package DBIx::Class::ResultClass::HashRefInflator::UTF8;

use strict;
use warnings;
use utf8;

# ABSTRACT: Get raw hashrefs from a resultset with utf-8 flag

our $VERSION = '1.000001'; # VERSION

use parent qw( DBIx::Class::ResultClass::HashRefInflator );

sub inflate_result {
    my ( $self, @args ) = @_;
    my $res =  $self->SUPER::inflate_result( @args );
    return $res  if ref($res) ne 'HASH';

    return {
        map {
            my $val = $res->{$_};
            utf8::decode($val)  if defined $val && !ref($val);
            ( $_ => $val );
        } keys %$res
    };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

DBIx::Class::ResultClass::HashRefInflator::UTF8 - Get raw hashrefs from a resultset with utf-8 flag

=head1 VERSION

version 1.000001

=head1 AUTHOR

Akzhan Abdulin <akzhan@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Akzhan Abdulin.

This is free software, licensed under:

  The MIT (X11) License

=cut
