#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/lib/BeforeBuild.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-PluginBundle-Author-VDB.
#
#   perl-Dist-Zilla-PluginBundle-Author-VDB is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-PluginBundle-Author-VDB is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-PluginBundle-Author-VDB. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package BeforeBuild;

use Moose;
use namespace::autoclean;

with 'Dist::Zilla::Role::BeforeBuild';
with 'Dist::Zilla::Role::Author::VDB::HgRunner';

#   Run code specified in $BeforeBuild::Hook variable before build.
sub before_build {
    my ( $self ) = @_;
    our $Hook;
    if ( defined( $Hook ) ) {
        $Hook->( $self );
    };
};

__PACKAGE__->meta->make_immutable();

1;

# end of file #
