#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'extreme/summit300-24.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit 300-24',
            DESCRIPTION  => 'Summit300-24 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:17:15',

            SNMPHOSTNAME => 'xtb12-2',
            LOCATION     => 'PMF-B12',
            CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
            SERIAL       => '0518G-00029',
            FIRMWARE     => '7.4.2.6',
            UPTIME       => '(447891453) 51 days, 20:08:34.53',
            MAC          => '00:04:96:1f:91:50',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '192.168.100.9',
                    '192.168.254.72',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit 300-24',
                COMMENTS     => 'Summit300-24 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:17:15',
                NAME         => 'xtb12-2',
                LOCATION     => 'PMF-B12',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                SERIAL       => '0518G-00029',
                FIRMWARE     => '7.4.2.6',
                UPTIME       => '(447891453) 51 days, 20:08:34.53',
                MAC          => '00:04:96:1f:91:50',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.9',
                        '192.168.254.72',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit300-24-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit300-24-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit300-24-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit300-24-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit300-24-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit300-24-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit300-24-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit300-24-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit300-24-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit300-24-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit300-24-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit300-24-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit300-24-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit300-24-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit300-24-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit300-24-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit300-24-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit300-24-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit300-24-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit300-24-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438821700) 50 days, 18:56:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '108729499',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304480573',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:04:96:0d:db:10',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit300-24-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446914100) 51 days, 17:25:41.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '365076084',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2673085982',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '0c:77:1a:21:98:47',
                                    '88:53:2e:d7:07:85',
                                    '10:0b:a9:a1:fd:c8',
                                    'c4:85:08:7d:77:c9',
                                    'c4:85:08:05:2b:e3',
                                    '24:77:03:d2:eb:18',
                                    '4c:80:93:68:01:41',
                                    '00:04:96:0d:c6:10',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit300-24-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432477100) 50 days, 1:19:31.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2230110099',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '2143937189',
                        IFOUTERRORS      => '125211',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:6c:c6:49:fa',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit300-24-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit300-24-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit300-24-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit300-24-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(900) 0:00:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1873901663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3791646090',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:a6:c0',
                                    '00:01:30:12:a6:d0',
                                    '00:01:30:12:a8:30',
                                    '00:0b:dc:00:b2:11',
                                    '00:10:db:ff:10:02',
                                    '00:02:b3:31:fa:f9',
                                    '00:e0:86:11:1a:27',
                                    '00:e0:86:11:1d:b0',
                                    '00:e0:86:12:d9:6f',
                                    '00:1b:ec:00:04:09',
                                    '00:1e:c9:da:3b:fc',
                                    '00:1e:c9:f2:ca:8d',
                                    '00:1e:4f:1f:3c:44',
                                    '00:1e:4f:1f:57:4b',
                                    '00:1e:4f:31:a9:a0',
                                    '00:1e:4f:31:ab:88',
                                    '00:1e:4f:31:ab:ab',
                                    '00:1e:4f:32:e1:d3',
                                    '00:1e:4f:32:e4:69',
                                    '00:1e:4f:33:07:e1',
                                    '00:1e:4f:41:d0:a4',
                                    '00:1e:4f:41:dc:7e',
                                    '00:1e:4f:41:dd:53',
                                    '00:1e:4f:08:e5:ca',
                                    '00:1e:4f:08:e6:62',
                                    '00:20:4a:0b:24:06',
                                    '00:20:4a:08:72:d2',
                                    '00:20:4a:08:ac:f6',
                                    '00:20:4a:08:ac:56',
                                    '00:20:4a:08:e1:6d',
                                    '00:20:4a:08:60:c6',
                                    '00:21:59:9a:dd:bf',
                                    '00:22:19:7b:be:11',
                                    '00:22:19:7b:be:da',
                                    '00:22:19:7b:bf:e6',
                                    '00:22:19:85:d9:70',
                                    '00:22:19:63:0f:55',
                                    '00:23:ae:fb:fd:89',
                                    '00:23:ae:fb:fd:b0',
                                    '00:23:ae:fc:00:cd',
                                    '00:23:ae:fc:00:d3',
                                    '00:23:ae:fc:00:d8',
                                    '00:23:24:4a:f7:49',
                                    '00:04:96:1c:71:00',
                                    '00:04:96:1f:8f:0f',
                                    '00:04:96:27:93:f9',
                                    '00:04:96:34:69:ab',
                                    '00:04:96:34:69:b1',
                                    '00:04:96:34:69:40',
                                    '00:04:96:34:8b:82',
                                    '00:04:96:34:8b:f8',
                                    '00:04:96:34:8c:10',
                                    '00:04:96:34:8c:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:af:ae',
                                    '00:04:96:35:77:14',
                                    '00:04:96:35:90:4d',
                                    '00:04:96:35:93:b9',
                                    '00:04:96:35:ad:e4',
                                    '00:04:96:35:c8:1f',
                                    '00:04:96:35:fa:ae',
                                    '00:04:96:35:fa:b1',
                                    '00:05:1e:08:f8:20',
                                    '00:05:1e:08:f9:12',
                                    '00:05:1e:09:21:2d',
                                    '00:05:1e:09:21:50',
                                    '00:05:33:43:78:2d',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:60:16:1e:64:79',
                                    '00:60:16:1e:68:23',
                                    '00:60:16:1e:56:f6',
                                    '00:60:16:1e:57:3d',
                                    '6c:ae:8b:6b:3e:78',
                                    '6c:ae:8b:6b:3e:e6',
                                    '6c:ae:8b:6b:40:58',
                                    '6c:ae:8b:6b:41:38',
                                    '78:fe:3d:df:c1:82',
                                    '78:fe:3d:df:cc:41',
                                    '84:18:88:a6:06:33',
                                    '84:18:88:ae:89:80',
                                    '84:2b:2b:71:30:f3',
                                    '10:8c:cf:cb:9e:92',
                                    'ac:4b:c8:22:b8:41',
                                    'ac:4b:c8:23:1d:81',
                                    'b0:a8:6e:86:08:41',
                                    'b0:a8:6e:9a:52:01',
                                    '02:04:96:35:f9:24',
                                    'd0:d0:fd:ab:1a:b6',
                                    'd0:d0:fd:ac:ae:b6',
                                    'd0:57:4c:74:16:01',
                                    'e4:1f:13:76:ca:35',
                                    '18:03:73:0a:29:c2',
                                    '18:03:73:09:ae:8c',
                                    'f0:4d:a2:6e:cf:89',
                                    'f0:4d:a2:6e:d3:e6',
                                    'f0:4d:a2:6e:d4:96',
                                    'f0:4d:a2:6e:d4:1c',
                                    'f0:4d:a2:6f:03:39',
                                    'f0:4d:a2:6f:03:5b',
                                    'f0:4d:a2:d9:bc:3f',
                                    '20:3a:07:ee:e1:60',
                                    '20:3a:07:ee:e1:62',
                                    '20:3a:07:ee:e2:40',
                                    '20:3a:07:ee:e4:76',
                                    '2c:6b:f5:9a:7e:80',
                                    '2c:6b:f5:9b:48:80',
                                    '2c:36:f8:4b:6e:8e',
                                    '54:e0:32:87:92:01',
                                    '54:e0:32:87:92:36',
                                    '5c:26:0a:a5:b9:93',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '70:56:81:aa:87:2b',
                                    '10:9a:dd:a7:7d:38',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => 'pmf-sans-fil',
                        IFDESCR          => 'VLAN 00003 (pmf-sans-fil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '802.1Q Encapsulation Tag 0250',
                        IFDESCR          => '802.1Q Encapsulation Tag 0250',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'wlan-mgmt',
                        IFDESCR          => 'VLAN 00004 (wlan-mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00005 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => 'rif0(192.168.100.9)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.9',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '961465250',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1209642666',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => 'rif1(192.168.254.72)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.254.72',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '88321595',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '151826622',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102001',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102002',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '6074133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102102',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '110875740',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10200101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10200201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '6074133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10210101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10210201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '110875740',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit300-48.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit 300-48',
            DESCRIPTION  => 'Summit300-48 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:44:51',

            SNMPHOSTNAME => 'xtc13',
            LOCATION     => 'PMF-C13',
            CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
            SERIAL       => '04375-00303',
            FIRMWARE     => '7.4.2.6',
            UPTIME       => '(447912326) 51 days, 20:12:03.26',
            MAC          => '00:04:96:1c:71:00',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '192.168.100.7',
                    '192.168.254.72',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit 300-48',
                COMMENTS     => 'Summit300-48 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:44:51',
                NAME         => 'xtc13',
                LOCATION     => 'PMF-C13',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                SERIAL       => '04375-00303',
                FIRMWARE     => '7.4.2.6',
                UPTIME       => '(447912326) 51 days, 20:12:03.26',
                MAC          => '00:04:96:1c:71:00',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.7',
                        '192.168.254.72',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit300-48-Port 1001',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit300-48-Port 1002',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit300-48-Port 1003',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit300-48-Port 1004',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit300-48-Port 1005',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit300-48-Port 1006',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit300-48-Port 1007',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit300-48-Port 1008',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit300-48-Port 1009',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit300-48-Port 1010',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit300-48-Port 1011',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit300-48-Port 1012',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit300-48-Port 1013',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308730300) 35 days, 17:35:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14633490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '82988466',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit300-48-Port 1014',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit300-48-Port 1015',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '340563827',
                        IFINERRORS       => '36',
                        IFOUTOCTETS      => '902415639',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit300-48-Port 1016',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3451688747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2978718322',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:92:7d:88',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit300-48-Port 1017',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '30201160',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit300-48-Port 1018',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit300-48-Port 1019',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit300-48-Port 1020',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9321530',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '163047911',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit300-48-Port 1021',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit300-48-Port 1022',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '366181779',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2017260163',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit300-48-Port 1023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '35813197',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit300-48-Port 1024',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit300-48-Port 1025',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1567036194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244268335',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit300-48-Port 1026',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1344904218',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4274000019',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:17:b0:2c',
                                    '1c:6f:65:0b:cc:d9',
                                    '44:37:e6:62:26:f7',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit300-48-Port 1027',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '107698894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1886542214',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit300-48-Port 1028',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit300-48-Port 1029',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit300-48-Port 1030',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit300-48-Port 1031',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '455443615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3361567846',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:89:79:7a',
                                    '00:1b:78:11:e8:b0',
                                    '00:20:6b:7a:63:3c',
                                    'c8:cb:b8:60:89:fb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit300-48-Port 1032',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit300-48-Port 1033',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387283800) 44 days, 19:47:18.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19697501',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3419051189',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit300-48-Port 1034',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386086800) 44 days, 16:27:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10642349',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1816803734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit300-48-Port 1035',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(419246300) 48 days, 12:34:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1096580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '210538077',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '2c:76:8a:3f:b6:bf',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit300-48-Port 1036',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '293670410',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490433860',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:7c:ef:75',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit300-48-Port 1037',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '879558887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2957696033',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '44:37:e6:bb:a3:cc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit300-48-Port 1038',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit300-48-Port 1039',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1700) 0:00:17.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4012106340',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4081915479',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:17:b0:93',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit300-48-Port 1040',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit300-48-Port 1041',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432490800) 50 days, 1:21:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1799874401',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '811762229',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:6c:c6:7d:1e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit300-48-Port 1042',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(385836200) 44 days, 15:46:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '220132478',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '930468204',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '10:9a:dd:a7:7d:38',
                                    '00:04:96:0d:c9:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit300-48-Port 1043',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(17900) 0:02:59.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '122893507',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '359332156',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:04:96:0c:f6:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit300-48-Port 1044',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432489600) 50 days, 1:21:36.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2463779142',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '3044537282',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1a:1e:cd:bb:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit300-48-Port 1045',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(18100) 0:03:01.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '120048887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366798786',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit300-48-Port 1046',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit300-48-Port 1047',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit300-48-Port 1048',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit300-48-Port 1049',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit300-48-Port 1050',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => '1/51',
                        IFDESCR          => 'Summit300-48-Port 1051',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1052',
                        IFNAME           => '1/52',
                        IFDESCR          => 'Summit300-48-Port 1052',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1700) 0:00:17.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1882067774',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '821330010',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:a8:30',
                                    '00:0b:dc:00:b2:11',
                                    '00:0b:60:b0:b0:1b',
                                    '00:0f:34:aa:ee:1b',
                                    '00:10:db:ff:10:02',
                                    '00:02:b3:31:fa:f9',
                                    '00:1b:ec:00:04:09',
                                    '00:1e:4f:1f:3c:44',
                                    '00:1e:4f:1f:57:4b',
                                    '00:1e:4f:31:a9:a0',
                                    '00:1e:4f:31:ab:88',
                                    '00:1e:4f:31:ab:ab',
                                    '00:1e:4f:32:e1:d3',
                                    '00:1e:4f:32:e4:69',
                                    '00:1e:4f:33:07:e1',
                                    '00:1e:4f:41:d0:a4',
                                    '00:1e:4f:41:dc:7e',
                                    '00:1e:4f:08:e5:ca',
                                    '00:1e:4f:08:e6:62',
                                    '00:20:4a:0b:24:06',
                                    '00:20:4a:08:72:d2',
                                    '00:20:4a:08:ac:56',
                                    '00:20:4a:08:e1:6d',
                                    '00:20:4a:08:60:c6',
                                    '00:22:19:7b:be:11',
                                    '00:22:19:7b:bf:e6',
                                    '00:22:19:85:d9:70',
                                    '00:23:ae:fb:fd:89',
                                    '00:23:ae:fb:fd:b0',
                                    '00:23:ae:fc:00:cd',
                                    '00:23:ae:fc:00:d8',
                                    '00:04:96:1c:6f:f0',
                                    '00:04:96:1f:8f:0f',
                                    '00:04:96:1f:91:50',
                                    '00:04:96:34:69:ab',
                                    '00:04:96:34:69:b1',
                                    '00:04:96:34:69:40',
                                    '00:04:96:34:89:5c',
                                    '00:04:96:34:8b:82',
                                    '00:04:96:34:8b:f8',
                                    '00:04:96:34:8c:10',
                                    '00:04:96:34:8c:11',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:af:ae',
                                    '00:04:96:35:93:b9',
                                    '00:04:96:35:ad:e4',
                                    '00:04:96:35:c8:14',
                                    '00:04:96:35:c8:1f',
                                    '00:04:96:35:fa:b1',
                                    '00:04:96:08:1e:70',
                                    '00:05:1e:09:21:50',
                                    '00:05:33:43:78:2d',
                                    '00:50:56:50:38:32',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:60:16:1e:64:79',
                                    '00:60:16:1e:68:23',
                                    '00:60:16:1e:56:f6',
                                    '00:60:16:1e:57:3d',
                                    '6c:ae:8b:6b:3e:e6',
                                    '6c:ae:8b:6b:40:58',
                                    '78:fe:3d:df:cc:41',
                                    '78:fe:3d:3f:7f:c0',
                                    '84:18:88:a6:06:33',
                                    '84:18:88:ae:89:80',
                                    'ac:4b:c8:23:1d:81',
                                    'b0:a8:6e:9a:52:01',
                                    '02:04:96:35:f9:24',
                                    'd0:d0:fd:ab:1a:b6',
                                    'd0:d0:fd:ac:ae:b6',
                                    'd0:57:4c:74:16:01',
                                    'e4:1f:13:76:ca:35',
                                    'e4:1f:13:76:d3:a1',
                                    '18:03:73:0a:29:c2',
                                    '18:03:73:09:ae:8c',
                                    'f0:4d:a2:6e:cf:89',
                                    'f0:4d:a2:6e:d3:e6',
                                    'f0:4d:a2:6e:d4:96',
                                    'f0:4d:a2:6e:d4:1c',
                                    'f0:4d:a2:6f:03:39',
                                    'f0:4d:a2:6f:03:5b',
                                    'f0:4d:a2:d9:bc:3f',
                                    '20:3a:07:ee:e2:40',
                                    '20:3a:07:ee:e4:76',
                                    '2c:36:f8:4b:6e:8e',
                                    '54:e0:32:87:92:01',
                                    '54:e0:32:87:92:36',
                                    '58:35:d9:94:d3:1a',
                                    '5c:26:0a:a5:b9:93',
                                    '00:10:db:ff:10:02',
                                    '00:1c:23:3d:c0:ad',
                                    '00:24:81:4c:5b:d0',
                                    '00:26:b9:05:c3:7a',
                                    'a4:ba:db:b5:40:ed',
                                    'b8:8d:12:53:6a:7f',
                                    'cc:52:af:41:25:f2',
                                    'd4:be:d9:47:52:e9',
                                    '44:37:e6:62:27:35',
                                    '58:55:ca:25:35:d5',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '00:0c:29:27:f8:57',
                                    '00:10:db:ff:10:02',
                                    '00:11:11:3a:83:e7',
                                    '00:16:76:ce:7c:0a',
                                    '00:17:f2:94:41:c4',
                                    '00:18:51:00:00:b3',
                                    '00:18:51:00:00:54',
                                    '00:18:51:00:01:51',
                                    '00:18:51:6a:b1:c9',
                                    '00:18:51:91:62:38',
                                    '00:18:51:94:15:c6',
                                    '00:18:51:99:f9:a1',
                                    '00:18:51:a0:3a:36',
                                    '00:18:51:a4:78:bc',
                                    '00:18:51:a4:e9:03',
                                    '00:18:51:a6:4b:5c',
                                    '00:18:51:a7:ea:1f',
                                    '00:18:51:11:12:86',
                                    '00:18:51:aa:62:ba',
                                    '00:18:51:ab:03:e0',
                                    '00:18:51:b7:73:e0',
                                    '00:18:51:c1:2e:a8',
                                    '00:18:51:ce:67:ca',
                                    '00:18:51:15:ff:3f',
                                    '00:18:51:de:bf:33',
                                    '00:18:51:17:e7:29',
                                    '00:18:51:ec:1e:3b',
                                    '00:18:51:ee:71:fe',
                                    '00:18:51:18:85:31',
                                    '00:18:51:fd:12:86',
                                    '00:18:51:1a:17:a6',
                                    '00:18:51:1d:af:93',
                                    '00:18:51:04:2d:18',
                                    '00:18:51:3a:3f:f2',
                                    '00:18:51:44:08:78',
                                    '00:18:51:46:7b:84',
                                    '00:18:51:47:8c:c5',
                                    '00:18:51:49:de:33',
                                    '00:18:51:4b:0a:36',
                                    '00:18:51:4e:e7:a3',
                                    '00:18:51:51:f1:8d',
                                    '00:18:51:5c:d2:3b',
                                    '00:1c:c0:22:f4:d4',
                                    '00:20:4a:d7:39:5a',
                                    '00:30:48:76:ab:88',
                                    '00:50:56:bc:00:01',
                                    '00:50:56:bc:00:09',
                                    '00:50:56:bc:19:00',
                                    '00:50:56:bc:31:94',
                                    '00:50:56:bc:56:18',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '10:8c:cf:cb:9b:ef',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '00:16:cb:aa:6d:75',
                                    '00:16:cb:ae:3d:f1',
                                    '00:e0:db:0c:ef:43',
                                    '00:18:51:c7:ad:5f',
                                    '00:1a:a0:ba:a1:2c',
                                    '00:1a:a0:ba:e2:a6',
                                    '00:1a:a0:36:ac:4d',
                                    '00:1c:c0:7f:3e:ca',
                                    '00:1c:c0:9b:58:fd',
                                    '00:1f:f3:fc:79:e8',
                                    '00:04:00:c3:15:26',
                                    '00:08:9b:80:83:38',
                                    '64:b9:e8:c0:af:d8',
                                    '70:cd:60:f1:fb:d0',
                                    '78:2b:cb:7e:62:9e',
                                    '84:2b:2b:ab:ef:b4',
                                    'cc:52:af:41:38:5e',
                                    'cc:52:af:4c:27:44',
                                    '1c:6f:65:0d:ec:26',
                                    '1c:6f:65:0e:4b:c8',
                                    '1c:6f:65:0e:51:02',
                                    '20:c9:d0:29:d8:47',
                                    '3c:97:0e:7b:e8:4a',
                                    '3c:97:0e:32:0f:fb',
                                    '3c:97:0e:48:cd:86',
                                    '3c:07:54:35:11:7a',
                                    '3c:07:54:35:22:51',
                                    '40:6c:8f:bb:dc:e2',
                                    '44:37:e6:6f:30:d8',
                                    '44:37:e6:87:65:d2',
                                    '44:37:e6:63:4c:f7',
                                    '5c:26:0a:2e:06:a9',
                                    '5c:26:0a:63:7c:f2',
                                    '00:0c:29:86:0c:c0',
                                    '00:0c:29:b9:6d:7d',
                                    '00:0c:29:ca:32:91',
                                    '00:0c:29:2b:12:ce',
                                    '00:0c:29:56:6b:7a',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:ae:27:a6',
                                    '00:1a:a0:65:6c:c0',
                                    '00:1c:c0:7f:3d:17',
                                    '00:1c:c0:7f:3d:03',
                                    '00:1c:c0:8f:2c:67',
                                    '00:1c:c0:8f:44:f4',
                                    '00:1c:c0:8f:46:74',
                                    '00:1c:c0:8f:46:75',
                                    '00:1c:c0:f8:1d:a7',
                                    '00:1e:4f:bf:c8:8b',
                                    '00:1e:4f:c0:59:04',
                                    '00:25:64:94:49:b1',
                                    '00:25:64:bd:f1:a0',
                                    '00:27:0e:01:25:84',
                                    '00:27:0e:02:56:0d',
                                    '00:27:0e:02:56:40',
                                    '00:50:56:bc:31:89',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '84:2b:2b:9d:79:cc',
                                    '10:78:d2:c3:df:fc',
                                    'cc:52:af:41:26:63',
                                    'cc:52:af:41:34:5f',
                                    '1c:6f:65:0b:cf:c8',
                                    '1c:6f:65:0d:f0:06',
                                    '1c:6f:65:0e:90:4d',
                                    '1c:6f:65:0f:e1:2e',
                                    '1c:6f:65:09:57:46',
                                    '44:37:e6:63:4c:e1',
                                    '44:37:e6:63:4c:e9',
                                    '44:37:e6:63:4c:eb',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:05:a6:73',
                                    '00:26:b9:ed:20:53',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '70:f3:95:1b:84:96',
                                    '70:f3:95:1b:85:37',
                                    '1c:6f:65:0e:8c:42',
                                    '00:80:77:ec:d6:f9',
                                    '00:9c:02:07:8d:ed',
                                    '00:10:db:ff:10:02',
                                    '00:03:2d:1c:e3:8b',
                                    '00:03:2d:1c:e3:de',
                                    '00:20:6b:7a:68:84',
                                    '00:20:6b:7a:88:7b',
                                    '00:20:6b:7a:d1:00',
                                    '00:20:6b:7a:d2:76',
                                    '00:20:6b:7a:d2:52',
                                    '00:20:6b:7a:1f:8c',
                                    '00:20:6b:7a:62:57',
                                    '00:20:6b:8f:a5:c4',
                                    '00:20:4a:66:3e:02',
                                    '00:23:7d:85:a4:41',
                                    '00:25:b3:fa:d3:49',
                                    '78:e3:b5:f7:f0:ca',
                                    'ac:16:2d:39:c4:3a',
                                    'd4:85:64:1f:4c:49',
                                    '1c:c1:de:82:2a:e3',
                                    '2c:76:8a:40:ff:fc',
                                    '3c:4a:92:b4:06:12',
                                    '00:10:db:ff:10:02',
                                    '84:a6:c8:ab:d3:c1',
                                    '88:53:2e:d7:07:85',
                                    'c4:85:08:7d:77:c9',
                                    'c4:85:08:05:2b:e3',
                                    '24:77:03:d2:eb:18',
                                    '4c:80:93:68:01:41',
                                    '4c:eb:42:95:f5:88',
                                    '58:91:cf:07:bd:9a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20002',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20003',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20004',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20006',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20007',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20008',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20009',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20010',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00005 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20011',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20012',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00006 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20013',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20014',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00007 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20015',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20016',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00008 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20017',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20018',
                        IFNAME           => 'pmf-miage',
                        IFDESCR          => 'VLAN 00009 (pmf-miage)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20019',
                        IFNAME           => '802.1Q Encapsulation Tag 0202',
                        IFDESCR          => '802.1Q Encapsulation Tag 0202',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20020',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00010 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20021',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20022',
                        IFNAME           => 'pmf-sans-fil',
                        IFDESCR          => 'VLAN 00011 (pmf-sans-fil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20023',
                        IFNAME           => '802.1Q Encapsulation Tag 0250',
                        IFDESCR          => '802.1Q Encapsulation Tag 0250',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20024',
                        IFNAME           => 'wlan-mgmt',
                        IFDESCR          => 'VLAN 00012 (wlan-mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20026',
                        IFNAME           => 'pmf-ls',
                        IFDESCR          => 'VLAN 00013 (pmf-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20027',
                        IFNAME           => '802.1Q Encapsulation Tag 0204',
                        IFDESCR          => '802.1Q Encapsulation Tag 0204',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20028',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00014 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20029',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20030',
                        IFNAME           => 'pmf-lan-re',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-re)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20031',
                        IFNAME           => '802.1Q Encapsulation Tag 1017',
                        IFDESCR          => '802.1Q Encapsulation Tag 1017',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20032',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20033',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20034',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20035',
                        IFNAME           => 'rif0(192.168.100.7)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.7',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1025541138',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '141678777',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20036',
                        IFNAME           => 'rif1(192.168.254.72)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.254.72',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '259451632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '424189761',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104201',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104202',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66083659',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104301',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104302',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '5820625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104501',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104502',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3985693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10420101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10420201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66083659',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10430101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10430201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '5820625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10450101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10450201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3985693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit400-48t.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit 400-48t',
            DESCRIPTION  => 'Summit400-48t - Version 7.2e.1 (Build 10) by Release_Master 03/26/04 18:29:56',

            SNMPHOSTNAME => 'xtc6',
            LOCATION     => 'PMF - C6',
            CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
            UPTIME       => '(364479986) 42 days, 4:26:39.86',
            MAC          => '00:04:96:18:5b:61',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '192.168.100.5',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit 400-48t',
                COMMENTS     => 'Summit400-48t - Version 7.2e.1 (Build 10) by Release_Master 03/26/04 18:29:56',
                NAME         => 'xtc6',
                LOCATION     => 'PMF - C6',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                UPTIME       => '(364479986) 42 days, 4:26:39.86',
                MAC          => '00:04:96:18:5b:61',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.5',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit400-48t-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit400-48t-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177076017',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3652478286',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:80:80',
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:a8:30',
                                    '00:0b:dc:00:b2:11',
                                    '00:0b:60:b0:b0:1b',
                                    '00:0f:34:aa:ee:1b',
                                    '00:10:db:ff:10:02',
                                    '00:02:b3:31:fa:f9',
                                    '00:e0:86:11:1a:27',
                                    '00:e0:86:11:1d:b0',
                                    '00:e0:86:12:d9:6f',
                                    '00:1b:ec:00:04:09',
                                    '00:1e:c9:f2:c0:81',
                                    '00:1e:4f:1f:3c:44',
                                    '00:1e:4f:1f:57:4b',
                                    '00:1e:4f:31:a9:a0',
                                    '00:1e:4f:31:ab:88',
                                    '00:1e:4f:31:ab:ab',
                                    '00:1e:4f:32:e1:d3',
                                    '00:1e:4f:32:e4:69',
                                    '00:1e:4f:33:14:d1',
                                    '00:1e:4f:33:07:e1',
                                    '00:1e:4f:41:d0:a4',
                                    '00:1e:4f:41:d8:69',
                                    '00:1e:4f:41:dc:7e',
                                    '00:1e:4f:41:e2:8c',
                                    '00:1e:4f:08:e5:ca',
                                    '00:1e:4f:08:e6:62',
                                    '00:20:4a:08:72:d2',
                                    '00:20:4a:08:ac:f6',
                                    '00:20:4a:08:ac:56',
                                    '00:20:4a:08:e1:6d',
                                    '00:20:4a:08:60:c6',
                                    '00:22:19:7b:be:11',
                                    '00:22:19:7b:bf:e6',
                                    '00:22:19:85:d5:3d',
                                    '00:22:19:85:d9:70',
                                    '00:22:19:63:0f:55',
                                    '00:23:ae:fb:fd:89',
                                    '00:23:ae:fb:fd:b0',
                                    '00:23:ae:fc:00:cd',
                                    '00:23:ae:fc:00:d3',
                                    '00:23:ae:fc:00:d8',
                                    '00:23:ae:fe:9c:e0',
                                    '00:23:ae:fe:a9:e0',
                                    '00:04:96:18:6e:93',
                                    '00:04:96:1c:6f:f0',
                                    '00:04:96:1f:8f:0f',
                                    '00:04:96:1f:91:50',
                                    '00:04:96:34:69:ab',
                                    '00:04:96:34:69:b1',
                                    '00:04:96:34:69:40',
                                    '00:04:96:34:89:5c',
                                    '00:04:96:34:8b:82',
                                    '00:04:96:34:8b:f8',
                                    '00:04:96:34:8c:10',
                                    '00:04:96:34:8c:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:af:ae',
                                    '00:04:96:35:90:4d',
                                    '00:04:96:35:93:b9',
                                    '00:04:96:35:ad:e4',
                                    '00:04:96:35:c8:14',
                                    '00:04:96:35:c8:1f',
                                    '00:04:96:35:fa:b1',
                                    '00:04:96:08:1e:70',
                                    '00:05:1e:09:21:50',
                                    '00:05:33:43:78:2d',
                                    '00:50:56:bc:31:8a',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:60:16:1e:64:79',
                                    '00:60:16:1e:68:23',
                                    '00:60:16:1e:56:f6',
                                    '00:60:16:1e:57:3d',
                                    '6c:ae:8b:6b:3e:e6',
                                    '6c:ae:8b:6b:40:58',
                                    '6c:ae:8b:6b:41:38',
                                    '78:fe:3d:df:c1:81',
                                    '78:fe:3d:df:cc:41',
                                    '84:18:88:a6:06:33',
                                    '84:18:88:ae:89:80',
                                    'ac:4b:c8:22:b8:41',
                                    'ac:4b:c8:23:1d:81',
                                    'ac:4b:c8:23:48:01',
                                    'b0:a8:6e:9a:52:01',
                                    '02:04:96:35:f9:24',
                                    'd0:d0:fd:ab:1a:b6',
                                    'd0:d0:fd:ac:ae:b6',
                                    'd0:57:4c:74:16:01',
                                    'e4:1f:13:76:ca:35',
                                    'e4:1f:13:76:cd:e9',
                                    '18:03:73:0a:29:c2',
                                    '18:03:73:09:ae:8c',
                                    'f0:4d:a2:6e:cf:89',
                                    'f0:4d:a2:6e:d3:e6',
                                    'f0:4d:a2:6e:d4:96',
                                    'f0:4d:a2:6e:d4:1c',
                                    'f0:4d:a2:6f:03:39',
                                    'f0:4d:a2:6f:03:5b',
                                    'f0:4d:a2:d9:bc:3f',
                                    '20:3a:07:ee:e1:62',
                                    '20:3a:07:ee:e2:40',
                                    '20:3a:07:ee:e4:76',
                                    '54:e0:32:87:92:01',
                                    '54:e0:32:87:92:36',
                                    '5c:26:0a:a5:b9:93',
                                    '00:0c:29:ca:32:af',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:04:c2:29',
                                    '00:1c:c0:5d:56:5f',
                                    '00:25:64:a0:3c:09',
                                    '00:50:56:bc:02:49',
                                    '00:50:56:bc:28:f0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '70:f3:95:1b:84:bc',
                                    '70:f3:95:1b:87:3d',
                                    '88:f0:77:59:d9:ae',
                                    'cc:52:af:4a:4b:98',
                                    'd0:d0:fd:ab:1a:80',
                                    'd0:d0:fd:ab:26:00',
                                    'd0:d0:fd:ad:4a:80',
                                    'd0:d0:fd:b2:ad:00',
                                    'd0:d0:fd:b2:ad:0d',
                                    'd0:d0:fd:45:e8:80',
                                    'e8:11:32:61:38:ef',
                                    '1c:6f:65:0b:cf:67',
                                    '40:6c:8f:51:ac:bd',
                                    '08:00:27:36:c0:49',
                                    '00:50:56:bc:00:5b',
                                    '00:50:56:bc:00:5d',
                                    '00:50:56:bc:00:5e',
                                    '00:50:56:bc:56:1d',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:51:4d:5a',
                                    '00:0c:29:7d:ce:d9',
                                    '00:0c:29:cf:f4:09',
                                    '00:0c:29:d4:b1:ab',
                                    '00:0c:29:f1:eb:69',
                                    '00:10:db:ff:10:02',
                                    '00:c0:dd:0d:61:80',
                                    '00:18:51:72:8e:eb',
                                    '00:18:51:7d:14:84',
                                    '00:18:51:91:7b:7c',
                                    '00:18:51:1c:b8:09',
                                    '00:1e:c9:f2:c0:81',
                                    '00:1e:4f:32:f7:9e',
                                    '00:1e:4f:41:e2:8c',
                                    '00:22:19:85:d5:3d',
                                    '00:22:19:63:0f:4d',
                                    '00:23:ae:fe:9c:e0',
                                    '00:23:ae:fe:9d:7c',
                                    '00:23:ae:fe:a9:c8',
                                    '00:23:ae:fe:a9:e0',
                                    '00:50:56:bc:00:27',
                                    '00:50:56:bc:00:2f',
                                    '00:50:56:bc:00:05',
                                    '00:50:56:bc:00:38',
                                    '00:50:56:bc:26:84',
                                    '00:50:56:bc:31:8b',
                                    '00:50:56:bc:57:2f',
                                    '00:50:56:bc:5d:6b',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:5a',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:79:a7:c6',
                                    '00:19:d1:79:a9:a8',
                                    '00:19:d1:7a:5d:68',
                                    '00:19:d1:7a:5d:52',
                                    '00:1b:78:1b:e4:49',
                                    '00:1c:c0:8e:71:05',
                                    '00:27:0e:02:64:94',
                                    '70:f3:95:13:d4:d3',
                                    '84:2b:2b:9d:8a:ef',
                                    '10:78:d2:c3:e1:6b',
                                    'cc:52:af:4c:27:6e',
                                    'cc:52:af:4c:27:a6',
                                    'cc:52:af:4c:27:d5',
                                    '1c:6f:65:0b:cf:8d',
                                    '1c:6f:65:0b:d0:02',
                                    '1c:6f:65:07:55:2d',
                                    '3c:97:0e:46:7d:53',
                                    '44:37:e6:bb:a3:cd',
                                    '44:37:e6:63:50:86',
                                    '08:00:27:ae:ac:20',
                                    '00:10:db:ff:10:02',
                                    '00:1c:c0:8e:71:21',
                                    '00:04:96:27:93:f9',
                                    '00:10:db:ff:10:02',
                                    '44:37:e6:87:64:d7',
                                    '44:37:e6:87:64:d8',
                                    '44:37:e6:91:c7:8b',
                                    '44:37:e6:91:c7:92',
                                    '44:37:e6:92:39:e3',
                                    '44:37:e6:92:3a:c8',
                                    '44:37:e6:92:3a:d3',
                                    '44:37:e6:92:3a:da',
                                    '44:37:e6:92:3a:1d',
                                    '44:37:e6:92:3a:06',
                                    '08:00:27:01:e8:7c',
                                    '08:00:27:8e:28:a5',
                                    '08:00:27:8f:99:1d',
                                    '08:00:27:9a:d2:1a',
                                    '08:00:27:e1:b2:19',
                                    '08:00:27:ea:d6:94',
                                    '08:00:27:ef:a1:10',
                                    '08:00:27:f8:6d:8f',
                                    '08:00:27:36:b3:04',
                                    '08:00:27:3a:50:18',
                                    '08:00:27:44:ab:de',
                                    '08:00:27:4b:50:21',
                                    '08:00:27:59:62:ca',
                                    '08:00:27:5b:27:66',
                                    '00:10:db:ff:10:02',
                                    '00:50:56:bc:03:4a',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '1c:6f:65:0d:ff:b9',
                                    '1c:6f:65:09:ed:24',
                                    '08:00:27:1e:c8:ee',
                                    '00:10:db:ff:10:02',
                                    '00:0c:29:27:f8:57',
                                    '00:10:db:ff:10:02',
                                    '00:11:11:3a:83:e7',
                                    '00:16:76:ce:7c:0a',
                                    '00:17:f2:94:41:c4',
                                    '00:18:51:00:00:b3',
                                    '00:18:51:00:00:54',
                                    '00:18:51:00:01:51',
                                    '00:18:51:00:41:ec',
                                    '00:18:51:66:aa:11',
                                    '00:18:51:6a:b1:c9',
                                    '00:18:51:91:62:38',
                                    '00:18:51:93:24:ec',
                                    '00:18:51:94:15:c6',
                                    '00:18:51:99:f9:a1',
                                    '00:18:51:a0:3a:36',
                                    '00:18:51:a4:78:bc',
                                    '00:18:51:a4:e9:03',
                                    '00:18:51:a6:4b:5c',
                                    '00:18:51:a7:ea:1f',
                                    '00:18:51:11:12:86',
                                    '00:18:51:ab:03:e0',
                                    '00:18:51:ac:bd:fd',
                                    '00:18:51:b7:73:e0',
                                    '00:18:51:bd:4d:a6',
                                    '00:18:51:c1:2e:a8',
                                    '00:18:51:ce:67:ca',
                                    '00:18:51:de:bf:33',
                                    '00:18:51:e1:5c:00',
                                    '00:18:51:17:e7:29',
                                    '00:18:51:ea:36:d4',
                                    '00:18:51:ec:1e:3b',
                                    '00:18:51:ee:71:fe',
                                    '00:18:51:18:85:31',
                                    '00:18:51:f6:da:b5',
                                    '00:18:51:fd:12:86',
                                    '00:18:51:1a:17:a6',
                                    '00:18:51:1d:af:93',
                                    '00:18:51:04:f4:d7',
                                    '00:18:51:04:2d:18',
                                    '00:18:51:2a:45:5e',
                                    '00:18:51:3a:3f:f2',
                                    '00:18:51:44:08:78',
                                    '00:18:51:46:7b:84',
                                    '00:18:51:47:8c:c5',
                                    '00:18:51:49:de:33',
                                    '00:18:51:4b:0a:36',
                                    '00:18:51:4b:1a:a2',
                                    '00:18:51:4e:e7:a3',
                                    '00:18:51:51:f1:8d',
                                    '00:18:51:5c:d2:3b',
                                    '00:1c:c0:22:f4:d4',
                                    '00:20:4a:d7:39:5a',
                                    '00:24:36:f4:02:3e',
                                    '00:30:48:76:ab:88',
                                    '00:30:48:82:e7:72',
                                    '00:50:56:bc:00:01',
                                    '00:50:56:bc:00:0d',
                                    '00:50:56:bc:00:09',
                                    '00:50:56:bc:19:00',
                                    '00:50:56:bc:31:94',
                                    '00:50:56:bc:35:da',
                                    '00:50:56:bc:56:18',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '00:1c:c0:fc:f8:fb',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '00:25:b3:f9:a4:5c',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '00:16:cb:aa:6d:75',
                                    '00:16:cb:ae:3d:f1',
                                    '00:e0:db:0c:ef:43',
                                    '00:18:51:c7:ad:5f',
                                    '00:1a:a0:ba:a1:2c',
                                    '00:1a:a0:ba:e2:a6',
                                    '00:1c:c0:7f:3e:ca',
                                    '00:1c:c0:9b:58:fd',
                                    '00:1e:4f:f4:31:2d',
                                    '00:1f:f3:fc:79:e8',
                                    '00:21:5a:8f:48:b0',
                                    '00:25:64:92:7d:88',
                                    '00:25:64:bd:f1:fb',
                                    '00:08:9b:80:83:38',
                                    '64:b9:e8:c0:af:d8',
                                    '70:cd:60:f1:fb:d0',
                                    '78:2b:cb:7e:62:9e',
                                    '84:2b:2b:bc:56:04',
                                    'c4:2c:03:21:ca:b2',
                                    'cc:52:af:4c:27:44',
                                    '1c:6f:65:0d:ec:26',
                                    '1c:6f:65:0d:fa:de',
                                    '1c:6f:65:0e:4b:c8',
                                    '1c:6f:65:0e:51:02',
                                    '20:c9:d0:29:d8:47',
                                    '3c:97:0e:7b:e8:4a',
                                    '3c:97:0e:32:0f:fb',
                                    '3c:97:0e:48:cd:86',
                                    '3c:07:54:35:11:7a',
                                    '3c:07:54:35:22:51',
                                    '40:6c:8f:bb:dc:e2',
                                    '44:37:e6:6f:30:d8',
                                    '44:37:e6:87:65:d7',
                                    '44:37:e6:63:4c:f7',
                                    '5c:26:0a:12:2e:62',
                                    '5c:26:0a:2e:06:a9',
                                    '5c:26:0a:63:7c:f2',
                                    '00:0c:f1:e2:7a:aa',
                                    '00:0c:f1:e2:7a:da',
                                    '00:0c:f1:e8:b9:80',
                                    '00:10:db:ff:10:02',
                                    '00:11:11:ee:b3:ee',
                                    '00:13:20:32:82:63',
                                    '00:13:20:4a:d7:3f',
                                    '00:1a:a0:d6:c8:a5',
                                    '00:0c:29:86:0c:c0',
                                    '00:0c:29:94:f8:bc',
                                    '00:0c:29:b9:6d:7d',
                                    '00:0c:29:ca:32:91',
                                    '00:0c:29:2b:12:ce',
                                    '00:0c:29:56:6b:7a',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:ae:27:a6',
                                    '00:19:d1:ae:31:6c',
                                    '00:19:d1:17:b0:2c',
                                    '00:1a:a0:65:6c:c0',
                                    '00:1c:c0:7f:3d:03',
                                    '00:1c:c0:8f:2b:f1',
                                    '00:1c:c0:8f:44:f4',
                                    '00:1c:c0:8f:46:74',
                                    '00:1c:c0:8f:46:75',
                                    '00:1e:4f:bf:c8:8b',
                                    '00:25:64:94:49:b1',
                                    '00:25:64:a0:39:0b',
                                    '00:25:64:bd:f1:a0',
                                    '00:27:0e:01:25:84',
                                    '00:27:0e:02:56:0d',
                                    '00:27:0e:02:56:40',
                                    '00:50:56:bc:00:48',
                                    '00:50:56:bc:31:89',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '84:2b:2b:9d:79:cc',
                                    '10:78:d2:c3:df:fc',
                                    'cc:52:af:41:34:5f',
                                    'f0:4d:a2:0e:2c:5f',
                                    '1c:6f:65:0b:cc:d9',
                                    '1c:6f:65:0b:cf:c8',
                                    '1c:6f:65:0e:90:4d',
                                    '1c:6f:65:09:57:46',
                                    '2c:36:f8:4b:6f:3f',
                                    '44:37:e6:62:26:f7',
                                    '44:37:e6:63:4c:e1',
                                    '44:37:e6:63:4c:e9',
                                    '44:37:e6:63:4c:eb',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:17:b0:93',
                                    '00:19:d1:05:a6:73',
                                    '00:27:0e:01:25:4a',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '1c:6f:65:0e:8c:42',
                                    '44:37:e6:bb:a3:cc',
                                    '00:0c:29:ca:32:9b',
                                    '00:10:db:ff:10:02',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:80:77:ec:d6:f9',
                                    '00:9c:02:07:8d:ed',
                                    '00:10:db:ff:10:02',
                                    '00:03:81:82:3e:45',
                                    '00:03:2d:1c:e3:8b',
                                    '00:03:2d:1c:e3:de',
                                    '00:20:6b:7a:68:84',
                                    '00:20:6b:7a:88:7b',
                                    '00:20:6b:7a:d1:00',
                                    '00:20:6b:7a:d2:76',
                                    '00:20:6b:7a:d2:52',
                                    '00:20:6b:7a:f0:5b',
                                    '00:20:6b:7a:1f:8c',
                                    '00:20:6b:7a:62:57',
                                    '00:20:6b:8f:a5:c4',
                                    '00:23:7d:7d:e0:d6',
                                    '00:23:7d:85:a4:41',
                                    '00:25:b3:fa:d3:49',
                                    '78:e3:b5:f7:f0:ca',
                                    'ac:16:2d:39:c4:3a',
                                    'c8:cb:b8:60:89:fb',
                                    'f4:ce:46:3c:72:b6',
                                    '1c:c1:de:82:2a:e3',
                                    '1c:c1:de:83:7e:ab',
                                    '2c:76:8a:3f:b6:bf',
                                    '2c:76:8a:40:ff:fc',
                                    '3c:4a:92:b4:06:12',
                                    '00:09:0f:97:44:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit400-48t-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1400) 0:00:14.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1757545224',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849416595',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '44:37:e6:91:c6:e5',
                                    '44:37:e6:91:c6:eb',
                                    '44:37:e6:91:c7:01',
                                    '44:37:e6:91:c7:17',
                                    '44:37:e6:91:c7:38',
                                    '44:37:e6:92:3a:cd',
                                    '44:37:e6:92:3a:d1',
                                    '44:37:e6:92:3a:f4',
                                    '44:37:e6:92:3a:fa',
                                    '44:37:e6:92:3b:00',
                                    '44:37:e6:92:3b:25',
                                    '44:37:e6:92:3b:31',
                                    '08:00:27:64:a9:9b',
                                    '08:00:27:73:84:26',
                                    '08:00:27:8c:9f:e2',
                                    '08:00:27:bc:bb:8c',
                                    '08:00:27:c8:fd:42',
                                    '08:00:27:e4:3b:66',
                                    '08:00:27:eb:04:00',
                                    '08:00:27:fb:d1:38',
                                    '08:00:27:3c:02:c1',
                                    '08:00:27:47:83:fd',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit400-48t-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(165095600) 19 days, 2:35:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2083495287',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4110289924',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '40:2c:f4:eb:f4:5d',
                                    '40:2c:f4:eb:fb:f8',
                                    '40:2c:f4:eb:fc:74',
                                    '40:2c:f4:eb:fc:12',
                                    '40:2c:f4:eb:fc:1f',
                                    '40:2c:f4:eb:fd:e0',
                                    '40:2c:f4:eb:fd:17',
                                    '40:2c:f4:eb:ff:6f',
                                    '40:2c:f4:ec:00:09',
                                    '40:2c:f4:ec:01:8c',
                                    '40:2c:f4:ec:01:d9',
                                    '08:00:27:78:c5:da',
                                    '08:00:27:87:b2:a2',
                                    '08:00:27:8f:49:c6',
                                    '08:00:27:b3:f9:95',
                                    '08:00:27:d1:ae:8f',
                                    '08:00:27:15:7e:5e',
                                    '08:00:27:e0:43:de',
                                    '08:00:27:f2:48:eb',
                                    '08:00:27:2c:56:14',
                                    '08:00:27:43:da:f7',
                                    '08:00:27:4e:6a:6d',
                                    '08:00:27:5c:04:1e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit400-48t-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit400-48t-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '402377290',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2266130369',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:6f:65:0d:eb:ab',
                                    '1c:6f:65:0d:eb:d0',
                                    '1c:6f:65:0d:eb:eb',
                                    '1c:6f:65:0d:f1:87',
                                    '1c:6f:65:0d:f7:43',
                                    '1c:6f:65:0d:fc:b9',
                                    '1c:6f:65:0d:fc:d3',
                                    '1c:6f:65:0d:fd:0d',
                                    '1c:6f:65:0e:4b:de',
                                    '1c:6f:65:0e:4f:e0',
                                    '08:00:27:00:a9:eb',
                                    '08:00:27:73:21:58',
                                    '08:00:27:af:7e:4e',
                                    '08:00:27:d2:23:c2',
                                    '08:00:27:e8:22:93',
                                    '08:00:27:18:66:2e',
                                    '08:00:27:05:c2:83',
                                    '08:00:27:34:36:55',
                                    '08:00:27:3d:00:ff',
                                    '08:00:27:42:97:f3',
                                    '08:00:27:5a:21:50',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit400-48t-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '194026273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '846580434',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a8:d0:e5:b7:2b:01',
                                    'a8:d0:e5:b7:2b:1a',
                                    '00:14:38:a4:ca:b0',
                                    '00:27:0e:02:ed:83',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit400-48t-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(20400) 0:03:24.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3425221527',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '773258660',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:18:88:a5:fa:41',
                                    '84:18:88:a5:fa:43',
                                    '2c:36:f8:4b:6e:8e',
                                    '70:f3:95:1b:87:3b',
                                    '1c:6f:65:0e:51:6b',
                                    '00:20:6b:7a:8a:e0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit400-48t-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4281783881',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4208070991',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:fc:f0:8a',
                                    '00:1c:c0:fc:f1:29',
                                    '00:1c:c0:fc:f8:a7',
                                    '00:1c:c0:fc:f8:cf',
                                    '00:1c:c0:fc:f9:9b',
                                    '00:1c:c0:fc:f9:ca',
                                    '00:1c:c0:fc:f9:f3',
                                    '00:1c:c0:fc:f9:fd',
                                    '00:1c:c0:fc:fa:0c',
                                    '00:1c:c0:fc:fa:12',
                                    '1c:6f:65:0e:4b:f4',
                                    '08:00:27:60:46:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit400-48t-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3438567034',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1202698565',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:fe:3d:3e:0c:41',
                                    'b0:a8:6e:85:f8:81',
                                    '00:1c:c0:7f:3d:83',
                                    '00:1c:c0:fc:f8:b8',
                                    '00:1c:c0:fc:fa:21',
                                    '00:1c:c0:fd:5b:0b',
                                    '40:2c:f4:eb:fc:7f',
                                    '40:2c:f4:ec:00:13',
                                    '40:2c:f4:ec:01:90',
                                    '40:2c:f4:ec:01:a7',
                                    '40:2c:f4:ec:01:c3',
                                    '40:2c:f4:ec:01:dc',
                                    '40:2c:f4:ec:01:3a',
                                    '08:00:27:6a:43:68',
                                    '08:00:27:77:79:64',
                                    '08:00:27:80:f0:2f',
                                    '08:00:27:db:75:c5',
                                    '08:00:27:e1:51:1c',
                                    '08:00:27:ed:12:66',
                                    '08:00:27:f0:aa:a1',
                                    '08:00:27:1a:85:b4',
                                    '08:00:27:03:68:f1',
                                    '08:00:27:3f:59:b6',
                                    '08:00:27:44:70:b4',
                                    '08:00:27:45:9d:fd',
                                    '08:00:27:46:99:29',
                                    '08:00:27:4e:b7:7c',
                                    '08:00:27:52:6b:8c',
                                    '08:00:27:59:e9:48',
                                    '08:00:27:60:40:78',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit400-48t-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit400-48t-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit400-48t-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit400-48t-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1596263611',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3251459626',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '44:37:e6:91:c6:03',
                                    '44:37:e6:91:c7:51',
                                    '44:37:e6:91:c7:5d',
                                    '44:37:e6:92:3a:d4',
                                    '44:37:e6:92:3a:e7',
                                    '44:37:e6:92:3a:56',
                                    '44:37:e6:92:3b:01',
                                    '08:00:27:65:ce:3e',
                                    '08:00:27:6f:99:dc',
                                    '08:00:27:73:8f:6f',
                                    '08:00:27:7a:c9:80',
                                    '08:00:27:86:6d:92',
                                    '08:00:27:a9:8c:b4',
                                    '08:00:27:bf:38:de',
                                    '08:00:27:d2:f6:52',
                                    '08:00:27:d8:a1:e4',
                                    '08:00:27:1f:07:26',
                                    '08:00:27:04:e3:73',
                                    '08:00:27:04:fa:09',
                                    '08:00:27:34:09:46',
                                    '08:00:27:4a:b8:5d',
                                    '08:00:27:4d:fa:21',
                                    '08:00:27:51:41:ce',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit400-48t-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '984958090',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3738069952',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:4a:0b:24:06',
                                    '28:c0:da:3e:36:6f',
                                    '28:c0:da:3e:36:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit400-48t-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(337605300) 39 days, 1:47:33.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2028971',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118153031',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit400-48t-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38451479',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '463318268',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:27:0e:01:25:fa',
                                    '70:f3:95:1b:85:4c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit400-48t-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361680000) 41 days, 20:40:00.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8151757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '149331863',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit400-48t-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit400-48t-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3375401911',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4264022983',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1a:a0:36:6d:b3',
                                    '00:1a:a0:36:ac:4d',
                                    '00:04:00:c3:15:26',
                                    '84:2b:2b:ab:ef:b4',
                                    'cc:52:af:41:38:5e',
                                    'f0:4d:a2:0e:2c:38',
                                    '44:37:e6:87:65:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit400-48t-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit400-48t-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit400-48t-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6200) 0:01:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '181144241',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1366823973',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:7f:3f:46',
                                    '10:8c:cf:cb:9b:ef',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit400-48t-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4036993988',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1391749109',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:fe:3d:36:f7:01',
                                    '10:8c:cf:cb:9b:5f',
                                    '10:8c:cf:cb:9e:92',
                                    '10:8c:cf:cb:bb:fc',
                                    '10:8c:cf:cb:bc:71',
                                    '2c:36:f8:4b:6e:e6',
                                    '58:35:d9:94:d3:1a',
                                    '58:35:d9:94:e2:8d',
                                    '70:f3:95:1b:87:45',
                                    'cc:52:af:4c:23:23',
                                    'ec:cd:6d:2b:95:86',
                                    '40:2c:f4:eb:d1:2d',
                                    '40:2c:f4:eb:d8:6c',
                                    '40:2c:f4:eb:d8:8a',
                                    '40:2c:f4:eb:d8:97',
                                    '44:37:e6:92:3a:ae',
                                    '44:37:e6:bb:a3:c9',
                                    '5c:f9:dd:41:55:61',
                                    '5c:f9:dd:41:55:a2',
                                    '5c:f9:dd:41:55:a4',
                                    '00:14:38:9c:5a:5c',
                                    '00:1a:1e:cd:bb:02',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit400-48t-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14110199',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '280764922',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit400-48t-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '251246470',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '192052830',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0c:f1:e2:75:45',
                                    '00:0c:f1:e2:7b:8d',
                                    '00:0c:f1:e8:b9:65',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit400-48t-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(364258200) 42 days, 3:49:42.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '370319219',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2628467813',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:ed:20:53',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit400-48t-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4092542623',
                        IFINERRORS       => '9',
                        IFOUTOCTETS      => '2426553853',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '70:f3:95:1b:84:96',
                                    '70:f3:95:1b:85:37',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit400-48t-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit400-48t-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361620200) 41 days, 20:30:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81868301',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1139156676',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:9d:8c:32',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit400-48t-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2981615086',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1290225290',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:f8:1d:a7',
                                    '00:1c:c0:1b:04:a3',
                                    '1c:6f:65:0f:e1:2e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit400-48t-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266569100) 30 days, 20:28:11.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '376042996',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1545759053',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:7f:3d:17',
                                    '00:27:0e:02:56:57',
                                    'ac:16:2d:37:1b:c0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit400-48t-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '646142851',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3441094674',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:8f:2c:67',
                                    '00:1e:4f:c0:59:04',
                                    'cc:52:af:41:26:63',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit400-48t-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(206567100) 23 days, 21:47:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5251689',
                        IFINERRORS       => '30',
                        IFOUTOCTETS      => '1475347312',
                        IFOUTERRORS      => '1',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit400-48t-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267443600) 30 days, 22:53:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8237991',
                        IFINERRORS       => '27',
                        IFOUTOCTETS      => '1482614003',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:78:f4:bd:8c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit400-48t-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266725600) 30 days, 20:54:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9165307',
                        IFINERRORS       => '29',
                        IFOUTOCTETS      => '1543895387',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit400-48t-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit400-48t-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1296461',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1420896038',
                        IFOUTERRORS      => '4454605',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:4a:66:3e:02',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit400-48t-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266614100) 30 days, 20:35:41.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34427684',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '694437068',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:7a:d2:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit400-48t-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit400-48t-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit400-48t-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '195782904',
                        IFINERRORS       => '22',
                        IFOUTOCTETS      => '2059780991',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:7c:c3:24',
                                    '00:20:6b:7c:df:6b',
                                    '00:20:6b:7d:08:de',
                                    'd4:85:64:1f:4c:49',
                                    '1c:c1:de:82:3a:75',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit400-48t-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit400-48t-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit400-48t-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(364114700) 42 days, 3:25:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '20222139',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '114709844',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit400-48t-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit400-48t-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361729400) 41 days, 20:48:14.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '77001898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '201455837',
                        IFOUTERRORS      => '17318',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1d:09:27:1e:8c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit400-48t-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361808700) 41 days, 21:01:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '174016118',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '362316793',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1d:09:2b:67:5e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit400-48t-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit400-48t-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '51',
                        IFNAME           => 'Management Port',
                        IFDESCR          => 'Management Port',
                        IFALIAS          => 'MgmtPort',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '53',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'Mgmt',
                        IFDESCR          => 'VLAN 00003 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '56',
                        IFNAME           => '802.1Q Encapsulation Tag 4093',
                        IFDESCR          => '802.1Q Encapsulation Tag 4093',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00004 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '59',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00005 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00006 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '62',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00007 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFNAME           => 'pmf-bup1pub',
                        IFDESCR          => 'VLAN 00008 (pmf-bup1pub)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => '802.1Q Encapsulation Tag 0221',
                        IFDESCR          => '802.1Q Encapsulation Tag 0221',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00009 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00010 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00011 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => 'pmf-testgp',
                        IFDESCR          => 'VLAN 00012 (pmf-testgp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFNAME           => '802.1Q Encapsulation Tag 0209',
                        IFDESCR          => '802.1Q Encapsulation Tag 0209',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00013 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFNAME           => 'pmf-ls',
                        IFDESCR          => 'VLAN 00014 (pmf-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFNAME           => '802.1Q Encapsulation Tag 0204',
                        IFDESCR          => '802.1Q Encapsulation Tag 0204',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => 'pmf-crous-adm',
                        IFDESCR          => 'VLAN 00015 (pmf-crous-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFNAME           => '802.1Q Encapsulation Tag 0299',
                        IFDESCR          => '802.1Q Encapsulation Tag 0299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFNAME           => 'pmf-lan-crir',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-crir)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => '802.1Q Encapsulation Tag 1010',
                        IFDESCR          => '802.1Q Encapsulation Tag 1010',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFNAME           => 'pmf-crous-monetique',
                        IFDESCR          => 'VLAN 00017 (pmf-crous-monetique)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '84',
                        IFNAME           => '802.1Q Encapsulation Tag 0298',
                        IFDESCR          => '802.1Q Encapsulation Tag 0298',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFNAME           => 'pmf-lan-ls',
                        IFDESCR          => 'VLAN 00018 (pmf-lan-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFNAME           => '802.1Q Encapsulation Tag 1020',
                        IFDESCR          => '802.1Q Encapsulation Tag 1020',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00019 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00020 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFNAME           => 'pmf-invites',
                        IFDESCR          => 'VLAN 00021 (pmf-invites)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFNAME           => '802.1Q Encapsulation Tag 0232',
                        IFDESCR          => '802.1Q Encapsulation Tag 0232',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFNAME           => 'pmf-sap-install',
                        IFDESCR          => 'VLAN 00022 (pmf-sap-install)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFNAME           => '802.1Q Encapsulation Tag 1040',
                        IFDESCR          => '802.1Q Encapsulation Tag 1040',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFNAME           => 'pmf-mz-priv',
                        IFDESCR          => 'VLAN 00023 (pmf-mz-priv)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '96',
                        IFNAME           => '802.1Q Encapsulation Tag 1013',
                        IFDESCR          => '802.1Q Encapsulation Tag 1013',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFNAME           => 'mse-lan-td',
                        IFDESCR          => 'VLAN 00024 (mse-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFNAME           => '802.1Q Encapsulation Tag 1117',
                        IFDESCR          => '802.1Q Encapsulation Tag 1117',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFNAME           => 'pmf-lan-adm',
                        IFDESCR          => 'VLAN 00025 (pmf-lan-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFNAME           => '802.1Q Encapsulation Tag 1016',
                        IFDESCR          => '802.1Q Encapsulation Tag 1016',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFNAME           => 'pmf-lan-sap',
                        IFDESCR          => 'VLAN 00026 (pmf-lan-sap)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFNAME           => '802.1Q Encapsulation Tag 1011',
                        IFDESCR          => '802.1Q Encapsulation Tag 1011',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFNAME           => 'pmf-crous-bornes',
                        IFDESCR          => 'VLAN 00027 (pmf-crous-bornes)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFNAME           => '802.1Q Encapsulation Tag 0297',
                        IFDESCR          => '802.1Q Encapsulation Tag 0297',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00028 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFNAME           => 'rif0(192.168.100.5)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.5',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1054022658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '67451927',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit450.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit x450e-48p',
            DESCRIPTION  => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',

            SNMPHOSTNAME => 'sw-bat02',
            CONTACT      => 'noc-roc@inria.fr, +33 139 637 959',
            MAC          => '00:04:96:34:60:9e',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit x450e-48p',
                COMMENTS     => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',
                NAME         => 'sw-bat02',
                CONTACT      => 'noc-roc@inria.fr, +33 139 637 959',
                MAC          => '00:04:96:34:60:9e',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => 'X450e-48p Port 1',
                        IFDESCR          => 'X450e-48p Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(10800) 0:01:48.00',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => 'X450e-48p Port 2',
                        IFDESCR          => 'X450e-48p Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => 'X450e-48p Port 3',
                        IFDESCR          => 'X450e-48p Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => 'X450e-48p Port 4',
                        IFDESCR          => 'X450e-48p Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(10600) 0:01:46.00',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => 'X450e-48p Port 5',
                        IFDESCR          => 'X450e-48p Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1958246000) 226 days, 15:34:20.00',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => 'X450e-48p Port 6',
                        IFDESCR          => 'X450e-48p Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => 'X450e-48p Port 7',
                        IFDESCR          => 'X450e-48p Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961084300) 226 days, 23:27:23.00',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => 'X450e-48p Port 8',
                        IFDESCR          => 'X450e-48p Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => 'X450e-48p Port 9',
                        IFDESCR          => 'X450e-48p Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961570100) 227 days, 0:48:21.00',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => 'X450e-48p Port 10',
                        IFDESCR          => 'X450e-48p Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => 'X450e-48p Port 11',
                        IFDESCR          => 'X450e-48p Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962199100) 227 days, 2:33:11.00',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => 'X450e-48p Port 12',
                        IFDESCR          => 'X450e-48p Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => 'X450e-48p Port 13',
                        IFDESCR          => 'X450e-48p Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1870264000) 216 days, 11:10:40.00',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => 'X450e-48p Port 14',
                        IFDESCR          => 'X450e-48p Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961002500) 226 days, 23:13:45.00',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => 'X450e-48p Port 15',
                        IFDESCR          => 'X450e-48p Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962148000) 227 days, 2:24:40.00',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => 'X450e-48p Port 16',
                        IFDESCR          => 'X450e-48p Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1860839400) 215 days, 8:59:54.00',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => 'X450e-48p Port 17',
                        IFDESCR          => 'X450e-48p Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => 'X450e-48p Port 18',
                        IFDESCR          => 'X450e-48p Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1937979600) 224 days, 7:16:36.00',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => 'X450e-48p Port 19',
                        IFDESCR          => 'X450e-48p Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1938610300) 224 days, 9:01:43.00',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => 'X450e-48p Port 20',
                        IFDESCR          => 'X450e-48p Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962433800) 227 days, 3:12:18.00',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => 'X450e-48p Port 21',
                        IFDESCR          => 'X450e-48p Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => 'X450e-48p Port 22',
                        IFDESCR          => 'X450e-48p Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => 'X450e-48p Port 23',
                        IFDESCR          => 'X450e-48p Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => 'X450e-48p Port 24',
                        IFDESCR          => 'X450e-48p Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => 'X450e-48p Port 25',
                        IFDESCR          => 'X450e-48p Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => 'X450e-48p Port 26',
                        IFDESCR          => 'X450e-48p Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => 'X450e-48p Port 27',
                        IFDESCR          => 'X450e-48p Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => 'X450e-48p Port 28',
                        IFDESCR          => 'X450e-48p Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => 'X450e-48p Port 29',
                        IFDESCR          => 'X450e-48p Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => 'X450e-48p Port 30',
                        IFDESCR          => 'X450e-48p Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => 'X450e-48p Port 31',
                        IFDESCR          => 'X450e-48p Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => 'X450e-48p Port 32',
                        IFDESCR          => 'X450e-48p Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => 'X450e-48p Port 33',
                        IFDESCR          => 'X450e-48p Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => 'X450e-48p Port 34',
                        IFDESCR          => 'X450e-48p Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => 'X450e-48p Port 35',
                        IFDESCR          => 'X450e-48p Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => 'X450e-48p Port 36',
                        IFDESCR          => 'X450e-48p Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => 'X450e-48p Port 37',
                        IFDESCR          => 'X450e-48p Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => 'X450e-48p Port 38',
                        IFDESCR          => 'X450e-48p Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => 'X450e-48p Port 39',
                        IFDESCR          => 'X450e-48p Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => 'X450e-48p Port 40',
                        IFDESCR          => 'X450e-48p Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => 'X450e-48p Port 41',
                        IFDESCR          => 'X450e-48p Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => 'X450e-48p Port 42',
                        IFDESCR          => 'X450e-48p Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => 'X450e-48p Port 43',
                        IFDESCR          => 'X450e-48p Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => 'X450e-48p Port 44',
                        IFDESCR          => 'X450e-48p Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => 'X450e-48p Port 45',
                        IFDESCR          => 'X450e-48p Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => 'X450e-48p Port 46',
                        IFDESCR          => 'X450e-48p Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => 'X450e-48p Port 47',
                        IFDESCR          => 'X450e-48p Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => 'X450e-48p Port 48',
                        IFDESCR          => 'X450e-48p Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => 'X450e-48p Port 49',
                        IFDESCR          => 'X450e-48p Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => 'X450e-48p Port 50',
                        IFDESCR          => 'X450e-48p Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => 'Management Port',
                        IFDESCR          => 'Management Port',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1000001',
                        IFNAME           => 'VirtualRouter0',
                        IFDESCR          => 'VirtualRouter0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000002',
                        IFNAME           => 'VirtualRouter2',
                        IFDESCR          => 'VirtualRouter2',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000003',
                        IFNAME           => 'VirtualRouter1',
                        IFDESCR          => 'VirtualRouter1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000004',
                        IFNAME           => 'VLAN 00001 (Default)',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000005',
                        IFNAME           => 'VLAN 04095 (Mgmt)',
                        IFDESCR          => 'VLAN 04095 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000006',
                        IFNAME           => 'VLAN 00002 (Admin)',
                        IFDESCR          => 'VLAN 00002 (Admin)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000007',
                        IFNAME           => 'VLAN 04002 (Ctrl-Ring-02)',
                        IFDESCR          => 'VLAN 04002 (Ctrl-Ring-02)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000008',
                        IFNAME           => 'VLAN 00003 (LAN-ROC)',
                        IFDESCR          => 'VLAN 00003 (LAN-ROC)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000009',
                        IFNAME           => 'VLAN 02432 (ToIP-Avaya)',
                        IFDESCR          => 'VLAN 02432 (ToIP-Avaya)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000010',
                        IFNAME           => 'VLAN 02144 (Guest-Rocq)',
                        IFDESCR          => 'VLAN 02144 (Guest-Rocq)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000011',
                        IFNAME           => 'VLAN 02176 (VoIP-Rocq)',
                        IFDESCR          => 'VLAN 02176 (VoIP-Rocq)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000013',
                        IFNAME           => 'rtif(192.168.3.2/21)',
                        IFDESCR          => 'rtif(192.168.3.2/21)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1000014',
                        IFNAME           => 'VLAN 02992 (Wifi-Adm)',
                        IFDESCR          => 'VLAN 02992 (Wifi-Adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000015',
                        IFNAME           => 'VLAN 03008 (Wifi-Auth)',
                        IFDESCR          => 'VLAN 03008 (Wifi-Auth)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                ]
            },
        },
    ],
    'extreme/summit48si.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit 48si',
            DESCRIPTION  => 'Summit48si - Version 7.0.0 (Build 61) by Release_Master 12/02/04 14:27:36',

            SNMPHOSTNAME => 'xt17t',
            LOCATION     => '17-Tolbiac',
            CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
            UPTIME       => '(2602571760) 301 days, 5:21:57.60',
            MAC          => '00:01:30:12:a6:d0',
            IPS          => {
                IP => [
                    '10.16.2.72',
                    '127.0.0.1',
                    '192.168.100.11',
                    '194.214.30.129',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.0.0 (Build 61) by Release_Master 12/02/04 14:27:36',
                NAME         => 'xt17t',
                LOCATION     => '17-Tolbiac',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                UPTIME       => '(2602571760) 301 days, 5:21:57.60',
                MAC          => '00:01:30:12:a6:d0',
                IPS          => {
                    IP => [
                        '10.16.2.72',
                        '127.0.0.1',
                        '192.168.100.11',
                        '194.214.30.129',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107135184',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107146320',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107121872',
                        IFLASTCHANGE     => '(2023887300) 234 days, 5:54:33.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '555322719',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '795501453',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107118416',
                        IFLASTCHANGE     => '(1030169000) 119 days, 5:34:50.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4437044',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '75757917',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107101648',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089744',
                        IFLASTCHANGE     => '(2567158700) 297 days, 2:59:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '16619775',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '689914185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089616',
                        IFLASTCHANGE     => '(1637570900) 189 days, 12:48:29.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '70476207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '933230080',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107108048',
                        IFLASTCHANGE     => '(1711783500) 198 days, 2:57:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '280043059',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2123917712',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107137488',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107104208',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107148368',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107093072',
                        IFLASTCHANGE     => '(2593175700) 300 days, 3:15:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1021873168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2903530650',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107091024',
                        IFLASTCHANGE     => '(2602152900) 301 days, 4:12:09.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3984701198',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '708469827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107119184',
                        IFLASTCHANGE     => '(2504471800) 289 days, 20:51:58.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54419893',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '459626351',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107097936',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107117776',
                        IFLASTCHANGE     => '(2576924400) 298 days, 6:07:24.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28600172',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '1163884310',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107092560',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107143248',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107128400',
                        IFLASTCHANGE     => '(847306700) 98 days, 1:37:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '52423',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4645',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107092304',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107127248',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107134544',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107109584',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107093200',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107088208',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107133264',
                        IFLASTCHANGE     => '(1393500600) 161 days, 6:50:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3660274100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2021539045',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107113040',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107136720',
                        IFLASTCHANGE     => '(1374511100) 159 days, 2:05:11.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '483758880',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4033595797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107095504',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107103184',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107130448',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107107792',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107127504',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107098064',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107122512',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107113808',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107114064',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089488',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107112912',
                        IFLASTCHANGE     => '(2602563200) 301 days, 5:20:32.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1938995348',
                        IFINERRORS       => '127898',
                        IFOUTOCTETS      => '2848850473',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107088592',
                        IFLASTCHANGE     => '(2291987900) 265 days, 6:37:59.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '158483339',
                        IFINERRORS       => '1510',
                        IFOUTOCTETS      => '807090182',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107128784',
                        IFLASTCHANGE     => '(2587170300) 299 days, 10:35:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1964612408',
                        IFINERRORS       => '203057',
                        IFOUTOCTETS      => '3552969330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107106000',
                        IFLASTCHANGE     => '(2587167200) 299 days, 10:34:32.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '890047339',
                        IFINERRORS       => '203121',
                        IFOUTOCTETS      => '299457870',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107106640',
                        IFLASTCHANGE     => '(2587172300) 299 days, 10:35:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1134037961',
                        IFINERRORS       => '203047',
                        IFOUTOCTETS      => '3687889861',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107099088',
                        IFLASTCHANGE     => '(2587168300) 299 days, 10:34:43.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1644450430',
                        IFINERRORS       => '203127',
                        IFOUTOCTETS      => '561681042',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107128144',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107091536',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107105744',
                        IFLASTCHANGE     => '(2505373100) 289 days, 23:22:11.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2856331',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2824421182',
                        IFOUTERRORS      => '80',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107143760',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3778367721',
                        IFINERRORS       => '74628326',
                        IFOUTOCTETS      => '1616287003',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107098960',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 51',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107141328',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107118928',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107094992',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'tolbiac-17',
                        IFDESCR          => 'VLAN 00003 (tolbiac-17)',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107103056',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 't17-borne-sf',
                        IFDESCR          => 'VLAN 00004 (t17-borne-sf)',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107151952',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 1602',
                        IFDESCR          => '802.1Q Encapsulation Tag 1602',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107150416',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107121744',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '33172',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107145936',
                        IFLASTCHANGE     => '(1730752000) 200 days, 7:38:40.00',
                        IFINOCTETS       => '2280',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2280',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '213',
                        IFNAME           => 'rif0(192.168.100.11)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.11',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107146832',
                        IFLASTCHANGE     => '(2602574100) 301 days, 5:22:21.00',
                        IFINOCTETS       => '2444465160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '581136371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '214',
                        IFNAME           => 'rif1(194.214.30.129)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '194.214.30.129',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107093840',
                        IFLASTCHANGE     => '(2602568600) 301 days, 5:21:26.00',
                        IFINOCTETS       => '445450310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '102905561',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '215',
                        IFNAME           => 'rif2(10.16.2.72)',
                        IFDESCR          => 'rif2',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '10.16.2.72',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107129168',
                        IFLASTCHANGE     => '(2602574000) 301 days, 5:22:20.00',
                        IFINOCTETS       => '703779036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '251147751',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit48si.02.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit 48si',
            DESCRIPTION  => 'Summit48si - Version 7.3.2 (Build 3) by Release_Master 02/21/05 16:35:08',

            SNMPHOSTNAME => 'xta6',
            LOCATION     => 'PMF-A6',
            CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
            SERIAL       => '0312R-01206',
            FIRMWARE     => '7.3.2.3',
            UPTIME       => '(447894395) 51 days, 20:09:03.95',
            MAC          => '00:01:30:12:a6:c0',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '192.168.100.3',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.3.2 (Build 3) by Release_Master 02/21/05 16:35:08',
                NAME         => 'xta6',
                LOCATION     => 'PMF-A6',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                SERIAL       => '0312R-01206',
                FIRMWARE     => '7.3.2.3',
                UPTIME       => '(447894395) 51 days, 20:09:03.95',
                MAC          => '00:01:30:12:a6:c0',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.3',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5577500) 15:29:35.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1619650',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2789577159',
                        IFOUTERRORS      => '23',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:90:c2:de:c5:f6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(350179000) 40 days, 12:43:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3028756',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729930085',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:e6:41:8c:f9',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2532935211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3912579530',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:13:20:e4:0a:53',
                                    '00:1a:a0:65:6c:c0',
                                    '00:25:64:bd:f1:a0',
                                    'f0:4d:a2:0e:2c:5f',
                                    '1c:6f:65:0b:cf:c8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387813900) 44 days, 21:15:39.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8391335',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '618557153',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446784500) 51 days, 17:04:05.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '129458',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '525200',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(377218000) 43 days, 15:49:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '137218196',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2313678216',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:7a:88:7b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324724500) 37 days, 14:00:45.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '580596016',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1079484795',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:00:ec:fc:35',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324790300) 37 days, 14:11:43.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1714894688',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '252210557',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c4:2c:03:21:ca:b2',
                                    '3c:97:0e:48:cd:86',
                                    '3c:07:54:35:22:51',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446890600) 51 days, 17:21:46.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '148196113',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3050431762',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:07:54:35:11:7a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361540800) 41 days, 20:16:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3692887776',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3079207077',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1948024927',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3518623546',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:6f:65:0d:ec:26',
                                    '1c:6f:65:0d:f2:9f',
                                    '1c:6f:65:0e:51:02',
                                    '44:37:e6:6f:30:d8',
                                    '44:37:e6:63:4c:f7',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4164965589',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '926530949',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1a:a0:ba:a1:2c',
                                    '00:1e:4f:f4:31:2d',
                                    '1c:6f:65:0e:50:e5',
                                    '3c:97:0e:32:0f:fb',
                                    '44:37:e6:79:b2:84',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(351027400) 40 days, 15:04:34.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '461945',
                        IFINERRORS       => '5',
                        IFOUTOCTETS      => '838425',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(431146100) 49 days, 21:37:41.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2294005345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2315857880',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2089190',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '36973571',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(298110400) 34 days, 12:05:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '98806572',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1608258231',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:7a:d1:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '25288269',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3419189697',
                        IFOUTERRORS      => '513',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:14:38:92:96:b7',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447703300) 51 days, 19:37:13.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '94166742',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1028880306',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26791553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '648042090',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:18:fe:a6:89:21',
                                    '00:25:b3:f9:a4:5c',
                                    'e8:39:35:8f:e1:0f',
                                    '2c:41:38:82:d7:28',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324750100) 37 days, 14:05:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '12958006',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '747534797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(600) 0:00:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '94904184',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3531347771',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(600) 0:00:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '817778670',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '484811170',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:6f:65:0e:91:b5',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324750100) 37 days, 14:05:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9870825',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '723271546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447864800) 51 days, 20:04:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352911303',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1902397373',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1f:f3:fc:79:e8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2939363508',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1539479146',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:80:80',
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:a6:d0',
                                    '00:01:30:12:a8:30',
                                    '00:0b:dc:00:b2:11',
                                    '00:0b:60:b0:b0:1b',
                                    '00:0f:34:aa:ee:1b',
                                    '00:10:db:ff:10:02',
                                    '00:02:b3:31:fa:f9',
                                    '00:e0:86:11:1a:27',
                                    '00:e0:86:11:1d:b0',
                                    '00:e0:86:12:d9:6f',
                                    '00:1b:ec:00:04:09',
                                    '00:1e:c9:da:3b:fc',
                                    '00:1e:c9:f2:ca:8d',
                                    '00:1e:4f:1f:3c:44',
                                    '00:1e:4f:1f:57:4b',
                                    '00:1e:4f:31:a9:a0',
                                    '00:1e:4f:31:ab:88',
                                    '00:1e:4f:31:ab:ab',
                                    '00:1e:4f:32:e1:d3',
                                    '00:1e:4f:32:e4:69',
                                    '00:1e:4f:33:07:e1',
                                    '00:1e:4f:41:d0:a4',
                                    '00:1e:4f:41:dc:7e',
                                    '00:1e:4f:41:dd:53',
                                    '00:1e:4f:08:e5:ca',
                                    '00:1e:4f:08:e6:62',
                                    '00:20:4a:0b:24:06',
                                    '00:20:4a:08:72:d2',
                                    '00:20:4a:08:ac:f6',
                                    '00:20:4a:08:ac:56',
                                    '00:20:4a:08:e1:6d',
                                    '00:20:4a:08:60:c6',
                                    '00:22:19:7b:be:11',
                                    '00:22:19:7b:be:da',
                                    '00:22:19:7b:bf:e6',
                                    '00:22:19:85:d9:70',
                                    '00:22:19:63:0f:55',
                                    '00:23:ae:fb:fd:89',
                                    '00:23:ae:fb:fd:b0',
                                    '00:23:ae:fc:00:cd',
                                    '00:23:ae:fc:00:d3',
                                    '00:23:ae:fc:00:d8',
                                    '00:23:24:4a:f7:49',
                                    '00:04:96:18:6e:93',
                                    '00:04:96:18:5b:61',
                                    '00:04:96:1c:6f:f0',
                                    '00:04:96:1c:71:00',
                                    '00:04:96:1f:8f:0f',
                                    '00:04:96:1f:91:50',
                                    '00:04:96:27:93:f9',
                                    '00:04:96:04:58:20',
                                    '00:04:96:34:69:ab',
                                    '00:04:96:34:69:b1',
                                    '00:04:96:34:69:40',
                                    '00:04:96:34:89:5c',
                                    '00:04:96:34:8b:82',
                                    '00:04:96:34:8b:f8',
                                    '00:04:96:34:8c:10',
                                    '00:04:96:34:8c:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:af:ae',
                                    '00:04:96:35:77:14',
                                    '00:04:96:35:90:4d',
                                    '00:04:96:35:93:b9',
                                    '00:04:96:35:ad:e4',
                                    '00:04:96:35:c8:14',
                                    '00:04:96:35:c8:1f',
                                    '00:04:96:35:fa:ae',
                                    '00:04:96:35:fa:b1',
                                    '00:04:96:08:1e:70',
                                    '00:04:96:09:07:00',
                                    '00:05:1e:08:f8:20',
                                    '00:05:1e:08:f9:12',
                                    '00:05:1e:09:21:2d',
                                    '00:05:1e:09:21:50',
                                    '00:05:33:43:78:2d',
                                    '00:50:56:bc:31:8a',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:60:16:1e:64:79',
                                    '00:60:16:1e:68:23',
                                    '00:60:16:1e:56:f6',
                                    '00:60:16:1e:57:3d',
                                    '6c:ae:8b:6b:3e:78',
                                    '6c:ae:8b:6b:3e:e6',
                                    '6c:ae:8b:6b:40:58',
                                    '6c:ae:8b:6b:41:38',
                                    '78:fe:3d:df:cc:41',
                                    '84:18:88:a6:06:33',
                                    '84:18:88:ae:89:80',
                                    '84:2b:2b:71:30:f3',
                                    '10:8c:cf:cb:9e:92',
                                    'ac:4b:c8:22:b8:41',
                                    'ac:4b:c8:23:1d:81',
                                    'ac:4b:c8:23:48:01',
                                    'b0:a8:6e:86:08:41',
                                    'b0:a8:6e:9a:52:01',
                                    '02:04:96:35:f9:24',
                                    'd0:d0:fd:ab:1a:b6',
                                    'd0:d0:fd:ac:ae:b6',
                                    'd0:57:4c:74:16:01',
                                    'e4:1f:13:76:ca:35',
                                    '18:03:73:0a:29:c2',
                                    '18:03:73:09:ae:8c',
                                    'f0:4d:a2:6e:cf:89',
                                    'f0:4d:a2:6e:d3:e6',
                                    'f0:4d:a2:6e:d4:96',
                                    'f0:4d:a2:6e:d4:1c',
                                    'f0:4d:a2:6f:03:39',
                                    'f0:4d:a2:6f:03:5b',
                                    'f0:4d:a2:d9:bc:3f',
                                    '20:3a:07:ee:e1:62',
                                    '20:3a:07:ee:e2:40',
                                    '20:3a:07:ee:e4:76',
                                    '2c:6b:f5:9a:7e:80',
                                    '2c:36:f8:4b:6e:8e',
                                    '54:e0:32:87:92:01',
                                    '54:e0:32:87:92:36',
                                    '58:35:d9:94:d3:1a',
                                    '5c:26:0a:a5:b9:93',
                                    '00:10:db:ff:10:02',
                                    '00:14:38:a4:ca:b0',
                                    '00:1c:c0:7f:3d:83',
                                    '00:1c:c0:fc:f0:8a',
                                    '00:1c:c0:fc:f1:29',
                                    '00:1c:c0:fc:f8:a7',
                                    '00:1c:c0:fc:f8:b8',
                                    '00:1c:c0:fc:f8:cf',
                                    '00:1c:c0:fc:f9:9b',
                                    '00:1c:c0:fc:f9:ca',
                                    '00:1c:c0:fc:f9:f3',
                                    '00:1c:c0:fc:f9:fd',
                                    '00:1c:c0:fc:fa:0c',
                                    '00:1c:c0:fc:fa:12',
                                    '00:1c:c0:fc:fa:21',
                                    '00:1c:c0:fc:fa:2a',
                                    '00:1c:c0:fd:5b:0b',
                                    '00:27:0e:02:ed:83',
                                    '1c:6f:65:0e:4b:f4',
                                    '40:2c:f4:eb:f4:5d',
                                    '40:2c:f4:eb:fc:7a',
                                    '40:2c:f4:eb:fd:17',
                                    '40:2c:f4:eb:ff:6f',
                                    '40:2c:f4:ec:00:13',
                                    '40:2c:f4:ec:01:8c',
                                    '40:2c:f4:ec:01:90',
                                    '40:2c:f4:ec:01:c3',
                                    '40:2c:f4:ec:01:d9',
                                    '40:2c:f4:ec:01:e1',
                                    '40:2c:f4:ec:01:e9',
                                    '40:2c:f4:ec:01:39',
                                    '40:2c:f4:ec:01:3a',
                                    '44:37:e6:87:64:b8',
                                    '44:37:e6:87:64:d7',
                                    '44:37:e6:87:64:d8',
                                    '44:37:e6:87:64:e3',
                                    '44:37:e6:91:c6:eb',
                                    '44:37:e6:91:c6:03',
                                    '44:37:e6:91:c7:8b',
                                    '44:37:e6:91:c7:92',
                                    '44:37:e6:91:c7:38',
                                    '44:37:e6:92:39:e3',
                                    '44:37:e6:92:3a:a8',
                                    '44:37:e6:92:3a:c8',
                                    '44:37:e6:92:3a:cd',
                                    '44:37:e6:92:3a:d3',
                                    '44:37:e6:92:3a:d4',
                                    '44:37:e6:92:3a:d6',
                                    '44:37:e6:92:3a:da',
                                    '44:37:e6:92:3a:ed',
                                    '44:37:e6:92:3a:f4',
                                    '44:37:e6:92:3a:1d',
                                    '44:37:e6:92:3a:31',
                                    '44:37:e6:92:3a:06',
                                    '44:37:e6:92:3a:56',
                                    '44:37:e6:92:3b:01',
                                    '08:00:27:01:e8:7c',
                                    '08:00:27:64:a9:9b',
                                    '08:00:27:65:ce:3e',
                                    '08:00:27:6a:43:68',
                                    '08:00:27:6f:99:dc',
                                    '08:00:27:73:84:26',
                                    '08:00:27:73:8f:6f',
                                    '08:00:27:77:79:64',
                                    '08:00:27:78:c5:da',
                                    '08:00:27:7a:c9:80',
                                    '08:00:27:80:f0:2f',
                                    '08:00:27:86:6d:92',
                                    '08:00:27:87:b2:a2',
                                    '08:00:27:8c:9f:e2',
                                    '08:00:27:8e:28:a5',
                                    '08:00:27:8f:99:1d',
                                    '08:00:27:8f:49:c6',
                                    '08:00:27:9a:d2:1a',
                                    '08:00:27:a9:0c:9a',
                                    '08:00:27:a9:8c:b4',
                                    '08:00:27:b3:f9:95',
                                    '08:00:27:ba:44:b4',
                                    '08:00:27:bc:bb:8c',
                                    '08:00:27:bf:38:de',
                                    '08:00:27:c8:fd:42',
                                    '08:00:27:d1:ae:8f',
                                    '08:00:27:15:7e:5e',
                                    '08:00:27:d2:f6:52',
                                    '08:00:27:d8:a1:e4',
                                    '08:00:27:db:75:c5',
                                    '08:00:27:e0:43:de',
                                    '08:00:27:e1:b2:19',
                                    '08:00:27:e1:51:1c',
                                    '08:00:27:e4:3b:66',
                                    '08:00:27:ea:d6:94',
                                    '08:00:27:eb:04:00',
                                    '08:00:27:ed:12:66',
                                    '08:00:27:ef:a1:10',
                                    '08:00:27:f0:aa:a1',
                                    '08:00:27:f2:48:eb',
                                    '08:00:27:f8:6d:8f',
                                    '08:00:27:fb:d1:38',
                                    '08:00:27:1a:85:b4',
                                    '08:00:27:03:68:f1',
                                    '08:00:27:1f:07:26',
                                    '08:00:27:24:0b:8c',
                                    '08:00:27:04:e3:73',
                                    '08:00:27:04:fa:09',
                                    '08:00:27:2c:56:14',
                                    '08:00:27:34:09:46',
                                    '08:00:27:36:b3:04',
                                    '08:00:27:36:c8:1f',
                                    '08:00:27:3a:50:18',
                                    '08:00:27:3c:02:c1',
                                    '08:00:27:3f:59:b6',
                                    '08:00:27:43:da:f7',
                                    '08:00:27:44:70:b4',
                                    '08:00:27:44:ab:de',
                                    '08:00:27:45:9d:fd',
                                    '08:00:27:46:99:29',
                                    '08:00:27:46:a4:a8',
                                    '08:00:27:47:83:fd',
                                    '08:00:27:4a:b8:5d',
                                    '08:00:27:4b:50:21',
                                    '08:00:27:4d:fa:21',
                                    '08:00:27:4e:6a:6d',
                                    '08:00:27:4e:b7:7c',
                                    '08:00:27:08:d7:49',
                                    '08:00:27:51:41:ce',
                                    '08:00:27:52:6b:8c',
                                    '08:00:27:59:e9:48',
                                    '08:00:27:59:62:ca',
                                    '08:00:27:5b:27:66',
                                    '08:00:27:5c:04:1e',
                                    '08:00:27:60:40:78',
                                    '08:00:27:60:46:4b',
                                    '00:10:db:ff:10:02',
                                    '9c:8e:99:c5:77:ad',
                                    '9c:8e:99:c6:91:4a',
                                    '18:a9:05:34:ed:d5',
                                    '2c:27:d7:52:e3:be',
                                    '54:53:ed:7f:cc:13',
                                    '54:53:ed:7f:cc:fe',
                                    '54:53:ed:7f:cc:ff',
                                    '00:0c:29:27:f8:57',
                                    '00:10:db:ff:10:02',
                                    '00:11:11:3a:83:e7',
                                    '00:16:76:ce:7c:0a',
                                    '00:17:f2:94:41:c4',
                                    '00:18:51:00:00:b3',
                                    '00:18:51:00:00:54',
                                    '00:18:51:00:01:51',
                                    '00:18:51:00:41:ec',
                                    '00:18:51:66:aa:11',
                                    '00:18:51:6a:b1:c9',
                                    '00:18:51:91:62:38',
                                    '00:18:51:93:24:ec',
                                    '00:18:51:94:15:c6',
                                    '00:18:51:99:f9:a1',
                                    '00:18:51:9d:82:ef',
                                    '00:18:51:a0:3a:36',
                                    '00:18:51:a4:78:bc',
                                    '00:18:51:a4:e9:03',
                                    '00:18:51:a6:4b:5c',
                                    '00:18:51:a7:ea:1f',
                                    '00:18:51:11:12:86',
                                    '00:18:51:ab:03:e0',
                                    '00:18:51:ac:bd:fd',
                                    '00:18:51:b7:73:e0',
                                    '00:18:51:bd:4d:a6',
                                    '00:18:51:c1:2e:a8',
                                    '00:18:51:ce:67:ca',
                                    '00:18:51:d8:80:37',
                                    '00:18:51:de:bf:33',
                                    '00:18:51:e1:5c:00',
                                    '00:18:51:17:e7:29',
                                    '00:18:51:ea:36:d4',
                                    '00:18:51:ec:1e:3b',
                                    '00:18:51:ee:71:fe',
                                    '00:18:51:18:85:31',
                                    '00:18:51:f6:da:b5',
                                    '00:18:51:fb:8c:ef',
                                    '00:18:51:fd:12:86',
                                    '00:18:51:1a:17:a6',
                                    '00:18:51:1d:af:93',
                                    '00:18:51:04:f4:d7',
                                    '00:18:51:04:2d:18',
                                    '00:18:51:2a:45:5e',
                                    '00:18:51:3a:3f:f2',
                                    '00:18:51:44:08:78',
                                    '00:18:51:46:7b:84',
                                    '00:18:51:47:8c:c5',
                                    '00:18:51:49:de:33',
                                    '00:18:51:4b:0a:36',
                                    '00:18:51:4b:1a:a2',
                                    '00:18:51:4e:e7:a3',
                                    '00:18:51:51:f1:8d',
                                    '00:18:51:5c:d2:3b',
                                    '00:18:51:5e:25:c8',
                                    '00:1c:c0:22:f4:d4',
                                    '00:20:4a:d7:39:5a',
                                    '00:22:19:63:0f:4d',
                                    '00:24:36:f4:02:3e',
                                    '00:30:48:76:ab:88',
                                    '00:30:48:82:e7:72',
                                    '00:50:56:bc:00:01',
                                    '00:50:56:bc:00:0d',
                                    '00:50:56:bc:00:09',
                                    '00:50:56:bc:19:00',
                                    '00:50:56:bc:31:94',
                                    '00:50:56:bc:35:da',
                                    '00:50:56:bc:56:18',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:10:db:ff:10:02',
                                    '00:10:db:ff:10:02',
                                    '00:1c:c0:fc:f8:fb',
                                    '10:8c:cf:cb:9b:ef',
                                    '00:10:db:ff:10:02',
                                    '00:1c:c0:9b:31:d1',
                                    '00:27:0e:01:25:fa',
                                    '70:f3:95:1b:85:4c',
                                    '00:10:db:ff:10:02',
                                    '00:13:20:32:81:47',
                                    '00:16:cb:aa:6d:75',
                                    '00:16:cb:ae:3d:f1',
                                    '00:e0:db:0c:ef:43',
                                    '00:18:51:c7:ad:5f',
                                    '00:1a:a0:ba:e2:a6',
                                    '00:1a:a0:36:6d:b3',
                                    '00:1a:a0:36:ac:4d',
                                    '00:1c:c0:7f:3e:ca',
                                    '00:1c:c0:9b:58:fd',
                                    '00:21:5a:8f:48:b0',
                                    '00:22:19:63:0f:4d',
                                    '00:25:64:92:7d:88',
                                    '00:25:64:bd:e6:e7',
                                    '00:25:64:bd:f1:fb',
                                    '00:26:b9:ed:20:4d',
                                    '00:04:00:c3:15:26',
                                    '00:08:9b:80:83:38',
                                    '64:b9:e8:c0:af:d8',
                                    '70:cd:60:f1:fb:d0',
                                    '78:2b:cb:7e:62:9e',
                                    '84:2b:2b:ab:ef:b4',
                                    '84:2b:2b:bc:56:04',
                                    'cc:52:af:41:38:5e',
                                    'cc:52:af:4c:27:44',
                                    'f0:4d:a2:0e:2c:0f',
                                    '1c:6f:65:0d:f0:52',
                                    '1c:6f:65:0d:fa:de',
                                    '1c:6f:65:0e:4b:c8',
                                    '20:c9:d0:29:d8:47',
                                    '3c:97:0e:7b:e8:4a',
                                    '40:6c:8f:bb:dc:e2',
                                    '44:37:e6:87:65:d2',
                                    '44:37:e6:87:65:d7',
                                    '5c:26:0a:12:2e:62',
                                    '5c:26:0a:2e:06:a9',
                                    '5c:26:0a:63:7c:f2',
                                    '00:0c:f1:e2:7a:aa',
                                    '00:0c:f1:e2:7a:da',
                                    '00:0c:f1:e2:7b:8d',
                                    '00:0c:f1:e8:b9:65',
                                    '00:0c:f1:e8:b9:80',
                                    '00:0c:f1:e8:bc:31',
                                    '00:10:db:ff:10:02',
                                    '00:11:11:ee:b3:ee',
                                    '00:13:20:32:82:63',
                                    '00:13:20:4a:d7:3f',
                                    '00:1a:a0:d6:c8:a5',
                                    '00:0c:29:86:0c:c0',
                                    '00:0c:29:94:f8:bc',
                                    '00:0c:29:b9:6d:7d',
                                    '00:0c:29:ca:32:91',
                                    '00:0c:29:2b:12:ce',
                                    '00:0c:29:56:6b:7a',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:ae:27:a6',
                                    '00:19:d1:ae:31:6c',
                                    '00:19:d1:17:b0:2c',
                                    '00:1c:c0:7f:3c:dd',
                                    '00:1c:c0:7f:3d:17',
                                    '00:1c:c0:7f:3d:03',
                                    '00:1c:c0:8f:2b:f1',
                                    '00:1c:c0:8f:2c:67',
                                    '00:1c:c0:8f:44:f4',
                                    '00:1c:c0:8f:46:74',
                                    '00:1c:c0:8f:46:75',
                                    '00:1c:c0:8f:46:14',
                                    '00:1c:c0:1b:04:a3',
                                    '00:1e:4f:bf:c8:8b',
                                    '00:1e:4f:c0:59:04',
                                    '00:1e:4f:32:ea:9a',
                                    '00:25:64:94:49:b1',
                                    '00:25:64:a0:39:0b',
                                    '00:27:0e:01:25:84',
                                    '00:27:0e:02:56:0d',
                                    '00:27:0e:02:56:40',
                                    '00:50:56:bc:00:48',
                                    '00:50:56:bc:31:89',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '84:2b:2b:9d:79:cc',
                                    '10:78:d2:c3:df:fc',
                                    'ac:16:2d:37:1b:c0',
                                    'cc:52:af:41:26:63',
                                    'cc:52:af:41:34:5f',
                                    '1c:6f:65:0b:cc:d9',
                                    '1c:6f:65:0e:90:4d',
                                    '1c:6f:65:0f:e1:2e',
                                    '1c:6f:65:09:57:46',
                                    '2c:36:f8:4b:6f:3f',
                                    '44:37:e6:62:26:f7',
                                    '44:37:e6:63:4c:e1',
                                    '44:37:e6:63:4c:e9',
                                    '44:37:e6:63:4c:eb',
                                    '00:0c:29:ca:32:a5',
                                    '00:10:db:ff:10:02',
                                    '00:19:d1:17:b0:93',
                                    '00:19:d1:05:a6:73',
                                    '00:26:b9:ed:20:53',
                                    '00:27:0e:01:25:4a',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '70:f3:95:1b:84:96',
                                    '70:f3:95:1b:85:37',
                                    '84:2b:2b:9d:8b:73',
                                    '1c:6f:65:0e:8c:42',
                                    '44:37:e6:bb:a3:cc',
                                    '00:80:77:ec:d6:f9',
                                    '00:9c:02:07:8d:ed',
                                    '00:10:db:ff:10:02',
                                    '00:03:81:82:3e:45',
                                    '00:03:2d:1c:e3:8b',
                                    '00:03:2d:1c:e3:de',
                                    '00:20:6b:7a:68:84',
                                    '00:20:6b:7a:d2:76',
                                    '00:20:6b:7a:d2:4b',
                                    '00:20:6b:7a:d2:52',
                                    '00:20:6b:7a:f0:5b',
                                    '00:20:6b:7a:1f:8c',
                                    '00:20:6b:7a:62:57',
                                    '00:20:6b:8f:a5:c4',
                                    '00:20:4a:66:3e:02',
                                    '00:23:7d:7d:e0:d6',
                                    '00:23:7d:7d:2c:4b',
                                    '00:23:7d:85:a4:41',
                                    '00:25:b3:fa:d3:49',
                                    '78:e3:b5:f7:f0:ca',
                                    'ac:16:2d:39:c4:3a',
                                    'c8:cb:b8:60:89:fb',
                                    'd4:85:64:1f:4c:49',
                                    'f4:ce:46:3c:72:b6',
                                    '1c:c1:de:82:2a:e3',
                                    '1c:c1:de:82:3a:75',
                                    '1c:c1:de:83:7e:ab',
                                    '2c:76:8a:3f:b6:bf',
                                    '2c:76:8a:40:ff:fc',
                                    '3c:4a:92:b4:06:12',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '53',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '56',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00005 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '59',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00006 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '62',
                        IFNAME           => 'pmf-bup1pub',
                        IFDESCR          => 'VLAN 00007 (pmf-bup1pub)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => '802.1Q Encapsulation Tag 0221',
                        IFDESCR          => '802.1Q Encapsulation Tag 0221',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00008 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00009 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00010 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => 'tmp',
                        IFDESCR          => 'VLAN 00011 (tmp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00012 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00013 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => 'pmf-lan-periph',
                        IFDESCR          => 'VLAN 00014 (pmf-lan-periph)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFNAME           => '802.1Q Encapsulation Tag 1030',
                        IFDESCR          => '802.1Q Encapsulation Tag 1030',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFNAME           => 'rif0(192.168.100.3)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.3',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1212371217',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123275965',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit48si.03.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit 48si',
            DESCRIPTION  => 'Summit48si - Version 7.0.1 (Build 11) by Release_Master 03/28/03 02:09:23',

            SNMPHOSTNAME => 'xtb12-1',
            LOCATION     => 'PMF-B12',
            CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
            UPTIME       => '(447894875) 51 days, 20:09:08.75',
            MAC          => '00:01:30:12:91:80',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '192.168.100.6',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.0.1 (Build 11) by Release_Master 03/28/03 02:09:23',
                NAME         => 'xtb12-1',
                LOCATION     => 'PMF-B12',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                UPTIME       => '(447894875) 51 days, 20:09:08.75',
                MAC          => '00:01:30:12:91:80',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.6',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438798800) 50 days, 18:53:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51459175',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '624206988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13645608',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1165108025',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438949800) 50 days, 19:18:18.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '10359391',
                        IFINERRORS       => '11883',
                        IFOUTOCTETS      => '791491706',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(360574500) 41 days, 17:35:45.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9519747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8043603',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447869200) 51 days, 20:04:52.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '17630567',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1347982097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445694100) 51 days, 14:02:21.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '90949422',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '844686721',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446153300) 51 days, 15:18:53.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '644817930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '98726208',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2960876979',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3776225281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(444947800) 51 days, 11:57:58.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '316906751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2620095600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1732175943',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2495978711',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(422093300) 48 days, 20:28:53.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4262916',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '20491664',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438784000) 50 days, 18:50:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15887247',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '323560384',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(431377500) 49 days, 22:16:15.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '298253440',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3211959663',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438152300) 50 days, 17:05:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '44479918',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '583219117',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6900) 0:01:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177442977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1775635520',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292477000) 33 days, 20:26:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36593901',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '476315387',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438778900) 50 days, 18:49:49.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37910746',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '495726371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438785100) 50 days, 18:50:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39504370',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '533393140',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292476100) 33 days, 20:26:01.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36161125',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '475876102',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(116590300) 13 days, 11:51:43.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '15952459',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154152485',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445049400) 51 days, 12:14:54.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '175358663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1084311319',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1471169108',
                        IFINERRORS       => '150994',
                        IFOUTOCTETS      => '2820742352',
                        IFOUTERRORS      => '1661377',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438422700) 50 days, 17:50:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '84056914',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '871927228',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2600) 0:00:26.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '11109366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1801736449',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '421202059',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1285712057',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445050700) 51 days, 12:15:07.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1431954',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '361041589',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(900) 0:00:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10394538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1733056324',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(315813900) 36 days, 13:15:39.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '110830791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '496907920',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446920000) 51 days, 17:26:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21310051',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '121889157',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424134400) 49 days, 2:09:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3137600162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '733909303',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00005 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00006 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00007 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00008 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00009 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => 'tmp',
                        IFDESCR          => 'VLAN 00010 (tmp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => 'pmf-crous-adm',
                        IFDESCR          => 'VLAN 00011 (pmf-crous-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFNAME           => '802.1Q Encapsulation Tag 0299',
                        IFDESCR          => '802.1Q Encapsulation Tag 0299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => 'pmf-lan-crir',
                        IFDESCR          => 'VLAN 00012 (pmf-lan-crir)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '84',
                        IFNAME           => '802.1Q Encapsulation Tag 1010',
                        IFDESCR          => '802.1Q Encapsulation Tag 1010',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFNAME           => 'pmf-testgp',
                        IFDESCR          => 'VLAN 00013 (pmf-testgp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFNAME           => '802.1Q Encapsulation Tag 0209',
                        IFDESCR          => '802.1Q Encapsulation Tag 0209',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00014 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFNAME           => 'pmf-lan-adm',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '96',
                        IFNAME           => '802.1Q Encapsulation Tag 1016',
                        IFDESCR          => '802.1Q Encapsulation Tag 1016',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00017 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFNAME           => 'pmf-lan-re',
                        IFDESCR          => 'VLAN 00018 (pmf-lan-re)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFNAME           => '802.1Q Encapsulation Tag 1017',
                        IFDESCR          => '802.1Q Encapsulation Tag 1017',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => 'rif0(192.168.100.6)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.6',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1192161775',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '83712995',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summitx350.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Extreme',
            MODEL        => 'Summit X350-48t',
            DESCRIPTION  => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',

            SNMPHOSTNAME => 'sw30-c01-1',
            LOCATION     => 'Inria dc1 salle 30',
            CONTACT      => 'dsi.sesi.reseau@inria.fr',
            SERIAL       => '1115G-80540',
            FIRMWARE     => '1.0.3.5',
            UPTIME       => '(3784113704) 437 days, 23:25:37.04',
            MAC          => '00:04:96:52:04:36',
            IPS          => {
                IP => [
                    '192.168.3.232',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Extreme',
                MODEL        => 'Summit X350-48t',
                COMMENTS     => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',
                NAME         => 'sw30-c01-1',
                LOCATION     => 'Inria dc1 salle 30',
                CONTACT      => 'dsi.sesi.reseau@inria.fr',
                SERIAL       => '1115G-80540',
                FIRMWARE     => '1.0.3.5',
                UPTIME       => '(3784113704) 437 days, 23:25:37.04',
                MAC          => '00:04:96:52:04:36',
                IPS          => {
                    IP => [
                        '192.168.3.232',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1:1',
                        IFDESCR          => 'X350-48t Port 1',
                        IFALIAS          => 'sesi-esx-testosx',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3272213204) 378 days, 17:28:52.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3303343612',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3942345649',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a8:20:66:11:91:74',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1:2',
                        IFDESCR          => 'X350-48t Port 2',
                        IFALIAS          => 'giration',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3324699704) 384 days, 19:16:37.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3959649414',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '185020433',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:03:ba:ce:77:fb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1:3',
                        IFDESCR          => 'X350-48t Port 3',
                        IFALIAS          => 'sesi-apc1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3513992804) 406 days, 17:05:28.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '50617003',
                        IFINERRORS       => '29',
                        IFOUTOCTETS      => '2337079249',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:c0:b7:50:a9:73',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1:4',
                        IFDESCR          => 'X350-48t Port 4',
                        IFALIAS          => 'uranium',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3178678404) 367 days, 21:39:44.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1618000480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2170113523',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:13:72:55:b1:9b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1:5',
                        IFDESCR          => 'X350-48t Port 5',
                        IFALIAS          => 'test-sesi-esx4-eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3291280804) 380 days, 22:26:48.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1042831496',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1437087003',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1d:09:71:5b:6c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1:6',
                        IFDESCR          => 'X350-48t Port 6',
                        IFALIAS          => 'test-sesi-esx4-eth1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3291280704) 380 days, 22:26:47.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3142817833',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2388193180',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1:7',
                        IFDESCR          => 'X350-48t Port 7',
                        IFALIAS          => 'text-sesi-kvm1-eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3297662704) 381 days, 16:10:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '245388637',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1638018966',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:2b:cb:1f:4e:93',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1:8',
                        IFDESCR          => 'X350-48t Port 8',
                        IFALIAS          => 'text-sesi-kvm1-eth1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3325246504) 384 days, 20:47:45.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2466694212',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '109701232',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1:9',
                        IFDESCR          => 'X350-48t Port 9',
                        IFALIAS          => 'text-sesi-kvm1-adm',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3297663004) 381 days, 16:10:30.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2213864083',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '792641758',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:2b:cb:1f:4e:95',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1:10',
                        IFDESCR          => 'X350-48t Port 10',
                        IFALIAS          => 'giration-rsc',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3324702904) 384 days, 19:17:09.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '92556134',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3538427385',
                        IFOUTERRORS      => '74',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:14:4f:22:48:d7',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1:11',
                        IFDESCR          => 'X350-48t Port 11',
                        IFALIAS          => 'audit-cobalt',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3325396404) 384 days, 21:12:44.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '514600894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1602719539',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1d:09:31:39:9e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1:12',
                        IFDESCR          => 'X350-48t Port 12',
                        IFALIAS          => 'audit-cobalt-res',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3333255604) 385 days, 19:02:36.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '204717546',
                        IFINERRORS       => '340',
                        IFOUTOCTETS      => '318859712',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1d:09:31:39:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1:13',
                        IFDESCR          => 'X350-48t Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3264178204) 377 days, 19:09:42.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1614001515',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4092847294',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1:14',
                        IFDESCR          => 'X350-48t Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3264178204) 377 days, 19:09:42.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3651246828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4065782396',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1:15',
                        IFDESCR          => 'X350-48t Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3264178204) 377 days, 19:09:42.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '657042982',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1:16',
                        IFDESCR          => 'X350-48t Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(75547000) 8 days, 17:51:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1:17',
                        IFDESCR          => 'X350-48t Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2262830304) 261 days, 21:38:23.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4280926394',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2115348006',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1:18',
                        IFDESCR          => 'X350-48t Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2961908200) 342 days, 19:31:22.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1:19',
                        IFDESCR          => 'X350-48t Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1659398400) 192 days, 1:26:24.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1:20',
                        IFDESCR          => 'X350-48t Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1477809600) 171 days, 1:01:36.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1:21',
                        IFDESCR          => 'X350-48t Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2261801704) 261 days, 18:46:57.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1106157847',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1730763040',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1:22',
                        IFDESCR          => 'X350-48t Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2261787704) 261 days, 18:44:37.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2463222105',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3684592586',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1:23',
                        IFDESCR          => 'X350-48t Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2261787704) 261 days, 18:44:37.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '11703527',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '362345271',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1:24',
                        IFDESCR          => 'X350-48t Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2261787704) 261 days, 18:44:37.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1357524542',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3965316269',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => '1:25',
                        IFDESCR          => 'X350-48t Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3204772304) 370 days, 22:08:43.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1324447642',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => '1:26',
                        IFDESCR          => 'X350-48t Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3204771304) 370 days, 22:08:33.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1323062006',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => '1:27',
                        IFDESCR          => 'X350-48t Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3204859504) 370 days, 22:23:15.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '788734047',
                        IFINERRORS       => '9',
                        IFOUTOCTETS      => '2322077285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => '1:28',
                        IFDESCR          => 'X350-48t Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3204859204) 370 days, 22:23:12.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '863154774',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '925032877',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => '1:29',
                        IFDESCR          => 'X350-48t Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2260794304) 261 days, 15:59:03.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2831504004',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3099013675',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => '1:30',
                        IFDESCR          => 'X350-48t Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2260794304) 261 days, 15:59:03.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3714231185',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3778747758',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => '1:31',
                        IFDESCR          => 'X350-48t Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2260732704) 261 days, 15:48:47.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '79749018',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '619839293',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => '1:32',
                        IFDESCR          => 'X350-48t Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2260732704) 261 days, 15:48:47.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2368997413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '450025791',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => '1:33',
                        IFDESCR          => 'X350-48t Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4232180500) 489 days, 20:03:25.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => '1:34',
                        IFDESCR          => 'X350-48t Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4232180500) 489 days, 20:03:25.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => '1:35',
                        IFDESCR          => 'X350-48t Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4232180500) 489 days, 20:03:25.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => '1:36',
                        IFDESCR          => 'X350-48t Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4232180500) 489 days, 20:03:25.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => '1:37',
                        IFDESCR          => 'X350-48t Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2961916400) 342 days, 19:32:44.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => '1:38',
                        IFDESCR          => 'X350-48t Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2961913000) 342 days, 19:32:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => '1:39',
                        IFDESCR          => 'X350-48t Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2269857004) 262 days, 17:09:30.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4080',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '957776568',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => '1:40',
                        IFDESCR          => 'X350-48t Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2269857304) 262 days, 17:09:33.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '279911082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3726055597',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => '1:41',
                        IFDESCR          => 'X350-48t Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(8700) 0:01:27.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => '1:42',
                        IFDESCR          => 'X350-48t Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2962035700) 342 days, 19:52:37.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => '1:43',
                        IFDESCR          => 'X350-48t Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2961968700) 342 days, 19:41:27.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => '1:44',
                        IFDESCR          => 'X350-48t Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2961974100) 342 days, 19:42:21.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => '1:45',
                        IFDESCR          => 'X350-48t Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2961977100) 342 days, 19:42:51.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => '1:46',
                        IFDESCR          => 'X350-48t Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(3297756904) 381 days, 16:26:09.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '232312790',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3450649308',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => '1:47',
                        IFDESCR          => 'X350-48t Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3153068804) 364 days, 22:31:28.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '19482976',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6044274',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => '1:48',
                        IFDESCR          => 'X350-48t Port 48',
                        IFALIAS          => 'sw30-c01-3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3358379604) 388 days, 16:49:56.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3918793861',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3049178434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => '1:49',
                        IFDESCR          => 'X350-48t Port 49',
                        IFALIAS          => 'swdc-30-02-dc1',
                        IFTYPE           => '6',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4028206546',
                        IFINERRORS       => '107',
                        IFOUTOCTETS      => '4268788729',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => 'Eth1/46',
                                IFDESCR  => 'Ethernet1/46',
                                SYSNAME  => 'swdc-30-02-dc1',
                                SYSDESCR => '"Cisco Nexus Operating System (NX-OS) Software',
                                SYSMAC   => '54:7f:ee:b1:46:35',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => '1:50',
                        IFDESCR          => 'X350-48t Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(8700) 0:01:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => 'Management',
                        IFDESCR          => 'Management Port',
                        IFALIAS          => 'MgmtPort',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000001',
                        IFNAME           => 'VirtualRouter0',
                        IFDESCR          => 'VirtualRouter0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4900) 0:00:49.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000002',
                        IFNAME           => 'VirtualRouter2',
                        IFDESCR          => 'VirtualRouter2',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5000) 0:00:50.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000003',
                        IFNAME           => 'VirtualRouter1',
                        IFDESCR          => 'VirtualRouter1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5000) 0:00:50.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000004',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1002630400) 116 days, 1:05:04.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000005',
                        IFNAME           => 'Mgmt',
                        IFDESCR          => 'VLAN 04095 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000006',
                        IFNAME           => 'Admin',
                        IFDESCR          => 'VLAN 00002 (Admin)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000007',
                        IFNAME           => 'rtif(192.168.3.232/21)',
                        IFDESCR          => 'rtif(192.168.3.232/21)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.3.232',
                        MAC              => '00:04:96:52:04:36',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000008',
                        IFNAME           => 'Ctrl-Ring-Nat',
                        IFDESCR          => 'VLAN 04080 (Ctrl-Ring-Nat)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000009',
                        IFNAME           => 'L2VPN-SOPHIA',
                        IFDESCR          => 'VLAN 00242 (L2VPN-SOPHIA)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000010',
                        IFNAME           => 'SRV-ESX-FT',
                        IFDESCR          => 'VLAN 00200 (SRV-ESX-FT)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000011',
                        IFNAME           => 'SRV-ESX-VMOTION',
                        IFDESCR          => 'VLAN 00201 (SRV-ESX-VMOTION)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000012',
                        IFNAME           => 'SRV-HEARTBEAT-LVS',
                        IFDESCR          => 'VLAN 00202 (SRV-HEARTBEAT-LVS)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000013',
                        IFNAME           => 'SRV-Prod-NUM',
                        IFDESCR          => 'VLAN 02272 (SRV-Prod-NUM)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000014',
                        IFNAME           => 'SRV-SI-Admin',
                        IFDESCR          => 'VLAN 02080 (SRV-SI-Admin)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000015',
                        IFNAME           => 'SRV-SI-Appli',
                        IFDESCR          => 'VLAN 00009 (SRV-SI-Appli)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000016',
                        IFNAME           => 'SRV-SI-DMZ',
                        IFDESCR          => 'VLAN 00012 (SRV-SI-DMZ)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000017',
                        IFNAME           => 'SRV-SI-Prod',
                        IFDESCR          => 'VLAN 02048 (SRV-SI-Prod)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000018',
                        IFNAME           => 'SRV-SI-Qualif',
                        IFDESCR          => 'VLAN 00011 (SRV-SI-Qualif)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000019',
                        IFNAME           => 'SRV-SI-Ressources',
                        IFDESCR          => 'VLAN 00013 (SRV-SI-Ressources)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000020',
                        IFNAME           => 'SRV-SI-SBX',
                        IFDESCR          => 'VLAN 00022 (SRV-SI-SBX)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000021',
                        IFNAME           => 'SRV-SI-Serv',
                        IFDESCR          => 'VLAN 00008 (SRV-SI-Serv)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000022',
                        IFNAME           => 'SRV-SI-TMA',
                        IFDESCR          => 'VLAN 02304 (SRV-SI-TMA)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000023',
                        IFNAME           => 'SRV-SI-VPN',
                        IFDESCR          => 'VLAN 00021 (SRV-SI-VPN)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000024',
                        IFNAME           => 'VPN-CRI-Bor',
                        IFDESCR          => 'VLAN 00031 (VPN-CRI-Bor)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000025',
                        IFNAME           => 'VPN-CRI-Gre',
                        IFDESCR          => 'VLAN 00032 (VPN-CRI-Gre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000026',
                        IFNAME           => 'VPN-CRI-Lil',
                        IFDESCR          => 'VLAN 00033 (VPN-CRI-Lil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8800) 0:01:28.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000027',
                        IFNAME           => 'VPN-CRI-Nan',
                        IFDESCR          => 'VLAN 00034 (VPN-CRI-Nan)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8900) 0:01:29.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000028',
                        IFNAME           => 'VPN-CRI-Ren',
                        IFDESCR          => 'VLAN 00035 (VPN-CRI-Ren)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8900) 0:01:29.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000029',
                        IFNAME           => 'VPN-CRI-Roc',
                        IFDESCR          => 'VLAN 02944 (VPN-CRI-Roc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8900) 0:01:29.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000030',
                        IFNAME           => 'VPN-CRI-Sac',
                        IFDESCR          => 'VLAN 00036 (VPN-CRI-Sac)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8900) 0:01:29.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000031',
                        IFNAME           => 'VPN-CRI-Sop',
                        IFDESCR          => 'VLAN 00030 (VPN-CRI-Sop)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8900) 0:01:29.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000032',
                        IFNAME           => 'SRV-CI-IaaS-Priv',
                        IFDESCR          => 'VLAN 00211 (SRV-CI-IaaS-Priv)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000033',
                        IFNAME           => 'SRV-CI-IaaS',
                        IFDESCR          => 'VLAN 00210 (SRV-CI-IaaS)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000034',
                        IFNAME           => 'SRV-CI-Frontal',
                        IFDESCR          => 'VLAN 00209 (SRV-CI-Frontal)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000035',
                        IFNAME           => 'SRV-SI-Infrasvc',
                        IFDESCR          => 'VLAN 00213 (SRV-SI-Infrasvc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000036',
                        IFNAME           => 'SRV-ESX-SAN-EQL',
                        IFDESCR          => 'VLAN 00216 (SRV-ESX-SAN-EQL)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000037',
                        IFNAME           => 'SRV-ESX-NAS',
                        IFDESCR          => 'VLAN 00217 (SRV-ESX-NAS)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000038',
                        IFNAME           => 'SRV-BACKUP-SAN-EQL',
                        IFDESCR          => 'VLAN 00218 (SRV-BACKUP-SAN-EQL)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000040',
                        IFNAME           => 'SRV-SI-Prod-NAS',
                        IFDESCR          => 'VLAN 00220 (SRV-SI-Prod-NAS)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000041',
                        IFNAME           => 'SRV-CI-Frontal-NAS',
                        IFDESCR          => 'VLAN 00221 (SRV-CI-Frontal-NAS)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1000042',
                        IFNAME           => 'SRV-SI-Qualif-NAS',
                        IFDESCR          => 'VLAN 00219 (SRV-SI-Qualif-NAS)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359565404) 388 days, 20:07:34.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
);

plan skip_all => 'SNMP walks database required'
    if !$ENV{SNMPWALK_DATABASE};
plan tests => 2 * scalar keys %tests;

foreach my $test (sort keys %tests) {
    my $snmp  = FusionInventory::Agent::SNMP::Mock->new(
        file => "$ENV{SNMPWALK_DATABASE}/$test"
    );

    my %discovery = getDeviceInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        \%discovery,
        $tests{$test}->[0],
        "$test: discovery"
    );

    my $inventory = getDeviceFullInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        $inventory,
        $tests{$test}->[1],
        "$test: inventory"
    );
}
