# Generated by default/object.tt
package Paws::SecurityHub::VulnerabilityVendor;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Url => (is => 'ro', isa => 'Str');
  has VendorCreatedAt => (is => 'ro', isa => 'Str');
  has VendorSeverity => (is => 'ro', isa => 'Str');
  has VendorUpdatedAt => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::VulnerabilityVendor

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::VulnerabilityVendor object:

  $service_obj->Method(Att1 => { Name => $value, ..., VendorUpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::VulnerabilityVendor object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

A vendor that generates a vulnerability report.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The name of the vendor.


=head2 Url => Str

The URL of the vulnerability advisory.


=head2 VendorCreatedAt => Str

Indicates when the vulnerability advisory was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 VendorSeverity => Str

The severity that the vendor assigned to the vulnerability.


=head2 VendorUpdatedAt => Str

Indicates when the vulnerability advisory was last updated.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

