package Location::Area::DoCoMo::iArea::Area;

use strict;

sub seek
{
  shift;
  my $arg = shift;
  seek DATA,0,0;
  my ($aid,$said,$name,$wara,$sara,$eara,$nara,$mesh);
  if ($arg =~ /^\d{5}$/)
  {
    ($aid,$said) = $arg =~ /^(\d{3})(\d{2})$/;
    while (my $line = <DATA>)
    {
      my @scan = $line =~ /^$aid,$said,([^,]+),(\d{8,9}),(\d{8,9}),(\d{8,9}),(\d{8,9}),/;
      if (@scan)
      {
        ($name,$wara,$sara,$eara,$nara) = @scan;
        last;
      }
    }
  }
  else
  {
    my ($m2,$m3,$m4,$m5,$m6,$m7) = $arg =~ /^(\d{6})(\d?)(\d?)(\d?)(\d?)(\d?)$/;
    while (my $line = <DATA>)
    {
      my @scan = $line =~ /^(\d{3}),(\d{2}),([^,]+),(\d{8,9}),(\d{8,9}),(\d{8,9}),(\d{8,9}),.*,(${m2}(${m3}(${m4}(${m5}(${m6}${m7}?)?)?)?)?),/;
      if (@scan)
      {
        ($aid,$said,$name,$wara,$sara,$eara,$nara,$mesh) = @scan;
        last;
      }
    }
  }
  return {
    areaid => $aid,
    sub_areaid => $said,
    name => $name,
    west => $wara,
    south => $sara,
    east => $eara,
    north => $nara,
  };
}

1;
__DATA__
001,00,ȡ/,501553125,148856250,508387500,153450000,31,57,71,54,193,621,624010,624011,624020,624021,624022,624023,624032,624033,624043,624053,624054,624055,624056,624057,624064,624065,624066,624067,624074,624075,624076,624160,634003,634004,634005,634012,634013,634021,634031,634052,634062,6240300,6240311,6240421,6240423,6240442,6240443,6240473,6240521,6240631,6240633,6240731,6240733,6240770,6240772,6241402,6241500,6241502,6241503,6241512,6241610,6340022,6340023,6340060,6340061,6340062,6340111,6340112,6340113,6340140,6340141,6340150,6340151,6340160,6340202,6340203,6340220,6340221,6340222,6340230,6340231,6340300,6340301,6340303,6340320,6340322,6340410,6340411,6340420,6340422,6340511,6340513,6340632,6340633,6340642,6340711,6340720,6340721,62391711,62391713,62391731,62391733,62392211,62392711,62392713,62392731,62392733,62393711,62393713,62400032,62400033,62400122,62400123,62400132,62401222,62401223,62401232,62404402,62404403,62404412,62404413,62404502,62404520,62404522,62404523,62404532,62404533,62404622,62404623,62404632,62404633,62404712,62404713,62404722,62404723,62407710,62414002,62414003,62414032,62415010,62415012,62415013,62415102,62415103,62415112,62415130,62415132,62416110,62416112,63400630,63400631,63401420,63401421,63401422,63401430,63401431,63401520,63401521,63401530,63401531,63401620,63401621,63402230,63402231,63402320,63402400,63402402,63406300,63406302,623912323,623912332,623912333,623913222,623922101,623922103,623923000,623923002,624012000,624012002,624012020,624012022,624012200,624012202,624012203,624012212,624012213,624012302,624012303,624150112,624150113,624151002,624151003,624151012,624151013,624151102,624151103,634007000,634007001,634007010,634007011,634022320,634022321,634022330,634022331,634023210,634023211,634023220,634023221,634023300,634023301,634023310,634023311,634024200,634024201,634042300,634042302,634042320,634042322,634063010,634063012,634063030,634063032,623906031,6239123203,6239123212,6239123213,6239123221,6239123223,6239123302,6239123303,6239123312,6239123313,6239132202,6239132203,6239171011,6239171013,6239171031,6239171033,6239171211,6239171213,6239171231,6239171233,6239173011,6239173013,6239173031,6239173033,6239173211,6239173213,6239173231,6239173233,6239221001,6239221003,6239221021,6239221023,6239221201,6239221210,6239221211,6239221300,6239221301,6239221310,6239221311,6239230200,6239230201,6239271011,6239271013,6239271031,6239271033,6239271211,6239271213,6239271231,6239271233,6239273011,6239273013,6239273031,6239273033,6239273211,6239273213,6239273231,6239273233,6239371011,6239371013,6239371031,6239371033,6239371211,6239371213,6239371231,6239371233,6240003022,6240003023,6240003032,6240003033,6240003122,6240003123,6240003132,6240003133,6240012022,6240012023,6240012032,6240012033,6240012122,6240012123,6240012132,6240012133,6240013022,6240013023,6240013032,6240013033,6240013122,6240013300,6240013302,6240013320,6240013322,6240120010,6240120012,6240120030,6240120032,6240120210,6240120212,6240120230,6240120232,6240122010,6240122012,6240440022,6240440023,6240440032,6240440033,6240440122,6240440123,6240440132,6240440133,6240441022,6240441023,6240441032,6240441033,6240441122,6240441123,6240441132,6240441133,6240450022,6240450023,6240450032,6240450033,6240771100,6240771102,6240771120,6240771122,6240771200,6240771201,6240771210,6240771211,6240771300,6241403300,6241403302,6241403320,6241403322,6241501100,6241501102,6241612000,6241612001,6241612010,6241612011,6241612100,6241612101,6241612110,6241612111,6241613000,6241613001,6241613010,6241613011,6340142300,6340142302,6340142320,6340142322,6340232120,6340232122,6340232300,6340232302,6340240100,6340240102,6340240120,6340240122,6340240300,6340240302,6340240320,6340240322,6340242100,6340242102,6340532222,6340532223,6340532232,6340532233,6340532322,6340532323,6340630332,6340630333,6340631222,6340631223,6340631232,6340631233,6340631322,6340631323,6340631332,6340631333,6340640222,6340640223,6340640232,6340640233,6340640322,6340640323,6340640332,6340640333,6239061202,6239061200,6239060132,6239060133,6239061022,62390732332,62390732333,62390733222,62390733223,62390733232,62390733233,62390733322,62390733323,62390733332,62390733333,62391232012,62391232013,62391232102,62391232103,62391232112,62391232113,62391233002,62391233003,62391233012,62391233013,62391233102,62391233103,62391233112,62391233113,62391322002,62391322003,62391322012,62391322013,62400022222,62400022223,62400022232,62400022233,62400022322,62400022323,62400022332,62400022333,62400023222,62400023223,62400023232,62400023233,62400023322,62400023323,62400023332,62400023333,62400133232,62400133233,62400133322,62400133323,62400133332,62400133333,62400222222,62400222223,62400222232,62400222233,62400222322,62400222323,62400222332,62401200110,62401200112,62401200130,62401200132,62401200310,62401200312,62401200330,62401200332,62401202110,62401202112,62401202130,62401202132,62401202310,62401202312,62401202330,62401202332,62401220110,62401220112,62401220130,62401220132,62401233222,62401233223,62401233232,62401233233,62401233322,62401233323,62401233332,62401233333,62401322222,62401322223,62401322232,62401322233,62401322322,62401322323,62401322332,62401322333,62401323222,62401323223,62401323232,62401323233,62401323322,62401323323,62401323332,62401323333,62401332222,62401332223,62401332232,62401332233,62401332322,62401332323,62401332332,62401332333,62401333222,62401333223,62401333232,62401333233,62401333322,62401333323,62401333332,62401333333,62401422222,62402400000,62402400002,62402400020,62402400022,62402400200,62402400202,62402400220,62402400222,62402402000,62402402002,62402402020,62402402022,62402402200,62402402202,62402402220,62402402222,62402420000,62402420002,62402420020,62402420022,62402420200,62402420202,62402420220,62402420222,62402422000,62402422002,62402422020,62402422022,62402422200,62402422202,62402422220,62402422222,62403400000,62403400002,62403400020,62403400022,62403400200,62403400202,62403400220,62403400222,62403402000,62403402002,62403402020,62403402022,62403402200,62403402202,62403402220,62403402222,62403420000,62403420002,62403420020,62403420022,62403420200,62403420202,62403420220,62403420222,62403422000,62403422002,62403422020,62403422022,62403422200,62403422202,62403422220,62403422222,62404400000,62404400002,62404400020,62404400022,62404400200,62404400202,62404501220,62404501222,62404503000,62404503002,62404503020,62404503022,62404503200,62404503202,62404503220,62404503222,62404521000,62404521002,62404521020,62404521022,62404521200,62404521202,62404521220,62404521222,62404521223,62404521232,62404521233,62404521322,62404521323,62404521332,62404521333,62404530222,62404530223,62404530232,62404530233,62404530322,62404530323,62404530332,62404530333,62404531222,62404531223,62404531232,62404531233,62404531322,62404531323,62404531332,62404531333,62404620222,62404620223,62404620232,62404620233,62404620322,62404620323,62404620332,62404620333,62404621222,62404621223,62404621232,62404621233,62404621322,62404621323,62404621332,62404621333,62404630222,62404630223,62404630232,62404630233,62404630322,62404630323,62404630332,62404630333,62404631222,62404631223,62404631232,62404631233,62404631322,62404631323,62404631332,62404631333,62404703111,62404703113,62404703131,62404703133,62404703311,62404703313,62404703331,62404703333,62404720222,62404720223,62404720232,62404720233,62404720322,62404720323,62404720332,62404720333,62404721111,62404721113,62404721131,62404721133,62404721222,62404721223,62404721232,62404721233,62404721311,62404721313,62404721322,62404721323,62404721331,62404721332,62404721333,62407711010,62407711012,62407711030,62407711032,62407711210,62407711212,62407711230,62407711232,62407712020,62407712022,62407712200,62407712202,62407712220,62407712222,62407713010,62407713012,62407730000,62407730002,62407730020,62407730022,62407730200,62407730202,62407730220,62407730222,62407732000,62407732002,62407732020,62407732022,62407732200,62407732202,62407732220,62407732222,62414012000,62414012002,62414012020,62414012022,62414012200,62414012202,62414012220,62414012222,62414030000,62414030002,62414030020,62414030022,62414030200,62414030202,62414030220,62414030222,62414030223,62414030232,62414030233,62414030322,62414030323,62414030332,62414030333,62414031222,62414031223,62415011032,62415011033,62415011122,62415011123,62415011132,62415011133,62415100022,62415100023,62415100032,62415100033,62415100122,62415100123,62415100132,62415100133,62415101022,62415101023,62415101032,62415101033,62415101122,62415101123,62415101132,62415101133,62415110022,62415110023,62415110032,62415110033,62415110122,62415110123,62415110132,62415110133,62416120020,62416120021,62416120022,62416120030,62416120031,62416120120,62416120121,62416120130,62416120131,62416120200,62416120202,62416120220,62416120222,62416121020,62416121021,62416121030,62416121031,62416121120,62416121121,62416121130,62416121131,62416122000,62416122002,62416122020,62416122022,62416122200,62416122202,62416122220,62416122222,62416130020,62416130021,62416130030,62416130031,62416130120,62416130121,62416130130,62416130131,63400632000,63400632001,63400632002,63400632010,63400632011,63400632020,63400632022,63400632100,63400632101,63400632110,63400632111,63400632200,63400632202,63400632220,63400632222,63400633000,63400633001,63400633010,63400633011,63400633100,63400633101,63400633110,63400633111,63400700200,63400700201,63400700202,63400700210,63400700211,63400700220,63400700222,63400700300,63400700301,63400700310,63400700311,63400701200,63400701201,63400701210,63400701211,63400701300,63400701301,63400701310,63400701311,63400702000,63400702002,63400702020,63400702022,63400702200,63400702202,63400702220,63400702222,63400710000,63400710002,63400710020,63400710022,63400710200,63400720000,63400720002,63400720020,63400720022,63400720200,63400720202,63400720220,63400720222,63400722000,63401610000,63401610002,63401610020,63401610022,63401610200,63401610202,63401610220,63401610222,63401612000,63401612002,63401612020,63401612022,63401612200,63401612202,63401612220,63401612222,63401630000,63401630002,63401630020,63401630022,63401630200,63401630202,63401630220,63401630222,63402232200,63402232201,63402232202,63402232210,63402232211,63402232220,63402232222,63402232300,63402232301,63402232310,63402232311,63402233200,63402233201,63402233210,63402233211,63402233300,63402233301,63402233310,63402233311,63402321210,63402321212,63402321230,63402321232,63402322200,63402322201,63402322210,63402322211,63402322300,63402322301,63402322310,63402322311,63402323010,63402323012,63402323030,63402323032,63402323200,63402323201,63402323210,63403210000,63403210002,63403210020,63403210022,63403210200,63403210202,63403210220,63403210222,63403212000,63403212002,63403212020,63403212022,63403212200,63403212202,63403212220,63403212222,63403230000,63403230002,63403230020,63403230022,63403230200,63403230202,63403230220,63403230222,63403232000,63403232002,63403232020,63403232022,63403232200,63403232202,63403232220,63403232222,63404210000,63404210002,63404210020,63404210022,63404210200,63404210202,63404210220,63404210222,63404212000,63404212002,63404212020,63404212022,63404212200,63404212202,63404212220,63404212222,63404212223,63404212232,63404212233,63404232322,63404232323,63404232332,63404232333,63404233222,63404233223,63404233232,63404233233,63404233322,63404233323,63404233332,63404233333,63405322202,63405322203,63405322212,63405322213,63405322302,63405322303,63405322312,63405322313,63405323202,63405323203,63405323212,63405323213,62390603013,62390603011,62390603021,62390603003,
001,01,/ɰ,501806250,149700000,505575000,153450000,18,55,24,48,83,374,624040,624041,624051,624061,624062,624071,624072,633927,633936,633937,633947,633957,633967,634001,634010,634040,634050,634061,6240301,6240302,6240303,6240310,6240312,6240313,6240420,6240422,6240501,6240503,6240520,6240522,6240523,6240630,6240632,6240730,6240732,6339033,6339042,6339131,6339133,6339140,6339142,6339172,6339173,6339231,6339233,6339240,6339242,6339262,6339263,6339460,6339461,6339463,6339561,6339563,6339661,6339663,6339761,6339770,6340001,6340003,6340020,6340021,6340110,6340200,6340201,6340302,6340412,6340413,6340510,6340512,6340600,6340601,6340710,62393731,62393733,62405001,62405003,62406011,62406013,62406031,62406033,62407011,62407013,62407031,62407033,63390321,63390323,63391301,63391303,63391321,63391323,63392301,63392303,63392321,63392323,63392612,63392613,633903201,633903203,633903221,633903223,633904300,633904302,633904320,633904322,633913001,633913003,633913021,633913023,633913201,633913203,633913221,633913223,633914100,633914102,633914120,633914122,633914300,633914302,633914320,633914322,633917111,633917113,633917131,633917133,633923001,633923003,633923021,633923023,633923201,633923203,633923221,633923223,633924100,633924102,633924120,633924122,633924300,633924302,633924320,633924322,634000211,634000213,634000231,634000233,6239373011,6239373013,6239373031,6239373033,6239373211,6239373213,6239373231,6239373233,6239471011,6239471100,6239471101,6239471110,6239471111,6240502111,6240502113,6240502131,6240502133,6240502311,6240502313,6240502331,6240502333,6240703222,6240703223,6240703232,6240703233,6339073323,6339073332,6339073333,6339170222,6339170223,6339170232,6339170233,6339170322,6339170323,6339170332,6339170333,6339171101,6339171103,6339171121,6339171123,6339171222,6339171223,6339171232,6339171233,6339171301,6339171303,6339171321,6339171322,6339171323,6339261022,6339261023,6339261032,6339261033,6339261122,6339261123,6339261132,6339261133,6339662331,6339662333,6339760111,6339760113,6339760131,6339760133,6339760311,6339760313,6339760331,6339760333,6340000323,6340000332,6340000333,6340002101,6340002103,6340002121,6340002123,6340002222,6340002223,6340002232,6340002233,6340002301,6340002303,6340002321,6340002322,6340002323,62394711131,62394711133,62394711311,62394711313,62394711331,62394711333,62394713111,62394713113,62394713131,62394713133,62394713311,62394713313,62394713331,62394713333,62394731111,62394731113,62394731131,62394731133,62394731311,62394731313,62394731331,62394731333,62394733111,62394733113,62394733131,62394733133,62394733311,62394733313,62394733331,62394733333,62405000111,62405000113,62405000131,62405000133,62405000311,62405000313,62405000331,62405000333,62405002111,62405002113,62405002131,62405002133,62405002311,62405002313,62405002331,62405002333,62405020111,62405021000,62405021001,62405021010,62405021011,62405021100,62405021101,62406001110,62406001111,62406010000,62406010001,62406010010,62406010011,62406010100,62406010101,62406010110,62406010111,62407032202,62407032203,62407032212,62407032213,62407032302,62407032303,62407032312,62407032313,63390302322,63390302323,63390302332,63390302333,63390303222,63390303223,63390303232,63390303233,63390303322,63390303323,63390303332,63390303333,63390312222,63390312223,63390312232,63390312233,63390312322,63390312323,63390312332,63390312333,63390313222,63390313223,63390313232,63390313233,63390313322,63390313323,63390313332,63390313333,63390402222,63390402223,63390402232,63390402233,63390402322,63390402323,63390402332,63390402333,63390403222,63390403223,63390403232,63390403233,63390403322,63390403323,63390403332,63390403333,63390412222,63390412223,63390412232,63390412233,63390733221,63390733223,63391613313,63391613331,63391613333,63391631111,63391631113,63391631131,63391631133,63391631311,63391631313,63391631331,63391631333,63391633111,63391633113,63391633131,63391633133,63391633311,63391633313,63391633331,63391633333,63391702202,63391702203,63391702212,63391702213,63391702302,63391702303,63391702312,63391702313,63391703202,63391703203,63391703212,63391703213,63391703302,63391703303,63391703312,63391703313,63391711001,63391711003,63391711021,63391711023,63391711201,63391711203,63391711221,63391711223,63391712202,63391712203,63391712212,63391712213,63391712302,63391712303,63391712312,63391712313,63391713001,63391713003,63391713021,63391713023,63391713201,63391713202,63391713203,63392531111,63392531113,63392531131,63392531133,63392531311,63392531313,63392531331,63392531333,63392533111,63392533113,63392533131,63392533133,63392533311,63392533313,63392533331,63392533333,63392601331,63392601333,63392603111,63392603113,63392603131,63392603133,63392603311,63392603313,63392603331,63392603333,63392611111,63392611113,63392611131,63392611133,63392611311,63392611313,63393511111,63393511113,63393511131,63393511133,63393511311,63393511313,63393511331,63393511333,63393513111,63393513113,63393513131,63393513133,63393513311,63393513313,63393513331,63393513333,63393531111,63393531113,63393531131,63393531133,63393531311,63393531313,63393531331,63393531333,63393533111,63393533113,63393533131,63393533133,63393533311,63393533313,63393533331,63393533333,63394511111,63394511113,63394511131,63394511133,63394511311,63394511313,63394511331,63394511333,63394513111,63394513113,63394513131,63394513133,63394513311,63394513313,63394513331,63394513333,63394531111,63394620000,63394620001,63394620010,63394620011,63394620100,63394620101,63394620110,63394620111,63394621000,63394621001,63394621010,63394621011,63394621100,63394621101,63394621110,63394621111,63394621113,63394621131,63394621133,63394621311,63394621313,63394621331,63394621333,63394623111,63394623113,63394623131,63394623133,63394623311,63394623313,63394623331,63394623333,63395601111,63395601113,63395601131,63395601133,63395601311,63395601313,63395601331,63395601333,63395603111,63395603113,63395603131,63395603133,63395603311,63395603313,63395603331,63395603333,63395621111,63395621113,63395621131,63395621133,63395621311,63395621313,63395621331,63395621333,63395623111,63395623113,63395623131,63395623133,63395623311,63395623313,63395623331,63395623333,63396601111,63396601113,63396601131,63396601133,63396601311,63396601313,63396601331,63396601333,63396603111,63396603113,63396603131,63396603133,63396603311,63396603313,63396603331,63396603333,63396621111,63396621113,63396621131,63396621133,63396621311,63396621313,63396621331,63396621333,63396623111,63396623113,63396623131,63396623133,63400003203,63400003212,63400003213,63400003221,63400003223,63400003302,63400003303,63400003312,63400003313,63400021001,63400021003,63400021021,63400021023,63400021201,63400021203,63400021221,63400021223,63400023001,63400023003,63400023021,63400023023,63400023201,63400023203,
002,01,î/,503325000,153150000,508500000,156159375,38,60,11,14,20,550,634070,634073,644001,644002,644003,644006,644011,644012,644013,644014,644015,644016,644017,644023,644024,644025,644026,644027,644034,644035,644036,644037,644044,644045,644046,644047,644054,644055,644056,644057,644063,644064,644065,644066,644067,644073,644074,644150,6339763,6339771,6339772,6339773,6340602,6340603,6340712,6340713,6340722,6340723,6340740,6340742,6439061,6439070,6439071,6440000,6440001,6440003,6440040,6440042,6440043,6440052,6440053,6440071,6440072,6440073,6440101,6440103,6440221,6440330,6440331,6440333,6440433,6440523,6440531,6440532,6440533,6440621,6440623,6440721,6440723,6440750,6441002,6441100,6441102,6441200,6441201,6441202,6441300,6441402,6441512,6441600,6441601,6441602,6441611,6441613,6540031,6540040,6441513,6441510,64400021,64402231,64402233,64405212,64405213,64405302,64405303,65400210,65400211,65400300,65400301,644022010,644022011,644043111,644043113,644043131,644043133,644075100,644075101,644075110,644075111,644075200,644075201,644075210,644075211,6440220120,6440220121,6440220130,6440220131,6440751020,6440751021,6440751030,6440751031,6440751120,6440751121,6440751130,6440751131,6440752020,6440752021,6440752030,6440752031,6440752120,6440752121,6440752130,6440752131,64390731111,64400020000,64400020001,64400020010,64400020011,64400020100,64400020101,64400020110,64400020111,64400020113,64400020131,64400020133,64400020311,64400020313,64400020331,64400020333,64400022111,64400023000,64400023001,64400023010,64400023011,64400023100,64400023101,64400023110,64400023111,64402010000,64402010001,64402010010,64402010011,64402010100,64402010101,64402010110,64402010111,64402011000,64402011001,64402011010,64402011011,64402011100,64402011101,64402011110,64402011111,64402100000,64402100001,64402100010,64402100011,64402100100,64402100101,64402100110,64402100111,64402101000,64402101001,64402101010,64402101011,64402101100,64402101101,64402101110,64402101111,64402110000,64402110001,64402110010,64402110011,64402110100,64402110101,64402110110,64402110111,64402111000,64402111001,64402111010,64402111011,64402111100,64402111101,64402111110,64402111111,64402200000,64402200001,64402200010,64402200011,64402200100,64402200101,64402200110,64402200111,64402200113,64402200131,64402200133,64402200311,64402200313,64402200331,64402201220,64402201221,64402201230,64402201231,64402201320,64402201321,64402201330,64402201331,64402201333,64402203111,64402203113,64402203131,64402203133,64402203311,64402203313,64402203331,64402203333,64402221111,64402230000,64402230001,64402230010,64402230011,64402230100,64402230101,64402230110,64402230111,64402230113,64402230131,64402230133,64402230311,64402230313,64402230331,64402230333,64402232111,64402232113,64402232131,64402232133,64402232311,64402232313,64402232331,64402232333,64403210111,64403211000,64403211001,64403211010,64403211011,64403211100,64403211101,64403211110,64403211111,64403211113,64403211131,64403211133,64403211311,64403211313,64403211331,64403211333,64403213111,64403213113,64403213131,64403213133,64403213311,64403213313,64403213331,64403213333,64404310000,64404310001,64404310010,64404310011,64404310100,64404310101,64404310110,64404310111,64404311000,64404311001,64404311010,64404311011,64405201333,64405203111,64405203113,64405203131,64405203133,64405203311,64405203313,64405203331,64405203333,64405210222,64405210223,64405210232,64405210233,64405210322,64405210323,64405210332,64405210333,64405211222,64405211223,64405211232,64405211233,64405211322,64405211323,64405211332,64405211333,64405221111,64405221113,64405221131,64405221133,64405221311,64405221313,64405221331,64405221333,64405223111,64405223113,64405223131,64405223133,64405223311,64405223313,64405223331,64405223333,64405300222,64405300223,64405300232,64405300233,64405300322,64405300323,64405300332,64405300333,64405301222,64405301223,64405301232,64405301233,64405301322,64405301323,64405301332,64405301333,64406201111,64406201113,64406201131,64406201133,64406201311,64406201313,64406201331,64406201333,64406203111,64406203113,64406203131,64406203133,64406203311,64406203313,64406203331,64406203333,64406221111,64406221113,64406221131,64406221133,64406221311,64406221313,64406221331,64406221333,64406223111,64406223113,64406223131,64406223133,64406223311,64406223313,64406223331,64406223333,64407201111,64407201113,64407201131,64407201133,64407201311,64407201313,64407201331,64407201333,64407203111,64407203113,64407203131,64407203133,64407203311,64407203313,64407203331,64407203333,64407221111,64407221113,64407221131,64407221133,64407221311,64407221313,64407221331,64407221333,64407223111,64407223113,64407223131,64407223133,64407223311,64407223313,64407223331,64407223333,64407510220,64407510221,64407510230,64407510231,64407510320,64407510321,64407510330,64407510331,64407511220,64407511221,64407511230,64407511231,64407511320,64407511321,64407511330,64407511331,64407520220,64407520221,64407520222,64407520230,64407520231,64407520320,64407520321,64407520330,64407520331,64407521220,64407521221,64407521230,64407521231,64407521320,64407521321,64407521330,64407521331,64407522000,64407522002,64407522020,64407522022,64407522200,64407522202,64407522220,64407522222,64407600000,64407600002,64407600020,64407600022,64407600200,64407600202,64407600220,64416030000,64416030001,64416030002,64416030010,64416030011,64416030020,64416030022,64416030100,64416030101,64416030110,64416030111,64416030200,64416030202,64416030220,64416030222,64416031000,64416031001,64416031010,64416031011,64416031100,64416031101,64416031110,64416031111,64416032000,64416032002,64416032020,64416032022,64416032200,64416032202,64416032220,64416032222,64416100000,64416100001,64416100002,64416100010,64416100011,64416100020,64416100022,64416100100,64416100101,64416100110,64416100111,64416100200,64416100202,64416100220,64416100222,64416101000,64416101001,64416101010,64416101011,64416101100,64416101101,64416101110,64416101111,64416101113,64416101131,64416101133,64416101311,64416101313,64416101331,64416101333,64416102000,64416102002,64416102020,64416102022,64416102200,64416102202,64416102220,64416102222,64416103111,64416103113,64416103131,64416103133,64416103311,64416103313,64416103331,64416103333,64416120000,64416121111,64416121113,64416121131,64416121133,64416121311,64416121313,64416121331,64416121333,64416123111,64416123113,64416123131,64416123133,64416123311,64416123313,64416123331,64416123333,64417101111,64417110000,64417110001,64417110010,64417110011,64417110100,64417110101,64417110110,64417110111,64417111000,64417111001,64417111010,64417111011,64417111100,64417111101,64417111110,64417111111,65400201111,65400201113,65400201131,65400201133,65400201311,65400201313,65400201331,65400201333,65400203111,65400212000,65400212001,65400212010,65400212011,65400212100,65400212101,65400212110,65400212111,65400213000,65400213001,65400213010,65400213011,65400213100,65400213101,65400213110,65400213111,65400302000,65400302001,65400302010,65400302011,65400302100,65400302101,65400302110,65400302111,65400303000,65400303001,65400303010,65400303011,65400303100,65400303101,65400303110,65400303111,65400330000,65400330001,65400330010,65400330011,65400330100,65400330101,65400330110,65400330111,65400331000,65400331001,65400331010,65400331011,65400331100,65400331101,65400331110,65400331111,65400410000,65400410001,65400410002,65400410010,65400410011,65400410020,65400410022,65400410100,65400410101,65400410110,65400410111,65400410200,65400410202,65400410220,65400410222,65400411000,65400411001,65400411010,65400411011,65400411100,65400411101,65400411110,65400411111,65400412000,65400412002,65400412020,65400412022,65400412200,65400412202,65400412220,65400412222,65400420000,65400420001,65400420010,65400420011,65400420100,65400420101,65400420110,65400420111,65400421000,65400421001,65400421010,65400421011,65400421100,65400421101,65400421110,65400421111,65400430000,65400500000,
002,02,Ѿ/,506025000,152240625,512325000,154650000,32,49,2,8,34,155,634047,634057,634066,634067,634075,634076,634077,634140,634150,634151,634160,634161,634162,634170,634171,634172,634173,634174,634175,634176,634177,634270,644104,644105,644106,644107,644116,644117,644200,644210,644211,644221,6340372,6340373,6340561,6340562,6340563,6340643,6340652,6340653,6340741,6340743,6341302,6341303,6341412,6341522,6341632,6341672,6341673,6342602,6440041,6440050,6440051,6440070,6441000,6441001,6441003,6441010,6441012,6441020,6441030,6441031,6441033,6441101,6441103,6441110,6441261,6441263,6441270,6441272,6442010,6442012,6442013,6442120,6442122,6442201,6442220,6442222,6442310,6442311,6442320,63416330,63416332,634163000,634163002,634163020,634163022,634163310,634163312,634163330,634163332,6340463222,6340463223,6340463232,6340463233,6340463322,6340463323,6340463332,6340463333,6341413222,6341413223,6341413232,6341413233,6341413322,6341413323,6341413332,6341413333,6341523222,6341523223,6341523232,6341523233,6341523322,6341523323,6341523332,6341523333,6341532222,6341532223,6341633110,6341633112,6341633130,6341633132,6341633310,6341633312,6341633330,6341633332,63403702222,63403702223,63403702232,63403702233,63403702322,63403702323,63403702332,63403702333,63403703222,63403703223,63403703232,63403703233,63403703322,63403703323,63403703332,63403703333,63403712222,63403712223,63403712232,63403712233,63403712322,63403712323,63403712332,63403712333,63403713222,63403713223,63403713232,63403713233,63403713322,63403713323,63403713332,63403713333,63406512222,63406512223,63406512232,63406512233,63406512322,63406512323,63406512332,63406512333,63406513222,63406513223,63406513232,63406513233,63406513322,63406513323,63406513332,63406513333,63413002222,63413002223,63413002232,63413002233,63413002322,63413002323,63413002332,63413002333,63413003222,63413003223,63413003232,63413003233,63413003322,63413003323,63413003332,63413003333,63413012222,63413012223,63413012232,63413012233,63413012322,63413012323,63413012332,63413012333,63413013222,63413013223,63413013232,63413013233,63413013322,63413013323,63413013332,63413013333,63414102222,63414102223,63414102232,63414102233,63414102322,63414102323,63414102332,63414102333,63414103222,63414103223,63414103232,63414103233,63414103322,63414103323,63414103332,63414103333,63416302322,63416302323,63416302332,63416302333,63416303222,63416303223,63416303232,63416303233,63416303322,63416303323,63416303332,63416303333,63416312222,63416312223,63416312232,63416312233,63416312322,63416312323,63416312332,63416312333,63416313222,63416313223,63416313232,63416313233,63416313322,63416313323,63416313332,63416331110,63416331112,63416331130,63416331132,63416331310,63416331312,63416331330,63416331332,63416333110,63416333112,63416333130,63416333132,63416333310,63416333312,63416333330,63416333332,63416631111,63416631113,63416631131,63416631133,63416631311,63416631313,63416631331,63416631333,63416633111,63416633113,63416633131,63416633133,63416633311,63416633313,63416633331,63416633333,
002,03,丫/,509400000,154200000,512550000,160050000,49,80,0,0,0,0,644136,644137,644145,644146,644147,644156,644157,644166,644167,644176,644177,644230,644240,644241,644250,644251,644260,644261,644270,644271,654105,654106,654107,654116,654117,654125,654126,654127,654135,654136,654137,654145,654146,654147,654157,654167,654200,654201,654210,654211,654212,654220,654221,654230,654240,654250,654260,654270,664241,6441271,6441273,6441351,6441352,6441353,6441441,6441551,6441552,6441553,6441650,6441651,6441653,6441751,6441752,6441753,6442200,6442202,6442203,6442312,6442313,6442322,6442420,6442622,6442720,6442722,6541151,6541153,6541341,6541342,6541343,6541440,6541441,6541551,6541560,6541561,6541563,6541770,6541771,6541773,6542020,6542022,6542023,6542220,6542222,6542310,6542311,6542312,6542320,6542410,6542412,6542510,6542512,6542610,6542710,6542712,6542713,6642001,6642003,6642010,6642012,6642101,6642103,6642110,6642112,6642201,6642203,6642210,6642212,6642301,6642303,6642310,6642312,6642313,6642322,6642401,6642403,6642420,6642501,6642510,6642511,
002,04,/,510960937,150900000,516178125,154800000,46,41,0,0,49,385,634217,634225,634226,634227,634234,634235,634236,634237,634242,634243,634244,634245,634246,634247,634251,634252,634253,634254,634255,634256,634261,634262,634263,634264,634265,634271,634272,634273,634274,634275,634301,634310,634311,634312,634320,644202,644203,644204,644205,644213,644214,644215,644223,644224,644225,644235,6243711,6243712,6243713,6243720,6243722,6341671,6342073,6342162,6342163,6342242,6342243,6342323,6342331,6342332,6342333,6342413,6342502,6342503,6342600,6342601,6342603,6342660,6342661,6342662,6342760,6343001,6343002,6343003,6343020,6343022,6343023,6343210,6343212,6343300,6343301,6343302,6442011,6442121,6442123,6442221,6442341,6341573222,6341573223,6341573232,6341573233,6341573322,6341573323,6341573332,6341573333,6342160222,6342160223,6342160232,6342160233,6342160322,6342160323,6342160332,6342160333,6342161222,6342161223,6342161232,6342161233,6342161322,6342161323,6342161332,6342161333,6342500222,6342500223,6342500232,6342500233,6342500322,6342500323,6342500332,6342500333,6342501222,6342501223,6342501232,6342501233,6342501322,6342501323,6342501332,6342501333,6343130222,6343132000,6343132002,6343132020,6343132022,6343132200,6343132202,6343132220,6343132222,62437032222,62437032223,62437032232,62437032233,62437032322,62437032323,62437032332,62437032333,62437033222,62437033223,62437033232,62437033233,62437033322,62437033323,62437033332,62437033333,62437210000,62437210002,62437210020,62437210022,62437210200,62437210202,62437210220,62437210222,62437212000,62437212002,62437212020,62437212022,62437212200,62437212202,62437212220,62437212222,62437230000,62437230002,62437230020,62437230022,62437230200,62437230202,62437230220,62437230222,62437232000,62437232002,62437232020,62437232022,62437232200,62437232202,62437232220,62437232222,63415713331,63415713333,63415723331,63415723333,63415731111,63415731113,63415731131,63415731133,63415731311,63415731313,63415731331,63415731333,63415733111,63415733113,63415733131,63415733133,63415733311,63415733313,63416701111,63416701113,63416701131,63416701133,63416701311,63416701313,63416701331,63416701333,63416703111,63416703113,63416703131,63416703133,63416703311,63416703313,63416703331,63416703333,63420633333,63420712222,63420712223,63420712232,63420712233,63420712322,63420712323,63420712332,63420712333,63420713222,63420713223,63420713232,63420713233,63420713322,63420713323,63420713332,63420713333,63420722222,63420722223,63420722232,63420722233,63420722322,63420722323,63420722332,63420722333,63420723222,63420723223,63420723232,63420723233,63420723322,63420723323,63420723332,63420723333,63421522222,63421522223,63421522232,63421522233,63421522322,63421522323,63421522332,63421522333,63421523222,63421523223,63421523232,63421523233,63421523322,63421523323,63421523332,63421523333,63421532222,63421532223,63421532232,63421532233,63421532322,63421532323,63421532332,63421532333,63421533222,63421533223,63421533232,63421533233,63421533322,63421533323,63421533332,63421533333,63421611111,63421611113,63421611131,63421611133,63421611311,63421611313,63421611331,63421611333,63421613111,63421613113,63421613131,63421613133,63421613311,63421613313,63422323333,63422332222,63422332223,63422332232,63422332233,63422332322,63422332323,63422332332,63422332333,63422333222,63422333223,63422333232,63422333233,63422333322,63422333323,63422333332,63422333333,63422402222,63422402223,63422402232,63422402233,63422402322,63422402323,63422402332,63422402333,63422403222,63422403223,63422403232,63422403233,63422403322,63422403323,63422403332,63422403333,63422412222,63422412223,63422412232,63422412233,63422412322,63422412323,63422412332,63422412333,63422413222,63422413223,63422413232,63422413233,63422413322,63422413323,63422413332,63422413333,63423133333,63423212222,63423212223,63423212232,63423212233,63423212322,63423212323,63423212332,63423212333,63423213222,63423213223,63423213232,63423213233,63423213322,63423213323,63423213332,63423213333,63423222222,63423222223,63423222232,63423222233,63423222322,63423222323,63423222332,63423222333,63423223222,63423223223,63423223232,63423223233,63423223322,63423223323,63423223332,63423223333,63423301111,63423301113,63423301131,63423301133,63423301311,63423301313,63423301331,63423301333,63423302222,63423302223,63423302232,63423302233,63423302322,63423302323,63423302332,63423302333,63423303111,63423303113,63423303131,63423303133,63423303222,63423303223,63423303232,63423303233,63423303311,63423303313,63423303322,63423303323,63423303331,63423303332,63423303333,63424111111,63424111113,63424111131,63424111133,63424111311,63424111313,63424111331,63424111333,63424112222,63424112223,63424112232,63424112233,63424112322,63424112323,63424112332,63424112333,63424113111,63424113113,63424113131,63424113133,63424113222,63424113223,63424113232,63424113233,63424113311,63424113313,63424113322,63424113323,63424113331,63424113332,63424113333,63424122222,63424122223,63424122232,63424122233,63424122322,63424122323,63424122332,63424122333,63424123222,63424123223,63424123232,63424123233,63424123322,63424123323,63424123332,63424123333,63430002222,63430002223,63430002232,63430002233,63430002322,63430002323,63430002332,63430002333,63430003222,63430003223,63430003232,63430003233,63430003322,63430003323,63430003332,63430003333,63430210000,63430210002,63430210020,63430210022,63430210200,63430210202,63430210220,63430210222,63430212000,63430212002,63430212020,63430212022,63430212200,63430212202,63430212220,63430212222,63430212223,63430212232,63430212233,63430212322,63430212323,63430212332,63430212333,63430213222,63430213223,63430213232,63430213233,63430213322,63430213323,63430213332,63430213333,63430302222,63430320000,63430320002,63430320020,63430320022,63430320200,63430320202,63430320220,63430320222,63430322000,63430322002,63430322020,63430322022,63430322200,63430322202,63430322220,63430322222,
002,05,̹//,508275000,153600000,510525000,154950000,7,15,5,18,22,20,644112,644113,644114,644115,644125,644124,644134,6441011,6441022,6441021,6441013,6441032,6441260,6441262,6441350,6441111,6441233,6441023,6441231,6441230,6441221,6441220,64411131,64414403,64414401,64413311,64413313,644123211,644123210,644123201,644123200,644144001,644144003,644144021,644144023,644144000,644133333,644133331,644133313,644133311,644133310,644133103,644133101,644123231,644123213,6441431133,6441232330,6441440223,6441440221,6441440021,6441440020,6441431131,6441431113,6441431111,6441431110,6441333123,6441333121,6441331233,6441331231,6441331213,6441331211,6441331021,6441331003,6441331001,6441331000,6441232333,6441232331,64414402032,64414400231,64414311123,64413333231,64413333031,64413333013,64413333011,64413333010,64413331203,64413331201,64413331200,64414402033,64414400230,64414400221,64414400220,64414400233,64414402011,64414402013,64414402031,64414311121,
002,06,ڱؼ,508837500,155006250,508907812,155043750,0,0,0,0,2,7,6441423300,6441423301,64414233100,64414231322,64414231233,64414231223,64414231232,64414231222,64414231220,
002,07,̸,508809375,154987500,508907812,155015625,0,0,0,0,2,7,6441423031,6441423120,64414231302,64414231213,64414231212,64414231320,64414231230,64414231231,64414231221,
002,08,,508865625,154978125,508907812,154996875,0,0,0,0,0,6,64414231300,64414231211,64414231210,64414231032,64414231033,64414231122,
002,09,,508865625,154931250,508921875,154978125,0,0,0,0,1,10,6441423101,64414231103,64414231102,64414231100,64414213322,64414213320,64414231030,64414231031,64414231120,64414231121,64414213233,
002,10,/߻/,508654687,154893750,508837500,155090625,0,0,0,4,18,21,644142302,644142211,644142300,644142122,6441423030,6441423032,6441423210,6441423201,6441422131,6441423012,6441423010,6441420332,6441420333,6441421232,6441421230,6441420331,6441421212,6441423212,6441423230,6441421203,6441423211,6441423033,64414221331,64414221333,64414221330,64414232031,64414232033,64414221303,64414221301,64414221033,64414221300,64414221031,64414221013,64414221011,64414203233,64414203231,64414203303,64414203301,64414221211,64414232130,64414232211,64414232213,64414232320,
002,11,,508893750,154978125,509020312,155043750,0,0,0,0,2,17,6441423311,6441432200,64414231303,64414231312,64414231330,64414231321,64414231323,64414233101,64414233102,64414233103,64414231332,64414231333,64414320222,64414322010,64414322012,64414322013,64414322102,64414231301,64414231123,
002,12,ɡ/,508753125,154800000,508893750,154987500,0,0,0,0,23,15,6441423013,6441423102,6441423011,6441423100,6441421233,6441421322,6441421321,6441421320,6441421231,6441421303,6441421302,6441421213,6441421300,6441421120,6441421102,6441421122,6441421211,6441421033,6441421031,6441421201,6441421210,6441421032,6441421023,64414213012,64414213010,64414211232,64414211230,64414211212,64414211210,64414211032,64414211002,64414211000,64414210113,64414210131,64414210133,64414213232,64414213230,64414213231,
002,13,24/,508725000,155043750,508893750,155156250,0,0,0,0,12,25,6441423303,6441423302,6441423320,6441423322,6441521100,6441521011,6441521012,6441521013,6441521102,6441521021,6441423231,6441423233,64414233212,64414233210,64414233230,64414233232,64415210101,64415210103,64415210102,64415210031,64415210033,64415211200,64415211201,64415210310,64415210311,64415210300,64415210301,64415210032,64415210201,64415210203,64415210202,64415210302,64414232321,64414232323,64414232131,64414232132,64414232133,
002,14,/ƻ,508584375,155146875,509189062,155475000,0,0,4,11,26,84,64415212,64415322,64415231,64415323,644152033,644152300,644152301,644152303,644152331,644152333,644152330,644153202,644153203,644153200,644152211,6441521033,6441521023,6441521022,6441520313,6441520311,6441520312,6441523321,6441520321,6441523020,6441523021,6441523023,6441521032,6441532122,6441630031,6441630010,6441621110,6441621111,6441521322,6441532012,6441532120,6441532123,6441522101,6441520323,6441520322,6441522100,6441522011,64415210312,64415210313,64415211202,64415211203,64415211220,64415211222,64415213000,64415213002,64415213020,64415213022,64415221310,64415221311,64415221313,64415230220,64415230221,64415232110,64415232111,64415232113,64415213202,64415213200,64415210303,64415321322,64415332022,64415332200,64416301100,64416301101,64416301011,64416301010,64416301000,64416301001,64416300111,64416300110,64416300112,64416300130,64416300132,64416300133,64416301202,64416301220,64416301221,64416301203,64416301222,64416300331,64416300123,64416300121,64416300011,64416300010,64416300001,64416300000,64415233233,64415233231,64415233230,64416211130,64416211121,64416211120,64416211011,64415213232,64415213233,64415213322,64415213323,64415320102,64415320103,64415320130,64415320132,64415320133,64415321022,64415321210,64415321212,64415321323,64415321332,64415321330,64415321333,64415201333,64415201331,64415201332,64415203101,64415203103,64415203033,64415221301,64415221033,64415221031,64415221030,64415221021,64415203203,64415202333,
002,15,,508851562,155043750,509259375,155371875,0,0,3,14,34,55,64415300,64415302,64415303,644152131,644153302,644153122,644153300,644153211,644153120,644152113,644152111,644143223,644143222,644142333,644153010,644153012,644153013,6441521321,6441521303,6441521301,6441521123,6441532011,6441521330,6441521331,6441521333,6441432202,6441432203,6441423312,6441423313,6441432213,6441432212,6441432322,6441432323,6441530110,6441530112,6441530113,6441531022,6441531020,6441533010,6441531232,6441532131,6441532100,6441532101,6441532103,6441521121,6441521103,6441521101,6441533200,6441533201,6441533203,6441532130,64414323202,64414323200,64414323203,64414323322,64415301112,64415301113,64415310020,64415310022,64415310232,64415310230,64415310023,64415310233,64415312120,64415312122,64415312300,64415312302,64415330120,64415330122,64415330300,64415330302,64415330320,64415330121,64415330322,64415332201,64415332210,64415321331,64415321020,64415321021,64415321023,64415320131,64415320100,64415320101,64415213203,64415213201,64415213023,64415213021,64415213003,64415213001,64415211223,64415211221,64414233211,64414233213,64414233231,64414233233,64415332020,64415332021,64415332023,64415213230,64415213231,64415213320,64415213321,64415321211,64415321213,64415321320,64415321321,
002,16,׻/Ȭ,508626562,154996875,508795312,155165625,0,0,0,1,16,25,644142231,6441423202,6441423200,6441422331,6441422132,6441422301,6441422123,6441423220,6441422333,6441520113,6441520111,6441423222,6441521000,6441521002,6441521001,6441520131,6441423223,64414221332,64414232030,64414232032,64414223301,64414223303,64414223300,64414223031,64414223033,64414223030,64414221221,64414221223,64414223001,64414223003,64414221203,64414221212,64414221213,64414221302,64415210100,64415201123,64415201330,64415210200,64415210030,64414232210,64414232212,64414232322,
002,17,/ܤ/,508190625,154856250,508696875,155353125,0,2,3,13,37,34,6441511,6441413,64414222,64414220,64415200,644141130,644141123,644141132,644141133,644152010,644142232,644152012,644152200,644152022,644152020,644152202,644141233,644152021,6441412311,6441412133,6441412131,6441411223,6441411033,6441411211,6441411212,6441411122,6441411123,6441411310,6441411313,6441420222,6441411312,6441411213,6441422100,6441422102,6441422302,6441520301,6441520132,6441520130,6441520110,6441422332,6441412313,6441412312,6441412303,6441412321,6441412323,6441522200,6441522030,6441522013,6441522012,6441522010,6441520232,6441520230,6441520231,6441520302,6441520300,64415203032,64415203031,64415203102,64415203100,64415201121,64415201120,64415201122,64414223302,64414223032,64414223002,64414223000,64414221222,64414221220,64414221202,64414221200,64414221201,64414221210,64414221032,64414221030,64414221012,64414221010,64414203232,64415203030,64415203201,64415203202,64415202331,64415202332,64415221020,64415222020,64415222010,64415220320,64415220310,64415203200,64415202330,
002,18,ʿ//,508879687,154556250,509062500,154968750,0,0,0,10,18,47,644142131,644142113,644143000,644143002,644133020,644133022,644133200,644133202,644133220,644133222,6441423111,6441421333,6441421330,6441421331,6441430202,6441430200,6441421113,6441323313,6441323331,6441323333,6441421111,6441330022,6441330023,6441332010,6441332012,6441332013,6441332030,6441430220,64414320000,64414302222,64414231101,64414213323,64414213321,64414302220,64414302032,64414302030,64414302221,64414302212,64414302210,64414213013,64414302012,64414302010,64414213011,64414211233,64414211231,64414211213,64414211211,64414211123,64414211121,64413233113,64414300322,64414300320,64414300302,64414300300,64414300122,64414300120,64413231313,64413231331,64413231333,64413233111,64413231311,64413231133,64413231131,64413231113,64413231111,64413213333,64413213331,64413213313,64413213311,64413213133,64413213131,64413213113,64413213111,64413211333,64413211331,
002,19,˭ʿ//,508921875,154387500,509343750,154996875,0,0,7,14,43,56,64413301,64413303,64413330,64413332,64413323,64414301,64413321,644133023,644133021,644133003,644123212,644123230,644123232,644133120,644133122,644133221,644133223,644143100,644143101,644143030,644143021,6441423113,6441430223,6441430230,6441430231,6441232033,6441232211,6441232213,6441232231,6441232233,6441330011,6441330013,6441332011,6441232031,6441232332,6441331002,6441331020,6441331023,6441331210,6441331212,6441331230,6441331232,6441333122,6441333300,6441333302,6441333321,6441333320,6441332031,6441331022,6441332033,6441430011,6441430013,6441430031,6441430033,6441431020,6441431021,6441431022,6441430310,6441431030,6441333322,6441332032,6441430010,6441431100,6441431101,64414231310,64414231311,64414320022,64414320020,64414320002,64414320021,64414320003,64414320001,64414302223,64414320012,64414320010,64414320011,64414302213,64414302211,64414302033,64414302031,64414302013,64414302011,64414302322,64414302321,64414303200,64414302330,64414303201,64414303120,64414303110,64414303202,64414302320,64414300323,64414300321,64414300303,64414300301,64414300123,64414300121,64414310232,64414312000,64414303111,64414303112,64414310231,64414310312,64414310330,64414310321,64414310311,64414311022,64414311021,64414311030,64413333233,64413333230,64413333232,64413333033,64413333032,64413333030,64413333012,64413331202,64414310310,64414311020,64414310230,
002,20,,508935937,154875000,509315625,155156250,0,0,1,10,23,59,64414321,644143300,644143033,644143122,644143320,644143231,644143230,644143322,644143203,644143201,644143302,6441432020,6441432023,6441432021,6441432003,6441431230,6441531001,6441531010,6441531011,6441531013,6441531003,6441531000,6441432333,6441432331,6441432330,6441432321,6441433232,6441433230,6441432211,6441430322,6441430321,6441430313,6441431202,6441430323,64414231331,64414231313,64414320220,64414320223,64414320221,64414320023,64414322011,64414320013,64414322100,64414322103,64414322101,64414302323,64414302332,64414323201,64415311023,64415311022,64415310311,64415310121,64415310122,64415310211,64415310212,64415310210,64415310021,64415301111,64415301110,64414323323,64414323321,64414323320,64415311020,64415311002,64414332333,64414332330,64414332312,64414332123,64414332120,64414332102,64414330100,64414330102,64414312322,64414312321,64414312033,64414312030,64414312012,64414312010,64414312001,64414312003,64414312002,64414303113,64414303121,64414303123,64414303122,64414303203,64414302331,64414302333,64414312032,64414312320,64414332122,64414332332,64415310120,
002,21,,509217187,154818750,509442187,155128125,0,0,1,6,20,48,64414313,644143303,644143312,644143310,644143311,644143112,644143121,6441433322,6441433320,6441440222,6441440220,6441442000,6441433131,6441433213,6441433302,6441433211,6441433013,6441433011,6441431233,6441431231,6441433012,6441433130,6441433300,6441440200,6441440202,6441431132,6441431130,64415311021,64415311030,64415311012,64415311003,64415311001,64415311010,64415311000,64414332331,64414332313,64414332311,64414332310,64414333010,64414331320,64414420021,64414420020,64414420022,64414420200,64414420202,64414402030,64414402012,64414402010,64414400232,64414400223,64414400222,64414311122,64414311120,64414311031,64414311033,64414311032,64414311023,64414310313,64414310331,64414310333,64414310332,64414310323,64414310322,64414310320,64414310233,64414312011,64414312013,64414312031,64414312323,64414330101,64414330103,64414332100,64414332101,64414332103,64414332121,
002,22,/׷,507600000,154050000,509034375,155100000,2,13,11,29,59,35,644121,644131,6441112,6441203,6441301,6441303,6441401,6441302,6441400,6441403,6441410,6441320,6441222,6441223,6441322,64411133,64411130,64411132,64414120,64414122,64413210,64413212,64413230,64413232,64414200,64414201,644123202,644141211,644141210,644141212,644123220,644123222,644133000,644132111,644132110,644132112,644132130,644132132,644132310,644132312,644132330,644132332,644142100,644141101,644141100,644141110,644141102,644141120,644142023,644142021,644142020,644142030,644141113,644141111,644142031,6441323332,6441421110,6441323330,6441323312,6441323310,6441323132,6441323130,6441323112,6441323110,6441321332,6441321330,6441321312,6441321310,6441321132,6441321130,6441321131,6441330020,6441330021,6441330012,6441330010,6441232232,6441232230,6441232212,6441232210,6441232032,6441232030,6441412322,6441412320,6441412302,6441412300,6441412301,6441412310,6441412132,6441412130,6441411222,6441411220,6441411221,6441411210,6441411032,6441411030,6441411031,6441411120,6441411121,6441421030,6441421012,6441421010,6441421101,6441411311,6441420220,6441420221,6441420223,6441420320,6441420321,6441420322,6441421202,6441421200,6441421020,6441421021,6441421022,64414211033,64414211122,64414211120,64414211030,64414211031,64414211003,64414210111,64414210110,64414210112,64414210130,64414210132,64414211001,64413233112,64413233110,64413231332,64413231312,64413231310,64413231330,64413231132,64413231130,64413231110,64413231112,64413213332,64413213330,64413213312,64413213310,64413213132,64413213130,64413213112,64413213110,64413211332,64413211330,64414203300,64414203302,64414203230,
002,23,/м,508500000,154950000,510075000,157350000,11,17,21,22,103,186,644154,644164,644173,644174,654103,654104,654113,654114,654123,654124,654133,6441443,6441550,6441652,6441721,6441750,6541150,6541152,6541340,6541421,6541430,6541431,6441631,6441632,6441633,6441620,6441622,6441623,65411233,65412211,65412213,65412231,65412233,65413211,65413213,65413231,65413233,64415223,64415331,64415333,64415313,64416302,64416303,64416210,64416212,64416213,64414421,64414422,64414423,654112312,654112313,644152212,644152320,644152322,644152323,644153321,644153323,644163002,644163013,644162112,644162113,644152221,644152222,644152223,644153111,644153112,644153113,644143331,644143333,644144201,644144203,6441720000,6441720001,6441720010,6441720011,6441720100,6441720101,6441720110,6441720111,6441720113,6441720131,6441720133,6441720311,6441720313,6441720331,6441720333,6441722111,6441723000,6441723001,6441723010,6441723011,6441723100,6441723101,6441723110,6441723111,6441723113,6441723131,6441723133,6441723311,6441723313,6441723331,6441723333,6541021111,6541021113,6541021131,6541021133,6541021311,6541021313,6541021331,6541021333,6541023111,6541023113,6541023131,6541023133,6541023311,6541023313,6541023331,6541023333,6541121111,6541121113,6541121131,6541121133,6541121311,6541121313,6541121331,6541121333,6541123111,6541123113,6441523320,6441523322,6441522132,6441522133,6441523210,6441523212,6441523213,6441533011,6441533013,6441531231,6441531233,6441531210,6441531211,6441531213,6441533031,6441533033,6441533222,6441533223,6441630102,6441630103,6441630111,6441630112,6441630113,6441630002,6441630003,6441630030,6441630032,6441630121,6441630123,6441621100,6441621102,6441621103,6441522203,6441522033,6441531030,6441531032,6441531033,6441433321,6441433323,6441442001,6441442003,6441433133,6441433303,6441442021,6441442022,6441442023,64417200020,64417200021,64417200030,64417200031,64417200120,64417200121,64417200130,64417200131,64417201020,64417201021,64417201030,64417201031,64417201120,64417201121,64417231121,64417231123,64417231301,64417231303,64417231321,64417231323,64417233101,64417233103,64417233121,64417233123,64417233301,64417233303,64417233321,64417233323,65410211101,65410211103,65410211121,65410211123,65410211301,65410211303,65410211321,65410211323,65410213101,65410213103,65410213121,65410213123,65410213301,65410213303,65410213321,65410213323,65410231101,65410231103,65410231121,65410231123,65410231301,65410231303,65410231321,65410231323,65410233101,65410233103,65410233121,65410233123,65410233301,65410233303,65410233321,65410233323,65411211101,65411211103,65411211121,65411211123,65411211301,65411211303,65411211321,65411211323,65411213101,65411213103,65411213121,65411213123,65411213301,65411213303,65411213321,65411213323,65411231101,65411231103,65411231121,65411231123,65413232133,65413232311,65413232313,65413232331,65413232333,65414201111,65414201113,65414201131,65414201133,65414201311,65414201313,65414201331,65414201333,65414203111,65414203113,65414203131,65414203133,65414203311,65414203313,65414203331,65414203333,64415221312,64415230222,64415230223,64415232112,64415310231,64415312121,64415312123,64415312301,64415312303,64415330123,64415330301,64415330303,64415330321,64415330323,64415332202,64415332203,64415332211,64415332212,64415332213,64416300113,64416301002,64416301003,64416301012,64416301013,64416301102,64416301103,64416300002,64416300003,64416300012,64416300013,64415233232,64416300131,64416300120,64416300122,64416301200,64416301201,64416301223,64416300330,64416300332,64416300333,64416211131,64416211132,64416211133,64416211122,64416211123,64416211010,64416211012,64416211013,64415221300,64415221302,64415221303,64415221032,64415221022,64415221023,64415220311,64415220312,64415220313,64415220321,64415220322,64415220323,64415222011,64415222012,64415222013,64415222021,64415222022,64415222023,64415310310,64415310312,64415310313,64415310123,64415310213,64415311031,64415311032,64415311033,64415311011,64415311013,64414333011,64414333012,64414333013,64414331321,64414331322,64414331323,64414420023,64414420201,64414420203,
003,00,/,511200000,154350000,515475000,161700000,86,85,0,0,0,0,644233,644243,644244,644245,644252,644253,644254,644255,644263,644264,644265,644273,644274,644275,654203,654204,654213,654214,654223,654224,654225,654233,654234,654235,654236,654237,654242,654243,654244,654245,654246,654247,654252,654253,654254,654255,654256,654257,654262,654263,654264,654265,654266,654267,654272,654273,654274,654275,654276,654330,654340,664202,664203,664204,664205,664206,664212,664213,664214,664215,664216,664222,664223,664224,664225,664226,664233,664234,664235,664243,664244,664245,664252,664253,664254,664261,664262,664263,664264,664270,664271,664272,674200,674201,674210,674220,6442223,6442321,6442323,6442340,6442342,6442343,6442421,6442422,6442423,6442620,6442621,6442623,6442721,6442723,6542021,6542050,6542051,6542052,6542150,6542152,6542153,6542221,6542223,6542260,6542262,6542263,6542272,6542273,6542313,6542321,6542322,6542323,6542411,6542413,6542511,6542513,6542611,6542612,6542613,6542711,6543202,6543310,6543312,6543410,6543412,6543602,6642011,6642013,6642111,6642113,6642211,6642213,6642311,6642320,6642321,6642323,6642360,6642362,6642421,6642422,6642423,6642460,6642462,6642503,6642512,6642513,6642550,6642551,6642560,6642561,6642601,6642603,6642730,6642731,6642732,6742020,6742021,6742022,6742030,6742110,6742111,6742112,6742120,6742210,6742212,
003,01,/ë,507403125,160500000,514575000,163959375,37,63,40,58,170,926,664274,674155,674156,674157,674161,674165,674166,674167,674175,674176,674177,674204,674205,674213,674214,674215,674222,674223,674224,674232,674233,674234,674242,674243,674250,674251,674252,674260,674261,674262,674270,674271,684105,684106,684107,684117,684200,6642733,6642750,6642752,6642753,6642762,6741452,6741462,6741463,6741512,6741513,6741522,6741541,6741543,6741620,6741622,6741641,6741643,6741702,6741741,6741743,6742023,6742031,6742032,6742033,6742060,6742061,6742062,6742070,6742113,6742121,6742122,6742123,6742160,6742211,6742213,6742250,6742252,6742310,6742311,6742313,6742411,6742412,6742413,6742440,6742442,6742530,6742531,6742532,6742720,6841000,6841002,6841100,6841150,6841151,6841160,6841161,6841163,6841270,6841271,6842010,6842100,6842101,6842102,67407713,67407731,67407733,67415102,67415103,67415112,67415113,67415202,67415203,67415212,67415230,67415232,67416210,67416212,67416230,67416232,67417002,67417003,67417012,67417030,67417032,67417100,67417101,67417110,67417111,67417200,67417201,67417210,68400711,68400713,68400731,68400733,68401711,68401713,68410010,68410012,68410030,68410032,68411010,68411012,674077103,674077112,674077113,674077121,674077123,674077301,674077303,674077321,674077323,674151002,674151003,674151012,674151013,674151102,674151103,674151112,674151113,674152002,674152003,674152012,674152013,674152102,674152103,674170002,674170003,674170012,674170013,674170102,674170103,674206300,674206301,674206310,674206311,674207200,674207201,674207210,674207211,684007101,684007103,684007121,684007123,684007301,684007303,684007321,684007323,684017101,684017103,684017121,684017123,684017301,684017310,684017311,684110200,684110201,684110210,684110211,684110300,684110301,6740771021,6740771023,6740771201,6740771203,6740771221,6740771223,6740773001,6740773003,6740773021,6740773023,6740773201,6740773203,6740773221,6740773223,6741510002,6741510003,6741510012,6741510013,6741510102,6741510103,6741510112,6741510113,6741511002,6741511003,6741511012,6741511013,6741511102,6741511103,6741511112,6741511113,6741520002,6741520003,6741520012,6741520013,6741520102,6741520103,6741520112,6741520113,6741521002,6741521003,6741521012,6741521013,6741521102,6741521120,6741521122,6741521300,6741521302,6741521320,6741521322,6741523100,6741523102,6741523120,6741523122,6741523300,6741523302,6741523320,6741523322,6741621100,6741621102,6741621120,6741621122,6741621300,6741621302,6741621320,6741621322,6741623100,6741623102,6741623120,6741623122,6741623300,6741623302,6741623320,6741623322,6741721100,6741721102,6741721120,6741721122,6742063020,6742063022,6742063200,6742063202,6742063220,6742063222,6742161000,6742161002,6742161020,6742161022,6742161200,6742161202,6742161220,6742161222,6742162000,6742162001,6742162010,6742162011,6742162100,6742162101,6742162110,6742162111,6742163000,6742251000,6742251001,6742251010,6742251011,6742251100,6742251101,6742251110,6742251111,6742533000,6742533001,6742533010,6742533011,6742533100,6742533101,6742533110,6742533111,6742630000,6742630001,6742630010,6742630011,6742630100,6742630101,6742630110,6742630111,6840071001,6840071003,6840071021,6840071023,6840071201,6840071203,6840071221,6840071223,6840073001,6840073003,6840073021,6840073023,6840073201,6840073203,6840073221,6840073223,6840171001,6840171003,6840171021,6840171023,6840171201,6840171203,6840171221,6840171223,6840173001,6840173003,6840173021,6840173030,6840173031,6840173120,6840173121,6840173130,6840173131,6841102020,6841102021,6841102030,6841102031,6841102120,6841102121,6841102130,6841102131,6841103020,6841103021,6841103030,6841103031,6840173122,67414423333,67414431111,67414431113,67414431131,67414431133,67414431311,67414431313,67414431331,67414431333,67414432222,67414432223,67414432232,67414432233,67414432322,67414432323,67414432332,67414432333,67414433111,67414433113,67414433131,67414433133,67414433222,67414433223,67414433232,67414433233,67414433311,67414433313,67414433322,67414433323,67414433331,67414433332,67414433333,67415011113,67415011131,67415011133,67415011311,67415011313,67415011331,67415011333,67415013111,67415013113,67415013131,67415013133,67415013311,67415013313,67415013331,67415013333,67415031111,67415031113,67415031131,67415031133,67415031311,67415031313,67415031331,67415031333,67415033111,67415033113,67415033131,67415033133,67415033311,67415033313,67415033331,67415033333,67415100002,67415100003,67415100012,67415100013,67415100102,67415100103,67415100112,67415100113,67415101002,67415101003,67415101012,67415101013,67415101102,67415101103,67415101112,67415101113,67415110002,67415110003,67415110012,67415110013,67415110102,67415110103,67415110112,67415110113,67415111002,67415111003,67415111012,67415111013,67415111102,67415111103,67415111112,67415111113,67415200002,67415200003,67415200012,67415200013,67415200102,67415200103,67415200112,67415200113,67415201002,67415201003,67415201012,67415201013,67415201102,67415201103,67415201112,67415201113,67415210002,67415210003,67415210012,67415210013,67415210102,67415210103,67415210112,67415210113,67415211002,67415211003,67415211012,67415211030,67415211032,67415211210,67415211212,67415211230,67415211232,67415213010,67415213012,67415213030,67415213032,67415213210,67415213212,67415213230,67415213232,67415231010,67415231012,67415231030,67415231032,67415231210,67415231212,67415231230,67415231232,67415233010,67415233012,67415233030,67415233032,67415233210,67415233212,67415233230,67415233232,67415401111,67415401113,67415401131,67415401133,67415401311,67415401313,67415401331,67415401333,67415403111,67415403113,67415403131,67415403133,67415403311,67415403313,67415403331,67415403333,67415421111,67415421113,67415421131,67415421133,67415421311,67415421313,67415421331,67415421333,67415423111,67415423113,67415423131,67415423133,67415423311,67415423313,67415423331,67415423333,67416011111,67416011113,67416011131,67416011133,67416011311,67416011313,67416011331,67416011333,67416013111,67416013113,67416013131,67416013133,67416013311,67416013313,67416013331,67416013333,67416031111,67416031113,67416031131,67416031133,67416031311,67416031313,67416031331,67416031333,67416033111,67416033113,67416033131,67416033133,67416033311,67416033313,67416033331,67416033333,67416211010,67416211012,67416211030,67416211032,67416211210,67416211212,67416211230,67416211232,67416213010,67416213012,67416213030,67416213032,67416213210,67416213212,67416213230,67416213232,67416231010,67416231012,67416231030,67416231032,67416231210,67416231212,67416231230,67416231232,67416233010,67416233012,67416233030,67416233032,67416233210,67416233212,67416233230,67416233232,67416401111,67416401113,67416401131,67416401133,67416401311,67416401313,67416401331,67416401333,67416403111,67416403113,67416403131,67416403133,67416403311,67416403313,67416403331,67416403333,67416421111,67416421113,67416421131,67416421133,67416421311,67416421313,67416421331,67416421333,67416423111,67416423113,67416423131,67416423133,67416423311,67416423313,67416423331,67416423333,67417011111,67417011113,67417011131,67417011133,67417011200,67417011202,67417011220,67417011222,67417011311,67417011313,67417011331,67417011333,67417013000,67417013002,67417013020,67417013022,67417013200,67417013202,67417013220,67417013222,67417031000,67417031002,67417031020,67417031022,67417031200,67417031202,67417031220,67417031222,67417033000,67417033002,67417033020,67417033022,67417033200,67417033202,67417033220,67417033222,67417211010,67417211012,67417211030,67417211032,67417211210,67417211212,67417211230,67417211232,67417401111,67417401113,67417401131,67417401133,67417401311,67417401313,67417401331,67417401333,67417403111,67417403113,67417403131,67417403133,67417403311,67417403313,67417403331,67417403333,67417421111,67421620020,67421620021,67421620030,67421620031,67421620120,67421620121,67421620130,67421620131,67421621020,67421621021,67421621030,67421621031,67421621120,67421621121,67421621130,67421621131,67421630020,67421630021,67422510020,67422510022,67422510200,67422510202,67422510220,67422510222,67422512000,67422512002,67422512020,67422512022,67422512200,67422512202,67422512220,67422512222,67422530000,67422530002,67422530020,67422530022,67422530200,67422530202,67422530220,67422530222,67422532000,67422532002,67422532020,67422532022,67422532200,67422532202,67422532220,67422532222,67423500000,67423500001,67423500010,67423500011,67423500100,67423500101,67423500110,67423500111,67423501000,67423501001,67423501010,67423501011,67423501100,67423501101,67423501110,67423501111,67423510000,67424410000,67424410001,67424410010,67424410011,67424410100,67424410101,67424410110,67424410111,67424411000,67424411001,67424411010,67424411011,67424411100,67424411101,67424411110,67424411111,67425330020,67425330022,67425330200,67425330202,67425330220,67425330222,67425332000,67425332002,67425332020,67425332022,67425332200,67425332202,67425332220,67425332222,67425400000,67425400001,67425400002,67425400010,67425400011,67425400020,67425400022,67425400100,67425400101,67425400110,67425400111,67425400200,67425400202,67425400220,67425400222,67425401000,67425401001,67425401010,67425401011,67425401100,67425401101,67425401110,67425401111,67425402000,67425402002,67425402020,67425402022,67425402200,67425402202,67425402220,67425402222,67425420000,67425420002,67426300020,67426300022,67426300200,67426300202,67426300220,67426300222,67426302000,67426302002,67426302020,67426302022,67426302200,67426302202,67426302220,67426302222,67426310000,67426310002,67426320000,67426320002,67426320020,67426320022,67426320200,67426320202,67426320220,67426320222,67426322000,67426322002,67426322020,67426322022,67426322200,67426322202,67426322220,67426322222,67427210000,67427210001,67427210002,67427210010,67427210011,67427210020,67427210022,67427210100,67427210101,67427210110,67427210111,67427210200,67427210202,67427210220,67427210222,67427211000,67427211001,67427211010,67427211011,67427211100,67427211101,67427211110,67427211111,67427212000,67427212002,67427212020,67427212022,67427212200,67427212202,67427212220,67427212222,67427220000,67427220001,67427220002,67427220010,67427220011,67427220020,67427220022,67427220100,67427220101,67427220110,67427220111,67427220200,67427220202,67427220220,67427220222,67427221000,67427221001,67427221010,67427221011,67427221100,67427221101,67427221110,67427221111,67427222000,67427222002,67427222020,67427222022,67427222200,67427222202,67427222220,67427222222,67427230000,67427300000,68410011000,68410011002,68410011020,68410011022,68410011200,68410011202,68410011220,68410011222,68410013000,68410013002,68410013020,68410013022,68410013200,68410013202,68410013220,68410013222,68410031000,68410031002,68410031020,68410031022,68410031200,68410031202,68410031220,68410031222,68410033000,68410033002,68410033020,68410033022,68410033200,68410033202,68410033220,68410033222,68410410000,68410410001,68410410010,68410410011,68410410100,68410410101,68410410110,68410410111,68410411000,68410411001,68410411010,68410411011,68410411100,68410411101,68410411110,68410411111,68410411113,68410411131,68410411133,68410411311,68410411313,68410411331,68410411333,68410413111,68410413113,68410413131,68410413133,68410413311,68410413313,68410413331,68410413333,68410431111,68410431113,68410431131,68410431133,68410431311,68410431313,68410431331,68410431333,68410433111,68410433113,68410433131,68410433133,68410433311,68410433313,68410433331,68410433333,68411011000,68411011002,68411011020,68411011022,68411011200,68411011202,68411011220,68411011222,68411013000,68411013002,68411013020,68411013022,68411013200,68411013202,68411013220,68411013222,68411031000,68411031002,68411031020,68411031022,68411031200,68411031202,68411411111,68411411113,68411411131,68411411133,68411411311,68411411313,68411411331,68411411333,68411413111,68411413113,68411413131,68411413133,68411413311,68411413313,68411413331,68411413333,68411431111,68411520000,68411520001,68411520010,68411520011,68411520100,68411520101,68411520110,68411520111,68411521000,68411521001,68411521010,68411521011,68411521100,68411521101,68411521110,68411521111,68411530000,68411530001,68411530010,68411530011,68411530100,68411530101,68411530110,68411530111,68411531000,68411531001,68411531010,68411531011,68411531100,68411531101,68411531110,68411531111,68411620000,68411620001,68411620010,68411620011,68411620100,68411620101,68411620110,68411620111,68411621000,68411621001,68411621010,68411621011,68411621100,68411621101,68411621110,68411621111,68411621113,68411621131,68411621133,68411621311,68411621313,68411621331,68411621333,68411623111,68411623113,68411623131,68411623133,68411623311,68411623313,68411623331,68411623333,68412601111,68412610000,68412610001,68412610010,68412610011,68412610100,68412610101,68412610110,68412610111,68412611000,68412611001,68412611010,68412611011,68412611100,68412611101,68412611110,68412611111,68412611113,68412611131,68412611133,68412611311,68412611313,68412611331,68412611333,68412613111,68412613113,68412613131,68412613133,68412613311,68412613313,68412613331,68412613333,68412631111,68412720000,68412720001,68412720010,68412720011,68412720100,68412720101,68412720110,68412720111,68412721000,68412721001,68412721010,68412721011,68412721100,68412721101,68412721110,68412721111,68412730000,68412730001,68412730010,68412730011,68412730100,68412730101,68412730110,68412730111,68412731000,68412731001,68412731010,68412731011,68412731100,68412731101,68412731110,68412731111,68420110000,68420110001,68420110010,68420110011,68420110100,68420110101,68420110110,68420110111,68420111000,68420111001,68420111010,68420111011,68420111100,68420111101,68420111110,68420111111,68420120000,68420120001,68420120002,68420120010,68420120011,68420120020,68420120022,68420120100,68420120101,68420120110,68420120111,68420120200,68420120202,68420120220,68420120222,68420121000,68420121001,68420121010,68420121011,68420121100,68420121101,68420121110,68420121111,68420122000,68420122002,68420122020,68420122022,68420122200,68420122202,68420122220,68420122222,68420200000,68421030000,68421030001,68421030002,68421030010,68421030011,68421030020,68421030022,68421030100,68421030101,68421030110,68421030111,68421030200,68421030202,68421030220,68421030222,68421031000,68421031001,68421031010,68421031011,68421031100,68421031101,68421031110,68421031111,68421032000,68421032002,68421032020,68421032022,68421032200,68421032202,68421032220,68421032222,68421100000,68421100002,68421100020,68421100022,68421100200,68421100202,68421100220,68421100222,68421102000,68421102002,68421102020,68421102022,68421102200,68421102202,68421102220,68421102222,68421120000,68422000000,68422000001,68422000010,68422000011,68422000100,68422000101,68422000110,68422000111,68422001000,68422001001,68422001010,68422001011,68422001100,68422001101,68422001110,68422001111,68422010000,68401730333,68401730331,
003,02,α˨,508612500,157350000,511875000,162300000,37,46,7,20,33,647,654153,654154,654165,654166,654175,654176,664105,664106,664107,664115,664116,664117,664125,664126,664127,664135,664136,664137,664146,664147,664156,664157,664166,664167,664176,664177,674106,674107,674116,674117,674126,674127,674136,674137,674147,674230,674240,6541423,6541432,6541433,6541442,6541443,6541521,6541523,6541550,6541552,6541553,6541562,6541631,6541640,6541641,6541643,6541741,6541772,6641450,6641451,6641453,6641551,6642000,6642002,6642100,6642102,6642200,6642202,6642300,6642302,6642400,6642402,6642500,6642502,6642600,6642602,6741253,6741351,6741352,6741353,6741450,6741451,6741453,6741460,6741461,6742312,6742410,66415201,66415210,66415211,66415300,66415301,67412511,67412513,664142232,664142233,664142322,664142323,664142332,664142333,664143222,664143223,664143232,664143233,664152030,664152031,664152120,664152121,664152130,664152131,664153020,664153021,664153030,664153031,6641422302,6641422303,6641422312,6641422313,6641423202,6641423203,6641423212,6641423213,6641423302,6641423303,6641423312,6641423313,6641432202,6641432203,6641432212,6641432213,6641432302,6641432303,6641432312,6641432313,6641433202,6641433220,6641433222,6641531000,6641531002,6641531020,6641531022,6641531200,6641531202,6741153322,6741153323,6741153332,6741153333,65414221111,65414221113,65414221131,65414221133,65414221311,65414221313,65414221331,65414221333,65414223111,65414223113,65414223131,65414223133,65414223311,65414223313,65414223331,65414223333,65415201111,65415201113,65415201131,65415201133,65415201311,65415201313,65415201331,65415201333,65415203111,65415203113,65415203131,65415203133,65415203311,65415203313,65415203331,65415203333,65415221111,65415221113,65415221131,65415221133,65415221311,65415221313,65415221331,65415221333,65415223111,65415223113,65415223131,65415223133,65415223311,65415223313,65415223331,65415223333,65416201111,65416210000,65416210001,65416210010,65416210011,65416210100,65416210101,65416210110,65416210111,65416211000,65416211001,65416211010,65416211011,65416211100,65416211101,65416211110,65416211111,65416300000,65416300001,65416300010,65416300011,65416300100,65416300101,65416300110,65416300111,65416301000,65416301001,65416301010,65416301011,65416301100,65416301101,65416301110,65416301111,65416301113,65416301131,65416301133,65416301311,65416301313,65416301331,65416301333,65416303111,65416303113,65416303131,65416303133,65416303311,65416303313,65416303331,65416303333,65417430000,65417430001,65417430010,65417430011,65417430100,65417430101,65417430110,65417430111,65417431000,65417431001,65417431010,65417431011,65417431100,65417431101,65417431110,65417431111,65417431113,65417431131,65417431133,65417431311,65417431313,65417431331,65417431333,65417433111,65417433113,65417433131,65417433133,65417433311,65417433313,65417433331,65417433333,66410411111,66410411113,66410411131,66410411133,66410411311,66410411313,66410411331,66410411333,66410413111,66410413113,66410413131,66410413133,66410413311,66410413313,66410413331,66410413333,66410431111,66410431113,66410431131,66410431133,66410431311,66410431313,66410431331,66410431333,66410433111,66410433113,66410433131,66410433133,66410433311,66410433313,66410433331,66410433333,66411411111,66411411113,66411411131,66411411133,66411411311,66411411313,66411411331,66411411333,66411413111,66411413113,66411413131,66411413133,66411413311,66411413313,66411413331,66411413333,66411431111,66411431113,66411431131,66411431133,66411431311,66411431313,66411431331,66411431333,66411433111,66411433113,66411433131,66411433133,66411433311,66411433313,66411433331,66411433333,66412411111,66412411113,66412411131,66412411133,66412411311,66412411313,66412411331,66412411333,66412413111,66412413113,66412413131,66412413133,66412413311,66412413313,66412413331,66412413333,66412431111,66412431113,66412431131,66412431133,66412431311,66412431313,66412431331,66412431333,66412433111,66412433113,66412433131,66412433133,66412433311,66412433313,66412433331,66412433333,66413411111,66413411113,66413411131,66413411133,66413411311,66413411313,66413411331,66413411333,66413413111,66413413113,66413413131,66413413133,66413413311,66413413313,66413413331,66413413333,66413431111,66413431113,66413431131,66413431133,66413431311,66413431313,66413431331,66413431333,66413433111,66413433113,66413433131,66413433133,66413433311,66413433313,66413433331,66413433333,66414223002,66414223003,66414223012,66414223013,66414223102,66414223103,66414223112,66414223113,66414232002,66414232003,66414232012,66414232013,66414232102,66414232103,66414232112,66414232113,66414233002,66414233003,66414233012,66414233013,66414233102,66414233103,66414233112,66414233113,66414322002,66414322003,66414322012,66414322013,66414322102,66414322103,66414322112,66414322113,66414323002,66414323003,66414323012,66414323013,66414323102,66414323103,66414323112,66414323113,66414332002,66414332003,66414332012,66414332030,66414332032,66414332210,66414332212,66414332230,66414332232,66414411111,66414411113,66414411131,66414411133,66414411311,66414411313,66414411331,66414411333,66414413111,66414413113,66414413131,66414413133,66414413311,66414413313,66414413331,66414413333,66414521111,66414521113,66414521131,66414521133,66414521311,66414521313,66414521331,66414521333,66414523111,66414523113,66414523131,66414523133,66414523311,66414523313,66414523331,66414523333,66415203200,66415203201,66415203210,66415203211,66415203300,66415203301,66415203310,66415203311,66415212200,66415212201,66415212210,66415212211,66415212300,66415212301,66415212310,66415212311,66415213200,66415213201,66415213210,66415213211,66415213300,66415213301,66415213310,66415213311,66415302200,66415302201,66415302210,66415302211,66415302300,66415302301,66415302310,66415302311,66415303200,66415303201,66415303210,66415303211,66415303300,66415303301,66415303310,66415303311,66415310010,66415310012,66415310030,66415310032,66415310210,66415310212,66415310230,66415310232,66415312010,66415312012,66415312030,66415312032,66415312200,66415312201,66415312210,66415501111,66415501113,66415501131,66415501133,66415501311,66415501313,66415501331,66415501333,66415503111,66415503113,66415503131,66415503133,66415503311,66415503313,66415503331,66415503333,66415521111,66415530000,66415530001,66415530010,66415530011,66415530100,66415530101,66415530110,66415530111,66415531000,66415531001,66415531010,66415531011,66415531100,66415531101,66415531110,66415531111,66415531113,66415531131,66415531133,66415531311,66415531313,66415531331,66415531333,66415533111,66415533113,66415533131,66415533133,66415533311,66415533313,66415533331,66415533333,66416511111,66416511113,66416511131,66416511133,66416511311,66416511313,66416511331,66416511333,66416513111,66416513113,66416513131,66416513133,66416513311,66416513313,66416513331,66416513333,66416531111,66416531113,66416531131,66416531133,66416531311,66416531313,66416531331,66416531333,66416533111,66416533113,66416533131,66416533133,66416533311,66416533313,66416533331,66416533333,66417511111,66417511113,66417511131,66417511133,66417511311,66417511313,66417511331,66417511333,66417513111,66417513113,66417513131,66417513133,66417513311,66417513313,66417513331,66417513333,66417531111,66417531113,66417531131,66417531133,66417531311,66417531313,66417531331,66417531333,66417533111,66417533113,66417533131,66417533133,66417533311,66417533313,66417533331,66417533333,67410511111,67410511113,67410511131,67410511133,67410511311,67410511313,67410511331,67410511333,67410513111,67410513113,67410513131,67410513133,67410513311,67410513313,67410513331,67410513333,67410531111,67410531113,67410531131,67410531133,67410531311,67410531313,67410531331,67410531333,67410533111,67410533113,67410533131,67410533133,67410533311,67410533313,67410533331,67410533333,67411511111,67411511113,67411511131,67411511133,67411511311,67411511313,67411511331,67411511333,67411513111,67411513113,67411513131,67411513133,67411513311,67411513313,67411513331,67411513333,67411531111,67411531113,67411531131,67411531133,67411531311,67411531313,67411531331,67411531333,67411532331,67411532333,67411533111,67411533113,67411533131,67411533133,67411533311,67411533313,67412510111,67412510113,67412510131,67412510133,67412510311,67412510313,67412510331,67412510333,67412512111,67412512113,67412512131,67412512133,67412512311,67412512313,67412512331,67412512333,67412521111,67412521113,67412521131,67412521133,67412521311,67412521313,67412521331,67412521333,67412523111,67412523113,67412523131,67412523133,67412523311,67412523313,67412523331,67412523333,67413431111,67413431113,67413431131,67413431133,67413431311,67413431313,67413431331,67413431333,67413433111,67413433113,67413433131,67413433133,67413433311,67413433313,67413433331,67413433333,67413501111,67413501113,67413501131,67413501133,67413501311,67413501313,67413501331,67413501333,67413503111,67413503113,67413503131,67413503133,67413503311,67413503313,67413503331,67413503333,67414411111,67414411113,67414411131,67414411133,67414411311,67414411313,67414411331,67414411333,67414413111,67414413113,67414413131,67414413133,67414413311,67414413313,67414413331,67414413333,
004,00,/̸/,513450000,156450000,523125000,160800000,101,89,0,0,0,2,654277,654327,654332,654333,654334,654337,654342,654343,654344,654345,654346,654347,654350,654351,654352,654353,654354,654355,654356,654357,654361,654362,654363,654364,654365,654366,654367,654370,654371,654372,654373,654374,654375,654376,654377,654420,654430,654431,654440,654441,654444,654445,654450,654451,654452,654453,654454,654455,654460,654461,654462,654463,654464,654465,654466,654470,654471,654472,654477,664207,664217,664227,664237,664247,664257,664265,664266,664267,664300,664301,664302,664303,664304,664305,664306,664307,664310,664311,664312,664313,664314,664315,664316,664317,664320,664321,664322,664323,664324,664325,664330,664331,664332,664333,664340,664341,664342,664350,664400,664401,664410,6543173,6543222,6543223,6543232,6543233,6543263,6543311,6543313,6543352,6543353,6543361,6543362,6543363,6543411,6543413,6543600,6543601,6543603,6544102,6544212,6544213,6544342,6544343,6544352,6544420,6544422,6544423,6544431,6544432,6544433,6544560,6544562,6544563,6544730,6544731,6544740,6544741,6544750,6544751,6544760,6544761,6544763,6642361,6642363,6642461,6642463,6642552,6642553,6642562,6642563,6642751,6642760,6642761,6642763,6642770,6642771,6642772,6643260,6643261,6643340,6643341,6643510,6643511,6643512,6643600,6643601,6643602,6644020,6644022,6644070,6644071,6644073,6644110,6644111,6644120,6645000,6645002,6645003,6645100,6645101,6645103,6645112,6645210,6645211,6645213,6645222,6645311,6645320,6645322,66434300000,66434300001,
005,00,ӹ/,513675000,151800000,518400000,157050000,105,52,0,0,0,0,634257,634267,634277,634322,634331,634332,634340,634341,634342,634350,634351,634352,634360,634361,634362,634363,634370,634371,634372,634373,634374,644206,644207,644216,644217,644226,644227,644236,644237,644246,644247,644256,644257,644266,644267,644276,644277,644300,644301,644302,644303,644304,644305,644310,644311,644312,644313,644314,644315,644320,644321,644322,644323,644324,644325,644330,644331,644332,644333,644334,644335,644340,644341,644342,644343,644344,644350,644351,644352,644353,644354,644355,644360,644361,644362,644363,644364,644365,644370,644371,644372,644373,644374,644375,654206,654207,654216,654217,654300,654301,654302,654303,654304,654305,654306,654310,654311,654312,654313,654314,654315,654316,654321,654324,654325,6342663,6342761,6342762,6342763,6343211,6343213,6343303,6343432,6343530,6343532,6343533,6343640,6343642,6343752,6443062,6443160,6443162,6443163,6443260,6443261,6443450,6443452,6443453,6443660,6443662,6443760,6443762,6443763,6542053,6542151,6542261,6542270,6542271,6543070,6543072,6543073,6543170,6543171,6543200,6543201,6543203,6543220,6543221,6543230,6543231,6543260,6543261,6543262,6543350,6543351,6543360,6543172,
006,00,ϩ,517275000,154200000,523125000,157350000,58,48,0,0,4,5,644336,644337,644346,644347,644356,644357,644367,644377,644430,644433,644434,644435,644440,644441,644442,644443,644444,644445,644446,644447,644450,644451,644452,644453,644454,644455,644456,644457,644460,644461,644462,644463,644464,644465,644466,644467,644470,644471,644472,644473,644474,644475,644540,644550,654400,654401,654402,654403,654404,654411,654412,654413,654414,654422,654423,654424,654432,654433,6443262,6443263,6443270,6443272,6443273,6443451,6443661,6443663,6443761,6444202,6444312,6444313,6444322,6444323,6444360,6444363,6444372,6444373,6444760,6444761,6445302,6445412,6445512,6445513,6445522,6445600,6445601,6445603,6445610,6445611,6445612,6445620,6543071,6544050,6544052,6544100,6544101,6544103,6544150,6544152,6544153,6544210,6544211,6544250,6544340,6544341,6544421,6544430,6444370222,6444370220,6444361331,6444361313,64443702022,64443702230,64443702212,64443613333,64443613331,
006,01,,520650000,155250000,525150000,159759375,33,55,0,0,7,41,644477,644563,644570,644571,644572,644574,654406,654407,654416,654417,654426,654427,654436,654437,654446,654447,654457,654467,654500,654501,654505,654506,654510,654511,654520,654521,654530,654531,654540,654550,654560,654570,664501,6444762,6444763,6445523,6445533,6445542,6445602,6445613,6445621,6445622,6445623,6445640,6445642,6445730,6445731,6445732,6445752,6445753,6544051,6544053,6544151,6544251,6544252,6544253,6544350,6544351,6544353,6544561,6545020,6545021,6545022,6545041,6545120,6545122,6545220,6545222,6545223,6545320,6545321,6545410,6545710,6545712,6645001,6645022,6645110,6645111,6645113,6645120,6645122,6645123,6645220,6645221,6645223,6645321,6645323,6645421,6445643132,6445643102,6445643100,6445643101,6445641322,6445641323,6445643110,66454230000,66454230001,66454230010,66454230011,66454230100,66454230101,66454230110,66454230111,66454231000,66454231001,66454231010,66454231011,66454231100,66454231101,66454231110,66454231111,64457622222,64457622220,64457622232,64457622333,64457622332,64456431231,64456431230,64456431213,64456431302,64456431303,64456431312,64456431330,64456431201,64456431210,64456431032,64456431030,64456431031,64456430131,64456430113,64456430111,64456413322,64456412333,64456412331,64456413212,64456413203,
007,00,δ,506685937,139471875,509400000,141553125,13,28,49,109,268,517,584047,584057,584122,584130,584131,584132,584140,584141,584142,584150,584151,584152,584162,5840363,5840371,5840372,5840373,5840461,5840463,5840561,5840563,5840671,5841113,5841122,5841202,5841203,5841211,5841212,5841213,5841230,5841232,5841330,5841332,5841430,5841432,5841600,5841601,5841610,5841611,5841613,5841720,58402733,58403621,58403623,58403702,58403703,58404601,58405601,58405603,58405621,58405623,58406701,58406731,58411111,58411112,58411113,58411121,58411122,58411123,58411233,58411321,58411322,58411323,58412101,58412103,58412330,58412332,58413310,58413312,58413313,58413330,58413332,58414310,58414312,58414330,58414332,58415300,58415301,58415302,58415310,58416020,58416021,58416023,58416030,58416031,58416120,58416121,58416123,58417210,58417220,584027311,584027313,584027323,584036131,584036132,584036133,584036221,584036223,584037002,584037003,584037011,584037012,584037013,584046031,584046033,584046223,584046231,584046232,584046233,584056001,584056003,584056021,584056023,584056201,584056203,584056221,584066011,584066100,584066111,584067000,584067001,584067031,584067300,584067301,584067303,584110333,584111023,584111032,584111033,584111103,584111201,584111203,584112020,584112022,584112312,584112313,584112321,584112322,584112323,584113032,584113033,584113201,584113202,584113203,584113302,584113320,584113322,584121001,584121003,584121023,584123100,584123102,584123103,584123120,584123122,584123330,584123332,584123333,584133110,584133112,584133310,584133312,584143110,584143312,584143330,584143332,584153200,584153201,584153202,584153220,584153221,584153222,584160220,584160221,584160223,584160320,584160322,584161221,584161223,584163000,584163002,584163020,584163022,584163023,584163200,584163201,584163202,584170011,584171011,584171100,584171101,584171102,584171110,584171111,584172110,584172120,584172210,584172211,584172212,5840271332,5840271333,5840272323,5840272332,5840273101,5840273103,5840273121,5840273122,5840273123,5840273211,5840273213,5840273221,5840273222,5840273223,5840360233,5840360322,5840360323,5840360332,5840360333,5840361133,5840361231,5840361232,5840361233,5840361302,5840361303,5840362011,5840362013,5840362031,5840362033,5840370002,5840370003,5840370012,5840370013,5840370101,5840370102,5840370103,5840460011,5840460301,5840462110,5840462111,5840462113,5840462131,5840462132,5840462133,5840462221,5840462223,5840560001,5840560003,5840560021,5840560023,5840560201,5840560203,5840562001,5840562002,5840562003,5840562020,5840562021,5840562023,5840562231,5840562233,5840660101,5840661010,5840661012,5840661100,5840661101,5840661103,5840670021,5840670030,5840670031,5840670033,5840670211,5840670300,5840670301,5840670303,5840670330,5840670331,5840670333,5840672111,5840672113,5840673020,5840673021,5840673023,5840673210,5840673211,5840673300,5840673301,5840673310,5840673311,5841013322,5841013323,5841013332,5841103303,5841103312,5841103313,5841103321,5841103323,5841110301,5841110302,5841110303,5841110310,5841110312,5841110313,5841111011,5841111012,5841111013,5841112023,5841120002,5841120020,5841120022,5841120023,5841120230,5841120232,5841120322,5841123023,5841123031,5841123032,5841123033,5841123201,5841123202,5841123203,5841130123,5841130132,5841130233,5841130301,5841130303,5841130310,5841130312,5841130313,5841131202,5841131220,5841131222,5841132001,5841132002,5841132003,5841133000,5841133002,5841133030,5841133032,5841133210,5841133212,5841133230,5841133232,5841201101,5841201110,5841201111,5841210000,5841210001,5841210003,5841210211,5841210213,5841231010,5841231012,5841231210,5841231211,5841231212,5841231230,5841231232,5841233102,5841233122,5841233123,5841233310,5841233312,5841233313,5841331110,5841331111,5841331112,5841331130,5841331132,5841333110,5841333111,5841333112,5841333130,5841333132,5841333300,5841333301,5841333302,5841333320,5841333322,5841431120,5841431121,5841431122,5841431300,5841433100,5841433102,5841433103,5841530300,5841530301,5841530302,5841530310,5841530311,5841530320,5841530322,5841531100,5841531101,5841531200,5841531201,5841531210,5841532030,5841532031,5841532032,5841532100,5841532102,5841532230,5841532232,5841603210,5841603211,5841603212,5841603230,5841603232,5841603310,5841603311,5841612200,5841612201,5841612203,5841630010,5841630030,5841630210,5841630212,5841630213,5841630320,5841632030,5841632031,5841632200,5841632201,5841632202,5841632220,5841632221,5841632222,5841700100,5841700101,5841710011,5841710100,5841710101,5841710103,5841710121,5841710130,5841710131,5841710133,5841711030,5841711031,5841711032,5841711120,5841711121,5841711130,5841711131,5841711200,5841711201,5841711331,5841711333,5841713111,5841713113,5841713131,5841721110,5841721111,5841721112,5841721120,5841721121,5841721210,5841721211,5841721212,5841721220,5841721222,5841722130,5841722132,5841722300,5841722301,5841722310,5841730000,58402713302,58402713303,58402713312,58402713313,58402723212,58402723213,58402723223,58402723302,58402723303,58402723313,58402723331,58402723332,58402723333,58402730331,58402730332,58402730333,58402731021,58402731023,58402731201,58402731203,58402732032,58402732033,58402732103,58402732121,58402732122,58402732123,58402732202,58402732203,58403602312,58403602313,58403602321,58403602323,58403603202,58403611233,58403611311,58403611313,58403611321,58403611322,58403611323,58403612132,58403612133,58403612231,58403612233,58403612303,58403613002,58403613003,58403613011,58403613012,58403613013,58403620101,58403620103,58403620121,58403620233,58403620301,58403620303,58403620321,58403620322,58403620323,58403622011,58403622013,58403622031,58403622033,58403622211,58403622213,58403622231,58403622233,58403701001,58403701003,58404600011,58404600100,58404600101,58404600103,58404600121,58404600130,58404600131,58404603001,58404603003,58404603031,58404603033,58404603211,58404603213,58404603231,58404603233,58404621011,58404621120,58404621121,58404621302,58404621303,58404622221,58404622223,58404623031,58404623033,58405531113,58405531131,58405531133,58405531311,58405531313,58405600001,58405600003,58405600021,58405600023,58405600201,58405600203,58405602003,58405602021,58405602023,58405602201,58405602210,58405602211,58405602213,58405602231,58405602233,58405620002,58405620003,58405620221,58405620223,58405622010,58405622011,58405622013,58405622031,58405622033,58405622211,58405622300,58405622301,58405622303,58405622321,58405622323,58406600101,58406600110,58406600111,58406601000,58406601001,58406601003,58406601031,58406601033,58406610110,58406610111,58406611021,58406611023,58406700321,58406700323,58406702101,58406702130,58406702131,58406703020,58406703021,58406703210,58406703211,58406703320,58406703321,58406703323,58406721101,58406721103,58406721121,58406721123,58406721311,58406721313,58406730220,58406730221,58406732010,58406732011,58406732013,58406732031,58406732120,58406732121,58406732130,58406732131,58406733020,58406733021,58406733030,58406733031,58406733120,58406733121,58406733130,58406733131,58410132313,58410132323,58410132331,58410132332,58410132333,58410133202,58410133203,58410133212,58410133213,58410133302,58410133303,58410133312,58410133330,58410133332,58410133333,58410222222,58411033012,58411033013,58411033102,58411033103,58411033112,58411033113,58411102122,58411102123,58411102131,58411102132,58411102133,58411102213,58411102231,58411102233,58411110101,58411110102,58411110103,58411110231,58411110233,58411120011,58411120013,58411120221,58411120223,58411200000,58411200002,58411200003,58411200012,58411200030,58411200032,58411200210,58411200212,58411200320,58411200322,58411202100,58411202102,58411202120,58411202122,58411202123,58411202313,58411202331,58411202332,58411202333,58411203202,58411203203,58411203212,58411203230,58411203232,58411203233,58411203322,58411203323,58411203332,58411203333,58411230131,58411230133,58411230301,58411230303,58411231020,58411231022,58411231113,58411231131,58411231133,58411232001,58411232002,58411232003,58411301221,58411301223,58411301330,58411301332,58411302223,58411302232,58411302233,58411302303,58411302312,58411302313,58411302321,58411302322,58411302323,58411303001,58411303003,58411303021,58411303022,58411303023,58411303110,58411303112,58411312030,58411312032,58411312210,58411312212,58411320001,58411320002,58411320003,58411330330,58411330332,58411332110,58412002222,58412002223,58412002232,58412002233,58412003223,58412003232,58412003233,58412003322,58412003323,58412012233,58412012322,58412013232,58412013233,58412013322,58412013323,58412013332,58412013333,58412100021,58412100023,58412100201,58412100210,58412100211,58412100213,58412100231,58412102100,58412102101,58412102122,58412102123,58412102222,58412102223,58412102232,58412102233,58412310130,58412310132,58412311200,58412311202,58412311220,58412311222,58412312332,58412313000,58412313002,58412331000,58412331002,58412331200,58412331201,58412331202,58412331322,58412331323,58412331332,58412333110,58412333112,58412333113,58413311130,58413311131,58413311132,58413311310,58413311312,58413311330,58413311332,58413311333,58413331130,58413331131,58413331132,58413331310,58413331312,58413331330,58413331332,58413333100,58413333102,58414313020,58414313022,58414313200,58414313202,58414313220,58414313222,58414331120,58414331122,58414331300,58414331302,58414331320,58414331322,58414333100,58414333102,58414333120,58414333122,58414333300,58414333302,58414333320,58414333322,58415303030,58415303031,58415303130,58415303131,58415311020,58415311021,58415311022,58415311030,58415311031,58415311100,58415311200,58415311202,58415311220,58415311222,58415312020,58415312021,58415312030,58415321200,58415321202,58415322310,58415322311,58416022200,58416022201,58416022210,58416022211,58416022213,58416032130,58416032131,58416032132,58416032310,58416032312,58416032330,58416032332,58416033000,58416033001,58416033010,58416033011,58416033013,58416033031,58416033120,58416033121,58416033130,58416033131,58416122020,58416122021,58416122023,58416122201,58416122210,58416122211,58416300120,58416300122,58416300123,58416300320,58416300322,58416303020,58416303022,58416303220,58416303221,58416303222,58416320320,58416320321,58416320322,58416321000,58416321002,58416322030,58416322031,58416322032,58416322100,58416322102,58416322120,58416322230,58416322232,58416322300,58416322302,58417000111,58417000113,58417010000,58417010002,58417010020,58417010022,58417101231,58417101320,58417101321,58417103110,58417103111,58417110330,58417110331,58417111230,58417111231,58417111320,58417111321,58417111330,58417111331,58417112020,58417112021,58417112030,58417112031,58417112100,58417112101,58417113303,58417113321,58417113323,58417131101,58417131103,58417131121,58417131123,58417131301,58417131303,58417131321,58417131330,58417131331,58417211130,58417211132,58417211220,58417211300,58417211302,58417212130,58417212131,58417212210,58417212211,58417212300,58417212301,58417221310,58417221312,58417221330,58417221332,58417222000,58417222001,58417222010,58417222011,58417222100,58417222101,58417222110,58417222111,58417222113,58417222131,58417223020,58417223021,58417223030,58417223031,58417223110,58417223120,58417223121,
008,00,,506348437,141009375,510693750,145350000,57,54,121,298,588,1207,584077,594006,594007,594016,594017,594027,594037,594047,594057,594067,594077,594100,594101,594102,594103,594104,594110,594111,594112,594113,594114,594120,594121,594122,594123,594124,594130,594131,594132,594133,594134,594135,594140,594141,594142,594150,594151,594152,594160,594161,594162,594170,594171,594172,594173,604007,604100,604101,604102,604103,604110,604111,604112,604121,604122,604132,604133,5840663,5840761,5840762,5840763,5841702,5841703,5841712,5841723,5841731,5841732,5841733,5841740,5841742,5841743,5841750,5940053,5940151,5940260,5940261,5940263,5940361,5940463,5941150,5941152,5941250,5941252,5941253,5941360,5941362,5941441,5941450,5941451,5941532,5941533,5941630,5941631,5941632,5941740,5941742,6040170,6040171,6040173,6040271,6041130,6041132,6041200,6041201,6041230,6041232,6041233,6041310,6041311,6041340,6041342,58406603,58406612,58406613,58406720,58406722,58406723,58407513,58407531,58407533,58407601,58407602,58407603,58416323,58416330,58416332,58416333,58417002,58417003,58417011,58417012,58417013,58417102,58417130,58417132,58417133,58417213,58417301,58417302,58417303,58417411,58417412,58417413,58417520,58417521,58417522,59400511,59400512,59400513,59401531,59401533,59402620,59402621,59402623,59403601,59403630,59403631,59403633,59404611,59404612,59404613,59405610,59405611,59405613,59405632,59405633,59406610,59406611,59406612,59410500,59410502,59410520,59410522,59411510,59411512,59412510,59412512,59412513,59412622,59413630,59413632,59414300,59414302,59414311,59414320,59414322,59414400,59414401,59414520,59414521,59414522,59414530,59414531,59414533,59414600,59414620,59415300,59415302,59415303,59415312,59416330,59416332,59416333,60401720,60401721,60401723,60402701,60402703,60402730,60410400,60410402,60410420,60411310,60411332,60412021,60412030,60412031,60412033,60412310,60412312,60412313,60412422,60412423,60412432,60413131,60413410,60414210,60414301,60414310,60414311,60414312,60414410,584066021,584066023,584066102,584066103,584066112,584066113,584066201,584066210,584066211,584066213,584066231,584066232,584066233,584067020,584067022,584067023,584067210,584067212,584067322,584067323,584067332,584067333,584075113,584075303,584075321,584076001,584076002,584076003,584160332,584160333,584163031,584163033,584163122,584163123,584163211,584163212,584163213,584163310,584163312,584164220,584164222,584164223,584164232,584170000,584170002,584170003,584170012,584170013,584170101,584170102,584170103,584171000,584171002,584171003,584171030,584171032,584171033,584171122,584171123,584171130,584171131,584171132,584171310,584171312,584172222,584172223,584172232,584172233,584173001,584173002,584173003,584174101,584174102,584174103,584175120,584175230,584175232,584175302,594005033,594005101,594005103,594005212,594005213,594005231,594005232,594005233,594015301,594025111,594025113,594025131,594025133,594025311,594025313,594026220,594026221,594026223,594036321,594036323,594046101,594046103,594046211,594046213,594046231,594056231,594056232,594056233,594056311,594056312,594056313,594066011,594066013,594066030,594066031,594066033,594066130,594066131,594066300,594076111,594076113,594076131,594076133,594076311,594076313,594076331,594076333,594105212,594105230,594105232,594105233,594105322,594105323,594105332,594105333,594115110,594115300,594115301,594115302,594115320,594115322,594125110,594125112,594125113,594126202,594126232,594126233,594126322,594136100,594136122,594136123,594136312,594136330,594136332,594143010,594143011,594143012,594143100,594143101,594143131,594144020,594144021,594144030,594144031,594144300,594144311,594144313,594145230,594145231,594145232,594145320,594145321,594145323,594146010,594146011,594146012,594146020,594146021,594146022,594146100,594146101,594146102,594146110,594153012,594153013,594153102,594153103,594153112,594153130,594153132,594153133,594154220,594154222,594163310,594163311,594163312,594164000,594164022,594164222,594164223,594164231,594164232,594164233,594174102,594174120,594174122,594174123,594174300,594174302,594174320,604006111,604006113,604006131,604006133,604006311,604006313,604006330,604006331,604006333,604016333,604017221,604017222,604017223,604027000,604027001,604027003,604027021,604027210,604027211,604027310,604027311,604027320,604027321,604104010,604104011,604104012,604104030,604104220,604104221,604113110,604113112,604113120,604113121,604113122,604113300,604113302,604113303,604113330,604113332,604120200,604120201,604120320,604120321,604120323,604123110,604123112,604124202,604124332,604130111,604130113,604130131,604131201,604131210,604131211,604131213,604131300,604131301,604131303,604131330,604131331,604134110,604134112,604134120,604134122,604134123,604134300,604134302,604134320,604134322,604142000,604142001,604142010,604142011,604142013,604142031,604142120,604143000,604143001,604143003,604143130,604143131,604143132,604144000,604144001,604144002,604144010,604144011,604144013,604144112,604144121,5840660131,5840660132,5840660133,5840661013,5840662031,5840662120,5840662121,5840662123,5840662213,5840662231,5840662232,5840662233,5840662301,5840662302,5840662303,5840670020,5840670022,5840670023,5840670212,5840670320,5840670322,5840670323,5840672130,5840672132,5840672133,5840673200,5840673202,5840751122,5840751123,5840751211,5840751233,5840753003,5840753011,5840753012,5840753013,5840753021,5840753023,5840753201,5840753203,5840753221,5840753230,5840753231,5840753233,5840760001,5840760003,5841602222,5841602223,5841603302,5841612222,5841612223,5841630303,5841630321,5841630323,5841631200,5841631202,5841631203,5841631212,5841631322,5841631323,5841632033,5841632101,5841632102,5841632103,5841632211,5841632213,5841632231,5841632232,5841632233,5841642212,5841642332,5841642333,5841643231,5841643233,5841643320,5841643322,5841643323,5841643332,5841643333,5841652220,5841652222,5841652223,5841652231,5841652232,5841652233,5841652320,5841652322,5841652323,5841700010,5841700012,5841700013,5841700102,5841700103,5841701001,5841701003,5841710010,5841710012,5841710013,5841710102,5841710120,5841710122,5841710310,5841710312,5841710313,5841711122,5841711211,5841711212,5841711213,5841721123,5841721131,5841721132,5841721133,5841721223,5841721231,5841721232,5841721233,5841722202,5841722203,5841722212,5841722313,5841730001,5841730002,5841730003,5841741002,5841741003,5841751020,5841751022,5841751023,5841751220,5841751221,5841751222,5841752310,5841752311,5841753002,5940050311,5940050312,5940050313,5940051003,5940051020,5940051021,5940051023,5940052102,5940052103,5940052111,5940052112,5940052113,5940052300,5940052301,5940052303,5940150311,5940150312,5940150313,5940150331,5940150333,5940153001,5940153003,5940153031,5940153033,5940153213,5940153231,5940153233,5940251101,5940251102,5940251103,5940251121,5940251123,5940253103,5940253121,5940253123,5940253310,5940253311,5940262221,5940360010,5940360011,5940360013,5940360031,5940360310,5940360311,5940360313,5940360331,5940363201,5940363203,5940363221,5940363223,5940460332,5940460333,5940461001,5940461003,5940461021,5940461023,5940462103,5940462121,5940462122,5940462123,5940462211,5940462300,5940462301,5940462331,5940462333,5940560111,5940560113,5940561210,5940561211,5940561213,5940561231,5940562132,5940562133,5940562303,5940563022,5940563023,5940563031,5940563032,5940563033,5940563101,5940563102,5940563103,5940660101,5940660103,5940660121,5940660122,5940660123,5940660320,5940660321,5940660323,5940661320,5940661321,5940661322,5940661330,5940661331,5940662110,5940662111,5940663010,5940663012,5940663133,5940663311,5940663313,5940663331,5940663332,5940663333,5940761323,5940763101,5940763102,5940763103,5940763120,5940763121,5940763123,5940763301,5940763303,5940763321,5940763323,5941050100,5941050102,5941050120,5941050122,5941050300,5941050302,5941050320,5941050322,5941052100,5941052102,5941052103,5941052132,5941052310,5941052312,5941052313,5941053202,5941053212,5941053213,5941053302,5941053312,5941151110,5941151111,5941151120,5941151122,5941151300,5941151302,5941151320,5941151322,5941153030,5941153032,5941153210,5941153212,5941153230,5941153232,5941153233,5941251110,5941251112,5941251113,5941260202,5941260220,5941260222,5941262000,5941262002,5941262003,5941262012,5941262030,5941262032,5941262033,5941361020,5941361022,5941361200,5941361202,5941361203,5941361322,5941363100,5941363102,5941430130,5941430132,5941430300,5941430301,5941430302,5941430320,5941431021,5941431030,5941431031,5941431301,5941431330,5941431331,5941440220,5941440221,5941440230,5941440231,5941440320,5941440321,5941440330,5941440331,5941440333,5941443010,5941443101,5941443103,5941443121,5941443123,5941452330,5941452331,5941452332,5941453220,5941453221,5941453223,5941460130,5941460131,5941460132,5941460230,5941460231,5941460232,5941460300,5941460301,5941460302,5941461030,5941461031,5941462120,5941462122,5941462200,5941462201,5941462210,5941462211,5941530100,5941530102,5941530103,5941530110,5941530112,5941530113,5941531002,5941531310,5941531312,5941542000,5941542002,5941542022,5941542023,5941542031,5941542032,5941542033,5941542210,5941542211,5941542212,5941542230,5941542232,5941550000,5941550001,5941550010,5941550011,5941550100,5941551010,5941633130,5941633132,5941640010,5941640012,5941640020,5941640021,5941640022,5941640030,5941640200,5941640202,5941640203,5941642000,5941642001,5941642200,5941642202,5941642203,5941642212,5941642302,5941642303,5941643220,5941643222,5941741002,5941741030,5941741032,5941741210,5941741212,5941743010,5941743011,5941743012,5941743030,5941743032,5941743210,5941743220,5941743221,5941743222,6040061101,6040061103,6040061301,6040061303,6040061321,6040063103,6040063121,6040063123,6040063320,6040063321,6040161111,6040161333,6040163111,6040163113,6040172200,6040172201,6040172203,6040261110,6040261111,6040261113,6040270020,6040270021,6040270023,6040270231,6040270233,6040272011,6040272013,6040272120,6040272121,6040272130,6040272131,6040272133,6040273120,6040273121,6040273122,6040273130,6040273131,6040273221,6040273230,6040273300,6040273302,6041040130,6041040132,6041040310,6041040320,6041040322,6041042100,6041042102,6041042220,6041042221,6041042230,6041042231,6041131110,6041131112,6041131130,6041131132,6041131230,6041131231,6041131232,6041131300,6041133010,6041133012,6041133013,6041133120,6041133122,6041133123,6041202031,6041202033,6041202301,6041202310,6041202311,6041203220,6041203221,6041203223,6041231110,6041231112,6041231130,6041231132,6041240222,6041242000,6041242002,6041242003,6041242012,6041242030,6041242032,6041242122,6041242123,6041243022,6041243023,6041243032,6041243302,6041243303,6041243312,6041243330,6041243332,6041301100,6041301101,6041301123,6041301301,6041301303,6041301331,6041301333,6041312120,6041312121,6041313020,6041313021,6041313321,6041313330,6041313331,6041313333,6041341110,6041341112,6041341130,6041341132,6041341210,6041341211,6041341212,6041341300,6041343010,6041343011,6041343012,6041343030,6041343032,6041343212,6041343230,6041343232,6041343233,6041411111,6041420021,6041420030,6041420031,6041420120,6041420121,6041421100,6041421101,6041421102,6041421110,6041421111,6041421210,6041421211,6041421212,6041421220,6041421221,6041430021,6041430210,6041430211,6041430213,6041430300,6041430301,6041430310,6041430311,6041430313,6041430331,6041431330,6041431331,6041431332,6041440030,6041440031,6041440032,6041440120,6041440121,6041440200,6041440201,6041440311,6041441102,6041441132,6041441200,6041441201,6041441203,6041441221,6041441230,6041441300,58406601222,58406601223,58406601232,58406601233,58406601302,58406601303,58406602011,58406602013,58406602031,58406602033,58406602211,58406602213,58406602231,58406602233,58406610112,58406610113,58406611020,58406611022,58406620011,58406620013,58406620031,58406620033,58406620301,58406620303,58406621220,58406621221,58406621223,58406622213,58406622223,58406622231,58406622232,58406622233,58406622301,58406622302,58406622303,58406623001,58406623003,58406700320,58406700322,58406702100,58406702102,58406702103,58406702132,58406702133,58406703022,58406703023,58406703212,58406703213,58406703322,58406721100,58406721102,58406721120,58406721122,58406721310,58406721312,58406730222,58406730223,58406732012,58406732030,58406732032,58406732033,58406732122,58406732123,58406732132,58406732133,58406733022,58406733023,58406733032,58406733033,58406733122,58406733123,58406733132,58406733133,58407511122,58407511123,58407511132,58407511133,58407511203,58407511212,58407511213,58407512130,58407512131,58407512312,58407512313,58407512323,58407530003,58407530012,58407530013,58407530021,58407530023,58407530101,58407530102,58407530103,58407530201,58407530221,58407530223,58407532001,58407532003,58407532021,58407532321,58407532322,58407532323,58407600001,58407600003,58407600021,58407600022,58407600023,58416022202,58416022203,58416022212,58416032133,58416032311,58416032313,58416032331,58416032333,58416033002,58416033003,58416033012,58416033030,58416033032,58416033033,58416033122,58416033123,58416033132,58416033133,58416122022,58416122200,58416122202,58416122203,58416122212,58416122213,58416303011,58416303013,58416303021,58416303023,58416303223,58416310223,58416310232,58416312010,58416312012,58416312130,58416312132,58416313200,58416313202,58416313320,58416313322,58416320323,58416321001,58416321003,58416322033,58416322101,58416322103,58416322121,58416322122,58416322123,58416322231,58416322233,58416322301,58416322303,58416331100,58416331102,58416331120,58416331122,58416331300,58416331302,58416331320,58416331322,58416423300,58416423302,58416423303,58416423312,58416423313,58416432222,58416432233,58416432303,58416432321,58416432322,58416432323,58416433210,58416433212,58416433213,58416433302,58416433303,58416433312,58416433313,58416522210,58416522212,58416522213,58416522301,58416522302,58416522303,58416523210,58416523212,58416523213,58416523302,58416523320,58416523322,58416523323,58416523332,58416523333,58417000110,58417000112,58417010001,58417010003,58417010021,58417010023,58417101230,58417101232,58417101233,58417101322,58417101323,58417103112,58417103113,58417110332,58417110333,58417111232,58417111233,58417111322,58417111323,58417111332,58417111333,58417112022,58417112023,58417112032,58417112033,58417112102,58417112103,58417113300,58417113301,58417113302,58417113320,58417113322,58417131100,58417131102,58417131120,58417131122,58417131300,58417131302,58417131320,58417131322,58417131323,58417131332,58417131333,58417211131,58417211133,58417211221,58417211222,58417211223,58417211301,58417211303,58417212132,58417212133,58417212212,58417212213,58417212302,58417212303,58417221311,58417221313,58417221331,58417221333,58417222002,58417222003,58417222012,58417222013,58417222102,58417222103,58417222112,58417222130,58417222132,58417222133,58417223022,58417223023,58417223032,58417223033,58417223111,58417223112,58417223113,58417223122,58417223123,58417410000,58417410002,58417410003,58417410011,58417410012,58417410013,58417510002,58417510020,58417510022,58417510023,58417510032,58417510210,58417510212,58417510213,58417510302,58417510320,58417510322,58417512100,58417512230,58417512232,58417523120,58417523121,58417523122,58417523130,58417523131,58417523300,58417523302,58417523320,58417523322,58417530000,58417530002,58417530003,58417530012,58417530030,58417530032,58417532000,58417532001,58417532010,58417532011,59400501133,59400501311,59400501313,59400501331,59400510012,59400510013,59400510022,59400510023,59400510220,59400510221,59400510223,59400520311,59400520313,59400520331,59400521003,59400521012,59400521013,59400521102,59400521103,59400523021,59400523022,59400523023,59401501100,59401501101,59401501110,59401501111,59401501113,59401501131,59401501133,59401501311,59401501313,59401501331,59401501333,59401503102,59401503103,59401521111,59401530000,59401530001,59401530003,59401530021,59401530210,59401530211,59401530300,59401530301,59401530303,59401530321,59401532112,59401532113,59402510110,59402510111,59402511000,59402511001,59402511003,59402511200,59402511201,59402511203,59402511221,59402511223,59402531011,59402531013,59402531021,59402531023,59402531201,59402531203,59402531221,59402531223,59402533011,59402533013,59402533131,59402533133,59402622201,59402622230,59402622231,59402622233,59403600011,59403600013,59403600031,59403600120,59403600121,59403603330,59403603331,59403603333,59403621111,59403621113,59403621131,59403621133,59403621311,59403621313,59404603113,59404603131,59404603133,59404603231,59404603233,59404603311,59404603313,59404610222,59404610223,59404620332,59404620333,59404621003,59404621011,59404621012,59404621013,59404621021,59404621023,59404621201,59404621202,59404621203,59404622130,59404622131,59404623020,59404623021,59404623030,59404623031,59404623033,59404623211,59404623300,59404623301,59405612010,59405612011,59405612013,59405612031,59405612120,59405612121,59405612123,59405612301,59405612330,59405612331,59405623011,59405623013,59405623021,59405623023,59405630123,59405630132,59405630133,59405630212,59405630213,59405630301,59405630302,59405630303,59405631001,59405631002,59405631003,59406601001,59406601003,59406601021,59406601023,59406601201,59406601203,59406603221,59406603223,59406613331,59406613333,59406621011,59406621013,59406630110,59406630112,59406630130,59406630132,59406631311,59406631313,59406631321,59406631323,59406633101,59406633103,59406633121,59406633123,59406633233,59406633301,59406633302,59406633303,59407611011,59407611013,59407611031,59407611033,59407611211,59407611213,59407611231,59407611233,59407613011,59407613013,59407613031,59407613033,59407613203,59407613211,59407613212,59407613213,59407613221,59407613223,59407631001,59407631003,59407631220,59407631221,59407631223,59407633001,59407633003,59407633021,59407633023,59407633201,59407633203,59407633221,59407633223,59410501010,59410501012,59410501030,59410501032,59410501210,59410501212,59410501230,59410503212,59410503230,59410503232,59410521010,59410521012,59410521120,59410521122,59410521300,59410521302,59410523112,59410523113,59410532002,59410532003,59410532012,59410532030,59410532032,59410532033,59410532102,59410532103,59410532112,59410532113,59410533002,59410533003,59410533012,59410533030,59410533032,59410533033,59410533102,59410533103,59410533132,59410533133,59410622202,59410622220,59410622222,59411511120,59411511121,59411511122,59411511130,59411511131,59411511210,59411511211,59411511212,59411511230,59411511232,59411511300,59411513010,59411513012,59411513030,59411513032,59411530310,59411530311,59411530312,59411530330,59411530332,59411531000,59411531001,59411532110,59411532112,59411532130,59411532132,59411532310,59411532312,59411600000,59412602002,59412602003,59412620130,59412620132,59412620310,59412620312,59412620313,59412623022,59412623023,59412623032,59412623033,59412623122,59412623123,59412623132,59413610210,59413610211,59413612012,59413612013,59413612102,59413612120,59413612122,59413612123,59413612132,59413612133,59413613022,59413613200,59413613202,59413613230,59413613232,59413631010,59413631012,59413631030,59413631032,59413631033,59414301310,59414301312,59414301330,59414301332,59414303220,59414303221,59414313001,59414313003,59414313031,59414313320,59414313321,59414313330,59414313331,59414321002,59414321020,59414321022,59414323000,59414323002,59414323020,59414323022,59414323200,59414323202,59414323220,59414323222,59414323223,59414323233,59414323322,59414323323,59414323332,59414402220,59414402221,59414402230,59414402231,59414402320,59414402321,59414402330,59414402331,59414403220,59414403221,59414403230,59414403231,59414403320,59414403321,59414403323,59414421101,59414421110,59414421111,59414421113,59414430110,59414430111,59414430112,59414431000,59414431001,59414433100,59414433101,59414433110,59414433111,59414433113,59414433131,59414433133,59414433311,59414523330,59414523331,59414532220,59414532221,59414602330,59414602331,59414602332,59414603030,59414603031,59414603032,59414603100,59414603102,59414603120,59414603200,59414603201,59414603210,59414621022,59414621023,59414622020,59414622021,59414622022,59414622030,59414622031,59414622120,59414622121,59414622130,59414622131,59414622200,59414623000,59414623001,59415301011,59415301012,59415301013,59415301110,59415301112,59415301113,59415310002,59415310003,59415310012,59415310030,59415310032,59415310033,59415310122,59415310123,59415310132,59415310133,59415311022,59415311023,59415311032,59415311033,59415311302,59415311320,59415311322,59415313110,59415313112,59415313130,59415313132,59415402220,59415402222,59415402223,59415402232,59415420010,59415420012,59415420030,59415420032,59415420123,59415420132,59415420133,59415420200,59415420202,59415420203,59415420212,59415420213,59415420301,59415420302,59415420303,59415421022,59415421200,59415421202,59415421220,59415421222,59415422130,59415422131,59415422132,59415422310,59415422312,59415422330,59415422332,59415423000,59415423002,59415423020,59415501010,59415501012,59415510011,59415510013,59415510110,59415510112,59416331310,59416331312,59416331330,59416331332,59416400230,59416400231,59416400232,59416402010,59416402012,59416422010,59416422012,59416422132,59416422133,59416432020,59416432022,59416432023,59416432032,59416432210,59416432212,59416432230,59416432232,59417410000,59417410002,59417410030,59417410032,59417410330,59417410332,59417412110,59417412112,59417412130,59417412132,59417412133,59417413022,59417413200,59417413202,59417413220,59417413222,59417430130,59417430131,59417430132,59417430310,59417430312,59417430330,59417430332,59417431000,59417431002,59417431020,59417432110,59417432230,59417432232,60400611001,60400611003,60400611021,60400611023,60400611201,60400611210,60400611211,60400611213,60400611231,60400611233,60400613001,60400613003,60400613021,60400613023,60400613201,60400613203,60400613231,60400613233,60400631011,60400631013,60400631021,60400631023,60400631201,60400631203,60400631221,60400631222,60400631223,60400633221,60400633230,60400633231,60400633233,60401611011,60401611100,60401611101,60401611103,60401611121,60401611130,60401611131,60401611133,60401611311,60401613133,60401613311,60401613313,60401613321,60401613323,60401631101,60401631103,60401631121,60401631123,60401631301,60401631310,60401631311,60401631313,60401633123,60401633132,60401633133,60401722022,60401722023,60402611120,60402611121,60402611123,60402702011,60402702013,60402702031,60402702033,60402702211,60402702300,60402702301,60402702303,60402702321,60402720101,60402720103,60402720121,60402721321,60402721323,60402731230,60402731232,60402732200,60402732201,60402732230,60402732231,60402732310,60402732311,60402732312,60402732320,60402732321,60402732330,60402733200,60402733201,60410401310,60410401311,60410403120,60410403122,60410410000,60410410001,60410410010,60410421200,60410421201,60410421202,60410421220,60410421222,60410422220,60410422221,60410422230,60410422231,60410422320,60410422321,60410422330,60410423000,60410423002,60410423020,60410423022,60410423200,60410423202,60411311110,60411311111,60411311112,60411311130,60411311132,60411311310,60411311312,60411311330,60411311332,60411312330,60411312331,60411312332,60411313020,60411313022,60411313200,60411313202,60411313220,60411330110,60411330112,60411331020,60411331022,60411331212,60411331213,60411333102,60411333120,60411333122,60411333300,60411333302,60411333320,60411333322,60412023001,60412023003,60412023030,60412023031,60412023120,60412023121,60412023130,60412023131,60412032220,60412032221,60412032223,60412311110,60412311112,60412311130,60412311132,60412311310,60412311312,60412311330,60412311332,60412311333,60412402002,60412402020,60412402022,60412402230,60412402232,60412420010,60412420012,60412420132,60412420310,60412420312,60412420330,60412420332,60412420333,60412421202,60412421203,60412421212,60412421213,60412421302,60412421320,60412421322,60412421323,60412421332,60412421333,60412430202,60412430203,60412430212,60412430213,60412430302,60412430303,60412430332,60412430333,60412431222,60412433000,60412433002,60413010001,60413010010,60413010011,60413010100,60413010101,60413010110,60413010111,60413010113,60413011031,60413011033,60413011211,60413011212,60413011213,60413013003,60413013021,60413013210,60413013211,60413013300,60413013301,60413013303,60413013321,60413031110,60413031111,60413120000,60413120001,60413120010,60413120011,60413120013,60413120031,60413120033,60413121231,60413121233,60413130220,60413130222,60413130231,60413130233,60413132101,60413132110,60413132111,60413133200,60413133201,60413133230,60413133231,60413133320,60413133321,60413133323,60413412130,60413412131,60413412132,60413413010,60413413012,60413413020,60413413200,60413413202,60413413220,60413413222,60413430132,60413430310,60413430312,60413430330,60413430332,60413431000,60413431002,60413432100,60413432101,60413432130,60413432132,60413432310,60413432312,60413433220,60413433222,60414201230,60414201231,60414201233,60414203011,60414203013,60414203031,60414203033,60414203211,60414203300,60414203301,60414203310,60414203311,60414203313,60414203331,60414211030,60414211032,60414211131,60414211133,60414211202,60414211220,60414211222,60414212130,60414212131,60414212220,60414212221,60414212230,60414212231,60414212300,60414212301,60414212302,60414212320,60414213000,60414300230,60414300231,60414302120,60414302121,60414302123,60414302301,60414302310,60414302311,60414303020,60414303021,60414303022,60414303030,60414303031,60414303120,60414303121,60414303200,60414303330,60414303331,60414303333,60414313330,60414313331,60414313332,60414400330,60414400331,60414401220,60414401221,60414401231,60414402020,60414402021,60414402022,60414402030,60414402031,60414402100,60414402101,60414402200,60414403100,60414403101,60414403103,60414403121,60414403130,60414403131,60414411000,60414411002,60414411003,60414411012,60414411030,60414411032,60414411033,60414411122,60414411300,60414411302,60414411303,60414412020,60414412021,60414412230,60414412231,60414412310,60414412311,60414412312,60414412320,60414412321,60414412323,60414412330,60414412332,60414413010,60414413011,60414413012,60414413020,60414413021,60414413022,60414413030,60414413100,60414413101,60414413200,
009,00,,509020312,140156250,511495312,145621875,16,51,125,329,677,1427,584144,584154,584155,584166,584176,594127,594156,594165,594166,594175,594176,604105,604114,604115,604125,604135,5841450,5841452,5841453,5841462,5841533,5841560,5841562,5841640,5841641,5841650,5841651,5841653,5941051,5941060,5941061,5941063,5941072,5941161,5941162,5941163,5941170,5941172,5941261,5941370,5941372,5941433,5941463,5941470,5941472,5941541,5941543,5941552,5941553,5941570,5941572,5941641,5941670,5941672,5941770,5941772,6041043,6041060,6041061,6041062,6041160,6041162,6041241,6041262,6041450,6041451,6041452,58413532,58414510,58414512,58414513,58414612,58415313,58415323,58415613,58415630,58415632,58416301,58416311,58416420,58416421,58416430,58416431,58416520,58416521,58416700,58416720,58416722,58417511,58417513,58417531,58417533,58417700,58417702,58417720,58417722,58417732,59410530,59410531,59410620,59410621,59410623,59410700,59410702,59410703,59410712,59410732,59411533,59411601,59411602,59411603,59411710,59411711,59411712,59411732,59411733,59412600,59412601,59412603,59412621,59412630,59412631,59412633,59413611,59413710,59413711,59413712,59413730,59413732,59414312,59414420,59414422,59414423,59414432,59414612,59414613,59414710,59414712,59414730,59414732,59415400,59415401,59415403,59415502,59415503,59415511,59415512,59415513,59415710,59415712,59415730,59415732,59416401,59416403,59416421,59416430,59416431,59416433,59416710,59416712,59417411,59417433,59417712,59421000,59422000,59422002,59422020,59422021,59422022,59423000,59423002,60410411,60410412,60410413,60410630,60410700,60411630,60411631,60411632,60412400,60412401,60412403,60412600,60412602,60413600,60413601,60413602,60413620,60413622,60414431,60414530,60414532,584133333,584134222,584134223,584134232,584134233,584134322,584134323,584134331,584134332,584134333,584135122,584135123,584135202,584135213,584135231,584135300,584135302,584135332,584135333,584143111,584143113,584143131,584143133,584145110,584145112,584146020,584146022,584146023,584146031,584146032,584146033,584146300,584146302,584146303,584146312,584146320,584146321,584146322,584146330,584153033,584153113,584153122,584153123,584153211,584153213,584156121,584156122,584156123,584156310,584156311,584156332,584156333,584157002,584157003,584157020,584157021,584157220,584157222,584157223,584163100,584163101,584163103,584163130,584163131,584164230,584164231,584164320,584164321,584164330,584164331,584165220,584165221,584165230,584165231,584167010,584167012,584167022,584167023,584167210,584167212,584167213,584167230,584167231,584167232,584167302,584167320,584167322,584167323,584175101,584175123,584175301,584175303,584175321,584175322,584175323,584177030,584177032,584177212,584177213,584177230,584177231,584177233,584177330,584177332,594105011,594105013,594105031,594105033,594106220,594106221,594106223,594107012,594107101,594107102,594107302,594107333,594115131,594115133,594115311,594115312,594115313,594116001,594116002,594116003,594117130,594117131,594117300,594117302,594117303,594126021,594126023,594126320,594126321,594126323,594136101,594136103,594136131,594136133,594136311,594136313,594136331,594136333,594137131,594137330,594137332,594143031,594143033,594143132,594143211,594143212,594143213,594143231,594144210,594144212,594144213,594144302,594144303,594144330,594144332,594146033,594146111,594146112,594146113,594146211,594146213,594146223,594146231,594146232,594146233,594147110,594147112,594147132,594147310,594147312,594147330,594147332,594147333,594153111,594154020,594154021,594154023,594154211,594154213,594154231,594154232,594154233,594155002,594155003,594155011,594155012,594155013,594155102,594155103,594157110,594157112,594157130,594157131,594157132,594157310,594157312,594157330,594157332,594164021,594164023,594164201,594164202,594164203,594164321,594164323,594167110,594167112,594167130,594167132,594167300,594167301,594167302,594167320,594167322,594174101,594174131,594174133,594174311,594174312,594174313,594174323,594177300,594177302,594177320,594210010,594210012,594210020,594210021,594210023,594210030,594210032,594210201,594210210,594210211,594210212,594210220,594210222,594220031,594220032,594220033,594220230,594220231,594220300,594230200,594230201,594230203,604104033,604104101,604104102,604104103,604104211,604104213,604104231,604104233,604106310,604106311,604106320,604106321,604106322,604107010,604107020,604107022,604113131,604113133,604113311,604113313,604116100,604116102,604116120,604116122,604116123,604116330,604116331,604116332,604124021,604124023,604124210,604124211,604124300,604124301,604124310,604124311,604124313,604126010,604126011,604126012,604126030,604126032,604126100,604126101,604126302,604126320,604126322,604134131,604134133,604134311,604134312,604134313,604134330,604134331,604134333,604136030,604136031,604136032,604136100,604136102,604136210,604136212,604144133,604144330,604144331,604144333,604145310,604145311,604146000,604146001,604146002,604146020,604155001,604155010,604155011,604155013,604155031,604155100,604155102,5841333303,5841333312,5841333321,5841333323,5841343131,5841343132,5841343133,5841343203,5841343212,5841343213,5841343301,5841343302,5841343303,5841351032,5841351201,5841351202,5841351203,5841351210,5841351212,5841351213,5841351302,5841351320,5841351321,5841351322,5841352002,5841352003,5841352113,5841352121,5841352123,5841352200,5841352202,5841352220,5841352222,5841352223,5841352301,5841352303,5841352322,5841352323,5841352331,5841352332,5841352333,5841353010,5841353011,5841353013,5841353031,5841353032,5841353033,5841353100,5841353102,5841353120,5841353122,5841353300,5841353302,5841353303,5841353311,5841353312,5841353313,5841431123,5841431301,5841431303,5841431321,5841431323,5841433101,5841433110,5841433111,5841433113,5841433131,5841433133,5841433311,5841433313,5841433331,5841433333,5841451110,5841451111,5841451112,5841451130,5841451132,5841451133,5841460021,5841460022,5841460023,5841460210,5841460212,5841460213,5841460302,5841461300,5841461302,5841461303,5841461320,5841461321,5841463132,5841463133,5841463310,5841463311,5841472022,5841472200,5841472223,5841530312,5841530321,5841530323,5841531111,5841531112,5841531113,5841531121,5841531123,5841531211,5841531212,5841531213,5841532033,5841532101,5841532103,5841532121,5841532122,5841532123,5841532233,5841561000,5841561002,5841561020,5841561022,5841561033,5841561113,5841561122,5841561123,5841561131,5841561132,5841561133,5841561200,5841561202,5841561203,5841563120,5841563121,5841563122,5841563300,5841563302,5841563303,5841563311,5841563312,5841563313,5841570001,5841570002,5841570003,5841570010,5841570012,5841570013,5841570122,5841570123,5841570132,5841570220,5841570222,5841570231,5841570300,5841570301,5841570310,5841572000,5841572212,5841572213,5841572322,5841630011,5841630013,5841630031,5841630033,5841630211,5841630300,5841631020,5841631021,5841631210,5841631211,5841631321,5841631330,5841631331,5841631333,5841633111,5841633113,5841633131,5841633133,5841642210,5841642211,5841642213,5841643220,5841643221,5841652331,5841670110,5841670112,5841670130,5841670132,5841670200,5841670202,5841670212,5841670322,5841670323,5841672110,5841672112,5841672331,5841673003,5841673030,5841673031,5841673320,5841673322,5841751001,5841751031,5841751033,5841751211,5841751212,5841751213,5841752331,5841752333,5841753202,5841753203,5841770122,5841770123,5841770130,5841770132,5841770133,5841770310,5841770312,5841770330,5841772100,5841772320,5841772321,5841773020,5841773022,5841773023,5841773032,5841773033,5841773122,5841773332,5941050301,5941050303,5941052110,5941052111,5941052113,5941052131,5941052133,5941053311,5941062221,5941062223,5941070102,5941070131,5941070132,5941070133,5941071001,5941071030,5941071032,5941071033,5941071100,5941071101,5941071103,5941071110,5941071112,5941071131,5941073000,5941073002,5941073011,5941073032,5941073322,5941073323,5941151131,5941151132,5941151133,5941151321,5941151323,5941153101,5941153102,5941153103,5941160001,5941160002,5941160003,5941171331,5941173010,5941173011,5941173012,5941173122,5941173123,5941173132,5941173133,5941251111,5941260201,5941260203,5941260221,5941260223,5941262001,5941262010,5941262011,5941262300,5941262301,5941262310,5941262311,5941361023,5941361211,5941361300,5941361301,5941361303,5941361321,5941371300,5941371301,5941371303,5941371322,5941371331,5941371333,5941373100,5941373102,5941373111,5941373120,5941373122,5941373123,5941373132,5941373310,5941430303,5941430321,5941430323,5941431020,5941431022,5941431023,5941431032,5941431033,5941431302,5941432101,5941432103,5941432301,5941432303,5941432321,5941432330,5941432331,5941442112,5941442113,5941443012,5941443013,5941443102,5941443120,5941443122,5941443312,5941443330,5941443332,5941443333,5941460133,5941460311,5941460313,5941460322,5941460323,5941461032,5941461033,5941462100,5941462101,5941462103,5941462121,5941462123,5941462221,5941462222,5941462223,5941462301,5941462302,5941462303,5941471110,5941471112,5941471130,5941471132,5941471300,5941471302,5941471303,5941471330,5941471332,5941473110,5941473112,5941473130,5941473132,5941473310,5941473312,5941531010,5941531011,5941531100,5941531101,5941531131,5941531133,5941540220,5941540221,5941542010,5941542011,5941542100,5941542101,5941542103,5941542121,5941542123,5941542301,5941542303,5941550002,5941550003,5941550012,5941550013,5941550102,5941550103,5941551000,5941551002,5941551003,5941551012,5941551013,5941571110,5941571111,5941571112,5941571130,5941571132,5941571133,5941571330,5941571331,5941571332,5941573110,5941573112,5941573130,5941573132,5941573310,5941573311,5941573312,5941573330,5941573332,5941640011,5941640013,5941640031,5941640032,5941640033,5941642002,5941642003,5941642210,5941642211,5941642300,5941642301,5941643200,5941643201,5941671110,5941671112,5941673030,5941673032,5941673100,5941673101,5941673102,5941673210,5941741001,5941741031,5941741300,5941741301,5941741303,5941741321,5941741323,5941743101,5941743103,5941743212,5941743213,5941771000,5941771002,5941771020,5941771022,5941773010,5941773011,5941773012,5941773030,5941773032,5941773033,5941773210,5941773212,5941773220,5941773221,5941773222,5942000020,5942002220,5942002222,5942002223,5942002232,5942002233,5942002322,5942100220,5942100221,5942100223,5942100330,5942100332,5942102001,5942102021,5942102022,5942102023,5942102130,5942102131,5942102132,5942102232,5942102233,5942102300,5942102301,5942102310,5942103000,5942103002,5942103020,5942200120,5942200122,5942200133,5942200300,5942200302,5942200303,5942201022,5942201200,5942201202,5942201220,5942201222,5942201223,5942202322,5942203020,5942203021,5942203022,5942203200,5942203202,5942300100,5942300102,5942300120,5942300300,5942300302,5942302021,5942302023,5942302201,5942302210,5942302211,5942402222,5942500000,5942500200,6041040133,6041040311,6041040313,6041040321,6041040323,6041041002,6041041003,6041042101,6041042103,6041042121,6041042123,6041042301,6041042303,6041042321,6041042322,6041042323,6041063120,6041063121,6041063122,6041063230,6041063231,6041063232,6041070110,6041070111,6041070113,6041070210,6041070211,6041070212,6041071000,6041072000,6041072001,6041131301,6041131303,6041131321,6041131323,6041133100,6041133101,6041133103,6041133311,6041133313,6041133331,6041133333,6041161010,6041161012,6041161030,6041161032,6041161210,6041161212,6041163330,6041163332,6041172002,6041172020,6041172022,6041240201,6041240203,6041240220,6041240221,6041242010,6041242011,6041242131,6041243031,6041243120,6041243121,6041243123,6041243301,6041243310,6041243311,6041243313,6041243331,6041243333,6041260130,6041260131,6041260132,6041260310,6041260312,6041260313,6041260330,6041260332,6041260333,6041261020,6041261021,6041261100,6041263002,6041263003,6041263012,6041263013,6041263030,6041263031,6041263032,6041263210,6041263212,6041341111,6041341113,6041341131,6041341133,6041341303,6041341321,6041341323,6041343101,6041343102,6041343103,6041343211,6041343320,6041343321,6041343323,6041360330,6041360331,6041360332,6041361200,6041362110,6041362112,6041362300,6041441110,6041441111,6041441113,6041441131,6041441133,6041441311,6041441312,6041441313,6041441321,6041441322,6041441323,6041443011,6041443013,6041443031,6041443033,6041443211,6041443213,6041443320,6041443321,6041443323,6041453120,6041453121,6041453122,6041453130,6041453300,6041453302,6041453320,6041453322,6041460030,6041460031,6041460220,6041460221,6041460222,6041541111,6041550000,6041550001,6041550121,6041551010,6041551011,6041551012,6041551100,6041551200,6041551202,5942002202,5841773121,5841773130,6041263000,58413333101,58413333103,58413333110,58413333112,58413333130,58413333132,58413422123,58413422132,58413422133,58413423022,58413423023,58413423032,58413423033,58413423122,58413423123,58413423132,58413423133,58413431131,58413431133,58413431232,58413431233,58413431301,58413431302,58413431303,58413432012,58413432013,58413432022,58413432023,58413432102,58413432103,58413432112,58413432113,58413433002,58413433003,58413510231,58413510232,58413510233,58413510330,58413510332,58413512002,58413512003,58413512110,58413512112,58413512113,58413513002,58413513003,58413513032,58413513033,58413513122,58413513230,58413513231,58413513232,58413513300,58413513302,58413513320,58413521111,58413521113,58413521121,58413521123,58413522010,58413522012,58413522030,58413522032,58413522210,58413522212,58413522331,58413522333,58413523300,58413523301,58413523303,58413530120,58413530121,58413530122,58413530300,58413530302,58413530303,58413531010,58413531012,58413531030,58413531323,58413531332,58413531333,58413533012,58413533013,58413533101,58413533102,58413533103,58413622002,58413622020,58413622022,58413622200,58413622202,58413622220,58414313021,58414313023,58414313201,58414313203,58414313221,58414313223,58414331121,58414331123,58414331301,58414331303,58414331321,58414331323,58414333101,58414333103,58414333121,58414333123,58414333301,58414333303,58414333321,58414333323,58414511130,58414511131,58414511312,58414511313,58414600201,58414600202,58414600203,58414600302,58414600320,58414600322,58414600323,58414600332,58414601322,58414601323,58414601332,58414601333,58414602110,58414602112,58414602113,58414603002,58414603003,58414603012,58414603030,58414603032,58414603033,58414610222,58414610223,58414610232,58414610233,58414610322,58414610323,58414610332,58414610333,58414611222,58414611223,58414611232,58414613010,58414613012,58414613013,58414613220,58414613221,58414613222,58414613230,58414613231,58414630100,58414630101,58414630102,58414630110,58414630111,58414630120,58414630122,58414630123,58414630132,58414630133,58414631000,58414631022,58414631023,58414631032,58414631033,58414631123,58414631132,58414631301,58414631302,58414631303,58414631310,58414631312,58414631313,58414632300,58414632301,58414632302,58414632310,58414632311,58414632320,58414632322,58414633120,58414633121,58414633130,58414633131,58414633200,58414633201,58414633210,58414633211,58414720202,58414720203,58414722020,58414722021,58414722221,58414722223,58415303032,58415303033,58415303132,58415303133,58415311023,58415311032,58415311033,58415311101,58415311102,58415311103,58415311201,58415311203,58415311221,58415311223,58415312022,58415312023,58415312031,58415312032,58415312033,58415321201,58415321203,58415322312,58415322313,58415610010,58415610011,58415610100,58415610312,58415610313,58415610322,58415610323,58415611123,58415611202,58415611203,58415611212,58415611213,58415611301,58415611302,58415611303,58415612012,58415612013,58415631230,58415631232,58415633010,58415633012,58415633101,58415633103,58415700001,58415700003,58415701022,58415701200,58415701202,58415701203,58415701212,58415701213,58415701302,58415701303,58415702210,58415702211,58415702300,58415702301,58415702303,58415702321,58415702330,58415702331,58415703020,58415703021,58415703022,58415703030,58415703200,58415703202,58415703220,58415720020,58415720022,58415722100,58415722102,58415723200,58415723202,58415723230,58415723232,58415723233,58415723322,58415723323,58416300121,58416300321,58416300323,58416303010,58416303012,58416310220,58416310221,58416310222,58416310230,58416310231,58416310233,58416312011,58416312013,58416312131,58416312133,58416313201,58416313203,58416313321,58416313323,58416331101,58416331103,58416331121,58416331123,58416331301,58416331303,58416331321,58416331323,58416423301,58416423310,58416423311,58416432220,58416432221,58416432223,58416432230,58416432231,58416432232,58416432300,58416432301,58416432302,58416432320,58416433211,58416433300,58416433301,58416433310,58416433311,58416522211,58416522300,58416523211,58416523300,58416523301,58416523303,58416523321,58416523330,58416523331,58416701312,58416701330,58416701332,58416702010,58416702011,58416702031,58416702033,58416703200,58416703202,58416703322,58416703323,58416703332,58416721110,58416721112,58416721130,58416721132,58416721133,58416723300,58416723301,58416723303,58416730003,58416730012,58416730013,58416730021,58416730022,58416730023,58416730102,58416730120,58416730122,58416730123,58416730132,58416730133,58416730320,58416730321,58416730322,58416732100,58416732102,58416732120,58416732122,58416733210,58416733212,58416733230,58416733232,58417410001,58417410010,58417510000,58417510001,58417510003,58417510021,58417510030,58417510031,58417510033,58417510211,58417510300,58417510301,58417510303,58417510321,58417510323,58417512101,58417512102,58417512103,58417512231,58417512233,58417523123,58417523132,58417523133,58417523301,58417523303,58417523321,58417523323,58417530001,58417530010,58417530011,58417530013,58417530031,58417530033,58417532002,58417532003,58417532012,58417532013,58417701000,58417701002,58417701020,58417701022,58417701033,58417701122,58417701123,58417701132,58417701202,58417701203,58417701211,58417701212,58417701213,58417701310,58417701312,58417701313,58417703110,58417703111,58417703112,58417703130,58417703132,58417703310,58417703312,58417710202,58417710220,58417710222,58417712000,58417721010,58417721012,58417721020,58417721022,58417721023,58417721032,58417721033,58417721122,58417721123,58417723222,58417723231,58417723233,58417730210,58417730212,58417731230,58417731232,58417733302,58417733303,59410501011,59410501013,59410501031,59410501033,59410501211,59410501213,59410501231,59410501232,59410501233,59410503210,59410503211,59410503213,59410503231,59410503233,59410521011,59410521013,59410521121,59410521123,59410521301,59410521303,59410523110,59410523111,59410532000,59410532001,59410532010,59410532011,59410532013,59410532031,59410532100,59410532101,59410532110,59410532111,59410533000,59410533001,59410533010,59410533011,59410533013,59410533031,59410533100,59410533101,59410533130,59410533131,59410622200,59410622201,59410622203,59410622221,59410622223,59410701000,59410701002,59410701003,59410701012,59410701030,59410701032,59410701033,59410701301,59410701303,59410710022,59410710023,59410710032,59410711112,59410711130,59410711132,59410711133,59410711211,59410711300,59410711301,59410711303,59410711321,59410711330,59410711331,59410713020,59410713022,59410713200,59410713202,59410713220,59410713222,59410730010,59410730012,59410730030,59410730032,59410730101,59410730103,59410730300,59410730302,59410731000,59410731002,59410733022,59410733033,59410733122,59410733123,59410733132,59410733133,59410733200,59410733202,59410733203,59410733211,59410733212,59410733213,59411511123,59411511132,59411511133,59411511213,59411511231,59411511233,59411511301,59411511302,59411511303,59411513011,59411513013,59411513031,59411513033,59411530313,59411530331,59411530333,59411531002,59411531003,59411532111,59411532113,59411532131,59411532133,59411532311,59411532313,59411600001,59411600002,59411600003,59411713200,59411713202,59411713301,59411713303,59411730130,59411730131,59411731200,59411731202,59412602000,59412602001,59412620131,59412620133,59412620311,59412623020,59412623021,59412623030,59412623031,59412623120,59412623121,59412623130,59412623131,59412623133,59413610212,59413610213,59413612010,59413612011,59413612100,59413612101,59413612103,59413612121,59413612130,59413612131,59413613020,59413613021,59413613023,59413613201,59413613203,59413613231,59413613233,59413631011,59413631013,59413631031,59413713020,59413713022,59413713200,59413713202,59413713211,59413713230,59413713232,59413713300,59413713301,59413713303,59413713321,59413731010,59413731012,59413731030,59413731032,59413731130,59413731131,59413731133,59413731210,59413731212,59413731213,59413731302,59413731303,59413731332,59413733110,59413733112,59413733120,59413733121,59414301311,59414301313,59414301331,59414301333,59414303222,59414303223,59414313000,59414313002,59414313030,59414313032,59414313033,59414313322,59414313323,59414313332,59414313333,59414321000,59414321001,59414321003,59414321021,59414321023,59414323001,59414323003,59414323021,59414323023,59414323201,59414323203,59414323221,59414323230,59414323231,59414323232,59414323320,59414323321,59414323330,59414323331,59414323333,59414402222,59414402223,59414402232,59414402233,59414402322,59414402323,59414402332,59414402333,59414403222,59414403223,59414403232,59414403233,59414403322,59414421100,59414421102,59414421103,59414421112,59414430113,59414431002,59414431003,59414433102,59414433103,59414433112,59414433130,59414433132,59414433310,59414433312,59414433313,59414523332,59414523333,59414532222,59414532223,59414602333,59414603033,59414603101,59414603103,59414603121,59414603122,59414603123,59414603202,59414603203,59414603211,59414603212,59414603213,59414621020,59414621021,59414622023,59414622032,59414622033,59414622122,59414622123,59414622132,59414622133,59414622201,59414622202,59414622203,59414623002,59414623003,59414711132,59414711310,59414711312,59414711330,59414711332,59414713010,59414713012,59414713013,59414713330,59414713332,59414731110,59414731112,59414731132,59414731310,59414731312,59414733110,59414733112,59414733130,59414733132,59415301010,59415301111,59415310000,59415310001,59415310010,59415310011,59415310013,59415310031,59415310120,59415310121,59415310130,59415310131,59415311020,59415311021,59415311030,59415311031,59415311300,59415311301,59415311303,59415311321,59415311323,59415313111,59415313113,59415313131,59415313133,59415402221,59415402230,59415402231,59415402233,59415420011,59415420013,59415420031,59415420033,59415420120,59415420121,59415420122,59415420130,59415420131,59415420201,59415420210,59415420211,59415420300,59415421020,59415421021,59415421023,59415421201,59415421203,59415421221,59415421223,59415422133,59415422311,59415422313,59415422331,59415422333,59415423001,59415423003,59415423021,59415423022,59415423023,59415501011,59415501013,59415510010,59415510012,59415510111,59415510113,59415711130,59415711132,59415711310,59415711312,59415711313,59415713330,59415713331,59415713332,59415731110,59415731112,59415731130,59415731132,59415731312,59415731330,59415731332,59415733130,59415733131,59415733132,59415733310,59415733312,59416331311,59416331313,59416331331,59416331333,59416400233,59416402011,59416402013,59416422011,59416422013,59416422130,59416422131,59416432021,59416432030,59416432031,59416432033,59416432211,59416432213,59416432231,59416432233,59416730310,59416730311,59416731030,59416731032,59416732120,59416732121,59416732122,59416732300,59416732302,59416732320,59416732322,59417410001,59417410003,59417410031,59417410033,59417410331,59417410333,59417412111,59417412113,59417412131,59417413020,59417413021,59417413023,59417413201,59417413203,59417413221,59417413223,59417430133,59417430311,59417430313,59417430331,59417430333,59417431001,59417431003,59417431021,59417431022,59417431023,59417432111,59417432112,59417432113,59417432231,59417432233,59417710010,59417710012,59417710030,59417710032,59417710210,59417710212,59417710230,59417710232,59417713022,59417713200,59417713202,59417730130,59417730131,59417732110,59417732111,59417732230,59417732232,59417732300,59417732302,59420000220,59420000221,59420022032,59420022210,59420022212,59420022213,59420022302,59420022303,59420022312,59420022313,59420023202,59420023203,59420023212,59420023230,59420023232,59420023233,59421001100,59421001102,59421001120,59421001122,59421001300,59421001302,59421001320,59421001322,59421002221,59421002223,59421003100,59421003102,59421003120,59421003122,59421003123,59421003132,59421003310,59421003312,59421003330,59421003332,59421003333,59421020001,59421020030,59421020031,59421020300,59421020301,59421020302,59421020310,59421020311,59421020313,59421020320,59421020322,59421020331,59421021330,59421021331,59421021332,59421022100,59421022102,59421022120,59421022122,59421022300,59421022302,59421022303,59421022312,59421022313,59421023110,59421023112,59421023220,59421023222,59421030220,59421030221,59422001000,59422001002,59422001020,59422001022,59422001210,59422001212,59422001230,59422001232,59422001322,59422001323,59422003010,59422003012,59422003013,59422012032,59422012210,59422012212,59422012213,59422012302,59422012320,59422012322,59422023200,59422023201,59422023202,59422023210,59422023211,59422023230,59422023232,59422023300,59422023301,59422023310,59422023311,59422030100,59422030102,59422030120,59422030122,59422030230,59422030232,59422030300,59422030302,59423001010,59423001012,59423001030,59423001032,59423001210,59423001212,59423001220,59423001222,59423001223,59423001232,59423003010,59423003012,59423003030,59423003032,59423003200,59423003202,59423003220,59423003222,59423020201,59423020203,59423020221,59423020223,59423021000,59423021002,59423021020,59423021022,59423021200,59423021202,59423021220,59423021222,59423022120,59423022121,59423022130,59423022131,59423023000,59423023002,59423023020,59424022230,59424022232,59425000222,59425000223,59425000232,59425002010,59425002012,59425002020,59425002021,59425002030,60410401312,60410401313,60410403121,60410403123,60410410002,60410410003,60410410011,60410410012,60410410013,60410421203,60410421221,60410421223,60410422222,60410422223,60410422232,60410422233,60410422322,60410422323,60410422331,60410422332,60410422333,60410423001,60410423003,60410423021,60410423023,60410423201,60410423203,60410631230,60410631231,60410631232,60410631300,60410631301,60410631310,60410631311,60410632330,60410632331,60410632332,60410633000,60410633002,60410633020,60410633022,60410701120,60410701121,60410701200,60410701201,60410701202,60410701210,60410701211,60410701220,60410701222,60410701310,60410701311,60410702300,60410702302,60410703000,60410710010,60410710020,60410710021,60410710022,60410710200,60410720020,60410720021,60410720022,60410720030,60410720031,60410720200,60411311113,60411311131,60411311133,60411311311,60411311313,60411311331,60411311333,60411312333,60411313021,60411313023,60411313201,60411313203,60411313221,60411313222,60411313223,60411330111,60411330113,60411331021,60411331023,60411331210,60411331211,60411333100,60411333101,60411333103,60411333121,60411333123,60411333301,60411333303,60411333321,60411333323,60411610110,60411610112,60411610130,60411610132,60411610310,60411610312,60411610330,60411610332,60411612110,60411612112,60411612130,60411612132,60411612133,60411613220,60411613222,60411633310,60411633312,60411633330,60411720000,60411720002,60411722000,60411722002,60411722020,60411722022,60412311111,60412311113,60412311131,60412311133,60412311311,60412311313,60412311331,60412402000,60412402001,60412402003,60412402021,60412402023,60412402231,60412402233,60412420011,60412420013,60412420130,60412420131,60412420133,60412420311,60412420313,60412420331,60412421200,60412421201,60412421210,60412421211,60412421300,60412421301,60412421303,60412421321,60412421330,60412421331,60412430200,60412430201,60412430210,60412430211,60412430300,60412430301,60412430330,60412430331,60412431220,60412431221,60412431223,60412433001,60412433003,60412601330,60412601332,60412603112,60412603113,60412603310,60412603311,60412603312,60412610300,60412610302,60412611010,60412611011,60412611012,60412611020,60412611021,60412611030,60412611100,60412611101,60412612002,60412612020,60412612022,60412612200,60412612220,60412612222,60412630330,60412630332,60412632110,60412632112,60412632130,60412632132,60412632300,60412632301,60412632302,60412632310,60412632320,60412632322,60413412133,60413413011,60413413013,60413413021,60413413022,60413413023,60413413201,60413413203,60413413221,60413413223,60413430130,60413430131,60413430133,60413430311,60413430313,60413430331,60413430333,60413431001,60413431003,60413432102,60413432103,60413432131,60413432133,60413432311,60413432313,60413433221,60413433223,60413603330,60413603331,60413603332,60413610100,60413610102,60413612020,60413612021,60413612022,60413612200,60413612202,60413612220,60413621110,60413621300,60413621302,60413621320,60413621322,60413623010,60413623020,60413623021,60414411001,60414411010,60414411011,60414411013,60414411031,60414411120,60414411121,60414411123,60414411301,60414412313,60414412331,60414412333,60414413013,60414413023,60414413031,60414413032,60414413033,60414413102,60414413103,60414413201,60414413202,60414413203,60414430101,60414430103,60414430121,60414430123,60414430301,60414430303,60414430321,60414430323,60414432101,60414432103,60414432121,60414432310,60414432311,60414531230,60414531231,60414531232,60414531320,60414533010,60414533012,60414533030,60414533032,60414533210,60414533212,60414600320,60414600321,60414600330,60414602230,60414602231,60414620000,60414620002,60415411101,60415411103,60415500031,60415500033,60415500310,60415500311,60415501200,60415501201,60415501203,60415501221,60415501230,60415501231,60415503300,60415503301,60415503310,60415503311,60415510130,60415510132,60415510300,60415510302,60415510320,60415512010,60415512011,60415512012,60415512030,60415512032,60415512200,60415512201,60415512210,59413733332,59413733323,59414711110,59420022002,59410733113,59410733111,59420022000,58417731033,58417731122,58417731123,60412603110,60412612000,60412610222,
010,00,Ȭ,506742187,144787500,510089062,149596875,25,48,114,251,561,1067,604067,604140,604150,604151,604152,604153,604160,604161,604162,604170,604171,604172,614077,614100,614101,614102,614111,614112,614122,614132,614142,614170,614172,624007,624100,6040572,6040573,6040770,6040771,6041300,6041302,6041410,6041412,6041413,6041422,6041423,6041432,6041433,6041442,6041540,6041542,6041543,6041630,6041631,6041632,6041730,6041732,6140661,6140663,6140670,6140672,6140673,6140761,6140763,6141100,6141101,6141103,6141210,6141211,6141213,6141521,6141523,6141602,6141603,6141621,6141622,6141623,6141712,6141713,6240170,6240171,6241010,6241100,60403711,60403713,60403731,60403733,60405702,60405703,60405712,60405713,60407721,60407731,60407733,60412022,60413012,60413030,60413032,60413033,60413122,60413123,60414110,60414112,60414113,60414202,60415410,60415412,60415413,60415502,60416330,60416331,60416332,60416400,60416401,60416410,60417310,61400711,61400723,61400731,61400732,61400733,61401711,61405623,61405632,61406601,61406603,61406621,61406623,61406712,61410300,61410301,61410302,61410320,61410322,61411020,61411021,61411023,61411300,61411302,61411320,61411322,61412010,61412011,61412012,61412300,61412302,61413111,61413113,61415200,61415201,61415203,61415221,61415223,61415300,61415302,61416003,61416201,61416203,61416302,61416320,61416322,61417100,61417102,61417111,61417112,61417113,61417300,61417302,61417320,61417322,61417323,62400611,62400613,62400631,62400633,62401721,62401723,62401730,62401731,62401732,62410110,62410111,62410112,62410120,62410121,62410122,62410200,62410210,62410211,62410300,62410301,62410303,62411010,62411011,62411012,62411020,62411021,604027331,604027333,604037101,604037103,604037123,604037301,604047110,604047111,604047313,604047331,604047333,604057002,604057003,604057011,604057012,604057013,604057102,604057103,604057111,604057112,604057113,604066133,604066311,604076111,604076113,604077201,604077202,604077203,604077220,604077221,604077300,604077301,604077303,604120202,604120232,604120233,604130102,604130103,604130310,604130312,604130313,604131202,604131203,604131320,604131322,604131323,604141110,604141112,604141113,604142113,604142131,604142132,604142133,604143020,604143022,604144023,604144030,604144032,604144033,604144300,604144302,604144320,604144322,604154110,604154112,604154113,604155002,604155030,604155032,604155200,604155201,604155202,604155220,604163330,604163331,604163332,604164020,604164021,604164022,604164030,604164031,604164110,604164120,604164122,604173120,604173122,604173300,604173302,614007131,614007133,614007302,614007303,614017011,614017100,614017101,614017130,614017131,614017133,614017311,614056211,614056212,614056213,614056221,614056223,614056302,614056332,614066003,614066021,614067100,614067102,614067132,614067133,614076011,614076013,614076031,614076033,614076211,614103030,614103031,614103032,614103210,614103212,614103230,614103232,614110221,614110223,614113010,614113012,614113030,614120011,614120013,614120031,614120033,614120130,614120131,614120132,614120300,614120301,614121210,614121211,614121213,614123200,614123201,614123202,614123220,614123222,614131101,614131103,614131310,614131311,614131313,614131331,614131333,614133000,614133002,614133020,614133022,614133200,614133202,614133220,614133222,614141111,614143000,614143002,614143020,614143022,614143200,614143202,614143220,614143222,614152020,614152021,614152023,614153200,614153202,614153220,614153222,614160013,614160021,614160022,614160023,614160120,614160122,614161202,614161220,614161222,614161223,614161333,614162021,614162023,614163000,614163002,614171032,614171033,614171103,614173010,614173012,614173030,614173032,614173210,614173212,614173213,624006100,624006101,624006103,624006121,624006123,624006301,624006303,624016111,624016113,624017201,624017330,624017331,624017332,624027011,624027012,624027013,624027030,624027031,624027100,624027101,624027102,624101130,624101230,624101300,624102010,624102011,624102012,624102131,624103020,624103021,624103023,624103122,624103210,624103211,624103213,624103300,624103302,624103320,624103323,624110130,624110131,624110132,624110300,624110301,624110302,624110310,624111000,624111001,624111002,6040273132,6040273133,6040273301,6040273303,6040273321,6040273322,6040273323,6040371001,6040371003,6040371021,6040371210,6040371211,6040371213,6040371221,6040371223,6040373001,6040373031,6040373033,6040373211,6040373213,6040373231,6040471013,6040471031,6040471120,6040471130,6040471131,6040471133,6040471311,6040471313,6040471333,6040473111,6040473112,6040473113,6040473303,6040473321,6040473323,6040570002,6040570003,6040570012,6040570013,6040570102,6040570103,6040571002,6040571003,6040571012,6040571013,6040661311,6040661313,6040663101,6040663131,6040663132,6040663133,6040663311,6040663313,6040663331,6040663333,6040761310,6040761311,6040772000,6040772001,6040772003,6040772300,6040772301,6040772302,6040773020,6040773021,6040773023,6040773211,6040773213,6040773231,6040773233,6041202030,6041202032,6041202302,6041301002,6041301003,6041301012,6041301013,6041301102,6041301120,6041301122,6041301320,6041301322,6041301323,6041303110,6041303112,6041303113,6041312002,6041312122,6041313212,6041313213,6041313322,6041411110,6041411112,6041411113,6041420020,6041420022,6041420023,6041420032,6041420033,6041420122,6041420300,6041420302,6041420320,6041420322,6041420323,6041420332,6041421112,6041421121,6041421123,6041421231,6041421233,6041421301,6041421302,6041421303,6041430020,6041430022,6041430232,6041430233,6041430321,6041430322,6041430323,6041430330,6041430332,6041440211,6041440212,6041440213,6041440221,6041440222,6041440223,6041441220,6041441222,6041443230,6041443232,6041443233,6041443322,6041541112,6041541113,6041550002,6041550030,6041550032,6041550033,6041550332,6041552030,6041552031,6041552032,6041552100,6041552101,6041552102,6041552220,6041552221,6041552222,6041640230,6041640232,6041640331,6041641110,6041641111,6041641112,6041641120,6041641121,6041641122,6041641210,6041641211,6041641212,6041641230,6041641232,6041642000,6041642001,6041642002,6041643000,6041643001,6041643010,6041731100,6041731102,6041731120,6041731210,6041731211,6041731212,6041731230,6041731232,6041733010,6041733012,6041733200,6041733201,6041733202,6041733220,6041733222,6140071233,6140071300,6140071301,6140071303,6140071321,6140071322,6140071323,6140072113,6140072122,6140072123,6140072131,6140072132,6140072133,6140072213,6140073002,6140073003,6140073011,6140073012,6140073013,6140170100,6140170101,6140170103,6140171021,6140171030,6140171031,6140171033,6140171211,6140171213,6140171320,6140171321,6140171323,6140173101,6140173103,6140173121,6140173130,6140173131,6140173133,6140562013,6140562031,6140562032,6140562033,6140562102,6140562103,6140563000,6140563002,6140563003,6140563030,6140563032,6140563300,6140563302,6140563303,6140563330,6140563332,6140563333,6140572222,6140572223,6140572232,6140572233,6140660011,6140660012,6140660013,6140660231,6140660233,6140671010,6140671012,6140671030,6140671032,6140671033,6140671300,6140671302,6140671303,6140671312,6140671313,6140760100,6140760101,6140760103,6140760121,6140760123,6140760301,6140762130,6140762131,6140762133,6140762311,6140762312,6140762313,6140762330,6140762331,6140762333,6141030330,6141030331,6141030332,6141031000,6141031002,6141031020,6141032110,6141032112,6141032130,6141032132,6141102200,6141102201,6141130320,6141130322,6141132100,6141132102,6141132120,6141132122,6141200010,6141200011,6141200100,6141200101,6141200103,6141200121,6141200301,6141200303,6141200321,6141201330,6141201331,6141202111,6141203100,6141212011,6141212120,6141212121,6141212123,6141212311,6141212313,6141212331,6141232030,6141232031,6141232032,6141232210,6141232212,6141232230,6141232232,6141311001,6141311003,6141311210,6141311211,6141311213,6141311231,6141313120,6141313121,6141313123,6141313301,6141313303,6141313321,6141330010,6141330012,6141330030,6141330210,6141332010,6141332012,6141411131,6141411133,6141411311,6141411313,6141411331,6141411333,6141413111,6141413113,6141413131,6141413133,6141413311,6141413313,6141413331,6141413333,6141430230,6141430232,6141432010,6141432012,6141432030,6141432032,6141432210,6141432212,6141432230,6141432232,6141432233,6141511111,6141511131,6141511133,6141520221,6141520223,6141522001,6141522010,6141522011,6141522013,6141522031,6141532010,6141532011,6141532012,6141532030,6141532032,6141532210,6141532212,6141532230,6141532232,6141600033,6141600121,6141600122,6141600123,6141600202,6141600203,6141601022,6141601230,6141601232,6141601233,6141601322,6141612002,6141612210,6141612212,6141612213,6141612322,6141613131,6141613133,6141613311,6141613312,6141613313,6141613322,6141613323,6141620011,6141620013,6141620031,6141620032,6141620033,6141620203,6141620221,6141620223,6141630010,6141630012,6141630030,6141630032,6141630033,6141632122,6141632300,6141632302,6141632320,6141632322,6141632323,6141710100,6141710102,6141710300,6141710302,6141710303,6141710311,6141710312,6141710313,6141711013,6141730330,6141730332,6141732110,6141732112,6141733220,6141733222,6240061021,6240061023,6240061201,6240063211,6240063213,6240063231,6240063233,6240161011,6240161100,6240161101,6240161103,6240161311,6240161313,6240172000,6240172001,6240172003,6240172030,6240172031,6240172033,6240172211,6240173330,6240270033,6240270101,6240270102,6240270103,6240270211,6240270320,6240270321,6240270323,6240270330,6240270332,6240271030,6240271031,6240271032,6240271100,6240271102,6240271200,6240271201,6240272101,6241011310,6241011311,6241011312,6241011320,6241011321,6241012310,6241012311,6241012312,6241012320,6241012321,6241012322,6241012330,6241013010,6241013020,6241013021,6241013022,6241020130,6241020131,6241020132,6241020200,6241020201,6241020210,6241021211,6241021300,6241021301,6241021331,6241030220,6241030221,6241030223,6241031000,6241031002,6241031020,6241031022,6241031200,6241031202,6241031203,6241031212,6241031230,6241031232,6241032011,6241032120,6241032121,6241032123,6241032310,6241032311,6241033010,6241033012,6241033013,6241033030,6241033031,6241033032,6241033210,6241033212,6241033213,6241033220,6241033221,6241033223,6241033322,6241101330,6241101331,6241101332,6241102200,6241102201,6241102210,6241103030,6241103031,6241103032,6241103110,6241103112,6241103120,6241110030,6241110031,6241110032,6241110200,6241131001,6241131010,6241131011,6241131013,6241131031,6241131100,6041640320,6041640231,6240272103,60402731231,60402731233,60402732233,60402732313,60402732322,60402732323,60402732331,60402732332,60402732333,60402733202,60402733203,60403710231,60403710233,60403712011,60403712013,60403712031,60403712120,60403712121,60403712123,60403730031,60403730033,60403730301,60403730303,60403730321,60403730323,60403732101,60403732103,60403732121,60403732123,60403732301,60403732330,60403732331,60403732333,60404710111,60404710112,60404710113,60404710331,60404711210,60404711212,60404711220,60404711221,60404711321,60404711323,60404713101,60404713103,60404713121,60404713123,60404713301,60404713310,60404713311,60404713313,60404713321,60404713323,60404723322,60404723323,60404723332,60404723333,60404731101,60404731102,60404731103,60404732222,60405611113,60405611131,60405611133,60405611311,60405611313,60405611331,60405611333,60405613111,60405613113,60405613131,60405613133,60405613311,60405613313,60405613331,60405613333,60405631111,60405631113,60405631131,60405631133,60405631311,60405631313,60405631331,60405631333,60405633111,60405633113,60405633131,60405633133,60405633311,60405633313,60405700002,60405700003,60405700012,60405700013,60405700102,60405700103,60405700112,60405700113,60405701002,60405701003,60405701012,60405701013,60405710000,60405710002,60405710003,60405710012,60405710013,60405710102,60405710103,60405710112,60405710113,60405711022,60405711023,60405711032,60405711033,60406611311,60406611313,60406611331,60406611333,60406613101,60406613103,60406613121,60406613122,60406613123,60406613213,60406613223,60406613231,60406613232,60406613233,60406631001,60406631003,60406631031,60406631300,60406631301,60406631303,60406633100,60406633101,60406633103,60406633121,60406633123,60406633301,60406633303,60406633321,60406633322,60406633323,60407613131,60407613133,60407720020,60407720021,60407723100,60407723102,60407730220,60407730221,60407730222,60407732101,60407732103,60407732121,60407732123,60412023000,60412023002,60412023032,60412023033,60412023122,60412023123,60412023132,60412023133,60412032222,60413010000,60413010002,60413010003,60413010012,60413010013,60413010102,60413010103,60413010112,60413011030,60413011032,60413011210,60413013000,60413013001,60413013002,60413013020,60413013022,60413013023,60413013212,60413013213,60413013302,60413013320,60413013322,60413013323,60413031112,60413031113,60413120002,60413120003,60413120012,60413120030,60413120032,60413121230,60413121232,60413130221,60413130223,60413130230,60413130232,60413132100,60413132102,60413132103,60413132112,60413132113,60413133202,60413133203,60413133232,60413133233,60413133322,60414201232,60414203010,60414203012,60414203030,60414203032,60414203210,60414203212,60414203213,60414203302,60414203303,60414203312,60414203330,60414203332,60414203333,60414211031,60414211033,60414211130,60414211132,60414211200,60414211201,60414211203,60414211221,60414211223,60414212132,60414212133,60414212222,60414212223,60414212232,60414212233,60414212303,60414212321,60414212322,60414212323,60414213001,60414213002,60414213003,60414300232,60414300233,60414302122,60414302300,60414302302,60414302303,60414302312,60414302313,60414303023,60414303032,60414303033,60414303122,60414303123,60414303201,60414303202,60414303203,60414303332,60414313333,60414400332,60414400333,60414401222,60414401223,60414401230,60414401232,60414401233,60414402023,60414402032,60414402033,60414402102,60414402103,60414402201,60414402202,60414402203,60414403102,60414403120,60414403122,60414403123,60414403132,60414403133,60414412022,60414412023,60414412232,60414412233,60414412322,60414430100,60414430102,60414430120,60414430122,60414430300,60414430302,60414430320,60414430322,60414432100,60414432102,60414432120,60414432122,60414432123,60414432312,60414432313,60415411100,60415411102,60415500030,60415500032,60415500312,60415500313,60415501202,60415501220,60415501222,60415501223,60415501232,60415501233,60415503302,60415503303,60415503312,60415503313,60415512202,60415520330,60415520331,60415520332,60415521030,60415521032,60415521100,60415521102,60415521200,60415521201,60415522100,60415522101,60415522110,60415522230,60415522232,60416333300,60416333302,60416403301,60416403303,60416403331,60416403333,60416411230,60416411231,60416411232,60416411300,60416411301,60416411302,60416411320,60416412130,60416412131,60416412132,60416412310,60416412312,60416412330,60416412332,60416413000,60416413001,60416413002,60416413010,60416413020,60416420030,60416420031,60416420032,60416420200,60416420201,60416420202,60416420210,60416420220,60416500000,60416500002,60417311010,60417311011,60417311220,60417311221,60417311222,60417312130,60417312132,60417312310,60417312312,60417312330,60417312332,60417313000,60417313002,60417330300,60417330301,60417332030,60417332032,60417332210,60417332212,60417332230,60417332232,61400710110,61400710111,61400710113,61400710131,61400710133,61400710311,61400710313,61400710331,61400710333,61400712111,61400712113,61400712313,61400713021,61400713023,61400713201,61400713202,61400713203,61400721121,61400721123,61400721202,61400721203,61400721212,61400721213,61400721301,61400721302,61400721303,61400722112,61400722113,61400722310,61400722311,61400730101,61400730103,61401701020,61401701021,61401710321,61401710323,61401712103,61401712121,61401712123,61401712310,61401712311,61401712313,61401712331,61401713220,61401713221,61401713223,61401731001,61401731321,61401731323,61401733111,61401733113,61405603322,61405603323,61405603332,61405603333,61405612222,61405612223,61405612232,61405620112,61405620113,61405620231,61405620233,61405620301,61405620303,61405621002,61405621003,61405621012,61405621013,61405622011,61405622013,61405622031,61405622033,61405622211,61405622213,61405622231,61405622233,61405630010,61405630012,61405630330,61405630332,61405633012,61405633013,61405633122,61405633123,61405633312,61405633313,61405722202,61405722203,61405722212,61405722213,61405722302,61405722303,61405722312,61405722313,61405723202,61405723220,61405723222,61405723223,61406600011,61406600031,61406600033,61406600100,61406600101,61406600103,61406600211,61406600213,61406600231,61406600233,61406602011,61406602013,61406602031,61406602033,61406602301,61406602303,61406620110,61406620111,61406710130,61406710132,61406710310,61406710312,61406711222,61406711223,61406713012,61406713013,61406713102,61406713103,61406713112,61406713113,61407601020,61407601021,61407601023,61407601201,61407601203,61407601221,61407601223,61407603001,61407603003,61407603031,61407603033,61407603211,61407623102,61407623103,61407623320,61407623321,61410303330,61410303332,61410310010,61410310012,61410310030,61410310032,61410310210,61410321110,61410321112,61410321130,61410321132,61410321310,61410321312,61410321330,61410321332,61410323100,61410323102,61410323120,61410323122,61410323300,61410323302,61410323320,61410323322,61411022030,61411022031,61411301100,61411323000,61411323002,61411323020,61411323022,61411323200,61411323202,61411323220,61411323222,61412001232,61412001233,61412003230,61412003231,61412013320,61412013321,61412013323,61412013330,61412013331,61412013332,61412021100,61412021101,61412021103,61412031010,61412031011,61412031101,61412031110,61412120000,61412120001,61412120010,61412120011,61412120100,61412120101,61412120131,61412120133,61412123011,61412123100,61412123101,61412123103,61412123121,61412123330,61412123331,61412301000,61412301002,61412301020,61412301022,61413110001,61413110003,61413110021,61413110023,61413110211,61413110213,61413110231,61413112120,61413112121,61413112123,61413112301,61413112303,61413112321,61413112330,61413112331,61413112333,61413130111,61413130113,61413130131,61413130133,61413131220,61413131221,61413133231,61413133233,61413300320,61413300321,61413300322,61413302120,61413302121,61413302122,61413302300,61413302302,61413302320,61413302322,61413302323,61413320300,61413320302,61413320320,61413320322,61413322100,61413322102,61413322120,61413322122,61413322300,61413322302,61413322320,61413322322,61414111011,61414111013,61414111031,61414111033,61414111211,61414111300,61414111301,61414111303,61414111321,61414111323,61414113101,61414113103,61414113121,61414113123,61414113301,61414113303,61414113321,61414113323,61414131101,61414131103,61414300100,61414300102,61414300120,61414300122,61414300300,61414300302,61414300320,61414300322,61414302100,61414302102,61414302120,61414302122,61414322312,61414322313,61415113110,61415113111,61415202201,61415202203,61415202221,61415202223,61415220120,61415220121,61415220123,61415220301,61415220303,61415220321,61415220330,61415220331,61415220333,61415222111,61415222113,61415222131,61415222133,61415222311,61415222313,61415222331,61415222333,61415301020,61415301022,61415301200,61415301202,61415301220,61415320130,61415320131,61416000322,61416000323,61416001201,61416001203,61416002002,61416002003,61416002012,61416002013,61416010200,61416010202,61416010232,61416010233,61416012102,61416012120,61416012122,61416012123,61416012132,61416012310,61416012312,61416012313,61416013202,61416013203,61416013232,61416120000,61416120002,61416120320,61416120322,61416120323,61416120332,61416122110,61416122112,61416122113,61416123002,61416123020,61416123022,61416123200,61416123202,61416123203,61416123212,61416123230,61416123232,61416131323,61416133013,61416133031,61416133033,61416133101,61416133102,61416133103,61416133211,61416133212,61416133213,61416200101,61416200103,61416200121,61416200123,61416200301,61416200303,61416202012,61416202013,61416202223,61416303202,61416303220,61416303222,61416321000,61416321002,61416321020,61416321022,61416321200,61416321202,61417101010,61417101012,61417101030,61417101032,61417101200,61417101201,61417101202,61417101210,61417101220,61417101222,61417101223,61417101232,61417101323,61417101332,61417101333,61417103010,61417103012,61417103013,61417103101,61417103102,61417103103,61417110111,61417110113,61417110121,61417110123,61417110213,61417110222,61417110223,61417110231,61417110232,61417110233,61417301302,61417301320,61417301322,61417303100,61417303102,61417303120,61417303122,61417303310,61417303312,61417303330,61417303332,61417321110,61417321112,61417321130,61417321132,61417332022,61417332023,62400601110,62400601111,62400612030,62400612031,62400612033,62400612211,62400612213,62400612231,62400612233,62400630011,62400630013,62400630031,62400630033,62400630211,62400630213,62400630231,62400630233,62400632101,62400632103,62400632121,62400632321,62400632323,62401610101,62401611021,62401611023,62401611211,62401611213,62401611231,62401611233,62401613101,62401613103,62401613121,62401613123,62401613301,62401613310,62401613311,62401720211,62401720213,62401720321,62401720323,62401722130,62401722131,62401733310,62401733311,62401733320,62401733321,62401733322,62402700312,62402700313,62402701001,62402701002,62402701003,62402702130,62402702131,62402703221,62402703223,62402703310,62402703311,62402710330,62402711010,62402711012,62402712020,62402712021,62402712022,62402712030,62402712031,62402712100,62402712101,62402712200,62402721001,62402721003,62402721100,62402721102,62410113130,62410113131,62410113132,62410113220,62410113221,62410113222,62410113230,62410113231,62410113300,62410113301,62410113310,62410123130,62410123132,62410123230,62410123231,62410123232,62410123310,62410123320,62410123321,62410130110,62410130111,62410130120,62410130121,62410130122,62410131000,62410132000,62410132002,62410201331,62410201333,62410202020,62410202021,62410212101,62410212103,62410213020,62410213021,62410213030,62410213031,62410213033,62410213211,62410213300,62410213301,62410213330,62410213331,62410302220,62410302221,62410310030,62410310032,62410310210,62410310212,62410310230,62410310232,62410312010,62410312012,62410312013,62410312330,62410312332,62410320010,62410320011,62410320100,62410320101,62410320103,62410320121,62410320130,62410320131,62410320133,62410321221,62410321223,62410323011,62410323013,62410323120,62410323121,62410323130,62410323131,62410323133,62410323311,62410323313,62410323331,62410330110,62410330112,62410330330,62410330332,62410331020,62410331022,62410331200,62410331202,62410332110,62410332112,62410332113,62410332220,62410332221,62410332223,62410333002,62410333020,62410333022,62410333200,62410333202,62411013330,62411013331,62411013332,62411022020,62411022021,62411022022,62411022030,62411022031,62411022110,62411022111,62411022112,62411022120,62411022121,62411022130,62411022200,62411023000,62411023001,62411023010,62411023011,62411023100,62411023101,62411023110,62411023111,62411030330,62411030332,62411031110,62411031112,62411032000,62411032001,62411032010,62411032011,62411100330,62411100332,62411101000,62411101001,62411101002,62411101010,62411102010,62411102011,62411102020,62411102021,62411102022,62411102200,62411102202,62411102220,62411310001,62411310121,62411310123,62411310301,62411310303,62411311020,62411311022,62411311200,62411311202,60416402330,60416403220,60416402331,62402721023,62402721210,62402721201,61413300112,
011,00,Ŀ,505209375,146156250,507923437,148546875,4,13,62,130,289,554,614006,614015,614027,614054,6040763,6140070,6140160,6140161,6140163,6140172,6140250,6140343,6140370,6140441,6140442,6140443,6140533,60407623,61400531,61400532,61400533,61400720,61401413,61401431,61401433,61401620,61401621,61401623,61401700,61401702,61401703,61401730,61401732,61402411,61402413,61402431,61402433,61402520,61402521,61402522,61402610,61402611,61402613,61403411,61403413,61403423,61403500,61403502,61403520,61403522,61403710,61403712,61403720,61403721,61403722,61404401,61404403,61404500,61404502,61405311,61405313,61405321,61405322,61405323,61406300,61406301,61406302,61406310,61406320,61406400,61406401,61406403,61406410,61406411,61406412,61412002,61412020,61412022,61412023,604076123,604076130,604076132,604076133,604077222,604077223,604077232,604077233,604077320,604077322,614004333,614005131,614005132,614005133,614005222,614005223,614005231,614005232,614005233,614005303,614007100,614007102,614007120,614007122,614007210,614007220,614007222,614014111,614014113,614014303,614014321,614014323,614016220,614016221,614016223,614017012,614017013,614017120,614017122,614017330,614017332,614017333,614024101,614024321,614025100,614025101,614025102,614025110,614025230,614025232,614026121,614026311,614026313,614034121,614034122,614034123,614035010,614035012,614035030,614036131,614036133,614036311,614037110,614037111,614037112,614037130,614037132,614037230,614037231,614037232,614037300,614037301,614037302,614037320,614043333,614044003,614044021,614044023,614045200,614045201,614045202,614045220,614045222,614047000,614047001,614053033,614053103,614053122,614053123,614053201,614053202,614053203,614055000,614055020,614055022,614055200,614055202,614055220,614055222,614062313,614062331,614063030,614063031,614063032,614063110,614063111,614063220,614064021,614064023,614064130,614064131,614064132,614064210,614064211,614064300,614064301,614065000,614065002,614110222,614120000,614120002,614120003,614120210,614120212,614120213,614120302,614120320,614130000,614130001,614053121,6040761122,6040761213,6040761312,6040762132,6040762133,6040762213,6040762223,6040762231,6040762232,6040762233,6040772303,6040772311,6040772312,6040772313,6040773230,6040773232,6140051131,6140051132,6140051133,6140051233,6140051303,6140052133,6140052203,6140052211,6140052212,6140052213,6140052300,6140052302,6140052303,6140053011,6140053013,6140053022,6140053023,6140071010,6140071012,6140071030,6140071032,6140071210,6140071212,6140071213,6140071230,6140071232,6140072110,6140072111,6140072210,6140072212,6140072230,6140072232,6140072233,6140073000,6140073001,6140141231,6140143021,6140143023,6140162220,6140162221,6140162223,6140171020,6140171022,6140171023,6140171230,6140171232,6140173102,6140173120,6140173122,6140173123,6140173310,6140173312,6140173313,6140241031,6140243013,6140243031,6140243032,6140243033,6140243201,6140243230,6140243231,6140243233,6140251030,6140251031,6140251032,6140251120,6140251200,6140251202,6140251220,6140251222,6140252310,6140252312,6140252330,6140260110,6140260111,6140260113,6140261201,6140261231,6140263101,6140263103,6140263310,6140263311,6140263313,6140263333,6140340331,6140340333,6140341011,6140341013,6140341023,6140341031,6140341032,6140341033,6140341201,6140341202,6140341203,6140342111,6140342113,6140342123,6140342131,6140342132,6140342133,6140342231,6140342233,6140350320,6140350322,6140352100,6140352102,6140352120,6140352122,6140352300,6140361111,6140361113,6140361131,6140361133,6140361213,6140361231,6140361301,6140361302,6140361303,6140361320,6140361321,6140363130,6140363131,6140363133,6140363310,6140363311,6140371130,6140371131,6140371330,6140371332,6140372330,6140372331,6140373030,6140373031,6140373032,6140373100,6140373101,6140373102,6140373110,6140373120,6140373210,6140373212,6140373220,6140373221,6140433113,6140433131,6140433133,6140433311,6140433313,6140433321,6140433322,6140433323,6140440011,6140440012,6140440013,6140440222,6140440223,6140452030,6140452032,6140452210,6140470100,6140470102,6140523133,6140523311,6140523313,6140523331,6140523333,6140530233,6140530321,6140530322,6140530323,6140531011,6140531012,6140531013,6140531203,6140532003,6140550020,6140550022,6140550023,6140552030,6140552032,6140552210,6140552212,6140552230,6140552232,6140621111,6140621113,6140621131,6140621133,6140621311,6140621331,6140621333,6140623111,6140623113,6140623303,6140623321,6140623322,6140623323,6140623330,6140623331,6140623332,6140630330,6140630331,6140630332,6140631120,6140631121,6140631130,6140631131,6140631133,6140631200,6140631201,6140631202,6140632100,6140632101,6140632102,6140632120,6140632122,6140632210,6140632211,6140632212,6140632220,6140632221,6140640200,6140640201,6140640203,6140641330,6140641332,6140642011,6140642013,6140642130,6140642131,6140642132,6140643020,6140643021,6140643030,6140643100,6140643101,6140650010,6140650012,6140650030,6140650200,6140650201,6140650202,6140721011,6140721013,6140721100,6140721101,6140721102,6141102202,6141200012,6141200013,6141200102,6141200120,6141200122,6141200300,6141200302,6141200320,6141200322,6141202112,6141202113,6141203030,6141203032,6141203220,6141203221,6141300020,6141300021,6141300030,6141300031,6141300100,6140470020,6140361130,6140361121,6140263123,60407611232,60407611233,60407612033,60407612112,60407612113,60407612122,60407612123,60407612211,60407612213,60407612231,60407612232,60407612233,60407613130,60407613132,60407621222,60407621223,60407621231,60407621232,60407621233,60407621311,60407621313,60407622112,60407622113,60407622123,60407622212,60407622213,60407622221,60407622223,60407622301,60407622302,60407622303,60407720022,60407720023,60407723101,60407723103,60407730223,60407732100,60407732102,60407732120,60407732122,61400433133,61400511111,61400511113,61400511131,61400511133,61400511233,61400511302,61400511303,61400513003,61400513011,61400513012,61400513013,61400513021,61400513022,61400513023,61400520323,61400520332,61400520333,61400521222,61400521223,61400521233,61400521312,61400521313,61400521322,61400521323,61400522012,61400522013,61400522022,61400522023,61400522101,61400522102,61400522103,61400523011,61400523012,61400523013,61400530101,61400530103,61400530121,61400530123,61400530202,61400530203,61400530212,61400530213,61400710112,61400710130,61400710132,61400710310,61400710312,61400710330,61400710332,61400712110,61400712112,61400712310,61400712311,61400712312,61400713020,61400713022,61400713200,61400721120,61400721122,61400721200,61400721201,61400721210,61400721211,61400721300,61400722110,61400722111,61400722312,61400722313,61400730100,61400730102,61401411011,61401411013,61401411031,61401411033,61401411211,61401411213,61401411222,61401411223,61401411231,61401411232,61401411233,61401412113,61401412123,61401412131,61401412132,61401412133,61401412301,61401412303,61401412321,61401412330,61401412331,61401412333,61401430032,61401430033,61401430111,61401430113,61401430122,61401430123,61401430131,61401430132,61401430133,61401622220,61401622221,61401701022,61401701023,61401710320,61401710322,61401712100,61401712101,61401712102,61401712120,61401712122,61401712312,61401712330,61401712332,61401712333,61401713222,61401731000,61401731002,61401731003,61401731320,61401731322,61401733110,61401733112,61402410301,61402410303,61402410331,61402410333,61402412111,61402412113,61402412131,61402412133,61402412311,61402412313,61402412331,61402412333,61402430103,61402430111,61402430112,61402430113,61402430121,61402430123,61402430232,61402430233,61402430301,61402430302,61402430303,61402432030,61402432031,61402432320,61402432321,61402432323,61402511100,61402511101,61402511110,61402511111,61402512010,61402512011,61402512012,61402512030,61402512032,61402512100,61402512210,61402523110,61402523112,61402523130,61402523132,61402523310,61402523312,61402523320,61402523321,61402523322,61402523330,61402530000,61402530001,61402600010,61402600011,61402600100,61402600101,61402600110,61402600111,61402601000,61402601001,61402601010,61402601011,61402601311,61402601313,61402612030,61402612031,61402612033,61402612211,61402612300,61402612301,61402612303,61402612321,61402612330,61402612331,61402631000,61402631001,61402631003,61402631021,61402631023,61402633011,61402633013,61402633031,61402633120,61402633121,61402633123,61402633301,61402633310,61402633311,61402633313,61402633321,61402633323,61403403323,61403410101,61403410103,61403410121,61403410123,61403410301,61403410303,61403412001,61403412003,61403421101,61403421103,61403421121,61403421123,61403421301,61403421303,61403422131,61403422133,61403422301,61403422303,61403422321,61403422323,61403501100,61403501102,61403501120,61403501122,61403501300,61403501302,61403503210,61403503211,61403523020,61403523021,61403523022,61403523200,61403523202,61403523220,61403523222,61403611101,61403611103,61403611121,61403611123,61403611321,61403611323,61403612330,61403612331,61403613001,61403613003,61403613220,61403613221,61403613230,61403613231,61403613233,61403631321,61403631323,61403633120,61403633121,61403633130,61403633131,61403633133,61403633311,61403711320,61403711321,61403711322,61403711330,61403711331,61403713100,61403713102,61403713120,61403713122,61403723320,61403723322,61403730330,61403730331,61403730332,61403731030,61403731032,61403732110,61403732300,61403732301,61404331112,61404331113,61404332332,61404332333,61404333032,61404333033,61404333121,61404333122,61404333123,61404333202,61404333203,61404400101,61404400102,61404400103,61404402031,61404402033,61404402202,61404402203,61404402211,61404402212,61404402213,61404501000,61404501002,61404501020,61404501022,61404501200,61404501202,61404501220,61404520310,61404520311,61404522120,61404522121,61404522122,61404522300,61404522302,61404522320,61404522322,61404701010,61404701012,61405233101,61405233103,61405233121,61405233123,61405233301,61405233303,61405302233,61405302312,61405302313,61405302322,61405302323,61405303032,61405303033,61405303122,61405303123,61405303132,61405303133,61405303202,61405303203,61405312003,61405312012,61405312013,61405312021,61405312022,61405312023,61405320011,61405320013,61405320021,61405320023,61405500100,61405500102,61405500120,61405500122,61405500210,61405500211,61405500212,61405500300,61405500320,61405500322,61405502100,61405502102,61405502120,61405502122,61405502300,61405502302,61405502320,61405502322,61405520100,61405520102,61405520120,61405520122,61406213132,61406213133,61406231101,61406231103,61406231121,61406231123,61406232313,61406232331,61406232333,61406233012,61406233013,61406233202,61406233203,61406233330,61406233331,61406233332,61406303330,61406303332,61406311220,61406311221,61406311230,61406311231,61406311320,61406311321,61406311323,61406312200,61406312202,61406321030,61406321031,61406321032,61406321100,61406321101,61406321110,61406321210,61406322130,61406322132,61406322220,61406322221,61406402021,61406402023,61406402211,61406402213,61406413310,61406413312,61406413330,61406413332,61406420101,61406420103,61406420121,61406420123,61406420301,61406420310,61406420311,61406421200,61406421201,61406421210,61406421211,61406421213,61406421231,61406421233,61406421330,61406421331,61406421332,61406430220,61406430221,61406430230,61406430231,61406430310,61406430311,61406430320,61406430321,61406431020,61406431021,61406431022,61406431030,61406431031,61406431100,61406431102,61406431120,61406431200,61406500320,61406500321,61406500322,61406502100,61406502102,61407210310,61407210311,61407211030,61407211031,61407211032,61407211100,61407211101,61407211102,61407211110,61407211120,61407211200,61407211201,61407211210,61411022032,61411022033,61412001230,61412001231,61412003232,61412003233,61412021102,61412030310,61412030312,61412030330,61412030332,61412032100,61412032101,61412032102,61412032110,61412032120,61412032220,61412032221,61412032222,61412032230,61412032231,61413000220,61413000221,61413000230,61413000231,61404710021,61404611313,61404611311,61404611133,61403611231,61403611320,61402631223,61402631221,
012,00,,503479687,145406250,507150000,148471875,17,39,75,184,344,747,604060,604061,604062,604063,604064,604065,604070,604071,604072,604073,604074,604075,614002,614003,614013,614023,614033,6039770,6039771,6039773,6040502,6040512,6040513,6040522,6040533,6040542,6040543,6040550,6040552,6040553,6040562,6040660,6040662,6040760,6140000,6140001,6140010,6140011,6140013,6140040,6140041,6140042,6140050,6140120,6140121,6140123,6140140,6140142,6140221,6140223,6140240,6140242,6140321,6140430,6140431,6140432,60395713,60395731,60395733,60396711,60396713,60396731,60396732,60396733,60397721,60405031,60405032,60405033,60405102,60405103,60405112,60405113,60405202,60405203,60405212,60405230,60405232,60405233,60405322,60405323,60405401,60405402,60405403,60405412,60405413,60405512,60405513,60406610,60406612,60406630,60406632,60407610,60407620,61390711,61400020,61400021,61400023,61400030,61400031,61400032,61400120,61400121,61400123,61400430,61400431,61400432,61400510,61401110,61401111,61401221,61401223,61401410,61402201,61403230,61403231,61403233,61403400,61403401,61403402,61403420,61404211,61404213,61404231,61404233,61404330,61405211,61405212,61405213,61405230,61405300,61405301,603957103,603957112,603957113,603957120,603957121,603957123,603957301,603957303,603957321,603957323,603967101,603967103,603967121,603967123,603967233,603967301,603967302,603967303,603976131,603977201,603977231,604044231,604044232,604044233,604045221,604045223,604045230,604045232,604050002,604050003,604050020,604050022,604050023,604050113,604050131,604050133,604050302,604050303,604051102,604051103,604051112,604052312,604052313,604053122,604053123,604053131,604053132,604053133,604053212,604054002,604054003,604054102,604054103,604054112,604054113,604055102,604055103,604055110,604055112,604056020,604056022,604056023,604056033,604056322,604066110,604066112,604066130,604066312,604066330,604066332,604076110,604076210,604076211,604076220,613907130,613907131,613907133,613907311,614000220,614000221,614000330,614000331,614001220,614001221,614001223,614004330,614004332,614005110,614005120,614005121,614005122,614005200,614005201,614005202,614005210,614005211,614005300,614010010,614010011,614010013,614010100,614011010,614011011,614011013,614011120,614011121,614011130,614011131,614012200,614012201,614012203,614012221,614012223,614014120,614014122,614014320,614014322,614022031,614022033,614022211,614022213,614022231,614024100,614024102,614024120,614024122,614024300,614024322,614032320,614032321,614032323,614034030,614034031,614034032,614034100,614034210,614034220,614034222,614042101,614042103,614042121,614042123,614042301,614042303,614042321,614042323,614043310,614043312,614043320,614043321,614043322,614044000,614044002,614052023,614052031,614052033,614052101,614052102,614052103,614052200,614052201,614052210,614052310,614052311,614052312,614052321,614052323,614052330,614052332,614053020,614053021,614053100,614053102,614062101,614062110,614062112,614062123,614062130,614062132,614062301,614062303,614062310,614062312,614062321,6039571020,6039571021,6039571023,6039571102,6039571103,6039571221,6039571223,6039573001,6039573003,6039573021,6039573023,6039573201,6039573203,6039573221,6039573223,6039663333,6039671001,6039671003,6039671021,6039671023,6039671201,6039671203,6039671221,6039671223,6039672113,6039672131,6039672133,6039672222,6039672223,6039672232,6039672233,6039672311,6039672313,6039673001,6039673002,6039673003,6039761111,6039761113,6039761131,6039761132,6039761133,6039761331,6039772001,6039772031,6040442133,6040442231,6040442233,6040442301,6040442302,6040442303,6040443022,6040443200,6040443202,6040443220,6040452201,6040452203,6040452221,6040452223,6040452330,6040452332,6040452333,6040453222,6040453322,6040453323,6040453332,6040500003,6040500010,6040500012,6040500210,6040500212,6040500320,6040500322,6040500323,6040501233,6040501301,6040501303,6040501321,6040501322,6040501323,6040503002,6040503003,6040503011,6040503012,6040503013,6040510022,6040510023,6040510031,6040510032,6040510033,6040510120,6040510122,6040510123,6040510132,6040510133,6040511130,6040511132,6040511133,6040520023,6040520032,6040521020,6040521022,6040521023,6040521032,6040521033,6040521300,6040521302,6040521320,6040521322,6040523100,6040523102,6040523103,6040531131,6040531132,6040531133,6040531202,6040531203,6040532020,6040532022,6040532023,6040532031,6040532032,6040532033,6040532113,6040532131,6040532132,6040532133,6040540011,6040541002,6040541003,6040541103,6040541112,6040541113,6040551000,6040551002,6040551012,6040551013,6040551110,6040551112,6040551130,6040551132,6040551133,6040560022,6040560212,6040560312,6040560313,6040560320,6040560322,6040560323,6040563202,6040563230,6040563232,6040661112,6040661113,6040661130,6040661132,6040661320,6040663102,6040761120,6040761121,6040761200,6040761201,6040761202,6040761210,6040761220,6040761222,6040762120,6040762121,6040762130,6040762210,6040762220,6139071000,6139071010,6139071011,6139071013,6139071031,6139071320,6139071321,6139073130,6139073131,6139073133,6139073311,6140002220,6140002221,6140002230,6140002231,6140002233,6140003320,6140003321,6140003322,6140012220,6140012221,6140043310,6140043311,6140043312,6140051110,6140051112,6140051120,6140051121,6140051122,6140051230,6140051231,6140051232,6140052030,6140052031,6140052120,6140052121,6140052130,6140052200,6140100011,6140100121,6140101010,6140101011,6140101012,6140101020,6140101021,6140101022,6140110011,6140110121,6140110310,6140110311,6140111330,6140111331,6140111333,6140122020,6140122021,6140122023,6140122201,6140141100,6140141102,6140141120,6140141210,6140143000,6140143001,6140143002,6140143010,6140143020,6140143022,6140220011,6140220013,6140220031,6140220301,6140220303,6140220321,6140220323,6140222101,6140222103,6140222121,6140222331,6140222333,6140241032,6140241210,6140241212,6140241230,6140241232,6140243020,6140243021,6140243022,6140243200,6140243202,6140320111,6140320113,6140320131,6140323221,6140323223,6140340330,6140341020,6140341021,6140341022,6140342120,6140342121,6140342122,6140342210,6140342211,6140342212,6140421001,6140421003,6140421021,6140421023,6140421201,6140421203,6140421221,6140423223,6140433110,6140433112,6140433130,6140433132,6140433230,6140433231,6140433232,6140433300,6140433301,6140433302,6140433310,6140440200,6140440201,6140440202,6140520133,6140520221,6140520222,6140520223,6140520303,6140520321,6140520322,6140520323,6140521001,6140521002,6140521003,6140522021,6140522110,6140522111,6140522120,6140523130,6140523131,6140523132,6140523201,6140523332,6140530220,6140530221,6140530222,6140530230,6140530300,6140530301,6140530302,6140530310,6140530311,6140531010,6140532000,6140621030,6140621031,6140621033,6140621110,6140621112,6140621130,6140621132,6140621211,6140621212,6140621213,6140621310,6140621312,6140621330,6140621332,6140623300,6140623302,6140113111,60395701133,60395701311,60395701313,60395701331,60395703111,60395703113,60395703131,60395703133,60395703311,60395710022,60395710023,60395710032,60395710033,60395710122,60395710123,60395710133,60395710220,60395710221,60395710223,60395711002,60395711003,60395711012,60395711013,60395711102,60395711120,60395711122,60395711123,60395711132,60395711133,60395712200,60395712201,60395712203,60395712221,60395712223,60395730001,60395730003,60395730021,60395730023,60396633312,60396633313,60396712023,60396712201,60396712203,60396712221,60396712223,60396722202,60396722203,60396722212,60396722213,60396722302,60396722303,60396722312,60396722313,60396723122,60396723123,60396723202,60396723213,60396723220,60396723222,60396723223,60396723231,60396723232,60396723233,60396730001,60396730003,60397611101,60397611103,60397611121,60397611123,60397611231,60397611233,60397611301,60397611303,60397613011,60397613013,60397613031,60397613033,60397613301,60397613303,60397613331,60397613333,60397720001,60397720030,60397720031,60397720300,60397720301,60397720303,60397720321,60397720330,60397720331,60397720333,60397723311,60397723313,60397723331,60397723333,60404022322,60404022323,60404022332,60404422301,60404422303,60404422321,60404422323,60404430230,60404430232,60404432010,60404432012,60404432030,60404432032,60404432210,60404432220,60404432222,60404433333,60404522203,60404522221,60404522222,60404522223,60404523310,60404523312,60404523313,60404532202,60404532203,60404533202,60404533203,60404533212,60404533213,60404533302,60404533303,60404533312,60404533330,60404533332,60405000003,60405000012,60405000013,60405000021,60405000023,60405000110,60405000112,60405000130,60405000132,60405001200,60405001202,60405001220,60405001222,60405002110,60405002111,60405002112,60405002130,60405002132,60405003000,60405003212,60405003213,60405003322,60405003323,60405003332,60405003333,60405011211,60405011213,60405011231,60405011233,60405012312,60405012313,60405012323,60405013001,60405013003,60405013021,60405013023,60405013201,60405013202,60405013203,60405030002,60405030003,60405030012,60405030013,60405030101,60405030102,60405030103,60405100200,60405100202,60405110133,60405111022,60405111023,60405111032,60405200220,60405200222,60405200330,60405200332,60405201311,60405201313,60405201331,60405201333,60405213232,60405231010,60405231012,60405231013,60405231102,60405231120,60405231122,60405311231,60405311233,60405313011,60405313013,60405313031,60405313033,60405321112,60405321113,60405400022,60405400023,60405400032,60405400033,60405400101,60405400103,60405400122,60405400123,60405400131,60405400132,60405400133,60405410000,60405410002,60405410003,60405410012,60405410013,60405410102,60405410120,60405410122,60405410123,60405410132,60405410133,60405411012,60405411013,60405411022,60405411102,60405411103,60405411111,60405411112,60405411113,60405510012,60405510030,60405510032,60405510033,60405510102,60405510103,60405510112,60405510113,60405511110,60405511112,60405511130,60405511132,60405511310,60405511312,60405600230,60405600232,60405603031,60405603033,60405603211,60405603212,60405603213,60405612202,60405612220,60405612222,60405630000,60405630002,60405630020,60405630022,60405630200,60405630202,60405630220,60405630222,60405632000,60405632002,60405632030,60405632032,60405632033,60405632122,60405632123,60405632312,60405632330,60405632332,60405632333,60405633222,60405633223,60405633232,60405633233,60405633322,60406611100,60406611102,60406611103,60406611112,60406611113,60406611310,60406611312,60406611330,60406611332,60406613100,60406613102,60406613120,60406613210,60406613211,60406613212,60406613220,60406613221,60406613222,60406613230,60406631000,60406631002,60406631030,60406631032,60406631033,60406631302,60406633102,60406633120,60406633122,60406633300,60406633302,60406633320,60407611230,60407611231,60407612030,60407612031,60407612032,60407612110,60407612111,60407612120,60407612121,60407612210,60407612212,60407612230,60407621220,60407621221,60407621230,60407621310,60407621312,60407622110,60407622111,60407622120,60407622121,60407622122,60407622210,60407622211,60407622220,60407622222,60407622300,61390701111,61390701113,61390701131,61390710010,61390710011,61390710020,61390710021,61390710120,61390710121,61390710123,61390710301,61390710303,61390710331,61390710333,61390712111,61390712113,61390712131,61390712133,61390712311,61390712313,61390713231,61390713233,61390731011,61390733131,61390733133,61390733311,61390733313,61390733331,61400022220,61400022221,61400022230,61400022231,61400022320,61400022321,61400022323,61400033230,61400033231,61400033300,61400033301,61400033310,61400033311,61400122220,61400122221,61400122230,61400122231,61400122233,61400433130,61400433131,61400433132,61400511110,61400511112,61400511130,61400511132,61400511230,61400511231,61400511232,61400511300,61400511301,61400513000,61400513001,61400513002,61400513010,61400513020,61400520320,61400520321,61400520322,61400520330,61400520331,61400521220,61400521221,61400521230,61400521231,61400521232,61400521310,61400521311,61400521320,61400521321,61400522010,61400522011,61400522020,61400522021,61400522100,61400523010,61400530100,61400530102,61400530120,61400530122,61400530200,61400530201,61400530210,61400530211,61401000101,61401000130,61401000131,61401001201,61401001203,61401010130,61401010131,61401010132,61401011000,61401011001,61401011002,61401011020,61401100011,61401100100,61401100101,61401100103,61401100121,61401100130,61401100131,61401101201,61401101203,61401101231,61401101233,61401103131,61401103133,61401112200,61401112201,61401112210,61401112211,61401112300,61401112301,61401112310,61401112311,61401113210,61401113211,61401113320,61401113321,61401113323,61401131101,61401131131,61401222031,61401222033,61401222211,61401411010,61401411012,61401411030,61401411032,61401411210,61401411212,61401411220,61401411221,61401411230,61401412110,61401412111,61401412112,61401412120,61401412121,61401412122,61401412130,61401412300,61401412302,61401412320,61401412322,61401412323,61401412332,61401430030,61401430031,61401430110,61401430112,61401430120,61401430121,61401430130,61402200100,61402200101,61402200331,61402200333,61402202111,61402203000,61402203001,61402203003,61402203021,61402203023,61402203201,61402203203,61402203221,61402203223,61402221001,61402223300,61402223301,61402223303,61402223321,61402223323,61402410300,61402410302,61402410330,61402410332,61402412110,61402412112,61402412130,61402412132,61402412310,61402412312,61402412330,61402412332,61402430100,61402430101,61402430102,61402430110,61402430120,61402430122,61402430230,61402430231,61402430300,61402432032,61402432033,61402432322,61403201101,61403201103,61403201121,61403201123,61403201301,61403201303,61403201331,61403201333,61403203111,61403203113,61403203131,61403203133,61403203311,61403203313,61403203331,61403203333,61403232200,61403232201,61403232203,61403232221,61403232223,61403403320,61403403321,61403403322,61403410100,61403410102,61403410120,61403410122,61403410300,61403410302,61403412000,61403412002,61403421100,61403421102,61403421120,61403421122,61403421300,61403421302,61403422130,61403422132,61403422300,61403422302,61403422320,61403422322,61404210001,61404210003,61404210021,61404210023,61404210201,61404210203,61404210221,61404210223,61404212001,61404212003,61404212021,61404212023,61404212201,61404212203,61404212231,61404212233,61404230011,61404230013,61404230031,61404230033,61404230211,61404230213,61404230231,61404230233,61404232011,61404232013,61404232031,61404232033,61404232203,61404232211,61404232212,61404232213,61404232221,61404232223,61404331110,61404331111,61404332330,61404332331,61404333030,61404333031,61404333120,61404333200,61404333201,61404400100,61404402030,61404402032,61404402200,61404402201,61404402210,61405113313,61405113331,61405113333,61405131111,61405131113,61405131131,61405201311,61405201313,61405201321,61405201323,61405202032,61405202033,61405202122,61405202123,61405202132,61405202133,61405202202,61405202203,61405203012,61405203013,61405203023,61405203201,61405203202,61405203203,61405210001,61405210003,61405220200,61405220201,61405220230,61405220231,61405220300,61405220301,61405220310,61405220311,61405220313,61405220331,61405221120,61405221121,61405221122,61405221130,61405221131,61405221133,61405221210,61405221211,61405221220,61405221221,61405221300,61405221311,61405221331,61405221333,61405223111,61405232000,61405232001,61405232003,61405232031,61405232033,61405232211,61405232213,61405232231,61405232233,61405233100,61405233102,61405233120,61405233122,61405233300,61405233302,61405302230,61405302231,61405302232,61405302310,61405302311,61405302320,61405302321,61405303030,61405303031,61405303120,61405303121,61405303130,61405303131,61405303200,61405303201,61405312000,61405312001,61405312002,61405312010,61405312011,61405312020,61405320010,61405320012,61405320020,61405320022,61406210320,61406210321,61406212102,61406212103,61406213130,61406213131,61406231100,61406231102,61406231120,61406231122,61406232311,61406233010,61406233011,61406233200,61406233201,
013,00,,503760937,143240625,507585937,145809375,28,29,70,199,346,782,594063,594073,594074,604002,604003,604004,604005,604010,604011,604012,604013,604014,604015,604021,604022,604023,604024,604025,604031,604032,604033,604034,604035,604036,604041,604042,604043,604046,5940621,5940623,5940721,5940722,5940723,6040012,6040013,6040060,6040062,6040160,6040162,6040200,6040201,6040203,6040260,6040262,6040263,6040301,6040303,6040370,6040372,6040401,6040403,6040440,6040441,6040450,6040451,6040470,6040530,59405232,59405333,59406402,59406420,59406422,59406423,59406432,59406433,59407033,59407203,59407502,59407520,59407522,59407523,59407623,59407632,60391711,60391713,60394733,60400011,60400013,60400031,60400032,60400033,60400100,60400102,60400103,60400111,60400112,60400113,60400610,60400612,60400630,60400632,60401610,60401612,60401630,60401632,60402021,60402023,60402610,60402612,60402613,60402722,60402723,60403001,60403003,60403021,60403023,60404001,60404003,60404020,60404021,60404023,60404420,60404431,60404520,60404521,60404530,60404531,60404712,60404720,60404721,60404722,60404730,60405010,60405211,60405310,60405601,60405610,594052300,594052302,594052303,594052330,594052332,594053232,594053233,594053310,594053312,594053313,594053322,594053323,594054202,594054220,594054222,594062213,594062231,594062233,594064000,594064002,594064003,594064030,594064032,594064210,594064212,594064213,594064302,594064303,594064312,594064313,594065220,594065222,594070312,594070321,594070323,594071222,594071333,594072003,594072011,594072012,594072013,594072021,594072022,594072023,594075000,594075002,594075003,594075030,594075032,594075210,594075212,594075213,594075302,594075320,594075322,594075323,594076201,594076203,594076212,594076213,594076221,594076222,594076223,594076302,594076303,603907303,603907321,603907323,603907330,603907332,603917311,603917313,603917331,603917333,603927111,603927113,603927131,603947313,603947323,604000101,604000103,604000121,604000123,604000231,604000232,604000233,604000301,604000302,604000303,604001011,604001012,604001013,604001102,604001103,604016112,604016130,604016132,604016310,604016312,604016330,604016332,604020200,604020201,604020203,604020221,604020223,604026110,604026112,604026113,604027200,604027202,604027203,604030001,604030003,604037302,604037320,604037322,604040021,604040023,604040220,604040221,604040222,604044210,604044211,604044212,604044220,604044221,604044222,604044300,604044301,604044303,604044321,604044323,604044330,604044331,604044332,604045231,604045320,604045321,604045323,604045330,604045331,604047100,604047102,604047130,604047132,604047230,604047231,604047232,604047310,604047312,604047320,604047321,604047323,604050010,604050011,604050013,604050031,604050110,604050111,604050120,604050121,604050122,604051000,604051001,604051010,604051011,604051100,604051111,604052000,604052001,604052010,604052011,604052012,604052100,604052101,604052131,604052133,604053110,604053111,604053121,604053200,604053201,604053210,604056000,604056001,604056003,604056110,604056112,604056120,604056121,604056123,604056130,604056132,604056301,604056303,604056310,604056312,604056330,5940522331,5940522332,5940522333,5940523012,5940523013,5940523120,5940523122,5940523330,5940523332,5940523333,5940532222,5940532223,5940532232,5940532233,5940532311,5940532312,5940532313,5940533033,5940533110,5940533112,5940533200,5940533202,5940533203,5940533211,5940533212,5940533213,5940542032,5940542210,5940542212,5940542230,5940620110,5940620111,5940620113,5940620133,5940620311,5940620312,5940620313,5940620330,5940620331,5940620333,5940622111,5940622112,5940622113,5940622321,5940622323,5940640122,5940642110,5940642112,5940642113,5940643102,5940643103,5940643112,5940643113,5940652020,5940652022,5940652023,5940703031,5940703032,5940703033,5940703130,5940703132,5940703133,5940703201,5940703203,5940703221,5940703223,5940712202,5940712232,5940713311,5940713312,5940713313,5940720013,5940720101,5940720102,5940720103,5940750122,5940750332,5940750333,5940752110,5940752112,5940752113,5940753002,5940753003,5940753210,5940753212,5940753213,5940753313,5940753322,5940753323,5940753331,5940753332,5940753333,5940762001,5940762002,5940762003,5940762020,5940762021,5940762023,5940762100,5940762102,5940762103,5940762112,5940762113,5940762201,5940762202,5940762203,5940763003,5940763011,5940763012,5940763013,6039073122,6039073123,6039073203,6039073221,6039171010,6039171011,6039171013,6039171031,6039171033,6039173101,6039173103,6039173121,6039271333,6039273111,6039473111,6039473112,6039473113,6039473122,6039473123,6039473213,6039473221,6039473223,6039571001,6039571010,6039571011,6039571111,6040001001,6040001003,6040001021,6040001023,6040001201,6040001203,6040001221,6040001223,6040002133,6040002223,6040002231,6040002232,6040002233,6040002302,6040002303,6040003001,6040003003,6040010100,6040010102,6040010103,6040011002,6040011003,6040011011,6040011012,6040011013,6040061122,6040061322,6040063100,6040161100,6040161102,6040161103,6040161130,6040161132,6040161133,6040161310,6040161311,6040161312,6040161330,6040163132,6040163133,6040163310,6040163311,6040202021,6040202023,6040202201,6040202203,6040202221,6040202223,6040270022,6040270200,6040270202,6040270220,6040270222,6040270223,6040272122,6040272123,6040273222,6040300210,6040300211,6040300213,6040300231,6040300233,6040302011,6040302013,6040302031,6040302033,6040302211,6040302213,6040302231,6040302233,6040371000,6040371002,6040371020,6040371022,6040371200,6040371202,6040371220,6040371222,6040373000,6040373002,6040373232,6040400011,6040400013,6040400031,6040400033,6040400222,6040400223,6040402230,6040402231,6040442130,6040442131,6040442132,6040442300,6040443020,6040443021,6040443223,6040443330,6040443331,6040443332,6040452200,6040452202,6040453221,6040453223,6040471010,6040471012,6040471030,6040471032,6040471123,6040472330,6040472331,6040473220,6040473221,6040473223,6040473300,6040473301,6040473302,6040473320,6040473322,6040500121,6040500123,6040500301,6040500302,6040500303,6040500330,6040500331,6040501120,6040501122,6040501230,6040510021,6040510030,6040510121,6040510130,6040510131,6040511010,6040511011,6040511012,6040511100,6040511101,6040511131,6040520020,6040520021,6040520030,6040520031,6040520130,6040520132,6040521021,6040521030,6040521031,6040521301,6040521303,6040521321,6040523111,6040523113,6040531120,6040531121,6040531122,6040531130,6040531200,6040531201,6040531300,6040531302,6040532021,6040532030,6040532110,6040532112,6040532130,6040540000,6040540001,6040541011,6040541100,6040560020,6040560021,6040560210,6040560211,6040560213,6040560300,6040560301,6040560302,6040560310,6040560311,6040561110,6040561112,6040561130,6040561132,6040561221,6040561223,6040561310,6040561312,6040561330,6040561332,6040563001,6040563003,6040563021,6040563023,6040563110,6040563112,6040563130,6040563132,6040563201,6040563210,6040563211,6040563213,6040563310,6040563312,6040563320,6040563321,6040563330,6040563333,6040571100,6040571101,59405203333,59405212222,59405212223,59405212232,59405212233,59405212322,59405221111,59405221113,59405221331,59405221333,59405223111,59405223113,59405223131,59405223133,59405223301,59405223302,59405223303,59405230100,59405230102,59405230103,59405230112,59405230113,59405231022,59405231023,59405231212,59405231230,59405231232,59405233100,59405233102,59405233120,59405233122,59405233310,59405233312,59405233313,59405313222,59405313223,59405313232,59405313233,59405313322,59405313323,59405322202,59405322203,59405322212,59405322213,59405322302,59405322303,59405322311,59405322312,59405322313,59405323031,59405323033,59405330133,59405330311,59405330313,59405331112,59405331130,59405331132,59405331133,59405420022,59405420023,59405420032,59405420033,59405420302,59405420303,59405422320,59405422322,59406201121,59406201123,59406201303,59406201311,59406201312,59406201313,59406201321,59406201323,59406203101,59406203103,59406203321,59406203323,59406221101,59406221102,59406221103,59406223032,59406223033,59406400100,59406400102,59406400120,59406400122,59406400123,59406400132,59406400133,59406401022,59406401200,59406401202,59406401230,59406401232,59406403322,59406403323,59406421112,59406421113,59406430002,59406430020,59406430022,59406430023,59406430032,59406430123,59406430132,59406430133,59406431002,59406431003,59406431012,59406431013,59406431102,59406431103,59406431112,59406431113,59406520022,59406520023,59406520210,59406520212,59406520320,59406520322,59406522100,59406522102,59406522120,59406522122,59406522300,59406522302,59406522320,59406522322,59407030231,59407030233,59407030301,59407030303,59407031310,59407031312,59407032003,59407032021,59407032023,59407113313,59407113331,59407113333,59407120220,59407120222,59407122000,59407122002,59407122003,59407122012,59407122030,59407122032,59407122033,59407122302,59407122303,59407122312,59407122330,59407122332,59407122333,59407123222,59407123322,59407123323,59407123332,59407123333,59407131111,59407131113,59407133101,59407133102,59407133103,59407133232,59407133233,59407200231,59407200233,59407201003,59407202011,59407202013,59407202022,59407202023,59407202031,59407202032,59407202033,59407500100,59407500102,59407500120,59407500122,59407501200,59407501202,59407503122,59407503300,59407503302,59407503303,59407503312,59407503313,59407521110,59407521112,59407521113,59407530002,59407530003,59407530012,59407530120,59407530122,59407530300,59407530302,59407530320,59407530322,59407531131,59407531133,59407531311,59407531313,59407531331,59407532110,59407532112,59407532113,59407533002,59407533020,59407533022,59407533112,59407533113,59407533200,59407533202,59407533203,59407533212,59407533213,59407533302,59407533303,59407602232,59407602233,59407602322,59407602323,59407602332,59407602333,59407603222,59407603223,59407612332,59407612333,59407613222,59407620220,59407620221,59407620223,59407621012,59407621013,59407621102,59407622001,59407622002,59407622003,59407630013,59407630102,59407630103,59407631000,59407631002,59407631222,59407633000,59407633002,59407633020,59407633022,59407633200,59407633202,59407633220,59407633222,60390731200,60390731202,60390731322,60390732012,60390732013,60390732230,60390732231,60390733100,60390733102,60390733120,60390733122,60390733300,60390733302,60390733320,60390733322,60391710120,60391710121,60391710123,60391710301,60391710303,60391710321,60391710323,60391712111,60391712113,60391712131,60391712133,60391731000,60391731001,60391731003,60391731021,60391731023,60391731201,60391731203,60391731231,60391731233,60391733011,60391733013,60391733031,60391733033,60392711033,60392711211,60392711213,60392713300,60392713301,60392713310,60392713311,60392713313,60392731130,60392731131,60392731133,60394713331,60394713332,60394713333,60394731013,60394731031,60394731033,60394731102,60394731103,60394731211,60394731213,60394732111,60394732113,60394732121,60394732123,60394732223,60395701113,60395701131,60395710001,60395710002,60395710003,60395710020,60395710021,60395710030,60395710031,60395710120,60395710121,60395710130,60395710131,60395710132,60395711000,60395711001,60395711010,60395711011,60395711100,60395711101,60395711103,60395711121,60395711130,60395711131,60400012223,60400021233,60400021311,60400021313,60400021322,60400021323,60400022123,60400022132,60400022133,60400022221,60400022223,60400022301,60400022302,60400022303,60400023002,60400023003,60400023011,60400023012,60400023013,60400030001,60400030003,60400030021,60400030023,60400110000,60400110002,60400611000,60400611002,60400611020,60400611022,60400611200,60400611202,60400611203,60400611212,60400611230,60400611232,60400613000,60400613002,60400613020,60400613022,60400613200,60400613202,60400613230,60400613232,60400631010,60400631012,60400631020,60400631022,60400631200,60400631202,60400631220,60400633220,60400633222,60400633223,60400633232,60401611010,60401611012,60401611013,60401611102,60401611120,60401611122,60401611123,60401611132,60401611310,60401611312,60401611313,60401613130,60401613131,60401613132,60401613310,60401613312,60401613320,60401613322,60401631100,60401631102,60401631120,60401631122,60401631300,60401631302,60401631303,60401631312,60401633120,60401633121,60401633122,60401633130,60401633131,60401722020,60401722021,60402020201,60402020203,60402020221,60402020223,60402022001,60402022003,60402611122,60402702010,60402702012,60402702030,60402702032,60402702210,60402702212,60402702213,60402702302,60402702320,60402702322,60402702323,60402720100,60402720102,60402720120,60402720122,60402720123,60402721320,60402721322,60402732202,60402732203,60402732232,60403000010,60403000011,60403002120,60403002121,60403002123,60403002301,60403002303,60403002321,60403002323,60403020101,60403020103,60403020121,60403020123,60403020301,60403020303,60403020321,60403020323,60403710230,60403710232,60403712010,60403712012,60403712030,60403712032,60403712033,60403712122,60403730030,60403730032,60403730300,60403730302,60403730320,60403730322,60403732100,60403732102,60403732120,60403732122,60403732300,60403732302,60403732303,60403732332,60404000321,60404000323,60404022320,60404022321,60404022330,60404022331,60404022333,60404422300,60404422302,60404422320,60404422322,60404430231,60404430233,60404432011,60404432013,60404432031,60404432033,60404432211,60404432212,60404432213,60404432221,60404432223,60404433330,60404433331,60404433332,60404522200,60404522201,60404522202,60404522220,60404523311,60404532200,60404532201,60404533200,60404533201,60404533210,60404533211,60404533300,60404533301,60404533310,60404533311,60404533313,60404533331,60404533333,60404710110,60404710330,60404710332,60404710333,60404711211,60404711213,60404711222,60404711223,60404711320,60404711322,60404713100,60404713102,60404713120,60404713122,60404713300,60404713302,60404713303,60404713312,60404713320,60404713322,60404723320,60404723321,60404723330,60404723331,60404731100,60404732220,60404732221,60404732223,60405000000,60405000001,60405000002,60405000010,60405000011,60405000020,60405000022,60405000111,60405000113,60405000131,60405000133,60405001201,60405001203,60405001221,60405001223,60405002113,60405002131,60405002133,60405003001,60405003002,60405003003,60405003210,60405003211,60405003320,60405003321,60405003330,60405003331,60405011210,60405011212,60405011230,60405011232,60405012310,60405012311,60405012320,60405012321,60405012322,60405013000,60405013002,60405013020,60405013022,60405013200,60405030000,60405030001,60405030010,60405030011,60405030100,60405100201,60405100203,60405110130,60405110131,60405110132,60405111020,60405111021,60405111030,60405111031,60405111033,60405200221,60405200223,60405200331,60405200333,60405201310,60405201312,60405201330,60405201332,60405213230,60405213231,60405213233,60405231011,60405231100,60405231101,60405231103,60405231121,60405231123,60405311230,60405311232,60405313010,60405313012,60405313030,60405313032,60405321110,60405321111,60405400020,60405400021,60405400030,60405400031,60405400100,60405400102,60405400120,60405400121,60405400130,60405410001,60405410010,60405410011,60405410100,60405410101,60405410103,60405410121,60405410130,60405410131,60405411010,60405411011,60405411020,60405411021,60405411023,60405411100,60405411101,60405411110,60405510010,60405510011,60405510013,60405510031,60405510100,60405510101,60405510110,60405510111,60405511111,60405511113,60405511131,60405511133,60405511311,60405511313,60405600231,60405600233,60405603030,60405603032,60405603210,60405611110,60405611111,60405611112,60405611130,60405611132,60405611310,60405611312,60405611330,60405611332,60405612200,60405612201,60405612203,60405612221,60405612223,60405613110,60405613112,60405613130,60405613132,60405613310,60405613312,60405613330,60405613332,60405630001,60405630003,60405630021,60405630023,60405630201,60405630203,60405630221,60405630223,60405631110,60405631112,60405631130,60405631132,60405631310,60405631312,60405631330,60405631332,60405632001,60405632003,60405632031,60405632120,60405632121,60405632310,60405632311,60405632313,60405632331,60405633110,60405633112,60405633130,60405633132,60405633220,60405633221,60405633230,60405633231,60405633310,60405633312,60405633320,60405633321,60405633323,60405700000,60405700001,60405700010,60405700011,60405700100,60405700101,60405700110,60405700111,60405701000,60405701001,60405701010,60405701011,60405710001,60405710010,60405710011,60405710100,60405710101,60405710110,60405710111,60405711020,60405711021,60405711030,60405711031,60406611101,60406611110,60406611111,
014,00,,502889062,140437500,505884375,144300000,10,47,84,233,462,911,584051,584060,584070,584071,594001,594011,594031,594041,594051,594061,5839573,5839671,5839673,5839771,5840422,5840502,5840503,5840520,5840610,5840612,5840720,5840722,5939662,5939760,5939761,5939770,5939771,5939773,5940001,5940003,5940101,5940103,5940201,5940203,5940210,5940211,5940212,5940301,5940303,5940401,5940403,5940420,5940422,5940423,5940432,5940501,5940503,5940530,5940601,5940602,5940603,5940700,5940701,5940702,5940710,6039071,6040000,58395721,58395723,58396701,58396703,58396721,58404122,58404123,58404131,58404132,58404133,58404232,58405011,58405012,58405013,58405220,58405222,58406110,58406111,58406112,58406130,58406132,58406133,58407212,58407230,59396630,59396632,59396633,59396722,59396723,59396731,59396732,59396733,59397511,59397531,59397720,59397721,59397723,59400001,59400003,59400021,59400023,59400200,59400220,59400222,59400223,59401001,59401003,59401220,59402130,59402132,59402133,59404212,59404330,59404332,59404333,59405023,59405200,59405201,59405202,59405210,59405211,59405213,59405220,59405222,59405310,59405311,59405312,59405320,59405321,59406001,59406002,59406003,59406200,59406202,59406220,59406222,59407110,59407111,59407112,59407121,59407130,59407132,60390701,60400020,583957022,583957023,583957032,583957033,583957122,583957123,583957131,583957132,583957133,583957201,583957203,583967023,583967230,583967231,583967233,583977010,583977011,583977013,583977031,583977310,583977311,583977313,583977331,584040333,584041123,584041132,584041133,584041212,584041213,584041301,584041302,584041303,584042013,584042022,584042023,584042031,584042032,584042033,584042120,584042122,584042300,584042301,584042302,584050022,584050101,584050103,584052100,584052101,584052102,584052210,584052211,584052212,584061130,584061132,584061310,584062000,584062002,584062220,584062222,584062223,584062232,584062233,584062322,584062323,584072100,584072101,584072102,584072310,584072320,584072321,584072322,593965313,593965331,593965332,593965333,593966021,593966022,593966023,593966030,593966032,593966033,593966120,593966122,593966123,593966132,593966310,593966312,593967131,593967133,593967302,593967303,593975103,593975130,593975131,593975133,593975301,593975303,593975321,593975323,593976200,593976201,593976310,593976311,593976313,593977220,593977221,593977223,594000000,594000001,594000003,594000021,594000023,594000201,594000203,594002010,594002011,594002012,594002020,594002021,594002022,594002100,594002210,594002211,594002212,594010211,594010213,594010231,594010233,594012000,594012001,594012002,594012020,594012022,594012023,594012220,594012222,594020011,594020013,594020031,594021310,594021312,594022000,594022222,594032000,594032002,594032020,594032022,594032023,594032200,594032201,594032202,594032220,594032222,594032223,594032231,594032232,594032233,594040233,594042100,594042102,594042103,594042130,594042132,594042133,594043022,594043023,594043122,594043310,594043312,594043313,594044220,594044222,594050011,594050013,594050031,594050033,594050211,594050212,594050213,594052030,594052031,594052032,594052120,594052121,594052210,594052212,594052230,594052232,594052311,594052313,594053130,594053220,594053221,594053300,594053302,594054000,594054002,594060001,594060003,594062010,594062012,594062030,594062032,594062210,594062212,594070300,594070301,594070310,594070311,594071130,594071131,594071132,594071200,594071201,594071203,594071221,594071230,594071231,594071310,594071312,594071313,594071330,594072000,603907031,603907033,603907300,603907301,603907302,603907310,603907311,604000210,604000211,604000220,5839561313,5839561331,5839570202,5839570203,5839570212,5839570213,5839570302,5839570303,5839570312,5839570313,5839571202,5839571203,5839571212,5839571213,5839571301,5839571302,5839571303,5839572001,5839572003,5839572021,5839572023,5839572210,5839572211,5839572213,5839572231,5839572233,5839670213,5839672010,5839672011,5839672013,5839672031,5839672321,5839672323,5839770120,5839770121,5839770123,5839770301,5839770330,5839770331,5839773121,5839773330,5839773331,5839773333,5840403223,5840403232,5840403233,5840403311,5840403313,5840403322,5840403323,5840411303,5840411312,5840411313,5840412011,5840412013,5840412022,5840412023,5840412031,5840412032,5840412033,5840412100,5840412102,5840412103,5840412112,5840420123,5840420202,5840420203,5840420212,5840420213,5840420301,5840420302,5840420303,5840421020,5840421022,5840421023,5840421230,5840421232,5840421233,5840421322,5840423030,5840423031,5840423032,5840423100,5840423102,5840423302,5840423320,5840423322,5840500200,5840500202,5840500232,5840500233,5840500322,5840501001,5840501002,5840501003,5840501021,5840501023,5840521030,5840521031,5840521100,5840521200,5840521202,5840522130,5840522300,5840522302,5840522320,5840522322,5840611310,5840611311,5840611312,5840613120,5840613122,5840613123,5840613132,5840613133,5840620010,5840620011,5840620200,5840622022,5840622023,5840622210,5840622212,5840622213,5840622302,5840623320,5840623322,5840721030,5840721032,5840721033,5840721100,5840721102,5840721302,5840721320,5840721322,5840723120,5840723122,5840723230,5840723231,5840723232,5840723300,5840723302,5840723320,5939071111,5939071113,5939651313,5939651331,5939651333,5939653111,5939653113,5939653303,5939660023,5939660133,5939660201,5939660202,5939660203,5939660311,5939660312,5939660313,5939661022,5939661023,5939661212,5939661213,5939661302,5939661303,5939661312,5939661330,5939661332,5939663110,5939663112,5939663130,5939663132,5939663133,5939671133,5939671321,5939671322,5939671323,5939672022,5939672023,5939672032,5939672132,5939672133,5939673013,5939751011,5939751012,5939751013,5939751210,5939751211,5939751213,5939751232,5939751233,5939751321,5939751322,5939751323,5939753021,5939753023,5939753201,5939753203,5939753221,5939753223,5939753300,5939753301,5939753302,5939753310,5939753320,5939762020,5939762021,5939762030,5939762100,5939762101,5939763001,5939763010,5939763011,5939763120,5939763121,5939763311,5939763313,5939772220,5939772221,5939772223,5940000020,5940000021,5940000023,5940000201,5940000203,5940000221,5940000223,5940002001,5940002211,5940002213,5940002231,5940002233,5940020130,5940020131,5940020132,5940020230,5940020232,5940020233,5940020322,5940020323,5940020332,5940020333,5940021010,5940021012,5940021020,5940021021,5940022130,5940022131,5940023000,5940023002,5940023003,5940023020,5940100011,5940100013,5940100031,5940102101,5940102103,5940102121,5940102123,5940120030,5940120032,5940120033,5940120100,5940120210,5940120212,5940120320,5940120322,5940122100,5940122102,5940122210,5940122212,5940122213,5940122230,5940122231,5940122232,5940200330,5940200331,5940200333,5940202111,5940202113,5940202131,5940202133,5940202311,5940202313,5940202331,5940213110,5940213112,5940213130,5940213132,5940213133,5940220010,5940220020,5940320030,5940320032,5940320210,5940320212,5940320213,5940320320,5940320322,5940322030,5940322031,5940322032,5940322100,5940322102,5940322120,5940322210,5940322212,5940322213,5940322302,5940322303,5940402133,5940402311,5940402312,5940402313,5940421013,5940421102,5940421120,5940421122,5940421310,5940421312,5940421313,5940430202,5940430203,5940430212,5940430320,5940430322,5940430333,5940431232,5940431233,5940433112,5940442020,5940442022,5940442023,5940442230,5940442232,5940500103,5940500121,5940500123,5940500301,5940500303,5940500321,5940500322,5940500323,5940502033,5940502101,5940502102,5940502103,5940502211,5940502213,5940502231,5940502232,5940502233,5940520330,5940520331,5940520332,5940521220,5940521221,5940521230,5940521231,5940521233,5940522110,5940522112,5940522113,5940522130,5940522131,5940522132,5940522310,5940522312,5940523100,5940523101,5940523103,5940523311,5940523313,5940531310,5940531311,5940531312,5940531320,5940531321,5940531330,5940532300,5940532301,5940532302,5940532310,5940533010,5940533011,5940533012,5940533030,5940533032,5940533201,5940533210,5940600001,5940600003,5940600021,5940600022,5940600023,5940622300,5940622301,5940622302,5940622320,5940622322,5940703020,5940703021,5940703022,5940703220,5940703222,5940711330,5940711332,5940712020,5940712021,5940712023,5940712320,5940712321,5940712323,5940712330,5940712331,5940713110,5940713112,5940713113,5940713320,5940713321,5940713322,5940720010,5940720011,5940720012,5940720020,5940720021,5940720022,5940720200,6039051010,6039070010,6039070011,6039070013,6039070300,6039070301,6039070303,6039072111,6039072113,6039073121,6039073130,6039073131,6039073133,6039073311,6039073313,6039073331,6039073333,6040001000,6040001002,6040001020,6040001022,6040001200,6040001202,6040001220,6040002120,6040002121,6040002122,6040002130,6040002210,6040002211,6040002220,6040002221,6040010101,6040011001,6040011010,58395613330,58395613331,58395613333,58395631111,58395703113,58395711223,58395711232,58395711233,58395711322,58395711323,58395711332,58395711333,58395712002,58395712003,58395712012,58395712013,58395712102,58395712103,58395712112,58395712113,58395713001,58395713002,58395713003,58395720000,58395720001,58395720003,58395720021,58395720023,58395720201,58395720203,58395720221,58395720223,58395722010,58395722011,58395722120,58395722121,58395722123,58395722301,58395722303,58395722321,58395722323,58396700101,58396700110,58396700111,58396700113,58396700131,58396700133,58396700311,58396700313,58396700331,58396700333,58396702111,58396702113,58396702121,58396702123,58396720121,58396720123,58396720301,58396720303,58396720331,58396720333,58396722111,58396723200,58396723201,58396723222,58396723223,58397703030,58397703031,58397703033,58397703211,58397703331,58397703333,58397730111,58397730113,58397731201,58397731203,58397731221,58397731230,58397731231,58397731233,58397733011,58397733013,58397733031,58404031332,58404031333,58404033211,58404033213,58404112033,58404112122,58404112123,58404112132,58404112133,58404112211,58404112213,58404112231,58404112233,58404113003,58404113012,58404113013,58404113021,58404113022,58404113023,58404113102,58404113103,58404113112,58404113113,58404120123,58404120202,58404120203,58404120212,58404120213,58404120301,58404120302,58404120303,58404121132,58404121133,58404130011,58404130013,58404130022,58404130023,58404130031,58404130032,58404130033,58404201212,58404201213,58404201223,58404202002,58404202003,58404202012,58404202013,58404202102,58404202103,58404202112,58404202113,58404203001,58404203002,58404203003,58404210212,58404210213,58404212122,58404212123,58404212132,58404212310,58404212312,58404230330,58404230332,58404230333,58404233002,58404233003,58405000222,58405000223,58405001131,58405001133,58405001333,58405002030,58405002032,58405002300,58405002302,58405003111,58405003113,58405003131,58405003133,58405003311,58405003313,58405003331,58405003333,58405010001,58405010003,58405010201,58405010203,58405010221,58405010222,58405010223,58405211020,58405211021,58405212200,58405212201,58405212202,58405212220,58405221320,58405221322,58405223010,58406113130,58406113131,58406113300,58406113301,58406113302,58406113320,58406113322,58406131100,58406131102,58406131120,58406131122,58406131133,58406131210,58406131212,58406131213,58406131302,58406131303,58406131311,58406131312,58406131313,58406200120,58406200122,58406200300,58406200302,58406201001,58406202010,58406202011,58406202012,58406202020,58406202021,58406202030,58406220022,58406220200,58406220202,58406220203,58406220212,58406222110,58406222112,58406223030,58406223032,58406233210,58406233212,58406233230,58406233232,58407210310,58407210312,58407213232,58407213233,58407213322,58407231100,58407231102,58407231120,58407231122,58407231210,58407231211,58407231212,58407231230,58407231300,58407232330,58407232332,59390711311,59390711313,59390711331,59396513301,59396513303,59396513321,59396513323,59396531033,59396531101,59396531103,59396531121,59396531122,59396531123,59396531211,59396531213,59396531231,59396531233,59396532133,59396532311,59396532313,59396532331,59396532332,59396532333,59396533011,59396533013,59396533021,59396533022,59396533023,59396600221,59396600223,59396602001,59396602003,59396603101,59396603103,59396610320,59396610322,59396612100,59396612102,59396613130,59396613132,59396613310,59396613312,59396711313,59396712333,59396713201,59396713202,59396713203,59396721311,59396721313,59396730032,59396730033,59396730103,59396730111,59396730112,59396730113,59396730121,59396730122,59396730123,59397512011,59397512013,59397512031,59397512120,59397512121,59397512233,59397512302,59397512303,59397512312,59397512313,59397513201,59397513202,59397513203,59397530011,59397530013,59397530031,59397530033,59397530201,59397530203,59397530221,59397530223,59397532001,59397532003,59397532021,59397532023,59397532201,59397532203,59397532221,59397532223,59397533110,59397533111,59397620220,59397620221,59397620222,59397620230,59397620231,59397620310,59397620311,59397620312,59397620320,59397620321,59397620330,59397621020,59397621021,59397621022,59397621030,59397621200,59397622000,59397630001,59397630003,59397630120,59397630121,59397630130,59397630131,59397630133,59397630311,59397631220,59397631221,59397631230,59397631231,59397631233,59397633011,59397633100,59397633101,59397633103,59397633311,59397633313,59397722221,59397722223,59400000220,59400000221,59400000223,59400002001,59400002003,59400002021,59400002023,59400022100,59400022101,59400022103,59400022121,59400022123,59400022301,59400022303,59400022321,59400022323,59400201330,59400201331,59400202310,59400202312,59400202313,59400203000,59400203001,59400203010,59400203011,59400203100,59400203101,59400203202,59400203203,59400203212,59400203213,59400203302,59400203303,59400203312,59400203313,59400210110,59400210112,59400210130,59400210132,59400210220,59400210221,59400210230,59400210231,59400212222,59400212223,59400221320,59400221321,59400221322,59400221330,59400221331,59400230012,59400230013,59400230210,59400230211,59400230220,59400230221,59400232202,59400232220,59400232222,59401000330,59401000331,59401021001,59401021003,59401021021,59401021023,59401021201,59401021203,59401021221,59401021223,59401023011,59401023013,59401023031,59401023033,59401023211,59401023213,59401023231,59401023233,59401200310,59401200311,59401200312,59401201010,59401201011,59401201012,59401201020,59401201021,59401201030,59401201100,59401201101,59401201110,59401201111,59401202110,59401202111,59401202112,59401202130,59401202132,59401202133,59401203022,59401203023,59401203232,59401221010,59401221200,59401221201,59401222110,59401222112,59401222113,59401222330,59401222332,59402001011,59402001013,59402001031,59402003320,59402003321,59402023330,59402023331,59402023333,59402131110,59402131111,59402131312,59402131313,59402200110,59402200112,59402200120,59402200121,59402200122,59402200130,59402200210,59402200211,59402200212,59402200220,59402200221,59402200222,59402200230,59402200300,59402202000,59402202002,59402202020,59402202022,59402202200,59402202202,59402202220,59402202222,59402220000,59402222002,59402222020,59402222022,59402222023,59402222032,59402222033,59403001111,59403001113,59403001131,59403001133,59403001311,59403001313,59403001331,59403001333,59403003111,59403003113,59403003131,59403003133,59403003311,59403003313,59403003331,59403003333,59403021111,59403021113,59403021131,59403021133,59403021311,59403021313,59403021331,59403021333,59403023111,59403023113,59403023131,59403023133,59403023311,59403023313,59403023331,59403023333,59403200120,59403200122,59403200310,59403200312,59403200330,59403200332,59403202110,59403202112,59403202113,59403203022,59403203023,59403203230,59403203232,59403220330,59403220332,59403221010,59403221012,59403221030,59403221032,59403221210,59403221212,59403221322,59403221323,59403221332,59403221333,59403222110,59403222112,59403222113,59403223002,59403223003,59403223012,59403223013,59403230222,59403232000,59403232002,59403232020,59403232022,59403232200,59403232202,59403232220,59403232222,59404001111,59404001113,59404001131,59404001133,59404001311,59404001313,59404001331,59404001333,59404003111,59404003113,59404003131,59404003133,59404003311,59404003313,59404003331,59404003333,59404021111,59404021113,59404021131,59404021133,59404021311,59404021312,59404021313,59404023231,59404023233,59404210102,59404210112,59404210113,59404210120,59404210122,59404210123,59404211002,59404211003,59404211212,59404211230,59404211232,59404211233,59404211322,59404211323,59404213112,59404213113,59404302002,59404302003,59404302012,59404302013,59404302130,59404302132,59404303230,59404303232,59404303321,59404303323,59404312300,59404312302,59404313220,59404313222,59404331102,59404331103,59404331112,59404331130,59404331132,59404331133,59404420022,59404420023,59404420212,59404420213,59404420322,59404422100,59404422102,59404422120,59404422122,59405001003,59405001011,59405001012,59405001013,59405001021,59405001023,59405001201,59405001203,59405001221,59405001223,59405003001,59405003003,59405003021,59405003023,59405003201,59405003203,59405021001,59405021002,59405021003,59405022121,59405022123,59405022232,59405022233,59405022301,59405022302,59405022303,59405203330,59405203331,59405203332,59405212220,59405212221,59405212230,59405212231,59405212320,59405212321,59405212323,59405221110,59405221112,59405221330,59405221332,59405223110,59405223112,59405223130,59405223132,59405223300,59405230101,59405230110,59405230111,59405231020,59405231021,59405231210,59405231211,59405231213,59405231231,59405231233,59405233101,59405233103,59405233121,59405233123,59405233311,59405313130,59405313131,59405313132,59405313220,59405313221,59405313230,59405313231,59405313310,59405313312,59405313320,59405313321,59405313330,59405322200,59405322201,59405322210,59405322211,59405322300,59405322301,59405322310,59405323030,59405323032,59405330130,59405330131,59405330132,59405330310,59405330312,59405400100,59405400102,59405400120,59405400122,59405402000,59405402001,59405402002,59405402010,59405402011,59405402020,59406000023,59406000201,59406000202,59406000203,59406201120,59406201122,59406201300,59406201301,59406201302,59406201310,59406201320,59406201322,59406203100,59406203102,59406203320,59406203322,59406221100,59406223030,59406223031,59407030230,59407030232,59407030300,59407030302,59407031311,59407031313,59407032000,59407032001,59407032002,59407032020,59407032022,59407113310,59407113311,59407113312,59407113330,59407113332,59407120221,59407120223,59407122001,59407122010,59407122011,59407122013,59407122031,59407122300,59407122301,59407122310,59407122311,59407122313,59407122331,59407123220,59407123221,59407123223,59407123320,59407123321,59407123330,59407123331,59407131110,59407131112,59407133100,59407133230,59407133231,59407200230,59407200232,59407201000,59407201001,59407201002,59407202010,59407202012,59407202020,59407202021,59407202030,60390510011,60390510013,60390510031,60390510110,60390510112,60390510120,60390510121,60390510130,60390700010,60390700011,60390700120,60390700121,60390700123,60390700301,60390700310,60390700311,60390700313,60390700331,60390700333,60390702111,60390703211,60390703213,60390703231,60390703233,60390721100,60390721101,60390721310,60390721311,60390721313,60390721331,60390721333,60390731201,60390731203,60390731320,60390731321,60390731323,60390732001,60390732003,60390732010,60390732011,60390732021,60390732023,60390733101,60390733103,60390733121,60390733123,60390733301,60390733303,60390733321,60390733323,60400012220,60400012221,60400012222,60400021230,60400021231,60400021232,60400021310,60400021312,60400021320,60400021321,60400022120,60400022121,60400022122,60400022130,60400022131,60400022220,60400022222,60400022300,60400023000,60400023001,60400023010,60400030000,60400030002,60400030020,60400030022,60400110001,60400110003,60390510213,60390510211,60390510300,60390510033,60390510122,59397512122,59397512033,59402003323,
015,00,,504829687,139921875,507150000,143971875,22,27,80,185,395,893,584034,584043,584044,584045,584053,584054,584063,584064,584065,584073,584074,594003,594004,594013,594014,594023,594024,594033,594034,594035,594045,594055,5840350,5840352,5840353,5840523,5840550,5840551,5840552,5840621,5840750,5840752,5940121,5940123,5940221,5940223,5940250,5940252,5940321,5940440,5940441,5940443,5940541,5940543,5940641,5940650,5940651,5940653,5940751,58402422,58402423,58402430,58402432,58402433,58402522,58403311,58403313,58403331,58403332,58403333,58403510,58403512,58404602,58404620,58405213,58405530,58405532,58405533,58406203,58406221,58406230,58406231,58407510,59400211,59400213,59400231,59400233,59400500,59400502,59400522,59401223,59401500,59401502,59401520,59401522,59401523,59402201,59402203,59402221,59402223,59402512,59402530,59402532,59403201,59403231,59403233,59403602,59403620,59403622,59403623,59404300,59404301,59404310,59404311,59404421,59404423,59404600,59404601,59404602,59405401,59405403,59405421,59405423,59405600,59405602,59405603,59405620,59405622,59406521,59406523,59406600,59406602,59406620,59406622,59406623,59406632,59407600,59407601,59407610,584023333,584024213,584024312,584024313,584025202,584025203,584025230,584025232,584025233,584033103,584033121,584033123,584033222,584033223,584033232,584033233,584033301,584033303,584035112,584035130,584035132,584035133,584036200,584042130,584042131,584042133,584042311,584042312,584042313,584042331,584042333,584046002,584046003,584046212,584046220,584046221,584052111,584052112,584052113,584052121,584052123,584052231,584052233,584055310,584055312,584062011,584062012,584062013,584062021,584062022,584062023,584062201,584062203,584062231,584062320,584062321,584062330,584062331,584062333,584066000,584066002,584066003,584066202,584066220,584072111,584072112,584072113,584072131,584072331,584072333,584075110,584075120,584075122,594002103,594002120,594002121,594002123,594002301,594002303,594002320,594002321,594002323,594005010,594005012,594005030,594005032,594005200,594005201,594005202,594012012,594012013,594012031,594012033,594012211,594012213,594015010,594015012,594015030,594015032,594015210,594015212,594015213,594015320,594015322,594022021,594022023,594022201,594022202,594022203,594022221,594022223,594025100,594025102,594025103,594025130,594025132,594025332,594025333,594032031,594032033,594032211,594032300,594032301,594032303,594032321,594032323,594036002,594036030,594036032,594036210,594036212,594042111,594043030,594043031,594043120,594043121,594043130,594043131,594043133,594044201,594046030,594046200,594046201,594046202,594046220,594046222,594046223,594054003,594054021,594054022,594054023,594054201,594056010,594056012,594056013,594056122,594056210,594056211,594056212,594056300,594064011,594064013,594064031,594065201,594066212,594066213,594066302,594066303,594066310,594066311,594066312,594066330,594075010,594075011,594075013,594075310,594075312,594076020,594076021,594076030,594076031,594076033,594076120,594076121,594076122,5840233133,5840233311,5840233313,5840233322,5840233323,5840240333,5840241222,5840242022,5840242023,5840242111,5840242112,5840242113,5840242123,5840243102,5840243103,5840252001,5840252002,5840252003,5840252010,5840252012,5840252013,5840252120,5840252122,5840252123,5840252310,5840252312,5840252313,5840253222,5840323333,5840331011,5840331013,5840332303,5840332313,5840333021,5840333023,5840351102,5840360222,5840360223,5840362020,5840362021,5840362022,5840362200,5840362202,5840362220,5840362222,5840421111,5840421113,5840421131,5840421132,5840421133,5840421320,5840421321,5840421323,5840423101,5840423103,5840423301,5840423303,5840423321,5840423323,5840460000,5840460002,5840460003,5840460302,5840460320,5840460322,5840462100,5840462102,5840462103,5840462220,5840462300,5840462301,5840462302,5840521032,5840521033,5840521101,5840521103,5840521201,5840521203,5840521221,5840521223,5840522131,5840522133,5840522303,5840522321,5840522323,5840553110,5840553112,5840553130,5840553132,5840553133,5840560022,5840560222,5840562200,5840562202,5840562220,5840562222,5840562223,5840611331,5840611333,5840613111,5840620013,5840620031,5840620032,5840620033,5840620101,5840620102,5840620103,5840622000,5840622001,5840622003,5840622300,5840622301,5840660012,5840660013,5840660102,5840660120,5840660121,5840660200,5840660202,5840660220,5840660222,5840662000,5840662002,5840662032,5840662033,5840662210,5840662211,5840662212,5840662220,5840721101,5840721103,5840721300,5840721301,5840721303,5840721321,5840721330,5840721331,5840721333,5840723111,5840723113,5840723131,5840723132,5840723133,5840723301,5840723303,5840723321,5840723322,5840723323,5840751110,5840751111,5840751210,5840751212,5840751230,5840753220,5840753222,5840753223,5940020302,5940020303,5940020311,5940020312,5940020313,5940021220,5940021221,5940021223,5940023023,5940023221,5940023223,5940050110,5940050111,5940050112,5940050130,5940050132,5940050310,5940051000,5940052030,5940052032,5940120112,5940120113,5940120300,5940120301,5940120303,5940120321,5940122103,5940122121,5940122122,5940122123,5940150112,5940150130,5940150132,5940150330,5940150332,5940152110,5940152112,5940152113,5940153020,5940153022,5940153023,5940153210,5940153212,5940153230,5940153232,5940213113,5940220031,5940220032,5940220033,5940220201,5940220203,5940220221,5940220223,5940222001,5940222002,5940222003,5940222201,5940251010,5940251012,5940251013,5940253100,5940253300,5940253302,5940253303,5940253312,5940262222,5940320010,5940320011,5940320013,5940320300,5940320301,5940320303,5940320321,5940322122,5940322123,5940322130,5940322131,5940323020,5940323021,5940323023,5940323201,5940323203,5940323221,5940323223,5940360000,5940360002,5940360030,5940360032,5940360033,5940360312,5940360330,5940360332,5940362110,5940362112,5940362130,5940362132,5940362133,5940363200,5940363202,5940363220,5940363222,5940421101,5940421103,5940421130,5940421131,5940421133,5940430210,5940430211,5940430321,5940430330,5940430331,5940431231,5940431320,5940431321,5940431323,5940442000,5940442001,5940442003,5940442030,5940442031,5940442033,5940442211,5940442213,5940442231,5940442233,5940460310,5940460312,5940460320,5940460321,5940460322,5940460330,5940461000,5940461002,5940461020,5940462030,5940462031,5940462032,5940462210,5940462212,5940462320,5940462322,5940462323,5940462332,5940540011,5940540013,5940540203,5940542000,5940542001,5940542031,5940542033,5940542211,5940542213,5940542231,5940542233,5940560110,5940560112,5940561200,5940561202,5940561232,5940562130,5940562131,5940562300,5940563010,5940563011,5940563020,5940640011,5940640100,5940640101,5940640103,5940640121,5940640330,5940640331,5940640333,5940643001,5940643010,5940643011,5940652000,5940652001,5940652003,5940652030,5940652031,5940652033,5940652211,5940652213,5940652231,5940652233,5940661323,5940661332,5940662100,5940662102,5940662103,5940662112,5940662113,5940663130,5940663320,5940663321,5940663322,5940750011,5940750013,5940750121,5940750123,5940750310,5940750311,5940750313,5940753010,5940753011,5940753013,5940753031,5940753033,5940753110,5940753111,5940753112,5940753130,5940753132,5940753301,5940753303,5940753310,5940753312,5940760220,5940760221,5940760222,5940760230,5940760231,5940760320,5940760321,5940760323,5940761100,5940761102,5940761120,5940761122,5940761230,5940761231,5940761232,5940761300,5940761302,5940762000,5940762111,5940763000,5940763002,58402332313,58402332331,58402332332,58402332333,58402333033,58402333103,58402333121,58402333122,58402333123,58402333202,58402333203,58402333211,58402333212,58402333213,58402403312,58402403313,58402412202,58402412203,58402412212,58402412230,58402412232,58402412233,58402412322,58402412323,58402420320,58402420322,58402420323,58402420331,58402420332,58402420333,58402421031,58402421033,58402421101,58402421103,58402421211,58402421213,58402421220,58402421222,58402421223,58402431000,58402431002,58402431120,58402431122,58402431131,58402431133,58402521020,58402521022,58402521320,58402521322,58402521323,58402521332,58402523110,58402523112,58402523113,58402532202,58402532203,58402532232,58402532233,58402532322,58402532323,58402532332,58403310231,58403310233,58403312011,58403312013,58403312031,58403312033,58403312211,58403312213,58403312231,58403312233,58403322022,58403322023,58403322032,58403322033,58403322122,58403322123,58403322132,58403322133,58403323012,58403323013,58403323022,58403323023,58403323112,58403323113,58403323122,58403323123,58403330011,58403330013,58403330031,58403330033,58403330201,58403330203,58403330221,58403330222,58403330223,58403511000,58403511002,58403513102,58403513120,58403513122,58403513123,58403513132,58403513133,58403602202,58403602203,58403602212,58403602213,58403602302,58403602303,58403602320,58403602322,58403620100,58403620102,58403620120,58403620122,58403620123,58403620230,58403620231,58403620232,58403620300,58403620302,58403620320,58403622010,58403622012,58403622030,58403622032,58403622210,58403622212,58403622230,58403622232,58404210333,58404211101,58404211103,58404211121,58404211123,58404211222,58404211223,58404211232,58404211233,58404211301,58404211302,58404211303,58404212102,58404212103,58404212111,58404212112,58404212113,58404212120,58404212121,58404212130,58404212131,58404212133,58404212311,58404212313,58404230331,58404233000,58404233001,58404600010,58404600012,58404600013,58404600102,58404600120,58404600122,58404600123,58404600132,58404600133,58404603000,58404603002,58404603030,58404603032,58404603210,58404603212,58404603230,58404603232,58404621010,58404621012,58404621013,58404621122,58404621123,58404621300,58404621301,58404622220,58404622222,58404623030,58404623032,58405211022,58405211023,58405212203,58405212221,58405212222,58405212223,58405221321,58405221323,58405223011,58405223012,58405223013,58405531110,58405531111,58405531112,58405531130,58405531132,58405531310,58405531312,58405600000,58405600002,58405600020,58405600022,58405600200,58405600202,58405602000,58405602001,58405602002,58405602020,58405602022,58405602200,58405602202,58405602203,58405602212,58405602230,58405602232,58405620000,58405620001,58405620220,58405620222,58405622012,58405622030,58405622032,58405622210,58405622212,58405622213,58405622302,58405622320,58405622322,58406113132,58406113133,58406113303,58406113321,58406113323,58406131101,58406131103,58406131121,58406131123,58406131130,58406131131,58406131132,58406131211,58406131300,58406131301,58406131310,58406200121,58406200123,58406200301,58406200303,58406201000,58406201002,58406201003,58406202013,58406202022,58406202023,58406202031,58406202032,58406202033,58406220020,58406220021,58406220023,58406220201,58406220210,58406220211,58406220213,58406222111,58406222113,58406223031,58406223033,58406233211,58406233213,58406233231,58406233233,58406600100,58406600102,58406600103,58406600112,58406600113,58406601002,58406601030,58406601032,58406601220,58406601221,58406601230,58406601231,58406601300,58406601301,58406602010,58406602012,58406602030,58406602032,58406602210,58406602212,58406602230,58406602232,58406620010,58406620012,58406620030,58406620032,58406620300,58406620302,58406621222,58406622210,58406622211,58406622212,58406622220,58406622221,58406622222,58406622230,58406622300,58406623000,58406623002,58407210311,58407210313,58407213230,58407213231,58407213320,58407213321,58407213323,58407231101,58407231103,58407231121,58407231123,58407231213,58407231231,58407231232,58407231233,58407231301,58407231302,58407231303,58407232331,58407232333,58407511120,58407511121,58407511130,58407511131,58407511200,58407511201,58407511202,58407511210,58407511211,58407512132,58407512133,58407512310,58407512311,58407512320,58407512321,58407512322,58407530000,58407530001,58407530002,58407530010,58407530011,58407530020,58407530022,58407530100,58407530200,58407530202,58407530203,58407530220,58407530222,58407532000,58407532002,58407532020,58407532022,58407532023,58407532320,58407600000,58407600002,58407600020,59400201332,59400201333,59400202311,59400203002,59400203003,59400203012,59400203013,59400203102,59400203103,59400203200,59400203201,59400203210,59400203211,59400203300,59400203301,59400203310,59400203311,59400210111,59400210113,59400210131,59400210133,59400210222,59400210223,59400210232,59400210233,59400212220,59400212221,59400221323,59400221332,59400221333,59400230010,59400230011,59400230212,59400230213,59400230222,59400230223,59400232200,59400232201,59400232203,59400232221,59400232223,59400501130,59400501131,59400501132,59400501310,59400501312,59400501330,59400501332,59400501333,59400510010,59400510011,59400510020,59400510021,59400510222,59400520310,59400520312,59400520330,59400520332,59400520333,59400521000,59400521001,59400521002,59400521010,59400521011,59400521100,59400521101,59400523020,59401200313,59401201013,59401201022,59401201023,59401201031,59401201032,59401201033,59401201102,59401201103,59401201112,59401201113,59401202113,59401202131,59401203020,59401203021,59401203230,59401203231,59401203233,59401221011,59401221012,59401221013,59401221202,59401221203,59401222111,59401222331,59401222333,59401501102,59401501103,59401501112,59401501130,59401501132,59401501310,59401501312,59401501330,59401501332,59401503100,59401503101,59401521110,59401521112,59401521113,59401530002,59401530020,59401530022,59401530023,59401530212,59401530213,59401530302,59401530320,59401530322,59401530323,59401532110,59401532111,59402131112,59402131113,59402131310,59402131311,59402200111,59402200113,59402200123,59402200131,59402200132,59402200133,59402200213,59402200223,59402200231,59402200232,59402200233,59402200301,59402200302,59402200303,59402202001,59402202003,59402202021,59402202023,59402202201,59402202203,59402202221,59402202223,59402220001,59402220002,59402220003,59402222000,59402222001,59402222003,59402222021,59402222030,59402222031,59402510112,59402510113,59402511002,59402511202,59402511220,59402511222,59402531010,59402531012,59402531020,59402531022,59402531200,59402531202,59402531220,59402531222,59402533010,59402533012,59402533130,59402533132,59402622200,59402622202,59402622203,59402622232,59403200121,59403200123,59403200311,59403200313,59403200331,59403200333,59403202111,59403203020,59403203021,59403203231,59403203233,59403220331,59403220333,59403221011,59403221013,59403221031,59403221033,59403221211,59403221213,59403221320,59403221321,59403221330,59403221331,59403222111,59403223000,59403223001,59403223010,59403223011,59403230220,59403230221,59403230223,59403232001,59403232003,59403232021,59403232023,59403232201,59403232203,59403232221,59403232223,59403600010,59403600012,59403600030,59403600032,59403600033,59403600122,59403600123,59403603332,59403621110,59403621112,59403621130,59403621132,59403621310,59403621312,59404210100,59404210101,59404210103,59404210110,59404210111,59404210121,59404211000,59404211001,59404211210,59404211211,59404211213,59404211231,59404211320,59404211321,59404213110,59404213111,59404302000,59404302001,59404302010,59404302011,59404302131,59404302133,59404303231,59404303233,59404303320,59404303322,59404312301,59404312303,59404313221,59404313223,59404331100,59404331101,59404331110,59404331111,59404331113,59404331131,59404420020,59404420021,59404420210,59404420211,59404420320,59404420321,59404420323,59404422101,59404422103,59404422121,59404422123,59404603110,59404603111,59404603112,59404603130,59404603132,59404603230,59404603232,59404603310,59404603312,59404610220,59404610221,59404620330,59404620331,59404621000,59404621001,59404621002,59404621010,59404621020,59404621022,59404621200,59404622132,59404622133,59404623022,59404623023,59404623032,59404623210,59404623212,59404623213,59404623302,59404623303,59405313133,59405313311,59405313313,59405313331,59405313332,59405313333,59405331110,59405331111,59405331113,59405331131,59405400101,59405400103,59405400121,59405400123,59405402003,59405402012,59405402013,59405402021,59405402022,59405402023,59405420020,59405420021,59405420030,59405420031,59405420300,59405420301,59405422321,59405422323,59405612012,59405612030,59405612032,59405612033,59405612122,59405612300,59405612302,59405612303,59405612332,59405612333,59405623010,59405623012,59405623020,59405623022,59405630120,59405630121,59405630122,59405630130,59405630131,59405630210,59405630211,59405630300,59405631000,59406400101,59406400103,59406400121,59406400130,59406400131,59406401020,59406401021,59406401023,59406401201,59406401203,59406401231,59406401233,59406403320,59406403321,59406421110,59406421111,59406430000,59406430001,59406430003,59406430021,59406430030,59406430031,59406430033,59406430120,59406430121,59406430122,59406430130,59406430131,59406431000,59406431001,59406431010,59406431011,59406431100,59406431101,59406431110,59406431111,59406520020,59406520021,59406520211,59406520213,59406520321,59406520323,59406522101,59406522103,59406522121,59406522123,59406522301,59406522303,59406522321,59406522323,59406601000,59406601002,59406601020,59406601022,59406601200,59406601202,59406603220,59406603222,59406613330,59406613332,59406621010,59406621012,59406630111,59406630113,59406630131,59406630133,59406631310,59406631312,59406631320,59406631322,59406633100,59406633102,59406633120,59406633122,59406633230,59406633231,59406633232,59406633300,59407500101,59407500103,59407500121,59407500123,59407501201,59407501203,59407503120,59407503121,59407503123,59407503301,59407503310,59407503311,59407521111,59407530000,59407530001,59407530010,59407530011,59407530013,59407530121,59407530123,59407530301,59407530303,59407530321,59407530323,59407531130,59407531132,59407531310,59407531312,59407531330,59407531332,59407531333,59407532111,59407533000,59407533001,59407533003,59407533021,59407533023,59407533110,59407533111,59407533201,59407533210,59407533211,59407533300,59407533301,59407602230,59407602231,59407602320,59407602321,59407602330,59407602331,59407603220,59407603221,59407611010,59407611012,59407611030,59407611032,59407611210,59407611212,59407611230,59407611232,59407612330,59407612331,59407613010,59407613012,59407613030,59407613032,59407613200,59407613201,59407613202,59407613210,59407613220,59407620222,59407621010,59407621011,59407621100,59407621101,59407621103,59407622000,59407630010,59407630011,59407630012,59407630100,59407630101,
016,00,ʡ,504815625,135000000,506685937,136725000,7,18,46,81,136,348,564033,564034,564042,564043,564044,564053,564054,5640233,5640240,5640242,5640243,5640252,5640323,5640521,5640523,5640550,5640552,5640621,5640623,5640630,5640631,5640632,5640640,5640641,5640650,56402233,56402313,56402321,56402322,56402323,56402410,56402412,56402413,56402502,56402503,56403203,56403211,56403212,56403213,56403223,56403500,56403501,56403502,56403520,56403522,56404500,56404502,56404520,56404522,56405201,56405203,56405223,56406201,56406203,56406221,56406223,56406330,56406331,56406332,56406420,56406421,56406430,56406431,56406520,56407201,56407203,56407210,56407211,56407300,56407301,56407310,564025302,564025320,564025322,564025323,564032211,564032212,564032213,564032223,564035030,564035031,564035032,564035100,564035101,564035102,564035110,564035210,564035212,564035230,564035232,564041113,564041131,564041133,564041311,564041313,564041333,564045010,564045032,564045210,564045212,564045230,564045232,564045233,564045322,564052000,564052001,564052003,564052021,564052211,564052213,564052223,564055100,564055101,564055110,564062001,564062003,564062021,564062023,564062201,564062203,564062221,564062223,564063330,564064220,564064221,564064230,564064231,564064320,564064321,564064322,564064330,564064331,564065210,564065211,564065212,564072120,564072121,564072122,564072130,564072131,564072201,564072210,564072211,564073020,564073021,564073023,564073030,564073031,564073032,564073120,564073121,564073201,5640251222,5640253000,5640253002,5640253212,5640253213,5640253320,5640253322,5640322101,5640322102,5640322103,5640322223,5640350330,5640350331,5640350332,5640351030,5640351031,5640351032,5640351120,5640351200,5640351202,5640351220,5640411103,5640411112,5640411113,5640411121,5640411123,5640411323,5640413101,5640413103,5640413121,5640413123,5640413311,5640413313,5640450120,5640450122,5640450300,5640450302,5640450303,5640452130,5640452132,5640452310,5640452312,5640452313,5640453230,5640453232,5640511111,5640520021,5640520023,5640520231,5640522100,5640522101,5640522103,5640522121,5640522123,5640522212,5640522213,5640551020,5640551021,5640551022,5640551110,5640551112,5640551121,5640551130,5640551200,5640551222,5640553000,5640553002,5640553003,5640553020,5640553022,5640553200,5640553202,5640553220,5640633310,5640633311,5640633312,5640633320,5640633322,5640643230,5640643330,5640643331,5640651000,5640651002,5640651020,5640651022,5640651200,5640651202,5640651220,5640652130,5640652131,5640652200,5640652201,5640652202,5640652210,5640652211,5640652300,5640652301,5640653000,5640653002,5640653020,5640720011,5640720013,5640720213,5640720231,5640720233,5640721230,5640721231,5640721232,5640721320,5640721321,5640721323,5640721330,5640721331,5640721332,5640722031,5640722120,5640722121,5640722122,5640723000,5640730220,5640730221,5640730330,5640730331,5640730332,5640731100,5640731102,5640731220,5640731221,5640731300,5640731302,5640732030,5640732031,5640732100,5640732101,5640732102,5640732120,56402512202,56402512203,56402530012,56402530030,56402530032,56402530300,56402530302,56402530320,56402530322,56402532100,56402532102,56402533020,56402533022,56402533232,56402533233,56403202333,56403220113,56403220131,56403220133,56403220311,56403220313,56403220331,56403220333,56403221001,56403221002,56403221003,56403222111,56403222113,56403222122,56403222123,56403222131,56403222132,56403222133,56403222212,56403222213,56403222222,56403222223,56403503330,56403503332,56403510330,56403510331,56403510332,56403511210,56403511211,56403511220,56403511221,56403512010,56403512011,56403512012,56403512030,56403512100,56403512101,56403512110,56403521100,56403521102,56403521120,56403521122,56403521300,56403521302,56403521320,56403521322,56403523100,56403523102,56403523120,56403523122,56404111103,56404111112,56404111113,56404113010,56404113011,56404113212,56404113213,56404133010,56404133011,56404133100,56404133101,56404133103,56404133121,56404133122,56404133123,56404501102,56404501120,56404501210,56404501211,56404503012,56404503013,56404503322,56404521100,56404521102,56404521120,56404521122,56404521310,56404521312,56404521330,56404521332,56404523110,56404523112,56404523113,56404532022,56404532023,56404532032,56404532033,56404532122,56404532123,56404532312,56404532330,56404532332,56404532333,56404533222,56404533223,56404533232,56404533233,56404533322,56405111101,56405111103,56405111121,56405111130,56405111131,56405111133,56405111311,56405200200,56405200201,56405202011,56405202013,56405202031,56405202033,56405202330,56405202331,56405202333,56405220111,56405220113,56405220131,56405220333,56405221020,56405221021,56405221203,56405221221,56405221222,56405221223,56405222033,56405222102,56405222103,56405222111,56405222112,56405222113,56405222211,56405222213,56405222231,56405222233,56405510230,56405510231,56405510300,56405510301,56405510302,56405510310,56405510311,56405510320,56405511110,56405511112,56405511130,56405511132,56405511200,56405511201,56405511203,56405511221,56405511230,56405511231,56405511310,56405511312,56405511320,56405511321,56405511330,56405512202,56405512203,56405512230,56405512232,56405530010,56405530012,56405530120,56405530122,56405530210,56405530211,56405530212,56405530230,56405530232,56405530300,56405532220,56405532221,56406200011,56406200013,56406200031,56406200033,56406200211,56406200213,56406200231,56406200233,56406202011,56406202013,56406202031,56406202033,56406202231,56406202233,56406220011,56406220013,56406220031,56406220033,56406220233,56406222011,56406222013,56406222031,56406222033,56406222211,56406222213,56406222231,56406333210,56406333211,56406333212,56406333230,56406333232,56406422300,56406422301,56406422310,56406422311,56406423200,56406423201,56406423210,56406423211,56406423300,56406423301,56406423310,56406423311,56406432310,56406432311,56406432320,56406432321,56406432322,56406433200,56406433201,56406433210,56406433211,56406433320,56406433321,56406433330,56406433331,56406510210,56406510212,56406510230,56406510232,56406512010,56406512012,56406512030,56406512032,56406512220,56406512221,56406521320,56406521322,56406530010,56406530012,56406530030,56406530032,56406530210,56406530212,56407200100,56407200101,56407200311,56407200313,56407200331,56407200333,56407202111,56407202112,56407202113,56407212330,56407212331,56407212332,56407213220,56407213221,56407213330,56407213331,56407213332,56407220331,56407220333,56407221300,56407221302,56407230010,56407230011,56407230100,56407230101,56407230110,56407231010,56407231011,56407231100,56407231101,56407231110,56407302220,56407302221,56407302230,56407302231,56407302233,56407303330,56407303331,56407311010,56407311012,56407311030,56407311032,56407311200,56407311202,56407311220,56407311222,56407311223,56407311232,56407312220,56407312221,56407312230,56407312231,56407312300,56407312301,56407312302,56407312310,56407312311,56407312320,56407313010,56407313012,56407313013,56407313030,56407313031,56407313032,56407313200,56407313201,56407313210,56407320011,56407320013,56407320031,56407320033,56407321030,56407321032,56407321100,56407321101,56407321210,56407321212,56407410000,56407410001,56407410003,56407410010,56407410011,56407410012,56407410021,56407410030,56407410100,
016,01,,503803125,132431250,507121875,135440625,21,38,69,131,299,540,554023,554033,554042,554043,554052,554053,554060,554061,554062,554063,554071,554072,554073,554074,564001,564002,564003,564004,564012,564013,564014,5540242,5540321,5540322,5540323,5540340,5540342,5540440,5540442,5540443,5540503,5540511,5540512,5540513,5540540,5540541,5540542,5540640,5540642,5540643,5540700,5540701,5540703,5540750,5540752,5640001,5640003,5640050,5640052,5640110,5640150,5640151,5640152,5640160,5640211,5640220,5640221,5640222,5640230,55395733,55396711,55396731,55396733,55397711,55401332,55402233,55402400,55402402,55402403,55402430,55403202,55403203,55403412,55404113,55404131,55404132,55404133,55404410,55404412,55404413,55405022,55405023,55405101,55405102,55405103,55405430,55405431,55405432,55405500,55405502,55406410,55406412,55406520,55406522,55406523,55407020,55407021,55407023,55407532,56400532,56400621,56400622,56400623,56400630,56400632,56401011,56401013,56401110,56401111,56401113,56401131,56401133,56401530,56401531,56401610,56401612,56402230,56402231,56402232,56402310,56402311,56402312,56402320,56402411,56402500,56402501,56403201,56403210,553957313,553967131,553967133,553967301,553967303,553967321,553977131,553977133,554013232,554013233,554013301,554013303,554013310,554013312,554013330,554013332,554013333,554014222,554022303,554022312,554022313,554022321,554022322,554022323,554024120,554024122,554024123,554024320,554032003,554032012,554032013,554034102,554034300,554034322,554034323,554041121,554041123,554041231,554041233,554041301,554041302,554041303,554044110,554044112,554044113,554045202,554045220,554045222,554045223,554050133,554050202,554050203,554050211,554050212,554050213,554051003,554054330,554054332,554055010,554055200,554055202,554064110,554064112,554064130,554064132,554065212,554070221,554075122,564000011,564000013,564000033,564000211,564000213,564000231,564005100,564005101,564005102,564005120,564005122,564005300,564005302,564005303,564005330,564005332,564005333,564006132,564006203,564006310,564006312,564006330,564006332,564010100,564010101,564010103,564010121,564010310,564010311,564011120,564011121,564011123,564011200,564011301,564011303,564011321,564011322,564011323,564015320,564015321,564015322,564015330,564015331,564016110,564016112,564016200,564016201,564016202,564016210,564016211,564016300,564021031,564021300,564021301,564021310,564021311,564021313,564025100,564025102,564032000,564032001,564032003,564032021,5539573122,5539573123,5539573211,5539573213,5539573233,5539671011,5539671013,5539671233,5539671300,5539671301,5539671303,5539671321,5539671322,5539671323,5539673003,5539673021,5539673023,5539673231,5539771300,5539771301,5539771303,5539773111,5539773113,5539773131,5540131233,5540131322,5540132223,5540132232,5540132233,5540132303,5540132311,5540132312,5540132313,5540133023,5540133112,5540133130,5540133132,5540133310,5540133312,5540133313,5540142200,5540142202,5540142203,5540142212,5540142230,5540142232,5540142233,5540221133,5540221311,5540221313,5540221331,5540221333,5540223013,5540223102,5540223103,5540223111,5540223112,5540223113,5540223201,5540223203,5540240120,5540240122,5540240123,5540241212,5540241213,5540241322,5540243100,5540243210,5540243212,5540243220,5540243221,5540243222,5540311311,5540311313,5540311331,5540313313,5540313331,5540313333,5540320022,5540320023,5540320111,5540320112,5540320113,5540341000,5540341002,5540341032,5540343010,5540343011,5540343012,5540343020,5540343021,5540343022,5540343030,5540343200,5540343202,5540343203,5540343212,5540343322,5540411031,5540411032,5540411033,5540411120,5540411122,5540411123,5540411132,5540411133,5540411203,5540411221,5540412321,5540412322,5540412323,5540413003,5540450022,5540450200,5540450202,5540450220,5540450222,5540452000,5540452002,5540452030,5540452032,5540452210,5540452212,5540452213,5540452302,5540452320,5540452322,5540501222,5540501223,5540501232,5540501233,5540501311,5540501312,5540501313,5540501321,5540501322,5540501323,5540502012,5540502013,5540502102,5540502103,5540510011,5540510013,5540510022,5540510023,5540543310,5540543311,5540543312,5540543330,5540543332,5540550120,5540550121,5540550122,5540550300,5540550302,5540550320,5540552010,5540552012,5540552200,5540552201,5540552203,5540641331,5540641332,5540641333,5540650222,5540650223,5540652132,5540652133,5540653202,5540653220,5540653222,5540702200,5540702201,5540702203,5540702230,5540702231,5540702233,5540751000,5540751002,5540751020,5540751022,5540751200,5540751202,5540753000,5540753001,5540753002,5540753020,5540753022,5540753023,5540753300,5540753302,5540753303,5540753320,5540753322,5640000011,5640000100,5640000101,5640000103,5640000310,5640000311,5640000313,5640002330,5640002331,5640002333,5640051030,5640051032,5640051210,5640051212,5640051232,5640053010,5640053012,5640053013,5640053133,5640053311,5640053312,5640053313,5640060323,5640061232,5640061233,5640062003,5640062011,5640062012,5640062013,5640062021,5640062022,5640062023,5640063112,5640063130,5640063132,5640063310,5640063312,5640063330,5640100111,5640101021,5640101023,5640101231,5640101233,5640103011,5640103013,5640103120,5640103121,5640112010,5640112011,5640112100,5640112101,5640113020,5640113021,5640113023,5640113201,5640113202,5640113203,5640153230,5640153231,5640153232,5640153320,5640153321,5640161300,5640161302,5640161320,5640161322,5640162030,5640162031,5640162032,5640162120,5640162121,5640162122,5640162130,5640162131,5640162200,5640162201,5640163010,5640163011,5640163012,5640163020,5640210131,5640210132,5640210133,5640210330,5640210331,5640213030,5640213031,5640213121,5640213123,5640213310,5640213311,5640213313,5640213331,5640213333,5640251030,5640251032,5640251200,5640251201,5640251202,5640251210,5640311111,5640311113,5640320020,5640320021,5640320231,55395730331,55395730333,55395732101,55395732103,55395732121,55395732123,55395732303,55395732311,55395732312,55395732313,55395732321,55395732323,55396710101,55396710103,55396710121,55396710123,55396710301,55396710310,55396710311,55396710313,55396710331,55396710333,55396712313,55396712321,55396712323,55396713021,55396713023,55396713201,55396713202,55396713203,55396732301,55396732303,55396732331,55396732333,55397710111,55397710131,55397710133,55397710311,55397710313,55397710331,55397710333,55397712111,55397712113,55397713021,55397713023,55397713201,55397713210,55397713211,55397713213,55397713231,55397731100,55397731101,55397731331,55397731333,55397733111,55397733113,55401313230,55401313232,55401321332,55401321333,55401322221,55401322223,55401322311,55401322313,55401323013,55401323102,55401323103,55401330033,55401330203,55401330211,55401330212,55401330213,55401330221,55401330222,55401330223,55401331132,55401331310,55401331312,55401331330,55401331332,55401333110,55401333112,55401333113,55401420222,55401420223,55401422012,55401422013,55401422102,55402211312,55402211313,55402213323,55402223323,55402223331,55402223332,55402223333,55402230033,55402230112,55402230113,55402230122,55402230123,55402230211,55402230213,55402230231,55402230233,55402231002,55402231003,55402231012,55402231013,55402231101,55402231102,55402231103,55402232001,55402232003,55402232021,55402232023,55402401000,55402401002,55402401020,55402401022,55402401023,55402401032,55402401210,55402401212,55402401213,55402401322,55402401323,55402401332,55402412100,55402412102,55402413200,55402413202,55402413230,55402413232,55402431010,55402431012,55402431020,55402431022,55402432230,55402432231,55402432232,55402432300,55402432301,55402432302,55402432320,55403111331,55403111333,55403113101,55403113103,55403113121,55403113123,55403113301,55403113303,55403113331,55403113333,55403131113,55403131131,55403131133,55403131311,55403131313,55403131331,55403131333,55403133111,55403133121,55403133123,55403133301,55403133303,55403133321,55403133323,55403200033,55403200122,55403200123,55403200132,55403200133,55403200211,55403200212,55403200213,55403201022,55403201023,55403201032,55403201033,55403201101,55403201102,55403201103,55403410010,55403410012,55403410030,55403410032,55403410033,55403410122,55403410300,55403410302,55403430230,55403430231,55403430232,55403430320,55403432010,55403432012,55403433202,55403433203,55403433212,55403433230,55403433232,55403433233,55404110231,55404110233,55404111111,55404111113,55404111131,55404111133,55404111210,55404111212,55404111311,55404111313,55404112011,55404112013,55404112231,55404112233,55404122332,55404122333,55404123023,55404123031,55404123032,55404123033,55404123201,55404123202,55404123203,55404130011,55404130012,55404130013,55404130022,55404130023,55404411122,55404411123,55404411132,55404411133,55404502232,55404520010,55404520012,55404520030,55404520032,55404520033,55404520122,55404520123,55404523232,55404523233,55405003313,55405003331,55405003332,55405003333,55405012202,55405012203,55405012212,55405012213,55405012302,55405012303,55405012312,55405012313,55405013023,55405013032,55405013033,55405013102,55405013103,55405013201,55405013202,55405013203,55405100121,55405100123,55405100211,55405100213,55405433130,55405433132,55405433310,55405433312,55405433330,55405433332,55405501230,55405501231,55405520300,55405520301,55405520302,55405520320,55405520322,55405522021,55405522023,55405522100,55405522102,55405522120,55405522122,55406411100,55406411102,55406411120,55406411300,55406411302,55406411320,55406411322,55406413100,55406413102,55406413120,55406413122,55406413132,55406413133,55406413300,55406413302,55406413303,55406502202,55406502203,55406502320,55406502322,55406521020,55406521022,55406521300,55406521302,55406532002,55406532003,55407022021,55407022023,55407022320,55407022321,55407022323,55407510232,55407512010,55407512012,55407512030,55407512032,55407512300,55407512302,55407512320,55407512322,55407530030,55407530031,55407530032,55407530100,55407530102,55407530120,55407530210,55407530212,55407530213,55407530302,55407530320,55407530322,55407530323,55407530332,55407530333,55407531222,55407531223,55407533012,55407533013,56400000101,56400000103,56400000121,56400000130,56400000131,56400001020,56400001021,56400001023,56400001211,56400001213,56400001231,56400001233,56400003120,56400003121,56400023320,56400023321,56400510310,56400510312,56400511000,56400511001,56400511002,56400511020,56400511022,56400512112,56400512130,56400512132,56400512300,56400512301,56400512302,56400512310,56400512330,56400512332,56400530110,56400530112,56400530113,56400531002,56400531020,56400531022,56400531200,56400531202,56400531220,56400531222,56400531223,56400531232,56400531233,56400531312,56400531313,56400533102,56400533103,56400603221,56400603223,56400603320,56400603322,56400612231,56400612233,56400613320,56400613322,56400620012,56400620013,56400620023,56400620102,56400620103,56400620201,56400620202,56400620203,56400631100,56400631102,56400631103,56400633320,56400633321,56400633322,56401001131,56401001133,56401010201,56401010203,56401012010,56401012011,56401012013,56401012031,56401012033,56401012211,56401012300,56401012301,56401012303,56401012321,56401012323,56401112200,56401112201,56401112210,56401112211,56401112213,56401112231,56401112233,56401123311,56401123313,56401123331,56401130011,56401130013,56401130022,56401130023,56401130031,56401130032,56401130033,56401532330,56401532331,56401532332,56401533220,56401533221,56401533230,56401533231,56401533300,56401533301,56401533310,56401533311,56401611100,56401611102,56401613010,56401613011,56401620330,56401620332,56401622020,56401622021,56401622030,56401622031,56401622100,56401622101,56401630130,56401630132,56401630210,56401630212,56401631000,56401631002,56402101123,56402101132,56402101133,56402101231,56402101233,56402101301,56402101302,56402101303,56402103011,56402103013,56402103031,56402103331,56402103333,56402130200,56402130201,56402130210,56402130211,56402130213,56402130231,56402130320,56402130321,56402130330,56402130331,56402131200,56402131201,56402133010,56402133011,56402133120,56402133121,56402133123,56402133301,56402133303,56402133321,56402133323,56402510100,56402510102,56402510120,56402510122,56402510123,56402512030,56402512031,56402512032,56402512120,56402512121,56402512200,56402512201,56402512210,56403111101,56403111103,56403111121,56403111123,56403111301,56403111310,56403111311,56403200220,56403200221,56403200230,56403200231,56403200233,56403202011,56403202331,
017,00,ż㾾/¿,500990625,133059375,505026562,136275000,31,36,81,181,382,743,553954,553955,553963,553964,553965,553966,553972,553973,553974,553975,553976,563902,563903,563904,563905,563906,563907,563914,563915,563916,563917,563925,563926,563927,563935,563936,563937,563946,563947,564020,564030,5539433,5539440,5539442,5539443,5539531,5539532,5539533,5539562,5539613,5539621,5539622,5539623,5539670,5539672,5539770,5539772,5639121,5639130,5639131,5639133,5639341,5639450,5639451,5639453,5639560,5639561,5639570,5640102,5640212,5640310,5640312,5640313,5640400,5640401,5640402,5640410,55393333,55393422,55394311,55394312,55394313,55394323,55394412,55394413,55394520,55394522,55394523,55394532,55394533,55395231,55395233,55395301,55395303,55395600,55395602,55395603,55395630,55395632,55395633,55395722,55395723,55396201,55396203,55397111,55397113,55397131,55397133,55397730,55397732,56390133,56391111,56391200,56391201,56391321,56392411,56392413,56392431,56392433,56393430,56393431,56393433,56394521,56395510,56395511,56395513,56395620,56395631,56395710,56395712,56395720,56395721,56395730,56400002,56400020,56400022,56401000,56401002,56401003,56401032,56401033,56401122,56402100,56402102,56402132,56403110,56403112,56403113,56404030,56404031,56404032,56404110,56404112,56404120,56404121,56404123,56404130,56404132,553933303,553933312,553933313,553933321,553933323,553934202,553934230,553934232,553934233,553943033,553943101,553943102,553943103,553943211,553943213,553943223,553944100,553944102,553944103,553944112,553944113,553945022,553945023,553945210,553945212,553945213,553945302,553946222,553952132,553952133,553952232,553953001,553953003,553953021,553953022,553953023,553956011,553956012,553956013,553956312,553957322,553961123,553961131,553961133,553961213,553961231,553961233,553962001,553962003,553962021,553962022,553962023,553967100,553967102,553967120,553967121,553967122,553967320,553967322,553971100,553971101,553971103,553971121,553977100,553977102,553977120,553977122,553977123,553977310,553977312,553977330,553977332,553977333,554070222,563901111,563901113,563901131,563901133,563901311,563901312,563901313,563901323,563911130,563912020,563912021,563912030,563912031,563912033,563912311,563913230,563913231,563913233,563923011,563923100,563923101,563923111,563924000,563924001,563924010,563924011,563924101,563924121,563924123,563924301,563924303,563924321,563924323,563934031,563934033,563934321,563944111,563945201,563945203,563945230,563945231,563945233,563955011,563955120,563955121,563955123,563955310,563955311,563955313,563956210,563956211,563956212,563956220,563956221,563956230,563956300,563956301,563956303,563956330,563956331,563957110,563957111,563957112,563957231,563965103,564000000,564000002,564000003,564000030,564000032,564000210,564000212,564000230,564000232,564010010,564010012,564010013,564010300,564010302,564010303,564010313,564011202,564011203,564011211,564011212,564011213,564011230,564011231,564011232,564021010,564021032,564021332,564031110,564031112,564032022,564032200,564032202,564032220,564040330,564041221,564041332,564050000,564050001,564050010,564050011,564050013,564050031,5539333022,5539333023,5539333113,5539333200,5539333201,5539333203,5539333221,5539333223,5539342002,5539342032,5539342033,5539342122,5539342312,5539342313,5539343220,5539343222,5539343223,5539430312,5539430313,5539431001,5539431003,5539432211,5539432213,5539432223,5539441010,5539441012,5539450200,5539450202,5539450203,5539450212,5539450320,5539450322,5539450323,5539452110,5539452112,5539453030,5539453032,5539453033,5539462200,5539462202,5539462203,5539462230,5539462232,5539462233,5539521233,5539521312,5539521313,5539522332,5539522333,5539523011,5539523013,5539523031,5539523033,5539523211,5539523213,5539523222,5539523231,5539530001,5539530003,5539530021,5539530201,5539530203,5539560102,5539560103,5539561000,5539561001,5539561002,5539561020,5539561022,5539561023,5539561200,5539561201,5539561202,5539561220,5539561222,5539561223,5539561232,5539563102,5539563103,5539563112,5539563130,5539563132,5539563133,5539572022,5539572023,5539572122,5539572123,5539573200,5539573202,5539573203,5539611132,5539611201,5539611203,5539611210,5539611212,5539611213,5539611221,5539611222,5539611223,5539611303,5539611321,5539611322,5539611323,5539612111,5539612113,5539612301,5539612303,5539612321,5539620003,5539620021,5539620023,5539620201,5539620202,5539620203,5539671032,5539671230,5539673000,5539673001,5539673002,5539673020,5539673022,5539673232,5539710111,5539710113,5539711020,5539711021,5539711023,5539711201,5539711203,5539771010,5539771012,5539771030,5539771032,5539771210,5539771212,5539771213,5539771322,5539773112,5539773130,5539773132,5539773310,5539773312,5539773313,5639011100,5639011101,5639011103,5639013031,5639013033,5639013203,5639013211,5639013212,5639013213,5639013221,5639111011,5639111013,5639111031,5639111033,5639111310,5639111311,5639111313,5639120220,5639120320,5639120321,5639123001,5639123010,5639123100,5639123101,5639123103,5639132000,5639132001,5639132010,5639132011,5639132320,5639132321,5639132323,5639230101,5639230103,5639230131,5639231020,5639231021,5639231030,5639231031,5639231100,5639231101,5639231102,5639240020,5639240031,5639240120,5639241000,5639241001,5639241030,5639241031,5639241033,5639241221,5639241223,5639243000,5639243001,5639243003,5639243021,5639243023,5639243201,5639243203,5639243221,5639243222,5639243223,5639340131,5639340132,5639340133,5639342110,5639342111,5639342113,5639342131,5639342132,5639342133,5639342311,5639343200,5639343201,5639343203,5639343230,5639343231,5639343233,5639441101,5639441103,5639441130,5639441131,5639441133,5639452001,5639452003,5639452211,5639452321,5639452323,5639550101,5639550103,5639550130,5639550131,5639550133,5639550311,5639550313,5639551221,5639553010,5639553011,5639553121,5639553123,5639553310,5639553311,5639553313,5639553323,5639553330,5639562130,5639562131,5639562132,5639562221,5639562230,5639562231,5639562310,5639562312,5639562320,5639562321,5639563020,5639563021,5639563023,5639563210,5639563211,5639563321,5639563330,5639571300,5639571301,5639571302,5639571320,5639572200,5639572300,5639572330,5639572331,5639573200,5639573201,5639573202,5639573210,5639573211,5639573220,5639650113,5639650131,5639651002,5639651020,5639651021,5639651100,5639651102,5639651120,5639651122,5640000120,5640000122,5640100110,5640100112,5640101022,5640101200,5640101202,5640101220,5640101222,5640101223,5640103010,5640103012,5640103122,5640103123,5640111222,5640112012,5640112013,5640112102,5640112103,5640112330,5640112332,5640113000,5640113022,5640113200,5640210110,5640210111,5640210120,5640210121,5640210122,5640210300,5640210302,5640210332,5640213022,5640213122,5640213300,5640213302,5640213303,5640311132,5640311133,5640320200,5640320202,5640320203,5640320230,5640320232,5640322010,5640322012,5640322030,5640322032,5640322210,5640322220,5640403310,5640403311,5640403312,5640403320,5640403321,5640403322,5640411100,5640411101,5640411102,5640411120,5640411122,5640411300,5640411302,5640411303,5640411320,5640411322,5640412200,5640412201,5640412203,5640412230,5640412231,5640412233,5640413100,5640413102,5640413120,5640413122,5640413300,5640413302,5640413303,5640500031,5640500120,5640500121,5640500123,5640501000,5640501001,5640501002,5640501010,5640501011,5640501020,5640501022,5640510100,5640510101,5640510110,5640510111,55393330033,55393330103,55393330112,55393330121,55393330122,55393330123,55393330130,55393330132,55393330133,55393330211,55393330212,55393330213,55393331022,55393331023,55393331032,55393331033,55393331103,55393331112,55393331113,55393331121,55393331122,55393331123,55393332020,55393332021,55393420002,55393420003,55393420012,55393420030,55393420032,55393420033,55393420302,55393420303,55393420312,55393421230,55393421232,55393423100,55393423102,55393432210,55393432212,55393432213,55393432302,55393432320,55393432322,55393432323,55393432332,55394301331,55394301333,55394303033,55394303111,55394303113,55394303211,55394303213,55394303231,55394303233,55394321013,55394321031,55394321033,55394321211,55394321213,55394321231,55394321233,55394322033,55394322121,55394322122,55394322123,55394322211,55394322212,55394322213,55394410110,55394410112,55394410130,55394410132,55394410133,55394411022,55394411023,55394411032,55394411033,55394411122,55394411123,55394411132,55394411133,55394500200,55394500202,55394500220,55394500222,55394502130,55394502132,55394502133,55394503022,55394503023,55394503212,55394503213,55394503302,55394503320,55394503322,55394503323,55394521132,55394530310,55394530312,55394622120,55394622122,55394622123,55394622132,55394622310,55394622312,55394622313,55394623222,55394623233,55394623322,55394623323,55394623332,55394623333,55394632222,55394632223,55394632232,55394632233,55394632322,55395212312,55395212313,55395213013,55395213022,55395213023,55395213031,55395213032,55395213033,55395213102,55395213103,55395213112,55395213113,55395222313,55395222323,55395222331,55395222332,55395222333,55395223022,55395223023,55395223032,55395223033,55395223122,55395223300,55395223302,55395223303,55395223312,55395223313,55395230321,55395230323,55395232101,55395232103,55395232121,55395232123,55395232202,55395232203,55395232212,55395232230,55395232232,55395232233,55395232322,55395232323,55395232332,55395232333,55395300230,55395300231,55395300233,55395302001,55395302003,55395302021,55395302022,55395302023,55395601000,55395601002,55395601003,55395601011,55395601012,55395601013,55395610030,55395610032,55395610100,55395610102,55395610210,55395610212,55395610320,55395610322,55395612030,55395612032,55395612100,55395612102,55395612210,55395612212,55395612213,55395612302,55395612303,55395631000,55395631002,55395631310,55395631312,55395720320,55395720322,55395721320,55395721322,55395732010,55395732012,55395732013,55395732102,55395732120,55395732122,55395732300,55395732301,55395732302,55395732310,55395732320,55395732322,55396103331,55396103333,55396110232,55396110233,55396110322,55396110323,55396111231,55396111233,55396111330,55396111332,55396111333,55396112023,55396112112,55396112113,55396112201,55396112203,55396113002,55396113011,55396113012,55396113013,55396113020,55396113022,55396113200,55396113202,55396113203,55396121121,55396121123,55396121211,55396121213,55396121231,55396121232,55396121233,55396123231,55396123233,55396202002,55396202003,55396710100,55396710102,55396710120,55396710122,55396710300,55396710302,55396710303,55396710312,55396710330,55396710332,55396712310,55396712311,55396712312,55396712320,55396712322,55396713020,55396713022,55396713200,55396732300,55396732302,55396732330,55396732332,55397101011,55397101100,55397101101,55397101103,55397101121,55397101310,55397101311,55397101313,55397110221,55397110223,55397112001,55397112003,55397112300,55397112301,55397112310,55397112311,55397112313,55397112331,55397112333,55397130111,55397130113,55397130131,55397130133,55397130311,55397130313,55397130331,55397130333,55397710110,55397710112,55397710113,55397710130,55397710132,55397710310,55397710312,55397710330,55397710332,55397712110,55397712112,55397713020,55397713022,55397713200,55397713202,55397713203,55397713212,55397713230,55397713232,55397713233,55397731102,55397731103,55397731330,55397731332,55397733110,55397733112,55407022020,55407022022,55407022322,56390111020,56390111021,56390111211,56390111213,56390111231,56390111233,56390113011,56390113013,56390130123,56390130132,56390130133,56390130301,56390130303,56390130321,56390130323,56390131011,56390131013,56390131022,56390131023,56390131031,56390131032,56390131033,56390132101,56390132102,56390132103,56390132230,56390132231,56391110100,56391110101,56391110103,56391110121,56391110123,56391110301,56391110303,56391110321,56391110323,56391112111,56391112113,56391112131,56391113120,56391113121,56391113200,56391113201,56391113210,56391113211,56391113310,56391113311,56391113313,56391113331,56391202210,56391202211,56391202212,56391202220,56391202221,56391202230,56391202300,56391202301,56391202310,56391202311,56391202313,56391202331,56391203220,56391203221,56391203230,56391203231,56391231021,56391231023,56391323220,56391323221,56391323223,56392301001,56392301003,56392301021,56392301023,56392301301,56392301303,56392310231,56392310320,56392310321,56392310330,56392311200,56392311202,56392311311,56392311313,56392400210,56392400212,56392400301,56392400303,56392401210,56392401212,56392410031,56392410033,56392412031,56392412033,56392412222,56392412223,56392432202,56392432203,56393401301,56393401303,56393421120,56393421121,56393421123,56393421301,56393421303,56393423100,56393423101,56393423103,56393423121,56393423130,56393423131,56393432020,56393432021,56393432211,56393432213,56394411001,56394411003,56394411210,56394411211,56394411320,56394411321,56394411323,56394413101,56394413110,56394413111,56394413113,56394413131,56394413133,56394413311,56394413313,56394520000,56394520001,56394520003,56394520021,56394520023,56394520201,56394520210,56394520211,56394520213,56394520231,56394522100,56394522101,56394522131,56394522133,56394523201,56394523203,56394523221,56394523223,56395501001,56395501003,56395501021,56395501210,56395501211,56395501320,56395501321,56395501323,56395512201,56395512203,56395512231,56395530120,56395530121,56395530130,56395530131,56395530133,56395530311,56395531200,56395531201,56395531203,56395531221,56395531223,56395533011,56395533013,56395533033,56395533121,56395533122,56395533123,56395533211,56395533212,56395533213,56395533221,56395533223,56395533310,56395533312,56395533320,56395533321,56395621330,56395621332,56395622201,56395622203,56395622330,56395622331,56395623110,56395623112,56395623220,56395623221,56395623230,56395630221,56395630223,56395633310,56395633312,56395711300,56395711301,56395711302,56395711310,56395711311,56395711320,56395711322,56395713220,56395713221,56395713222,56395723010,56395723012,56395723330,56395723331,56395731000,56395731020,56395731022,56395731200,56395731202,56395732030,56395732032,56395732210,56395732212,56395732220,56395732221,56396510111,56396510113,56396510131,56396510133,56396510231,56396510233,56396511010,56396511011,56396511012,56396511030,56396511032,56396511210,56400000100,56400000102,56400000120,56400000122,56400000123,56400000132,56400000133,56400001022,56400001210,56400001212,56400001230,56400001232,56400003122,56400003123,56400023322,56400023323,56401001130,56401001132,56401010200,56401010202,56401012012,56401012030,56401012032,56401012210,56401012212,56401012213,56401012302,56401012320,56401012322,56401112202,56401112203,56401112212,56401112230,56401112232,56401123310,56401123312,56401123330,56401123332,56401123333,56401130010,56401130012,56401130020,56401130021,56401130030,56402101120,56402101121,56402101122,56402101130,56402101131,56402101230,56402101232,56402101300,56402103010,56402103012,56402103030,56402103032,56402103033,56402103330,56402103332,56402130202,56402130203,56402130212,56402130230,56402130232,56402130233,56402130322,56402130323,56402130332,56402130333,56402131202,56402131203,56402133012,56402133013,56402133122,56402133300,56402133302,56402133320,56402133322,56403111100,56403111102,56403111120,56403111122,56403111300,56403111302,56403111303,56403111312,56403111313,56403200222,56403200223,56403200232,56403202010,56403202012,56403202013,56403202330,56403202332,56403220110,56403220111,56403220112,56403220130,56403220132,56403220310,56403220312,56403220330,56403220332,56403221000,56403222110,56403222112,56403222120,56403222121,56403222130,56403222210,56403222211,56403222220,56403222221,56404033130,56404033132,56404111100,56404111101,56404111102,56404111110,56404111111,56404113012,56404113013,56404113210,56404113211,56404122211,56404122213,56404122321,56404122323,56404133012,56404133013,56404133102,56404133120,56405000200,56405000201,56405000210,56405000211,56405000300,56405000301,56405000303,56405000321,56405000330,56405000331,56405001220,56405001221,56405001223,56405003011,56405003013,56405010030,56405010031,56405010032,56405010120,56405010121,56405010130,56405010131,56405010210,56405010212,56405010230,56405011000,56405011001,56405011002,56405011020,56405100101,56405100110,56405100111,56405101020,56405101021,56405101030,56405101031,56405101120,56405101121,56405101130,56405101131,56405110000,56405110001,56405110002,56405110010,56405110011,56405110020,56405110100,56405110101,
018,00,來,506067187,132665625,507782812,136462500,16,17,76,139,347,747,554035,554036,554046,554056,554066,554067,554076,554077,564007,564017,564026,564027,564036,564037,564046,564047,5540372,5540451,5540453,5540470,5540472,5540551,5540553,5540570,5540572,5540573,5540651,5640353,5640451,5640561,5640570,5640572,5640670,55402522,55402523,55402531,55402532,55402533,55402620,55402622,55402623,55403413,55403431,55403702,55403703,55403730,55403732,55404501,55404503,55404521,55404710,55404712,55404730,55404732,55405521,55405523,55405710,55405712,55405713,55406500,55406501,55406503,55406530,55406531,55406533,55407511,55407513,55417020,55417022,56400513,56400600,56400601,56400602,56400610,56400611,56401623,56401632,56401633,56402511,56402513,56402531,56403513,56404530,56404531,56405600,56405601,56405603,56405710,56405711,56405712,56405730,56405732,56406720,56406721,56410000,56410002,56410020,56410022,56411000,56411002,56411020,56411022,56412000,56412002,56412020,56412022,56413000,56413002,56413020,554024331,554024333,554025132,554025133,554025301,554025302,554025303,554026022,554026023,554026030,554026032,554026210,554026212,554026322,554026323,554026332,554034111,554034112,554034113,554034330,554034331,554034333,554037002,554037122,554037332,554045000,554045001,554045003,554045021,554045023,554045231,554045233,554047110,554047330,554047332,554055011,554055013,554055031,554055033,554055222,554055223,554057110,554057112,554057113,554065020,554065021,554065211,554065321,554065323,554075101,554075103,554075121,554075310,554075311,554075313,554075331,554075333,554150202,554160200,554160202,554160220,554160221,554160222,554170000,554170002,554170020,554170022,554170023,564005111,564005112,564005113,564005311,564006030,564006031,564006120,564006121,564006130,564006131,564016113,564016131,564016133,564016222,564016223,564016303,564016311,564016312,564016313,564025123,564025301,564025331,564025333,564035111,564035113,564035123,564035233,564045013,564045031,564045330,564045331,564055121,564055123,564055130,564055131,564055132,564056020,564056021,564056023,564056210,564056311,564056313,564056331,564056333,564057130,564057131,564057132,564057310,564057312,564057330,564066111,564066113,564066131,564066133,564066311,564067100,564067102,564110010,564110212,564110230,564110232,564130220,564130222,564140000,564140002,564140020,564140022,564140200,564140202,564140220,564140222,5540243323,5540251231,5540251233,5540252123,5540252131,5540252132,5540252133,5540253003,5540260203,5540260210,5540260212,5540260213,5540262112,5540262130,5540262132,5540262133,5540263202,5540263203,5540263213,5540263302,5540263332,5540341101,5540341102,5540341103,5540343013,5540343031,5540343033,5540343210,5540343211,5540343213,5540370002,5540370003,5540370032,5540370033,5540370122,5540370123,5540370132,5540370133,5540371230,5540371232,5540373102,5540373120,5540373122,5540373300,5540373302,5540373303,5540373330,5540373332,5540441110,5540441111,5540450020,5540450021,5540450023,5540450201,5540450203,5540450221,5540452010,5540452011,5540452013,5540452031,5540452033,5540452211,5540452300,5540452301,5540452303,5540452321,5540471120,5540471122,5540471300,5540471302,5540471320,5540471322,5540473100,5540473102,5540473120,5540473122,5540473123,5540473332,5540550301,5540550303,5540550321,5540550322,5540550323,5540552011,5540552013,5540552031,5540552033,5540552211,5540552213,5540571110,5540571112,5540641111,5540641113,5540641131,5540641133,5540641311,5540650221,5540650230,5540650231,5540650233,5540652100,5540652101,5540652103,5540652131,5540653201,5540653203,5540653221,5540653223,5540751001,5540751003,5540751021,5540751231,5540751233,5540753011,5540753013,5540753031,5540753120,5540753121,5540753123,5540753321,5540753323,5541500200,5541500202,5541500220,5541502000,5541502002,5541502200,5541502201,5541502202,5541502220,5541502222,5541600000,5541600002,5541600020,5541600022,5541600200,5541600202,5541600220,5541600222,5541600223,5541602032,5541602033,5541602300,5541602302,5541700030,5541700032,5541700210,5541700212,5541702122,5541702300,5541702301,5541702302,5541702322,5640051033,5640051101,5640051103,5640053101,5640053103,5640053121,5640053130,5640053132,5640060320,5640060321,5640060330,5640060331,5640060333,5640061220,5640061221,5640061222,5640061230,5640061231,5640061330,5640061331,5640061333,5640062000,5640063111,5640063113,5640063131,5640063133,5640063311,5640063313,5640063331,5640063333,5640153332,5640153333,5640161111,5640161112,5640161113,5640161303,5640161321,5640161323,5640162123,5640162132,5640162133,5640162211,5640162212,5640162213,5640163022,5640163023,5640163101,5640163102,5640163103,5640251011,5640251013,5640251031,5640251033,5640251211,5640251213,5640251223,5640253031,5640253033,5640253211,5640253300,5640253301,5640253303,5640253321,5640351123,5640351212,5640351213,5640351221,5640351222,5640351223,5640352111,5640352113,5640352131,5640352133,5640352311,5640352313,5640450111,5640450113,5640450123,5640450330,5640450331,5640450333,5640452111,5640452113,5640453200,5640453201,5640453210,5640453211,5640453213,5640453320,5640453321,5640453330,5640453331,5640453333,5640551033,5640551201,5640551202,5640551203,5640551221,5640551330,5640551331,5640553010,5640553011,5640560220,5640560221,5640562010,5640562011,5640562013,5640562031,5640562110,5640562111,5640563000,5640563001,5640563010,5640571330,5640571331,5640571332,5640573110,5640573112,5640573130,5640573132,5640573310,5640573312,5640573320,5640573321,5640573330,5640661103,5640661121,5640663130,5640663131,5640663133,5640671010,5640671011,5640671012,5640671030,5640671200,5640671201,5640671202,5640671220,5640672201,5640672210,5640672211,5640672213,5640672301,5641000100,5641000102,5641000120,5641000122,5641000300,5641000302,5641000320,5641000322,5641002100,5641002102,5641002120,5641002122,5641002300,5641002302,5641002320,5641002322,5641100120,5641100122,5641100300,5641100302,5641100320,5641100321,5641100322,5641102100,5641102102,5641200100,5641200101,5641200102,5641200120,5641200122,5641200300,5641200302,5641200320,5641200322,5641202100,5641202102,5641202120,5641202122,5641202300,5641300120,5641300122,5641302210,5641302211,5641302212,5641302230,5641302232,5641400010,5641400030,5641500000,5641500002,5640671032,55402433211,55402433213,55402512321,55402512322,55402512323,55402520223,55402520232,55402520233,55402520322,55402520323,55402520332,55402520333,55402521132,55402521133,55402521203,55402521212,55402521213,55402521221,55402521222,55402521223,55402521302,55402521303,55402530012,55402530013,55402530022,55402530023,55402601223,55402601232,55402601233,55402601322,55402602011,55402602013,55402602021,55402602023,55402602110,55402602112,55402603100,55402603102,55402603120,55402603300,55402603302,55402603320,55402603322,55402621100,55402621102,55402621103,55402621112,55402621130,55402621132,55402621310,55402621312,55402621313,55402630222,55402632000,55402632002,55402632121,55402632123,55402633332,55402633333,55402722222,55403410113,55403410131,55403410133,55403410313,55403410331,55403410333,55403411002,55403411003,55403430233,55403430321,55403430322,55403430323,55403432011,55403432013,55403433200,55403433201,55403433210,55403433211,55403433213,55403433231,55403700000,55403700002,55403700003,55403700012,55403700013,55403700302,55403700303,55403700312,55403701203,55403701212,55403701213,55403701302,55403701303,55403701312,55403701313,55403712000,55403712002,55403712020,55403712022,55403712332,55403712333,55403731002,55403731003,55403733010,55403733012,55403733120,55403733122,55404411120,55404411121,55404411130,55404411131,55404502230,55404502231,55404502233,55404520011,55404520013,55404520031,55404520120,55404520121,55404523230,55404523231,55404711100,55404711102,55404711120,55404711122,55404711210,55404711211,55404711212,55404711230,55404711232,55404711300,55404713010,55404713012,55404713030,55404713032,55404713210,55404713212,55404713230,55404713232,55404731010,55404731012,55404731030,55404731032,55404731210,55404731212,55404731320,55404731322,55404733100,55404733102,55404733120,55404733122,55404733300,55404733302,55404733303,55405433131,55405433133,55405433311,55405433313,55405433331,55405433333,55405501232,55405501233,55405520303,55405520321,55405520323,55405522020,55405522022,55405522101,55405522103,55405522121,55405522123,55406411101,55406411103,55406411121,55406411122,55406411123,55406411301,55406411303,55406411321,55406411323,55406413101,55406413103,55406413121,55406413123,55406413130,55406413131,55406413301,55406502200,55406502201,55406502321,55406502323,55406521021,55406521023,55406521301,55406521303,55406532000,55406532001,55407510230,55407510231,55407510233,55407512011,55407512013,55407512031,55407512033,55407512301,55407512303,55407512321,55407512323,55407530033,55407530101,55407530103,55407530121,55407530122,55407530123,55407530211,55407530300,55407530301,55407530303,55407530321,55407530330,55407530331,55407531220,55407531221,55407533010,55407533011,55415000220,55415000222,55415002010,55415002012,55415002030,55415002032,55415002210,55415002212,55415002220,55415002222,55415002223,55415002232,55415020010,55415020012,55415020030,55415020032,55415022030,55415022032,55415022210,55415022212,55415022230,55415022232,55416000010,55416000012,55416000030,55416000032,55416000210,55416000212,55416000230,55416000232,55416002010,55416002012,55416002030,55416002032,55416002210,55416002212,55416002213,55416020120,55416020122,55416020300,55416020302,55416021222,55416021223,55416022300,55416022302,55416022320,55416022322,55417000100,55417000102,55417000120,55417000122,55417000310,55417000312,55417000330,55417000332,55417002110,55417002112,55417002130,55417002132,55417021202,55417021203,55417021212,55417021230,55417021232,55417021233,55417021322,55417023030,55417023032,55417023100,55417023102,56400510311,56400510313,56400511003,56400511021,56400511023,56400512110,56400512111,56400512113,56400512131,56400512133,56400512303,56400512311,56400512312,56400512313,56400512331,56400512333,56400530111,56400531000,56400531001,56400531003,56400531021,56400531023,56400531201,56400531203,56400531221,56400531230,56400531231,56400531310,56400531311,56400533100,56400533101,56400603220,56400603222,56400603321,56400603323,56400612230,56400612232,56400613321,56400613323,56400620010,56400620011,56400620020,56400620021,56400620022,56400620100,56400620101,56400620200,56400631101,56400633323,56401532333,56401533222,56401533223,56401533232,56401533233,56401533302,56401533303,56401533312,56401533313,56401611101,56401611103,56401613012,56401613013,56401620331,56401620333,56401622022,56401622023,56401622032,56401622033,56401622102,56401622103,56401630131,56401630133,56401630211,56401630213,56401631001,56401631003,56402510101,56402510103,56402510121,56402512033,56402512122,56402512123,56402512211,56402512212,56402512213,56402530010,56402530011,56402530013,56402530031,56402530033,56402530301,56402530303,56402530321,56402530323,56402532101,56402532103,56402533021,56402533023,56402533230,56402533231,56403503331,56403503333,56403510333,56403511212,56403511213,56403511222,56403511223,56403512013,56403512031,56403512032,56403512033,56403512102,56403512103,56403512111,56403512112,56403512113,56403521101,56403521103,56403521121,56403521123,56403521301,56403521303,56403521321,56403521323,56403523101,56403523103,56403523121,56403523123,56404501100,56404501101,56404501103,56404501121,56404501122,56404501123,56404501212,56404501213,56404503010,56404503011,56404503320,56404503321,56404503323,56404521101,56404521103,56404521121,56404521123,56404521311,56404521313,56404521331,56404521333,56404523111,56404532020,56404532021,56404532030,56404532031,56404532120,56404532121,56404532310,56404532311,56404532313,56404532331,56404533220,56404533221,56404533230,56404533231,56404533320,56404533321,56404533323,56405510232,56405510233,56405510303,56405510312,56405510313,56405510321,56405510322,56405510323,56405511111,56405511113,56405511131,56405511133,56405511202,56405511220,56405511222,56405511223,56405511232,56405511233,56405511311,56405511313,56405511322,56405511323,56405511331,56405511332,56405511333,56405512200,56405512201,56405512231,56405512233,56405513330,56405513331,56405530011,56405530013,56405530121,56405530123,56405530130,56405530131,56405530132,56405530301,56405530310,56405531000,56405531001,56405531002,56405531010,56405531011,56405531020,56405602220,56405602221,56405602231,56405602233,56405620011,56405620013,56405620031,56405620120,56405620121,56405620123,56405620301,56405621120,56405621121,56405621122,56405621130,56405621131,56405621200,56405621201,56405621202,56405621210,56405621211,56405621300,56405630020,56405630021,56405630030,56405630031,56405630110,56405630111,56405630120,56405630121,56405631000,56405631001,56405631010,56405631011,56405631013,56405631031,56405631033,56405631211,56405631213,56405631231,56405631233,56405633011,56405633013,56405633031,56405633033,56405633211,56405633213,56405633231,56405633233,56405733220,56405733221,56405733230,56405733231,56405733320,56406611011,56406611013,56406611021,56406611023,56406611201,56406611203,56406611231,56406611233,56406613033,56406613211,56406613213,56406613231,56406613233,56406631011,56406631013,56406631031,56406631033,56406631211,56406631213,56406631321,56406631323,56406710130,56406710131,56406712030,56406712032,56406712210,56406712212,56406712220,56406712221,56406712222,56406712230,56406722121,56406722123,56406723000,56406723002,56406723020,56406723022,56406723100,56406723102,56406730000,56406730002,56406730020,56406730022,56406730200,56406730202,56406730220,56406730222,56410001030,56410001032,56410001210,56410001212,56410001230,56410001232,56410003010,56410003012,56410003013,56410003030,56410003031,56410003032,56410003102,56410003120,56410003210,56410003212,56410003230,56410003232,56410021010,56410021012,56410021030,56410021032,56410021210,56410021212,56410021230,56410021232,56410023010,56410023012,56410023030,56410023032,56410023210,56410023212,56410023230,56410023232,56411001100,56411001102,56411001120,56411001122,56411001210,56411001212,56411001230,56411001232,56411003010,56411003012,56411003030,56411003032,56411003230,56411003231,56411003232,56411003300,56411003302,56411003320,56411021010,56411021012,56411021030,56411021032,56411021033,56411021122,56411021300,56411021302,56411021320,56411021322,56411023100,56411023102,56411023120,56411023122,56411023300,56411023302,56411023320,56411023322,56412001030,56412001032,56412001100,56412001102,56412001210,56412001212,56412001230,56412001232,56412003010,56412023020,56412023021,56413003000,56413003001,56413022130,56413022131,56413022132,56413022310,56413022312,56413022330,56413022332,56414000110,56414000112,56414000120,56414000122,56414000310,56414000312,56414000320,56414000321,56414000322,56414000330,56414002100,56414002102,56414002120,56414002122,56414002300,56414002302,56414002320,56414002322,56414020100,56414020102,56414020120,56414020122,56414020300,56414020302,56414020320,56414020322,56414022100,56414022102,56414022120,56414022122,56414022300,56414022302,56415000010,56415000011,56415000012,56415000030,56415000032,56415000200,56415000201,56415000202,56415000210,56415000220,56406710132,56406710310,56406710312,56406712100,56406712101,55402633330,
019,00,Լ,505687500,136425000,507853125,138656250,7,14,57,76,182,342,574026,574035,574036,574037,574045,574046,574047,5740163,5740170,5740172,5740270,5740272,5740340,5740343,5740441,5740551,5740560,5740561,5740563,5740570,5740571,56406633,56407611,56407613,56407631,56407633,56407700,56407702,56407720,56407722,57400611,57400613,57400631,57400633,57400700,57400702,57400720,57400722,57401611,57401613,57401621,57401623,57402531,57402532,57402533,57402710,57402712,57402730,57402732,57402733,57403311,57403411,57403412,57403413,57403421,57403423,57404401,57404431,57404433,57405411,57405500,57405501,57405503,57405530,57405531,57405620,57405621,57405720,57405721,57405722,57405730,57405731,57413002,57414002,57414020,57414022,57415000,57415002,564067222,564067223,564067232,564077010,564077012,564077030,564077032,564077210,564077212,564077230,564077232,574007010,574007012,574007030,574007032,574007210,574007212,574007230,574007232,574007233,574017302,574017320,574017322,574027132,574027310,574027312,574027313,574034200,574034201,574034203,574044030,574044031,574044301,574044303,574044321,574044323,574054101,574054103,574054131,574055020,574055021,574055211,574055330,574055331,574056220,574056221,574056230,574056231,574057230,574057320,574057321,574057323,574057330,574057331,574057332,574120222,574130000,574130002,574130003,574130030,574130032,574130200,574130201,574140000,574140002,574140003,574140012,574140030,574140232,574150010,574150012,574150013,574150030,574150200,574150201,574150202,5640672200,5640672202,5640672203,5640672303,5640672311,5640672312,5640672313,5640672330,5640672332,5640770110,5640770112,5640770130,5640770132,5640770310,5740070310,5740070312,5740070330,5740070332,5740072110,5740072112,5740072130,5740072132,5740072310,5740072312,5740072313,5740171202,5740171220,5740171222,5740173000,5740173002,5740173003,5740173032,5740173210,5740173212,5740173230,5740173232,5740173233,5740271120,5740271122,5740271300,5740271302,5740273110,5740273112,5740273113,5740331311,5740331313,5740331331,5740331333,5740333111,5740333113,5740342021,5740342023,5740342211,5740342233,5740440011,5740440013,5740440031,5740440033,5740440330,5740440331,5740440333,5740443001,5740443003,5740443021,5740443023,5740443201,5740443203,5740443221,5740443223,5740541211,5740541300,5740541301,5740541330,5740541331,5740550221,5740550230,5740550231,5740550233,5740552100,5740552101,5740552103,5740552130,5740552131,5740552133,5740553201,5740553210,5740553211,5740553213,5740553321,5740553330,5740553331,5740562220,5740562221,5740562230,5740562231,5740562320,5740562321,5740562330,5740562331,5740572310,5740572311,5740572320,5740572322,5740573221,5740573330,5740573331,5740573332,5740661011,5740661100,5740661101,5740661110,5740670001,5740670003,5740670010,5740670012,5740670030,5740671011,5740671100,5741202200,5741202202,5741202203,5741300010,5741300012,5741300013,5741300120,5741300122,5741300123,5741300310,5741300330,5741300332,5741302020,5741302021,5741302022,5741302030,5741302031,5741302100,5741302102,5741302120,5741302200,5741302202,5741302220,5741302222,5741302223,5741400011,5741400012,5741400013,5741400100,5741400102,5741400103,5741400112,5741400113,5741400130,5741400131,5741400132,5741400310,5741400312,5741400320,5741400321,5741400330,5741402102,5741402120,5741402122,5741402300,5741402302,5741402303,5741402312,5741402330,5741402332,5741500110,5741500112,5741500113,5741500310,5741500311,5741500320,5741500322,5741501020,5741501022,5741501200,5741502030,5741502032,5741502100,5741502200,56406722120,56406722122,56406723001,56406723003,56406723021,56406723023,56406723101,56406723103,56406723310,56406723311,56407703120,56407703122,56407703300,56407703302,56407703320,56407703322,56407721100,56407721102,56407721120,56407721122,56407721300,56407721302,56407721320,56407721322,56407723100,56407723102,56407723120,56407723122,56407723300,56407723302,56407723320,56407723322,57400701100,57400701102,57400701120,57400701122,57400701300,57400701302,57400701320,57400701322,57401710022,57401710200,57401710202,57401710220,57401710222,57401712000,57401712002,57401712030,57401712032,57401712210,57401712212,57401712230,57401712232,57401730010,57401730012,57401730013,57401732130,57401732132,57401732310,57401732312,57401732313,57402713010,57402713012,57402713030,57402713032,57402713033,57402713122,57402713300,57402713302,57402713320,57402713322,57402713323,57403313000,57403313001,57403313010,57403313011,57403313100,57403313101,57403313103,57403331310,57403331311,57403420200,57403420201,57403420203,57403420221,57403420223,57403422101,57403422103,57403422131,57403422133,57403422303,57403422311,57403422312,57403422313,57403422321,57403422323,57404400101,57404400103,57404400121,57404400123,57404400301,57404400303,57404400321,57404400323,57404402111,57404402113,57404403211,57404403213,57404403321,57404403323,57404421101,57404421110,57404421111,57404430000,57404430001,57404430003,57404430021,57404430023,57404430201,57405410010,57405410011,57405412101,57405412103,57405413031,57405413033,57405413320,57405413321,57405413330,57405413331,57405502200,57405502201,57405502230,57405502231,57405502320,57405502321,57405502323,57405520101,57405520110,57405520111,57405521020,57405521021,57405521023,57405521211,57405521213,57405532001,57405532003,57405532030,57405532031,57405532120,57405532121,57405532310,57405532311,57405533200,57405533201,57405533203,57405533221,57405533230,57405533231,57405533320,57405533321,57405533330,57405533331,57405622220,57405622221,57405622230,57405622231,57405622320,57405622321,57405622330,57405622331,57405623220,57405623221,57405623230,57405623231,57405623320,57405623321,57405623330,57405623331,57405623333,57405723120,57405723121,57405723122,57405723130,57405723131,57405723133,57405723210,57405723211,57405723300,57405723311,57405732200,57405732201,57405732230,57405732231,57405732233,57405733330,57405733331,57406601111,57406610000,57406610001,57406610010,57406610011,57406610100,57406610101,57406610103,57406610121,57406610130,57406610131,57406611020,57406611021,57406611030,57406611031,57406611110,57406611111,57406611120,57406611121,57406700000,57406700001,57406700110,57406700111,57406700112,57406700130,57406700132,57406700211,57406700213,57406701000,57406701001,57406710011,57406710100,57406710101,57406710103,57406710121,57406710130,57406710131,57406711010,57406711011,57406711012,57406711020,57406711021,57406711030,57406711100,57406711101,57412020200,57412020202,57412020220,57412020222,57412022010,57412022012,57412022013,57412022302,57412022320,57412022322,57412022323,57412022332,57413000110,57413000112,57413001320,57413001322,57413003120,57413003122,57413003123,57413020230,57413020231,57413020232,57413020320,57413020321,57413020330,57413020331,57413021010,57413021011,57413021012,57413021030,57413021032,57413021100,57413021210,57413021220,57413021221,57413022010,57413022012,57413022030,57413022032,57413022210,57413022212,57413022213,57414000100,57414000102,57414001010,57414001012,57414001330,57414001331,57414001332,57414003110,57414003112,57414003221,57414003230,57414003231,57414003320,57414010020,57414010022,57414010200,57414010202,57414010220,57414021210,57414021212,57414021230,57414021232,57414023010,57414023012,57414023013,57414023102,57414023103,57414023330,57414023332,57415001110,57415001112,57415003120,57415003122,57415003210,57415003212,57415003230,57415003232,57415010020,57415010022,57415020310,57415020312,57415020330,57415020332,57415021010,57415021012,57415021020,57415021021,57415021030,57415022010,57415022012,57415022020,57415022021,57415022022,57415022030,57415022200,57413001210,57413001211,57413001300,57401733222,
019,01,,504984375,136031250,507107812,137775000,6,19,41,57,138,299,564075,574004,574005,574014,574015,574024,5640660,5640662,5640733,5640740,5640742,5640743,5640760,5640762,5740021,5740030,5740031,5740033,5740060,5740062,5740131,5740160,5740250,5740251,5740252,56405533,56405622,56405623,56405632,56406511,56406513,56406531,56406532,56406533,56406610,56406612,56406630,56406632,56407223,56407232,56407233,56407322,56407323,56407411,56407412,56407413,56407610,56407612,56407630,56407632,57400203,57400321,57400610,57400612,57400630,57400632,57401331,57401333,57401610,57401612,57401620,57401622,57402331,57402333,57402530,57403410,564055311,564055312,564055313,564055321,564055323,564056202,564056302,564056303,564063333,564064222,564065101,564065103,564065121,564065123,564065222,564065223,564065231,564065232,564065233,564065301,564065303,564072302,564072303,564072312,564072313,564073111,564073113,564073131,564073133,564073202,564073213,564074102,564074103,574002011,574002013,574002210,574002211,574002300,574002301,574002310,574002311,574003200,574003201,574003203,574003230,574003231,574003233,574013011,574013013,574013301,574013303,574023110,574023111,574023113,574023131,574023132,574023133,5640551332,5640553032,5640553033,5640553103,5640553201,5640553203,5640553221,5640553223,5640562000,5640562002,5640562032,5640562033,5640562122,5640562123,5640562131,5640562132,5640562133,5640563013,5640563102,5640563120,5640563122,5640563300,5640563302,5640563320,5640563322,5640633313,5640642232,5640642233,5640642322,5640642323,5640642332,5640642333,5640643233,5640643322,5640643323,5640651001,5640651003,5640651221,5640651223,5640652133,5640652203,5640652212,5640652213,5640652302,5640652303,5640653022,5640653023,5640661100,5640661122,5640661300,5640661301,5640661302,5640661320,5640661322,5640663100,5640663102,5640663120,5640663122,5640663123,5640722123,5640722131,5640722132,5640722133,5640722211,5640722213,5640722231,5640723002,5640723003,5640723012,5640723013,5640723100,5640723102,5640723103,5640723112,5640723113,5640731121,5640731233,5640731322,5640731323,5640732000,5640732002,5640732032,5640732033,5640732111,5640732112,5640732113,5640732122,5640732123,5640741011,5640741012,5640741013,5740020101,5740020103,5740020121,5740020122,5740020123,5740020211,5740020213,5740020231,5740022031,5740022120,5740022121,5740022130,5740022131,5740023020,5740023021,5740023030,5740023031,5740023120,5740023121,5740023130,5740023131,5740032020,5740032021,5740032023,5740032201,5740032210,5740032211,5740032321,5740130121,5740130310,5740130311,5740130313,5740130330,5740130331,5740130333,5740132111,5740133000,5740133001,5740133003,5740133021,5740133210,5740133211,5740133213,5740231121,5740231123,5740231301,5740231303,56405513332,56405513333,56405530133,56405530213,56405530231,56405530233,56405530302,56405530303,56405530311,56405530312,56405530313,56405531003,56405531012,56405531013,56405531021,56405531022,56405531023,56405532222,56405532223,56405602222,56405602223,56405602230,56405602232,56405620010,56405620012,56405620030,56405620032,56405620033,56405620122,56405620300,56405620302,56405620303,56405621123,56405621132,56405621133,56405621203,56405621212,56405621213,56405621301,56405621302,56405621303,56405630022,56405630023,56405630032,56405630033,56405630112,56405630113,56405630122,56405630123,56405631002,56405631003,56405631012,56405631030,56405631032,56405631210,56405631212,56405631230,56405631232,56405633010,56405633012,56405633030,56405633032,56405633210,56405633212,56405633230,56405633232,56406333213,56406333231,56406333233,56406422302,56406422303,56406422312,56406422313,56406423202,56406423203,56406423212,56406423213,56406423302,56406423303,56406423312,56406423313,56406432312,56406432313,56406432323,56406433202,56406433203,56406433212,56406433213,56406433322,56406433323,56406433332,56406433333,56406510211,56406510213,56406510231,56406510233,56406512011,56406512013,56406512031,56406512033,56406512222,56406512223,56406521321,56406521323,56406530011,56406530013,56406530031,56406530033,56406530211,56406530213,56406611010,56406611012,56406611020,56406611022,56406611200,56406611202,56406611230,56406611232,56406613030,56406613031,56406613032,56406613210,56406613212,56406613230,56406613232,56406631010,56406631012,56406631030,56406631032,56406631210,56406631212,56406631320,56406631322,56407212333,56407213222,56407213223,56407213333,56407220332,56407221301,56407221303,56407222330,56407222331,56407222333,56407230012,56407230013,56407230102,56407230103,56407230111,56407230112,56407230113,56407231012,56407231013,56407231102,56407231103,56407231111,56407231112,56407231113,56407302222,56407302223,56407302232,56407303332,56407303333,56407311011,56407311013,56407311031,56407311033,56407311201,56407311203,56407311221,56407311230,56407311231,56407311233,56407312222,56407312223,56407312232,56407312233,56407312303,56407312312,56407312313,56407312321,56407312322,56407312323,56407313011,56407313033,56407313202,56407313203,56407313211,56407313212,56407313213,56407320010,56407320012,56407320030,56407320032,56407321031,56407321033,56407321102,56407321103,56407321211,56407321213,56407410002,56407410013,56407410020,56407410022,56407410023,56407410031,56407410032,56407410033,56407410101,56407410102,56407410103,57400200111,57400200313,57400200331,57400200333,57400201000,57400201001,57400201003,57400201021,57400201023,57400201201,57400201202,57400201203,57400202330,57400202331,57400202333,57400220111,57400220113,57400220131,57400220132,57400220133,57400220331,57400221220,57400221221,57400221230,57400221231,57400221320,57400320220,57400320221,57400320223,57400322001,57400322003,57400322021,57400322030,57400322031,57400322120,57400322121,57400322130,57400322131,57400322133,57400322311,57400323200,57400323201,57400323203,57400323221,57400323230,57400323231,57400323233,57401301011,57401301013,57401301031,57401301032,57401301033,57401301230,57401301231,57401301233,57401303011,57401303013,57401303031,57401303120,57401303121,57401303123,57401303211,57401303213,57401303321,57401303323,57401330021,57401330023,57401330201,57401330203,57401330221,57401330230,57401330231,57401330233,57401332011,57401332013,57401332031,57401332120,57401332121,57401332310,57401332311,57401332313,57401332331,57401332333,57402313022,57402313023,57402330331,57402330333,57402332111,57402332113,
020,00,д/,507642187,137653125,510075000,140362500,1,23,52,192,447,978,574152,5741403,5741412,5741511,5741513,5741530,5741532,5741533,5741620,5741621,5741623,5741630,5741632,5741721,5741730,5741731,5741732,5841030,5841033,5841240,5841242,5841243,5841340,5841341,57413420,57413422,57414132,57414310,57414311,57414322,57414323,57414330,57414331,57414332,57414400,57415011,57415100,57415101,57415310,57415312,57415313,57416110,57416111,57416220,57416221,57416223,57416310,57416311,57416312,57416330,57416332,57417201,57417231,57417402,58410310,58410312,58410313,58410321,58410323,58410420,58410421,58410422,58411310,58411311,58411313,58411331,58411333,58411420,58411422,58411423,58412412,58412520,58412522,58413420,58413421,58413430,574130213,574130221,574130223,574130230,574130232,574130300,574130301,574130302,574130320,574130333,574131223,574131232,574133032,574133111,574133112,574133130,574133210,574133312,574133313,574133321,574133330,574133331,574133333,574134021,574134023,574134120,574134122,574134210,574134211,574134212,574134300,574134301,574134302,574140111,574140122,574140211,574140213,574141000,574141001,574141003,574141010,574141021,574141023,574141032,574141300,574141302,574141303,574141330,574141332,574141333,574142222,574142223,574142323,574142333,574143013,574143120,574143121,574143123,574143130,574143131,574143132,574143200,574143202,574143203,574143211,574143213,574143330,574143331,574143332,574144020,574144200,574144202,574144203,574144212,574150101,574150103,574150121,574151020,574151021,574151030,574151031,574151033,574151211,574151212,574151213,574151231,574151233,574154030,574154223,574154232,574161011,574161120,574161121,574161130,574161131,574161133,574161311,574161313,574162220,574162221,574162223,574163130,574163131,574163132,574163310,574163312,574164001,574164002,574164003,574164010,574164012,574164020,574164021,574164023,574164030,574164032,574172001,574172003,574172031,574172033,574172300,574172301,574172303,574172330,574172331,574172333,574173300,574173301,574173310,574173311,574173320,574173322,574174002,574174200,574174201,584103112,584103113,584103200,584103201,584103203,584104020,584104022,584104023,584104032,584104230,584104231,584104232,584113010,584113011,584113121,584113123,584113301,584114000,584114001,584114002,584114020,584114022,584114210,584114212,584114213,584114320,584114322,584114323,584114332,584123110,584123111,584123113,584123131,584123132,584123133,584123311,584124100,584124101,584124102,584124113,584124131,584124133,584125000,584125022,584125030,584125031,584125032,584125210,584125212,584134220,584134310,584135000,584135002,584135020,584135022,574142322,574141012,5741233332,5741233333,5741242220,5741242222,5741300313,5741300331,5741300333,5741301202,5741301220,5741301222,5741301223,5741302111,5741302112,5741302113,5741302123,5741302310,5741302311,5741302330,5741302332,5741303030,5741303032,5741303100,5741303102,5741303210,5741303233,5741303321,5741303322,5741303323,5741312212,5741312213,5741312220,5741312222,5741312223,5741312302,5741312303,5741312312,5741312313,5741312330,5741312332,5741330332,5741330333,5741331031,5741331033,5741331101,5741331102,5741331103,5741331130,5741331132,5741331211,5741331213,5741332110,5741332112,5741332120,5741332121,5741332123,5741332130,5741333013,5741333023,5741333031,5741333032,5741333033,5741333102,5741333103,5741333111,5741333113,5741333201,5741333320,5741333321,5741333323,5741340000,5741340032,5741340033,5741340201,5741340203,5741340221,5741340223,5741340331,5741340333,5741341021,5741341023,5741341030,5741341032,5741341210,5741341211,5741341212,5741341230,5741341232,5741342130,5741342131,5741342300,5741342301,5741342302,5741342320,5741342322,5741343030,5741400110,5741400313,5741400331,5741400333,5741401021,5741401023,5741401101,5741401103,5741401200,5741401202,5741401232,5741401233,5741401321,5741401322,5741401323,5741401330,5741401332,5741401333,5741402100,5741402101,5741402103,5741402311,5741402313,5741402331,5741410021,5741410023,5741410110,5741410112,5741410130,5741410201,5741410203,5741410222,5741410223,5741410300,5741410302,5741410332,5741410333,5741413012,5741413122,5741413123,5741413310,5741413312,5741413313,5741422202,5741422320,5741422322,5741422323,5741422332,5741422333,5741423112,5741423113,5741423130,5741423131,5741423133,5741423311,5741423313,5741423322,5741423323,5741430111,5741430112,5741430113,5741430123,5741430310,5741430311,5741430313,5741431221,5741431222,5741431223,5741431330,5741431331,5741431332,5741432012,5741432121,5741432122,5741432123,5741433331,5741440100,5741440101,5741440102,5741440210,5741440212,5741440220,5741440221,5741440230,5741442011,5741442012,5741442013,5741442100,5741442102,5741442103,5741442200,5741442201,5741442202,5741442210,5741442220,5741442300,5741442301,5741443122,5741443211,5741443300,5741500313,5741501000,5741501001,5741501003,5741501021,5741501023,5741501201,5741501202,5741501203,5741501300,5741501301,5741501302,5741501310,5741501311,5741501313,5741510323,5741512101,5741512103,5741512301,5741512321,5741512323,5741531100,5741531101,5741531122,5741531123,5741531132,5741531133,5741540033,5741540122,5741540200,5741540202,5741540203,5741540211,5741540213,5741540221,5741540222,5741540223,5741540231,5741540232,5741540233,5741540320,5741542010,5741542011,5741542212,5741542213,5741542302,5741542303,5741610101,5741610103,5741610130,5741610131,5741610133,5741610311,5741610313,5741611220,5741611221,5741611223,5741611230,5741611231,5741611321,5741611323,5741613310,5741613311,5741613313,5741622220,5741622221,5741622223,5741631330,5741631331,5741631332,5741633110,5741633112,5741633322,5741633323,5741633332,5741640002,5741640003,5741640132,5741640220,5741640221,5741640310,5741642011,5741642100,5741642101,5741722111,5741722113,5741723020,5741723021,5741723023,5741723321,5741733020,5741733021,5741733022,5741733030,5741733031,5741733033,5741733120,5741733121,5741733122,5741733130,5741733131,5741733212,5741740002,5741740032,5741740322,5741742020,5741742021,5741742030,5741742031,5741742100,5741742102,5741742120,5841021111,5841021133,5841021311,5841021313,5841021331,5841021333,5841023111,5841023113,5841031100,5841031102,5841031103,5841031112,5841031113,5841040022,5841040023,5841040032,5841040210,5841040212,5841040311,5841040313,5841040331,5841040332,5841040333,5841041202,5841041220,5841041222,5841043000,5841043020,5841043022,5841043200,5841043202,5841130120,5841130121,5841130130,5841130131,5841131200,5841131201,5841131223,5841133001,5841133003,5841133031,5841133213,5841133231,5841133233,5841140030,5841140032,5841140100,5841140102,5841140210,5841140212,5841140230,5841140232,5841140233,5841140322,5841142112,5841142113,5841143021,5841143022,5841143023,5841143030,5841143032,5841143210,5841143212,5841143213,5841143302,5841152222,5841231011,5841231121,5841231123,5841231213,5841231231,5841231301,5841231302,5841231303,5841233101,5841233103,5841233121,5841233130,5841233131,5841241030,5841241032,5841241100,5841241111,5841241112,5841241113,5841241123,5841241301,5841241303,5841241321,5841241323,5841250010,5841250012,5841250020,5841250021,5841250022,5841250030,5841250132,5841250200,5841250202,5841250203,5841250231,5841250233,5841250330,5841250332,5841252300,5841252302,5841342210,5841342211,5841342300,5841342301,5841342310,5841342311,5841343110,5841343111,5841343112,5841343120,5841343121,5841343122,5841343200,5841350010,5841350011,5841350012,5841350030,5841350032,5841350210,5841350211,5841350212,5841350230,5841350232,5841352000,5841352001,5841352012,5741312300,5741401212,5741401213,5741410020,5741401131,5741401133,5741443103,5741443121,57412333133,57412333213,57412333223,57412333231,57412333232,57412333233,57412333302,57412333303,57412333311,57412333312,57412333313,57412422022,57412422023,57412422032,57412422210,57412422212,57412422230,57412422232,57413003110,57413003112,57413003113,57413003121,57413012002,57413012003,57413012212,57413012213,57413012322,57413012323,57413012332,57413012333,57413020233,57413020322,57413020323,57413020332,57413020333,57413021013,57413021031,57413021033,57413021101,57413021102,57413021103,57413021211,57413021212,57413021213,57413021222,57413021223,57413022011,57413022013,57413022031,57413022033,57413022211,57413023120,57413023122,57413023123,57413023312,57413023330,57413023332,57413030310,57413030311,57413030312,57413030330,57413030332,57413031200,57413031201,57413032110,57413032112,57413032120,57413032122,57413032312,57413032313,57413033032,57413033033,57413033122,57413033123,57413033132,57413033133,57413033202,57413033203,57413121323,57413121332,57413122013,57413122022,57413122023,57413122031,57413122033,57413122102,57413122103,57413122112,57413122113,57413122211,57413122212,57413122213,57413123012,57413123013,57413123101,57413123102,57413123103,57413123110,57413123112,57413123113,57413123310,57413123312,57413132002,57413132020,57413132022,57413303022,57413303023,57413303032,57413303033,57413303122,57413303300,57413303302,57413303303,57413303312,57413303313,57413310301,57413310303,57413310321,57413310323,57413311001,57413311003,57413311310,57413311311,57413311312,57413311330,57413311332,57413312101,57413312103,57413312121,57413312123,57413313100,57413313101,57413313102,57413313110,57413313120,57413313122,57413313313,57413313331,57413313332,57413313333,57413321110,57413321111,57413321112,57413321130,57413321132,57413321220,57413321221,57413321223,57413321310,57413321312,57413321320,57413321321,57413321322,57413321330,57413330301,57413330303,57413331120,57413331122,57413332031,57413332033,57413332332,57413332333,57413333221,57413333222,57413333223,57413400010,57413400012,57413400020,57413400021,57413400030,57413400231,57413400233,57413401220,57413401222,57413402202,57413402220,57413402222,57413402223,57413403000,57413403002,57413403020,57413403022,57413403113,57413403123,57413403131,57413403132,57413403133,57413403200,57413403202,57413403220,57413403222,57413403223,57413403301,57413403303,57413403321,57413403322,57413403323,57413410330,57413410332,57413412130,57413412132,57413412310,57413412312,57413412330,57413412332,57413412333,57413413000,57413413002,57413413222,57413421320,57413421321,57413421322,57413421330,57413421331,57413423100,57413423102,57413430310,57413430311,57413430320,57413430321,57413431000,57413431002,57413431020,57413431022,57413431200,57414000101,57414000103,57414001011,57414001013,57414001110,57414001112,57414001333,57414003111,57414003113,57414003220,57414003222,57414003223,57414003232,57414003233,57414003321,57414003322,57414003323,57414010110,57414010111,57414010201,57414010203,57414010221,57414010222,57414010223,57414011000,57414011001,57414011210,57414011211,57414011300,57414011301,57414012032,57414012033,57414012302,57414013032,57414013033,57414013122,57414013123,57414013203,57414013312,57414021211,57414021213,57414021231,57414021233,57414023011,57414023100,57414023101,57414023331,57414023333,57414100221,57414100223,57414101320,57414101321,57414102001,57414102003,57414102021,57414102023,57414102211,57414102213,57414103010,57414103012,57414103030,57414103032,57414103033,57414103302,57414103303,57414103312,57414112220,57414112222,57414131200,57414131202,57414131203,57414131212,57414131213,57414131322,57414131323,57414131332,57414133110,57414133112,57414133113,57414222002,57414222003,57414222012,57414222030,57414222032,57414222033,57414222122,57414222123,57414222132,57414222133,57414223022,57414223023,57414223032,57414223210,57414223212,57414223213,57414223302,57414223303,57414223312,57414223313,57414231111,57414231113,57414232023,57414232032,57414232033,57414232113,57414232122,57414232123,57414232131,57414232132,57414232133,57414233002,57414233020,57414233022,57414233122,57414233123,57414233200,57414233202,57414233203,57414233212,57414233213,57414301031,57414301033,57414301211,57414301213,57414301221,57414301223,57414303312,57414303313,57414303330,57414303331,57414303333,57414312201,57414312202,57414312203,57414313330,57414313331,57414313332,57414320100,57414320102,57414321201,57414321202,57414321203,57414333330,57414333331,57414401030,57414401031,57414401200,57414401201,57414401202,57414401220,57414401222,57414402110,57414402112,57414402130,57414402132,57414402220,57414402221,57414402230,57414402231,57414402310,57414402312,57414402320,57414402321,57414421120,57414421122,57414421300,57414421302,57414421320,57414421322,57414422030,57414422032,57414422210,57414422212,57414422220,57414422221,57414422230,57414430332,57414430333,57414431202,57414431203,57414431230,57414431232,57414433010,57414433012,57415001111,57415001113,57415010021,57415010023,57415012211,57415012300,57415012301,57415012310,57415013030,57415013032,57415013121,57415013123,57415102310,57415102311,57415103200,57415103201,57415103210,57415103211,57415103213,57415121022,57415121023,57415123030,57415123031,57415123033,57415311020,57415311021,57415311022,57415311030,57415311031,57415311200,57415311202,57415311203,57415311212,57415311213,57415311302,57415311303,57415311312,57415311313,57415400202,57415400220,57415400222,57415400223,57415400232,57415400312,57415400313,57415400323,57415401202,57415401203,57415401232,57415401233,57415402010,57415402012,57415402013,57415402101,57415402103,57415402121,57415402122,57415402123,57415402200,57415402201,57415402202,57415402300,57415402301,57415402303,57415403220,57415403221,57415403222,57415420000,57415420001,57415420010,57415420011,57415420013,57415420022,57415420031,57415420120,57415420121,57415420130,57415420131,57415420200,57415420202,57415420220,57415420222,57415421000,57415421002,57415421020,57415422000,57415422002,57415422020,57415422022,57415422031,57415422033,57415422112,57415422113,57415422200,57415422202,57415422211,57415422213,57415422220,57415422222,57415422231,57415422233,57415423002,57415423003,57415423012,57415423013,57415423300,57415423302,57415423320,57415423322,57416101211,57416101213,57416101321,57416101323,57416103101,57416103103,57416103121,57416103123,57416103301,57416103310,57416103311,57416112220,57416112221,57416112223,57416112320,57416112321,57416112322,57416112330,57416112331,57416113200,57416113201,57416130001,57416130010,57416130011,57416130100,57416131010,57416131011,57416131013,57416131031,57416131033,57416131211,57416131213,57416131231,57416131233,57416133011,57416133013,57416133031,57416133120,57416133121,57416133123,57416133301,57416133310,57416133311,57416222220,57416222221,57416313330,57416313331,57416313332,57416331110,57416331112,57416331130,57416331132,57416331300,57416331302,57416331320,57416331322,57416333000,57416333002,57416333020,57416333022,57416333200,57416333202,57416333330,57416333332,57416400000,57416400011,57416400013,57416401100,57416401102,57416401120,57416401122,57416401300,57416401302,57416401303,57416402220,57416402221,57416402230,57416402231,57416402233,57416403120,57416420011,57416420100,57416420101,57417200010,57417200011,57417202101,57417202110,57417202111,57417203000,57417203011,57417203013,57417203031,57417203033,57417203211,57417203213,57417203231,57417203233,57417221101,57417221103,57417221311,57417221313,57417232010,57417232011,57417232100,57417232101,57417232110,57417232111,57417232113,57417232131,57417233200,57417233201,57417233230,57417233231,57417233233,57417330230,57417330231,57417330232,57417330320,57417330321,57417331230,57417331231,57417331320,57417331321,57417331330,57417331331,57417332110,57417332111,57417332300,57417332301,57417332322,57417332323,57417332332,57417332333,57417333000,57417333001,57417333222,57417333223,57417400000,57417400002,57417400003,57417400012,57417400030,57417400032,57417400033,57417400302,57417400303,57417400312,57417400330,57417400332,57417400333,57417401222,57417403000,57417403002,57417403020,57417403022,57417403200,57417403202,57417420220,57417420221,57417420230,58410211131,58410211133,58410211311,58410211313,58410311012,58410311013,58410311102,58410311103,58410311112,58410311113,58410320201,58410320210,58410320211,58410322100,58410322101,58410322110,58410322111,58410322113,58410322131,58410322133,58410322311,58410322313,58410322331,58410322333,58410400002,58410400020,58410400022,58410400200,58410400202,58410400212,58410400213,58410400302,58410400303,58410400330,58410400332,58410401331,58410401333,58410402110,58410402112,58410402130,58410402132,58410403101,58410403103,58410403121,58410403123,58410403301,58410403302,58410403303,58410410220,58410410222,58410412000,58410412002,58410412030,58410412032,58410412210,58410412212,58410412230,58410412232,58410423300,58410423302,58410430010,58410430012,58410430020,58410430022,58410430210,58410430212,58410430230,58410430232,58410432010,58410432012,58410432030,58410432032,58411300111,58411300113,58411300131,58411300133,58411300311,58411301220,58411301331,58411301333,58411303111,58411303113,58411312031,58411312033,58411312211,58411312213,58411330331,58411330333,58411332111,58411332112,58411332113,58411400310,58411400330,58411400332,58411402110,58411402112,58411402130,58411402132,58411402310,58411402312,58411402313,58411403202,58411403203,58411403232,58411403233,58411403322,58411421100,58411421102,58411421103,58411421112,58411421113,58411430020,58411430022,58411430200,58411430202,58411432112,58411432113,58411433002,58411433003,58411433032,58411433033,58411433122,58411433300,58411433302,58411433313,58411433320,58411433322,58411433323,58411433331,58411433332,58411433333,58411522202,58411522203,58411522212,58411522230,58411522232,58411522233,58411522322,58411522323,58412310131,58412310133,58412311201,58412311203,58412311221,58412311223,58412312330,58412312331,58412312333,58412313001,58412313003,58412331001,58412331003,58412331203,58412331320,58412331321,58412331330,58412331331,58412331333,58412333111,58412410310,58412410311,58412410312,58412410330,58412410332,58412411020,58412411022,58412411101,58412411103,58412411200,58412413000,58412413002,58412413020,58412413022,58412413200,58412413202,58412413220,58412413222,58412413223,58412500230,58412500231,58412500232,58412500320,58412500321,58412502010,58412502012,58412502013,58412502111,58412502113,58412502131,58412502132,58412502133,58412502303,58412502321,58412502323,58412521100,58412521102,58412521120,58412521122,58412521300,58412521302,58412521320,58412521322,58412523010,58412523012,58412523222,58412523223,58413311133,58413311311,58413311313,58413311331,58413331133,58413331311,58413331313,58413331331,58413331333,58413333111,58413333113,58413333131,58413333133,58413422120,58413422121,58413422122,58413422130,58413422131,58413423020,58413423021,58413423030,58413423031,58413423120,58413423121,58413423130,58413423131,58413431130,58413431132,58413431230,58413431231,58413431300,58413432010,58413432011,58413432020,58413432021,58413432100,58413432101,58413432110,58413432111,58413433000,58413433001,58413500130,58413500131,58413500132,58413500310,58413500312,58413500330,58413500332,58413500333,58413501000,58413501001,58413502312,58413502330,58413502332,58413520100,58413520101,58413520110,58413520300,58413520301,57413032300,57413032211,57413032210,57413032201,57413033113,57413033131,57413123010,57414001111,57414012102,57414100220,57414011303,57414402111,57414403000,57414431302,57414431300,57414303323,57414303322,57414303233,57414432130,57414432121,57414432103,57414432101,57416420300,57416420301,57416420123,57416420122,57416420120,57416420033,57416420031,57416420013,57414321011,57414423103,57414423121,57414423130,57414423112,
021,00,,505940625,138393750,509076562,140250000,13,23,67,143,313,606,574065,574075,574076,574077,574160,574170,574171,584006,584007,584016,584017,584026,584100,5740662,5740663,5740672,5740673,5741503,5741612,5840050,5840051,5840053,5840151,5840152,5840153,5840250,5840251,5840270,5841010,5841011,5841012,5841020,5841100,5841101,5841102,5841121,57405522,57405523,57406411,57406413,57406431,57406433,57406600,57406602,57406603,57406612,57406613,57406702,57406703,57406712,57406713,57407411,57407412,57407413,57415023,57415120,57415122,57416100,57416102,57416132,57417220,57417222,57417223,58400520,58400521,58400523,58401433,58401501,58401502,58401503,58402411,58402413,58402530,58402531,58402533,58402710,58402711,58402712,58402720,58402721,58402722,58403600,58403601,58403610,58410130,58410131,58410210,58410212,58410220,58410221,58410223,58410230,58410232,58410233,58411030,58411031,58411032,58411100,58411101,58411201,58412000,58412001,58412010,574054311,574054313,574054323,574054331,574054332,574054333,574055200,574055202,574055203,574055322,574064101,574064103,574064121,574064122,574064123,574064301,574064303,574064321,574064323,574066010,574066012,574066013,574066102,574066103,574066112,574066113,574067011,574067012,574067013,574067102,574067103,574067112,574067113,574074033,574074101,574074102,574074103,574074211,574074213,574074300,574074301,574074310,574074311,574074313,574074331,574074333,574150033,574150132,574150133,574150211,574150212,574150213,574150221,574150223,574151022,574161030,574161032,574161302,574161303,574161332,574172002,574172020,574172022,574172023,574172210,574172212,574172322,574172323,584004133,584004311,584005220,584005221,584005223,584014131,584014133,584014311,584014312,584014313,584015001,584024031,584024102,584024103,584024120,584024121,584025211,584025320,584025321,584027130,584027131,584027132,584027230,584027231,584027300,584027301,584027302,584035111,584035113,584036020,584036021,584036030,584036031,584036110,584036111,584036120,584101320,584101321,584101322,584101330,584101331,584102110,584102112,584102130,584102132,584102220,584102221,584102223,584102310,584102312,584102313,584103220,584103222,584111020,584111100,584112001,584112030,584112031,584112300,584113000,584113002,584113020,584113021,584120020,584120021,584120023,584120030,584120031,584120112,584120113,584120120,584120121,584120130,584120131,584121020,5740543123,5740543203,5740543212,5740543213,5740543221,5740543223,5740543301,5740543302,5740543303,5740550222,5740552012,5740552013,5740552120,5740552122,5740552123,5740552132,5740553202,5740553230,5740553232,5740553233,5740572323,5740572332,5740572333,5740573222,5740640313,5740640331,5740640333,5740641001,5740641002,5740641003,5740641021,5740641023,5740641201,5740641202,5740641203,5740643000,5740643001,5740643003,5740643021,5740643023,5740643201,5740643203,5740643221,5740643223,5740660110,5740660112,5740660113,5740661002,5740661003,5740661113,5740670002,5740670020,5740670022,5740670023,5740670031,5740670032,5740670033,5740670101,5740670102,5740670103,5740671000,5740671002,5740671003,5740671111,5740671112,5740671113,5740740131,5740740133,5740740311,5740740313,5740740323,5740741001,5740741002,5740741003,5740742101,5740742103,5740742121,5740743020,5740743021,5740743022,5740743030,5740743120,5740743121,5740743123,5741501220,5741501222,5741501223,5741501232,5741501233,5741502221,5741502222,5741502223,5741510230,5741510232,5741510233,5741510322,5741512100,5741512300,5741512302,5741512320,5741512322,5741610100,5741610102,5741610120,5741610122,5741610123,5741610332,5741610333,5741611322,5741613002,5741613003,5741613011,5741613012,5741613013,5741613100,5741613102,5741613120,5741613122,5741613300,5741613302,5741613332,5741613333,5741720000,5741720002,5741720003,5741720212,5741720213,5741720302,5741720320,5741720322,5741722112,5741722130,5741722132,5741722133,5741723022,5741723200,5741723202,5741723203,5741723212,5741723322,5840041110,5840041111,5840041113,5840041131,5840041311,5840041313,5840043130,5840043131,5840043133,5840043311,5840043313,5840052220,5840052221,5840052223,5840141303,5840141321,5840141323,5840143101,5840143102,5840143103,5840150001,5840150003,5840150022,5840150031,5840150032,5840150033,5840240113,5840240131,5840240133,5840240301,5840240303,5840240321,5840240323,5840240330,5840240332,5840241002,5840241003,5840241011,5840241012,5840241013,5840241230,5840241231,5840241233,5840243101,5840243110,5840243111,5840252000,5840252011,5840252100,5840252101,5840252103,5840252121,5840252130,5840252131,5840253221,5840253230,5840253231,5840272320,5840273030,5840273031,5840273032,5840273100,5840273200,5840273201,5840273202,5840351101,5840351103,5840351311,5840360321,5840360330,5840360331,5840361120,5840361121,5840361122,5840361130,5840361210,5840361211,5840361212,5840361220,5840361221,5840361222,5840370000,5840370001,5840370010,5840370011,5841013230,5841021110,5841021112,5841021130,5841021132,5841021310,5841021312,5841021330,5841021332,5841022220,5841022221,5841022223,5841023110,5841023112,5841032022,5841032023,5841032212,5841032230,5841032232,5841103300,5841103302,5841103320,5841103322,5841110210,5841110211,5841110220,5841110222,5841110300,5841110311,5841111020,5841111021,5841111022,5841112000,5841112002,5841112003,5841112020,5841112021,5841120030,5841120031,5841120033,5841120211,5841120213,5841120330,5841120331,5841123010,5841123011,5841123012,5841123020,5841123021,5841123022,5841123100,5841123101,5841123103,5841123110,5841123112,5841130010,5841130012,5841130030,5841130032,5841130033,5841130220,5841130221,5841200220,5841200221,5841200320,5841200321,5841200330,5841200331,5841200333,5841201100,5841201102,5841201103,5841201112,5841201113,5841201220,5841201221,5841201222,5841201230,5841201231,5841201233,5841201320,5841201321,5841201322,5841201330,5841201331,5841210022,5841210220,5841210221,57405413231,57405413233,57405413322,57405413323,57405413332,57405413333,57405431011,57405431013,57405431031,57405431033,57405431211,57405431212,57405431213,57405432113,57405432221,57405432223,57405433002,57405433003,57405502202,57405502203,57405502232,57405502233,57405502322,57405520100,57405520102,57405520103,57405520112,57405520113,57405521022,57405521210,57405521212,57405532000,57405532002,57405532032,57405532033,57405532122,57405532123,57405532312,57405532313,57405533202,57405533220,57405533222,57405533223,57405533232,57405533233,57405533322,57405533323,57405533332,57405533333,57405622222,57405622223,57405622232,57405622233,57405622322,57405622323,57405622332,57405622333,57405623222,57405623223,57405623232,57405623233,57405623322,57405623323,57405623332,57405723123,57405723132,57405723212,57405723213,57405723301,57405723302,57405723303,57405723310,57405723312,57405723313,57405732202,57405732203,57405732232,57405733332,57405733333,57406403112,57406403113,57406410001,57406410003,57406410201,57406410203,57406410221,57406410223,57406412001,57406412002,57406412003,57406421110,57406421111,57406430021,57406430023,57406430201,57406430203,57406430221,57406430223,57406601110,57406601112,57406601113,57406610002,57406610003,57406610012,57406610013,57406610102,57406610120,57406610122,57406610123,57406610132,57406610133,57406611022,57406611023,57406611032,57406611033,57406611112,57406611113,57406611122,57406611123,57406700002,57406700003,57406700113,57406700131,57406700133,57406700210,57406700212,57406701002,57406701003,57406710010,57406710012,57406710013,57406710102,57406710120,57406710122,57406710123,57406710132,57406710133,57406711013,57406711022,57406711023,57406711031,57406711032,57406711033,57406711102,57406711103,57407401132,57407401133,57407403101,57407403103,57407403121,57407403123,57407403211,57407403213,57407410001,57407410002,57407410003,57407421230,57407421231,57407421233,57407423011,57407423100,57407423101,57407423110,57407423111,57407430230,57407432000,57407432001,57407433010,57407433011,57407433013,57407433031,57407433033,57407433211,57407433213,57407433231,57415003121,57415003123,57415003211,57415003213,57415003231,57415003233,57415012210,57415012212,57415012213,57415012302,57415012303,57415012311,57415012312,57415012313,57415013031,57415013033,57415013120,57415013122,57415020311,57415020313,57415020331,57415020333,57415021011,57415021013,57415021022,57415021023,57415021031,57415021032,57415021033,57415022011,57415022013,57415022023,57415022031,57415022032,57415022033,57415022201,57415022202,57415022203,57415102312,57415102313,57415103202,57415103203,57415103212,57415121020,57415121021,57415123032,57416101210,57416101212,57416101320,57416101322,57416103100,57416103102,57416103120,57416103122,57416103300,57416103302,57416103303,57416103312,57416103313,57416112222,57416112323,57416112332,57416112333,57416113202,57416113203,57416130000,57416130002,57416130003,57416130012,57416130013,57416130101,57416130102,57416130103,57416131012,57416131030,57416131032,57416131210,57416131212,57416131230,57416131232,57416133010,57416133012,57416133030,57416133032,57416133033,57416133122,57416133300,57416133302,57416133303,57416133312,57416133313,57416222222,57416222223,57417200012,57417200013,57417202100,57417202102,57417202103,57417202112,57417202113,57417203001,57417203002,57417203003,57417203010,57417203012,57417203030,57417203032,57417203210,57417203212,57417203230,57417203232,57417221100,57417221102,57417221310,57417221312,57417232012,57417232013,57417232102,57417232103,57417232112,57417232130,57417232132,57417232133,57417233202,57417233203,57417233232,58400411331,58400411333,58400413211,58400413213,58400413231,58400413233,58400431011,58400431013,58400431031,58400431033,58400431211,58400431320,58400431321,58400433311,58400433313,58400522221,58400522223,58401411331,58401411333,58401431002,58401431003,58401432133,58401432311,58401432313,58401432323,58401432331,58401432332,58401432333,58401500001,58401500003,58401500210,58401500211,58401500230,58401500232,58401500300,58401500301,58401500303,58402403310,58402403311,58402410012,58402410013,58402410101,58402410102,58402410103,58402412200,58402412201,58402412210,58402412211,58402412213,58402412231,58402412320,58402412321,58402421010,58402421011,58402421013,58402421100,58402421102,58402431001,58402431003,58402431121,58402431123,58402431130,58402431132,58402521021,58402521023,58402521321,58402521330,58402521331,58402521333,58402523111,58402532200,58402532201,58402532230,58402532231,58402532320,58402532321,58402532330,58402532331,58402532333,58402713300,58402713301,58402713310,58402713311,58402723210,58402723211,58402723220,58402723221,58402723222,58402723300,58402723301,58402723310,58402723311,58402723312,58402723330,58402730330,58402731020,58402731022,58402731200,58402731202,58402732030,58402732031,58402732100,58402732101,58402732102,58402732120,58402732200,58402732201,58403511001,58403511003,58403513100,58403513101,58403513103,58403513121,58403513130,58403513131,58403602200,58403602201,58403602210,58403602211,58403602300,58403602301,58403602310,58403602311,58403603200,58403603201,58403603203,58403611230,58403611231,58403611232,58403611310,58403611312,58403611320,58403612130,58403612131,58403612230,58403612232,58403612300,58403612301,58403612302,58403613000,58403613001,58403613010,58403701000,58403701002,58410132310,58410132311,58410132312,58410132320,58410132321,58410132322,58410132330,58410133200,58410133201,58410133210,58410133211,58410133300,58410133301,58410133310,58410133311,58410133313,58410133331,58410211130,58410211132,58410211310,58410211312,58410222220,58410222221,58410222223,58410320200,58410320202,58410320203,58410320212,58410320213,58410322102,58410322103,58410322112,58410322130,58410322132,58410322310,58410322312,58410322330,58410322332,58411033010,58411033011,58411033100,58411033101,58411033110,58411033111,58411102120,58411102121,58411102130,58411102210,58411102211,58411102212,58411102230,58411102232,58411110100,58411110230,58411110232,58411120010,58411120012,58411120220,58411120222,58411200001,58411200010,58411200011,58411200013,58411200031,58411200033,58411200211,58411200213,58411200321,58411200323,58411202101,58411202103,58411202121,58411202310,58411202311,58411202312,58411202330,58411203200,58411203201,58411203210,58411203211,58411203213,58411203231,58411203320,58411203321,58411203330,58411203331,58411230130,58411230132,58411230300,58411230302,58411231021,58411231023,58411231110,58411231111,58411231112,58411231130,58411231132,58411232000,58411300110,58411300112,58411300130,58411300132,58411300310,58411300312,58411300313,58411301222,58411302220,58411302221,58411302222,58411302230,58411302231,58411302300,58411302301,58411302302,58411302310,58411302311,58411302320,58411303000,58411303002,58411303020,58411320000,58412002220,58412002221,58412002230,58412002231,58412003220,58412003221,58412003222,58412003230,58412003231,58412003320,58412003321,58412012230,58412012231,58412012232,58412012320,58412012321,58412012323,58412013230,58412013231,58412013320,58412013321,58412013330,58412013331,58412100020,58412100022,58412100200,58412100202,58412100203,58412100212,58412100230,58412100232,58412100233,58412102102,58412102103,58412102120,58412102121,58412102220,58412102221,58412102230,58412102231,
022,00,,502650000,135843750,505040625,137793750,15,18,32,115,253,465,563966,563967,563976,563977,564060,564061,564070,564071,573906,573907,573916,573917,574000,574001,574010,5639653,5639751,5639753,5640502,5640503,5640512,5640513,5739051,5739053,5739153,5739261,5739270,5740110,5740112,5740200,5740201,5740203,5740210,56395733,56396512,56396513,56396521,56396523,56397501,56397503,56397521,56397523,56405002,56405012,56405013,56405102,56405103,56405112,56405113,57390501,57391510,57391511,57391513,57392511,57392600,57392601,57392710,57392712,57392720,57392721,57392722,57401110,57402021,57402120,57402122,563956233,563956320,563956322,563956323,563957131,563957133,563957221,563957222,563957223,563957232,563957311,563957313,563957323,563965031,563965032,563965033,563965111,563965113,563965201,563965203,563965221,563965222,563965223,563975001,563975003,563975021,563975023,563975201,563975203,563975221,564040333,564050032,564050033,564050103,564050111,564050112,564050113,564051000,564051002,564051003,564051012,564051013,564051102,564051103,564051110,564051112,564052022,564052200,564052202,564072000,564072002,564072020,564072022,564072200,564072202,564072220,564072222,573905030,573905031,573905033,573905233,573915011,573915121,573915122,573915123,573925100,573925101,573925103,573925121,573925130,573925131,573926021,573926031,573926301,573926310,573926311,573926313,573927110,573927111,573927230,573927231,573927232,573937000,573937001,573937003,573937010,573937012,574002000,574002002,574002020,574002022,574002200,574002202,574002220,574011110,574011120,574011302,574011320,574011322,574020200,574020201,574020203,574020221,574020230,574020231,574020233,574021100,574021102,574021120,574021122,574021210,574021211,574021212,574021230,574030100,5639553333,5639562222,5639562223,5639562232,5639562313,5639563212,5639563213,5639563320,5639563322,5639563323,5639563332,5639563333,5639571133,5639571303,5639571321,5639571323,5639572201,5639572202,5639572203,5639572302,5639572303,5639572332,5639573101,5639573103,5639573121,5639573122,5639573123,5639573212,5639573213,5639573223,5639650132,5639650133,5639650231,5639650232,5639650233,5639650301,5639650302,5639650303,5639651022,5639651123,5639652003,5639652021,5639652022,5639652023,5639652201,5639652202,5639652203,5639750000,5639750001,5639750003,5639750021,5639752230,5639752231,5640403323,5640412202,5640412220,5640412222,5640412223,5640500022,5640500023,5640500300,5640500302,5640500303,5640501101,5640501103,5640510012,5640510013,5640511003,5640511011,5640511012,5640511013,5640511130,5640511132,5640511133,5640520022,5640520200,5640520202,5640520230,5640520232,5640522010,5640522012,5640522030,5640522031,5640522032,5640522200,5640522201,5640522202,5640522220,5640522222,5640620000,5640620002,5640620020,5640620022,5640620200,5640620202,5640620220,5640620221,5640620222,5640622000,5640622002,5640622020,5640622021,5640622022,5640622200,5640622202,5640622220,5640622222,5640720012,5640720030,5640720032,5640720210,5640720212,5640720230,5640720232,5640722030,5640722032,5640722210,5640722212,5640722230,5640722232,5739050320,5739050321,5739050323,5739052111,5739052113,5739052313,5739150131,5739150133,5739150311,5739151200,5739151201,5739151203,5739152313,5739152331,5739152333,5739250111,5739250113,5739251021,5739251023,5739251230,5739251231,5739251233,5739251320,5739251321,5739251322,5739251330,5739260200,5739260201,5739260300,5739260301,5739260303,5739260330,5739260331,5739260333,5739263000,5739263001,5739263120,5739263121,5739263311,5739263313,5739263331,5739263333,5739271120,5739271121,5739271122,5739271130,5739271131,5739271133,5739271300,5739271311,5739271312,5739271313,5739271331,5739271333,5739273000,5739273002,5739273003,5739273020,5739273022,5739273111,5739273200,5739370021,5739370112,5739370211,5739370300,5740020010,5740020012,5740020013,5740020030,5740020032,5740020210,5740020212,5740020230,5740020232,5740022010,5740022012,5740022030,5740022032,5740022220,5740111110,5740111112,5740111113,5740111120,5740111121,5740111130,5740111210,5740111211,5740111212,5740111220,5740111221,5740113002,5740113003,5740113012,5740113030,5740113031,5740113032,5740113210,5740113212,5740113230,5740113232,5740202020,5740202021,5740202023,5740202201,5740202203,5740202230,5740202231,5740202233,5740202320,5740202321,5740202322,5740211010,5740211012,5740211030,5740212130,5740212132,5740212310,5740212312,5740212320,5740212321,5740213000,5740213001,5740300110,5740300111,5740300113,5740301010,5740301012,5740301020,5740301021,5740301111,5740310000,5740310001,5740310010,56395533311,56395533313,56395533322,56395533323,56395621331,56395621333,56395622200,56395622202,56395622332,56395622333,56395623111,56395623113,56395623222,56395623223,56395623231,56395623232,56395623233,56395630220,56395630222,56395633311,56395633313,56395711303,56395711312,56395711313,56395711321,56395711323,56395713223,56395723011,56395723013,56395723332,56395723333,56395731001,56395731002,56395731003,56395731021,56395731023,56395731201,56395731203,56395732031,56395732033,56395732211,56395732213,56395732222,56395732223,56396501223,56396501232,56396501233,56396501301,56396501302,56396501303,56396502113,56396502131,56396502133,56396503001,56396503002,56396503003,56396510230,56396510232,56396511013,56396511031,56396511033,56396511211,56396511212,56396511213,56396520011,56396520013,56396520021,56396520023,56396520201,56396520202,56396520203,56396522001,56396522002,56396522003,56397500020,56397500021,56397500023,56397500201,56397500203,56397500231,56397500233,56397502011,56397502013,56397502031,56397502033,56397502211,56397502213,56397502231,56397520013,56397520031,56397520033,56397520211,56397520213,56397520233,56397522011,56397522013,56397522031,56397522320,56397522321,56397522330,56397522331,56397522333,56404033131,56404033133,56404122210,56404122212,56404122320,56404122322,56405000202,56405000203,56405000212,56405000213,56405000302,56405000320,56405000322,56405000323,56405000332,56405000333,56405001222,56405003010,56405003012,56405010033,56405010122,56405010123,56405010132,56405010133,56405010211,56405010213,56405010231,56405010232,56405010233,56405011003,56405011021,56405011022,56405011023,56405100100,56405100102,56405100103,56405100112,56405100113,56405101022,56405101023,56405101032,56405101033,56405101122,56405101123,56405101132,56405101133,56405110003,56405110012,56405110013,56405110021,56405110022,56405110023,56405110102,56405110103,56405111100,56405111102,56405111120,56405111122,56405111123,56405111132,56405111310,56405111312,56405111313,56405200202,56405200203,56405202010,56405202012,56405202030,56405202032,56405202332,56405220110,56405220112,56405220130,56405220132,56405220133,56405220330,56405220331,56405220332,56405221022,56405221023,56405221200,56405221201,56405221202,56405221220,56405222030,56405222031,56405222032,56405222100,56405222101,56405222110,56405222210,56405222212,56405222230,56405222232,56406200010,56406200012,56406200030,56406200032,56406200210,56406200212,56406200230,56406200232,56406202010,56406202012,56406202030,56406202032,56406202230,56406202232,56406220010,56406220012,56406220030,56406220032,56406220230,56406220231,56406220232,56406222010,56406222012,56406222030,56406222032,56406222210,56406222212,56406222230,56406222232,56406222233,56407200102,56407200103,56407200310,56407200312,56407200330,56407200332,56407202110,56407220330,56407222332,57390500111,57390500113,57390500131,57390500133,57390500311,57390500313,57390500331,57390500333,57390502111,57390502113,57390502131,57390502133,57390502311,57390502313,57390502331,57390503220,57390503221,57390523121,57390523123,57391501301,57391501303,57391501321,57391501323,57391503101,57391503130,57391503131,57391512020,57391512021,57391512023,57392510200,57392510201,57392510203,57392510221,57392510223,57392512001,57392512010,57392512011,57392512013,57392512031,57392512033,57392512211,57392512213,57392513230,57392513232,57392513310,57392513312,57392602020,57392602021,57392602022,57392602030,57392602031,57392602033,57392603020,57392603021,57392603022,57392603211,57392603213,57392603321,57392603323,57392630021,57392630030,57392630031,57392630300,57392630301,57392630310,57392630311,57392630313,57392630331,57392631220,57392631221,57392631230,57392631231,57392631233,57392633011,57392633100,57392633101,57392633103,57392633121,57392633123,57392633301,57392633303,57392711230,57392711231,57392711320,57392711321,57392713020,57392713021,57392723300,57392723302,57392723320,57392723322,57392730010,57392730012,57392730120,57392730122,57392730210,57392730211,57392730212,57392730230,57392730232,57392730300,57392731131,57392731133,57392731311,57392731313,57392731331,57392732010,57393611111,57393611113,57393611131,57393611133,57393611311,57393700200,57393700201,57393700230,57393700231,57393701100,57393701102,57393701130,57393701132,57393701300,57393701301,57393701302,57393701310,57393701320,57393702100,57393702101,57393702103,57393703010,57393703011,57393703012,57400200110,57400200112,57400200113,57400200310,57400200311,57400200312,57400200330,57400200332,57400201002,57400201020,57400201022,57400201200,57400202332,57400220110,57400220112,57400220130,57400220330,57400220332,57400222100,57400222101,57400222102,57400222110,57400222120,57400222122,57400222210,57400222211,57400222212,57400222220,57400222221,57400222230,57400222300,57401111112,57401111113,57401112130,57401112131,57401112220,57401112222,57401112300,57401112301,57401130000,57401130002,57401130003,57401130012,57401130013,57401130102,57401130103,57401130132,57401130330,57401130331,57401130332,57401132110,57401132130,57401132132,57401132310,57401132312,57401132330,57401132332,57402020220,57402020221,57402023231,57402023233,57402110320,57402110321,57402121310,57402121311,57402123220,57402123222,57402130020,57402130021,57402130022,57402130030,57402130200,57403001120,57403001121,57403001310,57403001311,57403001313,57403001331,57403010110,57403010112,57403010220,57403010221,57403010230,57403010231,57403010300,57403010301,57403011011,57403011013,57403011100,57403011102,57403011131,57403100020,57403100021,57403100030,57403100031,57403100110,57403100112,57403100120,57403100121,
023,00,,503535937,137006250,506193750,139387500,12,23,71,110,284,514,574012,574022,574032,574040,574041,574042,574043,574051,574052,574053,574063,574073,5739371,5739373,5739471,5739473,5739571,5739573,5740230,5740232,5740302,5740303,5740311,5740312,5740313,5740330,5740332,5740500,5740501,5740540,5740542,5740620,5740621,5740623,5740721,57392733,57393721,57393723,57394701,57396711,57400223,57400232,57400233,57401113,57401131,57401133,57401300,57401302,57401320,57401322,57401323,57402111,57402113,57402131,57402132,57402133,57402310,57402312,57403000,57403002,57403003,57403012,57403013,57403101,57403102,57403103,57403310,57403312,57403330,57403332,57403333,57404420,57404422,57404423,57405020,57405021,57405022,57405030,57405031,57405032,57405430,57406000,57406101,57406110,57406111,57406113,57406220,57406221,57406223,57406400,57406401,57406402,57407231,57407233,57407400,57407402,57407420,57407422,58400301,58400310,58400311,58400312,58400400,57406420,57406422,57406423,573927132,573927310,573927312,573927321,573927322,573927323,573937031,573937032,573937033,573937201,573937202,573937203,573937221,573937223,573947031,573947033,573947211,573947213,573947231,573947233,573967101,573967131,574003222,574013210,574013212,574013213,574013322,574020222,574021121,574021123,574021233,574021301,574021303,574023300,574023301,574023302,574023320,574023322,574023323,574030010,574030012,574030112,574030113,574031002,574031003,574033132,574033310,574033312,574034220,574034222,574044000,574044002,574044020,574044022,574044023,574044210,574044212,574044213,574050230,574050231,574050232,574050330,574050331,574050332,574054102,574054120,574054122,574054123,574060010,574060012,574060020,574060021,574060023,574060030,574060101,574061001,574061031,574061120,574061121,574061311,574061313,574062220,574062221,574062223,574064030,574064032,574072010,574072011,574072013,574072300,574072301,574072303,574072321,574072323,574074030,574074232,584002101,584002110,584002111,584003000,584003001,584003003,584003030,584003031,584004010,574074010,574074012,574064210,574064212,574064213,5739271301,5739271303,5739271310,5739271330,5739271332,5739272331,5739272333,5739273010,5739273011,5739273013,5739273031,5739273032,5739273033,5739273110,5739273112,5739273130,5739273132,5739273202,5739273203,5739370111,5739370133,5739370213,5739370231,5739370233,5739370302,5739370303,5739372001,5739372003,5739372200,5739372201,5739372203,5739372221,5739470300,5739470301,5739470303,5739470321,5739470322,5739470323,5739472100,5739472101,5739472103,5739472303,5739472321,5739472323,5739570110,5739570111,5739570113,5739570131,5739570133,5739570311,5739570313,5739570330,5739570331,5739570333,5739572110,5739572111,5739572113,5739572131,5739572132,5739572133,5739572311,5739572331,5739572333,5739671000,5739671001,5739671003,5739671030,5739671031,5739671300,5739671301,5739671331,5740022133,5740022213,5740022231,5740022232,5740022233,5740023022,5740023023,5740023032,5740023033,5740023122,5740023123,5740023132,5740023133,5740032230,5740032232,5740032233,5740111122,5740111123,5740111131,5740111132,5740111133,5740111223,5740111231,5740111232,5740111233,5740113011,5740130100,5740130102,5740130120,5740130122,5740130300,5740130302,5740130320,5740130322,5740130323,5740132110,5740132112,5740132113,5740133200,5740133202,5740133230,5740133232,5740202200,5740202202,5740202232,5740211011,5740211013,5740211031,5740211033,5740212133,5740212311,5740212313,5740212323,5740213021,5740213022,5740213023,5740231120,5740231122,5740231300,5740233030,5740233031,5740233032,5740233210,5740233212,5740233213,5740300130,5740300132,5740301013,5740301031,5740301032,5740301033,5740301100,5740301102,5740301103,5740301112,5740310013,5740331302,5740331303,5740331312,5740331330,5740331332,5740333110,5740333112,5740333130,5740333132,5740333133,5740342212,5740440210,5740440212,5740440213,5740440320,5740440322,5740440323,5740442112,5740442113,5740443022,5740443200,5740443202,5740443220,5740443222,5740502330,5740502331,5740502333,5740503330,5740503331,5740541000,5740541002,5740541003,5740541212,5740541213,5740541302,5740543120,5740543122,5740543210,5740543220,5740600220,5740600221,5740600223,5740600320,5740600322,5740601001,5740601100,5740601101,5740601102,5740602011,5740610000,5740610001,5740610031,5740610033,5740610300,5740610301,5740611231,5740611233,5740613100,5740613101,5740613103,5740613311,5740622221,5740640310,5740640312,5740640330,5740640332,5740643220,5740643222,5740720011,5740720013,5740720120,5740720121,5740720123,5740720310,5740720311,5740720313,5740720331,5740720333,5740722111,5740722113,5740722131,5740723020,5740723021,5740723023,5740723201,5740723203,5740723221,5740723223,5740742100,5740742102,5740742120,5740742122,5840021001,5840021003,5840021120,5840021121,5840021123,5840021130,5840021131,5840030020,5840030021,5840030023,5840030210,5840030211,5840030213,5840030331,5840031300,5840031301,5840031302,5840033001,5840033010,5840040120,5840040200,5840040211,5740742300,5740742302,5740742303,5740740320,5740740322,5740740130,5740740132,5740643200,5740643202,5740740110,5740740111,5740740112,5740642110,5740642112,5740642113,5740543200,5740543201,5740543202,5740541320,5740541321,5740541322,5740543100,5740543102,57392711232,57392711233,57392711322,57392711323,57392713022,57392713023,57392723301,57392723303,57392723321,57392723323,57392730011,57392730013,57392730121,57392730123,57392730213,57392730231,57392730233,57392730301,57392730302,57392730303,57392731130,57392731132,57392731310,57392731312,57392731330,57392731332,57392731333,57392732011,57392732012,57392732013,57393631311,57393631313,57393631331,57393631333,57393633111,57393633113,57393701101,57393701103,57393701131,57393701133,57393701303,57393701311,57393701312,57393701313,57393701321,57393701322,57393701323,57393702121,57393702123,57393702301,57393702303,57393702321,57393702322,57393702323,57393703013,57393720021,57393720023,57393722021,57393722023,57393722201,57393722203,57394700101,57394700110,57394700111,57394700113,57394700131,57394700133,57394700311,57394700313,57394700331,57394721020,57394721021,57394721210,57394721211,57394721213,57394721231,57394721233,57394723011,57394723012,57394723013,57395701010,57395701011,57395701120,57395701121,57395703122,57395703123,57395703320,57395703321,57395721120,57395721121,57395721302,57395721303,57395723131,57395723133,57396701110,57396701111,57396701113,57396701131,57396710020,57396710021,57396710331,57396710333,57396713031,57396713300,57396713301,57396713330,57396713331,57400220333,57400221222,57400221223,57400221232,57400221233,57400221321,57400221322,57400221323,57400222103,57400222111,57400222112,57400222113,57400222121,57400222123,57400222213,57400222222,57400222223,57400222231,57400222232,57400222233,57400222301,57400222302,57400222303,57400320222,57400322000,57400322002,57400322020,57400322022,57400322023,57400322032,57400322033,57400322122,57400322123,57400322132,57400322310,57400322312,57400322313,57400323202,57400323220,57400323222,57400323223,57400323232,57401111110,57401111111,57401112132,57401112133,57401112221,57401112223,57401112302,57401112303,57401130001,57401130010,57401130011,57401130100,57401130101,57401130130,57401130131,57401130133,57401130333,57401132111,57401132112,57401132113,57401132131,57401132133,57401132311,57401132313,57401132331,57401132333,57401301010,57401301012,57401301030,57401301232,57401303010,57401303012,57401303030,57401303032,57401303033,57401303122,57401303210,57401303212,57401303320,57401303322,57401330020,57401330022,57401330200,57401330202,57401330220,57401330222,57401330223,57401330232,57401332010,57401332012,57401332030,57401332032,57401332033,57401332122,57401332123,57401332312,57401332330,57401332332,57402020222,57402020223,57402023230,57402023232,57402110322,57402110323,57402121312,57402121313,57402123221,57402123223,57402130023,57402130031,57402130032,57402130033,57402130201,57402130202,57402130203,57402313020,57402313021,57402330330,57402330332,57402332110,57402332112,57403001122,57403001123,57403001312,57403001330,57403001332,57403001333,57403010111,57403010113,57403010222,57403010223,57403010232,57403010233,57403010302,57403010303,57403011010,57403011012,57403011101,57403011103,57403011130,57403011132,57403011133,57403100022,57403100023,57403100032,57403100033,57403100111,57403100113,57403100122,57403100123,57403313002,57403313003,57403313012,57403313013,57403313102,57403331312,57403331313,57403420202,57403420220,57403420222,57403422100,57403422102,57403422130,57403422132,57403422300,57403422301,57403422302,57403422310,57403422320,57403422322,57404400100,57404400102,57404400120,57404400122,57404400300,57404400302,57404400320,57404400322,57404402110,57404402112,57404403210,57404403212,57404403320,57404403322,57404421100,57404421102,57404421103,57404421112,57404421113,57404430002,57404430020,57404430022,57404430200,57404430202,57404430203,57405023320,57405023321,57405023322,57405033320,57405033321,57405033322,57405033330,57405033331,57405033333,57405410012,57405410013,57405412100,57405412102,57405413030,57405413032,57406001100,57406001110,57406001111,57406002220,57406002221,57406002223,57406003210,57406003211,57406010000,57406010001,57406010003,57406010021,57406010030,57406010031,57406010033,57406011030,57406011031,57406011100,57406011111,57406011113,57406011131,57406020001,57406020010,57406020011,57406020100,57406020101,57406020103,57406021000,57406021001,57406021002,57406100020,57406100021,57406100030,57406100031,57406100033,57406100301,57406100303,57406103021,57406103030,57406103031,57406103033,57406103211,57406103300,57406103301,57406103310,57406103311,57406112200,57406112201,57406112210,57406112211,57406112300,57406112301,57406130110,57406130111,57406130113,57406133100,57406133101,57406133103,57406133121,57406133130,57406133131,57406222231,57406412000,57407200101,57407200103,57407200311,57407200313,57407200331,57407201220,57407201221,57407201223,57407203011,57407203121,57407203301,57407203303,57407203321,57407203323,57407221101,57407221103,57407221121,57407221123,57407221301,57407230220,57407230221,57407230223,57407423102,57407423120,57407423122,57407423300,57407423301,57407423302,57407423320,57407423322,58400210001,58400210003,58400210021,58400210023,58400210210,58400210211,58400210300,58400210301,58400210310,58400210311,58400211320,58400211321,58400300221,58400302010,58400302011,58400302013,58400302121,58400302123,58400302310,58400302311,58400303200,58400303201,58400303210,58400303211,58400303212,58400303301,58400303331,58400313100,58400313101,58400313102,58400313110,58400313111,58400313113,58400313131,58400313200,58400313201,58400330000,58400330001,58400330110,58400330112,58400330120,58400330121,58400330123,58400330130,58400330132,58400401100,58400401102,58400401210,58400401211,58400401212,58400401220,58400401221,58400401222,58400402010,58400402011,58400402012,58400402020,58400402021,58400402030,57407423010,57407423012,57407423013,57407421232,57407403210,57407403212,57407403120,57407403122,57407403100,57407403102,57407401130,57407401131,57407410000,57406430220,57406430222,57406430200,57406430202,57406430020,57406430022,57406421112,57406421113,57406403110,57406403111,57406410220,57406410222,57406410200,57406410202,57406410000,57406410002,57405432220,57405432222,57405432110,57405432111,57405432112,57405433000,57405433001,57405431210,57405413230,57405413232,57405431010,57405431012,57405431030,57405431032,
024,00,,504084375,138590625,506320312,140578125,6,23,47,101,251,479,574071,584001,584011,584012,584013,584022,5740612,5840001,5840003,5840020,5840022,5840023,5840032,5840042,5840101,5840140,5840142,5840210,5840211,5840213,5840230,5840231,5840232,5840311,5840313,5840320,5840321,5840322,5840330,57406013,57406102,57406132,57407031,57407032,57407033,57407202,57407220,57407222,57407223,58400212,58400213,58400331,58400332,58400333,58400403,58400410,58400412,58400430,58400432,58401031,58401410,58401412,58401430,58402120,58402121,58402123,58402330,58402400,58402402,58403100,58403101,58403103,58403121,58403122,58403123,58403230,58403231,58403232,58403320,58403321,58404100,58404101,58404103,58404110,58404111,58404200,574060013,574060102,574060103,574060112,574060113,574060120,574060121,574060123,574060301,574060310,574060311,574060313,574060331,574060333,574061002,574061300,574061302,574061303,574061312,574061330,574061332,574061333,574070111,574070113,574070131,574070132,574070133,574070233,574070303,574072000,574072002,574072032,574072210,574072212,574074321,574074322,574074323,584000011,584000013,584000031,584000033,584000213,584000231,584000233,584003022,584003133,584003302,584003303,584004013,584004022,584004023,584004110,584004112,584004130,584004330,584004332,584010011,584010012,584010013,584010031,584010301,584010303,584014110,584014111,584014112,584014320,584014322,584020111,584020112,584020113,584020130,584020131,584021220,584021221,584021223,584023310,584023311,584023312,584023320,584023321,584023322,584024010,584024012,584024200,584024201,584030331,584031020,584031021,584031023,584032330,584032331,584032332,584033100,584041020,584041021,584041023,584042010,584042011,584042100,584042101,584042110,5740600112,5740600113,5740600310,5740600311,5740600313,5740601112,5740601221,5740601223,5740603031,5740603120,5740603121,5740603123,5740603301,5740610032,5740610320,5740610322,5740610323,5740610332,5740610333,5740611222,5740611223,5740611232,5740613010,5740613012,5740613013,5740613102,5740622220,5740622222,5740702312,5740702313,5740703003,5740703011,5740703012,5740703013,5740703021,5740703022,5740703023,5740720012,5740720030,5740720032,5740720300,5740720302,5740720303,5740722132,5740722133,5740723200,5740723202,5740723220,5740723222,5740742313,5740742331,5740742333,5740743031,5740743032,5740743033,5740743122,5740743201,5740743202,5740743203,5740743300,5740743302,5740743320,5740743322,5840000101,5840000102,5840000103,5840000120,5840000121,5840000303,5840002110,5840002111,5840002113,5840002321,5840002322,5840002323,5840021020,5840021022,5840021023,5840021032,5840021033,5840021122,5840021133,5840030200,5840030202,5840030203,5840030230,5840030232,5840030233,5840030322,5840030323,5840030332,5840031303,5840031312,5840031321,5840031322,5840031323,5840033002,5840033003,5840040111,5840040112,5840040113,5840040123,5840040210,5840040212,5840040213,5840041112,5840041130,5840041132,5840041310,5840041312,5840041320,5840041322,5840043100,5840043102,5840043120,5840043122,5840043123,5840043310,5840043312,5840043330,5840043332,5840043333,5840100031,5840100033,5840100101,5840100103,5840100300,5840100301,5840100330,5840100331,5840100333,5840103001,5840103211,5840103300,5840103301,5840103310,5840103311,5840103313,5840103331,5840103333,5840141130,5840141131,5840141132,5840141300,5840141301,5840141302,5840141320,5840141322,5840143210,5840143211,5840143212,5840143230,5840150002,5840150020,5840201013,5840201031,5840201033,5840201101,5840201102,5840201103,5840201211,5840201321,5840201330,5840201331,5840201333,5840203111,5840203113,5840203131,5840203133,5840212221,5840212222,5840212223,5840233130,5840233131,5840233132,5840233230,5840233232,5840233300,5840233301,5840233302,5840240110,5840240111,5840240112,5840240130,5840240132,5840240300,5840240302,5840240320,5840240322,5840241000,5840242020,5840242021,5840242030,5840242031,5840242100,5840242102,5840242120,5840303330,5840303331,5840303333,5840312010,5840312011,5840312013,5840312022,5840312023,5840312031,5840312032,5840312033,5840323330,5840323331,5840323332,5840331010,5840331012,5840331020,5840331021,5840331022,5840331200,5840331202,5840331220,5840331222,5840332200,5840332201,5840332210,5840332211,5840332300,5840332310,5840333000,5840333002,5840401131,5840401133,5840401311,5840410221,5840410223,5840411200,5840411201,5840411202,5840411210,5840411211,5840411220,5840411222,5840412010,5840412101,5840412110,5840412111,5840413000,5840420120,5840421030,5840421031,5840421032,5840421120,5840421121,57405023323,57405033323,57405033332,57406001101,57406001102,57406001103,57406001112,57406001113,57406003120,57406003121,57406003310,57406003311,57406010002,57406010020,57406010022,57406010023,57406010032,57406011032,57406011033,57406011101,57406011102,57406011103,57406011110,57406011112,57406011130,57406011132,57406011133,57406012200,57406012201,57406012203,57406012221,57406030010,57406030011,57406030013,57406030031,57406030033,57406030301,57406030303,57406031221,57406031223,57406033001,57406033003,57406033021,57406033030,57406033031,57406033033,57406033211,57406100022,57406100023,57406100032,57406100300,57406100302,57406103020,57406103022,57406103023,57406103032,57406103210,57406103212,57406103213,57406103302,57406103303,57406103312,57406103313,57406112202,57406112203,57406112212,57406112213,57406112302,57406112303,57406130112,57406133102,57406133120,57406133122,57406133123,57406133132,57406133133,57406222230,57406222232,57406222233,57407011013,57407011031,57407011033,57407011211,57407011213,57407011231,57407011233,57407012323,57407012332,57407012333,57407013011,57407021313,57407021331,57407021333,57407023031,57407023033,57407023111,57407023113,57407023211,57407023213,57407023223,57407023231,57407023232,57407023233,57407030012,57407030013,57407030023,57407030101,57407030102,57407030103,57407030201,57407030202,57407030203,57407200100,57407200102,57407200310,57407200312,57407200330,57407200332,57407200333,57407201222,57407203010,57407203012,57407203013,57407203120,57407203122,57407203123,57407203300,57407203302,57407203320,57407203322,57407221100,57407221102,57407221120,57407221122,57407221300,57407221302,57407221303,57407230222,57407423103,57407423112,57407423113,57407423121,57407423123,57407423303,57407423321,57407423323,57407430231,57407430232,57407430233,57407432002,57407432003,57407433012,57407433030,57407433032,57407433210,57407433212,57407433230,57407433232,57407433233,58400001001,58400001002,58400001003,58400001231,58400001233,58400003011,58400003013,58400003021,58400003023,58400003201,58400003210,58400003211,58400003213,58400023011,58400023013,58400023023,58400023031,58400023032,58400023033,58400023201,58400023202,58400023203,58400210000,58400210002,58400210020,58400210022,58400210212,58400210213,58400210302,58400210303,58400210312,58400210313,58400211322,58400211323,58400300220,58400300222,58400300223,58400302012,58400302120,58400302122,58400302312,58400302313,58400303202,58400303203,58400303213,58400303300,58400303302,58400303303,58400303330,58400303332,58400303333,58400313103,58400313112,58400313130,58400313132,58400313133,58400313202,58400313203,58400330002,58400330003,58400330111,58400330113,58400330122,58400330131,58400330133,58400401101,58400401103,58400401213,58400401223,58400402013,58400402022,58400402023,58400402031,58400402032,58400402033,58400411330,58400411332,58400413210,58400413212,58400413230,58400413232,58400431010,58400431012,58400431030,58400431032,58400431210,58400431212,58400431213,58400431322,58400431323,58400433310,58400433312,58400522220,58400522222,58401001001,58401001003,58401001021,58401001022,58401001023,58401002110,58401002111,58401003020,58401003021,58401003030,58401003031,58401003033,58401030031,58401030033,58401030211,58401030213,58401030231,58401030233,58401032011,58401032100,58401032101,58401032103,58401033223,58401033232,58401033233,58401033322,58401033323,58401411330,58401411332,58401431000,58401431001,58401432130,58401432131,58401432132,58401432310,58401432312,58401432320,58401432321,58401432322,58401432330,58401500000,58401500002,58401500212,58401500213,58401500231,58401500233,58401500302,58402010112,58402010113,58402011001,58402011002,58402011003,58402013201,58402013203,58402033111,58402033113,58402033333,58402122202,58402122203,58402332310,58402332311,58402332312,58402332330,58402333030,58402333031,58402333032,58402333100,58402333101,58402333102,58402333120,58402333200,58402333201,58402333210,58402410010,58402410011,58402410100,58402420321,58402420330,58402421012,58402421030,58402421032,58402421210,58402421212,58402421221,58403011111,58403011113,58403011131,58403011133,58403011311,58403011313,58403011331,58403011333,58403013111,58403013113,58403031313,58403031322,58403031323,58403031331,58403031332,58403031333,58403033320,58403033321,58403102211,58403102213,58403102231,58403102233,58403120011,58403120013,58403120031,58403120120,58403120121,58403120123,58403120202,58403120203,58403120212,58403120213,58403120301,58403120302,58403120303,58403310230,58403310232,58403312010,58403312012,58403312030,58403312032,58403312210,58403312212,58403312230,58403312232,58403322020,58403322021,58403322030,58403322031,58403322120,58403322121,58403322130,58403322131,58403323010,58403323011,58403323020,58403323021,58403323110,58403323111,58403323120,58403323121,58403330010,58403330012,58403330030,58403330032,58403330200,58403330202,58403330220,58404011110,58404011111,58404011113,58404011131,58404011133,58404013131,58404013133,58404102200,58404102201,58404112030,58404112031,58404112032,58404112120,58404112121,58404112130,58404112131,58404112210,58404112212,58404112230,58404112232,58404113000,58404113001,58404113002,58404113010,58404113011,58404113020,58404113100,58404113101,58404113110,58404113111,58404120010,58404120011,58404120013,58404120031,58404120120,58404120121,58404121130,58404121131,58404130010,58404130012,58404130020,58404130021,58404130030,58404201210,58404201211,58404201220,58404201221,58404201222,58404202000,58404202001,58404202010,58404202011,58404202100,58404202101,58404202110,58404202111,58404203000,58404210210,58404210211,58404210330,58404210331,58404210332,58404211100,58404211102,58404211120,58404211122,58404211220,58404211221,58404211230,58404211231,58404211300,58404212100,58404212101,58404212110,
025,00,Წ,502284375,137915625,504520312,141150000,11,21,61,131,309,533,573956,573966,573975,573976,573977,583906,583907,583917,583927,583937,583947,5739462,5739463,5739643,5739651,5739652,5739653,5739672,5739673,5740700,5839051,5839161,5839163,5839261,5839263,5840102,5840200,5840202,5840300,5840302,5840400,5840402,57394533,57394602,57394603,57394611,57394612,57394613,57394702,57394720,57394722,57395511,57395513,57395531,57395700,57395702,57395720,57395722,57396501,57396502,57396503,57396700,57396702,57396703,57396712,57397411,57397413,57397431,57406022,57406023,57406032,57407010,57407020,57407022,58390501,58390531,58390533,58391600,58391601,58391603,58391621,58391623,58392601,58393610,58393611,58393613,58393631,58393633,58395701,58395710,58400000,58400002,58400020,58400022,58402030,58402032,58403010,58403012,58403030,58403032,58404010,58404012,58404030,573945133,573945303,573945311,573945312,573945313,573945321,573946012,573946103,573947000,573947002,573955331,573955332,573955333,573957012,573957030,573957032,573957210,573957212,573957230,573957232,573964123,573964131,573964132,573964133,573964213,573965003,573967010,573967012,573967013,573967102,573967132,573974100,573974101,573974103,573974121,573974331,573974333,574060202,574060203,574060211,574060212,574060213,574060302,574070120,574070121,574070122,574070210,574070211,574070212,583905000,583905001,583905003,583905030,583905031,583905033,583905211,583905300,583905301,583905303,583905321,583905323,583915110,583915111,583916020,583916021,583916023,583916201,583916203,583926031,583926033,583926211,583936120,583936121,583936123,583936301,583946111,583946113,583946131,583957001,583957003,583957110,583957111,584000210,584000212,584010000,584010001,584010002,584010020,584010022,584010023,584010032,584010322,584010323,584020100,584020102,584020120,584020122,584020123,584020310,584020312,584020330,584020332,584030110,584030112,584030130,584030132,584030133,584030310,584030311,584030312,584030330,584030332,584040110,584040112,584040130,584040132,584040133,584040310,584040311,584040312,584040320,584040321,584040330,584050000,584050001,584050003,584050010,584050012,584050021,584050030,583964031,5739363313,5739363323,5739363331,5739363332,5739363333,5739372222,5739372223,5739451313,5739451323,5739453012,5739453013,5739453101,5739453102,5739453103,5739453230,5739453231,5739453233,5739460032,5739460033,5739460130,5739460132,5739460133,5739461003,5739461012,5739461013,5739461021,5739461022,5739461023,5739470012,5739470030,5739470032,5739470302,5739470320,5739472120,5739472122,5739472300,5739472302,5739472320,5739472322,5739553013,5739553031,5739553033,5739553231,5739553232,5739553233,5739553300,5739553301,5739553303,5739570100,5739570102,5739570103,5739570130,5739570132,5739570310,5739572310,5739572312,5739572330,5739572332,5739641212,5739641213,5739641221,5739641222,5739641223,5739641301,5739641302,5739641303,5739642111,5739642112,5739642113,5739642121,5739642123,5739642311,5739642313,5739650011,5739650012,5739650013,5739650023,5739670110,5739670112,5739671032,5739671302,5739671332,5739741020,5739741021,5739741023,5739741230,5739741231,5739741233,5739743011,5739743013,5739743301,5739743303,5739743321,5740600323,5740600330,5740600332,5740600333,5740602002,5740602003,5740602012,5740602013,5740602101,5740602102,5740602103,5740603000,5740603002,5740603032,5740603033,5740603320,5740603322,5740603323,5740701100,5740701102,5740701120,5740701122,5740701230,5740701231,5740701300,5740701302,5740701303,5740702130,5740702132,5740702300,5740702301,5740702302,5740702310,5740702320,5740703000,5839041110,5839041111,5839041113,5839050020,5839050021,5839050210,5839050211,5839050213,5839050320,5839050321,5839050323,5839052101,5839052103,5839053020,5839053021,5839053201,5839151011,5839151130,5839151131,5839151133,5839151311,5839160220,5839160221,5839160223,5839162001,5839162210,5839162211,5839162213,5839162231,5839260301,5839260303,5839260321,5839262131,5839262133,5839262311,5839262313,5839262331,5839262333,5839360111,5839360113,5839361220,5839361221,5839361223,5839363001,5839363003,5839363021,5839363030,5839363031,5839363033,5839461100,5839461101,5839461103,5839461121,5839461123,5839461331,5839461333,5839463111,5839463113,5839463131,5839463133,5839463311,5839463313,5839463331,5839570000,5839570001,5839570003,5839570021,5839570023,5839570200,5839570201,5839570210,5839570211,5839570300,5839570301,5839570310,5839571120,5839571121,5839571130,5839571131,5840000122,5840000300,5840000322,5840000323,5840002112,5840002300,5840100030,5840100032,5840100210,5840100212,5840100213,5840100332,5840103000,5840103002,5840103020,5840103022,5840103200,5840103202,5840103203,5840103212,5840103213,5840103302,5840103303,5840103312,5840103320,5840103321,5840103330,5840201010,5840201012,5840201030,5840201032,5840201210,5840201212,5840201213,5840201322,5840201323,5840201332,5840203110,5840203112,5840203130,5840203132,5840203310,5840203312,5840203313,5840203330,5840203331,5840203332,5840301110,5840301112,5840301130,5840301132,5840301310,5840301312,5840301313,5840303130,5840310220,5840310222,5840312000,5840312002,5840401110,5840401112,5840401130,5840401132,5840401310,5840401312,5840403130,5840403131,5840403132,5840403220,5840403221,5840403222,5840403230,5840403231,5840403310,5840403312,5840403320,5840410222,5840412000,5840412002,5840500020,5840500021,5840500023,5840500110,5840500111,5840500112,5840500130,5840500131,5840500132,5840500201,5840500231,5840500310,5840500312,5840500320,5840500321,5840500323,5840500330,5840500332,5839640331,5839641202,5839640132,5839640130,5839640123,57393631332,57393633103,57393633110,57393633112,57393633121,57393633123,57393633212,57393633213,57393633222,57393633223,57393633301,57393633302,57393633303,57393722020,57393722022,57393722200,57393722202,57394513033,57394513103,57394513112,57394513113,57394513121,57394513122,57394513123,57394513211,57394513212,57394513213,57394600222,57394600223,57394600232,57394600233,57394601310,57394601312,57394610201,57394610203,57394700100,57394700102,57394700103,57394700112,57394700130,57394700132,57394700310,57394700312,57394700330,57394700332,57394700333,57394721022,57394721023,57394721212,57394721230,57394721232,57394723010,57395510110,57395510111,57395510113,57395510131,57395510133,57395510311,57395510313,57395510331,57395510333,57395512111,57395512113,57395512131,57395512133,57395512311,57395512313,57395512331,57395512333,57395530111,57395530113,57395532111,57395532113,57395532231,57395532233,57395533021,57395533023,57395701012,57395701013,57395701122,57395701123,57395703120,57395703121,57395703322,57395703323,57395721122,57395721123,57395721300,57395721301,57395723130,57395723132,57396403331,57396403333,57396411223,57396411232,57396411233,57396411322,57396411323,57396411332,57396411333,57396412112,57396412113,57396413001,57396413002,57396413003,57396421023,57396421032,57396421033,57396421101,57396421102,57396421103,57396421201,57396421203,57396423100,57396423101,57396423103,57396423121,57396423123,57396423301,57396423310,57396423311,57396423313,57396423331,57396423333,57396500031,57396500033,57396500203,57396500211,57396500212,57396500213,57396500221,57396500222,57396500223,57396701112,57396701130,57396701132,57396701133,57396710022,57396710023,57396710330,57396710332,57396713030,57396713032,57396713033,57396713302,57396713303,57396713332,57396713333,57397401111,57397401113,57397412011,57397412013,57397412031,57397412033,57397412211,57397412320,57397412321,57397430311,57397430313,57397430331,57397430333,57397432111,57397433000,57397433001,57397433003,57397433021,57397433230,57397433231,57406002222,57406003122,57406003123,57406003212,57406003213,57406003312,57406003313,57406012202,57406012220,57406012222,57406012223,57406020000,57406020002,57406020003,57406020012,57406020013,57406020102,57406021003,57406030012,57406030030,57406030032,57406030300,57406030302,57406031220,57406031222,57406033000,57406033002,57406033020,57406033022,57406033023,57406033032,57406033210,57406033212,57406033213,57407011010,57407011011,57407011012,57407011030,57407011032,57407011210,57407011212,57407011230,57407011232,57407012320,57407012321,57407012322,57407012330,57407012331,57407013010,57407013012,57407013013,57407021310,57407021311,57407021312,57407021330,57407021332,57407023030,57407023032,57407023110,57407023112,57407023210,57407023212,57407023220,57407023221,57407023222,57407023230,57407030010,57407030011,57407030020,57407030021,57407030022,57407030100,57407030200,58390411121,58390411123,58390411311,58390411313,58390500220,58390500221,58390500230,58390500231,58390500233,58390502011,58390502120,58390502121,58390502310,58390502311,58390502313,58390503221,58390503223,58390521001,58390521003,58390521310,58390521311,58390530220,58390530221,58390530230,58390530231,58390530233,58390532001,58390532003,58390532021,58390532030,58390532031,58390532033,58391510131,58391510133,58391511201,58391511210,58391511211,58391511213,58391511231,58391511320,58391511321,58391511323,58391513101,58391513130,58391513131,58391602221,58391602223,58391620001,58391620003,58391620031,58391620033,58391620211,58391622331,58391622333,58392600111,58392600113,58392600131,58392603000,58392603001,58392603231,58392603233,58392621011,58392621013,58392621031,58392621033,58392621211,58392621300,58392621301,58392621303,58392621321,58392621323,58392623101,58392623103,58392623121,58392623123,58393601310,58393601311,58393612221,58393612223,58393630001,58393630003,58393630021,58393630321,58393630323,58393632111,58393632113,58393632131,58393632133,58393632311,58394611020,58394611021,58394613011,58394613013,58394613031,58394613033,58394613211,58394613300,58394613301,58394613303,58394613321,58394613323,58394631101,58394631103,58394631121,58394633330,58394633331,58394633333,58395611111,58395611113,58395611131,58395611333,58395613111,58395613112,58395613113,58395700020,58395700021,58395700023,58395700201,58395700203,58395700221,58395700222,58395700223,58395703110,58395703111,58395703112,58395711220,58395711221,58395711222,58395711230,58395711231,58395711320,58395711321,58395711330,58395711331,58395712000,58395712001,58395712010,58395712011,58395712100,58395712101,58395712110,58395712111,58395713000,58400001000,58400001230,58400001232,58400003010,58400003012,58400003020,58400003022,58400003200,58400003202,58400003203,58400003212,58400023010,58400023012,58400023020,58400023021,58400023022,58400023030,58400023200,58401001000,58401001002,58401001020,58401002112,58401002113,58401003022,58401003023,58401003032,58401030030,58401030032,58401030210,58401030212,58401030230,58401030232,58401032010,58401032012,58401032013,58401032102,58401033220,58401033221,58401033222,58401033230,58401033231,58401033320,58401033321,58402010110,58402010111,58402011000,58402013200,58402013202,58402033110,58402033112,58402033330,58402033331,58402033332,58402122200,58402122201,58403011110,58403011112,58403011130,58403011132,58403011310,58403011312,58403011330,58403011332,58403013110,58403013112,58403031310,58403031311,58403031312,58403031320,58403031321,58403031330,58403033322,58403033323,58403102210,58403102212,58403102230,58403102232,58403120010,58403120012,58403120030,58403120032,58403120033,58403120122,58403120200,58403120201,58403120210,58403120211,58403120300,58404011112,58404011130,58404011132,58404013130,58404013132,58404031330,58404031331,58404033210,58404033212,58404102202,58404102203,58404120012,58404120030,58404120032,58404120033,58404120122,58404120200,58404120201,58404120210,58404120211,58404120300,58405000220,58405000221,58405001130,58405001132,58405001330,58405001331,58405001332,58405002031,58405002033,58405002301,58405002303,58405003110,58405003112,58405003130,58405003132,58405003310,58405003312,58405003330,58405003332,58405010000,58405010002,58405010200,58405010202,58405010220,58396403321,58396403330,58396403303,58396403301,58396412200,58396412002,58396403011,58396403013,58396403031,58396403030,58396403012,58396401213,58396400330,58396401211,58396403323,58393601301,
026,00,,501707812,130293750,503718750,132168750,6,18,44,85,222,501,543944,543945,543954,543955,543964,543965,5439253,5439333,5439342,5439343,5439351,5439352,5439353,5439360,5439362,5439431,5439433,5439460,5439531,5439533,5439660,5439740,5439741,5439750,54392523,54392622,54392623,54393313,54393412,54393413,54393501,54393502,54393503,54393612,54393630,54393632,54393633,54393722,54394301,54394302,54394303,54394320,54394321,54394323,54394610,54394611,54394620,54394622,54395301,54396310,54396311,54396313,54396331,54396620,54396621,54396622,54397421,54397422,54397423,54397430,54397431,54397510,54397511,54397512,54397521,54397530,55390401,55390403,543925122,543925211,543925213,543925223,543926202,543926203,543926322,543933213,543933231,543934020,543934022,543934023,543934031,543934032,543934033,543934102,543935001,543935003,543936100,543936102,543943003,543943220,543943221,543943223,543946120,543946121,543946122,543946210,543946211,543946212,543946230,543946232,543947000,543947001,543947003,543947021,543953031,543953033,543953233,543956000,543956001,543956002,543956020,543956022,543956200,543956202,543956220,543956222,543956223,543956232,543963121,543963122,543963123,543963331,543963333,543966102,543966120,543966122,543966230,543966232,543966300,543973111,543973113,543973130,543973131,543974201,543974202,543974203,543974320,543974321,543974322,543975130,543975131,543975200,543975201,543975230,543975231,543975320,543976000,543976001,553904001,553904100,553904102,553904120,553904122,5439250323,5439250331,5439250332,5439250333,5439251202,5439251230,5439251232,5439251321,5439251322,5439251323,5439251330,5439251332,5439251333,5439252101,5439252103,5439252121,5439252122,5439252123,5439252210,5439252212,5439252213,5439252223,5439262000,5439262002,5439262003,5439262012,5439262122,5439262123,5439263200,5439263202,5439263203,5439263232,5439331122,5439331123,5439331211,5439331213,5439331223,5439331231,5439331232,5439331233,5439332111,5439332113,5439332123,5439332301,5439332303,5439332331,5439332332,5439332333,5439340133,5439340212,5439340213,5439340301,5439340302,5439340303,5439341030,5439341032,5439341033,5439341122,5439341123,5439341132,5439350001,5439350003,5439350021,5439350022,5439350023,5439361010,5439361012,5439361030,5439361032,5439361033,5439363120,5439363122,5439363123,5439363132,5439372013,5439372023,5439372031,5439372032,5439372033,5439372100,5439372102,5439372120,5439372121,5439372122,5439372300,5439372302,5439372320,5439372322,5439421331,5439421333,5439423111,5439423113,5439423131,5439423133,5439430013,5439432220,5439432221,5439432223,5439461230,5439461231,5439462130,5439462132,5439462310,5439462311,5439462312,5439463200,5439470020,5439470021,5439470100,5439470102,5439470120,5439470122,5439470300,5439530010,5439530011,5439530013,5439530031,5439530300,5439530301,5439530303,5439530321,5439530322,5439530323,5439532131,5439532133,5439532311,5439532312,5439532313,5439560030,5439560031,5439560032,5439560100,5439560210,5439560212,5439562012,5439562030,5439562032,5439562210,5439562212,5439562213,5439562302,5439562303,5439630110,5439630111,5439630113,5439630131,5439631201,5439631202,5439631203,5439633000,5439633001,5439633010,5439633011,5439633013,5439633031,5439633301,5439633303,5439661000,5439661002,5439661003,5439661032,5439661210,5439661212,5439661230,5439662310,5439662311,5439662312,5439662330,5439662332,5439662333,5439663020,5439663021,5439731101,5439731103,5439731121,5439731122,5439731123,5439731331,5439731333,5439742001,5439742003,5439743230,5439743231,5439743232,5439743300,5439743301,5439743302,5439752020,5439752031,5439752033,5439752212,5439752213,5439752231,5439752233,5439752320,5439752321,5439752330,5439753102,5439753120,5439753210,5439753211,5439753212,5439753221,5439753230,5439760020,5439760021,5439760022,5439760031,5439760100,5439760101,5439760102,5439760110,5439760112,5539040001,5539040031,5539040033,5539040211,5539040213,5539040231,5539040233,5539041010,5539042110,54392503123,54392503132,54392503133,54392503212,54392503213,54392503301,54392503302,54392503303,54392512123,54392512310,54392512312,54392512330,54392512332,54392512333,54392513032,54392513033,54392513203,54392513312,54392520333,54392521023,54392521201,54392521203,54392522111,54392522112,54392522113,54392522211,54392522213,54392602220,54392602222,54392602223,54392620010,54392620012,54392620013,54392620132,54392621200,54392621202,54392621203,54392621212,54392621322,54392621323,54392621332,54392621333,54392632012,54392632122,54392632300,54392632302,54392632303,54393303331,54393303332,54393303333,54393310323,54393310331,54393310332,54393310333,54393311320,54393311322,54393311323,54393311332,54393311333,54393312101,54393312103,54393312212,54393312213,54393312220,54393312222,54393312223,54393312302,54393312303,54393321121,54393321123,54393323210,54393323211,54393323223,54393323232,54393323233,54393323300,54393323301,54393323303,54393400222,54393400223,54393401232,54393401233,54393401311,54393401313,54393401322,54393401323,54393402100,54393402102,54393402103,54393402112,54393403002,54393403003,54393410312,54393410313,54393411202,54393411203,54393411212,54393411213,54393411302,54393411303,54393411330,54393411332,54393411333,54393610310,54393610312,54393611222,54393613000,54393613002,54393613020,54393613022,54393613200,54393613222,54393631000,54393631002,54393631020,54393631022,54393631023,54393631210,54393631212,54393631213,54393631302,54393631303,54393631332,54393631333,54393720103,54393720111,54393720112,54393720113,54393720121,54393720123,54393720203,54393720212,54393720213,54393720221,54393720222,54393720223,54393720301,54393720302,54393720303,54393721012,54393721030,54393721032,54393721230,54393721231,54393721232,54393723010,54393723012,54393723030,54393723032,54393723210,54393723212,54393723230,54393723232,54394213113,54394213131,54394213132,54394213133,54394213323,54394231101,54394231103,54394231121,54394231123,54394231301,54394231303,54394233111,54394300113,54394300123,54394300223,54394300231,54394300232,54394300233,54394322221,54394322223,54394612320,54394612321,54394613000,54394613001,54394613002,54394613010,54394613011,54394613020,54394613022,54394613100,54394613101,54394613110,54394613111,54394613113,54394613200,54394613202,54394621310,54394621312,54394621330,54394621332,54394621333,54394623130,54394623131,54394623300,54394623301,54394623302,54394623320,54394630000,54394630222,54394632020,54394700220,54394700221,54394700222,54394700230,54394700231,54394700233,54394701010,54394701012,54394701030,54394701032,54394701033,54394701210,54394701211,54394701212,54394701230,54394701232,54394702000,54394702002,54394703010,54394703012,54394703020,54395300010,54395300011,54395300013,54395300121,54395300123,54395300301,54395300303,54395300321,54395300330,54395300331,54395300333,54395302111,54395302113,54395303020,54395303021,54395303023,54395303203,54395321010,54395321011,54395321100,54395321110,54395321111,54395321113,54395321131,54395321132,54395321133,54395321323,54395323101,54395323103,54395323211,54395323213,54395323231,54395323233,54395600330,54395600331,54395600332,54395601010,54395601011,54395601020,54395601021,54395601022,54395601200,54395601202,54395602110,54395602300,54395602301,54395602302,54395602320,54395620100,54395620102,54395620310,54395620312,54395620330,54395620332,54395622110,54395622112,54395622113,54395623012,54395623013,54395623120,54395623122,54395623300,54395623302,54395623320,54395623322,54395623323,54395623332,54395623333,54395632222,54396301011,54396301120,54396301121,54396301123,54396301301,54396301331,54396301333,54396303111,54396303131,54396303133,54396303311,54396303313,54396303331,54396303333,54396312000,54396312001,54396312003,54396330020,54396330021,54396330023,54396330030,54396330031,54396330032,54396330120,54396330121,54396330123,54396330331,54396330333,54396332111,54396333001,54396333003,54396333021,54396333023,54396333210,54396333211,54396333213,54396333231,54396333232,54396333233,54396610010,54396610012,54396610302,54396610303,54396612112,54396612130,54396612132,54396612320,54396623312,54396623313,54396630102,54396630120,54396630122,54396630123,54396630220,54396630230,54396630231,54396630300,54396630301,54396630302,54396630320,54396632202,54396632220,54396632222,54397310331,54397310333,54397311001,54397311003,54397311021,54397311023,54397311201,54397311202,54397311203,54397312111,54397312113,54397312131,54397313210,54397313211,54397313300,54397313301,54397313303,54397313321,54397313323,54397331110,54397331111,54397331313,54397331331,54397331333,54397333111,54397333113,54397333131,54397333133,54397333311,54397333313,54397333331,54397420000,54397420001,54397420021,54397420023,54397432330,54397432331,54397432332,54397433030,54397433100,54397433101,54397433110,54397433200,54397433202,54397433220,54397513200,54397513201,54397513202,54397513210,54397513211,54397513220,54397513222,54397513300,54397513301,54397513303,54397513310,54397513311,54397513312,54397520210,54397520211,54397520212,54397520220,54397520222,54397520301,54397522111,54397522113,54397522301,54397522303,54397522321,54397522323,54397523220,54397523221,54397523222,54397523230,54397523231,54397523310,54397523311,54397523312,54397523320,54397523321,54397531000,54397531002,54397531220,54397531222,54397532130,54397532132,54397532200,54397532201,54397532230,54397532231,54397532310,54397532312,54397532320,54397532321,54397600230,54397600231,54397600232,54397600300,54397600301,54397600303,54397601030,54397601031,54397601032,54397601110,54397601111,54397601112,54397601200,54397601202,54397602000,54397602001,54397602002,54397602020,54397610000,55390400031,55390400033,55390400300,55390400301,55390400303,55390402301,55390402303,55390402321,55390410120,55390410122,55390410300,55390410302,55390410320,55390410322,55390412100,55390412120,55390412122,55390412300,55390412302,55390412320,55390420111,55390421000,55390421001,55390421010,55390421011,55390421110,55390421111,55390421113,55390430000,55390430001,55390430002,55390430010,
027,00,Ե,503085937,130790625,504956250,132487500,7,14,34,94,176,439,543957,543967,543977,544050,544060,544061,544070,5439472,5439473,5439561,5439763,5440402,5440510,5440512,5440710,5440712,5539070,5539071,5540000,5540001,5540002,54394631,54394633,54394712,54395603,54395621,54395630,54395631,54395633,54396611,54396613,54396631,54396633,54397603,54397611,54397612,54397613,54404123,54405130,54405132,54407110,54407111,54407112,54407130,54407132,55390610,55390611,55390613,55390731,55390733,55400030,55400100,55400102,55401000,55401001,543946133,543946301,543946303,543946321,543946322,543946323,543947013,543947022,543947023,543947031,543947032,543947033,543947102,543947132,543947133,543956011,543956013,543956320,543956321,543956323,543966101,543966320,543966321,543966323,543976013,543976021,543976022,543976023,543976101,543976102,543976103,543976210,543976211,543976213,543976231,543976233,544040320,544040322,544040323,544040330,544040332,544040333,544041223,544041322,544051100,544051102,544051120,544051122,544051330,544051332,544062002,544071130,544071131,544071132,544071310,544071312,544071330,544071332,553906011,553906013,553906031,553906120,553906121,553906122,553906310,553906311,553906313,553907200,553907201,553907210,553907211,553907300,553907301,553907303,553917111,553917113,553917131,553917133,554000310,554000311,554000312,554000320,554000321,554000322,554001010,554001011,554001012,554001100,554001101,554001200,554001201,554010020,554010100,554010102,5439461233,5439461303,5439461312,5439461313,5439461321,5439461322,5439461323,5439462331,5439462333,5439463001,5439463002,5439463003,5439463020,5439463021,5439463023,5439463201,5439463203,5439470110,5439470112,5439470113,5439470201,5439470202,5439470203,5439470303,5439471030,5439471032,5439471033,5439560103,5439560121,5439560122,5439560123,5439560213,5439560231,5439560233,5439562011,5439562013,5439562300,5439562310,5439562311,5439562313,5439562331,5439563220,5439563221,5439563223,5439661031,5439661033,5439661231,5439661233,5439662313,5439663011,5439663013,5439663031,5439663033,5439663221,5439663223,5439760032,5439760033,5439760113,5439760121,5439760122,5439760123,5439760201,5439760203,5439761001,5439761002,5439761003,5439762011,5439762013,5439762120,5439762121,5439762323,5440400220,5440400222,5440400223,5440400232,5440400233,5440400323,5440400332,5440403000,5440403002,5440403020,5440403022,5440403123,5440403132,5440403211,5440403212,5440403213,5440403310,5440403312,5440412213,5440412222,5440412223,5440413200,5440413202,5440511010,5440511012,5440511030,5440511032,5440511210,5440511212,5440511230,5440511232,5440620200,5440620202,5440622002,5440711330,5440711331,5440711332,5440713110,5440713112,5440713113,5440713130,5440713131,5440713132,5440713310,5440713312,5440713332,5539060101,5539060103,5539060120,5539060121,5539060123,5539060301,5539060303,5539060321,5539060330,5539060331,5539060333,5539061230,5539061231,5539061232,5539063000,5539063121,5539072020,5539072021,5539072030,5539073020,5539073021,5539073022,5539073233,5539171100,5539171101,5539171103,5539171121,5539171301,5539171303,5539171321,5539173110,5539173111,5539173113,5540003130,5540003131,5540003230,5540003232,5540010130,5540010131,5540010300,5540010301,5540010302,5540010320,5540010322,5540011020,5540011021,5540011030,5540011100,5540012030,5540012031,5540012100,5540100210,5540100212,5540100220,5540100221,5540100222,5540101010,5540101012,5540101030,54393723233,54393723322,54394612322,54394612323,54394613003,54394613012,54394613013,54394613021,54394613023,54394613102,54394613103,54394613112,54394613201,54394613203,54394621311,54394621313,54394621331,54394623132,54394623133,54394623303,54394623321,54394623322,54394623323,54394630001,54394630002,54394630003,54394630220,54394630221,54394630223,54394632021,54394632022,54394632023,54394700223,54394700232,54394701011,54394701013,54394701031,54394701112,54394701113,54394701213,54394701231,54394701233,54394702001,54394702003,54394703011,54394703013,54394703021,54394703022,54394703023,54394710020,54394710022,54394710023,54394710032,54394710310,54394710312,54394710313,54394711202,54394711222,54394713000,54394713002,54394713020,54394713022,54394713122,54394713123,54394713132,54394713133,54395600333,54395601012,54395601013,54395601023,54395601201,54395601203,54395602111,54395602112,54395602113,54395602303,54395602321,54395602322,54395602323,54395620101,54395620103,54395620311,54395620313,54395620331,54395620333,54395622111,54395623010,54395623011,54395623121,54395623123,54395623301,54395623303,54395623321,54395623330,54395623331,54395632220,54395632221,54395632223,54396610011,54396610013,54396610300,54396610301,54396612110,54396612111,54396612113,54396612131,54396612133,54396612321,54396612322,54396612323,54396623310,54396623311,54396630100,54396630101,54396630103,54396630121,54396630221,54396630222,54396630223,54396630232,54396630233,54396630303,54396630321,54396630322,54396630323,54396632200,54396632201,54396632203,54396632221,54396632223,54397513313,54397513331,54397600233,54397600302,54397601033,54397601113,54397601201,54397601203,54397602003,54397602021,54397602022,54397602023,54397610001,54397610002,54397610003,54397620001,54397620010,54397620011,54397620100,54397620101,54397620103,54397620121,54397620123,54397620311,54397620313,54397621220,54397621221,54397621230,54397621231,54397621233,54397623011,54397623013,54397623031,54397623033,54397623211,54397623213,54404002022,54404002023,54404002032,54404002210,54404002212,54404002213,54404002302,54404003220,54404003222,54404003223,54404003332,54404003333,54404012222,54404030012,54404030030,54404030032,54404030210,54404030212,54404030230,54404030232,54404030323,54404030332,54404030333,54404031212,54404031222,54404031223,54404032101,54404032102,54404032103,54404033132,54404120333,54404121222,54404121223,54404121232,54404121233,54404121322,54404121323,54404121332,54404121333,54404122111,54404122112,54404122113,54404122123,54404122200,54404122202,54404122203,54404122211,54404122212,54404122213,54404130222,54404132012,54404132030,54404132032,54404132033,54404132320,54404132322,54404132323,54405112312,54405112330,54405112332,54405131002,54405131020,54405131022,54405131200,54405131202,54405131220,54405131222,54405131223,54405131232,54405133120,54405133122,54405133300,54405133302,54405133320,54405133322,54405133323,54405133332,54405133333,54406200000,54406200002,54406200020,54406200022,54406202010,54406202012,54406202030,54406202200,54406202202,54406202220,54406202222,54406220000,54406220002,54406220003,54406220200,54406220201,54406220202,54406220220,54406220222,54406222000,54406222002,54406222020,54406222022,54406222200,54406222202,54406222220,54406222222,54407113330,54407113331,54407113332,54407131330,54407131331,54407131332,54407133110,54407133112,54407133130,54407133300,54407133301,54407133302,54407200000,54407200002,54407200020,54407200022,54407200200,54407200202,54407200220,54407200222,54407202000,54407202002,54407202020,54407202022,54407202200,54407202202,55390601003,55390601021,55390601022,55390601023,55390601221,55390601223,55390603001,55390603003,55390603021,55390603023,55390603201,55390603203,55390603230,55390603231,55390603321,55390603323,55390612330,55390612331,55390612333,55390621110,55390621111,55390621113,55390630010,55390630011,55390630012,55390630100,55390630101,55390630103,55390630111,55390630113,55390630131,55390631201,55390631230,55390631231,55390631233,55390720220,55390720310,55390720311,55390721200,55390721201,55390721300,55390721301,55390721310,55390730230,55390730231,55390730233,55390732111,55390732113,55390732131,55390732133,55390732311,55390732312,55390732313,55391710111,55391711020,55391711021,55391711023,55391711201,55391711203,55391711231,55391711233,55391713230,55391713231,55391713233,55391731011,55391731013,55391731120,55391731121,55391731123,55400031320,55400031321,55400031322,55400031330,55400031331,55400032310,55400032311,55400032312,55400032330,55400032332,55400033000,55400033001,55400033002,55400033010,55400033011,55400101320,55400101322,55400103030,55400103032,55400103100,55400103210,55400103212,55400103230,55400103232,55400110310,55400110311,55400110312,55400111010,55400111011,55400111012,55400111020,55400111100,55400120200,55400120202,55400120210,55400120211,55400120213,55400121010,55400121012,55400121020,55400121021,55400121022,55400121200,55401002110,55401002111,55401002112,55401002130,55401002132,55401002230,55401002232,55401002300,55401002301,55401003000,55401003001,55401003010,55401003011,55401003100,55401003101,55401003110,55401003111,55401010130,55401010132,55401010310,55401010312,55401010320,55401010321,55401010322,55401012000,55401012001,55401012010,55401020000,55401020001,55401020002,
028,00,/,501581250,131746875,502860937,132609375,1,5,20,53,118,256,553903,5439732,5539130,5539131,5539140,5539141,54397231,54397233,54397303,54397330,54397332,55390211,55390411,55390413,55390422,55390423,55390431,55390432,55390433,55390502,55390520,55390522,55391321,55391330,55391331,55391421,543972133,543972301,543972321,543973021,543973022,543973023,543973120,543973122,543973123,543973310,543973312,543973330,543973332,543974333,543975220,543975222,553902131,553902133,553904002,553904020,553904022,553904200,553904202,553904203,553904212,553904213,553904301,553904302,553904303,553905000,553905002,553905032,553905210,553905212,553905232,553912111,553912113,553913200,553913201,553913203,553913230,553913231,553913233,553913320,553914200,553914201,553914203,553914300,553914301,553914310,553915000,553915001,553915002,5439721303,5439721312,5439721313,5439721321,5439721322,5439721323,5439723031,5439723032,5439723033,5439723231,5439723233,5439730033,5439730122,5439730123,5439730132,5439730133,5439730202,5439730203,5439731022,5439731032,5439731210,5439731212,5439731320,5439731322,5439731323,5439733110,5439733112,5439733113,5439733130,5439733132,5439733310,5439733312,5439733330,5439733332,5439743312,5439743313,5439743321,5439743323,5439752023,5439752032,5439752210,5539021011,5539021300,5539021301,5539021303,5539021321,5539023110,5539023111,5539023113,5539023131,5539023133,5539023311,5539023313,5539023331,5539023332,5539023333,5539040000,5539040002,5539040032,5539040210,5539040212,5539041011,5539041013,5539041031,5539041033,5539041211,5539041213,5539041231,5539041233,5539042010,5539042012,5539042013,5539042102,5539042103,5539042112,5539042113,5539043002,5539043003,5539050010,5539050012,5539050030,5539050032,5539050033,5539050302,5539052112,5539052130,5539052132,5539052300,5539052302,5539121103,5539121311,5539121313,5539132211,5539132320,5539132321,5539133210,5539133211,5539133212,5539133220,5539133221,5539133230,5539133310,5539142020,5539142021,5539142022,5539142301,5539143020,5539143021,5539143022,5539143030,5539143031,5539143110,5539143112,5539143120,5539143121,5539150030,5539150100,5539150200,54397212323,54397212331,54397212332,54397212333,54397213023,54397213102,54397213103,54397213112,54397213113,54397213201,54397213202,54397213203,54397230300,54397230301,54397230303,54397232300,54397232301,54397232303,54397232321,54397300303,54397300312,54397300313,54397300321,54397300322,54397300323,54397301303,54397301312,54397301313,54397302002,54397302003,54397302011,54397302012,54397302013,54397310202,54397310203,54397310230,54397310232,54397310233,54397310332,54397312110,54397312112,54397312130,54397312132,54397312133,54397313212,54397313213,54397313302,54397313320,54397313322,54397331112,54397331113,54397331310,54397331311,54397331312,54397331330,54397331332,54397333110,54397333112,54397333130,54397333132,54397333310,54397333312,54397333330,54397333332,54397333333,54397420002,54397420003,54397420020,54397420022,54397432333,54397433031,54397433032,54397433033,54397433102,54397433103,54397433111,54397433112,54397433113,54397433201,54397433203,54397433221,54397433222,54397433223,54397520213,54397520221,54397520223,54397520300,54397520302,54397520303,54397522110,54397522112,54397522300,54397522302,54397522320,54397522322,55390210130,55390210131,55390210133,55390210311,55390210313,55390210331,55390210333,55390212111,55390213020,55390213021,55390213023,55390213231,55390213233,55390231121,55390233303,55390400030,55390400032,55390400302,55390402300,55390402302,55390402320,55390402322,55390402323,55390410121,55390410123,55390410301,55390410303,55390410321,55390410323,55390412101,55390412102,55390412103,55390412121,55390412123,55390412301,55390412303,55390412321,55390412322,55390412323,55390420110,55390420112,55390420113,55390421002,55390421003,55390421012,55390421013,55390421112,55390430003,55390430011,55390430012,55390430013,55390500110,55390500111,55390500112,55390500130,55390500132,55390500310,55390500312,55390501222,55390503000,55390503002,55390503003,55390503030,55390503032,55390503033,55390503322,55390521100,55390521102,55390521103,55390521310,55390521312,55390521330,55390523010,55390523011,55390523012,55390523030,55390523032,55391211011,55391211012,55391211013,55391211210,55391211211,55391211213,55391211231,55391211233,55391213011,55391213100,55391213101,55391213103,55391213121,55391213123,55391213310,55391213311,55391320201,55391320210,55391320211,55391322100,55391322101,55391322103,55391322121,55391322130,55391322131,55391322133,55391322311,55391322313,55391323231,55391323233,55391332130,55391332131,55391332132,55391332220,55391332221,55391332222,55391332310,55391333000,55391333001,55391333002,55391333010,55391333011,55391333110,55391333111,55391420230,55391420231,55391420232,55391422000,55391422010,55391423100,55391423101,55391423102,55391423110,55391423111,55391430230,55391430231,55391430320,55391430321,55391430331,55391431110,55391431111,55391431112,55391431220,55391431221,55391431230,55391431300,55391432000,55391500310,55391500311,55391500320,55391500321,55391500322,55391501010,55391501011,55391501012,55391501020,55391501022,55391501200,55391502010,55391502020,55391502022,55391502200,55391502202,55392301101,
029,00,/,501651562,131821875,503465625,133509375,2,11,32,71,171,443,553924,553925,5539051,5539053,5539152,5539231,5539233,5539340,5539341,5539350,5539352,5539353,5539451,54397533,54397622,55390600,55390602,55390620,55390622,55391433,55391503,55391510,55391512,55391530,55391532,55392300,55392302,55392303,55392320,55392321,55392323,55392602,55393310,55393311,55393313,55393430,55393431,55393433,55393510,55393511,55393512,55394501,55394531,55394620,55394621,543975311,543975313,543976202,553905010,553905011,553905013,553905031,553905231,553905233,553906210,553906212,553906213,553906230,553906231,553906302,553906303,553913332,553913333,553914221,553914222,553914223,553914232,553914233,553914321,553914322,553914323,553915011,553915013,553915021,553915023,553915110,553915111,553915112,553915130,553915132,553915310,553915312,553915330,553915332,553916000,553922113,553922131,553922133,553923010,553923012,553923013,553926002,553926200,553926202,553926220,553926222,553933121,553934201,553934210,553934211,553934213,553934320,553934321,553935130,553935131,553935132,553936000,553945000,553945001,553945003,553945031,553945300,553945301,553946022,553946230,553946231,5439751323,5439751332,5439752333,5439753101,5439753103,5439753121,5439753123,5439753222,5439753233,5439762002,5439762003,5439762030,5439762032,5439762033,5439762300,5439762302,5439762320,5439762322,5539050120,5539050121,5539050123,5539050301,5539050330,5539050331,5539050333,5539052111,5539052113,5539060322,5539062110,5539062112,5539062113,5539062320,5539062321,5539062322,5539062330,5539063002,5539063003,5539063012,5539063122,5539063200,5539063201,5539132232,5539132233,5539132322,5539133223,5539133232,5539133233,5539133302,5539133303,5539133312,5539133313,5539142202,5539142203,5539142300,5539142302,5539142303,5539142312,5539142313,5539143113,5539143131,5539143132,5539143133,5539143201,5539143202,5539143203,5539150033,5539150103,5539150121,5539150122,5539150123,5539150203,5539150221,5539150222,5539150223,5539151130,5539151131,5539151132,5539151310,5539151312,5539151330,5539151332,5539153332,5539160010,5539160011,5539160012,5539160020,5539160021,5539221113,5539221121,5539221123,5539230111,5539230112,5539230113,5539232210,5539232211,5539232213,5539232231,5539232233,5539260002,5539260032,5539262010,5539262012,5539262030,5539262032,5539262033,5539262210,5539262211,5539262212,5539262230,5539262232,5539330100,5539330101,5539330110,5539330111,5539330113,5539331200,5539331201,5539331203,5539331230,5539331231,5539331233,5539333100,5539333101,5539342120,5539342121,5539342311,5539343231,5539351330,5539351332,5539351333,5539360010,5539360020,5539362220,5539362222,5539441100,5539441101,5539441110,5539441111,5539450021,5539450023,5539450201,5539450210,5539450211,5539450300,5539450301,5539450303,5539450331,5539450333,5539452111,5539460000,5539460002,5539460020,5539460022,5539460200,5539460202,5539460232,5539460233,5539460322,5539460323,5539462201,5539462210,5539462211,5539462320,5539462321,5539462330,5539462331,5539463022,5539463200,5539463202,5539463220,5539463221,54397513203,54397513212,54397513213,54397513221,54397513223,54397513302,54397513330,54397513332,54397513333,54397523223,54397523232,54397523233,54397523313,54397523322,54397523323,54397531001,54397531003,54397531221,54397531223,54397532131,54397532133,54397532202,54397532203,54397532232,54397532233,54397532311,54397532313,54397532322,54397532323,54397620000,54397620002,54397620003,54397620012,54397620013,54397620102,54397620120,54397620122,54397620310,54397620312,54397621222,54397621223,54397621232,54397623010,54397623012,54397623030,54397623032,54397623210,54397623212,55390500113,55390500131,55390500133,55390500311,55390500313,55390501220,55390501221,55390501223,55390503001,55390503031,55390503320,55390503321,55390503323,55390521101,55390521311,55390521313,55390521331,55390521332,55390521333,55390523013,55390523031,55390523033,55390601000,55390601001,55390601002,55390601020,55390601220,55390601222,55390603000,55390603002,55390603020,55390603022,55390603200,55390603202,55390603232,55390603233,55390603320,55390603322,55390612332,55390621112,55390623230,55390623231,55390623232,55390623310,55390623311,55390623312,55390623320,55390623321,55390630013,55390630102,55390630110,55390630112,55390630130,55390630132,55390630133,55390631200,55390631202,55390631203,55390632020,55390632021,55390632022,55390632100,55390632101,55390632102,55390632110,55390632111,55390633000,55391233333,55391322222,55391322223,55391322231,55391322232,55391322233,55391323230,55391323232,55391332133,55391332223,55391332311,55391332312,55391332313,55391333003,55391333012,55391333013,55391333112,55391333113,55391420233,55391422001,55391422002,55391422003,55391422011,55391422012,55391422013,55391423103,55391423112,55391423113,55391430232,55391430233,55391430322,55391430323,55391430330,55391430332,55391430333,55391431113,55391431222,55391431223,55391431231,55391431232,55391431233,55391431301,55391431302,55391431303,55391432001,55391432002,55391432003,55391500312,55391500313,55391500323,55391501013,55391501021,55391501023,55391501201,55391501202,55391501203,55391502011,55391502012,55391502013,55391502021,55391502023,55391502201,55391502203,55391511330,55391511331,55391531100,55391531101,55391531102,55391531120,55391531122,55391533100,55391533102,55391533120,55391533122,55391533300,55391533332,55391533333,55391600220,55391600221,55391600230,55391600300,55391601000,55391601001,55392211033,55392211103,55392211111,55392211112,55392211113,55392211121,55392211122,55392211123,55392211203,55392211221,55392211223,55392213010,55392213011,55392213013,55392213031,55392213033,55392213211,55392213231,55392213233,55392231011,55392231100,55392231101,55392231110,55392231111,55392231113,55392231131,55392231133,55392231311,55392231313,55392231331,55392301100,55392301102,55392301103,55392322001,55392322010,55392322011,55392322013,55392322121,55392322123,55392322301,55392322303,55392322321,55392322323,55392600002,55392600003,55392600032,55392600033,55392600300,55392600302,55392600303,55392600330,55392600332,55392600333,55392620110,55392620111,55392620112,55392620130,55392620132,55392620310,55392620312,55392621222,55392622130,55392622132,55392622310,55392622312,55392622330,55392622332,55392623000,55392623002,55393300110,55393300111,55393300113,55393300131,55393301020,55393301021,55393301023,55393301030,55393301031,55393301032,55393301120,55393301121,55393301310,55393301311,55393301313,55393301331,55393301333,55393303111,55393312021,55393312211,55393312321,55393312323,55393330101,55393330110,55393330111,55393330113,55393330131,55393331020,55393331021,55393331030,55393331031,55393331100,55393331101,55393331102,55393331110,55393331111,55393331120,55393420000,55393420001,55393420010,55393420011,55393420013,55393420031,55393420300,55393420301,55393420310,55393420311,55393420313,55393421231,55393421233,55393423101,55393423103,55393432211,55393432300,55393432301,55393432303,55393432321,55393432330,55393432331,55393432333,55393513310,55393513312,55393513313,55393600110,55393600112,55393600120,55393600121,55393600122,55393600210,55393600211,55393600212,55393600220,55393600221,55393600222,55393600230,55393602000,55393602002,55393602020,55393602022,55393602222,55393620000,55393620002,55393620020,55393620022,55393620200,55393620202,55393620220,55393620222,55393622000,55393622002,55393622020,55393622022,55393622230,55393622232,55394410111,55394410113,55394410131,55394411020,55394411021,55394411030,55394411031,55394411120,55394411121,55394411130,55394411131,55394500201,55394500203,55394500221,55394500223,55394502131,55394503020,55394503021,55394503210,55394503211,55394503300,55394503301,55394503303,55394503321,55394521130,55394521131,55394521133,55394530311,55394530313,55394600010,55394600012,55394600030,55394600032,55394600210,55394600212,55394600213,55394600230,55394600231,55394600232,55394602010,55394602012,55394602030,55394602032,55394602033,55394602302,55394602303,55394602313,55394603202,55394603203,55394603212,55394603322,55394603323,55394603332,55394622121,55394622130,55394622131,55394622133,55394622311,55394623220,55394623221,55394623223,55394623230,55394623231,55394623232,55394623320,55394623321,55394623330,55394623331,55394630022,55394630200,55394630202,55394630232,55394632010,55394632012,55394632030,55394632032,55394632220,55394632221,55394632230,55394632231,55395601001,55395601010,
030,00,/ĸ,503043750,132018750,505082812,133340625,3,14,33,81,214,385,553927,554011,554021,5539161,5539162,5539163,5539170,5539172,5539261,5539263,5539361,5539370,5540013,5540103,5540200,5540201,5540203,55390722,55390723,55391602,55391603,55391712,55391730,55391732,55391733,55392601,55392603,55393601,55393603,55393621,55393623,55393630,55393631,55393710,55393712,55393720,55393721,55400112,55400122,55400123,55400220,55401011,55401013,55401021,55401022,55401023,55402020,55402021,55402023,55403110,553906322,553906323,553906331,553906332,553906333,553907320,553907322,553915313,553916011,553916012,553916013,553917100,553917102,553917103,553917312,553917313,553926001,553926210,553926211,553926213,553926231,553926232,553926233,553936003,553936021,553936023,553936201,553936203,553936221,553936223,553936320,553936321,553936322,553936330,553936331,553937110,553937300,553946001,553946003,553946010,553946011,553946012,553946021,553946030,554000331,554000332,554000333,554001033,554001130,554001132,554001133,554001211,554001213,554002022,554002220,554002221,554002222,554010032,554010033,554010121,554010122,554010123,554010201,554010202,554010203,554012002,554012022,554012200,554012202,554012220,554012222,554020220,554030011,554031001,554031003,554031010,554031011,554031013,554031110,554031111,554031112,5539062333,5539063203,5539063212,5539063213,5539063301,5539063302,5539063303,5539072023,5539072032,5539072033,5539072121,5539072122,5539072123,5539072132,5539072133,5539073210,5539073212,5539073230,5539073232,5539151311,5539151313,5539151331,5539151333,5539153111,5539153113,5539153311,5539153313,5539153331,5539160013,5539160031,5539160032,5539160033,5539160101,5539160102,5539160103,5539171010,5539171012,5539171013,5539171122,5539171300,5539171302,5539171320,5539171322,5539173100,5539173102,5539173103,5539260001,5539260031,5539262120,5539262121,5539262123,5539262301,5539262302,5539262303,5539360013,5539360201,5539360203,5539360220,5539360221,5539360223,5539362001,5539362003,5539362021,5539362023,5539362201,5539362203,5539362221,5539363230,5539363231,5539363331,5539371110,5539371111,5539371112,5539371120,5539371122,5539371300,5539371302,5539372200,5539372201,5539372202,5539372210,5539372211,5539372212,5539372220,5539372300,5539373010,5539373012,5539373020,5539460130,5539460131,5539460132,5539460310,5539460312,5540003302,5540003303,5540010133,5540010311,5540010312,5540010313,5540011022,5540011023,5540011032,5540011033,5540011120,5540011122,5540011312,5540011313,5540012022,5540012023,5540012032,5540012033,5540012103,5540012121,5540012122,5540012123,5540020230,5540020232,5540020233,5540020322,5540022100,5540022101,5540022102,5540022120,5540022122,5540022230,5540022300,5540100231,5540100232,5540100233,5540100302,5540100303,5540100312,5540100313,5540101011,5540101033,5540101202,5540101203,5540102001,5540102002,5540102003,5540120000,5540120001,5540120002,5540120200,5540120202,5540120230,5540120232,5540122010,5540122012,5540122030,5540122032,5540122210,5540122212,5540122230,5540202210,5540202211,5540202213,5540202220,5540202222,5540220000,5540220002,5540220020,5540220022,5540220200,5540220202,5540220220,5540220222,5540222000,5540222002,5540222020,5540222022,5540222200,5540222202,5540222222,5540300100,5540300101,5540300103,5540300121,5540300130,5540301000,5540301001,5540301002,5540301010,5540301011,5540301020,5540301100,5540301101,5540301103,5540301110,5540301111,5540301112,5540301121,5540301123,5540301130,5540310001,5540310003,5540310021,5540310120,5540310121,5540310123,5540310301,5540310310,5540310311,5540311130,5540311131,5540311132,5540311200,5540311201,5540311210,5540311211,5540311300,5540320000,5540320002,5540320020,55390623233,55390623313,55390623322,55390623323,55390631232,55390632023,55390632103,55390632112,55390632113,55390633001,55390633002,55390633003,55390720221,55390720222,55390720223,55390720312,55390720313,55390721202,55390721203,55390721302,55390721303,55390721311,55390721312,55390721313,55390730232,55390732110,55390732112,55390732130,55390732132,55390732310,55391511332,55391511333,55391531103,55391531121,55391531123,55391533101,55391533103,55391533121,55391533123,55391533301,55391533302,55391533303,55391533330,55391533331,55391600222,55391600223,55391600231,55391600232,55391600233,55391600301,55391600302,55391600303,55391601002,55391601003,55391710110,55391710112,55391710113,55391711022,55391711200,55391711202,55391711230,55391711232,55391713232,55391731010,55391731012,55391731122,55392600000,55392600001,55392600030,55392600031,55392600301,55392600331,55392620113,55392620131,55392620133,55392620311,55392620313,55392621220,55392621221,55392621223,55392622131,55392622133,55392622311,55392622313,55392622331,55392622333,55392623001,55392623003,55393513311,55393600111,55393600113,55393600123,55393600213,55393600223,55393600231,55393600232,55393600233,55393602001,55393602003,55393602021,55393602023,55393602220,55393602221,55393602223,55393620001,55393620003,55393620021,55393620023,55393620201,55393620203,55393620221,55393620223,55393622001,55393622003,55393622021,55393622023,55393622231,55393622233,55393632320,55393632321,55393632322,55393633200,55393633201,55393633210,55393633211,55393633300,55393633301,55393633303,55393711130,55393711131,55393711133,55393711210,55393711211,55393711212,55393711230,55393711232,55393713010,55393713012,55393713030,55393713032,55393713200,55393713201,55393713202,55393713220,55393722030,55393722031,55393722032,55393722130,55393722131,55393722132,55393723010,55393723011,55393723020,55393723100,55393723101,55393730110,55393730210,55393730211,55393730220,55393730300,55394600011,55394600013,55394600031,55394600033,55394600211,55394600233,55394601330,55394601331,55394601332,55394602011,55394602013,55394602031,55394602300,55394602301,55394602310,55394602311,55394602312,55394603200,55394603201,55394603210,55394603211,55394603213,55394603300,55394603302,55394603320,55394610000,55394610002,55394610020,55394610022,55394610200,55400031323,55400031332,55400031333,55400032313,55400032331,55400032333,55400033003,55400033012,55400033013,55400101321,55400101323,55400103031,55400103033,55400103101,55400103102,55400103103,55400103211,55400103213,55400103231,55400103233,55400110313,55400111021,55400111022,55400111023,55400111030,55400111032,55400111210,55400111212,55400111230,55400111232,55400111233,55400120201,55400120203,55400120212,55400121011,55400121013,55400121023,55400121201,55400121202,55400121203,55400202020,55400202022,55400202023,55400202032,55400202033,55400202122,55400202310,55400202312,55400203232,55400203233,55400203322,55400221030,55400221031,55400221032,55400221100,55400221210,55400221212,55400221230,55400221232,55400222310,55400222320,55400222321,55400222322,55400223010,55400223020,55400223022,55401002113,55401002131,55401002133,55401002231,55401002233,55401002302,55401002303,55401003002,55401003003,55401003012,55401003013,55401003102,55401003103,55401003112,55401003113,55401010131,55401010133,55401010311,55401010313,55401010323,55401012002,55401012003,55401012011,55401012012,55401012013,55401020003,55401200030,55401200032,55401200100,55401200302,55401200320,55401202010,55401202012,55401202030,55401202032,55401202033,55401222320,55401222321,55401222322,55402022120,55402022121,55402022123,55402022210,55402022211,55402022212,55402022230,55402022232,55402022311,55402200010,55402200011,55402200012,55402200030,55402200032,55402200100,55402200210,55402200212,55402200232,55402202010,55402202012,55402202030,55402202032,55402202210,55402202212,55402202230,55402202232,55402220010,55402220012,55402220030,55402220032,55402220210,55402220212,55402220230,55402220232,55402222200,55402222202,55402222203,55403000000,55403000001,55403000002,55403000010,55403000022,55403001021,55403001311,55403001313,55403010030,55403010032,55403010121,55403010130,55403010131,55403011020,55403011021,55403011130,55403011320,55403011321,55403011322,55403013010,55403013011,55403100000,55403100001,55403100230,55403100231,55403101220,55403101221,55403101223,55403103001,55403103003,55403103030,55403103031,55403103120,55403103121,55403103130,55403103131,55403103133,55403111330,55403111332,55403112020,55403112022,55403112031,55403112120,55403112121,55403112130,55403112131,55403113010,55403113011,55403113020,55403113100,55403200030,55403200032,55403200210,
031,00,,503282812,132853125,504900000,133734375,2,6,23,49,121,227,553947,554040,5539570,5539571,5540302,5540303,5540312,5540410,55393731,55393732,55393733,55394611,55394612,55394613,55394631,55394633,55395611,55395613,55403002,55403003,55403012,55403102,55403130,55403132,55404120,55404121,55405000,55405001,55405002,55405010,55405011,553937113,553937131,553937133,553937223,553937232,553937233,553946101,553946103,553946301,553946303,553946321,553957200,553957201,553957210,553957211,553957300,553957301,553957302,553957310,553957311,554030001,554030002,554030003,554030103,554030131,554030132,554030133,554031032,554031033,554031122,554031123,554031132,554031310,554031312,554031330,554031332,554041100,554041101,554041110,554041220,554041221,554041222,554050030,554050031,554050032,554050120,554050121,554050200,554051000,5539363233,5539363322,5539363323,5539363332,5539363333,5539371321,5539371323,5539372221,5539372222,5539372223,5539372303,5539372311,5539372312,5539372313,5539373013,5539373023,5539373031,5539373032,5539373033,5539460311,5539460313,5539460331,5539461001,5539461003,5539461021,5539461022,5539461023,5539463000,5539463001,5539463003,5539463021,5539463230,5539463231,5539463233,5539561011,5539561012,5539561013,5539561030,5539561031,5539561033,5539561211,5539561212,5539561213,5539561231,5539561233,5539563101,5539563110,5539563111,5539563113,5539572020,5539572021,5539572030,5539572031,5539572033,5539572120,5539572121,5539572130,5539572131,5539572133,5539573030,5539573031,5539573032,5539573120,5539573121,5540202230,5540202232,5540202233,5540300003,5540300120,5540300122,5540300123,5540300132,5540300133,5540301021,5540301022,5540301023,5540301120,5540301122,5540301131,5540301133,5540301300,5540301302,5540301303,5540310002,5540310020,5540310022,5540310302,5540311303,5540311332,5540313110,5540313112,5540313130,5540313132,5540313310,5540411020,5540411021,5540411022,5540411030,5540411110,5540411112,5540411130,5540411200,5540411202,5540411220,5540411222,5540412230,5540412231,5540412232,5540412300,5540412301,5540413000,5540500330,5540500332,5540501300,5540501301,5540502010,5540502011,5540502100,5540502101,5540510010,5540510020,55393632323,55393633202,55393633203,55393633212,55393633213,55393633302,55393711132,55393711213,55393711231,55393711233,55393713011,55393713013,55393713031,55393713033,55393713203,55393713221,55393713222,55393713223,55393722033,55393722133,55393723012,55393723013,55393723021,55393723022,55393723023,55393723102,55393723103,55393730111,55393730112,55393730113,55393730212,55393730213,55393730221,55393730222,55393730223,55393730301,55393730302,55393730303,55394601333,55394603301,55394603303,55394603321,55394603330,55394603331,55394603333,55394610001,55394610003,55394610021,55394610023,55394610201,55394610202,55394610203,55394630020,55394630021,55394630023,55394630201,55394630203,55394630230,55394630231,55394630233,55394632011,55394632013,55394632031,55394632033,55394632320,55394632321,55394632323,55395610031,55395610033,55395610101,55395610103,55395610211,55395610213,55395610321,55395610323,55395612031,55395612033,55395612101,55395612103,55395612211,55395612300,55395612301,55395631001,55395631003,55395631311,55395631313,55395720321,55395720323,55395721321,55395721323,55395730330,55395730332,55395732011,55395732100,55402022122,55402022213,55402022231,55402022233,55402022310,55402022312,55402022313,55403000003,55403000011,55403000012,55403000013,55403000020,55403000021,55403000023,55403001020,55403001022,55403001023,55403001310,55403001312,55403010031,55403010033,55403010120,55403010122,55403010123,55403010132,55403010133,55403011022,55403011023,55403011131,55403011132,55403011133,55403011323,55403013012,55403013013,55403100002,55403100003,55403100232,55403100233,55403101222,55403103000,55403103002,55403103032,55403103033,55403103122,55403103123,55403103132,55403112021,55403112023,55403112030,55403112032,55403112033,55403112122,55403112123,55403112132,55403112133,55403113012,55403113013,55403113021,55403113022,55403113023,55403113102,55403113120,55403113122,55403113300,55403113302,55403113330,55403113332,55403131110,55403131111,55403131112,55403131130,55403131132,55403131310,55403131312,55403131330,55403131332,55403133110,55403133112,55403133113,55403133120,55403133122,55403133300,55403133302,55403133320,55403133322,55404110230,55404110232,55404111110,55404111112,55404111130,55404111132,55404111211,55404111213,55404111310,55404111312,55404112010,55404112012,55404112230,55404112232,55404122330,55404122331,55404123020,55404123021,55404123022,55404123030,55404123200,55404130010,55404130020,55404130021,55405003310,55405003311,55405003312,55405003330,55405012200,55405012201,55405012210,55405012211,55405012300,55405012301,55405012310,55405012311,55405013020,55405013021,55405013022,55405013030,55405013031,55405013100,55405013101,55405013200,55405100120,55405100122,55405100210,55405100212,
032,00,,500906250,132140625,502045312,133884375,0,13,36,69,169,380,5539111,5539113,5539122,5539213,5539220,5539222,5539320,5539321,5539323,5539332,5539421,5539423,5539520,55390132,55391121,55391200,55391202,55391203,55391212,55391230,55391231,55391232,55392111,55392112,55392113,55392210,55392212,55392230,55392232,55392233,55393110,55393111,55393220,55393221,55393223,55393302,55394200,55394201,55394203,55394221,55394222,55394223,55394300,55394302,55394320,55395210,55395211,55395220,55395221,553901232,553901233,553901303,553901332,553901333,553902222,553902223,553911010,553911011,553911013,553911031,553911032,553911033,553911230,553911231,553911233,553912010,553912012,553912013,553912102,553912132,553912330,553912331,553912332,553913220,553921032,553921033,553921101,553921103,553921211,553921213,553921231,553922312,553923222,553931013,553931031,553931033,553931120,553931121,553931122,553931130,553931131,553931132,553932221,553932223,553933000,553933002,553933003,553933012,553933030,553933032,553933033,553942020,553942021,553942023,553942201,553942203,553943010,553943011,553943012,553952120,553952121,553952122,553952220,553952221,553952222,553952300,553952302,553952320,5539012302,5539012311,5539012313,5539013003,5539013010,5539013012,5539013013,5539013021,5539013023,5539013122,5539013300,5539013302,5539013303,5539022322,5539110120,5539110121,5539110123,5539110233,5539110301,5539110302,5539110303,5539112011,5539112012,5539112013,5539112031,5539112321,5539120112,5539120113,5539121032,5539121300,5539121302,5539121303,5539121330,5539121332,5539121333,5539123330,5539123331,5539123332,5539132022,5539132023,5539132220,5539132221,5539132230,5539210302,5539210303,5539210311,5539210312,5539210313,5539211001,5539211003,5539211021,5539211023,5539212101,5539212103,5539212331,5539212333,5539221100,5539221101,5539221102,5539221300,5539221302,5539221320,5539221322,5539223100,5539223102,5539223103,5539223112,5539223130,5539223132,5539232202,5539232203,5539310111,5539310112,5539310113,5539310121,5539310123,5539310301,5539310303,5539310321,5539311230,5539311231,5539311232,5539311330,5539312111,5539322201,5539322203,5539322221,5539322222,5539322223,5539330010,5539330012,5539330130,5539330132,5539330310,5539330312,5539330313,5539331220,5539331222,5539331223,5539333000,5539333001,5539333002,5539333020,5539333220,5539333222,5539411131,5539413333,5539420221,5539420223,5539422001,5539422003,5539422021,5539422023,5539430130,5539430131,5539430132,5539430300,5539430301,5539430302,5539430310,5539430320,5539430322,5539431000,5539431002,5539432100,5539432102,5539432120,5539432122,5539432200,5539432201,5539432202,5539432210,5539432220,5539432222,5539511111,5539511113,5539511131,5539511133,5539511310,5539511311,5539511313,5539511331,5539511333,5539513111,5539521230,5539521232,5539521300,5539522230,5539522300,5539522301,5539522310,5539522311,5539522313,5539523010,5539523012,5539523030,5539523230,5539530000,5539530002,5539530020,5539530022,5539611111,5539611113,5539611131,5539620000,5539620001,5539620002,5539620020,5539620022,55390112322,55390112323,55390112332,55390121333,55390122133,55390122311,55390122313,55390122331,55390122333,55390123030,55390123032,55390123033,55390123121,55390123122,55390123123,55390130012,55390130013,55390130110,55390130112,55390130221,55390130222,55390130223,55390131022,55390131200,55390131202,55390131203,55390131230,55390131232,55390133010,55390133012,55390133013,55390133102,55390133120,55390133122,55390133123,55390133132,55390133133,55390222022,55390222032,55390222122,55390222123,55390222132,55390223200,55390223202,55390223203,55390223230,55390223232,55391100111,55391101220,55391101221,55391101223,55391102131,55391102133,55391102303,55391102311,55391102312,55391102313,55391102321,55391102323,55391103001,55391103002,55391103003,55391120101,55391120102,55391120103,55391120301,55391120303,55391120331,55391120333,55391123201,55391123231,55391201102,55391201103,55391210022,55391210023,55391210302,55391210303,55391210330,55391210332,55391213010,55391213012,55391213013,55391213102,55391213120,55391213122,55391213312,55391213313,55391233330,55391233331,55391233332,55391320200,55391320202,55391320203,55391320212,55391320213,55391322102,55391322120,55391322122,55391322123,55391322132,55391322220,55391322221,55391322230,55391322310,55391322312,55392101101,55392101110,55392101111,55392101333,55392102113,55392102131,55392102133,55392102311,55392102313,55392102331,55392102333,55392103002,55392103003,55392103012,55392103013,55392103101,55392103102,55392103103,55392110000,55392110001,55392110222,55392110223,55392121000,55392121001,55392121003,55392123301,55392123303,55392123321,55392123323,55392211030,55392211031,55392211032,55392211100,55392211101,55392211102,55392211110,55392211120,55392211200,55392211201,55392211202,55392211220,55392211222,55392213012,55392213030,55392213032,55392213210,55392213212,55392213213,55392213230,55392213232,55392231010,55392231012,55392231013,55392231102,55392231103,55392231112,55392231130,55392231132,55392231310,55392231312,55392231330,55392231332,55392231333,55392322000,55392322002,55392322003,55392322012,55392322120,55392322122,55392322300,55392322302,55392322320,55392322322,55393101101,55393101103,55393103231,55393112330,55393112331,55393112333,55393113310,55393113311,55393113313,55393113320,55393113322,55393113331,55393113333,55393121101,55393130000,55393130010,55393130111,55393131000,55393131001,55393131010,55393131011,55393131100,55393131111,55393131113,55393131131,55393131133,55393131311,55393131331,55393131333,55393133111,55393222000,55393222001,55393222003,55393222021,55393222023,55393222201,55393222202,55393222203,55393300112,55393300130,55393300132,55393300133,55393301022,55393301033,55393301122,55393301123,55393301312,55393301330,55393301332,55393303110,55393303112,55393303113,55393312020,55393312022,55393312023,55393312210,55393312212,55393312213,55393312320,55393312322,55393330030,55393330031,55393330032,55393330100,55393330102,55393330120,55393330210,55393332022,55393332023,55394111111,55394111113,55394111131,55394111133,55394111331,55394111333,55394113111,55394113113,55394113131,55394113133,55394131333,55394133111,55394133113,55394133131,55394133133,55394133311,55394133313,55394133323,55394202200,55394202201,55394202203,55394202221,55394202223,55394220201,55394220203,55394220221,55394220222,55394220223,55394301330,55394301332,55394303030,55394303031,55394303032,55394303110,55394303112,55394303210,55394303212,55394303230,55394303232,55394321010,55394321011,55394321012,55394321030,55394321032,55394321210,55394321212,55394321230,55394321232,55394322030,55394322031,55394322032,55394322120,55394322210,55395111101,55395111103,55395111121,55395111123,55395111301,55395111303,55395111321,55395111322,55395111323,55395113120,55395113121,55395113123,55395113301,55395113303,55395113321,55395113323,55395131130,55395131131,55395131133,55395131311,55395131313,55395131331,55395131333,55395133111,55395133331,55395133332,55395133333,55395212310,55395212311,55395213010,55395213011,55395213012,55395213020,55395213021,55395213030,55395213100,55395213101,55395213110,55395213111,55395222310,55395222311,55395222312,55395222320,55395222321,55395222322,55395222330,55395223020,55395223021,55395223030,55395223031,55395223120,55395223121,55395223123,55395223301,55395223310,55395223311,55395230320,55395230322,55395232100,55395232102,55395232120,55395232122,55395232200,55395232201,55395232210,55395232211,55395232213,55395232231,55395232320,55395232321,55395232330,55395232331,55395300232,55395302000,55395302002,55395302020,55396111303,55396111331,55396202000,55396202001,
033,00,/,500400000,130406250,502129687,131868750,4,13,27,82,172,386,543941,543951,543952,543962,5439312,5439313,5439320,5439322,5439403,5439420,5439422,5439501,5439503,5439601,5439610,5439611,5439632,54393033,54393103,54393111,54393112,54393113,54394011,54394012,54394013,54394021,54394023,54394230,54394232,54395023,54395320,54395322,54396001,54396003,54396030,54396031,54396032,54396120,54396130,54396131,54396300,54396302,54397210,54397211,543922222,543922232,543922233,543922320,543922322,543922323,543930133,543930311,543930312,543930313,543931021,543931022,543931023,543931102,543931103,543932100,543932101,543932300,543932302,543932320,543932322,543940031,543940033,543940101,543940103,543940223,543942100,543942102,543942120,543942122,543942123,543942130,543942132,543942310,543942312,543942330,543942332,543942333,543950010,543950011,543950013,543950031,543950033,543950211,543950212,543950213,543950223,543953002,543953020,543953022,543953023,543953212,543953230,543960210,543960211,543960213,543960330,543960331,543961210,543961211,543961212,543961220,543961221,543961330,543961331,543963012,543963030,543963032,543963302,543963320,543963322,543963323,543972011,543972120,543972121,543973000,543973001,543973002,543973010,543973011,543973100,543973101,5439213331,5439213332,5439213333,5439222230,5439222232,5439222233,5439222311,5439222313,5439223023,5439223210,5439223212,5439223322,5439301313,5439301321,5439301323,5439303033,5439303101,5439303102,5439303103,5439303231,5439303232,5439303233,5439310133,5439310201,5439310203,5439311003,5439311011,5439311012,5439311013,5439321022,5439321100,5439321200,5439321202,5439321220,5439321222,5439323012,5439323030,5439323032,5439323210,5439323212,5439323230,5439323232,5439400132,5439400133,5439400233,5439400303,5439400321,5439400322,5439400323,5439401021,5439401022,5439401023,5439402031,5439402033,5439402203,5439402212,5439402213,5439402221,5439402223,5439421010,5439421210,5439421212,5439421213,5439421310,5439421312,5439421330,5439423132,5439423310,5439423312,5439423313,5439500000,5439500001,5439500003,5439500010,5439500011,5439500012,5439500021,5439500121,5439500123,5439500301,5439500303,5439500321,5439500323,5439502033,5439502101,5439502102,5439502103,5439502211,5439502213,5439530000,5439530002,5439530003,5439530210,5439530212,5439530213,5439532100,5439532102,5439532103,5439532112,5439532130,5439532320,5439532322,5439600011,5439600013,5439600031,5439600033,5439600211,5439600213,5439602121,5439602123,5439602301,5439602310,5439602311,5439602313,5439602331,5439602333,5439603320,5439603321,5439603330,5439603331,5439612130,5439612131,5439612132,5439612221,5439612230,5439612231,5439612300,5439612302,5439613201,5439613210,5439613211,5439613213,5439613330,5439613331,5439613333,5439630100,5439630102,5439630103,5439630132,5439630310,5439630312,5439630330,5439630332,5439633030,5439633032,5439633210,5439633212,5439633213,5439633320,5439633322,5439720000,5439720001,5439720010,5439720011,5439720100,5439720101,5439720131,5439720133,5439720311,5439720313,5439721220,5439721221,5439721223,5439721230,5439721231,5439721300,5439721301,5439730120,5439730121,5439731021,5439731030,5439731031,54392133231,54392133232,54392133233,54392133301,54392133302,54392133303,54392221333,54392222032,54392222033,54392222122,54392222123,54392222313,54392223033,54392223122,54392223123,54392230222,54392230223,54392230320,54392230322,54392230323,54392232132,54392232133,54392233022,54392233200,54392233202,54392233203,54392233230,54392233232,54393013032,54393013033,54393013121,54393013122,54393013123,54393013201,54393013202,54393013203,54393013220,54393013221,54393013223,54393030311,54393030313,54393031001,54393031003,54393032111,54393032113,54393032131,54393032133,54393032233,54393032301,54393032302,54393032303,54393101232,54393101233,54393101311,54393101312,54393101313,54393101321,54393101322,54393101323,54393102020,54393102022,54393102023,54393110023,54393210200,54393210201,54393210202,54393210210,54393210211,54393210230,54393210232,54393210300,54393210301,54393210310,54393210311,54393211010,54393211012,54393211020,54393211021,54393211022,54393211200,54393212010,54393212012,54393212030,54393212032,54393212210,54393212212,54393212230,54393212232,54393212233,54393230100,54393230102,54393230103,54393232132,54393232310,54393232312,54394001213,54394001231,54394001233,54394001302,54394001303,54394001312,54394001313,54394003011,54394003013,54394003201,54394003203,54394010011,54394010013,54394010031,54394010032,54394010033,54394010202,54394010203,54394020110,54394020111,54394020113,54394020131,54394020133,54394020301,54394020303,54394020321,54394022012,54394022013,54394022102,54394022103,54394022111,54394022113,54394022203,54394022221,54394022222,54394022223,54394210120,54394210121,54394210122,54394210300,54394210302,54394210320,54394210322,54394210323,54394211232,54394211233,54394211322,54394212111,54394212113,54394213110,54394213112,54394213130,54394213320,54394213321,54394213322,54394231100,54394231102,54394231120,54394231122,54394231300,54394231302,54394233110,54394233112,54394233113,54394322220,54394322222,54395000020,54395000021,54395000023,54395000131,54395000133,54395000201,54395000203,54395000221,54395000230,54395000231,54395000300,54395000301,54395000302,54395000311,54395001200,54395001201,54395001203,54395001221,54395020133,54395020311,54395020313,54395021001,54395021003,54395022101,54395022103,54395022121,54395022122,54395022123,54395300012,54395300120,54395300122,54395300300,54395300302,54395300320,54395300322,54395300323,54395300332,54395302110,54395302112,54395303022,54395303200,54395303201,54395303202,54395321012,54395321013,54395321101,54395321102,54395321103,54395321112,54395321130,54395321320,54395321321,54395321322,54395323100,54395323102,54395323210,54395323212,54395323230,54395323232,54396000101,54396000103,54396000121,54396000123,54396000301,54396000303,54396000321,54396000323,54396002101,54396002103,54396002121,54396002311,54396002313,54396002331,54396002333,54396020111,54396020113,54396021200,54396021201,54396023121,54396023123,54396023301,54396023303,54396023321,54396023323,54396033220,54396033221,54396033230,54396033231,54396033320,54396033321,54396121330,54396121331,54396121332,54396122200,54396122201,54396122203,54396123010,54396123011,54396123012,54396123030,54396123032,54396123100,54396123200,54396123201,54396132000,54396132001,54396132003,54396132030,54396132031,54396132120,54396132121,54396132123,54396132311,54396133200,54396133201,54396133210,54396133211,54396133213,54396133320,54396133321,54396133323,54396301010,54396301012,54396301013,54396301122,54396301300,54396301302,54396301303,54396301330,54396301332,54396303110,54396303112,54396303113,54396303130,54396303132,54396303310,54396303312,54396303330,54396303332,54396312002,54396330022,54396330033,54396330122,54396330330,54396330332,54396332110,54396332112,54396332113,54396333000,54396333002,54396333020,54396333022,54396333212,54396333230,54397001101,54397001110,54397001111,54397010000,54397010001,54397010010,54397010011,54397010100,54397010101,54397111101,54397111110,54397111111,54397111113,54397200030,54397200031,54397200120,54397200121,54397200130,54397200131,54397201020,54397201030,54397201031,54397201033,54397201301,54397201303,54397201321,54397201323,54397203101,54397203103,54397203311,54397212220,54397212221,54397212223,54397212320,54397212321,54397212322,54397212330,54397213020,54397213021,54397213022,54397213100,54397213101,54397213110,54397213111,54397213200,54397230010,54397230011,54397230013,54397300300,54397300301,54397300302,54397300310,54397300311,54397300320,54397301300,54397301301,54397301302,54397301310,54397301311,54397302000,54397302001,54397302010,54397310200,54397310201,54397310231,54397310330,54397311000,54397311002,54397311020,54397311022,54397311200,
034,00,/,501539062,130256250,502790625,130893750,0,3,11,46,84,195,5439233,5439242,5439243,54392313,54392323,54392402,54393213,54393231,54393233,54393300,54393301,54393302,54393320,54393322,543923121,543923122,543923123,543923211,543923212,543923213,543923221,543923222,543923223,543924030,543924032,543924033,543924122,543924133,543925022,543925023,543925200,543925201,543925202,543925220,543932111,543932113,543932121,543932123,543933030,543933031,543933032,543933100,543933101,543933102,543933110,543933111,543933120,543933210,543934000,543934001,543934003,543934010,543934011,543934100,543934101,543934110,543934111,543942110,543942111,543943000,5439223333,5439230333,5439231201,5439231203,5439232031,5439232032,5439232033,5439232103,5439232201,5439232203,5439240312,5439241232,5439241311,5439241312,5439241313,5439241321,5439241322,5439241323,5439250022,5439250200,5439250202,5439250203,5439250212,5439250213,5439252030,5439252031,5439252032,5439252100,5439252220,5439252222,5439321032,5439321033,5439321103,5439321121,5439321122,5439321123,5439323011,5439323013,5439323031,5439323033,5439323211,5439323233,5439330330,5439330331,5439330332,5439331030,5439331031,5439331120,5439331121,5439331130,5439331131,5439331212,5439331220,5439332110,5439332120,5439332121,5439332122,5439332300,5439332302,5439332320,5439340020,5439340021,5439340023,5439340120,5439340121,5439340122,5439340130,5439341131,5439350000,5439350002,5439350020,5439421011,5439421013,5439421031,5439421033,5439421120,5439421121,5439421122,5439421130,5439421131,5439421133,5439430010,5439430020,5439430021,54392233233,54392233303,54392233311,54392233312,54392233313,54392233321,54392233322,54392233323,54392303233,54392303311,54392303312,54392303313,54392303321,54392303322,54392303323,54392310322,54392310323,54392310332,54392310333,54392311222,54392311223,54392311232,54392311233,54392311322,54392311323,54392311332,54392311333,54392312021,54392312022,54392312023,54392320233,54392320303,54392321011,54392321012,54392321013,54392321022,54392321023,54392322021,54392322022,54392322023,54392400222,54392400233,54392400322,54392400323,54392400332,54392400333,54392401222,54392401223,54392401232,54392403102,54392403103,54392403130,54392403132,54392403133,54392411323,54392411331,54392411332,54392411333,54392412022,54392412023,54392412032,54392412300,54392412302,54392412303,54392412330,54392412332,54392412333,54392413033,54392413101,54392413102,54392413103,54392413203,54392502010,54392502012,54392502013,54392502102,54392502103,54392502112,54392502113,54392503002,54392503020,54392503022,54392503200,54392503221,54392503222,54392503223,54392520330,54392520331,54392520332,54392521020,54392521021,54392521022,54392521200,54392521202,54392522110,54392522210,54392522212,54393210203,54393210212,54393210213,54393210231,54393210233,54393210302,54393210303,54393210312,54393210313,54393211011,54393211013,54393211023,54393211201,54393211202,54393211203,54393212011,54393212013,54393212031,54393212033,54393212211,54393212213,54393212231,54393230101,54393232130,54393232131,54393232133,54393232311,54393232313,54393303330,54393310320,54393310321,54393310322,54393310330,54393311321,54393311330,54393311331,54393312100,54393312102,54393312210,54393312211,54393312221,54393312300,54393312301,54393321120,54393321122,54393323212,54393323213,54393323220,54393323221,54393323222,54393323230,54393323231,54393323302,54393400220,54393400221,54393401230,54393401231,54393401310,54393401312,54393401320,54393401321,54393402101,54393402110,54393402111,54393402113,54393403000,54393403001,54393410310,54393410311,54393411200,54393411201,54393411210,54393411211,54393411300,54393411301,54393411331,54394210123,54394210301,54394210303,54394210321,54394211230,54394211231,54394211320,54394211321,54394211323,54394212110,54394212112,54394213111,54394300110,54394300111,54394300112,54394300120,54394300121,54394300122,54394300220,54394300221,54394300222,54394300230,
035,00,,498881250,129525000,500878125,131100000,5,18,37,84,180,374,543816,543826,543827,543836,543837,5438053,5438062,5438151,5438152,5438153,5438172,5438173,5438251,5438252,5438253,5438351,5438353,5438451,5438460,5439200,5439202,5439300,5439302,54380503,54380510,54380512,54380513,54380521,54380523,54380632,54381501,54381503,54381700,54381702,54381703,54382501,54382503,54383500,54383501,54383503,54383521,54383523,54384501,54384503,54384521,54384530,54384531,54384610,54384611,54384620,54384700,54384710,54384711,54391020,54391022,54391023,54392032,54393010,54393012,54394000,533875322,533875323,533875332,543805012,543805013,543805021,543805023,543805110,543805112,543805113,543805221,543805223,543806022,543806023,543806032,543806033,543806122,543806300,543806302,543806303,543806330,543806332,543806333,543814312,543814313,543814330,543814331,543814333,543815001,543815023,543817011,543817012,543817013,543817102,543817120,543817122,543824333,543825001,543825003,543825020,543825021,543825023,543834111,543834113,543834131,543835020,543835021,543835023,543845230,543845231,543845320,543845321,543845330,543845331,543846120,543846121,543846122,543846130,543846131,543846210,543847010,543847011,543847013,543847020,543847130,543847131,543847132,543910210,543910212,543920122,543920300,543920302,543920303,543920332,543930110,543930112,543930300,543930301,543930302,543930320,543940010,543940011,543940020,543940021,5338753202,5338753203,5338753211,5338753212,5338753213,5338753332,5438050033,5438050103,5438050111,5438050112,5438050113,5438050201,5438050203,5438050221,5438051110,5438051112,5438051113,5438052011,5438052013,5438052031,5438052033,5438052221,5438052223,5438060200,5438060202,5438060303,5438060312,5438060313,5438061230,5438061232,5438063010,5438063012,5438063013,5438063120,5438063122,5438063310,5438063312,5438072222,5438072223,5438143103,5438143112,5438143113,5438143231,5438143232,5438143233,5438143320,5438143321,5438143322,5438150001,5438150003,5438150031,5438150033,5438150211,5438150212,5438150213,5438170100,5438170102,5438170103,5438171002,5438171032,5438171210,5438171212,5438171230,5438171232,5438171233,5438171303,5438171312,5438171321,5438171322,5438171323,5438171330,5438171332,5438171333,5438241011,5438241013,5438243113,5438243131,5438243133,5438243311,5438243313,5438243323,5438250001,5438250003,5438250021,5438250023,5438250221,5438250223,5438341101,5438341103,5438341121,5438341123,5438341301,5438341331,5438350220,5438350221,5438350223,5438352011,5438352033,5438352211,5438450011,5438450013,5438450031,5438452011,5438452211,5438452213,5438452321,5438452330,5438452331,5438452333,5438453220,5438453221,5438453231,5438453320,5438453321,5438453330,5438461230,5438461231,5438461232,5438461320,5438461321,5438461323,5438461330,5438461331,5438461332,5438462110,5438462111,5438462112,5438462120,5438462200,5438462201,5438462202,5438470120,5438470121,5438470122,5438470210,5438470220,5438471210,5438471211,5438471213,5438471231,5438471330,5438471332,5439100222,5439103202,5439103220,5439201022,5439201200,5439201202,5439201232,5439203010,5439203012,5439203300,5439203302,5439301110,5439301112,5439301130,5439301132,5439301133,5439301300,5439301301,5439301302,5439301310,5439301311,5439303030,5439303032,5439303210,5439303212,5439303220,5439303221,5439303222,5439310200,5439400120,5439400122,5439400221,5439400230,5439400231,5439400300,5439400302,5439401000,5439401002,53387523311,53387523313,53387523331,53387523332,53387523333,53387532013,53387532101,53387532102,53387532103,53387533000,53387533020,53387533022,53387533023,53387533032,53387533302,54380500312,54380500313,54380500321,54380500322,54380500323,54380501023,54380502231,54380502233,54380511110,54380511112,54380511113,54380520011,54380520100,54380520101,54380520103,54380520121,54380520123,54380520301,54380520303,54380520321,54380520323,54380522033,54380522223,54380600020,54380600022,54380600200,54380600202,54380600220,54380600222,54380600223,54380600232,54380602010,54380602012,54380602030,54380602032,54380602033,54380603012,54380603013,54380603021,54380603022,54380603023,54380603102,54380603103,54380612020,54380612022,54380612023,54380612032,54380612332,54380630110,54380630112,54380630113,54380631002,54380631020,54380631022,54380631232,54380633130,54380633132,54380722200,54380722202,54380722203,54380722322,54380722323,54380722332,54380723323,54380723332,54380723333,54380732222,54381430333,54381431023,54381431102,54381431103,54381431111,54381431112,54381431113,54381432111,54381432113,54381432123,54381432131,54381432132,54381432133,54381432301,54381432303,54381433230,54381433231,54381433232,54381500001,54381500211,54381500300,54381500301,54381500303,54381500321,54381500323,54381502101,54381502103,54381502231,54381502233,54381701010,54381701012,54381701013,54381710000,54381710002,54381710003,54381710012,54381710030,54381710032,54381710033,54381710300,54381710302,54381710332,54381712110,54381712112,54381712132,54381712310,54381712312,54381713132,54381713201,54381713202,54381713203,54381713310,54381713312,54381713313,54382410100,54382410101,54382410103,54382410121,54382410123,54382411000,54382411022,54382411101,54382411110,54382411111,54382413111,54382413113,54382413131,54382413133,54382431111,54382431113,54382431123,54382431301,54382431303,54382431321,54382431323,54382433101,54382433103,54382433121,54382433122,54382433123,54382433211,54382433212,54382433213,54382500000,54382500001,54382500003,54382500201,54382500203,54382500221,54382500222,54382500223,54382502200,54382502201,54382502203,54383413030,54383413031,54383413301,54383413303,54383413331,54383502220,54383502221,54383520011,54383520101,54383520103,54383520130,54383520131,54383520133,54383520311,54383520313,54383522131,54383522133,54383522311,54383522313,54383522331,54383522332,54383522333,54384500330,54384500331,54384500333,54384502111,54384502113,54384502131,54384502133,54384502311,54384502313,54384502331,54384502332,54384502333,54384520131,54384520133,54384520311,54384520313,54384520331,54384520332,54384520333,54384522311,54384523200,54384523201,54384523321,54384532220,54384532222,54384532300,54384532301,54384532331,54384532333,54384533220,54384533221,54384533222,54384533230,54384533310,54384533311,54384612330,54384612331,54384612332,54384613220,54384613221,54384613330,54384613331,54384621130,54384621210,54384621211,54384621220,54384622030,54384622100,54384622101,54384622102,54384630000,54384630001,54384630002,54384630010,54384630011,54384701230,54384701231,54384701232,54384702110,54384702111,54384702112,54384702120,54384702121,54384702122,54384702210,54384702211,54384703000,54384703001,54384703111,54384712000,54384712001,54384712010,54384712121,54384712123,54384712301,54384712303,54384712330,54384712331,54384712333,54384713310,54384730111,54384731000,54384731001,54384731010,54384731011,54384731100,54391002232,54391002333,54391003222,54391003223,54391003232,54391003233,54391003322,54391021100,54391021102,54391021320,54391021322,54391021323,54391032000,54391032002,54391032220,54391032222,54392010000,54392010002,54392010020,54392010022,54392010200,54392010202,54392010203,54392012030,54392012032,54392012302,54392030110,54392030112,54392030130,54392030132,54392030133,54392031202,54392031220,54392031222,54392031223,54392033012,54392033030,54392033032,54392033320,54392033322,54392033323,54393011310,54393011312,54393011313,54393013030,54393013031,54393013120,54393013200,54393013222,54393030310,54393030312,54393031000,54393031002,54393032110,54393032112,54393032130,54393032132,54393032230,54393032231,54393032232,54393032300,54393100220,54393100222,54393100223,54393102021,54394001210,54394001211,54394001212,54394001230,54394001232,54394001300,54394001301,54394001310,54394001311,54394002201,54394002230,54394002231,54394002320,54394002321,54394002323,54394003010,54394003012,54394003200,54394003202,54394010010,54394010012,54394010030,54394010200,54394010201,54394020101,
036,00,˹/̾/,498220312,130865625,500582812,132346875,9,15,34,73,183,456,543854,543855,543856,543857,543864,543865,543866,543867,543875,5438472,5438531,5438533,5438631,5438633,5438740,5438741,5438743,5438760,5438761,5438762,5438770,5538050,5538051,5538060,54384623,54384631,54384632,54384633,54384732,54384733,54385303,54385321,54385323,54386301,54387310,54387311,54387313,54387420,54387421,54387423,54387630,54387631,54387710,54387712,54387720,54387721,54387730,54395002,54396022,55380401,55380410,55380411,55380413,55380521,55380530,55380531,55380533,55380620,543843332,543843333,543844223,543844230,543844232,543846213,543846222,543846223,543846301,543846302,543846303,543847023,543847032,543847033,543847122,543847300,543847302,543847303,543847312,543847313,543853012,543853013,543863031,543863033,543873310,543873311,543876320,543876321,543876322,543876330,543876331,543877110,543877111,543877112,543877130,543877132,543877220,543877221,543877230,543877231,543877310,543877311,543877312,543877320,543940200,543940202,543950200,543950202,543950220,543950222,543960000,543960002,543960020,543960022,543960200,543960202,543960203,543960232,553804031,553804120,553804121,553805200,553805201,553806100,553806102,553806120,553806122,553806210,553806212,553806220,553806221,553806222,553806230,5438433213,5438433231,5438433233,5438433302,5438433303,5438433310,5438433312,5438442212,5438442213,5438442221,5438442222,5438442223,5438442312,5438442330,5438442332,5438442333,5438452222,5438452223,5438452232,5438452233,5438452322,5438452323,5438453223,5438453232,5438453332,5438453333,5438462123,5438462211,5438462212,5438462213,5438463002,5438463003,5438470213,5438470222,5438470223,5438470301,5438470302,5438470303,5438470310,5438470312,5438470313,5438471202,5438471203,5438471232,5438471333,5438473010,5438473012,5438473013,5438473102,5438473103,5438473111,5438473112,5438473113,5438530112,5438530113,5438530231,5438530233,5438532031,5438532033,5438532211,5438532213,5438532231,5438630301,5438630303,5438630321,5438630323,5438632110,5438632111,5438632113,5438632131,5438632133,5438632311,5438632312,5438632313,5438632330,5438632331,5438632333,5438730111,5438730113,5438730131,5438731201,5438731210,5438731211,5438731213,5438731231,5438731233,5438733011,5438733013,5438733120,5438733121,5438733123,5438733130,5438733131,5438733132,5438742211,5438763230,5438763231,5438763320,5438763321,5438763323,5438763330,5438763331,5438763333,5438771130,5438771132,5438771310,5438771312,5438771330,5438771332,5438772220,5438772221,5438772331,5438773130,5438773132,5438773210,5438773211,5438773300,5439400222,5439402012,5439402200,5439402202,5439500032,5439500033,5439500300,5439500302,5439500320,5439500322,5439502010,5439502011,5439502012,5439502030,5439502032,5439600230,5439600232,5439602010,5439602012,5439602013,5439602122,5439602300,5439602302,5439602303,5538040011,5538040013,5538040031,5538040033,5538040211,5538040300,5538040301,5538040303,5538040321,5538040330,5538040331,5538041220,5538041221,5538041230,5538041231,5538043100,5538043111,5538052030,5538052031,5538053200,5538053201,5538053210,5538053211,5538062110,5538062111,5538062112,5538062130,5538062132,5538062230,5538062231,5538062232,5538062310,5538062320,5538062321,5538063000,5538151100,5538151101,5538151103,5538151110,5538151111,5538151112,5538160000,54384331323,54384331332,54384332103,54384332112,54384332113,54384332121,54384332123,54384332223,54384332232,54384332233,54384332301,54384332303,54384332321,54384332322,54384332323,54384333002,54384333003,54384333011,54384333012,54384333013,54384333110,54384333112,54384333130,54384333132,54384422033,54384422111,54384422112,54384422113,54384422202,54384422203,54384423102,54384423312,54384432222,54384432223,54384432232,54384432233,54384432322,54384432323,54384432332,54384432333,54384433222,54384433232,54384433233,54384433323,54384433331,54384433332,54384433333,54384522123,54384522301,54384522302,54384522303,54384522310,54384522312,54384522313,54384523202,54384523203,54384523320,54384523322,54384523323,54384532221,54384532223,54384532302,54384532303,54384532330,54384532332,54384533223,54384533231,54384533232,54384533233,54384533312,54384533313,54384612333,54384613222,54384613223,54384613332,54384613333,54384621131,54384621132,54384621133,54384621212,54384621213,54384621221,54384621222,54384621223,54384622031,54384622032,54384622033,54384622103,54384630003,54384630012,54384630013,54384701233,54384702113,54384702123,54384702212,54384702213,54384703002,54384703003,54384703110,54384703112,54384703113,54384712002,54384712003,54384712011,54384712012,54384712013,54384712120,54384712122,54384712300,54384712302,54384712332,54384713311,54384713312,54384713313,54384730110,54384730112,54384730113,54384731002,54384731003,54384731012,54384731013,54384731101,54384731102,54384731103,54385300311,54385300313,54385300331,54385300333,54385301031,54385301032,54385301033,54385301103,54385301111,54385301112,54385301113,54385302111,54385302113,54385302131,54385302133,54385320110,54385320111,54385320113,54385320131,54385320132,54385320133,54385320323,54385322101,54385322103,54385322121,54385322123,54385322330,54385322331,54385322333,54386300111,54386300113,54386300131,54386300133,54386300311,54386300313,54386300331,54386300333,54386302111,54386303000,54386303001,54386303003,54386303203,54386303221,54386321010,54386321011,54386321121,54386321123,54386321301,54386321303,54386321321,54386321323,54386323101,54386323103,54386323320,54386323321,54386323323,54387301101,54387301103,54387301121,54387301123,54387301301,54387312000,54387312001,54387312003,54387312120,54387312121,54387312123,54387312301,54387312303,54387312321,54387312323,54387330101,54387330103,54387330121,54387330311,54387331221,54387331330,54387331331,54387422001,54387422010,54387422011,54387422100,54387422101,54387422131,54387422133,54387422311,54387422332,54387422333,54387632320,54387632321,54387632330,54387632331,54387633220,54387633221,54387633223,54387633320,54387633321,54387633323,54387711310,54387711312,54387711330,54387711332,54387713110,54387713112,54387713130,54387713132,54387713310,54387713312,54387713330,54387713332,54387722220,54387722221,54387722222,54387722300,54387722301,54387722311,54387723200,54387723201,54387723210,54387723211,54387723300,54387723301,54387723303,54387732120,54387732121,54387732122,54387732130,54387732131,54387732200,54387732201,54387732202,54387732210,54387733020,54387733021,54394002200,54394002202,54394002203,54394002232,54394002233,54394002322,54394020100,54394020102,54394020103,54394020112,54394020130,54394020132,54394020300,54394020302,54394020320,54394020322,54394020323,54394022010,54394022011,54394022100,54394022101,54394022110,54394022112,54394022200,54394022201,54394022202,54394022220,54395000022,54395000130,54395000132,54395000200,54395000202,54395000220,54395000222,54395000223,54395000232,54395000233,54395000303,54395000310,54395000312,54395000313,54395001202,54395001220,54395001222,54395001223,54395020130,54395020131,54395020132,54395020310,54395020312,54395021000,54395021002,54395022100,54395022102,54395022120,54396000100,54396000102,54396000120,54396000122,54396000300,54396000302,54396000320,54396000322,54396002100,54396002102,54396002120,54396002122,54396002123,54396002310,54396002312,54396002330,54396002332,54396020110,54396020112,54396021202,54396021203,54396023120,54396023122,54396023300,54396023302,54396023320,54396023322,54397000000,54397000001,54397000002,54397000010,54397000020,54397000100,54397000101,54397000110,54397000111,54397001000,54397001001,54397001003,54397001010,54397001011,54397001012,54397001100,55380400101,55380400103,55380400121,55380400123,55380400301,55380400303,55380400321,55380400322,55380400323,55380402100,55380402101,55380402103,55380402130,55380402131,55380403020,55380403021,55380403321,55380403330,55380403331,55380403333,55380412220,55380412221,55380412222,55380412230,55380412231,55380412233,55380412320,55380412321,55380412322,55380412330,55380412331,55380412333,55380430111,55380431010,55380431011,55380431012,55380431101,55380431130,55380431131,55380431133,55380520200,55380520201,55380520210,55380520211,55380520321,55380520330,55380520331,55380520333,55380523010,55380523011,55380523100,55380523101,55380523110,55380523111,55380523113,55380532020,55380532021,55380532030,55380532031,55380532120,55380532121,55380532130,55380532131,55380532133,55380532311,55380532313,55380611111,55380612100,55380612102,55380612120,55380612122,55380612300,55380612302,55380612320,55380621130,55380621131,55380621132,55380621310,55380621312,55380622330,55380622331,55380623120,55380623121,55380623122,55380623220,55380623221,55380630010,55380630020,55380700000,55381511021,55381511023,55381511130,55381511131,55381511132,55381511210,55381511211,55381511300,55381511301,55381600010,55381600020,
037,00,/,499640625,131615625,501721875,133406250,3,18,43,105,209,464,553900,553910,553920,5439702,5439703,5439710,5439712,5439713,5439722,5538071,5538072,5538073,5538170,5538171,5538173,5538271,5539010,5539020,5539300,5539301,5539303,54397002,54397003,54397011,54397012,54397013,54397110,54397112,54397113,54397202,55380613,55380631,55380632,55380633,55380701,55380702,55380703,55381611,55381613,55381631,55381720,55381721,55383713,55383731,55390110,55390111,55390113,55390120,55390220,55390221,55390230,55390232,55391122,55392100,55392120,55392122,55393020,55393021,55393100,55393102,55393120,55393122,55394011,55394013,543877323,543877331,543877332,543877333,543961233,543961322,543970002,543970003,543970012,543970013,543970102,543970103,543971110,543971112,543971113,543972002,543972003,543972012,543972030,543972032,543972302,543972320,543972322,553806101,553806103,553806110,553806112,553806113,553806233,553806301,553806302,553806303,553807001,553807002,553807003,553816100,553816101,553816103,553816121,553816123,553816301,553816303,553817221,553817230,553817231,553827013,553827031,553827033,553827300,553827301,553827302,553827310,553827311,553827313,553827331,553827333,553837111,553837112,553837113,553901120,553901121,553901122,553901210,553901211,553901212,553901220,553901222,553901311,553901313,553902100,553902102,553902120,553902122,553902123,553902230,553902231,553902233,553902310,553902312,553902330,553902332,553911000,553911002,553911003,553911020,553911022,553911200,553911202,553912101,553921010,553921012,553921020,553921022,553921212,553921230,553921232,553931010,553931210,553931212,553931230,553931232,553940310,553941000,553941001,553941002,5438772223,5438772232,5438772233,5438772322,5438772323,5438772332,5438772333,5438773131,5438773133,5438773222,5438773223,5438773301,5438773303,5439603333,5439612222,5439612223,5439612232,5439612233,5439612311,5439612312,5439612313,5439612321,5439612322,5439612323,5439613202,5439613230,5439613232,5439613233,5439613322,5439613323,5439700003,5439700012,5439700013,5439700102,5439700103,5439700112,5439700113,5439701002,5439701003,5439701011,5439701012,5439701013,5439711112,5439711113,5439720002,5439720312,5439720330,5439720332,5439720333,5439723000,5439723002,5439723003,5538061110,5538061112,5538061113,5538061211,5538061213,5538061231,5538061233,5538062133,5538062311,5538062313,5538063003,5538070001,5538070002,5538070003,5538160110,5538160111,5538160113,5538161021,5538163021,5538163023,5538172200,5538172201,5538172203,5538172320,5538172321,5538172330,5538172331,5538172333,5538270111,5538270113,5538270121,5538270123,5538270321,5538272110,5538272111,5538272113,5538272131,5538273030,5538273031,5538273032,5538273121,5538273123,5538273301,5538273303,5538273321,5538273323,5538371101,5538371102,5538371103,5539011230,5539011231,5539012130,5539012131,5539012132,5539012210,5539012211,5539012212,5539012230,5539012232,5539012300,5539012301,5539012310,5539013000,5539013002,5539013020,5539013100,5539013101,5539013103,5539013121,5539013311,5539021010,5539021012,5539021030,5539021032,5539021210,5539021212,5539021213,5539021320,5539021322,5539022200,5539022201,5539022210,5539022211,5539022321,5539023130,5539023132,5539023310,5539023312,5539110010,5539110012,5539110013,5539110210,5539110211,5539110212,5539112032,5539112322,5539120111,5539121000,5539121001,5539121003,5539121031,5539121100,5539121102,5539121120,5539121122,5539210112,5539210113,5539210130,5539210131,5539210132,5539210210,5539210212,5539210230,5539210232,5539211002,5539211020,5539212102,5539302210,5539302211,5539302300,5539302301,5539302310,5539302311,5539302313,5539302331,5539302333,5539310120,5539310122,5539310300,5539310302,5539310320,5539310322,5539312112,5539312130,5539312132,5539312310,5539312312,5539312313,5539312330,5539312332,5539401001,5539401010,5539401011,5539401013,5539401031,5539403110,5539403111,5539403112,5539403120,5539403121,5539410030,5539410032,5539410100,5539410200,5539410202,5539410220,5539410222,54387632322,54387632323,54387632332,54387632333,54387633222,54387633322,54387711311,54387711313,54387711331,54387711333,54387713111,54387713113,54387713131,54387713133,54387713311,54387713313,54387713331,54387713333,54387722223,54387722302,54387722303,54387722310,54387722312,54387722313,54387723202,54387723203,54387723212,54387723213,54387723302,54387732123,54387732132,54387732133,54387732203,54387732211,54387732212,54387732213,54387733022,54387733023,54396033222,54396033223,54396033232,54396033233,54396033322,54396033323,54396121333,54396122202,54396123013,54396123031,54396123033,54396123101,54396123102,54396123103,54396123202,54396123203,54396132002,54396132032,54396132033,54396132122,54396132310,54396132312,54396132313,54396133202,54396133203,54396133212,54396133322,54397000003,54397000011,54397000012,54397000013,54397000021,54397000022,54397000023,54397000102,54397000103,54397000112,54397000113,54397001002,54397001013,54397001102,54397001103,54397001112,54397001113,54397010002,54397010003,54397010012,54397010013,54397010102,54397010103,54397111100,54397111102,54397111103,54397111112,54397200032,54397200033,54397200122,54397200123,54397200132,54397200133,54397201021,54397201022,54397201023,54397201032,54397201300,54397201302,54397201320,54397201322,54397203100,54397203102,54397203310,54397203312,54397203313,54397212222,54397230012,54397230302,54397232302,54397232320,54397232322,54397232323,55380611110,55380611112,55380611113,55380612101,55380612103,55380612121,55380612123,55380612301,55380612303,55380612321,55380612322,55380612323,55380621133,55380621311,55380621313,55380623123,55380623230,55380623231,55380623233,55380630011,55380630012,55380630013,55380630021,55380630022,55380630023,55380700001,55380700002,55380700003,55381601011,55381601013,55381601031,55381601120,55381601121,55381601123,55381601310,55381601311,55381601313,55381610200,55381610201,55381610202,55381610230,55381610231,55381610233,55381612011,55381612013,55381630033,55381632010,55381632011,55381632100,55381632101,55381632110,55381632111,55381633000,55381633001,55381633010,55381633100,55381633101,55381633110,55381633111,55381633113,55381722020,55381722021,55381722023,55381722201,55381722210,55381722211,55381722300,55381722301,55381722310,55381722311,55381722313,55381723230,55381723231,55381723320,55381723321,55381723323,55382701101,55382701103,55382701121,55382701122,55382701123,55382703010,55382703011,55382703033,55382703230,55382703231,55382703233,55382721011,55382721120,55382721121,55382721123,55382721331,55382730330,55382730331,55382730332,55382731200,55382731201,55382731202,55383710133,55383710311,55383710313,55383710331,55383710333,55383711001,55383711003,55383712111,55383712113,55383712131,55383712133,55383712311,55383712313,55383712331,55383712333,55383730111,55383730113,55383730131,55383730133,55383730311,55383730313,55383730331,55383730333,55383732111,55383733000,55383733001,55383733100,55383733101,55383733110,55390112320,55390112321,55390112330,55390112331,55390112333,55390121330,55390121331,55390121332,55390122130,55390122131,55390122132,55390122310,55390122312,55390122330,55390122332,55390123031,55390123120,55390130010,55390130011,55390130111,55390130113,55390130220,55390131020,55390131021,55390131023,55390131201,55390131231,55390131233,55390133011,55390133100,55390133101,55390133103,55390133121,55390133130,55390133131,55390210132,55390210310,55390210312,55390210330,55390210332,55390212110,55390212112,55390212113,55390213022,55390213230,55390213232,55390222020,55390222021,55390222023,55390222030,55390222031,55390222033,55390222120,55390222121,55390222130,55390222131,55390222133,55390223201,55390223231,55390223233,55390231120,55390231122,55390231123,55390233300,55390233301,55390233302,55391100110,55391100112,55391100113,55391101222,55391102130,55391102132,55391102300,55391102301,55391102302,55391102310,55391102320,55391102322,55391103000,55391120100,55391120300,55391120302,55391120330,55391120332,55391123200,55391123202,55391123203,55391123230,55391123232,55391123233,55391201100,55391201101,55391210020,55391210021,55391210300,55391210301,55391210331,55391210333,55391211010,55391211212,55391211230,55391211232,55392101100,55392101102,55392101103,55392101112,55392101113,55392101330,55392101331,55392101332,55392102110,55392102111,55392102112,55392102130,55392102132,55392102310,55392102312,55392102330,55392102332,55392103000,55392103001,55392103010,55392103011,55392103100,55392110002,55392110003,55392110220,55392110221,55392121002,55392123300,55392123302,55392123320,55392123322,55393022000,55393022001,55393022010,55393022011,55393022013,55393022031,55393022120,55393022121,55393022130,55393023031,55393023120,55393023121,55393023123,55393023301,55393023303,55393023321,55393101100,55393101102,55393103230,55393103232,55393103233,55393121100,55393121102,55393121103,55393121130,55393121131,55393121132,55393121310,55393121312,55393121330,55393121332,55393123110,55393123112,55393123113,55393123310,55393123311,55393123312,55394001111,55394010000,55394010001,55394010030,55394010031,55394010120,55394010121,55394010123,55394010301,55394010331,55394010333,55394012111,55394012113,55394012131,55394012133,55394012311,55394012313,55394012331,55394012333,55394030111,55394030113,55394030131,55394031130,55394031300,55394031301,55394100310,55394100311,55394100312,55394100330,55394100332,55394101010,55394101011,55394101012,55394101020,55394101100,55394101101,55394102010,55394102011,55394102012,55394102030,55394102032,55394102100,55394102101,55394102210,55394102212,55394102230,55394120000,55394120001,55394120002,
038,00,/,498684375,132253125,501328125,134690625,15,19,68,135,346,665,553826,553835,553836,553845,553846,553847,553855,553856,553857,553866,553867,553877,553950,553960,553970,5538162,5538252,5538253,5538370,5538372,5538443,5538541,5538543,5538651,5538760,5538761,5538763,5539402,5539510,5539512,5539712,5639000,5639001,5639010,55381512,55381513,55381531,55381532,55381533,55381602,55381603,55382511,55382512,55382513,55382700,55382702,55382720,55382722,55382723,55382732,55383411,55383413,55383431,55383433,55384403,55384411,55384412,55384413,55385403,55386501,55386530,55386531,55387621,55387623,55393132,55394000,55394002,55394003,55394032,55394033,55394103,55394110,55394112,55394121,55394122,55394123,55394130,55394132,55395110,55395112,55395130,55395132,55396100,55396101,55396102,55396120,55396122,55397100,55397102,55397103,55397132,56380601,56380701,56380710,56380711,56390021,56390030,56390031,56390110,56390112,56390120,56390121,553815031,553815101,553815102,553815103,553815301,553815303,553816001,553816002,553816003,553816012,553816122,553816322,553816323,553816332,553816333,553824332,553824333,553825032,553825033,553825101,553825103,553827010,553827212,553834323,553837100,553837102,553837120,553837122,553837300,553837302,553837320,553837322,553837323,553837332,553837333,553844101,553844103,553844211,553844213,553844231,553844233,553854011,553854012,553854013,553854210,553854211,553865031,553865033,553865331,553865333,553876200,553876201,553876203,553876220,553876221,553876223,553930222,553930223,553930232,553931302,553931303,553931312,553931330,553931332,553931333,553940010,553940012,553940013,553940102,553940120,553940122,553940300,553940302,553940303,553941012,553941013,553941023,553941110,553941112,553941130,553941132,553941133,553941201,553941202,553941203,553941310,553941311,553941312,553941330,553941332,553951110,553951112,553951130,553951132,553951310,553951312,553951330,553951332,553961030,553961031,553961032,553961100,553961101,553961110,553961210,553971012,553971122,553971300,553971302,563806001,563806003,563806021,563806023,563806030,563806031,563806032,563806100,563806102,563806111,563807000,563807001,563807031,563807033,563807120,563807121,563807130,563807131,563807132,563900330,563900331,563901132,563901230,563901231,563901300,563901302,5538053221,5538053223,5538053230,5538053232,5538053233,5538150131,5538150132,5538150133,5538150331,5538151001,5538151002,5538151003,5538151120,5538151122,5538151123,5538151131,5538151132,5538151133,5538152311,5538152313,5538153000,5538153001,5538153003,5538153021,5538153022,5538153023,5538160003,5538160100,5538160102,5538160130,5538160132,5538160133,5538161022,5538161200,5538161202,5538161203,5538163000,5538163001,5538163002,5538163020,5538163022,5538163200,5538163202,5538163203,5538163212,5538163213,5538163302,5538163303,5538163312,5538163313,5538172222,5538172223,5538172232,5538172233,5538172322,5538243131,5538243133,5538243302,5538243303,5538243311,5538243312,5538243313,5538250233,5538250312,5538250313,5538251001,5538251003,5538251021,5538251023,5538270120,5538270122,5538270300,5538270302,5538270320,5538270322,5538272100,5538272102,5538272103,5538272130,5538272132,5538273122,5538273300,5538273302,5538273320,5538273322,5538341013,5538341031,5538341033,5538341211,5538341213,5538341231,5538341233,5538343011,5538343013,5538343031,5538343033,5538343211,5538343213,5538371010,5538371011,5538371012,5538371030,5538371032,5538371210,5538371212,5538371230,5538371232,5538373010,5538373012,5538373030,5538373032,5538373210,5538373212,5538373213,5538373301,5538373302,5538373303,5538373312,5538373313,5538440123,5538440132,5538440213,5538441001,5538441003,5538441021,5538441022,5538441023,5538442101,5538442103,5538442121,5538442123,5538442301,5538442303,5538442321,5538442323,5538540101,5538540102,5538540103,5538540211,5538542130,5538542131,5538542133,5538542311,5538641111,5538641113,5538650000,5538650001,5538650002,5538650010,5538650011,5538650013,5538650031,5538650300,5538650301,5538650303,5538650321,5538652110,5538652111,5538652113,5538652131,5538652132,5538652133,5538652311,5538653200,5538653201,5538653210,5538653211,5538653300,5538653303,5538751111,5538751113,5538751311,5538762021,5538762022,5538762023,5538762220,5538762221,5538762223,5539302202,5539302302,5539312333,5539313002,5539313003,5539313010,5539313012,5539313013,5539313102,5539313103,5539313112,5539313130,5539313132,5539313310,5539313312,5539313313,5539400110,5539400112,5539400113,5539401002,5539401032,5539401210,5539401212,5539401230,5539401232,5539403010,5539403012,5539403122,5539403123,5539403131,5539403132,5539403133,5539410103,5539410111,5539410112,5539410113,5539410211,5539410212,5539410213,5539411110,5539411112,5539411130,5539411132,5539411310,5539411312,5539412001,5539412002,5539412003,5539413130,5539413131,5539413132,5539413310,5539413312,5539413330,5539422000,5539422002,5539513110,5539513112,5539513130,5539513132,5539513310,5539513312,5539513313,5539513330,5539513331,5539513332,5539610330,5539610331,5539610332,5539611020,5539611021,5539611022,5539611030,5539611031,5539611033,5539611110,5539611112,5539611120,5539611121,5539611122,5539611200,5539612110,5539612120,5539612122,5539612300,5539612302,5539612320,5539612322,5539710100,5539710102,5539710103,5539710130,5539710132,5539710133,5539711202,5539711232,5539713010,5539713012,5539713030,5539713032,5638060001,5638060003,5638060021,5638060023,5638060201,5638060203,5638060330,5638061011,5638061100,5638061101,5638061103,5638061130,5638061131,5638061200,5638061202,5638062011,5638062100,5638062101,5638070020,5638070021,5638070023,5638070030,5638070031,5638070032,5638070300,5638070301,5638070303,5638070321,5638070323,5638071220,5638071231,5638071233,5638071330,5638071331,5638071332,5638073100,5639002010,5639002011,5639002013,5639002031,5639002311,5639002312,5639002313,5639002331,5639003200,5639003201,5639003202,5639003210,5639003211,5639011120,5639011122,5639011300,5639011302,5639011303,5639012200,5639012202,5639012211,5639012320,5639012321,5639012330,5639012331,5639013010,5639013011,5639013100,5639013200,5639013201,5639013202,5639013220,55380532032,55380532033,55380532122,55380532123,55380532132,55380532201,55380532203,55380532221,55380532223,55380532310,55380532312,55380622332,55380622333,55380623222,55380623223,55380623232,55381501233,55381501303,55381503011,55381503013,55381503031,55381503300,55381503301,55381503303,55381503331,55381503333,55381510001,55381510003,55381511020,55381511022,55381511133,55381511212,55381511213,55381511302,55381511303,55381521333,55381523310,55381523311,55381523313,55381523331,55381530021,55381530023,55381600011,55381600012,55381600013,55381600021,55381600022,55381600023,55381601010,55381601012,55381601030,55381601032,55381601033,55381601122,55381601312,55381610203,55381610232,55381612010,55381612012,55381630030,55381630031,55381630032,55381632012,55381632013,55381632102,55381632103,55381632112,55381632113,55381633002,55381633003,55381633011,55381633012,55381633013,55381633102,55381633103,55381633112,55381722022,55381722200,55381722202,55381722203,55381722212,55381722213,55381722302,55381722303,55381722312,55381723232,55381723233,55381723322,55382431113,55382431131,55382431133,55382432311,55382432313,55382432331,55382432333,55382502232,55382502233,55382502311,55382502313,55382502321,55382502322,55382502323,55382503022,55382503023,55382503032,55382503033,55382503111,55382503113,55382510001,55382510003,55382510021,55382510023,55382510201,55382510203,55382510221,55382510222,55382510223,55382701100,55382701102,55382701120,55382703012,55382703013,55382703030,55382703031,55382703032,55382703232,55382721010,55382721012,55382721013,55382721122,55382721330,55382721332,55382721333,55382730333,55382731203,55383410111,55383410112,55383410113,55383410121,55383410123,55383410301,55383410303,55383410321,55383410323,55383412101,55383432121,55383432123,55383432211,55383432213,55383432231,55383432232,55383432233,55383710130,55383710131,55383710132,55383710310,55383710312,55383710330,55383710332,55383711000,55383711002,55383712110,55383712112,55383712130,55383712132,55383712310,55383712312,55383712330,55383712332,55383730110,55383730112,55383730130,55383730132,55383730310,55383730312,55383730330,55383730332,55383732110,55383732112,55383732113,55383733002,55383733003,55383733102,55383733103,55383733111,55383733112,55383733113,55384400333,55384401221,55384401222,55384401223,55384401332,55384401333,55384402111,55384402112,55384402113,55384402311,55384402313,55384402331,55384410203,55384421203,55384421221,55384423003,55384423021,55385400331,55385400332,55385400333,55385401003,55385402130,55385402131,55385402133,55385402311,55385402313,55385402331,55385402333,55385420111,55385420113,55385420131,55385420133,55385420311,55385421200,55385421201,55385421210,55385421211,55385421213,55385421320,55385421321,55385421323,55385423101,55385423131,55386410000,55386410001,55386410010,55386410100,55386410110,55386410111,55386411000,55386411001,55386411010,55386411011,55386411100,55386411101,55386411311,55386500030,55386500031,55386500032,55386500120,55386500121,55386500200,55386500331,55386500333,55386502111,55386502113,55386503020,55386503021,55386503231,55386521120,55386521121,55386521123,55386521301,55386521302,55386521303,55386523101,55386523103,55386523121,55386523130,55386532121,55386533010,55386533011,55386533013,55386533211,55386533213,55386533231,55387511101,55387511103,55387511121,55387511311,55387511313,55387511331,55387511332,55387511333,55387513131,55387513311,55387513313,55387513331,55387513333,55387531111,55387620201,55387620202,55387620203,55387622221,55387622223,55393022002,55393022003,55393022012,55393022030,55393022032,55393022033,55393022122,55393022123,55393022131,55393022132,55393022133,55393023030,55393023032,55393023033,55393023122,55393023300,55393023302,55393023320,55393023322,55393023323,55393112332,55393113312,55393113321,55393113323,55393113330,55393113332,55393121133,55393121311,55393121313,55393121331,55393121333,55393123111,55393123313,55393130001,55393130002,55393130003,55393130011,55393130012,55393130013,55393130110,55393130112,55393130113,55393131002,55393131003,55393131012,55393131013,55393131101,55393131102,55393131103,55393131110,55393131112,55393131130,55393131132,55393131310,55393131312,55393131313,55393131330,55393131332,55393133110,55393133112,55393133113,55393222002,55393222020,55393222022,55393222200,55394001110,55394001112,55394001113,55394010002,55394010003,55394010032,55394010033,55394010122,55394010300,55394010302,55394010303,55394010330,55394010332,55394012110,55394012112,55394012130,55394012132,55394012310,55394012312,55394012330,55394012332,55394030110,55394030112,55394030130,55394030132,55394030133,55394031131,55394031132,55394031133,55394031302,55394031303,55394100313,55394100331,55394100333,55394101013,55394101021,55394101022,55394101023,55394101102,55394101103,55394102013,55394102031,55394102033,55394102102,55394102103,55394102211,55394102213,55394102231,55394102232,55394102233,55394111110,55394111112,55394111130,55394111132,55394111330,55394111332,55394113110,55394113112,55394113130,55394113132,55394120003,55394131330,55394131331,55394131332,55394133110,55394133112,55394133130,55394133132,55394133310,55394133312,55394133320,55394133321,55394133322,55394202202,55394202220,55394202222,55394220200,55394220202,55394220220,55395111100,55395111102,55395111120,55395111122,55395111300,55395111302,55395111320,55395113122,55395113300,55395113302,55395113320,55395113322,55395131132,55395131310,55395131312,55395131330,55395131332,55395133110,55395133112,55395133113,55395133330,55396103330,55396103332,55396110230,55396110231,55396110320,55396110321,55396111230,55396111232,55396111300,55396111301,55396111302,55396112020,55396112021,55396112022,55396112110,55396112111,55396112200,55396112202,55396113000,55396113001,55396113003,55396113010,55396113021,55396113023,55396113201,55396121120,55396121122,55396121210,55396121212,55396121230,55396123230,55396123232,55397101010,55397101012,55397101013,55397101102,55397101120,55397101122,55397101123,55397101312,55397110220,55397110222,55397112000,55397112002,55397112302,55397112303,55397112312,55397112330,55397112332,55397130110,55397130112,55397130130,55397130132,55397130310,55397130312,55397130330,55397130332,56380602210,56380602211,56380602213,56380602231,56380602233,56380603310,56380603311,56380603320,56380603322,56380603323,56380610100,56380610101,56380610102,56380611020,56380611021,56380611320,56380611321,56380611330,56380611331,56380612010,56380612011,56380612012,56380612030,56380612200,56380620100,56380620101,56380620103,56380620121,56380620130,56380620131,56380621020,56380621021,56380621030,56380621031,56380621100,56380621101,56380621102,56380621120,56380700220,56380700221,56380700330,56380700331,56380700333,56380703021,56380712210,56380712211,56380712212,56380712220,56380712300,56380712301,56380712303,56380712321,56380712323,56380713330,56380713331,56380713333,56380721011,56380721100,56380721101,56380721110,56380721111,56380730111,56380730113,56380730131,56380731010,56380731011,56380731012,56380731020,56380731021,56380731100,56380731101,56390020010,56390020011,56390020120,56390020121,56390020123,56390020301,56390020303,56390020321,56390020330,56390020331,56390020333,56390022111,56390023000,56390023001,56390023010,56390023011,56390023100,56390023101,56390023103,56390023300,56390023301,56390023303,56390023321,56390023330,56390023331,56390032030,56390032031,56390032032,56390032120,56390032121,56390032130,56390032131,56390032133,56390032200,56390032202,56390032220,56390032311,56390033200,56390033201,56390033210,56390033211,56390033300,56390033301,56390033310,56390033311,56390111022,56390111023,56390111210,56390111212,56390111230,56390111232,56390113010,56390113012,56390122010,56390122012,56390122101,56390122103,56390122130,56390122131,56390122133,56390122200,56390122311,56390123221,56390123230,56390123231,56390130120,56390130121,56390130122,56390130130,56390130131,56390130300,56390130302,56390130320,56390130322,56390131010,56390131012,56390131020,56390131021,56390131030,56390132100,
039,00,/ľ/̯,495478125,132337500,498867187,134306250,8,19,54,101,254,627,553736,553737,553840,553841,553842,553852,553853,553863,5537162,5537260,5537262,5537470,5537471,5538300,5538302,5538312,5538313,5538322,5538323,5538430,5538432,5538433,5538501,5538510,5538511,5538513,5538621,55371602,55372531,55372533,55372610,55372612,55372613,55372630,55372632,55373511,55373512,55373513,55373521,55373530,55373531,55373533,55374601,55374610,55374611,55374613,55374730,55374731,55374733,55383012,55383030,55383032,55383033,55383201,55383203,55383212,55384312,55384313,55384420,55384422,55385000,55385001,55385030,55385031,55385033,55385120,55385121,55385422,55386200,55386201,55386231,55386400,55386401,55386402,55387300,55387301,55387303,55387310,55387311,55387312,55387400,553715333,553716030,553716032,553716302,553716320,553716322,553716323,553725111,553725113,553725131,553725133,553726110,553726112,553726310,553726311,553726312,553726330,553726332,553727223,553727323,553727332,553727333,553735033,553735203,553735320,553735321,553746000,553746001,553746120,553746121,553747201,553747210,553747211,553747213,553747320,553747321,553747323,553757110,553757111,553757113,553820222,553820223,553830102,553830132,553830310,553830312,553830313,553831032,553831033,553831122,553831123,553831130,553831132,553832023,553832102,553832103,553832112,553832130,553832132,553833220,553833222,553843102,553844020,553844022,553850021,553850030,553850031,553850033,553851220,553851221,553851230,553851231,553854000,553854001,553854002,553854020,553854022,553854200,553854202,553854230,553854232,553854233,553862030,553862031,553862033,553862300,553862301,553862303,553862330,553862331,553862333,553864030,553864031,553864200,553864201,553864220,553864222,553873021,553873130,553873131,553873211,5537153311,5537153312,5537153313,5537160023,5537160032,5537160330,5537160332,5537160333,5537163000,5537163002,5537163003,5537163030,5537163032,5537163210,5537163212,5537163213,5537163322,5537251323,5537253211,5537261132,5537263130,5537263132,5537263310,5537263311,5537263312,5537263330,5537263332,5537263333,5537270202,5537270220,5537270222,5537272221,5537272222,5537272223,5537272322,5537272333,5537273211,5537273212,5537273213,5537273222,5537273223,5537350313,5537350321,5537350323,5537352013,5537352023,5537352301,5537352310,5537352311,5537352313,5537353221,5537353230,5537353231,5537353233,5537451110,5537451111,5537460021,5537460030,5537460031,5537460033,5537460311,5537461221,5537461230,5537461231,5537461233,5537463100,5537463110,5537463111,5537472000,5537472001,5537472003,5537472031,5537472120,5537472121,5537472123,5537472311,5537473221,5537473223,5537571011,5537571121,5538202202,5538202203,5538202212,5538222303,5538222321,5538222323,5538222330,5538222332,5538222333,5538301000,5538301002,5538301003,5538301032,5538301302,5538301303,5538301312,5538301330,5538301332,5538303113,5538310213,5538310223,5538310231,5538310232,5538310233,5538310300,5538310302,5538310303,5538310312,5538310313,5538311202,5538311211,5538311213,5538311330,5538311332,5538320211,5538320212,5538320213,5538321000,5538321002,5538321003,5538321012,5538321013,5538321100,5538321102,5538321132,5538321310,5538321312,5538321330,5538321332,5538321333,5538332002,5538332020,5538332022,5538332210,5538332212,5538332230,5538332232,5538332233,5538332322,5538431002,5538431030,5538431032,5538431033,5538431122,5538431123,5538431132,5538431133,5538440210,5538440212,5538440230,5538440232,5538442100,5538442102,5538442320,5538442322,5538500200,5538500201,5538500203,5538500320,5538500321,5538500323,5538502111,5538502113,5538503201,5538503210,5538503211,5538503213,5538503231,5538503233,5538512220,5538512221,5538512222,5538512230,5538512231,5538512320,5538512321,5538512330,5538512331,5538512333,5538540030,5538540031,5538540032,5538540210,5538540212,5538540230,5538540232,5538542010,5538542012,5538542030,5538542032,5538542033,5538542122,5538542123,5538542312,5538601100,5538601101,5538601110,5538611101,5538611110,5538611111,5538611113,5538620200,5538620202,5538620210,5538620211,5538620213,5538620220,5538620320,5538620321,5538620323,5538622111,5538622113,5538623020,5538623021,5538623023,5538623210,5538623211,5538623213,5538623320,5538623321,5538623323,5538640320,5538641002,5538641020,5538642020,5538642021,5538642022,5538642030,5538642210,5538642212,5538642230,5538642232,5538721110,5538721111,5538721113,5538721131,5538730201,5538730231,5538730233,5538731320,5538731321,5538731322,5538731330,5538731331,5538732100,5538732101,5538732103,5538740102,5538740103,5538740120,5538740121,5538740122,5538740200,5538620201,55371513113,55371513131,55371513133,55371531133,55371531311,55371531313,55371531331,55371531332,55371531333,55371533031,55371533033,55371533101,55371533102,55371533103,55371533211,55371533213,55371533233,55371600211,55371600213,55371600223,55371600300,55371600302,55371600303,55371600330,55371600332,55371600333,55371601222,55371601223,55371601232,55371603120,55371603122,55371603312,55371612220,55371612222,55371612223,55371612232,55371630010,55371630012,55371630013,55371630312,55371630330,55371630332,55371632110,55371632112,55371632113,55371633022,55371633200,55371633202,55371633203,55371633232,55372511011,55372511233,55372513011,55372513211,55372513213,55372513223,55372530131,55372530133,55372530311,55372530313,55372530331,55372530333,55372532130,55372532131,55372532133,55372532311,55372532313,55372532331,55372532333,55372611102,55372611120,55372611122,55372611300,55372611302,55372611303,55372611332,55372631310,55372631312,55372631330,55372631332,55372631333,55372633130,55372633131,55372633132,55372633310,55372633312,55372702002,55372702212,55372702230,55372720000,55372720222,55372722000,55372722002,55372722122,55372722123,55372722132,55372722201,55372722202,55372722203,55372723200,55372723202,55372723230,55372723232,55372723233,55372723312,55372723313,55372723321,55372723322,55372723323,55372732033,55372732101,55372732102,55372732103,55372732202,55372732203,55372732211,55372732212,55372732213,55372733000,55372733002,55372733020,55372733022,55372733023,55372733032,55372733033,55372733122,55372733123,55372733131,55372733132,55372733133,55373502333,55373503032,55373503033,55373503111,55373503112,55373503113,55373503121,55373503122,55373503123,55373503221,55373503222,55373503223,55373510111,55373510113,55373510131,55373510133,55373510232,55373510233,55373510311,55373510313,55373510322,55373510331,55373510332,55373510333,55373520111,55373520113,55373520123,55373520213,55373522010,55373522011,55373522100,55373522101,55373522110,55373522111,55373523000,55373523001,55373523003,55373523120,55373523121,55373523123,55373523311,55373532200,55373532201,55373532320,55373532321,55374511000,55374511001,55374511010,55374511011,55374511121,55374511130,55374511131,55374511133,55374600200,55374600201,55374600320,55374600321,55374603000,55374603010,55374603011,55374603100,55374603101,55374603103,55374603130,55374603131,55374612231,55374612320,55374612321,55374612323,55374630110,55374630111,55374630113,55374631010,55374631011,55374631131,55374720020,55374720021,55374720023,55374720300,55374720301,55374720331,55374721220,55374721221,55374723011,55374723100,55374723101,55374723103,55374723121,55374723130,55374723131,55374723133,55374732200,55374732201,55374732203,55374732221,55375710010,55375710011,55375710100,55375710101,55375710131,55375711201,55375711230,55375711231,55375713101,55375713110,55375713111,55375713113,55375713131,55382022002,55382022003,55382022012,55382022013,55382022102,55382022103,55382023202,55382023222,55382023223,55382023232,55382023233,55382023322,55382023323,55382023332,55382023333,55382032222,55382032223,55382032232,55382221233,55382221322,55382223011,55382223013,55382223100,55382223102,55382223120,55382223122,55382223123,55382223203,55382223221,55382223223,55382223312,55382232222,55382232223,55382232333,55382233222,55382233223,55383010010,55383010012,55383010300,55383010302,55383013000,55383013002,55383013003,55383013012,55383013013,55383013102,55383013103,55383031100,55383031101,55383031102,55383031111,55383031113,55383031121,55383031123,55383100333,55383101222,55383102111,55383102113,55383102123,55383102213,55383102222,55383102223,55383102301,55383102302,55383102303,55383103010,55383103012,55383103013,55383103102,55383103103,55383103112,55383103113,55383110332,55383110333,55383111222,55383111223,55383111232,55383111233,55383112002,55383112003,55383112012,55383112030,55383112032,55383112033,55383112121,55383112122,55383112123,55383113100,55383113102,55383113120,55383113122,55383113123,55383113312,55383113330,55383113332,55383113333,55383200111,55383200113,55383200131,55383200133,55383200313,55383200331,55383200332,55383200333,55383202101,55383202103,55383202213,55383202231,55383202232,55383202233,55383210010,55383210012,55383210013,55383210102,55383210103,55383210111,55383210112,55383210113,55383211012,55383211030,55383211032,55383211033,55383211300,55383211302,55383211303,55383211332,55383213110,55383213112,55383213130,55383213132,55383213310,55383213312,55383213313,55383302222,55383320000,55383320002,55383320210,55383320212,55383320230,55383320232,55383320233,55383322312,55383322313,55383323202,55383323203,55383323230,55383323232,55383323233,55383323322,55383323323,55384310000,55384310002,55384310003,55384310030,55384310032,55384310033,55384310122,55384310312,55384310313,55384311202,55384311203,55384311212,55384400222,55384400223,55384400232,55384402110,55384402310,55384402312,55384402330,55384402332,55384402333,55384421200,55384421201,55384421202,55384421220,55384421222,55384421223,55384423000,55384423001,55384423002,55384423020,55384423022,55384423023,55385002020,55385002021,55385002023,55385002311,55385002313,55385003221,55385021011,55385021100,55385021101,55385021103,55385021121,55385021123,55385021311,55385021313,55385021331,55385032001,55385032031,55385032120,55385032121,55385032123,55385032301,55385032303,55385122230,55385122231,55385122232,55385122320,55385122321,55385122330,55385122331,55385123320,55385123321,55385400330,55385401000,55385401001,55385401002,55385402132,55385402310,55385402312,55385402330,55385402332,55385420110,55385420112,55385420130,55385420132,55385420310,55385420312,55385420313,55385421202,55385421203,55385421212,55385421322,55385423100,55385423102,55385423103,55385423130,55385423132,55385423133,55386010110,55386010111,55386011110,55386011111,55386100000,55386100010,55386101111,55386110000,55386110001,55386110010,55386110011,55386110100,55386110101,55386110110,55386110111,55386111000,55386111001,55386111031,55386111120,55386111121,55386111123,55386111301,55386111310,55386111311,55386111313,55386111331,55386111333,55386113111,55386113113,55386113131,55386202121,55386202210,55386202212,55386202221,55386202230,55386202311,55386203221,55386221011,55386221100,55386221101,55386221103,55386221121,55386221311,55386230221,55386232010,55386232011,55386232121,55386232123,55386232310,55386232311,55386232313,55386233220,55386233221,55386233223,55386403210,55386403211,55386403220,55386403221,55386403222,55386403300,55386403301,55386403303,55386403310,55386403311,55386403312,55386410002,55386410003,55386410012,55386410030,55386410032,55386410210,55386410212,55386410220,55386410221,55386410222,55386412002,55386412020,55386420230,55386420232,55386420233,55386420310,55386421000,55386421002,55386421020,55386422332,55386422333,55387211010,55387211011,55387211013,55387211120,55387211121,55387211123,55387211301,55387211331,55387211333,55387302000,55387302001,55387302030,55387302031,55387302033,55387302300,55387302301,55387302303,55387302321,55387313230,55387313231,55387313232,55387313320,55387313321,55387313330,55387320111,55387321021,55387321210,55387321211,55387321213,55387321300,55387321301,55387321302,55387330000,55387330001,55387330002,55387330010,55387330011,55387330020,55387330022,55387330100,55387330101,55387330110,55387330111,55387401000,55387401002,55387401003,55387401230,55387402010,55387402011,55387402012,55387402020,55387402021,55387402022,55387402100,55387402101,55387402110,55387402111,55387402200,55387403000,55387403001,55386202120,55386202031,55374631021,
040,00,Ĺ,498318750,133800000,501496875,135759375,6,20,42,122,270,602,563805,563816,563817,563826,563910,563920,5538643,5538741,5538742,5538743,5538750,5538752,5638041,5638063,5638150,5638151,5638153,5638251,5638270,5638271,5638272,5639110,5639112,5639113,5639210,5639211,55386413,55386423,55386520,55386522,55387331,55387333,55387510,55387512,55387530,55387532,55387533,56380400,56380401,56380431,56380433,56380613,56380622,56380623,56380702,56380720,56380722,56380723,56380732,56380733,56381520,56381521,56381523,56382501,56382531,56382730,56382731,56382732,56383600,56383601,56383603,56383611,56383700,56383701,56391222,56392120,56393001,56381411,553864103,553864112,553864121,553864122,553864123,553864211,553864212,553864213,553865020,553865022,553865023,553865210,553865212,553865230,553865232,553865233,553865322,553865323,553873302,553873303,553873320,553873321,553874011,553874013,553874023,553874031,553874032,553874033,553875110,553875112,553875130,553875132,553875310,553875312,553875313,563803111,563804030,563804031,563804300,563804301,563804303,563804321,563806103,563806112,563806121,563806123,563806200,563806202,563806203,563806212,563806213,563807212,563807213,563807300,563807302,563807303,563807312,563807313,563814131,563814133,563815221,563815223,563825031,563825301,563825331,563825333,563827330,563827331,563835111,563836020,563836021,563836023,563836100,563836101,563836102,563836120,563836122,563836201,563836203,563836210,563836211,563836212,563836300,563837020,563837021,563837030,563837031,563837032,563846010,563846012,563846013,563846031,563846033,563900202,563900220,563900222,563900223,563900232,563911100,563911102,563911120,563911122,563911123,563912200,563912202,563912203,563912230,563912232,563921210,563921211,563921300,563921301,563921310,563922000,563922001,563922002,563930000,563930001,563930031,563930100,563930101,563930102,5538640323,5538640332,5538640333,5538641012,5538641013,5538641023,5538641102,5538641103,5538641112,5538641130,5538641132,5538641133,5538641201,5538641203,5538642032,5538642033,5538642101,5538642103,5538642211,5538642213,5538642231,5538650021,5538650022,5538650023,5538650030,5538650032,5538650210,5538650212,5538650213,5538650320,5538650322,5538653202,5538653203,5538653213,5538653302,5538653320,5538653322,5538732131,5538732133,5538733003,5538733012,5538733013,5538733230,5538733231,5538733233,5538740101,5538740203,5538740212,5538740213,5538740221,5538740222,5538740223,5538740301,5538740302,5538740303,5538751130,5538751132,5538751310,5538751312,5538751330,5538751332,5538753110,5538753112,5538753113,5638031101,5638031103,5638031131,5638031133,5638040211,5638040321,5638040330,5638040331,5638040333,5638042111,5638043020,5638043021,5638043023,5638043201,5638043231,5638043233,5638060000,5638060002,5638060020,5638060022,5638060200,5638060202,5638060220,5638060222,5638060333,5638061012,5638061013,5638061221,5638061222,5638061223,5638062111,5638062113,5638070320,5638070322,5638071223,5638072100,5638072102,5638072103,5638072112,5638072113,5638073010,5638073012,5638073103,5638073111,5638073112,5638073113,5638141301,5638141303,5638143111,5638143113,5638143131,5638143133,5638152200,5638152201,5638152203,5638152221,5638250011,5638250013,5638250301,5638250303,5638250331,5638250333,5638253001,5638253031,5638253300,5638253301,5638253303,5638253321,5638253323,5638273320,5638273322,5638273330,5638273331,5638273333,5638351131,5638360221,5638360223,5638361030,5638361031,5638361032,5638361210,5638361212,5638361230,5638361231,5638361232,5638361301,5638361310,5638361311,5638361313,5638362001,5638362003,5638362130,5638362131,5638362132,5638362211,5638362213,5638362231,5638362233,5638362300,5638362301,5638362302,5638362310,5638362320,5638362322,5638362323,5638363010,5638363020,5638363021,5638363023,5638370220,5638370221,5638370230,5638370231,5638370233,5638370330,5638370332,5638370333,5638371000,5638371001,5638371002,5638371010,5638371011,5638371020,5638371111,5638371113,5638371131,5638371222,5638372110,5638372111,5638460011,5638460112,5638460113,5638460300,5638460301,5638460303,5638460321,5638460323,5639002000,5639002002,5639002003,5639002210,5639002212,5639002213,5639002302,5639002303,5639003221,5639003223,5639003230,5639003232,5639003233,5639003322,5639003323,5639003332,5639003333,5639012203,5639012212,5639012221,5639012222,5639012223,5639012230,5639012232,5639012233,5639012332,5639012333,5639013222,5639111210,5639111212,5639111322,5639111323,5639111330,5639111332,5639122012,5639122310,5639122312,5639212120,5639212121,5639212130,5639212200,5639212202,5639213030,5639213031,5639213110,5639213111,5639213112,5639213120,5639213121,5639213130,5639220031,5639220100,5639220200,5639220202,5639220220,5639220221,5639300020,5639300021,5639300031,5639300301,5639301030,5639301032,5639301100,5639301101,5639301102,5639301110,5639301200,5639301201,5639301210,55386403212,55386403213,55386403223,55386403302,55386403313,55386410011,55386410013,55386410031,55386410033,55386410101,55386410102,55386410103,55386410112,55386410113,55386410211,55386410213,55386410223,55386411002,55386411003,55386411012,55386411013,55386411102,55386411103,55386411310,55386411312,55386411313,55386412000,55386412001,55386412003,55386412021,55386412022,55386412023,55386420231,55386420311,55386420312,55386420313,55386421001,55386421003,55386421021,55386421022,55386421023,55386422330,55386422331,55386500033,55386500122,55386500123,55386500201,55386500202,55386500203,55386500330,55386500332,55386502110,55386502112,55386503022,55386503023,55386503230,55386503232,55386503233,55386521122,55386521300,55386523100,55386523102,55386523120,55386523122,55386523123,55386523131,55386523132,55386523133,55386532120,55386532122,55386532123,55386533012,55386533210,55386533212,55386533230,55386533232,55386533233,55387313233,55387313322,55387313323,55387313331,55387313332,55387313333,55387321303,55387321320,55387321321,55387321323,55387323101,55387323110,55387323111,55387323113,55387323131,55387323133,55387330003,55387330012,55387330013,55387330021,55387330023,55387330102,55387330103,55387330112,55387330113,55387332210,55387332211,55387332213,55387332320,55387332321,55387332323,55387401001,55387401231,55387401232,55387401233,55387402013,55387402023,55387402102,55387402103,55387402112,55387402113,55387402201,55387402202,55387402203,55387403002,55387403003,55387511100,55387511102,55387511120,55387511122,55387511123,55387511310,55387511312,55387511330,55387513130,55387513132,55387513133,55387513310,55387513312,55387513330,55387513332,55387531110,55387531112,55387531113,55387620200,55387622220,55387622222,56380310101,56380310110,56380310111,56380311000,56380311001,56380311003,56380311300,56380311301,56380311303,56380311321,56380311323,56380402010,56380402011,56380402100,56380402101,56380402103,56380402121,56380402130,56380402131,56380402133,56380402311,56380403200,56380403201,56380403320,56380403321,56380403323,56380421101,56380421131,56380421133,56380430221,56380430223,56380432031,56380432300,56380432301,56380432303,56380432321,56380432323,56380602212,56380602230,56380602232,56380603312,56380603313,56380603321,56380610103,56380611022,56380611023,56380611322,56380611323,56380611332,56380611333,56380612013,56380612031,56380612032,56380612033,56380612201,56380612202,56380612203,56380620102,56380620120,56380620122,56380620123,56380620132,56380620133,56380621022,56380621023,56380621032,56380621033,56380621103,56380621121,56380621122,56380621123,56380700222,56380700223,56380700332,56380703020,56380703022,56380703023,56380712213,56380712221,56380712222,56380712223,56380712302,56380712320,56380712322,56380713332,56380721010,56380721012,56380721013,56380721102,56380721103,56380721112,56380721113,56380730110,56380730112,56380730130,56380730132,56380730133,56380731013,56380731022,56380731023,56380731102,56380731103,56381410110,56381410111,56381410113,56381410131,56381410133,56381410311,56381410313,56381413001,56381413211,56381413213,56381431100,56381431101,56381431103,56381431121,56381431123,56381431301,56381433110,56381433111,56381433113,56381522021,56381522230,56381522231,56382500100,56382500101,56382500103,56382500311,56382500313,56382500331,56382500333,56382503000,56382503001,56382503211,56382503300,56382503301,56382503303,56382503321,56382521110,56382521111,56382530000,56382530001,56382530030,56382530031,56382530033,56382530301,56382530331,56382530333,56382532111,56382533021,56382533023,56382733210,56382733211,56382733212,56382733230,56382733232,56382733321,56382733323,56383511010,56383511011,56383511013,56383511301,56383511303,56383511330,56383511331,56383511333,56383513111,56383602200,56383602201,56383602203,56383602221,56383610330,56383610331,56383610333,56383612111,56383612132,56383612133,56383612330,56383612331,56383612332,56383613000,56383613001,56383613030,56383613031,56383613120,56383613121,56383613123,56383613311,56383620211,56383620213,56383620231,56383621330,56383621332,56383622101,56383622103,56383622121,56383622123,56383622301,56383622303,56383622321,56383622323,56383623030,56383623031,56383623032,56383623120,56383623121,56383623210,56383623212,56383630120,56383630122,56383630220,56383630221,56383630223,56383630300,56383630302,56383630320,56383702230,56383702231,56383702320,56383702321,56383703310,56383703312,56383703313,56383710030,56383710032,56383710120,56383710121,56383710210,56383710212,56383710220,56383710221,56383710222,56383711000,56383711001,56383711101,56383711103,56383711121,56383711123,56383711330,56383711331,56383712000,56383712002,56383712202,56383721000,56383721001,56383721010,56383721011,56383721013,56383730000,56383730001,56383730002,56384600101,56384600130,56384600131,56384600133,56384600311,56384600313,56384600331,56384600333,56384603020,56384603021,56384603023,56384603201,56384603203,56384603221,56384603223,56384610022,56384610200,56384610202,56384610222,56384612000,56384612002,56384612020,56384612022,56384612200,56384612202,56384612220,56384612222,56384621100,56384621101,56384621110,56390020012,56390020013,56390020122,56390020300,56390020302,56390020320,56390020322,56390020323,56390020332,56390022110,56390022112,56390022113,56390023002,56390023003,56390023012,56390023013,56390023102,56390023302,56390023320,56390023322,56390023323,56390023332,56390023333,56390032033,56390032122,56390032123,56390032132,56390032201,56390032203,56390032221,56390032222,56390032223,56390032310,56390032312,56390032313,56390033202,56390033203,56390033212,56390033213,56390033302,56390033303,56390033312,56390033313,56390122011,56390122013,56390122100,56390122102,56390122132,56390122201,56390122202,56390122203,56390122310,56390122312,56390122313,56390123220,56390123222,56390123223,56390123232,56390123233,56390132232,56390132233,56391110102,56391110120,56391110122,56391110300,56391110302,56391110320,56391110322,56391112110,56391112112,56391112130,56391112132,56391112133,56391113122,56391113123,56391113202,56391113203,56391113212,56391113213,56391113312,56391113330,56391113332,56391113333,56391202222,56391202223,56391202232,56391220102,56391221202,56391221220,56391221222,56391221223,56391221232,56391221233,56391221322,56391221323,56391223300,56391223301,56391223302,56392121220,56392121221,56392121222,56392121230,56392121310,56392121311,56392122010,56392122011,56392122012,56392122030,56392122032,56392122100,56392122101,56392122110,56392122111,56392122200,56392122201,56392122202,56392122220,56392130200,56392130201,56392130210,56392130211,56392130213,56392130321,56392130330,56392130331,56392131130,56392131131,56392131132,56392131220,56392131221,56392131230,56392131231,56392131320,56392200300,56392200301,56392200303,56392201010,56392201012,56392201020,56392201021,56392201022,56392201030,56392201200,56392202010,56392202012,56392202030,56392202032,56392202033,56392202220,56392202222,56392220000,56393000220,56393000221,56393000230,56393000300,56393000301,56393000331,56393000333,56393002111,56393003000,56393003001,56393003003,56393003030,56393003031,56393003033,56393010310,56393011030,56393011031,56393011032,56393011120,56393012020,56393012022,56393012030,56393012031,56381410312,56381410330,56381410332,
041,00,/,499626562,134821875,503057812,136856250,8,25,74,127,302,638,563847,563857,563931,563932,563933,563940,563943,563950,5638463,5638671,5639221,5639223,5639232,5639233,5639242,5639302,5639303,5639410,5639411,5639412,5639420,5639421,5639423,5639440,5639442,5639443,5639530,5639531,5639540,5639541,5639600,5639601,5639603,56383631,56383632,56383633,56383713,56383720,56383722,56383723,56383731,56383732,56383733,56384611,56384613,56385610,56385611,56385613,56385631,56386701,56391232,56391233,56391322,56392123,56392132,56392133,56392203,56392221,56392222,56392223,56392300,56392302,56392303,56392312,56392313,56392402,56392403,56393013,56393400,56393402,56393420,56393422,56394130,56394131,56394132,56394220,56394221,56394410,56394412,56395100,56395101,56395102,56395120,56395122,56395211,56395213,56395320,56395321,56395431,56395500,56395502,56395520,56395521,56395523,56395532,56396020,56396021,56396023,56396100,56396102,56396120,56396122,56397010,56397011,56397100,56397102,56397130,563836132,563836233,563837103,563837112,563837121,563837123,563837212,563837213,563837301,563837302,563837303,563846101,563846103,563846121,563846123,563846213,563846231,563856121,563856123,563856301,563856331,563856333,563867000,563867001,563867003,563867031,563867310,563867311,563867313,563912210,563912211,563912302,563912303,563912312,563912313,563913202,563913203,563921223,563922011,563922013,563922021,563922023,563922201,563922202,563922203,563923012,563924013,563924102,563930020,563930022,563930023,563930032,563930033,563930112,563930113,563930122,563930123,563934010,563934011,563934012,563934030,563934032,563934210,563934212,563934230,563934232,563934233,563941330,563941331,563942220,563942231,563942233,563944130,563944132,563945220,563945222,563945223,563951030,563951032,563951100,563951101,563951102,563951210,563951211,563951232,563952011,563952100,563952101,563952103,563952311,563952313,563953220,563953221,563953300,563954211,563954300,563954301,563954303,563954331,563955030,563955032,563955033,563955220,563955221,563955300,563955302,563960220,563960221,563960223,563961030,563961032,563970010,563970011,563970013,563970121,563970130,563970131,563970133,563971010,563971012,563971030,563971032,563971033,563971122,563971210,563971211,563971312,5638361302,5638361330,5638361332,5638361333,5638362311,5638362313,5638363011,5638363013,5638363031,5638363033,5638370222,5638371013,5638371023,5638371101,5638371102,5638371103,5638371130,5638371132,5638371201,5638371202,5638371203,5638371221,5638371223,5638372102,5638372103,5638372112,5638372113,5638373001,5638373002,5638373003,5638460110,5638460111,5638461000,5638461001,5638461003,5638461021,5638461023,5638461201,5638461203,5638461221,5638461223,5638462101,5638462103,5638462112,5638462113,5638462121,5638462123,5638462330,5638462331,5638462333,5638560111,5638560113,5638561200,5638561201,5638561203,5638561221,5638561223,5638563031,5638563033,5638563300,5638563301,5638563303,5638563321,5638670021,5638670300,5638670301,5638670303,5638670330,5638670331,5638673001,5638673010,5638673011,5638673013,5638673120,5638673121,5638673123,5638673311,5639120232,5639122011,5639122013,5639122121,5639122130,5639122131,5639122133,5639122311,5639122313,5639122331,5639122332,5639122333,5639123000,5639123002,5639123003,5639123011,5639123012,5639123013,5639132002,5639132003,5639132012,5639132013,5639212132,5639212133,5639212212,5639212213,5639212221,5639212223,5639213022,5639213023,5639213131,5639213133,5639220032,5639220033,5639220121,5639220122,5639220123,5639220223,5639222001,5639222002,5639222003,5639230132,5639230133,5639231022,5639231103,5639231121,5639231122,5639231123,5639231130,5639231132,5639231133,5639240022,5639240023,5639240032,5639240033,5639240122,5639240123,5639241002,5639241032,5639241200,5639241201,5639241202,5639241220,5639243002,5639243020,5639243022,5639243200,5639243202,5639300032,5639300210,5639300212,5639300213,5639300302,5639301033,5639301111,5639301113,5639301211,5639301212,5639301213,5639343220,5639343222,5639343223,5639343232,5639413320,5639413322,5639413331,5639422210,5639422211,5639422212,5639422220,5639422221,5639422300,5639422301,5639422303,5639422321,5639422323,5639441102,5639441120,5639441122,5639441123,5639441312,5639441330,5639441332,5639441333,5639452022,5639452212,5639510310,5639510311,5639510312,5639510330,5639510332,5639511030,5639511031,5639511032,5639511100,5639511200,5639512120,5639512121,5639512130,5639512300,5639512302,5639512303,5639512312,5639512330,5639512332,5639520101,5639521020,5639521021,5639521023,5639521210,5639521211,5639521213,5639521231,5639521233,5639523100,5639523101,5639523103,5639523121,5639523311,5639523313,5639533010,5639533020,5639542000,5639542100,5639542101,5639542103,5639543020,5639543021,5639543023,5639543301,5639543331,5639550120,5639550122,5639550123,5639550310,5639550312,5639551222,5639552220,5639552221,5639552223,5639552230,5639552231,5639552232,5639553030,5639553032,5639553033,5639553300,5639553302,5639553320,5639602221,5639610100,5639610102,5639610120,5639610122,5639610123,5639610310,5639610312,5639610313,5639610330,5639610331,5639610332,5639611202,5639611220,5639612100,5639612102,5639612120,5639612122,5639612322,5639612323,5639612332,5639650111,5639651000,5639651001,5639651003,5639651010,5639651012,5639700011,5639700121,5639701200,5639701201,5639701203,5639701221,5639701231,5639701320,5639701321,5639701323,5639710110,5639710112,5639710131,5639710310,5639710312,5639710313,5639711232,5639712010,5639712011,5639712130,5639712131,5639713102,5639713211,5639713213,5639713300,5639713302,5639713322,5739011103,5739011121,56382733213,56382733231,56382733233,56382733320,56382733322,56383610332,56383612110,56383612112,56383612113,56383612130,56383612131,56383612333,56383613002,56383613003,56383613032,56383613033,56383613122,56383613310,56383613312,56383613313,56383621331,56383621333,56383623033,56383623122,56383623123,56383623211,56383623213,56383630121,56383630123,56383630222,56383630301,56383630303,56383630321,56383630322,56383630323,56383702232,56383702233,56383702322,56383702323,56383703311,56383710031,56383710033,56383710122,56383710123,56383710211,56383710213,56383710223,56383711002,56383711003,56383711100,56383711102,56383711120,56383711122,56383711332,56383711333,56383712001,56383712003,56383712200,56383712201,56383712203,56383721002,56383721003,56383721012,56383730003,56384610020,56384610021,56384610023,56384610201,56384610203,56384610220,56384610221,56384610223,56384612001,56384612003,56384612021,56384612023,56384612201,56384612203,56384612221,56384612223,56384621001,56384621003,56384621021,56384621023,56384621102,56384621103,56384621111,56384621112,56384621113,56384621201,56384623011,56384623013,56384623033,56384623211,56384623321,56384623323,56385601101,56385601103,56385601121,56385601310,56385601311,56385601313,56385601331,56385601333,56385603111,56385612020,56385612021,56385612023,56385612201,56385612203,56385612221,56385630010,56385630011,56385630013,56385630031,56385630301,56385630303,56385632111,56385632113,56385633021,56385633023,56385633231,56386611101,56386611110,56386611111,56386611113,56386611131,56386700201,56386700231,56386702101,56386702110,56386702111,56386702113,56386703021,56386703211,56386703321,56386703330,56386703331,56386703333,56386730000,56386730001,56386730120,56386730121,56386730123,56386730310,56386730311,56386730313,56386731220,56386731221,56386733010,56386733100,56386733101,56386733103,56386733130,56386733131,56386733133,56391202213,56391202231,56391202233,56391202302,56391202303,56391202312,56391202330,56391202332,56391202333,56391203222,56391203223,56391203232,56391203233,56391220100,56391220101,56391220103,56391221200,56391221201,56391221203,56391221221,56391221230,56391221231,56391221320,56391221321,56391223303,56391231020,56391231022,56391323222,56392121223,56392121231,56392121232,56392121233,56392121312,56392121313,56392122013,56392122031,56392122033,56392122102,56392122103,56392122112,56392122113,56392122203,56392122221,56392122222,56392122223,56392130202,56392130203,56392130212,56392130320,56392130322,56392130323,56392130332,56392130333,56392131133,56392131222,56392131223,56392131232,56392131233,56392131321,56392131322,56392131323,56392200302,56392201011,56392201013,56392201023,56392201031,56392201032,56392201033,56392201201,56392201202,56392201203,56392202011,56392202013,56392202031,56392202221,56392202223,56392220001,56392220002,56392220003,56392301000,56392301002,56392301020,56392301022,56392301300,56392301302,56392310230,56392310232,56392310233,56392310322,56392310323,56392310331,56392310332,56392310333,56392311201,56392311203,56392311310,56392311312,56392400211,56392400213,56392400300,56392400302,56392401211,56392401213,56392410030,56392410032,56392412030,56392412032,56392412220,56392412221,56392432200,56392432201,56393000222,56393000223,56393000231,56393000232,56393000233,56393000302,56393000303,56393000330,56393000332,56393002110,56393002112,56393002113,56393003002,56393003032,56393010311,56393010312,56393010313,56393011033,56393011121,56393011122,56393011123,56393012021,56393012023,56393012032,56393012033,56393401300,56393401302,56393421122,56393421300,56393421302,56393423102,56393423120,56393423122,56393423123,56393423132,56393423133,56393432022,56393432023,56393432210,56393432212,56394133210,56394133211,56394133212,56394133230,56394133232,56394133300,56394133301,56394133303,56394222130,56394222131,56394222132,56394222300,56394222301,56394223020,56394223021,56394411000,56394411002,56394411212,56394411213,56394411322,56394413100,56394413102,56394413103,56394413112,56394413130,56394413132,56394413310,56394413312,56394520002,56394520020,56394520022,56394520200,56394520202,56394520203,56394520212,56394520230,56394520232,56394520233,56394522102,56394522103,56394522130,56394522132,56394523200,56394523202,56394523220,56394523222,56395103130,56395103131,56395103332,56395110330,56395110331,56395111010,56395111012,56395111020,56395111021,56395111022,56395111200,56395111202,56395112010,56395112011,56395112012,56395112020,56395112021,56395121220,56395121310,56395121311,56395123012,56395123013,56395123102,56395123103,56395123130,56395123132,56395123310,56395123312,56395123330,56395201030,56395201031,56395201033,56395201301,56395201310,56395201311,56395201313,56395212011,56395212120,56395212121,56395212123,56395212301,56395212303,56395212321,56395230111,56395230113,56395231020,56395231021,56395231023,56395231231,56395233101,56395233103,56395233121,56395233123,56395233311,56395322200,56395322210,56395322211,56395322213,56395322300,56395322301,56395322302,56395323000,56395323001,56395323002,56395323010,56395323011,56395323020,56395323022,56395323100,56395323101,56395323110,56395323111,56395330110,56395330111,56395330120,56395330121,56395330210,56395330212,56395330220,56395330221,56395330222,56395331000,56395331001,56395331010,56395331011,56395331100,56395331101,56395331110,56395331111,56395420010,56395420011,56395420012,56395420100,56395420101,56395420110,56395420111,56395421020,56395421021,56395421023,56395421201,56395421210,56395421211,56395421300,56395421301,56395421303,56395421310,56395421311,56395421312,56395430221,56395432111,56395433000,56395433001,56395433301,56395433331,56395501000,56395501002,56395501020,56395501022,56395501023,56395501212,56395501213,56395501322,56395512200,56395512202,56395512230,56395512232,56395512233,56395522220,56395522221,56395522330,56395522331,56395522333,56395530122,56395530123,56395530132,56395530310,56395530312,56395530313,56395531202,56395531220,56395531222,56395533010,56395533012,56395533030,56395533031,56395533032,56395533120,56395533210,56395533220,56395533222,56396022200,56396022201,56396022203,56396022230,56396022231,56396022233,56396101010,56396101011,56396101032,56396101100,56396101210,56396101212,56396101322,56396101323,56396103112,56396103113,56396112002,56396112003,56396112012,56396112030,56396112032,56396112210,56396112212,56396121010,56396121011,56396121012,56396121030,56396121032,56396121100,56396121210,56396121212,56396121230,56396121232,56396123000,56396123001,56396123002,56396123010,56396123202,56396501010,56396501011,56396501100,56396501101,56396501103,56396501121,56396501123,56396510110,56396510112,56396510130,56396510132,56397000100,56397000101,56397000131,56397000133,56397001201,56397001231,56397003101,56397003110,56397003111,56397003113,56397003131,56397012020,56397012021,56397012023,56397012300,56397012301,56397012303,56397012331,56397013220,56397013221,56397013223,56397031101,56397031110,56397031111,56397101110,56397101112,56397101130,56397101132,56397101133,56397101300,56397101301,56397101303,56397103112,56397103113,56397112020,56397112022,56397112023,56397112032,56397112302,56397112332,56397112333,56397113222,56397120000,56397120001,56397120010,56397120011,56397120013,56397120121,56397120130,56397120131,56397120133,56397121210,56397121211,56397121213,56397121321,56397121330,56397121331,56397121333,56397131000,56397131002,56397131032,56397132010,56397132011,56397132100,56397132101,56397132103,56397132121,56397132123,56397132310,56397132311,56397132313,56397132331,56397132333,56397133010,56397133012,56397133030,56397133032,56397133200,56397133202,56397133232,57390111000,57390111001,57390111003,57390111010,57390111012,57390111021,
042,00,ȯ/¼,500962500,135853125,503620312,138750000,13,19,54,125,302,632,563962,563963,563964,563972,563973,563974,573903,573904,573914,573924,573934,573935,573944,5639513,5639522,5639613,5739021,5739131,5739133,5739231,5739252,5739253,5739262,5739360,5739362,5739450,5739452,5739540,5739541,5739543,5739550,5739552,56395113,56395200,56395202,56395203,56395232,56395332,56395333,56395422,56395423,56396110,56396111,56396113,56396500,56397110,56397111,57390201,57390231,57390520,57390522,57391300,57391301,57391303,57391321,57391500,57391502,57391520,57391521,57391522,57392331,57392333,57392500,57392502,57392503,57392632,57393311,57393313,57393331,57393333,57393610,57393612,57393613,57393630,57393632,57394311,57394313,57394331,57394333,57394510,57394511,57394512,57395421,57395423,57396401,57396410,563951111,563951113,563951121,563951122,563951123,563952012,563952122,563952300,563952302,563952303,563952330,563952332,563953232,563953233,563953303,563953312,563953313,563954202,563954203,563954320,563954322,563954323,563954332,563961121,563961123,563961213,563961231,563965020,563965022,563971121,563971130,563971131,563971133,563971311,563971313,563971331,563971333,563975222,573902001,573902031,573902301,573902303,573902330,573902331,573902333,573905000,573905002,573905020,573905022,573905210,573905212,573905213,573905230,573905232,573913021,573913023,573913231,573913233,573915010,573915012,573915030,573915032,573915033,573915230,573915232,573923300,573923301,573923303,573923321,573923323,573925010,573925012,573925013,573926022,573926023,573926302,573926332,573933101,573933103,573933121,573933123,573933301,573933303,573933321,573933323,573936110,573936112,573936310,573936311,573936312,573936330,573937020,573937022,573943101,573943103,573943121,573945300,573945302,573945320,573945322,573946000,573946001,573946010,573946011,573951130,573951133,573951311,573952202,573953111,573953113,573954200,573954201,573954203,573954221,573955100,573955102,573955120,573955122,573955300,573955302,573955320,573964031,573964110,573964111,573964120,5639413332,5639413333,5639422222,5639422223,5639422231,5639422232,5639422233,5639422320,5639422322,5639510331,5639511103,5639511121,5639511122,5639511123,5639511203,5639512123,5639512132,5639512133,5639512311,5639520100,5639520102,5639520132,5639520133,5639521022,5639521200,5639521202,5639521203,5639523010,5639523012,5639523013,5639523120,5639523122,5639523330,5639523332,5639523333,5639532222,5639532223,5639532231,5639532232,5639532233,5639532303,5639532312,5639532313,5639533013,5639533023,5639533102,5639533103,5639533112,5639533113,5639542002,5639542003,5639542012,5639542013,5639542122,5639542123,5639542132,5639542133,5639543210,5639543212,5639543213,5639543302,5639543303,5639543332,5639610111,5639610112,5639610113,5639610130,5639610131,5639610133,5639610333,5639611222,5639611223,5639612111,5639612112,5639612113,5639612302,5639612303,5639612321,5639612330,5639612331,5639612333,5639650100,5639650102,5639650103,5639650120,5639650121,5639650210,5639650212,5639650230,5639652000,5639710132,5639710133,5639711200,5639711201,5639711231,5639711320,5639711321,5639711323,5639713101,5639713321,5639750022,5639750200,5639750202,5639750220,5639750222,5639752000,5639752002,5639752020,5639752022,5639752200,5639752202,5739011111,5739020000,5739020001,5739020003,5739020030,5739020031,5739020033,5739020300,5739020301,5739020303,5739020330,5739020331,5739020333,5739023000,5739023001,5739023003,5739023021,5739023211,5739023320,5739023321,5739023323,5739050010,5739050012,5739050030,5739050032,5739050210,5739050212,5739050230,5739050232,5739052110,5739052112,5739052310,5739052311,5739121110,5739121111,5739121113,5739121131,5739121133,5739130200,5739130201,5739130203,5739130221,5739132011,5739132013,5739132031,5739132301,5739132303,5739132321,5739150312,5739152310,5739152311,5739152312,5739152330,5739152332,5739230111,5739230113,5739230131,5739230133,5739230311,5739230313,5739230331,5739233021,5739233023,5739233221,5739233223,5739250110,5739250112,5739251202,5739251220,5739251222,5739251223,5739251232,5739251332,5739251333,5739260320,5739260322,5739260323,5739263032,5739263300,5739263302,5739263303,5739263332,5739331001,5739331003,5739331021,5739331023,5739331203,5739331221,5739331223,5739333001,5739361110,5739361112,5739361130,5739361132,5739361133,5739363130,5739363132,5739363320,5739370022,5739372000,5739431230,5739431231,5739431233,5739433011,5739433013,5739433031,5739433033,5739433211,5739433213,5739451300,5739451301,5739451302,5739451320,5739451322,5739453010,5739453011,5739453100,5739453232,5739460020,5739460021,5739460030,5739460031,5739461000,5739461001,5739461002,5739461010,5739461011,5739511122,5739511123,5739511310,5739511312,5739511313,5739511321,5739511322,5739511323,5739513101,5739513131,5739513133,5739520222,5739522000,5739522002,5739522200,5739522201,5739522203,5739522210,5739531101,5739531103,5739531310,5739531311,5739531313,5739531331,5739542021,5739542023,5739542201,5739542230,5739542231,5739542233,5739551010,5739551012,5739551030,5739551032,5739551210,5739551212,5739551230,5739551232,5739553010,5739553012,5739553030,5739553032,5739553210,5739553212,5739553213,5739553220,5739553221,5739553222,5739553230,5739640011,5739640301,5739640303,5739640330,5739640331,5739641120,5739641121,5739641130,5739641131,5739641210,5739641220,5739650000,5739650001,5739650002,5739650010,56394133213,56394133231,56394133233,56394133302,56394222133,56394222302,56394222303,56394223022,56394223023,56395103132,56395103133,56395103330,56395103331,56395103333,56395110332,56395110333,56395111011,56395111013,56395111023,56395111201,56395111203,56395112013,56395112022,56395112023,56395121221,56395121222,56395121223,56395121312,56395121313,56395123010,56395123011,56395123100,56395123101,56395123131,56395123133,56395123311,56395123313,56395123331,56395123332,56395123333,56395201032,56395201300,56395201302,56395201303,56395201312,56395212010,56395212012,56395212013,56395212122,56395212300,56395212302,56395212320,56395212322,56395212323,56395230110,56395230112,56395231022,56395231230,56395231232,56395231233,56395233100,56395233102,56395233120,56395233122,56395233310,56395233312,56395233313,56395322201,56395322202,56395322203,56395322212,56395322303,56395323003,56395323012,56395323013,56395323021,56395323023,56395323102,56395323103,56395323112,56395323113,56395330112,56395330113,56395330122,56395330123,56395330211,56395330213,56395330223,56395331002,56395331003,56395331012,56395331013,56395331102,56395331103,56395331112,56395331113,56395420013,56395420102,56395420103,56395420112,56395420113,56395421022,56395421200,56395421202,56395421203,56395421212,56395421213,56395421302,56395421313,56395430220,56395430222,56395430223,56395432110,56395432112,56395432113,56395433002,56395433003,56395433300,56395433302,56395433303,56395433330,56395433332,56395433333,56395522222,56395522223,56395522332,56396101012,56396101013,56396101030,56396101031,56396101033,56396101101,56396101102,56396101103,56396101211,56396101213,56396101320,56396101321,56396103110,56396103111,56396112000,56396112001,56396112010,56396112011,56396112013,56396112031,56396112033,56396112211,56396112213,56396121013,56396121031,56396121033,56396121101,56396121102,56396121103,56396121211,56396121213,56396121231,56396121233,56396123003,56396123011,56396123012,56396123013,56396123200,56396123201,56396123203,56396501012,56396501013,56396501102,56396501120,56396501122,56396501220,56396501221,56396501222,56396501230,56396501231,56396501300,56396502110,56396502111,56396502112,56396502130,56396502132,56396503000,56396520010,56396520012,56396520020,56396520022,56396520200,56396522000,56397101111,56397101113,56397101131,56397101302,56397103110,56397103111,56397112021,56397112030,56397112031,56397112033,56397112300,56397112301,56397112303,56397112330,56397112331,56397113220,56397113221,56397113223,56397131001,56397131003,56397131030,56397131031,56397131033,56397133011,56397133013,56397133031,56397133033,56397133230,56397133231,56397133233,56397500022,56397500200,56397500202,56397500230,56397500232,56397502010,56397502012,56397502030,56397502032,56397502210,56397502212,56397502230,56397502232,56397502233,56397520010,56397520011,56397520012,56397520030,56397520032,56397520210,56397520212,56397520230,56397520231,56397520232,56397522010,56397522012,56397522030,56397522032,56397522033,56397522322,56397522323,56397522332,57390111011,57390111100,57390111101,57390111103,57390200020,57390200021,57390200210,57390200211,57390200213,57390200321,57390200323,57390202110,57390202111,57390202113,57390203021,57390203210,57390203211,57390203213,57390203321,57390203323,57390221110,57390221111,57390221113,57390230020,57390230021,57390230023,57390230231,57390232101,57390232130,57390232131,57390232133,57390232311,57390233221,57390500110,57390500112,57390500130,57390500132,57390500310,57390500312,57390500330,57390500332,57390502110,57390502112,57390502130,57390502132,57390502310,57390502312,57390502330,57390502332,57390502333,57390503222,57390503223,57390523120,57390523122,57391211010,57391211011,57391211013,57391211120,57391211121,57391211123,57391211301,57391211303,57391213111,57391302020,57391302021,57391302023,57391302230,57391302231,57391302233,57391320011,57391320100,57391320101,57391320103,57391320121,57391320123,57391320331,57391320333,57391322111,57391323000,57391323001,57391323003,57391323021,57391323230,57391323231,57391323233,57391501300,57391501302,57391501320,57391501322,57391503100,57391503102,57391503103,57391503132,57391503133,57391512022,57392301011,57392301100,57392301101,57392301103,57392301121,57392301123,57392301321,57392301323,57392303101,57392303103,57392303121,57392303123,57392303330,57392303331,57392303333,57392321111,57392321113,57392330201,57392330203,57392332010,57392332011,57392332013,57392332031,57392332032,57392332033,57392332201,57392332203,57392332221,57392332223,57392510202,57392510220,57392510222,57392512000,57392512002,57392512003,57392512012,57392512030,57392512032,57392512210,57392512212,57392513231,57392513233,57392513311,57392513313,57392602023,57392602032,57392603023,57392603210,57392603212,57392603320,57392603322,57392630020,57392630022,57392630023,57392630032,57392630033,57392630302,57392630303,57392630312,57392630330,57392630332,57392630333,57392631222,57392631223,57392631232,57392633010,57392633012,57392633013,57392633102,57392633120,57392633122,57392633300,57392633302,57393310001,57393312010,57393312011,57393312013,57393330031,57393330033,57393330211,57393330213,57393330231,57393330233,57393332011,57393332013,57393332031,57393332033,57393332211,57393332213,57393332231,57393332233,57393611110,57393611112,57393611130,57393611132,57393611310,57393611312,57393611313,57393631310,57393631312,57393631330,57393633100,57393633101,57393633102,57393633120,57393633122,57393633210,57393633211,57393633220,57393633221,57393633300,57393700202,57393700203,57393700232,57393700233,57393702102,57393702120,57393702122,57393702300,57393702302,57393702320,57393720020,57393720022,57394310011,57394310013,57394310031,57394310033,57394310213,57394310231,57394310233,57394312011,57394312013,57394312031,57394312321,57394312323,57394330101,57394330103,57394330121,57394330123,57394330301,57394330303,57394330321,57394330323,57394332101,57394332311,57394332313,57394332331,57394332333,57394513030,57394513031,57394513032,57394513100,57394513101,57394513102,57394513110,57394513111,57394513120,57394513210,57394600220,57394600221,57394600230,57394600231,57394601311,57394601313,57394610200,57394610202,57395110331,57395110333,57395111322,57395111323,57395112111,57395112113,57395112131,57395112133,57395113112,57395113201,57395113203,57395131000,57395131301,57395131303,57395131321,57395133110,57395133111,57395202022,57395202200,57395202202,57395202232,57395220010,57395220012,57395220030,57395220032,57395220033,57395220322,57395222020,57395222021,57395222023,57395222120,57395222121,57395222122,57395310111,57395311000,57395311001,57395311003,57395311021,57395311210,57395311211,57395311213,57395311231,57395311233,57395313011,57395313120,57395313121,57395313123,57395313301,57395313331,57395313333,57395331111,57395331113,57395420201,57395420203,57395420221,57395422030,57395422031,57395422033,57395422321,57395422323,57395510112,57395510130,57395510132,57395510310,57395510312,57395510330,57395510332,57395512110,57395512112,57395512130,57395512132,57395512310,57395512312,57395512330,57395512332,57395530110,57395530112,57395532110,57395532112,57395532230,57395532232,57395533020,57395533022,57396400101,57396400103,57396400130,57396400131,57396400133,57396400311,57396400313,57396403001,57396403211,57396403213,57396403320,57396403321,57396403323,57396403330,57396403332,57396411220,57396411221,57396411222,57396411230,57396411231,57396411320,57396411321,57396411330,57396411331,57396412110,57396412111,57396413000,57396500030,57396500032,57396500200,57396500201,57396500202,57396500210,57396500220,57392301303,57392301320,57390111131,
043,00,,497531250,136068750,498895312,138009375,2,12,29,81,185,423,563873,573802,5638621,5638623,5638632,5738030,5738031,5738032,5738121,5738123,5738130,5738132,5738230,5738233,56385133,56385222,56386201,56386302,56386332,56387210,56387211,56387213,56387231,56387233,56387422,57380330,57380331,57380400,57380402,57380420,57380421,57381201,57381203,57382211,57382310,57382312,57382320,57382321,57382323,57383310,57383311,57383313,57383331,563851313,563852202,563852232,563852233,563852322,563852323,563852332,563862000,563862001,563862030,563862031,563862033,563862211,563862213,563862230,563862231,563862233,563863002,563863032,563863302,563863332,563871313,563871331,563871333,563872011,563872121,563872202,563872220,563872222,563872223,563872323,563874022,563874200,563874202,573801111,573801113,573801133,573801313,573803320,573804010,573804012,573804030,573804032,573804033,573804230,573804231,573804320,573812000,573812001,573812003,573812211,573812213,573813300,573813302,573813320,573813322,573813323,573822100,573822101,573822103,573822121,573822130,573822131,573822133,573823112,573823130,573823132,573823133,573823221,573833121,573833123,573833301,573833330,573833331,573833333,573834002,573834022,573834200,573834202,573834220,573834222,5638513113,5638513121,5638513122,5638513123,5638513211,5638513212,5638513213,5638513231,5638513233,5638522002,5638522030,5638522032,5638522033,5638522122,5638522300,5638522302,5638522303,5638522312,5638522313,5638523212,5638523332,5638611110,5638611111,5638620031,5638620033,5638620320,5638620321,5638620323,5638622101,5638622103,5638622121,5638622123,5638622320,5638622321,5638622323,5638630000,5638630002,5638630003,5638630032,5638630302,5638630332,5638633000,5638633002,5638633003,5638633030,5638633032,5638633033,5638633300,5638633302,5638633303,5638633332,5638713113,5638713123,5638713301,5638720101,5638720131,5638720133,5638721200,5638721201,5638721231,5638721233,5638722000,5638722002,5638722210,5638722212,5638723211,5638723212,5638723213,5638723221,5638723223,5638740000,5638740002,5638740020,5638740022,5638740200,5638740202,5638742010,5638742012,5638742030,5638742032,5638742033,5638742302,5638742320,5638742322,5738011103,5738011120,5738011121,5738011123,5738011311,5738011313,5738013110,5738013111,5738013113,5738013311,5738013331,5738013333,5738033210,5738033211,5738033220,5738033222,5738033311,5738040110,5738040112,5738040130,5738040132,5738040310,5738040312,5738040313,5738041222,5738042200,5738042201,5738042210,5738042211,5738042213,5738042321,5738042330,5738042331,5738042333,5738043000,5738043002,5738043020,5738043022,5738043023,5738043220,5738043221,5738043222,5738111111,5738120021,5738120023,5738120211,5738120213,5738120231,5738120233,5738122100,5738122101,5738122103,5738122121,5738122311,5738122312,5738122313,5738122331,5738122333,5738131022,5738131200,5738131220,5738131222,5738133210,5738133212,5738221021,5738221023,5738221321,5738221323,5738223111,5738231100,5738231102,5738231310,5738231312,5738232231,5738232233,5738242200,5738242202,5738242220,5738242222,5738330111,5738331201,5738331203,5738331220,5738331221,5738331223,5738333030,5738333031,5738333033,5738333211,5738333213,5738340000,5738340002,5738340003,5738340200,5738340202,5738340203,5738342210,5738342212,5738342230,5738342232,5738033221,56385130313,56385130323,56385130331,56385130332,56385130333,56385131033,56385131121,56385131122,56385131123,56385131201,56385131202,56385131203,56385132101,56385132102,56385132103,56385132301,56385132303,56385132321,56385220030,56385220032,56385220033,56385220122,56385220123,56385220312,56385220313,56385221202,56385221203,56385221212,56385221230,56385221232,56385223010,56385223012,56385223013,56385223102,56385223103,56385232020,56385232022,56385232031,56385232032,56385232033,56385232132,56385232133,56385233022,56385233023,56385233302,56385233303,56385233330,56385233332,56385233333,56385322222,56386110111,56386111000,56386111001,56386111010,56386111011,56386111013,56386111131,56386111133,56386200300,56386200301,56386200303,56386200321,56386202110,56386202111,56386202113,56386202131,56386202133,56386203221,56386203222,56386203223,56386221000,56386221001,56386221003,56386221223,56386222113,56386222131,56386222133,56386222311,56386222313,56386223220,56386223221,56386223223,56386300012,56386300300,56386300302,56386300303,56386300332,56386300333,56386303000,56386303002,56386303003,56386303012,56386303030,56386303032,56386303302,56386303332,56386330012,56386330312,56386330313,56386331202,56386331220,56386331222,56386331223,56386331232,56386333010,56386333012,56386333122,56386333300,56386333302,56386333303,56386333332,56386333333,56386422222,56386422223,56387131111,56387131113,56387131122,56387131123,56387131211,56387131213,56387133031,56387133033,56387133211,56387201001,56387201031,56387201033,56387201300,56387201301,56387201303,56387201321,56387203110,56387203111,56387212030,56387212031,56387212033,56387212301,56387212303,56387212321,56387220010,56387220012,56387220030,56387220032,56387220302,56387220320,56387220322,56387222130,56387222132,56387222133,56387223222,56387223332,56387223333,56387230111,56387230113,56387230131,56387230133,56387230311,56387230313,56387230323,56387230331,56387230332,56387230333,56387232033,56387232101,56387232103,56387232221,56387232222,56387232223,56387400210,56387400212,56387400230,56387400232,56387402010,56387402012,56387402030,56387402032,56387402033,56387402302,56387402320,56387402322,56387402323,56387420132,56387420310,56387420312,56387421222,56387423000,56387423002,56387423210,56387423212,56387423230,56387423232,56387423233,57380111012,57380111013,57380111022,57380111023,57380111221,57380111222,57380111223,57380113000,57380113001,57380113010,57380113011,57380113100,57380113101,57380113103,57380113121,57380113123,57380131120,57380131121,57380131123,57380133101,57380133103,57380133130,57380133131,57380133133,57380133301,57380133303,57380133321,57380133323,57380332120,57380332121,57380332122,57380333000,57380333001,57380333010,57380333100,57380333101,57380333103,57380333131,57380401312,57380401330,57380401332,57380403110,57380403112,57380412022,57380412200,57380412202,57380422020,57380422021,57380422030,57380422031,57380422120,57380422121,57380422311,57380423200,57380423201,57380423203,57380423221,57380423223,57380423230,57380423231,57380423232,57380423320,57380423321,57380423323,57380430012,57380430030,57380430032,57380430210,57380430212,57380430213,57380430320,57380430322,57380432100,57380432230,57380432231,57380432232,57381111101,57381111131,57381111133,57381111311,57381200200,57381200201,57381202011,57381202100,57381202101,57381202103,57381202121,57381202123,57381202301,57381202303,57381202321,57381220111,57381220113,57381221021,57381221230,57381221231,57381223101,57381223103,57381223301,57381223303,57381223321,57381223323,57381310000,57381310002,57381310020,57381310022,57381310200,57381310202,57381310203,57381312020,57381312022,57381312230,57381312232,57381330120,57381330122,57381330300,57381330302,57381330320,57381330322,57381330323,57381332112,57381332130,57381332132,57381332133,57381333220,57381333222,57381333223,57381401111,57381410000,57381410001,57381410010,57382201110,57382201111,57382210200,57382210201,57382210203,57382212010,57382212011,57382212013,57382212031,57382212033,57382212311,57382213200,57382213201,57382213203,57382231010,57382231011,57382231100,57382231101,57382231103,57382231130,57382231131,57382231133,57382231311,57382231313,57382231331,57382231333,57382311012,57382311030,57382311032,57382311033,57382311320,57382311322,57382313132,57382322010,57382322011,57382322301,57382322303,57382322321,57382322323,57382420200,57382420202,57382420220,57382420222,57382422030,57382422032,57382422210,57382422212,57382422230,57382422232,57383300110,57383300111,57383301000,57383301001,57383301010,57383301011,57383301100,57383301101,57383301131,57383301133,57383301311,57383301331,57383301333,57383312000,57383312001,57383312003,57383312021,57383312023,57383312221,57383312223,57383330010,57383330011,57383330013,57383330031,57383330033,57383330320,57383330321,57383330323,57383332101,57383332103,57383332121,57383333210,57383333211,57383333213,57383400010,57383400012,57383402010,57383402012,57383402013,57383420122,57383420300,57383420302,57383420320,57383420322,57383420323,57383422112,57383422130,57383422132,57383422310,57383333233,57383333231,57384311100,
044,00,,504070312,127753125,505110937,128559375,0,6,10,41,92,209,5340212,5340213,5340303,5340310,5340311,5340312,53402200,53402202,53402220,53402222,53403013,53403130,53403132,53404011,53404100,53404101,534012223,534020313,534020330,534020331,534020332,534021032,534021033,534021111,534021113,534021131,534021133,534022012,534022030,534022210,534022212,534030112,534030113,534030121,534030122,534030123,534030211,534030212,534030213,534030230,534030231,534030233,534031310,534032000,534032002,534032020,534032022,534040011,534040100,534040101,534040131,534040133,534041020,534041021,534041100,534041102,534041120,5340122221,5340122223,5340203113,5340203121,5340203122,5340203123,5340203211,5340203213,5340203231,5340203233,5340203330,5340203331,5340203333,5340210223,5340210233,5340210313,5340211101,5340211103,5340211121,5340211122,5340211123,5340211220,5340211222,5340211223,5340211232,5340211233,5340211301,5340211323,5340220102,5340220130,5340220132,5340220320,5340220322,5340222300,5340222301,5340222302,5340222320,5340300333,5340301031,5340301032,5340301033,5340301102,5340301103,5340301111,5340301112,5340301113,5340301201,5340301202,5340301203,5340302103,5340302211,5340302213,5340302320,5340302321,5340302323,5340313110,5340313111,5340313120,5340313122,5340313300,5340320010,5340320011,5340320012,5340320210,5340320212,5340320230,5340320232,5340400101,5340401030,5340401031,5340401033,5340401211,5340401300,5340401301,5340401303,5340410230,5340410300,5340410301,5340410303,5340410310,5340410311,5340410313,5340411010,5340411011,5340411012,5340411030,5340411032,5340411210,5340411212,5340411220,5340411221,5340411230,53401133233,53401133322,53401133323,53401133332,53401133333,53401222032,53401222033,53401222123,53401222132,53401222133,53401222201,53401222203,53401222221,53401222222,53401222223,53402030313,53402030331,53402030333,53402031033,53402031103,53402031111,53402031112,53402031113,53402031121,53402031122,53402031123,53402031201,53402031202,53402031203,53402032123,53402032301,53402032303,53402032321,53402032323,53402033320,53402033321,53402033323,53402102223,53402102311,53402102313,53402102322,53402102323,53402103032,53402103033,53402103121,53402103122,53402103123,53402111201,53402111203,53402112020,53402112022,53402112023,53402112210,53402112212,53402112213,53402112302,53402112303,53402112313,53402113000,53402113001,53402113030,53402113031,53402113033,53402113202,53402113211,53402113212,53402113213,53402113220,53402113222,53402113223,53402201002,53402201330,53402201332,53402203210,53402203212,53402203230,53402221300,53402221302,53402221320,53402221322,53402223030,53402223032,53402223100,53402223220,53402223221,53402223222,53403003131,53403003133,53403003303,53403003311,53403003312,53403003313,53403003321,53403003322,53403003323,53403010101,53403010110,53403010111,53403010123,53403010131,53403010132,53403010133,53403010231,53403010232,53403010233,53403010301,53403010302,53403010303,53403011000,53403011001,53403011010,53403011011,53403011013,53403011101,53403011102,53403011103,53403012001,53403012002,53403012003,53403020313,53403020323,53403020331,53403020332,53403020333,53403021011,53403021012,53403021013,53403021023,53403022101,53403022311,53403023220,53403023221,53403023223,53403131120,53403131210,53403131212,53403131230,53403131232,53403133010,53403133020,53403133022,53403133200,53403133202,53403133220,53403133222,53403200130,53403200300,53403200301,53403200302,53403200320,53403200322,53403200323,53403201000,53403220000,53403220001,53403220002,53403220010,53403220011,53403220100,53403220101,53404001001,53404001031,53404001033,53404010210,53404010211,53404010213,53404010231,53404010320,53404010321,53404010323,53404012101,53404012103,53404013021,53404013023,53404013210,53404013211,53404013213,53404013231,53404013233,53404031011,53404031100,53404031101,53404031110,53404031111,53404102310,53404102311,53404102320,53404103020,53404103021,53404103022,53404103120,53404103121,53404103123,53404103200,53404103311,53404110130,53404110131,53404110132,53404112110,53404112112,53404112130,53404112132,53404112230,53404112231,53404112310,53404112312,53404112320,53404112321,53404112323,
044,01,/,503535937,128184375,504576562,128868750,0,1,17,44,84,174,5339471,53393721,53393723,53394723,53394730,53394731,53394732,53404000,53404002,53404003,53404020,53404021,53404023,53404030,53404032,53404033,53405010,53405011,533937200,533937201,533937203,533937221,533937223,533937322,533937323,533937332,533937333,533947001,533947010,533947011,533947013,533947031,533947033,533947211,533947212,533947213,533947330,533947331,534030222,534040012,534040013,534040120,534040122,534040123,534040220,534040221,534040223,534040312,534040313,534041022,534041200,534041202,534041220,534041222,534050001,534050010,534050011,534050013,534050121,534051000,534051001,534051002,5339370213,5339370222,5339370223,5339370231,5339370232,5339370233,5339370322,5339370323,5339370332,5339370333,5339371222,5339372021,5339373000,5339373002,5339373020,5339373022,5339373200,5339373202,5339373313,5339470121,5339472101,5339472103,5339472233,5339473320,5339473321,5339570100,5339570101,5339570102,5339570110,5339570111,5339571000,5339571001,5339571010,5339571011,5339571013,5339571031,5339571102,5339571120,5340302202,5340302203,5340302212,5340302230,5340302232,5340302233,5340400102,5340401020,5340401022,5340401212,5340401213,5340401320,5340401322,5340402221,5340402223,5340403100,5340403102,5340403103,5340403112,5340403113,5340412030,5340412032,5340412210,5340412212,5340412230,5340412232,5340412233,5340500031,5340500120,5340500121,5340500122,5340501200,5340501201,5340501203,5340501221,5340501223,5340501230,5340501231,5340501232,5340501300,5340501301,5340501302,5340501310,5340501311,5340503001,5340510030,53393613331,53393613333,53393631111,53393702112,53393702113,53393702213,53393702302,53393702303,53393703002,53393703020,53393703022,53393703200,53393703202,53393703203,53393703212,53393703213,53393712230,53393712232,53393720201,53393720231,53393720233,53393730010,53393730012,53393730030,53393730032,53393730210,53393730212,53393730230,53393730232,53393732010,53393732012,53393732030,53393732032,53393732033,53393732122,53393732123,53393732132,53393732133,53393733022,53393733023,53393733032,53393733033,53393733103,53393733112,53393733113,53393733121,53393733122,53393733123,53394700310,53394700311,53394701200,53394701201,53394701203,53394701230,53394701231,53394701233,53394703233,53394720313,53394720331,53394720333,53394721003,53394721021,53394721022,53394721023,53394722313,53394733220,53394733222,53394733300,53394733302,53395701030,53395701031,53395701032,53395701120,53395701200,53395701201,53395710031,53395710120,53395710121,53395710123,53395710301,53395710330,53395710331,53395711000,53395711002,53395711220,53395711221,53395711223,53403022002,53403022103,53403022310,53403022312,53403022313,53403023222,53404001000,53404001002,53404001003,53404001030,53404001032,53404010212,53404010230,53404010232,53404010233,53404010322,53404012100,53404012102,53404013020,53404013022,53404013212,53404013230,53404013232,53404022201,53404031010,53404031012,53404031013,53404031102,53404031103,53404031112,53404031113,53404120120,53404120122,53404120123,53404122312,53405000011,53405000013,53405000031,53405000301,53405000303,53405000330,53405000331,53405000333,53405001230,53405001231,53405001233,53405003101,53405003110,53405003111,53405003113,53405012020,53405012021,53405012023,53405012201,53405012203,53405012221,53405012223,53405012330,53405012332,53405013030,53405013031,53405013032,53405013120,53405013121,53405013130,53405013131,53405013200,53405013201,53405030001,53405030100,53405030101,53405030102,53405100310,53405100311,53405100312,53405100320,53405100322,53405101002,53405101020,53405101022,53405102000,53405102001,53405102002,53405102010,53405102011,53393702301,53393702212,
045,00,ڹ,503423437,126534375,504942187,127996875,2,13,31,73,161,368,524070,534000,5239773,5240600,5240602,5240603,5240712,5339071,5339073,5340010,5340012,5340100,5340101,5340103,5340201,52397711,52397712,52397713,52397721,52397723,52406010,52406012,52406013,52406102,52407100,52407102,52407103,52407132,53390700,53390701,53390703,53390723,53391710,53391711,53391713,53401021,53401023,53401100,53401102,53401120,53401122,53401123,53401132,53402100,53402101,53402110,523967311,523967313,523967323,523967331,523967332,523967333,523977031,523977033,523977101,523977102,523977103,523977203,523977221,523977222,523977223,524050222,524050223,524050232,524050233,524060112,524060113,524061200,524061202,524061220,524061222,524061223,524071010,524071012,524071122,524071300,524071302,524071303,524071312,533906113,533906130,533906131,533907021,533907211,533907212,533907213,533917010,533917011,533917013,533917121,533917310,533917311,534001100,534001101,534001102,534001120,534001122,534001300,534010200,534010201,534010203,534010221,534011010,534011012,534011030,534011031,534011032,534011210,534011212,534011213,534011302,534011330,534011331,534020010,534020011,534020013,534021020,534021021,534021121,5239573313,5239671313,5239671331,5239671332,5239671333,5239673103,5239673121,5239673123,5239673212,5239673301,5239673302,5239673303,5239763331,5239763333,5239770131,5239770132,5239770133,5239770301,5239770303,5239770321,5239770322,5239770323,5239771002,5239771003,5239772011,5239772012,5239772013,5239772201,5239772202,5239772203,5240502202,5240502203,5240502212,5240503222,5240601100,5240601102,5240610022,5240610033,5240610120,5240610122,5240610300,5240610302,5240612010,5240612012,5240612030,5240612032,5240612210,5240612212,5240612213,5240612322,5240710110,5240710112,5240710130,5240710132,5240711200,5240711202,5240711203,5240711230,5240711232,5240713012,5240713013,5240713102,5240713103,5240713300,5240713302,5240713320,5339061111,5339061112,5339061113,5339061121,5339061123,5339061320,5339061321,5339061322,5339061330,5339070200,5339070201,5339070230,5339070231,5339070233,5339072101,5339072102,5339072103,5339072231,5339072233,5339170011,5339170120,5339170121,5339170123,5339171200,5339171201,5339171230,5339171231,5339171233,5339173121,5339173130,5340011030,5340011032,5340011210,5340011212,5340013010,5340013012,5340013020,5340013021,5340013022,5340013200,5340013202,5340102020,5340102021,5340102023,5340102231,5340102233,5340110110,5340110111,5340110112,5340110130,5340110132,5340110133,5340110330,5340110332,5340112110,5340112112,5340112113,5340113002,5340113003,5340113030,5340113032,5340113320,5340113321,5340113322,5340113330,5340113331,5340122200,5340122202,5340200121,5340200123,5340200310,5340200311,5340200313,5340200331,5340203001,5340203010,5340203011,5340203100,5340203101,5340203102,5340210220,5340210221,5340210230,5340210300,5340210301,5340210302,5340210310,5340210311,5340211100,5340211102,5340211200,5340211201,5340211203,5340211302,5339072213,52395733112,52395733113,52395733310,52395733311,52395733313,52395733331,52395733333,52396711111,52396711113,52396711131,52396711133,52396711311,52396711313,52396711331,52396711333,52396713111,52396713112,52396713113,52396713123,52396713301,52396713303,52396731011,52396731012,52396731013,52396732131,52396732132,52396732133,52396732211,52396732213,52396732231,52396732233,52396733002,52396733003,52397633133,52397633303,52397633321,52397633323,52397701131,52397701133,52397701231,52397701232,52397701233,52397701303,52397702313,52397702331,52397702333,52397703021,52397703023,52397703201,52397703202,52397703203,52397710011,52397710012,52397710013,52397720031,52397720033,52397720102,52397720103,52397720211,52397720213,52397720231,52397720232,52397720233,52397722003,52405022002,52405022003,52405022012,52405022013,52405022102,52405022103,52405022130,52405022132,52405022133,52405023022,52405023023,52405023032,52405023033,52405023122,52405023123,52405032232,52405032323,52405032332,52405032333,52405033222,52405033223,52406011010,52406011012,52406011030,52406011032,52406011033,52406011122,52406011123,52406011132,52406100133,52406100230,52406100232,52406100233,52406100303,52406100311,52406100312,52406100313,52406100321,52406100322,52406100323,52406101022,52406101023,52406101032,52406101210,52406101212,52406101230,52406101232,52406103010,52406103200,52406103202,52406103220,52406120110,52406120111,52406120112,52406120130,52406120332,52406122110,52406122112,52406122113,52406123022,52406123200,52406123202,52406123203,52406123230,52406123232,52406123233,52406123322,52406123323,52407101112,52407101130,52407101132,52407101310,52407101312,52407101330,52407101332,52407101333,52407110222,52407112010,52407112012,52407112122,52407130100,52407130101,52407130102,52407130112,52407130113,52407131002,52407131003,52407131120,52407131122,52407131300,52407131302,52407133010,52407133011,52407133012,52407133030,52407133032,52407133220,52407133222,53390611013,53390611031,53390611032,53390611033,53390611101,53390611102,53390611103,53390612113,53390612131,53390612133,53390612311,53390612313,53390612331,53390613230,53390613231,53390613232,53390613310,53390702020,53390702021,53390702022,53390702030,53390702211,53390702213,53390702320,53390702321,53390720110,53390720111,53390720133,53390720311,53390720313,53390720331,53390720332,53390720333,53390721000,53390721001,53390721003,53390722110,53390722111,53390722113,53390722123,53390722301,53390722323,53391700101,53391700103,53391700131,53391700133,53391700311,53391700313,53391701221,53391703011,53391703100,53391703101,53391703110,53391703111,53391703113,53391712031,53391712033,53391712211,53391712213,53391712231,53391712320,53391712321,53391712323,53391730111,53391730113,53391730131,53391730133,53391731201,53391731310,53391731311,53391731313,53400110310,53400110312,53400110330,53400110332,53400111000,53400111002,53400112110,53400112112,53400112130,53400112132,53400112300,53400112301,53400112302,53400112310,53400112320,53400112322,53400112323,53400130230,53400130232,53400130300,53400130301,53400130302,53400132010,53400132030,53400132032,53400132200,53400132201,53400132202,53400132220,53400132222,53401020220,53401020221,53401020223,53401022011,53401022013,53401022031,53401022301,53401022303,53401022321,53401101130,53401101132,53401101310,53401101312,53401101313,53401103310,53401103311,53401103312,53401103330,53401110000,53401110202,53401110220,53401110222,53401112000,53401112002,53401112020,53401112022,53401112200,53401121112,53401121113,53401130002,53401130330,53401130332,53401131223,53401131232,53401131233,53401131322,53401131323,53401131332,53401131333,53401133230,53401133231,53401133232,53401133320,53401133321,53401133330,53401133331,53401220222,53401222030,53401222200,53401222202,53401222220,53402000110,53402000111,53402000113,53402000131,53402003011,53402003121,53402003331,53402003333,53402021111,53402030000,53402030001,53402030030,53402030031,53402030120,53402030130,53402030131,53402030133,53402030311,53402031030,53402031031,53402031032,53402031100,53402031101,53402031102,53402031110,53402031120,53402031200,53402102220,53402102221,53402102222,53402102310,53402102312,53402102320,53402102321,53402103030,53402103031,53402103120,53402111200,53402111202,53402112021,53402112211,53402112300,53402112301,53402112310,53402112311,53402112312,53402113002,53402113003,53402113032,53402113200,53402113201,53402113203,53402113210,53402113221,
046,00,˼,503071875,125615625,503985937,127284375,0,6,25,57,173,355,5239470,5239472,5239570,5239572,5239670,5239672,52393611,52393612,52393613,52393630,52393631,52393700,52393702,52393720,52393722,52393723,52394613,52394631,52394633,52395611,52395613,52395631,52395633,52395732,52396611,52396613,52396710,52396712,52396730,52397631,52397700,523926323,523926332,523926333,523927220,523927222,523927223,523927232,523927233,523936032,523936033,523936101,523936103,523936201,523936210,523936211,523936321,523936331,523936333,523937010,523937012,523946111,523946113,523946122,523946123,523946303,523946321,523956103,523956121,523956321,523956323,523957100,523957102,523957103,523957120,523957330,523957332,523966101,523966103,523966121,523967110,523967112,523967130,523967132,523967320,523976113,523976131,523976133,523976302,523976303,523976321,523976330,523976332,523977010,523977020,523977021,523977022,533906101,5239263211,5239263213,5239263223,5239263300,5239263302,5239263303,5239263312,5239263313,5239272210,5239272212,5239272213,5239272302,5239272303,5239272312,5239360223,5239360231,5239360232,5239360233,5239360312,5239360313,5239361021,5239361023,5239362001,5239362003,5239362020,5239362021,5239362030,5239362031,5239362120,5239362121,5239362130,5239362131,5239363203,5239363300,5239363301,5239363303,5239370110,5239370112,5239370130,5239370132,5239370300,5239370301,5239370302,5239370310,5239370320,5239372102,5239372120,5239372122,5239373222,5239461123,5239461203,5239461212,5239461213,5239463011,5239463012,5239463013,5239463201,5239463203,5239463231,5239471000,5239471002,5239471220,5239471222,5239473000,5239473001,5239473002,5239473022,5239473200,5239473202,5239473220,5239473222,5239561231,5239561233,5239563011,5239563013,5239563031,5239563033,5239563201,5239563203,5239563221,5239563223,5239571012,5239571013,5239571210,5239571211,5239571212,5239571220,5239571221,5239571223,5239571230,5239571300,5239573022,5239573310,5239573312,5239573330,5239573332,5239661001,5239661003,5239661021,5239661023,5239661201,5239661231,5239663101,5239663110,5239663111,5239663113,5239663313,5239663331,5239663333,5239671110,5239671112,5239671130,5239671132,5239671310,5239673100,5239673102,5239673120,5239673122,5239673210,5239673211,5239673220,5239673222,5239761111,5239761112,5239761113,5239761121,5239761123,5239761301,5239761303,5239761321,5239761322,5239761323,5239762122,5239762123,5239762131,5239762132,5239762133,5239763003,5239763011,5239763012,5239763013,5239763201,5239763203,5239763230,5239763231,5239763233,5239763310,5239763311,5239763312,5239770110,5239770111,5239770112,5239770120,5239770121,5239770122,5239770230,5239770232,5239770300,5239771000,5239772000,5239772001,5239772002,5239772020,5239772022,5339061003,5339061030,5339061031,5339061033,5339061100,5339061102,5339061120,5239561200,5239753133,52392632033,52392632121,52392632122,52392632123,52392632211,52392632212,52392632213,52392633010,52392633012,52392633013,52392633102,52392633103,52392633111,52392633112,52392633113,52392720233,52392720322,52392720323,52392722111,52392722112,52392722113,52392723000,52392723002,52392723003,52392723012,52392723013,52392723132,52393601333,52393602223,52393602301,52393602303,52393603032,52393603033,52393603103,52393603111,52393603112,52393603113,52393610010,52393610011,52393610013,52393610031,52393610033,52393610222,52393610223,52393620001,52393620003,52393620021,52393620023,52393620221,52393620223,52393620230,52393620231,52393620232,52393620320,52393620321,52393620330,52393620331,52393621220,52393621221,52393621321,52393621330,52393621331,52393621333,52393632010,52393632011,52393632013,52393633020,52393633022,52393633211,52393633213,52393633231,52393701110,52393701332,52393703030,52393703110,52393703220,52393703221,52393703222,52393721000,52393721002,52393721003,52393721210,52393721212,52393721230,52393721232,52393721233,52393721322,52393721323,52393721332,52393721333,52393732022,52393732200,52393732202,52393732203,52393732230,52393732232,52394603311,52394603313,52394603331,52394603333,52394610333,52394611031,52394611033,52394611211,52394611212,52394611213,52394611222,52394611223,52394612023,52394612111,52394612112,52394612113,52394630000,52394630001,52394630010,52394630101,52394630102,52394630103,52394630213,52394630231,52394630232,52394630233,52394632300,52394632301,52394632303,52394632331,52394632333,52394710010,52394710200,52394710202,52394710220,52394710222,52394712000,52394712002,52394712020,52394712022,52394712212,52394712230,52394712232,52394712233,52394730030,52394730032,52394730200,52394730201,52394730202,52394730232,52394732010,52394732012,52394732030,52394732032,52394732210,52394732212,52394732230,52394732232,52394732233,52395610111,52395610113,52395610131,52395610133,52395610212,52395610213,52395610230,52395610231,52395610233,52395612011,52395612013,52395612031,52395612300,52395612301,52395612303,52395612321,52395612323,52395630101,52395630301,52395630303,52395630321,52395630322,52395630323,52395632003,52395632021,52395632023,52395632223,52395710102,52395710103,52395710112,52395711220,52395711222,52395712130,52395712131,52395712132,52395712220,52395712221,52395712222,52395712310,52395712320,52395712322,52395713020,52395730000,52395730020,52395730022,52395730200,52395730202,52395730232,52395733312,52395733330,52395733332,52396610001,52396610003,52396610021,52396610023,52396610201,52396610203,52396610221,52396612030,52396612031,52396612033,52396612300,52396612301,52396612303,52396612321,52396612330,52396612331,52396612333,52396631000,52396631001,52396631120,52396631121,52396631123,52396631310,52396631311,52396631313,52396631331,52396631333,52396633111,52396633113,52396633321,52396633323,52396711110,52396711112,52396711130,52396711132,52396711310,52396711312,52396711330,52396711332,52396713110,52396713120,52396713121,52396713122,52396713300,52396713302,52396731010,52396732130,52396732210,52396732212,52396732230,52396732232,52396733000,52396733001,52397611031,52397611033,52397611101,52397611102,52397611103,52397611221,52397611223,52397612332,52397612333,52397613001,52397613003,52397613203,52397620333,52397621133,52397621212,52397621213,52397621301,52397621302,52397621303,52397622111,52397623000,52397623001,52397623010,52397623101,52397623110,52397623111,52397630013,52397630021,52397630022,52397630023,52397630101,52397630102,52397630103,52397632000,52397632001,52397632003,52397632021,52397632023,52397632210,52397632211,52397632321,52397632322,52397632323,52397633130,52397633131,52397633132,52397633300,52397633301,52397633302,52397633320,52397633322,52397701130,52397701132,52397701230,52397701300,52397701301,52397701302,52397702310,52397702311,52397702312,52397702330,52397702332,52397703020,52397703022,52397703200,52397710010,52397720030,52397720032,52397720100,52397720101,52397720210,52397720212,52397720230,52397722000,52397722001,52397722002,53390610011,53390610013,53390610211,53390610321,53390610323,53390611010,53390611011,53390611012,53390611030,53390611100,53390611220,53390611221,53390611222,53390612111,53390612110,52393633021,52397622110,52397620332,52397620323,52397632212,
047,00,˼,503676562,125662500,505518750,127237500,0,11,29,75,188,395,5240500,5240512,5240513,5240611,5240613,5240620,5240622,5240623,5240720,5240721,5240723,52393712,52393730,52394713,52394731,52394733,52395731,52404020,52404022,52404023,52405010,52405012,52405020,52405021,52405030,52405031,52405222,52405223,52406121,52406210,52406212,52406213,52406322,52407111,52407113,52407220,52407221,52407300,52407302,52407320,523937033,523937100,523937102,523937211,523937321,523937323,523947101,523947103,523947110,523947112,523947121,523947123,523947301,523947303,523947321,523947323,523957110,523957111,523957113,523957131,523957132,523957133,523957301,523957303,524040022,524040212,524040213,524040302,524040320,524040322,524040323,524050110,524050112,524050130,524050132,524050133,524050320,524050321,524050330,524050331,524050333,524051022,524051023,524051033,524051123,524051132,524052202,524052203,524052212,524052302,524052320,524052322,524061000,524061011,524061013,524061031,524061033,524061231,524062112,524062113,524063020,524063022,524063200,524063202,524063203,524071100,524071101,524071103,524071331,524072231,524072233,524073220,524073221,534002101,534002110,5239273222,5239370113,5239370131,5239370312,5239370313,5239370321,5239370323,5239371012,5239371030,5239371032,5239371033,5239372101,5239372103,5239372130,5239372131,5239373122,5239373200,5239373201,5239373203,5239373221,5239373300,5239373302,5239373320,5239373322,5239471003,5239471021,5239471023,5239471130,5239471132,5239471133,5239471201,5239471203,5239473021,5239571120,5239571121,5239571123,5239571233,5239571301,5239571303,5239573001,5239573003,5239573021,5240400200,5240400202,5240400230,5240400232,5240400233,5240402100,5240402102,5240402103,5240403032,5240403210,5240403212,5240403213,5240403302,5240403320,5240403321,5240403322,5240501110,5240501112,5240501310,5240501312,5240501313,5240502211,5240502300,5240502301,5240502310,5240502311,5240502313,5240503220,5240503221,5240503230,5240503231,5240503320,5240503321,5240503323,5240510213,5240510320,5240510322,5240510323,5240511203,5240511210,5240511212,5240511213,5240511221,5240511222,5240511223,5240511302,5240511303,5240511312,5240511330,5240511332,5240511333,5240522000,5240522002,5240522003,5240522011,5240522012,5240522013,5240522102,5240522103,5240522132,5240523002,5240523030,5240523032,5240523210,5240523212,5240523230,5240523232,5240523233,5240601110,5240601111,5240610010,5240610011,5240610012,5240610020,5240610021,5240610100,5240610101,5240610303,5240610321,5240610323,5240612031,5240612300,5240612301,5240612303,5240612321,5240612330,5240612331,5240612333,5240621100,5240621102,5240621113,5240630020,5240630022,5240630023,5240630212,5240630230,5240630232,5240632010,5240632012,5240632013,5240632302,5240632322,5240711020,5240711021,5240711023,5240711210,5240711211,5240711213,5240711231,5240711233,5240713101,5240713110,5240713111,5240713113,5240713131,5240713132,5240713133,5240722200,5240722201,5240722202,5240722300,5240722301,5240722303,5240722321,5240730100,5240730322,5240732100,5240732102,5240732103,5240732120,5240732121,5240732122,5240732220,5240732221,5240732230,5240732231,5240732232,5240732300,5240732302,5340021000,5340021001,5340021003,5340021110,5340021111,5340021112,5240403303,52392732200,52392732202,52392732230,52392732232,52393701111,52393701112,52393701113,52393701330,52393701331,52393701333,52393703031,52393703032,52393703033,52393703111,52393703112,52393703113,52393703223,52393710312,52393711222,52393713000,52393713002,52393713020,52393713022,52393713200,52393713202,52393713222,52393721001,52393721211,52393721213,52393721231,52393721320,52393721321,52393721330,52393721331,52393731000,52393731022,52393731200,52393731202,52393731203,52393732020,52393732021,52393732023,52393732201,52393732231,52393732233,52393733010,52393733012,52393733030,52393733032,52393733210,52393733212,52393733230,52393733232,52393733233,52394710011,52394710012,52394710013,52394710201,52394710203,52394710221,52394710223,52394711102,52394711120,52394711122,52394711123,52394711312,52394712001,52394712003,52394712021,52394712023,52394712210,52394712211,52394712213,52394712231,52394730031,52394730033,52394730203,52394730230,52394730231,52394730233,52394732011,52394732013,52394732031,52394732033,52394732211,52394732213,52394732231,52395710100,52395710101,52395710110,52395710111,52395710113,52395711221,52395711223,52395712133,52395712223,52395712311,52395712312,52395712313,52395712321,52395712323,52395713021,52395713022,52395713023,52395730001,52395730002,52395730003,52395730021,52395730023,52395730201,52395730203,52395730230,52395730231,52395730233,52395733110,52395733111,52404000222,52404002012,52404002030,52404002032,52404002033,52404002122,52404002123,52404002310,52404002312,52404003222,52404021010,52404021012,52404021120,52404021122,52404021123,52404021132,52404030032,52404030033,52404030122,52404030300,52404030302,52404030303,52404030330,52404030332,52404032110,52404032112,52404032113,52404033002,52404033230,52404033232,52405011300,52405011302,52405011320,52405011322,52405011323,52405013110,52405013112,52405013113,52405022000,52405022001,52405022010,52405022011,52405022100,52405022101,52405022131,52405023020,52405023021,52405023030,52405023031,52405023120,52405023121,52405032230,52405032231,52405032233,52405032320,52405032321,52405032322,52405032330,52405032331,52405033220,52405033221,52405102002,52405102020,52405102022,52405102023,52405102032,52405102123,52405103020,52405103132,52405103133,52405103212,52405103213,52405110233,52405110322,52405110323,52405112011,52405112012,52405112013,52405112022,52405112112,52405112113,52405112200,52405112202,52405113002,52405113312,52405202220,52405202222,52405202223,52405202332,52405202333,52405220012,52405220013,52405220102,52405220103,52405221000,52405221002,52405221003,52405221012,52405221113,52405221122,52405221131,52405221133,52405221300,52405221311,52405221313,52405221332,52405221333,52405230002,52405230003,52405230030,52405230032,52405230033,52405230122,52405230123,52405232130,52405232132,52405232310,52405232312,52405233222,52405233223,52406011011,52406011013,52406011031,52406011120,52406011121,52406011130,52406011131,52406011133,52406100130,52406100131,52406100132,52406100231,52406100300,52406100301,52406100302,52406100310,52406100320,52406101020,52406101021,52406101030,52406101031,52406101033,52406101211,52406101213,52406101231,52406101233,52406103011,52406103012,52406103013,52406103201,52406103203,52406103221,52406103222,52406103223,52406120113,52406120131,52406120132,52406120133,52406120330,52406120331,52406120333,52406122111,52406123020,52406123021,52406123023,52406123201,52406123231,52406123320,52406123321,52406211012,52406211030,52406211032,52406211123,52406300020,52406300022,52406300023,52406300210,52406300212,52406302100,52406302102,52406302332,52406320110,52406320112,52406321202,52406321220,52406321222,52406323000,52406323002,52406323003,52406323200,52406323202,52407101110,52407101111,52407101113,52407101131,52407101133,52407101311,52407101313,52407101331,52407110220,52407110221,52407110223,52407112011,52407112013,52407112120,52407112121,52407112123,52407130103,52407130110,52407130111,52407131000,52407131001,52407131121,52407131123,52407131301,52407131303,52407133013,52407133031,52407133310,52407133311,52407133313,52407222100,52407222101,52407222110,52407222111,52407222113,52407222200,52407222201,52407222202,52407223021,52407223231,52407223233,52407301220,52407301222,52407303000,52407303002,52407303020,52407303022,52407303200,52407303202,52407303203,52407303232,52407321010,52407321012,52407321230,52407321231,52407321232,52407322220,52407322221,52407322222,52407322230,52407322231,52407322233,52407322330,52407322331,52407323010,52407323012,52407323030,52407323200,52407323201,52407323202,53400201100,53400201101,53400201110,53400201111,53400201113,53400210020,53400210021,53400210023,53400211130,53400211131,53400211132,53400300000,53400300002,53400300011,53400300020,53400300100,52404033122,52404033120,
048,00,и/彽Τ,504646875,127134375,505828125,128268750,0,8,25,57,117,257,5340022,5340023,5340120,5340121,5340123,5340221,5340230,5340232,53400113,53400131,53400133,53400200,53400202,53400203,53400212,53400213,53401111,53401113,53401221,53401223,53401300,53401302,53401320,53401322,53402230,53402231,53402233,53402330,53402332,53403211,53403300,53403301,53403310,524072223,534001111,534001112,534001113,534001321,534001323,534002010,534002012,534002013,534002102,534002103,534002112,534002113,534003002,534003020,534003022,534003200,534003202,534003220,534003222,534011101,534011103,534011121,534011123,534011301,534011310,534011311,534012200,534012201,534012203,534013212,534013230,534013232,534013233,534022011,534022031,534022033,534022211,534022320,534022321,534022323,534023120,534023122,534023123,534023312,534023330,534023332,534023333,534032101,534032103,534032122,534032123,534033021,534033023,534033030,534033031,534033120,5240713321,5240713323,5240713330,5240713332,5240713333,5240722203,5240722212,5240722213,5240722221,5240722222,5240722223,5240722320,5240722322,5340011101,5340011102,5340011103,5340011233,5340013011,5340013013,5340013031,5340013032,5340013033,5340013221,5340013223,5340020112,5340020113,5340030003,5340030012,5340030030,5340030032,5340030210,5340030212,5340030230,5340030232,5340032010,5340032012,5340032030,5340032032,5340032210,5340032212,5340032230,5340032232,5340111001,5340111002,5340111003,5340111021,5340111023,5340111201,5340111203,5340111221,5340111222,5340111223,5340113001,5340113031,5340113120,5340113121,5340113130,5340113131,5340122020,5340122021,5340122023,5340122201,5340122210,5340122211,5340130302,5340130320,5340130322,5340132100,5340132102,5340132103,5340132132,5340132310,5340132312,5340220101,5340220103,5340220131,5340222131,5340222133,5340222311,5340222312,5340222313,5340223220,5340223221,5340223223,5340231002,5340231020,5340231022,5340231023,5340231210,5340231212,5340233100,5340233102,5340233132,5340233310,5340233312,5340233313,5340321023,5340321201,5340321202,5340321203,5340321210,5340321212,5340330200,5340330201,5340330320,5340330321,5340330322,5340330330,5340330331,5340331100,5340331101,5340331102,5340331210,5340331211,5340331212,5340331220,5340331221,52407133033,52407133221,52407133223,52407133312,52407222102,52407222103,52407222112,52407222203,52407223020,52407223022,52407223023,52407223230,52407223232,52407322223,52407322232,52407322332,53400110311,53400110313,53400110331,53400110333,53400111001,53400111003,53400112111,53400112113,53400112131,53400112133,53400112303,53400112311,53400112312,53400112313,53400112321,53400130231,53400130233,53400130303,53400132011,53400132012,53400132013,53400132031,53400132033,53400132203,53400132221,53400132223,53400201102,53400201103,53400201112,53400210022,53400211133,53400300001,53400300003,53400300010,53400300012,53400300013,53400300021,53400300022,53400300023,53400300101,53400300102,53400300103,53400300110,53400300112,53400322130,53400322132,53400322310,53400322312,53400322330,53400322332,53400322333,53401101131,53401101133,53401101311,53401103313,53401103331,53401103332,53401103333,53401110001,53401110002,53401110003,53401110200,53401110201,53401110203,53401110221,53401110223,53401112001,53401112003,53401112021,53401112023,53401112201,53401112202,53401112203,53401121110,53401121111,53401130000,53401130001,53401130003,53401130331,53401130333,53401131220,53401131221,53401131222,53401131230,53401131231,53401131320,53401131321,53401131330,53401131331,53401220220,53401220221,53401220223,53401222031,53401222120,53401222121,53401222122,53401222130,53401222131,53401301022,53401301222,53401303000,53401303002,53401303212,53401303230,53401303232,53401321010,53401321012,53401321300,53401321302,53401323130,53401323132,53401332220,53401332222,53402201000,53402201001,53402201003,53402201331,53402201333,53402203211,53402203213,53402203231,53402203232,53402203233,53402221301,53402221303,53402221321,53402221323,53402223031,53402223033,53402223101,53402223102,53402223103,53402223311,53402223313,53402223331,53402232220,53402232221,53402310000,53402310002,53402310003,53402310032,53402310210,53402310212,53402310322,53402310323,53402312132,53402312133,53402313200,53402313202,53402313222,53402313223,53402331012,53402331030,53402331032,53402331302,53402333110,53402333112,53402422022,53402422200,53402422202,53403203113,53403203131,53403203133,53403203311,53403203313,53403203331,53403210011,53403210013,53403210031,53403210033,53403210203,53403210211,53403210212,53403210213,53403210221,53403210223,53403212001,53403212002,53403212003,53403212112,53403212130,53403212132,53403212133,53403213001,53403213010,53403213011,53403213100,53403213101,53403213110,53403213111,53403230001,53403230010,53403230011,53403230100,53403230101,53403230110,53403230111,53403302031,53403302033,53403302211,53403302213,53403302231,53403302233,53403303230,53403303231,53403303232,53403303320,53403303321,53403303330,53403303331,53403311030,53403311031,53403311100,53403311101,53403311102,53403311110,53403311120,53403311200,53403311202,53403312130,53403312131,53403312132,53403312220,53403312221,53403312230,53403312300,53403312301,53403312302,53403320011,53403320100,53403320101,53403320110,53403320111,53403321000,53403321001,53403321003,53403321010,53403321012,53401301220,53402422203,53402313220,
048,01,ȬԾ,505504687,128081250,506770312,128859375,0,6,13,40,101,223,5340333,5340342,5340440,5340441,5340443,5340452,53403313,53403402,53403432,53404311,53404420,53404421,53404423,53404502,53404530,53404532,53405411,53405500,53405501,534033113,534033211,534033213,534033231,534033233,534034000,534034002,534034003,534034032,534034302,534034332,534043100,534043101,534043103,534043130,534043131,534043133,534043311,534044220,534044221,534044223,534045002,534045030,534045032,534045033,534045122,534045123,534045131,534045132,534045310,534045312,534045313,534054101,534054131,534055020,534055021,534055022,534055100,534055101,534055102,5340242222,5340331113,5340331121,5340331122,5340331123,5340331231,5340331232,5340331233,5340340012,5340340300,5340340302,5340340303,5340340330,5340340332,5340340333,5340343000,5340343002,5340343003,5340343030,5340343032,5340343033,5340343300,5340343302,5340343303,5340343332,5340430110,5340430111,5340430113,5340430131,5340431020,5340431021,5340431023,5340431210,5340431211,5340431320,5340431321,5340431323,5340433101,5340433103,5340433131,5340433133,5340442221,5340442223,5340450002,5340450003,5340450030,5340450032,5340450033,5340450312,5340450313,5340451202,5340451203,5340451212,5340451301,5340451303,5340451330,5340451331,5340451332,5340453110,5340453112,5340453113,5340453300,5340453302,5340453311,5340453313,5340453320,5340453322,5340460200,5340460202,5340460203,5340460220,5340540001,5340540003,5340540010,5340540012,5340540100,5340540101,5340540102,5340540110,5340540111,5340541001,5340541003,5340541030,5340541031,5340541033,5340541300,5340541301,5340541302,5340550230,5340550231,5340550300,5340550302,5340550311,5340550320,5340551030,5340551032,5340551100,5340551101,5340551200,5340551201,5340551202,53402422230,53402422232,53402422233,53403303233,53403303322,53403303323,53403303332,53403303333,53403311032,53403311033,53403311103,53403311111,53403311112,53403311113,53403311121,53403311122,53403311123,53403311201,53403311203,53403312133,53403312222,53403312223,53403312231,53403312232,53403312233,53403312303,53403321011,53403321013,53403321031,53403321033,53403321211,53403321213,53403321231,53403321233,53403323011,53403323013,53403323031,53403323033,53403323211,53403323213,53403323231,53403323233,53403400100,53403400102,53403400103,53403400132,53403401220,53403401222,53403401223,53403403010,53403403012,53403403013,53403403120,53403403122,53403403123,53403403312,53403412222,53403430012,53403430122,53403430312,53403431222,53403433012,53403433122,53403433300,53403433302,53403433303,53403433330,53403433332,53403433333,53404301011,53404301013,53404301031,53404301120,53404301121,53404310221,53404310223,53404312001,53404312010,53404312011,53404312013,53404312130,53404312131,53404312133,53404313221,53404313223,53404331211,53404331300,53404331301,53404331303,53404331321,53404333110,53404333111,53404422201,53404422203,53404422221,53404500000,53404500002,53404500003,53404500012,53404500122,53404500123,53404500312,53404500313,53404501220,53404501222,53404501223,53404501232,53404501233,53404503100,53404503102,53404503103,53404503112,53404511232,53404511233,53404511322,53404511323,53404511332,53404511333,53404512132,53404512133,53404513021,53404513022,53404513023,53404513332,53404531110,53404531112,53404533010,53404533011,53404533012,53404533030,53404533032,53404533100,53404533101,53404533103,53404533210,53404533212,53404533230,53404533232,53404533233,53404533310,53404533311,53404533313,53404600222,53404600223,53404600232,53404602010,53404602012,53404602013,53404602102,53404602120,53404602122,53404602210,53404602211,53404602212,53404620020,53404620022,53404620200,53404620202,53404620220,53404620222,53404622000,53404622002,53404622020,53404622022,53404622200,53404622202,53405400003,53405400021,53405400110,53405400111,53405400113,53405400131,53405400133,53405401030,53405401120,53405401121,53405401123,53405401130,53405410000,53405410001,53405410003,53405410021,53405410211,53405410213,53405410231,53405410320,53405410321,53405410323,53405412110,53405412111,53405412113,53405413030,53405413032,53405413311,53405413313,53405502320,53405502331,53405502333,53405503010,53405503011,53405503012,53405503030,53405503032,53405503101,53405503130,53405503131,53405503133,53405503220,53405503222,53405510310,53405510312,53405510330,53405510332,53405511020,53405511021,53405511022,53405511030,53405512030,53405512100,53405512101,53405520000,53405520001,53405520010,
049,00,/,504506250,128062500,505659375,129150000,2,3,23,38,132,276,534042,534052,5340413,5340432,5340511,53403221,53403222,53403223,53403231,53403232,53403233,53403322,53404111,53404113,53404121,53404123,53404300,53404302,53404303,53405130,53405131,53405133,53405300,53405302,53406110,53406111,53406200,53406201,534031313,534031331,534031333,534032011,534032012,534032013,534032030,534032032,534032132,534032133,534032202,534032203,534032302,534032303,534033202,534033203,534043012,534043122,534051011,534051012,534051013,534051030,534051031,534051033,534051213,534051321,534051323,534053010,534053012,534053200,534053202,534053220,534053222,534062021,534062030,534062031,534062100,534062101,5340222321,5340222323,5340222330,5340222332,5340313113,5340313303,5340313321,5340313323,5340320031,5340320033,5340320101,5340320102,5340320103,5340320211,5340320213,5340320231,5340320233,5340320310,5340320312,5340320330,5340320332,5340321000,5340321002,5340321302,5340321303,5340321312,5340321313,5340322002,5340322003,5340322011,5340322012,5340322013,5340323002,5340323003,5340323012,5340323013,5340330202,5340330220,5340330222,5340332000,5340332002,5340332003,5340332012,5340332013,5340332102,5340332120,5340332122,5340332300,5340332302,5340332320,5340332322,5340410233,5340410321,5340410322,5340410323,5340410330,5340410332,5340410333,5340411031,5340411033,5340411222,5340411233,5340412010,5340412011,5340412013,5340412031,5340412033,5340412211,5340412213,5340430100,5340430102,5340430130,5340430132,5340430133,5340431202,5340431203,5340431212,5340431230,5340433000,5340510033,5340510101,5340510103,5340510211,5340512111,5340512113,5340512301,5340512310,5340512311,5340512313,5340513200,5340513201,5340513223,5340530110,5340530112,5340530130,5340530132,5340532010,5340532012,5340532030,5340532210,5340532212,5340532230,5340532232,5340532233,5340610112,5340610113,5340610131,5340611210,5340611211,5340611300,5340620200,5340620201,5340620203,5340620230,5340620231,5340620320,5340620321,5340620322,5340621020,5340621021,5340621022,5340621030,5340621100,5340621101,5340621102,5340621110,5340621111,5340621200,5340630000,5340630001,5340630010,5340630011,53402223223,53402223310,53402223312,53402223330,53402223332,53402223333,53402232222,53402232223,53403131121,53403131122,53403131123,53403131211,53403131213,53403131231,53403131233,53403133011,53403133012,53403133013,53403133021,53403133023,53403133201,53403133203,53403133221,53403133223,53403200131,53403200132,53403200133,53403200303,53403200321,53403201001,53403201002,53403201003,53403203110,53403203111,53403203112,53403203130,53403203132,53403203310,53403203312,53403203330,53403203332,53403203333,53403210010,53403210012,53403210030,53403210032,53403210200,53403210201,53403210202,53403210210,53403210220,53403210222,53403212000,53403212110,53403212111,53403212113,53403212131,53403213000,53403213002,53403213003,53403213012,53403213013,53403213102,53403213103,53403213112,53403213113,53403220003,53403220012,53403220013,53403220102,53403220103,53403230000,53403230002,53403230003,53403230012,53403230013,53403230102,53403230103,53403230112,53403230113,53403302030,53403302032,53403302210,53403302212,53403302230,53403302232,53403320010,53403320012,53403320013,53403320102,53403320103,53403320112,53403320113,53403321002,53403321030,53403321032,53403321210,53403321212,53403321230,53403321232,53403323010,53403323012,53403323030,53403323032,53403323210,53403323212,53403323230,53403323232,53404102312,53404102313,53404102321,53404102322,53404102323,53404103023,53404103122,53404103201,53404103202,53404103203,53404103310,53404103312,53404103313,53404110133,53404112111,53404112113,53404112131,53404112133,53404112232,53404112233,53404112311,53404112313,53404112322,53404120121,53404122310,53404122311,53404122313,53404301010,53404301012,53404301030,53404301032,53404301033,53404301122,53404301123,53404310220,53404310222,53404312000,53404312002,53404312003,53404312012,53404312320,53404312321,53404312322,53404330010,53404330011,53404330012,53404330020,53404330021,53404330200,53404330202,53404330220,53404330222,53404332000,53404332002,53404332020,53404332202,53405100313,53405100321,53405100323,53405101000,53405101001,53405101003,53405101021,53405101023,53405102101,53405102130,53405102131,53405103231,53405103233,53405121100,53405121101,53405121103,53405121121,53405121123,53405121232,53405121233,53405123031,53405123120,53405123121,53405123123,53405123301,53405123310,53405123311,53405132020,53405132021,53405132030,53405132031,53405132033,53405132211,53405132213,53405132222,53405132223,53405301110,53405303000,53405303001,53405303002,53405303010,53405303011,53405303020,53405303022,53405303100,53405303101,53405303200,53405303202,53405303220,53405320320,53405320321,53405320322,53405322110,53405322112,53405322130,53405322132,53405322310,53405322312,53405322313,53405323222,53406101031,53406101033,53406101103,53406101111,53406101112,53406101113,53406101211,53406101300,53406101301,53406101303,53406101331,53406112001,53406112010,53406112011,53406113010,53406113011,53406113110,53406113111,53406202021,53406202211,53406202321,53406202330,53406202331,53406202333,53406203230,53406203300,53406203301,53406203302,53406210230,53406210231,53406210232,53406210310,53406210311,53406210312,53406210320,53406210321,53406211030,53406211031,53406211032,53406211130,53406211131,53406211200,53406212010,53406212012,53406212020,53406212021,53406212022,53406212030,53406300020,53406300021,53406301000,53406301002,
050,00,ĸҼ,505153125,128465625,507164062,129450000,0,8,21,76,157,367,5340531,5340533,5340542,5340543,5340631,5340640,5340641,5340642,53404621,53404630,53404631,53405321,53405402,53405403,53405521,53405522,53405523,53405530,53405532,53406213,53406302,53406303,53406320,53406321,53406330,53406331,53406430,53406500,53407400,534043301,534043303,534043321,534043323,534043330,534043332,534043333,534046023,534046132,534046201,534046203,534046221,534046223,534046230,534046231,534046232,534046320,534046331,534053033,534053230,534053231,534053233,534054002,534054003,534054012,534054013,534054120,534054122,534054123,534054132,534055033,534055111,534055112,534055113,534055122,534055123,534055130,534055131,534055132,534055201,534055202,534055203,534056000,534056001,534056002,534062113,534062121,534062311,534062313,534063002,534063003,534063011,534063012,534063013,534063221,534063230,534063231,534063320,534063321,534063323,534063330,534063331,534064310,534064312,534064320,534064321,534064322,534065010,534065011,534065012,534074010,534074011,534074012,534074020,534074021,534046330,5340431231,5340431233,5340433003,5340433021,5340433023,5340433100,5340433102,5340433120,5340433122,5340433123,5340433201,5340433203,5340433221,5340433222,5340433223,5340433310,5340433312,5340433313,5340453312,5340453330,5340453332,5340453333,5340460222,5340460223,5340460320,5340460322,5340460323,5340460332,5340461302,5340461303,5340461310,5340461311,5340461312,5340461330,5340461332,5340461333,5340462000,5340462001,5340462003,5340462021,5340462023,5340462201,5340462203,5340462221,5340462222,5340462223,5340462330,5340462331,5340462332,5340463210,5340463211,5340463330,5340530113,5340530131,5340530133,5340530303,5340530311,5340530312,5340530313,5340530321,5340530323,5340532011,5340532013,5340532031,5340532033,5340532320,5340532321,5340532323,5340541020,5340541022,5340541210,5340541212,5340541213,5340541330,5340541332,5340541333,5340550312,5340550321,5340550323,5340551211,5340551212,5340551213,5340551330,5340551331,5340551332,5340552002,5340552003,5340553100,5340553101,5340553102,5340553120,5340553122,5340553300,5340560030,5340560031,5340560032,5340560100,5340560101,5340560102,5340560200,5340621033,5340621112,5340621121,5340621122,5340621123,5340621231,5340621233,5340623100,5340623101,5340623103,5340623121,5340630003,5340630012,5340630013,5340630101,5340630102,5340630103,5340632200,5340632201,5340633220,5340633221,5340633320,5340633321,5340633322,5340633330,5340633331,5340633333,5340643110,5340643111,5340643112,5340643130,5340643132,5340643230,5340643232,5340643300,5340650130,5340650131,5340650200,5340650202,5340650220,5340651000,5340651001,5340651002,5340651010,5340731011,5340731111,5340731113,5340731131,5340740130,5340740131,5340740221,5340740223,5340740230,5340741000,5340741001,5340741002,5340463321,53404312132,53404312323,53404313220,53404313222,53404330013,53404330022,53404330023,53404330201,53404330203,53404330221,53404330223,53404331210,53404331212,53404331213,53404331302,53404331320,53404331322,53404331323,53404332001,53404332003,53404332021,53404332022,53404332023,53404332200,53404332201,53404332203,53404333112,53404333113,53404422200,53404422202,53404422220,53404422222,53404422223,53404513330,53404513331,53404513333,53404531111,53404531113,53404533013,53404533031,53404533033,53404533102,53404533211,53404533213,53404533231,53404533312,53404602121,53404602123,53404602132,53404602133,53404602213,53404603022,53404603212,53404603213,53404603332,53404603333,53404611323,53404611332,53404611333,53404612222,53404612223,53404612232,53404612233,53404612311,53404612313,53404612322,53404612323,53404612331,53404612332,53404612333,53404613002,53404613003,53404613011,53404613012,53404613013,53404613130,53404613132,53404613310,53404613312,53404613313,53404620021,53404620023,53404620201,53404620203,53404620221,53404620223,53404622001,53404622003,53404622021,53404622023,53404622201,53404622203,53404623330,53404623331,53404623332,53404632120,53404632121,53404632130,53404632131,53404632200,53404632201,53404632202,53404632210,53404633310,53404702202,53404702222,53404720002,53404720200,53404722000,53404722002,53405301111,53405301112,53405301113,53405303003,53405303012,53405303013,53405303021,53405303023,53405303102,53405303103,53405303201,53405303203,53405303221,53405303222,53405303223,53405320323,53405322111,53405322113,53405322131,53405322133,53405322311,53405323220,53405323221,53405323223,53405400000,53405400001,53405400002,53405400020,53405400022,53405400023,53405400112,53405400130,53405400132,53405401031,53405401032,53405401033,53405401122,53405401131,53405401132,53405401133,53405410002,53405410020,53405410022,53405410023,53405410210,53405410212,53405410230,53405410232,53405410233,53405410322,53405412112,53405413031,53405413033,53405413310,53405413312,53405502321,53405502322,53405502323,53405502330,53405502332,53405503013,53405503031,53405503033,53405503100,53405503102,53405503103,53405503132,53405503221,53405503223,53405510311,53405510313,53405510331,53405510333,53405511023,53405511031,53405511032,53405511033,53405512031,53405512032,53405512033,53405512102,53405512103,53405513330,53405520002,53405520003,53405520011,53405520012,53405520013,53405531030,53405531032,53405531100,53405531101,53405531210,53405531212,53405531230,53405531232,53405533020,53405533022,53405533200,53405533202,53405533220,53405600330,53405601030,53405601032,53405601100,53405601101,53405601200,53405601202,53405602010,53405602011,53405602012,53405602020,53405602021,53405602022,53405602100,53405602101,53405602200,53406210233,53406210313,53406210322,53406210323,53406211033,53406211132,53406211133,53406211201,53406211202,53406211203,53406212011,53406212013,53406212031,53406212032,53406212033,53406212211,53406212300,53406212301,53406212303,53406212321,53406230111,53406231021,53406231230,53406231231,53406231233,53406233100,53406233101,53406233110,53406233111,53406233113,53406300022,53406300023,53406301001,53406301003,53406322030,53406322031,53406322033,53406322301,53406322310,53406322311,53406323200,53406323201,53406323210,53406323301,53406323310,53406323311,53406323313,53406332221,53406332230,53406332231,53406332233,53406333230,53406333231,53406333232,53406333321,53406333323,53406431130,53406431132,53406431310,53406432310,53406432311,53406432312,53406432330,53406433010,53406433011,53406433012,53406433020,53406433021,53406433022,53406433030,53406433100,53406433200,53406501320,53406501321,53406501330,53406502010,53406502011,53406502012,53406502030,53406502032,53406502100,53406502101,53406502110,53406502111,53406502220,53406502222,53406510030,53406510031,53406510032,53406510110,53406510120,53406510200,53406510201,53406510202,53406510210,53406520000,53407310011,53407310100,53407310101,53407310103,53407310121,53407310130,53407310131,53407311000,53407311001,53407311002,53407311010,53407311101,53407311103,53407311121,53407311123,53407311301,53407311303,53407311331,53407311333,53407313111,53407313113,53407401320,53407401321,53407401322,53407402201,53407402203,53407402310,53407402311,53407402312,53407402320,53407402321,53407402322,53407403000,53407403001,53407403002,53407403010,53407403020,53407403022,53407410030,53407410032,53407410100,53407410101,53407410200,53404632133,
051,00,//,503198437,128662500,504717187,129975000,0,6,25,52,128,292,5339573,5339671,5339770,5340502,5340600,5340601,53395703,53395712,53395713,53395721,53395723,53396701,53396703,53396721,53396723,53396730,53396731,53396732,53397613,53397631,53397633,53397720,53405002,53405031,53405032,53405033,53405120,53405122,53406020,54390611,54390623,533957001,533957003,533957013,533957102,533957111,533957113,533957223,533967203,533967221,533967222,533967223,533967330,533967331,533967332,533976113,533976303,533976321,533976323,533977100,533977101,533977102,533977210,533977211,533977220,534050002,534050030,534050032,534050033,534050133,534050302,534050303,534051022,534051023,534051210,534051232,534060210,534060211,534060212,534060220,534060221,534061000,534061001,534061002,543906101,543906103,543906121,543906122,543906123,543906130,543906213,543906300,543916010,5339473323,5339473331,5339473332,5339473333,5339570021,5339570023,5339570113,5339570121,5339570122,5339570123,5339570210,5339570211,5339570213,5339570231,5339570233,5339571002,5339571032,5339571101,5339571103,5339571121,5339571123,5339572011,5339572013,5339572031,5339572033,5339572211,5339572212,5339572213,5339670011,5339670013,5339670031,5339670033,5339670231,5339670233,5339672011,5339672013,5339672201,5339672203,5339673330,5339673331,5339673332,5339761111,5339761113,5339761123,5339761231,5339761233,5339763011,5339763012,5339763013,5339763201,5339763203,5339763220,5339763221,5339763223,5339771030,5339771100,5339771101,5339772120,5339772210,5339772220,5339772222,5339773000,5340402222,5340500000,5340500002,5340500032,5340500312,5340500313,5340501321,5340501322,5340501323,5340503002,5340503003,5340503011,5340503012,5340503013,5340510202,5340510203,5340510212,5340510320,5340510321,5340510322,5340512120,5340512121,5340512122,5340512300,5340512302,5340512332,5340512333,5340513220,5340602130,5340602131,5340602221,5340602230,5340603000,5340603002,5340603011,5340603100,5340603101,5340610030,5340610032,5340610100,5340610101,5340610200,5340610201,5340610202,5340610220,5439061001,5439061003,5439061021,5439061023,5439061201,5439061203,5439061310,5439061320,5439062111,5439062112,5439062113,5439062123,5439063010,5439063020,5439063022,5439070000,5439070002,5439160110,5439160112,5439160120,5439160121,53394722323,53394733221,53394733223,53394733301,53394733303,53395700031,53395700033,53395701033,53395701121,53395701122,53395701123,53395701202,53395701203,53395702011,53395702121,53395702123,53395702301,53395702303,53395702321,53395702323,53395710030,53395710032,53395710033,53395710122,53395710300,53395710302,53395710303,53395710332,53395710333,53395711001,53395711003,53395711222,53395720101,53395720103,53395720121,53395720123,53395720301,53395720303,53395720321,53395720323,53395722101,53395722103,53396633313,53396633331,53396633333,53396700101,53396700103,53396700121,53396700123,53396700301,53396702110,53396702111,53396702113,53396702131,53396702133,53396702303,53396702321,53396702323,53396720101,53396720103,53396720121,53396720122,53396720123,53396720231,53396720232,53396720233,53396722003,53396722021,53396722022,53396722023,53396733330,53397611121,53397611123,53397611212,53397611213,53397611222,53397611223,53397612113,53397612131,53397612133,53397630103,53397630233,53397632023,53397632220,53397632221,53397632223,53397710310,53397710311,53397710312,53397710320,53397710321,53397710322,53397711020,53397711021,53397711022,53397711030,53397711100,53397711101,53397712000,53397712001,53397712002,53397712010,53397712020,53397712022,53397712202,53397712220,53397712222,53397712223,53397721210,53397721211,53397721212,53397721220,53397722110,53397722120,53397722210,53397722212,53397722230,53397722232,53397730020,53397730022,53404022200,53404022202,53404022203,53405000010,53405000012,53405000030,53405000032,53405000033,53405000300,53405000302,53405000332,53405001232,53405003100,53405003102,53405003103,53405003112,53405012022,53405012200,53405012202,53405012220,53405012222,53405012331,53405012333,53405013033,53405013122,53405013123,53405013132,53405013133,53405013202,53405013203,53405030000,53405030002,53405030003,53405030103,53405102003,53405102012,53405102013,53405102100,53405102102,53405102103,53405102132,53405102133,53405103230,53405103232,53405121102,53405121120,53405121122,53405121230,53405121231,53405123030,53405123032,53405123033,53405123122,53405123300,53405123302,53405123303,53405123312,53405123313,53405132022,53405132023,53405132032,53405132210,53405132212,53405132220,53405132221,53406021320,53406021321,53406022200,53406022201,53406022310,53406023000,53406023001,53406023002,53406023010,53406023020,53406030010,53406030011,53406030012,53406030100,53406030101,53406030103,53406030130,53406030131,53406030200,53406030202,53406031020,53406031021,53406031030,53406031100,53406031101,53406100310,53406101020,53406101021,53406101023,53406101030,53406101032,53406101100,53406101101,53406101102,53406101110,53406102030,53406102032,53406102100,53406102210,53406102212,53406102220,53406102221,53406102222,54390603313,54390603331,54390603332,54390603333,54390610001,54390610003,54390610021,54390610023,54390610201,54390610203,54390610221,54390610223,54390612001,54390612003,54390612021,54390612023,54390613110,54390613120,54390613121,54390613210,54390613220,54390613222,54390621033,54390621103,54390621211,54390621213,54390621223,54390630110,54390630111,54390630120,54390630121,54390630122,54390630210,54390630211,54390630212,54390630230,54390632000,54390632001,54390632022,54390632200,54390700010,54390700012,54390700030,54390700200,54390700220,54391600111,54391600113,54391600131,54391600133,54391600311,54391600313,54391601110,54391601111,54391601112,54391601130,54391601220,54391601221,54391601223,54391601230,54391601231,54391601232,54391601300,54391601301,54391601302,
052,00,/Ĥ,503760937,129028125,505434375,130753125,1,16,43,96,258,513,534070,5340612,5340613,5340622,5340710,5340711,5440001,5440003,5440101,5440103,5440201,5440210,5440211,5440213,5440220,5440222,5440223,53397713,53406032,53406033,53406103,53406232,53407120,53407121,53407122,53407131,54400001,54400003,54400021,54400023,54400100,54400122,54401001,54401002,54401003,54401021,54401023,54401100,54401102,54401120,54401122,54401123,54401131,54401133,54401222,54401223,54402001,54402120,54402121,54402123,54402212,54403101,54403103,54403110,54403111,54403112,54403121,54403130,54403200,54403210,533977112,533977113,533977121,533977123,533977301,533977302,533977310,533977311,533977313,533977331,533977333,534060231,534060232,534060233,534060303,534060312,534060313,534061023,534061122,534061123,534061132,534061133,534062300,534062302,534062303,534071230,534071231,534071232,534071300,534071301,534072000,534072011,534072020,534072022,534072100,534072200,534072202,544000000,544000001,544000003,544000203,544000221,544000223,544001010,544001020,544001022,544001200,544001202,544001203,544010001,544010003,544010200,544010201,544010203,544010221,544010223,544011012,544011030,544011032,544011210,544011212,544011322,544011323,544012200,544012202,544012203,544012211,544012212,544012213,544012300,544012301,544012302,544020030,544020031,544020033,544020300,544020301,544020310,544020311,544020313,544021220,544021221,544021223,544022132,544023220,544023222,544031001,544031003,544031130,544031131,544031132,544032010,544032011,544032013,544032110,544032111,5339771033,5339771111,5339771112,5339771113,5339771203,5339771221,5339771223,5339773001,5339773003,5339773030,5339773031,5339773032,5339773120,5339773121,5339773123,5339773301,5339773303,5339773321,5339773323,5340602133,5340602222,5340602223,5340602232,5340602233,5340602303,5340603003,5340603012,5340603021,5340603022,5340603023,5340603111,5340603112,5340603113,5340610033,5340610120,5340610122,5340610123,5340610132,5340610211,5340610212,5340610213,5340610223,5340611202,5340611203,5340611212,5340611213,5340611302,5340611303,5340611310,5340611312,5340611313,5340620220,5340620222,5340620223,5340620331,5340620332,5340620333,5340621220,5340621222,5340621223,5340623010,5340623012,5340623013,5340623120,5340623122,5340623300,5340623301,5340623303,5340623312,5340623313,5340623331,5340632202,5340632220,5340712330,5340712331,5340712332,5340713020,5340713021,5340713022,5340713030,5340713031,5340720010,5340720011,5340720012,5340720020,5340720021,5340720022,5340720131,5340720210,5340720211,5340720212,5340720230,5340720232,5340721010,5340721012,5340721020,5340721021,5340722010,5340722012,5340722200,5439071101,5439071111,5439071113,5439071131,5440000020,5440000021,5440000023,5440000210,5440000211,5440002013,5440002023,5440002201,5440002202,5440002203,5440002221,5440002222,5440002223,5440010110,5440010120,5440010210,5440010211,5440010212,5440010230,5440010232,5440012010,5440012012,5440012013,5440012120,5440012122,5440012123,5440012132,5440012300,5440012301,5440012302,5440012310,5440012322,5440100000,5440100001,5440100003,5440100021,5440100022,5440100023,5440102021,5440102023,5440102201,5440102202,5440102203,5440102221,5440102223,5440110130,5440110132,5440110310,5440110312,5440110313,5440110330,5440110331,5440110332,5440111322,5440111323,5440111332,5440111333,5440112110,5440112112,5440112130,5440112132,5440112133,5440113011,5440113013,5440113031,5440113033,5440113200,5440113202,5440113203,5440113211,5440113212,5440113213,5440120220,5440120222,5440120223,5440121232,5440122012,5440122013,5440122101,5440122102,5440122103,5440123030,5440123031,5440123032,5440123200,5440200001,5440200010,5440200011,5440200013,5440200031,5440200033,5440200211,5440202110,5440202113,5440202131,5440202133,5440202311,5440203020,5440203021,5440203030,5440203031,5440203120,5440203121,5440203123,5440203311,5440212221,5440212223,5440221000,5440221002,5440221022,5440221023,5440221032,5440221033,5440221122,5440221300,5440221302,5440221332,5440232002,5440232020,5440232022,5440232023,5440232232,5440310001,5440310003,5440310021,5440310211,5440310213,5440311330,5440312011,5440312013,5440312031,5440312301,5440312310,5440312311,5440313100,5440313102,5440313120,5440313200,5440313201,5440313210,5440320120,5440320121,5440320122,5440320200,5440320202,5440321120,5440321121,5440321123,5440321130,5440321200,5440321201,5440330000,5440330001,5440330002,53396733331,53396733332,53396733333,53397710313,53397710323,53397711023,53397711031,53397711032,53397711033,53397711102,53397711103,53397712003,53397712011,53397712012,53397712013,53397712021,53397712023,53397712200,53397712201,53397712203,53397712221,53397721311,53397721313,53397721331,53397730021,53397730023,53397730330,53397730331,53397731220,53397731221,53397731223,53397733001,53397733003,53397733021,53397733023,53397733201,53397733203,53397733221,53397733223,53406021322,53406021323,53406022202,53406022203,53406022311,53406022312,53406022313,53406023003,53406023011,53406023012,53406023013,53406023021,53406023022,53406023023,53406030013,53406030102,53406030132,53406030133,53406030201,53406030203,53406031022,53406031023,53406031031,53406031032,53406031033,53406031102,53406031103,53406100311,53406100312,53406100313,53406101022,53406101210,53406101212,53406101213,53406101302,53406101330,53406101332,53406101333,53406102031,53406102033,53406102101,53406102102,53406102103,53406102211,53406102213,53406102223,53406112000,53406112002,53406112003,53406112012,53406112013,53406113012,53406113013,53406113112,53406113113,53406202020,53406202022,53406202023,53406202210,53406202212,53406202213,53406202320,53406202322,53406202323,53406202332,53406203231,53406203232,53406203233,53406203303,53406212023,53406212210,53406212212,53406212213,53406212302,53406212320,53406212322,53406212323,53406230110,53406230112,53406230113,53406231020,53406231022,53406231023,53406231232,53406233020,53406233021,53406233022,53406233102,53406233103,53406233112,53406233200,53406233202,53406233203,53406233212,53406233220,53406233221,53406233222,53406233230,53406233301,53406233303,53406233330,53406233331,53406233333,53406322220,53406322222,53407123330,53407123331,53407123332,53407130230,53407130231,53407130232,53407130331,53407130333,53407132000,53407132001,53407132002,53407132111,53407133000,53407133001,53407133010,53407133100,53407133101,53407133110,53407133111,53407133113,53407200230,53407200232,53407200233,53407200300,53407200322,53407200323,53407200332,53407201000,53407201001,53407201010,53407201011,53407201013,53407201301,53407201331,53407202130,53407202131,53407202132,53407202310,53407202312,53407210110,53407210111,53407210112,53407210130,53407210132,53407210220,53407210221,53407210230,53407210231,53407210300,53407210301,53407220300,53407220301,53407220302,53407220320,53407222010,53407222012,54390711001,54390711100,54390711101,54390711102,54390711331,54390733333,54391711111,54391711113,54391711333,54391713111,54391713331,54391713333,54391731111,54391731113,54391731131,54391731133,54400000220,54400000221,54400000223,54400002010,54400002011,54400002013,54400002121,54400002130,54400002131,54400002133,54400002311,54400002313,54400002331,54400002333,54400020111,54400020112,54400020113,54400020121,54400020123,54400020212,54400020213,54400022200,54400022201,54400022203,54400101110,54400101120,54400101210,54400101220,54400101222,54400103000,54400120110,54400120112,54400120113,54400121020,54400121022,54400121023,54400121212,54400121213,54400121302,54400123030,54400123031,54400123032,54400123200,54400123202,54401000020,54401000021,54401000023,54401000202,54401000203,54401020200,54401020201,54401020203,54401020221,54401020223,54401022001,54401022002,54401022003,54401022201,54401101000,54401101001,54401101002,54401101022,54401101023,54401101122,54401101123,54401101332,54401103110,54401103112,54401103113,54401103330,54401103332,54401112022,54401112200,54401112202,54401112323,54401112331,54401112332,54401112333,54401113203,54401113212,54401113213,54401113302,54401113303,54401113312,54401113313,54401121110,54401121112,54401121130,54401121132,54401121310,54401121312,54401130101,54401130103,54401130121,54401130123,54401130222,54401130223,54401130301,54401130303,54401202210,54401202212,54401202322,54401203333,54401212222,54401212223,54401212232,54401212233,54401212332,54401212333,54401213222,54401220100,54401220102,54401220103,54401220112,54401220113,54401221001,54401221002,54401221003,54401230330,54401231000,54401231002,54401231003,54401231020,54401231021,54401231022,54401231200,54401232010,54401232011,54401232012,54401232020,54401232021,54401232022,54401232100,54401232101,54401232200,54401232202,54401232220,54401232222,54402000120,54402000121,54402000123,54402000301,54402000303,54402000321,54402000323,54402002101,54402002103,54402002131,54402003210,54402003211,54402003233,54402021011,54402021013,54402021110,54402021111,54402021113,54402021303,54402021321,54402021323,54402023101,54402030220,54402030221,54402030222,54402030230,54402030231,54402030320,54402030321,54402030323,54402030330,54402030331,54402030332,54402031220,54402031221,54402031223,54402032000,54402032002,54402033001,54402033010,54402033011,54402033100,54402033101,54402033130,54402033131,54402033133,54402122200,54402122201,54402122221,54402122223,54402210010,54402210012,54402210030,54402210032,54402210200,54402210202,54402210203,54402210212,54402210213,54402210302,54402210303,54402210312,54402210313,54402211202,54402211203,54402213300,54402213302,54402213303,54402213332,54402320000,54402320002,54402320210,54402320212,54402320322,54402322100,54402322102,54402322120,54402322122,54402322302,54403100001,54403100230,54403100231,54403102100,54403102101,54403102103,54403102121,54403102310,54403102311,54403102313,54403102323,54403102331,54403102332,54403102333,54403113310,54403113311,54403113320,54403113321,54403113322,54403120101,54403120103,54403120121,54403120123,54403120301,54403120303,54403120330,54403120331,54403120333,54403122111,54403123000,54403123001,54403123031,54403123120,54403123121,54403123130,54403123131,54403131010,54403131011,54403131012,54403131030,54403131032,54403131210,54403131220,54403131222,54403132020,54403132031,54403132110,54403132111,54403132112,54403132120,54403132121,54403133000,54403201230,54403201231,54403201232,54403202010,54403202011,54403202012,54403202030,54403202200,54403203101,54403203110,54403203111,54403203113,54403203131,54403211220,54403211221,54403211223,54403211310,54403211311,54403211312,54403211320,54403211322,54403212020,54403212021,54403212100,54403300030,54403300100,54403300101,54403300200,
053,00,Ų,502875000,129487500,504140625,130912500,1,10,29,56,146,352,543927,5439072,5439161,5439162,5439163,5439170,5439172,5439261,5439370,5439371,5439373,53397723,53397732,54390631,54390633,54390701,54390702,54390703,54390710,54390712,54390713,54390730,54390731,54390732,54391531,54391533,54391602,54391603,54391710,54391712,54391730,54391732,54391733,54392511,54392600,54392601,54392603,54392630,54392631,54392633,533977223,543906133,543906303,543906321,543906323,543907001,543907003,543907112,543907330,543907331,543907332,543915111,543915113,543915131,543915132,543915133,543915321,543915323,543916000,543916002,543917110,543917112,543917130,543917132,543917310,543917312,543917313,543925101,543925103,543925131,543926020,543926021,543926023,543926210,543926211,543936110,543936111,543936113,543936131,543936133,543936311,543937200,543937211,543937213,543937231,543947101,543947110,543947111,543947113,544000022,544000200,544020002,544020020,544030022,544030200,544030202,5339772123,5339772130,5339772132,5339772213,5439061313,5439061323,5439062223,5439062232,5439063013,5439063201,5439063203,5439063221,5439063222,5439063223,5439070021,5439070023,5439071102,5439071103,5439071112,5439071130,5439071132,5439073330,5439073331,5439073332,5439151101,5439151103,5439151121,5439151123,5439151301,5439151303,5439153011,5439153013,5439153031,5439153032,5439153033,5439153201,5439153203,5439153221,5439153223,5439160010,5439160012,5439160030,5439160032,5439160033,5439160131,5439160132,5439160133,5439171110,5439171112,5439171113,5439171130,5439171131,5439171132,5439171310,5439171312,5439171313,5439171330,5439171331,5439171332,5439173110,5439173112,5439251001,5439251003,5439251021,5439251023,5439251200,5439251201,5439251203,5439251210,5439251211,5439251213,5439251300,5439251301,5439251302,5439260220,5439260221,5439260223,5439262010,5439262011,5439262130,5439262131,5439263210,5439263211,5439263213,5439263231,5439263233,5439361011,5439361013,5439361120,5439361121,5439361123,5439361301,5439361303,5439361321,5439361323,5439363101,5439363103,5439363131,5439372330,5439372331,5439372333,5439471000,5439471001,5439471121,5439471123,5439471301,5439471303,5439471310,5439471311,5440000200,5440000202,5440000203,5440000230,5440000232,5440002010,5440002020,5440002022,5440002200,5440102222,5440200000,5440200002,5440200003,5440200212,5440200220,5440200221,5440200222,5440200230,5440200231,5440202000,5440202002,5440202020,5440300202,5440300230,5440300232,5440302010,5440302011,5440302012,5440302200,5440302202,5440302220,5440302222,5440400000,5440400002,5440400020,5440400022,5440400200,53397721213,53397721221,53397721222,53397721223,53397721310,53397721312,53397721330,53397721332,53397721333,53397722111,53397722112,53397722113,53397722121,53397722122,53397722123,53397722211,53397722213,53397722231,53397722233,53397730332,53397730333,53397731222,53397733000,53397733002,53397733020,53397733022,53397733200,53397733202,53397733220,53397733222,54390533232,54390533233,54390533322,54390533323,54390533332,54390533333,54390613111,54390613112,54390613113,54390613122,54390613123,54390613211,54390613212,54390613213,54390613221,54390613223,54390622212,54390622213,54390622221,54390622222,54390622223,54390622302,54390622303,54390622312,54390622330,54390622332,54390630112,54390630113,54390630123,54390630213,54390630231,54390630232,54390630233,54390632002,54390632003,54390632020,54390632021,54390632023,54390632201,54390632202,54390632203,54390700011,54390700013,54390700031,54390700032,54390700033,54390700201,54390700202,54390700203,54390700221,54390700222,54390700223,54390711000,54390711002,54390711003,54390711103,54390711330,54390711332,54390711333,54390733330,54390733331,54390733332,54391512332,54391512333,54391513023,54391530121,54391530123,54391530301,54391530302,54391530303,54391532223,54391600110,54391600112,54391600130,54391600132,54391600310,54391600312,54391601113,54391601131,54391601132,54391601133,54391601222,54391601233,54391601303,54391711110,54391711112,54391711330,54391711331,54391711332,54391713110,54391713112,54391713113,54391713330,54391713332,54391731110,54391731112,54391731130,54391731132,54392510001,54392510003,54392510021,54392510023,54392510201,54392510203,54392510221,54392510223,54392512120,54392512121,54392512122,54392512311,54392512313,54392512331,54392513030,54392513031,54392513200,54392513201,54392513202,54392513310,54392513311,54392513313,54392602221,54392620011,54392620130,54392620131,54392620133,54392621201,54392621210,54392621211,54392621213,54392621320,54392621321,54392621330,54392621331,54392632010,54392632011,54392632013,54392632120,54392632121,54392632123,54392632301,54393610311,54393610313,54393611220,54393611221,54393611223,54393613001,54393613003,54393613021,54393613023,54393613201,54393613202,54393613203,54393613220,54393613221,54393613223,54393631001,54393631003,54393631021,54393631211,54393631300,54393631301,54393631330,54393631331,54393720100,54393720101,54393720102,54393720110,54393720120,54393720122,54393720200,54393720201,54393720202,54393720210,54393720211,54393720220,54393720300,54393721010,54393721011,54393721013,54393721031,54393721033,54393721233,54393723011,54393723013,54393723031,54393723033,54393723211,54393723213,54393723231,54393723320,54393723321,54393723323,54394701110,54394701111,54394710021,54394710030,54394710031,54394710033,54394710311,54394711200,54394711201,54394711203,54394711220,54394711221,54394711223,54394713001,54394713003,54394713021,54394713023,54394713120,54394713121,54394713130,54394713131,54400000222,54400002012,54400002120,54400002122,54400002123,54400002132,54400002310,54400002312,54400002330,54400002332,54400020110,54400020120,54400020122,54400020210,54400020211,54400022202,54401000022,54401000200,54401000201,54401020202,54401020220,54401020222,54401022000,54401022200,54401022202,54401022203,54402000122,54402000300,54402000302,54402000320,54402000322,54402002100,54402002102,54402002130,54402002132,54402002133,54402002230,54402002231,54402002232,54402002320,54402002321,54402002323,54402002330,54402002331,54402002332,54402003200,54402003201,54402003202,54402020010,54402020012,54402020030,54402020032,54402020210,54402020220,54402020222,54402022000,54402022002,54402022020,54402022022,54402022200,54402022202,54402022220,54402022222,54403000000,54403000002,54403000020,54403000022,54403000200,54403000202,54403000220,54403000222,54403002000,54403002002,54403002003,54403002030,54403002032,54403002033,54403002122,54403002330,54403002332,54403002333,54403020130,54403020300,54403020301,54403020302,54403020320,54403020322,54403022010,54403022011,54403022012,54403022030,54403022032,54403022210,54403022212,54403022230,54403022232,54404000010,54404000012,54404000030,54404000032,54404000210,54404000212,54404000230,54404000232,54404002010,54404002012,54404002020,54404002021,54404002030,
054,00,ڱ,504534375,128653125,507065625,130453125,3,16,38,95,237,545,544002,544003,544013,5340723,5340730,5340732,5340733,5340742,5340743,5340750,5440011,5440013,5440040,5440041,5440042,5440140,5440142,5440230,5440231,53405620,53406503,53406511,53406512,53406513,53406521,53406522,53406523,53406530,53406532,53407203,53407211,53407212,53407213,53407221,53407223,53407312,53407411,53407412,53407413,53407520,53407522,54400430,54400431,54400432,54401110,54401111,54401200,54401201,54401210,54401211,54401233,54401410,54401412,54401430,54402330,54402400,54402402,534046323,534055313,534055331,534055333,534056013,534056023,534056030,534056031,534056032,534056100,534056210,534056220,534056221,534056222,534064333,534065023,534065103,534065201,534065202,534065203,534065310,534065312,534066000,534071322,534071323,534071332,534071333,534072012,534072221,534072222,534072223,534073102,534073103,534073112,534073130,534073132,534073133,534074031,534074032,534074033,534074103,534075100,534075102,534075210,534075211,534075212,544001013,544001031,544001032,544001033,544001211,544001233,544004330,544004331,544004332,544005000,544005001,544005002,544005020,544005022,544011121,544011130,544011131,544011300,544012020,544012021,544012030,544012031,544012032,544012120,544012121,544012130,544012131,544012133,544012311,544012313,544012323,544014110,544014112,544014320,544014322,544022101,544022110,544022111,544022113,544022131,544023201,544023210,544023211,544023213,544023310,544024010,544024011,544024100,544024200,5340463222,5340463223,5340463320,5340553111,5340553112,5340553113,5340553301,5340553303,5340553321,5340553323,5340560111,5340560112,5340560113,5340560121,5340560122,5340560123,5340560203,5340560211,5340560212,5340560213,5340560221,5340560222,5340560223,5340560330,5340560331,5340560332,5340561010,5340561020,5340561021,5340561022,5340562120,5340562122,5340562230,5340562232,5340623332,5340632221,5340632223,5340632232,5340632233,5340632322,5340632323,5340632332,5340632333,5340643133,5340643311,5340643312,5340643313,5340643321,5340643322,5340643323,5340650212,5340650213,5340650221,5340650223,5340651013,5340651022,5340651023,5340652001,5340652002,5340652003,5340653110,5340653112,5340653300,5340653302,5340660020,5340660022,5340713032,5340713201,5340713202,5340713203,5340713210,5340713212,5340713213,5340713302,5340713303,5340713312,5340713313,5340720013,5340720031,5340720102,5340720103,5340720132,5340720233,5340721031,5340721032,5340721033,5340722011,5340722013,5340722031,5340722033,5340722202,5340722203,5340731000,5340731002,5340731003,5340731102,5340731103,5340731132,5340731310,5340731312,5340731313,5340740133,5340740222,5340740233,5340740303,5340741011,5340741012,5340741013,5340741021,5340741022,5340741023,5340751010,5340751011,5340751013,5340751031,5340751032,5340751033,5340751200,5340751201,5340751202,5340751211,5340751213,5340751220,5340751222,5340751231,5340752300,5340752302,5340752320,5440010113,5440010123,5440010213,5440010231,5440010233,5440010301,5440010302,5440010303,5440012100,5440012101,5440012103,5440012131,5440012133,5440012311,5440012312,5440012313,5440012321,5440012323,5440043330,5440043332,5440050030,5440050031,5440050032,5440050210,5440052000,5440052002,5440052020,5440110101,5440110103,5440110110,5440110111,5440110113,5440110131,5440111200,5440111201,5440111203,5440111221,5440111222,5440111223,5440111230,5440111231,5440113020,5440113021,5440113023,5440113032,5440113201,5440113210,5440120230,5440120231,5440120233,5440120330,5440120331,5440120332,5440121220,5440121221,5440121230,5440121231,5440121320,5440121321,5440121323,5440123101,5440123103,5440123121,5440123122,5440123123,5440123203,5440123211,5440123212,5440123213,5440123221,5440123223,5440141110,5440141300,5440141302,5440141320,5440143210,5440143212,5440143230,5440143232,5440221121,5440221123,5440221301,5440221303,5440221331,5440232001,5440232003,5440232030,5440232031,5440232033,5440232120,5440232121,5440232211,5440233110,5440233111,5440233120,5440233122,5440233200,5440233210,5440233211,5440233300,5440240130,5440240131,5440240300,5440240302,5440240303,5440240320,5440241020,5440241021,5440242010,53404623333,53404632122,53404632123,53404632132,53404632203,53404632211,53404632212,53404632213,53404633220,53404633222,53405513331,53405513332,53405513333,53405531031,53405531033,53405531102,53405531103,53405531211,53405531213,53405531231,53405531233,53405533021,53405533023,53405533201,53405533203,53405533221,53405533222,53405533223,53405600331,53405600332,53405600333,53405601031,53405601033,53405601102,53405601103,53405601201,53405601203,53405602013,53405602023,53405602102,53405602103,53405602201,53405602202,53405602203,53405603330,53405610110,53405610120,53405610121,53405610122,53405610230,53405610232,53405612000,53405612001,53405612002,53405612010,53405612020,53405612022,53405621100,53405621101,53405621102,53405621120,53405621210,53405621211,53405621212,53405621230,53405621232,53405622310,53405622311,53405622312,53405622330,53405623000,53405623001,53405623002,53405623020,53405623022,53406233023,53406233201,53406233210,53406233211,53406233213,53406233223,53406233231,53406233232,53406233233,53406233300,53406233302,53406233332,53406322032,53406322221,53406322223,53406322300,53406322302,53406322303,53406322312,53406322313,53406323202,53406323203,53406323211,53406323212,53406323213,53406323300,53406323302,53406323303,53406323312,53406332220,53406332222,53406332223,53406332232,53406333233,53406333320,53406333322,53406431131,53406431133,53406431311,53406431312,53406431313,53406432313,53406432331,53406432332,53406432333,53406433013,53406433023,53406433031,53406433032,53406433033,53406433101,53406433102,53406433103,53406433201,53406433202,53406433203,53406501322,53406501323,53406501331,53406501332,53406501333,53406502013,53406502031,53406502033,53406502102,53406502103,53406502112,53406502113,53406502221,53406502223,53406510033,53406510111,53406510112,53406510113,53406510121,53406510122,53406510123,53406510203,53406510211,53406510212,53406510213,53406520001,53406520002,53406520003,53406531110,53406531300,53406531302,53406533010,53406533012,53406533200,53406533202,53406533220,53406600100,53406600101,53406600102,53406600120,53406600210,53406600211,53406600212,53406600230,53406600232,53406602000,53406602001,53406602002,53406602020,53406602022,53407123333,53407130233,53407130330,53407130332,53407132003,53407132110,53407132112,53407132113,53407133002,53407133003,53407133011,53407133012,53407133013,53407133102,53407133103,53407133112,53407200231,53407200301,53407200302,53407200303,53407200320,53407200321,53407200330,53407200331,53407200333,53407201002,53407201003,53407201012,53407201300,53407201302,53407201303,53407201330,53407201332,53407201333,53407202133,53407202311,53407202313,53407210113,53407210131,53407210133,53407210222,53407210223,53407210232,53407210233,53407210302,53407210303,53407220303,53407220321,53407220322,53407220323,53407222011,53407222013,53407310010,53407310012,53407310013,53407310102,53407310120,53407310122,53407310123,53407310132,53407310133,53407311003,53407311011,53407311012,53407311013,53407311100,53407311102,53407311120,53407311122,53407311300,53407311302,53407311330,53407311332,53407313110,53407313112,53407401323,53407402200,53407402202,53407402313,53407402323,53407403003,53407403011,53407403012,53407403013,53407403021,53407403023,53407410031,53407410033,53407410102,53407410103,53407410201,53407410202,53407410203,53407510120,53407510121,53407510122,53407512030,53407512031,53407512032,53407512100,53407512101,53407512210,53407512212,53407512230,53407513200,53407513202,53407521300,53407521301,53407521302,53407521310,53407521311,53407521320,53407523010,53407523011,53407523012,53407523030,53407523032,53407523210,53407523220,53407523221,53407523222,53407530000,53407530001,53407530002,53407530020,53407530022,54400101111,54400101112,54400101113,54400101121,54400101122,54400101123,54400101211,54400101212,54400101213,54400101221,54400101223,54400103001,54400103002,54400103003,54400120111,54400121021,54400121210,54400121211,54400121300,54400121301,54400121303,54400123033,54400123201,54400123203,54400433310,54400433312,54400433330,54400500330,54400500332,54400501000,54400501002,54400501020,54400502120,54400502121,54400502122,54400502300,54400520010,54400520012,54400520030,54400520220,54400520222,54400522000,54400522002,54401101003,54401101020,54401101021,54401101120,54401101121,54401101330,54401101331,54401101333,54401103111,54401103331,54401103333,54401112020,54401112021,54401112023,54401112201,54401112203,54401112320,54401112321,54401112322,54401112330,54401113200,54401113201,54401113202,54401113210,54401113211,54401113300,54401113301,54401113310,54401113311,54401121111,54401121113,54401121131,54401121133,54401121311,54401121313,54401130100,54401130102,54401130120,54401130122,54401130220,54401130221,54401130300,54401130302,54401202211,54401202213,54401202320,54401202321,54401202323,54401203330,54401203331,54401203332,54401212220,54401212221,54401212230,54401212231,54401212330,54401212331,54401213220,54401213221,54401213223,54401220101,54401220110,54401220111,54401221000,54401230331,54401230332,54401230333,54401231001,54401231023,54401231201,54401231202,54401231203,54401232013,54401232023,54401232102,54401232103,54401232201,54401232203,54401232221,54401232223,54401411120,54401411121,54401411122,54401411300,54401413010,54401413012,54401413030,54401413032,54401413210,54401413220,54401413221,54401413222,54401431000,54401431002,54401431020,54401431022,54401431200,54401432110,54401432112,54401432130,54402210011,54402210013,54402210031,54402210033,54402210201,54402210210,54402210211,54402210300,54402210301,54402210310,54402210311,54402211200,54402211201,54402213301,54402213330,54402213331,54402213333,54402320001,54402320003,54402320211,54402320213,54402320320,54402320321,54402320323,54402321220,54402321221,54402321222,54402321231,54402322101,54402322103,54402322121,54402323000,54402323100,54402323101,54402323111,54402331120,54402331131,54402331133,54402331210,54402331212,54402331230,54402331232,54402331311,54402332010,54402332011,54402332012,54402332020,54402332021,54402332030,54402332120,54402332121,54402332131,54402333010,54402333012,54402333020,54402333021,54402333030,54402401200,54402401201,54402401202,54402401210,54402401211,54402401213,54402401220,54402401222,54402401223,54402401320,54402401321,54402403010,54402403012,54402403210,54402403211,54402403212,54402403220,54402403221,54402403222,54402410100,54402410101,54402410102,54402410120,54402410122,54402410230,54402410231,54402410300,54402420120,54402420121,54402420200,54402420201,54402420210,53404633221,53407530021,53407530030,53407530013,53407530012,53407530031,
055,00,,504014062,130246875,506179687,131503125,1,14,29,106,204,485,544042,5440301,5440303,5440322,5440323,5440331,5440332,5440333,5440340,5440342,5440410,5440411,5440430,5440431,5440432,54402421,54402422,54402423,54403001,54403003,54403021,54403023,54403213,54403301,54403302,54403303,54403432,54404001,54404010,54404011,54404013,54404131,54404133,54404330,54404400,54404401,54405111,54405113,54405200,54405201,54405202,54405220,54405222,54405301,544020201,544020203,544020212,544020221,544020223,544020230,544020232,544020233,544020321,544020322,544020323,544020332,544020333,544023232,544023233,544023322,544023323,544023331,544023332,544023333,544024031,544024033,544024203,544030001,544030003,544030221,544030223,544031020,544031022,544031200,544031202,544031220,544031222,544031223,544031232,544031233,544031311,544031313,544031322,544031323,544031331,544031332,544031333,544032021,544032023,544032030,544032032,544032033,544032122,544032123,544033003,544034302,544040001,544040003,544040021,544040030,544040031,544040120,544040121,544040123,544040301,544040310,544040311,544041200,544041201,544041202,544041210,544041211,544041220,544041300,544041301,544041303,544041321,544043310,544043312,544043320,544043321,544043322,544044020,544044021,544044022,544044100,544051311,544051313,544052030,544052100,544052101,544052102,544052110,544052111,544052210,544052212,544052230,544052232,544053000,544053001,544053003,544053023,544053030,544053031,544053100,544053102,544053120,544062001,544062003,544062012,5440200322,5440202023,5440202100,5440202102,5440202103,5440202112,5440202201,5440202203,5440202221,5440202223,5440202312,5440202313,5440203201,5440203202,5440203203,5440203302,5440203303,5440203312,5440232213,5440232231,5440232233,5440232301,5440232302,5440232303,5440232312,5440232313,5440233130,5440233132,5440233133,5440240123,5440240133,5440240323,5440241022,5440241200,5440241202,5440241220,5440241222,5440242011,5440242013,5440242022,5440242023,5440243000,5440243002,5440243020,5440243022,5440300001,5440300003,5440300021,5440300023,5440300201,5440300210,5440300211,5440300213,5440300231,5440302031,5440302033,5440310002,5440310020,5440310022,5440310230,5440311333,5440312032,5440312210,5440312212,5440312213,5440312302,5440313123,5440313213,5440313301,5440313302,5440313303,5440320221,5440320222,5440320223,5440320312,5440321133,5440321203,5440321211,5440321212,5440321213,5440330011,5440330012,5440330013,5440330021,5440330022,5440330023,5440343000,5440343002,5440343032,5440343033,5440343300,5440343302,5440343320,5440343322,5440400231,5440400320,5440400321,5440400330,5440400331,5440401220,5440401221,5440401223,5440403030,5440403031,5440403120,5440403130,5440403131,5440403133,5440403311,5440412030,5440412031,5440412032,5440412120,5440412121,5440412130,5440412131,5440412210,5440413020,5440413021,5440413023,5440413230,5440413231,5440413233,5440433110,5440433111,5440433112,5440433130,5440433132,5440433230,5440433231,5440433232,5440433300,5440433301,5440433310,5440440230,5440440300,5440440301,5440440302,5440440310,5440441010,5440441012,5440441020,5440442000,5440511011,5440511013,5440511031,5440511033,5440511211,5440511213,5440513101,5440513103,5440513121,5440513310,5440513311,5440513313,5440513331,5440520310,5440520311,5440520312,5440520320,5440520322,5440520323,5440520332,5440521030,5440521032,5440521120,5440521121,5440521130,5440521131,5440522110,5440522112,5440522130,5440522132,5440522133,5440522310,5440522312,5440522330,5440522332,5440530020,5440530021,5440530023,5440530211,5440530212,5440530213,5440530223,5440530320,5440530321,5440530323,5440530330,5440531010,5440531012,5440531013,5440531030,5440531032,5440531210,5440531212,5440532001,5440532010,5440620001,5440620003,5440620100,5440620102,5440620103,5440620210,54402002233,54402002322,54402002333,54402003203,54402003212,54402003213,54402003230,54402003231,54402003232,54402020011,54402020013,54402020031,54402020033,54402020211,54402020212,54402020213,54402020221,54402020223,54402021010,54402021012,54402021112,54402021300,54402021301,54402021302,54402021320,54402021322,54402022001,54402022003,54402022021,54402022023,54402022201,54402022203,54402022221,54402022223,54402023100,54402023102,54402023103,54402030223,54402030232,54402030233,54402030322,54402030333,54402031222,54402032001,54402032003,54402033000,54402033002,54402033003,54402033012,54402033013,54402033102,54402033103,54402033132,54402122202,54402122203,54402122220,54402122222,54402321223,54402321230,54402321232,54402321233,54402322123,54402322300,54402322301,54402322303,54402323001,54402323002,54402323003,54402323102,54402323103,54402323110,54402323112,54402323113,54402331121,54402331122,54402331123,54402331130,54402331132,54402331211,54402331213,54402331231,54402331233,54402331310,54402331312,54402331313,54402332013,54402332022,54402332023,54402332031,54402332032,54402332033,54402332122,54402332123,54402332130,54402332132,54402332133,54402333011,54402333013,54402333022,54402333023,54402333031,54402333032,54402333033,54402401203,54402401212,54402401221,54402401322,54402401323,54402403011,54402403013,54402403213,54402403223,54402410232,54402410233,54402412010,54402412011,54402412012,54402412030,54402412032,54402412210,54402412212,54402412230,54402412232,54402420122,54402420123,54402420202,54402420203,54402420211,54402420212,54402420213,54402430010,54402430012,54402432000,54402432001,54402432002,54402432020,54402432022,54402432200,54402432202,54402432220,54402432222,54403000001,54403000003,54403000021,54403000023,54403000201,54403000203,54403000221,54403000223,54403002001,54403002031,54403002120,54403002121,54403002123,54403002331,54403020131,54403020132,54403020133,54403020303,54403020321,54403020323,54403022013,54403022031,54403022033,54403022211,54403022213,54403022231,54403022233,54403100000,54403100002,54403100003,54403100232,54403100233,54403102102,54403102120,54403102122,54403102123,54403102312,54403102320,54403102321,54403102322,54403102330,54403113312,54403113313,54403113323,54403120100,54403120102,54403120120,54403120122,54403120300,54403120302,54403120332,54403122110,54403122112,54403122113,54403123002,54403123003,54403123030,54403123032,54403123033,54403123122,54403123123,54403123132,54403123133,54403131013,54403131031,54403131033,54403131211,54403131212,54403131213,54403131221,54403131223,54403132021,54403132022,54403132023,54403132030,54403132032,54403132033,54403132113,54403132122,54403132123,54403133001,54403133002,54403133003,54403201233,54403202013,54403202031,54403202032,54403202033,54403202201,54403202202,54403202203,54403203100,54403203102,54403203103,54403203112,54403203130,54403203132,54403203133,54403211222,54403211313,54403211321,54403211323,54403212022,54403212023,54403212101,54403212102,54403212103,54403300031,54403300032,54403300033,54403300102,54403300103,54403300201,54403300202,54403300203,54403410000,54403410002,54403410020,54403410022,54403410200,54403410202,54403410220,54403410222,54403412000,54403412002,54403412020,54403412022,54403412200,54403412202,54403412220,54403412222,54403412223,54403430012,54403430030,54403430032,54403430300,54403430302,54403430303,54403430312,54403430313,54403431202,54403431220,54403431222,54403433232,54404000011,54404000013,54404000031,54404000033,54404000211,54404000213,54404000231,54404000233,54404002011,54404002013,54404002031,54404002033,54404002211,54404002300,54404002301,54404002303,54404003221,54404003330,54404003331,54404012220,54404012221,54404012223,54404030010,54404030011,54404030013,54404030031,54404030033,54404030211,54404030213,54404030231,54404030233,54404030320,54404030321,54404030322,54404030330,54404030331,54404031210,54404031211,54404031213,54404031220,54404031221,54404032100,54404033130,54404033131,54404033133,54404120330,54404120331,54404120332,54404121220,54404121221,54404121230,54404121231,54404121320,54404121321,54404121330,54404121331,54404122110,54404122120,54404122121,54404122122,54404122201,54404122210,54404130220,54404130221,54404130223,54404132010,54404132011,54404132013,54404132031,54404132321,54404331332,54404332330,54404332331,54404332332,54404333020,54404333021,54404333022,54404333031,54404333110,54404333120,54404333200,54404333202,54404402310,54404402311,54404402312,54404402320,54404402321,54404402322,54404403030,54404403031,54404403032,54404403110,54404403111,54404403112,54404403120,54404403121,54404410110,54404410111,54404410112,54404410210,54404410211,54404410212,54404410220,54404410221,54404410222,54404411000,54404411001,54404411010,54404412000,54404420010,54404420011,54404420012,54405112310,54405112311,54405112313,54405112331,54405112333,54405131000,54405131001,54405131003,54405131021,54405131023,54405131201,54405131203,54405131221,54405131230,54405131231,54405131233,54405133121,54405133123,54405133301,54405133303,54405133321,54405133330,54405133331,54405203210,54405203212,54405210310,54405210311,54405210312,54405211330,54405211331,54405212000,54405212001,54405212002,54405212010,54405212011,54405212100,54405221310,54405221312,54405221313,54405223110,54405223111,54405300220,54405302031,54405302033,54405302101,54405302103,54405302211,54405302212,54405302213,54405303220,54405303221,54405303223,54405303311,54405303320,54405303322,54405310112,54405310113,54405310310,54405310312,54405310330,54405312200,54405312201,54405312210,54405312211,54405312300,54405320110,54405321001,54405321010,54405321011,54406200001,54406200003,54406200021,54406200023,54406201010,54406201011,54406201012,54406202011,54406202110,54406202111,54406202112,54406202120,54406202121,54406203000,54406203001,54406203010,54403430122,54403430120,54403430121,
056,00,Ω,504829687,130800000,506925000,132975000,6,24,52,121,253,511,544063,544064,544073,544074,554003,554004,5440523,5440533,5440540,5440542,5440621,5440623,5440721,5440722,5440723,5440752,5540021,5540023,5540050,5540052,5540121,5540123,5540130,5540140,5540141,5540143,5540150,5540152,5540153,5540250,54404413,54404421,54404422,54404423,54404430,54404432,54405213,54405311,54405313,54405322,54405323,54405410,54405412,54405430,54405432,54405433,54406221,54406223,54406522,54407201,54407203,54407500,54407502,54407503,55400200,55400201,55400510,55400512,55400530,55400532,55401201,55401203,55401221,55401223,55401310,55401311,55401320,55401421,55401423,55401510,55401512,55401513,55402201,55402203,55402210,55402212,55402221,55402410,55402411,55402510,55402511,55402600,544043333,544044032,544044033,544044103,544044112,544044121,544044122,544044123,544044201,544044202,544044203,544044310,544044311,544044312,544044330,544044332,544052122,544052123,544053202,544053203,544053211,544053212,544053213,544054110,544054112,544054130,544054132,544054310,544054312,544062011,544062013,544062023,544062031,544062032,544062033,544062201,544062203,544062221,544062223,544065002,544065020,544065022,544065200,544065202,544065203,544072001,544072003,544072021,544072023,544075010,544075012,544075320,544075322,544075323,554001113,554002030,554002031,554002213,554002231,554002232,554002233,554005312,554005330,554005332,554012021,554013120,554013121,554013122,554013130,554013131,554013133,554013210,554013211,554013212,554013220,554013221,554014200,554014201,554014203,554015110,554015112,554015113,554016200,554016202,554016220,554016222,554016223,554016232,554016233,554022003,554022021,554022023,554022110,554022111,554022112,554022130,554022132,554022201,554022203,554022221,554022223,554022230,554022231,554022232,554024011,554024130,554024131,554024133,554024311,554024312,554024313,554024330,554025120,554025121,554025122,554025130,554025131,554025200,554025201,554025210,554026010,5440433113,5440433131,5440433313,5440433321,5440433322,5440433323,5440440233,5440440313,5440441013,5440441023,5440441102,5440441103,5440441130,5440441132,5440441201,5440441202,5440441203,5440442002,5440442003,5440443130,5440443132,5440443310,5440443312,5440443330,5440443332,5440450220,5440450222,5440452000,5440520313,5440520330,5440520331,5440520333,5440521033,5440521122,5440521123,5440521132,5440521202,5440521203,5440521211,5440521212,5440521213,5440522111,5440522113,5440522313,5440522331,5440522333,5440530200,5440530201,5440530202,5440530220,5440530222,5440530333,5440531211,5440531213,5440531222,5440531223,5440531231,5440531232,5440531233,5440532000,5440532002,5440532003,5440532012,5440532013,5440532102,5440532103,5440541110,5440541112,5440541130,5440541132,5440541310,5440541312,5440541330,5440541332,5440543110,5440543112,5440543130,5440543132,5440552220,5440552222,5440620213,5440620221,5440620223,5440620302,5440620303,5440622001,5440622003,5440622021,5440622023,5440622201,5440622203,5440622221,5440622223,5440650000,5440650002,5440650230,5440650232,5440652010,5440652012,5440652320,5440652322,5440713111,5440713331,5440713333,5440720001,5440720003,5440720021,5440720023,5440720201,5440720203,5440720221,5440720222,5440720223,5440750130,5440750132,5440751220,5440751222,5440753000,5440753002,5440753020,5440753022,5440753023,5440753210,5440753212,5440753213,5540011111,5540011112,5540011113,5540011310,5540011311,5540020200,5540020201,5540020210,5540020211,5540020213,5540020320,5540020321,5540020330,5540020331,5540020333,5540022111,5540022112,5540022113,5540022233,5540022303,5540051302,5540051320,5540051322,5540053100,5540053102,5540053103,5540053330,5540053332,5540120011,5540120012,5540120013,5540120031,5540120033,5540120231,5540120233,5540122011,5540122013,5540122031,5540122033,5540122211,5540122213,5540122231,5540122233,5540131230,5540131231,5540131232,5540131320,5540131321,5540132130,5540132131,5540132132,5540132220,5540132221,5540132230,5540132300,5540132302,5540133000,5540133001,5540133002,5540133110,5540133111,5540142020,5540142021,5540142023,5540142211,5540142213,5540142231,5540151110,5540151112,5540160220,5540160222,5540162032,5540162210,5540162212,5540162213,5540220011,5540220012,5540220013,5540221130,5540221132,5540221310,5540221312,5540221330,5540222201,5540222203,5540222221,5540222223,5540222330,5540222331,5540223000,5540223001,5540223002,5540223010,5540223020,5540223022,5540240101,5540240130,5540240131,5540241211,5540241321,5540243103,5540243211,5540243213,5540243231,5540243233,5540243320,5540243322,5540251230,5540252020,5540252021,5540252030,5540252031,5540252110,5540252111,5540252112,5540253000,5540260110,5540260112,5540260120,5540260121,5540260130,5540260200,5540320001,5540320010,5540320011,5540320100,5540320101,5540341010,54404331330,54404331331,54404331333,54404332333,54404333023,54404333030,54404333032,54404333033,54404333111,54404333112,54404333113,54404333121,54404333122,54404333123,54404333201,54404333203,54404402313,54404402323,54404403033,54404403113,54404403122,54404403123,54404410113,54404410213,54404410223,54404411002,54404411003,54404411011,54404411012,54404411013,54404411102,54404411120,54404411122,54404411123,54404411330,54404411332,54404411333,54404412001,54404412002,54404412003,54404420013,54404431310,54404431311,54404431312,54404431330,54404431332,54404500222,54404502000,54404502002,54404502020,54404502022,54404502023,54404520020,54404520021,54405203211,54405203213,54405210313,54405211332,54405211333,54405212003,54405212012,54405212013,54405212101,54405212102,54405212103,54405221311,54405223112,54405223113,54405300221,54405300222,54405300223,54405302030,54405302032,54405302100,54405302102,54405302210,54405303222,54405303310,54405303312,54405303313,54405303321,54405303323,54405310110,54405310111,54405310311,54405310313,54405310331,54405310332,54405310333,54405312202,54405312203,54405312212,54405312213,54405312301,54405312302,54405312303,54405320111,54405320112,54405320113,54405321000,54405321002,54405321003,54405321012,54405321013,54405431332,54405431333,54405520222,54405522000,54405522022,54405522023,54405522210,54405522212,54405522230,54405522232,54406201013,54406202013,54406202031,54406202032,54406202033,54406202113,54406202122,54406202123,54406202201,54406202203,54406202221,54406202223,54406203002,54406203003,54406203011,54406203012,54406203013,54406220001,54406220203,54406220221,54406220223,54406222001,54406222003,54406222021,54406222023,54406222201,54406222203,54406222221,54406222223,54406500010,54406500012,54406500013,54406500030,54406500031,54406500032,54406502100,54406502102,54406502120,54406502122,54406502332,54406520110,54406520112,54406520130,54406520132,54406521222,54406523000,54406523002,54406523020,54406523022,54406523023,54406523210,54406523212,54406523230,54406523232,54407113333,54407131333,54407133111,54407133113,54407133131,54407133132,54407133133,54407133303,54407200001,54407200003,54407200021,54407200023,54407200201,54407200203,54407200221,54407200223,54407202001,54407202003,54407202021,54407202023,54407202201,54407202203,54407501120,54407501122,54407501123,54407501332,54407512020,54407512022,54407512232,54407530010,54407530012,54407530030,54407530032,54407530210,54407530212,54407530322,54407530323,54407532112,54407533022,54407533200,54407533202,54407533220,54407533222,55400111013,55400111031,55400111033,55400111101,55400111102,55400111103,55400111211,55400111213,55400111231,55400202021,55400202030,55400202031,55400202120,55400202121,55400202123,55400202311,55400202313,55400203230,55400203231,55400203320,55400203321,55400203323,55400221033,55400221101,55400221102,55400221103,55400221211,55400221213,55400221231,55400221233,55400222311,55400222312,55400222313,55400222323,55400223011,55400223012,55400223013,55400223021,55400223023,55400511000,55400511002,55400511020,55400511022,55400511200,55400511202,55400511220,55400511222,55400513000,55400513002,55400513212,55400513230,55400513232,55400531010,55400531012,55400531013,55400533100,55400533102,55400533120,55400533122,55401200031,55401200033,55401200101,55401200102,55401200103,55401200300,55401200301,55401200303,55401200321,55401200322,55401200323,55401202011,55401202013,55401202031,55401222323,55401313231,55401313233,55401321330,55401321331,55401322220,55401322222,55401322310,55401322312,55401323010,55401323011,55401323012,55401323100,55401323101,55401330030,55401330031,55401330032,55401330200,55401330201,55401330202,55401330210,55401330220,55401331130,55401331131,55401331133,55401331311,55401331313,55401331331,55401331333,55401333111,55401420220,55401420221,55401422010,55401422011,55401422100,55401422101,55401422103,55401511112,55401511130,55401511132,55401600222,55401602000,55401602002,55401602020,55401602022,55401602230,55401602232,55401620120,55401620122,55401620300,55401620302,55401620303,55401622110,55401622112,55401622113,55401623020,55401623022,55401623033,55401623122,55401623123,55402200013,55402200031,55402200033,55402200101,55402200102,55402200103,55402200211,55402200213,55402200230,55402200231,55402200233,55402202011,55402202013,55402202031,55402202033,55402202211,55402202213,55402202231,55402202233,55402211310,55402211311,55402213320,55402213321,55402213322,55402220011,55402220013,55402220031,55402220033,55402220211,55402220213,55402220231,55402220233,55402222201,55402223320,55402223321,55402223322,55402223330,55402230030,55402230031,55402230032,55402230110,55402230111,55402230120,55402230121,55402230210,55402230212,55402230230,55402230232,55402231000,55402231001,55402231010,55402231011,55402231100,55402232000,55402232002,55402232020,55402232022,55402401001,55402401003,55402401021,55402401030,55402401031,55402401033,55402401211,55402401320,55402401321,55402401330,55402401331,55402401333,55402412101,55402412103,55402413201,55402413203,55402413231,55402413233,55402431011,55402431013,55402431021,55402431023,55402432233,55402432303,55402432321,55402432322,55402432323,55402433210,55402433212,55402512320,55402520220,55402520221,55402520222,55402520230,55402520231,55402520320,55402520321,55402520330,55402520331,55402521130,55402521131,55402521200,55402521201,55402521202,55402521210,55402521211,55402521220,55402521300,55402521301,55402530010,55402530011,55402530020,55402530021,55402601110,55402601111,55402601112,55402601220,55402601221,55402601222,55402601230,55402601231,55402601320,55402601321,55402601323,55402602010,55402602012,55402602020,55402602022,55402602111,55402602113,55402603101,55403200031,55403200120,55403200121,55403200130,55403200131,55403201020,55403201021,55403201030,55403201031,55403201100,55403410011,55403410013,55403410031,55403410110,55403410111,55403410112,55403410120,55403410121,55403410123,55403410130,55403410132,55403410301,55403410303,55403410310,55403410311,55403410312,55403410330,55403410332,55403411000,55403411001,54405411312,54405411313,54405411310,54404433311,54404433310,54404433133,54404433132,54404433130,54404520022,
057,00,ؼ,503142187,128418750,503198437,128475000,0,0,0,0,2,11,5339460030,5339460032,53394600120,53394600122,53394600123,53394600130,53394600132,53394600213,53394600231,53394600233,53394600310,53394600312,53394600330,
057,01,ͭĮ/ë,503085937,128400000,503156250,128484375,0,0,0,1,1,10,533946000,5339460020,53394511111,53394600210,53394600211,53394600212,53394600220,53394600221,53394600223,53394600230,53394600232,53394602001,
057,02,ո,503170312,128484375,503254687,128531250,0,0,0,0,2,11,5339460213,5339460302,53394602303,53394602310,53394602311,53394602312,53394603003,53394603012,53394603030,53394603032,53394603200,53394603201,53394603210,
057,03,,503128125,128475000,503226562,128493750,0,0,0,0,2,4,5339460210,5339460211,53394602010,53394602011,53394603000,53394603002,
057,04,ο/Į,503114062,128484375,503184375,128521875,0,0,0,0,2,9,5339460203,5339460212,53394602003,53394602012,53394602013,53394602021,53394602023,53394602210,53394602211,53394602300,53394602301,
057,05,Į/ԥë,503029687,128428125,503114062,128521875,0,0,0,0,5,20,5339451131,5339451133,5339451310,5339451311,5339451312,53394511123,53394511132,53394511133,53394511301,53394511303,53394511321,53394511322,53394511323,53394513011,53394513013,53394513031,53394513033,53394513130,53394513131,53394513211,53394513300,53394600222,53394602000,53394602002,53394602020,
058,00,,503142187,128371875,503198437,128428125,0,0,0,0,2,6,5339362232,5339460010,53393622233,53393622302,53393622332,53394600110,53394600112,53394600121,
058,02,ܶ,503184375,128400000,503240625,128475000,0,0,0,0,1,17,5339460102,53394600111,53394600113,53394600131,53394600133,53394600311,53394600313,53394600331,53394600332,53394600333,53394601000,53394601002,53394601003,53394601200,53394601201,53394601202,53394601220,53394601222,
058,04,ͷĮ/Į,503226562,128428125,503268750,128484375,0,0,0,0,0,12,53394601032,53394601203,53394601210,53394601212,53394601213,53394601221,53394601223,53394601230,53394601231,53394601232,53394603001,53394603010,
058,05,,503170312,128362500,503226562,128400000,0,0,0,0,0,10,53393622301,53393622303,53393622310,53393622312,53393622313,53393622330,53393622331,53393622333,53393623220,53393623222,
058,06,//˭,503156250,128287500,503268750,128409375,0,0,0,1,7,19,533936230,5339362033,5339362120,5339362122,5339362123,5339362211,5339362213,5339362320,53393620311,53393620312,53393620313,53393620323,53393621212,53393622101,53393622103,53393622120,53393622121,53393622123,53393622311,53393623210,53393623211,53393623212,53393623221,53393623223,53393623230,53393623232,53394601001,
058,07,,503071875,128353125,503170312,128400000,0,0,0,0,3,12,5339362220,5339362221,5339362222,53393533310,53393533311,53393533313,53393533331,53393533333,53393622032,53393622033,53393622122,53393622230,53393622231,53393622232,53393622300,
058,08,;Į/Ǳ,503071875,128268750,503170312,128362500,0,0,0,1,6,17,533936202,5339353131,5339362002,5339362003,5339362200,5339362201,5339362202,53393531132,53393531133,53393531331,53393533111,53393533113,53393533131,53393533133,53393620120,53393620122,53393620300,53393620302,53393620320,53393620322,53393622030,53393622031,53393622100,53393622102,
058,09,Į/,503057812,128287500,503100000,128343750,0,0,0,0,0,11,53393531301,53393531303,53393531321,53393531323,53393531330,53393531332,53393531333,53393533101,53393533103,53393533110,53393533112,
058,10,,503029687,128240625,503170312,128287500,0,0,0,0,5,17,5339353110,5339353111,5339353112,5339362000,5339362001,53393513233,53393513322,53393513323,53393513332,53393513333,53393531011,53393531013,53393531031,53393531130,53393531131,53393602222,53393602223,53393602232,53393602233,53393602322,53393620100,53393620102,
059,00,ֺ,503015625,128390625,503100000,128446875,0,0,0,0,3,13,5339451101,5339451103,5339451110,53393533233,53393533322,53393533323,53393533332,53394511110,53394511112,53394511113,53394511120,53394511121,53394511122,53394511130,53394511131,53394511211,
059,01,Ļ/ǻĮ,502973437,128371875,503029687,128437500,0,0,0,0,3,11,5339353322,5339451100,5339451102,53393532331,53393532333,53393533202,53393533203,53393533212,53393533230,53393533232,53394510111,53394510113,53394510131,53394510133,
059,02,ϻ,503029687,128353125,503085937,128390625,0,0,0,0,1,9,5339353330,53393533033,53393533122,53393533211,53393533213,53393533231,53393533312,53393533320,53393533321,53393533330,
059,03,,502973437,128343750,503029687,128381250,0,0,0,0,0,9,53393532311,53393532313,53393533022,53393533023,53393533030,53393533032,53393533200,53393533201,53393533210,
059,04,۽,503029687,128343750,503085937,128362500,0,0,0,0,0,6,53393533031,53393533120,53393533121,53393533123,53393533130,53393533132,
059,05,/,502973437,128259375,503057812,128362500,0,0,0,0,4,24,5339353121,5339353123,5339353300,5339353301,53393531012,53393531021,53393531022,53393531023,53393531030,53393531032,53393531033,53393531200,53393531201,53393531203,53393531221,53393531223,53393531300,53393531302,53393531320,53393531322,53393532111,53393532113,53393532131,53393532133,53393533020,53393533021,53393533100,53393533102,
059,06,,503170312,128090625,503395312,128325000,0,0,0,6,20,49,533936030,533936032,533936210,533936013,533936102,533936031,5339360122,5339360123,5339360213,5339360231,5339360233,5339360330,5339360332,5339362011,5339362013,5339362110,5339362112,5339362130,5339361200,5339360112,5339360113,5339361002,5339361003,5339360111,5339360331,5339360211,53393601203,53393601212,53393602301,53393602303,53393602321,53393602323,53393603330,53393603332,53393620101,53393620103,53393620121,53393620123,53393621110,53393621112,53393621130,53393621210,53393621211,53393621213,53393621320,53393621321,53393621322,53393612020,53393612010,53393601213,53393601211,53393601033,53393601031,53393601102,53393601103,53393610002,53393610003,53393610012,53393610122,53393610300,53393601101,53393610000,53392623333,53392623332,53393610302,53393603331,53393612021,53393612012,53393612011,53393600332,53393620310,53393620301,53393620303,53393620321,53393600333,
060,00,/ȿ,502903125,128146875,503085937,128268750,0,0,0,2,13,26,533935121,533935130,5339351032,5339351033,5339351122,5339351201,5339351203,5339351230,5339351231,5339351312,5339351320,5339351321,5339351322,5339351330,5339353100,53393510213,53393510231,53393510232,53393510233,53393510302,53393510303,53393510312,53393510313,53393511232,53393512210,53393512211,53393512330,53393512331,53393512333,53393513102,53393513103,53393513132,53393513230,53393513231,53393513232,53393513310,53393513312,53393513320,53393513321,53393513330,53393531010,
060,01,ܹ,502889062,128221875,503001562,128296875,0,0,0,0,6,12,5339351223,5339351232,5339353001,5339353010,5339353011,5339353013,53393512203,53393512212,53393512213,53393512221,53393512223,53393512332,53393530031,53393530120,53393530121,53393530123,53393530311,53393531020,
060,02,ŷ,503071875,128090625,503198437,128240625,0,0,0,2,11,26,533936002,533936020,5339351311,5339360001,5339360002,5339360003,5339360012,5339360030,5339360032,5339360210,5339360212,5339360220,5339360221,53392622232,53392622233,53392622322,53393511333,53393513130,53393513131,53393513133,53393513311,53393513313,53393513331,53393600002,53393600003,53393600100,53393600102,53393600130,53393600132,53393600310,53393600312,53393600330,53393602220,53393602221,53393602230,53393602231,53393602300,53393602302,53393602320,
060,03,Į,502973437,128109375,503100000,128184375,0,0,0,0,9,13,5339351102,5339351103,5339351112,5339351113,5339351120,5339351121,5339351130,5339351131,5339351132,53393510133,53393510311,53393511103,53393511112,53393511113,53393511230,53393511231,53393511233,53393511330,53393511331,53393511332,53393513100,53393513101,
060,04,翹,502903125,128006250,503254687,128146875,0,0,0,4,27,49,533925331,533925332,533925333,533926220,5339253132,5339253133,5339253231,5339253232,5339253233,5339253301,5339253302,5339253303,5339262022,5339262210,5339262212,5339262213,5339262220,5339262221,5339262222,5339262230,5339262231,5339262233,5339262302,5339262320,5339262322,5339351010,5339351011,5339351012,5339351100,5339351101,5339360011,53392531231,53392531233,53392532131,53392532132,53392532133,53392532233,53392532302,53392532303,53392533001,53392533002,53392533003,53392620232,53392620233,53392620320,53392620322,53392620323,53392622112,53392622230,53392622231,53392622320,53392622321,53392622323,53392623212,53392623230,53392623232,53393510010,53393510011,53393510013,53393510130,53393510131,53393510132,53393510300,53393510301,53393510310,53393511100,53393511101,53393511102,53393511110,53393511111,53393600000,53393600001,53393600101,53393600103,53393600131,53393600133,53393601000,53393601001,53393601002,53393601020,
061,00,,502832812,127884375,503325000,128100000,0,0,0,10,30,55,533925303,533925310,533925311,533925320,533926032,533926033,533926200,533926201,533926210,533926212,5339251232,5339251233,5339252311,5339252313,5339253011,5339253013,5339253021,5339253022,5339253023,5339253120,5339253121,5339253122,5339253130,5339253131,5339253210,5339253211,5339253212,5339253220,5339253221,5339253222,5339260233,5339260303,5339262020,5339262021,5339262030,5339262031,5339262033,5339262110,5339262112,5339262300,53392512302,53392512303,53392512312,53392512313,53392513202,53392513220,53392513222,53392513223,53392521331,53392521332,53392521333,53392523121,53392523123,53392523311,53392523313,53392530100,53392530101,53392530103,53392530121,53392530122,53392530123,53392530202,53392530203,53392531230,53392531232,53392532130,53392532230,53392532231,53392532232,53392532300,53392532301,53392533000,53392602311,53392602312,53392602313,53392602321,53392602322,53392602323,53392603023,53392603120,53392603122,53392603123,53392620230,53392620231,53392620321,53392621110,53392621112,53392621300,53392621302,53392622110,53392622111,53392622113,53392623010,53392623012,53392603102,
061,01,ıĴ,502720312,128062500,502931250,128165625,0,0,0,1,9,32,533935011,5339252332,5339252333,5339350102,5339350103,5339350120,5339351000,5339351002,5339351003,5339351020,53392523301,53392523302,53392523303,53392523310,53392523312,53393500131,53393500132,53393500133,53393500301,53393500310,53393500311,53393501002,53393501003,53393501011,53393501012,53393501013,53393501210,53393501211,53393501212,53393501300,53393501301,53393501310,53393501311,53393501313,53393501331,53393510012,53393510210,53393510211,53393510212,53393510220,53393510221,53393510230,
062,00,ëؼ,502875000,128325000,502945312,128400000,0,0,0,0,6,6,5339353201,5339353202,5339353203,5339353220,5339353221,5339353223,53393532102,53393532120,53393532122,53393532221,53393532223,53393532320,
062,01,ë̤/ܱ׺,502931250,128334375,502973437,128381250,0,0,0,0,0,9,53393532103,53393532112,53393532121,53393532123,53393532130,53393532132,53393532300,53393532301,53393532302,
062,03,ɽƻ/,502931250,128362500,502973437,128437500,0,0,0,0,2,12,5339451010,5339451012,53393532303,53393532310,53393532312,53393532321,53393532322,53393532323,53393532330,53393532332,53394510110,53394510112,53394510130,53394510132,
062,04,/塹ھ帶,502818750,128381250,502903125,128475000,0,0,0,0,7,15,5339352333,5339450111,5339450112,5339450113,5339450130,5339450131,5339451020,53393523323,53393532220,53393532222,53394501101,53394501102,53394501103,53394501330,53394501331,53394501333,53394510000,53394510002,53394510020,53394510022,53394510023,53394510220,
062,05,/崱,502917187,128287500,503001562,128334375,0,0,0,0,2,12,5339353032,5339353033,53393530233,53393530301,53393530303,53393530310,53393530312,53393530313,53393531202,53393531220,53393531222,53393532100,53393532101,53393532110,
062,06,ܹ,502846875,128231250,502945312,128343750,0,0,0,0,6,18,5339353000,5339353002,5339353020,5339353021,5339353022,5339353200,53393503332,53393503333,53393512220,53393512222,53393521111,53393521331,53393521333,53393523111,53393523113,53393530030,53393530032,53393530033,53393530122,53393530230,53393530231,53393530232,53393530300,53393530302,
062,07,ͳ,502790625,128146875,502903125,128250000,0,0,0,1,10,17,533935031,5339350123,5339350132,5339350301,5339350303,5339350321,5339350330,5339350331,5339350332,5339351200,5339351202,53393501213,53393501302,53393501303,53393501312,53393501330,53393501332,53393501333,53393503230,53393503231,53393503233,53393503330,53393503331,53393510222,53393510223,53393512200,53393512201,53393512202,
062,08,㲰/,502790625,128250000,502875000,128343750,0,0,0,0,7,16,5339352113,5339352121,5339352123,5339352130,5339352131,5339352132,5339352310,53393521032,53393521033,53393521101,53393521103,53393521110,53393521112,53393521113,53393521121,53393521122,53393521123,53393521330,53393521332,53393523010,53393523011,53393523110,53393523112,
062,09,Ҷ,502565625,128165625,502692187,128250000,0,0,0,1,4,19,533934133,5339341313,5339341321,5339350200,5339350202,53393413033,53393413113,53393413121,53393413122,53393413123,53393413230,53393413231,53393413233,53393500232,53393502010,53393502012,53393502030,53393502032,53393502200,53393502201,53393502202,53393502210,53393502220,53393502222,
062,10,,502692187,128146875,502790625,128231250,0,0,0,1,6,14,533935021,5339350032,5339350033,5339350122,5339350231,5339350300,5339350302,53393500231,53393500233,53393500302,53393500303,53393500312,53393500313,53393502011,53393502013,53393502031,53393502033,53393502300,53393502301,53393503200,53393503201,
062,11,,502734375,128334375,502875000,128409375,0,0,0,0,10,15,5339352213,5339352302,5339352303,5339352312,5339352313,5339352320,5339352321,5339352323,5339352330,5339352331,53393522112,53393522113,53393523002,53393523003,53393523012,53393523013,53393523221,53393523223,53393523320,53393523321,53393523322,53394501001,53394501010,53394501011,53394501100,
062,12,,502425000,128212500,502706250,128446875,0,0,1,4,19,53,53393431,533934301,533934330,533934332,533944110,5339341232,5339341233,5339341320,5339341322,5339343001,5339343003,5339343021,5339343023,5339343030,5339343031,5339343032,5339343310,5339343312,5339343330,5339343332,5339352002,5339352020,5339352022,5339352023,53393412231,53393412232,53393412233,53393412312,53393412313,53393413232,53393430003,53393430020,53393430021,53393430023,53393430201,53393430203,53393430221,53393430330,53393430331,53393430332,53393432011,53393432100,53393432131,53393432133,53393432311,53393432312,53393432313,53393432331,53393432333,53393433110,53393433112,53393433130,53393433132,53393433310,53393433312,53393433330,53393520000,53393520002,53393520003,53393520030,53393520032,53393520210,53393520212,53393520213,53394410110,53394410111,53394410113,53394410131,53394411100,53394411101,53394411102,53394411120,53394411122,53394411200,53394411201,53394411210,53394411211,
062,13,,502720312,128362500,502818750,128465625,0,0,0,0,9,18,5339352231,5339352233,5339450011,5339450013,5339450031,5339450102,5339450103,5339450120,5339450121,53393522321,53393522323,53393523220,53393523222,53394500101,53394500103,53394500121,53394500123,53394500301,53394501000,53394501002,53394501003,53394501012,53394501013,53394501220,53394501221,53394501230,53394501231,
062,14,,502537500,128362500,502734375,128493750,0,0,0,3,8,25,533935222,533944113,533945000,5339352230,5339441111,5339441113,5339441122,5339441123,5339450020,5339450021,5339450022,53393433311,53393433313,53393433331,53393433332,53393433333,53393522320,53393522322,53394411103,53394411121,53394411123,53394411202,53394411203,53394411212,53394411213,53394413100,53394413101,53394413102,53394413110,53394413111,53394500100,53394500102,53394500120,53394500122,53394500230,53394500300,
062,15,Ѳ/,502664062,128212500,502832812,128296875,0,0,0,1,8,26,533935201,5339350223,5339350232,5339350233,5339350322,5339352001,5339352100,5339352101,5339352102,53393502203,53393502211,53393502212,53393502213,53393502221,53393502223,53393502302,53393502303,53393503202,53393503203,53393503232,53393520001,53393520031,53393520033,53393520211,53393520300,53393520301,53393520310,53393520311,53393521030,53393521031,53393521100,53393521102,53393521120,53393521200,53393521201,
062,16,ë/Ʋ,502635937,128296875,502790625,128362500,0,0,0,1,5,14,533935220,5339352032,5339352033,5339352122,5339352210,5339352212,53393433111,53393433113,53393433131,53393433133,53393520302,53393520303,53393520312,53393520313,53393521202,53393521203,53393522110,53393522111,53393523000,53393523001,
063,00,,502931250,128465625,502959375,128484375,0,0,0,0,0,3,53394510322,53394512100,53394512101,
063,01,,502875000,128456250,502931250,128503125,0,0,0,0,3,7,5339451023,5339451200,5339451201,53394510221,53394510222,53394510223,53394512020,53394512021,53394512030,53394512031,
063,02,/塹,502889062,128400000,502973437,128465625,0,0,0,0,4,7,5339451001,5339451003,5339451021,5339451030,53394510001,53394510003,53394510021,53394510310,53394510312,53394510320,53394510321,
063,03,ɲĮ,502931250,128484375,502973437,128503125,0,0,0,0,0,6,53394512102,53394512103,53394512112,53394512120,53394512121,53394512130,
063,04,ɣ,502945312,128456250,502987500,128484375,0,0,0,0,0,5,53394510323,53394510330,53394510332,53394510333,53394512110,
063,05,̥ë/ǻĮ,502973437,128437500,503029687,128465625,0,0,0,0,1,6,5339451120,53394510311,53394510313,53394510331,53394511210,53394511212,53394511220,
063,06,ë,502987500,128437500,503057812,128484375,0,0,0,0,1,10,5339451123,53394511213,53394511221,53394511222,53394511223,53394511300,53394511302,53394511320,53394513000,53394513001,53394513010,
063,07,Ķ/ں,503043750,128503125,503114062,128550000,0,0,0,0,2,9,5339451331,5339451332,53394513132,53394513133,53394513301,53394513302,53394513303,53394513330,53394513331,53394513332,53394602022,
063,08,Ͼ/,502903125,128475000,503043750,128568750,0,0,0,1,6,26,533945123,5339451221,5339451302,5339451320,5339451322,5339453010,5339453011,53394512032,53394512033,53394512111,53394512113,53394512122,53394512123,53394512131,53394512132,53394512133,53394512230,53394512231,53394512233,53394513002,53394513003,53394513012,53394513030,53394513032,53394513210,53394513212,53394513213,53394513230,53394513231,53394530011,53394530013,53394531000,53394531002,
063,09,,502720312,128456250,502917187,128606250,0,0,0,2,11,25,533945031,533945033,5339450132,5339450303,5339450321,5339450323,5339451220,5339451222,5339452031,5339452101,5339452103,5339452110,5339452112,53394501233,53394501332,53394503011,53394503013,53394503223,53394512022,53394512023,53394512232,53394520123,53394520132,53394520133,53394520301,53394520303,53394521001,53394521003,53394521021,53394521022,53394521023,53394521200,53394521201,53394521202,53394521210,53394521211,53394521300,53394521301,
063,10,߻/ë,502664062,128446875,502804687,128578125,0,0,0,2,12,32,533945021,533945023,5339450032,5339450033,5339450201,5339450203,5339450221,5339450223,5339450300,5339450302,5339450320,5339452001,5339452010,5339452011,53394500231,53394500232,53394500233,53394500302,53394500303,53394501222,53394501223,53394501232,53394502003,53394502021,53394502023,53394502201,53394502203,53394502221,53394502223,53394503010,53394503012,53394503220,53394503221,53394503222,53394520001,53394520003,53394520021,53394520030,53394520031,53394520120,53394520121,53394520130,53394520131,53394521000,53394521002,53394521020,
063,12,/,502509375,128475000,502678125,128587500,0,0,0,1,14,26,533944133,5339441300,5339441301,5339441303,5339441312,5339441313,5339441321,5339441323,5339443011,5339443013,5339443100,5339443101,5339443110,5339443111,5339443113,53394413020,53394413021,53394413023,53394413103,53394413112,53394413113,53394413201,53394413203,53394413221,53394413222,53394413223,53394431020,53394431021,53394431022,53394502000,53394502001,53394502002,53394502020,53394502022,53394502200,53394502202,53394502220,53394502222,53394520000,53394520002,53394520020,
063,14,/,502270312,128550000,502720312,128793750,0,0,2,13,24,59,53394432,53394433,533944212,533944213,533944230,533944231,533944233,533944302,533944303,533944312,533944313,533945202,533954101,533954110,533954111,5339442033,5339442100,5339442102,5339442103,5339442112,5339442211,5339442321,5339443012,5339443103,5339443112,5339452200,5339452201,5339452202,5339452220,5339541000,5339541001,5339541003,5339541030,5339541031,5339541033,5339541120,5339541121,5339541122,5339541130,53394420111,53394420113,53394420131,53394420133,53394420303,53394420311,53394420312,53394420313,53394420321,53394420323,53394421010,53394421012,53394421013,53394421102,53394421132,53394422130,53394422131,53394422133,53394423200,53394423201,53394423203,53394423230,53394423231,53394423233,53394430033,53394430103,53394431023,53394520022,53394520023,53394520032,53394520033,53394520122,53394520300,53394520302,53394520320,53394520322,53394522220,53394522221,53394522222,53395401111,53395410021,53395410023,53395410211,53395410321,53395411231,53395411310,53395411311,53395411320,53395411321,53395412111,53395413000,53395413001,53395413003,53395413010,53395500000,53395500002,53395500020,53395500022,53395500200,
064,00,ܶ,503128125,128521875,503198437,128596875,0,0,0,0,5,8,5339460223,5339460232,5339462001,5339462003,5339462010,53394602212,53394602213,53394602302,53394602330,53394602332,53394620120,53394620121,53394620210,
064,01,/,503128125,128578125,503184375,128625000,0,0,0,0,2,8,5339462023,5339462030,53394620122,53394620123,53394620211,53394620212,53394620213,53394620320,53394620321,53394620322,
064,02,/,503071875,128540625,503128125,128596875,0,0,0,0,4,5,5339453111,5339453113,5339462000,5339462002,53394513333,53394602222,53394602223,53394620200,53394620201,
064,03,/,502987500,128540625,503071875,128615625,0,0,0,0,7,8,5339453101,5339453102,5339453103,5339453110,5339453112,5339453121,5339453130,53394513232,53394513233,53394531001,53394531003,53394531201,53394531203,53394531230,53394531231,
064,04,ڱ/ƻ,503100000,128512500,503128125,128540625,0,0,0,0,1,2,5339460220,53394602220,53394602221,
065,00,,502846875,128578125,503043750,128690625,0,0,0,2,11,22,533945320,533945321,5339453023,5339453031,5339453032,5339453033,5339453122,5339453231,5339453300,5339453301,5339453302,5339453320,5339453321,53394523111,53394523113,53394523130,53394523131,53394530133,53394530212,53394530213,53394530222,53394530223,53394530302,53394530303,53394531200,53394531202,53394531232,53394531233,53394532201,53394532210,53394533030,53394533032,53394533033,53394533221,53394533230,
065,01,,502832812,128550000,502987500,128643750,0,0,0,0,9,16,5339452111,5339452113,5339452131,5339452133,5339453000,5339453002,5339453003,5339453012,5339453020,53394521303,53394521321,53394521323,53394523110,53394523112,53394530010,53394530012,53394530130,53394530131,53394530132,53394530210,53394530211,53394530220,53394530221,53394530300,53394530301,
065,02,,502734375,128596875,502959375,128765625,0,0,0,3,16,33,533945233,533955010,533955011,5339452123,5339452301,5339452310,5339452312,5339452322,5339452323,5339453222,5339453223,5339453230,5339550013,5339550031,5339550120,5339550121,5339550130,5339551000,5339551001,53394521203,53394521212,53394521213,53394521221,53394521223,53394521302,53394521320,53394521322,53394523031,53394523033,53394523132,53394523133,53394523211,53394532200,53394532202,53394532203,53394532211,53394532212,53394532213,53394532320,53394532321,53394532322,53395500112,53395500113,53395500330,53395500331,53395501220,53395501221,53395501230,53395501310,53395510020,53395510021,53395510100,
065,03,˭/˭,502664062,128606250,502818750,128728125,0,0,0,2,8,17,533945221,533945223,5339452033,5339452203,5339452221,5339452223,5339452300,5339452302,5339452320,5339550010,53394520321,53394520323,53394521220,53394521222,53394522223,53394523030,53394523032,53394523210,53394523212,53394523213,53395500001,53395500010,53395500011,53395500013,53395500110,53395500111,53395500121,
065,04,,502664062,128709375,502917187,128868750,0,0,1,1,19,33,53395503,533955021,5339550003,5339550021,5339550023,5339550030,5339550032,5339550132,5339550201,5339550203,5339550230,5339550231,5339550233,5339551202,5339551220,5339551222,5339552100,5339552101,5339552110,5339552111,5339553000,53395500003,53395500012,53395500021,53395500023,53395500120,53395500122,53395500123,53395500201,53395500203,53395500221,53395500223,53395500332,53395500333,53395501222,53395501223,53395501231,53395501232,53395501233,53395501332,53395502001,53395502003,53395502021,53395502211,53395502321,53395502323,53395512002,53395512003,53395512230,53395512232,53395520101,53395520111,53395530010,53395530012,
065,05,,503001562,128671875,503142187,128765625,0,0,0,0,7,36,5339453332,5339551101,5339551110,5339551111,5339551113,5339551131,5339560020,53394533223,53394533231,53394533232,53394533233,53394533302,53394533303,53394533330,53394533332,53394533333,53394622222,53394622223,53394622232,53395511001,53395511003,53395511021,53395511030,53395511031,53395511120,53395511121,53395511123,53395511301,53395511303,53395511321,53395511330,53395511331,53395600000,53395600001,53395600002,53395600010,53395600020,53395600022,53395600023,53395600210,53395600212,53395600220,53395600221,
065,06,Τ,503043750,128643750,503142187,128690625,0,0,0,0,3,15,5339453331,5339462202,5339462220,53394533122,53394533123,53394533131,53394533132,53394533133,53394533300,53394533301,53394533331,53394622030,53394622032,53394622210,53394622212,53394622220,53394622221,53394622230,
065,07,콽,502903125,128681250,503057812,128775000,0,0,0,0,9,24,5339453233,5339551003,5339551011,5339551012,5339551013,5339551030,5339551031,5339551120,5339551121,53394532323,53394533220,53394533222,53395510101,53395510102,53395510103,53395510211,53395511000,53395511002,53395511020,53395511022,53395511023,53395511032,53395511033,53395511122,53395511220,53395511221,53395511223,53395511230,53395511231,53395511232,53395511300,53395511302,53395511320,
065,08,ֱ,502846875,128728125,503057812,128859375,0,0,0,2,12,32,533955121,533955130,5339551020,5339551022,5339551023,5339551032,5339551033,5339551201,5339551203,5339551221,5339551230,5339551231,5339551320,5339551321,53395501311,53395501312,53395501313,53395501330,53395501331,53395501333,53395510022,53395510023,53395510210,53395510212,53395510213,53395511222,53395511233,53395511322,53395512000,53395512001,53395512231,53395512233,53395512320,53395512321,53395512322,53395512330,53395512331,53395513100,53395513102,53395513120,53395513122,53395513220,53395513221,53395513300,53395513302,53395530011,
065,09,ü//,503029687,128587500,503254687,128700000,0,0,0,1,10,22,533946223,5339453131,5339453132,5339453133,5339453310,5339453311,5339462022,5339462200,5339462201,5339462320,5339462322,53394533031,53394533120,53394533121,53394533130,53394620202,53394620203,53394622031,53394622033,53394622100,53394622102,53394622120,53394622122,53394622123,53394622132,53394622211,53394622213,53394622231,53394622233,53394623210,53394623212,53394623230,53394623232,
066,00,/Į,503184375,128521875,503282812,128615625,0,0,0,0,7,12,5339460322,5339462011,5339462013,5339462100,5339462102,5339462103,5339462121,53394602313,53394602331,53394602333,53394603202,53394603203,53394621012,53394621201,53394621203,53394621230,53394621231,53394621302,53394621320,
066,01,,503240625,128521875,503325000,128615625,0,0,0,0,5,17,5339460323,5339462110,5339462112,5339462113,5339462131,53394603212,53394603213,53394603302,53394603320,53394603322,53394603323,53394621010,53394621011,53394621013,53394621110,53394621112,53394621300,53394621301,53394621303,53394621321,53394621330,53394621331,
066,02,Τ,503170312,128587500,503268750,128662500,0,0,0,0,7,12,5339462031,5339462033,5339462122,5339462211,5339462300,5339462302,5339462303,53394620323,53394621200,53394621202,53394621232,53394622101,53394622103,53394622121,53394622130,53394622131,53394622133,53394623010,53394623012,
066,03,齻,503057812,128615625,503493750,128934375,0,0,3,10,23,87,53395601,53395603,53395612,533946231,533946233,533956001,533956003,533956020,533956021,533956023,533956201,533956210,533956211,5339463200,5339463202,5339463220,5339551311,5339560003,5339560023,5339560221,5339561022,5339561023,5339561032,5339561033,5339561122,5339561123,5339561300,5339562003,5339562021,5339562030,5339562031,5339562032,5339563000,5339563002,5339563011,5339563100,53394621233,53394621322,53394621323,53394621332,53394621333,53394623011,53394623013,53394623211,53394623213,53394623231,53394623233,53394630222,53394630223,53394632012,53394632030,53394632032,53394632210,53394632220,53394632222,53395511323,53395511332,53395511333,53395513101,53395513103,53395513131,53395513133,53395600003,53395600011,53395600012,53395600013,53395600021,53395600211,53395600213,53395600222,53395600223,53395602200,53395602201,53395602203,53395602230,53395602231,53395602233,53395610000,53395610002,53395610020,53395610022,53395610200,53395610202,53395610203,53395610212,53395610213,53395610302,53395610303,53395610312,53395610313,53395611202,53395611203,53395611212,53395611213,53395613010,53395613020,53395613021,53395613022,53395613200,53395613202,53395613220,53395613222,53395620013,53395620023,53395620201,53395620203,53395620230,53395620231,53395620330,53395620331,53395620332,53395621200,53395621310,53395621311,53395622101,53395630010,53395630012,53395630030,53395630032,53395630200,53395630201,53395630210,53395630212,
066,04,,503339062,128428125,503592187,128746875,0,0,0,8,28,69,533946311,533946312,533946313,533946321,533946323,533946330,533946332,533956101,5339461131,5339461132,5339461133,5339461311,5339461313,5339461331,5339461332,5339461333,5339463033,5339463101,5339463103,5339463223,5339463310,5339463312,5339463330,5339470020,5339470022,5339470200,5339470202,5339470220,5339470222,5339472000,5339472002,5339561001,5339561003,5339561100,5339561101,5339561102,53394611132,53394611133,53394611301,53394611302,53394611303,53394613101,53394613103,53394613121,53394613123,53394613233,53394613301,53394613302,53394613303,53394630311,53394630313,53394630322,53394630323,53394631021,53394631022,53394631023,53394632013,53394632031,53394632033,53394632211,53394632212,53394632213,53394632221,53394632223,53394633110,53394633111,53394633112,53394633130,53394633320,53394633322,53394700022,53394700023,53394700032,53394700210,53394700212,53394700230,53394700232,53394702010,53394702012,53394702030,53394702032,53394702210,53394702212,53394702230,53394702232,53394720200,53394720202,53394720220,53395610001,53395610003,53395610021,53395610023,53395610201,53395610210,53395610211,53395610300,53395610301,53395610310,53395610311,53395611030,53395611032,53395611200,53395611201,53395611210,53395611211,
066,05,,503451562,128428125,503718750,128850000,0,0,0,10,29,71,533947021,533947023,533947030,533947201,533947220,533947221,533947222,533956111,533956113,533956131,5339463331,5339463333,5339470030,5339470032,5339470033,5339470122,5339470320,5339470321,5339470322,5339472001,5339472003,5339472021,5339472023,5339472030,5339472032,5339472230,5339561303,5339561321,5339561330,5339561331,5339561333,5339570000,5339570001,5339570002,5339570020,5339570022,5339570200,5339570203,5339570222,53394633113,53394633131,53394633132,53394633133,53394633321,53394633323,53394700033,53394700211,53394700213,53394700231,53394700233,53394700312,53394700313,53394701202,53394701232,53394702011,53394702013,53394702031,53394702033,53394702211,53394702213,53394702231,53394702233,53394703230,53394703231,53394703232,53394720201,53394720203,53394720221,53394720222,53394720223,53394720310,53394720311,53394720312,53394720330,53394720332,53394721000,53394721001,53394721002,53394721020,53394722310,53394722311,53394722312,53394722320,53394722321,53394722322,53395611031,53395611033,53395613011,53395613012,53395613013,53395613023,53395613201,53395613203,53395613221,53395613223,53395613230,53395613231,53395613320,53395613321,53395613323,53395700030,53395700032,53395702010,53395702012,53395702013,53395702020,53395702021,53395702120,53395702122,53395702202,
067,00,ξ,503254687,128475000,503325000,128540625,0,0,0,1,1,11,533946031,5339460331,53394603011,53394603013,53394603031,53394603033,53394603211,53394603300,53394603301,53394603303,53394603321,53394603330,53394603331,
067,01,ӻĮ/Ƚ,503296875,128437500,503395312,128634375,0,0,0,0,12,24,5339461020,5339461022,5339461200,5339461202,5339461220,5339461222,5339463000,5339463001,5339463002,5339463020,5339463021,5339463023,53394603332,53394603333,53394610210,53394610212,53394610230,53394610232,53394612010,53394612012,53394612030,53394612032,53394612210,53394612212,53394612230,53394612232,53394612233,53394621111,53394621113,53394630030,53394630032,53394630100,53394630220,53394630221,53394632010,53394632011,
067,02,,503367187,128428125,503507812,128615625,0,0,0,1,14,41,533946123,5339461123,5339461212,5339461213,5339461301,5339461302,5339461303,5339461320,5339461321,5339461322,5339463011,5339463012,5339463013,5339463030,5339463100,53394611023,53394611201,53394611203,53394611210,53394611212,53394611213,53394611221,53394611223,53394612011,53394612013,53394612031,53394612033,53394612100,53394612102,53394612103,53394612112,53394612113,53394612211,53394612213,53394612231,53394613001,53394613002,53394613003,53394613100,53394613102,53394613120,53394613122,53394613230,53394613231,53394613232,53394613300,53394630031,53394630033,53394630101,53394630102,53394630103,53394630310,53394630312,53394630320,53394630321,53394631020,
067,03,,503254687,128428125,503325000,128475000,0,0,0,1,0,7,533946013,53394601033,53394601122,53394601123,53394601132,53394601133,53394601211,53394601233,
067,04,,503240625,128362500,503310937,128428125,0,0,0,0,4,13,5339362330,5339362332,5339460101,5339460110,53393623213,53393623231,53393623233,53393623312,53393623330,53393623332,53394601030,53394601031,53394601110,53394601112,53394601120,53394601121,53394601130,
067,05,ھ,503310937,128381250,503367187,128437500,0,0,0,0,3,11,5339363222,5339461000,5339461002,53393623331,53393623333,53393632230,53393632232,53394601111,53394601113,53394601131,53394610010,53394610012,53394610030,53394610032,
067,06,ä̦/ͭ/ھ,503268750,128184375,503465625,128400000,0,0,1,6,17,23,53393630,533936122,533936123,533936231,533936320,533936321,533936323,5339361203,5339361212,5339361213,5339361302,5339361320,5339361322,5339362131,5339362133,5339363100,5339363102,5339363120,5339363122,5339363220,5339363221,5339363300,5339363302,5339363320,53393603333,53393612013,53393612022,53393612023,53393612102,53393612103,53393612112,53393612113,53393613002,53393613003,53393621111,53393621113,53393621131,53393621132,53393621133,53393621323,53393623310,53393623311,53393623313,53393632231,53393632233,53393633220,53393633221,
067,07,Į,503367187,128390625,503465625,128484375,0,0,0,2,1,21,533946101,533946103,5339461100,53393633222,53393633223,53394610011,53394610013,53394610031,53394610033,53394610211,53394610213,53394610231,53394610233,53394611020,53394611021,53394611022,53394611200,53394611202,53394611220,53394611222,53394612101,53394612110,53394612111,53394613000,
067,08,׳,503465625,128259375,503606250,128446875,0,0,0,5,17,19,533936313,533936331,533936333,533937220,533937222,5339363103,5339363112,5339363113,5339363121,5339363123,5339363301,5339363303,5339363321,5339363323,5339372022,5339461101,5339461103,5339461110,5339461111,5339461112,5339470000,5339470001,53393631012,53393631013,53393631102,53393631103,53393631112,53393631113,53393720200,53393720202,53393720203,53393720230,53393720232,53394611130,53394611131,53394611211,53394611300,53394700020,53394700021,53394700030,53394700031,
068,00,Ⱦͻ/,502298437,128362500,502551562,128587500,0,0,1,6,19,50,53394412,533944012,533944013,533944031,533944033,533944102,533944103,5339342323,5339343223,5339343230,5339343232,5339440101,5339440102,5339440103,5339440301,5339440303,5339440321,5339440323,5339441001,5339441003,5339441010,5339441012,5339442111,5339443000,5339443001,5339443002,53393423223,53393432212,53393432213,53393432221,53393432223,53393432330,53393432332,53394400131,53394400133,53394400311,53394400313,53394400331,53394400333,53394401001,53394401002,53394401003,53394403000,53394403001,53394403003,53394403023,53394403201,53394403203,53394403221,53394403222,53394403223,53394410001,53394410003,53394410021,53394410023,53394410112,53394410130,53394410132,53394410133,53394413022,53394413200,53394413202,53394413220,53394421011,53394421100,53394421101,53394421103,53394421130,53394421131,53394421133,53394430030,53394430031,53394430032,53394430100,53394430101,53394430102,
068,01,ʬ/Ω,501918750,128400000,502340625,128681250,0,0,2,12,29,97,53394331,53394402,533943102,533943120,533943122,533943123,533943131,533943132,533943133,533943301,533943303,533944200,533944202,533944220,5339430113,5339430131,5339430133,5339430331,5339431002,5339431003,5339431210,5339431212,5339431301,5339431302,5339431303,5339432133,5339433000,5339433021,5339433022,5339433023,5339433201,5339433210,5339433211,5339433213,5339433300,5339433302,5339433311,5339433313,5339440022,5339440023,5339442010,5339442012,5339442210,53394301113,53394301301,53394301302,53394301303,53394301320,53394301321,53394303111,53394303113,53394303131,53394303132,53394303133,53394303331,53394303333,53394310001,53394310002,53394310003,53394310012,53394310013,53394310100,53394310102,53394310120,53394310122,53394310300,53394310302,53394310320,53394310322,53394311222,53394311223,53394311232,53394311333,53394312132,53394313000,53394313001,53394313003,53394321111,53394321112,53394321113,53394321131,53394321322,53394321323,53394330010,53394330011,53394330013,53394330031,53394330033,53394330202,53394330203,53394332000,53394332001,53394332003,53394332120,53394332121,53394332311,53394333010,53394333011,53394333012,53394333030,53394333032,53394333100,53394333101,53394333103,53394333121,53394333123,53394333200,53394333201,53394333301,53394333310,53394333311,53394400203,53394400312,53394400320,53394400322,53394400330,53394400332,53394403002,53394403020,53394403021,53394403022,53394403200,53394403202,53394403220,53394420110,53394420112,53394420130,53394420132,53394420300,53394420301,53394420302,53394420310,53394420320,53394420322,53394422120,53394422121,53394422122,53394422200,53394422201,53394422202,
068,02,,501539062,128634375,502368750,129234375,0,1,14,29,68,171,5339532,53395231,53395303,53395311,53395312,53395313,53395330,53395331,53395332,53395402,53396300,53396301,53396303,53396310,53396312,533944223,533952301,533952303,533952321,533952330,533952331,533952333,533953021,533953022,533953023,533953101,533953103,533953330,533954000,533954001,533954002,533954010,533954200,533954201,533954203,533962111,533962113,533963020,533963021,533963023,533963201,533963210,533963211,533963212,5339433230,5339433232,5339433233,5339433321,5339433322,5339433323,5339433332,5339433333,5339442221,5339442222,5339442223,5339442322,5339523021,5339523023,5339523201,5339523321,5339523323,5339530021,5339530023,5339530032,5339530033,5339530122,5339530123,5339530132,5339530133,5339530203,5339531003,5339531021,5339531022,5339531023,5339533310,5339533311,5339533312,5339533320,5339533321,5339533322,5339533330,5339540121,5339540302,5339540320,5339540322,5339542020,5339542021,5339542100,5339542102,5339542103,5339542120,5339542122,5339542211,5339621101,5339621103,5339621121,5339621123,5339621301,5339621310,5339621311,5339630220,5339630221,5339630223,5339631100,5339631102,5339632031,5339632130,5339633000,5339633001,5339633010,5339633011,5339633013,53394332122,53394332123,53394332213,53394332231,53394332233,53394332310,53394332312,53394332313,53394333013,53394333031,53394333033,53394333102,53394333120,53394333122,53394333202,53394333203,53394333300,53394333302,53394333303,53394333312,53394333313,53394422123,53394422132,53394422203,53394423202,53394423232,53395212323,53395212332,53395213233,53395213322,53395213323,53395213332,53395213333,53395230013,53395230031,53395230032,53395230033,53395230221,53395230223,53395232001,53395232003,53395232030,53395232031,53395232033,53395232300,53395232301,53395232311,53395233200,53395233201,53395233203,53395233221,53395233223,53395300301,53395300302,53395300303,53395300310,53395300312,53395300313,53395301202,53395301203,53395301212,53395301213,53395301302,53395301303,53395301312,53395301313,53395302011,53395302013,53395302022,53395302023,53395310011,53395310012,53395310013,53395310021,53395310023,53395310201,53395310202,53395310203,53395333130,53395333132,53395333230,53395333231,53395333232,53395333320,53395400302,53395400310,53395400311,53395400320,53395400322,53395400323,53395401200,53395401201,53395401203,53395403000,53395403002,53395403003,53395403030,53395403032,53395403033,53395403210,53395403211,53395403212,53395420220,53395420221,53395420222,53395420230,53395420231,53395421010,53395421012,53395421013,53395421210,53395421212,53395421230,53395421231,53395422101,53395423000,53395423002,53395423020,53396211001,53396211003,53396211021,53396211023,53396211201,53396211203,53396213131,53396213133,53396213311,53396311010,53396311012,53396311030,53396311032,53396311200,53396311201,53396311202,53396311220,53396311222,53396313000,53396313020,53396313022,53396313200,53396313202,53396313220,53396320011,53396320013,53396320031,53396320301,53396320303,53396320330,53396320331,53396320333,53396321310,53396321311,53396321312,53396321320,53396321321,53396321322,53396321330,53396322111,53396323000,53396323001,53396323010,53396323011,53396330020,53396330021,53396330030,53396330120,53396330121,53396330123,53396330200,53396330310,53396330311,
069,00,ǽ/,500765625,128934375,501848437,129571875,0,7,12,19,85,148,5339612,5339613,5339620,5339622,5339623,5339711,5339720,53396103,53396111,53396112,53396113,53396210,53396212,53397100,53397101,53397210,53397212,53397220,53397221,533952322,533960133,533961013,533961022,533961023,533961102,533961103,533962132,533963202,533963220,533963222,533970111,533971031,533971033,533971311,533972110,533972130,533972132,533972230,5339522313,5339522331,5339522332,5339522333,5339523202,5339523232,5339523233,5339601303,5339601312,5339601313,5339601321,5339603111,5339603113,5339603131,5339603133,5339603311,5339603313,5339603331,5339603333,5339610113,5339610121,5339610123,5339610202,5339610203,5339610211,5339610212,5339610213,5339611001,5339611002,5339611003,5339611012,5339621122,5339621300,5339621302,5339621303,5339621312,5339621330,5339621332,5339621333,5339630222,5339632000,5339632002,5339632032,5339632210,5339632212,5339701101,5339701103,5339701131,5339710211,5339710300,5339710301,5339710303,5339712111,5339712113,5339713000,5339713001,5339713010,5339713100,5339713101,5339713103,5339713121,5339713130,5339713131,5339713133,5339721110,5339721111,5339721113,5339721120,5339721122,5339721123,5339721312,5339721330,5339721332,5339722200,5339722201,5339722210,5339722211,5339722310,5339723000,5339723001,5339723002,5339723020,5339723100,5339723101,5339730000,53395133232,53395133233,53395133322,53395133323,53395133332,53395133333,53395222222,53395222223,53395222232,53395222233,53395222322,53395222323,53395223112,53395223113,53395223121,53395223123,53395223222,53395223223,53395223231,53395223232,53395223233,53395223301,53395223303,53395232032,53395232302,53395232303,53395232310,53395232312,53395232313,53395233202,53395233220,53395233222,53396013231,53396031100,53396031101,53396031103,53396031121,53396031123,53396033103,53396033121,53396033123,53396033301,53396033303,53396033321,53396033322,53396033323,53396100333,53396101113,53396101123,53396101221,53396101222,53396101223,53396102013,53396102102,53396102103,53396110001,53396110002,53396110003,53396110102,53396110103,53396110113,53396110131,53396110132,53396110133,53396211000,53396211002,53396211020,53396211022,53396211200,53396211202,53396213130,53396213132,53396213310,53396213312,53396213313,53396320010,53396320012,53396320030,53396320032,53396320033,53396320300,53396320302,53396320332,53396322110,53396322112,53397011300,53397011301,53397011331,53397102100,53397102101,53397102103,53397103020,53397103021,53397103211,53397103213,53397103231,53397121100,53397121101,53397121103,53397121121,53397121123,53397130020,53397130021,53397130030,53397130031,53397130110,53397130120,53397131021,53397131023,53397131321,53397133111,53397211121,53397211123,53397211210,53397211212,53397213102,53397213103,53397222130,53397222131,53397222133,53397222311,53397223110,53397223111,53397223112,53397223120,53397223121,53397223200,53397223201,53397223210,53397230030,53397230032,53397230100,53397230101,53397230102,53397230110,53397230111,53397230113,53397230131,53397230210,53397230220,53397230222,53397231020,53397231021,53397231023,53397231030,53397231032,53397300010,53397300020,
070,00,/쾾,500948437,129018750,502453125,129993750,1,5,26,60,140,320,543902,5339731,5339732,5339733,5439011,5439030,53396331,53396332,53396333,53396402,53396420,53396422,53397132,53397232,53397233,53397301,53397302,53397303,53397400,53397402,54390103,54390130,54390131,54390133,54390310,54390311,54390312,54390320,54390321,54390322,54390330,54390403,533963131,533963133,533963223,533963231,533963232,533963233,533964003,533964212,533964230,533971302,533971303,533971330,533971332,533971333,533972113,533972222,533972233,533972303,533972311,533972312,533972313,533973001,533973002,533973003,533974200,533974202,533974220,543901011,543901013,543901210,543901211,543901213,543901230,543901231,543901232,543901321,543903130,543903131,543903132,543903230,543903231,543903310,543903320,543903321,543904000,543904002,543904003,543904012,543904020,543904021,543912001,543912010,543912011,543912013,543912100,543912110,543912111,543912112,543913000,543913001,5339631112,5339631121,5339631123,5339631130,5339631132,5339631133,5339631301,5339631303,5339631321,5339631323,5339632213,5339632302,5339632303,5339633021,5339633022,5339633023,5339633030,5339633032,5339633033,5339640021,5339640022,5339640023,5339640300,5339640322,5339640323,5339642100,5339642102,5339642130,5339642320,5339642322,5339712131,5339712132,5339712133,5339712310,5339712311,5339712313,5339712331,5339712333,5339713013,5339713120,5339713122,5339713123,5339713310,5339713312,5339713313,5339721311,5339721313,5339721331,5339721333,5339722202,5339722203,5339722212,5339722230,5339722232,5339722233,5339722313,5339722322,5339722323,5339723012,5339723023,5339730003,5339740100,5339740102,5339740120,5339740122,5339740300,5339740302,5339740320,5339742010,5339742012,5339742030,5339742220,5339742222,5439010101,5439010103,5439010121,5439010122,5439010123,5439012120,5439012121,5439012123,5439012330,5439012331,5439012332,5439013200,5439013201,5439013231,5439013233,5439031330,5439031331,5439031332,5439032320,5439032322,5439033110,5439033112,5439033120,5439033121,5439033122,5439033130,5439033220,5439033221,5439033223,5439033230,5439033232,5439040010,5439040012,5439040130,5439040132,5439040133,5439040231,5439040233,5439042011,5439042013,5439042031,5439042100,5439042101,5439042102,5439110100,5439110101,5439110110,5439111011,5439111100,5439120001,5439120121,5439120123,5439121010,5439121011,5439121012,5439121020,5439121022,5439121030,5439121130,5439121131,5439130020,5439130021,5439130030,5439130031,5439130032,5439130100,5439130102,53396311031,53396311033,53396311203,53396311221,53396311223,53396311310,53396311312,53396311313,53396313001,53396313002,53396313003,53396313021,53396313023,53396313201,53396313203,53396313221,53396313222,53396313223,53396321313,53396321323,53396321331,53396321332,53396321333,53396322113,53396323002,53396323003,53396323012,53396323013,53396330022,53396330023,53396330031,53396330032,53396330033,53396330122,53396330201,53396330202,53396330203,53396330312,53396330313,53396400033,53396400121,53396400122,53396400123,53396400130,53396400132,53396400201,53396400202,53396400203,53396401222,53396403020,53396403021,53396403200,53396403202,53396403203,53396403212,53396403213,53396403302,53396403320,53396403322,53396421010,53396421011,53396421012,53396421030,53396421032,53396421033,53396421100,53396421320,53396421322,53396423100,53396423102,53396423120,53396423122,53396423210,53396423212,53396423230,53396423232,53397121301,53397121302,53397121303,53397123011,53397123013,53397123120,53397123121,53397123123,53397123233,53397123301,53397123303,53397123321,53397123322,53397123323,53397130022,53397130023,53397130032,53397130033,53397130111,53397130112,53397130113,53397130121,53397130122,53397130123,53397131020,53397131022,53397131320,53397131322,53397131323,53397133110,53397133112,53397133113,53397211120,53397211122,53397211211,53397211213,53397213100,53397213101,53397222132,53397222310,53397222312,53397222313,53397223113,53397223122,53397223123,53397223202,53397223203,53397223211,53397223212,53397223213,53397230031,53397230033,53397230103,53397230112,53397230130,53397230132,53397230133,53397230211,53397230212,53397230213,53397230221,53397230223,53397231022,53397231031,53397231033,53397300011,53397300012,53397300013,53397300021,53397300022,53397300023,53397401010,53397401012,53397401030,53397401032,53397401210,53397401212,53397401230,53397401232,53397403010,53397403220,53397403221,53397420110,53397420320,53397422210,53397422212,53397422232,53397422233,54390100331,54390100333,54390101023,54390101201,54390101202,54390101203,54390102111,54390102113,54390102131,54390102331,54390102333,54390120111,54390121221,54390121222,54390121223,54390122311,54390122313,54390122331,54390122333,54390123330,54390123331,54390123332,54390132020,54390132021,54390132022,54390132031,54390132033,54390132200,54390132300,54390132301,54390132303,54390132321,54390132323,54390313330,54390313331,54390313332,54390323210,54390323230,54390323232,54390323311,54390331110,54390331112,54390331130,54390331230,54390331231,54390331232,54390331320,54390331321,54390332310,54390332312,54390333000,54390333001,54390333002,54390333020,54390333022,54390400130,54390400132,54390400133,54390401022,54390401023,54390401032,54390401033,54390401101,54390401103,54390401112,54390401121,54390401122,54390401123,54390401130,54390401132,54390401310,54390401312,54390401313,54390402200,54390402201,54390402210,54390402211,54390402300,54390402301,54390402303,54390402323,54390412020,54390412022,54390412200,54390412201,54390412202,54390412220,54390412222,54390420101,54390420103,54390420123,54390420301,54390421030,54390421032,54390421100,54390421101,54390421102,54390421110,54390421111,54390421200,54390421202,54390430000,54391100111,54391100113,54391101020,54391101021,54391101030,54391110101,54391110103,54391111010,54391111011,54391111012,54391111100,54391111101,54391111110,54391111111,54391200001,54391200030,54391200031,54391200033,54391200301,54391200303,54391200310,54391200311,54391200312,54391201200,54391203010,54391203011,54391203100,54391203101,54391203103,54391203110,54391203111,54391203112,54391210130,54391210131,54391210133,54391210210,54391210211,54391210213,54391210311,54391210313,54391211320,54391211321,54391212000,54391300220,54391300221,54391300230,54391300231,54391300233,54391300330,54391301010,54391301012,54391301030,54391301032,54391301200,
070,01,¸/ī/ٻθ,502129687,128700000,502762500,129187500,0,0,4,27,50,140,53395430,53395431,53395432,53396410,533954013,533954031,533954033,533954120,533954122,533954123,533954131,533954132,533954133,533954211,533954213,533954220,533954222,533954223,533954231,533954232,533954233,533954330,533954331,533954332,533955200,533964010,533964011,533964013,533964031,533964110,533964120,5339533331,5339533333,5339540033,5339540110,5339540112,5339540113,5339540122,5339540123,5339540301,5339540323,5339541020,5339541022,5339541023,5339541133,5339541210,5339541212,5339541213,5339541302,5339541303,5339542212,5339542213,5339542301,5339542303,5339543330,5339543331,5339543332,5339550220,5339550222,5339550223,5339552020,5339631110,5339631111,5339631113,5339640000,5339640001,5339640002,5339640010,5339640011,5339640120,5339640121,5339640123,5339640301,5339640303,5339640331,5339640333,5339641120,5339641210,5339641220,5339641221,5339642112,53395333131,53395333133,53395333233,53395333321,53395333322,53395333323,53395400300,53395400301,53395400303,53395400312,53395400313,53395400321,53395401110,53395401112,53395401113,53395401202,53395403001,53395403031,53395403213,53395410020,53395410022,53395410210,53395410212,53395410213,53395410320,53395410322,53395410323,53395411230,53395411232,53395411233,53395411312,53395411313,53395411322,53395411323,53395412110,53395412112,53395412113,53395413002,53395413011,53395413012,53395413013,53395420223,53395420232,53395420233,53395421011,53395421211,53395421213,53395421232,53395421233,53395422100,53395422102,53395422103,53395423001,53395423003,53395423021,53395423022,53395423023,53395433330,53395433332,53395500202,53395500220,53395500222,53395502000,53395502002,53395502020,53395502022,53395502023,53395502210,53395502212,53395502213,53395502320,53395502322,53395520100,53395520102,53395520103,53395520110,53395520112,53395520113,53395520120,53395520121,53395520122,53395520130,53395520210,53395520211,53395520213,53395520220,53395520221,53395520222,53395520231,53395520233,53395520300,53395520302,53395520320,53395522000,53395522002,53395522020,53395522022,53396311011,53396311013,53396311311,53396400030,53396400031,53396400032,53396400120,53396400131,53396400133,53396400200,53396401220,53396401221,53396401223,53396403022,53396403023,53396403201,53396403210,53396403211,53396403300,53396403301,53396403303,53396403321,53396403323,53396411100,53396411120,53396411210,53396411220,53396412110,53396412111,53396412112,53396412120,53396412121,53396412122,53396412300,53396412302,53396421013,53396421031,53396421101,53396421102,53396421103,53396421110,53396421111,53396421112,
071,00,,502228125,129131250,503001562,129740625,0,2,15,17,66,170,5339741,5339743,53396430,53396432,53396433,53396522,53396523,53397421,53397423,53397500,53397501,53397502,53397520,53397522,53397523,54390410,54390411,533964233,533965320,533965321,533965322,533974011,533974013,533974031,533974033,533974221,533974223,533975030,533975031,533975032,533975212,533975213,543905000,543905002,5339641222,5339641223,5339641232,5339641233,5339642113,5339642131,5339642133,5339642311,5339642313,5339652023,5339652032,5339652033,5339652122,5339652123,5339652132,5339652133,5339653022,5339653023,5339653032,5339653033,5339653230,5339653231,5339653232,5339740303,5339740321,5339740323,5339742013,5339742031,5339742033,5339750330,5339750332,5339751000,5339751001,5339751002,5339751020,5339752100,5339752101,5339752102,5339753020,5339753022,5339753200,5339753202,5339753220,5339753222,5439040011,5439040100,5439040101,5439041200,5439041201,5439041210,5439041211,5439041300,5439041301,5439041303,5439041310,5439041311,5439050010,5439050011,5439050012,5439050030,5439050032,5439050100,5439050101,5439050200,5439050201,5439050210,53396413220,53396413222,53396421113,53396421321,53396421323,53396423101,53396423103,53396423121,53396423123,53396423211,53396423213,53396423231,53396423233,53396431000,53396431002,53396431020,53396431022,53396431200,53396431202,53396431220,53396431222,53396431223,53396431232,53396431233,53396431322,53396431323,53396431332,53396431333,53396520212,53396520213,53396520221,53396520222,53396520223,53396520302,53396520303,53396520312,53396520313,53396521202,53396521203,53396521212,53396521213,53396521302,53396521303,53396521312,53396521313,53396530202,53396530203,53396530212,53396530213,53396530302,53396530303,53396530312,53396530313,53396531202,53396531220,53396531222,53396533000,53396533002,53396533020,53396533022,53396533200,53397401011,53397401013,53397401031,53397401033,53397401211,53397401213,53397401231,53397401233,53397403011,53397403012,53397403013,53397403222,53397403223,53397420111,53397420112,53397420113,53397420321,53397420322,53397420323,53397422211,53397422213,53397422230,53397422231,53397503310,53397503311,53397503312,53397503330,53397503332,53397510030,53397510032,53397510210,53397510220,53397510222,53397512000,53397512002,53397512020,53397512022,53397512200,53397521030,53397521032,53397521033,53397521100,53397521101,53397521102,53397530210,53397530212,53397530230,53397530232,53397532010,53397532012,53397532030,53397532032,53397532210,53397532212,53397532230,53397532232,54390400131,54390401020,54390401021,54390401030,54390401031,54390401100,54390401102,54390401110,54390401111,54390401113,54390401120,54390401131,54390401133,54390401311,54390412021,54390412023,54390412030,54390412031,54390412032,54390412120,54390412203,54390412210,54390412212,54390412221,54390412230,54390413021,54390413023,54390413120,54390413122,54390500130,54390500131,54390500132,54390500310,54390500312,54390500330,54390500332,54390501020,54390501021,54390501030,54390501031,54390501100,54390501101,54390501110,54390501111,54390502030,54390502031,54390502110,54390502112,54390502120,54390502121,54390502130,54390510000,54390510001,
071,01,,502495312,128868750,503071875,129253125,0,0,3,22,42,109,53396500,53396502,53396503,533955212,533955213,533955221,533955222,533955223,533964113,533964130,533964131,533964133,533964311,533965010,533965012,533965013,533965122,533965123,533965200,533965201,533965210,533965211,533965300,533965301,533965310,5339552031,5339552033,5339552102,5339552103,5339552112,5339552113,5339552201,5339552203,5339552300,5339552301,5339552302,5339552310,5339552320,5339552322,5339553002,5339553020,5339641111,5339641113,5339641123,5339641213,5339641231,5339641320,5339641321,5339641323,5339643101,5339643103,5339643121,5339643130,5339643131,5339650112,5339651022,5339651200,5339651202,5339651203,5339651212,5339651213,5339651322,5339652020,5339653112,5339653121,5339653123,5339653130,53395433331,53395433333,53395520123,53395520131,53395520132,53395520133,53395520212,53395520223,53395520230,53395520232,53395520301,53395520303,53395520321,53395520322,53395520323,53395522001,53395522003,53395522021,53395522023,53395523030,53395523032,53395523110,53395523111,53395523230,53395523232,53395530210,53395530212,53395530220,53395530221,53395530230,53396411101,53396411102,53396411103,53396411121,53396411122,53396411123,53396411211,53396411212,53396411213,53396411221,53396411222,53396411223,53396412113,53396412123,53396412301,53396412303,53396413221,53396413223,53396431001,53396431003,53396431021,53396431023,53396431201,53396431203,53396431221,53396431230,53396431231,53396431320,53396431321,53396431330,53396431331,53396501100,53396501102,53396501103,53396510202,53396510203,53396512010,53396512012,53396512013,53396513202,53396513232,53396513233,53396520210,53396520211,53396520220,53396520300,53396520301,53396520310,53396520311,53396521200,53396521201,53396521210,53396521211,53396521300,53396521301,53396521310,53396521311,53396530200,53396530201,53396530210,53396530211,53396530300,53396530301,53396530310,53396530311,53396531100,53396531102,53396531200,53396531201,53396531203,53396531221,53396531223,53396531320,53396531322,53396533001,53396533003,53396533010,53396533012,53396533021,
071,02,,502790625,128793750,503240625,129187500,0,0,4,15,28,79,53395531,53395532,53395533,53396511,533955233,533955301,533955303,533956220,533956222,533956223,533965100,533965101,533965103,533965130,533965131,533965133,533966000,533966002,533966020,5339551323,5339551331,5339551332,5339551333,5339552312,5339552313,5339552321,5339553003,5339560222,5339562000,5339562022,5339562212,5339650111,5339650113,5339651021,5339651023,5339651210,5339651211,5339651321,5339653111,5339653113,5339660010,5339660011,5339660012,5339660030,5339660220,5339660221,5339660222,53395512323,53395512332,53395512333,53395513121,53395513123,53395513130,53395513132,53395513222,53395513223,53395513301,53395513303,53395523031,53395523033,53395523112,53395523113,53395523231,53395523233,53395530013,53395530211,53395530213,53395530222,53395530223,53395530231,53395530232,53395530233,53395602202,53395602232,53395620010,53395620011,53395620012,53395620020,53395620021,53395620022,53395620200,53395620202,53395620232,53395620233,53395622100,53395622102,53395622103,53395622130,53395622132,53395622133,53395623022,53395623200,53395623201,53395623202,53396501101,53396510200,53396510201,53396512011,53396513200,53396513201,53396513203,53396513230,53396513231,53396531101,53396531103,53396600130,53396600131,53396600132,53396600310,53396600312,53396600320,53396600321,53396600322,53396602100,53396602102,53396602120,53396602122,53396602230,53396602231,53396602232,53396602300,53396602301,53396620000,53396620001,53396620002,53396620020,
072,00,/,503170312,128803125,503648437,129121875,0,0,5,14,37,81,53395632,53395633,53396601,53396610,53396611,533956231,533956233,533956303,533956311,533956312,533956313,533957200,533957202,533957220,533957222,533966121,533967000,533967002,533967020,5339562121,5339562122,5339562123,5339562130,5339562132,5339562133,5339562211,5339562300,5339562301,5339562303,5339562321,5339562322,5339562323,5339563010,5339563012,5339563013,5339563022,5339563023,5339563101,5339563102,5339563103,5339570221,5339570223,5339660033,5339660211,5339660301,5339661200,5339661201,5339661203,5339661300,5339661301,5339661310,5339661311,5339661313,5339670032,5339670210,5339670212,53395613232,53395613233,53395613322,53395620333,53395621201,53395621202,53395621203,53395621312,53395621313,53395622131,53395623020,53395623021,53395623023,53395623203,53395630011,53395630013,53395630031,53395630033,53395630202,53395630203,53395630211,53395630213,53395702022,53395702023,53395702200,53395702201,53395702203,53395702300,53395702302,53395702320,53395702322,53395720100,53395720102,53395720120,53395720122,53395720300,53395720302,53395720320,53395720322,53395722100,53395722102,53396600133,53396600311,53396600313,53396600323,53396602101,53396602103,53396602121,53396602123,53396602130,53396603000,53396603001,53396603003,53396603100,53396603101,53396603111,53396603113,53396612210,53396612211,53396612300,53396612301,53396612310,53396612311,53396613020,53396613021,53396613030,53396613031,53396613120,53396613121,53396613123,53396700100,53396700102,53396700120,53396700122,53396700300,53396700302,53396700303,53396702112,53396702130,53396702132,53396702200,
072,01,״/,502157812,129571875,503339062,130340625,0,5,19,39,83,221,5439052,5439141,5439143,5439150,5439152,54390431,54390432,54390433,54390503,54390511,54390512,54390513,54390530,54390531,54390532,54390600,54390602,54390620,54391403,54391421,54391423,54391510,54392410,54392501,543904123,543904132,543904133,543904301,543904302,543904303,543905012,543905013,543905022,543905023,543905101,543905102,543905103,543905330,543905331,543906032,543906220,543906221,543914203,543914221,543914222,543914223,543915120,543915121,543915122,543915300,543915302,543924000,543924001,543924010,543924011,543924013,543924110,543924111,543924112,543924121,543925000,543925001,543925003,5339753232,5339753233,5339753322,5339753323,5339753332,5339753333,5339762222,5439041213,5439041313,5439042323,5439042331,5439042332,5439042333,5439043001,5439043002,5439043003,5439050112,5439050113,5439050202,5439051001,5439051002,5439051003,5439053320,5439053321,5439053322,5439053330,5439053331,5439060302,5439060330,5439060332,5439062100,5439062101,5439062102,5439062120,5439062220,5439133333,5439140110,5439140111,5439140113,5439140121,5439140123,5439140131,5439140132,5439140133,5439142011,5439142013,5439142202,5439142203,5439151100,5439151102,5439151120,5439151122,5439151230,5439151231,5439151232,5439151300,5439153010,5439153200,5439153202,5439153220,5439231111,5439240020,5439240021,5439240030,5439240031,5439240120,5439240121,5439240311,5439241130,5439241131,5439241200,5439241201,5439241231,5439241300,5439241301,5439241302,5439250020,5439250021,5439250023,5439250301,5439250303,5439250310,5439250311,53397532231,53397532233,53397532302,53397532303,53397622230,53397622232,54390412033,54390412121,54390412122,54390412123,54390412211,54390412213,54390412223,54390412231,54390412232,54390412233,54390413020,54390413022,54390413121,54390413123,54390421113,54390421131,54390421133,54390421311,54390421313,54390421333,54390423111,54390423113,54390423131,54390423132,54390423133,54390423212,54390423213,54390423301,54390423302,54390423303,54390430001,54390430002,54390430003,54390500133,54390500311,54390500313,54390500331,54390500333,54390501022,54390501023,54390501032,54390501033,54390501102,54390501103,54390501112,54390501113,54390502032,54390502033,54390502111,54390502113,54390502122,54390502123,54390502131,54390502132,54390502133,54390510002,54390510003,54390533230,54390533231,54390533320,54390533321,54390533330,54390533331,54390601000,54390601002,54390601020,54390601022,54390601200,54390601202,54390603002,54390603032,54390603033,54390603122,54390603123,54390603132,54390603133,54390603310,54390603311,54390603312,54390603330,54390612022,54390621030,54390621031,54390621032,54390621100,54390621101,54390621102,54390621210,54390621212,54390621220,54390621221,54390621222,54390622210,54390622211,54390622220,54390622300,54390622301,54390622310,54390622311,54390622313,54390622331,54390622333,54391333113,54391333131,54391333133,54391333311,54391333313,54391333323,54391401010,54391401011,54391401013,54391401120,54391401121,54391401123,54391401222,54391401223,54391401301,54391401302,54391401303,54391402111,54391402113,54391402131,54391420122,54391420123,54391422002,54391422003,54391422011,54391422012,54391422013,54391512330,54391512331,54391513020,54391513021,54391513022,54391530120,54391530122,54391530300,54391532220,54391532221,54391532222,54392311101,54392311103,54392311121,54392311130,54392311131,54392311133,54392311311,54392311313,54392311331,54392400220,54392400221,54392400223,54392400230,54392400231,54392400232,54392400320,54392400321,54392400330,54392400331,54392401220,54392401221,54392401230,54392401231,54392401233,54392403100,54392403101,54392403131,54392411320,54392411321,54392411322,54392411330,54392412020,54392412021,54392412030,54392412031,54392412033,54392412301,54392412331,54392413030,54392413031,54392413032,54392413100,54392413200,54392413201,54392413202,54392502011,54392502100,54392502101,54392502110,54392502111,54392503000,54392503001,54392503003,54392503021,54392503023,54392503120,54392503121,54392503122,54392503130,54392503131,54392503201,54392503202,54392503203,54392503210,54392503211,54392503220,54392503300,54392510000,54392510002,54392510020,54392510022,54392510200,54392510202,54392510220,54392510222,
072,02,/ë,502804687,129075000,503634375,129703125,0,1,13,32,64,135,5339760,53396621,53396622,53396623,53396630,53396631,53396632,53397511,53397513,53397531,53397610,53397620,53397621,53397623,533965331,533965333,533966032,533966033,533966132,533966133,533966201,533966202,533966203,533966330,533966331,533966332,533967200,533975101,533975103,533975121,533975123,533975300,533975301,533975303,533975321,533975330,533975331,533976110,533976120,533976122,533976220,533976221,533976223,533976300,543906011,543906013,5339653131,5339653133,5339653233,5339653303,5339653321,5339653322,5339653323,5339660231,5339660232,5339660233,5339660302,5339660303,5339660312,5339660313,5339661202,5339661220,5339661222,5339661223,5339661232,5339661233,5339662001,5339662003,5339663330,5339663332,5339670221,5339670222,5339670223,5339672020,5339672021,5339672022,5339751023,5339751201,5339751203,5339751221,5339751222,5339751223,5339752111,5339752112,5339752113,5339753231,5339753320,5339753321,5339753330,5339753331,5339761110,5339761120,5339761210,5339761212,5339761230,5339761232,5339762220,5339762221,5339763020,5339763021,5339763022,5339763200,5439060101,5439060103,5439060121,5439060122,5439060123,5439060301,5439060310,5439060311,53396531321,53396531323,53396533011,53396533013,53396533023,53396533201,53396533202,53396533203,53396602131,53396602132,53396602133,53396602233,53396602302,53396602303,53396603002,53396603102,53396603103,53396603110,53396603112,53396612212,53396612213,53396612302,53396612303,53396612312,53396612313,53396613022,53396613023,53396613032,53396613033,53396613122,53396620003,53396620021,53396620022,53396620023,53396633310,53396633311,53396633312,53396633330,53396633332,53396702201,53396702202,53396702203,53396702300,53396702301,53396702302,53396702320,53396702322,53396720100,53396720102,53396720120,53396720230,53396722000,53396722001,53396722002,53396722020,53397503313,53397503331,53397503333,53397510031,53397510033,53397510211,53397510212,53397510213,53397510221,53397510223,53397512001,53397512003,53397512021,53397512023,53397512201,53397512202,53397512203,53397521031,53397521103,53397530211,53397530213,53397530231,53397530233,53397532011,53397532013,53397532031,53397532033,53397532211,53397532213,53397532300,53397532301,53397611120,53397611122,53397611210,53397611211,53397611220,53397611221,53397612110,53397612111,53397612112,53397612130,53397612132,53397622231,53397622233,53397630100,53397630101,53397630102,53397630230,53397630231,53397630232,53397632020,53397632021,53397632022,53397632222,54390601001,54390601003,54390601021,54390601023,54390601201,54390601203,54390603000,54390603001,54390603003,54390603030,54390603031,54390603120,54390603121,54390603130,54390603131,54390610000,54390610002,54390610020,54390610022,54390610200,54390610202,54390610220,54390610222,54390612000,54390612002,54390612020,
073,00,ë/ë,500315625,129721875,502425000,130575000,0,9,25,64,168,310,5439122,5439123,5439131,5439132,5439210,5439211,5439212,5439220,5439221,54390422,54391030,54391033,54391122,54391123,54391131,54391132,54391133,54391213,54391302,54391303,54391330,54391331,54391332,54391400,54392011,54392013,54392130,54392131,54392132,54392220,54392231,54392300,54392301,54392302,543903331,543903332,543903333,543904200,543904202,543904230,543910002,543910003,543910020,543910021,543910030,543910312,543910321,543910323,543911132,543911133,543911212,543911213,543911302,543911303,543912022,543912023,543912032,543912033,543912121,543912122,543912123,543913011,543913013,543913330,543913332,543914020,543914022,543914023,543914200,543914202,543920101,543920103,543920121,543920310,543920311,543920313,543920331,543921330,543921331,543922210,543922211,543922212,543922300,543922301,543922331,543923030,543923031,543923100,543923101,543923102,543923110,543923200,543923201,543931000,543931001,543931003,543931010,543931011,5438171131,5438171133,5438171310,5438171311,5439032330,5439032332,5439032333,5439033131,5439033133,5439033222,5439033233,5439033301,5439033303,5439040222,5439040223,5439042032,5439042033,5439042112,5439042121,5439042122,5439042123,5439042130,5439042132,5439042310,5439042312,5439042320,5439042322,5439100120,5439100122,5439100123,5439100220,5439100221,5439100230,5439100231,5439100232,5439100312,5439100320,5439100321,5439100330,5439100333,5439101221,5439101222,5439101223,5439101230,5439101232,5439101233,5439102111,5439102112,5439102113,5439102130,5439102131,5439102133,5439103102,5439103132,5439103133,5439103201,5439103203,5439103221,5439103223,5439112022,5439112023,5439112031,5439112032,5439112033,5439112101,5439112102,5439112103,5439112110,5439112112,5439112113,5439113002,5439113003,5439113011,5439113012,5439113013,5439120203,5439120211,5439120213,5439120300,5439120302,5439120303,5439120312,5439120313,5439121023,5439121032,5439121033,5439121133,5439121201,5439121202,5439121203,5439130121,5439130122,5439130123,5439133310,5439133312,5439133330,5439140100,5439140102,5439140103,5439140120,5439140210,5439140212,5439142010,5439201001,5439201003,5439201021,5439201023,5439201201,5439201231,5439201233,5439203121,5439203123,5439203330,5439203331,5439203333,5439213320,5439213321,5439213322,5439222130,5439222131,5439222132,5439222200,5439222201,5439222202,5439222210,5439222211,5439222213,5439222300,5439222301,5439222302,5439222310,5439223020,5439223021,5439223030,5439223031,5439223033,5439223211,5439223300,5439223301,5439223303,5439223321,5439230320,5439230321,5439230322,5439230330,5439231030,5439231031,5439231120,5439231121,5439231130,5439231200,5439232020,5439232021,5439232022,5439232100,5439232200,5439301111,5439301113,5439310020,5439310021,5439310023,5439310120,5439310121,5439310122,5439310130,5439311000,5439311001,5439311010,54381711132,54381711133,54381711233,54381711303,54381711321,54381711322,54381711323,54381713011,54381713012,54381713013,54381713130,54381713131,54381713133,54381713311,54390313333,54390323211,54390323212,54390323213,54390323231,54390323233,54390323310,54390323312,54390323313,54390331111,54390331113,54390331131,54390331132,54390331133,54390331233,54390331322,54390331323,54390332311,54390332313,54390333003,54390333021,54390333023,54390402202,54390402203,54390402212,54390402213,54390402302,54390402320,54390402321,54390402322,54390420100,54390420102,54390420120,54390420121,54390420122,54390420300,54390420302,54390420303,54390421031,54390421033,54390421103,54390421112,54390421130,54390421132,54390421201,54390421203,54390421310,54390421312,54390421330,54390421331,54390421332,54390423110,54390423112,54390423130,54390423210,54390423211,54390423300,54391000022,54391000023,54391000032,54391000033,54391001212,54391001322,54391002230,54391002231,54391002233,54391002330,54391002331,54391002332,54391003100,54391003102,54391003220,54391003221,54391003230,54391003231,54391003312,54391003313,54391003320,54391003321,54391003323,54391012032,54391012033,54391012201,54391012202,54391012203,54391012312,54391012313,54391013220,54391013222,54391021101,54391021103,54391021321,54391031000,54391031002,54391031030,54391031032,54391031033,54391031300,54391031302,54391031303,54391031312,54391031313,54391032001,54391032003,54391032221,54391032223,54391112133,54391112311,54391112313,54391112331,54391112333,54391113022,54391113023,54391113032,54391113033,54391113122,54391113123,54391113132,54391113133,54391120213,54391120301,54391120302,54391120303,54391121003,54391121112,54391121113,54391130002,54391130003,54391130012,54391130103,54391200233,54391200322,54391200323,54391200332,54391200333,54391201222,54391201223,54391202011,54391202021,54391202022,54391202023,54391202100,54391202101,54391202103,54391202122,54391202123,54391203012,54391203013,54391203102,54391203113,54391210132,54391210212,54391210310,54391210312,54391211322,54391211323,54391212001,54391212002,54391212003,54391300222,54391300223,54391300232,54391300331,54391300332,54391300333,54391301011,54391301013,54391301031,54391301033,54391301201,54391301202,54391301203,54391333110,54391333111,54391333112,54391333130,54391333132,54391333310,54391333312,54391333320,54391333321,54391333322,54391401012,54391401122,54391401220,54391401221,54391401300,54391402110,54391402112,54391402130,54391402132,54391402133,54391420120,54391420121,54391422000,54391422001,54391422010,54392010001,54392010003,54392010021,54392010023,54392010201,54392012031,54392012033,54392012300,54392012301,54392012303,54392030111,54392030113,54392030131,54392031200,54392031201,54392031203,54392031221,54392033010,54392033011,54392033013,54392033031,54392033033,54392033321,54392133230,54392133300,54392221330,54392221331,54392221332,54392222030,54392222031,54392222120,54392222121,54392222310,54392222311,54392222312,54392223030,54392223031,54392223032,54392223120,54392223121,54392230220,54392230221,54392230321,54392232130,54392232131,54392233020,54392233021,54392233023,54392233201,54392233231,54392233300,54392233301,54392233302,54392233310,54392233320,54392303230,54392303231,54392303232,54392303310,54392303320,54392310320,54392310321,54392310330,54392310331,54392311100,54392311102,54392311120,54392311122,54392311123,54392311132,54392311220,54392311221,54392311230,54392311231,54392311310,54392311312,54392311320,54392311321,54392311330,54392312020,54392320230,54392320231,54392320232,54392320300,54392320301,54392320302,54392321010,54392321020,54392321021,54392322020,54393011311,54393100221,54393101230,54393101231,54393101310,54393101320,54393110020,54393110021,54393110022,
074,00,/Ĺ,499359375,129018750,501440625,130106250,3,7,30,72,156,366,533876,533877,543900,5338663,5338672,5339700,5339702,5339703,5438070,5438071,53386622,53386623,53386702,53386703,53386730,53386732,53386733,53387531,53396022,53396023,53396030,53396032,53397010,53397012,53397013,53397120,53397122,54380601,54380610,54380611,54380613,54380720,54380721,54380730,54380731,54380733,54391010,54391011,54391102,54391103,533865333,533866122,533866123,533866132,533866133,533866211,533866213,533867312,533867313,533875131,533875133,533875331,533960213,533960310,533960312,533960330,533960332,533970112,533971020,533971022,533971023,533971210,533971212,543806001,543806003,543806021,543806121,543806311,543806313,543807220,543807221,543807230,543807231,543807232,543807320,543807321,543807323,543817101,543817110,543901000,543901001,543901002,543901020,543901022,543901200,543901202,543901203,543901220,543901221,543901222,543910001,543910010,543910011,543910121,543910130,543910131,543910133,543910311,543911000,543911002,543911003,543911012,543911013,543911100,543911102,543911103,543911112,543911113,543911120,543911122,543911200,543911201,5338653303,5338653312,5338653313,5338653321,5338653323,5338660323,5338660331,5338660332,5338660333,5338661202,5338661203,5338661212,5338661213,5338661302,5338661303,5338661312,5338661313,5338662101,5338662103,5338662121,5338662122,5338662123,5338670023,5338670030,5338670032,5338670033,5338670132,5338670133,5338671200,5338671202,5338671220,5338671222,5338671223,5338673102,5338751110,5338751111,5338751113,5338751131,5338751133,5338751321,5338751323,5338753013,5338753031,5338753033,5338753301,5338753331,5338753333,5339601322,5339602020,5339602022,5339602113,5339602122,5339602123,5339603130,5339603132,5339701100,5339701102,5339701132,5339710212,5339710213,5339710320,5339710322,5339712300,5339712302,5339712303,5339712320,5339712321,5339712322,5438060000,5438060001,5438060003,5438060021,5438060300,5438060311,5438061200,5438061201,5438061231,5438063101,5438063103,5438063121,5438063311,5438072221,5438072230,5438072231,5438072330,5438072331,5438073220,5438073221,5438073223,5438171031,5438171110,5438171111,5438171112,5438171120,5438171121,5438171122,5438171300,5438171302,5439010030,5439010031,5439010032,5439010100,5439010210,5439010212,5439010230,5439010231,5439010232,5439012010,5439012012,5439012013,5439012230,5439012232,5439013221,5439013222,5439013223,5439100000,5439100001,5439100130,5439100131,5439100133,5439100311,5439100313,5439101200,5439101201,5439101202,5439101320,5439101321,5439101323,5439103101,5439110010,5439110012,5439110013,5439110111,5439110112,5439110113,5439111012,5439111013,5439111102,5439111103,5439111112,5439111113,5439111210,5439111211,5439111212,5439111230,5439111232,5439111300,5439111301,5439111310,5439111311,5439112020,5439120002,5439120020,5439120021,5439120022,5439120200,53386533013,53386533102,53386533103,53386533111,53386533112,53386533113,53386603113,53386603131,53386603133,53386603213,53386603301,53386603302,53386603303,53386611233,53386611322,53386612002,53386612003,53386612012,53386612103,53386612112,53386612113,53386613011,53386613013,53386613100,53386613102,53386613103,53386613111,53386613112,53386613113,53386620232,53386620233,53386620322,53386620323,53386620332,53386620333,53386700121,53386700123,53386700212,53386700213,53386700221,53386700222,53386700223,53386700310,53386700312,53386700313,53386701220,53386701222,53386701223,53386701232,53386701233,53386701312,53386710222,53386710223,53386712212,53386712213,53386712322,53386731032,53386731033,53386731121,53386731122,53386731123,53386731130,53386731132,53386731133,53387511010,53387511011,53387511121,53387511123,53387511301,53387511303,53387511321,53387511322,53387511323,53387512333,53387513011,53387513013,53387513031,53387513032,53387513033,53387513221,53387513222,53387513223,53387530111,53387530112,53387530113,53387533001,53387533002,53387533003,53387533021,53387533030,53387533031,53387533033,53387533300,53387533301,53387533303,53396012222,53396012223,53396012230,53396012232,53396012233,53396012322,53396012323,53396012331,53396012332,53396012333,53396013202,53396013203,53396013230,53396013232,53396013233,53396020022,53396020232,53396021111,53396021112,53396021113,53396021121,53396021122,53396021123,53396021211,53396021212,53396021213,53396031102,53396031120,53396031122,53396033100,53396033101,53396033102,53396033120,53396033122,53396033300,53396033302,53396033320,53397011302,53397011303,53397011330,53397011332,53397011333,53397102102,53397103022,53397103023,53397103210,53397103212,53397103230,53397103232,53397103233,53397121102,53397121120,53397121122,53397121300,53397123010,53397123012,53397123122,53397123230,53397123231,53397123232,53397123300,53397123302,53397123320,54380511111,54380600021,54380600023,54380600201,54380600203,54380600221,54380600230,54380600231,54380600233,54380602011,54380602013,54380602031,54380603010,54380603011,54380603020,54380603100,54380603101,54380612021,54380612030,54380612031,54380612033,54380612330,54380612331,54380612333,54380630111,54380631000,54380631001,54380631003,54380631021,54380631023,54380631230,54380631231,54380631233,54380633131,54380633133,54380722201,54380722320,54380722321,54380722330,54380722331,54380722333,54380723320,54380723321,54380723322,54380723330,54380723331,54380732220,54380732221,54380732223,54381701011,54381710001,54381710010,54381710011,54381710013,54381710031,54381710301,54381710303,54381710330,54381710331,54381710333,54381711130,54381711131,54381711230,54381711231,54381711232,54381711300,54381711301,54381711302,54381711320,54381712111,54381712113,54381712130,54381712131,54381712133,54381712311,54381712313,54381713010,54381713200,54390100330,54390100332,54390101020,54390101021,54390101022,54390101200,54390102110,54390102112,54390102130,54390102132,54390102133,54390102330,54390102332,54390120110,54390120112,54390120113,54390121220,54390122310,54390122312,54390122330,54390122332,54390123333,54390132023,54390132030,54390132032,54390132201,54390132202,54390132203,54390132302,54390132320,54390132322,54391000020,54391000021,54391000030,54391000031,54391001210,54391001211,54391001213,54391001320,54391001321,54391001323,54391003101,54391003103,54391003310,54391003311,54391012030,54391012031,54391012200,54391012310,54391012311,54391013221,54391013223,54391031001,54391031003,54391031031,54391031301,54391031310,54391031311,54391100110,54391100112,54391101022,54391101023,54391101031,54391101032,54391101033,54391110100,54391110102,54391111013,54391111102,54391111103,54391111112,54391111113,54391112130,54391112131,54391112132,54391112310,54391112312,54391112330,54391112332,54391113020,54391113021,54391113030,54391113031,54391113120,54391113121,54391113130,54391113131,54391120210,54391120211,54391120212,54391120300,54391121000,54391121001,54391121002,54391121110,54391121111,54391130000,54391130001,54391130010,54391130011,54391130013,54391130100,54391130101,54391130102,54391200000,54391200002,54391200003,54391200032,54391200230,54391200231,54391200232,54391200300,54391200302,54391200313,54391200320,54391200321,54391200330,54391200331,54391201201,54391201202,54391201203,54391201220,54391201221,54391202010,54391202012,54391202013,54391202020,54391202102,54391202120,54391202121,
075,00,/Ĵ,501960937,128268750,502537500,128512500,0,0,0,13,41,92,533933323,533933332,533933333,533934213,533934222,533934223,533934230,533934231,533934233,533943110,533943111,533944000,533944011,5339333212,5339333213,5339333221,5339333222,5339333223,5339333302,5339333303,5339333312,5339333313,5339342113,5339342121,5339342122,5339342123,5339342202,5339342203,5339342211,5339342212,5339342213,5339342320,5339342321,5339343200,5339343202,5339343203,5339343211,5339343212,5339343220,5339431011,5339431013,5339431031,5339431033,5339431120,5339431121,5339431130,5339431131,5339431132,5339431211,5339440010,5339440011,5339440012,5339440021,5339440030,53393323333,53393332031,53393332032,53393332033,53393332103,53393332112,53393332113,53393332201,53393332203,53393333002,53393333003,53393333012,53393333013,53393333102,53393333103,53393333112,53393333113,53393420331,53393420332,53393420333,53393421121,53393421122,53393421123,53393421202,53393421203,53393422002,53393422003,53393422012,53393422013,53393422101,53393422102,53393422103,53393423220,53393423221,53393423222,53393430022,53393430200,53393430202,53393430220,53393430222,53393430223,53393430333,53393432010,53393432012,53393432013,53393432101,53393432102,53393432103,53393432130,53393432132,53393432210,53393432211,53393432220,53393432222,53393432310,53394301111,53394310000,53394310010,53394310011,53394310101,53394310103,53394310121,53394310123,53394310301,53394310303,53394310321,53394310323,53394311220,53394311221,53394311230,53394311231,53394311233,53394311330,53394311331,53394311332,53394312130,53394312131,53394312133,53394313002,53394400130,53394400132,53394400200,53394400201,53394400202,53394400310,53394400321,53394400323,53394401000,53394410000,53394410002,53394410020,53394410022,
075,01,¿,501707812,128165625,502312500,128484375,0,0,3,9,48,105,53393322,53393330,53393331,533933122,533933133,533933230,533933231,533933232,533934200,533934202,533943001,533943010,5339323311,5339323313,5339330302,5339330303,5339330312,5339330313,5339330321,5339330330,5339330331,5339330333,5339331202,5339331203,5339331232,5339331311,5339331312,5339331313,5339331322,5339331323,5339332023,5339332032,5339332033,5339332131,5339332132,5339332133,5339332330,5339332331,5339332332,5339333200,5339333201,5339333202,5339340222,5339340223,5339342012,5339342030,5339342032,5339430000,5339430001,5339430003,5339430020,5339430021,5339430023,5339430030,5339430031,5339430032,5339430110,5339430112,5339430120,5339430121,53393231333,53393233121,53393233123,53393233311,53393302113,53393302131,53393303102,53393303103,53393303112,53393303113,53393303201,53393303231,53393303320,53393303321,53393303323,53393311332,53393311333,53393312002,53393312003,53393312012,53393312013,53393312300,53393312302,53393312303,53393312330,53393312332,53393312333,53393313033,53393313101,53393313102,53393313103,53393313203,53393313211,53393313212,53393313213,53393320212,53393320213,53393320222,53393320223,53393320302,53393320303,53393320312,53393321111,53393321113,53393321131,53393321133,53393321222,53393321223,53393321233,53393321303,53393323330,53393323331,53393323332,53393332030,53393332100,53393332101,53393332102,53393332110,53393332111,53393332200,53393332202,53393333000,53393333001,53393333010,53393333011,53393333100,53393333101,53393333110,53393333111,53393400222,53393402000,53393402200,53393402202,53393402203,53393402320,53393402322,53393420100,53393420102,53393420103,53393420112,53393420310,53393420312,53393420313,53393420330,53393422000,53393422001,53393422010,53393422011,53393422100,53394211111,53394300021,53394300023,53394300220,53394300221,53394300223,53394300330,53394300331,53394300332,53394301110,53394301112,53394301220,53394301300,53394302001,53394302010,53394302011,
076,00,Ȭ,500273437,127931250,501960937,128634375,0,4,25,66,143,267,5339303,5339310,5339313,5339322,53392021,53392032,53392033,53392122,53392123,53393011,53393012,53393013,53393021,53393023,53393110,53393112,53393113,53393120,53393121,53393230,53393232,53394000,53394001,53394002,53394010,53394111,53394200,53394201,53394210,533847131,533847132,533847133,533920221,533920230,533920231,533920233,533920300,533920302,533920303,533920310,533920312,533920313,533921202,533921203,533921212,533921320,533921322,533921323,533930032,533930033,533930101,533930103,533931112,533931220,533931221,533931222,533931230,533931231,533931233,533932020,533932022,533932122,533932123,533932131,533932132,533932133,533932310,533932311,533932312,533932330,533932332,533933020,533933022,533933023,533933200,533933201,533933210,533940030,533940031,533940110,533940200,533941100,533941101,533941130,533941131,533941132,533942020,533942021,533942030,533942031,533942110,533942112,533942113,533942120,533942122,5338471111,5338471113,5338471131,5338471132,5338471133,5338471303,5339202013,5339202031,5339202032,5339202033,5339202201,5339202203,5339202221,5339202230,5339202231,5339202320,5339202321,5339202323,5339203011,5339203012,5339203013,5339203111,5339203112,5339203113,5339212002,5339212003,5339212012,5339212013,5339212132,5339213210,5339213212,5339213213,5339213320,5339213322,5339300213,5339300231,5339300233,5339300302,5339300303,5339300312,5339300313,5339301001,5339301002,5339301003,5339301020,5339301021,5339301023,5339302011,5339302012,5339302013,5339302030,5339302031,5339302033,5339302211,5339302213,5339302223,5339302231,5339302232,5339302233,5339311100,5339311102,5339312230,5339312231,5339312320,5339312321,5339320022,5339320023,5339320230,5339320232,5339320233,5339320322,5339320323,5339320331,5339320332,5339320333,5339321301,5339321303,5339323130,5339323131,5339323132,5339323310,5339323330,5339323332,5339323333,5339330022,5339330023,5339330210,5339330212,5339330322,5339332020,5339332110,5339332112,5339332120,5339332121,5339400320,5339400321,5339400322,5339401110,5339401111,5339401112,5339401120,5339401121,5339401122,5339401200,5339402010,5339402011,5339402012,5339402021,5339402030,5339410110,5339410111,5339410113,5339410131,5339411020,5339411021,5339411030,5339411031,5339411033,5339411211,5339411213,5339411231,5339411233,5339411330,5339411331,5339411332,5339420220,5339420221,5339420230,5339420231,5339420320,5339420321,5339420322,5339420330,5339420331,5339421110,5339421112,5339421113,5339421210,5339421211,5339421212,5339421230,5339421301,5339421310,53383733333,53384711233,53384711303,53384712313,53384712331,53384712333,53384713011,53384713013,53384713023,53384731111,53384731113,53392002333,53392003222,53392003223,53392003232,53392003322,53392012333,53392013222,53392013223,53392013321,53392013323,53392013330,53392013332,53392013333,53392020111,53392020113,53392020123,53392020233,53392020301,53392020303,53392022320,53392022321,53392022330,53392022331,53392023220,53392023221,53392023223,53392030102,53392030103,53392031101,53392031102,53392031103,53392102222,53392120000,53392120002,53392120003,53392120012,53392120013,53392120102,53392121022,53392121302,53392121303,53392121332,53392121333,53392130222,53392132110,53392132112,53392132113,53392133002,53392133020,53392133022,53392133230,53392133232,53393002303,53393002321,53393002323,53393003003,53393003011,53393003012,53393003013,53393003100,53393003102,53393003103,53393003112,53393010001,53393010003,53393010221,53393010222,53393010223,53393020101,53393020102,53393020103,53393020321,53393020323,53393022101,53393022222,53393022223,53393022301,53393022303,53393111010,53393111012,53393111030,53393111032,53393111033,53393111322,53393111332,53393111333,53393122320,53393122321,53393122322,53393123230,53393123231,53393123233,53393200203,53393202102,53393202120,53393202122,53393202123,53393202132,53393202310,53393202312,53393202313,53393203202,53393203203,53393203212,53393203213,53393203301,53393203302,53393203303,53393213001,53393213003,53393213021,53393213023,53393231330,53393231331,53393231332,53393233120,53393233122,53393233310,53393233312,53393233313,53393300203,53393300211,53393300212,53393300213,53393300300,53393300302,53393300320,53393300322,53393300323,53393302112,53393302130,53393302132,53393302133,53393303200,53393303202,53393303203,53393303230,53393303232,53393303233,53393303322,53393320210,53393320211,53393320220,53393320221,53393320300,53393320301,53393320310,53393320311,53393320313,53393321110,53393321112,53393321130,53393321132,53393321220,53393321221,53393321230,53393321231,53393321232,53393321300,53393321301,53393321302,53394003230,53394003231,53394003300,53394003301,53394003302,53394011130,53394011131,53394011132,53394011230,53394011231,53394011232,53394011300,53394011301,53394011302,53394012010,53394012011,53394012012,53394012020,53394012100,53394012101,53394020130,53394020201,53394020203,53394020230,53394020231,53394020233,53394020320,53394020322,53394021000,53394022011,53394100000,53394100001,53394100002,53394101120,53394101121,53394101123,53394101301,53394101303,53394101321,53394101330,53394110230,53394110320,53394110321,53394110323,53394112101,53394112103,53394112121,53394113330,53394113331,53394113332,53394130111,53394131000,53394131001,53394131010,53394131011,53394131100,53394202220,53394202221,53394202223,53394202230,53394202231,53394202232,53394202320,53394202321,53394202330,53394202331,53394202333,53394203230,53394203231,53394203232,53394203320,53394203321,53394203330,53394203331,53394203333,53394211110,53394211112,53394211113,53394212130,53394212131,53394212132,53394212310,53394212312,53394212320,53394212321,53394213000,53394213001,53394213002,53394213110,53394213111,53394213112,53394230010,53394300020,53394300022,53394300222,
077,00,Ω,501609375,128456250,502031250,128756250,0,0,3,15,29,78,53394320,53394322,53394323,533942132,533942133,533942311,533942313,533943021,533943022,533943023,533943030,533943032,533943210,533943212,533953000,533953001,533953010,533953011,5339421233,5339421302,5339421303,5339421312,5339421313,5339423100,5339423101,5339423311,5339423313,5339423331,5339423333,5339430123,5339430202,5339430203,5339430310,5339430312,5339430330,5339430332,5339432110,5339432112,5339432130,5339432131,5339433002,5339433202,5339433203,5339433220,5339433222,5339521111,5339531000,53394212133,53394212311,53394212313,53394213003,53394213113,53394230111,53394231020,53394231021,53394231030,53394231031,53394231033,53394233100,53394233101,53394233103,53394233121,53394233123,53394233300,53394233301,53394233303,53394233321,53394233323,53394300333,53394301221,53394301222,53394301223,53394301322,53394301323,53394302000,53394302002,53394302003,53394302012,53394302013,53394303110,53394303112,53394303130,53394303330,53394303332,53394321110,53394321130,53394321132,53394321133,53394321320,53394321321,53394330012,53394330030,53394330032,53394330200,53394330201,53394332002,53394332210,53394332211,53394332212,53394332230,53394332232,53395211101,53395211103,53395211130,53395211131,53395211133,53395211311,53395211313,53395300200,53395300201,53395300203,53395300300,53395300311,53395301200,53395301201,53395301210,53395301211,53395301300,53395301301,53395301310,53395301311,53395310010,53395310020,53395310022,53395310200,
077,01,/ʡ/¿,499739062,128381250,501792187,129225000,2,8,20,69,146,262,533857,533950,5339403,5339412,5339422,5339510,5339511,5339512,5339520,5339600,53384732,53384733,53385611,53386711,53386713,53394013,53394023,53394102,53394103,53394132,53394133,53394232,53395130,53395131,53395132,53395210,53395220,53395221,53396010,53396011,533846331,533846332,533846333,533847222,533847223,533847232,533847233,533847303,533847310,533847312,533847313,533856101,533856103,533856313,533856331,533856333,533867000,533867010,533867011,533867100,533867101,533867103,533867121,533940122,533940123,533940211,533940212,533940213,533940221,533940222,533940223,533941001,533941002,533941003,533941010,533941012,533941120,533941122,533941300,533941302,533941303,533941312,533941313,533942302,533942303,533942312,533942330,533942332,533951330,533951331,533952110,533952112,533952120,533952121,533952122,533952130,533952131,533952220,533952221,533952230,533960120,533960121,533960201,533960203,533960210,533961000,533961001,533961002,533961010,5338463301,5338463303,5338472200,5338472202,5338472203,5338472212,5338472213,5338472302,5338472303,5338472312,5338472313,5338473023,5338473110,5338473112,5338473113,5338561003,5338561021,5338561023,5338561201,5338561210,5338561211,5338561300,5338561301,5338561310,5338561311,5338561313,5338561331,5338561333,5338563111,5338563113,5338563303,5338563321,5338661111,5338661113,5338661131,5338661133,5338670010,5338670011,5338670013,5338670020,5338670120,5338670121,5338670130,5338671020,5338671021,5338671023,5338671201,5338671203,5338671230,5338671231,5338671233,5338673100,5338673101,5338673110,5338673111,5339312233,5339312322,5339400331,5339400332,5339400333,5339401131,5339401132,5339401133,5339401203,5339401211,5339401212,5339401213,5339402022,5339402031,5339402033,5339402101,5339402102,5339402103,5339402200,5339402202,5339402203,5339410001,5339410002,5339410003,5339411022,5339411230,5339411232,5339413010,5339413012,5339413013,5339413102,5339413103,5339413111,5339413112,5339413113,5339423000,5339423002,5339423003,5339423010,5339423012,5339423013,5339513320,5339513321,5339513322,5339513330,5339513331,5339521112,5339521130,5339521132,5339521133,5339521230,5339521231,5339521320,5339521321,5339521322,5339521330,5339521331,5339522220,5339522221,5339522230,5339522231,5339522233,5339522310,5339522320,5339522321,5339523000,5339523002,5339523020,5339530022,5339530200,5339601220,5339601221,5339601230,5339601231,5339601300,5339601301,5339601302,5339601310,5339601311,5339602000,5339602001,5339602003,5339602021,5339602110,5339602120,5339610030,5339610031,5339610032,5339610110,5339610120,5339610200,53384631232,53384631233,53384631322,53384631323,53384631332,53384631333,53384632322,53384632323,53384632331,53384632332,53384632333,53384633023,53384720222,53384720223,53384722010,53384722012,53384722013,53384722102,53384723103,53384723111,53384723112,53384723113,53384730113,53384730123,53384730131,53384730132,53384730133,53384730213,53384730222,53384730223,53384731110,53384731112,53385610013,53385610223,53385612001,53385612003,53385613031,53385613120,53385613121,53385613123,53385613323,53385631101,53385631103,53385631121,53385631122,53385631123,53385631211,53385631213,53385631231,53385633011,53385633012,53385633013,53385633231,53386611100,53386611101,53386611103,53386611121,53386611123,53386611301,53386611303,53386611321,53386611323,53386613101,53386613110,53386700120,53386700122,53386700210,53386700211,53386700220,53386700311,53386701221,53386701230,53386701231,53386701310,53386701311,53386701313,53386710220,53386710221,53386712210,53386712211,53386712320,53386712321,53386712323,53386731030,53386731031,53386731120,53386731131,53393122323,53393123232,53394003232,53394003233,53394003303,53394011133,53394011233,53394011303,53394012013,53394012021,53394012022,53394012023,53394012102,53394012103,53394020131,53394020132,53394020133,53394020200,53394020202,53394020232,53394020321,53394020323,53394021001,53394021002,53394021003,53394022010,53394022012,53394022013,53394100003,53394101122,53394101300,53394101302,53394101320,53394101322,53394101323,53394101331,53394101332,53394101333,53394110231,53394110232,53394110233,53394110322,53394112100,53394112102,53394112120,53394112122,53394112123,53394113333,53394130110,53394130112,53394130113,53394131002,53394131003,53394131012,53394131013,53394131101,53394131102,53394131103,53394202222,53394202233,53394202322,53394202323,53394202332,53394203233,53394203322,53394203323,53394203332,53394212322,53394212323,53394230011,53394230012,53394230013,53394230110,53394230112,53394230113,53394231022,53394231023,53394231032,53394233102,53394233120,53394233122,53394233302,53394233320,53394233322,53395133230,53395133231,53395133320,53395133321,53395133330,53395133331,53395211100,53395211102,53395211132,53395211310,53395211312,53395212320,53395212321,53395212322,53395212330,53395212331,53395212333,53395213230,53395213231,53395213232,53395213320,53395213321,53395213330,53395213331,53395222220,53395222221,53395222230,53395222231,53395222320,53395222321,53395223110,53395223111,53395223120,53395223122,53395223220,53395223221,53395223230,53395223300,53395223302,53395230010,53395230011,53395230012,53395230030,53395230220,53395230222,53395232000,53395232002,53395300202,53395302010,53395302012,53395302020,53395302021,53396012220,53396012221,53396012231,53396012320,53396012321,53396012330,53396013200,53396013201,53396020020,53396020021,53396020023,53396020230,53396020231,53396020233,53396021110,53396021120,53396021210,53396100330,53396100331,53396100332,53396101110,53396101111,53396101112,53396101120,53396101121,53396101122,53396101220,53396102010,53396102011,53396102012,53396102100,53396102101,53396110000,53396110100,53396110101,53396110110,53396110111,53396110112,53396110130,
078,00,¤θ/ޥץ顼/,502087500,127893750,502720312,128203125,0,0,3,13,43,102,53392420,53392423,53393411,533923311,533924023,533924210,533924212,533924213,533924322,533924323,533924332,533924333,533934010,533934011,533934100,533934101,5339231330,5339231332,5339231333,5339233122,5339233123,5339233130,5339233131,5339233132,5339233301,5339233303,5339233321,5339240212,5339240221,5339240222,5339240223,5339240322,5339240323,5339240332,5339242110,5339242112,5339242211,5339243133,5339243202,5339243212,5339243213,5339243302,5339243303,5339243311,5339243312,5339243313,5339252200,5339252202,5339252220,5339252222,5339340131,5339341020,5339341021,5339341030,5339341031,5339341310,5339350020,5339350021,5339350022,53392313312,53392313313,53392331203,53392331211,53392331212,53392331213,53392331330,53392331331,53392333000,53392333001,53392333003,53392333021,53392333100,53392333102,53392333120,53392333122,53392333230,53392333231,53392333300,53392333302,53392333303,53392333320,53392333321,53392402033,53392402130,53392402132,53392402133,53392402201,53392402202,53392402203,53392403200,53392403202,53392403203,53392403212,53392403213,53392421112,53392421130,53392421132,53392421133,53392422000,53392422001,53392422003,53392422010,53392422011,53392422012,53392422101,53392422131,53392422133,53392430022,53392430200,53392430202,53392430220,53392430222,53392432000,53392432002,53392432030,53392432032,53392432033,53392433002,53392433003,53392433012,53392433013,53392433102,53392433103,53392520222,53392520223,53392520232,53392522010,53392522012,53392522030,53392522032,53393401300,53393401301,53393401303,53393401330,53393410231,53393410320,53393410321,53393410330,53393410331,53393410333,53393413000,53393413001,53393413010,53393413011,53393413013,53393413031,53393413110,53393413111,53393413112,53393413120,53393500000,53393500002,53393500020,53393500022,53393500023,53393500031,53393500033,53393500120,53393500122,53393500230,53393500300,
078,01,̥˥塼,502368750,127809375,502621875,128053125,0,0,1,7,22,46,53392412,533924031,533924102,533924103,533924301,533924303,533924310,533924312,5339240131,5339240133,5339240330,5339240331,5339240333,5339241122,5339241123,5339241300,5339241301,5339241302,5339241320,5339241322,5339243000,5339243001,5339243003,5339243021,5339243023,5339243130,5339243132,5339243201,5339243210,5339243211,53392401131,53392401132,53392401133,53392401301,53392401303,53392401321,53392401322,53392401323,53392410020,53392410022,53392410023,53392410113,53392410131,53392410132,53392410133,53392411022,53392411200,53392411202,53392411203,53392411212,53392411213,53392413230,53392413232,53392421110,53392421111,53392421113,53392421131,53392430020,53392430021,53392430023,53392430201,53392430203,53392430221,53392430223,53392431121,53392431122,53392431123,53392432001,53392432003,53392432031,53392433000,53392433001,53392433010,53392433011,53392433100,53392433101,
078,02,ߤʤȤߤ餤,502579687,127575000,502762500,127678125,0,0,0,2,5,29,533914131,533915022,5339150202,5339150212,5339150230,5339152000,5339152001,53391413011,53391413013,53391413031,53391413033,53391413211,53391413300,53391413301,53391413310,53391413311,53391413313,53391413331,53391413333,53391502002,53391502003,53391502012,53391502030,53391502032,53391502033,53391502130,53391502132,53391502310,53391502311,53391502312,53391502320,53391502321,53391502322,53391502330,53391520030,53391520100,
078,03,Į/ڳ,502720312,127528125,502818750,127621875,0,0,0,1,4,15,533915012,5339150211,5339150300,5339150302,5339150303,53391500332,53391500333,53391501032,53391501033,53391502101,53391502103,53391502131,53391502133,53391503010,53391503011,53391503012,53391503200,53391503201,53391503210,53391503211,
078,04,/Į,502635937,127556250,502720312,127603125,0,0,0,0,2,10,5339150022,5339150023,53391411331,53391411333,53391502000,53391502001,53391502010,53391502011,53391502013,53391502031,53391502100,53391502102,
078,05,Į,502692187,127509375,502762500,127575000,0,0,0,0,5,8,5339150012,5339150013,5339150030,5339150031,5339150032,53391500031,53391500033,53391500102,53391500103,53391500211,53391500213,53391500330,53391500331,
078,06,/̱,502664062,127425000,502917187,127621875,0,0,0,4,15,36,533905232,533905233,533915011,533915013,5339052231,5339052233,5339052303,5339052310,5339052312,5339052313,5339053202,5339150011,5339150100,5339150101,5339150102,5339150310,5339150312,5339151020,5339151022,53390522301,53390522303,53390522321,53390522323,53390523013,53390523023,53390523110,53390523112,53390523113,53390532002,53390532012,53390532030,53390532032,53390532200,53390532201,53390532203,53390532210,53391500011,53391500012,53391500013,53391500023,53391500030,53391500032,53391500100,53391500101,53391501030,53391501031,53391503013,53391503110,53391503111,53391503112,53391503300,53391510020,53391510022,53391512000,53391512001,
078,07,/ڥë,502467187,127462500,502692187,127584375,0,0,0,3,13,24,533914101,533914110,533914112,5339043233,5339043321,5339043322,5339043323,5339141030,5339141031,5339141033,5339141112,5339141113,5339141130,5339141131,5339141132,5339150020,53390432311,53390432312,53390432313,53390432321,53390432323,53390433202,53391410013,53391410031,53391410213,53391410321,53391410323,53391411100,53391411102,53391411103,53391411330,53391411332,53391412110,53391412111,53391413000,53391413001,53391413010,53391500022,53391500210,53391500212,
078,08,ڥë,502382812,127556250,502621875,127809375,0,0,0,7,26,70,533914120,533914123,533914301,533914303,533914310,533914321,533914323,5339140311,5339140313,5339141022,5339141023,5339141210,5339141212,5339141213,5339141221,5339141302,5339141320,5339141322,5339141323,5339143003,5339143021,5339143023,5339143120,5339143122,5339143201,5339143202,5339143203,5339143300,5339143302,5339143320,5339143321,5339143322,5339143330,53391401333,53391403103,53391403121,53391403123,53391403310,53391403311,53391410320,53391410322,53391412112,53391412113,53391412200,53391412201,53391412230,53391412231,53391412233,53391413002,53391413003,53391413012,53391413030,53391413032,53391413210,53391413212,53391413213,53391413302,53391413320,53391413322,53391423113,53391423131,53391423132,53391423133,53391423310,53391423311,53391423313,53391430011,53391430012,53391430013,53391430021,53391430022,53391430023,53391430201,53391430221,53391431100,53391431102,53391431120,53391431210,53391431212,53391431213,53391431230,53391431231,53391431232,53391432002,53391432003,53391432201,53391432210,53391432211,53391432213,53391432231,53391432233,53391433010,53391433012,53391433030,53391433032,53391433033,53391433230,53391433231,53391433320,53391433321,53392410110,53392410111,53392411000,
078,09,,502537500,127256250,502748437,127528125,0,0,0,8,16,45,533904133,533904311,533904313,533904331,533904333,533905202,533905220,533905222,5339041301,5339041303,5339041310,5339041312,5339041313,5339041321,5339041322,5339041323,5339043100,5339043101,5339052000,5339052002,5339052210,5339052212,5339141111,5339150000,53390411220,53390411222,53390411223,53390411232,53390411233,53390411322,53390413001,53390413003,53390413021,53390413023,53390413201,53390413203,53390431020,53390431021,53390431030,53390431031,53390431213,53390431231,53390431232,53390431233,53390433010,53390433011,53390433013,53390502202,53390502220,53390502222,53390520010,53390520012,53390520030,53390520032,53390520033,53390520300,53390520302,53390520322,53390522110,53390522112,53390522130,53390522300,53390522302,53390522320,53390522322,53391411101,53391500010,53391500020,53391500021,
078,10,Ȭ/ʸ,502523437,127106250,502790625,127406250,0,0,2,7,21,47,52397433,53390500,523975222,533904110,533904111,533905020,533905021,533905023,533905201,5239743132,5239752200,5239752202,5239752203,5239752233,5339041120,5339041121,5339041130,5339041131,5339041133,5339041311,5339050102,5339050120,5339050122,5339050221,5339050223,5339050302,5339050320,5339052031,5339050322,5239752232,52397431222,52397431223,52397431231,52397431232,52397431233,52397431332,52397431333,52397432111,52397520222,52397522012,52397522013,52397522120,52397522122,52397522300,52397522302,53390410111,53390410113,53390410131,53390410133,53390410311,53390410313,53390411221,53390411230,53390411231,53390411320,53390411321,53390411323,53390501000,53390501002,53390501003,53390502200,53390502201,53390502203,53390502221,53390502223,53390503000,53390503002,53390520011,53390520013,53390520031,53390520301,53390520303,53390521000,53390521002,53390521020,53390521022,53390521200,
078,11,,502579687,127621875,502692187,127781250,0,0,0,2,7,29,533914313,533914331,5339143111,5339143113,5339152002,5339152020,5339152022,5339152200,5339152202,53391413303,53391413312,53391413321,53391413323,53391413330,53391413332,53391431101,53391431103,53391431121,53391431122,53391431123,53391431211,53391431233,53391433011,53391433013,53391433031,53391433310,53391433311,53391433313,53391520032,53391520210,53391520212,53391520230,53391520232,53391522010,53391522012,53391522030,53391522032,53391522210,
078,12,粬/,502410937,127293750,502593750,127500000,0,0,0,4,18,42,533904301,533904303,533904320,533904321,5339041223,5339041231,5339041232,5339041233,5339043001,5339043002,5339043003,5339043020,5339043021,5339043023,5339043120,5339043122,5339043220,5339043221,5339043230,5339043300,5339043302,5339043303,53390412132,53390412133,53390412221,53390412223,53390412301,53390412302,53390412303,53390413020,53390413022,53390413200,53390413202,53390421131,53390421133,53390423311,53390423313,53390430001,53390430002,53390430003,53390430220,53390430221,53390430223,53390431022,53390431023,53390431032,53390431033,53390431210,53390431211,53390431212,53390431230,53390432220,53390432221,53390432222,53390432230,53390432231,53390432233,53390432310,53390432320,53390432322,53390433012,53390433200,53390433201,53390433203,
078,13,/ܶ,502270312,127200000,502551562,127378125,0,0,0,4,21,40,533904032,533904033,533904102,533904120,5339040133,5339040213,5339040231,5339040233,5339040300,5339040302,5339040303,5339040311,5339040312,5339040313,5339041010,5339041012,5339041030,5339041032,5339041033,5339041210,5339041211,5339041212,5339041220,5339041221,5339042111,53390401313,53390401323,53390402111,53390402113,53390402121,53390402123,53390402301,53390402303,53390402321,53390402323,53390403010,53390403012,53390403101,53390403103,53390410033,53390410110,53390410112,53390410130,53390410132,53390410310,53390410312,53390412130,53390412131,53390412220,53390412222,53390412300,53390413000,53390413002,53390420110,53390420111,53390421001,53390421003,53390421010,53390421011,53390421012,53390421100,53390421101,53390421103,53390421130,53390430000,
078,14,,502143750,127265625,502481250,127603125,0,0,0,11,28,61,533904022,533904200,533904203,533904212,533904213,533904230,533904231,533904232,533914010,533914011,533914012,5339031311,5339031313,5339031331,5339031333,5339033111,5339033112,5339033113,5339042010,5339042012,5339042013,5339042021,5339042102,5339042103,5339042112,5339042210,5339042211,5339042213,5339042231,5339042330,5339042332,5339042333,5339140130,5339140131,5339140132,5339140300,5339141000,5339141002,5339141020,53390311323,53390311332,53390311333,53390313101,53390313103,53390313121,53390313123,53390313301,53390313303,53390313321,53390313323,53390331101,53390331102,53390331103,53390331311,53390402020,53390402022,53390402032,53390402033,53390402120,53390402122,53390402300,53390402302,53390402320,53390402322,53390420112,53390420113,53390420200,53390420201,53390420231,53390420233,53390421000,53390421002,53390421013,53390421102,53390421132,53390422011,53390422331,53390422333,53390423310,53390423312,53390430222,53390432223,53390432232,53391401330,53391401331,53391401332,53391403010,53391403011,53391403020,53391403100,53391403101,53391410010,53391410011,53391410012,53391410030,53391410032,53391410033,53391410210,53391410211,53391410212,
078,15,/бԻ,502101562,127378125,502312500,127603125,0,0,0,8,24,26,533903331,533903333,533904222,533913111,533913113,533914000,533914001,533914003,5339033121,5339033123,5339033130,5339033132,5339033133,5339033301,5339033303,5339033321,5339033323,5339042022,5339042200,5339042202,5339042203,5339042212,5339042230,5339042232,5339131101,5339131103,5339131121,5339131123,5339140020,5339140021,5339140210,5339140211,53390331033,53390331310,53390331312,53390331313,53390420202,53390420203,53390420230,53390420232,53390422010,53390422012,53390422013,53390422330,53390422332,53391311001,53391313011,53391313013,53391313031,53391313100,53391313101,53391313102,53391313110,53391313111,53391313120,53391402121,53391402130,53391402131,
078,16,/ë/Ķ,501862500,127453125,502256250,127856250,0,0,2,17,40,85,53391312,53391331,533913011,533913013,533913031,533913033,533913100,533913102,533913103,533913132,533913133,533913301,533913303,533913321,533913322,533913323,533913330,533913332,533923101,5339033221,5339033223,5339130101,5339130103,5339130121,5339130123,5339130301,5339130303,5339130321,5339131012,5339131013,5339131102,5339131120,5339131122,5339131300,5339131302,5339131313,5339132110,5339132111,5339133000,5339133001,5339133003,5339133021,5339133023,5339133201,5339133203,5339133310,5339133312,5339133330,5339133332,5339140022,5339140023,5339140200,5339140201,5339140202,5339140220,5339140222,5339142000,5339231000,5339231001,53390323232,53390323233,53390323322,53390323323,53390332032,53390332033,53390332221,53390332222,53390332223,53390332300,53390332302,53390332303,53390332320,53390332321,53390332322,53391301221,53391301223,53391303001,53391303003,53391303020,53391303021,53391303023,53391303201,53391303203,53391303231,53391303233,53391310112,53391310113,53391311002,53391311003,53391313010,53391313012,53391313030,53391313032,53391313033,53391313103,53391313112,53391313113,53391313121,53391313122,53391313123,53391321011,53391330021,53391330023,53391330201,53391330203,53391330221,53391330223,53391332001,53391332003,53391332021,53391332022,53391332023,53391333110,53391333111,53391333112,53391402030,53391402032,53391402210,53391402212,53391402230,53391420020,53391420021,53391420022,53391420200,53391420202,53391420220,53392301113,53392310021,53392310030,53392310031,53392310033,53392310211,53392310300,53392310301,53392310303,53392310310,53392310311,53392310312,53392311000,53392311001,53392311010,53392311011,53392311100,53392311101,
078,17,滳/Ĺ,502115625,127762500,502523437,127921875,0,0,0,6,25,43,533924001,533924002,533924003,533924010,533924012,533924030,5339142333,5339143222,5339231103,5339231112,5339231113,5339231130,5339231131,5339231133,5339231311,5339231313,5339240002,5339240003,5339240110,5339240111,5339240112,5339240200,5339240201,5339240202,5339240210,5339240211,5339241000,5339241001,5339241003,5339241010,5339241012,53391422322,53391423223,53391423232,53391423233,53391423322,53391423323,53391432200,53391432202,53391432203,53391432212,53391432230,53391432232,53392311012,53392311013,53392311102,53392311103,53392311211,53392311320,53392311321,53392311323,53392313101,53392313103,53392313121,53392313123,53392313310,53392313311,53392400011,53392400013,53392401130,53392401300,53392401302,53392401320,53392402030,53392402031,53392402032,53392402131,53392402200,53392403201,53392403210,53392403211,53392410021,53392410112,53392410130,
078,18,˾/,502171875,127584375,502467187,127818750,0,0,1,8,23,59,53391421,533914023,533914032,533914201,533914203,533914220,533914221,533914222,533914230,5339133313,5339133331,5339133333,5339140303,5339140330,5339140332,5339140333,5339141222,5339142001,5339142003,5339142021,5339142023,5339142230,5339142231,5339142233,5339142310,5339142312,5339142320,5339142321,5339142330,5339143000,5339231111,5339240000,53391333113,53391402031,53391402033,53391402120,53391402122,53391402123,53391402132,53391402133,53391402211,53391402213,53391402231,53391402232,53391402233,53391403012,53391403013,53391403021,53391403022,53391403023,53391403102,53391403120,53391403122,53391403312,53391403313,53391412202,53391412203,53391412232,53391420023,53391420201,53391420203,53391420221,53391420222,53391420223,53391422320,53391422321,53391422323,53391423110,53391423111,53391423112,53391423130,53391423220,53391423221,53391423222,53391423230,53391423231,53391423312,53391423320,53391423321,53391430010,53391430020,53391430200,53391430202,53391430203,53391430220,53391430222,53391430223,53391432000,53391432001,53392400010,53392400012,
078,19,,502537500,127762500,502762500,127978125,0,0,0,5,22,30,533924111,533924113,533924131,533924133,533925020,5339143333,5339152220,5339152222,5339152223,5339241101,5339241103,5339241303,5339241321,5339243110,5339243111,5339250000,5339250001,5339250002,5339250020,5339250022,5339250023,5339250210,5339250212,5339250220,5339250221,5339250222,5339250230,53391433232,53391433233,53391433312,53391433322,53391433323,53391522211,53391522212,53391522213,53392411001,53392411002,53392411003,53392411020,53392411021,53392411023,53392411201,53392411210,53392411211,53392413231,53392413233,53392431120,53392500030,53392500032,53392500210,53392500212,53392500213,53392500322,53392502310,53392502312,53392502313,53392520000,
078,20,/ḫ,502692187,127593750,503592187,128015625,0,0,9,23,35,98,53391523,53391530,53391532,53391533,53392501,53392503,53392510,53392511,53392600,533915122,533915203,533915211,533915212,533915213,533915221,533915223,533915312,533915313,533916222,533925001,533925120,533925121,533925122,533925130,533925131,533925133,533925211,533925300,533926012,533926020,533926021,533926022,5339150333,5339151203,5339151232,5339152012,5339152013,5339152102,5339152103,5339153100,5339153102,5339153103,5339153112,5339153113,5339162202,5339162203,5339162212,5339162230,5339162232,5339162233,5339162320,5339162322,5339250030,5339250031,5339250033,5339250211,5339250213,5339251321,5339251323,5339252101,5339252130,5339252131,5339260100,5339260102,5339260230,5339260300,5339260301,53391503311,53391503312,53391503313,53391503321,53391503323,53391512023,53391512300,53391512302,53391512303,53391512332,53391512333,53391513222,53391513223,53391513232,53391520031,53391520033,53391520102,53391520103,53391520111,53391520112,53391520113,53391520211,53391520213,53391520231,53391520233,53391521000,53391521002,53391521003,53391521012,53391521013,53391522011,53391522013,53391522031,53391522033,53391531010,53391531012,53391622002,53391622003,53391622012,53391622013,53391622102,53391622103,53391622311,53391622312,53391622313,53392500031,53392500033,53392500211,53392500320,53392500321,53392500323,53392502311,53392512300,53392512301,53392512310,53392512311,53392513200,53392513201,53392513203,53392513221,53392521000,53392521001,53392521003,53392521021,53392521023,53392521030,53392521031,53392521032,53392521201,53392521210,53392521330,53392530102,53392530120,53392530200,53392530201,53392601012,53392601030,53392601032,53392601033,53392601302,53392601320,53392601322,53392602310,53392602320,53392603020,53392603021,53392603022,53392603100,53392610002,53391720002,53391720000,53391720001,53391702223,53391702232,53391632132,53391503322,53392601300,53391503303,
078,21,¢/,502621875,127931250,502846875,128137500,0,0,0,6,19,36,533925201,533925203,533925221,533925223,533925230,533925232,5339243113,5339243131,5339250223,5339250232,5339250233,5339252001,5339252002,5339252003,5339252020,5339252021,5339252122,5339252123,5339252132,5339252221,5339252223,5339252310,5339350001,5339350010,5339350011,53392520001,53392520002,53392520003,53392520220,53392520221,53392520230,53392520231,53392520233,53392521002,53392521020,53392521022,53392521033,53392521200,53392521202,53392521203,53392521211,53392521212,53392521213,53392522011,53392522013,53392522031,53392522033,53392523120,53392523122,53392523300,53393500001,53393500003,53393500021,53393500030,53393500032,53393500121,53393500123,53393500130,53393501000,53393501001,53393501010,
079,00,ɴ/и,502031250,128015625,502579687,128296875,0,0,1,11,42,73,53393403,533924222,533924223,533933121,533934000,533934001,533934003,533934012,533934021,533934120,533934121,533934210,5339233311,5339233313,5339233331,5339233333,5339242202,5339242203,5339242212,5339331032,5339331103,5339331111,5339331112,5339331113,5339331121,5339331122,5339331123,5339331130,5339331131,5339331132,5339331231,5339331300,5339331301,5339331302,5339340020,5339340021,5339340023,5339340132,5339340201,5339340202,5339340203,5339340221,5339340230,5339340231,5339340233,5339341022,5339341220,5339341221,5339341222,5339341230,5339341302,5339342013,5339342110,5339342111,53392331332,53392331333,53392333101,53392333103,53392333121,53392333123,53392333301,53392422002,53392422013,53392422100,53392422102,53392422103,53392422130,53392422132,53393310331,53393310332,53393310333,53393311101,53393311102,53393311103,53393311201,53393311202,53393311203,53393311330,53393311331,53393312301,53393312331,53393313030,53393313031,53393313032,53393313100,53393313200,53393313201,53393313202,53393313210,53393400220,53393400221,53393400223,53393401302,53393401331,53393401332,53393401333,53393402001,53393402002,53393402003,53393402201,53393402321,53393402323,53393410230,53393410232,53393410233,53393410322,53393410323,53393410332,53393412230,53393412310,53393412311,53393413002,53393413003,53393413012,53393413030,53393413032,53393420101,53393420110,53393420111,53393420113,53393420311,53393421120,53393421200,53393421201,53393430000,53393430001,53393430002,
080,00,/ͳ/,502157812,127059375,502537500,127312500,0,0,1,15,22,58,52397423,523974202,523974203,523974212,523974213,523974220,523974221,523974223,523974320,523974322,523974323,533904001,533904003,533904010,533904011,533904012,5239733131,5239733133,5239742012,5239742013,5239742113,5239742220,5239742221,5239743020,5239743022,5239743023,5239743210,5239743212,5239743213,5339040021,5339040023,5339040130,5339040200,5339040201,5339040210,5339041000,5339041001,5339041002,52397331132,52397331133,52397331301,52397331303,52397331321,52397333111,52397333113,52397333131,52397333133,52397420022,52397420023,52397420032,52397420033,52397421020,52397421022,52397421023,52397421103,52397421112,52397421121,52397421123,52397422221,52397422230,52397422231,52397422233,52397430022,52397430212,52397430320,52397430322,52397430323,52397432110,52397432112,52397432113,53390400011,53390400031,53390400033,53390400203,53390400221,53390400222,53390400223,53390401310,53390401311,53390401312,53390401320,53390401321,53390401322,53390402021,53390402023,53390402030,53390402031,53390402110,53390402112,53390403011,53390403013,53390403100,53390403102,53390410030,53390410031,53390410032,
081,00,ܲ/,502382812,126440625,503114062,127181250,0,1,10,30,85,172,5239652,52395522,52396500,52396502,52396530,52396532,52397411,52397413,52397500,52397501,52397502,523954331,523955202,523955203,523955212,523955230,523964131,523964133,523964313,523964331,523964332,523964333,523965030,523965032,523965033,523965312,523965332,523974101,523974103,523974121,523974123,523974301,523974310,523974311,523975030,523975032,523975100,523975101,523975110,523975200,523975201,5239543111,5239543112,5239543113,5239543130,5239543131,5239543133,5239543331,5239543333,5239552000,5239552002,5239552130,5239552132,5239552133,5239552310,5239552311,5239552312,5239552320,5239552322,5239641111,5239641113,5239641131,5239641133,5239641301,5239641303,5239643121,5239643233,5239643301,5239643303,5239650100,5239650102,5239650120,5239650122,5239650312,5239651222,5239651223,5239653100,5239653300,5239653302,5239653303,5239653330,5239653332,5239653333,5239741021,5239741023,5239741201,5239741203,5239741221,5239741222,5239741223,5239743000,5239743001,5239743003,5239743030,5239743031,5239743033,5239743120,5239743121,5239743130,5239743131,5239750310,5239750311,5239750312,5239750330,5239750332,5239750333,5239751020,5239751022,5239751110,5239751111,5239751112,5239752020,5239752021,5239752023,5239752030,5239752032,5239752033,5239752100,5239752101,5239752102,5239752110,5239752210,5239752211,5239752213,5239752302,5239751221,52395431102,52395431103,52395431321,52395431323,52395433013,52395433031,52395433301,52395433303,52395502223,52395502232,52395520010,52395520012,52395520030,52395520032,52395520122,52395520123,52395520132,52395520133,52395521022,52395521023,52395521032,52395521122,52395521123,52395521132,52395521310,52395521312,52395523130,52395523131,52395523132,52395523210,52395523211,52395523212,52395523230,52395523232,52396411301,52396411303,52396411322,52396411323,52396413001,52396413003,52396413021,52396413211,52396413213,52396413231,52396431032,52396431033,52396431100,52396431101,52396431110,52396431111,52396431113,52396431122,52396431123,52396431131,52396431132,52396431133,52396431231,52396431232,52396431233,52396432313,52396432322,52396432323,52396433001,52396433021,52396433023,52396501010,52396501232,52396503102,52396503132,52396512202,52396512322,52396512323,52396512332,52396512333,52396513222,52396513223,52396513232,52396531010,52396531012,52396531020,52396531021,52396531022,52396531030,52396533010,52396533011,52396533012,52396533120,52396533122,52396622222,52397403323,52397403331,52397403332,52397403333,52397410203,52397412023,52397412201,52397412203,52397421101,52397421110,52397421111,52397421113,52397430020,52397430021,52397430023,52397430210,52397430211,52397430213,52397430321,52397431220,52397431221,52397431230,52397431330,52397431331,52397503130,52397503131,52397503132,52397503310,52397503312,52397503313,52397510210,52397510211,52397510212,52397510300,52397510301,52397510310,52397510311,52397511130,52397511131,52397511132,52397511200,52397511201,52397511210,52397511211,52397511300,52397512000,52397512002,52397520220,52397520221,52397520223,52397520310,52397520311,52397520312,52397521030,52397521031,52397521110,52397521111,52397521112,52397521120,52397521121,52397521200,52397522010,52397522011,52397522121,52397522123,52397522301,52397522303,52397522310,52397522311,52397522312,52397523000,52397523002,52397523003,52397523030,52397523032,52397523200,52397523201,52397523210,52397600002,52397512032,52396431201,52396431203,52396431120,
082,00,ʿ/,501243750,127012500,501764062,127425000,0,0,7,17,41,105,52397222,52397223,52397232,53390201,53390210,53390211,53390213,523972200,523972202,523972203,523972212,523972213,523972330,523972332,533902000,533902001,533902003,533902030,533902031,533902033,533902120,533902121,533902123,533902311,5239711330,5239711333,5239713110,5239713111,5239713113,5239713131,5239713133,5239713310,5239713311,5239713313,5239720222,5239722010,5239722012,5239722013,5239722102,5239722103,5239722112,5239723020,5239723022,5239723023,5239723032,5239723033,5239723310,5239723311,5239723312,5239723330,5239723332,5239723333,5339011111,5339011113,5339020020,5339020021,5339020023,5339020211,5339020320,5339020321,5339022110,5339022111,5339023011,5339023130,5339023131,52397113312,52397113313,52397113320,52397113321,52397113323,52397131121,52397131123,52397131301,52397131303,52397131321,52397131323,52397133121,52397133311,52397133332,52397133333,52397202232,52397202233,52397202322,52397220110,52397220112,52397220113,52397221002,52397221003,52397221012,52397221132,52397221133,52397230022,52397230023,52397230032,52397230210,52397230212,52397230213,52397230302,52397231222,52397231223,52397231232,52397231233,52397231322,52397231323,52397231332,52397231333,52397233130,52397233131,52397233132,52397233310,52397233312,52397233313,52397320222,52397322000,52397322002,53390111310,53390111311,53390111313,53390200220,53390200221,53390202101,53390202130,53390202131,53390202133,53390202311,53390202313,53390203233,53390212200,53390212201,53390212202,53390212210,53390212211,53390212213,53390212220,53390212222,53390212231,53390212233,53390221011,53390221013,53390221130,53390221132,53390230000,53390230011,53390230100,53390230101,53390231000,53390231001,53390231003,53390231010,53390231011,53390231021,53390231023,53390231213,53390231231,53390231233,53390231320,53390231321,53390231322,53390231330,53390231331,53390300000,53390320002,53390320020,53390320022,53390320200,53390320202,53390320220,53390320222,52397231330,52397231321,
082,01,ƣ//,501735937,127050000,502256250,127518750,0,0,9,18,42,93,52397323,52397332,53390301,53390302,53390303,53390310,53390312,53390321,53390330,523973221,523973222,523973223,523973330,523973332,523973333,533903001,533903002,533903003,533903110,533903111,533903112,533903130,533903132,533903201,533903203,533903231,533903321,5239732201,5239732202,5239732203,5239733101,5239733103,5239733110,5239733112,5239733123,5239733310,5239733312,5339030001,5339030002,5339030003,5339031130,5339031131,5339032001,5339032003,5339032021,5339032023,5339032301,5339032303,5339032330,5339032331,5339032333,5339033100,5339033101,5339033102,5339033120,5339033122,5339033200,5339033201,5339033202,5339033220,5339033231,5339033233,5339033300,5339033302,5339033320,5339033322,5339040000,5339040002,5339131010,52397233133,52397233311,52397320223,52397320232,52397320233,52397320322,52397320323,52397320332,52397322001,52397322003,52397330332,52397330333,52397331001,52397331003,52397331021,52397331110,52397331112,52397331130,52397331211,52397331212,52397331213,52397331221,52397331222,52397331223,52397331300,52397331302,52397331320,52397331322,52397331323,52397333110,52397333112,52397333130,52397333132,52397422220,52397422222,52397422223,52397422232,53390300001,53390300002,53390300003,53390311320,53390311321,53390311322,53390311330,53390311331,53390313100,53390313102,53390313120,53390313122,53390313300,53390313302,53390313320,53390313322,53390320000,53390320001,53390320003,53390320021,53390320023,53390320201,53390320203,53390320221,53390320223,53390323000,53390323001,53390323003,53390323021,53390323210,53390323211,53390323213,53390323231,53390323320,53390323321,53390331030,53390331031,53390331032,53390331100,53390332030,53390332031,53390332220,53390332301,53390332323,53390400010,53390400012,53390400013,53390400030,53390400032,53390400200,53390400201,53390400202,53390400220,53391310110,53391310111,53391311000,
083,00,Į/,501356250,127753125,502171875,128221875,0,1,11,25,42,121,5339232,53392231,53392233,53392302,53392303,53392312,53392330,53392332,53393201,53393210,53393211,53393301,533922131,533922132,533922133,533922301,533922303,533922321,533922322,533922323,533923001,533923003,533923012,533923013,533923130,533923132,533923310,533932003,533932030,533932031,533932120,533932121,533933000,533933001,533933100,533933101,533933102,5339132221,5339132223,5339132232,5339132233,5339132322,5339221133,5339221232,5339221233,5339221303,5339222333,5339223203,5339230001,5339230003,5339230021,5339230022,5339230023,5339230100,5339230102,5339230113,5339231020,5339231022,5339231023,5339231032,5339231033,5339231102,5339231120,5339231122,5339231123,5339233320,5339233322,5339320011,5339320013,5339320211,5339330031,5339330033,5339330300,5339330301,5339331030,5339331031,5339331100,5339331101,5339331102,53391322023,53391322032,53391322033,53391322122,53391322201,53391322203,53391322221,53391322223,53391322300,53391322302,53391322303,53392211323,53392212311,53392212312,53392212313,53392213013,53392213022,53392213023,53392222323,53392222332,53392222333,53392223222,53392223223,53392223232,53392223233,53392223311,53392223312,53392223313,53392223322,53392223323,53392230213,53392230231,53392230233,53392232011,53392232012,53392232013,53392232021,53392232022,53392232023,53392300001,53392300003,53392300021,53392300023,53392300201,53392300203,53392301030,53392301032,53392301033,53392301123,53392310020,53392310022,53392310023,53392310032,53392310210,53392310212,53392310213,53392310302,53392310313,53392311002,53392311003,53392311210,53392311212,53392311213,53392311322,53392313100,53392313102,53392313120,53392313122,53392331200,53392331201,53392331202,53392331210,53392333002,53392333020,53392333022,53392333023,53392333232,53392333233,53392333322,53392333323,53393200101,53393200103,53393200121,53393200123,53393202100,53393202101,53393202103,53393202121,53393202130,53393202131,53393202133,53393202311,53393203200,53393203201,53393203210,53393203211,53393203300,53393213000,53393213002,53393213020,53393213022,53393300200,53393300201,53393300202,53393300210,53393300301,53393300303,53393300321,53393302110,53393302111,53393303100,53393303101,53393303110,53393303111,53393310330,53393311100,53393311200,53393312000,53393312001,53393312010,53393312011,
083,01,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,1,4,16,34,93,213,533912,5339013,5339111,5339113,5339220,53390112,53390113,53390121,53390123,53390220,53390222,53390223,53390232,53390233,53390322,53391101,53391300,53391302,53391320,53392111,53392210,523971321,523971323,523971330,523971332,533901031,533901032,533901033,533901101,533901102,533901103,533901110,533901112,533902020,533902022,533902212,533902213,533902302,533902303,533911031,533911033,533911211,533911213,533913212,533913213,533913230,533913231,533913233,533921101,533921131,533922110,533922111,533922112,533922120,533922121,5239713032,5239713201,5239713203,5239713221,5239713223,5239713330,5239713332,5339010131,5339010132,5339010133,5339010233,5339010301,5339010303,5339011001,5339011003,5339011110,5339011112,5339011130,5339011132,5339011133,5339012011,5339012013,5339012213,5339012231,5339012233,5339020212,5339020230,5339020232,5339020233,5339020322,5339022100,5339022102,5339022103,5339022112,5339023002,5339023003,5339023012,5339023013,5339023103,5339023120,5339023122,5339032320,5339032322,5339110011,5339110013,5339110031,5339110033,5339110211,5339110300,5339110301,5339110303,5339110321,5339112310,5339112311,5339112313,5339130100,5339130102,5339130120,5339130322,5339132100,5339132102,5339132103,5339132112,5339132113,5339132200,5339132201,5339132210,5339132211,5339132213,5339132231,5339132320,5339132321,5339132323,5339211001,5339211031,5339211301,5339211303,5339211331,5339221130,5339221131,5339221220,5339221221,5339221230,5339221300,5339222001,5339222010,5339222100,5339222101,5339222103,5339222110,5339222112,5339230101,5339230110,52397130233,52397130302,52397130303,52397130332,52397132003,52397132021,52397132023,52397132223,52397133120,52397133122,52397133123,52397133310,52397133312,52397133313,52397133330,52397133331,53390101123,53390101132,53390101133,53390101232,53390101233,53390101301,53390101303,53390102312,53390102313,53390103001,53390103003,53390103021,53390103023,53390110001,53390110003,53390110021,53390110022,53390110023,53390111312,53390120310,53390120311,53390120313,53390120331,53390120333,53390122111,53390122113,53390200222,53390200223,53390202100,53390202102,53390202103,53390202132,53390202310,53390202312,53390203230,53390203231,53390203232,53390212203,53390212212,53390212221,53390212223,53390212230,53390212232,53390221010,53390221012,53390221131,53390221133,53390230001,53390230002,53390230003,53390230010,53390230012,53390230013,53390230102,53390230103,53390231002,53390231012,53390231013,53390231020,53390231022,53390231210,53390231211,53390231212,53390231230,53390231232,53390231323,53390231332,53390231333,53390323002,53390323020,53390323022,53390323023,53390323212,53390323230,53391100301,53391100303,53391100321,53391100323,53391102101,53391102103,53391103020,53391103021,53391103231,53391103233,53391121011,53391121013,53391121031,53391121033,53391121211,53391121213,53391121231,53391121233,53391123011,53391123120,53391123121,53391123123,53391123310,53391123311,53391123313,53391123331,53391301220,53391301222,53391303000,53391303002,53391303022,53391303200,53391303202,53391303230,53391303232,53391321010,53391321012,53391321013,53391322020,53391322021,53391322022,53391322030,53391322031,53391322120,53391322121,53391322123,53391322200,53391322202,53391322220,53391322222,53391322301,53391330020,53391330022,53391330200,53391330202,53391330220,53391330222,53391332000,53391332002,53391332020,53392110001,53392110003,53392110301,53392110330,53392110331,53392110333,53392112111,53392113000,53392113001,53392113003,53392113021,53392113022,53392113023,53392113201,53392113210,53392113211,53392113330,53392113331,53392113333,53392211320,53392211321,53392211322,53392212220,53392212221,53392212222,53392212230,53392212231,53392212310,53392213010,53392213011,53392213012,53392213020,53392213021,53392220000,53392220001,53392220003,53392220110,53392220111,53392220112,53392221020,53392221021,53392221023,53392221110,53392221111,53392221112,53392221130,53392221210,53392221211,53392221300,53392230000,53392300000,53392300002,53392300020,53392300022,53392300200,53392300202,53392301031,53392301110,53392301111,53392301112,53392301120,53392301121,53392301122,
084,00,/,500835937,123046875,502045312,125268750,0,1,3,38,102,235,5239032,52390303,52391300,52391301,513921020,513921021,513921023,513921201,513921203,513921210,513921212,513921221,513931321,513942002,513942003,513942020,513942021,513942023,513942201,513942203,513942221,513942230,523902133,523902311,523902313,523902331,523902333,523903012,523903013,523903021,523903022,523903023,523903120,523903300,523903320,523912111,523912113,523912131,523912133,523913020,523913021,523913030,5139210022,5139210023,5139210032,5139210221,5139210223,5139210302,5139210320,5139210322,5139210323,5139210332,5139212001,5139212003,5139212110,5139212112,5139212201,5139212300,5139212301,5139313201,5139313203,5139313230,5139313231,5139313233,5139313302,5139313320,5139313321,5139322232,5139411313,5139420001,5139420002,5139420003,5139420010,5139420012,5139420013,5139420220,5139420221,5139420223,5139422001,5139422003,5139422021,5139422023,5139422122,5139422201,5139422230,5139422231,5139422320,5139422322,5139422323,5139520100,5139520101,5139520102,5139522112,5139522121,5139620013,5139620031,5139620033,5139620120,5139620122,5139620123,5139620211,5139620213,5139620300,5139620301,5139620302,5239023103,5239023121,5239023323,5239030031,5239030032,5239030033,5239030113,5239030201,5239030202,5239030203,5239031020,5239031022,5239031220,5239031222,5239033020,5239033022,5239033220,5239033221,5239033222,5239121101,5239121103,5239121121,5239121123,5239121301,5239121303,5239123110,5239123111,5239130220,5239130221,5239130222,5239130230,5239130231,5239130310,5239130312,5239130320,5239131000,5239131002,5139411321,5139411331,51392011331,51392011333,51392013111,51392013113,51392013131,51392013133,51392100203,51392100212,51392100213,51392100302,51392100303,51392100330,51392100332,51392102200,51392102201,51392103000,51392103002,51392103003,51392103212,51392103213,51392103302,51392103303,51392112203,51392112212,51392112221,51392112223,51392112230,51392112232,51392120023,51392120201,51392120210,51392120211,51392120213,51392120231,51392120233,51392121300,51392121302,51392121320,51392121322,51392122031,51392122033,51392122211,51392122300,51392122301,51392122310,51392123020,51392123021,51392123022,51392123100,51393130233,51393130322,51393130332,51393130333,51393132321,51393132323,51393133000,51393133002,51393133003,51393133012,51393133030,51393133032,51393133033,51393133220,51393133221,51393133222,51393133230,51393222231,51393222232,51393222233,51393222303,51393222312,51393222330,51393222332,51394110110,51394110111,51394111133,51394111311,51394111313,51394111331,51394111333,51394113111,51394113112,51394113113,51394200001,51394200002,51394200003,51394200110,51394200112,51394200113,51394202220,51394202221,51394202223,51394220001,51394220003,51394220223,51394221022,51394221200,51394221202,51394222031,51394222321,51394222330,51394222331,51394223210,51394223211,51394223212,51395200133,51395200311,51395201030,51395201031,51395201032,51395201200,51395201201,51395221031,51395221033,51395221230,51395221231,51395221300,51395221301,51395221302,51396200123,51396200301,51396200303,51396200321,51396200323,51396201020,51396201022,51396201023,51396201210,51396201212,51396201213,51396202101,51396202103,51396202121,51396203030,51396203031,51396203032,51396203200,51396203201,52390213122,52390213123,52390213131,52390213132,52390213133,52390231011,52390231013,52390231231,52390231233,52390233011,52390233013,52390233031,52390233033,52390233211,52390233213,52390300233,52390300303,52390301022,52390301023,52390301032,52390301033,52390301123,52390302002,52390302003,52390310020,52390310022,52390310023,52390310212,52390310230,52390310232,52390310233,52390312102,52390312120,52390312122,52390312210,52390312211,52390312212,52390312230,52390312232,52390312233,52390330100,52390330102,52390330120,52390330210,52390330211,52390330212,52390330230,52390330231,52390330232,52390332120,52390332122,52390332230,52390332232,52391211003,52391211021,52391211023,52391211201,52391211203,52391213001,52391213003,52391213210,52391213211,52391213213,52391213231,52391302230,52391302231,52391302232,52391302320,52391302321,52391303110,52391303111,52391303112,52391303210,52391303211,52391303212,52391310010,52391310012,52391310200,52391310201,52391310202,52391310220,52391310222,52391320000,52391320001,52391320002,52391320010,51394222333,51393222311,51393222133,51393223022,51393223200,51394113230,51394113231,51394113032,51394113033,51392102223,52390310210,
085,00,/Ȭ,502101562,116775000,503521875,122840625,0,0,11,29,94,223,49394632,49395601,49395603,49395610,49395620,50396413,51390420,51390422,51390423,51391400,51391401,483956023,493946231,493946232,493946233,493946302,493946332,493955122,493956021,493956022,493956023,493956110,493956112,493956120,493956121,493956210,493956220,493956221,503964121,503964123,503964310,503964311,503964312,513903313,513903331,513903333,513904212,513914020,513914021,513914030,4839560203,4839560210,4839560212,4839560213,4839560221,4839560223,4839560320,4839562001,4839562003,4839562010,4839562012,4939462132,4939462133,4939462301,4939462302,4939462303,4939463012,4939463030,4939463032,4939550333,4939551333,4939552111,4939552113,4939553000,4939553111,4939553113,4939553131,4939553133,4939553311,4939560023,4939560031,4939560032,4939560033,4939560201,4939560202,4939560203,4939561220,4939561222,4939561300,4939561302,4939562110,4939562111,4939562112,4939562120,4939562121,4939562122,5039641122,5039641123,5039641132,5039641133,5039643010,5039643011,5039643013,5039643031,5039643130,5039643131,5039643132,5039650200,5039650202,5039650220,5039650222,5039652000,5139033112,5139033113,5139033303,5139033321,5139042100,5139042102,5139042130,5139042132,5139042133,5139043200,5139043202,5139043220,5139131110,5139131111,5139131113,5139131131,5139131133,5139131311,5139131313,5139140220,5139140221,5139140230,5139140231,5139140310,5139140311,5139140312,5139140320,5139140321,5139141000,5139141002,5139141020,5139141022,48395602012,48395602013,48395602023,48395602110,48395602112,48395602113,48395602201,48395602203,48395602221,48395602223,48395603002,48395603020,48395603022,48395603023,48395603220,48395603221,48395603222,48395620001,48395620003,48395620021,48395620110,48395620111,48395620112,48395620130,48395620210,48395620211,49394612323,49394612332,49394621233,49394621311,49394621312,49394621313,49394623001,49394623002,49394623003,49394630031,49394630032,49394630033,49394630101,49394630102,49394630103,49394630110,49394630112,49394630113,49394630130,49394630131,49394630132,49394630310,49394630312,49394630330,49394630332,49394633022,49394633023,49394633300,49394633302,49394633320,49394633321,49394633322,49395503133,49395503311,49395503313,49395503323,49395512022,49395512023,49395512031,49395512032,49395512033,49395512122,49395512300,49395512302,49395513311,49395513313,49395521101,49395521103,49395521121,49395521123,49395530010,49395530011,49395530020,49395530021,49395530022,49395531101,49395531103,49395531121,49395531123,49395531301,49395531303,49395531321,49395531323,49395533131,49395533133,49395600123,49395600132,49395600133,49395600212,49395600213,49395600221,49395600223,49395600301,49395600302,49395600303,49395602001,49395602003,49395611100,49395611102,49395611122,49395611300,49395611302,49395612210,49395612211,49395612212,49395612230,49395612300,49395612301,49395612310,49395612311,49395613010,49395613012,49395613030,49395621230,49395621231,49395621232,49395621300,49395621302,49395622210,49395622211,49395623000,49395623001,49395623002,49395623020,49395630000,49395630001,50396410323,50396410331,50396410332,50396410333,50396411303,50396411312,50396411313,50396430120,50396430121,50396430123,50396430301,50396430330,50396430331,50396430333,50396431330,50396433000,50396433001,50396433010,50396433011,50396433100,50396433101,50396500202,50396500220,50396500222,50396500223,50396502012,50396502030,50396502032,50396502210,50396502212,50396502230,50396502232,50396520020,50396520021,50396520022,50396520200,51390331031,51390331033,51390331111,51390331112,51390331113,51390331211,51390331213,51390331231,51390331233,51390333010,51390333011,51390333013,51390333023,51390333201,51390333203,51390333231,51390333233,51390402222,51390402223,51390421030,51390421032,51390421033,51390421312,51390430222,51390432212,51390432220,51390432222,51390432223,51391311011,51391311120,51391311121,51391311123,51391311301,51391311303,51391313103,51391313121,51391313310,51391313311,51391313313,51391402321,51391402330,51391402331,51391403130,51391403131,51391403132,51391403220,51391403221,51391403230,51391403231,51391403300,51391403301,51391403302,51391410030,51391412000,51391412002,
086,00,޸,505040625,87178125,512114062,109781250,0,0,5,45,180,430,37411212,37411230,40420102,40424130,40425110,364123303,364123321,364123330,374112010,374112013,374112031,374112033,384112010,384112012,394261303,394261330,394271002,394271031,394271033,394271210,394271212,394271221,394271223,394271230,394271231,404201001,404201012,404241033,404241123,404241310,404241312,404241320,404241321,404241323,404241330,404251013,404251030,404251121,404251122,404251123,404251130,404251300,404251301,404251322,414231033,414241001,414241002,454052231,454052213,414211323,3641233122,3741022322,3741022323,3741120112,3741120120,3741120121,3741120123,3741120301,3741120303,3741120321,3741120322,3741120323,3741121020,3741121022,3741121302,3741121320,3741121322,3741122100,3741122101,3741122110,3741122111,3741122113,3741122131,3741123100,3741123210,3841022233,3841022322,3841120011,3841120013,3841120031,3841120033,3841120110,3841120112,3841120130,3841120300,3841120301,3841120302,3942610233,3942612011,3942612013,3942612031,3942612033,3942612100,3942612102,3942612120,3942612122,3942612232,3942612233,3942612322,3942613003,3942613012,3942613021,3942613023,3942613123,3942613310,3942701133,3942710101,3942710132,3942712013,3942712031,3942712032,3942712033,3942712110,3942712112,3942712132,3942712223,3942712320,3942712322,3942713202,4040672220,4040672222,4042001331,4042001333,4042003111,4042010001,4042010003,4042010021,4042010022,4042010023,4042010030,4042010031,4042010032,4042010100,4042010102,4042010103,4042010302,4042010320,4042012000,4042411222,4042411223,4042411302,4042411303,4042411320,4042411321,4042411322,4042412111,4042412113,4042412131,4042412133,4042412311,4042412312,4042412313,4042413110,4042413112,4042413223,4042413320,4042413321,4042413322,4042510111,4042510112,4042510113,4042510320,4042510321,4042510331,4042510333,4042511100,4042511102,4042511112,4042511113,4042511201,4042511202,4042511203,4042511310,4042511320,4042511321,4042511322,4042512111,4042512132,4042512133,4042512311,4042512312,4042512313,4042512331,4042512332,4042512333,4042513020,4042513022,4042513100,4042513200,4042513202,4042513203,4042610111,4042610113,4042610131,4042610133,4042611000,4042611002,4042611020,4042611022,4042611200,4042611201,4142113213,4142113223,4142310323,4142312101,4142312103,4142312110,4142312111,4142312112,4142312302,4142312320,4142401131,4142401133,4142403101,4142403110,4142410001,4142410002,4142410003,4142410030,4142410032,4540522303,4540522301,4540522123,4540523022,4540523200,4540523202,4540522331,4540522330,3942610322,3942712130,36412330033,36412330122,36412330123,36412330132,36412330133,36412330211,36412330213,36412330231,36412330233,36412331022,36412331200,36412331202,36412331203,36412332011,36412332013,36412332031,36412332033,36412332211,36412332300,36412332301,36412332310,36412332311,36412333200,36412333201,36412333210,36412333211,37411201102,37411201103,37411201112,37411201130,37411201132,37411201133,37411210022,37411210023,37411210212,37411210230,37411210232,37411210233,37411210322,37411210323,37411210332,37411210333,37411213002,37411213030,37411213032,37411213210,37411213212,37411213230,37411213232,37411221023,37411221121,37411221123,37411221201,37411221203,37411221212,37411221221,37411221230,37411221331,37411221333,37411231010,37411231012,37411231020,37411231022,37411231200,37411231202,37411232001,37411232010,37411232011,37411232120,37411232121,38410222321,38410222323,38410223230,38410223232,38410223233,38410223322,38410223323,38411200101,38411200103,38411200121,38411200123,38411200301,38411200303,38411200321,38411200323,38411201320,38411201321,38411202101,38411202110,38411202111,38411202113,38411202131,38411203030,38411203031,38411203032,38411203200,38411203201,38411203210,39426102321,39426102323,39426120101,39426120103,39426120121,39426120123,39426120301,39426120303,39426120321,39426120323,39426121012,39426121030,39426121210,39426121212,39426122101,39426122110,39426122111,39426122312,39426122313,39426123000,39426123232,39426130012,39426130013,39426130132,39426130133,39426131200,39426131202,39426131220,39426131222,39426131223,39426131322,39426132011,39426132100,39426132101,39426132110,39426133110,39426133112,39426133120,39426133121,39426133200,39426133201,39426133210,39426133211,39427011133,39427011311,39427011313,39427013111,39427013113,39427100021,39427100022,39427100023,39427100030,39427100032,39427100033,39427100110,39427100111,39427100113,39427101000,39427101001,39427101002,39427101030,39427101031,39427101231,39427101233,39427101303,39427101312,39427101330,39427101332,39427102000,39427102001,39427102010,39427103011,39427103013,39427103031,39427103033,39427103211,39427103213,39427103222,39427103223,39427103231,39427103232,39427103233,39427120103,39427120112,39427120113,39427120121,39427120123,39427120301,39427120303,39427121110,39427121111,39427121112,39427121130,39427121132,39427122212,39427122213,39427123210,39427123211,39427123212,39427123230,39427123232,39427123300,39427123301,39427123310,39427123311,39427132000,39427132002,39427132003,39427132200,39427132201,40406633311,40406633313,40406633331,40406633333,40406722210,40406722212,40406722230,40406722232,40420011331,40420011333,40420013111,40420013113,40420013131,40420013132,40420013133,40420100023,40420100201,40420100203,40420100330,40420100331,40420100332,40420101010,40420101012,40420103000,40420103001,40420103010,40420103011,40420103030,40420103032,40420103033,40420103210,40420103211,40420103220,40420103222,40424103121,40424103123,40424103130,40424103132,40424103211,40424103213,40424103231,40424103233,40424112202,40424112211,40424112213,40424113230,40424113231,40424113232,40424113323,40424113332,40424121011,40424123102,40424123103,40424123300,40424123301,40424123310,40424123311,40424131110,40424131300,40424131302,40424131320,40424131322,40424132200,40424132201,40424132210,40424132211,40424132213,40424133100,40424133102,40424133120,40424133122,40424133230,40424133231,40424133232,40424133300,40425101102,40425101103,40425103110,40425103111,40425103120,40425103122,40425103133,40425103220,40425103221,40425103230,40425103231,40425103300,40425111010,40425111012,40425111103,40425111111,40425111112,40425111113,40425111200,40425111202,40425111220,40425111222,40425111223,40425111232,40425111233,40425111322,40425112000,40425112001,40425113120,40425113121,40425113230,40425121131,40425121133,40425121302,40425121303,40425121311,40425121312,40425121313,40425123100,40425123101,40425123300,40425123301,40425130210,40425130212,40425131020,40425131022,40425132010,40425132012,40425132013,40425132300,40425132302,40425132320,40425132322,40425200000,40425200002,40425200020,40425200022,40426103110,40426103111,40426110010,40426110011,40426110012,40426110030,40426110032,40426110033,40426110122,40426110210,40426110211,40426110212,40426110230,40426110232,40426110300,40426112020,40426112021,40426112030,41421132033,41421132103,41421132112,41421132121,41421132122,41421132123,41421132211,41421132212,41421132213,41421133020,41421133022,41421133023,41421133200,41421133201,41422110010,41422110011,41422110100,41422110101,41422110110,41423103133,41423103211,41423103213,41423103221,41423103223,41423112022,41423112200,41423112202,41423112220,41423112222,41423121001,41423121003,41423121021,41423121023,41423121130,41423121132,41423122322,41423122323,41423122332,41423123003,41424011113,41424011131,41424011132,41424011133,41424013111,41424031003,41424031021,41424031023,41424031030,41424031031,41424031032,41424031120,41424031121,41424100001,41424100002,41424100003,41424100310,41424100311,41424100312,41424102000,41424102001,41424102010,41424102011,41424102100,40424103122,40424103033,45405221213,45405230202,37411232013,39426133122,40420101322,40425130211,45405223211,
087,00,ĸ,500104687,126628125,501581250,128175000,1,6,25,90,197,359,533910,5239703,5239712,5338171,5339001,5339002,5339003,52397011,52397012,52397013,52397021,52397023,52397100,52397102,52397103,53380732,53381730,53381731,53381733,53390001,53390003,53390100,53391120,53391122,53392000,53392001,53392010,53392011,53392100,53392101,53392103,53392131,523960131,523960132,523960133,523960310,523960311,523960323,523960332,523960333,523961020,523961022,523961200,523961202,523961220,523961222,523961223,523970023,523970032,523970033,523970101,523970102,523970103,523970201,523970203,523970221,523971010,523971012,523971013,523971120,523971122,523971123,523971132,523971300,523971301,523971310,523971312,533807231,533807332,533807333,533817320,533817321,533827111,533827113,533900001,533900003,533900021,533900023,533901010,533901020,533901021,533901022,533901200,533901202,533901220,533901222,533911000,533911002,533911020,533911022,533911023,533911232,533920021,533920030,533920031,533920120,533920121,533920122,533920130,533920131,533921020,533921021,533921023,533921102,533921120,533921122,533921123,533921211,533921300,533921301,533921303,533921331,533921333,533922202,533922203,533922220,533922221,533922222,533922230,533922231,533931111,533932000,5239601133,5239601213,5239601231,5239601233,5239601301,5239601302,5239601303,5239603011,5239603121,5239603130,5239603131,5239603133,5239603211,5239603212,5239603213,5239603220,5239603221,5239603223,5239603303,5239603311,5239603312,5239603313,5239610021,5239610022,5239610023,5239610230,5239610232,5239612010,5239612012,5239612030,5239612032,5239612210,5239612212,5239612213,5239612320,5239612322,5239612323,5239700212,5239700213,5239700221,5239700223,5239700300,5239700302,5239700303,5239700311,5239700312,5239700313,5239701001,5239701003,5239702001,5239702003,5239702231,5239702232,5239702233,5239710110,5239710112,5239710113,5239711020,5239711022,5239711023,5239711210,5239711212,5239711213,5239711302,5239713020,5239713021,5239713022,5239713031,5239713220,5338072330,5338072331,5338072333,5338073302,5338073303,5338073310,5338073312,5338073313,5338170111,5338170113,5338170131,5338170133,5338170331,5338170333,5338172111,5338172113,5338172131,5338172133,5338172311,5338173221,5338173230,5338173231,5338173233,5338271101,5338271103,5338271121,5339000021,5339000201,5339000203,5339000221,5339000223,5339010110,5339010111,5339010120,5339010121,5339010122,5339010230,5339010232,5339012010,5339012012,5339012030,5339012032,5339012210,5339012212,5339012230,5339012232,5339110010,5339110012,5339110212,5339110213,5339110320,5339110322,5339112100,5339112102,5339112120,5339112122,5339112300,5339112302,5339112303,5339112330,5339112332,5339200201,5339200203,5339200221,5339200230,5339200231,5339200232,5339200320,5339200321,5339200330,5339200331,5339200333,5339201230,5339201231,5339201232,5339201320,5339201321,5339201323,5339201330,5339201331,5339210220,5339210221,5339210223,5339211002,5339211003,5339211032,5339211210,5339211212,5339211213,5339211322,5339211323,5339211330,5339211332,5339212011,5339212100,5339212101,5339212103,5339212131,5339213020,5339213021,5339213023,5339213301,5339213303,5339213321,5339222002,5339222003,5339222012,5339222013,5339222120,5339222122,5339222123,5339222131,5339222132,5339222133,5339222230,5339222231,5339222320,5339222321,5339222330,5339223001,5339223002,5339223003,5339223020,5339223022,5339223200,5339311130,5339311131,5339320021,52396011232,52396011233,52396011322,52396011323,52396012121,52396012123,52396012301,52396012303,52396012321,52396013001,52396013002,52396013003,52396023311,52396023313,52396030131,52396031201,52396031321,52396031323,52396032023,52396032031,52396032032,52396032033,52396032101,52396032102,52396032103,52396032220,52396032221,52396032223,52396033002,52396033020,52396033022,52396033023,52396033101,52396100122,52396100201,52396100202,52396100203,52396100300,52396100302,52396100320,52396100322,52396102100,52396102102,52396102120,52396102122,52396122110,52396122112,52396123022,52396123023,52396123210,52396123212,52396123213,52396123320,52396123322,52396123323,52397001222,52397001223,52397001313,52397001331,52397001332,52397001333,52397002031,52397002033,52397002102,52397002103,52397002111,52397002112,52397002113,52397002203,52397002221,52397002223,52397003010,52397003012,52397003013,52397003103,52397010001,52397010003,52397010021,52397010022,52397010023,52397020210,52397020211,52397020213,52397020231,52397020233,52397022011,52397022013,52397022233,52397022301,52397022302,52397022303,52397101110,52397101112,52397101113,52397110020,52397110022,52397110023,52397110210,52397110212,52397110213,52397110320,52397110322,52397110323,52397112110,52397112112,52397112113,52397113002,52397113030,52397113032,52397113033,52397113322,52397130230,52397130231,52397130232,52397130300,52397130301,52397130330,52397130331,52397130333,52397131120,52397131122,52397131300,52397131302,52397131320,52397131322,52397132000,52397132001,52397132002,52397132020,52397132022,52397132220,52397132221,52397132222,53380723011,53380723013,53380723031,53380723033,53380723211,53380723213,53380723321,53380723323,53380730222,53380730223,53380730232,53380733000,53380733002,53380733003,53380733012,53380733013,53380733112,53380733113,53381701101,53381701123,53381701301,53381701303,53381701321,53381701323,53381703110,53381703111,53381703113,53381703133,53381703303,53381703321,53381703323,53381723131,53381732201,53381732320,53381732321,53382710111,53382711000,53382711001,53382711003,53382711021,53382711023,53382711201,53382711203,53382711230,53382711231,53390000011,53390000013,53390000031,53390000032,53390000033,53390000230,53390000231,53390000233,53390002203,53390002221,53390002223,53390101120,53390101121,53390101122,53390101130,53390101131,53390101230,53390101231,53390101300,53390101302,53390102310,53390102311,53390103000,53390103002,53390103020,53390103022,53390110000,53390110002,53390110020,53390120312,53390120330,53390120332,53390122110,53390122112,53391100300,53391100302,53391100320,53391100322,53391102100,53391102102,53391103022,53391103023,53391103230,53391103232,53391121010,53391121012,53391121030,53391121032,53391121210,53391121212,53391121230,53391121232,53391123010,53391123012,53391123013,53391123122,53391123312,53391123330,53391123332,53391123333,53392002000,53392002001,53392002231,53392002330,53392002331,53392002332,53392003220,53392003221,53392003230,53392003231,53392003233,53392003320,53392003321,53392003323,53392012330,53392012331,53392012332,53392013220,53392013221,53392013320,53392013322,53392013331,53392030100,53392030101,53392031100,53392102220,53392102221,53392102223,53392110000,53392110002,53392110300,53392110302,53392110303,53392110332,53392112110,53392112112,53392112113,53392113002,53392113020,53392113200,53392113202,53392113203,53392113212,53392113213,53392113332,53392120001,53392120010,53392120011,53392120100,53392120101,53392120103,53392121020,53392121021,53392121023,53392121300,53392121301,53392121330,53392121331,53392130220,53392130221,53392130223,53392132111,53392133000,53392133001,53392133003,53392133021,53392133023,53392133231,53392133233,53392212223,53392212232,53392212233,53392220002,53392220113,53392221022,53392221113,53392221131,53392221132,53392221133,53392221212,53392221213,53392221301,53392221302,53392221303,53392222320,53392222321,53392222322,53392222330,53392222331,53392223220,53392223221,53392223230,53392223231,53392223310,53392223320,53392223321,53392230001,53392230002,53392230003,53392230210,53392230211,53392230212,53392230230,53392230232,53392232010,53392232020,53393111011,53393111013,53393111031,53393111320,53393111321,53393111323,53393111330,53393111331,53393200100,53393200102,53393200120,53393200122,53393200200,53393200201,53393200202,
088,00,Ȣ,500315625,126609375,500821875,127040625,0,0,6,17,35,85,52396002,52396003,52396020,52396021,52396022,52397000,523867311,523867313,523867331,523867333,523877111,523877113,523960003,523960012,523960122,523960230,523960231,523960232,523960300,523960302,523960303,523970010,523970011,5238671313,5238671331,5238671333,5238673301,5238673303,5238673321,5238673323,5238771101,5238771103,5238771310,5238771311,5238771313,5239600013,5239600021,5239600023,5239600132,5239601202,5239602330,5239602332,5239602333,5239603010,5239603012,5239603122,5239603123,5239603200,5239603201,5239603301,5239700120,5239700121,5239700123,5239700130,5239700132,5239700200,5239700201,5239700202,52386713111,52386713113,52386713123,52386713301,52386713303,52386713321,52386713323,52386731031,52386731033,52386731211,52386731213,52386731231,52386731233,52387711210,52387711211,52387711213,52387711231,52387711233,52387713121,52387713123,52387713310,52387713311,52387713313,52396000113,52396000221,52396000222,52396000223,52396001020,52396001022,52396001023,52396001032,52396001302,52396001332,52396012002,52396012032,52396012300,52396012302,52396012320,52396012322,52396012323,52396023310,52396023312,52396030130,52396030132,52396030133,52396031200,52396031202,52396031203,52396031320,52396031322,52396032020,52396032021,52396032022,52396032030,52396032100,52396032222,52396033000,52396033001,52396033003,52396033021,52396033100,52396033102,52396033103,52397001220,52397001221,52397001310,52397001311,52397001312,52397001330,52397002030,52397002032,52397002100,52397002101,52397002110,52397002200,52397002201,52397002202,52397002220,52397003011,52397003100,52397003101,52397003102,52397010000,52397010002,52397010020,
089,00,/ϸ,500512500,126478125,501018750,126712500,0,0,3,10,30,57,52395032,52395033,52396010,523950231,523950232,523950233,523950312,523951220,523951222,523960011,523960110,523960111,523961000,5239502300,5239502301,5239502303,5239503022,5239503023,5239503031,5239503032,5239503033,5239503132,5239512031,5239512032,5239512033,5239512120,5239512122,5239512210,5239512212,5239512230,5239512232,5239600100,5239600101,5239600131,5239601120,5239601121,5239601122,5239601130,5239601131,5239601201,5239601210,5239601211,5239610010,52395021323,52395021331,52395021332,52395021333,52395023021,52395023023,52395030302,52395030303,52395031302,52395031303,52395031312,52395031330,52395031332,52395031333,52395120222,52395120223,52395120232,52395120233,52395121032,52395121033,52395121210,52395121212,52395122110,52395122112,52395122130,52395122132,52395122310,52395122312,52395122330,52395122332,52396001021,52396001030,52396001031,52396001033,52396001300,52396001301,52396001303,52396001330,52396001331,52396001333,52396011230,52396011231,52396011320,52396011321,52396012000,52396012001,52396012003,52396012030,52396012031,52396012033,52396012120,52396012122,52396013000,52396100110,52396100120,52396100121,52396100200,
090,00,Ǯ//Ʀ,499964062,124968750,501046875,126525000,0,3,15,65,150,333,5239102,5239203,5239301,52380733,52381703,52381711,52381712,52381713,52381721,52381730,52381731,52381733,52391002,52392000,52392001,52392012,52394012,52395012,523807312,523807313,523817023,523817101,523817103,523817201,523817203,523817221,523817230,523817231,523817320,523817321,523827110,523827111,523827113,523910000,523910002,523910003,523910030,523910032,523910033,523910320,523910322,523920030,523920031,523920033,523920100,523920102,523920132,523920211,523920213,523921220,523921222,523930013,523930233,523930300,523930301,523930303,523930310,523930311,523930321,523930322,523931000,523931002,523931020,523940033,523940100,523940102,523940103,523940211,523940213,523940231,523940233,523940320,523940322,523950011,523950013,523950031,523950033,523950100,523950102,523950211,523950300,523950301,523950310,5238073112,5238073231,5238073232,5238073233,5238170133,5238170203,5238170211,5238170212,5238170213,5238170221,5238170223,5238171001,5238171022,5238171023,5238172230,5238172231,5238172320,5238173220,5238173221,5238173230,5238173231,5238173233,5238271120,5238271121,5238271123,5239002222,5239100010,5239100012,5239100121,5239100122,5239100123,5239100312,5239103002,5239103020,5239103022,5239103023,5239103212,5239200200,5239200201,5239200211,5239200320,5239200321,5239200323,5239201012,5239201030,5239201032,5239201300,5239201302,5239201332,5239201333,5239202101,5239202103,5239202311,5239202333,5239212000,5239212002,5239212003,5239212020,5239212021,5239212022,5239300111,5239300112,5239300113,5239300311,5239300313,5239302312,5239302313,5239303021,5239303023,5239303120,5239303122,5239303201,5239303202,5239303203,5239303230,5239303231,5239303232,5239303300,5239310010,5239310012,5239310030,5239310032,5239310210,5239310212,5239310220,5239310222,5239310230,5239312000,5239312002,5239400110,5239400111,5239400113,5239400131,5239400132,5239400133,5239400311,5239400313,5239400321,5239400323,5239401010,5239401012,5239401013,5239401102,5239401120,5239401122,5239401300,5239401302,5239401320,5239401322,5239402101,5239402103,5239402301,5239402303,5239402320,5239402321,5239402323,5239403000,5239403001,5239403002,5239403010,5239403020,5239403022,5239403023,5239403100,5239403210,5239403232,5239500101,5239500103,5239500121,5239500123,5239500301,5239500303,5239501010,5239501030,5239501032,5239501320,5239501322,5239501323,5239502121,5239502123,5239502130,5239502131,5239503020,5239503021,5239503110,5239503112,5239410330,5239410332,5239410323,5239501012,52380730313,52380730331,52380731023,52380731032,52380731033,52380731130,52380731132,52380732113,52380732131,52380732132,52380732133,52380732231,52380732232,52380732233,52380732303,52381701223,52381701230,52381701232,52381701233,52381701312,52381701313,52381701321,52381701322,52381701323,52381702012,52381702013,52381702023,52381702101,52381702102,52381702103,52381702201,52381702203,52381702221,52381710031,52381710033,52381710202,52381710203,52381710211,52381710212,52381710213,52381720011,52381720013,52381720031,52381720033,52381720211,52381720212,52381720213,52381720230,52381720231,52381720233,52381722011,52381722013,52381722031,52381722033,52381722211,52381722320,52381722321,52381722330,52381722331,52381723211,52381723220,52381723310,52381723311,52381732320,52381732321,52381732323,52382710111,52382710133,52382710311,52382710313,52382711221,52382713101,52382713110,52382713111,52390020220,52390020222,52390022000,52390022002,52390022003,52390022020,52390022022,52390022200,52390022202,52390022203,52390022232,52390022233,52390022322,52391000110,52391000112,52391000130,52391000132,52391001201,52391001202,52391001203,52391001302,52391001303,52391001320,52391001321,52391001322,52391003100,52391003102,52391003103,52391003130,52391003132,52391003133,52391012202,52391012220,52391012222,52391030000,52391030002,52391030210,52391030212,52391032100,52391032102,52391032300,52391032301,52391032302,52391032320,52391032322,52392002100,52392002101,52392002102,52392002131,52392002133,52392002311,52392002313,52392003220,52392003221,52392003223,52392010100,52392010102,52392010330,52392010332,52392010333,52392011222,52392011223,52392013010,52392013012,52392013030,52392013032,52392013033,52392013300,52392013302,52392013303,52392013312,52392013313,52392021001,52392021211,52392021213,52392023101,52392023130,52392023131,52392023133,52392023311,52392023313,52392023323,52392102220,52392102222,52392102223,52392102232,52392120010,52392120012,52392120230,52392120231,52392120232,52392120300,52392120302,52392120320,52392122120,52392122122,52392122300,52392122302,52392122320,52392122322,52393001101,52393001103,52393003100,52393003101,52393003103,52393003121,52393003311,52393003313,52393003331,52393003333,52393021111,52393021113,52393021131,52393023033,52393023103,52393023110,52393023112,52393023113,52393023211,52393023213,52393023231,52393023233,52393030201,52393031210,52393031211,52393031300,52393031301,52393031310,52393031311,52393032002,52393032003,52393032330,52393032332,52393033020,52393033021,52393033022,52393100130,52393100132,52393100310,52393100312,52393100330,52393102110,52393102112,52393102130,52393102132,52393102210,52393102211,52393102212,52393102232,52393102310,52393102312,52393120010,52393120200,52394001011,52394001120,52394001121,52394001123,52394001301,52394001303,52394003033,52394003100,52394003101,52394003103,52394003121,52394003122,52394003123,52394010110,52394010112,52394010113,52394011002,52394011003,52394011012,52394011030,52394011032,52394011232,52394013010,52394013012,52394013030,52394013032,52394013210,52394013212,52394013230,52394013232,52394021001,52394021003,52394021021,52394021023,52394021201,52394021210,52394021211,52394021213,52394021231,52394021232,52394021233,52394023001,52394023003,52394023021,52394023023,52394023220,52394023221,52394023223,52394030030,52394030031,52394030032,52394030110,52394030111,52394030113,52394030131,52394030210,52394030212,52394030213,52394030320,52394030322,52394031010,52394031012,52394031020,52394031021,52394032120,52394032122,52394032300,52394032302,52395001001,52395001003,52395001021,52395001023,52395003211,52395003233,52395010312,52395010330,52395010332,52395010333,52395013020,52395013022,52395013023,52395013210,52395013212,52395013213,52395013322,52395021011,52395021013,52395021031,52395021032,52395021033,52395021201,52395021203,52395021221,52395021223,52395021320,52395021321,52395021322,52395021330,52395030300,52395030301,52395031300,52395031301,52394103211,52394103213,52391000133,52391012200,
092,00,/Ʀ,499457812,124546875,500385937,125175000,0,2,8,43,86,183,5138763,5238070,51387722,52380601,52380610,52380611,52380712,52380720,52380721,52380723,513876121,513876123,513876132,513876133,513876211,513876212,513876213,513876230,513876231,513876233,513877200,513877202,513877203,513877212,513877230,513877232,513877233,513877332,523806003,523806020,523806021,523806030,523806031,523806032,523806120,523806121,523806130,523806131,523806133,523806311,523806313,523807100,523807102,523807103,523807110,523807221,523807223,523807300,523807301,523807302,523807320,523817010,523817011,5138760332,5138760333,5138761032,5138761033,5138761122,5138761202,5138761203,5138761221,5138761222,5138761223,5138761300,5138761302,5138761303,5138761312,5138762033,5138762103,5138762211,5138762321,5138762322,5138762323,5138770222,5138770223,5138772010,5138772012,5138772013,5138772102,5138772312,5138773213,5138773220,5138773222,5138773223,5138773231,5138773233,5138773302,5138773303,5138773330,5138773332,5238051133,5238051311,5238051313,5238060013,5238060221,5238060230,5238060231,5238060233,5238060330,5238061231,5238061320,5238061321,5238063101,5238063103,5238063311,5238071011,5238071012,5238071013,5238071120,5238071121,5238071122,5238071300,5238071302,5238071320,5238071322,5238071323,5238072200,5238072201,5238072203,5238072221,5238073030,5238073032,5238073100,5238073101,5238073110,5238073210,5238073212,5238073220,5238073221,5238073222,5238170011,5238170013,5238170031,5238170033,5238170120,5238170121,5238170130,5238171000,5238171002,51387603213,51387603231,51387603233,51387603302,51387603303,51387610231,51387610233,51387610313,51387611202,51387611203,51387611230,51387611232,51387612011,51387612012,51387612013,51387612201,51387612202,51387612203,51387613010,51387613012,51387613013,51387613102,51387613103,51387613132,51387613133,51387620311,51387620312,51387620313,51387621011,51387621013,51387621022,51387621023,51387622130,51387622131,51387622331,51387622333,51387623200,51387623201,51387623203,51387702022,51387702200,51387702202,51387702203,51387702320,51387702322,51387702323,51387720111,51387720112,51387720113,51387721000,51387721002,51387721003,51387721030,51387721032,51387723102,51387723132,51387723133,51387732022,51387732103,51387732112,51387732113,51387732121,51387732123,51387732212,51387732213,51387732301,51387732303,51387732321,51387733002,51387733003,51387733012,51387733013,51387733122,51387733123,52380511323,52380513101,52380513311,52380600111,52380600113,52380600122,52380600123,52380600220,52380600222,52380600223,52380600231,52380600232,52380600233,52380602200,52380602201,52380602203,52380602231,52380602320,52380602321,52380602323,52380603310,52380603311,52380612201,52380612210,52380612211,52380612300,52380612301,52380613220,52380613221,52380613230,52380613231,52380613233,52380620110,52380620111,52380620113,52380621000,52380621001,52380621010,52380621011,52380631003,52380631211,52380631213,52380633100,52380633101,52380633103,52380633121,52380633130,52380633131,52380633133,52380710102,52380710103,52380711230,52380711232,52380711300,52380713010,52380713012,52380713030,52380713032,52380713210,52380713212,52380713213,52380713322,52380722020,52380722021,52380722023,52380722231,52380730310,52380730311,52380730312,52380730330,52380730332,52380730333,52380731020,52380731021,52380731022,52380731030,52380731031,52380731112,52380732110,52380732111,52380732112,52380732130,52380732230,52380732300,52380732301,52380732302,52381700100,52381700101,52381700103,52381700121,52381700123,52381700301,52381700303,52381701220,52381701221,52381701222,52381701231,52381701310,52381701311,52381701320,52381710030,52381710032,52381710200,52381710201,52381710210,52380713320,52380713323,51387732111,51387733000,
093,00,//¾,499443750,125896875,500470312,127434375,0,13,26,63,159,295,5238563,5238570,5238572,5238661,5238670,5238672,5238761,5238763,5238770,5238772,5238773,5338070,5338071,52384722,52385613,52385621,52385623,52385730,52385732,52386601,52386631,52386632,52386633,52386710,52386711,52386712,52386730,52386732,52387603,52387621,52387623,52387710,52387712,53380600,53380601,53380610,53380611,53380613,53380731,523836322,523836323,523836330,523836332,523836333,523846013,523846100,523846101,523846102,523846110,523846111,523846333,523847000,523847002,523847201,523847203,523847232,523856033,523856111,523856112,523856113,523856121,523856122,523856123,523856201,523857102,523857120,523857122,523857123,523857312,523857330,523857332,523857333,523866031,523866231,523866233,523866301,523866302,523866303,523867130,523867132,523876011,523876012,523876013,523876023,523876201,523876203,523876221,523876223,523877130,523877132,533806020,533806021,533806030,533806031,533806120,533806121,533807210,533807211,533807213,533807300,533807301,533807303,5238362333,5238363033,5238363122,5238363202,5238363203,5238363211,5238363212,5238363213,5238363312,5238363313,5238372220,5238372222,5238372223,5238460111,5238460112,5238460113,5238460121,5238460123,5238460301,5238461030,5238461031,5238461032,5238461120,5238461121,5238461130,5238461131,5238461133,5238463312,5238463313,5238463321,5238463323,5238470010,5238470012,5238470013,5238470030,5238470031,5238470033,5238470122,5238470211,5238470212,5238470213,5238470231,5238470233,5238470322,5238472003,5238472021,5238472023,5238472122,5238472300,5238472302,5238472303,5238472332,5238560233,5238560322,5238560323,5238561033,5238561101,5238561103,5238561201,5238561202,5238561203,5238562001,5238562003,5238562031,5238562033,5238562211,5238571002,5238571212,5238573100,5238573102,5238573132,5238573310,5238573312,5238573313,5238660011,5238660013,5238660031,5238660033,5238660300,5238660301,5238660330,5238660331,5238660333,5238662132,5238662133,5238663000,5238663001,5238663003,5238671310,5238673100,5238673101,5238673102,5238673120,5238673122,5238673300,5238673302,5238673320,5238673322,5238760101,5238760102,5238760103,5238760211,5238760213,5238762201,5238762203,5238762221,5238762222,5238762223,5238771100,5238771102,5238771120,5238771122,5238771330,5238771332,5238771333,5239600000,5239600002,5239600020,5239702000,5239702002,5239702020,5239702022,5239702200,5239702202,5239702203,5239702220,5239702221,5239702222,5338051113,5338051131,5338051133,5338051310,5338051311,5338051313,5338060321,5338060330,5338060331,5338061220,5338061221,5338061230,5338061231,5338061233,5338063100,5338063101,5338063110,5338072001,5338072010,5338072011,5338072013,5338072120,5338072121,5338073020,5338073021,5339000000,5339000002,5339000020,5339000022,5339000200,5339000202,52383623113,52383623131,52383623133,52383623311,52383623312,52383623313,52383623323,52383630312,52383630313,52383631202,52383631203,52383631232,52383632002,52383632003,52383632012,52383632013,52383632101,52383632102,52383632103,52383633100,52383633102,52383633103,52383722020,52383722022,52383722210,52383722212,52383722322,52384601031,52384601032,52384601033,52384601101,52384601102,52384601103,52384601201,52384601202,52384601203,52384601220,52384601221,52384601223,52384603001,52384603003,52384603021,52384603030,52384603031,52384603100,52384603101,52384610330,52384610331,52384611220,52384611231,52384611320,52384611321,52384611323,52384612010,52384612011,52384613111,52384633103,52384633113,52384633221,52384633223,52384700110,52384700112,52384700113,52384700320,52384700321,52384701002,52384701020,52384701202,52384702000,52384702001,52384702010,52384702011,52384702031,52384702033,52384702101,52384702103,52384702211,52384702300,52384702301,52384703000,52384703001,52384703002,52384703200,52384703202,52384703203,52384720011,52384720013,52384720201,52384720203,52384720221,52384720222,52384720223,52384721000,52384721001,52384721002,52384721020,52384721022,52384721200,52384721202,52384721232,52384723010,52384723012,52384723013,52384723120,52384723122,52384723300,52384723302,52384723303,52384723330,52384723332,52384723333,52385602233,52385602322,52385602323,52385603123,52385603131,52385603132,52385603133,52385603203,52385603211,52385603212,52385603213,52385610311,52385610312,52385610313,52385610321,52385610322,52385610323,52385611001,52385611003,52385611021,52385611022,52385611023,52385612003,52385620001,52385620003,52385620210,52385620211,52385620301,52385622131,52385622133,52385622311,52385622323,52385622332,52385622333,52385710012,52385710030,52385710032,52385710033,52385710322,52385712100,52385712102,52385712132,52385713220,52385713222,52385731030,52385731032,52385731302,52385733112,52385733113,52386600101,52386600103,52386602111,52386603030,52386603031,52386603033,52386603321,52386621111,52386621313,52386623031,52386623033,52386623211,52386623213,52386623231,52386623232,52386623233,52386630020,52386630021,52386630023,52386713110,52386713112,52386713120,52386713121,52386713122,52386713300,52386713302,52386713320,52386713322,52386731030,52386731032,52386731210,52386731212,52386731230,52386731232,52387600311,52387600313,52387600331,52387600332,52387600333,52387601001,52387601003,52387602121,52387602123,52387602233,52387620011,52387620013,52387620031,52387620033,52387620211,52387620213,52387620231,52387620232,52387620233,52387622021,52387622023,52387622201,52387622203,52387711212,52387711230,52387711232,52387713120,52387713122,52387713312,52395022022,52395022200,52395022202,52395022220,52395022222,52395022223,52396000012,52396000030,52396000032,52396000033,52396000220,52397002222,52397020212,52397020230,52397020232,52397022010,52397022012,52397022230,52397022231,52397022232,52397022300,53380511111,53380511112,53380511113,53380511321,53380511323,53380513120,53380513121,53380602210,53380602211,53380602300,53380602301,53380602310,53380602311,53380603200,53380603201,53380612321,53380630110,53380630111,53380630113,53380631021,53380631030,53380631031,53380631110,53380631112,53380631120,53380720001,53380720121,53380720311,53380721221,53380721230,53380721231,53380721233,53380730220,53380730221,53380730230,53380730231,53380730233,53380733001,53380733010,53380733011,53380733110,53380733111,53390000010,53390000012,53390000030,53390000232,53390002200,53390002201,53390002202,53390002220,53390002222,
093,01,Ʀ,499457812,124912500,500034375,126046875,0,2,15,46,91,215,5238161,5238163,52380623,52380630,52380632,52381601,52381603,52381621,52381623,52382601,52382603,52382610,52382621,52382632,52383601,52383603,52383621,523806200,523806202,523806203,523806211,523806212,523806213,523806221,523806223,523806330,523806332,523806333,523816021,523816023,523816201,523816203,523816221,523816223,523817000,523817002,523826001,523826021,523826023,523826110,523826111,523826112,523826120,523826121,523826122,523826201,523826231,523826233,523826300,523826302,523826303,523827000,523836023,523836100,523836101,523836102,523836120,523836122,523836201,523836230,523836232,523836300,523836302,5238051333,5238053111,5238053113,5238053131,5238060222,5238060332,5238060333,5238061222,5238061223,5238061232,5238061233,5238062010,5238062012,5238062013,5238062102,5238062103,5238062200,5238062201,5238062203,5238062221,5238063102,5238063120,5238063122,5238063123,5238072220,5238072222,5238160033,5238160223,5238162001,5238162003,5238162023,5238162201,5238162203,5238170032,5238170200,5238172000,5238172002,5238172020,5238172022,5238172200,5238172202,5238172220,5238172222,5238172223,5238260031,5238260203,5238260221,5238260223,5238261130,5238261132,5238261230,5238261232,5238261300,5238262001,5238262003,5238262030,5238262031,5238262033,5238262300,5238262301,5238262303,5238262321,5238262323,5238263010,5238263012,5238263013,5238360211,5238360213,5238361030,5238361032,5238361210,5238361212,5238361230,5238361231,5238361232,5238362030,5238362031,5238362033,5238362211,5238362213,5238362231,5238362310,5238362312,5238362330,5238363010,5238363012,5238363030,5238363032,5238460100,5238460101,5238460102,52380513310,52380513312,52380513313,52380531301,52380531303,52380531330,52380531331,52380531333,52380533111,52380602202,52380602230,52380602232,52380602233,52380602322,52380603312,52380603313,52380612200,52380612202,52380612203,52380612212,52380612213,52380612302,52380612303,52380613222,52380613223,52380613232,52380620112,52380621002,52380621003,52380621012,52380621013,52380622201,52380622203,52380622231,52380631000,52380631001,52380631002,52380631210,52380631212,52380633102,52380633120,52380633122,52380633123,52380633132,52380722022,52380722230,52380722232,52380722233,52381600101,52381600110,52381600111,52381600113,52381600131,52381600133,52381600303,52381600311,52381600312,52381600313,52381600320,52381600321,52381600323,52381602211,52381602213,52381620003,52381620021,52381620023,52381620211,52381620221,52381620223,52381622001,52381622003,52381622021,52381622023,52381622210,52381622211,52381622213,52381622231,52381622233,52381700102,52381700120,52381700122,52381700300,52381700302,52381702010,52381702011,52381702020,52381702021,52381702022,52381702100,52381702200,52381702202,52381702220,52381702222,52381702223,52381720010,52381720012,52381720030,52381720032,52381720210,52381720232,52381722010,52381722012,52381722030,52381722032,52381722210,52381722212,52381722213,52381722322,52382600011,52382600013,52382600031,52382600301,52382600323,52382600331,52382600332,52382600333,52382602012,52382602013,52382602021,52382602023,52382602201,52382611310,52382611311,52382611312,52382611330,52382612310,52382612311,52382612312,52382612330,52382613010,52382613011,52382613020,52382620211,52382620320,52382620321,52382620323,52382623020,52382623021,52382623203,52382623221,52382623223,52382630112,52382631022,52382631200,52382631202,52382631220,52382631222,52382633000,52382633002,52382633020,52382633022,52382633023,52382633200,52382633201,52382633202,52382633220,52382700100,52382700102,52382700120,52382700201,52383600131,52383600133,52383600311,52383600313,52383600331,52383600333,52383602121,52383602122,52383602123,52383610310,52383610311,52383610312,52383610330,52383610332,52383612110,52383612112,52383612130,52383612132,52383612330,52383612332,52383620011,52383620013,52383620031,52383620033,52383620211,52383620320,52383620321,52383620323,52383622101,52383622103,52383622331,52383623110,52383623111,52383623112,52383623130,52383623132,52383623310,52383623320,52383623321,52383623322,52383630110,52383630112,52383630130,52383630132,52383630310,52383632000,52383632001,52383632010,52383632011,52383632100,52384600131,52384600133,52384601030,52384601100,52384601200,
093,02,Ʀ,499809375,125362500,500653125,126637500,0,7,23,41,109,247,5238272,5238273,5238370,5238371,5238373,5238471,5238473,52382701,52382702,52382703,52382712,52383611,52383613,52383720,52383721,52383723,52385711,52392020,52392022,52393000,52393002,52393020,52393022,52394000,52394002,52394020,52394022,52395000,52395002,52395020,523826131,523826132,523826133,523826311,523826313,523826331,523826333,523827003,523827100,523827102,523827130,523827132,523827133,523836310,523836311,523836313,523837221,523847011,523847013,523847031,523847033,523847211,523847213,523857101,523857130,523857131,523857133,523857311,523920022,523920230,523920232,523930010,523930012,523930030,523930032,523930210,523930212,523930213,523940012,523950221,523950223,5238172323,5238172330,5238172332,5238172333,5238173222,5238173223,5238261303,5238263100,5238263101,5238263103,5238263121,5238263123,5238263301,5238263303,5238263321,5238263323,5238270011,5238270013,5238270021,5238270022,5238270023,5238271010,5238271012,5238271030,5238271032,5238271033,5238271312,5238271313,5238363121,5238363311,5238372200,5238372201,5238372203,5238372230,5238372231,5238372233,5238470101,5238470103,5238470121,5238470123,5238470301,5238470302,5238470303,5238470321,5238470323,5238472101,5238472103,5238472121,5238472310,5238472311,5238472313,5238472331,5238571000,5238571030,5238571031,5238571033,5238571211,5238571320,5238571321,5238571323,5238573101,5238573131,5238573133,5239200202,5239200203,5239200212,5239200230,5239200232,5239200233,5239202102,5239202120,5239202122,5239202123,5239202312,5239202330,5239300330,5239300332,5239302110,5239302112,5239302300,5239302301,5239302302,5239302320,5239302322,5239303022,5239400100,5239400102,5239400103,5239400300,5239400301,5239400302,5239400320,5239400322,5239402122,5239500120,5239500122,5239500300,5239500302,5239500320,5239500322,5239502100,5239502102,5239502200,5239502201,5239502203,5239502221,5239502223,5239600010,5239600012,52381722323,52381722332,52381722333,52381723210,52381723212,52381723213,52381723221,52381723222,52381723223,52381723312,52381723313,52381732322,52382611313,52382611331,52382611332,52382611333,52382612313,52382612331,52382612332,52382612333,52382613012,52382613013,52382613021,52382613022,52382613023,52382630110,52382630111,52382630113,52382631020,52382631021,52382631023,52382631201,52382631203,52382631221,52382631223,52382633001,52382633003,52382633021,52382633203,52382633221,52382633222,52382633223,52382700101,52382700103,52382700121,52382700122,52382700123,52382700200,52382700202,52382700203,52382710110,52382710112,52382710113,52382710130,52382710131,52382710132,52382710310,52382710312,52382711220,52382711222,52382711223,52382713100,52382713102,52382713103,52382713112,52382713113,52383610313,52383610331,52383610333,52383612111,52383612113,52383612131,52383612133,52383612331,52383612333,52383630111,52383630113,52383630131,52383630133,52383630311,52383631200,52383631201,52383631230,52383631231,52383631233,52383633101,52383722021,52383722023,52383722211,52383722213,52383722320,52383722321,52383722323,52384700111,52384701000,52384701001,52384701003,52384701021,52384701022,52384701023,52384701200,52384701201,52384701203,52384703003,52384703201,52384721003,52384721021,52384721023,52384721201,52384721203,52384721230,52384721231,52384721233,52384723011,52384723121,52384723123,52384723301,52384723331,52385710010,52385710011,52385710013,52385710031,52385710320,52385710321,52385710323,52385712101,52385712103,52385712130,52385712131,52385712133,52385713221,52385713223,52385731031,52385731033,52385731300,52385731301,52385731303,52385733110,52385733111,52392002103,52392002130,52392002132,52392002310,52392002312,52392003222,52392021000,52392021002,52392021003,52392021210,52392021212,52392023100,52392023102,52392023103,52392023132,52392023310,52392023312,52392023320,52392023321,52392023322,52393001100,52393001102,52393003102,52393003120,52393003122,52393003123,52393003310,52393003312,52393003330,52393003332,52393021110,52393021112,52393021130,52393021132,52393021133,52393023030,52393023031,52393023032,52393023100,52393023101,52393023102,52393023111,52393023210,52393023212,52393023230,52393023232,52393030200,52393030202,52393030203,52393032000,52393032001,52394001010,52394001012,52394001013,52394001122,52394001300,52394001302,52394003030,52394003031,52394003032,52394003102,52394003120,52394021000,52394021002,52394021020,52394021022,52394021200,52394021202,52394021203,52394021212,52394021230,52394023000,52394023002,52394023020,52394023022,52394023222,52395001000,52395001002,52395001020,52395001022,52395003210,52395003212,52395003213,52395003230,52395003231,52395003232,52395021010,52395021012,52395021030,52395021200,52395021202,52395021220,52395021222,52395022020,52395022021,52395022023,52395022201,52395022203,52395022221,52395023020,52395023022,52396000010,52396000011,52396000013,52396000031,52396000110,52396000111,52396000112,
094,00,ٻε,498895312,127265625,500639062,128643750,2,12,27,82,164,345,533815,533816,5338053,5338062,5338260,5338261,5338263,5338270,5338272,5338273,5338370,5338371,5338372,5338470,53380522,53380523,53380632,53380633,53380722,53381413,53381431,53381700,53381702,53381720,53381722,53382500,53382510,53382511,53382712,53382713,53383601,53383610,53383611,53383613,53383730,53383731,53383732,53384710,53384721,53393000,53393001,533804331,533804333,533805120,533805122,533805123,533805132,533805133,533805213,533806300,533806302,533806303,533806312,533806313,533807202,533814111,533814113,533814330,533814331,533814333,533817010,533817012,533817030,533817032,533817210,533817212,533817230,533817232,533817233,533824111,533824113,533824130,533824131,533824133,533825010,533825011,533825020,533825121,533825130,533825131,533825133,533826200,533826201,533826210,533826211,533826213,533826231,533826233,533827100,533827102,533827103,533836030,533836031,533836120,533836121,533836123,533836310,533836311,533836313,533836331,533836333,533837330,533837331,533837332,533846111,533846113,533846131,533846133,533846311,533847110,533847120,533847121,533847122,533847200,533847201,533847203,533847300,533920200,533930020,533930022,533930200,533930202,533930220,5338043132,5338043133,5338043323,5338050311,5338050313,5338050331,5338050333,5338051212,5338051213,5338051303,5338052022,5338052111,5338052112,5338052113,5338060220,5338060222,5338060223,5338060232,5338060233,5338060322,5338060323,5338060332,5338060333,5338061222,5338061223,5338063010,5338063012,5338063013,5338063113,5338072002,5338072003,5338072030,5338072032,5338072033,5338072300,5338072302,5338072320,5338072322,5338072323,5338141033,5338141101,5338141103,5338141121,5338141122,5338141123,5338141211,5338141213,5338141231,5338141233,5338143011,5338143013,5338143031,5338143033,5338143320,5338143321,5338143323,5338170310,5338170312,5338172110,5338172112,5338172130,5338172132,5338172310,5338172312,5338173222,5338173223,5338241101,5338241103,5338241121,5338241123,5338241320,5338241321,5338241323,5338243101,5338243110,5338243111,5338250120,5338250121,5338250130,5338250131,5338250133,5338250210,5338250220,5338250222,5338251200,5338251201,5338251203,5338251231,5338251320,5338251321,5338251323,5338253110,5338253111,5338262030,5338262031,5338262120,5338262121,5338262303,5338262321,5338262322,5338262323,5338271010,5338271012,5338271013,5338271122,5338360011,5338360013,5338360031,5338360032,5338360033,5338360331,5338361220,5338361221,5338361223,5338363010,5338363011,5338363013,5338363121,5338363123,5338363301,5338363303,5338363321,5338363323,5338373330,5338373331,5338373332,5338461101,5338461103,5338463130,5338463131,5338471110,5338471112,5338471120,5338471121,5338471122,5338471230,5338471232,5338471300,5338472020,5338472021,5338472023,5338472211,5338472300,5338472301,5338473010,5338473020,5339200202,5339200220,5339200222,5339202010,5339202020,5339202021,5339202022,5339202200,5339202202,5339202220,5339202222,5339202223,5339300210,5339300211,5339300212,5339302212,5339302220,5339302221,53380431302,53380431303,53380431312,53380433011,53380433013,53380433031,53380433033,53380433211,53380433212,53380433213,53380501332,53380501333,53380503301,53380503303,53380503321,53380503323,53380512100,53380512102,53380512103,53380512112,53380513020,53380513022,53380513023,53380513122,53380513123,53380520230,53380520232,53380520233,53380520322,53380520323,53380520332,53380520333,53380521101,53380521103,53380521222,53380521223,53380521231,53380521232,53380521233,53380602212,53380602213,53380602302,53380602303,53380602312,53380602313,53380603202,53380603203,53380612320,53380612322,53380612323,53380630112,53380631020,53380631022,53380631023,53380631032,53380631033,53380631111,53380631113,53380631121,53380631122,53380631123,53380720000,53380720002,53380720003,53380720120,53380720122,53380720123,53380720310,53380720312,53380720313,53380721220,53380721222,53380721223,53380721232,53380723010,53380723012,53380723030,53380723032,53380723210,53380723212,53380723320,53380723322,53381411021,53381411023,53381411201,53381411202,53381411203,53381412101,53381412103,53381412121,53381412301,53381412303,53381412321,53381412323,53381430101,53381430103,53381430121,53381430123,53381430301,53381430303,53381430321,53381433221,53381701100,53381701102,53381701103,53381701120,53381701121,53381701122,53381701300,53381701302,53381701320,53381701322,53381703112,53381703130,53381703131,53381703132,53381703300,53381703301,53381703302,53381703320,53381703322,53381723130,53381723132,53381723133,53381732200,53381732202,53381732203,53381732322,53381732323,53382411021,53382411023,53382411201,53382411203,53382411221,53382411222,53382411223,53382412111,53382412113,53382412131,53382412133,53382412311,53382412313,53382413220,53382413221,53382413223,53382431001,53382431003,53382431021,53382431030,53382431031,53382431033,53382431120,53382431121,53382501231,53382501320,53382501321,53382502110,53382502120,53382502121,53382502122,53382502210,53382502211,53382502212,53382502230,53382502300,53382503111,53382503113,53382512020,53382512021,53382512023,53382512210,53382512211,53382512300,53382512301,53382512303,53382512331,53382513220,53382513221,53382520000,53382520001,53382531010,53382531011,53382531130,53382531131,53382620211,53382620320,53382620321,53382620330,53382620331,53382621230,53382621231,53382621233,53382622331,53382622332,53382622333,53382623011,53382623013,53382710110,53382710112,53382710113,53382711002,53382711020,53382711022,53382711200,53382711202,53382711232,53382711233,53383600301,53383600303,53383602111,53383603201,53383603210,53383603211,53383603300,53383603301,53383603303,53383603330,53383603331,53383612221,53383612223,53383630010,53383630011,53383630013,53383630121,53383630311,53383631200,53383631201,53383631203,53383631221,53383631223,53383633003,53383633021,53383633023,53383633201,53383633203,53383633221,53383633223,53383733330,53383733331,53383733332,53384611001,53384611003,53384611021,53384611210,53384611211,53384611213,53384613031,53384613033,53384613211,53384613213,53384613231,53384613233,53384631011,53384631013,53384631031,53384631033,53384631211,53384631320,53384631321,53384631330,53384631331,53384711230,53384711231,53384711232,53384711300,53384711301,53384711302,53384712310,53384712311,53384712312,53384712330,53384712332,53384713010,53384713012,53384713020,53384713021,53384713022,53384720220,53384720221,53384722011,53384722100,53384722101,53384722103,53384723100,53384723101,53384723102,53384723110,53384730110,53384730111,53384730112,53384730120,53384730121,53384730122,53384730130,53384730210,53384730211,53384730212,53384730220,53384730221,53392002002,53392002003,53392002230,53392002232,53392002233,53392020110,53392020112,53392020120,53392020121,53392020122,53392020230,53392020231,53392020232,53392020300,53392020302,53392022322,53392022323,53392022332,53392022333,53392023222,53393002300,53393002301,53393002302,53393002320,53393002322,53393003000,53393003001,53393003002,53393003010,53393003101,53393003110,53393003111,53393003113,53393010000,53393010002,53393010220,53393020100,53393020320,53393020322,53393022100,53393022102,53393022103,53393022220,53393022221,53393022300,53393022302,
095,00,ٻ/ٻε,498698437,126393750,499739062,127593750,2,4,20,47,89,147,523865,523875,5238643,5238741,5238743,5338041,52385523,52385532,52385533,52386401,52386403,52386421,52386423,52386620,52386622,52387401,52387403,52387421,52387423,53380401,53380403,53380430,53380432,53380500,53380502,53380510,523855023,523855201,523855203,523855210,523855212,523855213,523855221,523855222,523855223,523855302,523855303,523855312,523855313,523856220,523856222,523866000,523866002,523866020,523866022,523866023,523866032,523866210,523866212,523876000,523876001,523876002,523876020,533804211,533804213,533804230,533804231,533804233,533804310,533804311,533804312,533805010,533805011,533805012,533805030,533805032,533805110,533805112,533805200,533805201,533805210,533814100,533814101,5238550322,5238550323,5238552001,5238552003,5238552021,5238552023,5238552110,5238552112,5238552113,5238552201,5238552202,5238552203,5238553002,5238553003,5238553012,5238553013,5238553102,5238553103,5238553112,5238553113,5238562002,5238562020,5238562022,5238562023,5238562032,5238562210,5238562212,5238562230,5238660012,5238660030,5238660032,5238660210,5238660212,5238660213,5238660302,5238662110,5238662112,5238662113,5238662130,5238662300,5238662301,5238662302,5238662320,5238662322,5238760030,5238760032,5238760210,5238760220,5238760221,5238760222,5238762000,5238762002,5238762020,5238762022,5238762200,5338042100,5338042101,5338042103,5338042121,5338042123,5338042321,5338043300,5338043302,5338043320,5338043322,5338050130,5338050131,5338050132,5338050310,5338050312,5338051110,5338051112,5338051130,5338051300,5338051301,5338052020,5338052021,5338052030,5338052031,5338052120,5338052121,5338140111,5338141020,5338141021,5338141023,5338141030,5338141031,5338141032,5338141100,52385502120,52385502122,52385502123,52385502132,52385502213,52385502231,52385502233,52385503202,52385503203,52385503322,52385503323,52385520201,52385520203,52385520221,52385520223,52385521110,52385521112,52385521113,52385522001,52385522003,52385530002,52385530003,52385531103,52385531112,52385531113,52385620002,52385620212,52385620213,52385620300,52385620302,52385620303,52385622130,52385622132,52385622310,52385622312,52385622313,52385622320,52385622321,52385622322,52385622330,52385622331,52386600100,52386600102,52386602110,52386602112,52386602113,52386603032,52386603320,52386603322,52386603323,52386621110,52386621112,52386621113,52386621310,52386621311,52386621312,52386623030,52386623032,52386623210,52386623212,52386623230,52386630022,52387600310,52387600312,52387600330,52387601000,52387601002,52387602120,52387602122,52387602230,52387602231,52387602232,52387620010,52387620012,52387620030,52387620032,52387620210,52387620212,52387620230,52387622020,52387622022,52387622200,52387622202,53380402333,53380420111,53380421020,53380421021,53380421023,53380421201,53380421203,53380421221,53380421223,53380423200,53380423201,53380423203,53380423230,53380423231,53380431300,53380431301,53380431310,53380431311,53380431313,53380433010,53380433012,53380433030,53380433032,53380433210,53380501330,53380501331,53380503300,53380503302,53380503320,53380503322,53380511110,53380511320,53380511322,53380512101,53380512110,53380512111,53380512113,53380513021,53380520231,53380520320,53380520321,53380520330,53380520331,53380521100,53380521102,53380521220,53380521221,53380521230,53381401100,53381401101,53381401103,53381401130,53381401131,53381401133,53381401311,53381401313,53381410220,53381410221,53381411020,53381411022,53381411200,53381412011,53381412100,53381412102,
096,00,,497446875,127856250,499921875,129318750,7,16,45,98,229,441,533834,533835,533843,533844,533845,533854,533855,5338323,5338331,5338332,5338333,5338362,5338420,5338421,5338423,5338460,5338462,5338531,5338533,5338560,5338562,5338640,5338651,53382432,53382433,53382521,53382522,53382523,53382530,53382532,53382533,53383133,53383213,53383222,53383223,53383302,53383303,53383632,53384111,53384113,53384131,53384220,53384221,53384610,53384612,53384630,53385211,53385213,53385300,53385301,53385303,53385630,53385632,53386310,53386311,53386410,53386411,53386412,53386420,53386421,53386430,53386500,53386501,53386531,53386600,53386601,53386602,53386610,533823332,533823333,533824213,533824222,533824223,533824231,533824233,533824300,533824302,533824303,533824312,533824313,533825030,533825032,533825033,533825201,533825202,533825203,533825312,533825313,533826220,533826221,533826222,533832111,533832112,533832113,533832120,533832121,533832123,533833002,533833003,533833011,533833012,533833013,533836000,533836002,533836020,533836022,533836023,533836302,533841101,533841103,533841121,533841122,533841123,533841300,533841301,533841303,533841330,533841331,533842220,533842221,533842230,533842231,533842233,533846320,533846321,533846322,533852100,533852101,533852103,533852121,533853020,533853021,533853211,533856122,533856123,533856132,533856310,533863120,533863121,533863130,533863131,533863133,533864130,533864131,533864132,533864220,533864221,533864223,533864230,533864231,533864310,533864312,533864320,533864321,533864330,533865020,533865021,533865030,533865031,533865300,533865301,533865303,533866030,533866110,533866200,533866201,5338232332,5338232333,5338233220,5338233222,5338233223,5338233231,5338233232,5338233233,5338233301,5338233303,5338233310,5338233312,5338233313,5338242112,5338242113,5338242202,5338242212,5338242213,5338242321,5338242322,5338242323,5338243012,5338243013,5338243113,5338250122,5338250213,5338250231,5338250232,5338250233,5338250310,5338250312,5338250313,5338251220,5338251222,5338251223,5338251232,5338252001,5338252002,5338252003,5338253100,5338253102,5338253103,5338253112,5338262020,5338262022,5338262023,5338262122,5338262230,5338262231,5338262232,5338262300,5338262302,5338262320,5338313122,5338313123,5338313211,5338313213,5338313231,5338313232,5338313233,5338321013,5338321020,5338321022,5338321031,5338321033,5338321102,5338321103,5338321221,5338321223,5338322022,5338322023,5338322032,5338322033,5338322122,5338322123,5338322132,5338322133,5338330002,5338330003,5338330012,5338330013,5338330101,5338330102,5338330103,5338360010,5338360012,5338360210,5338360212,5338360213,5338360322,5338360323,5338360332,5338363000,5338363002,5338363003,5338363030,5338363032,5338363033,5338411001,5338411003,5338411021,5338411023,5338411201,5338411203,5338412111,5338413021,5338413210,5338413211,5338413213,5338413320,5338413321,5338413323,5338413330,5338413331,5338422220,5338422221,5338422230,5338422231,5338422321,5338461120,5338461122,5338461123,5338461300,5338461301,5338461302,5338461320,5338461322,5338463100,5338463102,5338463120,5338463122,5338463230,5338463231,5338463300,5338520111,5338520113,5338521021,5338521023,5338521231,5338523100,5338523101,5338523110,5338523111,5338530220,5338530221,5338530222,5338530230,5338530231,5338532131,5338532133,5338561000,5338561002,5338561020,5338561202,5338561203,5338561212,5338561213,5338561302,5338561330,5338563120,5338563122,5338563300,5338563302,5338563320,5338563322,5338631220,5338631221,5338631230,5338631231,5338631320,5338631321,5338633111,5338633113,5338633131,5338633133,5338641330,5338641331,5338641332,5338642220,5338642221,5338642223,5338642320,5338642321,5338642330,5338642331,5338642333,5338643220,5338643221,5338643222,5338643230,5338643231,5338643233,5338643312,5338643320,5338643322,5338650220,5338650221,5338650230,5338650231,5338650320,5338650321,5338650322,5338650330,5338650331,5338650333,5338653020,5338653021,5338653023,5338653210,5338653211,5338653213,5338653300,5338653302,5338660310,5338660312,5338660320,5338660322,5338661120,5338661121,5338661122,5338661300,5338662020,5338662021,5338662022,5338662030,5338662031,5338662100,5338662102,5338662120,53382233233,53382233322,53382233323,53382233332,53382233333,53382323232,53382323233,53382323302,53382323303,53382323311,53382323312,53382323313,53382331232,53382331233,53382332210,53382332212,53382332213,53382332302,53382332303,53382333021,53382333022,53382333023,53382333112,53382333113,53382412223,53382412232,53382421031,53382421032,53382421033,53382421103,53382421111,53382421112,53382421113,53382421210,53382421211,53382421213,53382421231,53382421232,53382421233,53382422002,53382422032,53382422033,53382423010,53382423011,53382423013,53382423031,53382423033,53382423200,53382423202,53382423203,53382430102,53382430113,53382431002,53382431020,53382431022,53382431023,53382431032,53382431122,53382431123,53382501230,53382501232,53382501233,53382501322,53382501323,53382502111,53382502112,53382502113,53382502123,53382502213,53382502231,53382502232,53382502233,53382502301,53382502302,53382502303,53382503110,53382503112,53382512022,53382512212,53382512213,53382512302,53382512330,53382512332,53382512333,53382513222,53382513223,53382520002,53382520003,53382531012,53382531013,53382531132,53382531133,53382620210,53382620212,53382620213,53382620322,53382620323,53382620332,53382620333,53382621232,53382622330,53382623010,53382623012,53383130333,53383131322,53383131332,53383131333,53383132121,53383132123,53383132232,53383132233,53383132301,53383132302,53383132303,53383201313,53383201331,53383201333,53383203111,53383203113,53383203133,53383210113,53383210230,53383210232,53383210233,53383210323,53383211002,53383211003,53383211011,53383211012,53383211013,53383212200,53383212201,53383212203,53383212221,53383212222,53383212223,53383220313,53383221202,53383221303,53383221312,53383221313,53383300002,53383300012,53383300013,53383300102,53383300103,53383300112,53383300113,53383301002,53383301003,53383600300,53383600302,53383602110,53383602112,53383602113,53383603200,53383603202,53383603203,53383603212,53383603213,53383603302,53383603332,53383603333,53383612220,53383612222,53383630012,53383630120,53383630122,53383630123,53383630310,53383630312,53383630313,53383631202,53383631220,53383631222,53383633000,53383633001,53383633002,53383633020,53383633022,53383633200,53383633202,53383633220,53383633222,53384103313,53384103331,53384103332,53384103333,53384110201,53384110203,53384110221,53384112023,53384121130,53384121131,53384121133,53384130200,53384130201,53384130203,53384130230,53384130231,53384130233,53384132011,53384132311,53384133221,53384133223,53384133320,53384223200,53384223201,53384223203,53384223231,53384223233,53384611000,53384611002,53384611020,53384611022,53384611023,53384611212,53384613030,53384613032,53384613210,53384613212,53384613230,53384613232,53384631010,53384631012,53384631030,53384631032,53384631210,53384631212,53384631213,53384631230,53384631231,53384632320,53384632321,53384632330,53384633020,53384633021,53384633022,53385111010,53385111011,53385201100,53385201101,53385201103,53385201121,53385201311,53385210200,53385210201,53385210203,53385210221,53385212010,53385212011,53385212013,53385212031,53385212301,53385212330,53385212331,53385212333,53385230111,53385231031,53385231120,53385231121,53385231130,53385302230,53385302231,53385302232,53385320000,53385320001,53385321000,53385321001,53385321010,53385321011,53385321013,53385321301,53385323110,53385323111,53385323113,53385323131,53385323133,53385610010,53385610011,53385610012,53385610220,53385610221,53385610222,53385612000,53385612002,53385613030,53385613032,53385613033,53385613122,53385613320,53385613321,53385613322,53385631100,53385631102,53385631120,53385631210,53385631212,53385631230,53385631232,53385631233,53385633010,53385633230,53385633232,53385633233,53386301313,53386301331,53386301333,53386303111,53386303113,53386303131,53386303133,53386303311,53386303313,53386303331,53386312220,53386312221,53386312230,53386312231,53386313231,53386331100,53386331101,53386331103,53386331121,53386331123,53386333110,53386333111,53386333113,53386333131,53386333133,53386333311,53386333313,53386422221,53386422223,53386423220,53386423221,53386423230,53386423231,53386423320,53386423321,53386423323,53386431100,53386431102,53386431120,53386431122,53386431300,53386431302,53386431320,53386431322,53386432230,53386432321,53386432323,53386433100,53386433102,53386433103,53386433210,53386433211,53386433212,53386433230,53386433300,53386433301,53386502221,53386502230,53386502320,53386502321,53386502330,53386502331,53386503230,53386503231,53386521110,53386521111,53386521113,53386521131,53386521133,53386521311,53386521313,53386521331,53386530220,53386530221,53386530223,53386532010,53386532011,53386532013,53386532120,53386532121,53386532123,53386532301,53386532310,53386532311,53386533010,53386533011,53386533012,53386533100,53386533101,53386533110,53386533200,53386603110,53386603111,53386603112,53386603130,53386603132,53386603210,53386603211,53386603212,53386603300,53386611102,53386611120,53386611122,53386611230,53386611231,53386611232,53386611300,53386611302,53386611320,53386612000,53386612001,53386612010,53386612011,53386612013,53386612100,53386612101,53386612102,53386612110,53386612111,53386613010,53386613012,53386620230,53386620231,53386620320,53386620321,53386620330,53386620331,53387400010,53387400011,53387400013,53387400100,53387400101,53387401110,53387401111,53387410111,53387411000,
097,00,ȱ,497629687,126590625,498965625,128325000,2,13,47,75,139,311,533803,533813,5238633,5238731,5238732,5238733,5338021,5338023,5338121,5338123,5338142,5338221,5338230,5338231,5338240,52386312,52386313,52386321,52386323,52386420,52386422,52387223,52387233,52387301,52387302,52387303,52387400,52387402,52387420,52387422,53380201,53380202,53380203,53380220,53380221,53380223,53380400,53380422,53381201,53381203,53381221,53381223,53381400,53381402,53381403,53381432,53382201,53382203,53382221,53382222,53382223,53382230,53382231,53382232,53382320,53382321,53382322,53382330,53382410,53382420,53383200,53383202,523863031,523863032,523863033,523863102,523863103,523863112,523863113,523863203,523863221,523863223,523864020,523864022,523864023,523872212,523872221,523872223,523872322,523872323,523873001,523873002,523873003,533801133,533802001,533802003,533802221,533802223,533804020,533804021,533804022,533804200,533804202,533804203,533812001,533812003,533812021,533812022,533812023,533812201,533812203,533812221,533812223,533814010,533814012,533814122,533814300,533814302,533822001,533822003,533822021,533822023,533822201,533822202,533822203,533822330,533822331,533823230,533823231,533823310,533823311,533823313,533823320,533823321,533824120,533831311,533832010,533832011,533832012,533832030,533832032,533832033,533832100,533832200,533832201,533832210,533832211,5238630131,5238630133,5238630231,5238630233,5238631002,5238631102,5238631103,5238631111,5238631112,5238631113,5238632011,5238632012,5238632013,5238632223,5238640002,5238640020,5238640022,5238640023,5238640212,5238640213,5238721133,5238721311,5238721313,5238721331,5238721333,5238722033,5238722201,5238722203,5238722221,5238722222,5238722223,5238723131,5238723132,5238723133,5238723202,5238730001,5238730002,5238730003,5338013110,5338013111,5338013113,5338020001,5338020003,5338020021,5338020023,5338022200,5338022201,5338022203,5338022221,5338022223,5338040230,5338040231,5338040232,5338042010,5338042012,5338042013,5338042322,5338120001,5338120003,5338120021,5338120023,5338120201,5338120202,5338120203,5338122000,5338122001,5338122003,5338122021,5338122023,5338122201,5338122203,5338122221,5338140112,5338140130,5338140132,5338140133,5338141200,5338141202,5338141203,5338213313,5338213331,5338213333,5338220203,5338220221,5338222003,5338223320,5338223321,5338223322,5338223330,5338223331,5338232320,5338232321,5338232322,5338233120,5338233121,5338233122,5338233300,5338241100,5338241210,5338241212,5338241220,5338241221,5338241230,5338241232,5338241233,5338242100,5338242101,5338242102,5338242120,5338242122,5338242201,5338242210,5338242211,5338242300,5338242302,5338311111,5338311113,5338311131,5338311133,5338311311,5338311312,5338311313,5338311331,5338311332,5338311333,5338313130,5338313131,5338320130,5338320132,5338320310,5338320312,5338321010,5338321012,5338321021,5338321030,5338322020,5338322021,5338322030,5338322121,52385333323,52385333332,52385333333,52386301132,52386301133,52386301301,52386301303,52386301321,52386301323,52386302132,52386302133,52386302303,52386302321,52386302323,52386303022,52386303031,52386303032,52386303033,52386310032,52386310033,52386310122,52386310123,52386310131,52386310132,52386310133,52386311013,52386311101,52386311102,52386311103,52386320101,52386320102,52386320103,52386322013,52386322031,52386322033,52386322211,52386322212,52386322213,52386322223,52386400002,52386400210,52386400212,52386402102,52386402103,52386402112,52386402113,52387211133,52387211311,52387211313,52387220233,52387220311,52387220312,52387220313,52387220322,52387220323,52387221022,52387221023,52387221032,52387221320,52387221322,52387222003,52387222021,52387222023,52387222201,52387222202,52387222203,52387231111,52387231113,52387231131,52387231133,52387231223,52387231232,52387231233,52387232000,52387232002,52387232003,52387232032,52387232033,52387232113,52387232123,52387232131,52387232132,52387232133,52387300001,52387300002,52387300003,53380113123,53380113132,53380113133,53380113213,53380131121,53380131123,53380131310,53380131311,53380131313,53380131331,53380131333,53380133111,53380200001,53380200021,53380200023,53380200201,53380200203,53380200221,53380200222,53380200223,53380222021,53380402330,53380402331,53380402332,53380420110,53380420112,53380420113,53380421022,53380421200,53380421202,53380421220,53380421222,53380423202,53380423232,53380423233,53381113131,53381113133,53381113311,53381113313,53381113331,53381113333,53381131111,53381131113,53381202002,53381202003,53381220021,53381222230,53381222231,53381222233,53381401102,53381401132,53381401310,53381401312,53381410222,53381410223,53381412010,53381412012,53381412013,53381412120,53381412122,53381412123,53381412300,53381412302,53381412320,53381412322,53381430100,53381430102,53381430120,53381430122,53381430300,53381430302,53381430320,53381430322,53381430323,53381433220,53381433222,53381433223,53382131313,53382131331,53382131333,53382133111,53382133112,53382133113,53382133321,53382133323,53382200011,53382200013,53382200031,53382202011,53382202012,53382202013,53382202230,53382202231,53382202233,53382220011,53382220013,53382220023,53382233230,53382233231,53382233232,53382233320,53382233321,53382233330,53382233331,53382323230,53382323231,53382323300,53382323301,53382323310,53382331230,53382331231,53382332211,53382332300,53382332301,53382333020,53382333110,53382333111,53382411020,53382411022,53382411200,53382411202,53382411220,53382412110,53382412112,53382412130,53382412132,53382412220,53382412221,53382412222,53382412230,53382412231,53382412233,53382412310,53382412312,53382413222,53382421030,53382421100,53382421101,53382421102,53382421110,53382421212,53382421230,53382422000,53382422001,53382422003,53382422030,53382422031,53382423012,53382423030,53382423032,53382423201,53382430100,53382430101,53382430103,53382430110,53382430111,53382430112,53382431000,53383111101,53383111322,53383111323,53383113100,53383113101,53383113103,53383113213,53383113231,53383113233,53383113301,53383113302,53383113303,53383131011,53383131013,53383131031,53383131033,53383131211,53383131213,53383131320,53383131321,53383131323,53383131330,53383131331,53383201310,53383201311,53383201312,53383201330,53383201332,53383203110,53383203112,53383203130,53383203131,53383203132,53383210110,53383210111,53383210112,53383210231,53383210320,53383210321,53383210322,53383211000,53383211001,53383211010,53383212202,53383212220,53383220310,53383220311,53383220312,53383221200,53383221201,53383221203,53383221300,53383221301,53383221302,53383221310,53383221311,53383300000,53383300001,53383300003,53383300010,53383300011,53383300100,53383300101,53383300110,53383300111,53383301000,53383301001,
098,00,Ų,497109375,125803125,498375000,128306250,3,5,39,118,247,445,523842,523852,523862,5238711,5238712,5238713,5238720,5338211,52383223,52383232,52384113,52384131,52384133,52384302,52384320,52384322,52385111,52385113,52385131,52386131,52386133,52387033,52387103,52387210,52387212,52387230,53380100,53380101,53380103,53380110,53380111,53380112,53380121,53380123,53380130,53380132,53381101,53381103,53381110,53381111,53381112,53381130,53381132,53381133,53382101,53382103,53382130,523832211,523832212,523832213,523832221,523832222,523832223,523832300,523832302,523832332,523841103,523841111,523841112,523841113,523841121,523841123,523841301,523843002,523843003,523843012,523843030,523843032,523843033,523843210,523843211,523843212,523843230,523843232,523851101,523851103,523851121,523851123,523851300,523851301,523851331,523853000,523853002,523853020,523853022,523853200,523853202,523853220,523853222,523853223,523861122,523861131,523861132,523861133,523861301,523861303,523861321,523861323,523863000,523863001,523863002,523863020,523863022,523863200,523863202,523870313,523871012,523871013,523871021,523871023,523872110,523872112,523872130,523872132,523872200,523872201,523872211,523872310,533800111,533800113,533801020,533801021,533801130,533801223,533801310,533801312,533801330,533801332,533801333,533811001,533811002,533811003,533811020,533811021,533811023,533811130,533811132,533811211,533811213,533811231,533811232,533811233,533811310,533811312,533811313,533821211,533821212,533821213,533821230,533821231,533821310,533821311,533821312,533821320,533821321,533821323,533821330,533821332,533822002,533831101,533831103,533831110,533831112,533831123,533831130,5238320321,5238320323,5238320330,5238320332,5238320333,5238322031,5238322033,5238322101,5238322103,5238323030,5238323032,5238323122,5238323300,5238323302,5238323330,5238323332,5238323333,5238411012,5238411021,5238411023,5238411102,5238411103,5238411201,5238411203,5238413030,5238413031,5238413033,5238413211,5238413213,5238413231,5238413232,5238413233,5238430002,5238430003,5238430012,5238430013,5238430102,5238430130,5238430132,5238430310,5238430312,5238430313,5238432130,5238432132,5238432310,5238432312,5238432313,5238432330,5238432331,5238511003,5238511021,5238511023,5238511201,5238511203,5238511221,5238511222,5238511223,5238513021,5238513030,5238513031,5238513300,5238513301,5238513303,5238513330,5238513331,5238513333,5238530010,5238530011,5238530012,5238530030,5238530032,5238530101,5238530210,5238530212,5238530230,5238530232,5238532010,5238532012,5238532030,5238532032,5238532210,5238532212,5238611111,5238611113,5238611131,5238611132,5238611133,5238611202,5238611203,5238611232,5238611233,5238611303,5238613000,5238613001,5238613003,5238613222,5238613223,5238630030,5238630032,5238630210,5238630212,5238632200,5238632202,5238632220,5238703113,5238703121,5238703123,5238710013,5238710031,5238710032,5238710033,5238710102,5238710103,5238710112,5238710113,5238710223,5238721110,5238721111,5238721112,5238721130,5238721132,5238721310,5238721312,5238721330,5238721332,5238722020,5238722021,5238722022,5238722030,5238722100,5238722101,5238722130,5238722131,5238722133,5238723110,5238723112,5238723120,5238723121,5238723130,5238723201,5238723210,5338001100,5338001101,5338001103,5338001120,5338001121,5338001123,5338001310,5338001311,5338001313,5338010230,5338010231,5338010233,5338011310,5338011311,5338011320,5338011322,5338011323,5338012011,5338012013,5338012211,5338012212,5338012213,5338012221,5338013130,5338013132,5338013310,5338013312,5338013313,5338022220,5338022222,5338110002,5338110003,5338110220,5338110221,5338111310,5338111311,5338111312,5338111330,5338111332,5338112101,5338112103,5338112120,5338112121,5338112123,5338112232,5338112233,5338112301,5338112303,5338113110,5338113112,5338113113,5338120000,5338120002,5338120020,5338120022,5338122020,5338122022,5338122200,5338122202,5338122220,5338122222,5338210010,5338210011,5338210013,5338210031,5338210032,5338210033,5338210211,5338210213,5338212031,5338212033,5338212101,5338212102,5338212103,5338212321,5338212330,5338213130,5338213132,5338213220,5338213221,5338213223,5338213310,5338213312,5338213330,5338220000,5338220002,5338220200,5338220202,5338220220,5338220222,5338222000,5338311001,5338311003,5338311112,5338311130,5338311211,5338311212,5338311213,5338311320,5338311322,5338313010,5338313011,5338313013,5338313100,5338313102,5338313120,52383133313,52383133331,52383133332,52383133333,52383203033,52383203312,52383203313,52383212222,52383212223,52383220303,52383220321,52383220323,52383221001,52383221003,52383221021,52383221022,52383221023,52383222032,52383222033,52383230120,52383230122,52383230312,52383230330,52383230332,52383230333,52383233122,52383233312,52383233313,52383322202,52383322220,52383322222,52384110032,52384110033,52384110132,52384110201,52384110203,52384110221,52384110223,52384111000,52384111002,52384111003,52384111011,52384111012,52384111013,52384112210,52384112211,52384112213,52384112231,52384112233,52384130011,52384130013,52384130320,52384130321,52384130323,52384132101,52384132123,52384132301,52384132302,52384132303,52384300000,52384300002,52384300012,52384300013,52384300102,52384300103,52384301032,52384301312,52384301330,52384301332,52384303110,52384303112,52384303113,52384321310,52384321311,52384321312,52384321330,52384321332,52384321333,52384323110,52384323111,52384323112,52384323320,52384323321,52384323322,52384323330,52385110011,52385110012,52385110013,52385110021,52385110023,52385110201,52385110203,52385110221,52385110223,52385112201,52385112203,52385130201,52385130330,52385130331,52385130333,52385132111,52385133021,52385133023,52385133321,52385133323,52385300130,52385300132,52385300310,52385300312,52385300330,52385300332,52385301000,52385301001,52385301003,52385301030,52385301031,52385301100,52385302110,52385302112,52385302130,52385302132,52385302310,52385302312,52385302330,52385302332,52385320110,52385320112,52385322110,52385322112,52385322130,52385322132,52386103131,52386103133,52386103311,52386110232,52386110233,52386111123,52386111233,52386111301,52386111302,52386111303,52386112001,52386112002,52386112003,52386112010,52386112012,52386112013,52386112122,52386112300,52386112302,52386112303,52386112310,52386112312,52386112313,52386113011,52386113012,52386113013,52386130021,52386130210,52386130211,52386130213,52386132011,52386132211,52386132213,52386300310,52386300311,52386300312,52386300330,52386300332,52386302110,52386302112,52386302130,52386302300,52386302301,52386302302,52386302320,52386302322,52386320100,52386322010,52386322011,52386322012,52386322030,52386322032,52386322210,52386322220,52386322221,52386322222,52387031032,52387031033,52387031111,52387031112,52387031113,52387031122,52387031123,52387031222,52387031223,52387032113,52387032131,52387032132,52387032133,52387032310,52387032311,52387032313,52387032331,52387032333,52387100112,52387100113,52387100301,52387100302,52387100303,52387101002,52387101003,52387101012,52387101013,52387101111,52387101112,52387101113,52387102211,52387102212,52387102213,52387102223,52387211130,52387211131,52387211132,52387211310,52387211312,52387220230,52387220231,52387220232,52387220310,52387220320,52387220321,52387221020,52387221021,52387221030,52387221031,52387221033,52387221321,52387221323,52387222000,52387222001,52387222002,52387222020,52387222022,52387222200,52387231110,52387231112,52387231130,52387231132,52387231220,52387231221,52387231222,52387231230,52387231231,52387232001,52387232030,52387232031,52387232110,52387232111,52387232112,52387232120,52387232121,52387232122,52387232130,52387300000,53380010111,53380010113,53380011021,53380011023,53380011220,53380011221,53380011223,53380013011,53380013013,53380013121,53380013123,53380013311,53380102200,53380102201,53380102211,53380102320,53380102321,53380102323,53380113120,53380113121,53380113122,53380113130,53380113131,53380113210,53380113211,53380113212,53380120101,53380120103,53380120121,53380120310,53380120311,53380120313,53380120331,53380120332,53380120333,53380122031,53380122032,53380122033,53380122103,53380122231,53380131120,53380131122,53380131312,53380131330,53380131332,53380133110,53380133112,53380133113,53380200000,53380200002,53380200003,53380200020,53380200022,53380200200,53380200202,53380200220,53380222020,53380222022,53380222023,53381011131,53381011133,53381011311,53381011313,53381011333,53381013111,53381013113,53381013131,53381013133,53381013311,53381013313,53381013331,53381100012,53381100013,53381102220,53381102231,53381113130,53381113132,53381113310,53381113312,53381113330,53381113332,53381121001,53381121003,53381121021,53381121022,53381121023,53381121220,53381121221,53381121223,53381122312,53381122313,53381123001,53381123003,53381123021,53381123023,53381131110,53381131112,53381202000,53381202001,53381220020,53381220022,53381220023,53381222232,53382100121,53382100123,53382102100,53382102101,53382102103,53382102310,53382102311,53382102313,53382120122,53382120123,53382120131,53382120132,53382120133,53382120300,53382120301,53382121001,53382121002,53382121003,53382122110,53382122111,53382122113,53382122131,53382123201,53382123203,53382123221,53382123230,53382123231,53382123310,53382123320,53382123321,53382131310,53382131311,53382131312,53382131330,53382131332,53382132220,53382132221,53382132223,53382133110,53382133320,53382133322,53382200010,53382200012,53382200030,53382200032,53382200033,53382202010,53382202232,53382220010,53382220012,53382220020,53382220021,53382220022,53383110211,53383110213,53383111100,53383111102,53383111103,53383111320,53383111321,53383112101,53383112103,53383113102,53383113210,53383113211,53383113212,53383113230,53383113232,53383113300,53383130121,53383130311,53383131010,53383131012,53383131030,53383131032,53383131210,53383131212,
098,01,/ƣ/,497362500,125146875,498079687,126037500,0,3,12,43,60,160,5238220,5238222,5238311,52381221,52381222,52381223,52382113,52382131,52382132,52382133,52382230,52383130,52383131,52383200,52383202,523811333,523812032,523812033,523812201,523812202,523812203,523812302,523812320,523812322,523812323,523821111,523821112,523821113,523821123,523821231,523821233,523821301,523821303,523822100,523822102,523822120,523822122,523822320,523822321,523822322,523831010,523831011,523831013,523831031,523831033,523831211,523831320,523831321,523831323,523831330,523831331,523831332,523832010,523832011,523832012,523832200,523832201,523832202,5238113303,5238113311,5238113312,5238113313,5238120132,5238120231,5238120233,5238120301,5238120302,5238120303,5238120310,5238120312,5238122003,5238123000,5238123002,5238123210,5238123212,5238211033,5238211103,5238211213,5238213003,5238213021,5238213022,5238213023,5238221010,5238221011,5238221012,5238221030,5238221230,5238221232,5238223120,5238223122,5238223230,5238310121,5238310123,5238310301,5238310303,5238310321,5238310323,5238312101,5238312131,5238313220,5238313221,5238313223,5238313330,5238313332,5238320300,5238320301,5238320302,5238320320,5238320322,5238321000,5238321002,5238322200,5238322201,5238322202,5238411001,5238411002,5238411010,5238411011,52381131313,52381131331,52381131332,52381131333,52381133023,52381133101,52381133102,52381133103,52381133201,52381133210,52381133211,52381133213,52381201231,52381201232,52381201233,52381201302,52381201332,52381202133,52381202303,52381202321,52381202322,52381202323,52381203001,52381203003,52381203110,52381203112,52381203130,52381203132,52381212220,52381212222,52381220011,52381220012,52381220013,52381220021,52381220023,52381230030,52381230032,52381230320,52381230322,52381232112,52381232130,52381232132,52382110111,52382110113,52382110312,52382110313,52382111002,52382111003,52382111012,52382111013,52382111021,52382111023,52382112111,52382112112,52382112113,52382112121,52382112122,52382112123,52382121313,52382121322,52382121323,52382121331,52382121332,52382121333,52382123011,52382123012,52382123013,52382123031,52382123033,52382123211,52382123213,52382123223,52382123231,52382123232,52382123233,52382130013,52382130023,52382130201,52382130202,52382130203,52382210130,52382210131,52382210132,52382210310,52382210320,52382210322,52382212100,52382212102,52382212120,52382212122,52382212310,52382212312,52382212330,52382212332,52382231022,52382231230,52382231232,52382232310,52382232320,52382232322,52382233000,52383101200,52383101201,52383101203,52383101221,52383101223,52383103003,52383103021,52383103023,52383103201,52383121031,52383121033,52383121211,52383121300,52383121301,52383121303,52383121330,52383121331,52383121333,52383123111,52383123113,52383123131,52383123133,52383132221,52383132223,52383133310,52383133311,52383133312,52383133330,52383201300,52383201301,52383201302,52383201310,52383201311,52383203030,52383203031,52383203032,52383210200,52383220300,52383220301,52383220302,52383220320,52383220322,52383221000,52383221002,52383221020,52383222030,52383222031,52384110001,52384110003,52384110030,52384110031,52384110130,52384110131,52384110133,52384111001,52384111010,52382210321,52382212123,52382212132,
098,02,/ø,498234375,125840625,499106250,126750000,0,5,14,34,65,168,5238433,5238531,5238542,5238543,5238641,52383333,52384311,52384312,52384313,52384422,52385303,52385321,52385323,52385330,52385331,52385332,52385400,52385402,52385403,523833312,523833313,523833323,523834220,523834222,523834223,523843101,523843102,523843103,523844000,523844001,523844022,523844200,523844202,523844203,523844230,523844232,523853012,523853013,523853330,523853331,523853332,523854010,523854012,523854013,523854120,523854122,523854123,523854132,523854133,523863010,523863012,523864001,523864003,5238333033,5238333101,5238333103,5238333112,5238333113,5238333211,5238333213,5238333223,5238342020,5238342022,5238342023,5238342210,5238342212,5238431001,5238431002,5238431003,5238440030,5238440031,5238440032,5238440102,5238440202,5238442010,5238442012,5238442013,5238442120,5238442122,5238442123,5238442330,5238442332,5238530102,5238530111,5238530112,5238530113,5238532013,5238532031,5238532033,5238533330,5238533331,5238540110,5238540112,5238541022,5238541212,5238541213,5238541302,5238541303,5238541312,5238541313,5238550202,5238550203,5238550220,5238550222,5238552000,5238552002,5238630110,5238630111,5238630112,5238630300,5238630301,5238631000,5238631001,5238631010,5238631011,5238631100,5238640001,5238640003,52383313232,52383330311,52383330312,52383330313,52383330321,52383330323,52383331102,52383331103,52383332101,52383332103,52383332121,52383332122,52383332123,52383332203,52383332211,52383332213,52383332221,52383332223,52383420022,52383420210,52383420212,52383420322,52383422112,52383422130,52383422132,52383423220,52383423222,52384301132,52384301133,52384301310,52384301311,52384301313,52384301331,52384301333,52384303111,52384310001,52384310003,52384321313,52384321331,52384323113,52384323323,52384323331,52384323332,52384323333,52384400200,52384400201,52384400202,52384400210,52384400211,52384400220,52384400222,52384400330,52384400331,52384401000,52384401002,52384401003,52384401200,52384401201,52384401202,52384402000,52384402002,52384402003,52384402030,52384402032,52384402033,52384402300,52384402302,52384402320,52384402322,52384402323,52384420112,52384421020,52384421022,52384421023,52384421210,52384421212,52384423120,52384423122,52385300131,52385300133,52385300311,52385300313,52385300331,52385300333,52385301002,52385301032,52385301033,52385301101,52385301102,52385301103,52385302111,52385302113,52385302131,52385302133,52385302311,52385302313,52385302331,52385302333,52385320111,52385320113,52385322111,52385322113,52385322131,52385322133,52385333320,52385333321,52385333322,52385333330,52385333331,52385401112,52385401130,52385401132,52385401133,52385410202,52385410232,52385410233,52385412100,52385412102,52385412103,52385412112,52385412113,52385413002,52385413003,52385502210,52385502211,52385502212,52385502230,52385502232,52385520200,52385520202,52385520220,52385520222,52385522000,52385522002,52386300313,52386300331,52386300333,52386301130,52386301131,52386301300,52386301302,52386301320,52386301322,52386302111,52386302113,52386302131,52386303020,52386303021,52386303023,52386303030,52386310030,52386310031,52386310120,52386310121,52386310130,52386311010,52386311011,52386311012,52386311100,52386400000,52386400001,52386400003,52386400211,52386400213,52386402100,52386402101,52386402110,52386402111,
099,00,Ųؼ,497868750,125625000,498515625,126037500,0,0,6,23,43,91,52383211,52383213,52383302,52383320,52383321,52383323,523822332,523832031,523832101,523832103,523832120,523832121,523832123,523832310,523832311,523832313,523833002,523833003,523833030,523833032,523833033,523833122,523833220,523833221,523833223,523833300,523833301,523833302,523833320,5238223233,5238223302,5238223303,5238223332,5238320132,5238320133,5238321001,5238321003,5238321021,5238321022,5238321023,5238321220,5238321221,5238321223,5238323010,5238323011,5238323013,5238323120,5238323121,5238323123,5238323301,5238323303,5238323310,5238323311,5238323313,5238330002,5238330003,5238330122,5238330312,5238330313,5238331232,5238331233,5238332221,5238332223,5238333030,5238333100,5238333102,5238430011,5238430100,5238430101,5238430110,5238430111,5238430112,52382232311,52382232312,52382232313,52382232321,52382232323,52382233001,52382233002,52382233003,52382233010,52382233012,52382233013,52382233122,52382233300,52382233302,52382233332,52383201303,52383201312,52383201313,52383203310,52383203311,52383210201,52383210202,52383210203,52383212220,52383212221,52383230121,52383230123,52383230310,52383230311,52383230313,52383230331,52383233120,52383233121,52383233123,52383233310,52383233311,52383300000,52383300002,52383300003,52383300122,52383300123,52383300132,52383300133,52383301202,52383303102,52383303103,52383303112,52383312020,52383312022,52383312023,52383312032,52383312300,52383312302,52383312303,52383312312,52383313220,52383313222,52383313223,52383322200,52383322201,52383322203,52383322221,52383322223,52383330310,52383330320,52383330322,52383332100,52383332102,52383332120,52383332200,52383332201,52383332202,52383332210,52383332212,52383332220,52383332222,52384300001,52384300003,52384300010,52384300011,52384300100,52384300101,52384301030,52384301031,52384301033,52384301130,52384301131,52384310000,52384310002,52382233333,52383300012,
100,00,/,496800000,124528125,497882812,127246875,0,17,33,92,242,494,5238111,5238203,5238210,5238301,5238303,5238401,5238403,5238410,5238412,5238501,5238503,5238510,5238512,5238601,5238603,5238612,5238701,52380121,52380123,52380130,52380132,52381101,52381103,52381121,52381122,52381123,52381130,52381132,52381200,52382012,52382013,52382120,52382122,52383003,52383021,52383100,52383102,52383120,52383122,52385021,52385023,52386001,52386023,52386100,52386101,52386102,52387001,52387003,52387021,52387030,513871031,513871112,513871120,513871121,513871122,523801031,523801032,523801033,523801100,523801102,523801120,523801122,523801123,523801330,523801332,523801333,523810331,523810333,523811001,523811201,523811202,523811203,523811310,523811311,523811312,523812020,523812022,523820033,523820103,523820111,523820112,523820113,523821100,523821102,523821120,523821122,523821210,523821211,523821212,523830011,523830012,523830013,523830201,523830203,523830230,523830231,523830233,523831230,523831232,523831233,523840011,523840012,523840013,523840031,523840213,523840231,523840233,523841302,523841320,523841322,523850033,523850201,523850203,523850221,523850223,523851320,523851322,523851323,523851332,523860001,523860030,523860031,523860033,523860211,523860213,523861030,523861032,523861100,523861101,523861103,523861110,523870003,523870021,523870230,523870231,523870233,523870320,523870322,523871000,523871002,523871020,533800100,5138710303,5138710331,5138710332,5138710333,5138711022,5138711023,5138711031,5138711032,5138711033,5138711230,5138711300,5138712111,5138712112,5138712113,5138712130,5138712131,5138712133,5138712311,5138713000,5138713001,5138713002,5138713020,5138713022,5138713200,5138713202,5138713220,5138713222,5138713223,5238010111,5238010113,5238010131,5238010132,5238010133,5238010213,5238010231,5238010233,5238010301,5238010302,5238010303,5238011030,5238011032,5238011210,5238011212,5238011213,5238012011,5238012013,5238012031,5238012033,5238012211,5238012213,5238012231,5238012232,5238012233,5238013102,5238013120,5238013122,5238013123,5238013310,5238013312,5238013313,5238022220,5238022222,5238022223,5238103113,5238103131,5238103133,5238103303,5238103321,5238103323,5238110031,5238110033,5238110211,5238110213,5238110231,5238110232,5238110233,5238112002,5238113130,5238113132,5238113300,5238113301,5238113322,5238113323,5238120102,5238120120,5238120121,5238120122,5238120210,5238120211,5238120212,5238122000,5238200311,5238200313,5238201012,5238201013,5238201101,5238201102,5238201103,5238202111,5238202113,5238202131,5238202331,5238202332,5238202333,5238211010,5238211012,5238211013,5238211030,5238211032,5238211210,5238212130,5238212300,5238212302,5238212320,5238213000,5238300033,5238300211,5238300213,5238300231,5238300232,5238300233,5238302211,5238302321,5238302323,5238310322,5238312100,5238312102,5238312120,5238312122,5238312123,5238312132,5238312310,5238312312,5238400033,5238400101,5238400103,5238400300,5238400301,5238400303,5238400331,5238400333,5238402111,5238402112,5238402113,5238411200,5238411202,5238411220,5238411222,5238413000,5238413002,5238413003,5238500111,5238500113,5238500131,5238500312,5238500313,5238500323,5238502021,5238502023,5238502201,5238502203,5238502221,5238502223,5238511000,5238511200,5238511202,5238513022,5238513023,5238513032,5238513210,5238513212,5238513213,5238600001,5238600030,5238600031,5238600033,5238600321,5238600323,5238602101,5238602103,5238602121,5238602123,5238602213,5238602230,5238602231,5238602233,5238610310,5238610311,5238610312,5238610330,5238610332,5238610333,5238611020,5238611021,5238611022,5238611110,5238611120,5238611121,5238611122,5238611210,5238611211,5238611213,5238611300,5238611302,5238613020,5238613022,5238613023,5238613200,5238613202,5238613203,5238613220,5238700003,5238700011,5238700012,5238700013,5238700021,5238700230,5238700231,5238700233,5238702011,5238702013,5238702031,5238702321,5238702323,5238703100,5238703101,5238703102,5238703110,5238703120,5238703210,5238703212,5238703230,5238703232,5238710010,5238710012,5238710110,5238710220,5338000111,5338000113,5338001010,5138711231,5138711320,51387101331,51387101332,51387101333,51387103012,51387103013,51387103210,51387103211,51387103300,51387103301,51387103303,51387110203,51387110212,51387110213,51387110302,51387110303,51387111022,51387111023,51387111032,51387111033,51387111300,51387111302,51387111320,51387111322,51387112320,51387112321,51387112322,51387113010,51387113011,51387113012,51387113020,51387113021,51387113030,51387121100,51387121101,51387121103,51387121320,51387121321,51387121323,51387123101,51387123131,51387123133,51387123311,51387123313,51387123333,51387130030,51387130031,51387130032,51387130100,51387130102,51387130120,51387130210,51387130212,51387130230,51387130232,51387132010,51387132012,51387132030,51387132032,51387132210,51387132212,52380101103,52380101121,52380101123,52380101233,52380101301,52380101302,52380101303,52380103002,52380103003,52380110120,52380110122,52380110312,52380110330,52380110332,52380112110,52380112112,52380112113,52380113222,52380120123,52380120301,52380120303,52380120321,52380120323,52380122101,52380122103,52380122121,52380122123,52380122231,52380122233,52380122301,52380122302,52380122303,52380131000,52380131002,52380131003,52380131032,52380131210,52380131212,52380131213,52380131320,52380131322,52380133112,52380222022,52380222023,52380222210,52380222212,52380222213,52380222320,52380222322,52380222323,52380222332,52381031111,52381031113,52381031230,52381031231,52381031233,52381031303,52381031321,52381031322,52381031323,52381033011,52381033012,52381033013,52381033023,52381033223,52381100011,52381100013,52381100031,52381100033,52381100300,52381100301,52381100303,52381100321,52381100323,52381102101,52381102103,52381102121,52381102123,52381102301,52381102303,52381120000,52381120002,52381120003,52381120031,52381120033,52381131310,52381131311,52381131312,52381131330,52381133020,52381133021,52381133022,52381133100,52381133200,52381133202,52381133203,52381133212,52381201002,52381201030,52381201032,52381201033,52381201230,52381201300,52381202130,52381202131,52381202132,52381202300,52381202301,52381202302,52381202320,52381203000,52381203002,52381220010,52381220020,52381220022,52382003101,52382003103,52382003121,52382003123,52382010033,52382010211,52382010213,52382010230,52382010231,52382010233,52382011001,52382011002,52382011003,52382021100,52382021101,52382021103,52382021121,52382021331,52382021333,52382023111,52382023113,52382023131,52382023132,52382023133,52382023233,52382023301,52382023303,52382110110,52382110112,52382110310,52382110311,52382111000,52382111001,52382111010,52382111011,52382111020,52382111022,52382112110,52382112120,52382121310,52382121311,52382121312,52382121320,52382121321,52382121330,52382123010,52382123030,52382123032,52382123210,52382123212,52382123220,52382123221,52382123222,52382123230,52382130010,52382130011,52382130012,52382130020,52382130021,52382130022,52382130200,52383000322,52383000323,52383001031,52383001033,52383002100,52383002101,52383002103,52383002121,52383002123,52383002300,52383002301,52383002303,52383020213,52383022100,52383022101,52383022103,52383022131,52383023201,52383023203,52383023223,52383101202,52383101220,52383101222,52383103000,52383103001,52383103002,52383103020,52383103022,52383103200,52383103202,52383103203,52383121030,52383121032,52383121210,52383121212,52383121213,52383121302,52383121332,52383123110,52383123112,52383123130,52383123132,52383132220,52383132222,52384000311,52384000313,52384000322,52384000323,52384001001,52384001003,52384001021,52384001022,52384001023,52384002101,52384002111,52384003021,52384003211,52384003300,52384003301,52384003303,52384003321,52384003323,52384021101,52384021103,52384021231,52384021233,52384023011,52384023013,52384110000,52384110002,52384110200,52384110202,52384110220,52384110222,52384112212,52384112230,52384112232,52384130010,52384130012,52384130322,52384132100,52384132102,52384132103,52384132120,52384132121,52384132122,52384132300,52385001100,52385001101,52385001103,52385001121,52385001123,52385001331,52385001333,52385003111,52385003112,52385003113,52385003211,52385003212,52385003213,52385003223,52385020011,52385020013,52385020031,52385020032,52385020033,52385020221,52385020223,52385022001,52385022003,52385022020,52385022021,52385022023,52385022201,52385022203,52385022221,52385110010,52385110020,52385110022,52385110200,52385110202,52385110220,52385110222,52385112200,52385112202,52385130200,52385130202,52385130203,52385130332,52385132110,52385132112,52385132113,52385133020,52385133022,52385133320,52385133322,52386000030,52386000031,52386000033,52386000321,52386000323,52386002110,52386002111,52386002113,52386003200,52386003201,52386003203,52386003221,52386021003,52386021021,52386021023,52386021201,52386021221,52386021222,52386021223,52386022111,52386022112,52386022113,52386022121,52386022122,52386022123,52386022320,52386022321,52386022323,52386103130,52386103132,52386103310,52386103312,52386103313,52386110230,52386110231,52386111120,52386111121,52386111122,52386111230,52386111231,52386111232,52386111300,52386112000,52386112011,52386112120,52386112121,52386112123,52386112301,52386112311,52386113010,52386130020,52386130022,52386130023,52386130212,52386132010,52386132012,52386132013,52386132210,52386132212,52387000021,52387000023,52387000101,52387000102,52387000103,52387000201,52387000231,52387002320,52387002321,52387002323,52387020101,52387020103,52387020121,52387020123,52387020331,52387020333,52387022111,52387022113,52387022131,52387023201,52387031030,52387031031,52387031110,52387031120,52387031121,52387031220,52387031221,52387032110,52387032111,52387032112,52387032130,52387032312,52387032330,52387032332,52387100110,52387100111,52387100300,52387101000,52387101001,52387101010,52387101011,52387101110,52387102210,52387102220,52387102221,52387102222,53380001101,53380010110,53380010112,53380010120,53380010121,53380010122,53380010200,53380010201,53380010210,53380010211,51387113221,51387113220,51387112331,51387113222,52380131323,52380110102,52380110123,
101,00,/,496589062,124584375,497475000,125700000,0,6,18,50,88,210,5238000,5238001,5238003,5238100,5238101,5238102,51387032,51387033,51387120,51387122,52371711,52371713,52371731,52371733,52372711,52380021,52380023,52380100,52381030,52381032,52382000,52382001,52382002,52382020,513870222,513870223,513870231,513870232,513870233,513870303,513870312,513870313,513871023,513871210,513871212,513871230,513871232,523707111,523707112,523707113,523707130,523707131,523707133,523707311,523717121,523717123,523717301,523717303,523717321,523717323,523727130,523727131,523727133,523800200,523800201,523800203,523800221,523800223,523801010,523801020,523801022,523801200,523801202,523801220,523810310,523811002,523811020,523811022,523820030,523820032,523820210,523820212,523820221,523820230,5137773323,5137773331,5137773332,5137773333,5138702213,5138702302,5138702303,5138703022,5138703023,5138703103,5138703111,5138703112,5138703113,5138710222,5138710223,5138710302,5138710320,5138710322,5138710323,5138712312,5138712330,5138712332,5237071031,5237071033,5237071101,5237071102,5237071103,5237071321,5237073131,5237073323,5237073332,5237073333,5237171033,5237171221,5237171223,5237173001,5237173003,5237173021,5237173023,5237173201,5237271011,5237271013,5237271031,5237271321,5237273111,5237273113,5238002020,5238002021,5238002023,5238002221,5238002222,5238002223,5238010120,5238010121,5238010122,5238010210,5238010211,5238010212,5238010230,5238010232,5238012010,5238012220,5238012221,5238012222,5238103110,5238103112,5238103120,5238103121,5238103122,5238103300,5238103320,5238110000,5238110002,5238112001,5238201000,5238201001,5238201002,5238201010,5238201011,5238201020,5238201022,5238202130,5238202132,5238202201,5238202310,5238202312,5238202320,5238202321,51377733203,51377733212,51377733213,51377733221,51377733223,51377733302,51377733303,51387013332,51387013333,51387021323,51387021332,51387021333,51387022032,51387022033,51387022122,51387022123,51387023002,51387023003,51387023011,51387023012,51387023013,51387030132,51387030133,51387030213,51387031013,51387031021,51387031022,51387031023,51387031101,51387031102,51387031103,51387102123,51387102131,51387102132,51387102133,51387102212,51387102213,51387103003,51387103212,51387103213,51387103302,51387121102,51387121322,51387123100,51387123102,51387123103,51387123130,51387123132,51387123310,51387123312,51387123330,51387123331,51387123332,52370710133,52370710303,52370710321,52370710323,52370711001,52370711002,52370711003,52370712111,52370713201,52370713233,52370731031,52370731033,52370731300,52370731301,52370731303,52370731331,52370733213,52370733222,52370733301,52370733302,52370733303,52370733312,52370733313,52371710111,52371710112,52371710113,52371710131,52371710133,52371710311,52371710312,52371710313,52371710321,52371710322,52371710323,52371712031,52371712033,52371712203,52371712221,52371712223,52371730001,52371732030,52371732031,52371732033,52371732211,52371732213,52372710101,52372710103,52372710330,52372710331,52372710333,52372712111,52372712113,52372713201,52372713231,52372731101,52372731311,52372731313,52380020220,52380020221,52380020223,52380022010,52380022011,52380022013,52380022031,52380022032,52380022033,52380022201,52380022202,52380022203,52380101100,52380101101,52380101102,52380101120,52380101122,52380101230,52380101231,52380101232,52380101300,52380103000,52380103001,52380120120,52380120121,52380120122,52380120300,52380120302,52380120320,52380120322,52380122100,52380122102,52380122120,52380122122,52380122230,52380122232,52380122300,52381031110,52381031112,52381031232,52381031300,52381031301,52381031302,52381031320,52381033010,52381033020,52381033021,52381033022,52381033220,52381033221,52381033222,52381100010,52381100012,52381100030,52381100032,52381100302,52381100320,52381100322,52381102100,52381102102,52381102120,52381102122,52381102300,52381102302,52381120001,52381120030,52381120032,52382003100,52382003102,52382003120,52382003122,52382010030,52382010031,52382010032,52382010210,52382010212,52382010232,52382011000,52382021102,52382021120,52382021122,52382021123,52382021330,52382021332,52382022031,52382022033,52382022211,52382022300,52382022301,52382022303,52382022310,52382022311,52382023110,52382023112,52382023130,52382023230,52382023231,52382023232,52382023300,52382023302,
101,01,/ް,496040625,124706250,496968750,125896875,0,6,15,53,109,184,5237061,5237070,5237072,5237170,5237172,5237270,52370630,52370631,52370633,52370730,52370732,52371611,52371613,52371631,52371633,52372611,52372730,52372732,52372733,52373710,52373711,513776231,513776233,513776320,513776322,513776323,513776332,513776333,523706011,523706013,523706320,523706321,523706323,523707100,523707102,523707120,523707122,523707123,523707312,523707330,523707331,523716101,523716103,523716121,523716301,523716303,523716321,523716323,523717100,523717102,523726101,523726103,523726131,523727100,523727102,523727120,523727122,523727123,523727210,523727211,523727213,523727231,523727233,523727310,523727312,523737011,523737130,523737131,523737133,523830000,523830001,523830002,523830020,523830022,5137762132,5137762133,5137762303,5137762321,5137762323,5137763212,5137763213,5137763302,5137772220,5137772222,5137772223,5137772232,5137772233,5137772322,5137772323,5137772332,5137772333,5137773222,5137773223,5137773232,5137773233,5237060310,5237060311,5237060313,5237060331,5237060333,5237062111,5237063221,5237063223,5237071010,5237071011,5237071012,5237071210,5237071212,5237071213,5237071322,5237073100,5237073101,5237073102,5237073132,5237073320,5237161001,5237161231,5237161232,5237161233,5237171010,5237171012,5237171030,5237171200,5237171201,5237171202,5237173002,5237173020,5237173022,5237173200,5237173202,5237173220,5237173222,5237173223,5237261300,5237261301,5237261303,5237261330,5237261331,5237261333,5237271012,5237271030,5237271032,5237271210,5237271212,5237271213,5237271322,5237272011,5237272303,5237272321,5237272322,5237272323,5237273112,5237273130,5237273132,5237273133,5237370101,5237370131,5237370133,5237371200,5237371201,5237371210,5237371211,5237371320,5237371321,5237373110,5237373111,5238002200,5238002202,5238202200,5238202202,5238202220,5238202222,5238202223,5238202232,5238202233,5238202322,5238300030,5238300031,5238300100,5238300101,5238300102,5238302001,5238302003,51377621231,51377621233,51377623011,51377623013,51377630222,51377630223,51377632100,51377632102,51377632103,51377632112,51377633032,51377633033,51377633122,51377633123,51377722212,51377722213,51377722302,51377722303,51377722312,51377723202,51377733220,51377733222,52370601011,52370601013,52370601031,52370601033,52370601211,52370603120,52370603121,52370621130,52370621131,52370621133,52370621311,52370621313,52370621331,52370621333,52370623111,52370632201,52370632203,52370632221,52370710130,52370710131,52370710132,52370710300,52370710301,52370710302,52370710320,52370710322,52370711000,52370712110,52370712112,52370712113,52370713200,52370713202,52370713203,52370713230,52370713231,52370713232,52370731030,52370731032,52370731302,52370731330,52370731332,52370731333,52370733210,52370733211,52370733212,52370733220,52370733221,52370733223,52370733300,52370733310,52370733311,52371610031,52371610033,52371610211,52371610213,52371610231,52371610233,52371612011,52371612301,52371612303,52371630031,52371630033,52371710110,52371710130,52371710132,52371710310,52371710320,52371712030,52371712032,52371712200,52371712201,52371712202,52371712220,52371712222,52371730000,52371730002,52371730003,52371732032,52371732210,52371732212,52372612101,52372612110,52372612111,52372612113,52372613020,52372613021,52372613023,52372613320,52372613321,52372613323,52372710100,52372710102,52372710332,52372712110,52372712112,52372713200,52372713202,52372713203,52372713230,52372713232,52372713233,52372720000,52372720010,52372720011,52372720100,52372720101,52372720131,52372721201,52372721210,52372721211,52372723013,52372723023,52372723201,52372723203,52372731100,52372731102,52372731103,52372731310,52372731312,52373701000,52373701001,52373701003,52373701021,52373701030,52373701031,52373701301,52373703111,52373712030,52373712031,52373712120,52373712130,52373712131,52373712133,52373712311,52373713221,52373713230,52373731131,52380020222,52380022012,52380022030,52380022200,52382022030,52382022032,52382022210,52382022212,52382022213,52382022302,52382022312,52382022313,52383000320,52383000321,52383001030,52383001032,52383002102,52383002120,52383002122,52383002302,52383020000,52383020001,52383020002,52383020210,52383020211,
102,00,ڰ/,497826562,129871875,499148437,131100000,2,10,26,87,170,372,543823,543833,5438123,5438221,5438240,5438242,5438340,5438342,5438343,5438431,5438440,5438441,54381213,54381322,54381323,54381332,54381412,54381413,54381421,54381422,54381423,54382230,54382231,54382233,54382412,54382430,54382432,54383211,54383213,54383231,54383233,54383410,54383412,54384301,54384420,54384421,54384430,54384431,543812101,543812103,543812110,543812112,543812113,543812121,543812122,543812123,543812211,543812213,543812231,543812233,543813022,543813200,543813202,543813203,543813212,543813213,543813313,543813331,543813332,543813333,543814023,543814032,543814033,543814103,543814112,543814113,543814201,543814202,543814203,543814300,543814301,543814302,543814320,543814322,543815020,543822011,543822013,543822031,543822033,543822320,543822321,543822323,543824100,543824102,543824103,543824112,543824113,543824130,543824132,543824133,543824310,543824312,543824330,543832213,543832302,543832320,543832323,543834132,543835202,543835220,543835222,543842101,543843001,543843003,543843021,543843030,543843031,543843033,543843300,543843301,543843303,543843310,543843311,543843312,543844320,543844321,543844330,543844331,543845000,543845002,543845020,543845022,543845200,543845202,543845220,5438023233,5438023322,5438023323,5438120311,5438120313,5438120331,5438120333,5438121110,5438121112,5438121113,5438121202,5438121203,5438122121,5438122123,5438122301,5438122303,5438122321,5438122323,5438130022,5438130200,5438130202,5438130203,5438130230,5438130232,5438132010,5438132012,5438132013,5438132102,5438132103,5438132112,5438133022,5438133023,5438133112,5438133113,5438133121,5438133123,5438133301,5438133302,5438133303,5438140211,5438140212,5438140213,5438140221,5438140223,5438140300,5438140302,5438140303,5438140311,5438140312,5438140313,5438141022,5438141023,5438142001,5438142002,5438142003,5438143030,5438143031,5438143032,5438143100,5438143101,5438143210,5438150020,5438150022,5438150023,5438150220,5438150221,5438150222,5438220101,5438220103,5438220121,5438220123,5438220301,5438220303,5438222110,5438222111,5438222113,5438222131,5438222133,5438222311,5438223221,5438241101,5438241103,5438241112,5438241113,5438241310,5438241312,5438243110,5438243320,5438243322,5438250002,5438250222,5438321011,5438321013,5438321211,5438322311,5438323031,5438323210,5438323212,5438323213,5438323221,5438323223,5438341100,5438341102,5438341120,5438341122,5438341300,5438341302,5438341332,5438352000,5438352002,5438352003,5438352012,5438352030,5438352032,5438352210,5438352212,5438352230,5438352232,5438421001,5438421021,5438421023,5438421030,5438421031,5438421100,5438421101,5438421110,5438421111,5438430000,5438430001,5438430003,5438430021,5438430023,5438430231,5438430320,5438430321,5438430323,5438432111,5438433021,5438433023,5438433130,5438433131,5438442200,5438442201,5438442202,5438442210,5438442311,5438442313,5438443220,5438443221,5438443230,5438443231,5438443320,5438443321,5438443330,5438443331,5438450010,5438450012,5438450030,5438450032,5438450210,5438450212,5438450230,5438450232,5438452010,5438452012,5438452030,5438452032,5438452210,5438452220,5438452221,54380232232,54380232233,54380232321,54380232322,54380232323,54380233212,54380233213,54380233302,54380233320,54380233322,54380233323,54381203103,54381203121,54381203123,54381203301,54381203303,54381203321,54381203323,54381210010,54381210011,54381210013,54381210211,54381210213,54381210231,54381210233,54381211112,54381212000,54381212002,54381212003,54381212011,54381212012,54381212013,54381221013,54381221031,54381221033,54381221223,54381223001,54381223003,54381223021,54381223023,54381223201,54381223203,54381223221,54381223223,54381300022,54381300200,54381300202,54381300203,54381300230,54381300232,54381302010,54381302012,54381302013,54381302120,54381302122,54381302123,54381302310,54381302312,54381302330,54381302332,54381320112,54381320113,54381321001,54381321002,54381321003,54381321012,54381321013,54381321132,54381321133,54381330200,54381330202,54381330320,54381330322,54381330323,54381330332,54381330333,54381331031,54381331032,54381331033,54381331103,54381331112,54381331113,54381333000,54381333002,54381333003,54381401331,54381401332,54381401333,54381402013,54381402031,54381402032,54381402033,54381402102,54381402103,54381402221,54381402223,54381403010,54381403012,54381403013,54381403101,54381403102,54381403103,54381410123,54381410132,54381410133,54381410202,54381410203,54381410211,54381410212,54381410213,54381411022,54381411023,54381411032,54381411033,54381411122,54381411123,54381411132,54381411133,54381420001,54381420002,54381420003,54381430330,54381430331,54381430332,54381431020,54381431021,54381431022,54381431100,54381431101,54381431110,54381432110,54381432112,54381432120,54381432121,54381432122,54381432130,54381432300,54381432302,54381433233,54381500003,54381500021,54381500022,54381500023,54381500210,54381500212,54381500213,54381500302,54381500320,54381500322,54381502100,54381502102,54381502230,54381502232,54382201001,54382201003,54382201021,54382201023,54382201201,54382201203,54382201221,54382203210,54382203211,54382203213,54382203231,54382221120,54382221121,54382221123,54382221301,54382221303,54382221321,54382221323,54382223131,54382223133,54382232200,54382232201,54382232203,54382232230,54382232231,54382410102,54382410120,54382410122,54382411001,54382411002,54382411003,54382411020,54382411021,54382411023,54382411100,54382411102,54382411103,54382411112,54382411113,54382413110,54382413112,54382413130,54382413132,54382431110,54382431112,54382431120,54382431121,54382431122,54382431300,54382431302,54382431320,54382431322,54382433100,54382433102,54382433120,54382433210,54382500002,54382500200,54382500202,54382500220,54382502202,54383210100,54383210101,54383210103,54383210121,54383210311,54383210313,54383210331,54383210332,54383210333,54383212101,54383212103,54383212130,54383212131,54383212133,54383212311,54383212313,54383223100,54383223101,54383223103,54383223121,54383223130,54383223131,54383223133,54383230113,54383230131,54383230133,54383230300,54383230302,54383230320,54383230322,54383230323,54383230331,54383230333,54383232111,54383232112,54383232113,54383232200,54383232201,54383232203,54383232221,54383413032,54383413033,54383413300,54383413302,54383413330,54383413332,54383413333,54383502222,54383502223,54383520010,54383520012,54383520013,54383520100,54383520102,54383520132,54383520310,54383520312,54383522130,54383522132,54383522310,54383522312,54383522330,54384210030,54384210031,54384210033,54384210320,54384210322,54384211020,54384211022,54384211031,54384211120,54384211200,54384300021,54384302011,54384302013,54384302031,54384302300,54384302301,54384302303,54384302321,54384302330,54384303220,54384303221,54384303223,54384330200,54384330201,54384330203,54384330221,54384331320,54384331321,54384331322,54384331330,54384331331,54384331333,54384332010,54384332011,54384332013,54384332100,54384332101,54384332102,54384332110,54384332111,54384332120,54384332122,54384332300,54384333000,54384333001,54384333010,54384333111,54384333113,54384333131,54384333133,54384422030,54384422031,54384422032,54384422110,54384422200,54384422201,54384423100,54384423101,54384423103,54384423310,54384423311,54384423313,54384432220,54384432221,54384432230,54384432231,54384432320,54384432321,54384432330,54384432331,54384433220,54384433221,54384433223,54384433230,54384433231,54384433320,54384433321,54384433322,54384433330,54384500332,54384502110,54384502112,54384502130,54384502132,54384502310,54384502312,54384502330,54384520130,54384520132,54384520310,54384520312,54384520330,54384522120,54384522121,54384522122,54384522300,
103,00,/ʿ,497025000,130528125,498445312,131587500,2,4,19,61,145,292,543841,543852,5438312,5438420,5438422,5438423,54383013,54383031,54383033,54383102,54383130,54383132,54383133,54383222,54384011,54384013,54384031,54384212,54384213,54384320,54384322,54384323,54386201,54386210,54386211,543830103,543830121,543830123,543830301,543830321,543830323,543831032,543831033,543831122,543831312,543831313,543832201,543832202,543832203,543832230,543832232,543832233,543840101,543840103,543840121,543840123,543840301,543840303,543842113,543843022,543843210,543843212,543843213,543851000,543851110,543851111,543851311,543851313,543851331,543851332,543851333,543853000,543853001,543853002,543853020,543853022,543853200,543853202,543853220,543853222,543862000,543862001,543862030,543862031,543862120,543862121,543862122,543862130,543862131,543862133,543863000,543863002,543863020,543863022,543863023,543863200,5438301120,5438301122,5438301123,5438301132,5438301133,5438301221,5438303031,5438303032,5438303033,5438303201,5438303203,5438303221,5438303223,5438310302,5438310303,5438310312,5438311232,5438311233,5438313100,5438313102,5438313103,5438320231,5438320233,5438320320,5438320322,5438322001,5438322002,5438322003,5438322100,5438322102,5438322120,5438322122,5438401001,5438401003,5438401021,5438401023,5438403003,5438403021,5438403023,5438403201,5438403210,5438403211,5438403213,5438403300,5438403301,5438403302,5438403310,5438403311,5438403313,5438403331,5438403333,5438421000,5438421002,5438421020,5438421022,5438421033,5438421113,5438421121,5438421122,5438421123,5438430020,5438430022,5438430200,5438430202,5438432110,5438432112,5438432113,5438433200,5438433202,5438433203,5438433220,5438433221,5438501111,5438501113,5438501131,5438510010,5438510011,5438510012,5438510020,5438510021,5438510100,5438511000,5438511001,5438511010,5438511011,5438511013,5438511131,5438511331,5438511333,5438513231,5438513232,5438513233,5438513301,5438513302,5438513303,5438530030,5438530032,5438530100,5438530101,5438530102,5438530210,5438530212,5438530230,5438530232,5438532010,5438532012,5438532030,5438532230,5438532232,5438611010,5438611011,5438611012,5438611100,5438611101,5438611103,5438611110,5438611111,5438611112,5438620031,5438620033,5438620211,5438620320,5438620331,5438620333,5438621230,5438621231,5438621232,5438621320,5438621321,5438621323,5438623000,5438623110,5438623111,5438623113,5438630010,5438630012,5438630030,5438630032,5438630210,5438630212,5438630213,5438630302,5438632010,5438632011,5438632012,54383010123,54383010132,54383010133,54383010231,54383010233,54383011022,54383011212,54383011312,54383011313,54383012011,54383012013,54383012031,54383012032,54383012033,54383012231,54383012233,54383030011,54383030013,54383030233,54383030300,54383030301,54383030303,54383032203,54383032221,54383032223,54383100220,54383100222,54383100223,54383100232,54383100233,54383100322,54383103000,54383103002,54383103003,54383103012,54383103013,54383103102,54383103132,54383103133,54383112022,54383112302,54383112303,54383112312,54383113220,54383113222,54383113223,54383131010,54383131012,54383131013,54383131113,54383131120,54383131122,54383131123,54383131131,54383131132,54383131133,54383202232,54383202233,54383202322,54383202323,54383203212,54383203230,54383220002,54383220003,54383221012,54383221030,54383221230,54383221232,54383223102,54383223120,54383223122,54383223123,54383223132,54383232202,54383232220,54383232222,54383232223,54384010001,54384010003,54384010021,54384010023,54384012011,54384012231,54384012233,54384030011,54384030012,54384030013,54384030203,54384030221,54384030222,54384030223,54384032000,54384032001,54384032003,54384032030,54384032031,54384032120,54384032121,54384032123,54384033030,54384033031,54384033032,54384033121,54384033123,54384033301,54384033303,54384033321,54384210032,54384210321,54384210323,54384211021,54384211023,54384211030,54384211032,54384211033,54384211121,54384211122,54384211123,54384211201,54384211202,54384211203,54384300020,54384300022,54384300023,54384302010,54384302012,54384302030,54384302032,54384302033,54384302302,54384302320,54384302322,54384302323,54384302331,54384302332,54384302333,54384303222,54384330202,54384330220,54384330222,54384330223,54384332012,54384332220,54384332221,54384332222,54384332230,54384332231,54384332302,54384332320,54385011121,54385011123,54385011301,54385011303,54385011331,54385100130,54385100131,54385100132,54385100220,54385100221,54385100223,54385100230,54385100232,54385100300,54385100301,54385100302,54385101010,54385101020,54385101100,54385101101,54385101110,54385101111,54385110120,54385110121,54385111200,54385111201,54385111210,54385111211,54385111300,54385111301,54385113113,54385113131,54385113132,54385113133,54385113321,54385113322,54385113323,54385131011,54385131013,54385131031,54385131033,54385131211,54385131213,54385131223,54385131231,54385131232,54385131233,54385132133,54385132303,54385133001,54385133003,54385300310,54385300312,54385300330,54385300332,54385301030,54385301100,54385301101,54385301102,54385301110,54385302110,54385302112,54385302130,54385302132,54385320112,54385320130,54385320320,54385320321,54385320322,54385322100,54385322102,54385322120,54385322122,54385322332,54386110013,54386110031,54386110033,54386110130,54386110131,54386111021,54386111023,54386111130,54386111131,54386111133,54386111210,54386111211,54386111300,54386200200,54386200201,54386200210,54386200211,54386200300,54386200301,54386200303,54386200321,54386200323,54386202101,54386202131,54386202133,54386202311,54386203210,54386203211,54386203300,54386203301,54386203303,54386203321,54386212330,54386212331,54386213220,54386213221,54386221110,54386221111,54386221113,54386230010,54386230011,54386230020,54386230100,54386231011,54386231013,54386231031,54386231120,54386231121,54386300110,54386300112,54386300130,54386300132,54386300310,54386300312,54386300330,54386300332,54386302110,54386302112,54386302113,54386303002,54386303200,54386303201,54386303202,54386303220,54386303222,54386303223,54386320130,54386321000,54386321002,
104,00,Ĺ,496462500,131034375,498389062,132281250,2,15,38,75,154,386,543860,543871,5437673,5437771,5438503,5438512,5438610,5438612,5438613,5438700,5438701,5438720,5438721,5438722,5538010,5538011,5538020,54375731,54375733,54376711,54376712,54376713,54377730,54377731,54377732,54385003,54385010,54385012,54385013,54385021,54385022,54385023,54385102,54385103,54385112,54385130,54386112,54386113,54386220,54386222,54386223,54386232,54386233,54386322,54387020,54387021,54387030,54387031,54387230,54387232,54387300,54387302,55380120,55380212,55380221,543757323,543767033,543767211,543777033,543777211,543777213,543777231,543777330,543777331,543777332,543840322,543840323,543840332,543850012,543850013,543850021,543850023,543850110,543850112,543850201,543850202,543850203,543851012,543851013,543851102,543851103,543851130,543851132,543851320,543851322,543861102,543861103,543862020,543862022,543862210,543862212,543862213,543862302,543862303,543862312,543862313,543863202,543863203,543863212,543863230,543863232,543870220,543870221,543870331,543870333,543872310,543872311,543872312,543873010,543873012,543873030,543873031,543873200,543873202,553800111,553800113,553801210,553801211,553801212,553801311,553802100,553802102,553802200,553802201,553802203,553802221,553802230,553802231,553802300,553802301,5437573013,5437573031,5437573032,5437573033,5437573210,5437573211,5437573213,5437670133,5437670311,5437670313,5437671011,5437671020,5437671022,5437671023,5437671033,5437672131,5437672133,5437672311,5437770131,5437770133,5437770311,5437770312,5437770313,5437770321,5437772121,5437772123,5437772301,5437772302,5437772303,5437772320,5437772331,5437773330,5437773331,5438403202,5438500023,5438500031,5438500032,5438500033,5438500111,5438500112,5438500113,5438500221,5438500223,5438501110,5438501132,5438502001,5438502002,5438502003,5438510031,5438510032,5438510033,5438510103,5438510112,5438510113,5438511002,5438511003,5438511122,5438511123,5438511132,5438511133,5438511310,5438511312,5438511330,5438513100,5438513102,5438513120,5438513210,5438513211,5438513212,5438611000,5438611002,5438611120,5438611122,5438611123,5438611131,5438611132,5438611133,5438620022,5438620023,5438620212,5438620230,5438620232,5438620233,5438620322,5438620323,5438622110,5438622112,5438622113,5438623003,5438623011,5438623012,5438623013,5438623100,5438623102,5438632102,5438632103,5438702300,5438702301,5438702302,5438702310,5438702311,5438703211,5438703300,5438703301,5438703303,5438723130,5438723131,5438723132,5438723300,5438723302,5438730132,5438730133,5438730320,5438730321,5438730322,5438730330,5438732010,5438732011,5438732012,5537071001,5537071011,5537071101,5538001101,5538001103,5538001121,5538001310,5538001311,5538001313,5538001331,5538001333,5538003111,5538012130,5538012200,5538012201,5538012203,5538012210,5538012211,5538012212,5538013000,5538013101,5538021010,5538021012,5538021030,5538021032,5538021033,5538021300,5538021302,5538021320,5538022021,5538022230,5538022321,5538022330,5538022331,5538023030,54375713222,54375713223,54375713231,54375713232,54375713233,54375713320,54375713322,54375713323,54375713332,54375713333,54375730111,54375730112,54375730113,54375730123,54375730233,54375730301,54375730303,54375732011,54375732013,54375732121,54375732123,54375732231,54375732233,54376701313,54376703101,54376703103,54376703121,54376703123,54376703211,54376703213,54376703231,54376703233,54376710101,54376710130,54376710131,54376710133,54376710313,54376710322,54376710323,54376721011,54376721013,54376721031,54376721033,54376721300,54376721301,54376721303,54376721321,54376721323,54376723101,54376723131,54376723133,54376723311,54376723313,54377701133,54377701301,54377701303,54377701321,54377701323,54377703031,54377703033,54377703101,54377703102,54377703103,54377703230,54377703231,54377703233,54377721011,54377721013,54377721031,54377721033,54377721203,54377721221,54377721223,54377723001,54377723003,54377723210,54377723211,54377723212,54377723301,54377723331,54377723333,54377733320,54377733321,54377733322,54377733330,54377733331,54384023313,54384023323,54384023331,54384023332,54384023333,54384032002,54384032032,54384032033,54384032122,54384033033,54384033120,54384033122,54384033300,54384033302,54384033320,54384033322,54384033323,54385001023,54385001031,54385001032,54385001033,54385001101,54385001102,54385001103,54385002010,54385002011,54385002013,54385002031,54385002033,54385002221,54385002223,54385011120,54385011122,54385011300,54385011302,54385011330,54385011332,54385011333,54385020001,54385020002,54385020003,54385100133,54385100222,54385100231,54385100233,54385100303,54385101011,54385101012,54385101013,54385101021,54385101022,54385101023,54385101102,54385101103,54385101112,54385101113,54385110122,54385110123,54385111202,54385111203,54385111212,54385111213,54385111302,54385111303,54385113110,54385113111,54385113112,54385113130,54385113320,54385131010,54385131012,54385131030,54385131032,54385131210,54385131212,54385131220,54385131221,54385131222,54385131230,54385132130,54385132131,54385132132,54385132300,54385132301,54385132302,54385133000,54385133002,54386110010,54386110011,54386110012,54386110030,54386110032,54386110132,54386110133,54386111020,54386111022,54386111132,54386111212,54386111213,54386111301,54386111302,54386111303,54386200202,54386200203,54386200212,54386200213,54386200302,54386200320,54386200322,54386202100,54386202102,54386202103,54386202130,54386202132,54386202310,54386202312,54386202313,54386203212,54386203213,54386203302,54386203320,54386203322,54386203323,54386212332,54386212333,54386213222,54386213223,54386221112,54386230012,54386230013,54386230021,54386230022,54386230023,54386230101,54386230102,54386230103,54386231010,54386231012,54386231030,54386231032,54386231033,54386231122,54386231123,54386320131,54386320132,54386320133,54386321001,54386321003,54386321012,54386321013,54386321120,54386321122,54386321300,54386321302,54386321320,54386321322,54386323100,54386323102,54386323322,54387022200,54387022201,54387022202,54387022210,54387022301,54387022310,54387023030,54387023031,54387023032,54387023120,54387023121,54387023130,54387032000,54387032001,54387032002,54387032010,54387032011,54387033211,54387033213,54387033231,54387033232,54387033233,54387231330,54387231331,54387231333,54387233010,54387233200,54387233201,54387301100,54387301102,54387301120,54387301122,54387301300,54387301302,54387301303,54387303230,54387303231,54387303232,54387303310,54387303311,54387303320,54387312002,54387312020,54387320130,54387320300,54387320302,54387320320,54387321000,54387321001,54387321002,54387321010,55370710000,55370710001,55370710100,55370710101,55370710103,55370711000,55370711001,55370711003,55380011230,55380011231,55380011233,55380013011,55380013120,55380013121,55380013123,55380013301,55380013303,55380031130,55380031131,55380031133,55380121310,55380121320,55380121321,55380121322,55380122130,55380123000,55380123001,55380123002,55380123010,55380130010,55380130011,55380130012,55380130020,55380130021,55380130100,55380130101,55380131000,55380131001,55380131003,55380131021,55380131030,55380131031,55380131033,55380210110,55380210112,55380210130,55380210132,55380210310,55380210312,55380210313,55380211220,55380211222,55380213030,55380213032,55380213220,55380213222,55380220200,55380220201,55380220203,55380220230,55380220231,55380220233,55380222011,55380222013,55380222031,55380222033,55380222211,55380222310,55380223200,55380223201,55380223203,55380230200,55380230201,55380230202,55380230210,55380230211,55380230212,55380230220,55380230222,55380230310,55380230311,55380231000,55380231002,55380231003,55380231020,55380232000,55380232002,55380232020,55380232022,55380232200,
105,00,ͱ/̯,496476562,131925000,497910937,133087500,2,6,30,66,135,269,553811,553821,5538000,5538002,5538100,5538101,5538103,5538201,55370712,55370713,55370730,55370731,55370733,55371711,55380010,55380012,55380030,55380032,55380033,55380132,55380133,55381020,55381021,55381023,55381200,55381202,55381220,55381222,55382001,55382003,55382030,55382031,55382033,55382200,55382202,55382220,55382222,55383011,543870232,543870233,543870322,543870323,553707011,553707013,553707031,553707102,553707103,553707111,553707112,553707113,553707321,553707323,553717130,553717131,553717133,553717311,553800132,553800310,553800312,553800313,553801222,553801223,553801231,553801232,553801233,553801302,553801303,553801312,553801313,553810220,553810221,553810223,553812010,553812012,553812030,553820211,553820212,553820213,553820230,553820231,553820320,553820321,553820323,553822012,553822030,553822032,553822210,553830101,553831000,553831001,553831002,553831010,553831011,553831013,553831020,553831100,553831101,553831102,553831110,553831111,553831113,553832000,553832002,553832020,5437772323,5437772332,5438702222,5438702223,5438702232,5438702233,5438703202,5438703203,5438703210,5438703212,5438703213,5438703302,5438703320,5438703322,5537070101,5537070301,5537070331,5537070333,5537071002,5537071003,5537071012,5537071013,5537071102,5537071103,5537072111,5537072113,5537073201,5537073203,5537171010,5537171011,5537171013,5537171031,5537171321,5537171323,5537173131,5537173133,5538001100,5538001102,5538001120,5538001122,5538001300,5538001302,5538001303,5538001332,5538003110,5538003112,5538012133,5538012202,5538012302,5538012303,5538013003,5538013011,5538013012,5538013013,5538022022,5538022200,5538022202,5538022220,5538022222,5538022223,5538022232,5538022233,5538022322,5538022323,5538022332,5538102221,5538120110,5538120112,5538120130,5538120132,5538120310,5538120312,5538120320,5538120321,5538120322,5538120330,5538122300,5538200010,5538200011,5538200013,5538200031,5538200032,5538200033,5538200210,5538200211,5538200213,5538200231,5538202031,5538202032,5538202033,5538202100,5538202101,5538202103,5538202211,5538202213,5538202321,5538202330,5538202331,5538203220,5538203221,5538220102,5538222112,5538222120,5538222121,5538222122,5538222300,5538222302,5538301031,5538301033,5538301311,5538301313,5538301331,5538301333,5538310030,5538310031,5538310032,5538310120,5538310121,5538310123,5538310210,5538310220,5538311030,5538311031,5538311032,5538311120,5538311121,5538311210,5538311311,5538311313,5538320010,5538320012,5538320030,5538320032,5538320220,5538320222,54377723213,54377723221,54377723300,54377723302,54377723303,54377723330,54377723332,54377733323,54377733332,54377733333,54387022203,54387022211,54387022212,54387022213,54387022300,54387022302,54387022303,54387022311,54387022312,54387022313,54387023033,54387023122,54387023123,54387023131,54387023132,54387023133,54387032003,54387032012,54387032013,54387033210,54387033212,54387033230,55370701030,55370701031,55370701033,55370701211,55370701213,55370701231,55370701232,55370701233,55370703031,55370703301,55370703303,55370703321,55370703323,55370710002,55370710003,55370710102,55370711002,55370721101,55370721310,55370721311,55370721313,55370721331,55370732000,55370732001,55370732003,55370732210,55370732211,55370732213,55371710121,55371710123,55371710331,55371713201,55371731010,55371731011,55371731013,55371731031,55371731033,55371731300,55371731301,55371731303,55371731321,55371733111,55371733113,55380011232,55380013010,55380013012,55380013013,55380013122,55380013300,55380013302,55380031132,55380121311,55380121312,55380121313,55380121323,55380122131,55380122132,55380122133,55380123003,55380123011,55380123012,55380123013,55380130013,55380130022,55380130023,55380130102,55380130103,55380131002,55380131020,55380131022,55380131023,55380131032,55380220202,55380220232,55380222010,55380222012,55380222030,55380222032,55380222210,55380222212,55380222213,55380222311,55380222312,55380222313,55380223202,55381022201,55381022203,55381022230,55381022231,55381022233,55381201130,55381201132,55381201310,55381201312,55381203110,55381203112,55381203130,55381203132,55381203230,55381203231,55381203320,55381221000,55381221001,55381221002,55381221020,55381221022,55381221200,55381221202,55381221222,55381221223,55381223020,55381223022,55381223200,55382000011,55382000121,55382000123,55382000301,55382000302,55382000303,55382002121,55382002331,55382020301,55382020302,55382020303,55382021021,55382021022,55382021023,55382022100,55382022101,55382023200,55382023201,55382023203,55382023220,55382023221,55382023230,55382023231,55382023320,55382023321,55382023330,55382023331,55382032220,55382032221,55382032230,55382032231,55382032233,55382201032,55382201033,55382201320,55382201322,55382203100,55382203102,55382221100,55382221102,55382221103,55382221230,55382221231,55382221232,55382221300,55382221302,55382221320,55382223010,55382223012,55382223200,55382223201,55382223202,55382223220,55382223222,55383010011,55383010013,55383010301,55383010303,55383013001,55383013010,55383013011,55383013100,55383013101,55383031103,55383031110,55383031112,55383031120,55383031122,55383100330,55383100331,55383100332,55383101220,55383101221,55383101223,55383102110,55383102112,55383102120,55383102121,55383102122,55383102210,55383102211,55383102212,55383102220,55383102221,55383102300,55383103011,55383103100,55383103101,55383103110,55383103111,55383110330,55383110331,55383111220,55383111221,55383111230,55383111231,55383112000,55383112001,55383112010,55383112011,55383112013,55383112031,55383112120,55383113101,55383113103,55383113121,55383113310,55383113311,55383113313,55383113331,55383200110,55383200112,55383200130,55383200132,55383200310,55383200311,55383200312,55383200330,55383202100,55383202102,55383202210,55383202211,55383202212,55383202230,
106,00,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,4,11,21,78,158,308,553803,553813,553814,553823,5538042,5538121,5538123,5538221,5538240,5538241,5538242,5538331,5538333,5538340,5538342,54387322,54387323,54387332,54387333,55380233,55380432,55380433,55380522,55381500,55381502,55381520,55381522,55382230,55382231,55382430,55382500,55382501,55383300,55383301,55383303,55383321,543872331,543872333,543873122,543873211,543873212,543873213,543873300,543873302,543874222,553802110,553802111,553802113,553802131,553802133,553802311,553802312,553802313,553802321,553802323,553804000,553804002,553804020,553804022,553804023,553804300,553804302,553804303,553804312,553804313,553805232,553805233,553812211,553812213,553812231,553812233,553815010,553815011,553815032,553815210,553815211,553815212,553815230,553815232,553822011,553822033,553822320,553822321,553822330,553822331,553822333,553824310,553824312,553824320,553824321,553824322,553825020,553825021,553832111,553833020,553833021,553833023,553833201,553833203,553833230,553833231,553834100,553834102,553834120,553834122,553834300,553834302,553834320,553843110,553843111,553844000,553844001,553844010,553844011,5438723303,5438723321,5438723322,5438723323,5438730333,5438731203,5438732031,5438732033,5438732102,5438732103,5438733030,5438733032,5438733033,5438742202,5438742203,5438742212,5438742230,5438742232,5538021120,5538021121,5538021123,5538021301,5538021321,5538021323,5538022333,5538023023,5538023032,5538023033,5538023101,5538023103,5538023201,5538023203,5538023221,5538023222,5538023223,5538040212,5538040320,5538040322,5538040323,5538043010,5538043012,5538043013,5538043102,5538043103,5538043112,5538052022,5538052023,5538052300,5538052302,5538052303,5538052312,5538052313,5538120111,5538120133,5538120331,5538120333,5538122101,5538122103,5538122121,5538122123,5538122301,5538122303,5538122321,5538122322,5538122323,5538150120,5538150121,5538150122,5538150300,5538150302,5538150332,5538152130,5538152131,5538152132,5538152310,5538152312,5538152330,5538152332,5538153020,5538220100,5538220101,5538220130,5538220131,5538220133,5538220311,5538220312,5538220313,5538222111,5538222113,5538222131,5538222133,5538222311,5538222313,5538223220,5538223221,5538223223,5538223230,5538223231,5538223232,5538223320,5538223321,5538223323,5538243110,5538243112,5538243130,5538243132,5538243230,5538243232,5538243300,5538243301,5538243310,5538250220,5538250221,5538250222,5538250230,5538250300,5538250301,5538250310,5538321131,5538330220,5538330221,5538330223,5538332001,5538332003,5538332211,5538332213,5538332321,5538332330,5538332331,5538332333,5538341010,5538341212,5538341230,5538341232,5538343010,5538343012,5538343030,5538343032,5538343210,5538343220,5538343222,5538431001,5538431010,5538431011,5538431013,5538431130,5538431131,5538440020,5538440021,5538440030,5538440031,5538440032,5538440120,5538440121,5538440130,5538440131,5538441000,5538441002,54387231332,54387233011,54387233012,54387233013,54387233202,54387233203,54387303233,54387303312,54387303313,54387303321,54387303322,54387303323,54387312021,54387312022,54387312023,54387312122,54387312300,54387312302,54387312320,54387312322,54387320131,54387320132,54387320133,54387320301,54387320303,54387320321,54387320322,54387320323,54387321003,54387321011,54387321012,54387321013,54387330100,54387330102,54387330120,54387330122,54387330123,54387330310,54387330312,54387330313,54387331220,54387331222,54387331223,54387331332,54387331333,54387422000,54387422002,54387422003,54387422012,54387422013,54387422102,54387422103,54387422130,54387422132,54387422310,54387422312,54387422313,54387422330,54387422331,55380210111,55380210113,55380210131,55380210133,55380210311,55380211221,55380211223,55380213031,55380213033,55380213221,55380213223,55380230203,55380230213,55380230221,55380230223,55380230312,55380230313,55380231001,55380231021,55380231022,55380231023,55380232001,55380232003,55380232021,55380232023,55380232201,55380232202,55380232203,55380400100,55380400102,55380400120,55380400122,55380400300,55380400302,55380400320,55380402102,55380402132,55380402133,55380403022,55380403023,55380403320,55380403322,55380403323,55380403332,55380412223,55380412232,55380412323,55380412332,55380430110,55380430112,55380430113,55380431013,55380431100,55380431102,55380431103,55380431132,55380520202,55380520203,55380520212,55380520213,55380520320,55380520322,55380520323,55380520332,55380523012,55380523013,55380523102,55380523103,55380523112,55380532022,55380532023,55380532200,55380532202,55380532220,55380532222,55381201131,55381201133,55381201311,55381201313,55381203111,55381203113,55381203131,55381203133,55381203232,55381203233,55381203321,55381203322,55381203323,55381221003,55381221021,55381221023,55381221201,55381221203,55381221220,55381221221,55381223021,55381223023,55381223201,55381223202,55381223203,55381501230,55381501231,55381501232,55381501300,55381501301,55381501302,55381503010,55381503012,55381503030,55381503032,55381503033,55381503302,55381503330,55381503332,55381510000,55381510002,55381521330,55381521331,55381521332,55381523312,55381523330,55381523332,55381523333,55381530020,55381530022,55382201030,55382201031,55382201321,55382201323,55382203101,55382203103,55382221101,55382221301,55382221303,55382221321,55382221323,55382223101,55382223103,55382223121,55382223310,55382223311,55382223313,55382232220,55382232221,55382232330,55382232331,55382232332,55382233220,55382233221,55382431110,55382431111,55382431112,55382431130,55382431132,55382432310,55382432312,55382432330,55382432332,55382502230,55382502231,55382502310,55382502312,55382502320,55382503020,55382503021,55382503030,55382503031,55382503110,55382503112,55382510000,55382510002,55382510020,55382510022,55382510200,55382510202,55382510220,55383210011,55383210100,55383210101,55383210110,55383211010,55383211011,55383211013,55383211031,55383211301,55383211330,55383211331,55383211333,55383213111,55383213113,55383213131,55383213133,55383213311,55383302220,55383302221,55383302223,55383320001,55383320003,55383320211,55383320213,55383320231,55383322310,55383322311,55383323200,55383323201,55383323231,55383323320,55383323321,55383410110,55383410120,55383410122,55383410300,55383410302,55383410320,55383410322,55383412100,55383412102,55383412103,55383432120,55383432122,55383432210,55383432212,55383432230,55384310001,55384310031,55384310120,55384310121,55384310123,55384310310,55384310311,55384311200,55384311201,55384311210,55384311211,55384311213,55384400220,55384400221,55384400230,55384400231,55384400233,55384400330,55384400331,55384400332,55384401220,55384401330,55384401331,55384410200,55384410201,55384410202,
107,00,/Ȭ,497460937,128671875,499457812,130134375,3,7,31,86,202,392,533873,543803,543804,5338522,5338621,5338632,5338742,5338743,5338750,5438131,53385113,53385131,53385133,53385200,53385202,53385203,53385232,53385233,53385322,53386200,53386201,53386231,53386233,53386300,53386302,53386330,53386332,53386520,53386522,53386523,53387402,53387403,53387412,53387413,53387510,53387520,53387521,53387522,54381301,54381303,54381400,533851111,533851113,533851123,533851301,533851303,533852010,533852012,533852122,533852300,533852302,533852303,533852312,533852313,533853201,533853202,533853203,533853212,533853230,533853232,533853233,533861110,533861111,533861113,533861131,533861133,533862020,533862022,533862031,533862300,533862301,533862303,533862321,533863010,533863011,533863012,533863030,533863032,533863310,533863312,533863330,533863332,533865210,533865212,533865322,533872110,533872111,533872113,533872131,533874002,533874003,533874010,533874012,533874013,533874100,533874102,533874103,533874111,533874112,533874113,533875112,533875120,533875121,533875122,533875230,533875231,533875232,533875300,533875302,543802131,543802133,543802311,543802313,543802330,543802331,543805000,543805001,543805002,543805202,543813001,543813003,543813300,543813301,543814010,543814011,543814012,543814100,5338413333,5338422222,5338422223,5338422232,5338422233,5338422322,5338511121,5338511122,5338511123,5338511211,5338511212,5338511213,5338511221,5338511222,5338511223,5338513000,5338513001,5338513003,5338513211,5338513212,5338513213,5338513230,5338513231,5338513233,5338520130,5338520132,5338520133,5338521200,5338521202,5338521232,5338523010,5338523012,5338523013,5338523102,5338530232,5338530233,5338532001,5338532002,5338532003,5338532102,5338532103,5338532132,5338532310,5338532312,5338611011,5338611121,5338611123,5338613111,5338620210,5338620211,5338620212,5338620230,5338620300,5338620301,5338620303,5338620330,5338620331,5338620333,5338622000,5338622111,5338623020,5338623021,5338623023,5338623231,5338623233,5338630130,5338630132,5338630310,5338630312,5338630330,5338630332,5338631232,5338631233,5338631322,5338633130,5338633132,5338633310,5338633312,5338633330,5338633332,5338633333,5338641333,5338643111,5338643113,5338643131,5338643133,5338643311,5338643313,5338643331,5338643332,5338643333,5338650332,5338652110,5338652112,5338652130,5338652132,5338653200,5338653202,5338653203,5338653232,5338653233,5338653322,5338721121,5338721123,5338721301,5338721303,5338721330,5338721331,5338721333,5338723111,5338723333,5338740000,5338740002,5338740003,5338740011,5338740012,5338740013,5338740110,5338740112,5338740113,5338741010,5338741012,5338741013,5338741101,5338741102,5338741103,5338751100,5338751102,5338751103,5338751230,5338751231,5338751232,5338751300,5338751302,5338751320,5338752330,5338752332,5338753010,5338753012,5338753030,5338753032,5338753200,5438021111,5438021113,5438021131,5438021132,5438021133,5438023101,5438023103,5438023121,5438023122,5438023123,5438023211,5438023213,5438023231,5438023320,5438023331,5438023333,5438050030,5438050100,5438050101,5438050110,5438050200,5438050202,5438050220,5438050222,5438052000,5438052002,5438052003,5438052200,5438052201,5438052202,5438052220,5438130000,5438130001,5438130003,5438130021,5438130210,5438130211,5438130213,5438132110,5438132111,5438133021,5438133030,5438133031,5438133100,5438133101,5438133102,5438133120,5438133122,5438140130,5438140131,5438140132,5438140200,5438140202,5438140220,5438141010,5438141011,5438141100,5438141101,5438141110,5438141111,53384133321,53384133322,53384133323,53384223202,53384223230,53384223232,53385103331,53385110333,53385111013,53385111033,53385111201,53385111203,53385112023,53385112031,53385112032,53385112033,53385112201,53385112202,53385112203,53385130020,53385130021,53385130023,53385130210,53385130211,53385130213,53385130231,53385132101,53385132102,53385132103,53385132321,53385201102,53385201120,53385201122,53385201123,53385201310,53385201312,53385201313,53385210202,53385210220,53385210222,53385210223,53385212012,53385212030,53385212032,53385212033,53385212300,53385212302,53385212303,53385212332,53385230110,53385230112,53385230113,53385231030,53385231032,53385231033,53385231122,53385231123,53385231131,53385231132,53385231133,53385302233,53385320002,53385320003,53385321002,53385321003,53385321012,53385321300,53385321302,53385321303,53385323112,53385323130,53385323132,53386110131,53386110133,53386111200,53386111201,53386111203,53386111221,53386111223,53386113010,53386113011,53386113013,53386113031,53386113033,53386113211,53386113213,53386113231,53386131100,53386131101,53386131103,53386131121,53386131130,53386131131,53386131133,53386202130,53386202131,53386202132,53386202310,53386202320,53386202321,53386202322,53386203211,53386203320,53386203321,53386203323,53386220010,53386220011,53386220012,53386220020,53386220021,53386220022,53386220100,53386221101,53386221130,53386221131,53386221133,53386221311,53386230221,53386232010,53386232011,53386232013,53386232300,53386232301,53386232303,53386232321,53386232323,53386301310,53386301311,53386301312,53386301330,53386301332,53386303110,53386303112,53386303130,53386303132,53386303310,53386303312,53386303330,53386303332,53386303333,53386312222,53386312223,53386312232,53386312233,53386313230,53386313232,53386313233,53386331102,53386331120,53386331122,53386333112,53386333130,53386333132,53386333310,53386333312,53386422220,53386422222,53386423222,53386423223,53386423232,53386423233,53386423322,53386431101,53386431103,53386431121,53386431123,53386431301,53386431303,53386431321,53386431323,53386432231,53386432232,53386432233,53386432320,53386432322,53386433101,53386433213,53386433231,53386433232,53386433233,53386433302,53386433303,53386502220,53386502222,53386502223,53386502231,53386502232,53386502233,53386502322,53386502323,53386502332,53386502333,53386503232,53386503233,53386521112,53386521130,53386521132,53386521310,53386521312,53386521330,53386521332,53386521333,53386530222,53386532012,53386532122,53386532300,53386532302,53386532303,53386532312,53386532313,53386533201,53386533202,53386533203,53387210110,53387210111,53387210113,53387210131,53387211200,53387211201,53387211203,53387211221,53387211223,53387213001,53387213003,53387213211,53387213320,53387213321,53387213323,53387231101,53387231103,53387231130,53387231131,53387231133,53387231311,53387231313,53387231331,53387231333,53387233133,53387233311,53387233312,53387233313,53387233323,53387400012,53387400102,53387400103,53387401112,53387401113,53387410110,53387410112,53387410113,53387411001,53387411002,53387411003,53387511012,53387511013,53387511120,53387511122,53387511300,53387511302,53387511320,53387512330,53387512331,53387512332,53387513010,53387513012,53387513030,53387513220,53387523310,53387523312,53387523330,53387530110,53387532010,53387532011,53387532012,53387532100,54380211101,54380211103,54380211121,54380211122,54380211123,54380211300,54380211301,54380211303,54380213033,54380213211,54380213213,54380213231,54380213233,54380230333,54380231003,54380231021,54380231023,54380231201,54380231203,54380232123,54380232301,54380232303,54380233210,54380233211,54380233300,54380233301,54380233303,54380233321,54380500310,54380500311,54380500320,54380501020,54380501021,54380501022,54380502230,54380502232,54380520010,54380520012,54380520013,54380520102,54380520120,54380520122,54380520300,54380520302,54380520320,54380520322,54380522030,54380522031,54380522032,54380522220,54380522221,54380522222,54381211110,54381211111,54381211113,54381300020,54381300021,54381300023,54381300201,54381300231,54381300233,54381302011,54381302121,54381302311,54381302313,54381302331,54381302333,54381320110,54381320111,54381321000,54381321010,54381321011,54381321130,54381321131,54381330201,54381330203,54381330321,54381330330,54381330331,54381331030,54381331100,54381331101,54381331102,54381331110,54381331111,54381333001,54381401330,54381402010,54381402011,54381402012,54381402030,54381402100,54381402101,54381402220,54381402222,54381403011,54381403100,54381410120,54381410121,54381410122,54381410130,54381410131,54381410200,54381410201,54381410210,54381411020,54381411021,54381411030,54381411031,54381411120,54381411121,54381411130,54381411131,54381420000,54381500000,54381500002,54381500020,
108,00,ˬ,496771875,128793750,498150000,130734375,1,9,31,85,163,437,543801,5338711,5338713,5338720,5338722,5438001,5438003,5438020,5438022,5438101,53386112,53386130,53386132,53386133,53386222,53386223,53387030,53387032,53387033,53387103,53387121,53387122,53387123,53387212,53387230,53387232,54380003,54380021,54380023,54380210,54380212,54381001,54381030,54381031,54381100,54381101,54381102,54381110,54381111,54381200,54381201,533851320,533851322,533861100,533861102,533861103,533861231,533861233,533861310,533861312,533861313,533862202,533862203,533862210,533862212,533862322,533870033,533870122,533870211,533870213,533870233,533870312,533870313,533871011,533871013,533871201,533871202,533871203,533872100,533872102,533872103,533872310,533872312,533872330,533872332,543800002,543800003,543800011,543800012,543800013,543800020,543800021,543800023,543800201,543800203,543800221,543802110,543802112,543802300,543802301,543802302,543802320,543810030,543810031,543810033,543810211,543810213,543810231,543810320,543810321,543810330,543810331,543811030,543811031,543811200,543811201,543811202,543811220,543812020,543812021,543812023,543812030,543812032,543812201,543822210,543822233,543832011,543832013,543832031,543832033,543832100,543832102,543832120,543832122,543832211,543832300,5338510331,5338512111,5338512112,5338512113,5338512131,5338512133,5338512311,5338512313,5338512331,5338512333,5338513020,5338513022,5338610111,5338610113,5338610331,5338611010,5338611012,5338611300,5338611302,5338611320,5338611322,5338612111,5338612113,5338612131,5338612132,5338612133,5338620233,5338620302,5338620320,5338620322,5338620323,5338622003,5338622011,5338622012,5338622013,5338622112,5338622130,5338622132,5338622133,5338623200,5338623202,5338623203,5338700313,5338700323,5338701202,5338702311,5338702313,5338702323,5338703102,5338703103,5338710103,5338710121,5338710122,5338710123,5338710211,5338710213,5338710232,5338710233,5338712001,5338712003,5338721010,5338721012,5338721302,5338721320,5338721322,5338721323,5338723112,5338723130,5338723132,5338723310,5338723311,5338723312,5338723330,5437071131,5438000002,5438000012,5438000101,5438000103,5438000220,5438000221,5438000223,5438002001,5438002003,5438002230,5438002231,5438021300,5438021301,5438021302,5438021320,5438021322,5438023030,5438023031,5438023032,5438023210,5438023220,5438023221,5438023222,5438100321,5438100323,5438102101,5438102103,5438102330,5438102331,5438102333,5438103220,5438103221,5438103321,5438103330,5438103331,5438110320,5438110321,5438110322,5438110330,5438110331,5438111200,5438111201,5438111202,5438111220,5438111310,5438111311,5438111313,5438112030,5438112031,5438112220,5438112221,5438120220,5438120221,5438120223,5438121000,5438121002,5438121003,5438121020,5438121022,5438122031,5438122033,5438122100,5438122102,5438122120,5438220300,5438220302,5438220320,5438220322,5438222120,5438222121,5438222123,5438222310,5438222312,5438223222,5438320103,5438320121,5438320123,5438320301,5438320302,5438320303,5438321030,5438321032,5438321212,5438321230,5438321232,5438321233,5438322121,5438323010,5438323012,53385103133,53385103301,53385103303,53385103321,53385103323,53385103330,53385103332,53385103333,53385112020,53385112021,53385112022,53385112030,53385112200,53385121101,53385121102,53385121103,53385121301,53385121303,53385121321,53385121323,53385123101,53385123103,53385123121,53385123123,53385123301,53385123323,53385130022,53385130212,53385130230,53385130232,53385130233,53385132100,53385132320,53385132322,53385132323,53386101101,53386101103,53386101121,53386101123,53386101310,53386101311,53386101313,53386101331,53386101333,53386103123,53386103131,53386103132,53386103133,53386103301,53386103331,53386103332,53386103333,53386110130,53386110132,53386111202,53386111220,53386111222,53386113012,53386113030,53386113032,53386113210,53386113212,53386113230,53386113232,53386113233,53386121301,53386121303,53386123013,53386123031,53386123033,53386123231,53386123233,53386131102,53386131120,53386131122,53386131123,53386131132,53386202133,53386202311,53386202312,53386202313,53386202323,53386203210,53386203212,53386203213,53386203322,53386220013,53386220023,53386220101,53386220102,53386220103,53386221100,53386221102,53386221103,53386221132,53386221310,53386221312,53386221313,53386230220,53386230222,53386230223,53386232012,53386232302,53386232320,53386232322,53387003112,53387003113,53387003123,53387003211,53387003212,53387003213,53387003221,53387003223,53387012002,53387012032,53387012033,53387012300,53387012302,53387012320,53387012322,53387012323,53387012332,53387012333,53387021001,53387021010,53387021011,53387021013,53387023100,53387023101,53387023103,53387023121,53387023123,53387023223,53387031002,53387031122,53387031123,53387031133,53387100331,53387100332,53387100333,53387101011,53387101013,53387101023,53387101201,53387101202,53387101203,53387102232,53387102233,53387102303,53387102311,53387102312,53387102313,53387120003,53387120021,53387120022,53387120023,53387210112,53387210130,53387210132,53387210133,53387211202,53387211220,53387211222,53387213000,53387213002,53387213210,53387213212,53387213213,53387213322,53387231100,53387231102,53387231132,53387231310,53387231312,53387231330,53387231332,53387233130,53387233131,53387233132,53387233310,53387233320,53387233321,53387233322,54370711132,54370711133,54370711330,54370711331,54370711333,54370713111,54370713113,54370713131,54370713133,54380000031,54380000032,54380000033,54380000130,54380000132,54380000133,54380001001,54380001003,54380001021,54380001022,54380001023,54380002220,54380002221,54380002223,54380020001,54380020003,54380020021,54380020210,54380020211,54380020213,54380020231,54380022013,54380022330,54380022331,54380022333,54380211100,54380211102,54380211120,54380211302,54380213030,54380213031,54380213032,54380213210,54380213212,54380213230,54380213232,54380230330,54380230331,54380230332,54380231000,54380231001,54380231002,54380231020,54380231022,54380231200,54380231202,54380232120,54380232121,54380232122,54380232230,54380232231,54380232300,54380232302,54380232320,54381000111,54381000113,54381000131,54381000133,54381000311,54381000313,54381000331,54381003200,54381003201,54381003203,54381003221,54381003223,54381021001,54381021003,54381021021,54381021211,54381021213,54381021231,54381021233,54381023011,54381023013,54381023321,54381023323,54381032220,54381032222,54381032300,54381032311,54381033200,54381033201,54381033203,54381103230,54381103231,54381103320,54381103330,54381103331,54381112030,54381112032,54381112100,54381112102,54381112110,54381112111,54381112220,54381112221,54381113000,54381113001,54381113010,54381113011,54381113121,54381113123,54381113311,54381113313,54381120320,54381120321,54381120322,54381120330,54381121000,54381121001,54381121002,54381121020,54381121022,54381122220,54381122221,54381122230,54381202221,54381203100,54381203101,54381203102,54381203120,54381203122,54381203300,54381203302,54381203320,54381203322,54381210012,54381210210,54381210212,54381210230,54381210232,54381212001,54381212010,54381220010,54381220011,54381220013,54381220031,54381220300,54381220301,54381220303,54381220321,54381221010,54381221011,54381221012,54381221030,54381221032,54381221220,54381221221,54381221222,54381222110,54381222111,54381222113,54381222131,54381222133,54381222311,54381222313,54381222331,54381222333,54381223000,54381223002,54381223020,54381223022,54381223200,54381223202,54381223220,54381223222,54382200111,54382201000,54382201002,54382201020,54382201022,54382201200,54382201202,54382201220,54382201222,54382201223,54382203212,54382203230,54382203232,54382203233,54382221122,54382221300,54382221302,54382221320,54382221322,54382223010,54382223011,54382223013,54382223031,54382223033,54382223130,54382223132,54382223233,54382232202,54382232232,54382232233,54383201003,54383201011,54383201012,54383201013,54383201021,54383201203,54383201221,54383201223,54383203001,54383203002,54383203003,54383203210,54383203211,54383203213,54383203231,54383203232,54383203233,54383210102,54383210120,54383210122,54383210123,54383210310,54383210312,54383210330,54383212100,54383212102,54383212132,54383212310,54383212312,54383221010,54383221011,54383221013,54383221031,54383221032,54383221033,54383221231,54383221233,54383230110,54383230111,54383230112,54383230130,54383230132,54383230301,54383230303,54383230321,54383230330,54383230332,54383232110,
109,00,,495801562,129675000,497868750,131362500,4,14,33,97,218,449,543717,543727,543820,543821,5437161,5437163,5437261,5437263,5437361,5437370,5437371,5437373,5437471,5437473,5438113,5438300,5438302,5438400,54370631,54370632,54370633,54370720,54370722,54370723,54370732,54370733,54371601,54371603,54371621,54373602,54373620,54373721,54373723,54374703,54375710,54375711,54375712,54381002,54381020,54381022,54381123,54382202,54382220,54382222,54383101,54383110,54383111,54383200,54384020,54384021,54384022,543706231,543706232,543706233,543706302,543706303,543707023,543707032,543707210,543707212,543707213,543707303,543707312,543707313,543716001,543716002,543716003,543716021,543716023,543716201,543716203,543716230,543716231,543716233,543726011,543726033,543726211,543726213,543726231,543726233,543735133,543735311,543735313,543735331,543736011,543736013,543736031,543736032,543736033,543736210,543736211,543736212,543736220,543736300,543736301,543736303,543736310,543736311,543736312,543737200,543737201,543737203,543747011,543747012,543747013,543747210,543747211,543747213,543747231,543747233,543757011,543757013,543757031,543757130,543757131,543757300,543800222,543810000,543810002,543810232,543811123,543811132,543811211,543811212,543811213,543811221,543811223,543812202,543812220,543812222,543822000,543822002,543822003,543830100,543830111,543831000,543831001,543831121,543831130,543831131,543831133,543832020,543832021,543840230,543840231,543840232,543850000,543850001,5437061322,5437061323,5437061332,5437062131,5437062133,5437062231,5437062232,5437062233,5437062302,5437063011,5437063012,5437063013,5437070212,5437070213,5437070223,5437070332,5437072110,5437072112,5437072113,5437073002,5437073012,5437073013,5437073020,5437073022,5437073023,5437073101,5437073102,5437073103,5437073110,5437073112,5437073113,5437160001,5437160002,5437160003,5437160201,5437160203,5437160221,5437160223,5437162001,5437162003,5437162211,5437162213,5437162320,5437162321,5437162323,5437260101,5437260103,5437260121,5437260131,5437260311,5437260312,5437260313,5437260321,5437260323,5437262101,5437262103,5437262123,5437262301,5437262303,5437262321,5437262323,5437351311,5437351313,5437351321,5437351323,5437353101,5437353103,5437353121,5437353123,5437353301,5437360300,5437360302,5437360303,5437362130,5437362131,5437362210,5437362211,5437362212,5437363020,5437363021,5437363130,5437363131,5437372020,5437372021,5437372211,5437470033,5437470101,5437470103,5437470211,5437470212,5437470213,5437472120,5437472121,5437472123,5437472301,5437472303,5437570101,5437570121,5437570122,5437570123,5437570331,5437571320,5437571321,5437571330,5437571331,5437572113,5437573010,5437573020,5437573021,5437573022,5437573200,5437573203,5438002020,5438002022,5438002200,5438002202,5438002203,5438002232,5438100010,5438100012,5438100030,5438100032,5438102120,5438102122,5438102300,5438102302,5438102303,5438103223,5438103232,5438103233,5438103322,5438103323,5438103332,5438103333,5438111212,5438111213,5438111221,5438111223,5438111302,5438111303,5438111330,5438111332,5438111333,5438112101,5438112103,5438122000,5438122002,5438122210,5438122212,5438122230,5438122232,5438220010,5438220012,5438220013,5438222122,5438222300,5438222302,5438222320,5438222321,5438222322,5438301010,5438301011,5438301020,5438301021,5438301022,5438301100,5438301101,5438301103,5438301130,5438301200,5438301202,5438301220,5438301222,5438303000,5438303002,5438303003,5438303020,5438303021,5438303022,5438303200,5438303202,5438310020,5438310021,5438310030,5438310031,5438310033,5438310311,5438311200,5438311201,5438311203,5438311320,5438311321,5438311323,5438313110,5438320220,5438320221,5438320222,5438320230,5438401020,5438401022,5438401200,5438401202,5438401203,5438401220,5438401221,5438401222,5438402330,5438403000,5438403002,5438500020,5438500021,5438500022,5438500030,5438500100,5438500101,5438500200,5438500202,5438500220,54370612333,54370613203,54370613212,54370613213,54370613302,54370613303,54370613330,54370613332,54370613333,54370621132,54370621133,54370621301,54370621323,54370622132,54370622133,54370622223,54370622231,54370622232,54370622233,54370622302,54370622303,54370623032,54370630022,54370630023,54370630032,54370630033,54370630102,54370630103,54370702033,54370702101,54370702102,54370702103,54370702110,54370702112,54370702113,54370702211,54370702212,54370702213,54370702222,54370702223,54370703020,54370703022,54370703023,54370703032,54370703302,54370703303,54370703330,54370703332,54370713223,54370713232,54370713233,54370713322,54370721110,54370721112,54370721113,54370730033,54370730113,54370730211,54370730213,54370731001,54370731002,54370731003,54370731112,54370731113,54371511133,54371511311,54371600001,54371600002,54371600003,54371602001,54371602003,54371602023,54371602201,54371602203,54371602221,54371602223,54371620001,54371620003,54371620211,54371620213,54371622100,54371622101,54371622103,54371622121,54371622123,54371622310,54371622311,54371622313,54371623221,54371623223,54372601001,54372601021,54372601023,54372601201,54372601300,54372601301,54372601303,54372601331,54372601332,54372601333,54372603032,54372603033,54372603101,54372603103,54372621211,54372621213,54372621223,54372623001,54372623003,54373513122,54373513123,54373513221,54373513223,54373531001,54373531003,54373531021,54373531023,54373531201,54373531203,54373531221,54373533031,54373533033,54373533211,54373533300,54373533310,54373533311,54373601011,54373601013,54373603012,54373603013,54373621320,54373621321,54373621330,54373622130,54373622131,54373622132,54373622200,54373622201,54373622210,54373622211,54373622300,54373623000,54373630221,54373630230,54373630231,54373630233,54373631320,54373631321,54373631330,54373631331,54373632110,54373632111,54373633000,54373633001,54373720220,54373722101,54373722103,54373722131,54373722132,54373722133,54373722310,54373722311,54373722313,54373722331,54374700313,54374700323,54374701000,54374701001,54374701003,54374701021,54374702101,54374702102,54374702103,54374702301,54374702310,54374702311,54374720133,54374720311,54374720313,54374720331,54374721220,54374721221,54374721223,54374723001,54374723003,54374723021,54374723211,54374723213,54374723231,54374723233,54375701031,54375701032,54375701033,54375701201,54375701202,54375701203,54375703000,54375703001,54375703010,54375703011,54375703013,54375703331,54375703333,54375713220,54375713221,54375713230,54375713321,54375713330,54375713331,54375721111,54375721113,54375721121,54375721123,54375721310,54375721311,54375721313,54375721331,54375730110,54375730120,54375730121,54375730122,54375730230,54375730231,54375730232,54375730300,54375730302,54375732010,54375732012,54375732020,54375732021,54375732120,54380020020,54380020022,54380020023,54380020212,54380020230,54380020232,54380020233,54380022010,54380022011,54380022012,54380022332,54381000110,54381000112,54381000130,54381000132,54381000310,54381000312,54381000330,54381000332,54381000333,54381003202,54381003220,54381003222,54381021000,54381021002,54381021020,54381021022,54381021023,54381021210,54381021212,54381021230,54381021232,54381023010,54381023012,54381023320,54381023322,54381032221,54381032223,54381032301,54381032302,54381032303,54381032310,54381032312,54381032313,54381033202,54381103232,54381103233,54381103321,54381103322,54381103323,54381103332,54381103333,54381112031,54381112033,54381112101,54381112103,54381112112,54381112113,54381112222,54381112223,54381113002,54381113003,54381113012,54381113013,54381113120,54381113122,54381113310,54381113312,54381120323,54381120331,54381120332,54381120333,54381121003,54381121021,54381121023,54381122222,54381122223,54381122231,54381122232,54381122233,54381202220,54381202222,54381202223,54381220012,54381220030,54381220032,54381220033,54381220302,54381220320,54381220322,54381220323,54381222112,54381222130,54381222132,54381222310,54381222312,54381222330,54381222332,54382200110,54382200112,54382200113,54382223012,54382223030,54382223032,54382223230,54382223231,54382223232,54383010120,54383010121,54383010122,54383010130,54383010131,54383010230,54383010232,54383011020,54383011021,54383011023,54383011210,54383011211,54383011213,54383011310,54383011311,54383012010,54383012012,54383012030,54383012230,54383012232,54383030010,54383030012,54383030230,54383030231,54383030232,54383030302,54383032200,54383032201,54383032202,54383032220,54383032222,54383100221,54383100230,54383100231,54383100320,54383100321,54383100323,54383103001,54383103010,54383103011,54383103100,54383103101,54383103103,54383103130,54383103131,54383112020,54383112021,54383112023,54383112300,54383112301,54383112310,54383112311,54383112313,54383113221,54383131011,54383131110,54383131111,54383131112,54383131121,54383131130,54383201000,54383201001,54383201002,54383201010,54383201020,54383201022,54383201023,54383201200,54383201201,54383201202,54383201220,54383201222,54383202230,54383202231,54383202320,54383202321,54383203000,54383220000,54383220001,54384010000,54384010002,54384010020,54384010022,54384012010,54384012012,54384012013,54384012230,54384012232,54384023310,54384023311,54384023312,54384023320,54384023321,54384023322,54384023330,54384030010,54384030200,54384030201,54384030202,54384030220,54385001020,54385001021,54385001022,54385001030,54385001100,54385002012,54385002030,54385002032,54385002220,54385002222,54385020000,
110,00,/,495182812,129618750,496110937,130912500,1,4,32,31,105,233,543725,5437052,5437150,5437152,5437153,54370502,54370503,54370512,54370530,54370532,54371411,54371412,54371413,54371431,54371433,54371510,54371512,54371513,54372411,54372413,54372431,54372600,54372602,54372620,54372622,54373500,54373501,54373503,54373510,54373511,54373512,54373521,54373523,54373530,54373532,54373600,54374510,543704131,543704133,543704311,543704333,543705012,543705013,543705102,543705132,543705310,543705312,543705330,543705332,543705333,543714101,543714102,543714103,543714300,543714301,543714303,543714321,543715110,543715112,543716220,543716222,543724123,543724301,543724331,543724333,543735021,543735130,543736012,5437041132,5437041133,5437041301,5437041303,5437041321,5437041323,5437043101,5437043131,5437043133,5437043233,5437043311,5437043313,5437043321,5437043322,5437043323,5437050033,5437050103,5437050112,5437051012,5437051030,5437051032,5437051033,5437051300,5437051302,5437053110,5437053112,5437053130,5437053132,5437053310,5437053312,5437140133,5437140311,5437140313,5437141003,5437142113,5437143020,5437143021,5437143023,5437143201,5437143231,5437151110,5437151111,5437151112,5437151130,5437151132,5437151133,5437162002,5437162020,5437162022,5437162023,5437162230,5437162232,5437162233,5437241211,5437241212,5437241213,5437243031,5437243300,5437243301,5437243303,5437243321,5437260122,5437260123,5437260132,5437260300,5437260301,5437260302,5437260320,5437260322,5437262100,5437262102,5437262120,5437262302,5437262320,5437262322,5437341110,5437341111,5437341113,5437350201,5437350203,5437350230,5437350231,5437350233,5437351310,5437351320,5437352011,5437352031,5437352033,5437352231,5437352233,5437353300,5437353302,5437353320,5437353322,5437353323,5437360100,5437360102,5437360103,5437450011,5437451100,5437451101,5437451102,5437451120,5437451201,5437451210,54370411303,54370413001,54370413003,54370413023,54370413201,54370413203,54370413221,54370413223,54370431001,54370431031,54370431033,54370431211,54370431300,54370431301,54370431303,54370431321,54370431323,54370432233,54370432313,54370432322,54370432323,54370433023,54370433032,54370433033,54370433101,54370433103,54370433121,54370433123,54370433201,54370433202,54370433203,54370500220,54370500222,54370500223,54370500321,54370500322,54370500323,54370501022,54370501023,54370501132,54370510031,54370510032,54370510033,54370510132,54370510310,54370510312,54370510313,54370511222,54370513032,54370513320,54370513322,54370533130,54370533132,54370533133,54370622202,54370622220,54370622221,54370622222,54371403101,54371403103,54371403121,54371403123,54371403310,54371403311,54371403313,54371403331,54371403333,54371410011,54371410012,54371410013,54371410023,54371421111,54371421113,54371421310,54371421311,54371421313,54371421331,54371430220,54371430221,54371430223,54371432030,54371432031,54371432033,54371432300,54371432301,54371432331,54371511130,54371511131,54371511132,54371511310,54371511312,54371511313,54371600000,54371602000,54371602002,54371602020,54371602021,54371602022,54371602200,54371602202,54371602220,54371602222,54371620000,54371620002,54371620210,54371620212,54371622102,54371622120,54371622122,54371622312,54371623220,54371623222,54372410131,54372410133,54372410311,54372410313,54372410331,54372412103,54372412211,54372412213,54372412231,54372412233,54372430011,54372430013,54372430031,54372430033,54372430303,54372430321,54372430330,54372430331,54372430333,54372432111,54372433021,54372433023,54372433201,54372433203,54372433231,54372433233,54372601000,54372601002,54372601003,54372601020,54372601022,54372601200,54372601202,54372601203,54372601302,54372601330,54372603030,54372603031,54372603100,54372603102,54372621210,54372621212,54372621220,54372621221,54372621222,54372623000,54372623002,54373411011,54373411121,54373411123,54373411301,54373411310,54373411311,54373411313,54373411331,54373502001,54373502003,54373502211,54373513120,54373513121,54373513220,54373513222,54373520130,54373520131,54373520133,54373522110,54373522111,54373522113,54373522131,54373522133,54373531000,54373531002,54373531020,54373531022,54373531200,54373531202,54373531220,54373531222,54373531223,54373533030,54373533032,54373533210,54373533212,54373533213,54373601010,54373601012,54373603010,54373603011,54374500101,54374500103,54374500121,54374500130,54374501000,54374501001,54374501002,54374501010,54374501011,54374501100,54374501101,54374501110,54374501111,54374501113,54374501131,54374501133,54374501311,54374511030,54374511031,54374511032,54374511210,54374511220,54374511221,54374512001,54374512003,54374512030,54374512031,54374512033,54374512110,54374512112,54374512120,54374512121,54374512122,
111,00,/َ̎̎ߎ,495309375,130706250,496926562,132890625,3,11,51,105,190,467,543746,543756,543766,5437452,5437453,5437551,5437553,5437761,5437763,5537061,5537063,5537170,5537172,5537271,54374502,54374503,54374513,54374722,54375501,54375503,54375521,54375700,54375702,54375720,54375722,54375723,54376511,54376513,54376530,54376531,54376700,54376702,54376720,54376722,54377601,54377602,54377603,54377621,54377623,54377700,54377702,54377720,54377722,55370601,55370603,55370621,55370623,55370700,55370702,55370720,55370722,55370723,55371610,55371611,55371613,55371631,55371712,55371730,55371732,55372700,55372701,55372703,55372721,55372730,55372731,543736231,543736232,543736233,543736320,543736322,543736323,543736331,543736332,543736333,543737220,543737222,543744132,543744133,543744310,543744311,543744313,543744331,543744333,543745003,543745012,543745111,543745113,543745122,543745123,543747000,543747001,543747002,543747020,543747022,543747200,543747202,543755001,543755003,543755021,543755230,543755231,543755233,543757032,543757210,543757212,543765100,543765101,543765103,543765122,543765123,543765330,543765331,543765333,543767010,543767011,543767012,543767030,543767100,543767212,543767230,543767232,543776001,543776002,543776003,543776201,543776203,543776221,543776223,543777010,543777012,553706001,553706003,553706021,553706022,553706023,553706201,553706203,553706221,553706223,553707032,553707210,553707212,553716001,553716010,553716011,553716013,553716120,553716121,553716123,553716301,553716331,553716333,553717100,553717102,553717312,553717330,553717332,553717333,553727021,553727023,553727201,553727203,553727230,553727231,553820002,553820020,553820022,553820200,553820201,553820202,5437353332,5437353333,5437362222,5437362223,5437362231,5437362232,5437362233,5437362301,5437362302,5437362303,5437363210,5437363212,5437363213,5437363301,5437363302,5437363303,5437372023,5437372212,5437372230,5437372232,5437441233,5437441313,5437443011,5437443013,5437443120,5437443121,5437443123,5437450021,5437450022,5437450023,5437450102,5437450103,5437450112,5437450130,5437450132,5437450133,5437451123,5437451202,5437451213,5437470030,5437470232,5437470233,5437472010,5437472011,5437472012,5437472030,5437472032,5437472320,5437472322,5437550000,5437550001,5437550231,5437570100,5437570102,5437570302,5437570303,5437570330,5437570332,5437572110,5437572130,5437572132,5437573220,5437573221,5437573222,5437650110,5437650111,5437650113,5437651210,5437651211,5437651213,5437653201,5437653210,5437653211,5437653213,5437653320,5437653321,5437653323,5437670130,5437670132,5437670320,5437670322,5437671012,5437671021,5437671030,5437672100,5437672102,5437672312,5437672330,5437672332,5437672333,5437760000,5437760001,5437760003,5437762001,5437762003,5437762021,5437762023,5437762201,5437762203,5437762221,5437770110,5437770111,5437770112,5437770300,5437770301,5437770302,5437770320,5437770322,5437772100,5437772102,5537060003,5537060021,5537060023,5537060201,5537060203,5537062000,5537062001,5537062003,5537062020,5537062021,5537062023,5537062201,5537062203,5537062221,5537062223,5537070100,5537070102,5537070120,5537070122,5537070300,5537070302,5537072112,5537072130,5537072132,5537073202,5537073220,5537073222,5537073223,5537160001,5537160003,5537160031,5537160120,5537160121,5537160310,5537160311,5537160313,5537161220,5537161221,5537163300,5537163301,5537163303,5537163321,5537171030,5537171032,5537171322,5537173100,5537173102,5537173310,5537173312,5537173313,5537261111,5537261113,5537261131,5537270201,5537270203,5537272001,5537272002,5537272003,5537272020,5537272021,5537272023,5537272201,5537272202,5537272203,5537272210,5537272211,5537272321,5537272330,5537273200,5537273201,5537273202,5537273301,5537273310,5537273311,5538102222,5538200000,5538200002,5538200003,5538200230,5538200232,54373533301,54373533302,54373533303,54373533312,54373533313,54373621322,54373621323,54373621331,54373621332,54373621333,54373622133,54373622202,54373622203,54373622212,54373622213,54373622301,54373622302,54373622303,54373623001,54373623002,54373623003,54373630220,54373630222,54373630223,54373630232,54373631322,54373631323,54373631332,54373631333,54373632112,54373632113,54373633002,54373633003,54373720221,54373720222,54373720223,54373722100,54373722102,54373722130,54373722312,54373722330,54373722332,54373722333,54374412311,54374412312,54374412313,54374413033,54374413111,54374413113,54374413122,54374413123,54374430310,54374430311,54374431220,54374431221,54374431223,54374433010,54374433011,54374433013,54374433031,54374433033,54374433211,54374433213,54374500031,54374500032,54374500033,54374500102,54374500120,54374500122,54374500123,54374500131,54374500132,54374500133,54374500201,54374500203,54374501003,54374501012,54374501013,54374501102,54374501103,54374501112,54374501130,54374501132,54374501310,54374501312,54374501313,54374511033,54374511211,54374511212,54374511213,54374511222,54374511223,54374512000,54374512002,54374512032,54374512111,54374512113,54374512123,54374700310,54374700311,54374700312,54374700320,54374700321,54374700322,54374701002,54374701020,54374701022,54374701023,54374702100,54374702300,54374702302,54374702303,54374702312,54374702313,54374720130,54374720131,54374720132,54374720310,54374720312,54374720330,54374720332,54374720333,54374721222,54374723000,54374723002,54374723020,54374723022,54374723023,54374723210,54374723212,54374723230,54374723232,54375411100,54375411101,54375411110,54375411111,54375411113,54375500030,54375500031,54375500033,54375500211,54375500213,54375500231,54375502301,54375502303,54375502330,54375502331,54375520311,54375520313,54375520331,54375520333,54375522111,54375522113,54375522131,54375522133,54375523200,54375523201,54375523210,54375523211,54375523213,54375523231,54375523233,54375701030,54375701200,54375703002,54375703003,54375703012,54375703330,54375703332,54375721110,54375721112,54375721120,54375721122,54375721312,54375721330,54375721332,54375721333,54375732022,54375732023,54375732122,54375732230,54375732232,54376501011,54376501013,54376501031,54376501120,54376501121,54376501123,54376501301,54376501310,54376501311,54376503311,54376503313,54376503331,54376503333,54376510200,54376510201,54376510210,54376510211,54376512121,54376512123,54376521111,54376532001,54376532120,54376532121,54376532123,54376532310,54376532311,54376532313,54376533220,54376533221,54376533223,54376701310,54376701311,54376701312,54376703100,54376703102,54376703120,54376703122,54376703210,54376703212,54376703230,54376703232,54376710100,54376710102,54376710103,54376710132,54376710310,54376710311,54376710312,54376710320,54376710321,54376721010,54376721012,54376721030,54376721032,54376721302,54376721320,54376721322,54376723100,54376723102,54376723103,54376723130,54376723132,54376723310,54376723312,54377511001,54377511010,54377511011,54377511100,54377511101,54377511110,54377511111,54377511331,54377511333,54377513111,54377513113,54377513131,54377513133,54377513311,54377513313,54377513331,54377513333,54377600020,54377600021,54377600023,54377620001,54377620003,54377620021,54377620023,54377620201,54377620203,54377622021,54377622023,54377622231,54377622233,54377701130,54377701131,54377701132,54377701300,54377701302,54377701320,54377701322,54377703030,54377703032,54377703100,54377703232,54377721010,54377721012,54377721030,54377721032,54377721200,54377721201,54377721202,54377721220,54377721222,54377723000,54377723002,54377723220,54377723222,54377723223,55370600011,55370600012,55370600013,55370600221,55370600223,55370602001,55370602022,55370602023,55370620021,55370620022,55370620023,55370620220,55370620221,55370620223,55370622001,55370622203,55370622221,55370622223,55370701032,55370701210,55370701212,55370701230,55370703030,55370703032,55370703033,55370703300,55370703302,55370703320,55370703322,55370721100,55370721102,55370721103,55370721312,55370721330,55370721332,55370721333,55370732002,55370732212,55371600001,55371600301,55371600331,55371601220,55371601221,55371601230,55371601231,55371601233,55371603121,55371603123,55371603310,55371603311,55371603313,55371612221,55371612230,55371612231,55371612233,55371630011,55371630310,55371630311,55371630313,55371630331,55371630333,55371632111,55371633020,55371633021,55371633023,55371633201,55371633230,55371633231,55371633233,55371710120,55371710122,55371710330,55371710332,55371710333,55371713200,55371713202,55371713203,55371731012,55371731030,55371731032,55371731302,55371731320,55371731322,55371731323,55371733110,55371733112,55372611100,55372611101,55372611103,55372611121,55372611123,55372611301,55372611330,55372611331,55372611333,55372631311,55372631313,55372631331,55372633133,55372633311,55372633313,55372702000,55372702001,55372702003,55372702210,55372702211,55372702213,55372702231,55372702232,55372702233,55372720001,55372720002,55372720003,55372720220,55372720221,55372720223,55372722001,55372722003,55372722120,55372722121,55372722130,55372722131,55372722133,55372722200,55372723201,55372723203,55372723231,55372723310,55372723311,55372723320,55372732030,55372732031,55372732032,55372732100,55372732200,55372732201,55372732210,55372733001,55372733003,55372733021,55372733030,55372733031,55372733120,55372733121,55372733130,55381022200,55381022202,55381022232,55382000010,55382000012,55382000013,55382000120,55382000122,55382000300,55382002120,55382002122,55382002123,55382002330,55382002332,55382002333,55382020300,55382021020,55382022000,55382022001,55382022010,55382022011,
112,00,/ŷε,495168750,126693750,497643750,129806250,17,21,76,156,323,670,523775,523776,533706,533707,533716,533717,533726,533727,533737,533747,533757,533767,533820,533830,533840,533850,533860,5237772,5337050,5337051,5337053,5337150,5337151,5337153,5337251,5337361,5337363,5337561,5337770,5337771,5337773,5338002,5338003,5338100,5338102,5338103,5338310,5338312,52376431,52376432,52376433,52376522,52376523,52376532,52376533,52376621,52376622,52376623,52376632,52376633,52377410,52377411,52377413,52377431,52377702,52377703,52377730,52377732,52377733,53370520,53370521,53370523,53371521,53371523,53372501,53372531,53372533,53373600,53373601,53373603,53374610,53374611,53374613,53374631,53374632,53374633,53375631,53375633,53377720,53377721,53377723,53380000,53380002,53380003,53380012,53381010,53381012,53381120,53384100,53384101,53384102,53384120,53384122,53384123,53385100,53385101,53385102,53385120,53385122,53386100,53386102,53386120,53386122,53387000,53387001,53387002,53387010,53387011,53387013,53387020,53387022,54370701,54370710,54370712,523764123,523764132,523764301,523764303,523765200,523765202,523765203,523765313,523766202,523766203,523766302,523766303,523766312,523766313,523767222,523774121,523774123,523774300,523774301,523774303,523774330,523774331,523774333,523777000,523777002,523777003,523777010,523777012,523777120,523777122,523777123,523777310,523777312,523777313,523870202,523870220,523870222,523870223,533704111,533704113,533704131,533704133,533704311,533705221,533705222,533705223,533714131,533714133,533715201,533715203,533715221,533715222,533715223,533725001,533725030,533725031,533725301,533725303,533725321,533735110,533735111,533735113,533736020,533736021,533736023,533736210,533736211,533736213,533746120,533746121,533746123,533746301,533746302,533746303,533756301,533756303,533766111,533766113,533766131,533766133,533766311,533766313,533766331,533766333,533776111,533776112,533776113,533776130,533776131,533776133,533776311,533777220,533777221,533777223,533800010,533800012,533800013,533800103,533800132,533801200,533801202,533810110,533810112,533810130,533810132,533811220,533811221,533811222,533821000,533821002,533821020,533821022,533821200,533821202,533821220,533821222,533821223,533831120,533831122,533831300,533831302,533831320,533841030,533841031,533841032,533841210,533841212,533841213,533841322,533851030,533851032,533851100,533851101,533851102,533851210,533851212,533851230,533851232,533861010,533861012,533861030,533861032,533861210,533861212,533870030,533870121,533870212,533870230,533871000,533871001,533871002,533871020,543707031,543707110,543707112,543707130,5237641212,5237641332,5237641333,5237642313,5237642331,5237642332,5237642333,5237643023,5237650232,5237652010,5237652012,5237652013,5237652122,5237652123,5237652132,5237653033,5237653113,5237653121,5237653122,5237653123,5237660231,5237660232,5237660233,5237660322,5237660323,5237660332,5237660333,5237662011,5237662012,5237662013,5237663000,5237663002,5237663003,5237663011,5237663012,5237663013,5237663102,5237672020,5237672022,5237672200,5237672201,5237672202,5237740110,5237740111,5237740113,5237741200,5237741201,5237741203,5237741221,5237741222,5237741223,5237743020,5237743021,5237743023,5237743201,5237743210,5237743211,5237743213,5237743320,5237743321,5237770010,5237770012,5237770013,5237770112,5237770130,5237770132,5237771320,5237771322,5237771323,5237773110,5237773112,5237773113,5238702002,5238702030,5238702032,5238702210,5238702212,5238702322,5337041101,5337041103,5337041121,5337041123,5337041301,5337041303,5337041321,5337041323,5337043013,5337043030,5337043031,5337043032,5337043101,5337043102,5337043103,5337043120,5337043121,5337043130,5337043131,5337052201,5337052203,5337141111,5337141113,5337141131,5337141132,5337141133,5337141301,5337141302,5337141303,5337141321,5337143111,5337152000,5337152001,5337152003,5337152021,5337152023,5337152201,5337152202,5337152203,5337250001,5337250031,5337250033,5337250211,5337253000,5337253001,5337253003,5337253021,5337253023,5337253201,5337253203,5337253231,5337351120,5337351121,5337351123,5337351301,5337351310,5337351311,5337351313,5337360221,5337360223,5337362011,5337362121,5337362310,5337362311,5337362313,5337362331,5337362333,5337460111,5337460113,5337460131,5337461220,5337461221,5337461223,5337462131,5337462133,5337462311,5337462313,5337463001,5337463003,5337563001,5337563211,5337563213,5337661101,5337661103,5337661121,5337661123,5337663101,5337663103,5337663121,5337663123,5337663301,5337663303,5337761013,5337761031,5337761032,5337761033,5337761102,5337761103,5337761210,5337761211,5337761213,5337761231,5337761320,5337761321,5337761323,5337763101,5337763131,5337763133,5337772221,5337772223,5338000112,5338001013,5338001022,5338001023,5338001300,5338001302,5338001303,5338001330,5338001332,5338001333,5338010222,5338010223,5338012030,5338012032,5338012200,5338012201,5338012202,5338012220,5338012222,5338101110,5338101111,5338101112,5338101130,5338101132,5338101310,5338101312,5338101330,5338101332,5338110000,5338112230,5338210030,5338210212,5338210230,5338210232,5338210233,5338212010,5338212011,5338212032,5338212210,5338212212,5338212333,5338311000,5338311002,5338311020,5338311022,5338311023,5338313030,5338313032,5338313210,5338313220,5338313221,5338313222,5338410330,5338410332,5338411000,5338411002,5338411200,5338412110,5338412112,5338413022,5338413200,5338413202,5338413203,5338413212,5338413230,5338413232,5338413233,5338510310,5338510311,5338510312,5338511030,5338511031,5338511032,5338511100,5338511102,5338511200,5338511201,5338511210,5338610130,5338610132,5338610310,5338610311,5338610332,5338612110,5338612112,5338612300,5338612302,5338612320,5338612321,5338612322,5338700310,5338700320,5338701201,5338701231,5338702102,5338702103,5338702320,5338702321,5338703101,5338703110,5338703111,5338710030,5338710031,5338710032,5338710100,5338710210,5338710212,5338710220,5338710221,5338710222,5437070010,5437070011,5437070013,5437070300,5437070301,5437070331,5437071110,5437071111,5437071112,5437071130,5437071132,5437071310,5437071312,5437071320,5437071321,5437071330,5437071331,5437071333,5437073000,5437073001,5437073010,5438000000,5438000001,5438000010,5438000011,52376412132,52376412133,52376413022,52376413023,52376413302,52376423112,52376423113,52376423123,52376423301,52376423303,52376430033,52376430211,52376430212,52376430213,52376430221,52376430223,52376502222,52376502223,52376502232,52376502233,52376502330,52376502332,52376520110,52376520112,52376520113,52376521002,52376521020,52376521022,52376521200,52376521202,52376521203,52376521212,52376521213,52376521332,52376521333,52376530222,52376530223,52376530232,52376530233,52376530322,52376530323,52376531023,52376531032,52376531033,52376531122,52376531123,52376531201,52376531203,52376602303,52376603200,52376603202,52376603203,52376603212,52376603213,52376603300,52376603302,52376603303,52376603312,52376612222,52376612223,52376620020,52376620022,52376620023,52376620032,52376620033,52376620100,52376620101,52376620103,52376630010,52376630012,52376630013,52376630101,52376630102,52376630103,52376631002,52376631032,52376631033,52376631122,52376631123,52376631131,52376631132,52376631133,52376720020,52376720022,52376720023,52376720210,52376720212,52376720230,52376720232,52376722030,52376722031,52376722032,52376722320,52376722322,52376723223,52376723232,52376723233,52377401120,52377401121,52377401311,52377401313,52377401331,52377401332,52377401333,52377403110,52377403111,52377403113,52377403331,52377403333,52377412021,52377412023,52377