=begin comment

Fastly API

Via the Fastly API you can perform any of the operations that are possible within the management console,  including creating services, domains, and backends, configuring rules or uploading your own application code, as well as account operations such as user administration and billing reports. The API is organized into collections of endpoints that allow manipulation of objects related to Fastly services and accounts. For the most accurate and up-to-date API reference content, visit our [Developer Hub](https://developer.fastly.com/reference/api/) 

The version of the API Spec document: 1.0.0
Contact: oss@fastly.com

=end comment

=cut

#
# NOTE: This class is auto generated.
# Do not edit the class manually.
#
package WebService::Fastly::Object::Results;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON::MaybeXS qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;


use base ("Class::Accessor", "Class::Data::Inheritable");

#
#The [results](#results-data-model) of the query, grouped by service (and optionally, region), and aggregated over the appropriate time span.
#
# NOTE: This class is auto generated. Do not edit the class manually.
#

=begin comment

Fastly API

Via the Fastly API you can perform any of the operations that are possible within the management console,  including creating services, domains, and backends, configuring rules or uploading your own application code, as well as account operations such as user administration and billing reports. The API is organized into collections of endpoints that allow manipulation of objects related to Fastly services and accounts. For the most accurate and up-to-date API reference content, visit our [Developer Hub](https://developer.fastly.com/reference/api/) 

The version of the API Spec document: 1.0.0
Contact: oss@fastly.com

=end comment

=cut

#
# NOTE: This class is auto generated.
# Do not edit the class manually.
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('openapi_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {});
__PACKAGE__->mk_classdata('class_documentation' => {});
__PACKAGE__->mk_classdata('openapi_nullable' => {});

# new plain object
sub new {
    my ($class, %args) = @_;

    my $self = bless {}, $class;

    $self->init(%args);

    return $self;
}

# initialize the object
sub init
{
    my ($self, %args) = @_;

    foreach my $attribute (keys %{$self->attribute_map}) {
        my $args_key = $self->attribute_map->{$attribute};
        $self->$attribute( $args{ $args_key } );
    }
}

# return perl hash
sub to_hash {
    my $self = shift;
    my $_hash = decode_json(JSON()->new->allow_blessed->convert_blessed->encode($self));

    return $_hash;
}

# used by JSON for serialization
sub TO_JSON {
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
    }

    return $_data;
}

# from Perl hashref
sub from_hash {
    my ($self, $hash) = @_;

    # loop through attributes and use openapi_types to deserialize the data
    while ( my ($_key, $_type) = each %{$self->openapi_types} ) {
        my $_json_attribute = $self->attribute_map->{$_key};
        my $_is_nullable = ($self->openapi_nullable->{$_key} || 'false') eq 'true';
        if ($_type =~ /^array\[(.+)\]$/i) { # array
            my $_subclass = $1;
            my @_array = ();
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                push @_array, $self->_deserialize($_subclass, $_element, $_is_nullable);
            }
            $self->{$_key} = \@_array;
        } elsif ($_type =~ /^hash\[string,(.+)\]$/i) { # hash
            my $_subclass = $1;
            my %_hash = ();
            while (my($_key, $_element) = each %{$hash->{$_json_attribute}}) {
                $_hash{$_key} = $self->_deserialize($_subclass, $_element, $_is_nullable);
            }
            $self->{$_key} = \%_hash;
        } elsif (exists $hash->{$_json_attribute}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{$_json_attribute}, $_is_nullable);
        } else {
            $log->debugf("Warning: %s (%s) does not exist in input hash\n", $_key, $_json_attribute);
        }
    }

    return $self;
}

# deserialize non-array data
sub _deserialize {
    my ($self, $type, $data, $is_nullable) = @_;
    $log->debugf("deserializing %s with %s",Dumper($data), $type);

    if (!(defined $data) && $is_nullable) {
        return undef;
    }
    if ($type eq 'DateTime') {
        return DateTime->from_epoch(epoch => str2time($data));
    } elsif ( grep( /^$type$/, ('int', 'double', 'string', 'boolean'))) {
        return $data;
    } else { # hash(model)
        my $_instance = eval "WebService::Fastly::Object::$type->new()";
        return $_instance->from_hash($data);
    }
}


__PACKAGE__->class_documentation({description => 'The [results](#results-data-model) of the query, grouped by service (and optionally, region), and aggregated over the appropriate time span.',
                                  class => 'Results',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'requests' => {
        datatype => 'int',
        base_name => 'requests',
        description => 'Number of requests processed.',
        format => '',
        read_only => 'false',
            },
    'hits' => {
        datatype => 'int',
        base_name => 'hits',
        description => 'Number of cache hits.',
        format => '',
        read_only => 'false',
            },
    'hits_time' => {
        datatype => 'double',
        base_name => 'hits_time',
        description => 'Total amount of time spent processing cache hits (in seconds).',
        format => '',
        read_only => 'false',
            },
    'miss' => {
        datatype => 'int',
        base_name => 'miss',
        description => 'Number of cache misses.',
        format => '',
        read_only => 'false',
            },
    'miss_time' => {
        datatype => 'double',
        base_name => 'miss_time',
        description => 'Total amount of time spent processing cache misses (in seconds).',
        format => '',
        read_only => 'false',
            },
    'pass' => {
        datatype => 'int',
        base_name => 'pass',
        description => 'Number of requests that passed through the CDN without being cached.',
        format => '',
        read_only => 'false',
            },
    'pass_time' => {
        datatype => 'double',
        base_name => 'pass_time',
        description => 'Total amount of time spent processing cache passes (in seconds).',
        format => '',
        read_only => 'false',
            },
    'errors' => {
        datatype => 'int',
        base_name => 'errors',
        description => 'Number of cache errors.',
        format => '',
        read_only => 'false',
            },
    'restarts' => {
        datatype => 'int',
        base_name => 'restarts',
        description => 'Number of restarts performed.',
        format => '',
        read_only => 'false',
            },
    'hit_ratio' => {
        datatype => 'double',
        base_name => 'hit_ratio',
        description => 'Ratio of cache hits to cache misses (between 0 and 1).',
        format => '',
        read_only => 'false',
            },
    'bandwidth' => {
        datatype => 'int',
        base_name => 'bandwidth',
        description => 'Total bytes delivered (&#x60;resp_header_bytes&#x60; + &#x60;resp_body_bytes&#x60; + &#x60;bereq_header_bytes&#x60; + &#x60;bereq_body_bytes&#x60; + &#x60;compute_resp_header_bytes&#x60; + &#x60;compute_resp_body_bytes&#x60; + &#x60;compute_bereq_header_bytes&#x60; + &#x60;compute_bereq_body_bytes&#x60; + &#x60;websocket_resp_header_bytes&#x60; + &#x60;websocket_resp_body_bytes&#x60; + &#x60;websocket_bereq_header_bytes&#x60; + &#x60;websocket_bereq_body_bytes&#x60; + &#x60;fanout_resp_header_bytes&#x60; + &#x60;fanout_resp_body_bytes&#x60; + &#x60;fanout_bereq_header_bytes&#x60; + &#x60;fanout_bereq_body_bytes&#x60;).',
        format => '',
        read_only => 'false',
            },
    'body_size' => {
        datatype => 'int',
        base_name => 'body_size',
        description => 'Total body bytes delivered (alias for resp_body_bytes).',
        format => '',
        read_only => 'false',
            },
    'header_size' => {
        datatype => 'int',
        base_name => 'header_size',
        description => 'Total header bytes delivered (alias for resp_header_bytes).',
        format => '',
        read_only => 'false',
            },
    'req_body_bytes' => {
        datatype => 'int',
        base_name => 'req_body_bytes',
        description => 'Total body bytes received.',
        format => '',
        read_only => 'false',
            },
    'req_header_bytes' => {
        datatype => 'int',
        base_name => 'req_header_bytes',
        description => 'Total header bytes received.',
        format => '',
        read_only => 'false',
            },
    'resp_body_bytes' => {
        datatype => 'int',
        base_name => 'resp_body_bytes',
        description => 'Total body bytes delivered (edge_resp_body_bytes + shield_resp_body_bytes).',
        format => '',
        read_only => 'false',
            },
    'resp_header_bytes' => {
        datatype => 'int',
        base_name => 'resp_header_bytes',
        description => 'Total header bytes delivered (edge_resp_header_bytes + shield_resp_header_bytes).',
        format => '',
        read_only => 'false',
            },
    'bereq_body_bytes' => {
        datatype => 'int',
        base_name => 'bereq_body_bytes',
        description => 'Total body bytes sent to origin.',
        format => '',
        read_only => 'false',
            },
    'bereq_header_bytes' => {
        datatype => 'int',
        base_name => 'bereq_header_bytes',
        description => 'Total header bytes sent to origin.',
        format => '',
        read_only => 'false',
            },
    'uncacheable' => {
        datatype => 'int',
        base_name => 'uncacheable',
        description => 'Number of requests that were designated uncachable.',
        format => '',
        read_only => 'false',
            },
    'pipe' => {
        datatype => 'int',
        base_name => 'pipe',
        description => 'Optional. Pipe operations performed (legacy feature).',
        format => '',
        read_only => 'false',
            },
    'synth' => {
        datatype => 'int',
        base_name => 'synth',
        description => 'Number of requests that returned a synthetic response (i.e., response objects created with the &#x60;synthetic&#x60; VCL statement).',
        format => '',
        read_only => 'false',
            },
    'tls' => {
        datatype => 'int',
        base_name => 'tls',
        description => 'Number of requests that were received over TLS.',
        format => '',
        read_only => 'false',
            },
    'tls_v10' => {
        datatype => 'int',
        base_name => 'tls_v10',
        description => 'Number of requests received over TLS 1.0.',
        format => '',
        read_only => 'false',
            },
    'tls_v11' => {
        datatype => 'int',
        base_name => 'tls_v11',
        description => 'Number of requests received over TLS 1.1.',
        format => '',
        read_only => 'false',
            },
    'tls_v12' => {
        datatype => 'int',
        base_name => 'tls_v12',
        description => 'Number of requests received over TLS 1.2.',
        format => '',
        read_only => 'false',
            },
    'tls_v13' => {
        datatype => 'int',
        base_name => 'tls_v13',
        description => 'Number of requests received over TLS 1.3.',
        format => '',
        read_only => 'false',
            },
    'edge_requests' => {
        datatype => 'int',
        base_name => 'edge_requests',
        description => 'Number of requests sent by end users to Fastly.',
        format => '',
        read_only => 'false',
            },
    'edge_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'edge_resp_header_bytes',
        description => 'Total header bytes delivered from Fastly to the end user.',
        format => '',
        read_only => 'false',
            },
    'edge_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'edge_resp_body_bytes',
        description => 'Total body bytes delivered from Fastly to the end user.',
        format => '',
        read_only => 'false',
            },
    'edge_hit_requests' => {
        datatype => 'int',
        base_name => 'edge_hit_requests',
        description => 'Number of requests sent by end users to Fastly that resulted in a hit at the edge.',
        format => '',
        read_only => 'false',
            },
    'edge_miss_requests' => {
        datatype => 'int',
        base_name => 'edge_miss_requests',
        description => 'Number of requests sent by end users to Fastly that resulted in a miss at the edge.',
        format => '',
        read_only => 'false',
            },
    'origin_fetches' => {
        datatype => 'int',
        base_name => 'origin_fetches',
        description => 'Number of requests sent to origin.',
        format => '',
        read_only => 'false',
            },
    'origin_fetch_header_bytes' => {
        datatype => 'int',
        base_name => 'origin_fetch_header_bytes',
        description => 'Total request header bytes sent to origin.',
        format => '',
        read_only => 'false',
            },
    'origin_fetch_body_bytes' => {
        datatype => 'int',
        base_name => 'origin_fetch_body_bytes',
        description => 'Total request body bytes sent to origin.',
        format => '',
        read_only => 'false',
            },
    'origin_fetch_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'origin_fetch_resp_header_bytes',
        description => 'Total header bytes received from origin.',
        format => '',
        read_only => 'false',
            },
    'origin_fetch_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'origin_fetch_resp_body_bytes',
        description => 'Total body bytes received from origin.',
        format => '',
        read_only => 'false',
            },
    'origin_revalidations' => {
        datatype => 'int',
        base_name => 'origin_revalidations',
        description => 'Number of responses received from origin with a &#x60;304&#x60; status code in response to an &#x60;If-Modified-Since&#x60; or &#x60;If-None-Match&#x60; request. Under regular scenarios, a revalidation will imply a cache hit. However, if using Fastly Image Optimizer or segmented caching this may result in a cache miss.',
        format => '',
        read_only => 'false',
            },
    'origin_cache_fetches' => {
        datatype => 'int',
        base_name => 'origin_cache_fetches',
        description => 'The total number of completed requests made to backends (origins) that returned cacheable content.',
        format => '',
        read_only => 'false',
            },
    'shield' => {
        datatype => 'int',
        base_name => 'shield',
        description => 'Number of requests from edge to the shield POP.',
        format => '',
        read_only => 'false',
            },
    'shield_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'shield_resp_body_bytes',
        description => 'Total body bytes delivered via a shield.',
        format => '',
        read_only => 'false',
            },
    'shield_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'shield_resp_header_bytes',
        description => 'Total header bytes delivered via a shield.',
        format => '',
        read_only => 'false',
            },
    'shield_fetches' => {
        datatype => 'int',
        base_name => 'shield_fetches',
        description => 'Number of requests made from one Fastly POP to another, as part of shielding.',
        format => '',
        read_only => 'false',
            },
    'shield_fetch_header_bytes' => {
        datatype => 'int',
        base_name => 'shield_fetch_header_bytes',
        description => 'Total request header bytes sent to a shield.',
        format => '',
        read_only => 'false',
            },
    'shield_fetch_body_bytes' => {
        datatype => 'int',
        base_name => 'shield_fetch_body_bytes',
        description => 'Total request body bytes sent to a shield.',
        format => '',
        read_only => 'false',
            },
    'shield_fetch_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'shield_fetch_resp_header_bytes',
        description => 'Total response header bytes sent from a shield to the edge.',
        format => '',
        read_only => 'false',
            },
    'shield_fetch_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'shield_fetch_resp_body_bytes',
        description => 'Total response body bytes sent from a shield to the edge.',
        format => '',
        read_only => 'false',
            },
    'shield_revalidations' => {
        datatype => 'int',
        base_name => 'shield_revalidations',
        description => 'Number of responses received from origin with a &#x60;304&#x60; status code, in response to an &#x60;If-Modified-Since&#x60; or &#x60;If-None-Match&#x60; request to a shield. Under regular scenarios, a revalidation will imply a cache hit. However, if using segmented caching this may result in a cache miss.',
        format => '',
        read_only => 'false',
            },
    'shield_cache_fetches' => {
        datatype => 'int',
        base_name => 'shield_cache_fetches',
        description => 'The total number of completed requests made to shields that returned cacheable content.',
        format => '',
        read_only => 'false',
            },
    'ipv6' => {
        datatype => 'int',
        base_name => 'ipv6',
        description => 'Number of requests that were received over IPv6.',
        format => '',
        read_only => 'false',
            },
    'otfp' => {
        datatype => 'int',
        base_name => 'otfp',
        description => 'Number of responses that came from the Fastly On-the-Fly Packaging service for video-on-demand.',
        format => '',
        read_only => 'false',
            },
    'otfp_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'otfp_resp_body_bytes',
        description => 'Total body bytes delivered from the Fastly On-the-Fly Packaging service for video-on-demand.',
        format => '',
        read_only => 'false',
            },
    'otfp_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'otfp_resp_header_bytes',
        description => 'Total header bytes delivered from the Fastly On-the-Fly Packaging service for video-on-demand.',
        format => '',
        read_only => 'false',
            },
    'otfp_shield_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'otfp_shield_resp_body_bytes',
        description => 'Total body bytes delivered via a shield for the Fastly On-the-Fly Packaging service for video-on-demand.',
        format => '',
        read_only => 'false',
            },
    'otfp_shield_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'otfp_shield_resp_header_bytes',
        description => 'Total header bytes delivered via a shield for the Fastly On-the-Fly Packaging service for video-on-demand.',
        format => '',
        read_only => 'false',
            },
    'otfp_manifests' => {
        datatype => 'int',
        base_name => 'otfp_manifests',
        description => 'Number of responses that were manifest files from the Fastly On-the-Fly Packaging service for video-on-demand.',
        format => '',
        read_only => 'false',
            },
    'otfp_deliver_time' => {
        datatype => 'double',
        base_name => 'otfp_deliver_time',
        description => 'Total amount of time spent delivering a response from the Fastly On-the-Fly Packaging service for video-on-demand (in seconds).',
        format => '',
        read_only => 'false',
            },
    'otfp_shield_time' => {
        datatype => 'double',
        base_name => 'otfp_shield_time',
        description => 'Total amount of time spent delivering a response via a shield from the Fastly On-the-Fly Packaging service for video-on-demand (in seconds).',
        format => '',
        read_only => 'false',
            },
    'video' => {
        datatype => 'int',
        base_name => 'video',
        description => 'Number of responses with the video segment or video manifest MIME type (i.e., application/x-mpegurl, application/vnd.apple.mpegurl, application/f4m, application/dash+xml, application/vnd.ms-sstr+xml, ideo/mp2t, audio/aac, video/f4f, video/x-flv, video/mp4, audio/mp4).',
        format => '',
        read_only => 'false',
            },
    'pci' => {
        datatype => 'int',
        base_name => 'pci',
        description => 'Number of responses with the PCI flag turned on.',
        format => '',
        read_only => 'false',
            },
    'log' => {
        datatype => 'int',
        base_name => 'log',
        description => 'Number of log lines sent.',
        format => '',
        read_only => 'false',
            },
    'log_bytes' => {
        datatype => 'int',
        base_name => 'log_bytes',
        description => 'Total log bytes sent.',
        format => '',
        read_only => 'false',
            },
    'http2' => {
        datatype => 'int',
        base_name => 'http2',
        description => 'Number of requests received over HTTP/2.',
        format => '',
        read_only => 'false',
            },
    'http3' => {
        datatype => 'int',
        base_name => 'http3',
        description => 'Number of requests received over HTTP/3.',
        format => '',
        read_only => 'false',
            },
    'waf_logged' => {
        datatype => 'int',
        base_name => 'waf_logged',
        description => 'Number of requests that triggered a WAF rule and were logged.',
        format => '',
        read_only => 'false',
            },
    'waf_blocked' => {
        datatype => 'int',
        base_name => 'waf_blocked',
        description => 'Number of requests that triggered a WAF rule and were blocked.',
        format => '',
        read_only => 'false',
            },
    'waf_passed' => {
        datatype => 'int',
        base_name => 'waf_passed',
        description => 'Number of requests that triggered a WAF rule and were passed.',
        format => '',
        read_only => 'false',
            },
    'attack_req_body_bytes' => {
        datatype => 'int',
        base_name => 'attack_req_body_bytes',
        description => 'Total body bytes received from requests that triggered a WAF rule.',
        format => '',
        read_only => 'false',
            },
    'attack_req_header_bytes' => {
        datatype => 'int',
        base_name => 'attack_req_header_bytes',
        description => 'Total header bytes received from requests that triggered a WAF rule.',
        format => '',
        read_only => 'false',
            },
    'attack_logged_req_body_bytes' => {
        datatype => 'int',
        base_name => 'attack_logged_req_body_bytes',
        description => 'Total body bytes received from requests that triggered a WAF rule that was logged.',
        format => '',
        read_only => 'false',
            },
    'attack_logged_req_header_bytes' => {
        datatype => 'int',
        base_name => 'attack_logged_req_header_bytes',
        description => 'Total header bytes received from requests that triggered a WAF rule that was logged.',
        format => '',
        read_only => 'false',
            },
    'attack_blocked_req_body_bytes' => {
        datatype => 'int',
        base_name => 'attack_blocked_req_body_bytes',
        description => 'Total body bytes received from requests that triggered a WAF rule that was blocked.',
        format => '',
        read_only => 'false',
            },
    'attack_blocked_req_header_bytes' => {
        datatype => 'int',
        base_name => 'attack_blocked_req_header_bytes',
        description => 'Total header bytes received from requests that triggered a WAF rule that was blocked.',
        format => '',
        read_only => 'false',
            },
    'attack_passed_req_body_bytes' => {
        datatype => 'int',
        base_name => 'attack_passed_req_body_bytes',
        description => 'Total body bytes received from requests that triggered a WAF rule that was passed.',
        format => '',
        read_only => 'false',
            },
    'attack_passed_req_header_bytes' => {
        datatype => 'int',
        base_name => 'attack_passed_req_header_bytes',
        description => 'Total header bytes received from requests that triggered a WAF rule that was passed.',
        format => '',
        read_only => 'false',
            },
    'attack_resp_synth_bytes' => {
        datatype => 'int',
        base_name => 'attack_resp_synth_bytes',
        description => 'Total bytes delivered for requests that triggered a WAF rule and returned a synthetic response.',
        format => '',
        read_only => 'false',
            },
    'imgopto' => {
        datatype => 'int',
        base_name => 'imgopto',
        description => 'Number of responses that came from the Fastly Image Optimizer service. If the service receives 10 requests for an image, this stat will be 10 regardless of how many times the image was transformed.',
        format => '',
        read_only => 'false',
            },
    'imgopto_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'imgopto_resp_body_bytes',
        description => 'Total body bytes delivered from the Fastly Image Optimizer service, including shield traffic.',
        format => '',
        read_only => 'false',
            },
    'imgopto_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'imgopto_resp_header_bytes',
        description => 'Total header bytes delivered from the Fastly Image Optimizer service, including shield traffic.',
        format => '',
        read_only => 'false',
            },
    'imgopto_shield_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'imgopto_shield_resp_body_bytes',
        description => 'Total body bytes delivered via a shield from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgopto_shield_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'imgopto_shield_resp_header_bytes',
        description => 'Total header bytes delivered via a shield from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo' => {
        datatype => 'int',
        base_name => 'imgvideo',
        description => 'Number of video responses that came from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_frames' => {
        datatype => 'int',
        base_name => 'imgvideo_frames',
        description => 'Number of video frames that came from the Fastly Image Optimizer service. A video frame is an individual image within a sequence of video.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'imgvideo_resp_header_bytes',
        description => 'Total header bytes of video delivered from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'imgvideo_resp_body_bytes',
        description => 'Total body bytes of video delivered from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_shield_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'imgvideo_shield_resp_header_bytes',
        description => 'Total header bytes of video delivered via a shield from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_shield_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'imgvideo_shield_resp_body_bytes',
        description => 'Total body bytes of video delivered via a shield from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_shield' => {
        datatype => 'int',
        base_name => 'imgvideo_shield',
        description => 'Number of video responses delivered via a shield that came from the Fastly Image Optimizer service.',
        format => '',
        read_only => 'false',
            },
    'imgvideo_shield_frames' => {
        datatype => 'int',
        base_name => 'imgvideo_shield_frames',
        description => 'Number of video frames delivered via a shield that came from the Fastly Image Optimizer service. A video frame is an individual image within a sequence of video.',
        format => '',
        read_only => 'false',
            },
    'status_200' => {
        datatype => 'int',
        base_name => 'status_200',
        description => 'Number of responses sent with status code 200 (Success).',
        format => '',
        read_only => 'false',
            },
    'status_204' => {
        datatype => 'int',
        base_name => 'status_204',
        description => 'Number of responses sent with status code 204 (No Content).',
        format => '',
        read_only => 'false',
            },
    'status_206' => {
        datatype => 'int',
        base_name => 'status_206',
        description => 'Number of responses sent with status code 206 (Partial Content).',
        format => '',
        read_only => 'false',
            },
    'status_301' => {
        datatype => 'int',
        base_name => 'status_301',
        description => 'Number of responses sent with status code 301 (Moved Permanently).',
        format => '',
        read_only => 'false',
            },
    'status_302' => {
        datatype => 'int',
        base_name => 'status_302',
        description => 'Number of responses sent with status code 302 (Found).',
        format => '',
        read_only => 'false',
            },
    'status_304' => {
        datatype => 'int',
        base_name => 'status_304',
        description => 'Number of responses sent with status code 304 (Not Modified).',
        format => '',
        read_only => 'false',
            },
    'status_400' => {
        datatype => 'int',
        base_name => 'status_400',
        description => 'Number of responses sent with status code 400 (Bad Request).',
        format => '',
        read_only => 'false',
            },
    'status_401' => {
        datatype => 'int',
        base_name => 'status_401',
        description => 'Number of responses sent with status code 401 (Unauthorized).',
        format => '',
        read_only => 'false',
            },
    'status_403' => {
        datatype => 'int',
        base_name => 'status_403',
        description => 'Number of responses sent with status code 403 (Forbidden).',
        format => '',
        read_only => 'false',
            },
    'status_404' => {
        datatype => 'int',
        base_name => 'status_404',
        description => 'Number of responses sent with status code 404 (Not Found).',
        format => '',
        read_only => 'false',
            },
    'status_406' => {
        datatype => 'int',
        base_name => 'status_406',
        description => 'Number of responses sent with status code 406 (Not Acceptable).',
        format => '',
        read_only => 'false',
            },
    'status_416' => {
        datatype => 'int',
        base_name => 'status_416',
        description => 'Number of responses sent with status code 416 (Range Not Satisfiable).',
        format => '',
        read_only => 'false',
            },
    'status_429' => {
        datatype => 'int',
        base_name => 'status_429',
        description => 'Number of responses sent with status code 429 (Too Many Requests).',
        format => '',
        read_only => 'false',
            },
    'status_500' => {
        datatype => 'int',
        base_name => 'status_500',
        description => 'Number of responses sent with status code 500 (Internal Server Error).',
        format => '',
        read_only => 'false',
            },
    'status_501' => {
        datatype => 'int',
        base_name => 'status_501',
        description => 'Number of responses sent with status code 501 (Not Implemented).',
        format => '',
        read_only => 'false',
            },
    'status_502' => {
        datatype => 'int',
        base_name => 'status_502',
        description => 'Number of responses sent with status code 502 (Bad Gateway).',
        format => '',
        read_only => 'false',
            },
    'status_503' => {
        datatype => 'int',
        base_name => 'status_503',
        description => 'Number of responses sent with status code 503 (Service Unavailable).',
        format => '',
        read_only => 'false',
            },
    'status_504' => {
        datatype => 'int',
        base_name => 'status_504',
        description => 'Number of responses sent with status code 504 (Gateway Timeout).',
        format => '',
        read_only => 'false',
            },
    'status_505' => {
        datatype => 'int',
        base_name => 'status_505',
        description => 'Number of responses sent with status code 505 (HTTP Version Not Supported).',
        format => '',
        read_only => 'false',
            },
    'status_1xx' => {
        datatype => 'int',
        base_name => 'status_1xx',
        description => 'Number of \&quot;Informational\&quot; category status codes delivered.',
        format => '',
        read_only => 'false',
            },
    'status_2xx' => {
        datatype => 'int',
        base_name => 'status_2xx',
        description => 'Number of \&quot;Success\&quot; status codes delivered.',
        format => '',
        read_only => 'false',
            },
    'status_3xx' => {
        datatype => 'int',
        base_name => 'status_3xx',
        description => 'Number of \&quot;Redirection\&quot; codes delivered.',
        format => '',
        read_only => 'false',
            },
    'status_4xx' => {
        datatype => 'int',
        base_name => 'status_4xx',
        description => 'Number of \&quot;Client Error\&quot; codes delivered.',
        format => '',
        read_only => 'false',
            },
    'status_5xx' => {
        datatype => 'int',
        base_name => 'status_5xx',
        description => 'Number of \&quot;Server Error\&quot; codes delivered.',
        format => '',
        read_only => 'false',
            },
    'object_size_1k' => {
        datatype => 'int',
        base_name => 'object_size_1k',
        description => 'Number of objects served that were under 1KB in size.',
        format => '',
        read_only => 'false',
            },
    'object_size_10k' => {
        datatype => 'int',
        base_name => 'object_size_10k',
        description => 'Number of objects served that were between 1KB and 10KB in size.',
        format => '',
        read_only => 'false',
            },
    'object_size_100k' => {
        datatype => 'int',
        base_name => 'object_size_100k',
        description => 'Number of objects served that were between 10KB and 100KB in size.',
        format => '',
        read_only => 'false',
            },
    'object_size_1m' => {
        datatype => 'int',
        base_name => 'object_size_1m',
        description => 'Number of objects served that were between 100KB and 1MB in size.',
        format => '',
        read_only => 'false',
            },
    'object_size_10m' => {
        datatype => 'int',
        base_name => 'object_size_10m',
        description => 'Number of objects served that were between 1MB and 10MB in size.',
        format => '',
        read_only => 'false',
            },
    'object_size_100m' => {
        datatype => 'int',
        base_name => 'object_size_100m',
        description => 'Number of objects served that were between 10MB and 100MB in size.',
        format => '',
        read_only => 'false',
            },
    'object_size_1g' => {
        datatype => 'int',
        base_name => 'object_size_1g',
        description => 'Number of objects served that were between 100MB and 1GB in size.',
        format => '',
        read_only => 'false',
            },
    'recv_sub_time' => {
        datatype => 'double',
        base_name => 'recv_sub_time',
        description => 'Time spent inside the &#x60;vcl_recv&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'recv_sub_count' => {
        datatype => 'int',
        base_name => 'recv_sub_count',
        description => 'Number of executions of the &#x60;vcl_recv&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'hash_sub_time' => {
        datatype => 'double',
        base_name => 'hash_sub_time',
        description => 'Time spent inside the &#x60;vcl_hash&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'hash_sub_count' => {
        datatype => 'int',
        base_name => 'hash_sub_count',
        description => 'Number of executions of the &#x60;vcl_hash&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'miss_sub_time' => {
        datatype => 'double',
        base_name => 'miss_sub_time',
        description => 'Time spent inside the &#x60;vcl_miss&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'miss_sub_count' => {
        datatype => 'int',
        base_name => 'miss_sub_count',
        description => 'Number of executions of the &#x60;vcl_miss&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'fetch_sub_time' => {
        datatype => 'double',
        base_name => 'fetch_sub_time',
        description => 'Time spent inside the &#x60;vcl_fetch&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'fetch_sub_count' => {
        datatype => 'int',
        base_name => 'fetch_sub_count',
        description => 'Number of executions of the &#x60;vcl_fetch&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'pass_sub_time' => {
        datatype => 'double',
        base_name => 'pass_sub_time',
        description => 'Time spent inside the &#x60;vcl_pass&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'pass_sub_count' => {
        datatype => 'int',
        base_name => 'pass_sub_count',
        description => 'Number of executions of the &#x60;vcl_pass&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'pipe_sub_time' => {
        datatype => 'double',
        base_name => 'pipe_sub_time',
        description => 'Time spent inside the &#x60;vcl_pipe&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'pipe_sub_count' => {
        datatype => 'int',
        base_name => 'pipe_sub_count',
        description => 'Number of executions of the &#x60;vcl_pipe&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'deliver_sub_time' => {
        datatype => 'double',
        base_name => 'deliver_sub_time',
        description => 'Time spent inside the &#x60;vcl_deliver&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'deliver_sub_count' => {
        datatype => 'int',
        base_name => 'deliver_sub_count',
        description => 'Number of executions of the &#x60;vcl_deliver&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'error_sub_time' => {
        datatype => 'double',
        base_name => 'error_sub_time',
        description => 'Time spent inside the &#x60;vcl_error&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'error_sub_count' => {
        datatype => 'int',
        base_name => 'error_sub_count',
        description => 'Number of executions of the &#x60;vcl_error&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'hit_sub_time' => {
        datatype => 'double',
        base_name => 'hit_sub_time',
        description => 'Time spent inside the &#x60;vcl_hit&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'hit_sub_count' => {
        datatype => 'int',
        base_name => 'hit_sub_count',
        description => 'Number of executions of the &#x60;vcl_hit&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'prehash_sub_time' => {
        datatype => 'double',
        base_name => 'prehash_sub_time',
        description => 'Time spent inside the &#x60;vcl_prehash&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'prehash_sub_count' => {
        datatype => 'int',
        base_name => 'prehash_sub_count',
        description => 'Number of executions of the &#x60;vcl_prehash&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'predeliver_sub_time' => {
        datatype => 'double',
        base_name => 'predeliver_sub_time',
        description => 'Time spent inside the &#x60;vcl_predeliver&#x60; Varnish subroutine (in seconds).',
        format => '',
        read_only => 'false',
            },
    'predeliver_sub_count' => {
        datatype => 'int',
        base_name => 'predeliver_sub_count',
        description => 'Number of executions of the &#x60;vcl_predeliver&#x60; Varnish subroutine.',
        format => '',
        read_only => 'false',
            },
    'tls_handshake_sent_bytes' => {
        datatype => 'int',
        base_name => 'tls_handshake_sent_bytes',
        description => 'Number of bytes transferred during TLS handshake.',
        format => '',
        read_only => 'false',
            },
    'hit_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'hit_resp_body_bytes',
        description => 'Total body bytes delivered for cache hits.',
        format => '',
        read_only => 'false',
            },
    'miss_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'miss_resp_body_bytes',
        description => 'Total body bytes delivered for cache misses.',
        format => '',
        read_only => 'false',
            },
    'pass_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'pass_resp_body_bytes',
        description => 'Total body bytes delivered for cache passes.',
        format => '',
        read_only => 'false',
            },
    'segblock_origin_fetches' => {
        datatype => 'int',
        base_name => 'segblock_origin_fetches',
        description => 'Number of &#x60;Range&#x60; requests to origin for segments of resources when using segmented caching.',
        format => '',
        read_only => 'false',
            },
    'segblock_shield_fetches' => {
        datatype => 'int',
        base_name => 'segblock_shield_fetches',
        description => 'Number of &#x60;Range&#x60; requests to a shield for segments of resources when using segmented caching.',
        format => '',
        read_only => 'false',
            },
    'compute_requests' => {
        datatype => 'int',
        base_name => 'compute_requests',
        description => 'The total number of requests that were received for your service by Fastly.',
        format => '',
        read_only => 'false',
            },
    'compute_request_time_ms' => {
        datatype => 'double',
        base_name => 'compute_request_time_ms',
        description => 'The total, actual amount of time used to process your requests, including active CPU time (in milliseconds).',
        format => '',
        read_only => 'false',
            },
    'compute_ram_used' => {
        datatype => 'int',
        base_name => 'compute_ram_used',
        description => 'The amount of RAM used for your service by Fastly (in bytes).',
        format => '',
        read_only => 'false',
            },
    'compute_execution_time_ms' => {
        datatype => 'double',
        base_name => 'compute_execution_time_ms',
        description => 'The amount of active CPU time used to process your requests (in milliseconds).',
        format => '',
        read_only => 'false',
            },
    'compute_req_header_bytes' => {
        datatype => 'int',
        base_name => 'compute_req_header_bytes',
        description => 'Total header bytes received by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_req_body_bytes' => {
        datatype => 'int',
        base_name => 'compute_req_body_bytes',
        description => 'Total body bytes received by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'compute_resp_header_bytes',
        description => 'Total header bytes sent from Compute@Edge to end user.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'compute_resp_body_bytes',
        description => 'Total body bytes sent from Compute@Edge to end user.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_status_1xx' => {
        datatype => 'int',
        base_name => 'compute_resp_status_1xx',
        description => 'Number of \&quot;Informational\&quot; category status codes delivered by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_status_2xx' => {
        datatype => 'int',
        base_name => 'compute_resp_status_2xx',
        description => 'Number of \&quot;Success\&quot; category status codes delivered by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_status_3xx' => {
        datatype => 'int',
        base_name => 'compute_resp_status_3xx',
        description => 'Number of \&quot;Redirection\&quot; category status codes delivered by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_status_4xx' => {
        datatype => 'int',
        base_name => 'compute_resp_status_4xx',
        description => 'Number of \&quot;Client Error\&quot; category status codes delivered by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_resp_status_5xx' => {
        datatype => 'int',
        base_name => 'compute_resp_status_5xx',
        description => 'Number of \&quot;Server Error\&quot; category status codes delivered by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_bereq_header_bytes' => {
        datatype => 'int',
        base_name => 'compute_bereq_header_bytes',
        description => 'Total header bytes sent to backends (origins) by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_bereq_body_bytes' => {
        datatype => 'int',
        base_name => 'compute_bereq_body_bytes',
        description => 'Total body bytes sent to backends (origins) by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_beresp_header_bytes' => {
        datatype => 'int',
        base_name => 'compute_beresp_header_bytes',
        description => 'Total header bytes received from backends (origins) by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_beresp_body_bytes' => {
        datatype => 'int',
        base_name => 'compute_beresp_body_bytes',
        description => 'Total body bytes received from backends (origins) by Compute@Edge.',
        format => '',
        read_only => 'false',
            },
    'compute_bereqs' => {
        datatype => 'int',
        base_name => 'compute_bereqs',
        description => 'Number of backend requests started.',
        format => '',
        read_only => 'false',
            },
    'compute_bereq_errors' => {
        datatype => 'int',
        base_name => 'compute_bereq_errors',
        description => 'Number of backend request errors, including timeouts.',
        format => '',
        read_only => 'false',
            },
    'compute_resource_limit_exceeded' => {
        datatype => 'int',
        base_name => 'compute_resource_limit_exceeded',
        description => 'Number of times a guest exceeded its resource limit, includes heap, stack, globals, and code execution timeout.',
        format => '',
        read_only => 'false',
            },
    'compute_heap_limit_exceeded' => {
        datatype => 'int',
        base_name => 'compute_heap_limit_exceeded',
        description => 'Number of times a guest exceeded its heap limit.',
        format => '',
        read_only => 'false',
            },
    'compute_stack_limit_exceeded' => {
        datatype => 'int',
        base_name => 'compute_stack_limit_exceeded',
        description => 'Number of times a guest exceeded its stack limit.',
        format => '',
        read_only => 'false',
            },
    'compute_globals_limit_exceeded' => {
        datatype => 'int',
        base_name => 'compute_globals_limit_exceeded',
        description => 'Number of times a guest exceeded its globals limit.',
        format => '',
        read_only => 'false',
            },
    'compute_guest_errors' => {
        datatype => 'int',
        base_name => 'compute_guest_errors',
        description => 'Number of times a service experienced a guest code error.',
        format => '',
        read_only => 'false',
            },
    'compute_runtime_errors' => {
        datatype => 'int',
        base_name => 'compute_runtime_errors',
        description => 'Number of times a service experienced a guest runtime error.',
        format => '',
        read_only => 'false',
            },
    'edge_hit_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'edge_hit_resp_body_bytes',
        description => 'Body bytes delivered for edge hits.',
        format => '',
        read_only => 'false',
            },
    'edge_hit_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'edge_hit_resp_header_bytes',
        description => 'Header bytes delivered for edge hits.',
        format => '',
        read_only => 'false',
            },
    'edge_miss_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'edge_miss_resp_body_bytes',
        description => 'Body bytes delivered for edge misses.',
        format => '',
        read_only => 'false',
            },
    'edge_miss_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'edge_miss_resp_header_bytes',
        description => 'Header bytes delivered for edge misses.',
        format => '',
        read_only => 'false',
            },
    'origin_cache_fetch_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'origin_cache_fetch_resp_body_bytes',
        description => 'Body bytes received from origin for cacheable content.',
        format => '',
        read_only => 'false',
            },
    'origin_cache_fetch_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'origin_cache_fetch_resp_header_bytes',
        description => 'Header bytes received from an origin for cacheable content.',
        format => '',
        read_only => 'false',
            },
    'shield_hit_requests' => {
        datatype => 'int',
        base_name => 'shield_hit_requests',
        description => 'Number of requests that resulted in a hit at a shield.',
        format => '',
        read_only => 'false',
            },
    'shield_miss_requests' => {
        datatype => 'int',
        base_name => 'shield_miss_requests',
        description => 'Number of requests that resulted in a miss at a shield.',
        format => '',
        read_only => 'false',
            },
    'shield_hit_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'shield_hit_resp_header_bytes',
        description => 'Header bytes delivered for shield hits.',
        format => '',
        read_only => 'false',
            },
    'shield_hit_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'shield_hit_resp_body_bytes',
        description => 'Body bytes delivered for shield hits.',
        format => '',
        read_only => 'false',
            },
    'shield_miss_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'shield_miss_resp_header_bytes',
        description => 'Header bytes delivered for shield misses.',
        format => '',
        read_only => 'false',
            },
    'shield_miss_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'shield_miss_resp_body_bytes',
        description => 'Body bytes delivered for shield misses.',
        format => '',
        read_only => 'false',
            },
    'websocket_req_header_bytes' => {
        datatype => 'int',
        base_name => 'websocket_req_header_bytes',
        description => 'Total header bytes received from end users over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_req_body_bytes' => {
        datatype => 'int',
        base_name => 'websocket_req_body_bytes',
        description => 'Total message content bytes received from end users over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'websocket_resp_header_bytes',
        description => 'Total header bytes sent to end users over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'websocket_resp_body_bytes',
        description => 'Total message content bytes sent to end users over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_bereq_header_bytes' => {
        datatype => 'int',
        base_name => 'websocket_bereq_header_bytes',
        description => 'Total header bytes sent to backends over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_bereq_body_bytes' => {
        datatype => 'int',
        base_name => 'websocket_bereq_body_bytes',
        description => 'Total message content bytes sent to backends over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_beresp_header_bytes' => {
        datatype => 'int',
        base_name => 'websocket_beresp_header_bytes',
        description => 'Total header bytes received from backends over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_beresp_body_bytes' => {
        datatype => 'int',
        base_name => 'websocket_beresp_body_bytes',
        description => 'Total message content bytes received from backends over passthrough WebSocket connections.',
        format => '',
        read_only => 'false',
            },
    'websocket_conn_time_ms' => {
        datatype => 'int',
        base_name => 'websocket_conn_time_ms',
        description => 'Total duration of passthrough WebSocket connections with end users.',
        format => '',
        read_only => 'false',
            },
    'fanout_recv_publishes' => {
        datatype => 'int',
        base_name => 'fanout_recv_publishes',
        description => 'Total published messages received from the publish API endpoint.',
        format => '',
        read_only => 'false',
            },
    'fanout_send_publishes' => {
        datatype => 'int',
        base_name => 'fanout_send_publishes',
        description => 'Total published messages sent to end users.',
        format => '',
        read_only => 'false',
            },
    'object_store_class_a_operations' => {
        datatype => 'int',
        base_name => 'object_store_class_a_operations',
        description => 'The total number of class a operations for the object store.',
        format => '',
        read_only => 'false',
            },
    'object_store_class_b_operations' => {
        datatype => 'int',
        base_name => 'object_store_class_b_operations',
        description => 'The total number of class b operations for the object store.',
        format => '',
        read_only => 'false',
            },
    'object_store_read_requests' => {
        datatype => 'int',
        base_name => 'object_store_read_requests',
        description => 'Use object_store_class_b_operations.',
        format => '',
        read_only => 'false',
            },
    'object_store_write_requests' => {
        datatype => 'int',
        base_name => 'object_store_write_requests',
        description => 'Use object_store_class_a_operations.',
        format => '',
        read_only => 'false',
            },
    'fanout_req_header_bytes' => {
        datatype => 'int',
        base_name => 'fanout_req_header_bytes',
        description => 'Total header bytes received from end users over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_req_body_bytes' => {
        datatype => 'int',
        base_name => 'fanout_req_body_bytes',
        description => 'Total body or message content bytes received from end users over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_resp_header_bytes' => {
        datatype => 'int',
        base_name => 'fanout_resp_header_bytes',
        description => 'Total header bytes sent to end users over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_resp_body_bytes' => {
        datatype => 'int',
        base_name => 'fanout_resp_body_bytes',
        description => 'Total body or message content bytes sent to end users over Fanout connections, excluding published message content.',
        format => '',
        read_only => 'false',
            },
    'fanout_bereq_header_bytes' => {
        datatype => 'int',
        base_name => 'fanout_bereq_header_bytes',
        description => 'Total header bytes sent to backends over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_bereq_body_bytes' => {
        datatype => 'int',
        base_name => 'fanout_bereq_body_bytes',
        description => 'Total body or message content bytes sent to backends over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_beresp_header_bytes' => {
        datatype => 'int',
        base_name => 'fanout_beresp_header_bytes',
        description => 'Total header bytes received from backends over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_beresp_body_bytes' => {
        datatype => 'int',
        base_name => 'fanout_beresp_body_bytes',
        description => 'Total body or message content bytes received from backends over Fanout connections.',
        format => '',
        read_only => 'false',
            },
    'fanout_conn_time_ms' => {
        datatype => 'int',
        base_name => 'fanout_conn_time_ms',
        description => 'Total duration of Fanout connections with end users.',
        format => '',
        read_only => 'false',
            },
});

__PACKAGE__->openapi_types( {
    'requests' => 'int',
    'hits' => 'int',
    'hits_time' => 'double',
    'miss' => 'int',
    'miss_time' => 'double',
    'pass' => 'int',
    'pass_time' => 'double',
    'errors' => 'int',
    'restarts' => 'int',
    'hit_ratio' => 'double',
    'bandwidth' => 'int',
    'body_size' => 'int',
    'header_size' => 'int',
    'req_body_bytes' => 'int',
    'req_header_bytes' => 'int',
    'resp_body_bytes' => 'int',
    'resp_header_bytes' => 'int',
    'bereq_body_bytes' => 'int',
    'bereq_header_bytes' => 'int',
    'uncacheable' => 'int',
    'pipe' => 'int',
    'synth' => 'int',
    'tls' => 'int',
    'tls_v10' => 'int',
    'tls_v11' => 'int',
    'tls_v12' => 'int',
    'tls_v13' => 'int',
    'edge_requests' => 'int',
    'edge_resp_header_bytes' => 'int',
    'edge_resp_body_bytes' => 'int',
    'edge_hit_requests' => 'int',
    'edge_miss_requests' => 'int',
    'origin_fetches' => 'int',
    'origin_fetch_header_bytes' => 'int',
    'origin_fetch_body_bytes' => 'int',
    'origin_fetch_resp_header_bytes' => 'int',
    'origin_fetch_resp_body_bytes' => 'int',
    'origin_revalidations' => 'int',
    'origin_cache_fetches' => 'int',
    'shield' => 'int',
    'shield_resp_body_bytes' => 'int',
    'shield_resp_header_bytes' => 'int',
    'shield_fetches' => 'int',
    'shield_fetch_header_bytes' => 'int',
    'shield_fetch_body_bytes' => 'int',
    'shield_fetch_resp_header_bytes' => 'int',
    'shield_fetch_resp_body_bytes' => 'int',
    'shield_revalidations' => 'int',
    'shield_cache_fetches' => 'int',
    'ipv6' => 'int',
    'otfp' => 'int',
    'otfp_resp_body_bytes' => 'int',
    'otfp_resp_header_bytes' => 'int',
    'otfp_shield_resp_body_bytes' => 'int',
    'otfp_shield_resp_header_bytes' => 'int',
    'otfp_manifests' => 'int',
    'otfp_deliver_time' => 'double',
    'otfp_shield_time' => 'double',
    'video' => 'int',
    'pci' => 'int',
    'log' => 'int',
    'log_bytes' => 'int',
    'http2' => 'int',
    'http3' => 'int',
    'waf_logged' => 'int',
    'waf_blocked' => 'int',
    'waf_passed' => 'int',
    'attack_req_body_bytes' => 'int',
    'attack_req_header_bytes' => 'int',
    'attack_logged_req_body_bytes' => 'int',
    'attack_logged_req_header_bytes' => 'int',
    'attack_blocked_req_body_bytes' => 'int',
    'attack_blocked_req_header_bytes' => 'int',
    'attack_passed_req_body_bytes' => 'int',
    'attack_passed_req_header_bytes' => 'int',
    'attack_resp_synth_bytes' => 'int',
    'imgopto' => 'int',
    'imgopto_resp_body_bytes' => 'int',
    'imgopto_resp_header_bytes' => 'int',
    'imgopto_shield_resp_body_bytes' => 'int',
    'imgopto_shield_resp_header_bytes' => 'int',
    'imgvideo' => 'int',
    'imgvideo_frames' => 'int',
    'imgvideo_resp_header_bytes' => 'int',
    'imgvideo_resp_body_bytes' => 'int',
    'imgvideo_shield_resp_header_bytes' => 'int',
    'imgvideo_shield_resp_body_bytes' => 'int',
    'imgvideo_shield' => 'int',
    'imgvideo_shield_frames' => 'int',
    'status_200' => 'int',
    'status_204' => 'int',
    'status_206' => 'int',
    'status_301' => 'int',
    'status_302' => 'int',
    'status_304' => 'int',
    'status_400' => 'int',
    'status_401' => 'int',
    'status_403' => 'int',
    'status_404' => 'int',
    'status_406' => 'int',
    'status_416' => 'int',
    'status_429' => 'int',
    'status_500' => 'int',
    'status_501' => 'int',
    'status_502' => 'int',
    'status_503' => 'int',
    'status_504' => 'int',
    'status_505' => 'int',
    'status_1xx' => 'int',
    'status_2xx' => 'int',
    'status_3xx' => 'int',
    'status_4xx' => 'int',
    'status_5xx' => 'int',
    'object_size_1k' => 'int',
    'object_size_10k' => 'int',
    'object_size_100k' => 'int',
    'object_size_1m' => 'int',
    'object_size_10m' => 'int',
    'object_size_100m' => 'int',
    'object_size_1g' => 'int',
    'recv_sub_time' => 'double',
    'recv_sub_count' => 'int',
    'hash_sub_time' => 'double',
    'hash_sub_count' => 'int',
    'miss_sub_time' => 'double',
    'miss_sub_count' => 'int',
    'fetch_sub_time' => 'double',
    'fetch_sub_count' => 'int',
    'pass_sub_time' => 'double',
    'pass_sub_count' => 'int',
    'pipe_sub_time' => 'double',
    'pipe_sub_count' => 'int',
    'deliver_sub_time' => 'double',
    'deliver_sub_count' => 'int',
    'error_sub_time' => 'double',
    'error_sub_count' => 'int',
    'hit_sub_time' => 'double',
    'hit_sub_count' => 'int',
    'prehash_sub_time' => 'double',
    'prehash_sub_count' => 'int',
    'predeliver_sub_time' => 'double',
    'predeliver_sub_count' => 'int',
    'tls_handshake_sent_bytes' => 'int',
    'hit_resp_body_bytes' => 'int',
    'miss_resp_body_bytes' => 'int',
    'pass_resp_body_bytes' => 'int',
    'segblock_origin_fetches' => 'int',
    'segblock_shield_fetches' => 'int',
    'compute_requests' => 'int',
    'compute_request_time_ms' => 'double',
    'compute_ram_used' => 'int',
    'compute_execution_time_ms' => 'double',
    'compute_req_header_bytes' => 'int',
    'compute_req_body_bytes' => 'int',
    'compute_resp_header_bytes' => 'int',
    'compute_resp_body_bytes' => 'int',
    'compute_resp_status_1xx' => 'int',
    'compute_resp_status_2xx' => 'int',
    'compute_resp_status_3xx' => 'int',
    'compute_resp_status_4xx' => 'int',
    'compute_resp_status_5xx' => 'int',
    'compute_bereq_header_bytes' => 'int',
    'compute_bereq_body_bytes' => 'int',
    'compute_beresp_header_bytes' => 'int',
    'compute_beresp_body_bytes' => 'int',
    'compute_bereqs' => 'int',
    'compute_bereq_errors' => 'int',
    'compute_resource_limit_exceeded' => 'int',
    'compute_heap_limit_exceeded' => 'int',
    'compute_stack_limit_exceeded' => 'int',
    'compute_globals_limit_exceeded' => 'int',
    'compute_guest_errors' => 'int',
    'compute_runtime_errors' => 'int',
    'edge_hit_resp_body_bytes' => 'int',
    'edge_hit_resp_header_bytes' => 'int',
    'edge_miss_resp_body_bytes' => 'int',
    'edge_miss_resp_header_bytes' => 'int',
    'origin_cache_fetch_resp_body_bytes' => 'int',
    'origin_cache_fetch_resp_header_bytes' => 'int',
    'shield_hit_requests' => 'int',
    'shield_miss_requests' => 'int',
    'shield_hit_resp_header_bytes' => 'int',
    'shield_hit_resp_body_bytes' => 'int',
    'shield_miss_resp_header_bytes' => 'int',
    'shield_miss_resp_body_bytes' => 'int',
    'websocket_req_header_bytes' => 'int',
    'websocket_req_body_bytes' => 'int',
    'websocket_resp_header_bytes' => 'int',
    'websocket_resp_body_bytes' => 'int',
    'websocket_bereq_header_bytes' => 'int',
    'websocket_bereq_body_bytes' => 'int',
    'websocket_beresp_header_bytes' => 'int',
    'websocket_beresp_body_bytes' => 'int',
    'websocket_conn_time_ms' => 'int',
    'fanout_recv_publishes' => 'int',
    'fanout_send_publishes' => 'int',
    'object_store_class_a_operations' => 'int',
    'object_store_class_b_operations' => 'int',
    'object_store_read_requests' => 'int',
    'object_store_write_requests' => 'int',
    'fanout_req_header_bytes' => 'int',
    'fanout_req_body_bytes' => 'int',
    'fanout_resp_header_bytes' => 'int',
    'fanout_resp_body_bytes' => 'int',
    'fanout_bereq_header_bytes' => 'int',
    'fanout_bereq_body_bytes' => 'int',
    'fanout_beresp_header_bytes' => 'int',
    'fanout_beresp_body_bytes' => 'int',
    'fanout_conn_time_ms' => 'int'
} );

__PACKAGE__->attribute_map( {
    'requests' => 'requests',
    'hits' => 'hits',
    'hits_time' => 'hits_time',
    'miss' => 'miss',
    'miss_time' => 'miss_time',
    'pass' => 'pass',
    'pass_time' => 'pass_time',
    'errors' => 'errors',
    'restarts' => 'restarts',
    'hit_ratio' => 'hit_ratio',
    'bandwidth' => 'bandwidth',
    'body_size' => 'body_size',
    'header_size' => 'header_size',
    'req_body_bytes' => 'req_body_bytes',
    'req_header_bytes' => 'req_header_bytes',
    'resp_body_bytes' => 'resp_body_bytes',
    'resp_header_bytes' => 'resp_header_bytes',
    'bereq_body_bytes' => 'bereq_body_bytes',
    'bereq_header_bytes' => 'bereq_header_bytes',
    'uncacheable' => 'uncacheable',
    'pipe' => 'pipe',
    'synth' => 'synth',
    'tls' => 'tls',
    'tls_v10' => 'tls_v10',
    'tls_v11' => 'tls_v11',
    'tls_v12' => 'tls_v12',
    'tls_v13' => 'tls_v13',
    'edge_requests' => 'edge_requests',
    'edge_resp_header_bytes' => 'edge_resp_header_bytes',
    'edge_resp_body_bytes' => 'edge_resp_body_bytes',
    'edge_hit_requests' => 'edge_hit_requests',
    'edge_miss_requests' => 'edge_miss_requests',
    'origin_fetches' => 'origin_fetches',
    'origin_fetch_header_bytes' => 'origin_fetch_header_bytes',
    'origin_fetch_body_bytes' => 'origin_fetch_body_bytes',
    'origin_fetch_resp_header_bytes' => 'origin_fetch_resp_header_bytes',
    'origin_fetch_resp_body_bytes' => 'origin_fetch_resp_body_bytes',
    'origin_revalidations' => 'origin_revalidations',
    'origin_cache_fetches' => 'origin_cache_fetches',
    'shield' => 'shield',
    'shield_resp_body_bytes' => 'shield_resp_body_bytes',
    'shield_resp_header_bytes' => 'shield_resp_header_bytes',
    'shield_fetches' => 'shield_fetches',
    'shield_fetch_header_bytes' => 'shield_fetch_header_bytes',
    'shield_fetch_body_bytes' => 'shield_fetch_body_bytes',
    'shield_fetch_resp_header_bytes' => 'shield_fetch_resp_header_bytes',
    'shield_fetch_resp_body_bytes' => 'shield_fetch_resp_body_bytes',
    'shield_revalidations' => 'shield_revalidations',
    'shield_cache_fetches' => 'shield_cache_fetches',
    'ipv6' => 'ipv6',
    'otfp' => 'otfp',
    'otfp_resp_body_bytes' => 'otfp_resp_body_bytes',
    'otfp_resp_header_bytes' => 'otfp_resp_header_bytes',
    'otfp_shield_resp_body_bytes' => 'otfp_shield_resp_body_bytes',
    'otfp_shield_resp_header_bytes' => 'otfp_shield_resp_header_bytes',
    'otfp_manifests' => 'otfp_manifests',
    'otfp_deliver_time' => 'otfp_deliver_time',
    'otfp_shield_time' => 'otfp_shield_time',
    'video' => 'video',
    'pci' => 'pci',
    'log' => 'log',
    'log_bytes' => 'log_bytes',
    'http2' => 'http2',
    'http3' => 'http3',
    'waf_logged' => 'waf_logged',
    'waf_blocked' => 'waf_blocked',
    'waf_passed' => 'waf_passed',
    'attack_req_body_bytes' => 'attack_req_body_bytes',
    'attack_req_header_bytes' => 'attack_req_header_bytes',
    'attack_logged_req_body_bytes' => 'attack_logged_req_body_bytes',
    'attack_logged_req_header_bytes' => 'attack_logged_req_header_bytes',
    'attack_blocked_req_body_bytes' => 'attack_blocked_req_body_bytes',
    'attack_blocked_req_header_bytes' => 'attack_blocked_req_header_bytes',
    'attack_passed_req_body_bytes' => 'attack_passed_req_body_bytes',
    'attack_passed_req_header_bytes' => 'attack_passed_req_header_bytes',
    'attack_resp_synth_bytes' => 'attack_resp_synth_bytes',
    'imgopto' => 'imgopto',
    'imgopto_resp_body_bytes' => 'imgopto_resp_body_bytes',
    'imgopto_resp_header_bytes' => 'imgopto_resp_header_bytes',
    'imgopto_shield_resp_body_bytes' => 'imgopto_shield_resp_body_bytes',
    'imgopto_shield_resp_header_bytes' => 'imgopto_shield_resp_header_bytes',
    'imgvideo' => 'imgvideo',
    'imgvideo_frames' => 'imgvideo_frames',
    'imgvideo_resp_header_bytes' => 'imgvideo_resp_header_bytes',
    'imgvideo_resp_body_bytes' => 'imgvideo_resp_body_bytes',
    'imgvideo_shield_resp_header_bytes' => 'imgvideo_shield_resp_header_bytes',
    'imgvideo_shield_resp_body_bytes' => 'imgvideo_shield_resp_body_bytes',
    'imgvideo_shield' => 'imgvideo_shield',
    'imgvideo_shield_frames' => 'imgvideo_shield_frames',
    'status_200' => 'status_200',
    'status_204' => 'status_204',
    'status_206' => 'status_206',
    'status_301' => 'status_301',
    'status_302' => 'status_302',
    'status_304' => 'status_304',
    'status_400' => 'status_400',
    'status_401' => 'status_401',
    'status_403' => 'status_403',
    'status_404' => 'status_404',
    'status_406' => 'status_406',
    'status_416' => 'status_416',
    'status_429' => 'status_429',
    'status_500' => 'status_500',
    'status_501' => 'status_501',
    'status_502' => 'status_502',
    'status_503' => 'status_503',
    'status_504' => 'status_504',
    'status_505' => 'status_505',
    'status_1xx' => 'status_1xx',
    'status_2xx' => 'status_2xx',
    'status_3xx' => 'status_3xx',
    'status_4xx' => 'status_4xx',
    'status_5xx' => 'status_5xx',
    'object_size_1k' => 'object_size_1k',
    'object_size_10k' => 'object_size_10k',
    'object_size_100k' => 'object_size_100k',
    'object_size_1m' => 'object_size_1m',
    'object_size_10m' => 'object_size_10m',
    'object_size_100m' => 'object_size_100m',
    'object_size_1g' => 'object_size_1g',
    'recv_sub_time' => 'recv_sub_time',
    'recv_sub_count' => 'recv_sub_count',
    'hash_sub_time' => 'hash_sub_time',
    'hash_sub_count' => 'hash_sub_count',
    'miss_sub_time' => 'miss_sub_time',
    'miss_sub_count' => 'miss_sub_count',
    'fetch_sub_time' => 'fetch_sub_time',
    'fetch_sub_count' => 'fetch_sub_count',
    'pass_sub_time' => 'pass_sub_time',
    'pass_sub_count' => 'pass_sub_count',
    'pipe_sub_time' => 'pipe_sub_time',
    'pipe_sub_count' => 'pipe_sub_count',
    'deliver_sub_time' => 'deliver_sub_time',
    'deliver_sub_count' => 'deliver_sub_count',
    'error_sub_time' => 'error_sub_time',
    'error_sub_count' => 'error_sub_count',
    'hit_sub_time' => 'hit_sub_time',
    'hit_sub_count' => 'hit_sub_count',
    'prehash_sub_time' => 'prehash_sub_time',
    'prehash_sub_count' => 'prehash_sub_count',
    'predeliver_sub_time' => 'predeliver_sub_time',
    'predeliver_sub_count' => 'predeliver_sub_count',
    'tls_handshake_sent_bytes' => 'tls_handshake_sent_bytes',
    'hit_resp_body_bytes' => 'hit_resp_body_bytes',
    'miss_resp_body_bytes' => 'miss_resp_body_bytes',
    'pass_resp_body_bytes' => 'pass_resp_body_bytes',
    'segblock_origin_fetches' => 'segblock_origin_fetches',
    'segblock_shield_fetches' => 'segblock_shield_fetches',
    'compute_requests' => 'compute_requests',
    'compute_request_time_ms' => 'compute_request_time_ms',
    'compute_ram_used' => 'compute_ram_used',
    'compute_execution_time_ms' => 'compute_execution_time_ms',
    'compute_req_header_bytes' => 'compute_req_header_bytes',
    'compute_req_body_bytes' => 'compute_req_body_bytes',
    'compute_resp_header_bytes' => 'compute_resp_header_bytes',
    'compute_resp_body_bytes' => 'compute_resp_body_bytes',
    'compute_resp_status_1xx' => 'compute_resp_status_1xx',
    'compute_resp_status_2xx' => 'compute_resp_status_2xx',
    'compute_resp_status_3xx' => 'compute_resp_status_3xx',
    'compute_resp_status_4xx' => 'compute_resp_status_4xx',
    'compute_resp_status_5xx' => 'compute_resp_status_5xx',
    'compute_bereq_header_bytes' => 'compute_bereq_header_bytes',
    'compute_bereq_body_bytes' => 'compute_bereq_body_bytes',
    'compute_beresp_header_bytes' => 'compute_beresp_header_bytes',
    'compute_beresp_body_bytes' => 'compute_beresp_body_bytes',
    'compute_bereqs' => 'compute_bereqs',
    'compute_bereq_errors' => 'compute_bereq_errors',
    'compute_resource_limit_exceeded' => 'compute_resource_limit_exceeded',
    'compute_heap_limit_exceeded' => 'compute_heap_limit_exceeded',
    'compute_stack_limit_exceeded' => 'compute_stack_limit_exceeded',
    'compute_globals_limit_exceeded' => 'compute_globals_limit_exceeded',
    'compute_guest_errors' => 'compute_guest_errors',
    'compute_runtime_errors' => 'compute_runtime_errors',
    'edge_hit_resp_body_bytes' => 'edge_hit_resp_body_bytes',
    'edge_hit_resp_header_bytes' => 'edge_hit_resp_header_bytes',
    'edge_miss_resp_body_bytes' => 'edge_miss_resp_body_bytes',
    'edge_miss_resp_header_bytes' => 'edge_miss_resp_header_bytes',
    'origin_cache_fetch_resp_body_bytes' => 'origin_cache_fetch_resp_body_bytes',
    'origin_cache_fetch_resp_header_bytes' => 'origin_cache_fetch_resp_header_bytes',
    'shield_hit_requests' => 'shield_hit_requests',
    'shield_miss_requests' => 'shield_miss_requests',
    'shield_hit_resp_header_bytes' => 'shield_hit_resp_header_bytes',
    'shield_hit_resp_body_bytes' => 'shield_hit_resp_body_bytes',
    'shield_miss_resp_header_bytes' => 'shield_miss_resp_header_bytes',
    'shield_miss_resp_body_bytes' => 'shield_miss_resp_body_bytes',
    'websocket_req_header_bytes' => 'websocket_req_header_bytes',
    'websocket_req_body_bytes' => 'websocket_req_body_bytes',
    'websocket_resp_header_bytes' => 'websocket_resp_header_bytes',
    'websocket_resp_body_bytes' => 'websocket_resp_body_bytes',
    'websocket_bereq_header_bytes' => 'websocket_bereq_header_bytes',
    'websocket_bereq_body_bytes' => 'websocket_bereq_body_bytes',
    'websocket_beresp_header_bytes' => 'websocket_beresp_header_bytes',
    'websocket_beresp_body_bytes' => 'websocket_beresp_body_bytes',
    'websocket_conn_time_ms' => 'websocket_conn_time_ms',
    'fanout_recv_publishes' => 'fanout_recv_publishes',
    'fanout_send_publishes' => 'fanout_send_publishes',
    'object_store_class_a_operations' => 'object_store_class_a_operations',
    'object_store_class_b_operations' => 'object_store_class_b_operations',
    'object_store_read_requests' => 'object_store_read_requests',
    'object_store_write_requests' => 'object_store_write_requests',
    'fanout_req_header_bytes' => 'fanout_req_header_bytes',
    'fanout_req_body_bytes' => 'fanout_req_body_bytes',
    'fanout_resp_header_bytes' => 'fanout_resp_header_bytes',
    'fanout_resp_body_bytes' => 'fanout_resp_body_bytes',
    'fanout_bereq_header_bytes' => 'fanout_bereq_header_bytes',
    'fanout_bereq_body_bytes' => 'fanout_bereq_body_bytes',
    'fanout_beresp_header_bytes' => 'fanout_beresp_header_bytes',
    'fanout_beresp_body_bytes' => 'fanout_beresp_body_bytes',
    'fanout_conn_time_ms' => 'fanout_conn_time_ms'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});

__PACKAGE__->openapi_nullable( {
    'hit_ratio' => 'true',
} );


1;
