#! perl

use v5.20;
use strict;
use experimental 'signatures';

use Term::Table;
use Ref::Util 'is_hashref', 'is_arrayref';
use CXC::Data::Visitor 'visit', 'RESULT_CONTINUE';
use DDP;

my %struct = (
    fruit => {
        berry  => 'purple',
        apples => [ 'fuji', 'macoun' ],
    } );

my @rows;
visit(
    \%struct,
    sub ( $, $vref, $, $metadata ) {
        my $path;
        my $ref = \%struct;
        for my $kydx ( $metadata->{path}->@* ) {
            if ( is_hashref( $ref ) ) {
                $path .= "{$kydx}";
                $ref = $ref->{$kydx};
            }
            elsif ( is_arrayref( $ref ) ) {
                $path .= "[$kydx]";
                $ref = $ref->[$kydx];
            }
        }
        push @rows, [ '$struct' . $path, $vref->$* ];
        return RESULT_CONTINUE;
    } );

my $table = Term::Table->new(
    header => [ 'Path', 'Value' ],
    rows   => \@rows,
);

say "  $_" for $table->render;
