/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module handles the splitting of Hangul syllables and multi-letter
 * Jamos into single Hangul letters (and back).
 * It also converts Romanised hangul to split Hangul (and back). */

/* Variables. ===============================================================*/

extern bool_t roman_hangul;
/* Indicates whether Hangul output is transcribed to latin letters. */

/* Functions. ===============================================================*/

extern void init_hangul( void );
/* Initialise hangul conversions. */

extern void terminate_hangul( void );
/* Free memory used by hangul conversions. */

extern void decode_hangul( char_t **string_p );
/* Decode *STRING_P to external format.
 * *STRING_P must be a string on the heap; 
 * it will be replaced by the new string which is also on the heap. */

extern void encode_hangul( char_t **string_p );
/* Encode *STRING_P to internal format.
 * *STRING_P must be a string on the heap; 
 * it will be replaced by the new string which is also on the heap. */

/* End of file. =============================================================*/
