// license:BSD-3-Clause
// copyright-holders:Ryan Holtz
//
// Netlist for Star Fire
//
// Derived from the schematics in the manual.
//
// Known problems/issues:
//
//    * Tracking computer might not be 100% right, compared to recordings.
//    * Slow.
//

#include "netlist/devices/net_lib.h"

//
// Main netlist
//

NETLIST_START(starfire)
	NET_MODEL("LM324_12V OPAMP(TYPE=3 VLH=1.6 VLL=0.16 FPF=5 UGF=500k SLEW=0.3M RI=1000k RO=50 DAB=0.00075)")
	NET_MODEL("LM324_5V OPAMP(TYPE=3 VLH=0.667 VLL=0.0667 FPF=5 UGF=500k SLEW=0.3M RI=1000k RO=50 DAB=0.00075)")

	SOLVER(Solver, 48000)
	ANALOG_INPUT(V1_2, 1.2)
	ANALOG_INPUT(V12, 12)
	ANALOG_INPUT(VM12, -12)
	ANALOG_INPUT(V5, 5)
	ANALOG_INPUT(VM5, -5)
	ALIAS(VCC, V5)

	TTL_INPUT(SIZE, 0)          // active high
	TTL_INPUT(SEXPLO, 0)        // active high
	TTL_INPUT(STIE, 0)          // active high
	TTL_INPUT(SLASER, 0)        // active high
	TTL_INPUT(TRACK, 0)         // active high
	TTL_INPUT(LOCK, 0)          // active high
	TTL_INPUT(SCANNER, 0)       // active high
	TTL_INPUT(OHEAT, 0)         // active high

	NET_C(VCC, SIZE.VCC, SEXPLO.VCC, STIE.VCC, SLASER.VCC, TRACK.VCC, LOCK.VCC, SCANNER.VCC, OHEAT.VCC)
	NET_C(GND, SIZE.GND, SEXPLO.GND, STIE.GND, SLASER.GND, TRACK.GND, LOCK.GND, SCANNER.GND, OHEAT.GND)

	RES(R12, RES_K(10))
	RES(R13, RES_K(470))
	RES(R14, RES_K(470))
	POT(R15, RES_K(100))
	POT(R16, RES_K(100))
	POT(R17, RES_K(100))
	POT(R18, RES_K(100))
	POT(R19, RES_K(33))
	POT(R20, RES_K(10))
	POT(R21, RES_K(10))
	RES(R23, RES_K(47))
	RES(R24, 470)
	RES(R25, RES_K(10))
	RES(R26, RES_K(1))
	RES(R27, RES_K(30))
	RES(R28, RES_K(30))
	RES(R29, RES_K(1))
	RES(R30, RES_K(4.7))
	RES(R31, RES_M(1))
	RES(R37, RES_K(10))
	RES(R38, RES_K(2.7))
	RES(R39, RES_K(10))
	RES(R40, RES_K(2.7))
	RES(R41, RES_K(3))
	RES(R42, RES_K(1))
	RES(R43, RES_M(1))
	RES(R44, RES_K(2.2))
	RES(R45, RES_K(3.3))
	RES(R46, RES_K(27))
	RES(R47, RES_K(82))
	RES(R48, RES_K(10))
	RES(R49, RES_K(100))
	RES(R50, RES_K(160))
	RES(R51, RES_K(16))
	RES(R52, RES_K(16))
	RES(R53, RES_K(16))
	RES(R54, RES_K(100))
	RES(R55, RES_K(100))
	RES(R56, RES_K(4.7))
	RES(R57, RES_K(10))
	RES(R58, RES_K(82))
	RES(R59, RES_K(27))
	RES(R60, RES_K(2.7))
	RES(R61, RES_K(10))
	RES(R62, RES_M(1))
	RES(R63, RES_M(1))
	RES(R64, RES_K(4.7))
	RES(R67, RES_K(10))
	RES(R68, RES_K(2.7))
	RES(R69, RES_K(470))
	RES(R70, RES_K(470))
	RES(R71, RES_K(100))
	RES(R72, RES_K(330))
	RES(R73, RES_K(4.7))
	RES(R74, RES_K(100))
	RES(R75, RES_K(27))
	RES(R77, RES_K(470))
	RES(R78, RES_K(4.7))
	RES(R79, RES_K(10))
	RES(R80, RES_K(3))
	RES(R81, RES_K(1))
	RES(R82, RES_K(10))
	RES(R83, RES_K(4.7))
	RES(R84, RES_K(1))
	RES(R85, RES_K(3))
	RES(R86, RES_K(1))
	RES(R87, RES_K(2))
	//RES(R88, RES_K(82))
	RES(R89, RES_K(22))
	RES(R90, RES_K(22))
	RES(R91, RES_M(1))
	//RES(R, RES_K())

	CAP(C7, CAP_U(0.1))
	CAP(C9, CAP_U(0.1))
	CAP(C10, CAP_U(0.1))
	CAP(C11, CAP_U(0.1))
	CAP(C12, CAP_U(0.01))
	CAP(C13, CAP_U(1.0))
	CAP(C14, CAP_U(0.1))
	CAP(C15, CAP_U(0.01))
	CAP(C18, CAP_U(1.0))
	CAP(C20, CAP_U(1.0))
	CAP(C21, CAP_U(0.1))
	CAP(C22, CAP_U(0.1))
	CAP(C23, CAP_U(0.1))
	CAP(C25, CAP_U(1.0))
	CAP(C26, CAP_U(0.1))
	CAP(C27, CAP_U(1.0))
	CAP(C29, CAP_U(0.1))
	CAP(C32, CAP_U(1.0))
	CAP(C34, CAP_U(1.0))
	CAP(C38, CAP_U(0.1))
	CAP(C39, CAP_U(0.01))
	CAP(C45, CAP_U(4.7))
	//CAP(C, CAP_U())

	DIODE(D3, "1N914")

	TTL_7406_GATE(IC_6C_A)
	TTL_7406_GATE(IC_6C_B)
	TTL_7406_GATE(IC_6C_C)
	TTL_7406_GATE(IC_6C_D)
	TTL_7406_GATE(IC_6C_E)
	TTL_7406_GATE(IC_6C_F)
	NET_C(VCC, IC_6C_A.VCC, IC_6C_B.VCC, IC_6C_C.VCC, IC_6C_D.VCC, IC_6C_E.VCC, IC_6C_F.VCC)
	NET_C(GND, IC_6C_A.GND, IC_6C_B.GND, IC_6C_C.GND, IC_6C_D.GND, IC_6C_E.GND, IC_6C_F.GND)

	CD4070_GATE(IC_7E_A)
	CD4070_GATE(IC_7E_B)
	CD4070_GATE(IC_7E_C)
	CD4070_GATE(IC_7E_D)
	NET_C(V12, IC_7E_A.VDD, IC_7E_B.VDD, IC_7E_C.VDD, IC_7E_D.VDD)
	NET_C(GND, IC_7E_A.VSS, IC_7E_B.VSS, IC_7E_C.VSS, IC_7E_D.VSS)

	NE555(IC_5B_A)
	NE555(IC_6E_A)
	NET_C(V5, IC_5B_A.VCC)
	NET_C(V12, IC_6E_A.VCC)
	NET_C(GND, IC_5B_A.GND, IC_6E_A.GND)

	SUBMODEL(NE556_DIP, IC_6A)
	SUBMODEL(NE556_DIP, IC_8F)
	NET_C(V5, IC_6A.14)
	NET_C(V12, IC_8F.14)
	NET_C(GND, IC_6A.7, IC_8F.7)

	CD4006_DIP(IC_8E)
	NET_C(V12, IC_8E.14)
	NET_C(GND, IC_8E.7)

	OPAMP(IC_6D_A, "LM324_12V")
	OPAMP(IC_6D_B, "LM324_12V")
	OPAMP(IC_6D_C, "LM324_12V")
	OPAMP(IC_6D_D, "LM324_12V")
	OPAMP(IC_8D_A, "LM324_12V")
	OPAMP(IC_8D_B, "LM324_12V")
	OPAMP(IC_8D_C, "LM324_12V")
	OPAMP(IC_8D_D, "LM324_12V")
	NET_C(V12, IC_6D_A.VCC, IC_6D_B.VCC, IC_6D_C.VCC, IC_6D_D.VCC, IC_8D_A.VCC, IC_8D_B.VCC, IC_8D_C.VCC, IC_8D_D.VCC)
	NET_C(VM12, IC_6D_A.GND, IC_6D_B.GND, IC_6D_C.GND, IC_6D_D.GND, IC_8D_A.GND, IC_8D_B.GND, IC_8D_C.GND, IC_8D_D.GND)

	OPAMP(IC_7C_A, "LM324_5V")
	OPAMP(IC_7C_B, "LM324_5V")
	OPAMP(IC_7C_C, "LM324_5V")
	OPAMP(IC_7C_D, "LM324_5V")
	NET_C(V5, IC_7C_A.VCC, IC_7C_B.VCC, IC_7C_C.VCC, IC_7C_D.VCC)
	NET_C(VM5, IC_7C_A.GND, IC_7C_B.GND, IC_7C_C.GND, IC_7C_D.GND)

	MC3340_DIP(IC_7D)
	MC3340_DIP(IC_6B)
	NET_C(V12, IC_6B.8, IC_7D.8)
	NET_C(GND, IC_6B.3, IC_7D.3)

	SUBMODEL(ICL8038_DIP, IC_6F)
	NET_C(V12, IC_6F.6)
	NET_C(VM12, IC_6F.11)

	CD4016_DIP(IC_7B)
	NET_C(V5, IC_7B.14)
	NET_C(VM5, IC_7B.7)

	QBJT_EB(Q1, "2N3702")
	QBJT_EB(Q2, "2N3702")

	// Tie Weapon
	NET_C(STIE.Q, IC_6C_E.A)
	NET_C(IC_6C_E.Y, R39.1, IC_7E_C.A)
	NET_C(V1_2, IC_7C_C.MINUS) // HACK: +12V is actually fed into this pin per the schematic, but it relies on LM324 abuse.
	NET_C(V12, R39.2, IC_7E_C.B, R83.1, R91.1, R86.1, IC_7E_A.A, IC_8F.10)
	NET_C(IC_7E_C.Q, IC_8F.4, IC_8F.6)
	NET_C(IC_8F.1, C45.1, Q2.C, IC_8D_D.PLUS)
	NET_C(GND, C38.2, C45.2, R82.2, R57.1, R61.2, R84.2, IC_8D_A.PLUS)
	NET_C(R83.2, R82.1, Q2.B)
	NET_C(R91.2, Q2.E)
	NET_C(IC_8F.5, R85.1)
	NET_C(R85.2, R84.1, IC_7C_C.PLUS)
	ALIAS(TIE_ON, IC_7C_C.OUT)
	ALIAS(TIEON1, R84.1)
	NET_C(R58.2, VM12)
	NET_C(R58.1, R57.2, R59.1, IC_8D_D.MINUS)
	NET_C(R59.2, IC_8D_D.OUT, R60.1, IC_8F.11)
	NET_C(R60.2, R61.1, IC_8F.2)
	NET_C(R86.2, R87.1, IC_8F.13)
	NET_C(R87.2, IC_8F.8, IC_8F.12, C38.1)
	NET_C(IC_8F.9, IC_8E.3)
	NET_C(IC_8E.13, IC_7E_A.B)
	NET_C(IC_7E_A.Q, IC_8E.5)
	NET_C(IC_8E.1, IC_8E.12, IC_7E_B.B)
	NET_C(IC_8E.8, IC_7E_B.A)
	NET_C(IC_7E_B.Q, IC_8E.4)
	NET_C(IC_8E.10, IC_8E.6, R73.1)
	NET_C(SIZE.Q, IC_6C_F.A)
	NET_C(IC_6C_F.Y, R56.1)
	NET_C(R56.2, R73.2, C29.1)
	NET_C(C29.2, R74.1)
	NET_C(R74.2, R75.1, IC_8D_A.MINUS)
	NET_C(R75.2, IC_8D_A.OUT)
	ALIAS(NOISE, IC_8D_A.OUT)

	// Explosion
	NET_C(NOISE, R53.1)
	NET_C(R53.2, C23.1, R52.1)
	NET_C(R52.2, C22.1, IC_6D_C.PLUS)
	NET_C(R50.2, R49.1, IC_6D_C.MINUS)
	NET_C(C23.2, R50.1, R51.1, R54.1, IC_6D_C.OUT)
	NET_C(R51.2, C21.1)
	ALIAS(RUMBLE_2, C21.1)
	NET_C(C21.2, C22.2, R49.2, C27.2, R55.2, C26.2, GND)
	NET_C(R54.2, R55.1, C34.1)
	NET_C(C34.2, IC_7D.1)
	NET_C(SEXPLO.Q, IC_6C_C.A)
	NET_C(IC_6C_C.Y, R40.1)
	NET_C(R40.2, C27.1, R63.1)
	NET_C(R63.2, R62.2, IC_8D_C.PLUS)
	NET_C(R62.1, V5)
	NET_C(IC_8D_C.MINUS, IC_8D_C.OUT, IC_7D.2)
	NET_C(IC_7D.6, C26.1)
	NET_C(IC_7D.7, C25.1)
	ALIAS(EXPLO, C25.2)

	// Tracking Computer
	NET_C(SCANNER.Q, IC_5B_A.RESET)
	NET_C(V5, R24.1, R70.1, R13.1, R27.1)
	NET_C(GND, C15.2, R26.2, C20.2, C11.2, C7.2, C12.2, R29.2)
	NET_C(R24.2, R23.1, R12.1, IC_6A.5, IC_5B_A.DISCH)
	NET_C(R23.2, C15.1, IC_5B_A.THRESH, IC_5B_A.TRIG)
	NET_C(OHEAT.Q, IC_6C_B.A)
	NET_C(IC_6C_B.Y, R38.1)
	NET_C(R38.2, C20.1, R69.1)
	NET_C(R69.2, R70.2, IC_6D_A.PLUS)
	NET_C(IC_6D_A.MINUS, IC_6D_A.OUT, IC_6B.2)
	NET_C(IC_5B_A.OUT, R25.1)
	NET_C(R25.2, C9.1, R26.1)
	NET_C(C9.2, IC_6B.1)
	NET_C(IC_6B.6, C11.1)
	NET_C(IC_6B.7, C10.1)
	ALIAS(LOH, C10.2)
	NET_C(R13.2, R14.1, IC_6A.1)
	NET_C(R14.2, C7.1, IC_6A.2, IC_6A.6)
	NET_C(LOCK.Q, IC_6A.4)
	NET_C(R12.2, IC_6A.11)
	NET_C(R27.2, R28.1, IC_6A.13)
	NET_C(R28.2, C12.1, IC_6A.12, IC_6A.8)
	NET_C(TRACK.Q, IC_6A.10)
	NET_C(IC_6A.9, C13.1)
	NET_C(C13.2, R30.1)
	NET_C(R30.2, R29.1)
	ALIAS(COMPUTER, R30.2)

	// Laser
	NET_C(SIZE.Q, IC_6C_D.A)
	NET_C(IC_6C_D.Y, R41.1)
	NET_C(R41.2, R78.2, R79.1, Q1.B)
	NET_C(V1_2, IC_7C_B.MINUS) // HACK: +12V is actually fed into this pin per the schematic, but it relies on LM324 abuse.
	NET_C(V12, R78.1, R77.1, R37.1, IC_7E_D.B, R89.1, R90.1)
	NET_C(GND, R79.2, C32.2, R48.2, R81.2, R67.2, IC_6D_B.PLUS)
	NET_C(R77.2, Q1.E)
	NET_C(Q1.C, C32.1, IC_6E_A.DISCH, IC_6D_D.PLUS)
	NET_C(SLASER.Q, IC_6C_A.A)
	NET_C(IC_6C_A.Y, R37.2, IC_7E_D.A)
	NET_C(IC_7E_D.Q, IC_6E_A.TRIG, IC_6E_A.RESET)
	NET_C(IC_6E_A.OUT, R80.1)
	NET_C(R80.2, R81.1, IC_7C_B.PLUS)
	ALIAS(LASERON1, R80.2)
	ALIAS(LASER_ON, IC_7C_B.OUT)
	NET_C(R48.1, R47.1, R46.1, IC_6D_D.MINUS)
	NET_C(VM12, R47.2, C39.2)
	NET_C(R46.2, IC_6D_D.OUT, R68.1, IC_6F.8)
	NET_C(R68.2, R67.1, IC_6E_A.THRESH)
	NET_C(C39.1, IC_6F.10)
	NET_C(R89.2, IC_6F.4)
	NET_C(R90.2, IC_6F.5)
	NET_C(IC_6F.3, R72.1)
	NET_C(R72.2, R71.1, IC_6D_B.MINUS)
	NET_C(R71.2, IC_6D_B.OUT)
	ALIAS(LASER, R71.2)

	// Mixer
	NET_C(V5, R45.1, R42.2)
	NET_C(R45.2, R44.1, IC_7C_A.MINUS, IC_7C_D.MINUS)
	NET_C(GND, R44.2, C18.2, R43.2)
	NET_C(SIZE.Q, R42.1, D3.A)
	NET_C(D3.K, C18.1, R43.1, IC_7C_D.PLUS)

	NET_C(TRACK.Q, IC_7C_A.PLUS)
	NET_C(IC_7C_A.OUT, IC_7B.13)
	NET_C(COMPUTER, IC_7B.1)
	NET_C(IC_7B.2, R16.1, R16.2)

	NET_C(LASER, IC_7B.11)
	NET_C(LASER_ON, IC_7B.12)
	NET_C(IC_7B.10, R18.1, R18.2)

	NET_C(NOISE, IC_7B.4)
	NET_C(TIE_ON, IC_7B.5)
	NET_C(IC_7B.3, R17.1, R17.2)

	NET_C(RUMBLE_2, IC_7B.8)
	NET_C(IC_7C_D.OUT, IC_7B.6)
	NET_C(IC_7B.9, R19.1, R19.2)

	NET_C(EXPLO, R20.1, R20.2)

	NET_C(LOH, R15.1, R15.2)

	NET_C(R16.3, R18.3, R17.3, R19.3, R20.3, R15.3, R64.1, IC_8D_B.MINUS)
	NET_C(GND, IC_8D_B.PLUS)
	NET_C(R64.2, R21.3, IC_8D_B.OUT)
	NET_C(R21.1, R31.2, GND)
	NET_C(R21.2, C14.1)
	NET_C(C14.2, R31.1)
	ALIAS(OUTPUT, R31.1)
NETLIST_END()
