macro(get_mapnik_version)
    file(READ ${CMAKE_CURRENT_SOURCE_DIR}/include/mapnik/version.hpp VERSION_FILE)

    string(REGEX MATCH "MAPNIK_MAJOR_VERSION ([0-9]*)" _ ${VERSION_FILE})
    set(MAPNIK_MAJOR_VERSION ${CMAKE_MATCH_1})

    string(REGEX MATCH "MAPNIK_MINOR_VERSION ([0-9]*)" _ ${VERSION_FILE})
    set(MAPNIK_MINOR_VERSION ${CMAKE_MATCH_1})

    string(REGEX MATCH "MAPNIK_PATCH_VERSION ([0-9]*)" _ ${VERSION_FILE})
    set(MAPNIK_PATCH_VERSION ${CMAKE_MATCH_1})

    set(MAPNIK_VERSION ${MAPNIK_MAJOR_VERSION}.${MAPNIK_MINOR_VERSION}.${MAPNIK_PATCH_VERSION})
endmacro()
