# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.composite_data_set_algorithm import CompositeDataSetAlgorithm


class ExtractBlockUsingDataAssembly(CompositeDataSetAlgorithm):
    r"""
    ExtractBlockUsingDataAssembly - extract blocks from certain
    composite datasets
    
    Superclass: CompositeDataSetAlgorithm
    
    ExtractBlockUsingDataAssembly is intended to extract selected
    blocks from certain composite datasets. Blocks to extract are
    selected using selectors. For supported selectors see
    `vtkdata_assembly::select_nodes`.
    
    The specific data-assembly to use to apply the selectors to determine
    the blocks to extract is chosen using
    `vtkextract_block_using_data_assembly::set_assembly_name`.
    
    @section ExtractBlockUsingDataAssembly-SupportedDataTypes
    Supported Data Types
    
    This filter accepts `vtkuniform_grid_amr`, `vtkmulti_block_data_set`, and
    `vtkpartitioned_data_set_collection` (and subclasses).
    MultiPieceDataSet and PartitionedDataSet are not accepted as
    inputs since those composite datasets are not comprised of "blocks".
    
    For OverlappingAMR, since extracting blocks cannot always
    guarantee a valid overlapping AMR, this filter generates a
    `vtkpartitioned_data_set_collection` instead. Any blanking information
    present in the input OverlappingAMR is also discarded for the same
    reason.
    
    For all other supported input data types, the type is preserved.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractBlockUsingDataAssembly, obj, update, **traits)
    
    prune_data_assembly = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true (default), the data assembly is pruned to remove
        branches that were not selected.
        """
    )

    def _prune_data_assembly_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPruneDataAssembly,
                        self.prune_data_assembly_)

    select_subtrees = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true (default) subtrees for chosen paths are treated
        as selected.
        """
    )

    def _select_subtrees_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSelectSubtrees,
                        self.select_subtrees_)

    assembly_name = traits.String('Hierarchy', enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the active assembly to use. The chosen assembly is used
        in combination with the selectors specified to determine which
        blocks are to be extracted.
        
        By default, this is set to
        DataAssemblyUtilities::HierarchyName().
        """
    )

    def _assembly_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAssemblyName,
                        self.assembly_name)

    def get_selector(self, *args):
        """
        get_selector(self, index:int) -> str
        C++: const char *get_selector(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetSelector, *args)
        return ret

    def set_selector(self, *args):
        """
        set_selector(self, selector:str) -> None
        C++: void set_selector(const char *selector)
        Convenience method to set a single selector. This clears any
        other existing selectors.
        """
        ret = self._wrap_call(self._vtk_obj.SetSelector, *args)
        return ret

    def _get_number_of_selectors(self):
        return self._vtk_obj.GetNumberOfSelectors()
    number_of_selectors = traits.Property(_get_number_of_selectors, desc=\
        r"""
        API to access selectors.
        """
    )

    def add_selector(self, *args):
        """
        add_selector(self, selector:str) -> bool
        C++: bool add_selector(const char *selector)
        API to set selectors. Multiple selectors can be added using
        `add_selector`. The order in which selectors are specified is not
        preserved and has no impact on the result.
        
        `add_selector` returns true if the selector was added, false if
        the selector was already specified and hence not added.
        
        @sa DataAssembly::SelectNodes
        """
        ret = self._wrap_call(self._vtk_obj.AddSelector, *args)
        return ret

    def clear_selectors(self):
        """
        clear_selectors(self) -> None
        C++: void clear_selectors()"""
        ret = self._vtk_obj.ClearSelectors()
        return ret
        

    _updateable_traits_ = \
    (('prune_data_assembly', 'GetPruneDataAssembly'), ('select_subtrees',
    'GetSelectSubtrees'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('assembly_name', 'GetAssemblyName'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'prune_data_assembly', 'release_data_flag', 'select_subtrees',
    'assembly_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractBlockUsingDataAssembly, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractBlockUsingDataAssembly properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['prune_data_assembly', 'select_subtrees'], [],
            ['assembly_name']),
            title='Edit ExtractBlockUsingDataAssembly properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractBlockUsingDataAssembly properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

