# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class ExtractDataArraysOverTime(MultiBlockDataSetAlgorithm):
    r"""
    ExtractDataArraysOverTime - extracts array from input dataset over
    time.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    ExtractDataArraysOverTime extracts array from input dataset over
    time. The filter extracts attribute arrays, based on the chosen field
    association (vtkextract_data_arrays_over_time::set_field_association).
    
    ExtractDataArraysOverTime::ReportStatisticsOnly determines if each
    element is individually tracked or only summary statistics for each
    timestep are tracked.
    
    If report_statistics_only is off, the filter tracks each element in the
    input over time. It requires that it can identify matching elements
    from one timestep to another. There are several ways of doing that.
    
    \li if ExtractDataArraysOverTime::UseGlobalIDs is true, then the
        filter
        will look for array marked as DataSetAttributes::GLOBALIDS in
    the
        input and use that to track the element.
    \li if ExtractDataArraysOverTime::UseGlobalIDs is false or there
        are no
        element ids present, then the filter will look for the array
    chosen for
        processing using `Algorithm::set_input_array_to_process` at index
    0.
    \li if earlier attempts fail, then simply the element id (i.e. index)
    is used.
    
    The output is a MultiBlockDataSet with single level, where leaf
    nodes can are Table instances.
    
    The output is structured as follows:
    
    \li if ExtractDataArraysOverTime::ReportStatisticsOnly is true,
        then the
        stats are computed per input block (if input is a composite
    dataset) or on the whole
        input dataset and placed as blocks named as stats block=<block
    id>.
        For non-composite input, the single leaf block is output is named
    as    stats.
    
    \li if ExtractDataArraysOverTime::ReportStatisticsOnly if off,
        then each
       tracked element is placed in a separate output block. The block
    name is of
       the form id=<id> block=<block id>where the block= suffix is
       dropped for non-composite input datasets. If global ids are being
    used for
       tracking then the name is simply gid=<global id>.
    
    @sa PExtractDataArraysOverTime
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractDataArraysOverTime, obj, update, **traits)
    
    report_statistics_only = tvtk_base.false_bool_trait(desc=\
        r"""
        Instead of breaking a data into a separate time-history table for
        each (block,ID)-tuple, you may call report_statistics_only_on().
        Then a single table per block of the input dataset will report
        the minimum, maximum, quartiles, and (for numerical arrays) the
        average and standard deviation of the data over time.
        
        * The default is off to preserve backwards-compatibility.
        """
    )

    def _report_statistics_only_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReportStatisticsOnly,
                        self.report_statistics_only_)

    field_association = traits.Trait(0, traits.Range(0, 6, enter_set=True, auto_set=False), desc=\
        r"""
        field_association indicates which attributes to extract over time.
        This filter can extract only one type of attribute arrays.
        Currently, DataObject::FIELD and
        DataObject::POINT_THEN_CELL are not supported.
        """
    )

    def _field_association_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldAssociation,
                        self.field_association)

    use_global_i_ds = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        When report_statistics_only is false, if use_global_i_ds is true, then
        the filter will track elements using their global ids, if
        present. Default is true.
        """
    )

    def _use_global_i_ds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseGlobalIDs,
                        self.use_global_i_ds)

    def _get_number_of_time_steps(self):
        return self._vtk_obj.GetNumberOfTimeSteps()
    number_of_time_steps = traits.Property(_get_number_of_time_steps, desc=\
        r"""
        Get the number of time steps
        """
    )

    _updateable_traits_ = \
    (('report_statistics_only', 'GetReportStatisticsOnly'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('field_association', 'GetFieldAssociation'), ('use_global_i_ds',
    'GetUseGlobalIDs'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'report_statistics_only', 'field_association',
    'progress_text', 'use_global_i_ds'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractDataArraysOverTime, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractDataArraysOverTime properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['report_statistics_only'], [], ['field_association',
            'use_global_i_ds']),
            title='Edit ExtractDataArraysOverTime properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractDataArraysOverTime properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

