# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class GLTFWriter(Writer):
    r"""
    GLTFWriter - export a scene into GLTF 2.0 format.
    
    Superclass: Writer
    
    GLTFWriter is a concrete subclass of Writer that writes GLTF
    2.0 files. Its input is a multiblock dataset as it is produced by the
    city_gml reader. The dataset contains a list of buildings, each
    building is made of pieces (polydata), each piece could potentially
    have a different texture. Materials, including textures, are
    described as fields in the polydata. If inline_data is false, we only
    refer to textures files refered in the data, otherwise we read the
    textures and save them encoded in the file.
    
    @sa
    CityGMLReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGLTFWriter, obj, update, **traits)
    
    inline_data = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _inline_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInlineData,
                        self.inline_data_)

    save_batch_id = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _save_batch_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveBatchId,
                        self.save_batch_id_)

    save_normal = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _save_normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveNormal,
                        self.save_normal_)

    save_textures = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _save_textures_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveTextures,
                        self.save_textures_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify the name of the GLTF file to write.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    texture_base_directory = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Specify the base directory for texture files.
        """
    )

    def _texture_base_directory_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureBaseDirectory,
                        self.texture_base_directory)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def write_to_string(self):
        """
        write_to_string(self) -> str
        C++: std::string write_to_string()
        Write the result to a string instead of a file
        """
        ret = self._vtk_obj.WriteToString()
        return ret
        

    _updateable_traits_ = \
    (('inline_data', 'GetInlineData'), ('save_batch_id',
    'GetSaveBatchId'), ('save_normal', 'GetSaveNormal'), ('save_textures',
    'GetSaveTextures'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('texture_base_directory', 'GetTextureBaseDirectory'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'inline_data',
    'release_data_flag', 'save_batch_id', 'save_normal', 'save_textures',
    'file_name', 'progress_text', 'texture_base_directory'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GLTFWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GLTFWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['inline_data', 'save_batch_id', 'save_normal',
            'save_textures'], [], ['file_name', 'texture_base_directory']),
            title='Edit GLTFWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GLTFWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

