# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.reader_algorithm import ReaderAlgorithm


class IOSSReader(ReaderAlgorithm):
    r"""
    IOSSReader - Reader for IOSS (Sierra IO System)
    
    Superclass: ReaderAlgorithm
    
    IOSSReader is reader that uses the IOSS (Sierra IO System) library
    to read files. Currently, this reader support Exodus and CGNS file
    formats. IOSS imposes certain restrictions on these file formats and
    hence it may not be possible to open every Exodus or CGNS file using
    this reader. This is true especially for CGNS, more so than Exodus.
    In that case `CGNSReader` may be more appropriate.
    
    @section specifying_files Specifying Files
    
    One can select a single file to read using
    `IOSSReader::set_file_name`. With IOSS, however, it is not uncommon
    to have a collection of files named using standard patterns
    (described in Section @ref ioss_naming_conventions). To support this
    use-case, the reader automatically scans for additionally files
    internally. To disable this behaviour, call
    `IOSSReader::scan_for_related_files_off`.
    
    Alternatively, the list of files to be read can be explicitly
    specified using `IOSSReader::add_file_name`. Then too, if
    `scan_for_related_files` is `true`, the reader will search for related
    files for each of the files specified.
    
    Additionally, `file_range` and `file_stride` may be used to limit to
    reading a subset of files.
    
    @section selecting_blocks_sets Selecting blocks and sets to read
    
    An IOSS file comprises of blocks and sets of various types. These are
    described by the enum `IOSSReader::entity_type`.
    
    `IOSSReader::get_entity_selection` returns a `vtkdata_array_selection`
    instance for each of the entity types. This `vtkdata_array_selection`
    can be used to query the names for available blocks or sets and also
    select which ones to read.
    
    Typical usage is as follows:
    
    {.cpp}
    
    Newreader; reader->set_file_name(...); reader->update_information();
    reader->get_element_block_selection()->enable_array("Block0");
    reader->get_entity_selection(IOSSReader::SIDESET)->disable_all_arrays()
    ;
    
    By default, all blocks are enabled, while all sets are disabled.
    
    In additional to selecting blocks and sets by name, if the file
    defines assemblies that organize these blocks and sets, then one can
    use selector expressions to enable blocks/sets as defined in the
    assemblies.
    
    A block (or set) is treated as enabled if it is either explicitly
    enabled using the block selection or implicitly enabled due to a
    selector specified on over the assemblies.
    
    Typical usage to select blocks by assembly alone is as follows:
    
    {.cpp}
    Newreader;
    reader->set_file_name(...);
    reader->update_information();
    reader->get_element_block_selection()->disable_all_arrays();
    ...
    reader->add_selector("//Low");
    reader->add_selector("//High");
    
    @section selecting_arrays Selecting arrays to read
    
    Similar to the block and set selection, arrays (or fields as IOSS
    refers to them) to read from each of the blocks or sets can be
    specified using the `vtkdata_array_selection` instance returned using
    `IOSSReader::get_field_selection` (or one of its convenience
    variants).
    
    By default all arrays are enabled.
    
    @section ioss_naming_conventions IOSS Naming Conventions
    
    An IOSS complete dataset is referred to as a database. There can be
    multiple multiple timesteps in a single database. A single database
    may split among multiple files. When a database is split among
    multiple files, this is strictly spatial partitioning with each file
    storing part of the data for a specific partition. In this case, the
    files are named with suffix `.{NP}.{RANK}` where `{NP}` is the total
    number of partitions  and `{RANK}` is the partition number. For
    example, if database named `can.e` is split among four files
    representing 4 partitions, it will be named as follows:
    
    
      can.e.4.0
      can.e.4.1
      can.e.4.2
      can.e.4.3
     
    
    In this example, the database name is `can.e` while the `.4.[0-4]`
    suffix provides the partition information.
    
    Note, the database need not be split into multiple files. Thus, a
    writer may generate a single `can.e` file that has all the timesteps
    and paritions and still provide all information available when the
    database is split among multiple files.
    
    Multiple databases (with each stored in a single file or spatially
    split among files) can form a temporal sequence. This done by using
    another file naming convention. If the database name is followed by
    `-s.{RS}`, where `{RS}` is some number sequence), then the databases
    are treated as a temporal sequence with `{RS}` (called restart
    numbers) representing the temporal sequence order.
    
    The follow represents a temporal sequence:
    
    
      mysimoutput.e-s.000
      mysimoutput.e-s.001
      mysimoutput.e-s.002
     
    
    You can use any number of digits for the restart number, but by
    convention the number used should be the same for all files. Also by
    convention, you can leave off the `-s.{RS}` suffix for the first
    file. The following sequence is internally the same as that above:
    
    
      mysimoutput.e-s
      mysimoutput.e-s.001
      mysimoutput.e-s.002
     
    
    When a database in the temporal sequence is spatially split in
    multiple files, the corresponding filename is suffixed by the
    partition information. For example:
    
    
      mysimoutput.e-s.2.0
      mysimoutput.e-s.2.1
      mysimoutput.e-s.001.2.0
      mysimoutput.e-s.001.2.1
      mysimoutput.e-s.002.2.0
      mysimoutput.e-s.002.2.1
     
    
    In this case, the filenames take the form
    `{DBNAME}-s.{RS}.{NP}.{RANK}`, where `{DBNAME}` is the database name,
    `{RS}` is the restart number, `{NP}` is the number of spatial
    partitions and `{RANK}` is the spatial partition number.
    
    @section References References
    * [Sierra IO System](http://gsjaardema.github.io/seacas/)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkIOSSReader, obj, update, **traits)
    
    apply_displacements = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true (default), if an array named 'displacement' is
        present in the node field arrays, it will be used to transform
        the point coordinates.
        """
    )

    def _apply_displacements_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetApplyDisplacements,
                        self.apply_displacements_)

    generate_file_id = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true, the reader will add a cell-data array for cells
        named 'file_id' which identifies the file number when reading
        spatially partitioned files.
        
        Default is false.
        """
    )

    def _generate_file_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateFileId,
                        self.generate_file_id_)

    read_global_fields = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true (default), the reader will read global fields.
        """
    )

    def _read_global_fields_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadGlobalFields,
                        self.read_global_fields_)

    read_ids = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true (default), the reader will read ids associated
        with elements.
        """
    )

    def _read_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadIds,
                        self.read_ids_)

    read_qa_and_information_records = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true (default), the reader will read quality
        assurance and information fields.
        """
    )

    def _read_qa_and_information_records_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadQAAndInformationRecords,
                        self.read_qa_and_information_records_)

    remove_unused_points = tvtk_base.true_bool_trait(desc=\
        r"""
        Node related data, including point coordinates, point field data
        etc. is typically shared between all blocks and sets. By default,
        the reader will remove unused points for each block or set. To
        avoid this, set this flag to false.
        
        Default is true, unused points are removed.
        """
    )

    def _remove_unused_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRemoveUnusedPoints,
                        self.remove_unused_points_)

    scan_for_related_files = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true, the reader can automatically locate and load
        additional files that are part of the collection.
        """
    )

    def _scan_for_related_files_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScanForRelatedFiles,
                        self.scan_for_related_files_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    database_type_override = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Get/Set the IOSS database name to use for reading the file. If
        not specified (default), the reader will determine based on the
        file extension.
        """
    )

    def _database_type_override_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDatabaseTypeOverride,
                        self.database_type_override)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Set a single filename. Note, this will clear all existing
        filenames.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    file_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, -1), cols=2, desc=\
        r"""
        This provides a mechanism to limit to reading to certain files in
        a spatially partitioned file-series. To just specific subset of
        files, one can always simply specify those files using
        `add_file_name` and then set `scan_for_related_files` to false.
        Another way is to let the reader scan for all related files and
        then use `file_range` and `file_stride` to limit which files are
        read.
        
        If the range is invalid, i.e. `file_range[0] >= file_range[1]`,
        it's assumed that no file-range overrides have been specified and
        both file_range and file_stride will be ignored. When valid, only
        the chosen subset of files will be processed.
        """
    )

    def _file_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileRange,
                        self.file_range)

    file_stride = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _file_stride_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileStride,
                        self.file_stride)

    def get_selector(self, *args):
        """
        get_selector(self, index:int) -> str
        C++: const char *get_selector(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetSelector, *args)
        return ret

    def set_selector(self, *args):
        """
        set_selector(self, selector:str) -> None
        C++: void set_selector(const char *selector)"""
        ret = self._wrap_call(self._vtk_obj.SetSelector, *args)
        return ret

    def _get_assembly(self):
        return wrap_vtk(self._vtk_obj.GetAssembly())
    assembly = traits.Property(_get_assembly, desc=\
        r"""
        Assemblies provide yet another way of selection blocks/sets to
        load, if available in the dataset. If a block (or set) is enabled
        either in the block (or set) selection or using assembly selector
        then it is treated as enabled and will be read.
        
        This method returns the DataAssembly. Since IOSS can have
        multiple assemblies, all are nested under the root "Assemblies"
        node.
        
        If the file has no assemblies, this will return nullptr.
        """
    )

    def _get_assembly_tag(self):
        return self._vtk_obj.GetAssemblyTag()
    assembly_tag = traits.Property(_get_assembly_tag, desc=\
        r"""
        Whenever the assembly is changed, this tag gets changed. Note,
        users should not assume that this is monotonically increasing but
        instead simply rely on its value to determine if the assembly may
        have changed since last time.
        
        It is set to 0 whenever there's no valid assembly available.
        """
    )

    def get_data_assembly_node_name_for_entity_type(self, *args):
        """
        get_data_assembly_node_name_for_entity_type(type:int) -> str
        C++: static const char *get_data_assembly_node_name_for_entity_type(
            int type)"""
        ret = self._wrap_call(self._vtk_obj.GetDataAssemblyNodeNameForEntityType, *args)
        return ret

    def _get_edge_block_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetEdgeBlockFieldSelection())
    edge_block_field_selection = traits.Property(_get_edge_block_field_selection, desc=\
        r"""
        
        """
    )

    def _get_edge_block_selection(self):
        return wrap_vtk(self._vtk_obj.GetEdgeBlockSelection())
    edge_block_selection = traits.Property(_get_edge_block_selection, desc=\
        r"""
        
        """
    )

    def _get_edge_set_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetEdgeSetFieldSelection())
    edge_set_field_selection = traits.Property(_get_edge_set_field_selection, desc=\
        r"""
        
        """
    )

    def _get_edge_set_selection(self):
        return wrap_vtk(self._vtk_obj.GetEdgeSetSelection())
    edge_set_selection = traits.Property(_get_edge_set_selection, desc=\
        r"""
        
        """
    )

    def _get_element_block_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetElementBlockFieldSelection())
    element_block_field_selection = traits.Property(_get_element_block_field_selection, desc=\
        r"""
        
        """
    )

    def _get_element_block_selection(self):
        return wrap_vtk(self._vtk_obj.GetElementBlockSelection())
    element_block_selection = traits.Property(_get_element_block_selection, desc=\
        r"""
        
        """
    )

    def _get_element_set_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetElementSetFieldSelection())
    element_set_field_selection = traits.Property(_get_element_set_field_selection, desc=\
        r"""
        
        """
    )

    def _get_element_set_selection(self):
        return wrap_vtk(self._vtk_obj.GetElementSetSelection())
    element_set_selection = traits.Property(_get_element_set_selection, desc=\
        r"""
        
        """
    )

    def get_entity_selection(self, *args):
        """
        get_entity_selection(self, type:int) -> DataArraySelection
        C++: DataArraySelection *get_entity_selection(int type)"""
        ret = self._wrap_call(self._vtk_obj.GetEntitySelection, *args)
        return wrap_vtk(ret)

    def get_entity_type_is_block(self, *args):
        """
        get_entity_type_is_block(type:int) -> bool
        C++: static bool get_entity_type_is_block(int type)"""
        ret = self._wrap_call(self._vtk_obj.GetEntityTypeIsBlock, *args)
        return ret

    def get_entity_type_is_set(self, *args):
        """
        get_entity_type_is_set(type:int) -> bool
        C++: static bool get_entity_type_is_set(int type)"""
        ret = self._wrap_call(self._vtk_obj.GetEntityTypeIsSet, *args)
        return ret

    def _get_face_block_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetFaceBlockFieldSelection())
    face_block_field_selection = traits.Property(_get_face_block_field_selection, desc=\
        r"""
        
        """
    )

    def _get_face_block_selection(self):
        return wrap_vtk(self._vtk_obj.GetFaceBlockSelection())
    face_block_selection = traits.Property(_get_face_block_selection, desc=\
        r"""
        
        """
    )

    def _get_face_set_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetFaceSetFieldSelection())
    face_set_field_selection = traits.Property(_get_face_set_field_selection, desc=\
        r"""
        
        """
    )

    def _get_face_set_selection(self):
        return wrap_vtk(self._vtk_obj.GetFaceSetSelection())
    face_set_selection = traits.Property(_get_face_set_selection, desc=\
        r"""
        
        """
    )

    def get_field_selection(self, *args):
        """
        get_field_selection(self, type:int) -> DataArraySelection
        C++: DataArraySelection *get_field_selection(int type)"""
        ret = self._wrap_call(self._vtk_obj.GetFieldSelection, *args)
        return wrap_vtk(ret)

    def _get_node_block_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetNodeBlockFieldSelection())
    node_block_field_selection = traits.Property(_get_node_block_field_selection, desc=\
        r"""
        
        """
    )

    def _get_node_block_selection(self):
        return wrap_vtk(self._vtk_obj.GetNodeBlockSelection())
    node_block_selection = traits.Property(_get_node_block_selection, desc=\
        r"""
        
        """
    )

    def _get_node_set_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetNodeSetFieldSelection())
    node_set_field_selection = traits.Property(_get_node_set_field_selection, desc=\
        r"""
        
        """
    )

    def _get_node_set_selection(self):
        return wrap_vtk(self._vtk_obj.GetNodeSetSelection())
    node_set_selection = traits.Property(_get_node_set_selection, desc=\
        r"""
        
        """
    )

    def _get_number_of_file_names(self):
        return self._vtk_obj.GetNumberOfFileNames()
    number_of_file_names = traits.Property(_get_number_of_file_names, desc=\
        r"""
        
        """
    )

    def _get_number_of_selectors(self):
        return self._vtk_obj.GetNumberOfSelectors()
    number_of_selectors = traits.Property(_get_number_of_selectors, desc=\
        r"""
        API to access selectors.
        """
    )

    def _get_side_set_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetSideSetFieldSelection())
    side_set_field_selection = traits.Property(_get_side_set_field_selection, desc=\
        r"""
        
        """
    )

    def _get_side_set_selection(self):
        return wrap_vtk(self._vtk_obj.GetSideSetSelection())
    side_set_selection = traits.Property(_get_side_set_selection, desc=\
        r"""
        
        """
    )

    def _get_structured_block_field_selection(self):
        return wrap_vtk(self._vtk_obj.GetStructuredBlockFieldSelection())
    structured_block_field_selection = traits.Property(_get_structured_block_field_selection, desc=\
        r"""
        
        """
    )

    def _get_structured_block_selection(self):
        return wrap_vtk(self._vtk_obj.GetStructuredBlockSelection())
    structured_block_selection = traits.Property(_get_structured_block_selection, desc=\
        r"""
        
        """
    )

    def add_file_name(self, *args):
        """
        add_file_name(self, fname:str) -> None
        C++: void add_file_name(const char *fname)
        API to set the filenames.
        """
        ret = self._wrap_call(self._vtk_obj.AddFileName, *args)
        return ret

    def add_property(self, *args):
        """
        add_property(self, name:str, value:int) -> None
        C++: void add_property(const char *name, int value)
        add_property(self, name:str, value:float) -> None
        C++: void add_property(const char *name, double value)
        add_property(self, name:str, value:Pointer) -> None
        C++: void add_property(const char *name, void *value)
        add_property(self, name:str, value:str) -> None
        C++: void add_property(const char *name, const char *value)
        IOSS databases support various properties that affect how the
        database is read. These properties can be set using this API.
        Note, it's best to call this before the first update to the
        reader since any change and the reader will flush all caches and
        close all open databases etc.
        """
        ret = self._wrap_call(self._vtk_obj.AddProperty, *args)
        return ret

    def add_selector(self, *args):
        """
        add_selector(self, selector:str) -> bool
        C++: bool add_selector(const char *selector)
        API to specify selectors that indicate which branches on the
        assembly are chosen.
        """
        ret = self._wrap_call(self._vtk_obj.AddSelector, *args)
        return ret

    def clear_file_names(self):
        """
        clear_file_names(self) -> None
        C++: void clear_file_names()"""
        ret = self._vtk_obj.ClearFileNames()
        return ret
        

    def clear_properties(self):
        """
        clear_properties(self) -> None
        C++: void clear_properties()"""
        ret = self._vtk_obj.ClearProperties()
        return ret
        

    def clear_selectors(self):
        """
        clear_selectors(self) -> None
        C++: void clear_selectors()"""
        ret = self._vtk_obj.ClearSelectors()
        return ret
        

    def do_test_file_pattern_matching(self):
        """
        do_test_file_pattern_matching() -> bool
        C++: static bool do_test_file_pattern_matching()
        Runs a bunch of tests for file pattern matching.
        """
        ret = self._vtk_obj.DoTestFilePatternMatching()
        return ret
        

    def remove_all_entity_selections(self):
        """
        remove_all_entity_selections(self) -> None
        C++: void remove_all_entity_selections()"""
        ret = self._vtk_obj.RemoveAllEntitySelections()
        return ret
        

    def remove_all_field_selections(self):
        """
        remove_all_field_selections(self) -> None
        C++: void remove_all_field_selections()"""
        ret = self._vtk_obj.RemoveAllFieldSelections()
        return ret
        

    def remove_all_selections(self):
        """
        remove_all_selections(self) -> None
        C++: void remove_all_selections()"""
        ret = self._vtk_obj.RemoveAllSelections()
        return ret
        

    def remove_property(self, *args):
        """
        remove_property(self, name:str) -> None
        C++: void remove_property(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.RemoveProperty, *args)
        return ret

    _updateable_traits_ = \
    (('apply_displacements', 'GetApplyDisplacements'),
    ('generate_file_id', 'GetGenerateFileId'), ('read_global_fields',
    'GetReadGlobalFields'), ('read_ids', 'GetReadIds'),
    ('read_qa_and_information_records', 'GetReadQAAndInformationRecords'),
    ('remove_unused_points', 'GetRemoveUnusedPoints'),
    ('scan_for_related_files', 'GetScanForRelatedFiles'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('database_type_override', 'GetDatabaseTypeOverride'), ('file_name',
    'GetFileName'), ('file_range', 'GetFileRange'), ('file_stride',
    'GetFileStride'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'apply_displacements', 'debug', 'generate_file_id',
    'global_warning_display', 'read_global_fields', 'read_ids',
    'read_qa_and_information_records', 'release_data_flag',
    'remove_unused_points', 'scan_for_related_files',
    'database_type_override', 'file_name', 'file_range', 'file_stride',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(IOSSReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit IOSSReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['apply_displacements', 'generate_file_id',
            'read_global_fields', 'read_ids', 'read_qa_and_information_records',
            'remove_unused_points', 'scan_for_related_files'], [],
            ['database_type_override', 'file_name', 'file_range', 'file_stride']),
            title='Edit IOSSReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit IOSSReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

