<a href="https://github.com/wentasah/meson-mode"><img src="https://www.gnu.org/software/emacs/images/emacs.png" alt="Emacs Logo" width="80" height="80" align="right"></a>
## meson-mode.el
*Major mode for the Meson build system files*

---
[![License GPLv3](https://img.shields.io/badge/license-GPL_v3-green.svg)](http://www.gnu.org/licenses/gpl-3.0.html)
[![MELPA](http://melpa.org/packages/meson-mode-badge.svg)](http://melpa.org/#/meson-mode)
[![MELPA Stable](http://stable.melpa.org/packages/meson-mode-badge.svg)](http://stable.melpa.org/#/meson-mode)

This is a major mode for Meson build system files.  Syntax
highlighting works reliably.  Indentation works too, but there are
probably cases, where it breaks.  Simple completion is supported
via `completion-at-point`.  To start completion, use either C-M-i
or install completion frameworks such as `company`.  To enable
`company` add the following to your .emacs:

    (add-hook 'meson-mode-hook 'company-mode)


### Function Documentation


#### `(meson-function-at-point)`

Return name of the function under point.
The point can be anywhere within function name or argument list.

#### `(meson-lookup-doc IDENTIFIER)`

Open Meson reference manual and find IDENTIFIER.
Return the buffer containing the reference manual.
IDENTIFIER is the name of a Meson function or object as a string.
Signal a `user-error` if the manual could not be found
or does not contain IDENTIFIER.

-----
<div style="padding-top:15px;color: #d0d0d0;">
Markdown README file generated by
<a href="https://github.com/mgalgs/make-readme-markdown">make-readme-markdown.el</a>
</div>
