#!/bin/ksh
# Script zum faxen von PS-Dokumenten
# Optionen "-n Number file -h"
# 05.09.95 Erste Version ohne Authentisierung. Lange Version
#          Mit der Fkt "getopts muesste alles viel einfacher
#          gehen. (Wenn man weis wie's geht) (freidhof)
# 07.08.95 Erweiterungen (kurpiers)

ERROR=false

if [ $# -gt 4 ]
then 
  echo "Error: To much parameters!"
  ERROR=true
else  
  if [ $# -lt 3 ]
  then 
    echo "Error: Less parameters!"
    ERROR=true
  else  
    if [ "$1" != "-n" ]
    then 
      echo "Error: Fax-Number missing!"
      ERROR=true
    else
      DUMMY=$2;
      # Kleines sed-Script zum Bereinigen der Tel-Nummer. Nicht perfekt!
      NUMBER=`echo $DUMMY | sed 's/[a-zA-Z()-]//g'`  
      if [ -z "$NUMBER" ]
      then
        echo "Error: Fax-Number missing!"
        ERROR=true
      else
        if [ ! -r $3 ]
        then
          echo "Error: The file "$3" doesn't exist or is unreadable."
          ERROR=true
        else
          if [ $# -gt 3 ]
          then
            if [ "$4" != "-h" ]
            then 
              echo "Error: Wrong parameter: "$4
              ERROR=true
            else
              RESOLUTION=High
            fi
          else
            RESOLUTION=Low
          fi            
        fi
      fi
    fi
  fi
fi

if [ "$ERROR" = "false" ]
then 
  (echo "Number: "$NUMBER" Resolution: "$RESOLUTION;
  cat $3) | lpr -Pfax
else
  echo "\nUsage:  fax -n <PhoneNumber> <Postscriptfile> {-h}"
  echo "Option:  -h High resolution"
fi

