C     DRIVER FOR CHKDER EXAMPLE.
C     DOUBLE PRECISION VERSION
C
C     **********
      INTEGER I,M,N,LDFJAC,MODE,NWRITE
      DOUBLE PRECISION X(3),FVEC(15),FJAC(15,3),XP(3),FVECP(15),
     *                 ERR(15)
C
C     LOGICAL OUTPUT UNIT IS ASSUMED TO BE NUMBER 6.
C
      DATA NWRITE /6/
C
      M = 15
      N = 3
C
C     THE FOLLOWING VALUES SHOULD BE SUITABLE FOR
C     CHECKING THE JACOBIAN MATRIX.
C
      X(1) = 9.2D-1
      X(2) = 1.3D-1
      X(3) = 5.4D-1
C
      LDFJAC = 15
C
      MODE = 1
      CALL CHKDER(M,N,X,FVEC,FJAC,LDFJAC,XP,FVECP,MODE,ERR)
      MODE = 2
      CALL FCN(M,N,X,FVEC,FJAC,LDFJAC,1)
      CALL FCN(M,N,X,FVEC,FJAC,LDFJAC,2)
      CALL FCN(M,N,XP,FVECP,FJAC,LDFJAC,1)
      CALL CHKDER(M,N,X,FVEC,FJAC,LDFJAC,XP,FVECP,MODE,ERR)
C
      DO 10 I = 1, M
         FVECP(I) = FVECP(I) - FVEC(I)
   10    CONTINUE
      WRITE (NWRITE,1000) (FVEC(I),I=1,M)
      WRITE (NWRITE,2000) (FVECP(I),I=1,M)
      WRITE (NWRITE,3000) (ERR(I),I=1,M)
      STOP
 1000 FORMAT (/5X,5H FVEC // (5X,3D15.7))
 2000 FORMAT (/5X,13H FVECP - FVEC // (5X,3D15.7))
 3000 FORMAT (/5X,4H ERR // (5X,3D15.7))
C
C     LAST CARD OF DRIVER FOR CHKDER EXAMPLE.
C
      END
      SUBROUTINE FCN(M,N,X,FVEC,FJAC,LDFJAC,IFLAG)
      INTEGER M,N,LDFJAC,IFLAG
      DOUBLE PRECISION X(N),FVEC(M),FJAC(LDFJAC,N)
C
C     SUBROUTINE FCN FOR CHKDER EXAMPLE.
C

      INTEGER I
      DOUBLE PRECISION TMP1,TMP2,TMP3,TMP4
      DOUBLE PRECISION Y(15)
      DATA Y(1),Y(2),Y(3),Y(4),Y(5),Y(6),Y(7),Y(8),
     *     Y(9),Y(10),Y(11),Y(12),Y(13),Y(14),Y(15)
     *     /1.4D-1,1.8D-1,2.2D-1,2.5D-1,2.9D-1,3.2D-1,3.5D-1,3.9D-1,
     *      3.7D-1,5.8D-1,7.3D-1,9.6D-1,1.34D0,2.1D0,4.39D0/
C
      IF (IFLAG .EQ. 2) GO TO 20
      DO 10 I = 1, 15
         TMP1 = I
         TMP2 = 16 - I
         TMP3 = TMP1
         IF (I .GT. 8) TMP3 = TMP2
         FVEC(I) = Y(I) - (X(1) + TMP1/(X(2)*TMP2 + X(3)*TMP3))
   10    CONTINUE
      GO TO 40
   20 CONTINUE
      DO 30 I = 1, 15
         TMP1 = I
         TMP2 = 16 - I
C
C        ERROR INTRODUCED INTO NEXT STATEMENT FOR ILLUSTRATION.
C        CORRECTED STATEMENT SHOULD READ    TMP3 = TMP1 .
C
         TMP3 = TMP2
         IF (I .GT. 8) TMP3 = TMP2
         TMP4 = (X(2)*TMP2 + X(3)*TMP3)**2
         FJAC(I,1) = -1.D0
         FJAC(I,2) = TMP1*TMP2/TMP4
         FJAC(I,3) = TMP1*TMP3/TMP4
   30    CONTINUE
   40 CONTINUE
      RETURN
C
C     LAST CARD OF SUBROUTINE FCN.
C
      END
