/* moonshot-trust-anchor-dialog.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-trust-anchor-dialog.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST (trust_anchor_confirmation_request_get_type ())
#define TRUST_ANCHOR_CONFIRMATION_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequest))
#define TRUST_ANCHOR_CONFIRMATION_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequestClass))
#define IS_TRUST_ANCHOR_CONFIRMATION_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST))
#define IS_TRUST_ANCHOR_CONFIRMATION_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST))
#define TRUST_ANCHOR_CONFIRMATION_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequestClass))

typedef struct _TrustAnchorConfirmationRequest TrustAnchorConfirmationRequest;
typedef struct _TrustAnchorConfirmationRequestClass TrustAnchorConfirmationRequestClass;
typedef struct _TrustAnchorConfirmationRequestPrivate TrustAnchorConfirmationRequestPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

#define TRUST_ANCHOR_TYPE_TRUST_ANCHOR_TYPE (trust_anchor_trust_anchor_type_get_type ())

#define TYPE_TRUST_ANCHOR_DIALOG (trust_anchor_dialog_get_type ())
#define TRUST_ANCHOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR_DIALOG, TrustAnchorDialog))
#define TRUST_ANCHOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR_DIALOG, TrustAnchorDialogClass))
#define IS_TRUST_ANCHOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR_DIALOG))
#define IS_TRUST_ANCHOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR_DIALOG))
#define TRUST_ANCHOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR_DIALOG, TrustAnchorDialogClass))

typedef struct _TrustAnchorDialog TrustAnchorDialog;
typedef struct _TrustAnchorDialogClass TrustAnchorDialogClass;
typedef struct _TrustAnchorDialogPrivate TrustAnchorDialogPrivate;

typedef void (*TrustAnchorConfirmationCallback) (TrustAnchorConfirmationRequest* request, void* user_data);
struct _TrustAnchorConfirmationRequest {
	GObject parent_instance;
	TrustAnchorConfirmationRequestPrivate * priv;
	gboolean confirmed;
};

struct _TrustAnchorConfirmationRequestClass {
	GObjectClass parent_class;
};

struct _TrustAnchorConfirmationRequestPrivate {
	IdentityManagerApp* parent_app;
	gchar* userid;
	gchar* realm;
	gchar* fingerprint;
	TrustAnchorConfirmationCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

typedef enum  {
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_EMPTY,
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_CA_CERT,
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT
} TrustAnchorTrustAnchorType;

struct _TrustAnchorDialog {
	GtkDialog parent_instance;
	TrustAnchorDialogPrivate * priv;
	gboolean complete;
};

struct _TrustAnchorDialogClass {
	GtkDialogClass parent_class;
};


static gpointer trust_anchor_confirmation_request_parent_class = NULL;
static MoonshotLogger* trust_anchor_confirmation_request_logger;
static MoonshotLogger* trust_anchor_confirmation_request_logger = NULL;
static gpointer trust_anchor_dialog_parent_class = NULL;
static GdkColor trust_anchor_dialog_white;
static GdkColor trust_anchor_dialog_white = {0};

GType trust_anchor_confirmation_request_get_type (void) G_GNUC_CONST;
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
#define TRUST_ANCHOR_CONFIRMATION_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequestPrivate))
enum  {
	TRUST_ANCHOR_CONFIRMATION_REQUEST_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
TrustAnchorConfirmationRequest* trust_anchor_confirmation_request_new (IdentityManagerApp* parent_app, const gchar* userid, const gchar* realm, const gchar* fingerprint);
TrustAnchorConfirmationRequest* trust_anchor_confirmation_request_construct (GType object_type, IdentityManagerApp* parent_app, const gchar* userid, const gchar* realm, const gchar* fingerprint);
void trust_anchor_confirmation_request_set_callback (TrustAnchorConfirmationRequest* self, TrustAnchorConfirmationCallback cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
gboolean trust_anchor_confirmation_request_execute (TrustAnchorConfirmationRequest* self);
GType id_card_get_type (void) G_GNUC_CONST;
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType identity_manager_view_get_type (void) G_GNUC_CONST;
IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store);
gboolean identity_manager_app_get_use_flat_file_store (IdentityManagerApp* self);
void moonshot_logger_warn (MoonshotLogger* self, const gchar* message, GError* e);
static void trust_anchor_confirmation_request_return_confirmation (TrustAnchorConfirmationRequest* self, gboolean confirmed);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
gboolean trust_anchor_is_empty (TrustAnchor* self);
GType trust_anchor_trust_anchor_type_get_type (void) G_GNUC_CONST;
TrustAnchorTrustAnchorType trust_anchor_get_anchor_type (TrustAnchor* self);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
gboolean identity_manager_app_get_headless (IdentityManagerApp* self);
GType trust_anchor_dialog_get_type (void) G_GNUC_CONST;
TrustAnchorDialog* trust_anchor_dialog_new (IdCard* card, const gchar* userid, const gchar* realm, const gchar* fingerprint);
TrustAnchorDialog* trust_anchor_dialog_construct (GType object_type, IdCard* card, const gchar* userid, const gchar* realm, const gchar* fingerprint);
void trust_anchor_update_server_fingerprint (TrustAnchor* self, const gchar* fingerprint);
IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card);
static gboolean __lambda21_ (TrustAnchorConfirmationRequest* self);
static gboolean ___lambda21__gsource_func (gpointer self);
static void trust_anchor_confirmation_request_finalize (GObject* obj);
enum  {
	TRUST_ANCHOR_DIALOG_DUMMY_PROPERTY
};
void make_color (guint16 red, guint16 green, guint16 blue, GdkColor* result);
void set_bg_color (GtkWidget* w);
const gchar* id_card_get_issuer (IdCard* self);
GtkWidget* make_ta_fingerprint_widget (const gchar* server_cert, const gchar* label_text);
static void trust_anchor_dialog_on_response (TrustAnchorDialog* self, GtkDialog* source, gint response_id);
static void _trust_anchor_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void trust_anchor_dialog_finalize (GObject* obj);


static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 252 "moonshot-trust-anchor-dialog.c"
}


TrustAnchorConfirmationRequest* trust_anchor_confirmation_request_construct (GType object_type, IdentityManagerApp* parent_app, const gchar* userid, const gchar* realm, const gchar* fingerprint) {
	TrustAnchorConfirmationRequest * self = NULL;
	IdentityManagerApp* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (parent_app != NULL, NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (userid != NULL, NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (realm != NULL, NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (fingerprint != NULL, NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self = (TrustAnchorConfirmationRequest*) g_object_new (object_type, NULL);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = parent_app;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1_ = _identity_manager_app_ref0 (_tmp0_);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_identity_manager_app_unref0 (self->priv->parent_app);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->parent_app = _tmp1_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp2_ = userid;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (self->priv->userid);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->userid = _tmp3_;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp4_ = realm;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (self->priv->realm);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->realm = _tmp5_;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp6_ = fingerprint;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (self->priv->fingerprint);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->fingerprint = _tmp7_;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return self;
#line 310 "moonshot-trust-anchor-dialog.c"
}


TrustAnchorConfirmationRequest* trust_anchor_confirmation_request_new (IdentityManagerApp* parent_app, const gchar* userid, const gchar* realm, const gchar* fingerprint) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return trust_anchor_confirmation_request_construct (TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, parent_app, userid, realm, fingerprint);
#line 317 "moonshot-trust-anchor-dialog.c"
}


void trust_anchor_confirmation_request_set_callback (TrustAnchorConfirmationRequest* self, TrustAnchorConfirmationCallback cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	TrustAnchorConfirmationCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = cb;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0__target = cb_target;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	cb = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	cb_target = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	cb_target_destroy_notify = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	(self->priv->callback_target_destroy_notify == NULL) ? NULL : (self->priv->callback_target_destroy_notify (self->priv->callback_target), NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback = _tmp0_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target = _tmp0__target;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target_destroy_notify = _tmp0__target_destroy_notify;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	cb = NULL;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	cb_target = NULL;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	cb_target_destroy_notify = NULL;
#line 361 "moonshot-trust-anchor-dialog.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 373 "moonshot-trust-anchor-dialog.c"
}


gboolean trust_anchor_confirmation_request_execute (TrustAnchorConfirmationRequest* self) {
	gboolean result = FALSE;
	gchar* nai = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	IdCard* card = NULL;
	IdentityManagerApp* _tmp6_ = NULL;
	IdentityManagerModel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	IdentityManagerApp* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	IdCard* _tmp12_ = NULL;
	IdCard* _tmp13_ = NULL;
	gboolean _tmp19_ = FALSE;
	IdCard* _tmp20_ = NULL;
	TrustAnchor* _tmp21_ = NULL;
	TrustAnchor* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	MoonshotLogger* _tmp33_ = NULL;
	IdCard* _tmp34_ = NULL;
	TrustAnchor* _tmp35_ = NULL;
	TrustAnchor* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	IdCard* _tmp42_ = NULL;
	TrustAnchor* _tmp43_ = NULL;
	TrustAnchor* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	IdentityManagerApp* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	TrustAnchorDialog* dialog = NULL;
	IdCard* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	TrustAnchorDialog* _tmp61_ = NULL;
	gint response = 0;
	TrustAnchorDialog* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	TrustAnchorDialog* _tmp64_ = NULL;
	gboolean is_confirmed = FALSE;
	gint _tmp65_ = 0;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp77_ = FALSE;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = self->priv->userid;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1_ = g_strconcat (_tmp0_, "@", NULL);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp2_ = _tmp1_;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp3_ = self->priv->realm;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp5_ = _tmp4_;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp2_);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	nai = _tmp5_;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp6_ = self->priv->parent_app;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp7_ = _tmp6_->model;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp8_ = nai;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp9_ = self->priv->parent_app;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp10_ = identity_manager_app_get_use_flat_file_store (_tmp9_);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp11_ = _tmp10_;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp12_ = identity_manager_model_find_id_card (_tmp7_, _tmp8_, _tmp11_);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	card = _tmp12_;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp13_ = card;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (_tmp13_ == NULL) {
#line 470 "moonshot-trust-anchor-dialog.c"
		MoonshotLogger* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp14_ = trust_anchor_confirmation_request_logger;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp15_ = nai;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp16_ = string_to_string (_tmp15_);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp17_ = g_strconcat ("execute: Could not find ID card for NAI ", _tmp16_, "; returning false.", NULL);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp18_ = _tmp17_;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		moonshot_logger_warn (_tmp14_, _tmp18_, NULL);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp18_);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		trust_anchor_confirmation_request_return_confirmation (self, FALSE);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		result = FALSE;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_object_unref0 (card);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (nai);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		return result;
#line 500 "moonshot-trust-anchor-dialog.c"
	}
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp20_ = card;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp21_ = id_card_get_trust_anchor (_tmp20_);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp22_ = _tmp21_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp23_ = trust_anchor_is_empty (_tmp22_);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (_tmp23_) {
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp19_ = TRUE;
#line 514 "moonshot-trust-anchor-dialog.c"
	} else {
		IdCard* _tmp24_ = NULL;
		TrustAnchor* _tmp25_ = NULL;
		TrustAnchor* _tmp26_ = NULL;
		TrustAnchorTrustAnchorType _tmp27_ = 0;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp24_ = card;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp25_ = id_card_get_trust_anchor (_tmp24_);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp26_ = _tmp25_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp27_ = trust_anchor_get_anchor_type (_tmp26_);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp19_ = _tmp27_ == TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT;
#line 530 "moonshot-trust-anchor-dialog.c"
	}
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (!_tmp19_) {
#line 534 "moonshot-trust-anchor-dialog.c"
		MoonshotLogger* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp28_ = trust_anchor_confirmation_request_logger;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp29_ = nai;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp30_ = string_to_string (_tmp29_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp31_ = g_strconcat ("execute: Trust anchor type for NAI ", _tmp30_, " is not empty or SERVER_CERT; returning true.", NULL);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp32_ = _tmp31_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		moonshot_logger_warn (_tmp28_, _tmp32_, NULL);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp32_);
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		trust_anchor_confirmation_request_return_confirmation (self, TRUE);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		result = FALSE;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_object_unref0 (card);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (nai);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		return result;
#line 564 "moonshot-trust-anchor-dialog.c"
	}
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp33_ = trust_anchor_confirmation_request_logger;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp34_ = card;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp35_ = id_card_get_trust_anchor (_tmp34_);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp36_ = _tmp35_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp37_ = trust_anchor_get_server_cert (_tmp36_);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp38_ = _tmp37_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp39_ = self->priv->fingerprint;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp40_ = g_strdup_printf ("execute: expected cert='%s'; fingerprint='%s'", _tmp38_, _tmp39_);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp41_ = _tmp40_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	moonshot_logger_trace (_tmp33_, _tmp41_, NULL);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp41_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp42_ = card;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp43_ = id_card_get_trust_anchor (_tmp42_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp44_ = _tmp43_;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp45_ = trust_anchor_get_server_cert (_tmp44_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp46_ = _tmp45_;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp47_ = self->priv->fingerprint;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
#line 602 "moonshot-trust-anchor-dialog.c"
		MoonshotLogger* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp48_ = trust_anchor_confirmation_request_logger;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp49_ = nai;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp50_ = string_to_string (_tmp49_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp51_ = g_strconcat ("execute: Fingerprint for ", _tmp50_, " matches stored value; returning true.", NULL);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp52_ = _tmp51_;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		moonshot_logger_trace (_tmp48_, _tmp52_, NULL);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp52_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		trust_anchor_confirmation_request_return_confirmation (self, TRUE);
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		result = FALSE;
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_object_unref0 (card);
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (nai);
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		return result;
#line 632 "moonshot-trust-anchor-dialog.c"
	}
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp53_ = self->priv->parent_app;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp54_ = identity_manager_app_get_headless (_tmp53_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp55_ = _tmp54_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (_tmp55_) {
#line 642 "moonshot-trust-anchor-dialog.c"
		MoonshotLogger* _tmp56_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp56_ = trust_anchor_confirmation_request_logger;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		moonshot_logger_trace (_tmp56_, "execute: Running in headless mode; returning false.", NULL);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		trust_anchor_confirmation_request_return_confirmation (self, FALSE);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		result = FALSE;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_object_unref0 (card);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (nai);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		return result;
#line 658 "moonshot-trust-anchor-dialog.c"
	}
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp57_ = card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp58_ = self->priv->userid;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp59_ = self->priv->realm;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp60_ = self->priv->fingerprint;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp61_ = trust_anchor_dialog_new (_tmp57_, _tmp58_, _tmp59_, _tmp60_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_object_ref_sink (_tmp61_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	dialog = _tmp61_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp62_ = dialog;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp63_ = gtk_dialog_run ((GtkDialog*) _tmp62_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	response = _tmp63_;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp64_ = dialog;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_object_destroy ((GtkObject*) _tmp64_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp65_ = response;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	is_confirmed = _tmp65_ == ((gint) GTK_RESPONSE_OK);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp66_ = is_confirmed;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (_tmp66_) {
#line 692 "moonshot-trust-anchor-dialog.c"
		MoonshotLogger* _tmp67_ = NULL;
		IdCard* _tmp68_ = NULL;
		TrustAnchor* _tmp69_ = NULL;
		TrustAnchor* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		IdentityManagerApp* _tmp72_ = NULL;
		IdentityManagerModel* _tmp73_ = NULL;
		IdCard* _tmp74_ = NULL;
		IdCard* _tmp75_ = NULL;
		IdCard* _tmp76_ = NULL;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp67_ = trust_anchor_confirmation_request_logger;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		moonshot_logger_trace (_tmp67_, "execute: Fingerprint confirmed; updating stored value.", NULL);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp68_ = card;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp69_ = id_card_get_trust_anchor (_tmp68_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp70_ = _tmp69_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp71_ = self->priv->fingerprint;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		trust_anchor_update_server_fingerprint (_tmp70_, _tmp71_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp72_ = self->priv->parent_app;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp73_ = _tmp72_->model;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp74_ = card;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp75_ = identity_manager_model_update_card (_tmp73_, _tmp74_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp76_ = _tmp75_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_object_unref0 (_tmp76_);
#line 729 "moonshot-trust-anchor-dialog.c"
	}
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp77_ = is_confirmed;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_confirmation_request_return_confirmation (self, _tmp77_);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	result = FALSE;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (dialog);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (card);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (nai);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return result;
#line 745 "moonshot-trust-anchor-dialog.c"
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (self) {
#line 753 "moonshot-trust-anchor-dialog.c"
		gchar* _tmp0_ = NULL;
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 761 "moonshot-trust-anchor-dialog.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 770 "moonshot-trust-anchor-dialog.c"
	}
}


static gboolean __lambda21_ (TrustAnchorConfirmationRequest* self) {
	gboolean result = FALSE;
	MoonshotLogger* _tmp0_ = NULL;
	TrustAnchorConfirmationCallback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = trust_anchor_confirmation_request_logger;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	moonshot_logger_trace (_tmp0_, "return_confirmation[Idle handler]: invoking callback", NULL);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1_ = self->priv->callback;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1__target = self->priv->callback_target;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1_ (self, _tmp1__target);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	result = FALSE;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return result;
#line 794 "moonshot-trust-anchor-dialog.c"
}


static gboolean ___lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda21_ ((TrustAnchorConfirmationRequest*) self);
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return result;
#line 803 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_confirmation_request_return_confirmation (TrustAnchorConfirmationRequest* self, gboolean confirmed) {
	TrustAnchorConfirmationCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gboolean _tmp1_ = FALSE;
	MoonshotLogger* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = self->priv->callback;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0__target = self->priv->callback_target;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1_ = confirmed;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->confirmed = _tmp1_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp2_ = trust_anchor_confirmation_request_logger;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp3_ = confirmed;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp4_ = bool_to_string (_tmp3_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp5_ = _tmp4_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp6_ = g_strconcat ("return_confirmation: confirmed=", _tmp5_, NULL);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp7_ = _tmp6_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	moonshot_logger_trace (_tmp2_, _tmp7_, NULL);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp7_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp5_);
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda21__gsource_func, g_object_ref (self), g_object_unref);
#line 849 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_confirmation_request_class_init (TrustAnchorConfirmationRequestClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_confirmation_request_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_type_class_add_private (klass, sizeof (TrustAnchorConfirmationRequestPrivate));
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = trust_anchor_confirmation_request_finalize;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = get_logger ("TrustAnchorConfirmationRequest");
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_confirmation_request_logger = _tmp0_;
#line 865 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_confirmation_request_instance_init (TrustAnchorConfirmationRequest * self) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv = TRUST_ANCHOR_CONFIRMATION_REQUEST_GET_PRIVATE (self);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->confirmed = FALSE;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback = NULL;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target = self;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 880 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_confirmation_request_finalize (GObject* obj) {
	TrustAnchorConfirmationRequest * self;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequest);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_identity_manager_app_unref0 (self->priv->parent_app);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (self->priv->userid);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (self->priv->realm);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (self->priv->fingerprint);
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	(self->priv->callback_target_destroy_notify == NULL) ? NULL : (self->priv->callback_target_destroy_notify (self->priv->callback_target), NULL);
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback = NULL;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target = NULL;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->priv->callback_target_destroy_notify = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	G_OBJECT_CLASS (trust_anchor_confirmation_request_parent_class)->finalize (obj);
#line 906 "moonshot-trust-anchor-dialog.c"
}


GType trust_anchor_confirmation_request_get_type (void) {
	static volatile gsize trust_anchor_confirmation_request_type_id__volatile = 0;
	if (g_once_init_enter (&trust_anchor_confirmation_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrustAnchorConfirmationRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trust_anchor_confirmation_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrustAnchorConfirmationRequest), 0, (GInstanceInitFunc) trust_anchor_confirmation_request_instance_init, NULL };
		GType trust_anchor_confirmation_request_type_id;
		trust_anchor_confirmation_request_type_id = g_type_register_static (G_TYPE_OBJECT, "TrustAnchorConfirmationRequest", &g_define_type_info, 0);
		g_once_init_leave (&trust_anchor_confirmation_request_type_id__volatile, trust_anchor_confirmation_request_type_id);
	}
	return trust_anchor_confirmation_request_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 925 "moonshot-trust-anchor-dialog.c"
}


static void _trust_anchor_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_dialog_on_response ((TrustAnchorDialog*) self, _sender, response_id);
#line 932 "moonshot-trust-anchor-dialog.c"
}


TrustAnchorDialog* trust_anchor_dialog_construct (GType object_type, IdCard* card, const gchar* userid, const gchar* realm, const gchar* fingerprint) {
	TrustAnchorDialog * self = NULL;
	gchar* server_ta_label_text = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkWidget* content_area = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkLabel* dialog_label = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	gchar* label_markup = NULL;
	IdCard* _tmp11_ = NULL;
	TrustAnchor* _tmp12_ = NULL;
	TrustAnchor* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	GtkLabel* user_label = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	GtkLabel* _tmp43_ = NULL;
	GtkLabel* _tmp44_ = NULL;
	GtkLabel* realm_label = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	GtkLabel* _tmp49_ = NULL;
	GtkLabel* _tmp50_ = NULL;
	gchar* confirm_text = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	GtkLabel* confirm_label = NULL;
	GtkLabel* _tmp58_ = NULL;
	GtkWidget* trust_anchor_display = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkWidget* _tmp61_ = NULL;
	GtkVBox* vbox = NULL;
	GtkVBox* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkWidget* _tmp64_ = NULL;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (userid != NULL, NULL);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (realm != NULL, NULL);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_val_if_fail (fingerprint != NULL, NULL);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self = (TrustAnchorDialog*) g_object_new (object_type, NULL);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = _ ("Server's trust anchor certificate (SHA-256 fingerprint):");
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	server_ta_label_text = _tmp1_;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp2_ = _ ("Trust Anchor");
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp2_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	set_bg_color ((GtkWidget*) self);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp3_ = _ ("Cancel");
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp4_ = _ ("Confirm");
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_dialog_add_buttons ((GtkDialog*) self, _tmp3_, GTK_RESPONSE_CANCEL, _tmp4_, GTK_RESPONSE_OK, NULL);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_CANCEL);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp5_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	content_area = _tmp6_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp7_ = content_area;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_box_set_spacing (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_BOX, GtkBox), 12);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp8_ = content_area;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	set_bg_color (_tmp8_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_object_ref_sink (_tmp9_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	dialog_label = _tmp9_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp10_ = dialog_label;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp10_, (gfloat) 0, (gfloat) 0);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp11_ = card;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp12_ = id_card_get_trust_anchor (_tmp11_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp13_ = _tmp12_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp14_ = trust_anchor_get_server_cert (_tmp13_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp15_ = _tmp14_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	if (g_strcmp0 (_tmp15_, "") == 0) {
#line 1062 "moonshot-trust-anchor-dialog.c"
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp16_ = _ ("You are using this identity for the first time with the following trus" \
"t anchor:");
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp17_ = g_strconcat ("<span font-weight='heavy'>", _tmp16_, NULL);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp18_ = _tmp17_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp19_ = g_strconcat (_tmp18_, "</span>", NULL);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (label_markup);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		label_markup = _tmp19_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp18_);
#line 1081 "moonshot-trust-anchor-dialog.c"
	} else {
		const gchar* _tmp20_ = NULL;
		IdCard* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp20_ = _ ("WARNING: The certificate we received for the authentication server for" \
" %s");
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp21_ = card;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp22_ = id_card_get_issuer (_tmp21_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp23_ = _tmp22_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp24_ = g_strdup_printf (_tmp20_, _tmp23_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp25_ = _tmp24_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp26_ = g_strconcat ("<span font-weight='heavy'>", _tmp25_, NULL);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp27_ = _tmp26_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp28_ = _ (" is different than expected.  Either the server certificate has change" \
"d, or an");
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp29_ = g_strconcat (_tmp27_, _tmp28_, NULL);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp30_ = _tmp29_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp31_ = _ (" attack may be underway.  If you proceed to the wrong server, your log" \
"in credentials may be compromised.");
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp33_ = _tmp32_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_tmp34_ = g_strconcat (_tmp33_, "</span>", NULL);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (label_markup);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		label_markup = _tmp34_;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp33_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp30_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp27_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		_g_free0 (_tmp25_);
#line 1140 "moonshot-trust-anchor-dialog.c"
	}
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp35_ = dialog_label;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp36_ = label_markup;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_label_set_markup (_tmp35_, _tmp36_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp37_ = dialog_label;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_label_set_line_wrap (_tmp37_, TRUE);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp38_ = dialog_label;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_label_set_width_chars (_tmp38_, 60);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp39_ = _ ("Username: ");
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp40_ = userid;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp42_ = _tmp41_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp43_ = (GtkLabel*) gtk_label_new (_tmp42_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_object_ref_sink (_tmp43_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp44_ = _tmp43_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp42_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	user_label = _tmp44_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) user_label, (gfloat) 0, 0.5f);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp45_ = _ ("Realm: ");
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp46_ = realm;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp47_ = g_strconcat (_tmp45_, _tmp46_, NULL);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp48_ = _tmp47_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp49_ = (GtkLabel*) gtk_label_new (_tmp48_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_object_ref_sink (_tmp49_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp50_ = _tmp49_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp48_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	realm_label = _tmp50_;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) realm_label, (gfloat) 0, 0.5f);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp51_ = _ ("\n" \
"Please check with your realm administrator for the correct fingerprint");
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp52_ = _ (" for your authentication server.  If it matches the above fingerprint,");
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp54_ = _tmp53_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp55_ = _ (" confirm the change.  If not, then cancel.");
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp56_ = g_strconcat (_tmp54_, _tmp55_, NULL);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp57_ = _tmp56_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (_tmp54_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	confirm_text = _tmp57_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp58_ = (GtkLabel*) gtk_label_new (confirm_text);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_object_ref_sink (_tmp58_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	confirm_label = _tmp58_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) confirm_label, (gfloat) 0, 0.5f);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_label_set_line_wrap (confirm_label, TRUE);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_label_set_width_chars (confirm_label, 60);
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp59_ = fingerprint;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp60_ = server_ta_label_text;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp61_ = make_ta_fingerprint_widget (_tmp59_, _tmp60_);
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_display = _tmp61_;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp62_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_object_ref_sink (_tmp62_);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	vbox = _tmp62_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 6);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp63_ = dialog_label;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _tmp63_, TRUE, TRUE, (guint) 12);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) user_label, TRUE, TRUE, (guint) 2);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) realm_label, TRUE, TRUE, (guint) 2);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, trust_anchor_display, TRUE, TRUE, (guint) 0);
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) confirm_label, TRUE, TRUE, (guint) 12);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp64_ = content_area;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_CONTAINER, GtkContainer), (GtkWidget*) vbox);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _trust_anchor_dialog_on_response_gtk_dialog_response, self, 0);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (vbox);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (trust_anchor_display);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (confirm_label);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (confirm_text);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (realm_label);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (user_label);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (label_markup);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (dialog_label);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_object_unref0 (content_area);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_g_free0 (server_ta_label_text);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return self;
#line 1288 "moonshot-trust-anchor-dialog.c"
}


TrustAnchorDialog* trust_anchor_dialog_new (IdCard* card, const gchar* userid, const gchar* realm, const gchar* fingerprint) {
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	return trust_anchor_dialog_construct (TYPE_TRUST_ANCHOR_DIALOG, card, userid, realm, fingerprint);
#line 1295 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_dialog_on_response (TrustAnchorDialog* self, GtkDialog* source, gint response_id) {
	gint _tmp0_ = 0;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	g_return_if_fail (source != NULL);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	_tmp0_ = response_id;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	switch (_tmp0_) {
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		case GTK_RESPONSE_OK:
#line 1311 "moonshot-trust-anchor-dialog.c"
		{
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
			self->complete = TRUE;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
			break;
#line 1317 "moonshot-trust-anchor-dialog.c"
		}
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		case GTK_RESPONSE_CANCEL:
#line 1321 "moonshot-trust-anchor-dialog.c"
		{
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
			self->complete = TRUE;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
			break;
#line 1327 "moonshot-trust-anchor-dialog.c"
		}
		default:
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
		break;
#line 1332 "moonshot-trust-anchor-dialog.c"
	}
}


static void trust_anchor_dialog_class_init (TrustAnchorDialogClass * klass) {
	GdkColor _tmp0_ = {0};
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_dialog_parent_class = g_type_class_peek_parent (klass);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = trust_anchor_dialog_finalize;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	make_color ((guint16) 65535, (guint16) 65535, (guint16) 65535, &_tmp0_);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	trust_anchor_dialog_white = _tmp0_;
#line 1347 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_dialog_instance_init (TrustAnchorDialog * self) {
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self->complete = FALSE;
#line 1354 "moonshot-trust-anchor-dialog.c"
}


static void trust_anchor_dialog_finalize (GObject* obj) {
	TrustAnchorDialog * self;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRUST_ANCHOR_DIALOG, TrustAnchorDialog);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-trust-anchor-dialog.vala"
	G_OBJECT_CLASS (trust_anchor_dialog_parent_class)->finalize (obj);
#line 1364 "moonshot-trust-anchor-dialog.c"
}


GType trust_anchor_dialog_get_type (void) {
	static volatile gsize trust_anchor_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&trust_anchor_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrustAnchorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trust_anchor_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrustAnchorDialog), 0, (GInstanceInitFunc) trust_anchor_dialog_instance_init, NULL };
		GType trust_anchor_dialog_type_id;
		trust_anchor_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "TrustAnchorDialog", &g_define_type_info, 0);
		g_once_init_leave (&trust_anchor_dialog_type_id__volatile, trust_anchor_dialog_type_id);
	}
	return trust_anchor_dialog_type_id__volatile;
}



