.TH SLOCAL %manext1% 2016-05-02 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
slocal \- asynchronously filter and deliver new mail to nmh
.SH SYNOPSIS
.HP 5
.na
.B %nmhlibexecdir%/slocal
.RB [ \-help ]
.RB [ \-version ]
.RB [ \-addr
.IR address ]
.RB [ \-info
.IR data ]
.RB [ \-sender
.IR sender ]
.RB [ \-user
.IR username ]
.RB [ \-mailbox
.IR mbox ]
.\" \%[\-home\ homedir]
.RB [ \-file
.IR file ]
.RB [ \-maildelivery
.IR deliveryfile ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-suppressdup " | " \-nosuppressdup ]
.RB [ \-debug ]
.ad
.SH DESCRIPTION
.B slocal
is a program designed to allow you to have your inbound
mail processed according to a complex set of selection criteria.
You do not normally invoke
.B slocal
yourself, rather
.B slocal
is invoked on your behalf by your system's Message Transfer Agent
(such as
.BR sendmail )
when the message arrives.
.PP
The message selection criteria used by
.B slocal
is specified in the file
.RI \*(lq .maildelivery \*(rq
in the user's home directory.
You can specify an alternate file with the
.B \-maildelivery
.I file
option.  The syntax of this file is specified below.
.PP
The message delivery address and message sender are determined from
the Message Transfer Agent envelope information, if possible.
Under
.BR sendmail ,
the sender will obtained from the UUCP
\*(lqFrom:\*(rq line, if present.  The user may override these
values with the
.B \-addr
and
.B \-sender
switches.
.PP
The message is normally read from the standard input.  The
.B \-file
switch sets the name of the file from which the message should be
read, instead of reading stdin.  This is useful when debugging a
.RI \*(lq .maildelivery \*(rq
file.
.PP
The
.B \-user
switch tells
.B slocal
the name of the user for
whom it is delivering mail.  It must exist on the local system.  The
.B \-mailbox
switch tells
.B slocal
the name of the user's mail drop file.
.PP
.B slocal
is able to detect and suppress duplicate messages.
To enable this, use the option
.BR \-suppressdup .
.B slocal
will
keep a database containing the Message-ID's of incoming messages,
in order to detect duplicates.  Depending on your configuration,
this database will be in either ndbm or Berkeley db format.
.PP
The
.B \-info
switch may be used to pass an arbitrary argument to
sub-processes which
.B slocal
may invoke on your behalf.
.PP
The
.B \-verbose
switch causes
.B slocal
to give information on
stdout about its progress.  The
.B \-debug
switch produces more
verbose debugging output on stderr.  These flags are useful when
creating and debugging your
.RI \*(lq .maildelivery \*(rq
file, as they
allow you to see the decisions and actions that
.B slocal
is taking, as well as check for syntax errors in your
.RI \*(lq .maildelivery \*(rq
file.
.SS "Message Transfer Agents"
Most modern MTAs including
.BR sendmail ,
.BR postfix
and
.BR exim
support a \&.forward file for directing incoming mail.
You should include the line
.PP
.ce
\*(lq|\ %nmhlibexecdir%/slocal\ \-user\ username\*(rq
.PP
in your \&.forward file in your home directory.  This will cause
your MTA to invoke
.B slocal
on your behalf when a message arrives.
.SS "The Maildelivery File"
The
.RI \*(lq .maildelivery \*(rq
file controls how
.B slocal
filters and delivers
incoming mail.  Each line of this file consists of five fields, separated
by whitespace or comma.  Since double-quotes are honored, these
characters may be included in a single argument by enclosing the entire
argument in double-quotes.  A double-quote can be included by preceding it
with a backslash.  Lines beginning with `#' and blank lines are ignored.
.PP
The format of each line in the
.RI \*(lq .maildelivery \*(rq
file is:
.PP
.RS 5
.B "header	pattern	action	result	string"
.RE
.PP
.BR header :
.RS 5
The name of a header field (such as To, Cc,  or From) that is to
be searched for a pattern.  This is any field in the headers of
the message that might be present.
.PP
The following special fields are also defined:
.TP \w'defaultrrr'u
.I source
the out-of-band sender information
.TP \w'defaultrrr'u
.I addr
the address that was used to cause delivery to the recipient
.TP \w'defaultrrr'u
.I default
this matches
.I only
if the message hasn't been delivered yet
.TP \w'defaultrrr'u
.I *
this always matches
.RE
.PP
.BR pattern :
.RS 5
The sequence of characters to match in the specified header field.
Matching is case-insensitive, but does not use regular expressions.
.RE
.PP
.BR action :
.RS 5
The action to take to deliver the message.  When a message is delivered,
a \*(lqDelivery\-Date:\ date\*(rq header is added which indicates the date
and time that message was delivered.
.TP 4
.I destroy
This action always succeeds.
.TP 4
.IR file ", " mbox ", or " >
Append the message to the file named by
.IR string .
The message is
appended to the file in mbox (uucp) format.  This is the format used by most
other mail clients (such as mailx, elm).  If the message can be appended to
the file, then this action succeeds.
.TP 4
.I mmdf
Identical to
.IR file ,
but always appends the message using the MMDF mailbox format.
.TP 4
.IR pipe " or " |
Pipe the message as the standard input to the command named by
.IR string ,
using the Bourne shell
.B sh
to interpret the string.
Prior to giving the string to the shell, it is expanded with the following
built-in variables:
.RS
.TP \w'zzreplyztozaaa'u
$(sender)
the out-of-band sender information
.TP \w'zzreplyztozaaa'u
$(address)
the address that was used to cause delivery to the recipient
.TP \w'zzreplyztozaaa'u
$(size)
the size of the message in bytes
.TP \w'zzreplyztozaaa'u
$(reply\-to)
either the \*(lqReply\-To:\*(rq or \*(lqFrom:\*(rq field of the message
.TP \w'zzreplyztozaaa'u
$(info)
the out-of-band information specified
.RE
.TP 4
.IR qpipe " or " ^
Similar to
.IR pipe ,
but executes the command
directly, after built-in variable expansion, without assistance from
the shell.  This action can be used to avoid quoting special characters
which your shell might interpret.
.TP 4
.IR folder " or " +
Store the message in the
.B nmh
folder named by
.IR string .
Currently this is handled by piping the message to the
.B nmh
program
.BR rcvstore ,
although this may change in the future.
.RE
.PP
.BR result :
.RS 5
Indicates how the action should be performed:
.TP \w'Azzz'u
.I A
Perform the action.  If the action succeeds, then the message
is considered delivered.
.TP \w'Azzz'u
.I R
Perform the action.  Regardless of the outcome of the action,
the message is not considered delivered.
.TP \w'Azzz'u
.I ?
Perform the action only if the message has not been delivered.
If the action succeeds, then the message is considered delivered.
.TP \w'Azzz'u
.I N
Perform the action only if the message has not been delivered
and the previous action succeeded.  If this action succeeds, then the
message is considered delivered.
.PP
The delivery file is always read completely, so that several matches
can be made and several actions can be taken.
.RE
.SS "Security of Delivery Files"
In order to prevent security problems, the
.RI \*(lq .maildelivery \*(rq
file must be owned either by the user or by root, and must be
writable only by the owner.  If this is not the case, the file is
not read.
.PP
If the
.RI \*(lq .maildelivery \*(rq
file cannot be found, or does not
perform an action which delivers the message, then
.B slocal
will check for a global delivery file at
.IR %nmhetcdir%/maildelivery .
This file is read according to the same rules.  This file must be
owned by root and must be writable only by root.
.PP
If a global delivery file cannot be found or does not perform an
action which delivers the message, then standard delivery to the
user's mail drop is performed.
.SS "Example Delivery File"
To summarize, here's an example delivery file:
.PP
.nf
.ta \w'default  'u +\w'mh-workersxx 'uC +\w'destroy 'uC +\w'result 'u
#
# .maildelivery file for nmh's slocal
#
# Blank lines and lines beginning with a '#' are ignored
#
# FIELD   PATTERN   ACTION  RESULT  STRING
#

# File mail with foobar in the \*(lqTo:\*(rq line into file foobar.log
To        foobar    file    A       foobar.log

# Pipe messages from coleman to the program message-archive
From      coleman   pipe    A       /bin/message-archive

# Anything to the \*(lqnmh-workers\*(rq mailing list is put in
# its own folder, if not filed already
To        nmh-workers  folder ?     nmh-workers

# Anything with Unix in the subject is put into
# the file unix-mail
Subject   unix      file    A       unix-mail

# I don't want to read mail from Steve, so destroy it
From      steve     destroy A       \-

# Put anything not matched yet into mailbox
default   \-        file    ?       mailbox

# always run rcvtty
*         \-        pipe    R       %nmhlibexecdir%/rcvtty
.fi
.SS "Sub-process environment"
When a process is invoked, its environment is: the user/group-ids are
set to recipient's ids; the working directory is the recipient's home
directory; the umask is 0077; the process has no /dev/tty; the standard
input is set to the message; the standard output and diagnostic output are
set to /dev/null; all other file-descriptors are closed; the environment
variables
.BR $USER ,
.BR $HOME ,
.B $SHELL
are set appropriately, and no other environment variables exist.
.PP
The process is given a certain amount of time to execute.  If the process
does not exit within this limit, the process will be terminated with
extreme prejudice.  The amount of time is calculated as ((size / 60) +
300) seconds, where size is the number of bytes in the message (with
30 minutes the maximum time allowed).
.PP
The exit status of the process is consulted in determining the success
of the action.  An exit status of zero means that the action succeeded.
Any other exit status (or abnormal termination) means that the action
failed.
.PP
In order to avoid any time limitations, you might implement a process
that began by
.IR fork ()-ing.
The parent would return the appropriate
value immediately, and the child could continue on, doing whatever it
wanted for as long as it wanted.  This approach is somewhat risky if
the parent is going to return an exit status of zero.  If the parent is
going to return a non-zero exit status, then this approach can lead to
quicker delivery into your mail drop.
.SH FILES
.fc ^ ~
.nf
.ta \w'%nmhetcdir%/ExtraBigFileName  'u
^%nmhetcdir%/mts.conf~^nmh mts configuration file
^$HOME/.maildelivery~^The file controlling local delivery
^%nmhetcdir%/maildelivery~^Rather than the standard file
^%mailspool%/$USER~^The default mail drop
.fi
.SH "SEE ALSO"
.IR rcvdist (1),
.IR rcvpack (1),
.IR rcvstore (1),
.IR rcvtty (1),
.IR mh\-format (5)
.SH DEFAULTS
.nf
.RB ` \-noverbose '
.RB ` \-nosuppressdup '
.RB ` \-maildelivery "' defaults to $HOME/.maildelivery"
.RB ` \-mailbox "' defaults to %mailspool%/$USER"
.RB ` \-file "' defaults to stdin"
.RB ` \-addr "' defaults to the current user"
.RB ` \-user "' defaults to the current user"
.fi
.PP
.B \-addr
and
.B \-user
will be set the the user part of the Local-Mailbox profile entry, if set.
.SH CONTEXT
None
.SH HISTORY
.B slocal
was originally designed to be backward-compatible with
the
.B maildelivery
facility provided by
.BR MMDF-II .
Thus, the
.RI \*(lq .maildelivery \*(rq
file syntax is somewhat limited.  But
.B slocal
has been modified and extended, so that is it no longer compatible with
.BR MMDF-II .
.PP
In addition to an exit status of zero, the
.B MMDF
values
.B RP_MOK
(32) and
.B RP_OK
(9) mean that the message has been fully delivered.
Any other non-zero exit status, including abnormal termination, is
interpreted as the
.B MMDF
value
.B RP_MECH
(200), which means
\*(lquse an alternate route\*(rq (deliver the message to the mail drop).
.SH BUGS
Only two return codes are meaningful, others should be.
.PP
.B slocal
was originally designed to be backwards-compatible with the
.B maildelivery
functionality provided by
.BR MMDF-II .
