.TH DIST %manext1% 2022-12-22 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
dist \- distribute an nmh message to additional addresses
.SH SYNOPSIS
.HP 5
.na
.B dist
.RB [ \-help ]
.RB [ \-version ]
.RI [ +folder ]
.RI [ msg ]
.RB [ \-form
.IR formfile ]
.RB [ \-annotate " | " \-noannotate ]
.RB [ \-inplace " | " \-noinplace ]
.RB [ \-draftfolder
.IR +folder ]
.RB [ \-draftmessage
.IR msg ]
.RB [ \-nodraftfolder ]
.RB [ \-editor
.IR editor ]
.RB [ \-noedit ]
.RB [ \-width
.IR columns ]
.RB [ \-from
.IR address ]
.RB [ \-to
.IR address ]
.RB [ \-cc
.IR address ]
.RB [ \-fcc
.IR +folder ]
.RB [ \-whatnowproc
.IR program ]
.RB [ \-nowhatnowproc ]
.RB [ \-atfile ]
.RB [ \-noatfile ]
.ad
.SH DESCRIPTION
.B dist
is similar to
.BR forw .
It prepares the specified message
for redistribution to addresses that (presumably) are not on the original
address list.
.PP
The default message form contains the following elements:
.PP
.RS 5
.nf
Resent-From: {from switch} or <Local-Mailbox> or <username@hostname>
Resent-To: {to switch} or blank
Resent-cc: {cc switch} or blank
Resent-fcc: {fcc switch} or blank
.fi
.RE
.PP
If a file named
.RI \*(lq distcomps \*(rq
exists in the user's nmh directory, it
will be used instead of this default form.  You may specify an alternate
forms file with the switch
.B \-form
.IR formfile .
Forms are processed via the
.B nmh
template system; see
.IR mh\-format (5)
for details.  Components from the redistributed message are available
as standard component escapes in the forms file.
.PP
In addition to the standard
.IR mh\-format (5)
escapes, the following
.I component
escapes are also supported:
.PP
.RS 5
.nf
.ta \w'Escape	'u +\w'Returns	'u
.I "Escape	Returns	Description"
fcc	string	Any folders specified with `\-fcc\ folder'
nmh\-from	string	Addresses specified with `\-from\ address'
nmh\-to	string	Addresses specified with `\-to\ address'
nmh\-cc	string	Addresses specified with `\-cc\ address'
.fi
.RE
.PP
See
.IR forw (1)
for descriptions of the
.BR \-from ,
.BR \-to ,
.BR \-cc ,
and
.B \-fcc
switches.
.PP
If the draft already exists,
.B dist
will ask you as to the disposition of the draft.  A reply of
.B quit
will abort
.BR dist ,
leaving the draft intact;
.B replace
will replace the existing draft with a blank skeleton; and
.B list
will display the draft.
.PP
Only those addresses in
.RI \*(lq Resent\-To: \*(rq,
.RI \*(lq Resent\-cc: \*(rq,
and
.RI \*(lq Resent\-Bcc: \*(rq
will be sent.  Also, a
.RI \*(lq "Resent\-Fcc: folder" \*(rq
will be honored (see
.IR send (1)).
Note that with
.BR dist ,
the draft should contain only
.RI \*(lq Resent\-xxx: \*(rq
fields and no body.  The headers and the body of
the original message are copied to the draft when the message is sent.
Use care in constructing the headers for the redistribution.
.PP
Because the draft is minimal, the
.IR prompter (1)
editor is quite useful with
.BR dist .
.PP
If the
.B \-annotate
switch is given, the  message being distributed will
be annotated with the lines:
.RS
Resent:\ date
.br
Resent:\ addrs
.RE
where each address list contains as many lines as required.  This
annotation will be done only if the message is sent directly from
.BR dist .
If the message is not sent immediately from
.BR dist ,
.RB \*(lq comp
.BR \-use \*(rq
may be used to re-edit and send the constructed
message, but the annotations won't take place.  Normally annotations are
done in place in order to preserve any links to the message.  You may use
the
.B \-noinplace
switch to change this.
.PP
See
.IR comp (1)
for a description of the
.B \-editor
and
.B \-noedit
switches.  Note that while in the editor, with
.B \-atfile
and if the current directory is writable, the message being resent
is available through a link named \*(lq@\*(rq (assuming the default
.IR whatnowproc ).
In addition, the actual pathname of the message is
stored in the environment variable
.BR $editalt ,
and the pathname of
the folder containing the message is stored in the environment variable
.BR $mhfolder .
The creation of the \*(lq@\*(rq file is controlled via the
.B \-atfile
and
.B \-noatfile
options.
.PP
The
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
switches invoke the
.B nmh
draft folder facility.  This is an advanced (and highly
useful) feature.  Consult
.IR mh-draft (5)
for more information.
.PP
Upon exiting from the editor,
.B dist
will invoke the
.B whatnow
program.  See
.IR whatnow (1)
for a discussion of available options.  The invocation of this
program can be inhibited by using the
.B \-nowhatnowproc
switch.  (In fact, it is the
.B whatnow
program which starts the initial edit.  Hence,
.B \-nowhatnowproc
will prevent any edit from occurring.)
.SH FILES
.PD 0
.TP 20
%nmhetcdir%/distcomps
The default message skeleton.
.TP 20
<mh-dir>/distcomps
The user's message skeleton.
.TP 20
$HOME/.mh_profile
The user's profile.
.TP 20
<mh-dir>/draft
The draft file.
.PD
.SH "PROFILE COMPONENTS"
.PD 0
.TP 20
Path:
To determine the user's nmh directory.
.TP 20
Current\-Folder:
To find the default current folder.
.TP 20
Draft\-Folder:
To specify the default draftfolder.
.TP 20
Editor:
To override the default editor.
.TP 20
fileproc:
Program to refile the message.
.TP 20
whatnowproc:
Program to ask the \*(lqWhat now?\*(rq questions.
.PD
.SH "SEE ALSO"
.IR comp (1),
.IR forw (1),
.IR mh\-draft (5),
.IR prompter (1),
.IR repl (1),
.IR send (1),
.IR whatnow (1)
.SH DEFAULTS
.PD 0
.TP 20
+folder
The current folder.
.TP 20
msg
The current message.
.TP 20
\-noannotate
.TP 20
\-nodraftfolder
.TP 20
\-inplace
.TP 20
\-noatfile
.PD
.SH CONTEXT
If a folder is given, it will become the current folder.  The message
distributed will become the current message.
.SH HISTORY
.B dist
originally used headers of the form
.RI \*(lq Distribute\-xxx: \*(rq
instead of
.RI \*(lq Resent\-xxx: \*(rq.
In order to conform with the ARPA Internet standard, RFC 822, the
.RI \*(lq Resent\-xxx: \*(rq
form is now used.
.B dist
will recognize
.RI \*(lq Distribute\-xxx: \*(rq
type headers and automatically convert them to
.RI \*(lq Resent\-xxx: \*(rq.
.SH BUGS
.B dist
does not rigorously check the message being distributed
for adherence to the transport standard, but
.B post
called by
.B send
does.  The
.B post
program will balk (and rightly so) at poorly formatted messages, and
.B dist
won't correct things for you.
.PP
If
.I whatnowproc
is
.BR whatnow ,
then
.B comp
uses a built-in
.BR whatnow ,
it does not actually run the
.B whatnow
program.
Hence, if you define your own
.IR whatnowproc ,
don't call it
.B whatnow
since
.B comp
won't run it.
