/* OpenCP Module Player
 * copyright (c) '94-'10 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * VGA fonts for graphic mode screen output
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    -patched in the analyser characters, so wo don't need to track fonts all
 *     the time.
 */

#include "config.h"
#include "types.h"
#include "pfonts.h"

#if 0
Hextable:
.... 0
...X 1
..X. 2
..XX 3
.X.. 4
.X.X 5
.XX. 6
.XXX 7
X... 8
X..X 9
X.X. a
X.XX b
XX.. c
XX.X d
XXX. e
XXXX f

6x6 font, each line will be a byte
HHLLLL  0xHL
.....X  0x01
.X....  0x10
XX....  0x30
X.XX.X  0x2d

I have done the very first characters

unsigned char plFont66[256][4]=
{
  {0x00, 0x00, 0x00, 0x00},
  /*
  ......
  ......
  ......
  ......
  ......
  ......

  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x1e, 0x21, 0x33, 0x21, 0x2d, 0x1e},
  /*
  .XXXX.
  X....X
  XX..XX
  X....X
  X.XX.X
  .XXXX.
  .XXXXXX.
  X......X
  X.X..X.X
  X......X
  X.XXXX.X
  X..XX..X
  X......X
  .XXXXXX.
  */
  {0x21, 0x1e, 0x0c, 0x1e, 0x12, 0x21},
  /*
  X....X
  .XXXX.
  ..XX..
  .XXXX.
  .X..X.
  X.....X

  .XXXXXX.
  XXXXXXXX
  XX.XX.XX
  XXXXXXXX
  XX....XX
  XXX..XXX
  XXXXXXXX
  .XXXXXX.
  */
  {0x00, 0x14, 0x3e, 0x1c, 0x08, 0x00},
  /*
  ......
  .X.X..
  XXXXX.
  .XXX..
  ..X...
  ......
  .XX.XX..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ..XXX...
  .XXXXX..
  ..XXX...
  XXXXXXX.
  .XXXXX..
  ..XXX...
  .XXXXX..
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...X....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  ..XXX...
  .XXXXX..
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ...XX...
  ..XXXX..
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0xf9, 0x9f},
  /*
  XXXX
  X..X
  X..X
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXX..XXX
  XX....XX
  XX....XX
  XXX..XXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ..XXXX..
  .XX..XX.
  .X....X.
  .X....X.
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XXXXXXXX
  XX....XX
  X..XX..X
  X.XXXX.X
  X.XXXX.X
  X..XX..X
  XX....XX
  XXXXXXXX
  */
  {0x3e, 0xae},
  /*
  ..XX
  XXX.
  X.X.
  XXX.
  ....XXXX
  .....XXX
  ....XXXX
  .XXXXX.X
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xea, 0x4e},
  /*
  XXX.
  X.X.
  .X..
  XXX.
  ..XXXX..
  .XX..XX.
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  .XXXXXX.
  ...XX...
  */
  {0x3c, 0xc0},
  /*
  ..XX
  XX..
  XX..
  ....
  ..XXXXXX
  ..XX..XX
  ..XXXXXX
  ..XX....
  ..XX....
  .XXX....
  XXXX....
  XXX.....
  */
  {0x75, 0xd0},
  /*
  .XXX
  .X.X
  XX.X
  ....
  .XXXXXXX
  .XX...XX
  .XXXXXXX
  .XX...XX
  .XX...XX
  .XX..XXX
  XXX..XX.
  XX......
  */
  {0x96, 0x90},
  /*
  X..X
  .XX.
  X..X
  ....
  X..XX..X
  .X.XX.X.
  ..XXXX..
  XXX..XXX
  ..XXXX..
  .X.XX.X.
  X..XX..X
  */
  {0x8e, 0x80},
  /*
  X...
  XXX.
  X...
  ....
  X.......
  XXX.....
  XXXXX...
  XXXXXXX.
  XXXXX...
  XXX.....
  X.......
  ........
  */
  {0x2e, 0x20},
  /*
  ..X.
  XXX.
  ..X.
  ....
  ......X.
  ....XXX.
  ..XXXXX.
  XXXXXXX.
  ..XXXXX.
  ....XXX.
  ......X.
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  */
  {0xaa, 0x0a},
  /*
  X.X.
  X.X.
  ....
  X.X.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  ........
  .xx..xx.
  ........
  */
  {0x6a, 0x62},
  /*
  .XX.
  X.X.
  .XX.
  ..X.
  .XXXXXXX
  XX.XX.XX
  XX.XX.XX
  .XXXXX.X
  ...XXX.X
  ...XXX.X
  ...XXX.X
  ........
  */
  {0x6c, 0x36},
  /*
  .XX.
  XX..
  ..XX
  .XX.
  ..XXXXX.
  .X.X..XX
  ..XXX...
  .X.XXX..
  .X.XXX..
  ..XXX...
  XX..XX..
  .XXXX...
  */
  {0x00, 0x60},
  /*
  ....
  ....
  .XX.
  ....
  ........
  ........
  ........
  ........
  .XXXXXX.
  .XXXXXX.
  .XXXXXX.
  ........
  */
  {0x4e, 0x4e},
  /*
  .X..
  XXX.
  .X..
  XXX.
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  */
  {0x4e, 0x44},
  /*
  .X..
  XXX.
  .X..
  .X..
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x44, 0xe4},
  /*
  .X..
  .X..
  XXX.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  */
  {0x2f, 0x20},
  /*
  ..X.
  XXXX
  ..X.
  ....
  ........
  ...XX...
  ....XX..
  XXXXXXX.
  ....XX..
  ...XX...
  ........
  ........
  */
  {0x4f, 0x40},
  /*
  .X..
  XXXX
  .X..
  ....
  ........
  ..XX....
  .XX.....
  XXXXXXX.
  .XX.....
  ..XX....
  ........
  ........
  */
  {0x04, 0x60},
  /*
  ....
  .X..
  .XX.
  ....
  ........
  ........
  XX......
  XX......
  XX......
  XXXXXXX.
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  ........
  ..X..X..
  .XX..XX.
  XXXXXXXX
  .XX.XX.
  ..X..X..
  ........
  ........
  */
  {0x4e, 0x00},
  /*
  .X..
  XXX.
  ....
  ....
  ........
  ...XX...
  ..XXXX..
  .XXXXXX.
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  ........
  XXXXXXXX
  XXXXXXXX
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {044, 0x04},
  /*
  .X..
  .X..
  ....
  .X..
  ..XX....
  .XXXX...
  .XXXX...
  ..XX....
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x60, 0x00},
  /*
  .XX.
  ....
  ....
  ....
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0x6c, 0x6e},
  /*
  .XX.
  XX..
  .XX.
  XXX.
  ..XX....
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ..XX....
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  ........
  XX...XX.
  XX..XX..
  ...XX...
  ..XX....
  .XX..XX.
  XX...XX.
  ........
  */
  {0x6d, 0xa5},
  /*
  .XX.
  XX.X
  X.X.
  .X.X
  ..XXX...
  .XX.XX..
  ..XXX...
  .XXX.XX.
  XX.XXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  .XX.....
  .XX.....
  XX......
  ........
  ........
  ........
  ........
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  .XX.....
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ...XX...
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  .XX..XX.
  ..XXXX..
  XXXXXXXX
  ..XXXX..
  .XX..XX.
  ........
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  ........
  */
  {0x00, 0x24},
  /*
  ....
  ....
  ..X.
  .X..
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x0e, 0x00},
  /*
  ....
  XXX.
  ....
  ....
  ........
  ........
  ........
  XXXXXX..
  ........
  ........
  ........
  ........
  */
  {0x00, 0x66},
  /*
  ....
  ....
  .XX.
  .XX.
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x12, 0x48},
  /*
  ...X
  ..X.
  .X..
  X...
  .....XX.
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  XX......
  X.......
  ........
  */
  {0x69, 0x96},
  /*
  .XX.
  X..X
  X..X
  .XX.
  .XXXXX..
  XX...XX.
  XX..XXX.
  XX.XXXX.
  XXXX.XX.
  XXX..XX.
  .XXXXX..
  ........
  */
  {0xc4, 0x4e},
  /*
  XX..
  .X..
  .X..
  XXX.
  ..XX....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  XXXXXX..
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.

  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0xe6, 0x2e},
  /*
  XXX.
  .XX.
  ..X.
  XXX.
  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x6a, 0xe2},
  /*
  .XX.
  X.X.
  XXX.
  ..X.
  ...XXX..
  ..XXXX..
  .XX.XX..
  XX..XX..
  XXXXXXX.
  ....XX..
  ...XXXX.
  ........
  */
  {0xec, 0x2e},
  /*
  XXX.
  XX..
  ..X.
  XXX.
  XXXXXX..
  XX......
  XXXXX...
  ....XX..
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x24, 0xae},
  /*
  ..X.
  .X..
  X.X.
  XXX.
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xf2, 0x44},
  /*
  XXXX
  ..X.
  .X..
  .X..
  XXXXXX..
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ..XX....
  ..XX....
  ........
  */
  {0x66, 0x96},
  /*
  .XX.
  .XX.
  X..X
  .XX.
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xea, 0x6c},
  /*
  XXX.
  X.X.
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XX...
  .XXX....
  ........
  */
  {0x40, 0x40},
  /*
  .X..
  ....
  .X..
  ....
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x40, 0x48},
  /*
  .X..
  ....
  .X..
  X...
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x28, 0x20},
  /*
  ..X.
  X...
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  XX......
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  ........
  XXXXXX..
  ........
  ........
  XXXXXX..
  ........
  ........
  */
  {0x82, 0x80},
  /*
  X...
  ..X.
  X...
  ....
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xe2, 0x04},
  /*
  XXX.
  ..X.
  ....
  .X..
  .XXXX...
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x7b, 0x86},
  /*
  .XXX
  X.XX
  X...
  .XX.
  .XXXXX..
  XX...XX.
  XX.XXXX.
  XX.XXXX.
  XX.XXXX.
  XX......
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XXXXXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX......
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  XXXXX...
  .XX.XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX.XX..
  XXXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX...X.
  XXXXXXX.
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX..XXX.
  .XX..XX.
  ..XXXXX.
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXX...
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XXXX.
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX..XX.
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  XXXX....
  .XX.....
  .XX.....
  .XX.....
  .XX...X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  XX...XX.
  XXX.XXX.
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XX...XX.
  XXX..XX.
  XXXX.XX.
  XX.XXXX.
  XX..XXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX.XXX..
  .XXXX...
  ...XXX..
  ........
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  .XXXX...
  XX..XX..
  XXX.....
  .XXX
  ...XXX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  XXXXXX..
  X.XX.X..
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  XX...XX.
  XX...XX.
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXX.XXX.
  XX...XX.
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XX...XX.
  XX...XX.
  .XX.XX.
  ..XXX...
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  XXXXXXX.
  XX...XX.
  X...XX..
  ...XX...
  ..XX..X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0x64, 0x60},
  /*
  .XX.
  .X..
  .XX.
  ....
  .XXXX...
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XXXX...
  ........
  */
  {0x84, 0x21},
  /*
  X...
  .X..
  ..X.
  ...X
  XX......
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  .....XX.
  ......X.
  ........
  */
  {0x62, 0x60},
  /*
  .XX.
  ..X.
  .XX.
  ....
  .XXXX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXX...
  ........
  */
  {0x4a, 0x00},
  /*
  .X..
  X.X.
  ....
  ....
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  ........
  ........
  ........
  */
  {0x00, 0x0f},
  /*
  ....
  ....
  ....
  XXXX
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXXX
  */
  {0x84, 0x00},
  /*
  X...
  .X..
  ....
  ....
  ..XX....
  ..XX....
  ...XX...
  ........
  ........
  ........
  ........
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ........
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXX.....
  .XX.....
  .XX.....
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XX.XXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  ...XXX..
  ....XX..
  ....XX..
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  ..XXX...
  .XX.XX..
  .XX.....
  XXXX....
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XXX.....
  .XX.....
  .XX.XX..
  .XXX.XX.
  .XX..XX.
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XX....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ....XX..
  ........
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX.....
  .XX.....
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  ........
  ........
  XX..XX..
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  ........
  ........
  XX.XXX..
  .XX..XX.
  .XXXXX..
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XXXX.
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  ........
  ........
  XX.XXX..
  .XXX.XX.
  .XX..XX.
  .XX.....
  XXXX....
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  ........
  ........
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  ...X....
  ..XX....
  .XXXXX..
  ..XX....
  ..XX....
  ..XX.X..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  ........
  ........
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  ........
  XX...XX.
  .XX.XX..
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  ........
  ........
  XXXXXX..
  X..XX...
  ..XX....
  .XX..X..
  XXXXXX..
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX.
  .XX.
  ....
  ...XXX...
  ..XX....
  ..XX....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ........
  */
  {0x22, 0x20},
  /*
  ..X.
  ..X.
  ..X.
  ....
  ...XX....
  ...XX....
  ...XX....
  .........
  ...XX....
  ...XX....
  ...XX....
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ..XX....
  ..XX....
  XXX.....
  ........
  */
  {0x5a, 0x00},
  /*
  .X.X
  X.X.
  ....
  ....
  .XXX.XX.
  XX.XXX..
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x4a, 0xe0},
  /*
  .X..
  X.X.
  XXX.
  ....
  ........
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XXXXXXX.
  ........
  */
  {0x68, 0x6c},
  /*
  .XX.
  X...
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ...XX...
  ....XX..
  .XXXX...
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXXX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .....XX.
  ..XXXXX.
  .XX..XX.
  ..XXXXXX
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX..XX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XXX.....
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x68, 0x64},
  /*
  .XX.
  X...
  .XX.
  .X..
  ........
  ........
  .XXXX...
  XX......
  XX......
  .XXXX...
  ....XX..
  ..XXX...
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .XX..XX.
  .XXXXXX.
  .XX.....
  ..XXXX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XX..XX..
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXXX..
  XX...XX.
  ..XXX...
  ...XX...
  ...XX...
  ...XX...
  ..XXXX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XXX.....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX...XX.
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX..XX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  XXXXXX..
  .XX.....
  .XXXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0x2e, 0xe0},
  /*
  ..X.
  XXX.
  XXX.
  ....
  ........
  ........
  .XXXXXXX
  ....XX..
  .XXXXXXX
  XX..XX..
  .XXXXXXX
  ........
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XXXXX.
  .XX.XX..
  XX..XX..
  XXXXXXX.
  XX..XX..
  XX..XX..
  XX..XXX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  .XXXX...
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  .XXXX...
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XXX.....
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  XX....XX
  ...XX...
  ..XXXX..
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x68, 0x66},
  /*
  .XX.
  X...
  .XX.
  .XX.
  ...XX...
  ...XX...
  .XXXXXX.
  XX......
  XX......
  .XXXXXX.
  ...XX...
  ...XX...
  */
  {0xc8, 0xe0},
  /*
  XX..
  X...
  XXX.
  ....
  ..XXX...
  .XX.XX..
  .XX..X..
  XXXX....
  .XX.....
  XXX..XX.
  XXXXXX..
  ........
  */
  {0xa4, 0xe4},
  /*
  X.X.
  .X..
  XXX.
  .X..
  XX..XX..
  XX..XX..
  .XXXX...
  XXXXXX..
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  */
  {0xea, 0xea},
  /*
  XXX.
  X.X.
  XXX.
  X.X.
  XXXXX...
  XX..XX..
  XX..XX..
  XXXXX.X.
  XX...XX.
  XX..XXXX
  XX...XX.
  XX...XXX
  */
  {0x64, 0x4c},
  /*
  .XX.
  .X..
  .X..
  XX..
  ....XXX.
  ...XX.XX
  ...XX...
  ..XXXX..
  ...XX...
  ...XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...XXX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XXX...
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ...XXX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  XXXXX...
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XXXXXX..
  ........
  XX..XX..
  XXX.XX..
  XXXXXX..
  XX.XXX..
  XX..XX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XXXX..
  .XX.XX..
  .XX.XX..
  ..XXXXX.
  ........
  .XXXXXX.
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  .XXXXX..
  ........
  ........
  */
  {0x40, 0x8e},
  /*
  .X..
  ....
  X...
  XXX.
  ..XX....
  ........
  ..XX....
  .XX.....
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0x0c, 0x80},
  /*
  ....
  XX..
  X...
  ....
  ........
  ........
  ........
  XXXXXX..
  XX......
  XX......
  ........
  ........
  */
  {0x0c, 0x40},
  /*
  ....
  XX..
  .X..
  ....
  ........
  ........
  ........
  XXXXXX..
  ....XX..
  ....XX..
  ........
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/2
  XX...XX.
  XX..XX..
  XX.XXXX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ....XXXX
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/4
  XX...XX.
  XX..XX..
  XX.XX.XX
  ..XX.XXX
  .XX.XXXX
  XX..XXXX
  ......XX
  */
  {0x20, 0x22},
  /*
  ..X.
  ....
  ..X.
  ..X.
  ...XX...
  ...XX...
  ........
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ..XX..XX.
  .XX..XX.
  XX..XX..
  .XX..XX.
  ..XX..XX.
  .........
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  ........
  XX..XX..
  .XX..XX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ........
  ........
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  */
  {0x44, 0x44},
  /*
  .X..
  .X..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x44},
  /*
  .X..
  XX..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
*/
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  ........
  ........
  XXXXXXX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x6e, 0xe6},
  /*
  .XX.
  XXX.
  XXX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x66, 0x66},
  /*
  .XX.
  .XX.
  .XX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0e, 0xe6},
  /*
  ....
  XXX.
  XXX.
  .XX.
  ........
  ........
  XXXXXXX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXXXXX.
  ........
  ........
  ........
  */
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXX.
  ........
  ........
  ........
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
  {0x0c, 0x44},
  /*
  ....
  XX..
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x00},
  /*
  .X..
  .XXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x00},
  /*
  .X..
  XXXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0x44},
  /*
  ....
  XXXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x44},
  /*
  .X..
  .XXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x0f, 0x00},
  /*
  ....
  XXXX
  ....
  ....
  ........
  ........
  ........
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x44},
  /*
  .X..
  XXXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x67, 0x70},
  /*
  .XX.
  .XXX
  .XXX
  ....
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XXXXXX
  ........
  ........
  ........
  */
  {0x07, 0x76},
  /*
  ....
  .XXX
  .XXX
  .XX.
  ........
  ........
  ..XXXXXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6f, 0xf0},
  /*
  .XX.
  XXXX
  XXXX
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0xf6},
  /*
  ....
  XXXX
  XXXX
  .XX.
  ........
  ........
  XXXXXXXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x67, 0x76},
  /*
  .XX.
  .XXX
  .XXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0f, 0xf0},
  /*
  ....
  XXXX
  XXXX
  ....
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  XXXXXXXX.
  .........
  .........
  .........
  .........
  .........
  .........
  .........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ........
  ........
  */
  {0xe0, 0x00},
  /*
  XXX.
  ....
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  ........
  ........
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0x00},
  /*
  XXX.
  XXX.
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XXXXXX
  ........
  ........
  ........
  */
  {0xee, 0x40},
  /*
  XXX.
  XXX.
  .X..
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  org
  ........
  ........
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xee, 0xe4},
  /*
  XXX.
  XXX.
  XXX.
  .X..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  org
  ........
  ........
  ........
  ........
  ..XXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0xee},
  /*
  XXX.
  XXX.
  XXX.
  XXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x4f, 0xf4},
  /*
  .X..
  XXXX
  XXXX
  .X..
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x00},
  /*
  .X..
  XX..
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
  {0x07, 0x44},
  /*
  ....
  .XXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xff, 0xff},
  /*
  XXXX
  XXXX
  XXXX
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x00, 0xff},
  /*
  ....
  ....
  XXXX
  XXXX
  ........
  ........
  ........
  ........
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0xcc, 0xcc},
  /*
  XX..
  XX..
  XX..
  XX..
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  */
  {0x33, 0x33},
  /*
  ..XX
  ..XX
  ..XX
  ..XX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  */
  {0xff, 0x00},
  /*
  XXXX
  XXXX
  ....
  ....
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  ........
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX.XXX..
  XX..X...
  XX.XXX..
  .XXX.XX.
  ........
  */
  {0xee, 0xa0},
  /*
  XXX.
  XXX.
  X.X.
  ....
  .XXXX... German double S
  XX..XX..
  XX..XX..
  XX.XX...
  XX..XX..
  XX...XX.
  XX...XX.
  ........
  */
  {0xea, 0x80},
  /*
  XXX.
  X.X.
  X...
  ....
  XXXXXX..
  XX..XX..
  XX......
  XX......
  XX......
  XX......
  XX......
  ........
  */
  {0xec, 0xc0},
  /*
  XXX.
  XX..
  XX..
  ....
  ........ PI
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  */
  {0xe8, 0xe0},
  /*
  XXX.
  X...
  XXX.
  ....
  XXXXXX..
  XX..XX..
  .XX.....
  ..XX....
  .XX.....
  XX..XX..
  XXXXXX...
  .........
  */
  {0x6a, 0x40},
  /*
  .XX.
  X.X.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX...
  XX.XX...
  XX.XX...
  .XXX....
  ........
  */
  {0xaa, 0xe8},
  /*
  X.X.
  X.X.
  XXX.
  X...
  ........
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  XX......
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ........I + tilda
  .XXX.XX.
  XX.XXX..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0xe4, 0x4e},
  /*
  XXX.
  .X..
  .X..
  XXX.
  XXXXXX..
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  XXXXXX...
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0x4a, 0xa0},
  /*
  .X..
  X.X.
  X.X.
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  .XX.XX..
  .XX.XX..
  XXX.XXX.
  ........
  */
  {0x64, 0xa4},
  /*
  .XX.
  .X..
  X.X.
  .X..
  ...XXX..
  ..XX....
  ...XX...
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  ........
  ........
  */
  {0x6e, 0xc0},
  /*
  .XX.
  XXX.
  XX..
  ....
  .....XX.
  ....XX..
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  .XX.....
  XX......
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX......
  .XX.....
  ..XXX...
  .........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  ........
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  ....
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ..XX....
  .XX.....
  ........
  XXXXXX..
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  ..XX....
  ...XX...
  ........
  XXXXXX..
  ........
  */
  {0x2a, 0x44},
  /*
  ..X.
  .X.X.
  .X...
  .X...
  ....XXX.
  ...XX.XX
  ...XX.XX
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XX.XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  ..XX....
  ..XX....
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  .XXX.XX.
  XX.XXX..
  ........
  .XXX.XX.
  XX.XXX..
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ...XX...
  ...XX...
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ........
  ...XX...
  ........
  ........
  ........
  */
  {0x32, 0xa6},
  /*
  ..XX
  ..X.
  X.X.
  .XX.
  ....XXXX
  ....XX..
  ....XX..
  ....XX..
  XXX.XX..
  .XX.XX..
  ..XXXX..
  ...XXX..
  */
  {0xea, 0x00},
  /*
  XXX.
  X.X.
  ....
  ....
  .XXXX...
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.
  .XXX....
  ...XX...
  ..XX....
  .XX.....
  .XXXX...
  ........
  ........
  ........
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ........
  ........
  */
  {0x00, 0x00}
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
};

#endif

































































































unsigned char plFont44[256][2]=
{
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  .XXXXXX.
  X......X
  X.X..X.X
  X......X
  X.XXXX.X
  X..XX..X
  X......X
  .XXXXXX.
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  .XXXXXX.
  XXXXXXXX
  XX.XX.XX
  XXXXXXXX
  XX....XX
  XXX..XXX
  XXXXXXXX
  .XXXXXX.
  */
  {0xae, 0x40},
  /*
  X.X.
  XXX.
  .X..
  ....
  .XX.XX..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ..XXX...
  .XXXXX..
  ..XXX...
  XXXXXXX.
  .XXXXX..
  ..XXX...
  .XXXXX..
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...X....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  ..XXX...
  .XXXXX..
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ...XX...
  ..XXXX..
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0xf9, 0x9f},
  /*
  XXXX
  X..X
  X..X
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXX..XXX
  XX....XX
  XX....XX
  XXX..XXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ..XXXX..
  .XX..XX.
  .X....X.
  .X....X.
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XXXXXXXX
  XX....XX
  X..XX..X
  X.XXXX.X
  X.XXXX.X
  X..XX..X
  XX....XX
  XXXXXXXX
  */
  {0x3e, 0xae},
  /*
  ..XX
  XXX.
  X.X.
  XXX.
  ....XXXX
  .....XXX
  ....XXXX
  .XXXXX.X
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xea, 0x4e},
  /*
  XXX.
  X.X.
  .X..
  XXX.
  ..XXXX..
  .XX..XX.
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  .XXXXXX.
  ...XX...
  */
  {0x3c, 0xc0},
  /*
  ..XX
  XX..
  XX..
  ....
  ..XXXXXX
  ..XX..XX
  ..XXXXXX
  ..XX....
  ..XX....
  .XXX....
  XXXX....
  XXX.....
  */
  {0x75, 0xd0},
  /*
  .XXX
  .X.X
  XX.X
  ....
  .XXXXXXX
  .XX...XX
  .XXXXXXX
  .XX...XX
  .XX...XX
  .XX..XXX
  XXX..XX.
  XX......
  */
  {0x96, 0x90},
  /*
  X..X
  .XX.
  X..X
  ....
  X..XX..X
  .X.XX.X.
  ..XXXX..
  XXX..XXX
  ..XXXX..
  .X.XX.X.
  X..XX..X
  */
  {0x8e, 0x80},
  /*
  X...
  XXX.
  X...
  ....
  X.......
  XXX.....
  XXXXX...
  XXXXXXX.
  XXXXX...
  XXX.....
  X.......
  ........
  */
  {0x2e, 0x20},
  /*
  ..X.
  XXX.
  ..X.
  ....
  ......X.
  ....XXX.
  ..XXXXX.
  XXXXXXX.
  ..XXXXX.
  ....XXX.
  ......X.
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  */
  {0xaa, 0x0a},
  /*
  X.X.
  X.X.
  ....
  X.X.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  ........
  .xx..xx.
  ........
  */
  {0x6a, 0x62},
  /*
  .XX.
  X.X.
  .XX.
  ..X.
  .XXXXXXX
  XX.XX.XX
  XX.XX.XX
  .XXXXX.X
  ...XXX.X
  ...XXX.X
  ...XXX.X
  ........
  */
  {0x6c, 0x36},
  /*
  .XX.
  XX..
  ..XX
  .XX.
  ..XXXXX.
  .X.X..XX
  ..XXX...
  .X.XXX..
  .X.XXX..
  ..XXX...
  XX..XX..
  .XXXX...
  */
  {0x00, 0x60},
  /*
  ....
  ....
  .XX.
  ....
  ........
  ........
  ........
  ........
  .XXXXXX.
  .XXXXXX.
  .XXXXXX.
  ........
  */
  {0x4e, 0x4e},
  /*
  .X..
  XXX.
  .X..
  XXX.
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  */
  {0x4e, 0x44},
  /*
  .X..
  XXX.
  .X..
  .X..
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x44, 0xe4},
  /*
  .X..
  .X..
  XXX.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  */
  {0x2f, 0x20},
  /*
  ..X.
  XXXX
  ..X.
  ....
  ........
  ...XX...
  ....XX..
  XXXXXXX.
  ....XX..
  ...XX...
  ........
  ........
  */
  {0x4f, 0x40},
  /*
  .X..
  XXXX
  .X..
  ....
  ........
  ..XX....
  .XX.....
  XXXXXXX.
  .XX.....
  ..XX....
  ........
  ........
  */
  {0x04, 0x60},
  /*
  ....
  .X..
  .XX.
  ....
  ........
  ........
  XX......
  XX......
  XX......
  XXXXXXX.
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  ........
  ..X..X..
  .XX..XX.
  XXXXXXXX
  .XX.XX.
  ..X..X..
  ........
  ........
  */
  {0x4e, 0x00},
  /*
  .X..
  XXX.
  ....
  ....
  ........
  ...XX...
  ..XXXX..
  .XXXXXX.
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  ........
  XXXXXXXX
  XXXXXXXX
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {044, 0x04},
  /*
  .X..
  .X..
  ....
  .X..
  ..XX....
  .XXXX...
  .XXXX...
  ..XX....
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x60, 0x00},
  /*
  .XX.
  ....
  ....
  ....
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0x6c, 0x6e},
  /*
  .XX.
  XX..
  .XX.
  XXX.
  ..XX....
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ..XX....
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  ........
  XX...XX.
  XX..XX..
  ...XX...
  ..XX....
  .XX..XX.
  XX...XX.
  ........
  */
  {0x6d, 0xa5},
  /*
  .XX.
  XX.X
  X.X.
  .X.X
  ..XXX...
  .XX.XX..
  ..XXX...
  .XXX.XX.
  XX.XXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  .XX.....
  .XX.....
  XX......
  ........
  ........
  ........
  ........
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  .XX.....
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ...XX...
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  .XX..XX.
  ..XXXX..
  XXXXXXXX
  ..XXXX..
  .XX..XX.
  ........
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  ........
  */
  {0x00, 0x24},
  /*
  ....
  ....
  ..X.
  .X..
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x0e, 0x00},
  /*
  ....
  XXX.
  ....
  ....
  ........
  ........
  ........
  XXXXXX..
  ........
  ........
  ........
  ........
  */
  {0x00, 0x66},
  /*
  ....
  ....
  .XX.
  .XX.
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x12, 0x48},
  /*
  ...X
  ..X.
  .X..
  X...
  .....XX.
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  XX......
  X.......
  ........
  */
  {0x69, 0x96},
  /*
  .XX.
  X..X
  X..X
  .XX.
  .XXXXX..
  XX...XX.
  XX..XXX.
  XX.XXXX.
  XXXX.XX.
  XXX..XX.
  .XXXXX..
  ........
  */
  {0xc4, 0x4e},
  /*
  XX..
  .X..
  .X..
  XXX.
  ..XX....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  XXXXXX..
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.

  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0xe6, 0x2e},
  /*
  XXX.
  .XX.
  ..X.
  XXX.
  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x6a, 0xe2},
  /*
  .XX.
  X.X.
  XXX.
  ..X.
  ...XXX..
  ..XXXX..
  .XX.XX..
  XX..XX..
  XXXXXXX.
  ....XX..
  ...XXXX.
  ........
  */
  {0xec, 0x2e},
  /*
  XXX.
  XX..
  ..X.
  XXX.
  XXXXXX..
  XX......
  XXXXX...
  ....XX..
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x24, 0xae},
  /*
  ..X.
  .X..
  X.X.
  XXX.
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xf2, 0x44},
  /*
  XXXX
  ..X.
  .X..
  .X..
  XXXXXX..
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ..XX....
  ..XX....
  ........
  */
  {0x66, 0x96},
  /*
  .XX.
  .XX.
  X..X
  .XX.
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xea, 0x6c},
  /*
  XXX.
  X.X.
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XX...
  .XXX....
  ........
  */
  {0x40, 0x40},
  /*
  .X..
  ....
  .X..
  ....
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x40, 0x48},
  /*
  .X..
  ....
  .X..
  X...
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x28, 0x20},
  /*
  ..X.
  X...
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  XX......
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  ........
  XXXXXX..
  ........
  ........
  XXXXXX..
  ........
  ........
  */
  {0x82, 0x80},
  /*
  X...
  ..X.
  X...
  ....
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xe2, 0x04},
  /*
  XXX.
  ..X.
  ....
  .X..
  .XXXX...
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x7b, 0x86},
  /*
  .XXX
  X.XX
  X...
  .XX.
  .XXXXX..
  XX...XX.
  XX.XXXX.
  XX.XXXX.
  XX.XXXX.
  XX......
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XXXXXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX......
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  XXXXX...
  .XX.XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX.XX..
  XXXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX...X.
  XXXXXXX.
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX..XXX.
  .XX..XX.
  ..XXXXX.
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXX...
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XXXX.
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX..XX.
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  XXXX....
  .XX.....
  .XX.....
  .XX.....
  .XX...X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  XX...XX.
  XXX.XXX.
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XX...XX.
  XXX..XX.
  XXXX.XX.
  XX.XXXX.
  XX..XXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX.XXX..
  .XXXX...
  ...XXX..
  ........
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  .XXXX...
  XX..XX..
  XXX.....
  .XXX
  ...XXX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  XXXXXX..
  X.XX.X..
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  XX...XX.
  XX...XX.
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXX.XXX.
  XX...XX.
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XX...XX.
  XX...XX.
  .XX.XX.
  ..XXX...
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  XXXXXXX.
  XX...XX.
  X...XX..
  ...XX...
  ..XX..X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0x64, 0x60},
  /*
  .XX.
  .X..
  .XX.
  ....
  .XXXX...
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XXXX...
  ........
  */
  {0x84, 0x21},
  /*
  X...
  .X..
  ..X.
  ...X
  XX......
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  .....XX.
  ......X.
  ........
  */
  {0x62, 0x60},
  /*
  .XX.
  ..X.
  .XX.
  ....
  .XXXX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXX...
  ........
  */
  {0x4a, 0x00},
  /*
  .X..
  X.X.
  ....
  ....
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  ........
  ........
  ........
  */
  {0x00, 0x0f},
  /*
  ....
  ....
  ....
  XXXX
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXXX
  */
  {0x84, 0x00},
  /*
  X...
  .X..
  ....
  ....
  ..XX....
  ..XX....
  ...XX...
  ........
  ........
  ........
  ........
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ........
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXX.....
  .XX.....
  .XX.....
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XX.XXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  ...XXX..
  ....XX..
  ....XX..
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  ..XXX...
  .XX.XX..
  .XX.....
  XXXX....
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XXX.....
  .XX.....
  .XX.XX..
  .XXX.XX.
  .XX..XX.
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XX....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ....XX..
  ........
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX.....
  .XX.....
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  ........
  ........
  XX..XX..
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  ........
  ........
  XX.XXX..
  .XX..XX.
  .XXXXX..
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XXXX.
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  ........
  ........
  XX.XXX..
  .XXX.XX.
  .XX..XX.
  .XX.....
  XXXX....
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  ........
  ........
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  ...X....
  ..XX....
  .XXXXX..
  ..XX....
  ..XX....
  ..XX.X..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  ........
  ........
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  ........
  XX...XX.
  .XX.XX..
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  ........
  ........
  XXXXXX..
  X..XX...
  ..XX....
  .XX..X..
  XXXXXX..
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX.
  .XX.
  ....
  ...XXX...
  ..XX....
  ..XX....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ........
  */
  {0x22, 0x20},
  /*
  ..X.
  ..X.
  ..X.
  ....
  ...XX....
  ...XX....
  ...XX....
  .........
  ...XX....
  ...XX....
  ...XX....
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ..XX....
  ..XX....
  XXX.....
  ........
  */
  {0x5a, 0x00},
  /*
  .X.X
  X.X.
  ....
  ....
  .XXX.XX.
  XX.XXX..
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x4a, 0xe0},
  /*
  .X..
  X.X.
  XXX.
  ....
  ........
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XXXXXXX.
  ........
  */
  {0x68, 0x6c},
  /*
  .XX.
  X...
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ...XX...
  ....XX..
  .XXXX...
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXXX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .....XX.
  ..XXXXX.
  .XX..XX.
  ..XXXXXX
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX..XX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XXX.....
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x68, 0x64},
  /*
  .XX.
  X...
  .XX.
  .X..
  ........
  ........
  .XXXX...
  XX......
  XX......
  .XXXX...
  ....XX..
  ..XXX...
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .XX..XX.
  .XXXXXX.
  .XX.....
  ..XXXX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XX..XX..
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXXX..
  XX...XX.
  ..XXX...
  ...XX...
  ...XX...
  ...XX...
  ..XXXX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XXX.....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX...XX.
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX..XX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  XXXXXX..
  .XX.....
  .XXXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0x2e, 0xe0},
  /*
  ..X.
  XXX.
  XXX.
  ....
  ........
  ........
  .XXXXXXX
  ....XX..
  .XXXXXXX
  XX..XX..
  .XXXXXXX
  ........
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XXXXX.
  .XX.XX..
  XX..XX..
  XXXXXXX.
  XX..XX..
  XX..XX..
  XX..XXX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  .XXXX...
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  .XXXX...
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XXX.....
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  XX....XX
  ...XX...
  ..XXXX..
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x68, 0x66},
  /*
  .XX.
  X...
  .XX.
  .XX.
  ...XX...
  ...XX...
  .XXXXXX.
  XX......
  XX......
  .XXXXXX.
  ...XX...
  ...XX...
  */
  {0xc8, 0xe0},
  /*
  XX..
  X...
  XXX.
  ....
  ..XXX...
  .XX.XX..
  .XX..X..
  XXXX....
  .XX.....
  XXX..XX.
  XXXXXX..
  ........
  */
  {0xa4, 0xe4},
  /*
  X.X.
  .X..
  XXX.
  .X..
  XX..XX..
  XX..XX..
  .XXXX...
  XXXXXX..
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  */
  {0xea, 0xea},
  /*
  XXX.
  X.X.
  XXX.
  X.X.
  XXXXX...
  XX..XX..
  XX..XX..
  XXXXX.X.
  XX...XX.
  XX..XXXX
  XX...XX.
  XX...XXX
  */
  {0x64, 0x4c},
  /*
  .XX.
  .X..
  .X..
  XX..
  ....XXX.
  ...XX.XX
  ...XX...
  ..XXXX..
  ...XX...
  ...XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...XXX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XXX...
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ...XXX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  XXXXX...
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XXXXXX..
  ........
  XX..XX..
  XXX.XX..
  XXXXXX..
  XX.XXX..
  XX..XX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XXXX..
  .XX.XX..
  .XX.XX..
  ..XXXXX.
  ........
  .XXXXXX.
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  .XXXXX..
  ........
  ........
  */
  {0x40, 0x8e},
  /*
  .X..
  ....
  X...
  XXX.
  ..XX....
  ........
  ..XX....
  .XX.....
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0x0c, 0x80},
  /*
  ....
  XX..
  X...
  ....
  ........
  ........
  ........
  XXXXXX..
  XX......
  XX......
  ........
  ........
  */
  {0x0c, 0x40},
  /*
  ....
  XX..
  .X..
  ....
  ........
  ........
  ........
  XXXXXX..
  ....XX..
  ....XX..
  ........
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/2
  XX...XX.
  XX..XX..
  XX.XXXX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ....XXXX
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/4
  XX...XX.
  XX..XX..
  XX.XX.XX
  ..XX.XXX
  .XX.XXXX
  XX..XXXX
  ......XX
  */
  {0x20, 0x22},
  /*
  ..X.
  ....
  ..X.
  ..X.
  ...XX...
  ...XX...
  ........
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ..XX..XX.
  .XX..XX.
  XX..XX..
  .XX..XX.
  ..XX..XX.
  .........
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  ........
  XX..XX..
  .XX..XX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ........
  ........
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  */
  {0x44, 0x44},
  /*
  .X..
  .X..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x44},
  /*
  .X..
  XX..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
*/
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  ........
  ........
  XXXXXXX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x6e, 0xe6},
  /*
  .XX.
  XXX.
  XXX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x66, 0x66},
  /*
  .XX.
  .XX.
  .XX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0e, 0xe6},
  /*
  ....
  XXX.
  XXX.
  .XX.
  ........
  ........
  XXXXXXX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXXXXX.
  ........
  ........
  ........
  */
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXX.
  ........
  ........
  ........
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
  {0x0c, 0x44},
  /*
  ....
  XX..
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x00},
  /*
  .X..
  .XXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x00},
  /*
  .X..
  XXXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0x44},
  /*
  ....
  XXXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x44},
  /*
  .X..
  .XXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x0f, 0x00},
  /*
  ....
  XXXX
  ....
  ....
  ........
  ........
  ........
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x44},
  /*
  .X..
  XXXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x67, 0x70},
  /*
  .XX.
  .XXX
  .XXX
  ....
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XXXXXX
  ........
  ........
  ........
  */
  {0x07, 0x76},
  /*
  ....
  .XXX
  .XXX
  .XX.
  ........
  ........
  ..XXXXXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6f, 0xf0},
  /*
  .XX.
  XXXX
  XXXX
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0xf6},
  /*
  ....
  XXXX
  XXXX
  .XX.
  ........
  ........
  XXXXXXXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x67, 0x76},
  /*
  .XX.
  .XXX
  .XXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0f, 0xf0},
  /*
  ....
  XXXX
  XXXX
  ....
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  XXXXXXXX.
  .........
  .........
  .........
  .........
  .........
  .........
  .........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ........
  ........
  */
  {0xe0, 0x00},
  /*
  XXX.
  ....
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  ........
  ........
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0x00},
  /*
  XXX.
  XXX.
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XXXXXX
  ........
  ........
  ........
  */
  {0xee, 0x40},
  /*
  XXX.
  XXX.
  .X..
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  org
  ........
  ........
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xee, 0xe4},
  /*
  XXX.
  XXX.
  XXX.
  .X..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  org
  ........
  ........
  ........
  ........
  ..XXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0xee},
  /*
  XXX.
  XXX.
  XXX.
  XXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x4f, 0xf4},
  /*
  .X..
  XXXX
  XXXX
  .X..
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x00},
  /*
  .X..
  XX..
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
  {0x07, 0x44},
  /*
  ....
  .XXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xff, 0xff},
  /*
  XXXX
  XXXX
  XXXX
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x00, 0xff},
  /*
  ....
  ....
  XXXX
  XXXX
  ........
  ........
  ........
  ........
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0xcc, 0xcc},
  /*
  XX..
  XX..
  XX..
  XX..
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  */
  {0x33, 0x33},
  /*
  ..XX
  ..XX
  ..XX
  ..XX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  */
  {0xff, 0x00},
  /*
  XXXX
  XXXX
  ....
  ....
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  ........
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX.XXX..
  XX..X...
  XX.XXX..
  .XXX.XX.
  ........
  */
  {0xee, 0xa0},
  /*
  XXX.
  XXX.
  X.X.
  ....
  .XXXX... German double S
  XX..XX..
  XX..XX..
  XX.XX...
  XX..XX..
  XX...XX.
  XX...XX.
  ........
  */
  {0xea, 0x80},
  /*
  XXX.
  X.X.
  X...
  ....
  XXXXXX..
  XX..XX..
  XX......
  XX......
  XX......
  XX......
  XX......
  ........
  */
  {0xec, 0xc0},
  /*
  XXX.
  XX..
  XX..
  ....
  ........ PI
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  */
  {0xe8, 0xe0},
  /*
  XXX.
  X...
  XXX.
  ....
  XXXXXX..
  XX..XX..
  .XX.....
  ..XX....
  .XX.....
  XX..XX..
  XXXXXX...
  .........
  */
  {0x6a, 0x40},
  /*
  .XX.
  X.X.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX...
  XX.XX...
  XX.XX...
  .XXX....
  ........
  */
  {0xaa, 0xe8},
  /*
  X.X.
  X.X.
  XXX.
  X...
  ........
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  XX......
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ........I + tilda
  .XXX.XX.
  XX.XXX..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0xe4, 0x4e},
  /*
  XXX.
  .X..
  .X..
  XXX.
  XXXXXX..
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  XXXXXX...
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0x4a, 0xa0},
  /*
  .X..
  X.X.
  X.X.
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  .XX.XX..
  .XX.XX..
  XXX.XXX.
  ........
  */
  {0x64, 0xa4},
  /*
  .XX.
  .X..
  X.X.
  .X..
  ...XXX..
  ..XX....
  ...XX...
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  ........
  ........
  */
  {0x6e, 0xc0},
  /*
  .XX.
  XXX.
  XX..
  ....
  .....XX.
  ....XX..
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  .XX.....
  XX......
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX......
  .XX.....
  ..XXX...
  .........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  ........
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  ....
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ..XX....
  .XX.....
  ........
  XXXXXX..
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  ..XX....
  ...XX...
  ........
  XXXXXX..
  ........
  */
  {0x2a, 0x44},
  /*
  ..X.
  .X.X.
  .X...
  .X...
  ....XXX.
  ...XX.XX
  ...XX.XX
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XX.XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  ..XX....
  ..XX....
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  .XXX.XX.
  XX.XXX..
  ........
  .XXX.XX.
  XX.XXX..
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ...XX...
  ...XX...
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ........
  ...XX...
  ........
  ........
  ........
  */
  {0x32, 0xa6},
  /*
  ..XX
  ..X.
  X.X.
  .XX.
  ....XXXX
  ....XX..
  ....XX..
  ....XX..
  XXX.XX..
  .XX.XX..
  ..XXXX..
  ...XXX..
  */
  {0xea, 0x00},
  /*
  XXX.
  X.X.
  ....
  ....
  .XXXX...
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.
  .XXX....
  ...XX...
  ..XX....
  .XX.....
  .XXXX...
  ........
  ........
  ........
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ........
  ........
  */
  {0x00, 0x00}
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
};























unsigned char plFont88[256][8]=
{
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/* 00 */
  {0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E},
  {0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E},
  {0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00},
  {0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00},
  {0x38,0x7C,0x38,0xFE,0xFE,0x7C,0x38,0x7C},
  {0x10,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x7C},
  {0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00},
  {0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF},
  {0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00},
  {0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF},
  {0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78},
  {0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18},
  {0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0},
  {0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0},
  {0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99},
  {0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00},/* 10 */
  {0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00},
  {0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18},
  {0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00},
  {0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00},
  {0x3C,0x62,0x38,0x6C,0x38,0x8C,0x78,0x00},
  {0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00},
  {0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF},
  {0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00},
  {0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00},
  {0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00},
  {0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00},
  {0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00},
  {0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00},
  {0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00},
  {0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/* 20 */
  {0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00},
  {0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00},
  {0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00},
  {0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00},
  {0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00},
  {0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00},
  {0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00},
  {0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00},
  {0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00},
  {0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00},
  {0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60},
  {0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00},
  {0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00},
  {0x7C,0xC6,0xCE,0xDE,0xF6,0xE6,0x7C,0x00},/* 30 */
  {0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00},
  {0x78,0xCC,0x0C,0x38,0x60,0xCC,0xFC,0x00},
  {0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00},
  {0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00},
  {0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00},
  {0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00},
  {0xFC,0xCC,0x0C,0x18,0x30,0x30,0x30,0x00},
  {0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00},
  {0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00},
  {0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00},
  {0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60},
  {0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00},
  {0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00},
  {0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00},
  {0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00},
  {0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00},/* 40 */
  {0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00},
  {0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00},
  {0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00},
  {0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00},
  {0xFE,0x62,0x68,0x78,0x68,0x62,0xFE,0x00},
  {0xFE,0x62,0x68,0x78,0x68,0x60,0xF0,0x00},
  {0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00},
  {0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00},
  {0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
  {0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00},
  {0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00},
  {0xF0,0x60,0x60,0x60,0x62,0x66,0xFE,0x00},
  {0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0x00},
  {0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00},
  {0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00},
  {0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00},/* 50 */
  {0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00},
  {0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE6,0x00},
  {0x78,0xCC,0xE0,0x70,0x1C,0xCC,0x78,0x00},
  {0xFC,0xB4,0x30,0x30,0x30,0x30,0x78,0x00},
  {0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00},
  {0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00},
  {0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00},
  {0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00},
  {0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00},
  {0xFE,0xC6,0x8C,0x18,0x32,0x66,0xFE,0x00},
  {0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00},
  {0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00},
  {0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00},
  {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},
  {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00},/* 60 */
  {0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00},
  {0xE0,0x60,0x60,0x7C,0x66,0x66,0xDC,0x00},
  {0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00},
  {0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00},
  {0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00},
  {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00},
  {0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x0C,0x00,0x0C,0x0C,0x0C,0xCC,0xCC,0x78},
  {0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00},
  {0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
  {0x00,0x00,0xCC,0xFE,0xFE,0xD6,0xC6,0x00},
  {0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00},
  {0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00},
  {0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0},/* 70 */
  {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E},
  {0x00,0x00,0xDC,0x76,0x66,0x60,0xF0,0x00},
  {0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00},
  {0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00},
  {0x00,0x00,0xC6,0xD6,0xFE,0xFE,0x6C,0x00},
  {0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00},
  {0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00},
  {0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00},
  {0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00},
  {0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00},
  {0x78,0xCC,0xC0,0xCC,0x78,0x18,0x0C,0x78},/* 80 */
  {0x00,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x1C,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0x7E,0xC3,0x3C,0x06,0x3E,0x66,0x3F,0x00},
  {0xCC,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0xE0,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x30,0x30,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x00,0x00,0x78,0xC0,0xC0,0x78,0x0C,0x38},
  {0x7E,0xC3,0x3C,0x66,0x7E,0x60,0x3C,0x00},
  {0xCC,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0xE0,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0xCC,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x7C,0xC6,0x38,0x18,0x18,0x18,0x3C,0x00},
  {0xE0,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0xC6,0x38,0x6C,0xC6,0xFE,0xC6,0xC6,0x00},
  {0x30,0x30,0x00,0x78,0xCC,0xFC,0xCC,0x00},
  {0x1C,0x00,0xFC,0x60,0x78,0x60,0xFC,0x00},/* 90 */
  {0x00,0x00,0x7F,0x0C,0x7F,0xCC,0x7F,0x00},
  {0x3E,0x6C,0xCC,0xFE,0xCC,0xCC,0xCE,0x00},
  {0x78,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0xE0,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x78,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xE0,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xCC,0x00,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0xC3,0x18,0x3C,0x66,0x66,0x3C,0x18,0x00},
  {0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00},
  {0x18,0x18,0x7E,0xC0,0x7E,0x18,0x18,0x00},
  {0x38,0x6C,0x64,0xF0,0x60,0xE6,0xFC,0x00},
  {0xCC,0xCC,0x78,0xFC,0x30,0xFC,0x30,0x00},
  {0xF8,0xCC,0xCC,0xFA,0xC6,0xCF,0xC6,0xC7},
  {0x0E,0x1B,0x18,0x3C,0x18,0x18,0xD8,0x70},
  {0x1C,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},/* A0 */
  {0x38,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x00,0x1C,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0x1C,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xF8,0x00,0xF8,0xCC,0xCC,0xCC,0x00},
  {0xFC,0x00,0xCC,0xEC,0xFC,0xDC,0xCC,0x00},
  {0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00},
  {0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00},
  {0x30,0x00,0x30,0x60,0xC0,0xCC,0x78,0x00},
  {0x00,0x00,0x00,0xFC,0xC0,0xC0,0x00,0x00},
  {0x00,0x00,0x00,0xFC,0x0C,0x0C,0x00,0x00},
  {0xC3,0xC6,0xCC,0xDE,0x33,0x66,0xCC,0x0F},
  {0xC3,0xC6,0xCC,0xDB,0x37,0x6F,0xCF,0x03},
  {0x30,0x00,0x30,0x30,0x78,0x78,0x30,0x00},
  {0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00},
  {0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00},
  {0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88},/* B0 */
  {0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA},
  {0xDB,0x77,0xDB,0xEE,0xDB,0x77,0xDB,0xEE},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18},
  /*{0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe},
  /*{0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
  /*{0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe},
  {0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36},
  {0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe},
  {0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00},/* C0 */
  {0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18},
  {0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00},
  {0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18},
  /*{0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  {0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00},
  {0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36},
  {0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36},
  {0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36},
  {0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00},
  {0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36},
  /*{0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00},*/{0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/* D0 */
  /*{0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18},*/{0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00},
  /*{0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00},
  /*{0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00},
  /*{0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  {0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF},
  {0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0},
  {0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F},
  {0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x76,0xDC,0xC8,0xDC,0x76,0x00},/* E0 */
  {0x78,0xCC,0xCC,0xD8,0xC6,0xC6,0xCC,0x00},
  {0xFC,0xCC,0xC0,0xC0,0xC0,0xC0,0xC0,0x00},
  {0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x00},
  {0xFC,0xCC,0x60,0x30,0x60,0xCC,0xFC,0x00},
  {0x00,0x00,0x7E,0xD8,0xD8,0xD8,0x70,0x00},
  {0x00,0x66,0x66,0x66,0x66,0x7C,0x60,0xC0},
  {0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x00},
  {0xFC,0x30,0x78,0xCC,0xCC,0x78,0x30,0xFC},
  {0x38,0x6C,0xC6,0xFE,0xC6,0x6C,0x38,0x00},
  {0x38,0x6C,0xC6,0xC6,0x6C,0x6C,0xEE,0x00},
  {0x1C,0x30,0x18,0x7C,0xCC,0xCC,0x78,0x00},
  {0x00,0x00,0x7E,0xDB,0xDB,0x7E,0x00,0x00},
  {0x06,0x0C,0x7E,0xDB,0xDB,0x7E,0x60,0xC0},
  {0x38,0x60,0xC0,0xF8,0xC0,0x60,0x38,0x00},
  {0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x00},
  {0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0x00},/* F0 */
  {0x30,0x30,0xFC,0x30,0x30,0x00,0xFC,0x00},
  {0x60,0x30,0x18,0x30,0x60,0x00,0xFC,0x00},
  {0x18,0x30,0x60,0x30,0x18,0x00,0xFC,0x00},
  {0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x70},
  {0x30,0x30,0x00,0xFC,0x00,0x30,0x30,0x00},
  {0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00},
  {0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00},
  {0x0F,0x0C,0x0C,0x0C,0xEC,0x6C,0x3C,0x1C},
  {0x78,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00},
  {0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

unsigned char plFont816[256][16]=
{
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0000
  {0x00,0x00,0x7E,0x81,0xA5,0x81,0x81,0xBD,0x99,0x81,0x81,0x7E,0x00,0x00,0x00,0x00}, // 263a
  {0x00,0x00,0x7E,0xFF,0xDB,0xFF,0xFF,0xC3,0xE7,0xFF,0xFF,0x7E,0x00,0x00,0x00,0x00}, // 263b
  {0x00,0x00,0x00,0x00,0x6C,0xFE,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00}, // 2665
  {0x00,0x00,0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00}, // 2666
  {0x00,0x00,0x00,0x18,0x3C,0x3C,0xE7,0xE7,0xE7,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 2663
  {0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x7E,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 2660
  {0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 2022
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 25d8
  {0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,0x00,0x00,0x00,0x00}, // 25cb
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF}, // 25d9
  {0x00,0x00,0x1E,0x0E,0x1A,0x32,0x78,0xCC,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00}, // 2642
  {0x00,0x00,0x3C,0x66,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00}, // 2640
  {0x00,0x00,0x3F,0x33,0x3F,0x30,0x30,0x30,0x30,0x70,0xF0,0xE0,0x00,0x00,0x00,0x00}, // 266a
  {0x00,0x00,0x7F,0x63,0x7F,0x63,0x63,0x63,0x63,0x67,0xE7,0xE6,0xC0,0x00,0x00,0x00}, // 266b
  {0x00,0x00,0x00,0x18,0x18,0xDB,0x3C,0xE7,0x3C,0xDB,0x18,0x18,0x00,0x00,0x00,0x00}, // 263c

  {0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xFE,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00}, // 25ba
  {0x00,0x02,0x06,0x0E,0x1E,0x3E,0xFE,0x3E,0x1E,0x0E,0x06,0x02,0x00,0x00,0x00,0x00}, // 25c4
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00,0x00}, // 2195
  {0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x66,0x00,0x00,0x00,0x00}, // 203c
  {0x00,0x00,0x7F,0xDB,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,0x00,0x00,0x00}, // 00b6
  {0x00,0x7C,0xC6,0x60,0x38,0x6C,0xC6,0xC6,0x6C,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00}, // 00a7
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0x00,0x00,0x00,0x00}, // 25ac
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00}, // 21a8
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 2191
  {0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00}, // 2193
  {0x00,0x00,0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 2192
  {0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00}, // 2190
  {0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,0x00,0x00,0x00,0x00}, // 221f
  {0x00,0x00,0x00,0x00,0x00,0x28,0x6C,0xFE,0x6C,0x28,0x00,0x00,0x00,0x00,0x00,0x00}, // 2194
  {0x00,0x00,0x00,0x00,0x10,0x38,0x38,0x7C,0x7C,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00}, // 25b2
  {0x00,0x00,0x00,0x00,0xFE,0xFE,0x7C,0x7C,0x38,0x38,0x10,0x00,0x00,0x00,0x00,0x00}, // 25bc

  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0020
  {0x00,0x00,0x18,0x3C,0x3C,0x3C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00}, // 0021
  {0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0022
  {0x00,0x00,0x00,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x00,0x00,0x00,0x00}, // 0023
  {0x18,0x18,0x7C,0xC6,0xC2,0xC0,0x7C,0x06,0x06,0x86,0xC6,0x7C,0x18,0x18,0x00,0x00}, // 0024
  {0x00,0x00,0x00,0x00,0xC2,0xC6,0x0C,0x18,0x30,0x60,0xC6,0x86,0x00,0x00,0x00,0x00}, // 0025
  {0x00,0x00,0x38,0x6C,0x6C,0x38,0x76,0xDC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0026
  {0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0027
  {0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0C,0x00,0x00,0x00,0x00}, // 0028
  {0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,0x00}, // 0029
  {0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00}, // 002a
  {0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00}, // 002b
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00}, // 002c
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 002d
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00}, // 002e
  {0x00,0x00,0x00,0x00,0x02,0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,0x00,0x00,0x00}, // 002f

  {0x00,0x00,0x7C,0xC6,0xC6,0xCE,0xDE,0xF6,0xE6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0030
  {0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,0x00}, // 0031
  {0x00,0x00,0x7C,0xC6,0x06,0x0C,0x18,0x30,0x60,0xC0,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 0032
  {0x00,0x00,0x7C,0xC6,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0033
  {0x00,0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00,0x00}, // 0034
  {0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xFC,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0035
  {0x00,0x00,0x38,0x60,0xC0,0xC0,0xFC,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0036
  {0x00,0x00,0xFE,0xC6,0x06,0x06,0x0C,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00}, // 0037
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0038
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x0C,0x78,0x00,0x00,0x00,0x00}, // 0039
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00}, // 003a
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00}, // 003b
  {0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00}, // 003c
  {0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 003d
  {0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00}, // 003e
  {0x00,0x00,0x7C,0xC6,0xC6,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00}, // 003f

  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xDE,0xDE,0xDE,0xDC,0xC0,0x7C,0x00,0x00,0x00,0x00}, // 0040
  {0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 0041
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,0x00}, // 0042
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x00,0x00,0x00,0x00}, // 0043
  {0x00,0x00,0xF8,0x6C,0x66,0x66,0x66,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00}, // 0044
  {0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00}, // 0045
  {0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0046
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xDE,0xC6,0xC6,0x66,0x3A,0x00,0x00,0x00,0x00}, // 0047
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 0048
  {0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0049
  {0x00,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00}, // 004a
  {0x00,0x00,0xE6,0x66,0x66,0x6C,0x78,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,0x00}, // 004b
  {0x00,0x00,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00}, // 004c
  {0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 004d
  {0x00,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 004e
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 004f

  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0050
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xDE,0x7C,0x0C,0x0E,0x00,0x00}, // 0051
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00}, // 0052
  {0x00,0x00,0x7C,0xC6,0xC6,0x60,0x38,0x0C,0x06,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0053
  {0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0054
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0055
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x10,0x00,0x00,0x00,0x00}, // 0056
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0xEE,0x6C,0x00,0x00,0x00,0x00}, // 0057
  {0x00,0x00,0xC6,0xC6,0x6C,0x7C,0x38,0x38,0x7C,0x6C,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 0058
  {0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0059
  {0x00,0x00,0xFE,0xC6,0x86,0x0C,0x18,0x30,0x60,0xC2,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 005a
  {0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00,0x00,0x00}, // 005b
  {0x00,0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x06,0x02,0x00,0x00,0x00,0x00}, // 005c
  {0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,0x00}, // 005d
  {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 005e
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00}, // 005f

  {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0060
  {0x00,0x00,0x00,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0061
  {0x00,0x00,0xE0,0x60,0x60,0x78,0x6C,0x66,0x66,0x66,0x66,0x7C,0x00,0x00,0x00,0x00}, // 0062
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC0,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0063
  {0x00,0x00,0x1C,0x0C,0x0C,0x3C,0x6C,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0064
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0065
  {0x00,0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0066
  {0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0xCC,0x78,0x00}, // 0067
  {0x00,0x00,0xE0,0x60,0x60,0x6C,0x76,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00}, // 0068
  {0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 0069
  {0x00,0x00,0x06,0x06,0x00,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3C,0x00}, // 006a
  {0x00,0x00,0xE0,0x60,0x60,0x66,0x6C,0x78,0x78,0x6C,0x66,0xE6,0x00,0x00,0x00,0x00}, // 006b
  {0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 006c
  {0x00,0x00,0x00,0x00,0x00,0xEC,0xFE,0xD6,0xD6,0xD6,0xD6,0xC6,0x00,0x00,0x00,0x00}, // 006d
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00}, // 006e
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 006f

  {0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00}, // 0070
  {0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0x0C,0x1E,0x00}, // 0071
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00}, // 0072
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0x60,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 0073
  {0x00,0x00,0x10,0x30,0x30,0xFC,0x30,0x30,0x30,0x30,0x36,0x1C,0x00,0x00,0x00,0x00}, // 0074
  {0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 0075
  {0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00}, // 0076
  {0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0x6C,0x00,0x00,0x00,0x00}, // 0077
  {0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00}, // 0078
  {0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00}, // 0079
  {0x00,0x00,0x00,0x00,0x00,0xFE,0xCC,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 007a
  {0x00,0x00,0x0E,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0E,0x00,0x00,0x00,0x00}, // 007b
  {0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 00a6
  {0x00,0x00,0x70,0x18,0x18,0x18,0x0E,0x18,0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00}, // 007d
  {0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 007e
  {0x00,0x00,0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0x00,0x00,0x00,0x00,0x00}, // 2302

  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x0C,0x06,0x7C,0x00,0x00}, // 00c7
  {0x00,0x00,0xCC,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00fc
  {0x00,0x0C,0x18,0x30,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00e9
  {0x00,0x10,0x38,0x6C,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e2
  {0x00,0x00,0xCC,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e4
  {0x00,0x60,0x30,0x18,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e0
  {0x00,0x38,0x6C,0x38,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e5
  {0x00,0x00,0x00,0x00,0x3C,0x66,0x60,0x60,0x66,0x3C,0x0C,0x06,0x3C,0x00,0x00,0x00}, // 00e7
  {0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00ea
  {0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00eb
  {0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00e8
  {0x00,0x00,0x66,0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ef
  {0x00,0x18,0x3C,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ee
  {0x00,0x60,0x30,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ec
  {0x00,0xC6,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 00c4
  {0x38,0x6C,0x38,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 00c5

  {0x18,0x30,0x60,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}, // 00c9
  {0x00,0x00,0x00,0x00,0x6C,0xFE,0xB2,0x32,0x7E,0xD8,0xD8,0x6E,0x00,0x00,0x00,0x00}, // 00e6
  {0x00,0x00,0x3E,0x6C,0xCC,0xCC,0xFE,0xCC,0xCC,0xCC,0xCC,0xCE,0x00,0x00,0x00,0x00}, // 00c6
  {0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f4
  {0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f6
  {0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f2
  {0x00,0x30,0x78,0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00fb
  {0x00,0x60,0x30,0x18,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00f9
  {0x00,0x00,0xC6,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0x78,0x00}, // 00ff
  {0x00,0xC6,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00d6
  {0x00,0xC6,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00dc
  {0x00,0x18,0x18,0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x18,0x18,0x00,0x00,0x00,0x00}, // 00a2
  {0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xE6,0xFC,0x00,0x00,0x00,0x00}, // 00a3
  {0x00,0x00,0x66,0x66,0x3C,0x18,0x7E,0x18,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 00a5
  {0x00,0xF8,0xCC,0xCC,0xF8,0xC4,0xCC,0xDE,0xCC,0xCC,0xCC,0xC6,0x00,0x00,0x00,0x00}, // 20a7
  {0x00,0x0E,0x1B,0x18,0x18,0x18,0x7E,0x18,0x18,0x18,0x18,0x18,0xD8,0x70,0x00,0x00}, // 0192

  {0x00,0x18,0x30,0x60,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00e1
  {0x00,0x0C,0x18,0x30,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}, // 00ed
  {0x00,0x18,0x30,0x60,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00f3
  {0x00,0x18,0x30,0x60,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}, // 00fa
  {0x00,0x00,0x76,0xDC,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00}, // 00f1
  {0x76,0xDC,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 00d1
  {0x00,0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00aa
  {0x00,0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00ba
  {0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}, // 00bf
  {0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00}, // 2310
  {0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00}, // 00ac
  {0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x60,0xDC,0x86,0x0C,0x18,0x3E,0x00,0x00}, // 00bd
  {0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x66,0xCE,0x9E,0x3E,0x06,0x06,0x00,0x00}, // 00bc
  {0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x18,0x3C,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00}, // 00a1
  {0x00,0x00,0x00,0x00,0x00,0x36,0x6C,0xD8,0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00}, // 00ab
  {0x00,0x00,0x00,0x00,0x00,0xD8,0x6C,0x36,0x6C,0xD8,0x00,0x00,0x00,0x00,0x00,0x00}, // 00bb

  {0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44}, // 2591
  {0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA}, // 2592
  {0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77}, // 2593
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2502
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2524
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2561
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe}, // 2562
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe}, // 2556
  /*{0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 2555
  {0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2563
  {0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2551
  {0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2557
  {0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 255d
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255c
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255b
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2510

  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2514
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2534
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 252c
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 251c
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2500
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 253c
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255e
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 255f
  {0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 255a
  {0x00,0x00,0x00,0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2554
  {0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2569
  {0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2566
  {0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 2560
  {0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2550
  {0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36}, // 256c
  /*{0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 2567

  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2568
  /*{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2564
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2565
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2559
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00}, // 2558
  /*{0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00}, // 2552
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00}, // 2553
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe}, // 256b
  {0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 256a
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2518
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 250c
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 2588
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, // 2584
  {0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0}, // 258c
  {0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F}, // 2590
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2580

  {0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0xD8,0xD8,0xD8,0xDC,0x76,0x00,0x00,0x00,0x00}, // 03b1
  {0x00,0x00,0x78,0xCC,0xCC,0xCC,0xD8,0xCC,0xC6,0xC6,0xC6,0xCC,0x00,0x00,0x00,0x00}, // 00df
  {0x00,0x00,0xFE,0xC6,0xC6,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00}, // 0393
  {0x00,0x00,0x00,0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00}, // 03c0
  {0x00,0x00,0x00,0xFE,0xC6,0x60,0x30,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00}, // 03a3
  {0x00,0x00,0x00,0x00,0x00,0x7E,0xD8,0xD8,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00}, // 03c3
  {0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xC0,0x00,0x00,0x00}, // 00b5
  {0x00,0x00,0x00,0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}, // 03c4
  {0x00,0x00,0x00,0x7E,0x18,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00}, // 03a6
  {0x00,0x00,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0x6C,0x38,0x00,0x00,0x00,0x00}, // 0398
  {0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x6C,0x6C,0x6C,0xEE,0x00,0x00,0x00,0x00}, // 03a9
  {0x00,0x00,0x1E,0x30,0x18,0x0C,0x3E,0x66,0x66,0x66,0x66,0x3C,0x00,0x00,0x00,0x00}, // 03b4
  {0x00,0x00,0x00,0x00,0x00,0x7E,0xDB,0xDB,0xDB,0x7E,0x00,0x00,0x00,0x00,0x00,0x00}, // 221e
  {0x00,0x00,0x00,0x03,0x06,0x7E,0xDB,0xDB,0xF3,0x7E,0x60,0xC0,0x00,0x00,0x00,0x00}, // 03c6
  {0x00,0x00,0x1C,0x30,0x60,0x60,0x7C,0x60,0x60,0x60,0x30,0x1C,0x00,0x00,0x00,0x00}, // 03b5
  {0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}, // 2229

  {0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00}, // 2261
  {0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0xFF,0x00,0x00,0x00,0x00}, // 00b1
  {0x00,0x00,0x00,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00,0x7E,0x00,0x00,0x00,0x00}, // 2265
  {0x00,0x00,0x00,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00,0x7E,0x00,0x00,0x00,0x00}, // 2264
  {0x00,0x00,0x0E,0x1B,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18}, // 2320
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00}, // 2321
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00}, // 00f7
  {0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00}, // 2248
  {0x00,0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00b0
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 2219
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00b7
  {0x00,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0xEC,0x6C,0x6C,0x3C,0x1C,0x00,0x00,0x00,0x00}, // 221a
  {0x00,0xD8,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 207f
  {0x00,0x70,0xD8,0x30,0x60,0xC8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 00b2
  {0x00,0x00,0x00,0x00,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00}, // 25a0
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  // 00a0
};

const struct FontData_8x8_t plFont_8x8_latin1_addons[41] =
{
	{0x007c, {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00}},
	{0x00a4, {0x82,0x54,0x6c,0x82,0x6c,0x54,0x82,0x00}},
	{0x00a8, {0x00,0xc6,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00a9, {0x38,0x44,0x9A,0xA2,0x9A,0x44,0x38,0x00}},
	{0x00ad, {0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00}},
	{0x00ae, {0x7c,0x82,0xba,0xba,0xb2,0xaa,0x7c,0x00}},
	{0x00af, {0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b3, {0x70,0x08,0x30,0x08,0x70,0x00,0x00,0x00}},
	{0x00b4, {0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00}},
	{0x00b8, {0x00,0x00,0x00,0x00,0x00,0x10,0x20,0x00}},
	{0x00b9, {0x20,0x60,0x20,0x20,0x70,0x00,0x00,0x00}},
	{0x00be, {0xe3,0xe6,0x6c,0xdb,0x37,0x6f,0xcf,0x03}},
	{0x00c0, {0xe0,0x00,0x78,0xcc,0xfc,0xcc,0xcc,0x00}},
	{0x00c1, {0x1c,0x00,0x78,0xcc,0xfc,0xcc,0xcc,0x00}},
	{0x00c2, {0x30,0x48,0x00,0x78,0xcc,0xfc,0xcc,0x00}},
	{0x00c3, {0x76,0xdc,0x00,0x78,0xcc,0xfc,0xcc,0x00}},
	{0x00c8, {0xe0,0x00,0xfc,0x60,0x78,0x60,0xfc,0x00}},
	{0x00ca, {0x30,0x48,0xfc,0x60,0x78,0x60,0xfc,0x00}},
	{0x00cb, {0x6c,0x00,0xfc,0x60,0x78,0x60,0xfc,0x00}},
	{0x00cc, {0xe0,0x00,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00cd, {0x1c,0x00,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00ce, {0x30,0x48,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00cf, {0xcc,0x00,0x78,0x30,0x30,0x30,0x78,0x00}},
	{0x00d0, {0xf8,0x6c,0x66,0xf6,0x66,0x6c,0xf8,0x00}},
	{0x00d2, {0xe0,0x00,0x38,0x6C,0xC6,0x6C,0x38,0x00}},
	{0x00d3, {0x1c,0x00,0x38,0x6C,0xC6,0x6C,0x38,0x00}},
	{0x00d4, {0x30,0x48,0x38,0x6C,0xC6,0x6C,0x38,0x00}},
	{0x00d5, {0x76,0xdc,0x38,0x6C,0xC6,0x6c,0x38,0x00}},
	{0x00d7, {0x00,0x44,0x28,0x10,0x28,0x44,0x00,0x00}},
	{0x00d8, {0x0c,0x38,0x6c,0xd6,0x6c,0x38,0x60,0x00}},
	{0x00d9, {0xe0,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00}},
	{0x00da, {0x1c,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00}},
	{0x00db, {0x30,0x48,0x00,0xCC,0xCC,0xCC,0x78,0x00}},
	{0x00dd, {0x00,0xe0,0x00,0xCC,0xCC,0x7C,0x0C,0xF8}},
	{0x00de, {0x60,0x60,0x7c,0x66,0x7c,0x60,0x60,0x00}},
	{0x00e3, {0xfe,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00}},
	{0x00f0, {0x0c,0x1e,0x0c,0x7c,0xa6,0xac,0x38,0x00}},
	{0x00f5, {0x76,0xdc,0x00,0x78,0xcc,0xcc,0x78,0x00}},
	{0x00f8, {0x00,0x04,0x38,0x54,0x64,0x78,0x80,0x00}},
	{0x00fd, {0xe0,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8}},
	{0x00fe, {0x60,0x7c,0x66,0x66,0x66,0x7c,0x60,0x00}}
};


const struct FontData_8x16_t plFont_8x16_latin1_addons[41] =
{
	{0x007c, {0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00}},
	{0x00a4, {0x00,0x00,0x00,0x82,0x44,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x44,0x82,0x00,0x00,0x00}},
	{0x00a8, {0x00,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00a9, {0x00,0x00,0x00,0x00,0x38,0x44,0x9A,0xA2,0xA2,0x9A,0x44,0x38,0x00,0x00,0x00,0x00}},
	{0x00ad, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00ae, {0x00,0x00,0x00,0x10,0x6C,0x82,0xB2,0xAA,0xB2,0xAA,0xAA,0x82,0x6C,0x10,0x00,0x00}},
	{0x00af, {0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b3, {0x70,0x08,0x30,0x08,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b4, {0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00b8, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x20,0x00,0x00}},
	{0x00b9, {0x20,0x60,0x20,0x20,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0x00be, {0xE0,0x10,0x60,0x12,0x16,0xEC,0x18,0x30,0x66,0xCE,0x9E,0x3E,0x06,0x06,0x00,0x00}},
	{0x00c0, {0x30,0x18,0x0C,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c1, {0x18,0x30,0x60,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c2, {0x10,0x38,0x6C,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c3, {0x76,0xDC,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00}},
	{0x00c8, {0x30,0x18,0x0C,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}},
	{0x00ca, {0x10,0x38,0x6C,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}},
	{0x00cb, {0x00,0xC6,0x00,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00}},
	{0x00cc, {0x30,0x18,0x0C,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00cd, {0x18,0x30,0x60,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00ce, {0x10,0x38,0x6C,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00cf, {0x00,0xC6,0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00d0, {0x00,0x00,0xF8,0x6C,0x66,0x66,0xF6,0xF6,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00}},
	{0x00d2, {0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d3, {0x18,0x30,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d4, {0x10,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d5, {0x76,0xDC,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00d7, {0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00}},
	{0x00d8, {0x00,0x02,0x7C,0xCE,0xD6,0xD6,0xD6,0xD6,0xD6,0xE6,0xC6,0x7C,0x80,0x00,0x00,0x00}},
	{0x00d9, {0x30,0x18,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00da, {0x08,0x30,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00db, {0x10,0x6C,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00dd, {0x18,0x30,0x60,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00}},
	{0x00de, {0x00,0x00,0x00,0x00,0x60,0x7C,0x66,0x66,0x66,0x66,0x7C,0x60,0x00,0x00,0x00,0x00}},
	{0x00e3, {0x00,0x76,0xDC,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00}},
	{0x00f0, {0x00,0x00,0x18,0x3C,0x0C,0x7E,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00f5, {0x00,0x76,0xDC,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00}},
	{0x00f8, {0x00,0x00,0x00,0x00,0x04,0x7C,0xCE,0xD6,0xD6,0xD6,0xE6,0x7C,0x40,0x00,0x00,0x00}},
	{0x00fd, {0x00,0x18,0x30,0x60,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0x78,0x00}},
	{0x00fe, {0x00,0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0x00,0x00,0x00,0x00}}
};

