// ----------------------------------------------------------------------------
// -                        Open3D: www.open3d.org                            -
// ----------------------------------------------------------------------------
// The MIT License (MIT)
//
// Copyright (c) 2018-2021 www.open3d.org
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------------------------------

#pragma once

#include "open3d/core/Dtype.h"
#include "open3d/t/geometry/Geometry.h"
#include "pybind/open3d_pybind.h"

namespace open3d {
namespace t {
namespace geometry {

// Geometry trampoline class.
template <class GeometryBase = Geometry>
class PyGeometry : public GeometryBase {
public:
    using GeometryBase::GeometryBase;

    GeometryBase& Clear() override {
        PYBIND11_OVERLOAD_PURE(GeometryBase&, GeometryBase, );
    }

    bool IsEmpty() const override {
        PYBIND11_OVERLOAD_PURE(bool, GeometryBase, );
    }

    core::Device GetDevice() const override {
        PYBIND11_OVERLOAD_PURE(core::Device, GeometryBase, );
    }
};

void pybind_geometry(py::module& m);
void pybind_geometry_class(py::module& m);
void pybind_drawable_geometry_class(py::module& m);
void pybind_tensormap(py::module& m);
void pybind_image(py::module& m);
void pybind_pointcloud(py::module& m);
void pybind_lineset(py::module& m);
void pybind_trianglemesh(py::module& m);
void pybind_image(py::module& m);
void pybind_boundingvolume(py::module& m);
void pybind_voxel_block_grid(py::module& m);
void pybind_raycasting_scene(py::module& m);

}  // namespace geometry
}  // namespace t
}  // namespace open3d
