Руководство пользователя OpenGNB

*Примечание. Большая часть содержания этой статьи переведена с помощью переводчика Google с китайской версии «Руководства пользователя OpenGNB», содержание этой статьи зависит от китайской версии.*

# Обзор

[OpenGNB](https://github.com/gnbdev/opengnb "OpenGNB") — это децентрализованная P2P-VPN с открытым исходным кодом и возможностью проникновения во внутреннюю сеть.

GNB — это децентрализованная сеть, каждый узел в сети является одноранговой, и в ней нет концепции сервера и клиента.

Идентификатор каждого узла в каждой сети GNB, созданной пользователем, уникален и называется **nodeid** , который представляет собой 32-битное целое число без знака.

Узлы GNB могут находить другие узлы GNB через индексный узел и устанавливать связь.В этом процессе роль индексного узла GNB аналогична **трекеру** в **DNS** и **Bit Torrent**.

Когда GNB связывается с индексным узлом, в качестве уникальных идентификаторов используются открытый ключ **ed25519** и дайджест sha512 `passcode` и **nodeid**. На основе этой функции индексный узел GNB может предоставлять услуги индексирования. для многих сетей GNB без конфликтных ситуаций могут возникать конфликты.

Узлы GNB также могут находить другие узлы GNB по доменному имени, статическому IP-адресу или трансляции в интрасети.

GNB позволяет узлам, расположенным в локальной сети, успешно устанавливать P2P-связь с другими узлами через обход NAT с помощью многих методов, включая, помимо прочего, обнаружение порта, upnp, мультииндекс, мультисокет и т. д. В худшем случае, когда два узла GNB Когда P2P-соединение не может быть установлено, полезная нагрузка может быть передана через другие узлы в сети.

Операционные системы и платформы, которые в настоящее время поддерживаются GNB, включают Linux, Windows10, macOS, FreeBSD, OpenBSD, Raspberry Pi и OpenWRT.Если не указано иное, этот документ относится к дистрибутивам этих поддерживаемых платформ и версиям, скомпилированным для конкретных платформ.



# развертывать GNB



## GNB публичный инод

***GNB Public Index node** предоставляет только службу индексирования, не открывает устройство TUN, не создает виртуальный IP-адрес, не обрабатывает группировку IP-адресов, не требует запуска с правами root и предоставляется добровольцами.

Команда для запуска узла GNB в режиме **Public Index** может быть

Начать прослушивание на порту 9001 по умолчанию
```
gnb -P
```

Начать прослушивание порта 9002
```
gnb -P -l 9002
```



## Облегченный режим для GNB

В **Lite Mode** нет необходимости создавать пару ключей **ed25519** и файл конфигурации для узла, а узел GNB можно запустить, задав параметры командной строки.

Параметр **upnp** включен по умолчанию в **Lite Mode**.

Исходный код GNB жестко кодирует сеть GNB с 5 узлами для использования в **Lite Mode**.
```
nodeid       tun address
1001         10.1.0.1/255.255.0.0
1002         10.1.0.2/255.255.0.0
1003         10.1.0.3/255.255.0.0
1004         10.1.0.4/255.255.0.0
1005         10.1.0.5/255.255.0.0
```

Это значительно упрощает процесс развертывания.

**Lite Mode** 下的 GNB 节点 通过 `####passcode###` 生成通讯密钥，安全性远低于基于 **ed25519** 的非对称加密的安全模式。

Узлы GNB в ***Lite Mode** генерируют ключи связи с помощью `passcode`, что гораздо менее безопасно, чем асимметричное шифрование на основе **ed25519**.

Ниже приведен набор команд, которые запускаются на узле A и узле B соответственно для реализации виртуальной сети и должны выполняться с правами **root**.

на хосте А
```
gnb -n 1001 -I "$public_index_ip/$port" -l 9001 --multi-socket=on -p 12345678
```

на хосте B
```
gnb -n 1002 -I "$public_index_ip/$port" -l 9002 --multi-socket=on -p 12345678
```

На этом этапе вы должны увидеть, что IP-адрес TUN на хосте A — 10.1.0.1, а IP-адрес TUN на хосте B — 10.1.0.2. В это время, если два узла устанавливают соединение, они могут получить доступ друг к другу.

Конечно, пользователи могут установить больше узлов в **Lite Mode**, что требует понимания `-n`, `-I`, `-a`, `-r`, `-p` и т. д. в `gnb. ` использование параметров.



## Безопасный режим для GNB

Чтобы запустить GNB в режиме **Safe Mode**, вам необходимо правильно установить файлы `node.conf` `address.conf` `route.conf` и открытый и закрытый ключи **ed25519**, эти файлы должны быть быть помещен в каталог, имя каталога может быть **nodeid**.

где `address.conf` не является обязательным.
Предполагая, что узел с идентификатором узла 1000 работает в глобальной сети в качестве индексного узла, а другие узлы GNB находят узел 1000 с помощью конфигурации `address.conf`, тогда, как правило, узел 1000 не нуждается в `address.conf`.

Если вы создали несколько узлов GNB, вы можете поместить каталоги конфигурации этих узлов в `gnb/conf/` для удобства управления.



### Структура каталогов

Возьмите узлы `1001` `1002` `1003` в качестве примера, каталоги конфигурации этих узлов следующие:

```
gnb/conf/1001/

gnb/conf/1001/node.conf
gnb/conf/1001/address.conf
gnb/conf/1001/route.conf
gnb/conf/1001/security/1001.private
gnb/conf/1001/security/1001.public
gnb/conf/1001/ed25519/1002.public
gnb/conf/1001/ed25519/1003.public
gnb/conf/1001/scripts
```

```
gnb/conf/1002/

gnb/conf/1002/node.conf
gnb/conf/1002/address.conf
gnb/conf/1002/route.conf
gnb/conf/1002/security/1002.private
gnb/conf/1002/security/1002.public
gnb/conf/1002/ed25519/1001.public
gnb/conf/1002/ed25519/1003.public
gnb/conf/1002/scripts
```

```
gnb/conf/1003/

gnb/conf/1003/node.conf
gnb/conf/1003/address.conf
gnb/conf/1003/route.conf
gnb/conf/1003/security/1003.private
gnb/conf/1003/security/1003.public
gnb/conf/1003/ed25519/1001.public
gnb/conf/1003/ed25519/1002.public
gnb/conf/1003/scripts
```

Предполагая, что каталоги конфигурации этих узлов были развернуты на разных хостах, команды для запуска узлов `1001`,`1002`, `1003` могут быть следующими:
```
gnb -c gnb/conf/1001
gnb -c gnb/conf/1002
gnb -c gnb/conf/1003
```

`scripts/`目录下存放的是在虚拟网卡启动/关闭后调用的脚本，用于用户自定义设置路由，防火墙的指令。

В каталоге `scripts/` хранятся сценарии, вызываемые после запуска/закрытия виртуальной сетевой карты, которые используются для заданной пользователем маршрутизации и инструкций брандмауэра.



### обмен ключами

В **Safe Mode** узлы GNB обмениваются коммуникационными ключами с помощью асимметричного шифрования (ed25519), которое является основой связи узла GNB, поэтому для связи необходимо создать набор открытых и закрытых ключей для каждого узла GNB.

Открытый и закрытый ключи называются с UUID узла в качестве имени файла, .private и .public в качестве суффикса файла, а файлы открытого и закрытого ключей узла, чей UUID равен 1001, должны быть `1001.public` `1001.private`

GNB предоставляет инструмент командной строки под названием `gnb_crypto` для создания открытых и закрытых ключей,

Команда для создания открытых и закрытых ключей **ed25519** для узлов `1001` `1002` `1003`:

`gnb_crypto -c -p 1001.private -k 1001.public`
`gnb_crypto -c -p 1002.private -k 1002.public`
`gnb_crypto -c -p 1003.private -k 1003.public`

Для обмена открытыми ключами нужно поместить эти открытые и закрытые ключи **ed25519** в правильный каталог.

На узле с **nodeid** `1001`:
`Gnb/conf/1001/security/`mùlù xià yīnggāi yǒu `1001.Private``1001.Public`
61 / 5,000
翻译结果
Каталог `gnb/conf/1001/security/` должен иметь `1001.private` `1001.public` 
Каталог `gnb/conf/1001/ed25519/` должен иметь `1002.public` `1003.public`

На узле с **nodeid** `1002`:
Каталог `gnb/conf/1002/security/` должен иметь `1002.private` `1002.public`
Каталог `gnb/conf/1002/ed25519/` должен иметь `1001.public` `1003.public`

На узле с **nodeid** `1003`:
Каталог `gnb/conf/1003/security/` должен иметь `1003.private` `1003.public`
Каталог `gnb/conf/1003/ed25519/` должен иметь `1001.public` `1002.public`

На основе асимметричного шифрования узлы в одной сети GNB также могут установить один и тот же `passcode` для защиты коммуникационного ключа.

Для получения информации о ключе связи GNB см. описание `--crypto` `--crypto-key-update-interval` `--passcode`.



### ### файл конфигурации node.conf

Вот пример `node.conf`:
```
nodeid 1001
listen 9001
```

`node.conf` Используется для хранения информации о конфигурации узла в следующем формате.
```
nodeid $nodeid
listen $listen_port
```
или
```
nodeid $nodeid
listen ip_address:$listen_port
```

GNB поддерживает IPV6 и IPV4.

Есть несколько опций, на которые стоит обратить внимание, которые могут значительно улучшить возможности обхода NAT GNB:
```
es-argv      "--upnp"
```
Попробуйте включить upnp, чтобы упростить передачу IP-пакетов из глобальной сети.

```
multi-socket on
```
Откройте больше портов прослушивания UDP и увеличьте вероятность успешного обнаружения порта для обхода NAT.

После включения `multi-socket` в дополнение к исходному порту `listen` будут открыты 4 дополнительных случайных порта UDP. Если вы хотите дополнительно контролировать указанный порт, вы можете использовать несколько `listen` Элемент настройки, GNB поддерживает `listen` для указания 5 адресных портов IPV6 или `listen6` для прослушивания 5 адресов и портов IPV6 и `listen4` для прослушивания 5 адресных портов IPV4.

Элементы конфигурации, поддерживаемые `node.conf`, соответствуют параметрам командной строки gnb один за другим. В настоящее время поддерживаются следующие элементы конфигурации:
```
ifname nodeid listen listen6 listen4 ctl-block multi-socket disabled-direct-forward ipv4-only ipv6-only passcode quiet daemon mtu set-tun address-secure node-worker index-worker index-service-worker node-detect-worker port-detect-range port-detect-start port-detect-end pid-file node-cache-file log-file-path log-udp4 log-udp-type console-log-level file-log-level udp-log-level core-log-level pf-log-level main-log-level node-log-level index-log-level detect-log-level es-argv
```



### файл конфигурации route.conf

Пакет данных, передаваемый между узлами GNB, называется **gnb payload**, таблица маршрутизации используется всеми узлами в сети, файл конфигурации — route.conf, его функция — указать, как Ядро GNB "route"Эти **gnb payload**, содержащие IP-пакеты.

Каждый элемент конфигурации маршрутизации занимает одну строку.Существует два типа элементов конфигурации маршрутизации: **forward** и **relay**, которые используются для установки payload Способ доступа к равноправному узлу.



#### Разница между форвардом и реле:

**forward** По умолчанию GNB определяет отправку на указанный узел GNB в соответствии с элементами конфигурации в `route.conf` и адресом назначения IP-пакета.

Например, в `route.conf` есть строчка
```
1001|10.1.0.1|255.255.255.0
```

Когда GNB обрабатывает IP-пакет с адресом назначения 10.1.0.1, он определяет, что этот IP-пакет необходимо зашифровать и инкапсулировать с помощью коммуникационного ключа узла, **nodeid** которого равен 1001, в **gnb payload** отправляется на узел 1001, этот процесс мы называем **direct forwarding**.

Когда два узла не устанавливают связь P2P, если есть узел с атрибутом f, определенным в `address.conf`, текущий узел будет проходить через этот узел, называемый **forward node** Вверх и вперед **gnb payload** к узлу назначения.

**relay** Ретранслирует **gnb payload** через четкий настраиваемый путь ретрансляции, **gnb payload** во время процесса ретрансляции. релейный узел.

Маршрут между узлами может быть **forward** или **relay** или комбинацией **forward** и **relay**.

Из-за сквозного шифрования узлы **forward node** и **relay node** не могут получить IP-пакеты в полезной нагрузке **gnb payload** в оба конца связи.



#### route type forward

Связь между узлами по умолчанию двухточечная, если в конфигурации есть узлы forward, в случае неудачи точка-точка или обязательный forward Сообщение будет перенаправлено через узел forward;

Вот пример типа `route.conf`  forward  :
```
1001|10.1.0.1|255.255.255.0
1002|10.1.0.2|255.255.255.0
1003|10.1.0.3|255.255.255.0
```

Каждая строка в конфигурационном файле представляет собой описание узла в следующем формате
```
$nodeid|$tun_ipv4|$tun_netmask
```

Значение каждого элемента конфигурации следующее:
`$nodeid`                UUID узла
`$tun_ipv4`           IPV4-адрес виртуальной сетевой карты
`$tun_netmask`    Маска подсети IPV4-адреса виртуальной сетевой карты



#### route type relay

Чтобы установить узел ретрансляции для узла назначения, вы можете настроить до 8 маршрутов ретрансляции для однорангового узла, и каждый маршрут ретрансляции может иметь до 5 узлов ретрансляции.

Вот несколько примеров реле типа `route.conf`:


```
1006|1003
1006|auto,static
```
Роль этой группы маршрутов такова: когда текущий узел не может установить P2P-связь с узлом 1006, IP-пакет, отправленный на узел 1006, будет ретранслироваться через узел 1003.


```
1006|1003,1004,1005
1006|force,static
```
Смысл этой группы маршрутов таков: IP-пакеты, отправленные текущим узлом на узел 1006, принудительно ретранслируются на узел 1006 через 1005, 1004 и 1003 по порядку.


```
1006|1003,1005
1006|1005,1004
1006|1005,1003
1006|force,balance
```
Роль этой группы маршрутов такова: существует 3 маршрута ретрансляции от текущего узла к узлу 1006, а стратегия выбора маршрутов при отправке IP-пакетов — балансировка нагрузки.

Соответствующие элементы настройки имеют следующий формат:
```
$nodeid|$relay_nodeid3,$relay_nodeid2,$relay_nodeid1
$nodeid|$relay_mode
```

Путь для полезной нагрузки локального узла для достижения равноправного узла через узел ретрансляции: local_node => relay_node1 => relay_node2 => relay_node3 => dst_node, а путь от dst_node до local_node определяется конфигурацией route.conf узла одноранговый dst_node.

`$relay_mode` может быть **auto**, **force**, **static**, **balance**

**auto**         Когда двухточечная связь с узлом назначения невозможна и нет переадресации прямого узла, она пересылается по заранее установленному маршруту ретрансляции.
**force**        Принудительно маршрутизировать связь с этим целевым узлом через ретранслятор.
**static**       Когда узел назначения имеет несколько маршрутов ретрансляции, используйте первый маршрут ретрансляции.
**balance**   Когда узел назначения имеет несколько маршрутов ретрансляции, маршрут ретрансляции выбирается с балансировкой нагрузки.



### файл конфигурации address.conf

`address.conf` используется для настройки свойств узла, общедоступного IP-адреса и порта. Ниже приведен пример:

```
i|0|a.a.a.a|9001
if|1001|b.b.b.b|9001
n|1002|c.c.c.c|9001
```

`aaaa` `bbbb` `cccc` в файле представляет собой IP-адрес физической сетевой карты узла, который необходимо заполнить в соответствии с реальной ситуацией Каждая строка в файле конфигурации представляет собой описание адреса, и формат следующий

```
$attrib|$nodeid|$ipv4/$ipv6/$hostname|$port
```

**$attrib**         Атрибут узла представлен набором символов, i означает, что этот узел является индексным узлом, f означает, что этот узел является узлом forward, n означает, что этот узел является нормальный узел; s является тихим (Slience) узлом, если локальный узел содержит атрибут s, он не будет связываться с индексным узлом, а также не будет отвечать на запросы пинг-понга и определения адреса, чтобы раскрыть локальный IP-адрес
**$nodeid**       nodeid узла, который соответствует **$nodeid** в `route.conf`
**$ipv6**             IPV6-адрес узла GNB
**$ipv4**             IPV4-адрес узла GNB
**$hostname**  Доменное имя узла GNB
**$port**             Сервисный порт узла GNB


Если узел имеет несколько IP-адресов, его необходимо настроить в несколько строк в соответствии с форматом. GNB будет использовать протокол **GNB node ping-pong**, чтобы определить, какой IP-адрес узла имеет более высокий IP-адрес Низкая задержка, при отправке данных IP-пакета они автоматически отправляются на адрес с низкой задержкой.

Процесс `gnb` не интерпретирует доменное имя **$hostname** в `address.conf`, но обрабатывается асинхронно с помощью `gnb_es`.

Как упоминалось выше, функция индексного узла аналогична **трекеру** в **DNS** и **Bit Torrent**.Если группа узлов GNB, которые не знают IP-адрес и порт друг друга, отправляется в тот же индекс. Узел отправляет свой собственный IP-адрес и порт, затем эти узлы GNB могут запрашивать IP-адрес и порт однорангового узла из индекса через открытый ключ однорангового узла.

Атрибут **i** требуется в **$attrib** индексного узла в `address.conf`.

Протокол индекса GNB позволяет не проверять цифровую подпись сообщения в процессе отправки и запроса порта IP-адреса узла, то есть узлу индекса разрешено не проверять цифровую подпись сообщения, которое отправляет и запрашивает ip, а узел не отвечает на сообщение запроса ip к индексному узлу.Проверьте цифровые подписи.

**GNB Public Index node** Соответствующий **nodeid** в `address.conf` может быть установлен на **0**, он не обязательно должен быть в `route .conf` В правиле route приведен пример узла **GNB Public Index node**:
```
i|0|a.a.a.a|9001
```

forward  Узел **$attrib** имеет значение **f**, **$nodeid** не может быть установлен на **0** и должен быть привязан ####nodeid ## ## Появляется как элемент конфигурации в `route.conf`, gnb forward Пакеты, относящиеся к протоколу, должны отправлять цифровую подпись узла проверки, то есть forward , и узел, пересылающий сообщение через узел forward, должны обменяться открытыми ключами друг с другом.

Передающий узел может пересылать IP-пакеты для узлов GNB, которые не могут получить прямой доступ друг к другу. Эти узлы обычно развернуты во внутренней сети и не имеют фиксированного IP-адреса общедоступной сети. # Одноранговая связь достигается за счет проникновения, forward не могут расшифровать содержимое сообщения между двумя узлами.

Пользователи, конечно, могут использовать узел GNB в качестве узла index и узла forward в сети GNB, а также могут предоставлять индекс для других Сервис сетей GNB, вот пример:
```
if|1001|b.b.b.b|9001
```

В `address.conf` может быть несколько узлов индекса и узлов пересылки, и их можно передавать через
`--multi-index-type` `--multi-forward-type` Установить балансировку нагрузки и режим отказоустойчивости.

Предполагая, что узел GNB может иметь несколько IP-адресов с NAT одновременно после очень сложной трансляции адресов в локальной сети, то есть оператор может выбрать разные выходы шлюза в соответствии с адресом назначения хоста в локальной сети, получающего доступ к глобальной сети. `address.conf` имеет несколько узлов индекса, тогда при обходе NAT одноранговый узел GNB может знать больше адресов и портов узла, тем самым увеличивая вероятность успешного обхода NAT для установления связи P2P.



### Об открытии в Лан

**Discover In Lan** позволяет узлам GNB обнаруживать другие узлы GNB в локальной сети с помощью широковещательной рассылки, что позволяет устанавливать узлы GNB в той же локальной сети без предварительного прохождения через глобальную сеть для начала связи с проникновением через NAT.

**Discover In Lan** Реализовано в `gnb_es`.

Чтобы `gnb_es` всегда прослушивал широковещательные пакеты от других узлов в локальной сети, `gnb_es` должен быть запущен как служба или демон с параметром `-L, --discover-in-lan`.

Следующий узел 1002 является примером

```
gnb_es -s -L -b gnb/conf/1002/gnb.map
```

`gnb.map` – это файл сопоставления общей памяти, созданный процессом `gnb`. Если не указано иное, этот файл сопоставления будет создан в каталоге конфигурации узла (`gnb/conf/1002/`); через эту общую память, `gnb_es` может передавать информацию от других узлов GNB, контролируемых в локальной сети, процессу gnb; в то же время, `gnb_es` также регулярно передает информацию о своем собственном узле в локальной сети, чтобы его могли обнаружить другие узлы в ЛВС.

В процессе развертывания узлов GNB пользователи обнаружат, что в некоторых случаях некоторые узлы GNB в одной и той же локальной сети могут успешно пройти через NAT и успешно установить P2P-связь с узлами в другой удаленной локальной сети, в то время как некоторым узлам не удается добиться успеха с помощью **Discover In Lan** не только легче подключить больше узлов, но и узлы, которые успешно прошли NAT, могут помочь другим узлам в той же локальной сети пересылать IP-пакеты.

Для получения дополнительной информации о **Discover In Lan** вы можете обратиться к `-b, --ctl-block` из `gnb` и `-s, --service` `-d, - из `gnb_es` - daemon` `-L, --discover-in-lan` опции.



### net to net

Вообще говоря, VPN может объединить несколько компьютеров в сеть, установив виртуальную ссылку, или разрешить одному компьютеру доступ к сети через виртуальную ссылку, а также может соединить два или более компьютеров через виртуальную ссылку.Сеть образует большую виртуальную сеть. , чтобы компьютеры, разбросанные по разным сетям, могли получить доступ друг к другу.

Такая архитектура, объединяющая несколько сетей в виртуальную сеть через виртуальный канал VPN, называется **net to net**.

GNB делает развертывание ** сети к сети ** очень простым.Благодаря мощным возможностям обхода NAT GNB может легко объединить несколько локальных сетей, расположенных в разных местах, для формирования виртуальной сети, и большую часть времени одна из этих локальных сетей является виртуальной. Существует прямая связь P2P между двумя сетями без необходимости передачи центрального узла, так что связь между сетями не ограничивается пропускной способностью центрального узла.

Если предположить, что есть две удаленные **LAN A** и **LAN B**, имеющие доступ к Интернету через NAT, и оба шлюза этих двух локальных сетей являются маршрутизаторами OpenWRT, то на маршрутизаторе OpenWRT необходимо развернуть только два узла GNB. , с помощью WAN на индексном узле GNB для обеспечения проникновения NAT узлы в **LAN A** и **LAN B** могут получить доступ друг к другу.

Если предположить, что есть две удаленные **LAN A** и **LAN B**, имеющие доступ к Интернету через NAT, и оба шлюза этих двух локальных сетей являются маршрутизаторами OpenWRT, то на маршрутизаторе OpenWRT необходимо развернуть только два узла GNB. для доступа в Интернет через NAT. Установив связь P2P, узлы в **LAN A** и **LAN B** могут получить доступ друг к другу.
В этом процессе обычно необходимо иметь индексный узел GNB, расположенный в глобальной сети, чтобы помочь двум узлам GNB найти друг друга.В следующем примере, чтобы гарантировать, что два узла могут взаимодействовать, даже если обход NAT не удался , можно развернуть Передовой узел также предоставляет службу индексирования.



Таким образом, необходимо развернуть 3 узла GNB:

**nodeid**=1001  в WAN, как узлы index и forward####,，IP= x.x.x.x  port = 9001
**nodeid**=1002  На маршрутизаторе OpenWRT в **LAN A**，NetWork=192.168.0.0/24
**nodeid**=1003  На маршрутизаторе OpenWRT в **LAN B**,NetWork=192.168.1.0/24



настраивать **node 1001**

`conf/1001/node.conf`
```
nodeid 1001
listen 9001
```

`conf/1001/route.conf`
```
1001|10.1.0.1|255.255.255.0
1002|10.1.0.2|255.255.255.0
1003|10.1.0.3|255.255.255.0
```



Установите **node 1002** в **LAN A**

`conf/1002/node.conf`
```
nodeid 1002
listen 9002
multi-socket on
es-argv --upnp
```

`conf/1002/route.conf`
```
1001|10.1.0.1|255.255.255.0
1002|10.1.0.2|255.255.255.0
1003|10.1.0.3|255.255.255.0
1003|192.168.1.0|255.255.255.0
```

`conf/1002/address.conf`
```
if|1001|x.x.x.x|9001
```
x.x.x.x — это IP-адрес WAN узла 1001, который необходимо заполнить в соответствии с реальной ситуацией.

`conf/1002/scripts/if_up_linux.sh`
```
ip route add 192.168.1.0/24 via 10.1.0.3
```
Назначение этой инструкции маршрутизации: когда хост в **LAN A** хочет отправить IP-пакет с адресом назначения 192.168.1.0/24, поскольку сеть **LAN A** — 192.168. 0.0/24``, так что эта цель `192.168.1.0/24`. IP-пакеты будут отправлены на шлюз OpenWRT Router по умолчанию, поскольку установлено это правило маршрутизации, эти IP-пакеты будут перенаправлены на устройство TUN для захвата и инкапсулируется процессом GNB как ** Полезная нагрузка gnb**, наконец, отправляется на **node 1003**.

Несомненно, должна быть аналогичная директива маршрутизации на **node 1003**, чтобы IP-пакеты, предназначенные для `192.168.0.0/24`, могли достигать **node 1003**, процессы GNB в конечном итоге отправляются на **node 1002**. на.

Установите **node 1003** в **LAN B**

`conf/1003/node.conf`
```
nodeid 1003
listen 9003
multi-socket on
es-argv --upnp
```

`conf/1003/route.conf`
```
1001|10.1.0.1|255.255.255.0
1002|10.1.0.2|255.255.255.0
1003|10.1.0.3|255.255.255.0
1003|192.168.1.0|255.255.255.0
```

`conf/1003/address.conf`
```
if|1001|x.x.x.x|9001
```

`conf/1003/scripts/if_up_linux.sh`
```
ip route add 192.168.0.0/24 via 10.1.0.2
```

Обычно OpenWRT имеет некоторые правила брандмауэра по умолчанию, что может привести к блокировке IP-пакетов, пересылаемых GNB на хост в текущей локальной сети.Поэтому здесь необходимо обнаружить OpenWRT.Как правило, в брандмауэре следует установить параметр Forward для принятия. , а для переадресации, связанной с Wan, установлено значение «принять».

Убедившись, что конфигурация верна, вы можете сначала запустить **node 1001**, затем **node 1002** и **node 1003**, так что **node 1001** может быть первым **node 1002** И **node 1003** предоставляет службу индексирования.

После запуска **node 1001**, **node 1002** и **node 1003** вы можете сначала попробовать виртуальные IP-адреса, соответствующие этим трем узлам GNB, а именно: 10.1.0.1, 10.1.0.2, 10.1. .0.3` может успешно пройти пинг-тест.

Если все пойдет хорошо, вы можете попытаться пропинговать хост в **LAN B** с хоста в **LAN A**.

Например, пропингуйте хост с IP-адресом 192.168.0.2 в **LAN A** и хост с IP-адресом 192.168.1.2 в **LAN B**. противоположное направление.

На этом этапе, если обнаружено, что виртуальные IP-адреса, соответствующие трем узлам GNB, могут пройти пинг-тест, но хосты в двух локальных сетях не могут пройти пинг-тест, вы можете вернуться к предыдущим шагам, чтобы проверить брандмауэр. правила для OpenWRT и хоста обнаружения.правила брандмауэра.





# Об обходе NAT GNB

Абсолютная способность проникновения NAT может быть самой интересной особенностью GNB, но это еще не все GNB.Пользователям предстоит изучить множество ценных функций GNB.

В сложной сетевой среде иногда трудно установить P2P-связь с другими узлами посредством успешного обхода NAT.Чтобы повысить вероятность успешного прохождения NAT узла, необходимо ввести NAT (преобразование сетевых адресов) и GNB в Обход NAT в деталях, проделанная работа.

Как правило, для некоторых хостов, которые получают доступ к Интернету через NAT в локальной сети, процесс NAT (преобразование сетевых адресов) будет включать, помимо прочего, оборудование маршрутизации в локальной сети, структуру сети, сетевое оборудование, используемое операторами, сеть. Архитектура, стратегия NAT и многие другие сетевые среды представляют собой почти «черный ящик». IP-адрес пакета может претерпевать несколько трансляций, и может быть несколько выходных шлюзов. Это неопределенные факторы в процессе обхода NAT.

**Don't talk about the white paper, who known? who care?**

**Don't talk about the type of NAT,  I don‘t  f*cking care**

**What GNB has to do, just try it's best to traverse the NAT**

Нет сомнений в том, что GNB был вдохновлен **Bit Torrent** этим программным обеспечением P2P, поскольку два хоста в разных локальных сетях, получающих доступ к Интернету через NAT, могут установить связь P2P для передачи блоков файловых данных, то это означает, что этот режим также можно использовать. для передачи IP-пакетов для виртуальных сетевых карт.

GNB использует различные стратегии для обеспечения успешного обхода NAT, среди которых некоторые стратегии очень эффективны, некоторые неэффективны, а некоторые стратегии эффективны в одних ситуациях и могут быть неэффективны в других.

Во-первых, локальный узел получает адреса и порты WAN других узлов, связываясь и обмениваясь информацией с индексным узлом, и пытается связаться с этими узлами;

На самом деле, некоторые узлы будут использовать более одного адреса WAN для доступа в Интернет после NAT.GNB поддерживает обмен информацией с несколькими индексными узлами одновременно, так что есть шанс найти больше WAN-адресов равноправного узла.

Для одноранговых узлов, которые определены в route.conf и не установили P2P-связь, процесс GNB будет периодически запрашивать у индексного узла порты WAN-адресов этих узлов и пытаться инициировать связь.

GNB обнаружит небольшой диапазон портов для однорангового узла, который получил адрес WAN, но не установил связь P2P.

У GNB также есть специальный поток для периодического обнаружения большого количества портов для заказов, которые не могут установить P2P-связь.

Как и большинство программ P2P, таких как **Bit Torrent**, GNB также попытается установить сопоставление адресов и портов на выходном шлюзе через UPNP, чтобы повысить вероятность успешного проникновения NAT.

Следует отметить, что если в локальной сети есть несколько хостов, на которых развернуты узлы GNB и включен UPNP, эти узлы не должны прослушивать один и тот же порт, что вызовет конфликты, когда шлюз установит сопоставление портов UPNP.

Если шлюз, на котором расположен хост, поддерживает и включает службу UPNP, а при запуске GNB используется параметр --es-argv "--upnp"`, вероятность успешного проникновения через NAT будет значительно повышена. Подробнее см. см. `--es- из `gnb` argv "--upnp"` и параметр `--upnp` для `gnb_es`.

Поскольку отслеживание порта UDP и включение UPNP может эффективно повысить вероятность успешного проникновения через NAT, то, отслеживая больше портов UDP и устанавливая больше сопоставлений портов UPNP на шлюзе, можно еще больше повысить вероятность успешного проникновения через NAT. узнать об опции `--multi-socket`.

В некоторых сетевых средах полное понимание функций `--es-argv "--upnp"` из `gnb`, `--multi-socket` и `--upnp` из `gnb_es` может быть очень эффективным для улучшения GNB Уровень успешности проникновения узла через NAT.

Использование параметра `--dump-address` в `gnb_es` может сделать адресную информацию узлов, которые установили P2P-связь, регулярно сохраняемой в указанном файле кеша узла, при изменении файла конфигурации или обновлении программы или перезапуске хоста, вам необходимо перезапустить `gnb`, вы можете использовать параметр `--node-cache-file`, чтобы указать файл кэша узла, чтобы быстро восстановить связь. Следует отметить, что некоторые узлы могут не работать. Для получения подробной информации см. вы можете узнать о `--node- из `gnb` Опция `--dump-address` кэш-файла` опция `gnb_es`.

В дополнение к поиску других узлов через индексный узел, узлы GNB также могут настроить доменное имя или динамическое доменное имя однорангового узла в «address.conf». столь же эффективен, как и использование индексного узла. Хорошо помогает установить P2P-связь.

До сих пор GNB проделал большую работу по проникновению NAT в узлы, и успешность проникновения NAT достигла беспрецедентной высоты, но этого все еще недостаточно.


`--broadcast-address` в `gnb_es` позволяет узлу GNB распространять адресную информацию узла, который установил P2P-связь с этим узлом, на другие узлы, чтобы эти узлы могли получать больше информации об адресах других узлов в сети. Сеть GNB Для повышения успешности проникновения NAT.

С помощью **Discover In Lan** несколько узлов GNB в одной и той же локальной сети могут реализовать P2P-связь без прохождения через WAN. которые успешно прошли NAT для передачи IP-пакетов для косвенной реализации P2P-связи.

Следует подчеркнуть, что даже если приложить много усилий, невозможно установить 100%-й уровень успеха для P2P-связи через проникновение NAT.Гибкое использование механизма, предоставляемого GNB, может значительно повысить вероятность успеха.





# О проникновении шлюза / брандмауэра IPV6 GNB

В общем, IPv6-адреса - это WAN-адреса, но это не означает, что хосты с IPV6 за шлюзом не должны проникать.Конечно, это проникновение нельзя назвать проникновением NAT, но можно назвать проникновением NAT. .
Из-за роли брандмауэра, расположенного на шлюзе, политика брандмауэра некоторых шлюзов (например, маршрут OpenWRT) по умолчанию не разрешает IP-пакеты из глобальной сети, инициированные противоположным хостом, что требует, чтобы хосты на обоих концах отправлялись на порты друг друга почти одновременно.Отправляйте IP-пакеты.

Нет никаких сомнений в том, что проникновение через шлюз/брандмауэр IPV6 намного проще, чем проникновение через NAT IPV4, и вероятность успеха может достигать 100%.

GNB выполняет некоторую работу по проникновению шлюза/брандмауэра в IPV6.

Предполагая, что некоторые узлы GNB за шлюзом имеют адреса IPV6, в то время как узлы индекса, расположенные в глобальной сети, не имеют адресов IPV6, и узлы индекса не могут напрямую получить адреса IPV6 узлов GNB за шлюзом и, следовательно, не могут помочь этим узлам установить связь.Чтобы решить эту проблему, узел GNB за шлюзом должен получить адрес IPV6 хоста, на котором он расположен, и сообщить об этом узлу индекса.

Предполагая, что хост имеет адрес IPV6, можно использовать одну из следующих двух команд, чтобы получить адрес IPV6 хоста и сохранить его в файле.

```
dig -6 TXT +short o-o.myaddr.l.google.com @ns1.google.com | awk -F'"' '{ print $2}' > /tmp/wan6_addr.dump
```

```
wget http://api.myip.la -q -6 -O /tmp/wan6_addr.dump
```

以节点 1002 为例
```
gnb_es -b gnb/conf/1002/gnb.map --wan-address6-file=/tmp/wan6_addr.dump
```
Через общую память `gnb` и `gnb_es` процесс `gnb` может получить адрес IPV6, где находится узел, и сообщить об этом узлу индекса.

Для получения дополнительной информации см. `-b, --ctl_block` и `--wan-address6-file` в `gnb_es`





# Скомпилируйте, создайте и запустите среду GNB

С точки зрения безопасности, пользователи должны максимально компилировать и собирать GNB самостоятельно, а если нет условной компиляции и сборки, то максимально использовать бинарные пакеты из надежных источников.

GNB является проектом с открытым исходным кодом, и нет необходимости устанавливать файлы сторонних библиотек разработки в процессе компиляции и построения. Весь исходный код сосредоточен в каталоге `src/`, и весь используемый сторонний открытый исходный код сосредоточены в каталоге `libs/`, поэтому GNB очень легко компилируется и собирается на различных платформах ОС.



## FreeBSD

```
make -f Makefile.freebsd
```



## OpenBSD

```
make -f Makefile.openbsd
```



## Linux

```
make -f Makefile.linux
```



## OpenWRT

```
make -f Makefile.openwrt
```

Чтобы скомпилировать и собрать GNB, работающий на OpenWRT, вам нужно перейти на [https://downloads.openwrt.org/releases/](https://downloads.openwrt.org/releases/ "downloads"), чтобы загрузить соответствующий OpenWRT номер версии и аппаратная платформа OpenWRT SDK.
Перед загрузкой `OpenWRT SDK` обязательно подтвердите номер версии OpenWRT и аппаратную платформу, соответствующую SDK, иначе скомпилированная программа не будет работать на целевой прошивке.
Посетите официальный веб-сайт OpenWRT для получения дополнительной информации о OpenWRT SDK.

Как правило, прошивка OpenWRT по умолчанию не устанавливает kmod-tun, который является модулем ядра виртуальной сетевой карты в Linux. GNB необходимо загрузить этот модуль ядра при реализации коммутации уровня 3.

Некоторые файловые системы прошивки OpenWRT имеют некоторые особенности. GNB не может создать файл карты общей памяти `gnb.map` с помощью системного вызова **mmap** в этих файловых системах, а каталог `/etc` оказывается там в файловой системе. , если пользователь помещает каталог конфигурации узла в `/etc`, по умолчанию GNB попытается создать файл карты общей памяти `gnb.map` в каталоге конфигурации узла, что сделает невозможным запуск процесса. b, --ctl-block` Укажите файл карты общей памяти `gnb.map`, например, в каталог `/tmp`.

Если файловая система, используемая прошивкой, **ext4**, эта проблема не возникнет.



## macOS

```
make -f Makefile.Darwin
```

Для компиляции и сборки GNB в macOS необходимо установить Xcode.



## Windows

```
make -f Makefile.mingw_x86_64
```

`Makefile.mingw_x86_64` представляет собой Makefile, специально скомпилированный с помощью цепочки инструментов компиляции mingw под Linux, Также доступно в Windows. 

В Windows для запуска GNB требуется установка виртуальной сетевой карты, которую можно скачать здесь: [tap-windows](https://github.com/gnbdev/gnb_build/tree/main/if_drv/tap-windows ""downloads"")。

tap-windows 源码所在的仓库:[https://github.com/OpenVPN/tap-windows6](https://github.com/OpenVPN/tap-windows6 "tap-windows6") 





# 附录



## gnb的命令行参数

Выполните `gnb -h`, чтобы увидеть параметры, поддерживаемые gnb на текущей платформе.


#### -c, --conf
Укажите каталог узла gnb


#### -n, --nodeid
nodeid


#### -P, --public-index-service
Работает как общедоступная служба индексирования


#### -a, --node-address
node address


#### -r, --node-route
node route


#### -i, --ifname
Укажите имя виртуальной сетевой карты, которое недопустимо в macOS и Windows, в этих системах есть свои правила именования виртуальных сетевых карт.


#### -4, --ipv4-only
Отключите ipv6, gnb не будет отправлять и получать данные через адрес ipv6, виртуальная сетевая карта, включенная gnb, не будет привязывать адрес ipv6, поскольку ipv6 отключен, gnb может установить mtu меньше 1280, эту функцию можно использовать для некоторых сетевых сред с более ограничения попробуй с меньшим mtu


#### -6, --ipv6-only
Отключите ipv4, gnb не будет отправлять и получать данные через адрес ipv4, а виртуальная сетевая карта, включенная gnb, не будет привязываться к адресу ipv4.


#### -d, --daemon
Запущен как процесс-демон, Windows не поддерживает этот параметр


#### -q, --quiet
Отключить вывод в консоль


#### -t, --selftest
self test


#### -p, --passcode
a hexadecimal string of 32-bit unsigned integer, use to strengthen safety


#### -l, --listen
listen address default is "0.0.0.0:9001"


#### -b, --ctl-block
ctl block mapper file


#### -e, --es-argv
pass-through gnb_es argv


#### -V, --verbose
verbose mode


#### --node-woker-queue-length
node  woker queue length


#### --index-woker-queue-length
index woker queue length


#### --index-service-woker-queue
index service woker queue length


#### --port-detect-start
port detect start


#### --port-detect-end
port detect end


#### --port-detect-range
port detect range


#### --mtu
MTU виртуальной сетевой карты можно установить на 532 для ipv4 и 1280 для ipv6 в плохой сетевой среде.


#### --crypto
«xor» или «rc4» или «none» по умолчанию «xor»; установите алгоритм шифрования данных передачи gnb, выберите «none» означает отсутствие шифрования, по умолчанию используется xor, чтобы его также можно было использовать на оборудовании со слабым процессором. вычислительная мощность Более высокая пропускная способность данных. Алгоритм aes будет поддерживаться в будущем. Два узла gnb должны поддерживать один и тот же алгоритм шифрования для нормальной связи.


#### --crypto-key-update-interval
«час» или «минута» или нет по умолчанию «нет»; ключ может быть изменен между узлами gnb посредством синхронизации часов, которая зависит от того, что часы узла должны быть синхронизированы более точно, потому что часы некоторых узлов учитывается фактическая среда Может быть невозможно синхронизировать время во времени, поэтому эта опция не включена по умолчанию.Если узел, на котором работает gnb, может гарантировать синхронизацию часов, вы можете рассмотреть возможность выбора интервала для синхронизации и обновления ключа , что может повысить безопасность связи.


#### --multi-index-type
«простая отказоустойчивость» или «простая балансировка нагрузки» по умолчанию — «простая отказоустойчивость»; если задано несколько индексных узлов, вы можете выбрать способ выбора индексных узлов, балансировку нагрузки или отказоустойчивый режим, этот вариант еще не совершенен, и отказоустойчивый режим может выполняться только между узлами, обменявшимися коммуникационными ключами


#### --multi-forward-type
«простой отказоустойчивый» или «простой баланс нагрузки» по умолчанию «простой отказоустойчивый»; если есть несколько передающих узлов, вы можете выбрать метод прямого узла, балансировку нагрузки или отказоустойчивый режим.


#### --socket-if-name
пример: 'eth0', 'eno1', только для unix-подобных ОС; в unix-подобных системах данные gnb могут отправляться через указанную физическую сетевую карту, где пользователю необходимо ввести имя физической сетевой карты, Windows не поддерживает эту функцию, и я не вижу эту опцию


#### --address-secure
'hide part of ip address in logs 'on' or 'off' default is 'on'


#### --if-dump
'dump the interface data frame 'on' или 'off' по умолчанию 'off'; группировать ip виртуальной сетевой карты, открытой gnb, и выводить в лог, что удобно для отладки системы


#### --pf-route
packet filter route


#### --multi-socket
Когда обнаружение нескольких портов включено, вероятность успешного проникновения NAT может быть значительно повышена в процессе обнаружения порта проникновения NAT.


#### --direct-forwarding
'on' or 'off' default is 'on'


#### --set-tun
Не запускать виртуальную сетевую карту, этот параметр не требует привилегий root для запуска процесса, используется в службах index и fwd.


#### --index-worker
'on' or 'off' default is 'on'


#### --index-service-worker
'on' or 'off' default is 'on'


#### --node-detect-worker
'on' or 'off' default is 'on'


#### --set-fwdu0
'on' or 'off' default is 'on'


#### --pid-file
Укажите файл, сохраняющий id процесса gnb, которым удобно убивать процесс через скрипт, если этот файл не указан, pid-файл будет сохранен в каталоге конфигурации текущей ноды


#### --node-cache-file
gnb будет регулярно записывать IP-адрес и порт успешно подключенного узла в файл кеша.После завершения процесса gnb эта адресная информация не исчезнет, ​​и данные будут считаны при перезапуске процесса, так что можно будет запустить процесс gnb. Нет необходимости запрашивать адресную информацию узлов, которые были успешно подключены через индексный узел


#### --log-file-path
Укажите путь к выходному файлу журнала, если он не указан, файл журнала не будет создан.


#### --log-udp4
send log to the address ipv4 default is "127.0.0.1:9000"


#### --log-udp-type
the log udp type 'binary' or 'text' default is 'binary'


#### --console-log-level
log console level 0-3


#### --file-log-level
log file level    0-3


#### --udp-log-level
log udp level      0-3


#### --core-log-level
core log level    0-3


#### --pf-log-level
packet filter log level 0-3


#### --main-log-level
main log level    0-3


#### --node-log-level
node log level    0-3


#### --index-log-level
index log level  0-3


#### --index-service-log-level
index service log level  0-3


#### --node-detect-log-level
node detect log level      0-3

#### --help





## Аргументы командной строки для gnb_es
Выполните `gnb_es -h`, чтобы увидеть параметры, поддерживаемые gnb_es на текущей платформе.


#### -b, --ctl_block
ctl block mapper file


#### -s, --service
service mode


#### -d, --daemon
daemon


#### -L, --discover-in-lan
discover in lan


#### --upnp
upnp


#### --resolv
resolv


#### --dump-address
dump address


#### --broadcast-address
broadcast address


#### --pid-file
pid file


#### --wan-address6-file
wan address6 file


#### --if-up
call at interface up


#### --if-down
call at interface down


#### --log-udp4
send log to the address ipv4 default is "127.0.0.1:9000"


#### --log-udp-type
the log udp type 'binary' or 'text' default is 'binary'



***
https://github.com/gnbdev/opengnb
