% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{useMySQL,EnsDb-method}
\alias{useMySQL,EnsDb-method}
\alias{useMySQL}
\title{Use a MariaDB/MySQL backend}
\usage{
\S4method{useMySQL}{EnsDb}(x, host = "localhost", port = 3306, user, pass)
}
\arguments{
\item{x}{The \code{\linkS4class{EnsDb}} object.}

\item{host}{Character vector specifying the host on which the MariaDB/MySQL
server runs.}

\item{port}{The port on which the MariaDB/MySQL server can be accessed.}

\item{user}{The user name for the MariaDB/MySQL server.}

\item{pass}{The password for the MariaDB/MySQL server.}
}
\value{
A \code{\linkS4class{EnsDb}} object providing access to the
     data stored in the MySQL backend.
}
\description{
Change the SQL backend from \emph{SQLite} to \emph{MySQL}.
    When first called on an \code{\linkS4class{EnsDb}} object, the function
    tries to create and save all of the data into a MySQL database. All
    subsequent calls will connect to the already existing MySQL database.
}
\details{
This functionality requires that the \code{RMariaDB} package is
    installed and that the user has (write) access to a running MySQL server.
    If the corresponding database does already exist users without write
    access can use this functionality.
}
\note{
At present the function does not evaluate whether the versions
    between the SQLite and MariaDB/MySQL database differ.
}
\examples{
## Load the EnsDb database (SQLite backend).
library(EnsDb.Hsapiens.v86)
edb <- EnsDb.Hsapiens.v86
## Now change the backend to MySQL; my_user and my_pass should
## be the user name and password to access the MySQL server.
\dontrun{
edb_mysql <- useMySQL(edb, host = "localhost", user = my_user, pass = my_pass)
}
}
\author{
Johannes Rainer
}
