% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqLogo.R
\name{seqLogo}
\alias{seqLogo}
\title{Plot a sequence logo for a given position weight matrix}
\usage{
seqLogo(pwm, ic.scale=TRUE, xaxis=TRUE, yaxis=TRUE, xfontsize=15, yfontsize=15,
        fill=c(A='#61D04F', C='#2297E6', G='#F5C710', T='#DF536B'))
}
\arguments{
\item{pwm}{numeric. The alphabet*width position weight matrix.}

\item{ic.scale}{logical. If TRUE, the height of each column is proportional to its information content. Otherwise, all columns have the same height.}

\item{xaxis}{logical. If TRUE, an X-axis will be plotted.}

\item{yaxis}{logical. If TRUE, a Y-axis will be plotted.}

\item{xfontsize}{numeric. Font size to be used for the X-axis.}

\item{yfontsize}{numeric.  Font size to be used for the Y-axis.}

\item{fill}{character. Fill color to be used for the letters. Must be a named character vector of length equal to number of rows in \code{pwm} slot and names identical to its rownames.}
}
\value{
NULL.
}
\description{
This function takes the alphabet*width position weight matrix of
a sequence motif and plots the corresponding sequence logo.
}
\examples{
mFile <- system.file("extdata/pwm1", package = "seqLogo")
m <- read.table(mFile)
p <- makePWM(m)
seqLogo(p)
}
\author{
Oliver Bembom
}
