% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{upload_GMT_file}
\alias{upload_GMT_file}
\title{Upload custom annotations for functional enrichment analysis in g:GOSt.}
\usage{
upload_GMT_file(gmtfile)
}
\arguments{
\item{gmtfile}{the filepath of the GMT file to be uploaded. The file extension should be .gmt or .zip in case of multiple GMT files.
If the filepath does not contain an absolute path, the filename is relative to the current working directory.}
}
\value{
A string that denotes the ID of the uploaded custom annotations in the g:Profiler database.
After the GMT file upload this unique ID can be used as a value for the argument 'organism' in the \code{gost()} function to perform
functional enrichment analysis based on these custom data.

No need to repeatedly upload the same custom GMT file(s) every time you want to do the enrichment analysis.
The custom ID can also be used in the web tool as a token under the Custom GMT options.
}
\description{
Upload your own annotation data using files in the Gene Matrix Transposed file format (GMT) for functional enrichment analysis in g:GOSt.
The accepted file is either a single annotations file (with the extension .gmt) or a compressed directory of multiple annotation GMT files (with the extension .zip).
The GMT format is a tab-separated list of gene annotation sets where every line represents a separate gene set/functional term. The first column defines the function ID, second defines a short name/description of the function and the following columns
are the list of genes related to the specific function in that row.
}
\details{
The uploaded filename is used to define 'source' name in the g:GOSt results.
}
\examples{
\dontrun{custom_id <- upload_GMT_file("path/to/file.gmt")}
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>
}
