% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irace2pyimp.R
\name{irace2pyimp}
\alias{irace2pyimp}
\title{Convert an \code{irace.Rdata} file into the format supported by PyImp}
\usage{
irace2pyimp(file = "./irace.Rdata", normalise = "none",
  outdir = "./pyimp-input/", instanceFeatureFile = NA,
  filterConditions = NA, defaultConfigurationID = 1,
  ignoreUnsupported = 0)
}
\arguments{
\item{file}{(\code{character(1)}) \cr Filename of the \code{.Rdata} file generated by
irace after a tuning run is finished.}

\item{normalise}{(\code{none} | \code{instance} | \code{feature}) \cr Normalise the cost metric values into \code{[0, 1]} range before converting to PyImp format. Possible values are:\cr
* \code{none} (default): no normalisation. \cr
* \code{instance} : normalisation is done per instance. \cr
* \code{feature} : normalisation is based on features, i.e., instances with the same feature-vector values are grouped together and the normalised cost is calculated per group.}

\item{outdir}{(\code{character(1)}) \cr Directory where all generated files are stored.}

\item{instanceFeatureFile}{(\code{character(1)}) \cr A \code{.csv} file containing instance features (one line per instance,
sorted in the same order as the list of instances input to irace). The first line contains feature names.}

\item{filterConditions}{Only extract data that satisfies the given conditions. The conditions are in R expression format.}

\item{defaultConfigurationID}{Index of default configuration (starting from 1), used by ablation analysis.}

\item{ignoreUnsupported}{Forbidden configurations and repairConfiguration are not supported by the script. Set ignoreUnsupported=1 to ignore them and proceed with your own risk. This may cause some unwanted behaviours, e.g., forbidden configurations may appear in ablation analysis's path.}
}
\description{
This function converts an \code{irace.Rdata} file generated by irace into the
input format supported by the parameter importance analysis tool \code{PyImp}
(https://github.com/automl/ParameterImportance).
}
\details{
The generated files include:
\itemize{
\item \code{params.pcs} : a text file containing the parameter space definition.
\item \code{runhistory.json} : a JSON file containing the list of algorithm configurations evaluated during the tuning and the performance data obtained.
\item \code{traj_aclib2.json} : a JSON file containing the best configurations after each iteration of irace. The last configuration will be used as the target configuration in ablation analysis.
\item \code{scenario.txt} : a text file containing the definition of the tuning scenario.
\item \code{instances.txt} : a text file containing the list of instances.
\item \code{features.csv} : a text file containing instance features. If no instance features are provided, the index of each instance will be used as a feature.
}
}
\examples{
\dontrun{
irace2pyimp(file='irace.Rdata', outdir='pyimp-run')
irace2pyimp(file='irace.Rdata', normalise='feature',
            instanceFeatureFile='feature.csv', filterConditions="algorithm!='mas'")
}
cat("See more examples in '",
    file.path(system.file(package="irace"), "examples/irace2pyimp/acotsp/run.sh"),
    "' and in '",
    file.path(system.file(package="irace"), "examples/irace2pyimp/002-TemplateDesign/run.sh"),
    "'\\n")

}
\author{
Nguyen Dang and Manuel López-Ibáñez
}
