% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{markdown_options}
\alias{markdown_options}
\title{Markdown rendering options}
\usage{
markdown_options()
}
\value{
A character vector of all available options.
}
\description{
A list of all available options to control Markdown rendering. Options that
are enabled by default are marked by a \code{+} prefix, and those disabled by
default are marked by \code{-}.
}
\details{
Description of all options:

\describe{

\item{\code{base64_images}}{Embed local images in the HTML output with base64
encoding.}

\item{\code{highlight_code}}{Includes JavaScript libraries to syntax
highlight code blocks.}

\item{\code{latex_math}}{Identify LaTeX math expressions in pairs of single
or double dollar signs, and transform them so that they could be correctly
rendered by MathJax (HTML output) or LaTeX.}

\item{\code{mathjax}}{Include MathJax library in HTML output.}

\item{\code{mathjax_embed}}{Whether to download and embed the MathJax library
in HTML output.}

\item{\code{smartypants}}{Translate certain ASCII strings into smart
typographic characters (see \code{\link{smartypants}()}.}

\item{\code{standalone}}{Generate a full (HTML/LaTeX) document or only a
fragment of the body.}

\item{\code{superscript}}{Translate strings between two carets into
superscripts, e.g., \verb{text^foo^} to \verb{text<sup>foo</sup>}.}

\item{\code{subscript}}{Translate strings between two tildes into subscripts,
e.g., \verb{text~foo~} to \verb{text<sub>foo</sub>}.}

\item{\code{toc}}{Generate a table of contents from section headers.}

\item{\code{toc_depth}}{The number of section levels to include in the table
of contents (\code{3} by default).}

\item{\code{top_level}}{The desired type of the top-level headings in LaTeX
output. Possible values are \code{'chapter'} and \code{'part'}. For example,
if \code{top_level = 'chapter'}, \code{# header} will be rendered to
\verb{\chapter{header}} instead of the default \verb{\section{header}}.}

}

Options not described above can be found on the help pages of
\pkg{commonmark}, e.g., the \code{hardbreaks} option is for the
\code{hardbreaks} argument of
\code{\link[commonmark:commonmark]{markdown_*}()} functions, and the
\code{table} option is for the \code{table} extension in \pkg{commonmark}'s
extensions (\code{commonmark::\link[commonmark]{list_extensions}()}).
}
\examples{
# List all available options
markdown::markdown_options()

# Turn on/off some options globally for HTML output
options(markdown.html.options = '+toc-smartypants-standalone')

library(markdown)

# toc example
mkd <- c("# Header 1", "p1", "## Header 2", "p2")

cat(mark(mkd))
cat(mark(mkd, options = "toc"))

# hard_wrap example
cat(mark("foo\nbar\n"))
cat(mark("foo\nbar\n", options = "hard_wrap"))

# latex math example
mkd <- c(
  "`$x$` is inline math $x$!", "", "Display style:", "", "$$x + y$$", "",
  "\\\\begin{eqnarray}
a^{2}+b^{2} & = & c^{2}\\\\\\\\
\\\\sin^{2}(x)+\\\\cos^{2}(x) & = & 1
\\\\end{eqnarray}"
)

cat(mark(mkd))
cat(mark(mkd, options = "-latex_math"))

# tables example (need 4 spaces at beginning of line here)
cat(mark("
First Header  | Second Header
------------- | -------------
Content Cell  | Content Cell
Content Cell  | Content Cell
"))

# but not here
cat(mark("
First Header  | Second Header
------------- | -------------
Content Cell  | Content Cell
Content Cell  | Content Cell
", options = '-table'))

# autolink example
cat(mark("https://www.r-project.org/"))
cat(mark("https://www.r-project.org/", options = "-autolink"))

# strikethrough example
cat(mark("~~awesome~~"))
cat(mark("~~awesome~~", options = "-strikethrough"))

# superscript and subscript examples
cat(mark("2^10^"))
cat(mark("2^10^", options = "-superscript"))
cat(mark("H~2~O"))
cat(mark("H~2~O", options = "-subscript"))

# skip_html tags
mkd = '<style>a {}</style><script type="text/javascript">console.log("No!");</script>\n[Hello](#)'
cat(mark(mkd))
# TODO: wait for https://github.com/r-lib/commonmark/issues/15 to be fixed
# cat(mark(mkd, options = "tagfilter"))
}
