% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableWorkers.R
\name{availableWorkers}
\alias{availableWorkers}
\title{Get Set of Available Workers}
\usage{
availableWorkers(
  methods = getOption2("future.availableWorkers.methods", c("mc.cores",
    "_R_CHECK_LIMIT_CORES_", "PBS", "SGE", "Slurm", "LSF", "custom", "system",
    "fallback")),
  na.rm = TRUE,
  logical = getOption2("future.availableCores.logical", TRUE),
  default = "localhost",
  which = c("auto", "min", "max", "all")
)
}
\arguments{
\item{methods}{A character vector specifying how to infer the number
of available cores.}

\item{na.rm}{If TRUE, only non-missing settings are considered/returned.}

\item{logical}{Passed as-is to \code{\link[=availableCores]{availableCores()}}.}

\item{default}{The default set of workers.}

\item{which}{A character specifying which set / sets to return.
If \code{"auto"}, the first non-empty set found.
If \code{"min"}, the minimum value is returned.
If \code{"max"}, the maximum value is returned (be careful!)
If \code{"all"}, all values are returned.}
}
\value{
Return a character vector of workers, which typically consists
of names of machines / compute nodes, but may also be IP numbers.
}
\description{
Get Set of Available Workers
}
\details{
The default set of workers for each method is
\code{rep("localhost", times = availableCores(methods = method, logical = logical))},
which means that each will at least use as many parallel workers on the
current machine that \code{\link[=availableCores]{availableCores()}} allows for that method.

In addition, the following settings ("methods") are also acknowledged:
\itemize{
\item \code{"PBS"} -
Query TORQUE/PBS environment variable \env{PBS_NODEFILE}.
If this is set and specifies an existing file, then the set
of workers is read from that file, where one worker (node)
is given per line.
An example of a job submission that results in this is
\verb{qsub -l nodes = 4:ppn = 2}, which requests four nodes each
with two cores.
\item \code{"SGE"} -
Query Sun/Oracle Grid Engine (SGE) environment variable
\env{PE_HOSTFILE}.
An example of a job submission that results in this is
\verb{qsub -pe mpi 8} (or \verb{qsub -pe ompi 8}), which
requests eight cores on a any number of machines.
\item \code{"LSF"} -
Query LSF/OpenLava environment variable \env{LSB_HOSTS}.
\item \code{"custom"} -
If option \option{future.availableWorkers.custom} is set and a function,
then this function will be called (without arguments) and it's value
will be coerced to a character vector, which will be interpreted as
hostnames of available workers.
}
}
\examples{
message(paste("Available workers:",
        paste(sQuote(availableWorkers()), collapse = ", ")))

\dontrun{
options(mc.cores = 2L)
message(paste("Available workers:",
        paste(sQuote(availableWorkers()), collapse = ", ")))
}

\dontrun{
## Always use two workers on host 'n1' and one on host 'n2'
options(parallelly.availableWorkers.custom = function() {
  c("n1", "n1", "n2")
})
message(paste("Available workers:",
        paste(sQuote(availableWorkers()), collapse = ", ")))
}

}
\seealso{
To get the number of available workers on the current machine,
see \code{\link[=availableCores]{availableCores()}}.
}
