# Script to update the version of jQuery bundled
# in projvis, at inst/htmlwidgets/lib/jquery.
# Based on simplified version of script at
# https://github.com/rstudio/shiny/blob/main/tools/updatejQuery.R

version <- "3.7.1"
extension <- ".min.js"

jq_cdn_download <- function(version, extension) {
  download.file(
    url = file.path(
      "https://code.jquery.com",
      paste0("jquery-", version, extension)
    ),
    destfile = file.path(
      "inst", "htmlwidgets", "lib", "jquery",
      paste0("jquery", extension)
    )
  )
}

jq_cdn_download(version, extension)

download.file(
  url = sprintf("https://raw.githubusercontent.com/jquery/jquery/%s/AUTHORS.txt", version),
  destfile = file.path("inst", "htmlwidgets", "lib", "jquery", "AUTHORS.txt")
)

writeLines(con = "R/version_jquery.R", c(
  "# Generated by R/updatejQuery.R; do not edit by hand",
  sprintf('version_jquery <- "%s"', version)
))
