% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reprex-options.R
\name{reprex_options}
\alias{reprex_options}
\alias{opt}
\title{reprex options}
\description{
Some \code{\link[=reprex]{reprex()}} behaviour can be controlled via an option, providing a way
for the user to set personal defaults. The pattern for option names is
\verb{reprex.<arg>}, where \verb{<arg>} is an argument of \code{\link[=reprex]{reprex()}}. Here are the main
ones:
\itemize{
\item \code{reprex.advertise}
\item \code{reprex.session_info} (previously, \code{reprex.si})
\item \code{reprex.style}
\item \code{reprex.html_preview} (previously, \code{reprex.show})
\item \code{reprex.comment}
\item \code{reprex.tidyverse_quiet}
\item \code{reprex.std_out_err}
}

A few more options exist, but are only relevant to specific situations:
\itemize{
\item \code{reprex.venue}: Can be used to control the \code{venue} used by the
\code{\link[=reprex_selection]{reprex_selection()}} addin.
\item \code{reprex.current_venue}: Read-only option that is set during
\code{\link[=reprex_render]{reprex_render()}}. Other packages that want to generate reprex-compatible
output can consult it via \code{getOption("reprex.current_venue")}, if they want
to tailor their output to the \code{venue}.
\item \code{reprex.highlight.hl_style}: Only relevant to \verb{venue = "rtf}. Details are
in the article
\href{https://reprex.tidyverse.org/articles/articles/rtf.html}{reprex venue RTF}.
\item \code{reprex.highlight.font}: See above.
\item \code{reprex.highlight.font_size}: See above.
\item \code{reprex.highlight.other}: See above.
}

Here's code you could put in \code{.Rprofile} to set reprex options. It would be
rare to want non-default behaviour for all of these! We only do so here for
the sake of exposition:\preformatted{options(
  reprex.advertise       = FALSE,
  reprex.session_info    = TRUE,
  reprex.style           = TRUE,
  reprex.html_preview    = FALSE,
  reprex.comment         = "#;-)",
  reprex.tidyverse_quiet = FALSE,
  reprex.std_out_err     = TRUE,
  reprex.venue           = "html", # NOTE: only affects reprex_selection()!
  reprex.highlight.hl_style  = "acid", # NOTE: only affects RTF venue
  reprex.highlight.font      = "Andale Mono Regular",
  reprex.highlight.font_size = 35,
  reprex.highlight.other     = "--line-numbers"
)
}

The function \code{usethis::edit_r_profile()} is handy for creating and/or opening
your \code{.Rprofile}.
}
\section{Explaining the \code{opt()} helper}{

Arguments that appear like so in \code{\link[=reprex]{reprex()}}:\preformatted{reprex(..., arg = opt(DEFAULT), ...)
}

get their value according to this logic:\preformatted{user-specified value or, if not given,
  getOption("reprex.arg") or, if does not exist,
    DEFAULT
}

It's shorthand for:\preformatted{f(..., arg = getOption("reprex.arg", DEFAULT), ...)
}

This is not an exported function and should not be called directly.
}

