% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downstream.R
\name{downstream}
\alias{downstream}
\alias{downstream.default}
\alias{downstream.tsn}
\alias{downstream.gbifid}
\alias{downstream.uid}
\alias{downstream.wormsid}
\alias{downstream.boldid}
\alias{downstream.ids}
\title{Retrieve the downstream taxa for a given taxon name or ID.}
\usage{
downstream(...)

\method{downstream}{default}(
  sci_id,
  db = NULL,
  downto = NULL,
  intermediate = FALSE,
  rows = NA,
  x = NULL,
  ...
)

\method{downstream}{tsn}(sci_id, db = NULL, downto = NULL, intermediate = FALSE, ...)

\method{downstream}{gbifid}(
  sci_id,
  db = NULL,
  downto = NULL,
  intermediate = FALSE,
  limit = 100,
  start = NULL,
  ...
)

\method{downstream}{uid}(sci_id, db = NULL, downto = NULL, intermediate = FALSE, ...)

\method{downstream}{wormsid}(sci_id, db = NULL, downto = NULL, intermediate = FALSE, ...)

\method{downstream}{boldid}(sci_id, db = NULL, downto = NULL, intermediate = FALSE, ...)

\method{downstream}{ids}(sci_id, db = NULL, downto = NULL, intermediate = FALSE, ...)
}
\arguments{
\item{...}{Further args passed on to \code{\link[=itis_downstream]{itis_downstream()}},
\code{\link[=gbif_downstream]{gbif_downstream()}}, \code{\link[=ncbi_downstream]{ncbi_downstream()}},
\code{\link[=worms_downstream]{worms_downstream()}}, or \code{\link[=bold_downstream]{bold_downstream()}}}

\item{sci_id}{Vector of taxa names (character) or IDs (character or numeric)
to query.}

\item{db}{character; database to query. One or more of \code{itis}, \code{gbif},
\code{ncbi}, \code{worms}, or \code{bold}. Note that each taxonomic  data source has
their own identifiers, so that if you provide the wrong \code{db} value for
the identifier
you could get a result, but it will likely be wrong (not what you were
expecting). If using ncbi, we recommend getting an API key; see
\link{taxize-authentication}}

\item{downto}{What taxonomic rank to go down to. One of: 'superkingdom',
'kingdom', 'subkingdom','infrakingdom','phylum','division','subphylum',
'subdivision','infradivision', 'superclass','class','subclass','infraclass',
'superorder','order','suborder','infraorder','superfamily','family',
'subfamily','tribe','subtribe','genus','subgenus','section','subsection',
'species group','species','subspecies','variety','form','subvariety','race',
'stirp', 'morph','aberration','subform', 'unspecified', 'no rank'}

\item{intermediate}{(logical) If \code{TRUE}, return a list of length two
with target taxon rank names, with additional list of data.frame's of
intermediate taxonomic groups. Default: \code{FALSE}}

\item{rows}{(numeric) Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this parameter is ignored if you pass in a
taxonomic id of any of the acceptable classes: tsn.}

\item{x}{Deprecated, see \code{sci_id}}

\item{limit}{Number of records to return}

\item{start}{Record number to start at}
}
\value{
A named list of data.frames with the downstream names of every
supplied taxa. You get an NA if there was no match in the database.
}
\description{
This function uses a while loop to continually collect children taxa down
to the taxonomic rank that you specify in the \code{downto} parameter. You
can get data from ITIS (itis), GBIF (gbif), NCBI (ncbi), WORMS (worms),
or BOLD (bold). There is no method exposed by these four
services for getting taxa at a specific taxonomic rank, so we do it
ourselves here.
}
\section{Authentication}{

See \link{taxize-authentication} for help on authentication
}

\section{bold}{

BEWARE: \code{db="bold"} scrapes the BOLD website, so may be unstable. That is,
one day it may work, and the next it may fail. Open an issue if you
encounter an error: https://github.com/ropensci/taxize/issues
}

\examples{
\dontrun{
# Plug in taxon IDs
downstream(125732, db = 'worms', downto = 'species')
downstream(3451, db = 'bold', downto = 'species')

# Plug in taxon names
downstream("Apis", db = 'ncbi', downto = 'species')
downstream("Apis", db = 'itis', downto = 'species')
downstream("Apis", db = 'bold', downto = 'species')
downstream("Gadus", db = 'worms', downto = 'species')
downstream(c("Apis","Epeoloides"), db = 'itis', downto = 'species')
downstream("Ursus", db = 'gbif', downto = 'species')
downstream(get_gbifid("Ursus"), db = 'gbif', downto = 'species')

# Many taxa
sp <- names_list("genus", 3)
downstream(sp, db = 'itis', downto = 'species')
downstream(sp, db = 'gbif', downto = 'species')

# Both data sources
ids <- get_ids("Apis", db = c('gbif','itis'))
downstream(ids, downto = 'species')
## same result
downstream(get_ids("Apis", db = c('gbif','itis')), downto = 'species')

# Collect intermediate names
## itis
downstream('Bangiophyceae', db="itis", downto="genus")
downstream('Bangiophyceae', db="itis", downto="genus", intermediate=TRUE)
downstream(get_tsn('Bangiophyceae'), downto="genus")
downstream(get_tsn('Bangiophyceae'), downto="genus", intermediate=TRUE)

# Use the rows parameter
## note how in the second function call you don't get the prompt
downstream("Poa", db = 'gbif', downto="species")
downstream("Poa", db = 'gbif', downto="species", rows=1)

# use curl options
res <- downstream("Apis", db = 'gbif', downto = 'species', verbose = TRUE)
}
}
