% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoPlot.R
\name{volcano_density_plot}
\alias{volcano_density_plot}
\title{Create volcano plot from log2FC and adjusted pvalues data frame}
\usage{
volcano_density_plot(stats, side = "both",
  title = "Volcano Plot with Marginal Distributions", pval.cutoff = 0.05,
  lfc.cutoff = 1, shade.colour = "green", shade.alpha = 0.25,
  point.colour = "gray", point.alpha = 0.75,
  point.outline.colour = "darkgray", line.colour = "gray")
}
\arguments{
\item{stats}{data.frame with two columns: logFC and Adjusted.Pvalue}

\item{side}{plot UP, DOWN or BOTH de-regulated points}

\item{title}{title for the figure}

\item{pval.cutoff}{cutoff for the adjusted pvalue. Default 0.05}

\item{lfc.cutoff}{cutoff for the log2FC. Default 1}

\item{shade.alpha}{transparency value. Default 0.25}

\item{point.colour}{colours for points. Default gray}

\item{point.alpha}{transparency for points. Default 0.75}

\item{point.outline.colour}{Default darkgray}

\item{line.colour}{Defaul gray}
}
\description{
Create volcano plot from log2FC and adjusted pvalues data frame
}

