///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//! @examplefile yield_slip_error.cc The yield slip problem on a circle -- error computation
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "yield_slip_circle.h"
int main(int argc, char**argv) {
  environment rheolef (argc,argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e-15;
  Float S, n, Cf;
  field uh, lambda_h;
  din >> catchmark("S")       >> S
      >> catchmark("n")       >> n
      >> catchmark("Cf")      >> Cf
      >> catchmark("u")       >> uh
      >> catchmark("lambda")  >> lambda_h;
  const geo& omega = uh.get_geo();
  geo boundary = omega["boundary"];
  const space& Xh = uh.get_space();
  field pi_h_u = interpolate (Xh, u(S,n,Cf));
  field eh = pi_h_u - uh;
  integrate_option iopt;
  iopt.set_family(integrate_option::gauss);
  iopt.set_order(3*Xh.degree());
  Float err_linf = eh.max_abs();
  Float err_l2 = sqrt(integrate (omega, sqr(uh - u(S,n,Cf)), iopt));
  Float err_h1 = sqrt(integrate (omega, norm2(grad(uh) - grad_u(S,n,Cf)), iopt));
  Float err_b  = sqrt(integrate (boundary, sqr(uh[boundary] - u(S,n,Cf)), iopt));
  Float err_lb = sqrt(integrate (boundary, sqr(lambda_h - lambda(S,n,Cf)), iopt));
  dout << "err_linf = " << err_linf << endl
       << "err_l2   = " << err_l2 << endl
       << "err_h1   = " << err_h1 << endl
       << "err_b    = " << err_b  << endl
       << "err_lb   = " << err_lb  << endl;
  return (err_linf < tol) ? 0 : 1;
}
