// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::CssSection;
use crate::StyleProvider;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkCssProvider")]
    pub struct CssProvider(Object<ffi::GtkCssProvider, ffi::GtkCssProviderClass>) @implements StyleProvider;

    match fn {
        type_ => || ffi::gtk_css_provider_get_type(),
    }
}

impl CssProvider {
    #[doc(alias = "gtk_css_provider_new")]
    pub fn new() -> CssProvider {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_css_provider_new()) }
    }

    #[doc(alias = "gtk_css_provider_load_from_data")]
    pub fn load_from_data(&self, data: &[u8]) {
        let length = data.len() as isize;
        unsafe {
            ffi::gtk_css_provider_load_from_data(
                self.to_glib_none().0,
                data.to_glib_none().0,
                length,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_file")]
    pub fn load_from_file(&self, file: &impl IsA<gio::File>) {
        unsafe {
            ffi::gtk_css_provider_load_from_file(
                self.to_glib_none().0,
                file.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_path")]
    pub fn load_from_path(&self, path: &str) {
        unsafe {
            ffi::gtk_css_provider_load_from_path(self.to_glib_none().0, path.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_resource")]
    pub fn load_from_resource(&self, resource_path: &str) {
        unsafe {
            ffi::gtk_css_provider_load_from_resource(
                self.to_glib_none().0,
                resource_path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_named")]
    pub fn load_named(&self, name: &str, variant: Option<&str>) {
        unsafe {
            ffi::gtk_css_provider_load_named(
                self.to_glib_none().0,
                name.to_glib_none().0,
                variant.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(&self) -> glib::GString {
        unsafe { from_glib_full(ffi::gtk_css_provider_to_string(self.to_glib_none().0)) }
    }

    #[doc(alias = "parsing-error")]
    pub fn connect_parsing_error<F: Fn(&Self, &CssSection, &glib::Error) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn parsing_error_trampoline<
            F: Fn(&CssProvider, &CssSection, &glib::Error) + 'static,
        >(
            this: *mut ffi::GtkCssProvider,
            section: *mut ffi::GtkCssSection,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(section),
                &from_glib_borrow(error),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"parsing-error\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    parsing_error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for CssProvider {
    fn default() -> Self {
        Self::new()
    }
}

impl fmt::Display for CssProvider {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}
