# 2023-06-13 Triage Log

Our build pipeline got sped up by PR #112012, which side-steps one of the rustc
rebuilds we were suffering with before. (There is further potential speed-up by
caching LLVM, as noted by on that PR.) Other than that, various small
regressions that are largely noise, as well as one unexpected increase in binary
sizes from PR #109005 that we should follow up on.

Triage done by **@pnkfelix**.
Revision range: [adc719d7..4bd4e2ea](https://perf.rust-lang.org/?start=adc719d7147d5e2578ce08e0b4504be44650256e&end=4bd4e2ea824f4f458cae8917047ebb6b88853fe6&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.5%  | [0.2%, 21.6%]  | 84    |
| Regressions ❌ <br /> (secondary)  | 6.2%  | [0.2%, 21.0%]  | 105   |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.6%, -0.2%] | 26    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.2%, -0.2%] | 19    |
| All ❌✅ (primary)                 | 1.7%  | [-1.6%, 21.6%] | 110   |


7 Regressions, 3 Improvements, 5 Mixed; 5 of them in rollups
46 artifact comparisons made in total

#### Regressions

Misc HIR typeck type mismatch tweaks [#112116](https://github.com/rust-lang/rust/pull/112116) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=68c8fdaac071432c0a5c149ece5c094449fbe8e0&end=9c843d9fa322596c7d525c78fa89731ecf7afbfe&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.8%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.7%]   | 11    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.7%  | [0.7%, 0.8%]   | 3     |

* only primary benchmark to regress was helloworld (3 incr check variants), and not by all that much (relatively speaking)
* secondary regressions were mainly to unify-linearly, await-call-tree, token-stream-stress.
* impact seems acceptable, marking as triaged.

Uplift `clippy::undropped_manually_drops` lint [#111530](https://github.com/rust-lang/rust/pull/111530) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=343ad6f0596fa3222f3168b74b3e8571066e77bb&end=d7ad9d9797e595e9daed98c291a8eb6e4be838ff&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.6%, 0.7%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.6%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.6%, 0.7%] | 3     |

* only primary benchmark to regress was helloworld (3 incr check variants), and not by all that much (relatively speaking)
* secondary regressions were solely to unify-linearly, await-call-tree, token-stream-stress.
* impact seems acceptable (one expects new lint to add some amount of extra work, and I wouldn't be surprised if this is actually noise,. given #112116 above).
* marking as triaged.


Rollup of 3 pull requests [#112465](https://github.com/rust-lang/rust/pull/112465) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d7ad9d9797e595e9daed98c291a8eb6e4be838ff&end=397641f3bd4f4211d0a1e9ada8d477bf495735b2&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 4.2% | [0.4%, 14.8%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -             | 0     |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 4.2% | [0.4%, 14.8%] | 6     |

* already marked as triaged (expected regressions to doc benchmarks)

increase the accuracy of effective visibilities calculation [#112426](https://github.com/rust-lang/rust/pull/112426) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43062c43d2a63cf4e261c6eddc417575c4f3062f&end=29611778b708f95d153fa591a50ac8702dfc0fd5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.6%] | 10    |
| Regressions ❌ <br /> (secondary)  | 1.2% | [0.6%, 1.9%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.6%] | 10    |

* primary regressions are to serde (check, debug, opt) and also cargo + webrender (both check)
* This PR added some extra work to the compiler to ensure some lazily-filled in tables are constructed correctly.
* Therefore, this seems like extra work that is largely unavoidable.
* marking as triaged.

rustdoc: re-elide cross-crate default trait-object lifetime bounds [#107637](https://github.com/rust-lang/rust/pull/107637) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ef8ee73fc4ff70a426e71f900441f040db252dae&end=7820972f866ca2cea281ccc39201c0cd27087110&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.3%, 0.9%] | 12    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.3%, 0.9%] | 18    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.3%, 0.9%] | 12    |

* already marked as triaged (expected regressions to doc benchmarks)


Rollup of 3 pull requests [#112530](https://github.com/rust-lang/rust/pull/112530) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=81c02da94e5f5ec1ec4732e75049c3a3cb4d6c7a&end=37998ab508d5d9fa0d465d7b535dc673087dda8f&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 9.3% | [0.6%, 21.0%] | 19    |
| Regressions ❌ <br /> (secondary)  | 8.7% | [1.0%, 20.8%] | 71    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 9.3% | [0.6%, 21.0%] | 19    |

* One of the rolled up PRs, PR #112528, is itself a partial revert of PR #110221, which yields the large compile-time losses noted here (solely for helloworld, it is worth noting).
* the point is, the gains were 1. accidental 2. isolated to a toy and 3. due to an unintended change (which was now reverted).
* marking as triaged.

Private-in-public lints implementation [#111801](https://github.com/rust-lang/rust/pull/111801) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=37998ab508d5d9fa0d465d7b535dc673087dda8f&end=77dba225c1048e5585b2cdefb7f8588bd2d2741b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.2%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.2%, 1.1%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.2%] | 3     |

* primary regressions were to stm32f4-0.14.0 check+opt incr, but by a really small amount (0.18%).
* marking as triaged.

#### Improvements

Avoid one `rustc` rebuild in the optimized build pipeline [#112012](https://github.com/rust-lang/rust/pull/112012) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f383703e32dc583468a702213eff63c58c7f9ef5&end=50f2176721a08c0c5673db924a95c0544316682c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.5%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.6%, -0.3%] | 26    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.2%, -0.9%] | 11    |
| All ❌✅ (primary)                 | -0.8% | [-1.6%, 0.5%]  | 28    |

* Interesting case where removing PGO data improved a class of benchmarks
* Specifically, nearly all the improvements were to debug builds
* this makes sense, because the PGO data we were gathering was during rustc bootstrap, which does not exercise the debug build paths.


Rollup of 5 pull requests [#112450](https://github.com/rust-lang/rust/pull/112450) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c843d9fa322596c7d525c78fa89731ecf7afbfe&end=dcc9028c0ce30c3b37f3ca9faf637a9f3ccd5bcb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.6% | [-0.6%, -0.6%] | 3     |


[rustdoc] Fix infinite loop when retrieving impls for type alias [#112543](https://github.com/rust-lang/rust/pull/112543) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd0a3313f7a64cb16533030e49a271db449368c3&end=cb882fa998571e8a7ec1c06bb5d9dd9bc3423629&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -3.8% | [-12.9%, -0.4%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -               | 0     |
| All ❌✅ (primary)                 | -3.8% | [-12.9%, -0.4%] | 6     |


#### Mixed

Use `load`+`store` instead of `memcpy` for small integer arrays [#111999](https://github.com/rust-lang/rust/pull/111999) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=adc719d7147d5e2578ce08e0b4504be44650256e&end=fd9bf594366e73efb1a26a023e0b4de8eff82b94&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [0.1%, 5.7%]   | 3     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -     | -              | 0     |

* changes are all to secondary benchmarks
* only notable was coercions debug incr-full regressing by 5.7%, but that's acceptable given what we expect benefits to be here w.r.t. codegen.
* marking as triaged.

Update to LLVM 16.0.5 [#112312](https://github.com/rust-lang/rust/pull/112312) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd9bf594366e73efb1a26a023e0b4de8eff82b94&end=3572d7451d1062e8bccf310af6bbf6255091d296&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 5     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.2% | [-5.2%, -5.2%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |

* effects are all to secondary benchmarks
* effects are small enough that they would not block an LLVM upgrade
* marking as triaged.

Rollup of 7 pull requests [#112344](https://github.com/rust-lang/rust/pull/112344) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3572d7451d1062e8bccf310af6bbf6255091d296&end=b2b34bd83192c3d16c88655158f7d8d612513e88&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 5.4%  | [5.4%, 5.4%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 2     |

* sole regression is to secondary coercions debug incr-full.
* not worth dissecting this rollup for that.
* marking as triaged.

Remember names of `cfg`-ed out items to mention them in diagnostics [#109005](https://github.com/rust-lang/rust/pull/109005) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b2807b2bf3be9fbed9a0aadc97841c20a1ab5f79&end=a97c36dd2e6f711949fc9b790476e93bd9e6d1f4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.5%]   | 11    |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 8     |
| All ❌✅ (primary)                 | 0.2%  | [-0.2%, 0.5%]  | 14    |

* instruction counts regressed (expected) and binary sizes regressed (which may have been unexpected).
* specifically the binary sizes for libc and syn both regressed on the order of 3%.
* not marking as triaged until we get confirmation that it is expected for the metadata in question to leak into the binary sizes being measured.

Rollup of 4 pull requests [#112420](https://github.com/rust-lang/rust/pull/112420) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e7409258db4a43f23dcc66e10061dee91c316055&end=a77659a1e1807ba567f513afe59115af2604dc30&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.6%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.6%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [-0.3%, 0.6%]  | 7     |

* currently guessing that the regression here might be due to PR #109953.
* doing a specific rust-timer run now to check that, not marking as triaged for now.

#### Untriaged Pull Requests

- [#112530 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/112530)
- [#112426 increase the accuracy of effective visibilities calculation](https://github.com/rust-lang/rust/pull/112426)
- [#112420 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/112420)
- [#112344 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/112344)
- [#112312 Update to LLVM 16.0.5](https://github.com/rust-lang/rust/pull/112312)
- [#112116 Misc HIR typeck type mismatch tweaks](https://github.com/rust-lang/rust/pull/112116)
- [#112083 Make `TrustedStep` require `Copy`](https://github.com/rust-lang/rust/pull/112083)
- [#112016 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/112016)
- [#112001 Enable MatchBranchSimplification](https://github.com/rust-lang/rust/pull/112001)
- [#111999 Use `load`+`store` instead of `memcpy` for small integer arrays](https://github.com/rust-lang/rust/pull/111999)
- [#111869 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/111869)
- [#111813 MIR: opt-in normalization of `BasicBlock` and `Local` numbering](https://github.com/rust-lang/rust/pull/111813)
- [#111801 Private-in-public lints implementation](https://github.com/rust-lang/rust/pull/111801)
- [#111623 move `super_relate_consts` hack to `normalize_param_env_or_error`](https://github.com/rust-lang/rust/pull/111623)
- [#111530 Uplift `clippy::undropped_manually_drops` lint](https://github.com/rust-lang/rust/pull/111530)
- [#111524 `ascii::Char`-ify the escaping code in `core`](https://github.com/rust-lang/rust/pull/111524)
- [#111425 Populate effective visibilities in `rustc_privacy` (take 2)](https://github.com/rust-lang/rust/pull/111425)
- [#111364 Remove the ThinLTO CU hack](https://github.com/rust-lang/rust/pull/111364)
- [#111311 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/111311)
- [#111306 Update hashbrown from 0.12.3 to 0.13.1 for std](https://github.com/rust-lang/rust/pull/111306)
- [#111221 Combine three generalizer implementations](https://github.com/rust-lang/rust/pull/111221)
- [#111007 Disable nrvo mir opt](https://github.com/rust-lang/rust/pull/111007)
- [#110967 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/110967)
- [#110546 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/110546)
- [#110542 resolve: Remove `module_children_untracked`](https://github.com/rust-lang/rust/pull/110542)
- [#110440 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110440)
- [#110012 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110012)
- [#109900 Only enable ConstProp at mir-opt-level >= 2.](https://github.com/rust-lang/rust/pull/109900)
- [#109732 Uplift `clippy::{drop,forget}_{ref,copy}` lints](https://github.com/rust-lang/rust/pull/109732)
- [#109692 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/109692)
