An undeclared crate, module, or type was used.

Erroneous code example:

```compile_fail,E0433
let map = HashMap::new();
// error: failed to resolve: use of undeclared type `HashMap`
```

Please verify you didn't misspell the type/module's name or that you didn't
forget to import it:

```
use std::collections::HashMap; // HashMap has been imported.
let map: HashMap<u32, u32> = HashMap::new(); // So it can be used!
```

If you've expected to use a crate name:

```compile_fail
use ferris_wheel::BigO;
// error: failed to resolve: use of undeclared module or unlinked crate
```

Make sure the crate has been added as a dependency in `Cargo.toml`.

To use a module from your current crate, add the `crate::` prefix to the path.
