pub struct CodePoint {
    raw: u32
}

impl CodePoint {
    pub const fn from(raw: u32) -> Self {
        CodePoint { raw }
    }
}

impl CodePoint {
    pub const SPACE : CodePoint = CodePoint::from(32u32);
    pub const EXCLAMATION_MARK : CodePoint = CodePoint::from(33u32);
    pub const QUOTATION_MARK : CodePoint = CodePoint::from(34u32);
    pub const NUMBER_SIGN : CodePoint = CodePoint::from(35u32);
    pub const DOLLAR_SIGN : CodePoint = CodePoint::from(36u32);
    pub const PERCENT_SIGN : CodePoint = CodePoint::from(37u32);
    pub const AMPERSAND : CodePoint = CodePoint::from(38u32);
    pub const APOSTROPHE : CodePoint = CodePoint::from(39u32);
    pub const LEFT_PARENTHESIS : CodePoint = CodePoint::from(40u32);
    pub const RIGHT_PARENTHESIS : CodePoint = CodePoint::from(41u32);
    pub const ASTERISK : CodePoint = CodePoint::from(42u32);
    pub const PLUS_SIGN : CodePoint = CodePoint::from(43u32);
    pub const COMMA : CodePoint = CodePoint::from(44u32);
    pub const HYPHEN_MINUS : CodePoint = CodePoint::from(45u32);
    pub const FULL_STOP : CodePoint = CodePoint::from(46u32);
    pub const SOLIDUS : CodePoint = CodePoint::from(47u32);
    pub const DIGIT_ZERO : CodePoint = CodePoint::from(48u32);
    pub const DIGIT_ONE : CodePoint = CodePoint::from(49u32);
    pub const DIGIT_TWO : CodePoint = CodePoint::from(50u32);
    pub const DIGIT_THREE : CodePoint = CodePoint::from(51u32);
    pub const DIGIT_FOUR : CodePoint = CodePoint::from(52u32);
    pub const DIGIT_FIVE : CodePoint = CodePoint::from(53u32);
    pub const DIGIT_SIX : CodePoint = CodePoint::from(54u32);
    pub const DIGIT_SEVEN : CodePoint = CodePoint::from(55u32);
    pub const DIGIT_EIGHT : CodePoint = CodePoint::from(56u32);
    pub const DIGIT_NINE : CodePoint = CodePoint::from(57u32);
    pub const COLON : CodePoint = CodePoint::from(58u32);
    pub const SEMICOLON : CodePoint = CodePoint::from(59u32);
    pub const LESS_THAN_SIGN : CodePoint = CodePoint::from(60u32);
    pub const EQUALS_SIGN : CodePoint = CodePoint::from(61u32);
    pub const GREATER_THAN_SIGN : CodePoint = CodePoint::from(62u32);
    pub const QUESTION_MARK : CodePoint = CodePoint::from(63u32);
    pub const COMMERCIAL_AT : CodePoint = CodePoint::from(64u32);
    pub const LATIN_CAPITAL_LETTER_A : CodePoint = CodePoint::from(65u32);
    pub const LATIN_CAPITAL_LETTER_B : CodePoint = CodePoint::from(66u32);
    pub const LATIN_CAPITAL_LETTER_C : CodePoint = CodePoint::from(67u32);
    pub const LATIN_CAPITAL_LETTER_D : CodePoint = CodePoint::from(68u32);
    pub const LATIN_CAPITAL_LETTER_E : CodePoint = CodePoint::from(69u32);
    pub const LATIN_CAPITAL_LETTER_F : CodePoint = CodePoint::from(70u32);
    pub const LATIN_CAPITAL_LETTER_G : CodePoint = CodePoint::from(71u32);
    pub const LATIN_CAPITAL_LETTER_H : CodePoint = CodePoint::from(72u32);
    pub const LATIN_CAPITAL_LETTER_I : CodePoint = CodePoint::from(73u32);
    pub const LATIN_CAPITAL_LETTER_J : CodePoint = CodePoint::from(74u32);
    pub const LATIN_CAPITAL_LETTER_K : CodePoint = CodePoint::from(75u32);
    pub const LATIN_CAPITAL_LETTER_L : CodePoint = CodePoint::from(76u32);
    pub const LATIN_CAPITAL_LETTER_M : CodePoint = CodePoint::from(77u32);
    pub const LATIN_CAPITAL_LETTER_N : CodePoint = CodePoint::from(78u32);
    pub const LATIN_CAPITAL_LETTER_O : CodePoint = CodePoint::from(79u32);
    pub const LATIN_CAPITAL_LETTER_P : CodePoint = CodePoint::from(80u32);
    pub const LATIN_CAPITAL_LETTER_Q : CodePoint = CodePoint::from(81u32);
    pub const LATIN_CAPITAL_LETTER_R : CodePoint = CodePoint::from(82u32);
    pub const LATIN_CAPITAL_LETTER_S : CodePoint = CodePoint::from(83u32);
    pub const LATIN_CAPITAL_LETTER_T : CodePoint = CodePoint::from(84u32);
    pub const LATIN_CAPITAL_LETTER_U : CodePoint = CodePoint::from(85u32);
    pub const LATIN_CAPITAL_LETTER_V : CodePoint = CodePoint::from(86u32);
    pub const LATIN_CAPITAL_LETTER_W : CodePoint = CodePoint::from(87u32);
    pub const LATIN_CAPITAL_LETTER_X : CodePoint = CodePoint::from(88u32);
    pub const LATIN_CAPITAL_LETTER_Y : CodePoint = CodePoint::from(89u32);
    pub const LATIN_CAPITAL_LETTER_Z : CodePoint = CodePoint::from(90u32);
    pub const LEFT_SQUARE_BRACKET : CodePoint = CodePoint::from(91u32);
    pub const REVERSE_SOLIDUS : CodePoint = CodePoint::from(92u32);
    pub const RIGHT_SQUARE_BRACKET : CodePoint = CodePoint::from(93u32);
    pub const CIRCUMFLEX_ACCENT : CodePoint = CodePoint::from(94u32);
    pub const LOW_LINE : CodePoint = CodePoint::from(95u32);
    pub const GRAVE_ACCENT : CodePoint = CodePoint::from(96u32);
    pub const LATIN_SMALL_LETTER_A : CodePoint = CodePoint::from(97u32);
    pub const LATIN_SMALL_LETTER_B : CodePoint = CodePoint::from(98u32);
    pub const LATIN_SMALL_LETTER_C : CodePoint = CodePoint::from(99u32);
    pub const LATIN_SMALL_LETTER_D : CodePoint = CodePoint::from(100u32);
    pub const LATIN_SMALL_LETTER_E : CodePoint = CodePoint::from(101u32);
    pub const LATIN_SMALL_LETTER_F : CodePoint = CodePoint::from(102u32);
    pub const LATIN_SMALL_LETTER_G : CodePoint = CodePoint::from(103u32);
    pub const LATIN_SMALL_LETTER_H : CodePoint = CodePoint::from(104u32);
    pub const LATIN_SMALL_LETTER_I : CodePoint = CodePoint::from(105u32);
    pub const LATIN_SMALL_LETTER_J : CodePoint = CodePoint::from(106u32);
    pub const LATIN_SMALL_LETTER_K : CodePoint = CodePoint::from(107u32);
    pub const LATIN_SMALL_LETTER_L : CodePoint = CodePoint::from(108u32);
    pub const LATIN_SMALL_LETTER_M : CodePoint = CodePoint::from(109u32);
    pub const LATIN_SMALL_LETTER_N : CodePoint = CodePoint::from(110u32);
    pub const LATIN_SMALL_LETTER_O : CodePoint = CodePoint::from(111u32);
    pub const LATIN_SMALL_LETTER_P : CodePoint = CodePoint::from(112u32);
    pub const LATIN_SMALL_LETTER_Q : CodePoint = CodePoint::from(113u32);
    pub const LATIN_SMALL_LETTER_R : CodePoint = CodePoint::from(114u32);
    pub const LATIN_SMALL_LETTER_S : CodePoint = CodePoint::from(115u32);
    pub const LATIN_SMALL_LETTER_T : CodePoint = CodePoint::from(116u32);
    pub const LATIN_SMALL_LETTER_U : CodePoint = CodePoint::from(117u32);
    pub const LATIN_SMALL_LETTER_V : CodePoint = CodePoint::from(118u32);
    pub const LATIN_SMALL_LETTER_W : CodePoint = CodePoint::from(119u32);
    pub const LATIN_SMALL_LETTER_X : CodePoint = CodePoint::from(120u32);
    pub const LATIN_SMALL_LETTER_Y : CodePoint = CodePoint::from(121u32);
    pub const LATIN_SMALL_LETTER_Z : CodePoint = CodePoint::from(122u32);
    pub const LEFT_CURLY_BRACKET : CodePoint = CodePoint::from(123u32);
    pub const VERTICAL_LINE : CodePoint = CodePoint::from(124u32);
    pub const RIGHT_CURLY_BRACKET : CodePoint = CodePoint::from(125u32);
    pub const TILDE : CodePoint = CodePoint::from(126u32);
    pub const NO_BREAK_SPACE : CodePoint = CodePoint::from(160u32);
    pub const INVERTED_EXCLAMATION_MARK : CodePoint = CodePoint::from(161u32);
    pub const CENT_SIGN : CodePoint = CodePoint::from(162u32);
    pub const POUND_SIGN : CodePoint = CodePoint::from(163u32);
    pub const CURRENCY_SIGN : CodePoint = CodePoint::from(164u32);
    pub const YEN_SIGN : CodePoint = CodePoint::from(165u32);
    pub const BROKEN_BAR : CodePoint = CodePoint::from(166u32);
    pub const SECTION_SIGN : CodePoint = CodePoint::from(167u32);
    pub const DIAERESIS : CodePoint = CodePoint::from(168u32);
    pub const COPYRIGHT_SIGN : CodePoint = CodePoint::from(169u32);
    pub const FEMININE_ORDINAL_INDICATOR : CodePoint = CodePoint::from(170u32);
    pub const LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK : CodePoint = CodePoint::from(171u32);
    pub const NOT_SIGN : CodePoint = CodePoint::from(172u32);
    pub const SOFT_HYPHEN : CodePoint = CodePoint::from(173u32);
    pub const REGISTERED_SIGN : CodePoint = CodePoint::from(174u32);
    pub const MACRON : CodePoint = CodePoint::from(175u32);
    pub const DEGREE_SIGN : CodePoint = CodePoint::from(176u32);
    pub const PLUS_MINUS_SIGN : CodePoint = CodePoint::from(177u32);
    pub const SUPERSCRIPT_TWO : CodePoint = CodePoint::from(178u32);
    pub const SUPERSCRIPT_THREE : CodePoint = CodePoint::from(179u32);
    pub const ACUTE_ACCENT : CodePoint = CodePoint::from(180u32);
    pub const MICRO_SIGN : CodePoint = CodePoint::from(181u32);
    pub const PILCROW_SIGN : CodePoint = CodePoint::from(182u32);
    pub const MIDDLE_DOT : CodePoint = CodePoint::from(183u32);
    pub const CEDILLA : CodePoint = CodePoint::from(184u32);
    pub const SUPERSCRIPT_ONE : CodePoint = CodePoint::from(185u32);
    pub const MASCULINE_ORDINAL_INDICATOR : CodePoint = CodePoint::from(186u32);
    pub const RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK : CodePoint = CodePoint::from(187u32);
    pub const VULGAR_FRACTION_ONE_QUARTER : CodePoint = CodePoint::from(188u32);
    pub const VULGAR_FRACTION_ONE_HALF : CodePoint = CodePoint::from(189u32);
    pub const VULGAR_FRACTION_THREE_QUARTERS : CodePoint = CodePoint::from(190u32);
    pub const INVERTED_QUESTION_MARK : CodePoint = CodePoint::from(191u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_GRAVE : CodePoint = CodePoint::from(192u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_ACUTE : CodePoint = CodePoint::from(193u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(194u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_TILDE : CodePoint = CodePoint::from(195u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS : CodePoint = CodePoint::from(196u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE : CodePoint = CodePoint::from(197u32);
    pub const LATIN_CAPITAL_LETTER_AE : CodePoint = CodePoint::from(198u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_CEDILLA : CodePoint = CodePoint::from(199u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_GRAVE : CodePoint = CodePoint::from(200u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_ACUTE : CodePoint = CodePoint::from(201u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(202u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS : CodePoint = CodePoint::from(203u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_GRAVE : CodePoint = CodePoint::from(204u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_ACUTE : CodePoint = CodePoint::from(205u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(206u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS : CodePoint = CodePoint::from(207u32);
    pub const LATIN_CAPITAL_LETTER_ETH : CodePoint = CodePoint::from(208u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_TILDE : CodePoint = CodePoint::from(209u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_GRAVE : CodePoint = CodePoint::from(210u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_ACUTE : CodePoint = CodePoint::from(211u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(212u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_TILDE : CodePoint = CodePoint::from(213u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS : CodePoint = CodePoint::from(214u32);
    pub const MULTIPLICATION_SIGN : CodePoint = CodePoint::from(215u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_STROKE : CodePoint = CodePoint::from(216u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_GRAVE : CodePoint = CodePoint::from(217u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_ACUTE : CodePoint = CodePoint::from(218u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(219u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS : CodePoint = CodePoint::from(220u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_ACUTE : CodePoint = CodePoint::from(221u32);
    pub const LATIN_CAPITAL_LETTER_THORN : CodePoint = CodePoint::from(222u32);
    pub const LATIN_SMALL_LETTER_SHARP_S : CodePoint = CodePoint::from(223u32);
    pub const LATIN_SMALL_LETTER_A_WITH_GRAVE : CodePoint = CodePoint::from(224u32);
    pub const LATIN_SMALL_LETTER_A_WITH_ACUTE : CodePoint = CodePoint::from(225u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(226u32);
    pub const LATIN_SMALL_LETTER_A_WITH_TILDE : CodePoint = CodePoint::from(227u32);
    pub const LATIN_SMALL_LETTER_A_WITH_DIAERESIS : CodePoint = CodePoint::from(228u32);
    pub const LATIN_SMALL_LETTER_A_WITH_RING_ABOVE : CodePoint = CodePoint::from(229u32);
    pub const LATIN_SMALL_LETTER_AE : CodePoint = CodePoint::from(230u32);
    pub const LATIN_SMALL_LETTER_C_WITH_CEDILLA : CodePoint = CodePoint::from(231u32);
    pub const LATIN_SMALL_LETTER_E_WITH_GRAVE : CodePoint = CodePoint::from(232u32);
    pub const LATIN_SMALL_LETTER_E_WITH_ACUTE : CodePoint = CodePoint::from(233u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(234u32);
    pub const LATIN_SMALL_LETTER_E_WITH_DIAERESIS : CodePoint = CodePoint::from(235u32);
    pub const LATIN_SMALL_LETTER_I_WITH_GRAVE : CodePoint = CodePoint::from(236u32);
    pub const LATIN_SMALL_LETTER_I_WITH_ACUTE : CodePoint = CodePoint::from(237u32);
    pub const LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(238u32);
    pub const LATIN_SMALL_LETTER_I_WITH_DIAERESIS : CodePoint = CodePoint::from(239u32);
    pub const LATIN_SMALL_LETTER_ETH : CodePoint = CodePoint::from(240u32);
    pub const LATIN_SMALL_LETTER_N_WITH_TILDE : CodePoint = CodePoint::from(241u32);
    pub const LATIN_SMALL_LETTER_O_WITH_GRAVE : CodePoint = CodePoint::from(242u32);
    pub const LATIN_SMALL_LETTER_O_WITH_ACUTE : CodePoint = CodePoint::from(243u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(244u32);
    pub const LATIN_SMALL_LETTER_O_WITH_TILDE : CodePoint = CodePoint::from(245u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DIAERESIS : CodePoint = CodePoint::from(246u32);
    pub const DIVISION_SIGN : CodePoint = CodePoint::from(247u32);
    pub const LATIN_SMALL_LETTER_O_WITH_STROKE : CodePoint = CodePoint::from(248u32);
    pub const LATIN_SMALL_LETTER_U_WITH_GRAVE : CodePoint = CodePoint::from(249u32);
    pub const LATIN_SMALL_LETTER_U_WITH_ACUTE : CodePoint = CodePoint::from(250u32);
    pub const LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(251u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DIAERESIS : CodePoint = CodePoint::from(252u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_ACUTE : CodePoint = CodePoint::from(253u32);
    pub const LATIN_SMALL_LETTER_THORN : CodePoint = CodePoint::from(254u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_DIAERESIS : CodePoint = CodePoint::from(255u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_MACRON : CodePoint = CodePoint::from(256u32);
    pub const LATIN_SMALL_LETTER_A_WITH_MACRON : CodePoint = CodePoint::from(257u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_BREVE : CodePoint = CodePoint::from(258u32);
    pub const LATIN_SMALL_LETTER_A_WITH_BREVE : CodePoint = CodePoint::from(259u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_OGONEK : CodePoint = CodePoint::from(260u32);
    pub const LATIN_SMALL_LETTER_A_WITH_OGONEK : CodePoint = CodePoint::from(261u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_ACUTE : CodePoint = CodePoint::from(262u32);
    pub const LATIN_SMALL_LETTER_C_WITH_ACUTE : CodePoint = CodePoint::from(263u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(264u32);
    pub const LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(265u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE : CodePoint = CodePoint::from(266u32);
    pub const LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE : CodePoint = CodePoint::from(267u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_CARON : CodePoint = CodePoint::from(268u32);
    pub const LATIN_SMALL_LETTER_C_WITH_CARON : CodePoint = CodePoint::from(269u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_CARON : CodePoint = CodePoint::from(270u32);
    pub const LATIN_SMALL_LETTER_D_WITH_CARON : CodePoint = CodePoint::from(271u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_STROKE : CodePoint = CodePoint::from(272u32);
    pub const LATIN_SMALL_LETTER_D_WITH_STROKE : CodePoint = CodePoint::from(273u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_MACRON : CodePoint = CodePoint::from(274u32);
    pub const LATIN_SMALL_LETTER_E_WITH_MACRON : CodePoint = CodePoint::from(275u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_BREVE : CodePoint = CodePoint::from(276u32);
    pub const LATIN_SMALL_LETTER_E_WITH_BREVE : CodePoint = CodePoint::from(277u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE : CodePoint = CodePoint::from(278u32);
    pub const LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE : CodePoint = CodePoint::from(279u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_OGONEK : CodePoint = CodePoint::from(280u32);
    pub const LATIN_SMALL_LETTER_E_WITH_OGONEK : CodePoint = CodePoint::from(281u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CARON : CodePoint = CodePoint::from(282u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CARON : CodePoint = CodePoint::from(283u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(284u32);
    pub const LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(285u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_BREVE : CodePoint = CodePoint::from(286u32);
    pub const LATIN_SMALL_LETTER_G_WITH_BREVE : CodePoint = CodePoint::from(287u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE : CodePoint = CodePoint::from(288u32);
    pub const LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE : CodePoint = CodePoint::from(289u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_CEDILLA : CodePoint = CodePoint::from(290u32);
    pub const LATIN_SMALL_LETTER_G_WITH_CEDILLA : CodePoint = CodePoint::from(291u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(292u32);
    pub const LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(293u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_STROKE : CodePoint = CodePoint::from(294u32);
    pub const LATIN_SMALL_LETTER_H_WITH_STROKE : CodePoint = CodePoint::from(295u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_TILDE : CodePoint = CodePoint::from(296u32);
    pub const LATIN_SMALL_LETTER_I_WITH_TILDE : CodePoint = CodePoint::from(297u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_MACRON : CodePoint = CodePoint::from(298u32);
    pub const LATIN_SMALL_LETTER_I_WITH_MACRON : CodePoint = CodePoint::from(299u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_BREVE : CodePoint = CodePoint::from(300u32);
    pub const LATIN_SMALL_LETTER_I_WITH_BREVE : CodePoint = CodePoint::from(301u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_OGONEK : CodePoint = CodePoint::from(302u32);
    pub const LATIN_SMALL_LETTER_I_WITH_OGONEK : CodePoint = CodePoint::from(303u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE : CodePoint = CodePoint::from(304u32);
    pub const LATIN_SMALL_LETTER_DOTLESS_I : CodePoint = CodePoint::from(305u32);
    pub const LATIN_CAPITAL_LIGATURE_IJ : CodePoint = CodePoint::from(306u32);
    pub const LATIN_SMALL_LIGATURE_IJ : CodePoint = CodePoint::from(307u32);
    pub const LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(308u32);
    pub const LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(309u32);
    pub const LATIN_CAPITAL_LETTER_K_WITH_CEDILLA : CodePoint = CodePoint::from(310u32);
    pub const LATIN_SMALL_LETTER_K_WITH_CEDILLA : CodePoint = CodePoint::from(311u32);
    pub const LATIN_SMALL_LETTER_KRA : CodePoint = CodePoint::from(312u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_ACUTE : CodePoint = CodePoint::from(313u32);
    pub const LATIN_SMALL_LETTER_L_WITH_ACUTE : CodePoint = CodePoint::from(314u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_CEDILLA : CodePoint = CodePoint::from(315u32);
    pub const LATIN_SMALL_LETTER_L_WITH_CEDILLA : CodePoint = CodePoint::from(316u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_CARON : CodePoint = CodePoint::from(317u32);
    pub const LATIN_SMALL_LETTER_L_WITH_CARON : CodePoint = CodePoint::from(318u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT : CodePoint = CodePoint::from(319u32);
    pub const LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT : CodePoint = CodePoint::from(320u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_STROKE : CodePoint = CodePoint::from(321u32);
    pub const LATIN_SMALL_LETTER_L_WITH_STROKE : CodePoint = CodePoint::from(322u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_ACUTE : CodePoint = CodePoint::from(323u32);
    pub const LATIN_SMALL_LETTER_N_WITH_ACUTE : CodePoint = CodePoint::from(324u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_CEDILLA : CodePoint = CodePoint::from(325u32);
    pub const LATIN_SMALL_LETTER_N_WITH_CEDILLA : CodePoint = CodePoint::from(326u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_CARON : CodePoint = CodePoint::from(327u32);
    pub const LATIN_SMALL_LETTER_N_WITH_CARON : CodePoint = CodePoint::from(328u32);
    pub const LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE : CodePoint = CodePoint::from(329u32);
    pub const LATIN_CAPITAL_LETTER_ENG : CodePoint = CodePoint::from(330u32);
    pub const LATIN_SMALL_LETTER_ENG : CodePoint = CodePoint::from(331u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_MACRON : CodePoint = CodePoint::from(332u32);
    pub const LATIN_SMALL_LETTER_O_WITH_MACRON : CodePoint = CodePoint::from(333u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_BREVE : CodePoint = CodePoint::from(334u32);
    pub const LATIN_SMALL_LETTER_O_WITH_BREVE : CodePoint = CodePoint::from(335u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE : CodePoint = CodePoint::from(336u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE : CodePoint = CodePoint::from(337u32);
    pub const LATIN_CAPITAL_LIGATURE_OE : CodePoint = CodePoint::from(338u32);
    pub const LATIN_SMALL_LIGATURE_OE : CodePoint = CodePoint::from(339u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_ACUTE : CodePoint = CodePoint::from(340u32);
    pub const LATIN_SMALL_LETTER_R_WITH_ACUTE : CodePoint = CodePoint::from(341u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_CEDILLA : CodePoint = CodePoint::from(342u32);
    pub const LATIN_SMALL_LETTER_R_WITH_CEDILLA : CodePoint = CodePoint::from(343u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_CARON : CodePoint = CodePoint::from(344u32);
    pub const LATIN_SMALL_LETTER_R_WITH_CARON : CodePoint = CodePoint::from(345u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_ACUTE : CodePoint = CodePoint::from(346u32);
    pub const LATIN_SMALL_LETTER_S_WITH_ACUTE : CodePoint = CodePoint::from(347u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(348u32);
    pub const LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(349u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_CEDILLA : CodePoint = CodePoint::from(350u32);
    pub const LATIN_SMALL_LETTER_S_WITH_CEDILLA : CodePoint = CodePoint::from(351u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_CARON : CodePoint = CodePoint::from(352u32);
    pub const LATIN_SMALL_LETTER_S_WITH_CARON : CodePoint = CodePoint::from(353u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_CEDILLA : CodePoint = CodePoint::from(354u32);
    pub const LATIN_SMALL_LETTER_T_WITH_CEDILLA : CodePoint = CodePoint::from(355u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_CARON : CodePoint = CodePoint::from(356u32);
    pub const LATIN_SMALL_LETTER_T_WITH_CARON : CodePoint = CodePoint::from(357u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_STROKE : CodePoint = CodePoint::from(358u32);
    pub const LATIN_SMALL_LETTER_T_WITH_STROKE : CodePoint = CodePoint::from(359u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_TILDE : CodePoint = CodePoint::from(360u32);
    pub const LATIN_SMALL_LETTER_U_WITH_TILDE : CodePoint = CodePoint::from(361u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_MACRON : CodePoint = CodePoint::from(362u32);
    pub const LATIN_SMALL_LETTER_U_WITH_MACRON : CodePoint = CodePoint::from(363u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_BREVE : CodePoint = CodePoint::from(364u32);
    pub const LATIN_SMALL_LETTER_U_WITH_BREVE : CodePoint = CodePoint::from(365u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE : CodePoint = CodePoint::from(366u32);
    pub const LATIN_SMALL_LETTER_U_WITH_RING_ABOVE : CodePoint = CodePoint::from(367u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE : CodePoint = CodePoint::from(368u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE : CodePoint = CodePoint::from(369u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_OGONEK : CodePoint = CodePoint::from(370u32);
    pub const LATIN_SMALL_LETTER_U_WITH_OGONEK : CodePoint = CodePoint::from(371u32);
    pub const LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(372u32);
    pub const LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(373u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(374u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(375u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS : CodePoint = CodePoint::from(376u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_ACUTE : CodePoint = CodePoint::from(377u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_ACUTE : CodePoint = CodePoint::from(378u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE : CodePoint = CodePoint::from(379u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE : CodePoint = CodePoint::from(380u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_CARON : CodePoint = CodePoint::from(381u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_CARON : CodePoint = CodePoint::from(382u32);
    pub const LATIN_SMALL_LETTER_LONG_S : CodePoint = CodePoint::from(383u32);
    pub const LATIN_SMALL_LETTER_B_WITH_STROKE : CodePoint = CodePoint::from(384u32);
    pub const LATIN_CAPITAL_LETTER_B_WITH_HOOK : CodePoint = CodePoint::from(385u32);
    pub const LATIN_CAPITAL_LETTER_B_WITH_TOPBAR : CodePoint = CodePoint::from(386u32);
    pub const LATIN_SMALL_LETTER_B_WITH_TOPBAR : CodePoint = CodePoint::from(387u32);
    pub const LATIN_CAPITAL_LETTER_TONE_SIX : CodePoint = CodePoint::from(388u32);
    pub const LATIN_SMALL_LETTER_TONE_SIX : CodePoint = CodePoint::from(389u32);
    pub const LATIN_CAPITAL_LETTER_OPEN_O : CodePoint = CodePoint::from(390u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_HOOK : CodePoint = CodePoint::from(391u32);
    pub const LATIN_SMALL_LETTER_C_WITH_HOOK : CodePoint = CodePoint::from(392u32);
    pub const LATIN_CAPITAL_LETTER_AFRICAN_D : CodePoint = CodePoint::from(393u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_HOOK : CodePoint = CodePoint::from(394u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_TOPBAR : CodePoint = CodePoint::from(395u32);
    pub const LATIN_SMALL_LETTER_D_WITH_TOPBAR : CodePoint = CodePoint::from(396u32);
    pub const LATIN_SMALL_LETTER_TURNED_DELTA : CodePoint = CodePoint::from(397u32);
    pub const LATIN_CAPITAL_LETTER_REVERSED_E : CodePoint = CodePoint::from(398u32);
    pub const LATIN_CAPITAL_LETTER_SCHWA : CodePoint = CodePoint::from(399u32);
    pub const LATIN_CAPITAL_LETTER_OPEN_E : CodePoint = CodePoint::from(400u32);
    pub const LATIN_CAPITAL_LETTER_F_WITH_HOOK : CodePoint = CodePoint::from(401u32);
    pub const LATIN_SMALL_LETTER_F_WITH_HOOK : CodePoint = CodePoint::from(402u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_HOOK : CodePoint = CodePoint::from(403u32);
    pub const LATIN_CAPITAL_LETTER_GAMMA : CodePoint = CodePoint::from(404u32);
    pub const LATIN_SMALL_LETTER_HV : CodePoint = CodePoint::from(405u32);
    pub const LATIN_CAPITAL_LETTER_IOTA : CodePoint = CodePoint::from(406u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_STROKE : CodePoint = CodePoint::from(407u32);
    pub const LATIN_CAPITAL_LETTER_K_WITH_HOOK : CodePoint = CodePoint::from(408u32);
    pub const LATIN_SMALL_LETTER_K_WITH_HOOK : CodePoint = CodePoint::from(409u32);
    pub const LATIN_SMALL_LETTER_L_WITH_BAR : CodePoint = CodePoint::from(410u32);
    pub const LATIN_SMALL_LETTER_LAMBDA_WITH_STROKE : CodePoint = CodePoint::from(411u32);
    pub const LATIN_CAPITAL_LETTER_TURNED_M : CodePoint = CodePoint::from(412u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_LEFT_HOOK : CodePoint = CodePoint::from(413u32);
    pub const LATIN_SMALL_LETTER_N_WITH_LONG_RIGHT_LEG : CodePoint = CodePoint::from(414u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(415u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HORN : CodePoint = CodePoint::from(416u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HORN : CodePoint = CodePoint::from(417u32);
    pub const LATIN_CAPITAL_LETTER_OI : CodePoint = CodePoint::from(418u32);
    pub const LATIN_SMALL_LETTER_OI : CodePoint = CodePoint::from(419u32);
    pub const LATIN_CAPITAL_LETTER_P_WITH_HOOK : CodePoint = CodePoint::from(420u32);
    pub const LATIN_SMALL_LETTER_P_WITH_HOOK : CodePoint = CodePoint::from(421u32);
    pub const LATIN_LETTER_YR : CodePoint = CodePoint::from(422u32);
    pub const LATIN_CAPITAL_LETTER_TONE_TWO : CodePoint = CodePoint::from(423u32);
    pub const LATIN_SMALL_LETTER_TONE_TWO : CodePoint = CodePoint::from(424u32);
    pub const LATIN_CAPITAL_LETTER_ESH : CodePoint = CodePoint::from(425u32);
    pub const LATIN_LETTER_REVERSED_ESH_LOOP : CodePoint = CodePoint::from(426u32);
    pub const LATIN_SMALL_LETTER_T_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(427u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_HOOK : CodePoint = CodePoint::from(428u32);
    pub const LATIN_SMALL_LETTER_T_WITH_HOOK : CodePoint = CodePoint::from(429u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(430u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HORN : CodePoint = CodePoint::from(431u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HORN : CodePoint = CodePoint::from(432u32);
    pub const LATIN_CAPITAL_LETTER_UPSILON : CodePoint = CodePoint::from(433u32);
    pub const LATIN_CAPITAL_LETTER_V_WITH_HOOK : CodePoint = CodePoint::from(434u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_HOOK : CodePoint = CodePoint::from(435u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_HOOK : CodePoint = CodePoint::from(436u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_STROKE : CodePoint = CodePoint::from(437u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_STROKE : CodePoint = CodePoint::from(438u32);
    pub const LATIN_CAPITAL_LETTER_EZH : CodePoint = CodePoint::from(439u32);
    pub const LATIN_CAPITAL_LETTER_EZH_REVERSED : CodePoint = CodePoint::from(440u32);
    pub const LATIN_SMALL_LETTER_EZH_REVERSED : CodePoint = CodePoint::from(441u32);
    pub const LATIN_SMALL_LETTER_EZH_WITH_TAIL : CodePoint = CodePoint::from(442u32);
    pub const LATIN_LETTER_TWO_WITH_STROKE : CodePoint = CodePoint::from(443u32);
    pub const LATIN_CAPITAL_LETTER_TONE_FIVE : CodePoint = CodePoint::from(444u32);
    pub const LATIN_SMALL_LETTER_TONE_FIVE : CodePoint = CodePoint::from(445u32);
    pub const LATIN_LETTER_INVERTED_GLOTTAL_STOP_WITH_STROKE : CodePoint = CodePoint::from(446u32);
    pub const LATIN_LETTER_WYNN : CodePoint = CodePoint::from(447u32);
    pub const LATIN_LETTER_DENTAL_CLICK : CodePoint = CodePoint::from(448u32);
    pub const LATIN_LETTER_LATERAL_CLICK : CodePoint = CodePoint::from(449u32);
    pub const LATIN_LETTER_ALVEOLAR_CLICK : CodePoint = CodePoint::from(450u32);
    pub const LATIN_LETTER_RETROFLEX_CLICK : CodePoint = CodePoint::from(451u32);
    pub const LATIN_CAPITAL_LETTER_DZ_WITH_CARON : CodePoint = CodePoint::from(452u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z_WITH_CARON : CodePoint = CodePoint::from(453u32);
    pub const LATIN_SMALL_LETTER_DZ_WITH_CARON : CodePoint = CodePoint::from(454u32);
    pub const LATIN_CAPITAL_LETTER_LJ : CodePoint = CodePoint::from(455u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_SMALL_LETTER_J : CodePoint = CodePoint::from(456u32);
    pub const LATIN_SMALL_LETTER_LJ : CodePoint = CodePoint::from(457u32);
    pub const LATIN_CAPITAL_LETTER_NJ : CodePoint = CodePoint::from(458u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_SMALL_LETTER_J : CodePoint = CodePoint::from(459u32);
    pub const LATIN_SMALL_LETTER_NJ : CodePoint = CodePoint::from(460u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CARON : CodePoint = CodePoint::from(461u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CARON : CodePoint = CodePoint::from(462u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_CARON : CodePoint = CodePoint::from(463u32);
    pub const LATIN_SMALL_LETTER_I_WITH_CARON : CodePoint = CodePoint::from(464u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CARON : CodePoint = CodePoint::from(465u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CARON : CodePoint = CodePoint::from(466u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_CARON : CodePoint = CodePoint::from(467u32);
    pub const LATIN_SMALL_LETTER_U_WITH_CARON : CodePoint = CodePoint::from(468u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_MACRON : CodePoint = CodePoint::from(469u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_MACRON : CodePoint = CodePoint::from(470u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_ACUTE : CodePoint = CodePoint::from(471u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_ACUTE : CodePoint = CodePoint::from(472u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_CARON : CodePoint = CodePoint::from(473u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_CARON : CodePoint = CodePoint::from(474u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_GRAVE : CodePoint = CodePoint::from(475u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_GRAVE : CodePoint = CodePoint::from(476u32);
    pub const LATIN_SMALL_LETTER_TURNED_E : CodePoint = CodePoint::from(477u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS_AND_MACRON : CodePoint = CodePoint::from(478u32);
    pub const LATIN_SMALL_LETTER_A_WITH_DIAERESIS_AND_MACRON : CodePoint = CodePoint::from(479u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON : CodePoint = CodePoint::from(480u32);
    pub const LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON : CodePoint = CodePoint::from(481u32);
    pub const LATIN_CAPITAL_LETTER_AE_WITH_MACRON : CodePoint = CodePoint::from(482u32);
    pub const LATIN_SMALL_LETTER_AE_WITH_MACRON : CodePoint = CodePoint::from(483u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_STROKE : CodePoint = CodePoint::from(484u32);
    pub const LATIN_SMALL_LETTER_G_WITH_STROKE : CodePoint = CodePoint::from(485u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_CARON : CodePoint = CodePoint::from(486u32);
    pub const LATIN_SMALL_LETTER_G_WITH_CARON : CodePoint = CodePoint::from(487u32);
    pub const LATIN_CAPITAL_LETTER_K_WITH_CARON : CodePoint = CodePoint::from(488u32);
    pub const LATIN_SMALL_LETTER_K_WITH_CARON : CodePoint = CodePoint::from(489u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_OGONEK : CodePoint = CodePoint::from(490u32);
    pub const LATIN_SMALL_LETTER_O_WITH_OGONEK : CodePoint = CodePoint::from(491u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_OGONEK_AND_MACRON : CodePoint = CodePoint::from(492u32);
    pub const LATIN_SMALL_LETTER_O_WITH_OGONEK_AND_MACRON : CodePoint = CodePoint::from(493u32);
    pub const LATIN_CAPITAL_LETTER_EZH_WITH_CARON : CodePoint = CodePoint::from(494u32);
    pub const LATIN_SMALL_LETTER_EZH_WITH_CARON : CodePoint = CodePoint::from(495u32);
    pub const LATIN_SMALL_LETTER_J_WITH_CARON : CodePoint = CodePoint::from(496u32);
    pub const LATIN_CAPITAL_LETTER_DZ : CodePoint = CodePoint::from(497u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z : CodePoint = CodePoint::from(498u32);
    pub const LATIN_SMALL_LETTER_DZ : CodePoint = CodePoint::from(499u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_ACUTE : CodePoint = CodePoint::from(500u32);
    pub const LATIN_SMALL_LETTER_G_WITH_ACUTE : CodePoint = CodePoint::from(501u32);
    pub const LATIN_CAPITAL_LETTER_HWAIR : CodePoint = CodePoint::from(502u32);
    pub const LATIN_CAPITAL_LETTER_WYNN : CodePoint = CodePoint::from(503u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_GRAVE : CodePoint = CodePoint::from(504u32);
    pub const LATIN_SMALL_LETTER_N_WITH_GRAVE : CodePoint = CodePoint::from(505u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE : CodePoint = CodePoint::from(506u32);
    pub const LATIN_SMALL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE : CodePoint = CodePoint::from(507u32);
    pub const LATIN_CAPITAL_LETTER_AE_WITH_ACUTE : CodePoint = CodePoint::from(508u32);
    pub const LATIN_SMALL_LETTER_AE_WITH_ACUTE : CodePoint = CodePoint::from(509u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_STROKE_AND_ACUTE : CodePoint = CodePoint::from(510u32);
    pub const LATIN_SMALL_LETTER_O_WITH_STROKE_AND_ACUTE : CodePoint = CodePoint::from(511u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(512u32);
    pub const LATIN_SMALL_LETTER_A_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(513u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(514u32);
    pub const LATIN_SMALL_LETTER_A_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(515u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(516u32);
    pub const LATIN_SMALL_LETTER_E_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(517u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(518u32);
    pub const LATIN_SMALL_LETTER_E_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(519u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(520u32);
    pub const LATIN_SMALL_LETTER_I_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(521u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(522u32);
    pub const LATIN_SMALL_LETTER_I_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(523u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(524u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(525u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(526u32);
    pub const LATIN_SMALL_LETTER_O_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(527u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(528u32);
    pub const LATIN_SMALL_LETTER_R_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(529u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(530u32);
    pub const LATIN_SMALL_LETTER_R_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(531u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(532u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DOUBLE_GRAVE : CodePoint = CodePoint::from(533u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(534u32);
    pub const LATIN_SMALL_LETTER_U_WITH_INVERTED_BREVE : CodePoint = CodePoint::from(535u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_COMMA_BELOW : CodePoint = CodePoint::from(536u32);
    pub const LATIN_SMALL_LETTER_S_WITH_COMMA_BELOW : CodePoint = CodePoint::from(537u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_COMMA_BELOW : CodePoint = CodePoint::from(538u32);
    pub const LATIN_SMALL_LETTER_T_WITH_COMMA_BELOW : CodePoint = CodePoint::from(539u32);
    pub const LATIN_CAPITAL_LETTER_YOGH : CodePoint = CodePoint::from(540u32);
    pub const LATIN_SMALL_LETTER_YOGH : CodePoint = CodePoint::from(541u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_CARON : CodePoint = CodePoint::from(542u32);
    pub const LATIN_SMALL_LETTER_H_WITH_CARON : CodePoint = CodePoint::from(543u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_LONG_RIGHT_LEG : CodePoint = CodePoint::from(544u32);
    pub const LATIN_SMALL_LETTER_D_WITH_CURL : CodePoint = CodePoint::from(545u32);
    pub const LATIN_CAPITAL_LETTER_OU : CodePoint = CodePoint::from(546u32);
    pub const LATIN_SMALL_LETTER_OU : CodePoint = CodePoint::from(547u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_HOOK : CodePoint = CodePoint::from(548u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_HOOK : CodePoint = CodePoint::from(549u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE : CodePoint = CodePoint::from(550u32);
    pub const LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE : CodePoint = CodePoint::from(551u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CEDILLA : CodePoint = CodePoint::from(552u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CEDILLA : CodePoint = CodePoint::from(553u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS_AND_MACRON : CodePoint = CodePoint::from(554u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DIAERESIS_AND_MACRON : CodePoint = CodePoint::from(555u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_MACRON : CodePoint = CodePoint::from(556u32);
    pub const LATIN_SMALL_LETTER_O_WITH_TILDE_AND_MACRON : CodePoint = CodePoint::from(557u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE : CodePoint = CodePoint::from(558u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE : CodePoint = CodePoint::from(559u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON : CodePoint = CodePoint::from(560u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON : CodePoint = CodePoint::from(561u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_MACRON : CodePoint = CodePoint::from(562u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_MACRON : CodePoint = CodePoint::from(563u32);
    pub const LATIN_SMALL_LETTER_L_WITH_CURL : CodePoint = CodePoint::from(564u32);
    pub const LATIN_SMALL_LETTER_N_WITH_CURL : CodePoint = CodePoint::from(565u32);
    pub const LATIN_SMALL_LETTER_T_WITH_CURL : CodePoint = CodePoint::from(566u32);
    pub const LATIN_SMALL_LETTER_DOTLESS_J : CodePoint = CodePoint::from(567u32);
    pub const LATIN_SMALL_LETTER_DB_DIGRAPH : CodePoint = CodePoint::from(568u32);
    pub const LATIN_SMALL_LETTER_QP_DIGRAPH : CodePoint = CodePoint::from(569u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_STROKE : CodePoint = CodePoint::from(570u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_STROKE : CodePoint = CodePoint::from(571u32);
    pub const LATIN_SMALL_LETTER_C_WITH_STROKE : CodePoint = CodePoint::from(572u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_BAR : CodePoint = CodePoint::from(573u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_DIAGONAL_STROKE : CodePoint = CodePoint::from(574u32);
    pub const LATIN_SMALL_LETTER_S_WITH_SWASH_TAIL : CodePoint = CodePoint::from(575u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_SWASH_TAIL : CodePoint = CodePoint::from(576u32);
    pub const LATIN_CAPITAL_LETTER_GLOTTAL_STOP : CodePoint = CodePoint::from(577u32);
    pub const LATIN_SMALL_LETTER_GLOTTAL_STOP : CodePoint = CodePoint::from(578u32);
    pub const LATIN_CAPITAL_LETTER_B_WITH_STROKE : CodePoint = CodePoint::from(579u32);
    pub const LATIN_CAPITAL_LETTER_U_BAR : CodePoint = CodePoint::from(580u32);
    pub const LATIN_CAPITAL_LETTER_TURNED_V : CodePoint = CodePoint::from(581u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_STROKE : CodePoint = CodePoint::from(582u32);
    pub const LATIN_SMALL_LETTER_E_WITH_STROKE : CodePoint = CodePoint::from(583u32);
    pub const LATIN_CAPITAL_LETTER_J_WITH_STROKE : CodePoint = CodePoint::from(584u32);
    pub const LATIN_SMALL_LETTER_J_WITH_STROKE : CodePoint = CodePoint::from(585u32);
    pub const LATIN_CAPITAL_LETTER_SMALL_Q_WITH_HOOK_TAIL : CodePoint = CodePoint::from(586u32);
    pub const LATIN_SMALL_LETTER_Q_WITH_HOOK_TAIL : CodePoint = CodePoint::from(587u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_STROKE : CodePoint = CodePoint::from(588u32);
    pub const LATIN_SMALL_LETTER_R_WITH_STROKE : CodePoint = CodePoint::from(589u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_STROKE : CodePoint = CodePoint::from(590u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_STROKE : CodePoint = CodePoint::from(591u32);
    pub const LATIN_SMALL_LETTER_TURNED_A : CodePoint = CodePoint::from(592u32);
    pub const LATIN_SMALL_LETTER_ALPHA : CodePoint = CodePoint::from(593u32);
    pub const LATIN_SMALL_LETTER_TURNED_ALPHA : CodePoint = CodePoint::from(594u32);
    pub const LATIN_SMALL_LETTER_B_WITH_HOOK : CodePoint = CodePoint::from(595u32);
    pub const LATIN_SMALL_LETTER_OPEN_O : CodePoint = CodePoint::from(596u32);
    pub const LATIN_SMALL_LETTER_C_WITH_CURL : CodePoint = CodePoint::from(597u32);
    pub const LATIN_SMALL_LETTER_D_WITH_TAIL : CodePoint = CodePoint::from(598u32);
    pub const LATIN_SMALL_LETTER_D_WITH_HOOK : CodePoint = CodePoint::from(599u32);
    pub const LATIN_SMALL_LETTER_REVERSED_E : CodePoint = CodePoint::from(600u32);
    pub const LATIN_SMALL_LETTER_SCHWA : CodePoint = CodePoint::from(601u32);
    pub const LATIN_SMALL_LETTER_SCHWA_WITH_HOOK : CodePoint = CodePoint::from(602u32);
    pub const LATIN_SMALL_LETTER_OPEN_E : CodePoint = CodePoint::from(603u32);
    pub const LATIN_SMALL_LETTER_REVERSED_OPEN_E : CodePoint = CodePoint::from(604u32);
    pub const LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_HOOK : CodePoint = CodePoint::from(605u32);
    pub const LATIN_SMALL_LETTER_CLOSED_REVERSED_OPEN_E : CodePoint = CodePoint::from(606u32);
    pub const LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE : CodePoint = CodePoint::from(607u32);
    pub const LATIN_SMALL_LETTER_G_WITH_HOOK : CodePoint = CodePoint::from(608u32);
    pub const LATIN_SMALL_LETTER_SCRIPT_G : CodePoint = CodePoint::from(609u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_G : CodePoint = CodePoint::from(610u32);
    pub const LATIN_SMALL_LETTER_GAMMA : CodePoint = CodePoint::from(611u32);
    pub const LATIN_SMALL_LETTER_RAMS_HORN : CodePoint = CodePoint::from(612u32);
    pub const LATIN_SMALL_LETTER_TURNED_H : CodePoint = CodePoint::from(613u32);
    pub const LATIN_SMALL_LETTER_H_WITH_HOOK : CodePoint = CodePoint::from(614u32);
    pub const LATIN_SMALL_LETTER_HENG_WITH_HOOK : CodePoint = CodePoint::from(615u32);
    pub const LATIN_SMALL_LETTER_I_WITH_STROKE : CodePoint = CodePoint::from(616u32);
    pub const LATIN_SMALL_LETTER_IOTA : CodePoint = CodePoint::from(617u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_I : CodePoint = CodePoint::from(618u32);
    pub const LATIN_SMALL_LETTER_L_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(619u32);
    pub const LATIN_SMALL_LETTER_L_WITH_BELT : CodePoint = CodePoint::from(620u32);
    pub const LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(621u32);
    pub const LATIN_SMALL_LETTER_LEZH : CodePoint = CodePoint::from(622u32);
    pub const LATIN_SMALL_LETTER_TURNED_M : CodePoint = CodePoint::from(623u32);
    pub const LATIN_SMALL_LETTER_TURNED_M_WITH_LONG_LEG : CodePoint = CodePoint::from(624u32);
    pub const LATIN_SMALL_LETTER_M_WITH_HOOK : CodePoint = CodePoint::from(625u32);
    pub const LATIN_SMALL_LETTER_N_WITH_LEFT_HOOK : CodePoint = CodePoint::from(626u32);
    pub const LATIN_SMALL_LETTER_N_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(627u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_N : CodePoint = CodePoint::from(628u32);
    pub const LATIN_SMALL_LETTER_BARRED_O : CodePoint = CodePoint::from(629u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_OE : CodePoint = CodePoint::from(630u32);
    pub const LATIN_SMALL_LETTER_CLOSED_OMEGA : CodePoint = CodePoint::from(631u32);
    pub const LATIN_SMALL_LETTER_PHI : CodePoint = CodePoint::from(632u32);
    pub const LATIN_SMALL_LETTER_TURNED_R : CodePoint = CodePoint::from(633u32);
    pub const LATIN_SMALL_LETTER_TURNED_R_WITH_LONG_LEG : CodePoint = CodePoint::from(634u32);
    pub const LATIN_SMALL_LETTER_TURNED_R_WITH_HOOK : CodePoint = CodePoint::from(635u32);
    pub const LATIN_SMALL_LETTER_R_WITH_LONG_LEG : CodePoint = CodePoint::from(636u32);
    pub const LATIN_SMALL_LETTER_R_WITH_TAIL : CodePoint = CodePoint::from(637u32);
    pub const LATIN_SMALL_LETTER_R_WITH_FISHHOOK : CodePoint = CodePoint::from(638u32);
    pub const LATIN_SMALL_LETTER_REVERSED_R_WITH_FISHHOOK : CodePoint = CodePoint::from(639u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_R : CodePoint = CodePoint::from(640u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_INVERTED_R : CodePoint = CodePoint::from(641u32);
    pub const LATIN_SMALL_LETTER_S_WITH_HOOK : CodePoint = CodePoint::from(642u32);
    pub const LATIN_SMALL_LETTER_ESH : CodePoint = CodePoint::from(643u32);
    pub const LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE_AND_HOOK : CodePoint = CodePoint::from(644u32);
    pub const LATIN_SMALL_LETTER_SQUAT_REVERSED_ESH : CodePoint = CodePoint::from(645u32);
    pub const LATIN_SMALL_LETTER_ESH_WITH_CURL : CodePoint = CodePoint::from(646u32);
    pub const LATIN_SMALL_LETTER_TURNED_T : CodePoint = CodePoint::from(647u32);
    pub const LATIN_SMALL_LETTER_T_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(648u32);
    pub const LATIN_SMALL_LETTER_U_BAR : CodePoint = CodePoint::from(649u32);
    pub const LATIN_SMALL_LETTER_UPSILON : CodePoint = CodePoint::from(650u32);
    pub const LATIN_SMALL_LETTER_V_WITH_HOOK : CodePoint = CodePoint::from(651u32);
    pub const LATIN_SMALL_LETTER_TURNED_V : CodePoint = CodePoint::from(652u32);
    pub const LATIN_SMALL_LETTER_TURNED_W : CodePoint = CodePoint::from(653u32);
    pub const LATIN_SMALL_LETTER_TURNED_Y : CodePoint = CodePoint::from(654u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_Y : CodePoint = CodePoint::from(655u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(656u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_CURL : CodePoint = CodePoint::from(657u32);
    pub const LATIN_SMALL_LETTER_EZH : CodePoint = CodePoint::from(658u32);
    pub const LATIN_SMALL_LETTER_EZH_WITH_CURL : CodePoint = CodePoint::from(659u32);
    pub const LATIN_LETTER_GLOTTAL_STOP : CodePoint = CodePoint::from(660u32);
    pub const LATIN_LETTER_PHARYNGEAL_VOICED_FRICATIVE : CodePoint = CodePoint::from(661u32);
    pub const LATIN_LETTER_INVERTED_GLOTTAL_STOP : CodePoint = CodePoint::from(662u32);
    pub const LATIN_LETTER_STRETCHED_C : CodePoint = CodePoint::from(663u32);
    pub const LATIN_LETTER_BILABIAL_CLICK : CodePoint = CodePoint::from(664u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_B : CodePoint = CodePoint::from(665u32);
    pub const LATIN_SMALL_LETTER_CLOSED_OPEN_E : CodePoint = CodePoint::from(666u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_G_WITH_HOOK : CodePoint = CodePoint::from(667u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_H : CodePoint = CodePoint::from(668u32);
    pub const LATIN_SMALL_LETTER_J_WITH_CROSSED_TAIL : CodePoint = CodePoint::from(669u32);
    pub const LATIN_SMALL_LETTER_TURNED_K : CodePoint = CodePoint::from(670u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_L : CodePoint = CodePoint::from(671u32);
    pub const LATIN_SMALL_LETTER_Q_WITH_HOOK : CodePoint = CodePoint::from(672u32);
    pub const LATIN_LETTER_GLOTTAL_STOP_WITH_STROKE : CodePoint = CodePoint::from(673u32);
    pub const LATIN_LETTER_REVERSED_GLOTTAL_STOP_WITH_STROKE : CodePoint = CodePoint::from(674u32);
    pub const LATIN_SMALL_LETTER_DZ_DIGRAPH : CodePoint = CodePoint::from(675u32);
    pub const LATIN_SMALL_LETTER_DEZH_DIGRAPH : CodePoint = CodePoint::from(676u32);
    pub const LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_CURL : CodePoint = CodePoint::from(677u32);
    pub const LATIN_SMALL_LETTER_TS_DIGRAPH : CodePoint = CodePoint::from(678u32);
    pub const LATIN_SMALL_LETTER_TESH_DIGRAPH : CodePoint = CodePoint::from(679u32);
    pub const LATIN_SMALL_LETTER_TC_DIGRAPH_WITH_CURL : CodePoint = CodePoint::from(680u32);
    pub const LATIN_SMALL_LETTER_FENG_DIGRAPH : CodePoint = CodePoint::from(681u32);
    pub const LATIN_SMALL_LETTER_LS_DIGRAPH : CodePoint = CodePoint::from(682u32);
    pub const LATIN_SMALL_LETTER_LZ_DIGRAPH : CodePoint = CodePoint::from(683u32);
    pub const LATIN_LETTER_BILABIAL_PERCUSSIVE : CodePoint = CodePoint::from(684u32);
    pub const LATIN_LETTER_BIDENTAL_PERCUSSIVE : CodePoint = CodePoint::from(685u32);
    pub const LATIN_SMALL_LETTER_TURNED_H_WITH_FISHHOOK : CodePoint = CodePoint::from(686u32);
    pub const LATIN_SMALL_LETTER_TURNED_H_WITH_FISHHOOK_AND_TAIL : CodePoint = CodePoint::from(687u32);
    pub const MODIFIER_LETTER_SMALL_H : CodePoint = CodePoint::from(688u32);
    pub const MODIFIER_LETTER_SMALL_H_WITH_HOOK : CodePoint = CodePoint::from(689u32);
    pub const MODIFIER_LETTER_SMALL_J : CodePoint = CodePoint::from(690u32);
    pub const MODIFIER_LETTER_SMALL_R : CodePoint = CodePoint::from(691u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_R : CodePoint = CodePoint::from(692u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_R_WITH_HOOK : CodePoint = CodePoint::from(693u32);
    pub const MODIFIER_LETTER_SMALL_CAPITAL_INVERTED_R : CodePoint = CodePoint::from(694u32);
    pub const MODIFIER_LETTER_SMALL_W : CodePoint = CodePoint::from(695u32);
    pub const MODIFIER_LETTER_SMALL_Y : CodePoint = CodePoint::from(696u32);
    pub const MODIFIER_LETTER_PRIME : CodePoint = CodePoint::from(697u32);
    pub const MODIFIER_LETTER_DOUBLE_PRIME : CodePoint = CodePoint::from(698u32);
    pub const MODIFIER_LETTER_TURNED_COMMA : CodePoint = CodePoint::from(699u32);
    pub const MODIFIER_LETTER_APOSTROPHE : CodePoint = CodePoint::from(700u32);
    pub const MODIFIER_LETTER_REVERSED_COMMA : CodePoint = CodePoint::from(701u32);
    pub const MODIFIER_LETTER_RIGHT_HALF_RING : CodePoint = CodePoint::from(702u32);
    pub const MODIFIER_LETTER_LEFT_HALF_RING : CodePoint = CodePoint::from(703u32);
    pub const MODIFIER_LETTER_GLOTTAL_STOP : CodePoint = CodePoint::from(704u32);
    pub const MODIFIER_LETTER_REVERSED_GLOTTAL_STOP : CodePoint = CodePoint::from(705u32);
    pub const MODIFIER_LETTER_LEFT_ARROWHEAD : CodePoint = CodePoint::from(706u32);
    pub const MODIFIER_LETTER_RIGHT_ARROWHEAD : CodePoint = CodePoint::from(707u32);
    pub const MODIFIER_LETTER_UP_ARROWHEAD : CodePoint = CodePoint::from(708u32);
    pub const MODIFIER_LETTER_DOWN_ARROWHEAD : CodePoint = CodePoint::from(709u32);
    pub const MODIFIER_LETTER_CIRCUMFLEX_ACCENT : CodePoint = CodePoint::from(710u32);
    pub const CARON : CodePoint = CodePoint::from(711u32);
    pub const MODIFIER_LETTER_VERTICAL_LINE : CodePoint = CodePoint::from(712u32);
    pub const MODIFIER_LETTER_MACRON : CodePoint = CodePoint::from(713u32);
    pub const MODIFIER_LETTER_ACUTE_ACCENT : CodePoint = CodePoint::from(714u32);
    pub const MODIFIER_LETTER_GRAVE_ACCENT : CodePoint = CodePoint::from(715u32);
    pub const MODIFIER_LETTER_LOW_VERTICAL_LINE : CodePoint = CodePoint::from(716u32);
    pub const MODIFIER_LETTER_LOW_MACRON : CodePoint = CodePoint::from(717u32);
    pub const MODIFIER_LETTER_LOW_GRAVE_ACCENT : CodePoint = CodePoint::from(718u32);
    pub const MODIFIER_LETTER_LOW_ACUTE_ACCENT : CodePoint = CodePoint::from(719u32);
    pub const MODIFIER_LETTER_TRIANGULAR_COLON : CodePoint = CodePoint::from(720u32);
    pub const MODIFIER_LETTER_HALF_TRIANGULAR_COLON : CodePoint = CodePoint::from(721u32);
    pub const MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING : CodePoint = CodePoint::from(722u32);
    pub const MODIFIER_LETTER_CENTRED_LEFT_HALF_RING : CodePoint = CodePoint::from(723u32);
    pub const MODIFIER_LETTER_UP_TACK : CodePoint = CodePoint::from(724u32);
    pub const MODIFIER_LETTER_DOWN_TACK : CodePoint = CodePoint::from(725u32);
    pub const MODIFIER_LETTER_PLUS_SIGN : CodePoint = CodePoint::from(726u32);
    pub const MODIFIER_LETTER_MINUS_SIGN : CodePoint = CodePoint::from(727u32);
    pub const BREVE : CodePoint = CodePoint::from(728u32);
    pub const DOT_ABOVE : CodePoint = CodePoint::from(729u32);
    pub const RING_ABOVE : CodePoint = CodePoint::from(730u32);
    pub const OGONEK : CodePoint = CodePoint::from(731u32);
    pub const SMALL_TILDE : CodePoint = CodePoint::from(732u32);
    pub const DOUBLE_ACUTE_ACCENT : CodePoint = CodePoint::from(733u32);
    pub const MODIFIER_LETTER_RHOTIC_HOOK : CodePoint = CodePoint::from(734u32);
    pub const MODIFIER_LETTER_CROSS_ACCENT : CodePoint = CodePoint::from(735u32);
    pub const MODIFIER_LETTER_SMALL_GAMMA : CodePoint = CodePoint::from(736u32);
    pub const MODIFIER_LETTER_SMALL_L : CodePoint = CodePoint::from(737u32);
    pub const MODIFIER_LETTER_SMALL_S : CodePoint = CodePoint::from(738u32);
    pub const MODIFIER_LETTER_SMALL_X : CodePoint = CodePoint::from(739u32);
    pub const MODIFIER_LETTER_SMALL_REVERSED_GLOTTAL_STOP : CodePoint = CodePoint::from(740u32);
    pub const MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR : CodePoint = CodePoint::from(741u32);
    pub const MODIFIER_LETTER_HIGH_TONE_BAR : CodePoint = CodePoint::from(742u32);
    pub const MODIFIER_LETTER_MID_TONE_BAR : CodePoint = CodePoint::from(743u32);
    pub const MODIFIER_LETTER_LOW_TONE_BAR : CodePoint = CodePoint::from(744u32);
    pub const MODIFIER_LETTER_EXTRA_LOW_TONE_BAR : CodePoint = CodePoint::from(745u32);
    pub const MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK : CodePoint = CodePoint::from(746u32);
    pub const MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK : CodePoint = CodePoint::from(747u32);
    pub const MODIFIER_LETTER_VOICING : CodePoint = CodePoint::from(748u32);
    pub const MODIFIER_LETTER_UNASPIRATED : CodePoint = CodePoint::from(749u32);
    pub const MODIFIER_LETTER_DOUBLE_APOSTROPHE : CodePoint = CodePoint::from(750u32);
    pub const MODIFIER_LETTER_LOW_DOWN_ARROWHEAD : CodePoint = CodePoint::from(751u32);
    pub const MODIFIER_LETTER_LOW_UP_ARROWHEAD : CodePoint = CodePoint::from(752u32);
    pub const MODIFIER_LETTER_LOW_LEFT_ARROWHEAD : CodePoint = CodePoint::from(753u32);
    pub const MODIFIER_LETTER_LOW_RIGHT_ARROWHEAD : CodePoint = CodePoint::from(754u32);
    pub const MODIFIER_LETTER_LOW_RING : CodePoint = CodePoint::from(755u32);
    pub const MODIFIER_LETTER_MIDDLE_GRAVE_ACCENT : CodePoint = CodePoint::from(756u32);
    pub const MODIFIER_LETTER_MIDDLE_DOUBLE_GRAVE_ACCENT : CodePoint = CodePoint::from(757u32);
    pub const MODIFIER_LETTER_MIDDLE_DOUBLE_ACUTE_ACCENT : CodePoint = CodePoint::from(758u32);
    pub const MODIFIER_LETTER_LOW_TILDE : CodePoint = CodePoint::from(759u32);
    pub const MODIFIER_LETTER_RAISED_COLON : CodePoint = CodePoint::from(760u32);
    pub const MODIFIER_LETTER_BEGIN_HIGH_TONE : CodePoint = CodePoint::from(761u32);
    pub const MODIFIER_LETTER_END_HIGH_TONE : CodePoint = CodePoint::from(762u32);
    pub const MODIFIER_LETTER_BEGIN_LOW_TONE : CodePoint = CodePoint::from(763u32);
    pub const MODIFIER_LETTER_END_LOW_TONE : CodePoint = CodePoint::from(764u32);
    pub const MODIFIER_LETTER_SHELF : CodePoint = CodePoint::from(765u32);
    pub const MODIFIER_LETTER_OPEN_SHELF : CodePoint = CodePoint::from(766u32);
    pub const MODIFIER_LETTER_LOW_LEFT_ARROW : CodePoint = CodePoint::from(767u32);
    pub const COMBINING_GRAVE_ACCENT : CodePoint = CodePoint::from(768u32);
    pub const COMBINING_ACUTE_ACCENT : CodePoint = CodePoint::from(769u32);
    pub const COMBINING_CIRCUMFLEX_ACCENT : CodePoint = CodePoint::from(770u32);
    pub const COMBINING_TILDE : CodePoint = CodePoint::from(771u32);
    pub const COMBINING_MACRON : CodePoint = CodePoint::from(772u32);
    pub const COMBINING_OVERLINE : CodePoint = CodePoint::from(773u32);
    pub const COMBINING_BREVE : CodePoint = CodePoint::from(774u32);
    pub const COMBINING_DOT_ABOVE : CodePoint = CodePoint::from(775u32);
    pub const COMBINING_DIAERESIS : CodePoint = CodePoint::from(776u32);
    pub const COMBINING_HOOK_ABOVE : CodePoint = CodePoint::from(777u32);
    pub const COMBINING_RING_ABOVE : CodePoint = CodePoint::from(778u32);
    pub const COMBINING_DOUBLE_ACUTE_ACCENT : CodePoint = CodePoint::from(779u32);
    pub const COMBINING_CARON : CodePoint = CodePoint::from(780u32);
    pub const COMBINING_VERTICAL_LINE_ABOVE : CodePoint = CodePoint::from(781u32);
    pub const COMBINING_DOUBLE_VERTICAL_LINE_ABOVE : CodePoint = CodePoint::from(782u32);
    pub const COMBINING_DOUBLE_GRAVE_ACCENT : CodePoint = CodePoint::from(783u32);
    pub const COMBINING_CANDRABINDU : CodePoint = CodePoint::from(784u32);
    pub const COMBINING_INVERTED_BREVE : CodePoint = CodePoint::from(785u32);
    pub const COMBINING_TURNED_COMMA_ABOVE : CodePoint = CodePoint::from(786u32);
    pub const COMBINING_COMMA_ABOVE : CodePoint = CodePoint::from(787u32);
    pub const COMBINING_REVERSED_COMMA_ABOVE : CodePoint = CodePoint::from(788u32);
    pub const COMBINING_COMMA_ABOVE_RIGHT : CodePoint = CodePoint::from(789u32);
    pub const COMBINING_GRAVE_ACCENT_BELOW : CodePoint = CodePoint::from(790u32);
    pub const COMBINING_ACUTE_ACCENT_BELOW : CodePoint = CodePoint::from(791u32);
    pub const COMBINING_LEFT_TACK_BELOW : CodePoint = CodePoint::from(792u32);
    pub const COMBINING_RIGHT_TACK_BELOW : CodePoint = CodePoint::from(793u32);
    pub const COMBINING_LEFT_ANGLE_ABOVE : CodePoint = CodePoint::from(794u32);
    pub const COMBINING_HORN : CodePoint = CodePoint::from(795u32);
    pub const COMBINING_LEFT_HALF_RING_BELOW : CodePoint = CodePoint::from(796u32);
    pub const COMBINING_UP_TACK_BELOW : CodePoint = CodePoint::from(797u32);
    pub const COMBINING_DOWN_TACK_BELOW : CodePoint = CodePoint::from(798u32);
    pub const COMBINING_PLUS_SIGN_BELOW : CodePoint = CodePoint::from(799u32);
    pub const COMBINING_MINUS_SIGN_BELOW : CodePoint = CodePoint::from(800u32);
    pub const COMBINING_PALATALIZED_HOOK_BELOW : CodePoint = CodePoint::from(801u32);
    pub const COMBINING_RETROFLEX_HOOK_BELOW : CodePoint = CodePoint::from(802u32);
    pub const COMBINING_DOT_BELOW : CodePoint = CodePoint::from(803u32);
    pub const COMBINING_DIAERESIS_BELOW : CodePoint = CodePoint::from(804u32);
    pub const COMBINING_RING_BELOW : CodePoint = CodePoint::from(805u32);
    pub const COMBINING_COMMA_BELOW : CodePoint = CodePoint::from(806u32);
    pub const COMBINING_CEDILLA : CodePoint = CodePoint::from(807u32);
    pub const COMBINING_OGONEK : CodePoint = CodePoint::from(808u32);
    pub const COMBINING_VERTICAL_LINE_BELOW : CodePoint = CodePoint::from(809u32);
    pub const COMBINING_BRIDGE_BELOW : CodePoint = CodePoint::from(810u32);
    pub const COMBINING_INVERTED_DOUBLE_ARCH_BELOW : CodePoint = CodePoint::from(811u32);
    pub const COMBINING_CARON_BELOW : CodePoint = CodePoint::from(812u32);
    pub const COMBINING_CIRCUMFLEX_ACCENT_BELOW : CodePoint = CodePoint::from(813u32);
    pub const COMBINING_BREVE_BELOW : CodePoint = CodePoint::from(814u32);
    pub const COMBINING_INVERTED_BREVE_BELOW : CodePoint = CodePoint::from(815u32);
    pub const COMBINING_TILDE_BELOW : CodePoint = CodePoint::from(816u32);
    pub const COMBINING_MACRON_BELOW : CodePoint = CodePoint::from(817u32);
    pub const COMBINING_LOW_LINE : CodePoint = CodePoint::from(818u32);
    pub const COMBINING_DOUBLE_LOW_LINE : CodePoint = CodePoint::from(819u32);
    pub const COMBINING_TILDE_OVERLAY : CodePoint = CodePoint::from(820u32);
    pub const COMBINING_SHORT_STROKE_OVERLAY : CodePoint = CodePoint::from(821u32);
    pub const COMBINING_LONG_STROKE_OVERLAY : CodePoint = CodePoint::from(822u32);
    pub const COMBINING_SHORT_SOLIDUS_OVERLAY : CodePoint = CodePoint::from(823u32);
    pub const COMBINING_LONG_SOLIDUS_OVERLAY : CodePoint = CodePoint::from(824u32);
    pub const COMBINING_RIGHT_HALF_RING_BELOW : CodePoint = CodePoint::from(825u32);
    pub const COMBINING_INVERTED_BRIDGE_BELOW : CodePoint = CodePoint::from(826u32);
    pub const COMBINING_SQUARE_BELOW : CodePoint = CodePoint::from(827u32);
    pub const COMBINING_SEAGULL_BELOW : CodePoint = CodePoint::from(828u32);
    pub const COMBINING_X_ABOVE : CodePoint = CodePoint::from(829u32);
    pub const COMBINING_VERTICAL_TILDE : CodePoint = CodePoint::from(830u32);
    pub const COMBINING_DOUBLE_OVERLINE : CodePoint = CodePoint::from(831u32);
    pub const COMBINING_GRAVE_TONE_MARK : CodePoint = CodePoint::from(832u32);
    pub const COMBINING_ACUTE_TONE_MARK : CodePoint = CodePoint::from(833u32);
    pub const COMBINING_GREEK_PERISPOMENI : CodePoint = CodePoint::from(834u32);
    pub const COMBINING_GREEK_KORONIS : CodePoint = CodePoint::from(835u32);
    pub const COMBINING_GREEK_DIALYTIKA_TONOS : CodePoint = CodePoint::from(836u32);
    pub const COMBINING_GREEK_YPOGEGRAMMENI : CodePoint = CodePoint::from(837u32);
    pub const COMBINING_BRIDGE_ABOVE : CodePoint = CodePoint::from(838u32);
    pub const COMBINING_EQUALS_SIGN_BELOW : CodePoint = CodePoint::from(839u32);
    pub const COMBINING_DOUBLE_VERTICAL_LINE_BELOW : CodePoint = CodePoint::from(840u32);
    pub const COMBINING_LEFT_ANGLE_BELOW : CodePoint = CodePoint::from(841u32);
    pub const COMBINING_NOT_TILDE_ABOVE : CodePoint = CodePoint::from(842u32);
    pub const COMBINING_HOMOTHETIC_ABOVE : CodePoint = CodePoint::from(843u32);
    pub const COMBINING_ALMOST_EQUAL_TO_ABOVE : CodePoint = CodePoint::from(844u32);
    pub const COMBINING_LEFT_RIGHT_ARROW_BELOW : CodePoint = CodePoint::from(845u32);
    pub const COMBINING_UPWARDS_ARROW_BELOW : CodePoint = CodePoint::from(846u32);
    pub const COMBINING_GRAPHEME_JOINER : CodePoint = CodePoint::from(847u32);
    pub const COMBINING_RIGHT_ARROWHEAD_ABOVE : CodePoint = CodePoint::from(848u32);
    pub const COMBINING_LEFT_HALF_RING_ABOVE : CodePoint = CodePoint::from(849u32);
    pub const COMBINING_FERMATA : CodePoint = CodePoint::from(850u32);
    pub const COMBINING_X_BELOW : CodePoint = CodePoint::from(851u32);
    pub const COMBINING_LEFT_ARROWHEAD_BELOW : CodePoint = CodePoint::from(852u32);
    pub const COMBINING_RIGHT_ARROWHEAD_BELOW : CodePoint = CodePoint::from(853u32);
    pub const COMBINING_RIGHT_ARROWHEAD_AND_UP_ARROWHEAD_BELOW : CodePoint = CodePoint::from(854u32);
    pub const COMBINING_RIGHT_HALF_RING_ABOVE : CodePoint = CodePoint::from(855u32);
    pub const COMBINING_DOT_ABOVE_RIGHT : CodePoint = CodePoint::from(856u32);
    pub const COMBINING_ASTERISK_BELOW : CodePoint = CodePoint::from(857u32);
    pub const COMBINING_DOUBLE_RING_BELOW : CodePoint = CodePoint::from(858u32);
    pub const COMBINING_ZIGZAG_ABOVE : CodePoint = CodePoint::from(859u32);
    pub const COMBINING_DOUBLE_BREVE_BELOW : CodePoint = CodePoint::from(860u32);
    pub const COMBINING_DOUBLE_BREVE : CodePoint = CodePoint::from(861u32);
    pub const COMBINING_DOUBLE_MACRON : CodePoint = CodePoint::from(862u32);
    pub const COMBINING_DOUBLE_MACRON_BELOW : CodePoint = CodePoint::from(863u32);
    pub const COMBINING_DOUBLE_TILDE : CodePoint = CodePoint::from(864u32);
    pub const COMBINING_DOUBLE_INVERTED_BREVE : CodePoint = CodePoint::from(865u32);
    pub const COMBINING_DOUBLE_RIGHTWARDS_ARROW_BELOW : CodePoint = CodePoint::from(866u32);
    pub const COMBINING_LATIN_SMALL_LETTER_A : CodePoint = CodePoint::from(867u32);
    pub const COMBINING_LATIN_SMALL_LETTER_E : CodePoint = CodePoint::from(868u32);
    pub const COMBINING_LATIN_SMALL_LETTER_I : CodePoint = CodePoint::from(869u32);
    pub const COMBINING_LATIN_SMALL_LETTER_O : CodePoint = CodePoint::from(870u32);
    pub const COMBINING_LATIN_SMALL_LETTER_U : CodePoint = CodePoint::from(871u32);
    pub const COMBINING_LATIN_SMALL_LETTER_C : CodePoint = CodePoint::from(872u32);
    pub const COMBINING_LATIN_SMALL_LETTER_D : CodePoint = CodePoint::from(873u32);
    pub const COMBINING_LATIN_SMALL_LETTER_H : CodePoint = CodePoint::from(874u32);
    pub const COMBINING_LATIN_SMALL_LETTER_M : CodePoint = CodePoint::from(875u32);
    pub const COMBINING_LATIN_SMALL_LETTER_R : CodePoint = CodePoint::from(876u32);
    pub const COMBINING_LATIN_SMALL_LETTER_T : CodePoint = CodePoint::from(877u32);
    pub const COMBINING_LATIN_SMALL_LETTER_V : CodePoint = CodePoint::from(878u32);
    pub const COMBINING_LATIN_SMALL_LETTER_X : CodePoint = CodePoint::from(879u32);
    pub const GREEK_CAPITAL_LETTER_HETA : CodePoint = CodePoint::from(880u32);
    pub const GREEK_SMALL_LETTER_HETA : CodePoint = CodePoint::from(881u32);
    pub const GREEK_CAPITAL_LETTER_ARCHAIC_SAMPI : CodePoint = CodePoint::from(882u32);
    pub const GREEK_SMALL_LETTER_ARCHAIC_SAMPI : CodePoint = CodePoint::from(883u32);
    pub const GREEK_NUMERAL_SIGN : CodePoint = CodePoint::from(884u32);
    pub const GREEK_LOWER_NUMERAL_SIGN : CodePoint = CodePoint::from(885u32);
    pub const GREEK_CAPITAL_LETTER_PAMPHYLIAN_DIGAMMA : CodePoint = CodePoint::from(886u32);
    pub const GREEK_SMALL_LETTER_PAMPHYLIAN_DIGAMMA : CodePoint = CodePoint::from(887u32);
    pub const GREEK_YPOGEGRAMMENI : CodePoint = CodePoint::from(890u32);
    pub const GREEK_SMALL_REVERSED_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(891u32);
    pub const GREEK_SMALL_DOTTED_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(892u32);
    pub const GREEK_SMALL_REVERSED_DOTTED_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(893u32);
    pub const GREEK_QUESTION_MARK : CodePoint = CodePoint::from(894u32);
    pub const GREEK_CAPITAL_LETTER_YOT : CodePoint = CodePoint::from(895u32);
    pub const GREEK_TONOS : CodePoint = CodePoint::from(900u32);
    pub const GREEK_DIALYTIKA_TONOS : CodePoint = CodePoint::from(901u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS : CodePoint = CodePoint::from(902u32);
    pub const GREEK_ANO_TELEIA : CodePoint = CodePoint::from(903u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS : CodePoint = CodePoint::from(904u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_TONOS : CodePoint = CodePoint::from(905u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS : CodePoint = CodePoint::from(906u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS : CodePoint = CodePoint::from(908u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS : CodePoint = CodePoint::from(910u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS : CodePoint = CodePoint::from(911u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS : CodePoint = CodePoint::from(912u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA : CodePoint = CodePoint::from(913u32);
    pub const GREEK_CAPITAL_LETTER_BETA : CodePoint = CodePoint::from(914u32);
    pub const GREEK_CAPITAL_LETTER_GAMMA : CodePoint = CodePoint::from(915u32);
    pub const GREEK_CAPITAL_LETTER_DELTA : CodePoint = CodePoint::from(916u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON : CodePoint = CodePoint::from(917u32);
    pub const GREEK_CAPITAL_LETTER_ZETA : CodePoint = CodePoint::from(918u32);
    pub const GREEK_CAPITAL_LETTER_ETA : CodePoint = CodePoint::from(919u32);
    pub const GREEK_CAPITAL_LETTER_THETA : CodePoint = CodePoint::from(920u32);
    pub const GREEK_CAPITAL_LETTER_IOTA : CodePoint = CodePoint::from(921u32);
    pub const GREEK_CAPITAL_LETTER_KAPPA : CodePoint = CodePoint::from(922u32);
    pub const GREEK_CAPITAL_LETTER_LAMDA : CodePoint = CodePoint::from(923u32);
    pub const GREEK_CAPITAL_LETTER_MU : CodePoint = CodePoint::from(924u32);
    pub const GREEK_CAPITAL_LETTER_NU : CodePoint = CodePoint::from(925u32);
    pub const GREEK_CAPITAL_LETTER_XI : CodePoint = CodePoint::from(926u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON : CodePoint = CodePoint::from(927u32);
    pub const GREEK_CAPITAL_LETTER_PI : CodePoint = CodePoint::from(928u32);
    pub const GREEK_CAPITAL_LETTER_RHO : CodePoint = CodePoint::from(929u32);
    pub const GREEK_CAPITAL_LETTER_SIGMA : CodePoint = CodePoint::from(931u32);
    pub const GREEK_CAPITAL_LETTER_TAU : CodePoint = CodePoint::from(932u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON : CodePoint = CodePoint::from(933u32);
    pub const GREEK_CAPITAL_LETTER_PHI : CodePoint = CodePoint::from(934u32);
    pub const GREEK_CAPITAL_LETTER_CHI : CodePoint = CodePoint::from(935u32);
    pub const GREEK_CAPITAL_LETTER_PSI : CodePoint = CodePoint::from(936u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA : CodePoint = CodePoint::from(937u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA : CodePoint = CodePoint::from(938u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA : CodePoint = CodePoint::from(939u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_TONOS : CodePoint = CodePoint::from(940u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_TONOS : CodePoint = CodePoint::from(941u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_TONOS : CodePoint = CodePoint::from(942u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_TONOS : CodePoint = CodePoint::from(943u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS : CodePoint = CodePoint::from(944u32);
    pub const GREEK_SMALL_LETTER_ALPHA : CodePoint = CodePoint::from(945u32);
    pub const GREEK_SMALL_LETTER_BETA : CodePoint = CodePoint::from(946u32);
    pub const GREEK_SMALL_LETTER_GAMMA : CodePoint = CodePoint::from(947u32);
    pub const GREEK_SMALL_LETTER_DELTA : CodePoint = CodePoint::from(948u32);
    pub const GREEK_SMALL_LETTER_EPSILON : CodePoint = CodePoint::from(949u32);
    pub const GREEK_SMALL_LETTER_ZETA : CodePoint = CodePoint::from(950u32);
    pub const GREEK_SMALL_LETTER_ETA : CodePoint = CodePoint::from(951u32);
    pub const GREEK_SMALL_LETTER_THETA : CodePoint = CodePoint::from(952u32);
    pub const GREEK_SMALL_LETTER_IOTA : CodePoint = CodePoint::from(953u32);
    pub const GREEK_SMALL_LETTER_KAPPA : CodePoint = CodePoint::from(954u32);
    pub const GREEK_SMALL_LETTER_LAMDA : CodePoint = CodePoint::from(955u32);
    pub const GREEK_SMALL_LETTER_MU : CodePoint = CodePoint::from(956u32);
    pub const GREEK_SMALL_LETTER_NU : CodePoint = CodePoint::from(957u32);
    pub const GREEK_SMALL_LETTER_XI : CodePoint = CodePoint::from(958u32);
    pub const GREEK_SMALL_LETTER_OMICRON : CodePoint = CodePoint::from(959u32);
    pub const GREEK_SMALL_LETTER_PI : CodePoint = CodePoint::from(960u32);
    pub const GREEK_SMALL_LETTER_RHO : CodePoint = CodePoint::from(961u32);
    pub const GREEK_SMALL_LETTER_FINAL_SIGMA : CodePoint = CodePoint::from(962u32);
    pub const GREEK_SMALL_LETTER_SIGMA : CodePoint = CodePoint::from(963u32);
    pub const GREEK_SMALL_LETTER_TAU : CodePoint = CodePoint::from(964u32);
    pub const GREEK_SMALL_LETTER_UPSILON : CodePoint = CodePoint::from(965u32);
    pub const GREEK_SMALL_LETTER_PHI : CodePoint = CodePoint::from(966u32);
    pub const GREEK_SMALL_LETTER_CHI : CodePoint = CodePoint::from(967u32);
    pub const GREEK_SMALL_LETTER_PSI : CodePoint = CodePoint::from(968u32);
    pub const GREEK_SMALL_LETTER_OMEGA : CodePoint = CodePoint::from(969u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA : CodePoint = CodePoint::from(970u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA : CodePoint = CodePoint::from(971u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_TONOS : CodePoint = CodePoint::from(972u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_TONOS : CodePoint = CodePoint::from(973u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_TONOS : CodePoint = CodePoint::from(974u32);
    pub const GREEK_CAPITAL_KAI_SYMBOL : CodePoint = CodePoint::from(975u32);
    pub const GREEK_BETA_SYMBOL : CodePoint = CodePoint::from(976u32);
    pub const GREEK_THETA_SYMBOL : CodePoint = CodePoint::from(977u32);
    pub const GREEK_UPSILON_WITH_HOOK_SYMBOL : CodePoint = CodePoint::from(978u32);
    pub const GREEK_UPSILON_WITH_ACUTE_AND_HOOK_SYMBOL : CodePoint = CodePoint::from(979u32);
    pub const GREEK_UPSILON_WITH_DIAERESIS_AND_HOOK_SYMBOL : CodePoint = CodePoint::from(980u32);
    pub const GREEK_PHI_SYMBOL : CodePoint = CodePoint::from(981u32);
    pub const GREEK_PI_SYMBOL : CodePoint = CodePoint::from(982u32);
    pub const GREEK_KAI_SYMBOL : CodePoint = CodePoint::from(983u32);
    pub const GREEK_LETTER_ARCHAIC_KOPPA : CodePoint = CodePoint::from(984u32);
    pub const GREEK_SMALL_LETTER_ARCHAIC_KOPPA : CodePoint = CodePoint::from(985u32);
    pub const GREEK_LETTER_STIGMA : CodePoint = CodePoint::from(986u32);
    pub const GREEK_SMALL_LETTER_STIGMA : CodePoint = CodePoint::from(987u32);
    pub const GREEK_LETTER_DIGAMMA : CodePoint = CodePoint::from(988u32);
    pub const GREEK_SMALL_LETTER_DIGAMMA : CodePoint = CodePoint::from(989u32);
    pub const GREEK_LETTER_KOPPA : CodePoint = CodePoint::from(990u32);
    pub const GREEK_SMALL_LETTER_KOPPA : CodePoint = CodePoint::from(991u32);
    pub const GREEK_LETTER_SAMPI : CodePoint = CodePoint::from(992u32);
    pub const GREEK_SMALL_LETTER_SAMPI : CodePoint = CodePoint::from(993u32);
    pub const COPTIC_CAPITAL_LETTER_SHEI : CodePoint = CodePoint::from(994u32);
    pub const COPTIC_SMALL_LETTER_SHEI : CodePoint = CodePoint::from(995u32);
    pub const COPTIC_CAPITAL_LETTER_FEI : CodePoint = CodePoint::from(996u32);
    pub const COPTIC_SMALL_LETTER_FEI : CodePoint = CodePoint::from(997u32);
    pub const COPTIC_CAPITAL_LETTER_KHEI : CodePoint = CodePoint::from(998u32);
    pub const COPTIC_SMALL_LETTER_KHEI : CodePoint = CodePoint::from(999u32);
    pub const COPTIC_CAPITAL_LETTER_HORI : CodePoint = CodePoint::from(1000u32);
    pub const COPTIC_SMALL_LETTER_HORI : CodePoint = CodePoint::from(1001u32);
    pub const COPTIC_CAPITAL_LETTER_GANGIA : CodePoint = CodePoint::from(1002u32);
    pub const COPTIC_SMALL_LETTER_GANGIA : CodePoint = CodePoint::from(1003u32);
    pub const COPTIC_CAPITAL_LETTER_SHIMA : CodePoint = CodePoint::from(1004u32);
    pub const COPTIC_SMALL_LETTER_SHIMA : CodePoint = CodePoint::from(1005u32);
    pub const COPTIC_CAPITAL_LETTER_DEI : CodePoint = CodePoint::from(1006u32);
    pub const COPTIC_SMALL_LETTER_DEI : CodePoint = CodePoint::from(1007u32);
    pub const GREEK_KAPPA_SYMBOL : CodePoint = CodePoint::from(1008u32);
    pub const GREEK_RHO_SYMBOL : CodePoint = CodePoint::from(1009u32);
    pub const GREEK_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(1010u32);
    pub const GREEK_LETTER_YOT : CodePoint = CodePoint::from(1011u32);
    pub const GREEK_CAPITAL_THETA_SYMBOL : CodePoint = CodePoint::from(1012u32);
    pub const GREEK_LUNATE_EPSILON_SYMBOL : CodePoint = CodePoint::from(1013u32);
    pub const GREEK_REVERSED_LUNATE_EPSILON_SYMBOL : CodePoint = CodePoint::from(1014u32);
    pub const GREEK_CAPITAL_LETTER_SHO : CodePoint = CodePoint::from(1015u32);
    pub const GREEK_SMALL_LETTER_SHO : CodePoint = CodePoint::from(1016u32);
    pub const GREEK_CAPITAL_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(1017u32);
    pub const GREEK_CAPITAL_LETTER_SAN : CodePoint = CodePoint::from(1018u32);
    pub const GREEK_SMALL_LETTER_SAN : CodePoint = CodePoint::from(1019u32);
    pub const GREEK_RHO_WITH_STROKE_SYMBOL : CodePoint = CodePoint::from(1020u32);
    pub const GREEK_CAPITAL_REVERSED_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(1021u32);
    pub const GREEK_CAPITAL_DOTTED_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(1022u32);
    pub const GREEK_CAPITAL_REVERSED_DOTTED_LUNATE_SIGMA_SYMBOL : CodePoint = CodePoint::from(1023u32);
    pub const CYRILLIC_CAPITAL_LETTER_IE_WITH_GRAVE : CodePoint = CodePoint::from(1024u32);
    pub const CYRILLIC_CAPITAL_LETTER_IO : CodePoint = CodePoint::from(1025u32);
    pub const CYRILLIC_CAPITAL_LETTER_DJE : CodePoint = CodePoint::from(1026u32);
    pub const CYRILLIC_CAPITAL_LETTER_GJE : CodePoint = CodePoint::from(1027u32);
    pub const CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE : CodePoint = CodePoint::from(1028u32);
    pub const CYRILLIC_CAPITAL_LETTER_DZE : CodePoint = CodePoint::from(1029u32);
    pub const CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I : CodePoint = CodePoint::from(1030u32);
    pub const CYRILLIC_CAPITAL_LETTER_YI : CodePoint = CodePoint::from(1031u32);
    pub const CYRILLIC_CAPITAL_LETTER_JE : CodePoint = CodePoint::from(1032u32);
    pub const CYRILLIC_CAPITAL_LETTER_LJE : CodePoint = CodePoint::from(1033u32);
    pub const CYRILLIC_CAPITAL_LETTER_NJE : CodePoint = CodePoint::from(1034u32);
    pub const CYRILLIC_CAPITAL_LETTER_TSHE : CodePoint = CodePoint::from(1035u32);
    pub const CYRILLIC_CAPITAL_LETTER_KJE : CodePoint = CodePoint::from(1036u32);
    pub const CYRILLIC_CAPITAL_LETTER_I_WITH_GRAVE : CodePoint = CodePoint::from(1037u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHORT_U : CodePoint = CodePoint::from(1038u32);
    pub const CYRILLIC_CAPITAL_LETTER_DZHE : CodePoint = CodePoint::from(1039u32);
    pub const CYRILLIC_CAPITAL_LETTER_A : CodePoint = CodePoint::from(1040u32);
    pub const CYRILLIC_CAPITAL_LETTER_BE : CodePoint = CodePoint::from(1041u32);
    pub const CYRILLIC_CAPITAL_LETTER_VE : CodePoint = CodePoint::from(1042u32);
    pub const CYRILLIC_CAPITAL_LETTER_GHE : CodePoint = CodePoint::from(1043u32);
    pub const CYRILLIC_CAPITAL_LETTER_DE : CodePoint = CodePoint::from(1044u32);
    pub const CYRILLIC_CAPITAL_LETTER_IE : CodePoint = CodePoint::from(1045u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZHE : CodePoint = CodePoint::from(1046u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZE : CodePoint = CodePoint::from(1047u32);
    pub const CYRILLIC_CAPITAL_LETTER_I : CodePoint = CodePoint::from(1048u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHORT_I : CodePoint = CodePoint::from(1049u32);
    pub const CYRILLIC_CAPITAL_LETTER_KA : CodePoint = CodePoint::from(1050u32);
    pub const CYRILLIC_CAPITAL_LETTER_EL : CodePoint = CodePoint::from(1051u32);
    pub const CYRILLIC_CAPITAL_LETTER_EM : CodePoint = CodePoint::from(1052u32);
    pub const CYRILLIC_CAPITAL_LETTER_EN : CodePoint = CodePoint::from(1053u32);
    pub const CYRILLIC_CAPITAL_LETTER_O : CodePoint = CodePoint::from(1054u32);
    pub const CYRILLIC_CAPITAL_LETTER_PE : CodePoint = CodePoint::from(1055u32);
    pub const CYRILLIC_CAPITAL_LETTER_ER : CodePoint = CodePoint::from(1056u32);
    pub const CYRILLIC_CAPITAL_LETTER_ES : CodePoint = CodePoint::from(1057u32);
    pub const CYRILLIC_CAPITAL_LETTER_TE : CodePoint = CodePoint::from(1058u32);
    pub const CYRILLIC_CAPITAL_LETTER_U : CodePoint = CodePoint::from(1059u32);
    pub const CYRILLIC_CAPITAL_LETTER_EF : CodePoint = CodePoint::from(1060u32);
    pub const CYRILLIC_CAPITAL_LETTER_HA : CodePoint = CodePoint::from(1061u32);
    pub const CYRILLIC_CAPITAL_LETTER_TSE : CodePoint = CodePoint::from(1062u32);
    pub const CYRILLIC_CAPITAL_LETTER_CHE : CodePoint = CodePoint::from(1063u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHA : CodePoint = CodePoint::from(1064u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHCHA : CodePoint = CodePoint::from(1065u32);
    pub const CYRILLIC_CAPITAL_LETTER_HARD_SIGN : CodePoint = CodePoint::from(1066u32);
    pub const CYRILLIC_CAPITAL_LETTER_YERU : CodePoint = CodePoint::from(1067u32);
    pub const CYRILLIC_CAPITAL_LETTER_SOFT_SIGN : CodePoint = CodePoint::from(1068u32);
    pub const CYRILLIC_CAPITAL_LETTER_E : CodePoint = CodePoint::from(1069u32);
    pub const CYRILLIC_CAPITAL_LETTER_YU : CodePoint = CodePoint::from(1070u32);
    pub const CYRILLIC_CAPITAL_LETTER_YA : CodePoint = CodePoint::from(1071u32);
    pub const CYRILLIC_SMALL_LETTER_A : CodePoint = CodePoint::from(1072u32);
    pub const CYRILLIC_SMALL_LETTER_BE : CodePoint = CodePoint::from(1073u32);
    pub const CYRILLIC_SMALL_LETTER_VE : CodePoint = CodePoint::from(1074u32);
    pub const CYRILLIC_SMALL_LETTER_GHE : CodePoint = CodePoint::from(1075u32);
    pub const CYRILLIC_SMALL_LETTER_DE : CodePoint = CodePoint::from(1076u32);
    pub const CYRILLIC_SMALL_LETTER_IE : CodePoint = CodePoint::from(1077u32);
    pub const CYRILLIC_SMALL_LETTER_ZHE : CodePoint = CodePoint::from(1078u32);
    pub const CYRILLIC_SMALL_LETTER_ZE : CodePoint = CodePoint::from(1079u32);
    pub const CYRILLIC_SMALL_LETTER_I : CodePoint = CodePoint::from(1080u32);
    pub const CYRILLIC_SMALL_LETTER_SHORT_I : CodePoint = CodePoint::from(1081u32);
    pub const CYRILLIC_SMALL_LETTER_KA : CodePoint = CodePoint::from(1082u32);
    pub const CYRILLIC_SMALL_LETTER_EL : CodePoint = CodePoint::from(1083u32);
    pub const CYRILLIC_SMALL_LETTER_EM : CodePoint = CodePoint::from(1084u32);
    pub const CYRILLIC_SMALL_LETTER_EN : CodePoint = CodePoint::from(1085u32);
    pub const CYRILLIC_SMALL_LETTER_O : CodePoint = CodePoint::from(1086u32);
    pub const CYRILLIC_SMALL_LETTER_PE : CodePoint = CodePoint::from(1087u32);
    pub const CYRILLIC_SMALL_LETTER_ER : CodePoint = CodePoint::from(1088u32);
    pub const CYRILLIC_SMALL_LETTER_ES : CodePoint = CodePoint::from(1089u32);
    pub const CYRILLIC_SMALL_LETTER_TE : CodePoint = CodePoint::from(1090u32);
    pub const CYRILLIC_SMALL_LETTER_U : CodePoint = CodePoint::from(1091u32);
    pub const CYRILLIC_SMALL_LETTER_EF : CodePoint = CodePoint::from(1092u32);
    pub const CYRILLIC_SMALL_LETTER_HA : CodePoint = CodePoint::from(1093u32);
    pub const CYRILLIC_SMALL_LETTER_TSE : CodePoint = CodePoint::from(1094u32);
    pub const CYRILLIC_SMALL_LETTER_CHE : CodePoint = CodePoint::from(1095u32);
    pub const CYRILLIC_SMALL_LETTER_SHA : CodePoint = CodePoint::from(1096u32);
    pub const CYRILLIC_SMALL_LETTER_SHCHA : CodePoint = CodePoint::from(1097u32);
    pub const CYRILLIC_SMALL_LETTER_HARD_SIGN : CodePoint = CodePoint::from(1098u32);
    pub const CYRILLIC_SMALL_LETTER_YERU : CodePoint = CodePoint::from(1099u32);
    pub const CYRILLIC_SMALL_LETTER_SOFT_SIGN : CodePoint = CodePoint::from(1100u32);
    pub const CYRILLIC_SMALL_LETTER_E : CodePoint = CodePoint::from(1101u32);
    pub const CYRILLIC_SMALL_LETTER_YU : CodePoint = CodePoint::from(1102u32);
    pub const CYRILLIC_SMALL_LETTER_YA : CodePoint = CodePoint::from(1103u32);
    pub const CYRILLIC_SMALL_LETTER_IE_WITH_GRAVE : CodePoint = CodePoint::from(1104u32);
    pub const CYRILLIC_SMALL_LETTER_IO : CodePoint = CodePoint::from(1105u32);
    pub const CYRILLIC_SMALL_LETTER_DJE : CodePoint = CodePoint::from(1106u32);
    pub const CYRILLIC_SMALL_LETTER_GJE : CodePoint = CodePoint::from(1107u32);
    pub const CYRILLIC_SMALL_LETTER_UKRAINIAN_IE : CodePoint = CodePoint::from(1108u32);
    pub const CYRILLIC_SMALL_LETTER_DZE : CodePoint = CodePoint::from(1109u32);
    pub const CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I : CodePoint = CodePoint::from(1110u32);
    pub const CYRILLIC_SMALL_LETTER_YI : CodePoint = CodePoint::from(1111u32);
    pub const CYRILLIC_SMALL_LETTER_JE : CodePoint = CodePoint::from(1112u32);
    pub const CYRILLIC_SMALL_LETTER_LJE : CodePoint = CodePoint::from(1113u32);
    pub const CYRILLIC_SMALL_LETTER_NJE : CodePoint = CodePoint::from(1114u32);
    pub const CYRILLIC_SMALL_LETTER_TSHE : CodePoint = CodePoint::from(1115u32);
    pub const CYRILLIC_SMALL_LETTER_KJE : CodePoint = CodePoint::from(1116u32);
    pub const CYRILLIC_SMALL_LETTER_I_WITH_GRAVE : CodePoint = CodePoint::from(1117u32);
    pub const CYRILLIC_SMALL_LETTER_SHORT_U : CodePoint = CodePoint::from(1118u32);
    pub const CYRILLIC_SMALL_LETTER_DZHE : CodePoint = CodePoint::from(1119u32);
    pub const CYRILLIC_CAPITAL_LETTER_OMEGA : CodePoint = CodePoint::from(1120u32);
    pub const CYRILLIC_SMALL_LETTER_OMEGA : CodePoint = CodePoint::from(1121u32);
    pub const CYRILLIC_CAPITAL_LETTER_YAT : CodePoint = CodePoint::from(1122u32);
    pub const CYRILLIC_SMALL_LETTER_YAT : CodePoint = CodePoint::from(1123u32);
    pub const CYRILLIC_CAPITAL_LETTER_IOTIFIED_E : CodePoint = CodePoint::from(1124u32);
    pub const CYRILLIC_SMALL_LETTER_IOTIFIED_E : CodePoint = CodePoint::from(1125u32);
    pub const CYRILLIC_CAPITAL_LETTER_LITTLE_YUS : CodePoint = CodePoint::from(1126u32);
    pub const CYRILLIC_SMALL_LETTER_LITTLE_YUS : CodePoint = CodePoint::from(1127u32);
    pub const CYRILLIC_CAPITAL_LETTER_IOTIFIED_LITTLE_YUS : CodePoint = CodePoint::from(1128u32);
    pub const CYRILLIC_SMALL_LETTER_IOTIFIED_LITTLE_YUS : CodePoint = CodePoint::from(1129u32);
    pub const CYRILLIC_CAPITAL_LETTER_BIG_YUS : CodePoint = CodePoint::from(1130u32);
    pub const CYRILLIC_SMALL_LETTER_BIG_YUS : CodePoint = CodePoint::from(1131u32);
    pub const CYRILLIC_CAPITAL_LETTER_IOTIFIED_BIG_YUS : CodePoint = CodePoint::from(1132u32);
    pub const CYRILLIC_SMALL_LETTER_IOTIFIED_BIG_YUS : CodePoint = CodePoint::from(1133u32);
    pub const CYRILLIC_CAPITAL_LETTER_KSI : CodePoint = CodePoint::from(1134u32);
    pub const CYRILLIC_SMALL_LETTER_KSI : CodePoint = CodePoint::from(1135u32);
    pub const CYRILLIC_CAPITAL_LETTER_PSI : CodePoint = CodePoint::from(1136u32);
    pub const CYRILLIC_SMALL_LETTER_PSI : CodePoint = CodePoint::from(1137u32);
    pub const CYRILLIC_CAPITAL_LETTER_FITA : CodePoint = CodePoint::from(1138u32);
    pub const CYRILLIC_SMALL_LETTER_FITA : CodePoint = CodePoint::from(1139u32);
    pub const CYRILLIC_CAPITAL_LETTER_IZHITSA : CodePoint = CodePoint::from(1140u32);
    pub const CYRILLIC_SMALL_LETTER_IZHITSA : CodePoint = CodePoint::from(1141u32);
    pub const CYRILLIC_CAPITAL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT : CodePoint = CodePoint::from(1142u32);
    pub const CYRILLIC_SMALL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT : CodePoint = CodePoint::from(1143u32);
    pub const CYRILLIC_CAPITAL_LETTER_UK : CodePoint = CodePoint::from(1144u32);
    pub const CYRILLIC_SMALL_LETTER_UK : CodePoint = CodePoint::from(1145u32);
    pub const CYRILLIC_CAPITAL_LETTER_ROUND_OMEGA : CodePoint = CodePoint::from(1146u32);
    pub const CYRILLIC_SMALL_LETTER_ROUND_OMEGA : CodePoint = CodePoint::from(1147u32);
    pub const CYRILLIC_CAPITAL_LETTER_OMEGA_WITH_TITLO : CodePoint = CodePoint::from(1148u32);
    pub const CYRILLIC_SMALL_LETTER_OMEGA_WITH_TITLO : CodePoint = CodePoint::from(1149u32);
    pub const CYRILLIC_CAPITAL_LETTER_OT : CodePoint = CodePoint::from(1150u32);
    pub const CYRILLIC_SMALL_LETTER_OT : CodePoint = CodePoint::from(1151u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOPPA : CodePoint = CodePoint::from(1152u32);
    pub const CYRILLIC_SMALL_LETTER_KOPPA : CodePoint = CodePoint::from(1153u32);
    pub const CYRILLIC_THOUSANDS_SIGN : CodePoint = CodePoint::from(1154u32);
    pub const COMBINING_CYRILLIC_TITLO : CodePoint = CodePoint::from(1155u32);
    pub const COMBINING_CYRILLIC_PALATALIZATION : CodePoint = CodePoint::from(1156u32);
    pub const COMBINING_CYRILLIC_DASIA_PNEUMATA : CodePoint = CodePoint::from(1157u32);
    pub const COMBINING_CYRILLIC_PSILI_PNEUMATA : CodePoint = CodePoint::from(1158u32);
    pub const COMBINING_CYRILLIC_POKRYTIE : CodePoint = CodePoint::from(1159u32);
    pub const COMBINING_CYRILLIC_HUNDRED_THOUSANDS_SIGN : CodePoint = CodePoint::from(1160u32);
    pub const COMBINING_CYRILLIC_MILLIONS_SIGN : CodePoint = CodePoint::from(1161u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHORT_I_WITH_TAIL : CodePoint = CodePoint::from(1162u32);
    pub const CYRILLIC_SMALL_LETTER_SHORT_I_WITH_TAIL : CodePoint = CodePoint::from(1163u32);
    pub const CYRILLIC_CAPITAL_LETTER_SEMISOFT_SIGN : CodePoint = CodePoint::from(1164u32);
    pub const CYRILLIC_SMALL_LETTER_SEMISOFT_SIGN : CodePoint = CodePoint::from(1165u32);
    pub const CYRILLIC_CAPITAL_LETTER_ER_WITH_TICK : CodePoint = CodePoint::from(1166u32);
    pub const CYRILLIC_SMALL_LETTER_ER_WITH_TICK : CodePoint = CodePoint::from(1167u32);
    pub const CYRILLIC_CAPITAL_LETTER_GHE_WITH_UPTURN : CodePoint = CodePoint::from(1168u32);
    pub const CYRILLIC_SMALL_LETTER_GHE_WITH_UPTURN : CodePoint = CodePoint::from(1169u32);
    pub const CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE : CodePoint = CodePoint::from(1170u32);
    pub const CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE : CodePoint = CodePoint::from(1171u32);
    pub const CYRILLIC_CAPITAL_LETTER_GHE_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1172u32);
    pub const CYRILLIC_SMALL_LETTER_GHE_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1173u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DESCENDER : CodePoint = CodePoint::from(1174u32);
    pub const CYRILLIC_SMALL_LETTER_ZHE_WITH_DESCENDER : CodePoint = CodePoint::from(1175u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZE_WITH_DESCENDER : CodePoint = CodePoint::from(1176u32);
    pub const CYRILLIC_SMALL_LETTER_ZE_WITH_DESCENDER : CodePoint = CodePoint::from(1177u32);
    pub const CYRILLIC_CAPITAL_LETTER_KA_WITH_DESCENDER : CodePoint = CodePoint::from(1178u32);
    pub const CYRILLIC_SMALL_LETTER_KA_WITH_DESCENDER : CodePoint = CodePoint::from(1179u32);
    pub const CYRILLIC_CAPITAL_LETTER_KA_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(1180u32);
    pub const CYRILLIC_SMALL_LETTER_KA_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(1181u32);
    pub const CYRILLIC_CAPITAL_LETTER_KA_WITH_STROKE : CodePoint = CodePoint::from(1182u32);
    pub const CYRILLIC_SMALL_LETTER_KA_WITH_STROKE : CodePoint = CodePoint::from(1183u32);
    pub const CYRILLIC_CAPITAL_LETTER_BASHKIR_KA : CodePoint = CodePoint::from(1184u32);
    pub const CYRILLIC_SMALL_LETTER_BASHKIR_KA : CodePoint = CodePoint::from(1185u32);
    pub const CYRILLIC_CAPITAL_LETTER_EN_WITH_DESCENDER : CodePoint = CodePoint::from(1186u32);
    pub const CYRILLIC_SMALL_LETTER_EN_WITH_DESCENDER : CodePoint = CodePoint::from(1187u32);
    pub const CYRILLIC_CAPITAL_LIGATURE_EN_GHE : CodePoint = CodePoint::from(1188u32);
    pub const CYRILLIC_SMALL_LIGATURE_EN_GHE : CodePoint = CodePoint::from(1189u32);
    pub const CYRILLIC_CAPITAL_LETTER_PE_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1190u32);
    pub const CYRILLIC_SMALL_LETTER_PE_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1191u32);
    pub const CYRILLIC_CAPITAL_LETTER_ABKHASIAN_HA : CodePoint = CodePoint::from(1192u32);
    pub const CYRILLIC_SMALL_LETTER_ABKHASIAN_HA : CodePoint = CodePoint::from(1193u32);
    pub const CYRILLIC_CAPITAL_LETTER_ES_WITH_DESCENDER : CodePoint = CodePoint::from(1194u32);
    pub const CYRILLIC_SMALL_LETTER_ES_WITH_DESCENDER : CodePoint = CodePoint::from(1195u32);
    pub const CYRILLIC_CAPITAL_LETTER_TE_WITH_DESCENDER : CodePoint = CodePoint::from(1196u32);
    pub const CYRILLIC_SMALL_LETTER_TE_WITH_DESCENDER : CodePoint = CodePoint::from(1197u32);
    pub const CYRILLIC_CAPITAL_LETTER_STRAIGHT_U : CodePoint = CodePoint::from(1198u32);
    pub const CYRILLIC_SMALL_LETTER_STRAIGHT_U : CodePoint = CodePoint::from(1199u32);
    pub const CYRILLIC_CAPITAL_LETTER_STRAIGHT_U_WITH_STROKE : CodePoint = CodePoint::from(1200u32);
    pub const CYRILLIC_SMALL_LETTER_STRAIGHT_U_WITH_STROKE : CodePoint = CodePoint::from(1201u32);
    pub const CYRILLIC_CAPITAL_LETTER_HA_WITH_DESCENDER : CodePoint = CodePoint::from(1202u32);
    pub const CYRILLIC_SMALL_LETTER_HA_WITH_DESCENDER : CodePoint = CodePoint::from(1203u32);
    pub const CYRILLIC_CAPITAL_LIGATURE_TE_TSE : CodePoint = CodePoint::from(1204u32);
    pub const CYRILLIC_SMALL_LIGATURE_TE_TSE : CodePoint = CodePoint::from(1205u32);
    pub const CYRILLIC_CAPITAL_LETTER_CHE_WITH_DESCENDER : CodePoint = CodePoint::from(1206u32);
    pub const CYRILLIC_SMALL_LETTER_CHE_WITH_DESCENDER : CodePoint = CodePoint::from(1207u32);
    pub const CYRILLIC_CAPITAL_LETTER_CHE_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(1208u32);
    pub const CYRILLIC_SMALL_LETTER_CHE_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(1209u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHHA : CodePoint = CodePoint::from(1210u32);
    pub const CYRILLIC_SMALL_LETTER_SHHA : CodePoint = CodePoint::from(1211u32);
    pub const CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE : CodePoint = CodePoint::from(1212u32);
    pub const CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE : CodePoint = CodePoint::from(1213u32);
    pub const CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER : CodePoint = CodePoint::from(1214u32);
    pub const CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER : CodePoint = CodePoint::from(1215u32);
    pub const CYRILLIC_LETTER_PALOCHKA : CodePoint = CodePoint::from(1216u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZHE_WITH_BREVE : CodePoint = CodePoint::from(1217u32);
    pub const CYRILLIC_SMALL_LETTER_ZHE_WITH_BREVE : CodePoint = CodePoint::from(1218u32);
    pub const CYRILLIC_CAPITAL_LETTER_KA_WITH_HOOK : CodePoint = CodePoint::from(1219u32);
    pub const CYRILLIC_SMALL_LETTER_KA_WITH_HOOK : CodePoint = CodePoint::from(1220u32);
    pub const CYRILLIC_CAPITAL_LETTER_EL_WITH_TAIL : CodePoint = CodePoint::from(1221u32);
    pub const CYRILLIC_SMALL_LETTER_EL_WITH_TAIL : CodePoint = CodePoint::from(1222u32);
    pub const CYRILLIC_CAPITAL_LETTER_EN_WITH_HOOK : CodePoint = CodePoint::from(1223u32);
    pub const CYRILLIC_SMALL_LETTER_EN_WITH_HOOK : CodePoint = CodePoint::from(1224u32);
    pub const CYRILLIC_CAPITAL_LETTER_EN_WITH_TAIL : CodePoint = CodePoint::from(1225u32);
    pub const CYRILLIC_SMALL_LETTER_EN_WITH_TAIL : CodePoint = CodePoint::from(1226u32);
    pub const CYRILLIC_CAPITAL_LETTER_KHAKASSIAN_CHE : CodePoint = CodePoint::from(1227u32);
    pub const CYRILLIC_SMALL_LETTER_KHAKASSIAN_CHE : CodePoint = CodePoint::from(1228u32);
    pub const CYRILLIC_CAPITAL_LETTER_EM_WITH_TAIL : CodePoint = CodePoint::from(1229u32);
    pub const CYRILLIC_SMALL_LETTER_EM_WITH_TAIL : CodePoint = CodePoint::from(1230u32);
    pub const CYRILLIC_SMALL_LETTER_PALOCHKA : CodePoint = CodePoint::from(1231u32);
    pub const CYRILLIC_CAPITAL_LETTER_A_WITH_BREVE : CodePoint = CodePoint::from(1232u32);
    pub const CYRILLIC_SMALL_LETTER_A_WITH_BREVE : CodePoint = CodePoint::from(1233u32);
    pub const CYRILLIC_CAPITAL_LETTER_A_WITH_DIAERESIS : CodePoint = CodePoint::from(1234u32);
    pub const CYRILLIC_SMALL_LETTER_A_WITH_DIAERESIS : CodePoint = CodePoint::from(1235u32);
    pub const CYRILLIC_CAPITAL_LIGATURE_A_IE : CodePoint = CodePoint::from(1236u32);
    pub const CYRILLIC_SMALL_LIGATURE_A_IE : CodePoint = CodePoint::from(1237u32);
    pub const CYRILLIC_CAPITAL_LETTER_IE_WITH_BREVE : CodePoint = CodePoint::from(1238u32);
    pub const CYRILLIC_SMALL_LETTER_IE_WITH_BREVE : CodePoint = CodePoint::from(1239u32);
    pub const CYRILLIC_CAPITAL_LETTER_SCHWA : CodePoint = CodePoint::from(1240u32);
    pub const CYRILLIC_SMALL_LETTER_SCHWA : CodePoint = CodePoint::from(1241u32);
    pub const CYRILLIC_CAPITAL_LETTER_SCHWA_WITH_DIAERESIS : CodePoint = CodePoint::from(1242u32);
    pub const CYRILLIC_SMALL_LETTER_SCHWA_WITH_DIAERESIS : CodePoint = CodePoint::from(1243u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DIAERESIS : CodePoint = CodePoint::from(1244u32);
    pub const CYRILLIC_SMALL_LETTER_ZHE_WITH_DIAERESIS : CodePoint = CodePoint::from(1245u32);
    pub const CYRILLIC_CAPITAL_LETTER_ZE_WITH_DIAERESIS : CodePoint = CodePoint::from(1246u32);
    pub const CYRILLIC_SMALL_LETTER_ZE_WITH_DIAERESIS : CodePoint = CodePoint::from(1247u32);
    pub const CYRILLIC_CAPITAL_LETTER_ABKHASIAN_DZE : CodePoint = CodePoint::from(1248u32);
    pub const CYRILLIC_SMALL_LETTER_ABKHASIAN_DZE : CodePoint = CodePoint::from(1249u32);
    pub const CYRILLIC_CAPITAL_LETTER_I_WITH_MACRON : CodePoint = CodePoint::from(1250u32);
    pub const CYRILLIC_SMALL_LETTER_I_WITH_MACRON : CodePoint = CodePoint::from(1251u32);
    pub const CYRILLIC_CAPITAL_LETTER_I_WITH_DIAERESIS : CodePoint = CodePoint::from(1252u32);
    pub const CYRILLIC_SMALL_LETTER_I_WITH_DIAERESIS : CodePoint = CodePoint::from(1253u32);
    pub const CYRILLIC_CAPITAL_LETTER_O_WITH_DIAERESIS : CodePoint = CodePoint::from(1254u32);
    pub const CYRILLIC_SMALL_LETTER_O_WITH_DIAERESIS : CodePoint = CodePoint::from(1255u32);
    pub const CYRILLIC_CAPITAL_LETTER_BARRED_O : CodePoint = CodePoint::from(1256u32);
    pub const CYRILLIC_SMALL_LETTER_BARRED_O : CodePoint = CodePoint::from(1257u32);
    pub const CYRILLIC_CAPITAL_LETTER_BARRED_O_WITH_DIAERESIS : CodePoint = CodePoint::from(1258u32);
    pub const CYRILLIC_SMALL_LETTER_BARRED_O_WITH_DIAERESIS : CodePoint = CodePoint::from(1259u32);
    pub const CYRILLIC_CAPITAL_LETTER_E_WITH_DIAERESIS : CodePoint = CodePoint::from(1260u32);
    pub const CYRILLIC_SMALL_LETTER_E_WITH_DIAERESIS : CodePoint = CodePoint::from(1261u32);
    pub const CYRILLIC_CAPITAL_LETTER_U_WITH_MACRON : CodePoint = CodePoint::from(1262u32);
    pub const CYRILLIC_SMALL_LETTER_U_WITH_MACRON : CodePoint = CodePoint::from(1263u32);
    pub const CYRILLIC_CAPITAL_LETTER_U_WITH_DIAERESIS : CodePoint = CodePoint::from(1264u32);
    pub const CYRILLIC_SMALL_LETTER_U_WITH_DIAERESIS : CodePoint = CodePoint::from(1265u32);
    pub const CYRILLIC_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE : CodePoint = CodePoint::from(1266u32);
    pub const CYRILLIC_SMALL_LETTER_U_WITH_DOUBLE_ACUTE : CodePoint = CodePoint::from(1267u32);
    pub const CYRILLIC_CAPITAL_LETTER_CHE_WITH_DIAERESIS : CodePoint = CodePoint::from(1268u32);
    pub const CYRILLIC_SMALL_LETTER_CHE_WITH_DIAERESIS : CodePoint = CodePoint::from(1269u32);
    pub const CYRILLIC_CAPITAL_LETTER_GHE_WITH_DESCENDER : CodePoint = CodePoint::from(1270u32);
    pub const CYRILLIC_SMALL_LETTER_GHE_WITH_DESCENDER : CodePoint = CodePoint::from(1271u32);
    pub const CYRILLIC_CAPITAL_LETTER_YERU_WITH_DIAERESIS : CodePoint = CodePoint::from(1272u32);
    pub const CYRILLIC_SMALL_LETTER_YERU_WITH_DIAERESIS : CodePoint = CodePoint::from(1273u32);
    pub const CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE_AND_HOOK : CodePoint = CodePoint::from(1274u32);
    pub const CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE_AND_HOOK : CodePoint = CodePoint::from(1275u32);
    pub const CYRILLIC_CAPITAL_LETTER_HA_WITH_HOOK : CodePoint = CodePoint::from(1276u32);
    pub const CYRILLIC_SMALL_LETTER_HA_WITH_HOOK : CodePoint = CodePoint::from(1277u32);
    pub const CYRILLIC_CAPITAL_LETTER_HA_WITH_STROKE : CodePoint = CodePoint::from(1278u32);
    pub const CYRILLIC_SMALL_LETTER_HA_WITH_STROKE : CodePoint = CodePoint::from(1279u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_DE : CodePoint = CodePoint::from(1280u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_DE : CodePoint = CodePoint::from(1281u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_DJE : CodePoint = CodePoint::from(1282u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_DJE : CodePoint = CodePoint::from(1283u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_ZJE : CodePoint = CodePoint::from(1284u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_ZJE : CodePoint = CodePoint::from(1285u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_DZJE : CodePoint = CodePoint::from(1286u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_DZJE : CodePoint = CodePoint::from(1287u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_LJE : CodePoint = CodePoint::from(1288u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_LJE : CodePoint = CodePoint::from(1289u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_NJE : CodePoint = CodePoint::from(1290u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_NJE : CodePoint = CodePoint::from(1291u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_SJE : CodePoint = CodePoint::from(1292u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_SJE : CodePoint = CodePoint::from(1293u32);
    pub const CYRILLIC_CAPITAL_LETTER_KOMI_TJE : CodePoint = CodePoint::from(1294u32);
    pub const CYRILLIC_SMALL_LETTER_KOMI_TJE : CodePoint = CodePoint::from(1295u32);
    pub const CYRILLIC_CAPITAL_LETTER_REVERSED_ZE : CodePoint = CodePoint::from(1296u32);
    pub const CYRILLIC_SMALL_LETTER_REVERSED_ZE : CodePoint = CodePoint::from(1297u32);
    pub const CYRILLIC_CAPITAL_LETTER_EL_WITH_HOOK : CodePoint = CodePoint::from(1298u32);
    pub const CYRILLIC_SMALL_LETTER_EL_WITH_HOOK : CodePoint = CodePoint::from(1299u32);
    pub const CYRILLIC_CAPITAL_LETTER_LHA : CodePoint = CodePoint::from(1300u32);
    pub const CYRILLIC_SMALL_LETTER_LHA : CodePoint = CodePoint::from(1301u32);
    pub const CYRILLIC_CAPITAL_LETTER_RHA : CodePoint = CodePoint::from(1302u32);
    pub const CYRILLIC_SMALL_LETTER_RHA : CodePoint = CodePoint::from(1303u32);
    pub const CYRILLIC_CAPITAL_LETTER_YAE : CodePoint = CodePoint::from(1304u32);
    pub const CYRILLIC_SMALL_LETTER_YAE : CodePoint = CodePoint::from(1305u32);
    pub const CYRILLIC_CAPITAL_LETTER_QA : CodePoint = CodePoint::from(1306u32);
    pub const CYRILLIC_SMALL_LETTER_QA : CodePoint = CodePoint::from(1307u32);
    pub const CYRILLIC_CAPITAL_LETTER_WE : CodePoint = CodePoint::from(1308u32);
    pub const CYRILLIC_SMALL_LETTER_WE : CodePoint = CodePoint::from(1309u32);
    pub const CYRILLIC_CAPITAL_LETTER_ALEUT_KA : CodePoint = CodePoint::from(1310u32);
    pub const CYRILLIC_SMALL_LETTER_ALEUT_KA : CodePoint = CodePoint::from(1311u32);
    pub const CYRILLIC_CAPITAL_LETTER_EL_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1312u32);
    pub const CYRILLIC_SMALL_LETTER_EL_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1313u32);
    pub const CYRILLIC_CAPITAL_LETTER_EN_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1314u32);
    pub const CYRILLIC_SMALL_LETTER_EN_WITH_MIDDLE_HOOK : CodePoint = CodePoint::from(1315u32);
    pub const CYRILLIC_CAPITAL_LETTER_PE_WITH_DESCENDER : CodePoint = CodePoint::from(1316u32);
    pub const CYRILLIC_SMALL_LETTER_PE_WITH_DESCENDER : CodePoint = CodePoint::from(1317u32);
    pub const CYRILLIC_CAPITAL_LETTER_SHHA_WITH_DESCENDER : CodePoint = CodePoint::from(1318u32);
    pub const CYRILLIC_SMALL_LETTER_SHHA_WITH_DESCENDER : CodePoint = CodePoint::from(1319u32);
    pub const CYRILLIC_CAPITAL_LETTER_EN_WITH_LEFT_HOOK : CodePoint = CodePoint::from(1320u32);
    pub const CYRILLIC_SMALL_LETTER_EN_WITH_LEFT_HOOK : CodePoint = CodePoint::from(1321u32);
    pub const CYRILLIC_CAPITAL_LETTER_DZZHE : CodePoint = CodePoint::from(1322u32);
    pub const CYRILLIC_SMALL_LETTER_DZZHE : CodePoint = CodePoint::from(1323u32);
    pub const CYRILLIC_CAPITAL_LETTER_DCHE : CodePoint = CodePoint::from(1324u32);
    pub const CYRILLIC_SMALL_LETTER_DCHE : CodePoint = CodePoint::from(1325u32);
    pub const CYRILLIC_CAPITAL_LETTER_EL_WITH_DESCENDER : CodePoint = CodePoint::from(1326u32);
    pub const CYRILLIC_SMALL_LETTER_EL_WITH_DESCENDER : CodePoint = CodePoint::from(1327u32);
    pub const ARMENIAN_CAPITAL_LETTER_AYB : CodePoint = CodePoint::from(1329u32);
    pub const ARMENIAN_CAPITAL_LETTER_BEN : CodePoint = CodePoint::from(1330u32);
    pub const ARMENIAN_CAPITAL_LETTER_GIM : CodePoint = CodePoint::from(1331u32);
    pub const ARMENIAN_CAPITAL_LETTER_DA : CodePoint = CodePoint::from(1332u32);
    pub const ARMENIAN_CAPITAL_LETTER_ECH : CodePoint = CodePoint::from(1333u32);
    pub const ARMENIAN_CAPITAL_LETTER_ZA : CodePoint = CodePoint::from(1334u32);
    pub const ARMENIAN_CAPITAL_LETTER_EH : CodePoint = CodePoint::from(1335u32);
    pub const ARMENIAN_CAPITAL_LETTER_ET : CodePoint = CodePoint::from(1336u32);
    pub const ARMENIAN_CAPITAL_LETTER_TO : CodePoint = CodePoint::from(1337u32);
    pub const ARMENIAN_CAPITAL_LETTER_ZHE : CodePoint = CodePoint::from(1338u32);
    pub const ARMENIAN_CAPITAL_LETTER_INI : CodePoint = CodePoint::from(1339u32);
    pub const ARMENIAN_CAPITAL_LETTER_LIWN : CodePoint = CodePoint::from(1340u32);
    pub const ARMENIAN_CAPITAL_LETTER_XEH : CodePoint = CodePoint::from(1341u32);
    pub const ARMENIAN_CAPITAL_LETTER_CA : CodePoint = CodePoint::from(1342u32);
    pub const ARMENIAN_CAPITAL_LETTER_KEN : CodePoint = CodePoint::from(1343u32);
    pub const ARMENIAN_CAPITAL_LETTER_HO : CodePoint = CodePoint::from(1344u32);
    pub const ARMENIAN_CAPITAL_LETTER_JA : CodePoint = CodePoint::from(1345u32);
    pub const ARMENIAN_CAPITAL_LETTER_GHAD : CodePoint = CodePoint::from(1346u32);
    pub const ARMENIAN_CAPITAL_LETTER_CHEH : CodePoint = CodePoint::from(1347u32);
    pub const ARMENIAN_CAPITAL_LETTER_MEN : CodePoint = CodePoint::from(1348u32);
    pub const ARMENIAN_CAPITAL_LETTER_YI : CodePoint = CodePoint::from(1349u32);
    pub const ARMENIAN_CAPITAL_LETTER_NOW : CodePoint = CodePoint::from(1350u32);
    pub const ARMENIAN_CAPITAL_LETTER_SHA : CodePoint = CodePoint::from(1351u32);
    pub const ARMENIAN_CAPITAL_LETTER_VO : CodePoint = CodePoint::from(1352u32);
    pub const ARMENIAN_CAPITAL_LETTER_CHA : CodePoint = CodePoint::from(1353u32);
    pub const ARMENIAN_CAPITAL_LETTER_PEH : CodePoint = CodePoint::from(1354u32);
    pub const ARMENIAN_CAPITAL_LETTER_JHEH : CodePoint = CodePoint::from(1355u32);
    pub const ARMENIAN_CAPITAL_LETTER_RA : CodePoint = CodePoint::from(1356u32);
    pub const ARMENIAN_CAPITAL_LETTER_SEH : CodePoint = CodePoint::from(1357u32);
    pub const ARMENIAN_CAPITAL_LETTER_VEW : CodePoint = CodePoint::from(1358u32);
    pub const ARMENIAN_CAPITAL_LETTER_TIWN : CodePoint = CodePoint::from(1359u32);
    pub const ARMENIAN_CAPITAL_LETTER_REH : CodePoint = CodePoint::from(1360u32);
    pub const ARMENIAN_CAPITAL_LETTER_CO : CodePoint = CodePoint::from(1361u32);
    pub const ARMENIAN_CAPITAL_LETTER_YIWN : CodePoint = CodePoint::from(1362u32);
    pub const ARMENIAN_CAPITAL_LETTER_PIWR : CodePoint = CodePoint::from(1363u32);
    pub const ARMENIAN_CAPITAL_LETTER_KEH : CodePoint = CodePoint::from(1364u32);
    pub const ARMENIAN_CAPITAL_LETTER_OH : CodePoint = CodePoint::from(1365u32);
    pub const ARMENIAN_CAPITAL_LETTER_FEH : CodePoint = CodePoint::from(1366u32);
    pub const ARMENIAN_MODIFIER_LETTER_LEFT_HALF_RING : CodePoint = CodePoint::from(1369u32);
    pub const ARMENIAN_APOSTROPHE : CodePoint = CodePoint::from(1370u32);
    pub const ARMENIAN_EMPHASIS_MARK : CodePoint = CodePoint::from(1371u32);
    pub const ARMENIAN_EXCLAMATION_MARK : CodePoint = CodePoint::from(1372u32);
    pub const ARMENIAN_COMMA : CodePoint = CodePoint::from(1373u32);
    pub const ARMENIAN_QUESTION_MARK : CodePoint = CodePoint::from(1374u32);
    pub const ARMENIAN_ABBREVIATION_MARK : CodePoint = CodePoint::from(1375u32);
    pub const ARMENIAN_SMALL_LETTER_TURNED_AYB : CodePoint = CodePoint::from(1376u32);
    pub const ARMENIAN_SMALL_LETTER_AYB : CodePoint = CodePoint::from(1377u32);
    pub const ARMENIAN_SMALL_LETTER_BEN : CodePoint = CodePoint::from(1378u32);
    pub const ARMENIAN_SMALL_LETTER_GIM : CodePoint = CodePoint::from(1379u32);
    pub const ARMENIAN_SMALL_LETTER_DA : CodePoint = CodePoint::from(1380u32);
    pub const ARMENIAN_SMALL_LETTER_ECH : CodePoint = CodePoint::from(1381u32);
    pub const ARMENIAN_SMALL_LETTER_ZA : CodePoint = CodePoint::from(1382u32);
    pub const ARMENIAN_SMALL_LETTER_EH : CodePoint = CodePoint::from(1383u32);
    pub const ARMENIAN_SMALL_LETTER_ET : CodePoint = CodePoint::from(1384u32);
    pub const ARMENIAN_SMALL_LETTER_TO : CodePoint = CodePoint::from(1385u32);
    pub const ARMENIAN_SMALL_LETTER_ZHE : CodePoint = CodePoint::from(1386u32);
    pub const ARMENIAN_SMALL_LETTER_INI : CodePoint = CodePoint::from(1387u32);
    pub const ARMENIAN_SMALL_LETTER_LIWN : CodePoint = CodePoint::from(1388u32);
    pub const ARMENIAN_SMALL_LETTER_XEH : CodePoint = CodePoint::from(1389u32);
    pub const ARMENIAN_SMALL_LETTER_CA : CodePoint = CodePoint::from(1390u32);
    pub const ARMENIAN_SMALL_LETTER_KEN : CodePoint = CodePoint::from(1391u32);
    pub const ARMENIAN_SMALL_LETTER_HO : CodePoint = CodePoint::from(1392u32);
    pub const ARMENIAN_SMALL_LETTER_JA : CodePoint = CodePoint::from(1393u32);
    pub const ARMENIAN_SMALL_LETTER_GHAD : CodePoint = CodePoint::from(1394u32);
    pub const ARMENIAN_SMALL_LETTER_CHEH : CodePoint = CodePoint::from(1395u32);
    pub const ARMENIAN_SMALL_LETTER_MEN : CodePoint = CodePoint::from(1396u32);
    pub const ARMENIAN_SMALL_LETTER_YI : CodePoint = CodePoint::from(1397u32);
    pub const ARMENIAN_SMALL_LETTER_NOW : CodePoint = CodePoint::from(1398u32);
    pub const ARMENIAN_SMALL_LETTER_SHA : CodePoint = CodePoint::from(1399u32);
    pub const ARMENIAN_SMALL_LETTER_VO : CodePoint = CodePoint::from(1400u32);
    pub const ARMENIAN_SMALL_LETTER_CHA : CodePoint = CodePoint::from(1401u32);
    pub const ARMENIAN_SMALL_LETTER_PEH : CodePoint = CodePoint::from(1402u32);
    pub const ARMENIAN_SMALL_LETTER_JHEH : CodePoint = CodePoint::from(1403u32);
    pub const ARMENIAN_SMALL_LETTER_RA : CodePoint = CodePoint::from(1404u32);
    pub const ARMENIAN_SMALL_LETTER_SEH : CodePoint = CodePoint::from(1405u32);
    pub const ARMENIAN_SMALL_LETTER_VEW : CodePoint = CodePoint::from(1406u32);
    pub const ARMENIAN_SMALL_LETTER_TIWN : CodePoint = CodePoint::from(1407u32);
    pub const ARMENIAN_SMALL_LETTER_REH : CodePoint = CodePoint::from(1408u32);
    pub const ARMENIAN_SMALL_LETTER_CO : CodePoint = CodePoint::from(1409u32);
    pub const ARMENIAN_SMALL_LETTER_YIWN : CodePoint = CodePoint::from(1410u32);
    pub const ARMENIAN_SMALL_LETTER_PIWR : CodePoint = CodePoint::from(1411u32);
    pub const ARMENIAN_SMALL_LETTER_KEH : CodePoint = CodePoint::from(1412u32);
    pub const ARMENIAN_SMALL_LETTER_OH : CodePoint = CodePoint::from(1413u32);
    pub const ARMENIAN_SMALL_LETTER_FEH : CodePoint = CodePoint::from(1414u32);
    pub const ARMENIAN_SMALL_LIGATURE_ECH_YIWN : CodePoint = CodePoint::from(1415u32);
    pub const ARMENIAN_SMALL_LETTER_YI_WITH_STROKE : CodePoint = CodePoint::from(1416u32);
    pub const ARMENIAN_FULL_STOP : CodePoint = CodePoint::from(1417u32);
    pub const ARMENIAN_HYPHEN : CodePoint = CodePoint::from(1418u32);
    pub const RIGHT_FACING_ARMENIAN_ETERNITY_SIGN : CodePoint = CodePoint::from(1421u32);
    pub const LEFT_FACING_ARMENIAN_ETERNITY_SIGN : CodePoint = CodePoint::from(1422u32);
    pub const ARMENIAN_DRAM_SIGN : CodePoint = CodePoint::from(1423u32);
    pub const HEBREW_ACCENT_ETNAHTA : CodePoint = CodePoint::from(1425u32);
    pub const HEBREW_ACCENT_SEGOL : CodePoint = CodePoint::from(1426u32);
    pub const HEBREW_ACCENT_SHALSHELET : CodePoint = CodePoint::from(1427u32);
    pub const HEBREW_ACCENT_ZAQEF_QATAN : CodePoint = CodePoint::from(1428u32);
    pub const HEBREW_ACCENT_ZAQEF_GADOL : CodePoint = CodePoint::from(1429u32);
    pub const HEBREW_ACCENT_TIPEHA : CodePoint = CodePoint::from(1430u32);
    pub const HEBREW_ACCENT_REVIA : CodePoint = CodePoint::from(1431u32);
    pub const HEBREW_ACCENT_ZARQA : CodePoint = CodePoint::from(1432u32);
    pub const HEBREW_ACCENT_PASHTA : CodePoint = CodePoint::from(1433u32);
    pub const HEBREW_ACCENT_YETIV : CodePoint = CodePoint::from(1434u32);
    pub const HEBREW_ACCENT_TEVIR : CodePoint = CodePoint::from(1435u32);
    pub const HEBREW_ACCENT_GERESH : CodePoint = CodePoint::from(1436u32);
    pub const HEBREW_ACCENT_GERESH_MUQDAM : CodePoint = CodePoint::from(1437u32);
    pub const HEBREW_ACCENT_GERSHAYIM : CodePoint = CodePoint::from(1438u32);
    pub const HEBREW_ACCENT_QARNEY_PARA : CodePoint = CodePoint::from(1439u32);
    pub const HEBREW_ACCENT_TELISHA_GEDOLA : CodePoint = CodePoint::from(1440u32);
    pub const HEBREW_ACCENT_PAZER : CodePoint = CodePoint::from(1441u32);
    pub const HEBREW_ACCENT_ATNAH_HAFUKH : CodePoint = CodePoint::from(1442u32);
    pub const HEBREW_ACCENT_MUNAH : CodePoint = CodePoint::from(1443u32);
    pub const HEBREW_ACCENT_MAHAPAKH : CodePoint = CodePoint::from(1444u32);
    pub const HEBREW_ACCENT_MERKHA : CodePoint = CodePoint::from(1445u32);
    pub const HEBREW_ACCENT_MERKHA_KEFULA : CodePoint = CodePoint::from(1446u32);
    pub const HEBREW_ACCENT_DARGA : CodePoint = CodePoint::from(1447u32);
    pub const HEBREW_ACCENT_QADMA : CodePoint = CodePoint::from(1448u32);
    pub const HEBREW_ACCENT_TELISHA_QETANA : CodePoint = CodePoint::from(1449u32);
    pub const HEBREW_ACCENT_YERAH_BEN_YOMO : CodePoint = CodePoint::from(1450u32);
    pub const HEBREW_ACCENT_OLE : CodePoint = CodePoint::from(1451u32);
    pub const HEBREW_ACCENT_ILUY : CodePoint = CodePoint::from(1452u32);
    pub const HEBREW_ACCENT_DEHI : CodePoint = CodePoint::from(1453u32);
    pub const HEBREW_ACCENT_ZINOR : CodePoint = CodePoint::from(1454u32);
    pub const HEBREW_MARK_MASORA_CIRCLE : CodePoint = CodePoint::from(1455u32);
    pub const HEBREW_POINT_SHEVA : CodePoint = CodePoint::from(1456u32);
    pub const HEBREW_POINT_HATAF_SEGOL : CodePoint = CodePoint::from(1457u32);
    pub const HEBREW_POINT_HATAF_PATAH : CodePoint = CodePoint::from(1458u32);
    pub const HEBREW_POINT_HATAF_QAMATS : CodePoint = CodePoint::from(1459u32);
    pub const HEBREW_POINT_HIRIQ : CodePoint = CodePoint::from(1460u32);
    pub const HEBREW_POINT_TSERE : CodePoint = CodePoint::from(1461u32);
    pub const HEBREW_POINT_SEGOL : CodePoint = CodePoint::from(1462u32);
    pub const HEBREW_POINT_PATAH : CodePoint = CodePoint::from(1463u32);
    pub const HEBREW_POINT_QAMATS : CodePoint = CodePoint::from(1464u32);
    pub const HEBREW_POINT_HOLAM : CodePoint = CodePoint::from(1465u32);
    pub const HEBREW_POINT_HOLAM_HASER_FOR_VAV : CodePoint = CodePoint::from(1466u32);
    pub const HEBREW_POINT_QUBUTS : CodePoint = CodePoint::from(1467u32);
    pub const HEBREW_POINT_DAGESH_OR_MAPIQ : CodePoint = CodePoint::from(1468u32);
    pub const HEBREW_POINT_METEG : CodePoint = CodePoint::from(1469u32);
    pub const HEBREW_PUNCTUATION_MAQAF : CodePoint = CodePoint::from(1470u32);
    pub const HEBREW_POINT_RAFE : CodePoint = CodePoint::from(1471u32);
    pub const HEBREW_PUNCTUATION_PASEQ : CodePoint = CodePoint::from(1472u32);
    pub const HEBREW_POINT_SHIN_DOT : CodePoint = CodePoint::from(1473u32);
    pub const HEBREW_POINT_SIN_DOT : CodePoint = CodePoint::from(1474u32);
    pub const HEBREW_PUNCTUATION_SOF_PASUQ : CodePoint = CodePoint::from(1475u32);
    pub const HEBREW_MARK_UPPER_DOT : CodePoint = CodePoint::from(1476u32);
    pub const HEBREW_MARK_LOWER_DOT : CodePoint = CodePoint::from(1477u32);
    pub const HEBREW_PUNCTUATION_NUN_HAFUKHA : CodePoint = CodePoint::from(1478u32);
    pub const HEBREW_POINT_QAMATS_QATAN : CodePoint = CodePoint::from(1479u32);
    pub const HEBREW_LETTER_ALEF : CodePoint = CodePoint::from(1488u32);
    pub const HEBREW_LETTER_BET : CodePoint = CodePoint::from(1489u32);
    pub const HEBREW_LETTER_GIMEL : CodePoint = CodePoint::from(1490u32);
    pub const HEBREW_LETTER_DALET : CodePoint = CodePoint::from(1491u32);
    pub const HEBREW_LETTER_HE : CodePoint = CodePoint::from(1492u32);
    pub const HEBREW_LETTER_VAV : CodePoint = CodePoint::from(1493u32);
    pub const HEBREW_LETTER_ZAYIN : CodePoint = CodePoint::from(1494u32);
    pub const HEBREW_LETTER_HET : CodePoint = CodePoint::from(1495u32);
    pub const HEBREW_LETTER_TET : CodePoint = CodePoint::from(1496u32);
    pub const HEBREW_LETTER_YOD : CodePoint = CodePoint::from(1497u32);
    pub const HEBREW_LETTER_FINAL_KAF : CodePoint = CodePoint::from(1498u32);
    pub const HEBREW_LETTER_KAF : CodePoint = CodePoint::from(1499u32);
    pub const HEBREW_LETTER_LAMED : CodePoint = CodePoint::from(1500u32);
    pub const HEBREW_LETTER_FINAL_MEM : CodePoint = CodePoint::from(1501u32);
    pub const HEBREW_LETTER_MEM : CodePoint = CodePoint::from(1502u32);
    pub const HEBREW_LETTER_FINAL_NUN : CodePoint = CodePoint::from(1503u32);
    pub const HEBREW_LETTER_NUN : CodePoint = CodePoint::from(1504u32);
    pub const HEBREW_LETTER_SAMEKH : CodePoint = CodePoint::from(1505u32);
    pub const HEBREW_LETTER_AYIN : CodePoint = CodePoint::from(1506u32);
    pub const HEBREW_LETTER_FINAL_PE : CodePoint = CodePoint::from(1507u32);
    pub const HEBREW_LETTER_PE : CodePoint = CodePoint::from(1508u32);
    pub const HEBREW_LETTER_FINAL_TSADI : CodePoint = CodePoint::from(1509u32);
    pub const HEBREW_LETTER_TSADI : CodePoint = CodePoint::from(1510u32);
    pub const HEBREW_LETTER_QOF : CodePoint = CodePoint::from(1511u32);
    pub const HEBREW_LETTER_RESH : CodePoint = CodePoint::from(1512u32);
    pub const HEBREW_LETTER_SHIN : CodePoint = CodePoint::from(1513u32);
    pub const HEBREW_LETTER_TAV : CodePoint = CodePoint::from(1514u32);
    pub const HEBREW_YOD_TRIANGLE : CodePoint = CodePoint::from(1519u32);
    pub const HEBREW_LIGATURE_YIDDISH_DOUBLE_VAV : CodePoint = CodePoint::from(1520u32);
    pub const HEBREW_LIGATURE_YIDDISH_VAV_YOD : CodePoint = CodePoint::from(1521u32);
    pub const HEBREW_LIGATURE_YIDDISH_DOUBLE_YOD : CodePoint = CodePoint::from(1522u32);
    pub const HEBREW_PUNCTUATION_GERESH : CodePoint = CodePoint::from(1523u32);
    pub const HEBREW_PUNCTUATION_GERSHAYIM : CodePoint = CodePoint::from(1524u32);
    pub const ARABIC_NUMBER_SIGN : CodePoint = CodePoint::from(1536u32);
    pub const ARABIC_SIGN_SANAH : CodePoint = CodePoint::from(1537u32);
    pub const ARABIC_FOOTNOTE_MARKER : CodePoint = CodePoint::from(1538u32);
    pub const ARABIC_SIGN_SAFHA : CodePoint = CodePoint::from(1539u32);
    pub const ARABIC_SIGN_SAMVAT : CodePoint = CodePoint::from(1540u32);
    pub const ARABIC_NUMBER_MARK_ABOVE : CodePoint = CodePoint::from(1541u32);
    pub const ARABIC_INDIC_CUBE_ROOT : CodePoint = CodePoint::from(1542u32);
    pub const ARABIC_INDIC_FOURTH_ROOT : CodePoint = CodePoint::from(1543u32);
    pub const ARABIC_RAY : CodePoint = CodePoint::from(1544u32);
    pub const ARABIC_INDIC_PER_MILLE_SIGN : CodePoint = CodePoint::from(1545u32);
    pub const ARABIC_INDIC_PER_TEN_THOUSAND_SIGN : CodePoint = CodePoint::from(1546u32);
    pub const AFGHANI_SIGN : CodePoint = CodePoint::from(1547u32);
    pub const ARABIC_COMMA : CodePoint = CodePoint::from(1548u32);
    pub const ARABIC_DATE_SEPARATOR : CodePoint = CodePoint::from(1549u32);
    pub const ARABIC_POETIC_VERSE_SIGN : CodePoint = CodePoint::from(1550u32);
    pub const ARABIC_SIGN_MISRA : CodePoint = CodePoint::from(1551u32);
    pub const ARABIC_SIGN_SALLALLAHOU_ALAYHE_WASSALLAM : CodePoint = CodePoint::from(1552u32);
    pub const ARABIC_SIGN_ALAYHE_ASSALLAM : CodePoint = CodePoint::from(1553u32);
    pub const ARABIC_SIGN_RAHMATULLAH_ALAYHE : CodePoint = CodePoint::from(1554u32);
    pub const ARABIC_SIGN_RADI_ALLAHOU_ANHU : CodePoint = CodePoint::from(1555u32);
    pub const ARABIC_SIGN_TAKHALLUS : CodePoint = CodePoint::from(1556u32);
    pub const ARABIC_SMALL_HIGH_TAH : CodePoint = CodePoint::from(1557u32);
    pub const ARABIC_SMALL_HIGH_LIGATURE_ALEF_WITH_LAM_WITH_YEH : CodePoint = CodePoint::from(1558u32);
    pub const ARABIC_SMALL_HIGH_ZAIN : CodePoint = CodePoint::from(1559u32);
    pub const ARABIC_SMALL_FATHA : CodePoint = CodePoint::from(1560u32);
    pub const ARABIC_SMALL_DAMMA : CodePoint = CodePoint::from(1561u32);
    pub const ARABIC_SMALL_KASRA : CodePoint = CodePoint::from(1562u32);
    pub const ARABIC_SEMICOLON : CodePoint = CodePoint::from(1563u32);
    pub const ARABIC_LETTER_MARK : CodePoint = CodePoint::from(1564u32);
    pub const ARABIC_TRIPLE_DOT_PUNCTUATION_MARK : CodePoint = CodePoint::from(1566u32);
    pub const ARABIC_QUESTION_MARK : CodePoint = CodePoint::from(1567u32);
    pub const ARABIC_LETTER_KASHMIRI_YEH : CodePoint = CodePoint::from(1568u32);
    pub const ARABIC_LETTER_HAMZA : CodePoint = CodePoint::from(1569u32);
    pub const ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE : CodePoint = CodePoint::from(1570u32);
    pub const ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1571u32);
    pub const ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1572u32);
    pub const ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW : CodePoint = CodePoint::from(1573u32);
    pub const ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1574u32);
    pub const ARABIC_LETTER_ALEF : CodePoint = CodePoint::from(1575u32);
    pub const ARABIC_LETTER_BEH : CodePoint = CodePoint::from(1576u32);
    pub const ARABIC_LETTER_TEH_MARBUTA : CodePoint = CodePoint::from(1577u32);
    pub const ARABIC_LETTER_TEH : CodePoint = CodePoint::from(1578u32);
    pub const ARABIC_LETTER_THEH : CodePoint = CodePoint::from(1579u32);
    pub const ARABIC_LETTER_JEEM : CodePoint = CodePoint::from(1580u32);
    pub const ARABIC_LETTER_HAH : CodePoint = CodePoint::from(1581u32);
    pub const ARABIC_LETTER_KHAH : CodePoint = CodePoint::from(1582u32);
    pub const ARABIC_LETTER_DAL : CodePoint = CodePoint::from(1583u32);
    pub const ARABIC_LETTER_THAL : CodePoint = CodePoint::from(1584u32);
    pub const ARABIC_LETTER_REH : CodePoint = CodePoint::from(1585u32);
    pub const ARABIC_LETTER_ZAIN : CodePoint = CodePoint::from(1586u32);
    pub const ARABIC_LETTER_SEEN : CodePoint = CodePoint::from(1587u32);
    pub const ARABIC_LETTER_SHEEN : CodePoint = CodePoint::from(1588u32);
    pub const ARABIC_LETTER_SAD : CodePoint = CodePoint::from(1589u32);
    pub const ARABIC_LETTER_DAD : CodePoint = CodePoint::from(1590u32);
    pub const ARABIC_LETTER_TAH : CodePoint = CodePoint::from(1591u32);
    pub const ARABIC_LETTER_ZAH : CodePoint = CodePoint::from(1592u32);
    pub const ARABIC_LETTER_AIN : CodePoint = CodePoint::from(1593u32);
    pub const ARABIC_LETTER_GHAIN : CodePoint = CodePoint::from(1594u32);
    pub const ARABIC_LETTER_KEHEH_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1595u32);
    pub const ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1596u32);
    pub const ARABIC_LETTER_FARSI_YEH_WITH_INVERTED_V : CodePoint = CodePoint::from(1597u32);
    pub const ARABIC_LETTER_FARSI_YEH_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1598u32);
    pub const ARABIC_LETTER_FARSI_YEH_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1599u32);
    pub const ARABIC_TATWEEL : CodePoint = CodePoint::from(1600u32);
    pub const ARABIC_LETTER_FEH : CodePoint = CodePoint::from(1601u32);
    pub const ARABIC_LETTER_QAF : CodePoint = CodePoint::from(1602u32);
    pub const ARABIC_LETTER_KAF : CodePoint = CodePoint::from(1603u32);
    pub const ARABIC_LETTER_LAM : CodePoint = CodePoint::from(1604u32);
    pub const ARABIC_LETTER_MEEM : CodePoint = CodePoint::from(1605u32);
    pub const ARABIC_LETTER_NOON : CodePoint = CodePoint::from(1606u32);
    pub const ARABIC_LETTER_HEH : CodePoint = CodePoint::from(1607u32);
    pub const ARABIC_LETTER_WAW : CodePoint = CodePoint::from(1608u32);
    pub const ARABIC_LETTER_ALEF_MAKSURA : CodePoint = CodePoint::from(1609u32);
    pub const ARABIC_LETTER_YEH : CodePoint = CodePoint::from(1610u32);
    pub const ARABIC_FATHATAN : CodePoint = CodePoint::from(1611u32);
    pub const ARABIC_DAMMATAN : CodePoint = CodePoint::from(1612u32);
    pub const ARABIC_KASRATAN : CodePoint = CodePoint::from(1613u32);
    pub const ARABIC_FATHA : CodePoint = CodePoint::from(1614u32);
    pub const ARABIC_DAMMA : CodePoint = CodePoint::from(1615u32);
    pub const ARABIC_KASRA : CodePoint = CodePoint::from(1616u32);
    pub const ARABIC_SHADDA : CodePoint = CodePoint::from(1617u32);
    pub const ARABIC_SUKUN : CodePoint = CodePoint::from(1618u32);
    pub const ARABIC_MADDAH_ABOVE : CodePoint = CodePoint::from(1619u32);
    pub const ARABIC_HAMZA_ABOVE : CodePoint = CodePoint::from(1620u32);
    pub const ARABIC_HAMZA_BELOW : CodePoint = CodePoint::from(1621u32);
    pub const ARABIC_SUBSCRIPT_ALEF : CodePoint = CodePoint::from(1622u32);
    pub const ARABIC_INVERTED_DAMMA : CodePoint = CodePoint::from(1623u32);
    pub const ARABIC_MARK_NOON_GHUNNA : CodePoint = CodePoint::from(1624u32);
    pub const ARABIC_ZWARAKAY : CodePoint = CodePoint::from(1625u32);
    pub const ARABIC_VOWEL_SIGN_SMALL_V_ABOVE : CodePoint = CodePoint::from(1626u32);
    pub const ARABIC_VOWEL_SIGN_INVERTED_SMALL_V_ABOVE : CodePoint = CodePoint::from(1627u32);
    pub const ARABIC_VOWEL_SIGN_DOT_BELOW : CodePoint = CodePoint::from(1628u32);
    pub const ARABIC_REVERSED_DAMMA : CodePoint = CodePoint::from(1629u32);
    pub const ARABIC_FATHA_WITH_TWO_DOTS : CodePoint = CodePoint::from(1630u32);
    pub const ARABIC_WAVY_HAMZA_BELOW : CodePoint = CodePoint::from(1631u32);
    pub const ARABIC_INDIC_DIGIT_ZERO : CodePoint = CodePoint::from(1632u32);
    pub const ARABIC_INDIC_DIGIT_ONE : CodePoint = CodePoint::from(1633u32);
    pub const ARABIC_INDIC_DIGIT_TWO : CodePoint = CodePoint::from(1634u32);
    pub const ARABIC_INDIC_DIGIT_THREE : CodePoint = CodePoint::from(1635u32);
    pub const ARABIC_INDIC_DIGIT_FOUR : CodePoint = CodePoint::from(1636u32);
    pub const ARABIC_INDIC_DIGIT_FIVE : CodePoint = CodePoint::from(1637u32);
    pub const ARABIC_INDIC_DIGIT_SIX : CodePoint = CodePoint::from(1638u32);
    pub const ARABIC_INDIC_DIGIT_SEVEN : CodePoint = CodePoint::from(1639u32);
    pub const ARABIC_INDIC_DIGIT_EIGHT : CodePoint = CodePoint::from(1640u32);
    pub const ARABIC_INDIC_DIGIT_NINE : CodePoint = CodePoint::from(1641u32);
    pub const ARABIC_PERCENT_SIGN : CodePoint = CodePoint::from(1642u32);
    pub const ARABIC_DECIMAL_SEPARATOR : CodePoint = CodePoint::from(1643u32);
    pub const ARABIC_THOUSANDS_SEPARATOR : CodePoint = CodePoint::from(1644u32);
    pub const ARABIC_FIVE_POINTED_STAR : CodePoint = CodePoint::from(1645u32);
    pub const ARABIC_LETTER_DOTLESS_BEH : CodePoint = CodePoint::from(1646u32);
    pub const ARABIC_LETTER_DOTLESS_QAF : CodePoint = CodePoint::from(1647u32);
    pub const ARABIC_LETTER_SUPERSCRIPT_ALEF : CodePoint = CodePoint::from(1648u32);
    pub const ARABIC_LETTER_ALEF_WASLA : CodePoint = CodePoint::from(1649u32);
    pub const ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_ABOVE : CodePoint = CodePoint::from(1650u32);
    pub const ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_BELOW : CodePoint = CodePoint::from(1651u32);
    pub const ARABIC_LETTER_HIGH_HAMZA : CodePoint = CodePoint::from(1652u32);
    pub const ARABIC_LETTER_HIGH_HAMZA_ALEF : CodePoint = CodePoint::from(1653u32);
    pub const ARABIC_LETTER_HIGH_HAMZA_WAW : CodePoint = CodePoint::from(1654u32);
    pub const ARABIC_LETTER_U_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1655u32);
    pub const ARABIC_LETTER_HIGH_HAMZA_YEH : CodePoint = CodePoint::from(1656u32);
    pub const ARABIC_LETTER_TTEH : CodePoint = CodePoint::from(1657u32);
    pub const ARABIC_LETTER_TTEHEH : CodePoint = CodePoint::from(1658u32);
    pub const ARABIC_LETTER_BEEH : CodePoint = CodePoint::from(1659u32);
    pub const ARABIC_LETTER_TEH_WITH_RING : CodePoint = CodePoint::from(1660u32);
    pub const ARABIC_LETTER_TEH_WITH_THREE_DOTS_ABOVE_DOWNWARDS : CodePoint = CodePoint::from(1661u32);
    pub const ARABIC_LETTER_PEH : CodePoint = CodePoint::from(1662u32);
    pub const ARABIC_LETTER_TEHEH : CodePoint = CodePoint::from(1663u32);
    pub const ARABIC_LETTER_BEHEH : CodePoint = CodePoint::from(1664u32);
    pub const ARABIC_LETTER_HAH_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1665u32);
    pub const ARABIC_LETTER_HAH_WITH_TWO_DOTS_VERTICAL_ABOVE : CodePoint = CodePoint::from(1666u32);
    pub const ARABIC_LETTER_NYEH : CodePoint = CodePoint::from(1667u32);
    pub const ARABIC_LETTER_DYEH : CodePoint = CodePoint::from(1668u32);
    pub const ARABIC_LETTER_HAH_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1669u32);
    pub const ARABIC_LETTER_TCHEH : CodePoint = CodePoint::from(1670u32);
    pub const ARABIC_LETTER_TCHEHEH : CodePoint = CodePoint::from(1671u32);
    pub const ARABIC_LETTER_DDAL : CodePoint = CodePoint::from(1672u32);
    pub const ARABIC_LETTER_DAL_WITH_RING : CodePoint = CodePoint::from(1673u32);
    pub const ARABIC_LETTER_DAL_WITH_DOT_BELOW : CodePoint = CodePoint::from(1674u32);
    pub const ARABIC_LETTER_DAL_WITH_DOT_BELOW_AND_SMALL_TAH : CodePoint = CodePoint::from(1675u32);
    pub const ARABIC_LETTER_DAHAL : CodePoint = CodePoint::from(1676u32);
    pub const ARABIC_LETTER_DDAHAL : CodePoint = CodePoint::from(1677u32);
    pub const ARABIC_LETTER_DUL : CodePoint = CodePoint::from(1678u32);
    pub const ARABIC_LETTER_DAL_WITH_THREE_DOTS_ABOVE_DOWNWARDS : CodePoint = CodePoint::from(1679u32);
    pub const ARABIC_LETTER_DAL_WITH_FOUR_DOTS_ABOVE : CodePoint = CodePoint::from(1680u32);
    pub const ARABIC_LETTER_RREH : CodePoint = CodePoint::from(1681u32);
    pub const ARABIC_LETTER_REH_WITH_SMALL_V : CodePoint = CodePoint::from(1682u32);
    pub const ARABIC_LETTER_REH_WITH_RING : CodePoint = CodePoint::from(1683u32);
    pub const ARABIC_LETTER_REH_WITH_DOT_BELOW : CodePoint = CodePoint::from(1684u32);
    pub const ARABIC_LETTER_REH_WITH_SMALL_V_BELOW : CodePoint = CodePoint::from(1685u32);
    pub const ARABIC_LETTER_REH_WITH_DOT_BELOW_AND_DOT_ABOVE : CodePoint = CodePoint::from(1686u32);
    pub const ARABIC_LETTER_REH_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1687u32);
    pub const ARABIC_LETTER_JEH : CodePoint = CodePoint::from(1688u32);
    pub const ARABIC_LETTER_REH_WITH_FOUR_DOTS_ABOVE : CodePoint = CodePoint::from(1689u32);
    pub const ARABIC_LETTER_SEEN_WITH_DOT_BELOW_AND_DOT_ABOVE : CodePoint = CodePoint::from(1690u32);
    pub const ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1691u32);
    pub const ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW_AND_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1692u32);
    pub const ARABIC_LETTER_SAD_WITH_TWO_DOTS_BELOW : CodePoint = CodePoint::from(1693u32);
    pub const ARABIC_LETTER_SAD_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1694u32);
    pub const ARABIC_LETTER_TAH_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1695u32);
    pub const ARABIC_LETTER_AIN_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1696u32);
    pub const ARABIC_LETTER_DOTLESS_FEH : CodePoint = CodePoint::from(1697u32);
    pub const ARABIC_LETTER_FEH_WITH_DOT_MOVED_BELOW : CodePoint = CodePoint::from(1698u32);
    pub const ARABIC_LETTER_FEH_WITH_DOT_BELOW : CodePoint = CodePoint::from(1699u32);
    pub const ARABIC_LETTER_VEH : CodePoint = CodePoint::from(1700u32);
    pub const ARABIC_LETTER_FEH_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1701u32);
    pub const ARABIC_LETTER_PEHEH : CodePoint = CodePoint::from(1702u32);
    pub const ARABIC_LETTER_QAF_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1703u32);
    pub const ARABIC_LETTER_QAF_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1704u32);
    pub const ARABIC_LETTER_KEHEH : CodePoint = CodePoint::from(1705u32);
    pub const ARABIC_LETTER_SWASH_KAF : CodePoint = CodePoint::from(1706u32);
    pub const ARABIC_LETTER_KAF_WITH_RING : CodePoint = CodePoint::from(1707u32);
    pub const ARABIC_LETTER_KAF_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1708u32);
    pub const ARABIC_LETTER_NG : CodePoint = CodePoint::from(1709u32);
    pub const ARABIC_LETTER_KAF_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1710u32);
    pub const ARABIC_LETTER_GAF : CodePoint = CodePoint::from(1711u32);
    pub const ARABIC_LETTER_GAF_WITH_RING : CodePoint = CodePoint::from(1712u32);
    pub const ARABIC_LETTER_NGOEH : CodePoint = CodePoint::from(1713u32);
    pub const ARABIC_LETTER_GAF_WITH_TWO_DOTS_BELOW : CodePoint = CodePoint::from(1714u32);
    pub const ARABIC_LETTER_GUEH : CodePoint = CodePoint::from(1715u32);
    pub const ARABIC_LETTER_GAF_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1716u32);
    pub const ARABIC_LETTER_LAM_WITH_SMALL_V : CodePoint = CodePoint::from(1717u32);
    pub const ARABIC_LETTER_LAM_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1718u32);
    pub const ARABIC_LETTER_LAM_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1719u32);
    pub const ARABIC_LETTER_LAM_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1720u32);
    pub const ARABIC_LETTER_NOON_WITH_DOT_BELOW : CodePoint = CodePoint::from(1721u32);
    pub const ARABIC_LETTER_NOON_GHUNNA : CodePoint = CodePoint::from(1722u32);
    pub const ARABIC_LETTER_RNOON : CodePoint = CodePoint::from(1723u32);
    pub const ARABIC_LETTER_NOON_WITH_RING : CodePoint = CodePoint::from(1724u32);
    pub const ARABIC_LETTER_NOON_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1725u32);
    pub const ARABIC_LETTER_HEH_DOACHASHMEE : CodePoint = CodePoint::from(1726u32);
    pub const ARABIC_LETTER_TCHEH_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1727u32);
    pub const ARABIC_LETTER_HEH_WITH_YEH_ABOVE : CodePoint = CodePoint::from(1728u32);
    pub const ARABIC_LETTER_HEH_GOAL : CodePoint = CodePoint::from(1729u32);
    pub const ARABIC_LETTER_HEH_GOAL_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1730u32);
    pub const ARABIC_LETTER_TEH_MARBUTA_GOAL : CodePoint = CodePoint::from(1731u32);
    pub const ARABIC_LETTER_WAW_WITH_RING : CodePoint = CodePoint::from(1732u32);
    pub const ARABIC_LETTER_KIRGHIZ_OE : CodePoint = CodePoint::from(1733u32);
    pub const ARABIC_LETTER_OE : CodePoint = CodePoint::from(1734u32);
    pub const ARABIC_LETTER_U : CodePoint = CodePoint::from(1735u32);
    pub const ARABIC_LETTER_YU : CodePoint = CodePoint::from(1736u32);
    pub const ARABIC_LETTER_KIRGHIZ_YU : CodePoint = CodePoint::from(1737u32);
    pub const ARABIC_LETTER_WAW_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1738u32);
    pub const ARABIC_LETTER_VE : CodePoint = CodePoint::from(1739u32);
    pub const ARABIC_LETTER_FARSI_YEH : CodePoint = CodePoint::from(1740u32);
    pub const ARABIC_LETTER_YEH_WITH_TAIL : CodePoint = CodePoint::from(1741u32);
    pub const ARABIC_LETTER_YEH_WITH_SMALL_V : CodePoint = CodePoint::from(1742u32);
    pub const ARABIC_LETTER_WAW_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1743u32);
    pub const ARABIC_LETTER_E : CodePoint = CodePoint::from(1744u32);
    pub const ARABIC_LETTER_YEH_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1745u32);
    pub const ARABIC_LETTER_YEH_BARREE : CodePoint = CodePoint::from(1746u32);
    pub const ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1747u32);
    pub const ARABIC_FULL_STOP : CodePoint = CodePoint::from(1748u32);
    pub const ARABIC_LETTER_AE : CodePoint = CodePoint::from(1749u32);
    pub const ARABIC_SMALL_HIGH_LIGATURE_SAD_WITH_LAM_WITH_ALEF_MAKSURA : CodePoint = CodePoint::from(1750u32);
    pub const ARABIC_SMALL_HIGH_LIGATURE_QAF_WITH_LAM_WITH_ALEF_MAKSURA : CodePoint = CodePoint::from(1751u32);
    pub const ARABIC_SMALL_HIGH_MEEM_INITIAL_FORM : CodePoint = CodePoint::from(1752u32);
    pub const ARABIC_SMALL_HIGH_LAM_ALEF : CodePoint = CodePoint::from(1753u32);
    pub const ARABIC_SMALL_HIGH_JEEM : CodePoint = CodePoint::from(1754u32);
    pub const ARABIC_SMALL_HIGH_THREE_DOTS : CodePoint = CodePoint::from(1755u32);
    pub const ARABIC_SMALL_HIGH_SEEN : CodePoint = CodePoint::from(1756u32);
    pub const ARABIC_END_OF_AYAH : CodePoint = CodePoint::from(1757u32);
    pub const ARABIC_START_OF_RUB_EL_HIZB : CodePoint = CodePoint::from(1758u32);
    pub const ARABIC_SMALL_HIGH_ROUNDED_ZERO : CodePoint = CodePoint::from(1759u32);
    pub const ARABIC_SMALL_HIGH_UPRIGHT_RECTANGULAR_ZERO : CodePoint = CodePoint::from(1760u32);
    pub const ARABIC_SMALL_HIGH_DOTLESS_HEAD_OF_KHAH : CodePoint = CodePoint::from(1761u32);
    pub const ARABIC_SMALL_HIGH_MEEM_ISOLATED_FORM : CodePoint = CodePoint::from(1762u32);
    pub const ARABIC_SMALL_LOW_SEEN : CodePoint = CodePoint::from(1763u32);
    pub const ARABIC_SMALL_HIGH_MADDA : CodePoint = CodePoint::from(1764u32);
    pub const ARABIC_SMALL_WAW : CodePoint = CodePoint::from(1765u32);
    pub const ARABIC_SMALL_YEH : CodePoint = CodePoint::from(1766u32);
    pub const ARABIC_SMALL_HIGH_YEH : CodePoint = CodePoint::from(1767u32);
    pub const ARABIC_SMALL_HIGH_NOON : CodePoint = CodePoint::from(1768u32);
    pub const ARABIC_PLACE_OF_SAJDAH : CodePoint = CodePoint::from(1769u32);
    pub const ARABIC_EMPTY_CENTRE_LOW_STOP : CodePoint = CodePoint::from(1770u32);
    pub const ARABIC_EMPTY_CENTRE_HIGH_STOP : CodePoint = CodePoint::from(1771u32);
    pub const ARABIC_ROUNDED_HIGH_STOP_WITH_FILLED_CENTRE : CodePoint = CodePoint::from(1772u32);
    pub const ARABIC_SMALL_LOW_MEEM : CodePoint = CodePoint::from(1773u32);
    pub const ARABIC_LETTER_DAL_WITH_INVERTED_V : CodePoint = CodePoint::from(1774u32);
    pub const ARABIC_LETTER_REH_WITH_INVERTED_V : CodePoint = CodePoint::from(1775u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_ZERO : CodePoint = CodePoint::from(1776u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_ONE : CodePoint = CodePoint::from(1777u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_TWO : CodePoint = CodePoint::from(1778u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_THREE : CodePoint = CodePoint::from(1779u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_FOUR : CodePoint = CodePoint::from(1780u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_FIVE : CodePoint = CodePoint::from(1781u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_SIX : CodePoint = CodePoint::from(1782u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_SEVEN : CodePoint = CodePoint::from(1783u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_EIGHT : CodePoint = CodePoint::from(1784u32);
    pub const EXTENDED_ARABIC_INDIC_DIGIT_NINE : CodePoint = CodePoint::from(1785u32);
    pub const ARABIC_LETTER_SHEEN_WITH_DOT_BELOW : CodePoint = CodePoint::from(1786u32);
    pub const ARABIC_LETTER_DAD_WITH_DOT_BELOW : CodePoint = CodePoint::from(1787u32);
    pub const ARABIC_LETTER_GHAIN_WITH_DOT_BELOW : CodePoint = CodePoint::from(1788u32);
    pub const ARABIC_SIGN_SINDHI_AMPERSAND : CodePoint = CodePoint::from(1789u32);
    pub const ARABIC_SIGN_SINDHI_POSTPOSITION_MEN : CodePoint = CodePoint::from(1790u32);
    pub const ARABIC_LETTER_HEH_WITH_INVERTED_V : CodePoint = CodePoint::from(1791u32);
    pub const SYRIAC_END_OF_PARAGRAPH : CodePoint = CodePoint::from(1792u32);
    pub const SYRIAC_SUPRALINEAR_FULL_STOP : CodePoint = CodePoint::from(1793u32);
    pub const SYRIAC_SUBLINEAR_FULL_STOP : CodePoint = CodePoint::from(1794u32);
    pub const SYRIAC_SUPRALINEAR_COLON : CodePoint = CodePoint::from(1795u32);
    pub const SYRIAC_SUBLINEAR_COLON : CodePoint = CodePoint::from(1796u32);
    pub const SYRIAC_HORIZONTAL_COLON : CodePoint = CodePoint::from(1797u32);
    pub const SYRIAC_COLON_SKEWED_LEFT : CodePoint = CodePoint::from(1798u32);
    pub const SYRIAC_COLON_SKEWED_RIGHT : CodePoint = CodePoint::from(1799u32);
    pub const SYRIAC_SUPRALINEAR_COLON_SKEWED_LEFT : CodePoint = CodePoint::from(1800u32);
    pub const SYRIAC_SUBLINEAR_COLON_SKEWED_RIGHT : CodePoint = CodePoint::from(1801u32);
    pub const SYRIAC_CONTRACTION : CodePoint = CodePoint::from(1802u32);
    pub const SYRIAC_HARKLEAN_OBELUS : CodePoint = CodePoint::from(1803u32);
    pub const SYRIAC_HARKLEAN_METOBELUS : CodePoint = CodePoint::from(1804u32);
    pub const SYRIAC_HARKLEAN_ASTERISCUS : CodePoint = CodePoint::from(1805u32);
    pub const SYRIAC_ABBREVIATION_MARK : CodePoint = CodePoint::from(1807u32);
    pub const SYRIAC_LETTER_ALAPH : CodePoint = CodePoint::from(1808u32);
    pub const SYRIAC_LETTER_SUPERSCRIPT_ALAPH : CodePoint = CodePoint::from(1809u32);
    pub const SYRIAC_LETTER_BETH : CodePoint = CodePoint::from(1810u32);
    pub const SYRIAC_LETTER_GAMAL : CodePoint = CodePoint::from(1811u32);
    pub const SYRIAC_LETTER_GAMAL_GARSHUNI : CodePoint = CodePoint::from(1812u32);
    pub const SYRIAC_LETTER_DALATH : CodePoint = CodePoint::from(1813u32);
    pub const SYRIAC_LETTER_DOTLESS_DALATH_RISH : CodePoint = CodePoint::from(1814u32);
    pub const SYRIAC_LETTER_HE : CodePoint = CodePoint::from(1815u32);
    pub const SYRIAC_LETTER_WAW : CodePoint = CodePoint::from(1816u32);
    pub const SYRIAC_LETTER_ZAIN : CodePoint = CodePoint::from(1817u32);
    pub const SYRIAC_LETTER_HETH : CodePoint = CodePoint::from(1818u32);
    pub const SYRIAC_LETTER_TETH : CodePoint = CodePoint::from(1819u32);
    pub const SYRIAC_LETTER_TETH_GARSHUNI : CodePoint = CodePoint::from(1820u32);
    pub const SYRIAC_LETTER_YUDH : CodePoint = CodePoint::from(1821u32);
    pub const SYRIAC_LETTER_YUDH_HE : CodePoint = CodePoint::from(1822u32);
    pub const SYRIAC_LETTER_KAPH : CodePoint = CodePoint::from(1823u32);
    pub const SYRIAC_LETTER_LAMADH : CodePoint = CodePoint::from(1824u32);
    pub const SYRIAC_LETTER_MIM : CodePoint = CodePoint::from(1825u32);
    pub const SYRIAC_LETTER_NUN : CodePoint = CodePoint::from(1826u32);
    pub const SYRIAC_LETTER_SEMKATH : CodePoint = CodePoint::from(1827u32);
    pub const SYRIAC_LETTER_FINAL_SEMKATH : CodePoint = CodePoint::from(1828u32);
    pub const SYRIAC_LETTER_E : CodePoint = CodePoint::from(1829u32);
    pub const SYRIAC_LETTER_PE : CodePoint = CodePoint::from(1830u32);
    pub const SYRIAC_LETTER_REVERSED_PE : CodePoint = CodePoint::from(1831u32);
    pub const SYRIAC_LETTER_SADHE : CodePoint = CodePoint::from(1832u32);
    pub const SYRIAC_LETTER_QAPH : CodePoint = CodePoint::from(1833u32);
    pub const SYRIAC_LETTER_RISH : CodePoint = CodePoint::from(1834u32);
    pub const SYRIAC_LETTER_SHIN : CodePoint = CodePoint::from(1835u32);
    pub const SYRIAC_LETTER_TAW : CodePoint = CodePoint::from(1836u32);
    pub const SYRIAC_LETTER_PERSIAN_BHETH : CodePoint = CodePoint::from(1837u32);
    pub const SYRIAC_LETTER_PERSIAN_GHAMAL : CodePoint = CodePoint::from(1838u32);
    pub const SYRIAC_LETTER_PERSIAN_DHALATH : CodePoint = CodePoint::from(1839u32);
    pub const SYRIAC_PTHAHA_ABOVE : CodePoint = CodePoint::from(1840u32);
    pub const SYRIAC_PTHAHA_BELOW : CodePoint = CodePoint::from(1841u32);
    pub const SYRIAC_PTHAHA_DOTTED : CodePoint = CodePoint::from(1842u32);
    pub const SYRIAC_ZQAPHA_ABOVE : CodePoint = CodePoint::from(1843u32);
    pub const SYRIAC_ZQAPHA_BELOW : CodePoint = CodePoint::from(1844u32);
    pub const SYRIAC_ZQAPHA_DOTTED : CodePoint = CodePoint::from(1845u32);
    pub const SYRIAC_RBASA_ABOVE : CodePoint = CodePoint::from(1846u32);
    pub const SYRIAC_RBASA_BELOW : CodePoint = CodePoint::from(1847u32);
    pub const SYRIAC_DOTTED_ZLAMA_HORIZONTAL : CodePoint = CodePoint::from(1848u32);
    pub const SYRIAC_DOTTED_ZLAMA_ANGULAR : CodePoint = CodePoint::from(1849u32);
    pub const SYRIAC_HBASA_ABOVE : CodePoint = CodePoint::from(1850u32);
    pub const SYRIAC_HBASA_BELOW : CodePoint = CodePoint::from(1851u32);
    pub const SYRIAC_HBASA_ESASA_DOTTED : CodePoint = CodePoint::from(1852u32);
    pub const SYRIAC_ESASA_ABOVE : CodePoint = CodePoint::from(1853u32);
    pub const SYRIAC_ESASA_BELOW : CodePoint = CodePoint::from(1854u32);
    pub const SYRIAC_RWAHA : CodePoint = CodePoint::from(1855u32);
    pub const SYRIAC_FEMININE_DOT : CodePoint = CodePoint::from(1856u32);
    pub const SYRIAC_QUSHSHAYA : CodePoint = CodePoint::from(1857u32);
    pub const SYRIAC_RUKKAKHA : CodePoint = CodePoint::from(1858u32);
    pub const SYRIAC_TWO_VERTICAL_DOTS_ABOVE : CodePoint = CodePoint::from(1859u32);
    pub const SYRIAC_TWO_VERTICAL_DOTS_BELOW : CodePoint = CodePoint::from(1860u32);
    pub const SYRIAC_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1861u32);
    pub const SYRIAC_THREE_DOTS_BELOW : CodePoint = CodePoint::from(1862u32);
    pub const SYRIAC_OBLIQUE_LINE_ABOVE : CodePoint = CodePoint::from(1863u32);
    pub const SYRIAC_OBLIQUE_LINE_BELOW : CodePoint = CodePoint::from(1864u32);
    pub const SYRIAC_MUSIC : CodePoint = CodePoint::from(1865u32);
    pub const SYRIAC_BARREKH : CodePoint = CodePoint::from(1866u32);
    pub const SYRIAC_LETTER_SOGDIAN_ZHAIN : CodePoint = CodePoint::from(1869u32);
    pub const SYRIAC_LETTER_SOGDIAN_KHAPH : CodePoint = CodePoint::from(1870u32);
    pub const SYRIAC_LETTER_SOGDIAN_FE : CodePoint = CodePoint::from(1871u32);
    pub const ARABIC_LETTER_BEH_WITH_THREE_DOTS_HORIZONTALLY_BELOW : CodePoint = CodePoint::from(1872u32);
    pub const ARABIC_LETTER_BEH_WITH_DOT_BELOW_AND_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1873u32);
    pub const ARABIC_LETTER_BEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW : CodePoint = CodePoint::from(1874u32);
    pub const ARABIC_LETTER_BEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW_AND_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1875u32);
    pub const ARABIC_LETTER_BEH_WITH_TWO_DOTS_BELOW_AND_DOT_ABOVE : CodePoint = CodePoint::from(1876u32);
    pub const ARABIC_LETTER_BEH_WITH_INVERTED_SMALL_V_BELOW : CodePoint = CodePoint::from(1877u32);
    pub const ARABIC_LETTER_BEH_WITH_SMALL_V : CodePoint = CodePoint::from(1878u32);
    pub const ARABIC_LETTER_HAH_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1879u32);
    pub const ARABIC_LETTER_HAH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW : CodePoint = CodePoint::from(1880u32);
    pub const ARABIC_LETTER_DAL_WITH_TWO_DOTS_VERTICALLY_BELOW_AND_SMALL_TAH : CodePoint = CodePoint::from(1881u32);
    pub const ARABIC_LETTER_DAL_WITH_INVERTED_SMALL_V_BELOW : CodePoint = CodePoint::from(1882u32);
    pub const ARABIC_LETTER_REH_WITH_STROKE : CodePoint = CodePoint::from(1883u32);
    pub const ARABIC_LETTER_SEEN_WITH_FOUR_DOTS_ABOVE : CodePoint = CodePoint::from(1884u32);
    pub const ARABIC_LETTER_AIN_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1885u32);
    pub const ARABIC_LETTER_AIN_WITH_THREE_DOTS_POINTING_DOWNWARDS_ABOVE : CodePoint = CodePoint::from(1886u32);
    pub const ARABIC_LETTER_AIN_WITH_TWO_DOTS_VERTICALLY_ABOVE : CodePoint = CodePoint::from(1887u32);
    pub const ARABIC_LETTER_FEH_WITH_TWO_DOTS_BELOW : CodePoint = CodePoint::from(1888u32);
    pub const ARABIC_LETTER_FEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW : CodePoint = CodePoint::from(1889u32);
    pub const ARABIC_LETTER_KEHEH_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1890u32);
    pub const ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(1891u32);
    pub const ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW : CodePoint = CodePoint::from(1892u32);
    pub const ARABIC_LETTER_MEEM_WITH_DOT_ABOVE : CodePoint = CodePoint::from(1893u32);
    pub const ARABIC_LETTER_MEEM_WITH_DOT_BELOW : CodePoint = CodePoint::from(1894u32);
    pub const ARABIC_LETTER_NOON_WITH_TWO_DOTS_BELOW : CodePoint = CodePoint::from(1895u32);
    pub const ARABIC_LETTER_NOON_WITH_SMALL_TAH : CodePoint = CodePoint::from(1896u32);
    pub const ARABIC_LETTER_NOON_WITH_SMALL_V : CodePoint = CodePoint::from(1897u32);
    pub const ARABIC_LETTER_LAM_WITH_BAR : CodePoint = CodePoint::from(1898u32);
    pub const ARABIC_LETTER_REH_WITH_TWO_DOTS_VERTICALLY_ABOVE : CodePoint = CodePoint::from(1899u32);
    pub const ARABIC_LETTER_REH_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(1900u32);
    pub const ARABIC_LETTER_SEEN_WITH_TWO_DOTS_VERTICALLY_ABOVE : CodePoint = CodePoint::from(1901u32);
    pub const ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_BELOW : CodePoint = CodePoint::from(1902u32);
    pub const ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS : CodePoint = CodePoint::from(1903u32);
    pub const ARABIC_LETTER_SEEN_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS : CodePoint = CodePoint::from(1904u32);
    pub const ARABIC_LETTER_REH_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS : CodePoint = CodePoint::from(1905u32);
    pub const ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_ABOVE : CodePoint = CodePoint::from(1906u32);
    pub const ARABIC_LETTER_ALEF_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE : CodePoint = CodePoint::from(1907u32);
    pub const ARABIC_LETTER_ALEF_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE : CodePoint = CodePoint::from(1908u32);
    pub const ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE : CodePoint = CodePoint::from(1909u32);
    pub const ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE : CodePoint = CodePoint::from(1910u32);
    pub const ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_BELOW : CodePoint = CodePoint::from(1911u32);
    pub const ARABIC_LETTER_WAW_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE : CodePoint = CodePoint::from(1912u32);
    pub const ARABIC_LETTER_WAW_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE : CodePoint = CodePoint::from(1913u32);
    pub const ARABIC_LETTER_YEH_BARREE_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE : CodePoint = CodePoint::from(1914u32);
    pub const ARABIC_LETTER_YEH_BARREE_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE : CodePoint = CodePoint::from(1915u32);
    pub const ARABIC_LETTER_HAH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_BELOW : CodePoint = CodePoint::from(1916u32);
    pub const ARABIC_LETTER_SEEN_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_ABOVE : CodePoint = CodePoint::from(1917u32);
    pub const ARABIC_LETTER_SEEN_WITH_INVERTED_V : CodePoint = CodePoint::from(1918u32);
    pub const ARABIC_LETTER_KAF_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(1919u32);
    pub const THAANA_LETTER_HAA : CodePoint = CodePoint::from(1920u32);
    pub const THAANA_LETTER_SHAVIYANI : CodePoint = CodePoint::from(1921u32);
    pub const THAANA_LETTER_NOONU : CodePoint = CodePoint::from(1922u32);
    pub const THAANA_LETTER_RAA : CodePoint = CodePoint::from(1923u32);
    pub const THAANA_LETTER_BAA : CodePoint = CodePoint::from(1924u32);
    pub const THAANA_LETTER_LHAVIYANI : CodePoint = CodePoint::from(1925u32);
    pub const THAANA_LETTER_KAAFU : CodePoint = CodePoint::from(1926u32);
    pub const THAANA_LETTER_ALIFU : CodePoint = CodePoint::from(1927u32);
    pub const THAANA_LETTER_VAAVU : CodePoint = CodePoint::from(1928u32);
    pub const THAANA_LETTER_MEEMU : CodePoint = CodePoint::from(1929u32);
    pub const THAANA_LETTER_FAAFU : CodePoint = CodePoint::from(1930u32);
    pub const THAANA_LETTER_DHAALU : CodePoint = CodePoint::from(1931u32);
    pub const THAANA_LETTER_THAA : CodePoint = CodePoint::from(1932u32);
    pub const THAANA_LETTER_LAAMU : CodePoint = CodePoint::from(1933u32);
    pub const THAANA_LETTER_GAAFU : CodePoint = CodePoint::from(1934u32);
    pub const THAANA_LETTER_GNAVIYANI : CodePoint = CodePoint::from(1935u32);
    pub const THAANA_LETTER_SEENU : CodePoint = CodePoint::from(1936u32);
    pub const THAANA_LETTER_DAVIYANI : CodePoint = CodePoint::from(1937u32);
    pub const THAANA_LETTER_ZAVIYANI : CodePoint = CodePoint::from(1938u32);
    pub const THAANA_LETTER_TAVIYANI : CodePoint = CodePoint::from(1939u32);
    pub const THAANA_LETTER_YAA : CodePoint = CodePoint::from(1940u32);
    pub const THAANA_LETTER_PAVIYANI : CodePoint = CodePoint::from(1941u32);
    pub const THAANA_LETTER_JAVIYANI : CodePoint = CodePoint::from(1942u32);
    pub const THAANA_LETTER_CHAVIYANI : CodePoint = CodePoint::from(1943u32);
    pub const THAANA_LETTER_TTAA : CodePoint = CodePoint::from(1944u32);
    pub const THAANA_LETTER_HHAA : CodePoint = CodePoint::from(1945u32);
    pub const THAANA_LETTER_KHAA : CodePoint = CodePoint::from(1946u32);
    pub const THAANA_LETTER_THAALU : CodePoint = CodePoint::from(1947u32);
    pub const THAANA_LETTER_ZAA : CodePoint = CodePoint::from(1948u32);
    pub const THAANA_LETTER_SHEENU : CodePoint = CodePoint::from(1949u32);
    pub const THAANA_LETTER_SAADHU : CodePoint = CodePoint::from(1950u32);
    pub const THAANA_LETTER_DAADHU : CodePoint = CodePoint::from(1951u32);
    pub const THAANA_LETTER_TO : CodePoint = CodePoint::from(1952u32);
    pub const THAANA_LETTER_ZO : CodePoint = CodePoint::from(1953u32);
    pub const THAANA_LETTER_AINU : CodePoint = CodePoint::from(1954u32);
    pub const THAANA_LETTER_GHAINU : CodePoint = CodePoint::from(1955u32);
    pub const THAANA_LETTER_QAAFU : CodePoint = CodePoint::from(1956u32);
    pub const THAANA_LETTER_WAAVU : CodePoint = CodePoint::from(1957u32);
    pub const THAANA_ABAFILI : CodePoint = CodePoint::from(1958u32);
    pub const THAANA_AABAAFILI : CodePoint = CodePoint::from(1959u32);
    pub const THAANA_IBIFILI : CodePoint = CodePoint::from(1960u32);
    pub const THAANA_EEBEEFILI : CodePoint = CodePoint::from(1961u32);
    pub const THAANA_UBUFILI : CodePoint = CodePoint::from(1962u32);
    pub const THAANA_OOBOOFILI : CodePoint = CodePoint::from(1963u32);
    pub const THAANA_EBEFILI : CodePoint = CodePoint::from(1964u32);
    pub const THAANA_EYBEYFILI : CodePoint = CodePoint::from(1965u32);
    pub const THAANA_OBOFILI : CodePoint = CodePoint::from(1966u32);
    pub const THAANA_OABOAFILI : CodePoint = CodePoint::from(1967u32);
    pub const THAANA_SUKUN : CodePoint = CodePoint::from(1968u32);
    pub const THAANA_LETTER_NAA : CodePoint = CodePoint::from(1969u32);
    pub const NKO_DIGIT_ZERO : CodePoint = CodePoint::from(1984u32);
    pub const NKO_DIGIT_ONE : CodePoint = CodePoint::from(1985u32);
    pub const NKO_DIGIT_TWO : CodePoint = CodePoint::from(1986u32);
    pub const NKO_DIGIT_THREE : CodePoint = CodePoint::from(1987u32);
    pub const NKO_DIGIT_FOUR : CodePoint = CodePoint::from(1988u32);
    pub const NKO_DIGIT_FIVE : CodePoint = CodePoint::from(1989u32);
    pub const NKO_DIGIT_SIX : CodePoint = CodePoint::from(1990u32);
    pub const NKO_DIGIT_SEVEN : CodePoint = CodePoint::from(1991u32);
    pub const NKO_DIGIT_EIGHT : CodePoint = CodePoint::from(1992u32);
    pub const NKO_DIGIT_NINE : CodePoint = CodePoint::from(1993u32);
    pub const NKO_LETTER_A : CodePoint = CodePoint::from(1994u32);
    pub const NKO_LETTER_EE : CodePoint = CodePoint::from(1995u32);
    pub const NKO_LETTER_I : CodePoint = CodePoint::from(1996u32);
    pub const NKO_LETTER_E : CodePoint = CodePoint::from(1997u32);
    pub const NKO_LETTER_U : CodePoint = CodePoint::from(1998u32);
    pub const NKO_LETTER_OO : CodePoint = CodePoint::from(1999u32);
    pub const NKO_LETTER_O : CodePoint = CodePoint::from(2000u32);
    pub const NKO_LETTER_DAGBASINNA : CodePoint = CodePoint::from(2001u32);
    pub const NKO_LETTER_N : CodePoint = CodePoint::from(2002u32);
    pub const NKO_LETTER_BA : CodePoint = CodePoint::from(2003u32);
    pub const NKO_LETTER_PA : CodePoint = CodePoint::from(2004u32);
    pub const NKO_LETTER_TA : CodePoint = CodePoint::from(2005u32);
    pub const NKO_LETTER_JA : CodePoint = CodePoint::from(2006u32);
    pub const NKO_LETTER_CHA : CodePoint = CodePoint::from(2007u32);
    pub const NKO_LETTER_DA : CodePoint = CodePoint::from(2008u32);
    pub const NKO_LETTER_RA : CodePoint = CodePoint::from(2009u32);
    pub const NKO_LETTER_RRA : CodePoint = CodePoint::from(2010u32);
    pub const NKO_LETTER_SA : CodePoint = CodePoint::from(2011u32);
    pub const NKO_LETTER_GBA : CodePoint = CodePoint::from(2012u32);
    pub const NKO_LETTER_FA : CodePoint = CodePoint::from(2013u32);
    pub const NKO_LETTER_KA : CodePoint = CodePoint::from(2014u32);
    pub const NKO_LETTER_LA : CodePoint = CodePoint::from(2015u32);
    pub const NKO_LETTER_NA_WOLOSO : CodePoint = CodePoint::from(2016u32);
    pub const NKO_LETTER_MA : CodePoint = CodePoint::from(2017u32);
    pub const NKO_LETTER_NYA : CodePoint = CodePoint::from(2018u32);
    pub const NKO_LETTER_NA : CodePoint = CodePoint::from(2019u32);
    pub const NKO_LETTER_HA : CodePoint = CodePoint::from(2020u32);
    pub const NKO_LETTER_WA : CodePoint = CodePoint::from(2021u32);
    pub const NKO_LETTER_YA : CodePoint = CodePoint::from(2022u32);
    pub const NKO_LETTER_NYA_WOLOSO : CodePoint = CodePoint::from(2023u32);
    pub const NKO_LETTER_JONA_JA : CodePoint = CodePoint::from(2024u32);
    pub const NKO_LETTER_JONA_CHA : CodePoint = CodePoint::from(2025u32);
    pub const NKO_LETTER_JONA_RA : CodePoint = CodePoint::from(2026u32);
    pub const NKO_COMBINING_SHORT_HIGH_TONE : CodePoint = CodePoint::from(2027u32);
    pub const NKO_COMBINING_SHORT_LOW_TONE : CodePoint = CodePoint::from(2028u32);
    pub const NKO_COMBINING_SHORT_RISING_TONE : CodePoint = CodePoint::from(2029u32);
    pub const NKO_COMBINING_LONG_DESCENDING_TONE : CodePoint = CodePoint::from(2030u32);
    pub const NKO_COMBINING_LONG_HIGH_TONE : CodePoint = CodePoint::from(2031u32);
    pub const NKO_COMBINING_LONG_LOW_TONE : CodePoint = CodePoint::from(2032u32);
    pub const NKO_COMBINING_LONG_RISING_TONE : CodePoint = CodePoint::from(2033u32);
    pub const NKO_COMBINING_NASALIZATION_MARK : CodePoint = CodePoint::from(2034u32);
    pub const NKO_COMBINING_DOUBLE_DOT_ABOVE : CodePoint = CodePoint::from(2035u32);
    pub const NKO_HIGH_TONE_APOSTROPHE : CodePoint = CodePoint::from(2036u32);
    pub const NKO_LOW_TONE_APOSTROPHE : CodePoint = CodePoint::from(2037u32);
    pub const NKO_SYMBOL_OO_DENNEN : CodePoint = CodePoint::from(2038u32);
    pub const NKO_SYMBOL_GBAKURUNEN : CodePoint = CodePoint::from(2039u32);
    pub const NKO_COMMA : CodePoint = CodePoint::from(2040u32);
    pub const NKO_EXCLAMATION_MARK : CodePoint = CodePoint::from(2041u32);
    pub const NKO_LAJANYALAN : CodePoint = CodePoint::from(2042u32);
    pub const NKO_DANTAYALAN : CodePoint = CodePoint::from(2045u32);
    pub const NKO_DOROME_SIGN : CodePoint = CodePoint::from(2046u32);
    pub const NKO_TAMAN_SIGN : CodePoint = CodePoint::from(2047u32);
    pub const SAMARITAN_LETTER_ALAF : CodePoint = CodePoint::from(2048u32);
    pub const SAMARITAN_LETTER_BIT : CodePoint = CodePoint::from(2049u32);
    pub const SAMARITAN_LETTER_GAMAN : CodePoint = CodePoint::from(2050u32);
    pub const SAMARITAN_LETTER_DALAT : CodePoint = CodePoint::from(2051u32);
    pub const SAMARITAN_LETTER_IY : CodePoint = CodePoint::from(2052u32);
    pub const SAMARITAN_LETTER_BAA : CodePoint = CodePoint::from(2053u32);
    pub const SAMARITAN_LETTER_ZEN : CodePoint = CodePoint::from(2054u32);
    pub const SAMARITAN_LETTER_IT : CodePoint = CodePoint::from(2055u32);
    pub const SAMARITAN_LETTER_TIT : CodePoint = CodePoint::from(2056u32);
    pub const SAMARITAN_LETTER_YUT : CodePoint = CodePoint::from(2057u32);
    pub const SAMARITAN_LETTER_KAAF : CodePoint = CodePoint::from(2058u32);
    pub const SAMARITAN_LETTER_LABAT : CodePoint = CodePoint::from(2059u32);
    pub const SAMARITAN_LETTER_MIM : CodePoint = CodePoint::from(2060u32);
    pub const SAMARITAN_LETTER_NUN : CodePoint = CodePoint::from(2061u32);
    pub const SAMARITAN_LETTER_SINGAAT : CodePoint = CodePoint::from(2062u32);
    pub const SAMARITAN_LETTER_IN : CodePoint = CodePoint::from(2063u32);
    pub const SAMARITAN_LETTER_FI : CodePoint = CodePoint::from(2064u32);
    pub const SAMARITAN_LETTER_TSAADIY : CodePoint = CodePoint::from(2065u32);
    pub const SAMARITAN_LETTER_QUF : CodePoint = CodePoint::from(2066u32);
    pub const SAMARITAN_LETTER_RISH : CodePoint = CodePoint::from(2067u32);
    pub const SAMARITAN_LETTER_SHAN : CodePoint = CodePoint::from(2068u32);
    pub const SAMARITAN_LETTER_TAAF : CodePoint = CodePoint::from(2069u32);
    pub const SAMARITAN_MARK_IN : CodePoint = CodePoint::from(2070u32);
    pub const SAMARITAN_MARK_IN_ALAF : CodePoint = CodePoint::from(2071u32);
    pub const SAMARITAN_MARK_OCCLUSION : CodePoint = CodePoint::from(2072u32);
    pub const SAMARITAN_MARK_DAGESH : CodePoint = CodePoint::from(2073u32);
    pub const SAMARITAN_MODIFIER_LETTER_EPENTHETIC_YUT : CodePoint = CodePoint::from(2074u32);
    pub const SAMARITAN_MARK_EPENTHETIC_YUT : CodePoint = CodePoint::from(2075u32);
    pub const SAMARITAN_VOWEL_SIGN_LONG_E : CodePoint = CodePoint::from(2076u32);
    pub const SAMARITAN_VOWEL_SIGN_E : CodePoint = CodePoint::from(2077u32);
    pub const SAMARITAN_VOWEL_SIGN_OVERLONG_AA : CodePoint = CodePoint::from(2078u32);
    pub const SAMARITAN_VOWEL_SIGN_LONG_AA : CodePoint = CodePoint::from(2079u32);
    pub const SAMARITAN_VOWEL_SIGN_AA : CodePoint = CodePoint::from(2080u32);
    pub const SAMARITAN_VOWEL_SIGN_OVERLONG_A : CodePoint = CodePoint::from(2081u32);
    pub const SAMARITAN_VOWEL_SIGN_LONG_A : CodePoint = CodePoint::from(2082u32);
    pub const SAMARITAN_VOWEL_SIGN_A : CodePoint = CodePoint::from(2083u32);
    pub const SAMARITAN_MODIFIER_LETTER_SHORT_A : CodePoint = CodePoint::from(2084u32);
    pub const SAMARITAN_VOWEL_SIGN_SHORT_A : CodePoint = CodePoint::from(2085u32);
    pub const SAMARITAN_VOWEL_SIGN_LONG_U : CodePoint = CodePoint::from(2086u32);
    pub const SAMARITAN_VOWEL_SIGN_U : CodePoint = CodePoint::from(2087u32);
    pub const SAMARITAN_MODIFIER_LETTER_I : CodePoint = CodePoint::from(2088u32);
    pub const SAMARITAN_VOWEL_SIGN_LONG_I : CodePoint = CodePoint::from(2089u32);
    pub const SAMARITAN_VOWEL_SIGN_I : CodePoint = CodePoint::from(2090u32);
    pub const SAMARITAN_VOWEL_SIGN_O : CodePoint = CodePoint::from(2091u32);
    pub const SAMARITAN_VOWEL_SIGN_SUKUN : CodePoint = CodePoint::from(2092u32);
    pub const SAMARITAN_MARK_NEQUDAA : CodePoint = CodePoint::from(2093u32);
    pub const SAMARITAN_PUNCTUATION_NEQUDAA : CodePoint = CodePoint::from(2096u32);
    pub const SAMARITAN_PUNCTUATION_AFSAAQ : CodePoint = CodePoint::from(2097u32);
    pub const SAMARITAN_PUNCTUATION_ANGED : CodePoint = CodePoint::from(2098u32);
    pub const SAMARITAN_PUNCTUATION_BAU : CodePoint = CodePoint::from(2099u32);
    pub const SAMARITAN_PUNCTUATION_ATMAAU : CodePoint = CodePoint::from(2100u32);
    pub const SAMARITAN_PUNCTUATION_SHIYYAALAA : CodePoint = CodePoint::from(2101u32);
    pub const SAMARITAN_ABBREVIATION_MARK : CodePoint = CodePoint::from(2102u32);
    pub const SAMARITAN_PUNCTUATION_MELODIC_QITSA : CodePoint = CodePoint::from(2103u32);
    pub const SAMARITAN_PUNCTUATION_ZIQAA : CodePoint = CodePoint::from(2104u32);
    pub const SAMARITAN_PUNCTUATION_QITSA : CodePoint = CodePoint::from(2105u32);
    pub const SAMARITAN_PUNCTUATION_ZAEF : CodePoint = CodePoint::from(2106u32);
    pub const SAMARITAN_PUNCTUATION_TURU : CodePoint = CodePoint::from(2107u32);
    pub const SAMARITAN_PUNCTUATION_ARKAANU : CodePoint = CodePoint::from(2108u32);
    pub const SAMARITAN_PUNCTUATION_SOF_MASHFAAT : CodePoint = CodePoint::from(2109u32);
    pub const SAMARITAN_PUNCTUATION_ANNAAU : CodePoint = CodePoint::from(2110u32);
    pub const MANDAIC_LETTER_HALQA : CodePoint = CodePoint::from(2112u32);
    pub const MANDAIC_LETTER_AB : CodePoint = CodePoint::from(2113u32);
    pub const MANDAIC_LETTER_AG : CodePoint = CodePoint::from(2114u32);
    pub const MANDAIC_LETTER_AD : CodePoint = CodePoint::from(2115u32);
    pub const MANDAIC_LETTER_AH : CodePoint = CodePoint::from(2116u32);
    pub const MANDAIC_LETTER_USHENNA : CodePoint = CodePoint::from(2117u32);
    pub const MANDAIC_LETTER_AZ : CodePoint = CodePoint::from(2118u32);
    pub const MANDAIC_LETTER_IT : CodePoint = CodePoint::from(2119u32);
    pub const MANDAIC_LETTER_ATT : CodePoint = CodePoint::from(2120u32);
    pub const MANDAIC_LETTER_AKSA : CodePoint = CodePoint::from(2121u32);
    pub const MANDAIC_LETTER_AK : CodePoint = CodePoint::from(2122u32);
    pub const MANDAIC_LETTER_AL : CodePoint = CodePoint::from(2123u32);
    pub const MANDAIC_LETTER_AM : CodePoint = CodePoint::from(2124u32);
    pub const MANDAIC_LETTER_AN : CodePoint = CodePoint::from(2125u32);
    pub const MANDAIC_LETTER_AS : CodePoint = CodePoint::from(2126u32);
    pub const MANDAIC_LETTER_IN : CodePoint = CodePoint::from(2127u32);
    pub const MANDAIC_LETTER_AP : CodePoint = CodePoint::from(2128u32);
    pub const MANDAIC_LETTER_ASZ : CodePoint = CodePoint::from(2129u32);
    pub const MANDAIC_LETTER_AQ : CodePoint = CodePoint::from(2130u32);
    pub const MANDAIC_LETTER_AR : CodePoint = CodePoint::from(2131u32);
    pub const MANDAIC_LETTER_ASH : CodePoint = CodePoint::from(2132u32);
    pub const MANDAIC_LETTER_AT : CodePoint = CodePoint::from(2133u32);
    pub const MANDAIC_LETTER_DUSHENNA : CodePoint = CodePoint::from(2134u32);
    pub const MANDAIC_LETTER_KAD : CodePoint = CodePoint::from(2135u32);
    pub const MANDAIC_LETTER_AIN : CodePoint = CodePoint::from(2136u32);
    pub const MANDAIC_AFFRICATION_MARK : CodePoint = CodePoint::from(2137u32);
    pub const MANDAIC_VOCALIZATION_MARK : CodePoint = CodePoint::from(2138u32);
    pub const MANDAIC_GEMINATION_MARK : CodePoint = CodePoint::from(2139u32);
    pub const MANDAIC_PUNCTUATION : CodePoint = CodePoint::from(2142u32);
    pub const SYRIAC_LETTER_MALAYALAM_NGA : CodePoint = CodePoint::from(2144u32);
    pub const SYRIAC_LETTER_MALAYALAM_JA : CodePoint = CodePoint::from(2145u32);
    pub const SYRIAC_LETTER_MALAYALAM_NYA : CodePoint = CodePoint::from(2146u32);
    pub const SYRIAC_LETTER_MALAYALAM_TTA : CodePoint = CodePoint::from(2147u32);
    pub const SYRIAC_LETTER_MALAYALAM_NNA : CodePoint = CodePoint::from(2148u32);
    pub const SYRIAC_LETTER_MALAYALAM_NNNA : CodePoint = CodePoint::from(2149u32);
    pub const SYRIAC_LETTER_MALAYALAM_BHA : CodePoint = CodePoint::from(2150u32);
    pub const SYRIAC_LETTER_MALAYALAM_RA : CodePoint = CodePoint::from(2151u32);
    pub const SYRIAC_LETTER_MALAYALAM_LLA : CodePoint = CodePoint::from(2152u32);
    pub const SYRIAC_LETTER_MALAYALAM_LLLA : CodePoint = CodePoint::from(2153u32);
    pub const SYRIAC_LETTER_MALAYALAM_SSA : CodePoint = CodePoint::from(2154u32);
    pub const ARABIC_LETTER_BEH_WITH_SMALL_V_BELOW : CodePoint = CodePoint::from(2208u32);
    pub const ARABIC_LETTER_BEH_WITH_HAMZA_ABOVE : CodePoint = CodePoint::from(2209u32);
    pub const ARABIC_LETTER_JEEM_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(2210u32);
    pub const ARABIC_LETTER_TAH_WITH_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(2211u32);
    pub const ARABIC_LETTER_FEH_WITH_DOT_BELOW_AND_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(2212u32);
    pub const ARABIC_LETTER_QAF_WITH_DOT_BELOW : CodePoint = CodePoint::from(2213u32);
    pub const ARABIC_LETTER_LAM_WITH_DOUBLE_BAR : CodePoint = CodePoint::from(2214u32);
    pub const ARABIC_LETTER_MEEM_WITH_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(2215u32);
    pub const ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_HAMZA_ABOVE : CodePoint = CodePoint::from(2216u32);
    pub const ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_DOT_ABOVE : CodePoint = CodePoint::from(2217u32);
    pub const ARABIC_LETTER_REH_WITH_LOOP : CodePoint = CodePoint::from(2218u32);
    pub const ARABIC_LETTER_WAW_WITH_DOT_WITHIN : CodePoint = CodePoint::from(2219u32);
    pub const ARABIC_LETTER_ROHINGYA_YEH : CodePoint = CodePoint::from(2220u32);
    pub const ARABIC_LETTER_LOW_ALEF : CodePoint = CodePoint::from(2221u32);
    pub const ARABIC_LETTER_DAL_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(2222u32);
    pub const ARABIC_LETTER_SAD_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(2223u32);
    pub const ARABIC_LETTER_GAF_WITH_INVERTED_STROKE : CodePoint = CodePoint::from(2224u32);
    pub const ARABIC_LETTER_STRAIGHT_WAW : CodePoint = CodePoint::from(2225u32);
    pub const ARABIC_LETTER_ZAIN_WITH_INVERTED_V_ABOVE : CodePoint = CodePoint::from(2226u32);
    pub const ARABIC_LETTER_AIN_WITH_THREE_DOTS_BELOW : CodePoint = CodePoint::from(2227u32);
    pub const ARABIC_LETTER_KAF_WITH_DOT_BELOW : CodePoint = CodePoint::from(2228u32);
    pub const ARABIC_LETTER_BEH_WITH_SMALL_MEEM_ABOVE : CodePoint = CodePoint::from(2230u32);
    pub const ARABIC_LETTER_PEH_WITH_SMALL_MEEM_ABOVE : CodePoint = CodePoint::from(2231u32);
    pub const ARABIC_LETTER_TEH_WITH_SMALL_TEH_ABOVE : CodePoint = CodePoint::from(2232u32);
    pub const ARABIC_LETTER_REH_WITH_SMALL_NOON_ABOVE : CodePoint = CodePoint::from(2233u32);
    pub const ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_SMALL_NOON_ABOVE : CodePoint = CodePoint::from(2234u32);
    pub const ARABIC_LETTER_AFRICAN_FEH : CodePoint = CodePoint::from(2235u32);
    pub const ARABIC_LETTER_AFRICAN_QAF : CodePoint = CodePoint::from(2236u32);
    pub const ARABIC_LETTER_AFRICAN_NOON : CodePoint = CodePoint::from(2237u32);
    pub const ARABIC_SMALL_LOW_WAW : CodePoint = CodePoint::from(2259u32);
    pub const ARABIC_SMALL_HIGH_WORD_AR_RUB : CodePoint = CodePoint::from(2260u32);
    pub const ARABIC_SMALL_HIGH_SAD : CodePoint = CodePoint::from(2261u32);
    pub const ARABIC_SMALL_HIGH_AIN : CodePoint = CodePoint::from(2262u32);
    pub const ARABIC_SMALL_HIGH_QAF : CodePoint = CodePoint::from(2263u32);
    pub const ARABIC_SMALL_HIGH_NOON_WITH_KASRA : CodePoint = CodePoint::from(2264u32);
    pub const ARABIC_SMALL_LOW_NOON_WITH_KASRA : CodePoint = CodePoint::from(2265u32);
    pub const ARABIC_SMALL_HIGH_WORD_ATH_THALATHA : CodePoint = CodePoint::from(2266u32);
    pub const ARABIC_SMALL_HIGH_WORD_AS_SAJDA : CodePoint = CodePoint::from(2267u32);
    pub const ARABIC_SMALL_HIGH_WORD_AN_NISF : CodePoint = CodePoint::from(2268u32);
    pub const ARABIC_SMALL_HIGH_WORD_SAKTA : CodePoint = CodePoint::from(2269u32);
    pub const ARABIC_SMALL_HIGH_WORD_QIF : CodePoint = CodePoint::from(2270u32);
    pub const ARABIC_SMALL_HIGH_WORD_WAQFA : CodePoint = CodePoint::from(2271u32);
    pub const ARABIC_SMALL_HIGH_FOOTNOTE_MARKER : CodePoint = CodePoint::from(2272u32);
    pub const ARABIC_SMALL_HIGH_SIGN_SAFHA : CodePoint = CodePoint::from(2273u32);
    pub const ARABIC_DISPUTED_END_OF_AYAH : CodePoint = CodePoint::from(2274u32);
    pub const ARABIC_TURNED_DAMMA_BELOW : CodePoint = CodePoint::from(2275u32);
    pub const ARABIC_CURLY_FATHA : CodePoint = CodePoint::from(2276u32);
    pub const ARABIC_CURLY_DAMMA : CodePoint = CodePoint::from(2277u32);
    pub const ARABIC_CURLY_KASRA : CodePoint = CodePoint::from(2278u32);
    pub const ARABIC_CURLY_FATHATAN : CodePoint = CodePoint::from(2279u32);
    pub const ARABIC_CURLY_DAMMATAN : CodePoint = CodePoint::from(2280u32);
    pub const ARABIC_CURLY_KASRATAN : CodePoint = CodePoint::from(2281u32);
    pub const ARABIC_TONE_ONE_DOT_ABOVE : CodePoint = CodePoint::from(2282u32);
    pub const ARABIC_TONE_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(2283u32);
    pub const ARABIC_TONE_LOOP_ABOVE : CodePoint = CodePoint::from(2284u32);
    pub const ARABIC_TONE_ONE_DOT_BELOW : CodePoint = CodePoint::from(2285u32);
    pub const ARABIC_TONE_TWO_DOTS_BELOW : CodePoint = CodePoint::from(2286u32);
    pub const ARABIC_TONE_LOOP_BELOW : CodePoint = CodePoint::from(2287u32);
    pub const ARABIC_OPEN_FATHATAN : CodePoint = CodePoint::from(2288u32);
    pub const ARABIC_OPEN_DAMMATAN : CodePoint = CodePoint::from(2289u32);
    pub const ARABIC_OPEN_KASRATAN : CodePoint = CodePoint::from(2290u32);
    pub const ARABIC_SMALL_HIGH_WAW : CodePoint = CodePoint::from(2291u32);
    pub const ARABIC_FATHA_WITH_RING : CodePoint = CodePoint::from(2292u32);
    pub const ARABIC_FATHA_WITH_DOT_ABOVE : CodePoint = CodePoint::from(2293u32);
    pub const ARABIC_KASRA_WITH_DOT_BELOW : CodePoint = CodePoint::from(2294u32);
    pub const ARABIC_LEFT_ARROWHEAD_ABOVE : CodePoint = CodePoint::from(2295u32);
    pub const ARABIC_RIGHT_ARROWHEAD_ABOVE : CodePoint = CodePoint::from(2296u32);
    pub const ARABIC_LEFT_ARROWHEAD_BELOW : CodePoint = CodePoint::from(2297u32);
    pub const ARABIC_RIGHT_ARROWHEAD_BELOW : CodePoint = CodePoint::from(2298u32);
    pub const ARABIC_DOUBLE_RIGHT_ARROWHEAD_ABOVE : CodePoint = CodePoint::from(2299u32);
    pub const ARABIC_DOUBLE_RIGHT_ARROWHEAD_ABOVE_WITH_DOT : CodePoint = CodePoint::from(2300u32);
    pub const ARABIC_RIGHT_ARROWHEAD_ABOVE_WITH_DOT : CodePoint = CodePoint::from(2301u32);
    pub const ARABIC_DAMMA_WITH_DOT : CodePoint = CodePoint::from(2302u32);
    pub const ARABIC_MARK_SIDEWAYS_NOON_GHUNNA : CodePoint = CodePoint::from(2303u32);
    pub const DEVANAGARI_SIGN_INVERTED_CANDRABINDU : CodePoint = CodePoint::from(2304u32);
    pub const DEVANAGARI_SIGN_CANDRABINDU : CodePoint = CodePoint::from(2305u32);
    pub const DEVANAGARI_SIGN_ANUSVARA : CodePoint = CodePoint::from(2306u32);
    pub const DEVANAGARI_SIGN_VISARGA : CodePoint = CodePoint::from(2307u32);
    pub const DEVANAGARI_LETTER_SHORT_A : CodePoint = CodePoint::from(2308u32);
    pub const DEVANAGARI_LETTER_A : CodePoint = CodePoint::from(2309u32);
    pub const DEVANAGARI_LETTER_AA : CodePoint = CodePoint::from(2310u32);
    pub const DEVANAGARI_LETTER_I : CodePoint = CodePoint::from(2311u32);
    pub const DEVANAGARI_LETTER_II : CodePoint = CodePoint::from(2312u32);
    pub const DEVANAGARI_LETTER_U : CodePoint = CodePoint::from(2313u32);
    pub const DEVANAGARI_LETTER_UU : CodePoint = CodePoint::from(2314u32);
    pub const DEVANAGARI_LETTER_VOCALIC_R : CodePoint = CodePoint::from(2315u32);
    pub const DEVANAGARI_LETTER_VOCALIC_L : CodePoint = CodePoint::from(2316u32);
    pub const DEVANAGARI_LETTER_CANDRA_E : CodePoint = CodePoint::from(2317u32);
    pub const DEVANAGARI_LETTER_SHORT_E : CodePoint = CodePoint::from(2318u32);
    pub const DEVANAGARI_LETTER_E : CodePoint = CodePoint::from(2319u32);
    pub const DEVANAGARI_LETTER_AI : CodePoint = CodePoint::from(2320u32);
    pub const DEVANAGARI_LETTER_CANDRA_O : CodePoint = CodePoint::from(2321u32);
    pub const DEVANAGARI_LETTER_SHORT_O : CodePoint = CodePoint::from(2322u32);
    pub const DEVANAGARI_LETTER_O : CodePoint = CodePoint::from(2323u32);
    pub const DEVANAGARI_LETTER_AU : CodePoint = CodePoint::from(2324u32);
    pub const DEVANAGARI_LETTER_KA : CodePoint = CodePoint::from(2325u32);
    pub const DEVANAGARI_LETTER_KHA : CodePoint = CodePoint::from(2326u32);
    pub const DEVANAGARI_LETTER_GA : CodePoint = CodePoint::from(2327u32);
    pub const DEVANAGARI_LETTER_GHA : CodePoint = CodePoint::from(2328u32);
    pub const DEVANAGARI_LETTER_NGA : CodePoint = CodePoint::from(2329u32);
    pub const DEVANAGARI_LETTER_CA : CodePoint = CodePoint::from(2330u32);
    pub const DEVANAGARI_LETTER_CHA : CodePoint = CodePoint::from(2331u32);
    pub const DEVANAGARI_LETTER_JA : CodePoint = CodePoint::from(2332u32);
    pub const DEVANAGARI_LETTER_JHA : CodePoint = CodePoint::from(2333u32);
    pub const DEVANAGARI_LETTER_NYA : CodePoint = CodePoint::from(2334u32);
    pub const DEVANAGARI_LETTER_TTA : CodePoint = CodePoint::from(2335u32);
    pub const DEVANAGARI_LETTER_TTHA : CodePoint = CodePoint::from(2336u32);
    pub const DEVANAGARI_LETTER_DDA : CodePoint = CodePoint::from(2337u32);
    pub const DEVANAGARI_LETTER_DDHA : CodePoint = CodePoint::from(2338u32);
    pub const DEVANAGARI_LETTER_NNA : CodePoint = CodePoint::from(2339u32);
    pub const DEVANAGARI_LETTER_TA : CodePoint = CodePoint::from(2340u32);
    pub const DEVANAGARI_LETTER_THA : CodePoint = CodePoint::from(2341u32);
    pub const DEVANAGARI_LETTER_DA : CodePoint = CodePoint::from(2342u32);
    pub const DEVANAGARI_LETTER_DHA : CodePoint = CodePoint::from(2343u32);
    pub const DEVANAGARI_LETTER_NA : CodePoint = CodePoint::from(2344u32);
    pub const DEVANAGARI_LETTER_NNNA : CodePoint = CodePoint::from(2345u32);
    pub const DEVANAGARI_LETTER_PA : CodePoint = CodePoint::from(2346u32);
    pub const DEVANAGARI_LETTER_PHA : CodePoint = CodePoint::from(2347u32);
    pub const DEVANAGARI_LETTER_BA : CodePoint = CodePoint::from(2348u32);
    pub const DEVANAGARI_LETTER_BHA : CodePoint = CodePoint::from(2349u32);
    pub const DEVANAGARI_LETTER_MA : CodePoint = CodePoint::from(2350u32);
    pub const DEVANAGARI_LETTER_YA : CodePoint = CodePoint::from(2351u32);
    pub const DEVANAGARI_LETTER_RA : CodePoint = CodePoint::from(2352u32);
    pub const DEVANAGARI_LETTER_RRA : CodePoint = CodePoint::from(2353u32);
    pub const DEVANAGARI_LETTER_LA : CodePoint = CodePoint::from(2354u32);
    pub const DEVANAGARI_LETTER_LLA : CodePoint = CodePoint::from(2355u32);
    pub const DEVANAGARI_LETTER_LLLA : CodePoint = CodePoint::from(2356u32);
    pub const DEVANAGARI_LETTER_VA : CodePoint = CodePoint::from(2357u32);
    pub const DEVANAGARI_LETTER_SHA : CodePoint = CodePoint::from(2358u32);
    pub const DEVANAGARI_LETTER_SSA : CodePoint = CodePoint::from(2359u32);
    pub const DEVANAGARI_LETTER_SA : CodePoint = CodePoint::from(2360u32);
    pub const DEVANAGARI_LETTER_HA : CodePoint = CodePoint::from(2361u32);
    pub const DEVANAGARI_VOWEL_SIGN_OE : CodePoint = CodePoint::from(2362u32);
    pub const DEVANAGARI_VOWEL_SIGN_OOE : CodePoint = CodePoint::from(2363u32);
    pub const DEVANAGARI_SIGN_NUKTA : CodePoint = CodePoint::from(2364u32);
    pub const DEVANAGARI_SIGN_AVAGRAHA : CodePoint = CodePoint::from(2365u32);
    pub const DEVANAGARI_VOWEL_SIGN_AA : CodePoint = CodePoint::from(2366u32);
    pub const DEVANAGARI_VOWEL_SIGN_I : CodePoint = CodePoint::from(2367u32);
    pub const DEVANAGARI_VOWEL_SIGN_II : CodePoint = CodePoint::from(2368u32);
    pub const DEVANAGARI_VOWEL_SIGN_U : CodePoint = CodePoint::from(2369u32);
    pub const DEVANAGARI_VOWEL_SIGN_UU : CodePoint = CodePoint::from(2370u32);
    pub const DEVANAGARI_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(2371u32);
    pub const DEVANAGARI_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(2372u32);
    pub const DEVANAGARI_VOWEL_SIGN_CANDRA_E : CodePoint = CodePoint::from(2373u32);
    pub const DEVANAGARI_VOWEL_SIGN_SHORT_E : CodePoint = CodePoint::from(2374u32);
    pub const DEVANAGARI_VOWEL_SIGN_E : CodePoint = CodePoint::from(2375u32);
    pub const DEVANAGARI_VOWEL_SIGN_AI : CodePoint = CodePoint::from(2376u32);
    pub const DEVANAGARI_VOWEL_SIGN_CANDRA_O : CodePoint = CodePoint::from(2377u32);
    pub const DEVANAGARI_VOWEL_SIGN_SHORT_O : CodePoint = CodePoint::from(2378u32);
    pub const DEVANAGARI_VOWEL_SIGN_O : CodePoint = CodePoint::from(2379u32);
    pub const DEVANAGARI_VOWEL_SIGN_AU : CodePoint = CodePoint::from(2380u32);
    pub const DEVANAGARI_SIGN_VIRAMA : CodePoint = CodePoint::from(2381u32);
    pub const DEVANAGARI_VOWEL_SIGN_PRISHTHAMATRA_E : CodePoint = CodePoint::from(2382u32);
    pub const DEVANAGARI_VOWEL_SIGN_AW : CodePoint = CodePoint::from(2383u32);
    pub const DEVANAGARI_OM : CodePoint = CodePoint::from(2384u32);
    pub const DEVANAGARI_STRESS_SIGN_UDATTA : CodePoint = CodePoint::from(2385u32);
    pub const DEVANAGARI_STRESS_SIGN_ANUDATTA : CodePoint = CodePoint::from(2386u32);
    pub const DEVANAGARI_GRAVE_ACCENT : CodePoint = CodePoint::from(2387u32);
    pub const DEVANAGARI_ACUTE_ACCENT : CodePoint = CodePoint::from(2388u32);
    pub const DEVANAGARI_VOWEL_SIGN_CANDRA_LONG_E : CodePoint = CodePoint::from(2389u32);
    pub const DEVANAGARI_VOWEL_SIGN_UE : CodePoint = CodePoint::from(2390u32);
    pub const DEVANAGARI_VOWEL_SIGN_UUE : CodePoint = CodePoint::from(2391u32);
    pub const DEVANAGARI_LETTER_QA : CodePoint = CodePoint::from(2392u32);
    pub const DEVANAGARI_LETTER_KHHA : CodePoint = CodePoint::from(2393u32);
    pub const DEVANAGARI_LETTER_GHHA : CodePoint = CodePoint::from(2394u32);
    pub const DEVANAGARI_LETTER_ZA : CodePoint = CodePoint::from(2395u32);
    pub const DEVANAGARI_LETTER_DDDHA : CodePoint = CodePoint::from(2396u32);
    pub const DEVANAGARI_LETTER_RHA : CodePoint = CodePoint::from(2397u32);
    pub const DEVANAGARI_LETTER_FA : CodePoint = CodePoint::from(2398u32);
    pub const DEVANAGARI_LETTER_YYA : CodePoint = CodePoint::from(2399u32);
    pub const DEVANAGARI_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(2400u32);
    pub const DEVANAGARI_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(2401u32);
    pub const DEVANAGARI_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(2402u32);
    pub const DEVANAGARI_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(2403u32);
    pub const DEVANAGARI_DANDA : CodePoint = CodePoint::from(2404u32);
    pub const DEVANAGARI_DOUBLE_DANDA : CodePoint = CodePoint::from(2405u32);
    pub const DEVANAGARI_DIGIT_ZERO : CodePoint = CodePoint::from(2406u32);
    pub const DEVANAGARI_DIGIT_ONE : CodePoint = CodePoint::from(2407u32);
    pub const DEVANAGARI_DIGIT_TWO : CodePoint = CodePoint::from(2408u32);
    pub const DEVANAGARI_DIGIT_THREE : CodePoint = CodePoint::from(2409u32);
    pub const DEVANAGARI_DIGIT_FOUR : CodePoint = CodePoint::from(2410u32);
    pub const DEVANAGARI_DIGIT_FIVE : CodePoint = CodePoint::from(2411u32);
    pub const DEVANAGARI_DIGIT_SIX : CodePoint = CodePoint::from(2412u32);
    pub const DEVANAGARI_DIGIT_SEVEN : CodePoint = CodePoint::from(2413u32);
    pub const DEVANAGARI_DIGIT_EIGHT : CodePoint = CodePoint::from(2414u32);
    pub const DEVANAGARI_DIGIT_NINE : CodePoint = CodePoint::from(2415u32);
    pub const DEVANAGARI_ABBREVIATION_SIGN : CodePoint = CodePoint::from(2416u32);
    pub const DEVANAGARI_SIGN_HIGH_SPACING_DOT : CodePoint = CodePoint::from(2417u32);
    pub const DEVANAGARI_LETTER_CANDRA_A : CodePoint = CodePoint::from(2418u32);
    pub const DEVANAGARI_LETTER_OE : CodePoint = CodePoint::from(2419u32);
    pub const DEVANAGARI_LETTER_OOE : CodePoint = CodePoint::from(2420u32);
    pub const DEVANAGARI_LETTER_AW : CodePoint = CodePoint::from(2421u32);
    pub const DEVANAGARI_LETTER_UE : CodePoint = CodePoint::from(2422u32);
    pub const DEVANAGARI_LETTER_UUE : CodePoint = CodePoint::from(2423u32);
    pub const DEVANAGARI_LETTER_MARWARI_DDA : CodePoint = CodePoint::from(2424u32);
    pub const DEVANAGARI_LETTER_ZHA : CodePoint = CodePoint::from(2425u32);
    pub const DEVANAGARI_LETTER_HEAVY_YA : CodePoint = CodePoint::from(2426u32);
    pub const DEVANAGARI_LETTER_GGA : CodePoint = CodePoint::from(2427u32);
    pub const DEVANAGARI_LETTER_JJA : CodePoint = CodePoint::from(2428u32);
    pub const DEVANAGARI_LETTER_GLOTTAL_STOP : CodePoint = CodePoint::from(2429u32);
    pub const DEVANAGARI_LETTER_DDDA : CodePoint = CodePoint::from(2430u32);
    pub const DEVANAGARI_LETTER_BBA : CodePoint = CodePoint::from(2431u32);
    pub const BENGALI_ANJI : CodePoint = CodePoint::from(2432u32);
    pub const BENGALI_SIGN_CANDRABINDU : CodePoint = CodePoint::from(2433u32);
    pub const BENGALI_SIGN_ANUSVARA : CodePoint = CodePoint::from(2434u32);
    pub const BENGALI_SIGN_VISARGA : CodePoint = CodePoint::from(2435u32);
    pub const BENGALI_LETTER_A : CodePoint = CodePoint::from(2437u32);
    pub const BENGALI_LETTER_AA : CodePoint = CodePoint::from(2438u32);
    pub const BENGALI_LETTER_I : CodePoint = CodePoint::from(2439u32);
    pub const BENGALI_LETTER_II : CodePoint = CodePoint::from(2440u32);
    pub const BENGALI_LETTER_U : CodePoint = CodePoint::from(2441u32);
    pub const BENGALI_LETTER_UU : CodePoint = CodePoint::from(2442u32);
    pub const BENGALI_LETTER_VOCALIC_R : CodePoint = CodePoint::from(2443u32);
    pub const BENGALI_LETTER_VOCALIC_L : CodePoint = CodePoint::from(2444u32);
    pub const BENGALI_LETTER_E : CodePoint = CodePoint::from(2447u32);
    pub const BENGALI_LETTER_AI : CodePoint = CodePoint::from(2448u32);
    pub const BENGALI_LETTER_O : CodePoint = CodePoint::from(2451u32);
    pub const BENGALI_LETTER_AU : CodePoint = CodePoint::from(2452u32);
    pub const BENGALI_LETTER_KA : CodePoint = CodePoint::from(2453u32);
    pub const BENGALI_LETTER_KHA : CodePoint = CodePoint::from(2454u32);
    pub const BENGALI_LETTER_GA : CodePoint = CodePoint::from(2455u32);
    pub const BENGALI_LETTER_GHA : CodePoint = CodePoint::from(2456u32);
    pub const BENGALI_LETTER_NGA : CodePoint = CodePoint::from(2457u32);
    pub const BENGALI_LETTER_CA : CodePoint = CodePoint::from(2458u32);
    pub const BENGALI_LETTER_CHA : CodePoint = CodePoint::from(2459u32);
    pub const BENGALI_LETTER_JA : CodePoint = CodePoint::from(2460u32);
    pub const BENGALI_LETTER_JHA : CodePoint = CodePoint::from(2461u32);
    pub const BENGALI_LETTER_NYA : CodePoint = CodePoint::from(2462u32);
    pub const BENGALI_LETTER_TTA : CodePoint = CodePoint::from(2463u32);
    pub const BENGALI_LETTER_TTHA : CodePoint = CodePoint::from(2464u32);
    pub const BENGALI_LETTER_DDA : CodePoint = CodePoint::from(2465u32);
    pub const BENGALI_LETTER_DDHA : CodePoint = CodePoint::from(2466u32);
    pub const BENGALI_LETTER_NNA : CodePoint = CodePoint::from(2467u32);
    pub const BENGALI_LETTER_TA : CodePoint = CodePoint::from(2468u32);
    pub const BENGALI_LETTER_THA : CodePoint = CodePoint::from(2469u32);
    pub const BENGALI_LETTER_DA : CodePoint = CodePoint::from(2470u32);
    pub const BENGALI_LETTER_DHA : CodePoint = CodePoint::from(2471u32);
    pub const BENGALI_LETTER_NA : CodePoint = CodePoint::from(2472u32);
    pub const BENGALI_LETTER_PA : CodePoint = CodePoint::from(2474u32);
    pub const BENGALI_LETTER_PHA : CodePoint = CodePoint::from(2475u32);
    pub const BENGALI_LETTER_BA : CodePoint = CodePoint::from(2476u32);
    pub const BENGALI_LETTER_BHA : CodePoint = CodePoint::from(2477u32);
    pub const BENGALI_LETTER_MA : CodePoint = CodePoint::from(2478u32);
    pub const BENGALI_LETTER_YA : CodePoint = CodePoint::from(2479u32);
    pub const BENGALI_LETTER_RA : CodePoint = CodePoint::from(2480u32);
    pub const BENGALI_LETTER_LA : CodePoint = CodePoint::from(2482u32);
    pub const BENGALI_LETTER_SHA : CodePoint = CodePoint::from(2486u32);
    pub const BENGALI_LETTER_SSA : CodePoint = CodePoint::from(2487u32);
    pub const BENGALI_LETTER_SA : CodePoint = CodePoint::from(2488u32);
    pub const BENGALI_LETTER_HA : CodePoint = CodePoint::from(2489u32);
    pub const BENGALI_SIGN_NUKTA : CodePoint = CodePoint::from(2492u32);
    pub const BENGALI_SIGN_AVAGRAHA : CodePoint = CodePoint::from(2493u32);
    pub const BENGALI_VOWEL_SIGN_AA : CodePoint = CodePoint::from(2494u32);
    pub const BENGALI_VOWEL_SIGN_I : CodePoint = CodePoint::from(2495u32);
    pub const BENGALI_VOWEL_SIGN_II : CodePoint = CodePoint::from(2496u32);
    pub const BENGALI_VOWEL_SIGN_U : CodePoint = CodePoint::from(2497u32);
    pub const BENGALI_VOWEL_SIGN_UU : CodePoint = CodePoint::from(2498u32);
    pub const BENGALI_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(2499u32);
    pub const BENGALI_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(2500u32);
    pub const BENGALI_VOWEL_SIGN_E : CodePoint = CodePoint::from(2503u32);
    pub const BENGALI_VOWEL_SIGN_AI : CodePoint = CodePoint::from(2504u32);
    pub const BENGALI_VOWEL_SIGN_O : CodePoint = CodePoint::from(2507u32);
    pub const BENGALI_VOWEL_SIGN_AU : CodePoint = CodePoint::from(2508u32);
    pub const BENGALI_SIGN_VIRAMA : CodePoint = CodePoint::from(2509u32);
    pub const BENGALI_LETTER_KHANDA_TA : CodePoint = CodePoint::from(2510u32);
    pub const BENGALI_AU_LENGTH_MARK : CodePoint = CodePoint::from(2519u32);
    pub const BENGALI_LETTER_RRA : CodePoint = CodePoint::from(2524u32);
    pub const BENGALI_LETTER_RHA : CodePoint = CodePoint::from(2525u32);
    pub const BENGALI_LETTER_YYA : CodePoint = CodePoint::from(2527u32);
    pub const BENGALI_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(2528u32);
    pub const BENGALI_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(2529u32);
    pub const BENGALI_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(2530u32);
    pub const BENGALI_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(2531u32);
    pub const BENGALI_DIGIT_ZERO : CodePoint = CodePoint::from(2534u32);
    pub const BENGALI_DIGIT_ONE : CodePoint = CodePoint::from(2535u32);
    pub const BENGALI_DIGIT_TWO : CodePoint = CodePoint::from(2536u32);
    pub const BENGALI_DIGIT_THREE : CodePoint = CodePoint::from(2537u32);
    pub const BENGALI_DIGIT_FOUR : CodePoint = CodePoint::from(2538u32);
    pub const BENGALI_DIGIT_FIVE : CodePoint = CodePoint::from(2539u32);
    pub const BENGALI_DIGIT_SIX : CodePoint = CodePoint::from(2540u32);
    pub const BENGALI_DIGIT_SEVEN : CodePoint = CodePoint::from(2541u32);
    pub const BENGALI_DIGIT_EIGHT : CodePoint = CodePoint::from(2542u32);
    pub const BENGALI_DIGIT_NINE : CodePoint = CodePoint::from(2543u32);
    pub const BENGALI_LETTER_RA_WITH_MIDDLE_DIAGONAL : CodePoint = CodePoint::from(2544u32);
    pub const BENGALI_LETTER_RA_WITH_LOWER_DIAGONAL : CodePoint = CodePoint::from(2545u32);
    pub const BENGALI_RUPEE_MARK : CodePoint = CodePoint::from(2546u32);
    pub const BENGALI_RUPEE_SIGN : CodePoint = CodePoint::from(2547u32);
    pub const BENGALI_CURRENCY_NUMERATOR_ONE : CodePoint = CodePoint::from(2548u32);
    pub const BENGALI_CURRENCY_NUMERATOR_TWO : CodePoint = CodePoint::from(2549u32);
    pub const BENGALI_CURRENCY_NUMERATOR_THREE : CodePoint = CodePoint::from(2550u32);
    pub const BENGALI_CURRENCY_NUMERATOR_FOUR : CodePoint = CodePoint::from(2551u32);
    pub const BENGALI_CURRENCY_NUMERATOR_ONE_LESS_THAN_THE_DENOMINATOR : CodePoint = CodePoint::from(2552u32);
    pub const BENGALI_CURRENCY_DENOMINATOR_SIXTEEN : CodePoint = CodePoint::from(2553u32);
    pub const BENGALI_ISSHAR : CodePoint = CodePoint::from(2554u32);
    pub const BENGALI_GANDA_MARK : CodePoint = CodePoint::from(2555u32);
    pub const BENGALI_LETTER_VEDIC_ANUSVARA : CodePoint = CodePoint::from(2556u32);
    pub const BENGALI_ABBREVIATION_SIGN : CodePoint = CodePoint::from(2557u32);
    pub const BENGALI_SANDHI_MARK : CodePoint = CodePoint::from(2558u32);
    pub const GURMUKHI_SIGN_ADAK_BINDI : CodePoint = CodePoint::from(2561u32);
    pub const GURMUKHI_SIGN_BINDI : CodePoint = CodePoint::from(2562u32);
    pub const GURMUKHI_SIGN_VISARGA : CodePoint = CodePoint::from(2563u32);
    pub const GURMUKHI_LETTER_A : CodePoint = CodePoint::from(2565u32);
    pub const GURMUKHI_LETTER_AA : CodePoint = CodePoint::from(2566u32);
    pub const GURMUKHI_LETTER_I : CodePoint = CodePoint::from(2567u32);
    pub const GURMUKHI_LETTER_II : CodePoint = CodePoint::from(2568u32);
    pub const GURMUKHI_LETTER_U : CodePoint = CodePoint::from(2569u32);
    pub const GURMUKHI_LETTER_UU : CodePoint = CodePoint::from(2570u32);
    pub const GURMUKHI_LETTER_EE : CodePoint = CodePoint::from(2575u32);
    pub const GURMUKHI_LETTER_AI : CodePoint = CodePoint::from(2576u32);
    pub const GURMUKHI_LETTER_OO : CodePoint = CodePoint::from(2579u32);
    pub const GURMUKHI_LETTER_AU : CodePoint = CodePoint::from(2580u32);
    pub const GURMUKHI_LETTER_KA : CodePoint = CodePoint::from(2581u32);
    pub const GURMUKHI_LETTER_KHA : CodePoint = CodePoint::from(2582u32);
    pub const GURMUKHI_LETTER_GA : CodePoint = CodePoint::from(2583u32);
    pub const GURMUKHI_LETTER_GHA : CodePoint = CodePoint::from(2584u32);
    pub const GURMUKHI_LETTER_NGA : CodePoint = CodePoint::from(2585u32);
    pub const GURMUKHI_LETTER_CA : CodePoint = CodePoint::from(2586u32);
    pub const GURMUKHI_LETTER_CHA : CodePoint = CodePoint::from(2587u32);
    pub const GURMUKHI_LETTER_JA : CodePoint = CodePoint::from(2588u32);
    pub const GURMUKHI_LETTER_JHA : CodePoint = CodePoint::from(2589u32);
    pub const GURMUKHI_LETTER_NYA : CodePoint = CodePoint::from(2590u32);
    pub const GURMUKHI_LETTER_TTA : CodePoint = CodePoint::from(2591u32);
    pub const GURMUKHI_LETTER_TTHA : CodePoint = CodePoint::from(2592u32);
    pub const GURMUKHI_LETTER_DDA : CodePoint = CodePoint::from(2593u32);
    pub const GURMUKHI_LETTER_DDHA : CodePoint = CodePoint::from(2594u32);
    pub const GURMUKHI_LETTER_NNA : CodePoint = CodePoint::from(2595u32);
    pub const GURMUKHI_LETTER_TA : CodePoint = CodePoint::from(2596u32);
    pub const GURMUKHI_LETTER_THA : CodePoint = CodePoint::from(2597u32);
    pub const GURMUKHI_LETTER_DA : CodePoint = CodePoint::from(2598u32);
    pub const GURMUKHI_LETTER_DHA : CodePoint = CodePoint::from(2599u32);
    pub const GURMUKHI_LETTER_NA : CodePoint = CodePoint::from(2600u32);
    pub const GURMUKHI_LETTER_PA : CodePoint = CodePoint::from(2602u32);
    pub const GURMUKHI_LETTER_PHA : CodePoint = CodePoint::from(2603u32);
    pub const GURMUKHI_LETTER_BA : CodePoint = CodePoint::from(2604u32);
    pub const GURMUKHI_LETTER_BHA : CodePoint = CodePoint::from(2605u32);
    pub const GURMUKHI_LETTER_MA : CodePoint = CodePoint::from(2606u32);
    pub const GURMUKHI_LETTER_YA : CodePoint = CodePoint::from(2607u32);
    pub const GURMUKHI_LETTER_RA : CodePoint = CodePoint::from(2608u32);
    pub const GURMUKHI_LETTER_LA : CodePoint = CodePoint::from(2610u32);
    pub const GURMUKHI_LETTER_LLA : CodePoint = CodePoint::from(2611u32);
    pub const GURMUKHI_LETTER_VA : CodePoint = CodePoint::from(2613u32);
    pub const GURMUKHI_LETTER_SHA : CodePoint = CodePoint::from(2614u32);
    pub const GURMUKHI_LETTER_SA : CodePoint = CodePoint::from(2616u32);
    pub const GURMUKHI_LETTER_HA : CodePoint = CodePoint::from(2617u32);
    pub const GURMUKHI_SIGN_NUKTA : CodePoint = CodePoint::from(2620u32);
    pub const GURMUKHI_VOWEL_SIGN_AA : CodePoint = CodePoint::from(2622u32);
    pub const GURMUKHI_VOWEL_SIGN_I : CodePoint = CodePoint::from(2623u32);
    pub const GURMUKHI_VOWEL_SIGN_II : CodePoint = CodePoint::from(2624u32);
    pub const GURMUKHI_VOWEL_SIGN_U : CodePoint = CodePoint::from(2625u32);
    pub const GURMUKHI_VOWEL_SIGN_UU : CodePoint = CodePoint::from(2626u32);
    pub const GURMUKHI_VOWEL_SIGN_EE : CodePoint = CodePoint::from(2631u32);
    pub const GURMUKHI_VOWEL_SIGN_AI : CodePoint = CodePoint::from(2632u32);
    pub const GURMUKHI_VOWEL_SIGN_OO : CodePoint = CodePoint::from(2635u32);
    pub const GURMUKHI_VOWEL_SIGN_AU : CodePoint = CodePoint::from(2636u32);
    pub const GURMUKHI_SIGN_VIRAMA : CodePoint = CodePoint::from(2637u32);
    pub const GURMUKHI_SIGN_UDAAT : CodePoint = CodePoint::from(2641u32);
    pub const GURMUKHI_LETTER_KHHA : CodePoint = CodePoint::from(2649u32);
    pub const GURMUKHI_LETTER_GHHA : CodePoint = CodePoint::from(2650u32);
    pub const GURMUKHI_LETTER_ZA : CodePoint = CodePoint::from(2651u32);
    pub const GURMUKHI_LETTER_RRA : CodePoint = CodePoint::from(2652u32);
    pub const GURMUKHI_LETTER_FA : CodePoint = CodePoint::from(2654u32);
    pub const GURMUKHI_DIGIT_ZERO : CodePoint = CodePoint::from(2662u32);
    pub const GURMUKHI_DIGIT_ONE : CodePoint = CodePoint::from(2663u32);
    pub const GURMUKHI_DIGIT_TWO : CodePoint = CodePoint::from(2664u32);
    pub const GURMUKHI_DIGIT_THREE : CodePoint = CodePoint::from(2665u32);
    pub const GURMUKHI_DIGIT_FOUR : CodePoint = CodePoint::from(2666u32);
    pub const GURMUKHI_DIGIT_FIVE : CodePoint = CodePoint::from(2667u32);
    pub const GURMUKHI_DIGIT_SIX : CodePoint = CodePoint::from(2668u32);
    pub const GURMUKHI_DIGIT_SEVEN : CodePoint = CodePoint::from(2669u32);
    pub const GURMUKHI_DIGIT_EIGHT : CodePoint = CodePoint::from(2670u32);
    pub const GURMUKHI_DIGIT_NINE : CodePoint = CodePoint::from(2671u32);
    pub const GURMUKHI_TIPPI : CodePoint = CodePoint::from(2672u32);
    pub const GURMUKHI_ADDAK : CodePoint = CodePoint::from(2673u32);
    pub const GURMUKHI_IRI : CodePoint = CodePoint::from(2674u32);
    pub const GURMUKHI_URA : CodePoint = CodePoint::from(2675u32);
    pub const GURMUKHI_EK_ONKAR : CodePoint = CodePoint::from(2676u32);
    pub const GURMUKHI_SIGN_YAKASH : CodePoint = CodePoint::from(2677u32);
    pub const GURMUKHI_ABBREVIATION_SIGN : CodePoint = CodePoint::from(2678u32);
    pub const GUJARATI_SIGN_CANDRABINDU : CodePoint = CodePoint::from(2689u32);
    pub const GUJARATI_SIGN_ANUSVARA : CodePoint = CodePoint::from(2690u32);
    pub const GUJARATI_SIGN_VISARGA : CodePoint = CodePoint::from(2691u32);
    pub const GUJARATI_LETTER_A : CodePoint = CodePoint::from(2693u32);
    pub const GUJARATI_LETTER_AA : CodePoint = CodePoint::from(2694u32);
    pub const GUJARATI_LETTER_I : CodePoint = CodePoint::from(2695u32);
    pub const GUJARATI_LETTER_II : CodePoint = CodePoint::from(2696u32);
    pub const GUJARATI_LETTER_U : CodePoint = CodePoint::from(2697u32);
    pub const GUJARATI_LETTER_UU : CodePoint = CodePoint::from(2698u32);
    pub const GUJARATI_LETTER_VOCALIC_R : CodePoint = CodePoint::from(2699u32);
    pub const GUJARATI_LETTER_VOCALIC_L : CodePoint = CodePoint::from(2700u32);
    pub const GUJARATI_VOWEL_CANDRA_E : CodePoint = CodePoint::from(2701u32);
    pub const GUJARATI_LETTER_E : CodePoint = CodePoint::from(2703u32);
    pub const GUJARATI_LETTER_AI : CodePoint = CodePoint::from(2704u32);
    pub const GUJARATI_VOWEL_CANDRA_O : CodePoint = CodePoint::from(2705u32);
    pub const GUJARATI_LETTER_O : CodePoint = CodePoint::from(2707u32);
    pub const GUJARATI_LETTER_AU : CodePoint = CodePoint::from(2708u32);
    pub const GUJARATI_LETTER_KA : CodePoint = CodePoint::from(2709u32);
    pub const GUJARATI_LETTER_KHA : CodePoint = CodePoint::from(2710u32);
    pub const GUJARATI_LETTER_GA : CodePoint = CodePoint::from(2711u32);
    pub const GUJARATI_LETTER_GHA : CodePoint = CodePoint::from(2712u32);
    pub const GUJARATI_LETTER_NGA : CodePoint = CodePoint::from(2713u32);
    pub const GUJARATI_LETTER_CA : CodePoint = CodePoint::from(2714u32);
    pub const GUJARATI_LETTER_CHA : CodePoint = CodePoint::from(2715u32);
    pub const GUJARATI_LETTER_JA : CodePoint = CodePoint::from(2716u32);
    pub const GUJARATI_LETTER_JHA : CodePoint = CodePoint::from(2717u32);
    pub const GUJARATI_LETTER_NYA : CodePoint = CodePoint::from(2718u32);
    pub const GUJARATI_LETTER_TTA : CodePoint = CodePoint::from(2719u32);
    pub const GUJARATI_LETTER_TTHA : CodePoint = CodePoint::from(2720u32);
    pub const GUJARATI_LETTER_DDA : CodePoint = CodePoint::from(2721u32);
    pub const GUJARATI_LETTER_DDHA : CodePoint = CodePoint::from(2722u32);
    pub const GUJARATI_LETTER_NNA : CodePoint = CodePoint::from(2723u32);
    pub const GUJARATI_LETTER_TA : CodePoint = CodePoint::from(2724u32);
    pub const GUJARATI_LETTER_THA : CodePoint = CodePoint::from(2725u32);
    pub const GUJARATI_LETTER_DA : CodePoint = CodePoint::from(2726u32);
    pub const GUJARATI_LETTER_DHA : CodePoint = CodePoint::from(2727u32);
    pub const GUJARATI_LETTER_NA : CodePoint = CodePoint::from(2728u32);
    pub const GUJARATI_LETTER_PA : CodePoint = CodePoint::from(2730u32);
    pub const GUJARATI_LETTER_PHA : CodePoint = CodePoint::from(2731u32);
    pub const GUJARATI_LETTER_BA : CodePoint = CodePoint::from(2732u32);
    pub const GUJARATI_LETTER_BHA : CodePoint = CodePoint::from(2733u32);
    pub const GUJARATI_LETTER_MA : CodePoint = CodePoint::from(2734u32);
    pub const GUJARATI_LETTER_YA : CodePoint = CodePoint::from(2735u32);
    pub const GUJARATI_LETTER_RA : CodePoint = CodePoint::from(2736u32);
    pub const GUJARATI_LETTER_LA : CodePoint = CodePoint::from(2738u32);
    pub const GUJARATI_LETTER_LLA : CodePoint = CodePoint::from(2739u32);
    pub const GUJARATI_LETTER_VA : CodePoint = CodePoint::from(2741u32);
    pub const GUJARATI_LETTER_SHA : CodePoint = CodePoint::from(2742u32);
    pub const GUJARATI_LETTER_SSA : CodePoint = CodePoint::from(2743u32);
    pub const GUJARATI_LETTER_SA : CodePoint = CodePoint::from(2744u32);
    pub const GUJARATI_LETTER_HA : CodePoint = CodePoint::from(2745u32);
    pub const GUJARATI_SIGN_NUKTA : CodePoint = CodePoint::from(2748u32);
    pub const GUJARATI_SIGN_AVAGRAHA : CodePoint = CodePoint::from(2749u32);
    pub const GUJARATI_VOWEL_SIGN_AA : CodePoint = CodePoint::from(2750u32);
    pub const GUJARATI_VOWEL_SIGN_I : CodePoint = CodePoint::from(2751u32);
    pub const GUJARATI_VOWEL_SIGN_II : CodePoint = CodePoint::from(2752u32);
    pub const GUJARATI_VOWEL_SIGN_U : CodePoint = CodePoint::from(2753u32);
    pub const GUJARATI_VOWEL_SIGN_UU : CodePoint = CodePoint::from(2754u32);
    pub const GUJARATI_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(2755u32);
    pub const GUJARATI_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(2756u32);
    pub const GUJARATI_VOWEL_SIGN_CANDRA_E : CodePoint = CodePoint::from(2757u32);
    pub const GUJARATI_VOWEL_SIGN_E : CodePoint = CodePoint::from(2759u32);
    pub const GUJARATI_VOWEL_SIGN_AI : CodePoint = CodePoint::from(2760u32);
    pub const GUJARATI_VOWEL_SIGN_CANDRA_O : CodePoint = CodePoint::from(2761u32);
    pub const GUJARATI_VOWEL_SIGN_O : CodePoint = CodePoint::from(2763u32);
    pub const GUJARATI_VOWEL_SIGN_AU : CodePoint = CodePoint::from(2764u32);
    pub const GUJARATI_SIGN_VIRAMA : CodePoint = CodePoint::from(2765u32);
    pub const GUJARATI_OM : CodePoint = CodePoint::from(2768u32);
    pub const GUJARATI_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(2784u32);
    pub const GUJARATI_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(2785u32);
    pub const GUJARATI_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(2786u32);
    pub const GUJARATI_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(2787u32);
    pub const GUJARATI_DIGIT_ZERO : CodePoint = CodePoint::from(2790u32);
    pub const GUJARATI_DIGIT_ONE : CodePoint = CodePoint::from(2791u32);
    pub const GUJARATI_DIGIT_TWO : CodePoint = CodePoint::from(2792u32);
    pub const GUJARATI_DIGIT_THREE : CodePoint = CodePoint::from(2793u32);
    pub const GUJARATI_DIGIT_FOUR : CodePoint = CodePoint::from(2794u32);
    pub const GUJARATI_DIGIT_FIVE : CodePoint = CodePoint::from(2795u32);
    pub const GUJARATI_DIGIT_SIX : CodePoint = CodePoint::from(2796u32);
    pub const GUJARATI_DIGIT_SEVEN : CodePoint = CodePoint::from(2797u32);
    pub const GUJARATI_DIGIT_EIGHT : CodePoint = CodePoint::from(2798u32);
    pub const GUJARATI_DIGIT_NINE : CodePoint = CodePoint::from(2799u32);
    pub const GUJARATI_ABBREVIATION_SIGN : CodePoint = CodePoint::from(2800u32);
    pub const GUJARATI_RUPEE_SIGN : CodePoint = CodePoint::from(2801u32);
    pub const GUJARATI_LETTER_ZHA : CodePoint = CodePoint::from(2809u32);
    pub const GUJARATI_SIGN_SUKUN : CodePoint = CodePoint::from(2810u32);
    pub const GUJARATI_SIGN_SHADDA : CodePoint = CodePoint::from(2811u32);
    pub const GUJARATI_SIGN_MADDAH : CodePoint = CodePoint::from(2812u32);
    pub const GUJARATI_SIGN_THREE_DOT_NUKTA_ABOVE : CodePoint = CodePoint::from(2813u32);
    pub const GUJARATI_SIGN_CIRCLE_NUKTA_ABOVE : CodePoint = CodePoint::from(2814u32);
    pub const GUJARATI_SIGN_TWO_CIRCLE_NUKTA_ABOVE : CodePoint = CodePoint::from(2815u32);
    pub const ORIYA_SIGN_CANDRABINDU : CodePoint = CodePoint::from(2817u32);
    pub const ORIYA_SIGN_ANUSVARA : CodePoint = CodePoint::from(2818u32);
    pub const ORIYA_SIGN_VISARGA : CodePoint = CodePoint::from(2819u32);
    pub const ORIYA_LETTER_A : CodePoint = CodePoint::from(2821u32);
    pub const ORIYA_LETTER_AA : CodePoint = CodePoint::from(2822u32);
    pub const ORIYA_LETTER_I : CodePoint = CodePoint::from(2823u32);
    pub const ORIYA_LETTER_II : CodePoint = CodePoint::from(2824u32);
    pub const ORIYA_LETTER_U : CodePoint = CodePoint::from(2825u32);
    pub const ORIYA_LETTER_UU : CodePoint = CodePoint::from(2826u32);
    pub const ORIYA_LETTER_VOCALIC_R : CodePoint = CodePoint::from(2827u32);
    pub const ORIYA_LETTER_VOCALIC_L : CodePoint = CodePoint::from(2828u32);
    pub const ORIYA_LETTER_E : CodePoint = CodePoint::from(2831u32);
    pub const ORIYA_LETTER_AI : CodePoint = CodePoint::from(2832u32);
    pub const ORIYA_LETTER_O : CodePoint = CodePoint::from(2835u32);
    pub const ORIYA_LETTER_AU : CodePoint = CodePoint::from(2836u32);
    pub const ORIYA_LETTER_KA : CodePoint = CodePoint::from(2837u32);
    pub const ORIYA_LETTER_KHA : CodePoint = CodePoint::from(2838u32);
    pub const ORIYA_LETTER_GA : CodePoint = CodePoint::from(2839u32);
    pub const ORIYA_LETTER_GHA : CodePoint = CodePoint::from(2840u32);
    pub const ORIYA_LETTER_NGA : CodePoint = CodePoint::from(2841u32);
    pub const ORIYA_LETTER_CA : CodePoint = CodePoint::from(2842u32);
    pub const ORIYA_LETTER_CHA : CodePoint = CodePoint::from(2843u32);
    pub const ORIYA_LETTER_JA : CodePoint = CodePoint::from(2844u32);
    pub const ORIYA_LETTER_JHA : CodePoint = CodePoint::from(2845u32);
    pub const ORIYA_LETTER_NYA : CodePoint = CodePoint::from(2846u32);
    pub const ORIYA_LETTER_TTA : CodePoint = CodePoint::from(2847u32);
    pub const ORIYA_LETTER_TTHA : CodePoint = CodePoint::from(2848u32);
    pub const ORIYA_LETTER_DDA : CodePoint = CodePoint::from(2849u32);
    pub const ORIYA_LETTER_DDHA : CodePoint = CodePoint::from(2850u32);
    pub const ORIYA_LETTER_NNA : CodePoint = CodePoint::from(2851u32);
    pub const ORIYA_LETTER_TA : CodePoint = CodePoint::from(2852u32);
    pub const ORIYA_LETTER_THA : CodePoint = CodePoint::from(2853u32);
    pub const ORIYA_LETTER_DA : CodePoint = CodePoint::from(2854u32);
    pub const ORIYA_LETTER_DHA : CodePoint = CodePoint::from(2855u32);
    pub const ORIYA_LETTER_NA : CodePoint = CodePoint::from(2856u32);
    pub const ORIYA_LETTER_PA : CodePoint = CodePoint::from(2858u32);
    pub const ORIYA_LETTER_PHA : CodePoint = CodePoint::from(2859u32);
    pub const ORIYA_LETTER_BA : CodePoint = CodePoint::from(2860u32);
    pub const ORIYA_LETTER_BHA : CodePoint = CodePoint::from(2861u32);
    pub const ORIYA_LETTER_MA : CodePoint = CodePoint::from(2862u32);
    pub const ORIYA_LETTER_YA : CodePoint = CodePoint::from(2863u32);
    pub const ORIYA_LETTER_RA : CodePoint = CodePoint::from(2864u32);
    pub const ORIYA_LETTER_LA : CodePoint = CodePoint::from(2866u32);
    pub const ORIYA_LETTER_LLA : CodePoint = CodePoint::from(2867u32);
    pub const ORIYA_LETTER_VA : CodePoint = CodePoint::from(2869u32);
    pub const ORIYA_LETTER_SHA : CodePoint = CodePoint::from(2870u32);
    pub const ORIYA_LETTER_SSA : CodePoint = CodePoint::from(2871u32);
    pub const ORIYA_LETTER_SA : CodePoint = CodePoint::from(2872u32);
    pub const ORIYA_LETTER_HA : CodePoint = CodePoint::from(2873u32);
    pub const ORIYA_SIGN_NUKTA : CodePoint = CodePoint::from(2876u32);
    pub const ORIYA_SIGN_AVAGRAHA : CodePoint = CodePoint::from(2877u32);
    pub const ORIYA_VOWEL_SIGN_AA : CodePoint = CodePoint::from(2878u32);
    pub const ORIYA_VOWEL_SIGN_I : CodePoint = CodePoint::from(2879u32);
    pub const ORIYA_VOWEL_SIGN_II : CodePoint = CodePoint::from(2880u32);
    pub const ORIYA_VOWEL_SIGN_U : CodePoint = CodePoint::from(2881u32);
    pub const ORIYA_VOWEL_SIGN_UU : CodePoint = CodePoint::from(2882u32);
    pub const ORIYA_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(2883u32);
    pub const ORIYA_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(2884u32);
    pub const ORIYA_VOWEL_SIGN_E : CodePoint = CodePoint::from(2887u32);
    pub const ORIYA_VOWEL_SIGN_AI : CodePoint = CodePoint::from(2888u32);
    pub const ORIYA_VOWEL_SIGN_O : CodePoint = CodePoint::from(2891u32);
    pub const ORIYA_VOWEL_SIGN_AU : CodePoint = CodePoint::from(2892u32);
    pub const ORIYA_SIGN_VIRAMA : CodePoint = CodePoint::from(2893u32);
    pub const ORIYA_AI_LENGTH_MARK : CodePoint = CodePoint::from(2902u32);
    pub const ORIYA_AU_LENGTH_MARK : CodePoint = CodePoint::from(2903u32);
    pub const ORIYA_LETTER_RRA : CodePoint = CodePoint::from(2908u32);
    pub const ORIYA_LETTER_RHA : CodePoint = CodePoint::from(2909u32);
    pub const ORIYA_LETTER_YYA : CodePoint = CodePoint::from(2911u32);
    pub const ORIYA_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(2912u32);
    pub const ORIYA_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(2913u32);
    pub const ORIYA_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(2914u32);
    pub const ORIYA_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(2915u32);
    pub const ORIYA_DIGIT_ZERO : CodePoint = CodePoint::from(2918u32);
    pub const ORIYA_DIGIT_ONE : CodePoint = CodePoint::from(2919u32);
    pub const ORIYA_DIGIT_TWO : CodePoint = CodePoint::from(2920u32);
    pub const ORIYA_DIGIT_THREE : CodePoint = CodePoint::from(2921u32);
    pub const ORIYA_DIGIT_FOUR : CodePoint = CodePoint::from(2922u32);
    pub const ORIYA_DIGIT_FIVE : CodePoint = CodePoint::from(2923u32);
    pub const ORIYA_DIGIT_SIX : CodePoint = CodePoint::from(2924u32);
    pub const ORIYA_DIGIT_SEVEN : CodePoint = CodePoint::from(2925u32);
    pub const ORIYA_DIGIT_EIGHT : CodePoint = CodePoint::from(2926u32);
    pub const ORIYA_DIGIT_NINE : CodePoint = CodePoint::from(2927u32);
    pub const ORIYA_ISSHAR : CodePoint = CodePoint::from(2928u32);
    pub const ORIYA_LETTER_WA : CodePoint = CodePoint::from(2929u32);
    pub const ORIYA_FRACTION_ONE_QUARTER : CodePoint = CodePoint::from(2930u32);
    pub const ORIYA_FRACTION_ONE_HALF : CodePoint = CodePoint::from(2931u32);
    pub const ORIYA_FRACTION_THREE_QUARTERS : CodePoint = CodePoint::from(2932u32);
    pub const ORIYA_FRACTION_ONE_SIXTEENTH : CodePoint = CodePoint::from(2933u32);
    pub const ORIYA_FRACTION_ONE_EIGHTH : CodePoint = CodePoint::from(2934u32);
    pub const ORIYA_FRACTION_THREE_SIXTEENTHS : CodePoint = CodePoint::from(2935u32);
    pub const TAMIL_SIGN_ANUSVARA : CodePoint = CodePoint::from(2946u32);
    pub const TAMIL_SIGN_VISARGA : CodePoint = CodePoint::from(2947u32);
    pub const TAMIL_LETTER_A : CodePoint = CodePoint::from(2949u32);
    pub const TAMIL_LETTER_AA : CodePoint = CodePoint::from(2950u32);
    pub const TAMIL_LETTER_I : CodePoint = CodePoint::from(2951u32);
    pub const TAMIL_LETTER_II : CodePoint = CodePoint::from(2952u32);
    pub const TAMIL_LETTER_U : CodePoint = CodePoint::from(2953u32);
    pub const TAMIL_LETTER_UU : CodePoint = CodePoint::from(2954u32);
    pub const TAMIL_LETTER_E : CodePoint = CodePoint::from(2958u32);
    pub const TAMIL_LETTER_EE : CodePoint = CodePoint::from(2959u32);
    pub const TAMIL_LETTER_AI : CodePoint = CodePoint::from(2960u32);
    pub const TAMIL_LETTER_O : CodePoint = CodePoint::from(2962u32);
    pub const TAMIL_LETTER_OO : CodePoint = CodePoint::from(2963u32);
    pub const TAMIL_LETTER_AU : CodePoint = CodePoint::from(2964u32);
    pub const TAMIL_LETTER_KA : CodePoint = CodePoint::from(2965u32);
    pub const TAMIL_LETTER_NGA : CodePoint = CodePoint::from(2969u32);
    pub const TAMIL_LETTER_CA : CodePoint = CodePoint::from(2970u32);
    pub const TAMIL_LETTER_JA : CodePoint = CodePoint::from(2972u32);
    pub const TAMIL_LETTER_NYA : CodePoint = CodePoint::from(2974u32);
    pub const TAMIL_LETTER_TTA : CodePoint = CodePoint::from(2975u32);
    pub const TAMIL_LETTER_NNA : CodePoint = CodePoint::from(2979u32);
    pub const TAMIL_LETTER_TA : CodePoint = CodePoint::from(2980u32);
    pub const TAMIL_LETTER_NA : CodePoint = CodePoint::from(2984u32);
    pub const TAMIL_LETTER_NNNA : CodePoint = CodePoint::from(2985u32);
    pub const TAMIL_LETTER_PA : CodePoint = CodePoint::from(2986u32);
    pub const TAMIL_LETTER_MA : CodePoint = CodePoint::from(2990u32);
    pub const TAMIL_LETTER_YA : CodePoint = CodePoint::from(2991u32);
    pub const TAMIL_LETTER_RA : CodePoint = CodePoint::from(2992u32);
    pub const TAMIL_LETTER_RRA : CodePoint = CodePoint::from(2993u32);
    pub const TAMIL_LETTER_LA : CodePoint = CodePoint::from(2994u32);
    pub const TAMIL_LETTER_LLA : CodePoint = CodePoint::from(2995u32);
    pub const TAMIL_LETTER_LLLA : CodePoint = CodePoint::from(2996u32);
    pub const TAMIL_LETTER_VA : CodePoint = CodePoint::from(2997u32);
    pub const TAMIL_LETTER_SHA : CodePoint = CodePoint::from(2998u32);
    pub const TAMIL_LETTER_SSA : CodePoint = CodePoint::from(2999u32);
    pub const TAMIL_LETTER_SA : CodePoint = CodePoint::from(3000u32);
    pub const TAMIL_LETTER_HA : CodePoint = CodePoint::from(3001u32);
    pub const TAMIL_VOWEL_SIGN_AA : CodePoint = CodePoint::from(3006u32);
    pub const TAMIL_VOWEL_SIGN_I : CodePoint = CodePoint::from(3007u32);
    pub const TAMIL_VOWEL_SIGN_II : CodePoint = CodePoint::from(3008u32);
    pub const TAMIL_VOWEL_SIGN_U : CodePoint = CodePoint::from(3009u32);
    pub const TAMIL_VOWEL_SIGN_UU : CodePoint = CodePoint::from(3010u32);
    pub const TAMIL_VOWEL_SIGN_E : CodePoint = CodePoint::from(3014u32);
    pub const TAMIL_VOWEL_SIGN_EE : CodePoint = CodePoint::from(3015u32);
    pub const TAMIL_VOWEL_SIGN_AI : CodePoint = CodePoint::from(3016u32);
    pub const TAMIL_VOWEL_SIGN_O : CodePoint = CodePoint::from(3018u32);
    pub const TAMIL_VOWEL_SIGN_OO : CodePoint = CodePoint::from(3019u32);
    pub const TAMIL_VOWEL_SIGN_AU : CodePoint = CodePoint::from(3020u32);
    pub const TAMIL_SIGN_VIRAMA : CodePoint = CodePoint::from(3021u32);
    pub const TAMIL_OM : CodePoint = CodePoint::from(3024u32);
    pub const TAMIL_AU_LENGTH_MARK : CodePoint = CodePoint::from(3031u32);
    pub const TAMIL_DIGIT_ZERO : CodePoint = CodePoint::from(3046u32);
    pub const TAMIL_DIGIT_ONE : CodePoint = CodePoint::from(3047u32);
    pub const TAMIL_DIGIT_TWO : CodePoint = CodePoint::from(3048u32);
    pub const TAMIL_DIGIT_THREE : CodePoint = CodePoint::from(3049u32);
    pub const TAMIL_DIGIT_FOUR : CodePoint = CodePoint::from(3050u32);
    pub const TAMIL_DIGIT_FIVE : CodePoint = CodePoint::from(3051u32);
    pub const TAMIL_DIGIT_SIX : CodePoint = CodePoint::from(3052u32);
    pub const TAMIL_DIGIT_SEVEN : CodePoint = CodePoint::from(3053u32);
    pub const TAMIL_DIGIT_EIGHT : CodePoint = CodePoint::from(3054u32);
    pub const TAMIL_DIGIT_NINE : CodePoint = CodePoint::from(3055u32);
    pub const TAMIL_NUMBER_TEN : CodePoint = CodePoint::from(3056u32);
    pub const TAMIL_NUMBER_ONE_HUNDRED : CodePoint = CodePoint::from(3057u32);
    pub const TAMIL_NUMBER_ONE_THOUSAND : CodePoint = CodePoint::from(3058u32);
    pub const TAMIL_DAY_SIGN : CodePoint = CodePoint::from(3059u32);
    pub const TAMIL_MONTH_SIGN : CodePoint = CodePoint::from(3060u32);
    pub const TAMIL_YEAR_SIGN : CodePoint = CodePoint::from(3061u32);
    pub const TAMIL_DEBIT_SIGN : CodePoint = CodePoint::from(3062u32);
    pub const TAMIL_CREDIT_SIGN : CodePoint = CodePoint::from(3063u32);
    pub const TAMIL_AS_ABOVE_SIGN : CodePoint = CodePoint::from(3064u32);
    pub const TAMIL_RUPEE_SIGN : CodePoint = CodePoint::from(3065u32);
    pub const TAMIL_NUMBER_SIGN : CodePoint = CodePoint::from(3066u32);
    pub const TELUGU_SIGN_COMBINING_CANDRABINDU_ABOVE : CodePoint = CodePoint::from(3072u32);
    pub const TELUGU_SIGN_CANDRABINDU : CodePoint = CodePoint::from(3073u32);
    pub const TELUGU_SIGN_ANUSVARA : CodePoint = CodePoint::from(3074u32);
    pub const TELUGU_SIGN_VISARGA : CodePoint = CodePoint::from(3075u32);
    pub const TELUGU_SIGN_COMBINING_ANUSVARA_ABOVE : CodePoint = CodePoint::from(3076u32);
    pub const TELUGU_LETTER_A : CodePoint = CodePoint::from(3077u32);
    pub const TELUGU_LETTER_AA : CodePoint = CodePoint::from(3078u32);
    pub const TELUGU_LETTER_I : CodePoint = CodePoint::from(3079u32);
    pub const TELUGU_LETTER_II : CodePoint = CodePoint::from(3080u32);
    pub const TELUGU_LETTER_U : CodePoint = CodePoint::from(3081u32);
    pub const TELUGU_LETTER_UU : CodePoint = CodePoint::from(3082u32);
    pub const TELUGU_LETTER_VOCALIC_R : CodePoint = CodePoint::from(3083u32);
    pub const TELUGU_LETTER_VOCALIC_L : CodePoint = CodePoint::from(3084u32);
    pub const TELUGU_LETTER_E : CodePoint = CodePoint::from(3086u32);
    pub const TELUGU_LETTER_EE : CodePoint = CodePoint::from(3087u32);
    pub const TELUGU_LETTER_AI : CodePoint = CodePoint::from(3088u32);
    pub const TELUGU_LETTER_O : CodePoint = CodePoint::from(3090u32);
    pub const TELUGU_LETTER_OO : CodePoint = CodePoint::from(3091u32);
    pub const TELUGU_LETTER_AU : CodePoint = CodePoint::from(3092u32);
    pub const TELUGU_LETTER_KA : CodePoint = CodePoint::from(3093u32);
    pub const TELUGU_LETTER_KHA : CodePoint = CodePoint::from(3094u32);
    pub const TELUGU_LETTER_GA : CodePoint = CodePoint::from(3095u32);
    pub const TELUGU_LETTER_GHA : CodePoint = CodePoint::from(3096u32);
    pub const TELUGU_LETTER_NGA : CodePoint = CodePoint::from(3097u32);
    pub const TELUGU_LETTER_CA : CodePoint = CodePoint::from(3098u32);
    pub const TELUGU_LETTER_CHA : CodePoint = CodePoint::from(3099u32);
    pub const TELUGU_LETTER_JA : CodePoint = CodePoint::from(3100u32);
    pub const TELUGU_LETTER_JHA : CodePoint = CodePoint::from(3101u32);
    pub const TELUGU_LETTER_NYA : CodePoint = CodePoint::from(3102u32);
    pub const TELUGU_LETTER_TTA : CodePoint = CodePoint::from(3103u32);
    pub const TELUGU_LETTER_TTHA : CodePoint = CodePoint::from(3104u32);
    pub const TELUGU_LETTER_DDA : CodePoint = CodePoint::from(3105u32);
    pub const TELUGU_LETTER_DDHA : CodePoint = CodePoint::from(3106u32);
    pub const TELUGU_LETTER_NNA : CodePoint = CodePoint::from(3107u32);
    pub const TELUGU_LETTER_TA : CodePoint = CodePoint::from(3108u32);
    pub const TELUGU_LETTER_THA : CodePoint = CodePoint::from(3109u32);
    pub const TELUGU_LETTER_DA : CodePoint = CodePoint::from(3110u32);
    pub const TELUGU_LETTER_DHA : CodePoint = CodePoint::from(3111u32);
    pub const TELUGU_LETTER_NA : CodePoint = CodePoint::from(3112u32);
    pub const TELUGU_LETTER_PA : CodePoint = CodePoint::from(3114u32);
    pub const TELUGU_LETTER_PHA : CodePoint = CodePoint::from(3115u32);
    pub const TELUGU_LETTER_BA : CodePoint = CodePoint::from(3116u32);
    pub const TELUGU_LETTER_BHA : CodePoint = CodePoint::from(3117u32);
    pub const TELUGU_LETTER_MA : CodePoint = CodePoint::from(3118u32);
    pub const TELUGU_LETTER_YA : CodePoint = CodePoint::from(3119u32);
    pub const TELUGU_LETTER_RA : CodePoint = CodePoint::from(3120u32);
    pub const TELUGU_LETTER_RRA : CodePoint = CodePoint::from(3121u32);
    pub const TELUGU_LETTER_LA : CodePoint = CodePoint::from(3122u32);
    pub const TELUGU_LETTER_LLA : CodePoint = CodePoint::from(3123u32);
    pub const TELUGU_LETTER_LLLA : CodePoint = CodePoint::from(3124u32);
    pub const TELUGU_LETTER_VA : CodePoint = CodePoint::from(3125u32);
    pub const TELUGU_LETTER_SHA : CodePoint = CodePoint::from(3126u32);
    pub const TELUGU_LETTER_SSA : CodePoint = CodePoint::from(3127u32);
    pub const TELUGU_LETTER_SA : CodePoint = CodePoint::from(3128u32);
    pub const TELUGU_LETTER_HA : CodePoint = CodePoint::from(3129u32);
    pub const TELUGU_SIGN_AVAGRAHA : CodePoint = CodePoint::from(3133u32);
    pub const TELUGU_VOWEL_SIGN_AA : CodePoint = CodePoint::from(3134u32);
    pub const TELUGU_VOWEL_SIGN_I : CodePoint = CodePoint::from(3135u32);
    pub const TELUGU_VOWEL_SIGN_II : CodePoint = CodePoint::from(3136u32);
    pub const TELUGU_VOWEL_SIGN_U : CodePoint = CodePoint::from(3137u32);
    pub const TELUGU_VOWEL_SIGN_UU : CodePoint = CodePoint::from(3138u32);
    pub const TELUGU_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(3139u32);
    pub const TELUGU_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(3140u32);
    pub const TELUGU_VOWEL_SIGN_E : CodePoint = CodePoint::from(3142u32);
    pub const TELUGU_VOWEL_SIGN_EE : CodePoint = CodePoint::from(3143u32);
    pub const TELUGU_VOWEL_SIGN_AI : CodePoint = CodePoint::from(3144u32);
    pub const TELUGU_VOWEL_SIGN_O : CodePoint = CodePoint::from(3146u32);
    pub const TELUGU_VOWEL_SIGN_OO : CodePoint = CodePoint::from(3147u32);
    pub const TELUGU_VOWEL_SIGN_AU : CodePoint = CodePoint::from(3148u32);
    pub const TELUGU_SIGN_VIRAMA : CodePoint = CodePoint::from(3149u32);
    pub const TELUGU_LENGTH_MARK : CodePoint = CodePoint::from(3157u32);
    pub const TELUGU_AI_LENGTH_MARK : CodePoint = CodePoint::from(3158u32);
    pub const TELUGU_LETTER_TSA : CodePoint = CodePoint::from(3160u32);
    pub const TELUGU_LETTER_DZA : CodePoint = CodePoint::from(3161u32);
    pub const TELUGU_LETTER_RRRA : CodePoint = CodePoint::from(3162u32);
    pub const TELUGU_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(3168u32);
    pub const TELUGU_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(3169u32);
    pub const TELUGU_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(3170u32);
    pub const TELUGU_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(3171u32);
    pub const TELUGU_DIGIT_ZERO : CodePoint = CodePoint::from(3174u32);
    pub const TELUGU_DIGIT_ONE : CodePoint = CodePoint::from(3175u32);
    pub const TELUGU_DIGIT_TWO : CodePoint = CodePoint::from(3176u32);
    pub const TELUGU_DIGIT_THREE : CodePoint = CodePoint::from(3177u32);
    pub const TELUGU_DIGIT_FOUR : CodePoint = CodePoint::from(3178u32);
    pub const TELUGU_DIGIT_FIVE : CodePoint = CodePoint::from(3179u32);
    pub const TELUGU_DIGIT_SIX : CodePoint = CodePoint::from(3180u32);
    pub const TELUGU_DIGIT_SEVEN : CodePoint = CodePoint::from(3181u32);
    pub const TELUGU_DIGIT_EIGHT : CodePoint = CodePoint::from(3182u32);
    pub const TELUGU_DIGIT_NINE : CodePoint = CodePoint::from(3183u32);
    pub const TELUGU_SIGN_SIDDHAM : CodePoint = CodePoint::from(3191u32);
    pub const TELUGU_FRACTION_DIGIT_ZERO_FOR_ODD_POWERS_OF_FOUR : CodePoint = CodePoint::from(3192u32);
    pub const TELUGU_FRACTION_DIGIT_ONE_FOR_ODD_POWERS_OF_FOUR : CodePoint = CodePoint::from(3193u32);
    pub const TELUGU_FRACTION_DIGIT_TWO_FOR_ODD_POWERS_OF_FOUR : CodePoint = CodePoint::from(3194u32);
    pub const TELUGU_FRACTION_DIGIT_THREE_FOR_ODD_POWERS_OF_FOUR : CodePoint = CodePoint::from(3195u32);
    pub const TELUGU_FRACTION_DIGIT_ONE_FOR_EVEN_POWERS_OF_FOUR : CodePoint = CodePoint::from(3196u32);
    pub const TELUGU_FRACTION_DIGIT_TWO_FOR_EVEN_POWERS_OF_FOUR : CodePoint = CodePoint::from(3197u32);
    pub const TELUGU_FRACTION_DIGIT_THREE_FOR_EVEN_POWERS_OF_FOUR : CodePoint = CodePoint::from(3198u32);
    pub const TELUGU_SIGN_TUUMU : CodePoint = CodePoint::from(3199u32);
    pub const KANNADA_SIGN_SPACING_CANDRABINDU : CodePoint = CodePoint::from(3200u32);
    pub const KANNADA_SIGN_CANDRABINDU : CodePoint = CodePoint::from(3201u32);
    pub const KANNADA_SIGN_ANUSVARA : CodePoint = CodePoint::from(3202u32);
    pub const KANNADA_SIGN_VISARGA : CodePoint = CodePoint::from(3203u32);
    pub const KANNADA_SIGN_SIDDHAM : CodePoint = CodePoint::from(3204u32);
    pub const KANNADA_LETTER_A : CodePoint = CodePoint::from(3205u32);
    pub const KANNADA_LETTER_AA : CodePoint = CodePoint::from(3206u32);
    pub const KANNADA_LETTER_I : CodePoint = CodePoint::from(3207u32);
    pub const KANNADA_LETTER_II : CodePoint = CodePoint::from(3208u32);
    pub const KANNADA_LETTER_U : CodePoint = CodePoint::from(3209u32);
    pub const KANNADA_LETTER_UU : CodePoint = CodePoint::from(3210u32);
    pub const KANNADA_LETTER_VOCALIC_R : CodePoint = CodePoint::from(3211u32);
    pub const KANNADA_LETTER_VOCALIC_L : CodePoint = CodePoint::from(3212u32);
    pub const KANNADA_LETTER_E : CodePoint = CodePoint::from(3214u32);
    pub const KANNADA_LETTER_EE : CodePoint = CodePoint::from(3215u32);
    pub const KANNADA_LETTER_AI : CodePoint = CodePoint::from(3216u32);
    pub const KANNADA_LETTER_O : CodePoint = CodePoint::from(3218u32);
    pub const KANNADA_LETTER_OO : CodePoint = CodePoint::from(3219u32);
    pub const KANNADA_LETTER_AU : CodePoint = CodePoint::from(3220u32);
    pub const KANNADA_LETTER_KA : CodePoint = CodePoint::from(3221u32);
    pub const KANNADA_LETTER_KHA : CodePoint = CodePoint::from(3222u32);
    pub const KANNADA_LETTER_GA : CodePoint = CodePoint::from(3223u32);
    pub const KANNADA_LETTER_GHA : CodePoint = CodePoint::from(3224u32);
    pub const KANNADA_LETTER_NGA : CodePoint = CodePoint::from(3225u32);
    pub const KANNADA_LETTER_CA : CodePoint = CodePoint::from(3226u32);
    pub const KANNADA_LETTER_CHA : CodePoint = CodePoint::from(3227u32);
    pub const KANNADA_LETTER_JA : CodePoint = CodePoint::from(3228u32);
    pub const KANNADA_LETTER_JHA : CodePoint = CodePoint::from(3229u32);
    pub const KANNADA_LETTER_NYA : CodePoint = CodePoint::from(3230u32);
    pub const KANNADA_LETTER_TTA : CodePoint = CodePoint::from(3231u32);
    pub const KANNADA_LETTER_TTHA : CodePoint = CodePoint::from(3232u32);
    pub const KANNADA_LETTER_DDA : CodePoint = CodePoint::from(3233u32);
    pub const KANNADA_LETTER_DDHA : CodePoint = CodePoint::from(3234u32);
    pub const KANNADA_LETTER_NNA : CodePoint = CodePoint::from(3235u32);
    pub const KANNADA_LETTER_TA : CodePoint = CodePoint::from(3236u32);
    pub const KANNADA_LETTER_THA : CodePoint = CodePoint::from(3237u32);
    pub const KANNADA_LETTER_DA : CodePoint = CodePoint::from(3238u32);
    pub const KANNADA_LETTER_DHA : CodePoint = CodePoint::from(3239u32);
    pub const KANNADA_LETTER_NA : CodePoint = CodePoint::from(3240u32);
    pub const KANNADA_LETTER_PA : CodePoint = CodePoint::from(3242u32);
    pub const KANNADA_LETTER_PHA : CodePoint = CodePoint::from(3243u32);
    pub const KANNADA_LETTER_BA : CodePoint = CodePoint::from(3244u32);
    pub const KANNADA_LETTER_BHA : CodePoint = CodePoint::from(3245u32);
    pub const KANNADA_LETTER_MA : CodePoint = CodePoint::from(3246u32);
    pub const KANNADA_LETTER_YA : CodePoint = CodePoint::from(3247u32);
    pub const KANNADA_LETTER_RA : CodePoint = CodePoint::from(3248u32);
    pub const KANNADA_LETTER_RRA : CodePoint = CodePoint::from(3249u32);
    pub const KANNADA_LETTER_LA : CodePoint = CodePoint::from(3250u32);
    pub const KANNADA_LETTER_LLA : CodePoint = CodePoint::from(3251u32);
    pub const KANNADA_LETTER_VA : CodePoint = CodePoint::from(3253u32);
    pub const KANNADA_LETTER_SHA : CodePoint = CodePoint::from(3254u32);
    pub const KANNADA_LETTER_SSA : CodePoint = CodePoint::from(3255u32);
    pub const KANNADA_LETTER_SA : CodePoint = CodePoint::from(3256u32);
    pub const KANNADA_LETTER_HA : CodePoint = CodePoint::from(3257u32);
    pub const KANNADA_SIGN_NUKTA : CodePoint = CodePoint::from(3260u32);
    pub const KANNADA_SIGN_AVAGRAHA : CodePoint = CodePoint::from(3261u32);
    pub const KANNADA_VOWEL_SIGN_AA : CodePoint = CodePoint::from(3262u32);
    pub const KANNADA_VOWEL_SIGN_I : CodePoint = CodePoint::from(3263u32);
    pub const KANNADA_VOWEL_SIGN_II : CodePoint = CodePoint::from(3264u32);
    pub const KANNADA_VOWEL_SIGN_U : CodePoint = CodePoint::from(3265u32);
    pub const KANNADA_VOWEL_SIGN_UU : CodePoint = CodePoint::from(3266u32);
    pub const KANNADA_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(3267u32);
    pub const KANNADA_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(3268u32);
    pub const KANNADA_VOWEL_SIGN_E : CodePoint = CodePoint::from(3270u32);
    pub const KANNADA_VOWEL_SIGN_EE : CodePoint = CodePoint::from(3271u32);
    pub const KANNADA_VOWEL_SIGN_AI : CodePoint = CodePoint::from(3272u32);
    pub const KANNADA_VOWEL_SIGN_O : CodePoint = CodePoint::from(3274u32);
    pub const KANNADA_VOWEL_SIGN_OO : CodePoint = CodePoint::from(3275u32);
    pub const KANNADA_VOWEL_SIGN_AU : CodePoint = CodePoint::from(3276u32);
    pub const KANNADA_SIGN_VIRAMA : CodePoint = CodePoint::from(3277u32);
    pub const KANNADA_LENGTH_MARK : CodePoint = CodePoint::from(3285u32);
    pub const KANNADA_AI_LENGTH_MARK : CodePoint = CodePoint::from(3286u32);
    pub const KANNADA_LETTER_FA : CodePoint = CodePoint::from(3294u32);
    pub const KANNADA_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(3296u32);
    pub const KANNADA_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(3297u32);
    pub const KANNADA_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(3298u32);
    pub const KANNADA_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(3299u32);
    pub const KANNADA_DIGIT_ZERO : CodePoint = CodePoint::from(3302u32);
    pub const KANNADA_DIGIT_ONE : CodePoint = CodePoint::from(3303u32);
    pub const KANNADA_DIGIT_TWO : CodePoint = CodePoint::from(3304u32);
    pub const KANNADA_DIGIT_THREE : CodePoint = CodePoint::from(3305u32);
    pub const KANNADA_DIGIT_FOUR : CodePoint = CodePoint::from(3306u32);
    pub const KANNADA_DIGIT_FIVE : CodePoint = CodePoint::from(3307u32);
    pub const KANNADA_DIGIT_SIX : CodePoint = CodePoint::from(3308u32);
    pub const KANNADA_DIGIT_SEVEN : CodePoint = CodePoint::from(3309u32);
    pub const KANNADA_DIGIT_EIGHT : CodePoint = CodePoint::from(3310u32);
    pub const KANNADA_DIGIT_NINE : CodePoint = CodePoint::from(3311u32);
    pub const KANNADA_SIGN_JIHVAMULIYA : CodePoint = CodePoint::from(3313u32);
    pub const KANNADA_SIGN_UPADHMANIYA : CodePoint = CodePoint::from(3314u32);
    pub const MALAYALAM_SIGN_COMBINING_ANUSVARA_ABOVE : CodePoint = CodePoint::from(3328u32);
    pub const MALAYALAM_SIGN_CANDRABINDU : CodePoint = CodePoint::from(3329u32);
    pub const MALAYALAM_SIGN_ANUSVARA : CodePoint = CodePoint::from(3330u32);
    pub const MALAYALAM_SIGN_VISARGA : CodePoint = CodePoint::from(3331u32);
    pub const MALAYALAM_LETTER_A : CodePoint = CodePoint::from(3333u32);
    pub const MALAYALAM_LETTER_AA : CodePoint = CodePoint::from(3334u32);
    pub const MALAYALAM_LETTER_I : CodePoint = CodePoint::from(3335u32);
    pub const MALAYALAM_LETTER_II : CodePoint = CodePoint::from(3336u32);
    pub const MALAYALAM_LETTER_U : CodePoint = CodePoint::from(3337u32);
    pub const MALAYALAM_LETTER_UU : CodePoint = CodePoint::from(3338u32);
    pub const MALAYALAM_LETTER_VOCALIC_R : CodePoint = CodePoint::from(3339u32);
    pub const MALAYALAM_LETTER_VOCALIC_L : CodePoint = CodePoint::from(3340u32);
    pub const MALAYALAM_LETTER_E : CodePoint = CodePoint::from(3342u32);
    pub const MALAYALAM_LETTER_EE : CodePoint = CodePoint::from(3343u32);
    pub const MALAYALAM_LETTER_AI : CodePoint = CodePoint::from(3344u32);
    pub const MALAYALAM_LETTER_O : CodePoint = CodePoint::from(3346u32);
    pub const MALAYALAM_LETTER_OO : CodePoint = CodePoint::from(3347u32);
    pub const MALAYALAM_LETTER_AU : CodePoint = CodePoint::from(3348u32);
    pub const MALAYALAM_LETTER_KA : CodePoint = CodePoint::from(3349u32);
    pub const MALAYALAM_LETTER_KHA : CodePoint = CodePoint::from(3350u32);
    pub const MALAYALAM_LETTER_GA : CodePoint = CodePoint::from(3351u32);
    pub const MALAYALAM_LETTER_GHA : CodePoint = CodePoint::from(3352u32);
    pub const MALAYALAM_LETTER_NGA : CodePoint = CodePoint::from(3353u32);
    pub const MALAYALAM_LETTER_CA : CodePoint = CodePoint::from(3354u32);
    pub const MALAYALAM_LETTER_CHA : CodePoint = CodePoint::from(3355u32);
    pub const MALAYALAM_LETTER_JA : CodePoint = CodePoint::from(3356u32);
    pub const MALAYALAM_LETTER_JHA : CodePoint = CodePoint::from(3357u32);
    pub const MALAYALAM_LETTER_NYA : CodePoint = CodePoint::from(3358u32);
    pub const MALAYALAM_LETTER_TTA : CodePoint = CodePoint::from(3359u32);
    pub const MALAYALAM_LETTER_TTHA : CodePoint = CodePoint::from(3360u32);
    pub const MALAYALAM_LETTER_DDA : CodePoint = CodePoint::from(3361u32);
    pub const MALAYALAM_LETTER_DDHA : CodePoint = CodePoint::from(3362u32);
    pub const MALAYALAM_LETTER_NNA : CodePoint = CodePoint::from(3363u32);
    pub const MALAYALAM_LETTER_TA : CodePoint = CodePoint::from(3364u32);
    pub const MALAYALAM_LETTER_THA : CodePoint = CodePoint::from(3365u32);
    pub const MALAYALAM_LETTER_DA : CodePoint = CodePoint::from(3366u32);
    pub const MALAYALAM_LETTER_DHA : CodePoint = CodePoint::from(3367u32);
    pub const MALAYALAM_LETTER_NA : CodePoint = CodePoint::from(3368u32);
    pub const MALAYALAM_LETTER_NNNA : CodePoint = CodePoint::from(3369u32);
    pub const MALAYALAM_LETTER_PA : CodePoint = CodePoint::from(3370u32);
    pub const MALAYALAM_LETTER_PHA : CodePoint = CodePoint::from(3371u32);
    pub const MALAYALAM_LETTER_BA : CodePoint = CodePoint::from(3372u32);
    pub const MALAYALAM_LETTER_BHA : CodePoint = CodePoint::from(3373u32);
    pub const MALAYALAM_LETTER_MA : CodePoint = CodePoint::from(3374u32);
    pub const MALAYALAM_LETTER_YA : CodePoint = CodePoint::from(3375u32);
    pub const MALAYALAM_LETTER_RA : CodePoint = CodePoint::from(3376u32);
    pub const MALAYALAM_LETTER_RRA : CodePoint = CodePoint::from(3377u32);
    pub const MALAYALAM_LETTER_LA : CodePoint = CodePoint::from(3378u32);
    pub const MALAYALAM_LETTER_LLA : CodePoint = CodePoint::from(3379u32);
    pub const MALAYALAM_LETTER_LLLA : CodePoint = CodePoint::from(3380u32);
    pub const MALAYALAM_LETTER_VA : CodePoint = CodePoint::from(3381u32);
    pub const MALAYALAM_LETTER_SHA : CodePoint = CodePoint::from(3382u32);
    pub const MALAYALAM_LETTER_SSA : CodePoint = CodePoint::from(3383u32);
    pub const MALAYALAM_LETTER_SA : CodePoint = CodePoint::from(3384u32);
    pub const MALAYALAM_LETTER_HA : CodePoint = CodePoint::from(3385u32);
    pub const MALAYALAM_LETTER_TTTA : CodePoint = CodePoint::from(3386u32);
    pub const MALAYALAM_SIGN_VERTICAL_BAR_VIRAMA : CodePoint = CodePoint::from(3387u32);
    pub const MALAYALAM_SIGN_CIRCULAR_VIRAMA : CodePoint = CodePoint::from(3388u32);
    pub const MALAYALAM_SIGN_AVAGRAHA : CodePoint = CodePoint::from(3389u32);
    pub const MALAYALAM_VOWEL_SIGN_AA : CodePoint = CodePoint::from(3390u32);
    pub const MALAYALAM_VOWEL_SIGN_I : CodePoint = CodePoint::from(3391u32);
    pub const MALAYALAM_VOWEL_SIGN_II : CodePoint = CodePoint::from(3392u32);
    pub const MALAYALAM_VOWEL_SIGN_U : CodePoint = CodePoint::from(3393u32);
    pub const MALAYALAM_VOWEL_SIGN_UU : CodePoint = CodePoint::from(3394u32);
    pub const MALAYALAM_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(3395u32);
    pub const MALAYALAM_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(3396u32);
    pub const MALAYALAM_VOWEL_SIGN_E : CodePoint = CodePoint::from(3398u32);
    pub const MALAYALAM_VOWEL_SIGN_EE : CodePoint = CodePoint::from(3399u32);
    pub const MALAYALAM_VOWEL_SIGN_AI : CodePoint = CodePoint::from(3400u32);
    pub const MALAYALAM_VOWEL_SIGN_O : CodePoint = CodePoint::from(3402u32);
    pub const MALAYALAM_VOWEL_SIGN_OO : CodePoint = CodePoint::from(3403u32);
    pub const MALAYALAM_VOWEL_SIGN_AU : CodePoint = CodePoint::from(3404u32);
    pub const MALAYALAM_SIGN_VIRAMA : CodePoint = CodePoint::from(3405u32);
    pub const MALAYALAM_LETTER_DOT_REPH : CodePoint = CodePoint::from(3406u32);
    pub const MALAYALAM_SIGN_PARA : CodePoint = CodePoint::from(3407u32);
    pub const MALAYALAM_LETTER_CHILLU_M : CodePoint = CodePoint::from(3412u32);
    pub const MALAYALAM_LETTER_CHILLU_Y : CodePoint = CodePoint::from(3413u32);
    pub const MALAYALAM_LETTER_CHILLU_LLL : CodePoint = CodePoint::from(3414u32);
    pub const MALAYALAM_AU_LENGTH_MARK : CodePoint = CodePoint::from(3415u32);
    pub const MALAYALAM_FRACTION_ONE_ONE_HUNDRED_AND_SIXTIETH : CodePoint = CodePoint::from(3416u32);
    pub const MALAYALAM_FRACTION_ONE_FORTIETH : CodePoint = CodePoint::from(3417u32);
    pub const MALAYALAM_FRACTION_THREE_EIGHTIETHS : CodePoint = CodePoint::from(3418u32);
    pub const MALAYALAM_FRACTION_ONE_TWENTIETH : CodePoint = CodePoint::from(3419u32);
    pub const MALAYALAM_FRACTION_ONE_TENTH : CodePoint = CodePoint::from(3420u32);
    pub const MALAYALAM_FRACTION_THREE_TWENTIETHS : CodePoint = CodePoint::from(3421u32);
    pub const MALAYALAM_FRACTION_ONE_FIFTH : CodePoint = CodePoint::from(3422u32);
    pub const MALAYALAM_LETTER_ARCHAIC_II : CodePoint = CodePoint::from(3423u32);
    pub const MALAYALAM_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(3424u32);
    pub const MALAYALAM_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(3425u32);
    pub const MALAYALAM_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(3426u32);
    pub const MALAYALAM_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(3427u32);
    pub const MALAYALAM_DIGIT_ZERO : CodePoint = CodePoint::from(3430u32);
    pub const MALAYALAM_DIGIT_ONE : CodePoint = CodePoint::from(3431u32);
    pub const MALAYALAM_DIGIT_TWO : CodePoint = CodePoint::from(3432u32);
    pub const MALAYALAM_DIGIT_THREE : CodePoint = CodePoint::from(3433u32);
    pub const MALAYALAM_DIGIT_FOUR : CodePoint = CodePoint::from(3434u32);
    pub const MALAYALAM_DIGIT_FIVE : CodePoint = CodePoint::from(3435u32);
    pub const MALAYALAM_DIGIT_SIX : CodePoint = CodePoint::from(3436u32);
    pub const MALAYALAM_DIGIT_SEVEN : CodePoint = CodePoint::from(3437u32);
    pub const MALAYALAM_DIGIT_EIGHT : CodePoint = CodePoint::from(3438u32);
    pub const MALAYALAM_DIGIT_NINE : CodePoint = CodePoint::from(3439u32);
    pub const MALAYALAM_NUMBER_TEN : CodePoint = CodePoint::from(3440u32);
    pub const MALAYALAM_NUMBER_ONE_HUNDRED : CodePoint = CodePoint::from(3441u32);
    pub const MALAYALAM_NUMBER_ONE_THOUSAND : CodePoint = CodePoint::from(3442u32);
    pub const MALAYALAM_FRACTION_ONE_QUARTER : CodePoint = CodePoint::from(3443u32);
    pub const MALAYALAM_FRACTION_ONE_HALF : CodePoint = CodePoint::from(3444u32);
    pub const MALAYALAM_FRACTION_THREE_QUARTERS : CodePoint = CodePoint::from(3445u32);
    pub const MALAYALAM_FRACTION_ONE_SIXTEENTH : CodePoint = CodePoint::from(3446u32);
    pub const MALAYALAM_FRACTION_ONE_EIGHTH : CodePoint = CodePoint::from(3447u32);
    pub const MALAYALAM_FRACTION_THREE_SIXTEENTHS : CodePoint = CodePoint::from(3448u32);
    pub const MALAYALAM_DATE_MARK : CodePoint = CodePoint::from(3449u32);
    pub const MALAYALAM_LETTER_CHILLU_NN : CodePoint = CodePoint::from(3450u32);
    pub const MALAYALAM_LETTER_CHILLU_N : CodePoint = CodePoint::from(3451u32);
    pub const MALAYALAM_LETTER_CHILLU_RR : CodePoint = CodePoint::from(3452u32);
    pub const MALAYALAM_LETTER_CHILLU_L : CodePoint = CodePoint::from(3453u32);
    pub const MALAYALAM_LETTER_CHILLU_LL : CodePoint = CodePoint::from(3454u32);
    pub const MALAYALAM_LETTER_CHILLU_K : CodePoint = CodePoint::from(3455u32);
    pub const SINHALA_SIGN_ANUSVARAYA : CodePoint = CodePoint::from(3458u32);
    pub const SINHALA_SIGN_VISARGAYA : CodePoint = CodePoint::from(3459u32);
    pub const SINHALA_LETTER_AYANNA : CodePoint = CodePoint::from(3461u32);
    pub const SINHALA_LETTER_AAYANNA : CodePoint = CodePoint::from(3462u32);
    pub const SINHALA_LETTER_AEYANNA : CodePoint = CodePoint::from(3463u32);
    pub const SINHALA_LETTER_AEEYANNA : CodePoint = CodePoint::from(3464u32);
    pub const SINHALA_LETTER_IYANNA : CodePoint = CodePoint::from(3465u32);
    pub const SINHALA_LETTER_IIYANNA : CodePoint = CodePoint::from(3466u32);
    pub const SINHALA_LETTER_UYANNA : CodePoint = CodePoint::from(3467u32);
    pub const SINHALA_LETTER_UUYANNA : CodePoint = CodePoint::from(3468u32);
    pub const SINHALA_LETTER_IRUYANNA : CodePoint = CodePoint::from(3469u32);
    pub const SINHALA_LETTER_IRUUYANNA : CodePoint = CodePoint::from(3470u32);
    pub const SINHALA_LETTER_ILUYANNA : CodePoint = CodePoint::from(3471u32);
    pub const SINHALA_LETTER_ILUUYANNA : CodePoint = CodePoint::from(3472u32);
    pub const SINHALA_LETTER_EYANNA : CodePoint = CodePoint::from(3473u32);
    pub const SINHALA_LETTER_EEYANNA : CodePoint = CodePoint::from(3474u32);
    pub const SINHALA_LETTER_AIYANNA : CodePoint = CodePoint::from(3475u32);
    pub const SINHALA_LETTER_OYANNA : CodePoint = CodePoint::from(3476u32);
    pub const SINHALA_LETTER_OOYANNA : CodePoint = CodePoint::from(3477u32);
    pub const SINHALA_LETTER_AUYANNA : CodePoint = CodePoint::from(3478u32);
    pub const SINHALA_LETTER_ALPAPRAANA_KAYANNA : CodePoint = CodePoint::from(3482u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_KAYANNA : CodePoint = CodePoint::from(3483u32);
    pub const SINHALA_LETTER_ALPAPRAANA_GAYANNA : CodePoint = CodePoint::from(3484u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_GAYANNA : CodePoint = CodePoint::from(3485u32);
    pub const SINHALA_LETTER_KANTAJA_NAASIKYAYA : CodePoint = CodePoint::from(3486u32);
    pub const SINHALA_LETTER_SANYAKA_GAYANNA : CodePoint = CodePoint::from(3487u32);
    pub const SINHALA_LETTER_ALPAPRAANA_CAYANNA : CodePoint = CodePoint::from(3488u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_CAYANNA : CodePoint = CodePoint::from(3489u32);
    pub const SINHALA_LETTER_ALPAPRAANA_JAYANNA : CodePoint = CodePoint::from(3490u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_JAYANNA : CodePoint = CodePoint::from(3491u32);
    pub const SINHALA_LETTER_TAALUJA_NAASIKYAYA : CodePoint = CodePoint::from(3492u32);
    pub const SINHALA_LETTER_TAALUJA_SANYOOGA_NAAKSIKYAYA : CodePoint = CodePoint::from(3493u32);
    pub const SINHALA_LETTER_SANYAKA_JAYANNA : CodePoint = CodePoint::from(3494u32);
    pub const SINHALA_LETTER_ALPAPRAANA_TTAYANNA : CodePoint = CodePoint::from(3495u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_TTAYANNA : CodePoint = CodePoint::from(3496u32);
    pub const SINHALA_LETTER_ALPAPRAANA_DDAYANNA : CodePoint = CodePoint::from(3497u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_DDAYANNA : CodePoint = CodePoint::from(3498u32);
    pub const SINHALA_LETTER_MUURDHAJA_NAYANNA : CodePoint = CodePoint::from(3499u32);
    pub const SINHALA_LETTER_SANYAKA_DDAYANNA : CodePoint = CodePoint::from(3500u32);
    pub const SINHALA_LETTER_ALPAPRAANA_TAYANNA : CodePoint = CodePoint::from(3501u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_TAYANNA : CodePoint = CodePoint::from(3502u32);
    pub const SINHALA_LETTER_ALPAPRAANA_DAYANNA : CodePoint = CodePoint::from(3503u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_DAYANNA : CodePoint = CodePoint::from(3504u32);
    pub const SINHALA_LETTER_DANTAJA_NAYANNA : CodePoint = CodePoint::from(3505u32);
    pub const SINHALA_LETTER_SANYAKA_DAYANNA : CodePoint = CodePoint::from(3507u32);
    pub const SINHALA_LETTER_ALPAPRAANA_PAYANNA : CodePoint = CodePoint::from(3508u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_PAYANNA : CodePoint = CodePoint::from(3509u32);
    pub const SINHALA_LETTER_ALPAPRAANA_BAYANNA : CodePoint = CodePoint::from(3510u32);
    pub const SINHALA_LETTER_MAHAAPRAANA_BAYANNA : CodePoint = CodePoint::from(3511u32);
    pub const SINHALA_LETTER_MAYANNA : CodePoint = CodePoint::from(3512u32);
    pub const SINHALA_LETTER_AMBA_BAYANNA : CodePoint = CodePoint::from(3513u32);
    pub const SINHALA_LETTER_YAYANNA : CodePoint = CodePoint::from(3514u32);
    pub const SINHALA_LETTER_RAYANNA : CodePoint = CodePoint::from(3515u32);
    pub const SINHALA_LETTER_DANTAJA_LAYANNA : CodePoint = CodePoint::from(3517u32);
    pub const SINHALA_LETTER_VAYANNA : CodePoint = CodePoint::from(3520u32);
    pub const SINHALA_LETTER_TAALUJA_SAYANNA : CodePoint = CodePoint::from(3521u32);
    pub const SINHALA_LETTER_MUURDHAJA_SAYANNA : CodePoint = CodePoint::from(3522u32);
    pub const SINHALA_LETTER_DANTAJA_SAYANNA : CodePoint = CodePoint::from(3523u32);
    pub const SINHALA_LETTER_HAYANNA : CodePoint = CodePoint::from(3524u32);
    pub const SINHALA_LETTER_MUURDHAJA_LAYANNA : CodePoint = CodePoint::from(3525u32);
    pub const SINHALA_LETTER_FAYANNA : CodePoint = CodePoint::from(3526u32);
    pub const SINHALA_SIGN_AL_LAKUNA : CodePoint = CodePoint::from(3530u32);
    pub const SINHALA_VOWEL_SIGN_AELA_PILLA : CodePoint = CodePoint::from(3535u32);
    pub const SINHALA_VOWEL_SIGN_KETTI_AEDA_PILLA : CodePoint = CodePoint::from(3536u32);
    pub const SINHALA_VOWEL_SIGN_DIGA_AEDA_PILLA : CodePoint = CodePoint::from(3537u32);
    pub const SINHALA_VOWEL_SIGN_KETTI_IS_PILLA : CodePoint = CodePoint::from(3538u32);
    pub const SINHALA_VOWEL_SIGN_DIGA_IS_PILLA : CodePoint = CodePoint::from(3539u32);
    pub const SINHALA_VOWEL_SIGN_KETTI_PAA_PILLA : CodePoint = CodePoint::from(3540u32);
    pub const SINHALA_VOWEL_SIGN_DIGA_PAA_PILLA : CodePoint = CodePoint::from(3542u32);
    pub const SINHALA_VOWEL_SIGN_GAETTA_PILLA : CodePoint = CodePoint::from(3544u32);
    pub const SINHALA_VOWEL_SIGN_KOMBUVA : CodePoint = CodePoint::from(3545u32);
    pub const SINHALA_VOWEL_SIGN_DIGA_KOMBUVA : CodePoint = CodePoint::from(3546u32);
    pub const SINHALA_VOWEL_SIGN_KOMBU_DEKA : CodePoint = CodePoint::from(3547u32);
    pub const SINHALA_VOWEL_SIGN_KOMBUVA_HAA_AELA_PILLA : CodePoint = CodePoint::from(3548u32);
    pub const SINHALA_VOWEL_SIGN_KOMBUVA_HAA_DIGA_AELA_PILLA : CodePoint = CodePoint::from(3549u32);
    pub const SINHALA_VOWEL_SIGN_KOMBUVA_HAA_GAYANUKITTA : CodePoint = CodePoint::from(3550u32);
    pub const SINHALA_VOWEL_SIGN_GAYANUKITTA : CodePoint = CodePoint::from(3551u32);
    pub const SINHALA_LITH_DIGIT_ZERO : CodePoint = CodePoint::from(3558u32);
    pub const SINHALA_LITH_DIGIT_ONE : CodePoint = CodePoint::from(3559u32);
    pub const SINHALA_LITH_DIGIT_TWO : CodePoint = CodePoint::from(3560u32);
    pub const SINHALA_LITH_DIGIT_THREE : CodePoint = CodePoint::from(3561u32);
    pub const SINHALA_LITH_DIGIT_FOUR : CodePoint = CodePoint::from(3562u32);
    pub const SINHALA_LITH_DIGIT_FIVE : CodePoint = CodePoint::from(3563u32);
    pub const SINHALA_LITH_DIGIT_SIX : CodePoint = CodePoint::from(3564u32);
    pub const SINHALA_LITH_DIGIT_SEVEN : CodePoint = CodePoint::from(3565u32);
    pub const SINHALA_LITH_DIGIT_EIGHT : CodePoint = CodePoint::from(3566u32);
    pub const SINHALA_LITH_DIGIT_NINE : CodePoint = CodePoint::from(3567u32);
    pub const SINHALA_VOWEL_SIGN_DIGA_GAETTA_PILLA : CodePoint = CodePoint::from(3570u32);
    pub const SINHALA_VOWEL_SIGN_DIGA_GAYANUKITTA : CodePoint = CodePoint::from(3571u32);
    pub const SINHALA_PUNCTUATION_KUNDDALIYA : CodePoint = CodePoint::from(3572u32);
    pub const THAI_CHARACTER_KO_KAI : CodePoint = CodePoint::from(3585u32);
    pub const THAI_CHARACTER_KHO_KHAI : CodePoint = CodePoint::from(3586u32);
    pub const THAI_CHARACTER_KHO_KHUAT : CodePoint = CodePoint::from(3587u32);
    pub const THAI_CHARACTER_KHO_KHWAI : CodePoint = CodePoint::from(3588u32);
    pub const THAI_CHARACTER_KHO_KHON : CodePoint = CodePoint::from(3589u32);
    pub const THAI_CHARACTER_KHO_RAKHANG : CodePoint = CodePoint::from(3590u32);
    pub const THAI_CHARACTER_NGO_NGU : CodePoint = CodePoint::from(3591u32);
    pub const THAI_CHARACTER_CHO_CHAN : CodePoint = CodePoint::from(3592u32);
    pub const THAI_CHARACTER_CHO_CHING : CodePoint = CodePoint::from(3593u32);
    pub const THAI_CHARACTER_CHO_CHANG : CodePoint = CodePoint::from(3594u32);
    pub const THAI_CHARACTER_SO_SO : CodePoint = CodePoint::from(3595u32);
    pub const THAI_CHARACTER_CHO_CHOE : CodePoint = CodePoint::from(3596u32);
    pub const THAI_CHARACTER_YO_YING : CodePoint = CodePoint::from(3597u32);
    pub const THAI_CHARACTER_DO_CHADA : CodePoint = CodePoint::from(3598u32);
    pub const THAI_CHARACTER_TO_PATAK : CodePoint = CodePoint::from(3599u32);
    pub const THAI_CHARACTER_THO_THAN : CodePoint = CodePoint::from(3600u32);
    pub const THAI_CHARACTER_THO_NANGMONTHO : CodePoint = CodePoint::from(3601u32);
    pub const THAI_CHARACTER_THO_PHUTHAO : CodePoint = CodePoint::from(3602u32);
    pub const THAI_CHARACTER_NO_NEN : CodePoint = CodePoint::from(3603u32);
    pub const THAI_CHARACTER_DO_DEK : CodePoint = CodePoint::from(3604u32);
    pub const THAI_CHARACTER_TO_TAO : CodePoint = CodePoint::from(3605u32);
    pub const THAI_CHARACTER_THO_THUNG : CodePoint = CodePoint::from(3606u32);
    pub const THAI_CHARACTER_THO_THAHAN : CodePoint = CodePoint::from(3607u32);
    pub const THAI_CHARACTER_THO_THONG : CodePoint = CodePoint::from(3608u32);
    pub const THAI_CHARACTER_NO_NU : CodePoint = CodePoint::from(3609u32);
    pub const THAI_CHARACTER_BO_BAIMAI : CodePoint = CodePoint::from(3610u32);
    pub const THAI_CHARACTER_PO_PLA : CodePoint = CodePoint::from(3611u32);
    pub const THAI_CHARACTER_PHO_PHUNG : CodePoint = CodePoint::from(3612u32);
    pub const THAI_CHARACTER_FO_FA : CodePoint = CodePoint::from(3613u32);
    pub const THAI_CHARACTER_PHO_PHAN : CodePoint = CodePoint::from(3614u32);
    pub const THAI_CHARACTER_FO_FAN : CodePoint = CodePoint::from(3615u32);
    pub const THAI_CHARACTER_PHO_SAMPHAO : CodePoint = CodePoint::from(3616u32);
    pub const THAI_CHARACTER_MO_MA : CodePoint = CodePoint::from(3617u32);
    pub const THAI_CHARACTER_YO_YAK : CodePoint = CodePoint::from(3618u32);
    pub const THAI_CHARACTER_RO_RUA : CodePoint = CodePoint::from(3619u32);
    pub const THAI_CHARACTER_RU : CodePoint = CodePoint::from(3620u32);
    pub const THAI_CHARACTER_LO_LING : CodePoint = CodePoint::from(3621u32);
    pub const THAI_CHARACTER_LU : CodePoint = CodePoint::from(3622u32);
    pub const THAI_CHARACTER_WO_WAEN : CodePoint = CodePoint::from(3623u32);
    pub const THAI_CHARACTER_SO_SALA : CodePoint = CodePoint::from(3624u32);
    pub const THAI_CHARACTER_SO_RUSI : CodePoint = CodePoint::from(3625u32);
    pub const THAI_CHARACTER_SO_SUA : CodePoint = CodePoint::from(3626u32);
    pub const THAI_CHARACTER_HO_HIP : CodePoint = CodePoint::from(3627u32);
    pub const THAI_CHARACTER_LO_CHULA : CodePoint = CodePoint::from(3628u32);
    pub const THAI_CHARACTER_O_ANG : CodePoint = CodePoint::from(3629u32);
    pub const THAI_CHARACTER_HO_NOKHUK : CodePoint = CodePoint::from(3630u32);
    pub const THAI_CHARACTER_PAIYANNOI : CodePoint = CodePoint::from(3631u32);
    pub const THAI_CHARACTER_SARA_A : CodePoint = CodePoint::from(3632u32);
    pub const THAI_CHARACTER_MAI_HAN_AKAT : CodePoint = CodePoint::from(3633u32);
    pub const THAI_CHARACTER_SARA_AA : CodePoint = CodePoint::from(3634u32);
    pub const THAI_CHARACTER_SARA_AM : CodePoint = CodePoint::from(3635u32);
    pub const THAI_CHARACTER_SARA_I : CodePoint = CodePoint::from(3636u32);
    pub const THAI_CHARACTER_SARA_II : CodePoint = CodePoint::from(3637u32);
    pub const THAI_CHARACTER_SARA_UE : CodePoint = CodePoint::from(3638u32);
    pub const THAI_CHARACTER_SARA_UEE : CodePoint = CodePoint::from(3639u32);
    pub const THAI_CHARACTER_SARA_U : CodePoint = CodePoint::from(3640u32);
    pub const THAI_CHARACTER_SARA_UU : CodePoint = CodePoint::from(3641u32);
    pub const THAI_CHARACTER_PHINTHU : CodePoint = CodePoint::from(3642u32);
    pub const THAI_CURRENCY_SYMBOL_BAHT : CodePoint = CodePoint::from(3647u32);
    pub const THAI_CHARACTER_SARA_E : CodePoint = CodePoint::from(3648u32);
    pub const THAI_CHARACTER_SARA_AE : CodePoint = CodePoint::from(3649u32);
    pub const THAI_CHARACTER_SARA_O : CodePoint = CodePoint::from(3650u32);
    pub const THAI_CHARACTER_SARA_AI_MAIMUAN : CodePoint = CodePoint::from(3651u32);
    pub const THAI_CHARACTER_SARA_AI_MAIMALAI : CodePoint = CodePoint::from(3652u32);
    pub const THAI_CHARACTER_LAKKHANGYAO : CodePoint = CodePoint::from(3653u32);
    pub const THAI_CHARACTER_MAIYAMOK : CodePoint = CodePoint::from(3654u32);
    pub const THAI_CHARACTER_MAITAIKHU : CodePoint = CodePoint::from(3655u32);
    pub const THAI_CHARACTER_MAI_EK : CodePoint = CodePoint::from(3656u32);
    pub const THAI_CHARACTER_MAI_THO : CodePoint = CodePoint::from(3657u32);
    pub const THAI_CHARACTER_MAI_TRI : CodePoint = CodePoint::from(3658u32);
    pub const THAI_CHARACTER_MAI_CHATTAWA : CodePoint = CodePoint::from(3659u32);
    pub const THAI_CHARACTER_THANTHAKHAT : CodePoint = CodePoint::from(3660u32);
    pub const THAI_CHARACTER_NIKHAHIT : CodePoint = CodePoint::from(3661u32);
    pub const THAI_CHARACTER_YAMAKKAN : CodePoint = CodePoint::from(3662u32);
    pub const THAI_CHARACTER_FONGMAN : CodePoint = CodePoint::from(3663u32);
    pub const THAI_DIGIT_ZERO : CodePoint = CodePoint::from(3664u32);
    pub const THAI_DIGIT_ONE : CodePoint = CodePoint::from(3665u32);
    pub const THAI_DIGIT_TWO : CodePoint = CodePoint::from(3666u32);
    pub const THAI_DIGIT_THREE : CodePoint = CodePoint::from(3667u32);
    pub const THAI_DIGIT_FOUR : CodePoint = CodePoint::from(3668u32);
    pub const THAI_DIGIT_FIVE : CodePoint = CodePoint::from(3669u32);
    pub const THAI_DIGIT_SIX : CodePoint = CodePoint::from(3670u32);
    pub const THAI_DIGIT_SEVEN : CodePoint = CodePoint::from(3671u32);
    pub const THAI_DIGIT_EIGHT : CodePoint = CodePoint::from(3672u32);
    pub const THAI_DIGIT_NINE : CodePoint = CodePoint::from(3673u32);
    pub const THAI_CHARACTER_ANGKHANKHU : CodePoint = CodePoint::from(3674u32);
    pub const THAI_CHARACTER_KHOMUT : CodePoint = CodePoint::from(3675u32);
    pub const LAO_LETTER_KO : CodePoint = CodePoint::from(3713u32);
    pub const LAO_LETTER_KHO_SUNG : CodePoint = CodePoint::from(3714u32);
    pub const LAO_LETTER_KHO_TAM : CodePoint = CodePoint::from(3716u32);
    pub const LAO_LETTER_PALI_GHA : CodePoint = CodePoint::from(3718u32);
    pub const LAO_LETTER_NGO : CodePoint = CodePoint::from(3719u32);
    pub const LAO_LETTER_CO : CodePoint = CodePoint::from(3720u32);
    pub const LAO_LETTER_PALI_CHA : CodePoint = CodePoint::from(3721u32);
    pub const LAO_LETTER_SO_TAM : CodePoint = CodePoint::from(3722u32);
    pub const LAO_LETTER_PALI_JHA : CodePoint = CodePoint::from(3724u32);
    pub const LAO_LETTER_NYO : CodePoint = CodePoint::from(3725u32);
    pub const LAO_LETTER_PALI_NYA : CodePoint = CodePoint::from(3726u32);
    pub const LAO_LETTER_PALI_TTA : CodePoint = CodePoint::from(3727u32);
    pub const LAO_LETTER_PALI_TTHA : CodePoint = CodePoint::from(3728u32);
    pub const LAO_LETTER_PALI_DDA : CodePoint = CodePoint::from(3729u32);
    pub const LAO_LETTER_PALI_DDHA : CodePoint = CodePoint::from(3730u32);
    pub const LAO_LETTER_PALI_NNA : CodePoint = CodePoint::from(3731u32);
    pub const LAO_LETTER_DO : CodePoint = CodePoint::from(3732u32);
    pub const LAO_LETTER_TO : CodePoint = CodePoint::from(3733u32);
    pub const LAO_LETTER_THO_SUNG : CodePoint = CodePoint::from(3734u32);
    pub const LAO_LETTER_THO_TAM : CodePoint = CodePoint::from(3735u32);
    pub const LAO_LETTER_PALI_DHA : CodePoint = CodePoint::from(3736u32);
    pub const LAO_LETTER_NO : CodePoint = CodePoint::from(3737u32);
    pub const LAO_LETTER_BO : CodePoint = CodePoint::from(3738u32);
    pub const LAO_LETTER_PO : CodePoint = CodePoint::from(3739u32);
    pub const LAO_LETTER_PHO_SUNG : CodePoint = CodePoint::from(3740u32);
    pub const LAO_LETTER_FO_TAM : CodePoint = CodePoint::from(3741u32);
    pub const LAO_LETTER_PHO_TAM : CodePoint = CodePoint::from(3742u32);
    pub const LAO_LETTER_FO_SUNG : CodePoint = CodePoint::from(3743u32);
    pub const LAO_LETTER_PALI_BHA : CodePoint = CodePoint::from(3744u32);
    pub const LAO_LETTER_MO : CodePoint = CodePoint::from(3745u32);
    pub const LAO_LETTER_YO : CodePoint = CodePoint::from(3746u32);
    pub const LAO_LETTER_LO_LING : CodePoint = CodePoint::from(3747u32);
    pub const LAO_LETTER_LO_LOOT : CodePoint = CodePoint::from(3749u32);
    pub const LAO_LETTER_WO : CodePoint = CodePoint::from(3751u32);
    pub const LAO_LETTER_SANSKRIT_SHA : CodePoint = CodePoint::from(3752u32);
    pub const LAO_LETTER_SANSKRIT_SSA : CodePoint = CodePoint::from(3753u32);
    pub const LAO_LETTER_SO_SUNG : CodePoint = CodePoint::from(3754u32);
    pub const LAO_LETTER_HO_SUNG : CodePoint = CodePoint::from(3755u32);
    pub const LAO_LETTER_PALI_LLA : CodePoint = CodePoint::from(3756u32);
    pub const LAO_LETTER_O : CodePoint = CodePoint::from(3757u32);
    pub const LAO_LETTER_HO_TAM : CodePoint = CodePoint::from(3758u32);
    pub const LAO_ELLIPSIS : CodePoint = CodePoint::from(3759u32);
    pub const LAO_VOWEL_SIGN_A : CodePoint = CodePoint::from(3760u32);
    pub const LAO_VOWEL_SIGN_MAI_KAN : CodePoint = CodePoint::from(3761u32);
    pub const LAO_VOWEL_SIGN_AA : CodePoint = CodePoint::from(3762u32);
    pub const LAO_VOWEL_SIGN_AM : CodePoint = CodePoint::from(3763u32);
    pub const LAO_VOWEL_SIGN_I : CodePoint = CodePoint::from(3764u32);
    pub const LAO_VOWEL_SIGN_II : CodePoint = CodePoint::from(3765u32);
    pub const LAO_VOWEL_SIGN_Y : CodePoint = CodePoint::from(3766u32);
    pub const LAO_VOWEL_SIGN_YY : CodePoint = CodePoint::from(3767u32);
    pub const LAO_VOWEL_SIGN_U : CodePoint = CodePoint::from(3768u32);
    pub const LAO_VOWEL_SIGN_UU : CodePoint = CodePoint::from(3769u32);
    pub const LAO_SIGN_PALI_VIRAMA : CodePoint = CodePoint::from(3770u32);
    pub const LAO_VOWEL_SIGN_MAI_KON : CodePoint = CodePoint::from(3771u32);
    pub const LAO_SEMIVOWEL_SIGN_LO : CodePoint = CodePoint::from(3772u32);
    pub const LAO_SEMIVOWEL_SIGN_NYO : CodePoint = CodePoint::from(3773u32);
    pub const LAO_VOWEL_SIGN_E : CodePoint = CodePoint::from(3776u32);
    pub const LAO_VOWEL_SIGN_EI : CodePoint = CodePoint::from(3777u32);
    pub const LAO_VOWEL_SIGN_O : CodePoint = CodePoint::from(3778u32);
    pub const LAO_VOWEL_SIGN_AY : CodePoint = CodePoint::from(3779u32);
    pub const LAO_VOWEL_SIGN_AI : CodePoint = CodePoint::from(3780u32);
    pub const LAO_KO_LA : CodePoint = CodePoint::from(3782u32);
    pub const LAO_TONE_MAI_EK : CodePoint = CodePoint::from(3784u32);
    pub const LAO_TONE_MAI_THO : CodePoint = CodePoint::from(3785u32);
    pub const LAO_TONE_MAI_TI : CodePoint = CodePoint::from(3786u32);
    pub const LAO_TONE_MAI_CATAWA : CodePoint = CodePoint::from(3787u32);
    pub const LAO_CANCELLATION_MARK : CodePoint = CodePoint::from(3788u32);
    pub const LAO_NIGGAHITA : CodePoint = CodePoint::from(3789u32);
    pub const LAO_DIGIT_ZERO : CodePoint = CodePoint::from(3792u32);
    pub const LAO_DIGIT_ONE : CodePoint = CodePoint::from(3793u32);
    pub const LAO_DIGIT_TWO : CodePoint = CodePoint::from(3794u32);
    pub const LAO_DIGIT_THREE : CodePoint = CodePoint::from(3795u32);
    pub const LAO_DIGIT_FOUR : CodePoint = CodePoint::from(3796u32);
    pub const LAO_DIGIT_FIVE : CodePoint = CodePoint::from(3797u32);
    pub const LAO_DIGIT_SIX : CodePoint = CodePoint::from(3798u32);
    pub const LAO_DIGIT_SEVEN : CodePoint = CodePoint::from(3799u32);
    pub const LAO_DIGIT_EIGHT : CodePoint = CodePoint::from(3800u32);
    pub const LAO_DIGIT_NINE : CodePoint = CodePoint::from(3801u32);
    pub const LAO_HO_NO : CodePoint = CodePoint::from(3804u32);
    pub const LAO_HO_MO : CodePoint = CodePoint::from(3805u32);
    pub const LAO_LETTER_KHMU_GO : CodePoint = CodePoint::from(3806u32);
    pub const LAO_LETTER_KHMU_NYO : CodePoint = CodePoint::from(3807u32);
    pub const TIBETAN_SYLLABLE_OM : CodePoint = CodePoint::from(3840u32);
    pub const TIBETAN_MARK_GTER_YIG_MGO_TRUNCATED_A : CodePoint = CodePoint::from(3841u32);
    pub const TIBETAN_MARK_GTER_YIG_MGO__UM_RNAM_BCAD_MA : CodePoint = CodePoint::from(3842u32);
    pub const TIBETAN_MARK_GTER_YIG_MGO__UM_GTER_TSHEG_MA : CodePoint = CodePoint::from(3843u32);
    pub const TIBETAN_MARK_INITIAL_YIG_MGO_MDUN_MA : CodePoint = CodePoint::from(3844u32);
    pub const TIBETAN_MARK_CLOSING_YIG_MGO_SGAB_MA : CodePoint = CodePoint::from(3845u32);
    pub const TIBETAN_MARK_CARET_YIG_MGO_PHUR_SHAD_MA : CodePoint = CodePoint::from(3846u32);
    pub const TIBETAN_MARK_YIG_MGO_TSHEG_SHAD_MA : CodePoint = CodePoint::from(3847u32);
    pub const TIBETAN_MARK_SBRUL_SHAD : CodePoint = CodePoint::from(3848u32);
    pub const TIBETAN_MARK_BSKUR_YIG_MGO : CodePoint = CodePoint::from(3849u32);
    pub const TIBETAN_MARK_BKA__SHOG_YIG_MGO : CodePoint = CodePoint::from(3850u32);
    pub const TIBETAN_MARK_INTERSYLLABIC_TSHEG : CodePoint = CodePoint::from(3851u32);
    pub const TIBETAN_MARK_DELIMITER_TSHEG_BSTAR : CodePoint = CodePoint::from(3852u32);
    pub const TIBETAN_MARK_SHAD : CodePoint = CodePoint::from(3853u32);
    pub const TIBETAN_MARK_NYIS_SHAD : CodePoint = CodePoint::from(3854u32);
    pub const TIBETAN_MARK_TSHEG_SHAD : CodePoint = CodePoint::from(3855u32);
    pub const TIBETAN_MARK_NYIS_TSHEG_SHAD : CodePoint = CodePoint::from(3856u32);
    pub const TIBETAN_MARK_RIN_CHEN_SPUNGS_SHAD : CodePoint = CodePoint::from(3857u32);
    pub const TIBETAN_MARK_RGYA_GRAM_SHAD : CodePoint = CodePoint::from(3858u32);
    pub const TIBETAN_MARK_CARET__DZUD_RTAGS_ME_LONG_CAN : CodePoint = CodePoint::from(3859u32);
    pub const TIBETAN_MARK_GTER_TSHEG : CodePoint = CodePoint::from(3860u32);
    pub const TIBETAN_LOGOTYPE_SIGN_CHAD_RTAGS : CodePoint = CodePoint::from(3861u32);
    pub const TIBETAN_LOGOTYPE_SIGN_LHAG_RTAGS : CodePoint = CodePoint::from(3862u32);
    pub const TIBETAN_ASTROLOGICAL_SIGN_SGRA_GCAN__CHAR_RTAGS : CodePoint = CodePoint::from(3863u32);
    pub const TIBETAN_ASTROLOGICAL_SIGN__KHYUD_PA : CodePoint = CodePoint::from(3864u32);
    pub const TIBETAN_ASTROLOGICAL_SIGN_SDONG_TSHUGS : CodePoint = CodePoint::from(3865u32);
    pub const TIBETAN_SIGN_RDEL_DKAR_GCIG : CodePoint = CodePoint::from(3866u32);
    pub const TIBETAN_SIGN_RDEL_DKAR_GNYIS : CodePoint = CodePoint::from(3867u32);
    pub const TIBETAN_SIGN_RDEL_DKAR_GSUM : CodePoint = CodePoint::from(3868u32);
    pub const TIBETAN_SIGN_RDEL_NAG_GCIG : CodePoint = CodePoint::from(3869u32);
    pub const TIBETAN_SIGN_RDEL_NAG_GNYIS : CodePoint = CodePoint::from(3870u32);
    pub const TIBETAN_SIGN_RDEL_DKAR_RDEL_NAG : CodePoint = CodePoint::from(3871u32);
    pub const TIBETAN_DIGIT_ZERO : CodePoint = CodePoint::from(3872u32);
    pub const TIBETAN_DIGIT_ONE : CodePoint = CodePoint::from(3873u32);
    pub const TIBETAN_DIGIT_TWO : CodePoint = CodePoint::from(3874u32);
    pub const TIBETAN_DIGIT_THREE : CodePoint = CodePoint::from(3875u32);
    pub const TIBETAN_DIGIT_FOUR : CodePoint = CodePoint::from(3876u32);
    pub const TIBETAN_DIGIT_FIVE : CodePoint = CodePoint::from(3877u32);
    pub const TIBETAN_DIGIT_SIX : CodePoint = CodePoint::from(3878u32);
    pub const TIBETAN_DIGIT_SEVEN : CodePoint = CodePoint::from(3879u32);
    pub const TIBETAN_DIGIT_EIGHT : CodePoint = CodePoint::from(3880u32);
    pub const TIBETAN_DIGIT_NINE : CodePoint = CodePoint::from(3881u32);
    pub const TIBETAN_DIGIT_HALF_ONE : CodePoint = CodePoint::from(3882u32);
    pub const TIBETAN_DIGIT_HALF_TWO : CodePoint = CodePoint::from(3883u32);
    pub const TIBETAN_DIGIT_HALF_THREE : CodePoint = CodePoint::from(3884u32);
    pub const TIBETAN_DIGIT_HALF_FOUR : CodePoint = CodePoint::from(3885u32);
    pub const TIBETAN_DIGIT_HALF_FIVE : CodePoint = CodePoint::from(3886u32);
    pub const TIBETAN_DIGIT_HALF_SIX : CodePoint = CodePoint::from(3887u32);
    pub const TIBETAN_DIGIT_HALF_SEVEN : CodePoint = CodePoint::from(3888u32);
    pub const TIBETAN_DIGIT_HALF_EIGHT : CodePoint = CodePoint::from(3889u32);
    pub const TIBETAN_DIGIT_HALF_NINE : CodePoint = CodePoint::from(3890u32);
    pub const TIBETAN_DIGIT_HALF_ZERO : CodePoint = CodePoint::from(3891u32);
    pub const TIBETAN_MARK_BSDUS_RTAGS : CodePoint = CodePoint::from(3892u32);
    pub const TIBETAN_MARK_NGAS_BZUNG_NYI_ZLA : CodePoint = CodePoint::from(3893u32);
    pub const TIBETAN_MARK_CARET__DZUD_RTAGS_BZHI_MIG_CAN : CodePoint = CodePoint::from(3894u32);
    pub const TIBETAN_MARK_NGAS_BZUNG_SGOR_RTAGS : CodePoint = CodePoint::from(3895u32);
    pub const TIBETAN_MARK_CHE_MGO : CodePoint = CodePoint::from(3896u32);
    pub const TIBETAN_MARK_TSA__PHRU : CodePoint = CodePoint::from(3897u32);
    pub const TIBETAN_MARK_GUG_RTAGS_GYON : CodePoint = CodePoint::from(3898u32);
    pub const TIBETAN_MARK_GUG_RTAGS_GYAS : CodePoint = CodePoint::from(3899u32);
    pub const TIBETAN_MARK_ANG_KHANG_GYON : CodePoint = CodePoint::from(3900u32);
    pub const TIBETAN_MARK_ANG_KHANG_GYAS : CodePoint = CodePoint::from(3901u32);
    pub const TIBETAN_SIGN_YAR_TSHES : CodePoint = CodePoint::from(3902u32);
    pub const TIBETAN_SIGN_MAR_TSHES : CodePoint = CodePoint::from(3903u32);
    pub const TIBETAN_LETTER_KA : CodePoint = CodePoint::from(3904u32);
    pub const TIBETAN_LETTER_KHA : CodePoint = CodePoint::from(3905u32);
    pub const TIBETAN_LETTER_GA : CodePoint = CodePoint::from(3906u32);
    pub const TIBETAN_LETTER_GHA : CodePoint = CodePoint::from(3907u32);
    pub const TIBETAN_LETTER_NGA : CodePoint = CodePoint::from(3908u32);
    pub const TIBETAN_LETTER_CA : CodePoint = CodePoint::from(3909u32);
    pub const TIBETAN_LETTER_CHA : CodePoint = CodePoint::from(3910u32);
    pub const TIBETAN_LETTER_JA : CodePoint = CodePoint::from(3911u32);
    pub const TIBETAN_LETTER_NYA : CodePoint = CodePoint::from(3913u32);
    pub const TIBETAN_LETTER_TTA : CodePoint = CodePoint::from(3914u32);
    pub const TIBETAN_LETTER_TTHA : CodePoint = CodePoint::from(3915u32);
    pub const TIBETAN_LETTER_DDA : CodePoint = CodePoint::from(3916u32);
    pub const TIBETAN_LETTER_DDHA : CodePoint = CodePoint::from(3917u32);
    pub const TIBETAN_LETTER_NNA : CodePoint = CodePoint::from(3918u32);
    pub const TIBETAN_LETTER_TA : CodePoint = CodePoint::from(3919u32);
    pub const TIBETAN_LETTER_THA : CodePoint = CodePoint::from(3920u32);
    pub const TIBETAN_LETTER_DA : CodePoint = CodePoint::from(3921u32);
    pub const TIBETAN_LETTER_DHA : CodePoint = CodePoint::from(3922u32);
    pub const TIBETAN_LETTER_NA : CodePoint = CodePoint::from(3923u32);
    pub const TIBETAN_LETTER_PA : CodePoint = CodePoint::from(3924u32);
    pub const TIBETAN_LETTER_PHA : CodePoint = CodePoint::from(3925u32);
    pub const TIBETAN_LETTER_BA : CodePoint = CodePoint::from(3926u32);
    pub const TIBETAN_LETTER_BHA : CodePoint = CodePoint::from(3927u32);
    pub const TIBETAN_LETTER_MA : CodePoint = CodePoint::from(3928u32);
    pub const TIBETAN_LETTER_TSA : CodePoint = CodePoint::from(3929u32);
    pub const TIBETAN_LETTER_TSHA : CodePoint = CodePoint::from(3930u32);
    pub const TIBETAN_LETTER_DZA : CodePoint = CodePoint::from(3931u32);
    pub const TIBETAN_LETTER_DZHA : CodePoint = CodePoint::from(3932u32);
    pub const TIBETAN_LETTER_WA : CodePoint = CodePoint::from(3933u32);
    pub const TIBETAN_LETTER_ZHA : CodePoint = CodePoint::from(3934u32);
    pub const TIBETAN_LETTER_ZA : CodePoint = CodePoint::from(3935u32);
    pub const TIBETAN_LETTER__A : CodePoint = CodePoint::from(3936u32);
    pub const TIBETAN_LETTER_YA : CodePoint = CodePoint::from(3937u32);
    pub const TIBETAN_LETTER_RA : CodePoint = CodePoint::from(3938u32);
    pub const TIBETAN_LETTER_LA : CodePoint = CodePoint::from(3939u32);
    pub const TIBETAN_LETTER_SHA : CodePoint = CodePoint::from(3940u32);
    pub const TIBETAN_LETTER_SSA : CodePoint = CodePoint::from(3941u32);
    pub const TIBETAN_LETTER_SA : CodePoint = CodePoint::from(3942u32);
    pub const TIBETAN_LETTER_HA : CodePoint = CodePoint::from(3943u32);
    pub const TIBETAN_LETTER_A : CodePoint = CodePoint::from(3944u32);
    pub const TIBETAN_LETTER_KSSA : CodePoint = CodePoint::from(3945u32);
    pub const TIBETAN_LETTER_FIXED_FORM_RA : CodePoint = CodePoint::from(3946u32);
    pub const TIBETAN_LETTER_KKA : CodePoint = CodePoint::from(3947u32);
    pub const TIBETAN_LETTER_RRA : CodePoint = CodePoint::from(3948u32);
    pub const TIBETAN_VOWEL_SIGN_AA : CodePoint = CodePoint::from(3953u32);
    pub const TIBETAN_VOWEL_SIGN_I : CodePoint = CodePoint::from(3954u32);
    pub const TIBETAN_VOWEL_SIGN_II : CodePoint = CodePoint::from(3955u32);
    pub const TIBETAN_VOWEL_SIGN_U : CodePoint = CodePoint::from(3956u32);
    pub const TIBETAN_VOWEL_SIGN_UU : CodePoint = CodePoint::from(3957u32);
    pub const TIBETAN_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(3958u32);
    pub const TIBETAN_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(3959u32);
    pub const TIBETAN_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(3960u32);
    pub const TIBETAN_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(3961u32);
    pub const TIBETAN_VOWEL_SIGN_E : CodePoint = CodePoint::from(3962u32);
    pub const TIBETAN_VOWEL_SIGN_EE : CodePoint = CodePoint::from(3963u32);
    pub const TIBETAN_VOWEL_SIGN_O : CodePoint = CodePoint::from(3964u32);
    pub const TIBETAN_VOWEL_SIGN_OO : CodePoint = CodePoint::from(3965u32);
    pub const TIBETAN_SIGN_RJES_SU_NGA_RO : CodePoint = CodePoint::from(3966u32);
    pub const TIBETAN_SIGN_RNAM_BCAD : CodePoint = CodePoint::from(3967u32);
    pub const TIBETAN_VOWEL_SIGN_REVERSED_I : CodePoint = CodePoint::from(3968u32);
    pub const TIBETAN_VOWEL_SIGN_REVERSED_II : CodePoint = CodePoint::from(3969u32);
    pub const TIBETAN_SIGN_NYI_ZLA_NAA_DA : CodePoint = CodePoint::from(3970u32);
    pub const TIBETAN_SIGN_SNA_LDAN : CodePoint = CodePoint::from(3971u32);
    pub const TIBETAN_MARK_HALANTA : CodePoint = CodePoint::from(3972u32);
    pub const TIBETAN_MARK_PALUTA : CodePoint = CodePoint::from(3973u32);
    pub const TIBETAN_SIGN_LCI_RTAGS : CodePoint = CodePoint::from(3974u32);
    pub const TIBETAN_SIGN_YANG_RTAGS : CodePoint = CodePoint::from(3975u32);
    pub const TIBETAN_SIGN_LCE_TSA_CAN : CodePoint = CodePoint::from(3976u32);
    pub const TIBETAN_SIGN_MCHU_CAN : CodePoint = CodePoint::from(3977u32);
    pub const TIBETAN_SIGN_GRU_CAN_RGYINGS : CodePoint = CodePoint::from(3978u32);
    pub const TIBETAN_SIGN_GRU_MED_RGYINGS : CodePoint = CodePoint::from(3979u32);
    pub const TIBETAN_SIGN_INVERTED_MCHU_CAN : CodePoint = CodePoint::from(3980u32);
    pub const TIBETAN_SUBJOINED_SIGN_LCE_TSA_CAN : CodePoint = CodePoint::from(3981u32);
    pub const TIBETAN_SUBJOINED_SIGN_MCHU_CAN : CodePoint = CodePoint::from(3982u32);
    pub const TIBETAN_SUBJOINED_SIGN_INVERTED_MCHU_CAN : CodePoint = CodePoint::from(3983u32);
    pub const TIBETAN_SUBJOINED_LETTER_KA : CodePoint = CodePoint::from(3984u32);
    pub const TIBETAN_SUBJOINED_LETTER_KHA : CodePoint = CodePoint::from(3985u32);
    pub const TIBETAN_SUBJOINED_LETTER_GA : CodePoint = CodePoint::from(3986u32);
    pub const TIBETAN_SUBJOINED_LETTER_GHA : CodePoint = CodePoint::from(3987u32);
    pub const TIBETAN_SUBJOINED_LETTER_NGA : CodePoint = CodePoint::from(3988u32);
    pub const TIBETAN_SUBJOINED_LETTER_CA : CodePoint = CodePoint::from(3989u32);
    pub const TIBETAN_SUBJOINED_LETTER_CHA : CodePoint = CodePoint::from(3990u32);
    pub const TIBETAN_SUBJOINED_LETTER_JA : CodePoint = CodePoint::from(3991u32);
    pub const TIBETAN_SUBJOINED_LETTER_NYA : CodePoint = CodePoint::from(3993u32);
    pub const TIBETAN_SUBJOINED_LETTER_TTA : CodePoint = CodePoint::from(3994u32);
    pub const TIBETAN_SUBJOINED_LETTER_TTHA : CodePoint = CodePoint::from(3995u32);
    pub const TIBETAN_SUBJOINED_LETTER_DDA : CodePoint = CodePoint::from(3996u32);
    pub const TIBETAN_SUBJOINED_LETTER_DDHA : CodePoint = CodePoint::from(3997u32);
    pub const TIBETAN_SUBJOINED_LETTER_NNA : CodePoint = CodePoint::from(3998u32);
    pub const TIBETAN_SUBJOINED_LETTER_TA : CodePoint = CodePoint::from(3999u32);
    pub const TIBETAN_SUBJOINED_LETTER_THA : CodePoint = CodePoint::from(4000u32);
    pub const TIBETAN_SUBJOINED_LETTER_DA : CodePoint = CodePoint::from(4001u32);
    pub const TIBETAN_SUBJOINED_LETTER_DHA : CodePoint = CodePoint::from(4002u32);
    pub const TIBETAN_SUBJOINED_LETTER_NA : CodePoint = CodePoint::from(4003u32);
    pub const TIBETAN_SUBJOINED_LETTER_PA : CodePoint = CodePoint::from(4004u32);
    pub const TIBETAN_SUBJOINED_LETTER_PHA : CodePoint = CodePoint::from(4005u32);
    pub const TIBETAN_SUBJOINED_LETTER_BA : CodePoint = CodePoint::from(4006u32);
    pub const TIBETAN_SUBJOINED_LETTER_BHA : CodePoint = CodePoint::from(4007u32);
    pub const TIBETAN_SUBJOINED_LETTER_MA : CodePoint = CodePoint::from(4008u32);
    pub const TIBETAN_SUBJOINED_LETTER_TSA : CodePoint = CodePoint::from(4009u32);
    pub const TIBETAN_SUBJOINED_LETTER_TSHA : CodePoint = CodePoint::from(4010u32);
    pub const TIBETAN_SUBJOINED_LETTER_DZA : CodePoint = CodePoint::from(4011u32);
    pub const TIBETAN_SUBJOINED_LETTER_DZHA : CodePoint = CodePoint::from(4012u32);
    pub const TIBETAN_SUBJOINED_LETTER_WA : CodePoint = CodePoint::from(4013u32);
    pub const TIBETAN_SUBJOINED_LETTER_ZHA : CodePoint = CodePoint::from(4014u32);
    pub const TIBETAN_SUBJOINED_LETTER_ZA : CodePoint = CodePoint::from(4015u32);
    pub const TIBETAN_SUBJOINED_LETTER__A : CodePoint = CodePoint::from(4016u32);
    pub const TIBETAN_SUBJOINED_LETTER_YA : CodePoint = CodePoint::from(4017u32);
    pub const TIBETAN_SUBJOINED_LETTER_RA : CodePoint = CodePoint::from(4018u32);
    pub const TIBETAN_SUBJOINED_LETTER_LA : CodePoint = CodePoint::from(4019u32);
    pub const TIBETAN_SUBJOINED_LETTER_SHA : CodePoint = CodePoint::from(4020u32);
    pub const TIBETAN_SUBJOINED_LETTER_SSA : CodePoint = CodePoint::from(4021u32);
    pub const TIBETAN_SUBJOINED_LETTER_SA : CodePoint = CodePoint::from(4022u32);
    pub const TIBETAN_SUBJOINED_LETTER_HA : CodePoint = CodePoint::from(4023u32);
    pub const TIBETAN_SUBJOINED_LETTER_A : CodePoint = CodePoint::from(4024u32);
    pub const TIBETAN_SUBJOINED_LETTER_KSSA : CodePoint = CodePoint::from(4025u32);
    pub const TIBETAN_SUBJOINED_LETTER_FIXED_FORM_WA : CodePoint = CodePoint::from(4026u32);
    pub const TIBETAN_SUBJOINED_LETTER_FIXED_FORM_YA : CodePoint = CodePoint::from(4027u32);
    pub const TIBETAN_SUBJOINED_LETTER_FIXED_FORM_RA : CodePoint = CodePoint::from(4028u32);
    pub const TIBETAN_KU_RU_KHA : CodePoint = CodePoint::from(4030u32);
    pub const TIBETAN_KU_RU_KHA_BZHI_MIG_CAN : CodePoint = CodePoint::from(4031u32);
    pub const TIBETAN_CANTILLATION_SIGN_HEAVY_BEAT : CodePoint = CodePoint::from(4032u32);
    pub const TIBETAN_CANTILLATION_SIGN_LIGHT_BEAT : CodePoint = CodePoint::from(4033u32);
    pub const TIBETAN_CANTILLATION_SIGN_CANG_TE_U : CodePoint = CodePoint::from(4034u32);
    pub const TIBETAN_CANTILLATION_SIGN_SBUB__CHAL : CodePoint = CodePoint::from(4035u32);
    pub const TIBETAN_SYMBOL_DRIL_BU : CodePoint = CodePoint::from(4036u32);
    pub const TIBETAN_SYMBOL_RDO_RJE : CodePoint = CodePoint::from(4037u32);
    pub const TIBETAN_SYMBOL_PADMA_GDAN : CodePoint = CodePoint::from(4038u32);
    pub const TIBETAN_SYMBOL_RDO_RJE_RGYA_GRAM : CodePoint = CodePoint::from(4039u32);
    pub const TIBETAN_SYMBOL_PHUR_PA : CodePoint = CodePoint::from(4040u32);
    pub const TIBETAN_SYMBOL_NOR_BU : CodePoint = CodePoint::from(4041u32);
    pub const TIBETAN_SYMBOL_NOR_BU_NYIS__KHYIL : CodePoint = CodePoint::from(4042u32);
    pub const TIBETAN_SYMBOL_NOR_BU_GSUM__KHYIL : CodePoint = CodePoint::from(4043u32);
    pub const TIBETAN_SYMBOL_NOR_BU_BZHI__KHYIL : CodePoint = CodePoint::from(4044u32);
    pub const TIBETAN_SIGN_RDEL_NAG_RDEL_DKAR : CodePoint = CodePoint::from(4046u32);
    pub const TIBETAN_SIGN_RDEL_NAG_GSUM : CodePoint = CodePoint::from(4047u32);
    pub const TIBETAN_MARK_BSKA__SHOG_GI_MGO_RGYAN : CodePoint = CodePoint::from(4048u32);
    pub const TIBETAN_MARK_MNYAM_YIG_GI_MGO_RGYAN : CodePoint = CodePoint::from(4049u32);
    pub const TIBETAN_MARK_NYIS_TSHEG : CodePoint = CodePoint::from(4050u32);
    pub const TIBETAN_MARK_INITIAL_BRDA_RNYING_YIG_MGO_MDUN_MA : CodePoint = CodePoint::from(4051u32);
    pub const TIBETAN_MARK_CLOSING_BRDA_RNYING_YIG_MGO_SGAB_MA : CodePoint = CodePoint::from(4052u32);
    pub const RIGHT_FACING_SVASTI_SIGN : CodePoint = CodePoint::from(4053u32);
    pub const LEFT_FACING_SVASTI_SIGN : CodePoint = CodePoint::from(4054u32);
    pub const RIGHT_FACING_SVASTI_SIGN_WITH_DOTS : CodePoint = CodePoint::from(4055u32);
    pub const LEFT_FACING_SVASTI_SIGN_WITH_DOTS : CodePoint = CodePoint::from(4056u32);
    pub const TIBETAN_MARK_LEADING_MCHAN_RTAGS : CodePoint = CodePoint::from(4057u32);
    pub const TIBETAN_MARK_TRAILING_MCHAN_RTAGS : CodePoint = CodePoint::from(4058u32);
    pub const MYANMAR_LETTER_KA : CodePoint = CodePoint::from(4096u32);
    pub const MYANMAR_LETTER_KHA : CodePoint = CodePoint::from(4097u32);
    pub const MYANMAR_LETTER_GA : CodePoint = CodePoint::from(4098u32);
    pub const MYANMAR_LETTER_GHA : CodePoint = CodePoint::from(4099u32);
    pub const MYANMAR_LETTER_NGA : CodePoint = CodePoint::from(4100u32);
    pub const MYANMAR_LETTER_CA : CodePoint = CodePoint::from(4101u32);
    pub const MYANMAR_LETTER_CHA : CodePoint = CodePoint::from(4102u32);
    pub const MYANMAR_LETTER_JA : CodePoint = CodePoint::from(4103u32);
    pub const MYANMAR_LETTER_JHA : CodePoint = CodePoint::from(4104u32);
    pub const MYANMAR_LETTER_NYA : CodePoint = CodePoint::from(4105u32);
    pub const MYANMAR_LETTER_NNYA : CodePoint = CodePoint::from(4106u32);
    pub const MYANMAR_LETTER_TTA : CodePoint = CodePoint::from(4107u32);
    pub const MYANMAR_LETTER_TTHA : CodePoint = CodePoint::from(4108u32);
    pub const MYANMAR_LETTER_DDA : CodePoint = CodePoint::from(4109u32);
    pub const MYANMAR_LETTER_DDHA : CodePoint = CodePoint::from(4110u32);
    pub const MYANMAR_LETTER_NNA : CodePoint = CodePoint::from(4111u32);
    pub const MYANMAR_LETTER_TA : CodePoint = CodePoint::from(4112u32);
    pub const MYANMAR_LETTER_THA : CodePoint = CodePoint::from(4113u32);
    pub const MYANMAR_LETTER_DA : CodePoint = CodePoint::from(4114u32);
    pub const MYANMAR_LETTER_DHA : CodePoint = CodePoint::from(4115u32);
    pub const MYANMAR_LETTER_NA : CodePoint = CodePoint::from(4116u32);
    pub const MYANMAR_LETTER_PA : CodePoint = CodePoint::from(4117u32);
    pub const MYANMAR_LETTER_PHA : CodePoint = CodePoint::from(4118u32);
    pub const MYANMAR_LETTER_BA : CodePoint = CodePoint::from(4119u32);
    pub const MYANMAR_LETTER_BHA : CodePoint = CodePoint::from(4120u32);
    pub const MYANMAR_LETTER_MA : CodePoint = CodePoint::from(4121u32);
    pub const MYANMAR_LETTER_YA : CodePoint = CodePoint::from(4122u32);
    pub const MYANMAR_LETTER_RA : CodePoint = CodePoint::from(4123u32);
    pub const MYANMAR_LETTER_LA : CodePoint = CodePoint::from(4124u32);
    pub const MYANMAR_LETTER_WA : CodePoint = CodePoint::from(4125u32);
    pub const MYANMAR_LETTER_SA : CodePoint = CodePoint::from(4126u32);
    pub const MYANMAR_LETTER_HA : CodePoint = CodePoint::from(4127u32);
    pub const MYANMAR_LETTER_LLA : CodePoint = CodePoint::from(4128u32);
    pub const MYANMAR_LETTER_A : CodePoint = CodePoint::from(4129u32);
    pub const MYANMAR_LETTER_SHAN_A : CodePoint = CodePoint::from(4130u32);
    pub const MYANMAR_LETTER_I : CodePoint = CodePoint::from(4131u32);
    pub const MYANMAR_LETTER_II : CodePoint = CodePoint::from(4132u32);
    pub const MYANMAR_LETTER_U : CodePoint = CodePoint::from(4133u32);
    pub const MYANMAR_LETTER_UU : CodePoint = CodePoint::from(4134u32);
    pub const MYANMAR_LETTER_E : CodePoint = CodePoint::from(4135u32);
    pub const MYANMAR_LETTER_MON_E : CodePoint = CodePoint::from(4136u32);
    pub const MYANMAR_LETTER_O : CodePoint = CodePoint::from(4137u32);
    pub const MYANMAR_LETTER_AU : CodePoint = CodePoint::from(4138u32);
    pub const MYANMAR_VOWEL_SIGN_TALL_AA : CodePoint = CodePoint::from(4139u32);
    pub const MYANMAR_VOWEL_SIGN_AA : CodePoint = CodePoint::from(4140u32);
    pub const MYANMAR_VOWEL_SIGN_I : CodePoint = CodePoint::from(4141u32);
    pub const MYANMAR_VOWEL_SIGN_II : CodePoint = CodePoint::from(4142u32);
    pub const MYANMAR_VOWEL_SIGN_U : CodePoint = CodePoint::from(4143u32);
    pub const MYANMAR_VOWEL_SIGN_UU : CodePoint = CodePoint::from(4144u32);
    pub const MYANMAR_VOWEL_SIGN_E : CodePoint = CodePoint::from(4145u32);
    pub const MYANMAR_VOWEL_SIGN_AI : CodePoint = CodePoint::from(4146u32);
    pub const MYANMAR_VOWEL_SIGN_MON_II : CodePoint = CodePoint::from(4147u32);
    pub const MYANMAR_VOWEL_SIGN_MON_O : CodePoint = CodePoint::from(4148u32);
    pub const MYANMAR_VOWEL_SIGN_E_ABOVE : CodePoint = CodePoint::from(4149u32);
    pub const MYANMAR_SIGN_ANUSVARA : CodePoint = CodePoint::from(4150u32);
    pub const MYANMAR_SIGN_DOT_BELOW : CodePoint = CodePoint::from(4151u32);
    pub const MYANMAR_SIGN_VISARGA : CodePoint = CodePoint::from(4152u32);
    pub const MYANMAR_SIGN_VIRAMA : CodePoint = CodePoint::from(4153u32);
    pub const MYANMAR_SIGN_ASAT : CodePoint = CodePoint::from(4154u32);
    pub const MYANMAR_CONSONANT_SIGN_MEDIAL_YA : CodePoint = CodePoint::from(4155u32);
    pub const MYANMAR_CONSONANT_SIGN_MEDIAL_RA : CodePoint = CodePoint::from(4156u32);
    pub const MYANMAR_CONSONANT_SIGN_MEDIAL_WA : CodePoint = CodePoint::from(4157u32);
    pub const MYANMAR_CONSONANT_SIGN_MEDIAL_HA : CodePoint = CodePoint::from(4158u32);
    pub const MYANMAR_LETTER_GREAT_SA : CodePoint = CodePoint::from(4159u32);
    pub const MYANMAR_DIGIT_ZERO : CodePoint = CodePoint::from(4160u32);
    pub const MYANMAR_DIGIT_ONE : CodePoint = CodePoint::from(4161u32);
    pub const MYANMAR_DIGIT_TWO : CodePoint = CodePoint::from(4162u32);
    pub const MYANMAR_DIGIT_THREE : CodePoint = CodePoint::from(4163u32);
    pub const MYANMAR_DIGIT_FOUR : CodePoint = CodePoint::from(4164u32);
    pub const MYANMAR_DIGIT_FIVE : CodePoint = CodePoint::from(4165u32);
    pub const MYANMAR_DIGIT_SIX : CodePoint = CodePoint::from(4166u32);
    pub const MYANMAR_DIGIT_SEVEN : CodePoint = CodePoint::from(4167u32);
    pub const MYANMAR_DIGIT_EIGHT : CodePoint = CodePoint::from(4168u32);
    pub const MYANMAR_DIGIT_NINE : CodePoint = CodePoint::from(4169u32);
    pub const MYANMAR_SIGN_LITTLE_SECTION : CodePoint = CodePoint::from(4170u32);
    pub const MYANMAR_SIGN_SECTION : CodePoint = CodePoint::from(4171u32);
    pub const MYANMAR_SYMBOL_LOCATIVE : CodePoint = CodePoint::from(4172u32);
    pub const MYANMAR_SYMBOL_COMPLETED : CodePoint = CodePoint::from(4173u32);
    pub const MYANMAR_SYMBOL_AFOREMENTIONED : CodePoint = CodePoint::from(4174u32);
    pub const MYANMAR_SYMBOL_GENITIVE : CodePoint = CodePoint::from(4175u32);
    pub const MYANMAR_LETTER_SHA : CodePoint = CodePoint::from(4176u32);
    pub const MYANMAR_LETTER_SSA : CodePoint = CodePoint::from(4177u32);
    pub const MYANMAR_LETTER_VOCALIC_R : CodePoint = CodePoint::from(4178u32);
    pub const MYANMAR_LETTER_VOCALIC_RR : CodePoint = CodePoint::from(4179u32);
    pub const MYANMAR_LETTER_VOCALIC_L : CodePoint = CodePoint::from(4180u32);
    pub const MYANMAR_LETTER_VOCALIC_LL : CodePoint = CodePoint::from(4181u32);
    pub const MYANMAR_VOWEL_SIGN_VOCALIC_R : CodePoint = CodePoint::from(4182u32);
    pub const MYANMAR_VOWEL_SIGN_VOCALIC_RR : CodePoint = CodePoint::from(4183u32);
    pub const MYANMAR_VOWEL_SIGN_VOCALIC_L : CodePoint = CodePoint::from(4184u32);
    pub const MYANMAR_VOWEL_SIGN_VOCALIC_LL : CodePoint = CodePoint::from(4185u32);
    pub const MYANMAR_LETTER_MON_NGA : CodePoint = CodePoint::from(4186u32);
    pub const MYANMAR_LETTER_MON_JHA : CodePoint = CodePoint::from(4187u32);
    pub const MYANMAR_LETTER_MON_BBA : CodePoint = CodePoint::from(4188u32);
    pub const MYANMAR_LETTER_MON_BBE : CodePoint = CodePoint::from(4189u32);
    pub const MYANMAR_CONSONANT_SIGN_MON_MEDIAL_NA : CodePoint = CodePoint::from(4190u32);
    pub const MYANMAR_CONSONANT_SIGN_MON_MEDIAL_MA : CodePoint = CodePoint::from(4191u32);
    pub const MYANMAR_CONSONANT_SIGN_MON_MEDIAL_LA : CodePoint = CodePoint::from(4192u32);
    pub const MYANMAR_LETTER_SGAW_KAREN_SHA : CodePoint = CodePoint::from(4193u32);
    pub const MYANMAR_VOWEL_SIGN_SGAW_KAREN_EU : CodePoint = CodePoint::from(4194u32);
    pub const MYANMAR_TONE_MARK_SGAW_KAREN_HATHI : CodePoint = CodePoint::from(4195u32);
    pub const MYANMAR_TONE_MARK_SGAW_KAREN_KE_PHO : CodePoint = CodePoint::from(4196u32);
    pub const MYANMAR_LETTER_WESTERN_PWO_KAREN_THA : CodePoint = CodePoint::from(4197u32);
    pub const MYANMAR_LETTER_WESTERN_PWO_KAREN_PWA : CodePoint = CodePoint::from(4198u32);
    pub const MYANMAR_VOWEL_SIGN_WESTERN_PWO_KAREN_EU : CodePoint = CodePoint::from(4199u32);
    pub const MYANMAR_VOWEL_SIGN_WESTERN_PWO_KAREN_UE : CodePoint = CodePoint::from(4200u32);
    pub const MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_1 : CodePoint = CodePoint::from(4201u32);
    pub const MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_2 : CodePoint = CodePoint::from(4202u32);
    pub const MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_3 : CodePoint = CodePoint::from(4203u32);
    pub const MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_4 : CodePoint = CodePoint::from(4204u32);
    pub const MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_5 : CodePoint = CodePoint::from(4205u32);
    pub const MYANMAR_LETTER_EASTERN_PWO_KAREN_NNA : CodePoint = CodePoint::from(4206u32);
    pub const MYANMAR_LETTER_EASTERN_PWO_KAREN_YWA : CodePoint = CodePoint::from(4207u32);
    pub const MYANMAR_LETTER_EASTERN_PWO_KAREN_GHWA : CodePoint = CodePoint::from(4208u32);
    pub const MYANMAR_VOWEL_SIGN_GEBA_KAREN_I : CodePoint = CodePoint::from(4209u32);
    pub const MYANMAR_VOWEL_SIGN_KAYAH_OE : CodePoint = CodePoint::from(4210u32);
    pub const MYANMAR_VOWEL_SIGN_KAYAH_U : CodePoint = CodePoint::from(4211u32);
    pub const MYANMAR_VOWEL_SIGN_KAYAH_EE : CodePoint = CodePoint::from(4212u32);
    pub const MYANMAR_LETTER_SHAN_KA : CodePoint = CodePoint::from(4213u32);
    pub const MYANMAR_LETTER_SHAN_KHA : CodePoint = CodePoint::from(4214u32);
    pub const MYANMAR_LETTER_SHAN_GA : CodePoint = CodePoint::from(4215u32);
    pub const MYANMAR_LETTER_SHAN_CA : CodePoint = CodePoint::from(4216u32);
    pub const MYANMAR_LETTER_SHAN_ZA : CodePoint = CodePoint::from(4217u32);
    pub const MYANMAR_LETTER_SHAN_NYA : CodePoint = CodePoint::from(4218u32);
    pub const MYANMAR_LETTER_SHAN_DA : CodePoint = CodePoint::from(4219u32);
    pub const MYANMAR_LETTER_SHAN_NA : CodePoint = CodePoint::from(4220u32);
    pub const MYANMAR_LETTER_SHAN_PHA : CodePoint = CodePoint::from(4221u32);
    pub const MYANMAR_LETTER_SHAN_FA : CodePoint = CodePoint::from(4222u32);
    pub const MYANMAR_LETTER_SHAN_BA : CodePoint = CodePoint::from(4223u32);
    pub const MYANMAR_LETTER_SHAN_THA : CodePoint = CodePoint::from(4224u32);
    pub const MYANMAR_LETTER_SHAN_HA : CodePoint = CodePoint::from(4225u32);
    pub const MYANMAR_CONSONANT_SIGN_SHAN_MEDIAL_WA : CodePoint = CodePoint::from(4226u32);
    pub const MYANMAR_VOWEL_SIGN_SHAN_AA : CodePoint = CodePoint::from(4227u32);
    pub const MYANMAR_VOWEL_SIGN_SHAN_E : CodePoint = CodePoint::from(4228u32);
    pub const MYANMAR_VOWEL_SIGN_SHAN_E_ABOVE : CodePoint = CodePoint::from(4229u32);
    pub const MYANMAR_VOWEL_SIGN_SHAN_FINAL_Y : CodePoint = CodePoint::from(4230u32);
    pub const MYANMAR_SIGN_SHAN_TONE_2 : CodePoint = CodePoint::from(4231u32);
    pub const MYANMAR_SIGN_SHAN_TONE_3 : CodePoint = CodePoint::from(4232u32);
    pub const MYANMAR_SIGN_SHAN_TONE_5 : CodePoint = CodePoint::from(4233u32);
    pub const MYANMAR_SIGN_SHAN_TONE_6 : CodePoint = CodePoint::from(4234u32);
    pub const MYANMAR_SIGN_SHAN_COUNCIL_TONE_2 : CodePoint = CodePoint::from(4235u32);
    pub const MYANMAR_SIGN_SHAN_COUNCIL_TONE_3 : CodePoint = CodePoint::from(4236u32);
    pub const MYANMAR_SIGN_SHAN_COUNCIL_EMPHATIC_TONE : CodePoint = CodePoint::from(4237u32);
    pub const MYANMAR_LETTER_RUMAI_PALAUNG_FA : CodePoint = CodePoint::from(4238u32);
    pub const MYANMAR_SIGN_RUMAI_PALAUNG_TONE_5 : CodePoint = CodePoint::from(4239u32);
    pub const MYANMAR_SHAN_DIGIT_ZERO : CodePoint = CodePoint::from(4240u32);
    pub const MYANMAR_SHAN_DIGIT_ONE : CodePoint = CodePoint::from(4241u32);
    pub const MYANMAR_SHAN_DIGIT_TWO : CodePoint = CodePoint::from(4242u32);
    pub const MYANMAR_SHAN_DIGIT_THREE : CodePoint = CodePoint::from(4243u32);
    pub const MYANMAR_SHAN_DIGIT_FOUR : CodePoint = CodePoint::from(4244u32);
    pub const MYANMAR_SHAN_DIGIT_FIVE : CodePoint = CodePoint::from(4245u32);
    pub const MYANMAR_SHAN_DIGIT_SIX : CodePoint = CodePoint::from(4246u32);
    pub const MYANMAR_SHAN_DIGIT_SEVEN : CodePoint = CodePoint::from(4247u32);
    pub const MYANMAR_SHAN_DIGIT_EIGHT : CodePoint = CodePoint::from(4248u32);
    pub const MYANMAR_SHAN_DIGIT_NINE : CodePoint = CodePoint::from(4249u32);
    pub const MYANMAR_SIGN_KHAMTI_TONE_1 : CodePoint = CodePoint::from(4250u32);
    pub const MYANMAR_SIGN_KHAMTI_TONE_3 : CodePoint = CodePoint::from(4251u32);
    pub const MYANMAR_VOWEL_SIGN_AITON_A : CodePoint = CodePoint::from(4252u32);
    pub const MYANMAR_VOWEL_SIGN_AITON_AI : CodePoint = CodePoint::from(4253u32);
    pub const MYANMAR_SYMBOL_SHAN_ONE : CodePoint = CodePoint::from(4254u32);
    pub const MYANMAR_SYMBOL_SHAN_EXCLAMATION : CodePoint = CodePoint::from(4255u32);
    pub const GEORGIAN_CAPITAL_LETTER_AN : CodePoint = CodePoint::from(4256u32);
    pub const GEORGIAN_CAPITAL_LETTER_BAN : CodePoint = CodePoint::from(4257u32);
    pub const GEORGIAN_CAPITAL_LETTER_GAN : CodePoint = CodePoint::from(4258u32);
    pub const GEORGIAN_CAPITAL_LETTER_DON : CodePoint = CodePoint::from(4259u32);
    pub const GEORGIAN_CAPITAL_LETTER_EN : CodePoint = CodePoint::from(4260u32);
    pub const GEORGIAN_CAPITAL_LETTER_VIN : CodePoint = CodePoint::from(4261u32);
    pub const GEORGIAN_CAPITAL_LETTER_ZEN : CodePoint = CodePoint::from(4262u32);
    pub const GEORGIAN_CAPITAL_LETTER_TAN : CodePoint = CodePoint::from(4263u32);
    pub const GEORGIAN_CAPITAL_LETTER_IN : CodePoint = CodePoint::from(4264u32);
    pub const GEORGIAN_CAPITAL_LETTER_KAN : CodePoint = CodePoint::from(4265u32);
    pub const GEORGIAN_CAPITAL_LETTER_LAS : CodePoint = CodePoint::from(4266u32);
    pub const GEORGIAN_CAPITAL_LETTER_MAN : CodePoint = CodePoint::from(4267u32);
    pub const GEORGIAN_CAPITAL_LETTER_NAR : CodePoint = CodePoint::from(4268u32);
    pub const GEORGIAN_CAPITAL_LETTER_ON : CodePoint = CodePoint::from(4269u32);
    pub const GEORGIAN_CAPITAL_LETTER_PAR : CodePoint = CodePoint::from(4270u32);
    pub const GEORGIAN_CAPITAL_LETTER_ZHAR : CodePoint = CodePoint::from(4271u32);
    pub const GEORGIAN_CAPITAL_LETTER_RAE : CodePoint = CodePoint::from(4272u32);
    pub const GEORGIAN_CAPITAL_LETTER_SAN : CodePoint = CodePoint::from(4273u32);
    pub const GEORGIAN_CAPITAL_LETTER_TAR : CodePoint = CodePoint::from(4274u32);
    pub const GEORGIAN_CAPITAL_LETTER_UN : CodePoint = CodePoint::from(4275u32);
    pub const GEORGIAN_CAPITAL_LETTER_PHAR : CodePoint = CodePoint::from(4276u32);
    pub const GEORGIAN_CAPITAL_LETTER_KHAR : CodePoint = CodePoint::from(4277u32);
    pub const GEORGIAN_CAPITAL_LETTER_GHAN : CodePoint = CodePoint::from(4278u32);
    pub const GEORGIAN_CAPITAL_LETTER_QAR : CodePoint = CodePoint::from(4279u32);
    pub const GEORGIAN_CAPITAL_LETTER_SHIN : CodePoint = CodePoint::from(4280u32);
    pub const GEORGIAN_CAPITAL_LETTER_CHIN : CodePoint = CodePoint::from(4281u32);
    pub const GEORGIAN_CAPITAL_LETTER_CAN : CodePoint = CodePoint::from(4282u32);
    pub const GEORGIAN_CAPITAL_LETTER_JIL : CodePoint = CodePoint::from(4283u32);
    pub const GEORGIAN_CAPITAL_LETTER_CIL : CodePoint = CodePoint::from(4284u32);
    pub const GEORGIAN_CAPITAL_LETTER_CHAR : CodePoint = CodePoint::from(4285u32);
    pub const GEORGIAN_CAPITAL_LETTER_XAN : CodePoint = CodePoint::from(4286u32);
    pub const GEORGIAN_CAPITAL_LETTER_JHAN : CodePoint = CodePoint::from(4287u32);
    pub const GEORGIAN_CAPITAL_LETTER_HAE : CodePoint = CodePoint::from(4288u32);
    pub const GEORGIAN_CAPITAL_LETTER_HE : CodePoint = CodePoint::from(4289u32);
    pub const GEORGIAN_CAPITAL_LETTER_HIE : CodePoint = CodePoint::from(4290u32);
    pub const GEORGIAN_CAPITAL_LETTER_WE : CodePoint = CodePoint::from(4291u32);
    pub const GEORGIAN_CAPITAL_LETTER_HAR : CodePoint = CodePoint::from(4292u32);
    pub const GEORGIAN_CAPITAL_LETTER_HOE : CodePoint = CodePoint::from(4293u32);
    pub const GEORGIAN_CAPITAL_LETTER_YN : CodePoint = CodePoint::from(4295u32);
    pub const GEORGIAN_CAPITAL_LETTER_AEN : CodePoint = CodePoint::from(4301u32);
    pub const GEORGIAN_LETTER_AN : CodePoint = CodePoint::from(4304u32);
    pub const GEORGIAN_LETTER_BAN : CodePoint = CodePoint::from(4305u32);
    pub const GEORGIAN_LETTER_GAN : CodePoint = CodePoint::from(4306u32);
    pub const GEORGIAN_LETTER_DON : CodePoint = CodePoint::from(4307u32);
    pub const GEORGIAN_LETTER_EN : CodePoint = CodePoint::from(4308u32);
    pub const GEORGIAN_LETTER_VIN : CodePoint = CodePoint::from(4309u32);
    pub const GEORGIAN_LETTER_ZEN : CodePoint = CodePoint::from(4310u32);
    pub const GEORGIAN_LETTER_TAN : CodePoint = CodePoint::from(4311u32);
    pub const GEORGIAN_LETTER_IN : CodePoint = CodePoint::from(4312u32);
    pub const GEORGIAN_LETTER_KAN : CodePoint = CodePoint::from(4313u32);
    pub const GEORGIAN_LETTER_LAS : CodePoint = CodePoint::from(4314u32);
    pub const GEORGIAN_LETTER_MAN : CodePoint = CodePoint::from(4315u32);
    pub const GEORGIAN_LETTER_NAR : CodePoint = CodePoint::from(4316u32);
    pub const GEORGIAN_LETTER_ON : CodePoint = CodePoint::from(4317u32);
    pub const GEORGIAN_LETTER_PAR : CodePoint = CodePoint::from(4318u32);
    pub const GEORGIAN_LETTER_ZHAR : CodePoint = CodePoint::from(4319u32);
    pub const GEORGIAN_LETTER_RAE : CodePoint = CodePoint::from(4320u32);
    pub const GEORGIAN_LETTER_SAN : CodePoint = CodePoint::from(4321u32);
    pub const GEORGIAN_LETTER_TAR : CodePoint = CodePoint::from(4322u32);
    pub const GEORGIAN_LETTER_UN : CodePoint = CodePoint::from(4323u32);
    pub const GEORGIAN_LETTER_PHAR : CodePoint = CodePoint::from(4324u32);
    pub const GEORGIAN_LETTER_KHAR : CodePoint = CodePoint::from(4325u32);
    pub const GEORGIAN_LETTER_GHAN : CodePoint = CodePoint::from(4326u32);
    pub const GEORGIAN_LETTER_QAR : CodePoint = CodePoint::from(4327u32);
    pub const GEORGIAN_LETTER_SHIN : CodePoint = CodePoint::from(4328u32);
    pub const GEORGIAN_LETTER_CHIN : CodePoint = CodePoint::from(4329u32);
    pub const GEORGIAN_LETTER_CAN : CodePoint = CodePoint::from(4330u32);
    pub const GEORGIAN_LETTER_JIL : CodePoint = CodePoint::from(4331u32);
    pub const GEORGIAN_LETTER_CIL : CodePoint = CodePoint::from(4332u32);
    pub const GEORGIAN_LETTER_CHAR : CodePoint = CodePoint::from(4333u32);
    pub const GEORGIAN_LETTER_XAN : CodePoint = CodePoint::from(4334u32);
    pub const GEORGIAN_LETTER_JHAN : CodePoint = CodePoint::from(4335u32);
    pub const GEORGIAN_LETTER_HAE : CodePoint = CodePoint::from(4336u32);
    pub const GEORGIAN_LETTER_HE : CodePoint = CodePoint::from(4337u32);
    pub const GEORGIAN_LETTER_HIE : CodePoint = CodePoint::from(4338u32);
    pub const GEORGIAN_LETTER_WE : CodePoint = CodePoint::from(4339u32);
    pub const GEORGIAN_LETTER_HAR : CodePoint = CodePoint::from(4340u32);
    pub const GEORGIAN_LETTER_HOE : CodePoint = CodePoint::from(4341u32);
    pub const GEORGIAN_LETTER_FI : CodePoint = CodePoint::from(4342u32);
    pub const GEORGIAN_LETTER_YN : CodePoint = CodePoint::from(4343u32);
    pub const GEORGIAN_LETTER_ELIFI : CodePoint = CodePoint::from(4344u32);
    pub const GEORGIAN_LETTER_TURNED_GAN : CodePoint = CodePoint::from(4345u32);
    pub const GEORGIAN_LETTER_AIN : CodePoint = CodePoint::from(4346u32);
    pub const GEORGIAN_PARAGRAPH_SEPARATOR : CodePoint = CodePoint::from(4347u32);
    pub const MODIFIER_LETTER_GEORGIAN_NAR : CodePoint = CodePoint::from(4348u32);
    pub const GEORGIAN_LETTER_AEN : CodePoint = CodePoint::from(4349u32);
    pub const GEORGIAN_LETTER_HARD_SIGN : CodePoint = CodePoint::from(4350u32);
    pub const GEORGIAN_LETTER_LABIAL_SIGN : CodePoint = CodePoint::from(4351u32);
    pub const HANGUL_CHOSEONG_KIYEOK : CodePoint = CodePoint::from(4352u32);
    pub const HANGUL_CHOSEONG_SSANGKIYEOK : CodePoint = CodePoint::from(4353u32);
    pub const HANGUL_CHOSEONG_NIEUN : CodePoint = CodePoint::from(4354u32);
    pub const HANGUL_CHOSEONG_TIKEUT : CodePoint = CodePoint::from(4355u32);
    pub const HANGUL_CHOSEONG_SSANGTIKEUT : CodePoint = CodePoint::from(4356u32);
    pub const HANGUL_CHOSEONG_RIEUL : CodePoint = CodePoint::from(4357u32);
    pub const HANGUL_CHOSEONG_MIEUM : CodePoint = CodePoint::from(4358u32);
    pub const HANGUL_CHOSEONG_PIEUP : CodePoint = CodePoint::from(4359u32);
    pub const HANGUL_CHOSEONG_SSANGPIEUP : CodePoint = CodePoint::from(4360u32);
    pub const HANGUL_CHOSEONG_SIOS : CodePoint = CodePoint::from(4361u32);
    pub const HANGUL_CHOSEONG_SSANGSIOS : CodePoint = CodePoint::from(4362u32);
    pub const HANGUL_CHOSEONG_IEUNG : CodePoint = CodePoint::from(4363u32);
    pub const HANGUL_CHOSEONG_CIEUC : CodePoint = CodePoint::from(4364u32);
    pub const HANGUL_CHOSEONG_SSANGCIEUC : CodePoint = CodePoint::from(4365u32);
    pub const HANGUL_CHOSEONG_CHIEUCH : CodePoint = CodePoint::from(4366u32);
    pub const HANGUL_CHOSEONG_KHIEUKH : CodePoint = CodePoint::from(4367u32);
    pub const HANGUL_CHOSEONG_THIEUTH : CodePoint = CodePoint::from(4368u32);
    pub const HANGUL_CHOSEONG_PHIEUPH : CodePoint = CodePoint::from(4369u32);
    pub const HANGUL_CHOSEONG_HIEUH : CodePoint = CodePoint::from(4370u32);
    pub const HANGUL_CHOSEONG_NIEUN_KIYEOK : CodePoint = CodePoint::from(4371u32);
    pub const HANGUL_CHOSEONG_SSANGNIEUN : CodePoint = CodePoint::from(4372u32);
    pub const HANGUL_CHOSEONG_NIEUN_TIKEUT : CodePoint = CodePoint::from(4373u32);
    pub const HANGUL_CHOSEONG_NIEUN_PIEUP : CodePoint = CodePoint::from(4374u32);
    pub const HANGUL_CHOSEONG_TIKEUT_KIYEOK : CodePoint = CodePoint::from(4375u32);
    pub const HANGUL_CHOSEONG_RIEUL_NIEUN : CodePoint = CodePoint::from(4376u32);
    pub const HANGUL_CHOSEONG_SSANGRIEUL : CodePoint = CodePoint::from(4377u32);
    pub const HANGUL_CHOSEONG_RIEUL_HIEUH : CodePoint = CodePoint::from(4378u32);
    pub const HANGUL_CHOSEONG_KAPYEOUNRIEUL : CodePoint = CodePoint::from(4379u32);
    pub const HANGUL_CHOSEONG_MIEUM_PIEUP : CodePoint = CodePoint::from(4380u32);
    pub const HANGUL_CHOSEONG_KAPYEOUNMIEUM : CodePoint = CodePoint::from(4381u32);
    pub const HANGUL_CHOSEONG_PIEUP_KIYEOK : CodePoint = CodePoint::from(4382u32);
    pub const HANGUL_CHOSEONG_PIEUP_NIEUN : CodePoint = CodePoint::from(4383u32);
    pub const HANGUL_CHOSEONG_PIEUP_TIKEUT : CodePoint = CodePoint::from(4384u32);
    pub const HANGUL_CHOSEONG_PIEUP_SIOS : CodePoint = CodePoint::from(4385u32);
    pub const HANGUL_CHOSEONG_PIEUP_SIOS_KIYEOK : CodePoint = CodePoint::from(4386u32);
    pub const HANGUL_CHOSEONG_PIEUP_SIOS_TIKEUT : CodePoint = CodePoint::from(4387u32);
    pub const HANGUL_CHOSEONG_PIEUP_SIOS_PIEUP : CodePoint = CodePoint::from(4388u32);
    pub const HANGUL_CHOSEONG_PIEUP_SSANGSIOS : CodePoint = CodePoint::from(4389u32);
    pub const HANGUL_CHOSEONG_PIEUP_SIOS_CIEUC : CodePoint = CodePoint::from(4390u32);
    pub const HANGUL_CHOSEONG_PIEUP_CIEUC : CodePoint = CodePoint::from(4391u32);
    pub const HANGUL_CHOSEONG_PIEUP_CHIEUCH : CodePoint = CodePoint::from(4392u32);
    pub const HANGUL_CHOSEONG_PIEUP_THIEUTH : CodePoint = CodePoint::from(4393u32);
    pub const HANGUL_CHOSEONG_PIEUP_PHIEUPH : CodePoint = CodePoint::from(4394u32);
    pub const HANGUL_CHOSEONG_KAPYEOUNPIEUP : CodePoint = CodePoint::from(4395u32);
    pub const HANGUL_CHOSEONG_KAPYEOUNSSANGPIEUP : CodePoint = CodePoint::from(4396u32);
    pub const HANGUL_CHOSEONG_SIOS_KIYEOK : CodePoint = CodePoint::from(4397u32);
    pub const HANGUL_CHOSEONG_SIOS_NIEUN : CodePoint = CodePoint::from(4398u32);
    pub const HANGUL_CHOSEONG_SIOS_TIKEUT : CodePoint = CodePoint::from(4399u32);
    pub const HANGUL_CHOSEONG_SIOS_RIEUL : CodePoint = CodePoint::from(4400u32);
    pub const HANGUL_CHOSEONG_SIOS_MIEUM : CodePoint = CodePoint::from(4401u32);
    pub const HANGUL_CHOSEONG_SIOS_PIEUP : CodePoint = CodePoint::from(4402u32);
    pub const HANGUL_CHOSEONG_SIOS_PIEUP_KIYEOK : CodePoint = CodePoint::from(4403u32);
    pub const HANGUL_CHOSEONG_SIOS_SSANGSIOS : CodePoint = CodePoint::from(4404u32);
    pub const HANGUL_CHOSEONG_SIOS_IEUNG : CodePoint = CodePoint::from(4405u32);
    pub const HANGUL_CHOSEONG_SIOS_CIEUC : CodePoint = CodePoint::from(4406u32);
    pub const HANGUL_CHOSEONG_SIOS_CHIEUCH : CodePoint = CodePoint::from(4407u32);
    pub const HANGUL_CHOSEONG_SIOS_KHIEUKH : CodePoint = CodePoint::from(4408u32);
    pub const HANGUL_CHOSEONG_SIOS_THIEUTH : CodePoint = CodePoint::from(4409u32);
    pub const HANGUL_CHOSEONG_SIOS_PHIEUPH : CodePoint = CodePoint::from(4410u32);
    pub const HANGUL_CHOSEONG_SIOS_HIEUH : CodePoint = CodePoint::from(4411u32);
    pub const HANGUL_CHOSEONG_CHITUEUMSIOS : CodePoint = CodePoint::from(4412u32);
    pub const HANGUL_CHOSEONG_CHITUEUMSSANGSIOS : CodePoint = CodePoint::from(4413u32);
    pub const HANGUL_CHOSEONG_CEONGCHIEUMSIOS : CodePoint = CodePoint::from(4414u32);
    pub const HANGUL_CHOSEONG_CEONGCHIEUMSSANGSIOS : CodePoint = CodePoint::from(4415u32);
    pub const HANGUL_CHOSEONG_PANSIOS : CodePoint = CodePoint::from(4416u32);
    pub const HANGUL_CHOSEONG_IEUNG_KIYEOK : CodePoint = CodePoint::from(4417u32);
    pub const HANGUL_CHOSEONG_IEUNG_TIKEUT : CodePoint = CodePoint::from(4418u32);
    pub const HANGUL_CHOSEONG_IEUNG_MIEUM : CodePoint = CodePoint::from(4419u32);
    pub const HANGUL_CHOSEONG_IEUNG_PIEUP : CodePoint = CodePoint::from(4420u32);
    pub const HANGUL_CHOSEONG_IEUNG_SIOS : CodePoint = CodePoint::from(4421u32);
    pub const HANGUL_CHOSEONG_IEUNG_PANSIOS : CodePoint = CodePoint::from(4422u32);
    pub const HANGUL_CHOSEONG_SSANGIEUNG : CodePoint = CodePoint::from(4423u32);
    pub const HANGUL_CHOSEONG_IEUNG_CIEUC : CodePoint = CodePoint::from(4424u32);
    pub const HANGUL_CHOSEONG_IEUNG_CHIEUCH : CodePoint = CodePoint::from(4425u32);
    pub const HANGUL_CHOSEONG_IEUNG_THIEUTH : CodePoint = CodePoint::from(4426u32);
    pub const HANGUL_CHOSEONG_IEUNG_PHIEUPH : CodePoint = CodePoint::from(4427u32);
    pub const HANGUL_CHOSEONG_YESIEUNG : CodePoint = CodePoint::from(4428u32);
    pub const HANGUL_CHOSEONG_CIEUC_IEUNG : CodePoint = CodePoint::from(4429u32);
    pub const HANGUL_CHOSEONG_CHITUEUMCIEUC : CodePoint = CodePoint::from(4430u32);
    pub const HANGUL_CHOSEONG_CHITUEUMSSANGCIEUC : CodePoint = CodePoint::from(4431u32);
    pub const HANGUL_CHOSEONG_CEONGCHIEUMCIEUC : CodePoint = CodePoint::from(4432u32);
    pub const HANGUL_CHOSEONG_CEONGCHIEUMSSANGCIEUC : CodePoint = CodePoint::from(4433u32);
    pub const HANGUL_CHOSEONG_CHIEUCH_KHIEUKH : CodePoint = CodePoint::from(4434u32);
    pub const HANGUL_CHOSEONG_CHIEUCH_HIEUH : CodePoint = CodePoint::from(4435u32);
    pub const HANGUL_CHOSEONG_CHITUEUMCHIEUCH : CodePoint = CodePoint::from(4436u32);
    pub const HANGUL_CHOSEONG_CEONGCHIEUMCHIEUCH : CodePoint = CodePoint::from(4437u32);
    pub const HANGUL_CHOSEONG_PHIEUPH_PIEUP : CodePoint = CodePoint::from(4438u32);
    pub const HANGUL_CHOSEONG_KAPYEOUNPHIEUPH : CodePoint = CodePoint::from(4439u32);
    pub const HANGUL_CHOSEONG_SSANGHIEUH : CodePoint = CodePoint::from(4440u32);
    pub const HANGUL_CHOSEONG_YEORINHIEUH : CodePoint = CodePoint::from(4441u32);
    pub const HANGUL_CHOSEONG_KIYEOK_TIKEUT : CodePoint = CodePoint::from(4442u32);
    pub const HANGUL_CHOSEONG_NIEUN_SIOS : CodePoint = CodePoint::from(4443u32);
    pub const HANGUL_CHOSEONG_NIEUN_CIEUC : CodePoint = CodePoint::from(4444u32);
    pub const HANGUL_CHOSEONG_NIEUN_HIEUH : CodePoint = CodePoint::from(4445u32);
    pub const HANGUL_CHOSEONG_TIKEUT_RIEUL : CodePoint = CodePoint::from(4446u32);
    pub const HANGUL_CHOSEONG_FILLER : CodePoint = CodePoint::from(4447u32);
    pub const HANGUL_JUNGSEONG_FILLER : CodePoint = CodePoint::from(4448u32);
    pub const HANGUL_JUNGSEONG_A : CodePoint = CodePoint::from(4449u32);
    pub const HANGUL_JUNGSEONG_AE : CodePoint = CodePoint::from(4450u32);
    pub const HANGUL_JUNGSEONG_YA : CodePoint = CodePoint::from(4451u32);
    pub const HANGUL_JUNGSEONG_YAE : CodePoint = CodePoint::from(4452u32);
    pub const HANGUL_JUNGSEONG_EO : CodePoint = CodePoint::from(4453u32);
    pub const HANGUL_JUNGSEONG_E : CodePoint = CodePoint::from(4454u32);
    pub const HANGUL_JUNGSEONG_YEO : CodePoint = CodePoint::from(4455u32);
    pub const HANGUL_JUNGSEONG_YE : CodePoint = CodePoint::from(4456u32);
    pub const HANGUL_JUNGSEONG_O : CodePoint = CodePoint::from(4457u32);
    pub const HANGUL_JUNGSEONG_WA : CodePoint = CodePoint::from(4458u32);
    pub const HANGUL_JUNGSEONG_WAE : CodePoint = CodePoint::from(4459u32);
    pub const HANGUL_JUNGSEONG_OE : CodePoint = CodePoint::from(4460u32);
    pub const HANGUL_JUNGSEONG_YO : CodePoint = CodePoint::from(4461u32);
    pub const HANGUL_JUNGSEONG_U : CodePoint = CodePoint::from(4462u32);
    pub const HANGUL_JUNGSEONG_WEO : CodePoint = CodePoint::from(4463u32);
    pub const HANGUL_JUNGSEONG_WE : CodePoint = CodePoint::from(4464u32);
    pub const HANGUL_JUNGSEONG_WI : CodePoint = CodePoint::from(4465u32);
    pub const HANGUL_JUNGSEONG_YU : CodePoint = CodePoint::from(4466u32);
    pub const HANGUL_JUNGSEONG_EU : CodePoint = CodePoint::from(4467u32);
    pub const HANGUL_JUNGSEONG_YI : CodePoint = CodePoint::from(4468u32);
    pub const HANGUL_JUNGSEONG_I : CodePoint = CodePoint::from(4469u32);
    pub const HANGUL_JUNGSEONG_A_O : CodePoint = CodePoint::from(4470u32);
    pub const HANGUL_JUNGSEONG_A_U : CodePoint = CodePoint::from(4471u32);
    pub const HANGUL_JUNGSEONG_YA_O : CodePoint = CodePoint::from(4472u32);
    pub const HANGUL_JUNGSEONG_YA_YO : CodePoint = CodePoint::from(4473u32);
    pub const HANGUL_JUNGSEONG_EO_O : CodePoint = CodePoint::from(4474u32);
    pub const HANGUL_JUNGSEONG_EO_U : CodePoint = CodePoint::from(4475u32);
    pub const HANGUL_JUNGSEONG_EO_EU : CodePoint = CodePoint::from(4476u32);
    pub const HANGUL_JUNGSEONG_YEO_O : CodePoint = CodePoint::from(4477u32);
    pub const HANGUL_JUNGSEONG_YEO_U : CodePoint = CodePoint::from(4478u32);
    pub const HANGUL_JUNGSEONG_O_EO : CodePoint = CodePoint::from(4479u32);
    pub const HANGUL_JUNGSEONG_O_E : CodePoint = CodePoint::from(4480u32);
    pub const HANGUL_JUNGSEONG_O_YE : CodePoint = CodePoint::from(4481u32);
    pub const HANGUL_JUNGSEONG_O_O : CodePoint = CodePoint::from(4482u32);
    pub const HANGUL_JUNGSEONG_O_U : CodePoint = CodePoint::from(4483u32);
    pub const HANGUL_JUNGSEONG_YO_YA : CodePoint = CodePoint::from(4484u32);
    pub const HANGUL_JUNGSEONG_YO_YAE : CodePoint = CodePoint::from(4485u32);
    pub const HANGUL_JUNGSEONG_YO_YEO : CodePoint = CodePoint::from(4486u32);
    pub const HANGUL_JUNGSEONG_YO_O : CodePoint = CodePoint::from(4487u32);
    pub const HANGUL_JUNGSEONG_YO_I : CodePoint = CodePoint::from(4488u32);
    pub const HANGUL_JUNGSEONG_U_A : CodePoint = CodePoint::from(4489u32);
    pub const HANGUL_JUNGSEONG_U_AE : CodePoint = CodePoint::from(4490u32);
    pub const HANGUL_JUNGSEONG_U_EO_EU : CodePoint = CodePoint::from(4491u32);
    pub const HANGUL_JUNGSEONG_U_YE : CodePoint = CodePoint::from(4492u32);
    pub const HANGUL_JUNGSEONG_U_U : CodePoint = CodePoint::from(4493u32);
    pub const HANGUL_JUNGSEONG_YU_A : CodePoint = CodePoint::from(4494u32);
    pub const HANGUL_JUNGSEONG_YU_EO : CodePoint = CodePoint::from(4495u32);
    pub const HANGUL_JUNGSEONG_YU_E : CodePoint = CodePoint::from(4496u32);
    pub const HANGUL_JUNGSEONG_YU_YEO : CodePoint = CodePoint::from(4497u32);
    pub const HANGUL_JUNGSEONG_YU_YE : CodePoint = CodePoint::from(4498u32);
    pub const HANGUL_JUNGSEONG_YU_U : CodePoint = CodePoint::from(4499u32);
    pub const HANGUL_JUNGSEONG_YU_I : CodePoint = CodePoint::from(4500u32);
    pub const HANGUL_JUNGSEONG_EU_U : CodePoint = CodePoint::from(4501u32);
    pub const HANGUL_JUNGSEONG_EU_EU : CodePoint = CodePoint::from(4502u32);
    pub const HANGUL_JUNGSEONG_YI_U : CodePoint = CodePoint::from(4503u32);
    pub const HANGUL_JUNGSEONG_I_A : CodePoint = CodePoint::from(4504u32);
    pub const HANGUL_JUNGSEONG_I_YA : CodePoint = CodePoint::from(4505u32);
    pub const HANGUL_JUNGSEONG_I_O : CodePoint = CodePoint::from(4506u32);
    pub const HANGUL_JUNGSEONG_I_U : CodePoint = CodePoint::from(4507u32);
    pub const HANGUL_JUNGSEONG_I_EU : CodePoint = CodePoint::from(4508u32);
    pub const HANGUL_JUNGSEONG_I_ARAEA : CodePoint = CodePoint::from(4509u32);
    pub const HANGUL_JUNGSEONG_ARAEA : CodePoint = CodePoint::from(4510u32);
    pub const HANGUL_JUNGSEONG_ARAEA_EO : CodePoint = CodePoint::from(4511u32);
    pub const HANGUL_JUNGSEONG_ARAEA_U : CodePoint = CodePoint::from(4512u32);
    pub const HANGUL_JUNGSEONG_ARAEA_I : CodePoint = CodePoint::from(4513u32);
    pub const HANGUL_JUNGSEONG_SSANGARAEA : CodePoint = CodePoint::from(4514u32);
    pub const HANGUL_JUNGSEONG_A_EU : CodePoint = CodePoint::from(4515u32);
    pub const HANGUL_JUNGSEONG_YA_U : CodePoint = CodePoint::from(4516u32);
    pub const HANGUL_JUNGSEONG_YEO_YA : CodePoint = CodePoint::from(4517u32);
    pub const HANGUL_JUNGSEONG_O_YA : CodePoint = CodePoint::from(4518u32);
    pub const HANGUL_JUNGSEONG_O_YAE : CodePoint = CodePoint::from(4519u32);
    pub const HANGUL_JONGSEONG_KIYEOK : CodePoint = CodePoint::from(4520u32);
    pub const HANGUL_JONGSEONG_SSANGKIYEOK : CodePoint = CodePoint::from(4521u32);
    pub const HANGUL_JONGSEONG_KIYEOK_SIOS : CodePoint = CodePoint::from(4522u32);
    pub const HANGUL_JONGSEONG_NIEUN : CodePoint = CodePoint::from(4523u32);
    pub const HANGUL_JONGSEONG_NIEUN_CIEUC : CodePoint = CodePoint::from(4524u32);
    pub const HANGUL_JONGSEONG_NIEUN_HIEUH : CodePoint = CodePoint::from(4525u32);
    pub const HANGUL_JONGSEONG_TIKEUT : CodePoint = CodePoint::from(4526u32);
    pub const HANGUL_JONGSEONG_RIEUL : CodePoint = CodePoint::from(4527u32);
    pub const HANGUL_JONGSEONG_RIEUL_KIYEOK : CodePoint = CodePoint::from(4528u32);
    pub const HANGUL_JONGSEONG_RIEUL_MIEUM : CodePoint = CodePoint::from(4529u32);
    pub const HANGUL_JONGSEONG_RIEUL_PIEUP : CodePoint = CodePoint::from(4530u32);
    pub const HANGUL_JONGSEONG_RIEUL_SIOS : CodePoint = CodePoint::from(4531u32);
    pub const HANGUL_JONGSEONG_RIEUL_THIEUTH : CodePoint = CodePoint::from(4532u32);
    pub const HANGUL_JONGSEONG_RIEUL_PHIEUPH : CodePoint = CodePoint::from(4533u32);
    pub const HANGUL_JONGSEONG_RIEUL_HIEUH : CodePoint = CodePoint::from(4534u32);
    pub const HANGUL_JONGSEONG_MIEUM : CodePoint = CodePoint::from(4535u32);
    pub const HANGUL_JONGSEONG_PIEUP : CodePoint = CodePoint::from(4536u32);
    pub const HANGUL_JONGSEONG_PIEUP_SIOS : CodePoint = CodePoint::from(4537u32);
    pub const HANGUL_JONGSEONG_SIOS : CodePoint = CodePoint::from(4538u32);
    pub const HANGUL_JONGSEONG_SSANGSIOS : CodePoint = CodePoint::from(4539u32);
    pub const HANGUL_JONGSEONG_IEUNG : CodePoint = CodePoint::from(4540u32);
    pub const HANGUL_JONGSEONG_CIEUC : CodePoint = CodePoint::from(4541u32);
    pub const HANGUL_JONGSEONG_CHIEUCH : CodePoint = CodePoint::from(4542u32);
    pub const HANGUL_JONGSEONG_KHIEUKH : CodePoint = CodePoint::from(4543u32);
    pub const HANGUL_JONGSEONG_THIEUTH : CodePoint = CodePoint::from(4544u32);
    pub const HANGUL_JONGSEONG_PHIEUPH : CodePoint = CodePoint::from(4545u32);
    pub const HANGUL_JONGSEONG_HIEUH : CodePoint = CodePoint::from(4546u32);
    pub const HANGUL_JONGSEONG_KIYEOK_RIEUL : CodePoint = CodePoint::from(4547u32);
    pub const HANGUL_JONGSEONG_KIYEOK_SIOS_KIYEOK : CodePoint = CodePoint::from(4548u32);
    pub const HANGUL_JONGSEONG_NIEUN_KIYEOK : CodePoint = CodePoint::from(4549u32);
    pub const HANGUL_JONGSEONG_NIEUN_TIKEUT : CodePoint = CodePoint::from(4550u32);
    pub const HANGUL_JONGSEONG_NIEUN_SIOS : CodePoint = CodePoint::from(4551u32);
    pub const HANGUL_JONGSEONG_NIEUN_PANSIOS : CodePoint = CodePoint::from(4552u32);
    pub const HANGUL_JONGSEONG_NIEUN_THIEUTH : CodePoint = CodePoint::from(4553u32);
    pub const HANGUL_JONGSEONG_TIKEUT_KIYEOK : CodePoint = CodePoint::from(4554u32);
    pub const HANGUL_JONGSEONG_TIKEUT_RIEUL : CodePoint = CodePoint::from(4555u32);
    pub const HANGUL_JONGSEONG_RIEUL_KIYEOK_SIOS : CodePoint = CodePoint::from(4556u32);
    pub const HANGUL_JONGSEONG_RIEUL_NIEUN : CodePoint = CodePoint::from(4557u32);
    pub const HANGUL_JONGSEONG_RIEUL_TIKEUT : CodePoint = CodePoint::from(4558u32);
    pub const HANGUL_JONGSEONG_RIEUL_TIKEUT_HIEUH : CodePoint = CodePoint::from(4559u32);
    pub const HANGUL_JONGSEONG_SSANGRIEUL : CodePoint = CodePoint::from(4560u32);
    pub const HANGUL_JONGSEONG_RIEUL_MIEUM_KIYEOK : CodePoint = CodePoint::from(4561u32);
    pub const HANGUL_JONGSEONG_RIEUL_MIEUM_SIOS : CodePoint = CodePoint::from(4562u32);
    pub const HANGUL_JONGSEONG_RIEUL_PIEUP_SIOS : CodePoint = CodePoint::from(4563u32);
    pub const HANGUL_JONGSEONG_RIEUL_PIEUP_HIEUH : CodePoint = CodePoint::from(4564u32);
    pub const HANGUL_JONGSEONG_RIEUL_KAPYEOUNPIEUP : CodePoint = CodePoint::from(4565u32);
    pub const HANGUL_JONGSEONG_RIEUL_SSANGSIOS : CodePoint = CodePoint::from(4566u32);
    pub const HANGUL_JONGSEONG_RIEUL_PANSIOS : CodePoint = CodePoint::from(4567u32);
    pub const HANGUL_JONGSEONG_RIEUL_KHIEUKH : CodePoint = CodePoint::from(4568u32);
    pub const HANGUL_JONGSEONG_RIEUL_YEORINHIEUH : CodePoint = CodePoint::from(4569u32);
    pub const HANGUL_JONGSEONG_MIEUM_KIYEOK : CodePoint = CodePoint::from(4570u32);
    pub const HANGUL_JONGSEONG_MIEUM_RIEUL : CodePoint = CodePoint::from(4571u32);
    pub const HANGUL_JONGSEONG_MIEUM_PIEUP : CodePoint = CodePoint::from(4572u32);
    pub const HANGUL_JONGSEONG_MIEUM_SIOS : CodePoint = CodePoint::from(4573u32);
    pub const HANGUL_JONGSEONG_MIEUM_SSANGSIOS : CodePoint = CodePoint::from(4574u32);
    pub const HANGUL_JONGSEONG_MIEUM_PANSIOS : CodePoint = CodePoint::from(4575u32);
    pub const HANGUL_JONGSEONG_MIEUM_CHIEUCH : CodePoint = CodePoint::from(4576u32);
    pub const HANGUL_JONGSEONG_MIEUM_HIEUH : CodePoint = CodePoint::from(4577u32);
    pub const HANGUL_JONGSEONG_KAPYEOUNMIEUM : CodePoint = CodePoint::from(4578u32);
    pub const HANGUL_JONGSEONG_PIEUP_RIEUL : CodePoint = CodePoint::from(4579u32);
    pub const HANGUL_JONGSEONG_PIEUP_PHIEUPH : CodePoint = CodePoint::from(4580u32);
    pub const HANGUL_JONGSEONG_PIEUP_HIEUH : CodePoint = CodePoint::from(4581u32);
    pub const HANGUL_JONGSEONG_KAPYEOUNPIEUP : CodePoint = CodePoint::from(4582u32);
    pub const HANGUL_JONGSEONG_SIOS_KIYEOK : CodePoint = CodePoint::from(4583u32);
    pub const HANGUL_JONGSEONG_SIOS_TIKEUT : CodePoint = CodePoint::from(4584u32);
    pub const HANGUL_JONGSEONG_SIOS_RIEUL : CodePoint = CodePoint::from(4585u32);
    pub const HANGUL_JONGSEONG_SIOS_PIEUP : CodePoint = CodePoint::from(4586u32);
    pub const HANGUL_JONGSEONG_PANSIOS : CodePoint = CodePoint::from(4587u32);
    pub const HANGUL_JONGSEONG_IEUNG_KIYEOK : CodePoint = CodePoint::from(4588u32);
    pub const HANGUL_JONGSEONG_IEUNG_SSANGKIYEOK : CodePoint = CodePoint::from(4589u32);
    pub const HANGUL_JONGSEONG_SSANGIEUNG : CodePoint = CodePoint::from(4590u32);
    pub const HANGUL_JONGSEONG_IEUNG_KHIEUKH : CodePoint = CodePoint::from(4591u32);
    pub const HANGUL_JONGSEONG_YESIEUNG : CodePoint = CodePoint::from(4592u32);
    pub const HANGUL_JONGSEONG_YESIEUNG_SIOS : CodePoint = CodePoint::from(4593u32);
    pub const HANGUL_JONGSEONG_YESIEUNG_PANSIOS : CodePoint = CodePoint::from(4594u32);
    pub const HANGUL_JONGSEONG_PHIEUPH_PIEUP : CodePoint = CodePoint::from(4595u32);
    pub const HANGUL_JONGSEONG_KAPYEOUNPHIEUPH : CodePoint = CodePoint::from(4596u32);
    pub const HANGUL_JONGSEONG_HIEUH_NIEUN : CodePoint = CodePoint::from(4597u32);
    pub const HANGUL_JONGSEONG_HIEUH_RIEUL : CodePoint = CodePoint::from(4598u32);
    pub const HANGUL_JONGSEONG_HIEUH_MIEUM : CodePoint = CodePoint::from(4599u32);
    pub const HANGUL_JONGSEONG_HIEUH_PIEUP : CodePoint = CodePoint::from(4600u32);
    pub const HANGUL_JONGSEONG_YEORINHIEUH : CodePoint = CodePoint::from(4601u32);
    pub const HANGUL_JONGSEONG_KIYEOK_NIEUN : CodePoint = CodePoint::from(4602u32);
    pub const HANGUL_JONGSEONG_KIYEOK_PIEUP : CodePoint = CodePoint::from(4603u32);
    pub const HANGUL_JONGSEONG_KIYEOK_CHIEUCH : CodePoint = CodePoint::from(4604u32);
    pub const HANGUL_JONGSEONG_KIYEOK_KHIEUKH : CodePoint = CodePoint::from(4605u32);
    pub const HANGUL_JONGSEONG_KIYEOK_HIEUH : CodePoint = CodePoint::from(4606u32);
    pub const HANGUL_JONGSEONG_SSANGNIEUN : CodePoint = CodePoint::from(4607u32);
    pub const ETHIOPIC_SYLLABLE_HA : CodePoint = CodePoint::from(4608u32);
    pub const ETHIOPIC_SYLLABLE_HU : CodePoint = CodePoint::from(4609u32);
    pub const ETHIOPIC_SYLLABLE_HI : CodePoint = CodePoint::from(4610u32);
    pub const ETHIOPIC_SYLLABLE_HAA : CodePoint = CodePoint::from(4611u32);
    pub const ETHIOPIC_SYLLABLE_HEE : CodePoint = CodePoint::from(4612u32);
    pub const ETHIOPIC_SYLLABLE_HE : CodePoint = CodePoint::from(4613u32);
    pub const ETHIOPIC_SYLLABLE_HO : CodePoint = CodePoint::from(4614u32);
    pub const ETHIOPIC_SYLLABLE_HOA : CodePoint = CodePoint::from(4615u32);
    pub const ETHIOPIC_SYLLABLE_LA : CodePoint = CodePoint::from(4616u32);
    pub const ETHIOPIC_SYLLABLE_LU : CodePoint = CodePoint::from(4617u32);
    pub const ETHIOPIC_SYLLABLE_LI : CodePoint = CodePoint::from(4618u32);
    pub const ETHIOPIC_SYLLABLE_LAA : CodePoint = CodePoint::from(4619u32);
    pub const ETHIOPIC_SYLLABLE_LEE : CodePoint = CodePoint::from(4620u32);
    pub const ETHIOPIC_SYLLABLE_LE : CodePoint = CodePoint::from(4621u32);
    pub const ETHIOPIC_SYLLABLE_LO : CodePoint = CodePoint::from(4622u32);
    pub const ETHIOPIC_SYLLABLE_LWA : CodePoint = CodePoint::from(4623u32);
    pub const ETHIOPIC_SYLLABLE_HHA : CodePoint = CodePoint::from(4624u32);
    pub const ETHIOPIC_SYLLABLE_HHU : CodePoint = CodePoint::from(4625u32);
    pub const ETHIOPIC_SYLLABLE_HHI : CodePoint = CodePoint::from(4626u32);
    pub const ETHIOPIC_SYLLABLE_HHAA : CodePoint = CodePoint::from(4627u32);
    pub const ETHIOPIC_SYLLABLE_HHEE : CodePoint = CodePoint::from(4628u32);
    pub const ETHIOPIC_SYLLABLE_HHE : CodePoint = CodePoint::from(4629u32);
    pub const ETHIOPIC_SYLLABLE_HHO : CodePoint = CodePoint::from(4630u32);
    pub const ETHIOPIC_SYLLABLE_HHWA : CodePoint = CodePoint::from(4631u32);
    pub const ETHIOPIC_SYLLABLE_MA : CodePoint = CodePoint::from(4632u32);
    pub const ETHIOPIC_SYLLABLE_MU : CodePoint = CodePoint::from(4633u32);
    pub const ETHIOPIC_SYLLABLE_MI : CodePoint = CodePoint::from(4634u32);
    pub const ETHIOPIC_SYLLABLE_MAA : CodePoint = CodePoint::from(4635u32);
    pub const ETHIOPIC_SYLLABLE_MEE : CodePoint = CodePoint::from(4636u32);
    pub const ETHIOPIC_SYLLABLE_ME : CodePoint = CodePoint::from(4637u32);
    pub const ETHIOPIC_SYLLABLE_MO : CodePoint = CodePoint::from(4638u32);
    pub const ETHIOPIC_SYLLABLE_MWA : CodePoint = CodePoint::from(4639u32);
    pub const ETHIOPIC_SYLLABLE_SZA : CodePoint = CodePoint::from(4640u32);
    pub const ETHIOPIC_SYLLABLE_SZU : CodePoint = CodePoint::from(4641u32);
    pub const ETHIOPIC_SYLLABLE_SZI : CodePoint = CodePoint::from(4642u32);
    pub const ETHIOPIC_SYLLABLE_SZAA : CodePoint = CodePoint::from(4643u32);
    pub const ETHIOPIC_SYLLABLE_SZEE : CodePoint = CodePoint::from(4644u32);
    pub const ETHIOPIC_SYLLABLE_SZE : CodePoint = CodePoint::from(4645u32);
    pub const ETHIOPIC_SYLLABLE_SZO : CodePoint = CodePoint::from(4646u32);
    pub const ETHIOPIC_SYLLABLE_SZWA : CodePoint = CodePoint::from(4647u32);
    pub const ETHIOPIC_SYLLABLE_RA : CodePoint = CodePoint::from(4648u32);
    pub const ETHIOPIC_SYLLABLE_RU : CodePoint = CodePoint::from(4649u32);
    pub const ETHIOPIC_SYLLABLE_RI : CodePoint = CodePoint::from(4650u32);
    pub const ETHIOPIC_SYLLABLE_RAA : CodePoint = CodePoint::from(4651u32);
    pub const ETHIOPIC_SYLLABLE_REE : CodePoint = CodePoint::from(4652u32);
    pub const ETHIOPIC_SYLLABLE_RE : CodePoint = CodePoint::from(4653u32);
    pub const ETHIOPIC_SYLLABLE_RO : CodePoint = CodePoint::from(4654u32);
    pub const ETHIOPIC_SYLLABLE_RWA : CodePoint = CodePoint::from(4655u32);
    pub const ETHIOPIC_SYLLABLE_SA : CodePoint = CodePoint::from(4656u32);
    pub const ETHIOPIC_SYLLABLE_SU : CodePoint = CodePoint::from(4657u32);
    pub const ETHIOPIC_SYLLABLE_SI : CodePoint = CodePoint::from(4658u32);
    pub const ETHIOPIC_SYLLABLE_SAA : CodePoint = CodePoint::from(4659u32);
    pub const ETHIOPIC_SYLLABLE_SEE : CodePoint = CodePoint::from(4660u32);
    pub const ETHIOPIC_SYLLABLE_SE : CodePoint = CodePoint::from(4661u32);
    pub const ETHIOPIC_SYLLABLE_SO : CodePoint = CodePoint::from(4662u32);
    pub const ETHIOPIC_SYLLABLE_SWA : CodePoint = CodePoint::from(4663u32);
    pub const ETHIOPIC_SYLLABLE_SHA : CodePoint = CodePoint::from(4664u32);
    pub const ETHIOPIC_SYLLABLE_SHU : CodePoint = CodePoint::from(4665u32);
    pub const ETHIOPIC_SYLLABLE_SHI : CodePoint = CodePoint::from(4666u32);
    pub const ETHIOPIC_SYLLABLE_SHAA : CodePoint = CodePoint::from(4667u32);
    pub const ETHIOPIC_SYLLABLE_SHEE : CodePoint = CodePoint::from(4668u32);
    pub const ETHIOPIC_SYLLABLE_SHE : CodePoint = CodePoint::from(4669u32);
    pub const ETHIOPIC_SYLLABLE_SHO : CodePoint = CodePoint::from(4670u32);
    pub const ETHIOPIC_SYLLABLE_SHWA : CodePoint = CodePoint::from(4671u32);
    pub const ETHIOPIC_SYLLABLE_QA : CodePoint = CodePoint::from(4672u32);
    pub const ETHIOPIC_SYLLABLE_QU : CodePoint = CodePoint::from(4673u32);
    pub const ETHIOPIC_SYLLABLE_QI : CodePoint = CodePoint::from(4674u32);
    pub const ETHIOPIC_SYLLABLE_QAA : CodePoint = CodePoint::from(4675u32);
    pub const ETHIOPIC_SYLLABLE_QEE : CodePoint = CodePoint::from(4676u32);
    pub const ETHIOPIC_SYLLABLE_QE : CodePoint = CodePoint::from(4677u32);
    pub const ETHIOPIC_SYLLABLE_QO : CodePoint = CodePoint::from(4678u32);
    pub const ETHIOPIC_SYLLABLE_QOA : CodePoint = CodePoint::from(4679u32);
    pub const ETHIOPIC_SYLLABLE_QWA : CodePoint = CodePoint::from(4680u32);
    pub const ETHIOPIC_SYLLABLE_QWI : CodePoint = CodePoint::from(4682u32);
    pub const ETHIOPIC_SYLLABLE_QWAA : CodePoint = CodePoint::from(4683u32);
    pub const ETHIOPIC_SYLLABLE_QWEE : CodePoint = CodePoint::from(4684u32);
    pub const ETHIOPIC_SYLLABLE_QWE : CodePoint = CodePoint::from(4685u32);
    pub const ETHIOPIC_SYLLABLE_QHA : CodePoint = CodePoint::from(4688u32);
    pub const ETHIOPIC_SYLLABLE_QHU : CodePoint = CodePoint::from(4689u32);
    pub const ETHIOPIC_SYLLABLE_QHI : CodePoint = CodePoint::from(4690u32);
    pub const ETHIOPIC_SYLLABLE_QHAA : CodePoint = CodePoint::from(4691u32);
    pub const ETHIOPIC_SYLLABLE_QHEE : CodePoint = CodePoint::from(4692u32);
    pub const ETHIOPIC_SYLLABLE_QHE : CodePoint = CodePoint::from(4693u32);
    pub const ETHIOPIC_SYLLABLE_QHO : CodePoint = CodePoint::from(4694u32);
    pub const ETHIOPIC_SYLLABLE_QHWA : CodePoint = CodePoint::from(4696u32);
    pub const ETHIOPIC_SYLLABLE_QHWI : CodePoint = CodePoint::from(4698u32);
    pub const ETHIOPIC_SYLLABLE_QHWAA : CodePoint = CodePoint::from(4699u32);
    pub const ETHIOPIC_SYLLABLE_QHWEE : CodePoint = CodePoint::from(4700u32);
    pub const ETHIOPIC_SYLLABLE_QHWE : CodePoint = CodePoint::from(4701u32);
    pub const ETHIOPIC_SYLLABLE_BA : CodePoint = CodePoint::from(4704u32);
    pub const ETHIOPIC_SYLLABLE_BU : CodePoint = CodePoint::from(4705u32);
    pub const ETHIOPIC_SYLLABLE_BI : CodePoint = CodePoint::from(4706u32);
    pub const ETHIOPIC_SYLLABLE_BAA : CodePoint = CodePoint::from(4707u32);
    pub const ETHIOPIC_SYLLABLE_BEE : CodePoint = CodePoint::from(4708u32);
    pub const ETHIOPIC_SYLLABLE_BE : CodePoint = CodePoint::from(4709u32);
    pub const ETHIOPIC_SYLLABLE_BO : CodePoint = CodePoint::from(4710u32);
    pub const ETHIOPIC_SYLLABLE_BWA : CodePoint = CodePoint::from(4711u32);
    pub const ETHIOPIC_SYLLABLE_VA : CodePoint = CodePoint::from(4712u32);
    pub const ETHIOPIC_SYLLABLE_VU : CodePoint = CodePoint::from(4713u32);
    pub const ETHIOPIC_SYLLABLE_VI : CodePoint = CodePoint::from(4714u32);
    pub const ETHIOPIC_SYLLABLE_VAA : CodePoint = CodePoint::from(4715u32);
    pub const ETHIOPIC_SYLLABLE_VEE : CodePoint = CodePoint::from(4716u32);
    pub const ETHIOPIC_SYLLABLE_VE : CodePoint = CodePoint::from(4717u32);
    pub const ETHIOPIC_SYLLABLE_VO : CodePoint = CodePoint::from(4718u32);
    pub const ETHIOPIC_SYLLABLE_VWA : CodePoint = CodePoint::from(4719u32);
    pub const ETHIOPIC_SYLLABLE_TA : CodePoint = CodePoint::from(4720u32);
    pub const ETHIOPIC_SYLLABLE_TU : CodePoint = CodePoint::from(4721u32);
    pub const ETHIOPIC_SYLLABLE_TI : CodePoint = CodePoint::from(4722u32);
    pub const ETHIOPIC_SYLLABLE_TAA : CodePoint = CodePoint::from(4723u32);
    pub const ETHIOPIC_SYLLABLE_TEE : CodePoint = CodePoint::from(4724u32);
    pub const ETHIOPIC_SYLLABLE_TE : CodePoint = CodePoint::from(4725u32);
    pub const ETHIOPIC_SYLLABLE_TO : CodePoint = CodePoint::from(4726u32);
    pub const ETHIOPIC_SYLLABLE_TWA : CodePoint = CodePoint::from(4727u32);
    pub const ETHIOPIC_SYLLABLE_CA : CodePoint = CodePoint::from(4728u32);
    pub const ETHIOPIC_SYLLABLE_CU : CodePoint = CodePoint::from(4729u32);
    pub const ETHIOPIC_SYLLABLE_CI : CodePoint = CodePoint::from(4730u32);
    pub const ETHIOPIC_SYLLABLE_CAA : CodePoint = CodePoint::from(4731u32);
    pub const ETHIOPIC_SYLLABLE_CEE : CodePoint = CodePoint::from(4732u32);
    pub const ETHIOPIC_SYLLABLE_CE : CodePoint = CodePoint::from(4733u32);
    pub const ETHIOPIC_SYLLABLE_CO : CodePoint = CodePoint::from(4734u32);
    pub const ETHIOPIC_SYLLABLE_CWA : CodePoint = CodePoint::from(4735u32);
    pub const ETHIOPIC_SYLLABLE_XA : CodePoint = CodePoint::from(4736u32);
    pub const ETHIOPIC_SYLLABLE_XU : CodePoint = CodePoint::from(4737u32);
    pub const ETHIOPIC_SYLLABLE_XI : CodePoint = CodePoint::from(4738u32);
    pub const ETHIOPIC_SYLLABLE_XAA : CodePoint = CodePoint::from(4739u32);
    pub const ETHIOPIC_SYLLABLE_XEE : CodePoint = CodePoint::from(4740u32);
    pub const ETHIOPIC_SYLLABLE_XE : CodePoint = CodePoint::from(4741u32);
    pub const ETHIOPIC_SYLLABLE_XO : CodePoint = CodePoint::from(4742u32);
    pub const ETHIOPIC_SYLLABLE_XOA : CodePoint = CodePoint::from(4743u32);
    pub const ETHIOPIC_SYLLABLE_XWA : CodePoint = CodePoint::from(4744u32);
    pub const ETHIOPIC_SYLLABLE_XWI : CodePoint = CodePoint::from(4746u32);
    pub const ETHIOPIC_SYLLABLE_XWAA : CodePoint = CodePoint::from(4747u32);
    pub const ETHIOPIC_SYLLABLE_XWEE : CodePoint = CodePoint::from(4748u32);
    pub const ETHIOPIC_SYLLABLE_XWE : CodePoint = CodePoint::from(4749u32);
    pub const ETHIOPIC_SYLLABLE_NA : CodePoint = CodePoint::from(4752u32);
    pub const ETHIOPIC_SYLLABLE_NU : CodePoint = CodePoint::from(4753u32);
    pub const ETHIOPIC_SYLLABLE_NI : CodePoint = CodePoint::from(4754u32);
    pub const ETHIOPIC_SYLLABLE_NAA : CodePoint = CodePoint::from(4755u32);
    pub const ETHIOPIC_SYLLABLE_NEE : CodePoint = CodePoint::from(4756u32);
    pub const ETHIOPIC_SYLLABLE_NE : CodePoint = CodePoint::from(4757u32);
    pub const ETHIOPIC_SYLLABLE_NO : CodePoint = CodePoint::from(4758u32);
    pub const ETHIOPIC_SYLLABLE_NWA : CodePoint = CodePoint::from(4759u32);
    pub const ETHIOPIC_SYLLABLE_NYA : CodePoint = CodePoint::from(4760u32);
    pub const ETHIOPIC_SYLLABLE_NYU : CodePoint = CodePoint::from(4761u32);
    pub const ETHIOPIC_SYLLABLE_NYI : CodePoint = CodePoint::from(4762u32);
    pub const ETHIOPIC_SYLLABLE_NYAA : CodePoint = CodePoint::from(4763u32);
    pub const ETHIOPIC_SYLLABLE_NYEE : CodePoint = CodePoint::from(4764u32);
    pub const ETHIOPIC_SYLLABLE_NYE : CodePoint = CodePoint::from(4765u32);
    pub const ETHIOPIC_SYLLABLE_NYO : CodePoint = CodePoint::from(4766u32);
    pub const ETHIOPIC_SYLLABLE_NYWA : CodePoint = CodePoint::from(4767u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_A : CodePoint = CodePoint::from(4768u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_U : CodePoint = CodePoint::from(4769u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_I : CodePoint = CodePoint::from(4770u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_AA : CodePoint = CodePoint::from(4771u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_EE : CodePoint = CodePoint::from(4772u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_E : CodePoint = CodePoint::from(4773u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_O : CodePoint = CodePoint::from(4774u32);
    pub const ETHIOPIC_SYLLABLE_GLOTTAL_WA : CodePoint = CodePoint::from(4775u32);
    pub const ETHIOPIC_SYLLABLE_KA : CodePoint = CodePoint::from(4776u32);
    pub const ETHIOPIC_SYLLABLE_KU : CodePoint = CodePoint::from(4777u32);
    pub const ETHIOPIC_SYLLABLE_KI : CodePoint = CodePoint::from(4778u32);
    pub const ETHIOPIC_SYLLABLE_KAA : CodePoint = CodePoint::from(4779u32);
    pub const ETHIOPIC_SYLLABLE_KEE : CodePoint = CodePoint::from(4780u32);
    pub const ETHIOPIC_SYLLABLE_KE : CodePoint = CodePoint::from(4781u32);
    pub const ETHIOPIC_SYLLABLE_KO : CodePoint = CodePoint::from(4782u32);
    pub const ETHIOPIC_SYLLABLE_KOA : CodePoint = CodePoint::from(4783u32);
    pub const ETHIOPIC_SYLLABLE_KWA : CodePoint = CodePoint::from(4784u32);
    pub const ETHIOPIC_SYLLABLE_KWI : CodePoint = CodePoint::from(4786u32);
    pub const ETHIOPIC_SYLLABLE_KWAA : CodePoint = CodePoint::from(4787u32);
    pub const ETHIOPIC_SYLLABLE_KWEE : CodePoint = CodePoint::from(4788u32);
    pub const ETHIOPIC_SYLLABLE_KWE : CodePoint = CodePoint::from(4789u32);
    pub const ETHIOPIC_SYLLABLE_KXA : CodePoint = CodePoint::from(4792u32);
    pub const ETHIOPIC_SYLLABLE_KXU : CodePoint = CodePoint::from(4793u32);
    pub const ETHIOPIC_SYLLABLE_KXI : CodePoint = CodePoint::from(4794u32);
    pub const ETHIOPIC_SYLLABLE_KXAA : CodePoint = CodePoint::from(4795u32);
    pub const ETHIOPIC_SYLLABLE_KXEE : CodePoint = CodePoint::from(4796u32);
    pub const ETHIOPIC_SYLLABLE_KXE : CodePoint = CodePoint::from(4797u32);
    pub const ETHIOPIC_SYLLABLE_KXO : CodePoint = CodePoint::from(4798u32);
    pub const ETHIOPIC_SYLLABLE_KXWA : CodePoint = CodePoint::from(4800u32);
    pub const ETHIOPIC_SYLLABLE_KXWI : CodePoint = CodePoint::from(4802u32);
    pub const ETHIOPIC_SYLLABLE_KXWAA : CodePoint = CodePoint::from(4803u32);
    pub const ETHIOPIC_SYLLABLE_KXWEE : CodePoint = CodePoint::from(4804u32);
    pub const ETHIOPIC_SYLLABLE_KXWE : CodePoint = CodePoint::from(4805u32);
    pub const ETHIOPIC_SYLLABLE_WA : CodePoint = CodePoint::from(4808u32);
    pub const ETHIOPIC_SYLLABLE_WU : CodePoint = CodePoint::from(4809u32);
    pub const ETHIOPIC_SYLLABLE_WI : CodePoint = CodePoint::from(4810u32);
    pub const ETHIOPIC_SYLLABLE_WAA : CodePoint = CodePoint::from(4811u32);
    pub const ETHIOPIC_SYLLABLE_WEE : CodePoint = CodePoint::from(4812u32);
    pub const ETHIOPIC_SYLLABLE_WE : CodePoint = CodePoint::from(4813u32);
    pub const ETHIOPIC_SYLLABLE_WO : CodePoint = CodePoint::from(4814u32);
    pub const ETHIOPIC_SYLLABLE_WOA : CodePoint = CodePoint::from(4815u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_A : CodePoint = CodePoint::from(4816u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_U : CodePoint = CodePoint::from(4817u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_I : CodePoint = CodePoint::from(4818u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_AA : CodePoint = CodePoint::from(4819u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_EE : CodePoint = CodePoint::from(4820u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_E : CodePoint = CodePoint::from(4821u32);
    pub const ETHIOPIC_SYLLABLE_PHARYNGEAL_O : CodePoint = CodePoint::from(4822u32);
    pub const ETHIOPIC_SYLLABLE_ZA : CodePoint = CodePoint::from(4824u32);
    pub const ETHIOPIC_SYLLABLE_ZU : CodePoint = CodePoint::from(4825u32);
    pub const ETHIOPIC_SYLLABLE_ZI : CodePoint = CodePoint::from(4826u32);
    pub const ETHIOPIC_SYLLABLE_ZAA : CodePoint = CodePoint::from(4827u32);
    pub const ETHIOPIC_SYLLABLE_ZEE : CodePoint = CodePoint::from(4828u32);
    pub const ETHIOPIC_SYLLABLE_ZE : CodePoint = CodePoint::from(4829u32);
    pub const ETHIOPIC_SYLLABLE_ZO : CodePoint = CodePoint::from(4830u32);
    pub const ETHIOPIC_SYLLABLE_ZWA : CodePoint = CodePoint::from(4831u32);
    pub const ETHIOPIC_SYLLABLE_ZHA : CodePoint = CodePoint::from(4832u32);
    pub const ETHIOPIC_SYLLABLE_ZHU : CodePoint = CodePoint::from(4833u32);
    pub const ETHIOPIC_SYLLABLE_ZHI : CodePoint = CodePoint::from(4834u32);
    pub const ETHIOPIC_SYLLABLE_ZHAA : CodePoint = CodePoint::from(4835u32);
    pub const ETHIOPIC_SYLLABLE_ZHEE : CodePoint = CodePoint::from(4836u32);
    pub const ETHIOPIC_SYLLABLE_ZHE : CodePoint = CodePoint::from(4837u32);
    pub const ETHIOPIC_SYLLABLE_ZHO : CodePoint = CodePoint::from(4838u32);
    pub const ETHIOPIC_SYLLABLE_ZHWA : CodePoint = CodePoint::from(4839u32);
    pub const ETHIOPIC_SYLLABLE_YA : CodePoint = CodePoint::from(4840u32);
    pub const ETHIOPIC_SYLLABLE_YU : CodePoint = CodePoint::from(4841u32);
    pub const ETHIOPIC_SYLLABLE_YI : CodePoint = CodePoint::from(4842u32);
    pub const ETHIOPIC_SYLLABLE_YAA : CodePoint = CodePoint::from(4843u32);
    pub const ETHIOPIC_SYLLABLE_YEE : CodePoint = CodePoint::from(4844u32);
    pub const ETHIOPIC_SYLLABLE_YE : CodePoint = CodePoint::from(4845u32);
    pub const ETHIOPIC_SYLLABLE_YO : CodePoint = CodePoint::from(4846u32);
    pub const ETHIOPIC_SYLLABLE_YOA : CodePoint = CodePoint::from(4847u32);
    pub const ETHIOPIC_SYLLABLE_DA : CodePoint = CodePoint::from(4848u32);
    pub const ETHIOPIC_SYLLABLE_DU : CodePoint = CodePoint::from(4849u32);
    pub const ETHIOPIC_SYLLABLE_DI : CodePoint = CodePoint::from(4850u32);
    pub const ETHIOPIC_SYLLABLE_DAA : CodePoint = CodePoint::from(4851u32);
    pub const ETHIOPIC_SYLLABLE_DEE : CodePoint = CodePoint::from(4852u32);
    pub const ETHIOPIC_SYLLABLE_DE : CodePoint = CodePoint::from(4853u32);
    pub const ETHIOPIC_SYLLABLE_DO : CodePoint = CodePoint::from(4854u32);
    pub const ETHIOPIC_SYLLABLE_DWA : CodePoint = CodePoint::from(4855u32);
    pub const ETHIOPIC_SYLLABLE_DDA : CodePoint = CodePoint::from(4856u32);
    pub const ETHIOPIC_SYLLABLE_DDU : CodePoint = CodePoint::from(4857u32);
    pub const ETHIOPIC_SYLLABLE_DDI : CodePoint = CodePoint::from(4858u32);
    pub const ETHIOPIC_SYLLABLE_DDAA : CodePoint = CodePoint::from(4859u32);
    pub const ETHIOPIC_SYLLABLE_DDEE : CodePoint = CodePoint::from(4860u32);
    pub const ETHIOPIC_SYLLABLE_DDE : CodePoint = CodePoint::from(4861u32);
    pub const ETHIOPIC_SYLLABLE_DDO : CodePoint = CodePoint::from(4862u32);
    pub const ETHIOPIC_SYLLABLE_DDWA : CodePoint = CodePoint::from(4863u32);
    pub const ETHIOPIC_SYLLABLE_JA : CodePoint = CodePoint::from(4864u32);
    pub const ETHIOPIC_SYLLABLE_JU : CodePoint = CodePoint::from(4865u32);
    pub const ETHIOPIC_SYLLABLE_JI : CodePoint = CodePoint::from(4866u32);
    pub const ETHIOPIC_SYLLABLE_JAA : CodePoint = CodePoint::from(4867u32);
    pub const ETHIOPIC_SYLLABLE_JEE : CodePoint = CodePoint::from(4868u32);
    pub const ETHIOPIC_SYLLABLE_JE : CodePoint = CodePoint::from(4869u32);
    pub const ETHIOPIC_SYLLABLE_JO : CodePoint = CodePoint::from(4870u32);
    pub const ETHIOPIC_SYLLABLE_JWA : CodePoint = CodePoint::from(4871u32);
    pub const ETHIOPIC_SYLLABLE_GA : CodePoint = CodePoint::from(4872u32);
    pub const ETHIOPIC_SYLLABLE_GU : CodePoint = CodePoint::from(4873u32);
    pub const ETHIOPIC_SYLLABLE_GI : CodePoint = CodePoint::from(4874u32);
    pub const ETHIOPIC_SYLLABLE_GAA : CodePoint = CodePoint::from(4875u32);
    pub const ETHIOPIC_SYLLABLE_GEE : CodePoint = CodePoint::from(4876u32);
    pub const ETHIOPIC_SYLLABLE_GE : CodePoint = CodePoint::from(4877u32);
    pub const ETHIOPIC_SYLLABLE_GO : CodePoint = CodePoint::from(4878u32);
    pub const ETHIOPIC_SYLLABLE_GOA : CodePoint = CodePoint::from(4879u32);
    pub const ETHIOPIC_SYLLABLE_GWA : CodePoint = CodePoint::from(4880u32);
    pub const ETHIOPIC_SYLLABLE_GWI : CodePoint = CodePoint::from(4882u32);
    pub const ETHIOPIC_SYLLABLE_GWAA : CodePoint = CodePoint::from(4883u32);
    pub const ETHIOPIC_SYLLABLE_GWEE : CodePoint = CodePoint::from(4884u32);
    pub const ETHIOPIC_SYLLABLE_GWE : CodePoint = CodePoint::from(4885u32);
    pub const ETHIOPIC_SYLLABLE_GGA : CodePoint = CodePoint::from(4888u32);
    pub const ETHIOPIC_SYLLABLE_GGU : CodePoint = CodePoint::from(4889u32);
    pub const ETHIOPIC_SYLLABLE_GGI : CodePoint = CodePoint::from(4890u32);
    pub const ETHIOPIC_SYLLABLE_GGAA : CodePoint = CodePoint::from(4891u32);
    pub const ETHIOPIC_SYLLABLE_GGEE : CodePoint = CodePoint::from(4892u32);
    pub const ETHIOPIC_SYLLABLE_GGE : CodePoint = CodePoint::from(4893u32);
    pub const ETHIOPIC_SYLLABLE_GGO : CodePoint = CodePoint::from(4894u32);
    pub const ETHIOPIC_SYLLABLE_GGWAA : CodePoint = CodePoint::from(4895u32);
    pub const ETHIOPIC_SYLLABLE_THA : CodePoint = CodePoint::from(4896u32);
    pub const ETHIOPIC_SYLLABLE_THU : CodePoint = CodePoint::from(4897u32);
    pub const ETHIOPIC_SYLLABLE_THI : CodePoint = CodePoint::from(4898u32);
    pub const ETHIOPIC_SYLLABLE_THAA : CodePoint = CodePoint::from(4899u32);
    pub const ETHIOPIC_SYLLABLE_THEE : CodePoint = CodePoint::from(4900u32);
    pub const ETHIOPIC_SYLLABLE_THE : CodePoint = CodePoint::from(4901u32);
    pub const ETHIOPIC_SYLLABLE_THO : CodePoint = CodePoint::from(4902u32);
    pub const ETHIOPIC_SYLLABLE_THWA : CodePoint = CodePoint::from(4903u32);
    pub const ETHIOPIC_SYLLABLE_CHA : CodePoint = CodePoint::from(4904u32);
    pub const ETHIOPIC_SYLLABLE_CHU : CodePoint = CodePoint::from(4905u32);
    pub const ETHIOPIC_SYLLABLE_CHI : CodePoint = CodePoint::from(4906u32);
    pub const ETHIOPIC_SYLLABLE_CHAA : CodePoint = CodePoint::from(4907u32);
    pub const ETHIOPIC_SYLLABLE_CHEE : CodePoint = CodePoint::from(4908u32);
    pub const ETHIOPIC_SYLLABLE_CHE : CodePoint = CodePoint::from(4909u32);
    pub const ETHIOPIC_SYLLABLE_CHO : CodePoint = CodePoint::from(4910u32);
    pub const ETHIOPIC_SYLLABLE_CHWA : CodePoint = CodePoint::from(4911u32);
    pub const ETHIOPIC_SYLLABLE_PHA : CodePoint = CodePoint::from(4912u32);
    pub const ETHIOPIC_SYLLABLE_PHU : CodePoint = CodePoint::from(4913u32);
    pub const ETHIOPIC_SYLLABLE_PHI : CodePoint = CodePoint::from(4914u32);
    pub const ETHIOPIC_SYLLABLE_PHAA : CodePoint = CodePoint::from(4915u32);
    pub const ETHIOPIC_SYLLABLE_PHEE : CodePoint = CodePoint::from(4916u32);
    pub const ETHIOPIC_SYLLABLE_PHE : CodePoint = CodePoint::from(4917u32);
    pub const ETHIOPIC_SYLLABLE_PHO : CodePoint = CodePoint::from(4918u32);
    pub const ETHIOPIC_SYLLABLE_PHWA : CodePoint = CodePoint::from(4919u32);
    pub const ETHIOPIC_SYLLABLE_TSA : CodePoint = CodePoint::from(4920u32);
    pub const ETHIOPIC_SYLLABLE_TSU : CodePoint = CodePoint::from(4921u32);
    pub const ETHIOPIC_SYLLABLE_TSI : CodePoint = CodePoint::from(4922u32);
    pub const ETHIOPIC_SYLLABLE_TSAA : CodePoint = CodePoint::from(4923u32);
    pub const ETHIOPIC_SYLLABLE_TSEE : CodePoint = CodePoint::from(4924u32);
    pub const ETHIOPIC_SYLLABLE_TSE : CodePoint = CodePoint::from(4925u32);
    pub const ETHIOPIC_SYLLABLE_TSO : CodePoint = CodePoint::from(4926u32);
    pub const ETHIOPIC_SYLLABLE_TSWA : CodePoint = CodePoint::from(4927u32);
    pub const ETHIOPIC_SYLLABLE_TZA : CodePoint = CodePoint::from(4928u32);
    pub const ETHIOPIC_SYLLABLE_TZU : CodePoint = CodePoint::from(4929u32);
    pub const ETHIOPIC_SYLLABLE_TZI : CodePoint = CodePoint::from(4930u32);
    pub const ETHIOPIC_SYLLABLE_TZAA : CodePoint = CodePoint::from(4931u32);
    pub const ETHIOPIC_SYLLABLE_TZEE : CodePoint = CodePoint::from(4932u32);
    pub const ETHIOPIC_SYLLABLE_TZE : CodePoint = CodePoint::from(4933u32);
    pub const ETHIOPIC_SYLLABLE_TZO : CodePoint = CodePoint::from(4934u32);
    pub const ETHIOPIC_SYLLABLE_TZOA : CodePoint = CodePoint::from(4935u32);
    pub const ETHIOPIC_SYLLABLE_FA : CodePoint = CodePoint::from(4936u32);
    pub const ETHIOPIC_SYLLABLE_FU : CodePoint = CodePoint::from(4937u32);
    pub const ETHIOPIC_SYLLABLE_FI : CodePoint = CodePoint::from(4938u32);
    pub const ETHIOPIC_SYLLABLE_FAA : CodePoint = CodePoint::from(4939u32);
    pub const ETHIOPIC_SYLLABLE_FEE : CodePoint = CodePoint::from(4940u32);
    pub const ETHIOPIC_SYLLABLE_FE : CodePoint = CodePoint::from(4941u32);
    pub const ETHIOPIC_SYLLABLE_FO : CodePoint = CodePoint::from(4942u32);
    pub const ETHIOPIC_SYLLABLE_FWA : CodePoint = CodePoint::from(4943u32);
    pub const ETHIOPIC_SYLLABLE_PA : CodePoint = CodePoint::from(4944u32);
    pub const ETHIOPIC_SYLLABLE_PU : CodePoint = CodePoint::from(4945u32);
    pub const ETHIOPIC_SYLLABLE_PI : CodePoint = CodePoint::from(4946u32);
    pub const ETHIOPIC_SYLLABLE_PAA : CodePoint = CodePoint::from(4947u32);
    pub const ETHIOPIC_SYLLABLE_PEE : CodePoint = CodePoint::from(4948u32);
    pub const ETHIOPIC_SYLLABLE_PE : CodePoint = CodePoint::from(4949u32);
    pub const ETHIOPIC_SYLLABLE_PO : CodePoint = CodePoint::from(4950u32);
    pub const ETHIOPIC_SYLLABLE_PWA : CodePoint = CodePoint::from(4951u32);
    pub const ETHIOPIC_SYLLABLE_RYA : CodePoint = CodePoint::from(4952u32);
    pub const ETHIOPIC_SYLLABLE_MYA : CodePoint = CodePoint::from(4953u32);
    pub const ETHIOPIC_SYLLABLE_FYA : CodePoint = CodePoint::from(4954u32);
    pub const ETHIOPIC_COMBINING_GEMINATION_AND_VOWEL_LENGTH_MARK : CodePoint = CodePoint::from(4957u32);
    pub const ETHIOPIC_COMBINING_VOWEL_LENGTH_MARK : CodePoint = CodePoint::from(4958u32);
    pub const ETHIOPIC_COMBINING_GEMINATION_MARK : CodePoint = CodePoint::from(4959u32);
    pub const ETHIOPIC_SECTION_MARK : CodePoint = CodePoint::from(4960u32);
    pub const ETHIOPIC_WORDSPACE : CodePoint = CodePoint::from(4961u32);
    pub const ETHIOPIC_FULL_STOP : CodePoint = CodePoint::from(4962u32);
    pub const ETHIOPIC_COMMA : CodePoint = CodePoint::from(4963u32);
    pub const ETHIOPIC_SEMICOLON : CodePoint = CodePoint::from(4964u32);
    pub const ETHIOPIC_COLON : CodePoint = CodePoint::from(4965u32);
    pub const ETHIOPIC_PREFACE_COLON : CodePoint = CodePoint::from(4966u32);
    pub const ETHIOPIC_QUESTION_MARK : CodePoint = CodePoint::from(4967u32);
    pub const ETHIOPIC_PARAGRAPH_SEPARATOR : CodePoint = CodePoint::from(4968u32);
    pub const ETHIOPIC_DIGIT_ONE : CodePoint = CodePoint::from(4969u32);
    pub const ETHIOPIC_DIGIT_TWO : CodePoint = CodePoint::from(4970u32);
    pub const ETHIOPIC_DIGIT_THREE : CodePoint = CodePoint::from(4971u32);
    pub const ETHIOPIC_DIGIT_FOUR : CodePoint = CodePoint::from(4972u32);
    pub const ETHIOPIC_DIGIT_FIVE : CodePoint = CodePoint::from(4973u32);
    pub const ETHIOPIC_DIGIT_SIX : CodePoint = CodePoint::from(4974u32);
    pub const ETHIOPIC_DIGIT_SEVEN : CodePoint = CodePoint::from(4975u32);
    pub const ETHIOPIC_DIGIT_EIGHT : CodePoint = CodePoint::from(4976u32);
    pub const ETHIOPIC_DIGIT_NINE : CodePoint = CodePoint::from(4977u32);
    pub const ETHIOPIC_NUMBER_TEN : CodePoint = CodePoint::from(4978u32);
    pub const ETHIOPIC_NUMBER_TWENTY : CodePoint = CodePoint::from(4979u32);
    pub const ETHIOPIC_NUMBER_THIRTY : CodePoint = CodePoint::from(4980u32);
    pub const ETHIOPIC_NUMBER_FORTY : CodePoint = CodePoint::from(4981u32);
    pub const ETHIOPIC_NUMBER_FIFTY : CodePoint = CodePoint::from(4982u32);
    pub const ETHIOPIC_NUMBER_SIXTY : CodePoint = CodePoint::from(4983u32);
    pub const ETHIOPIC_NUMBER_SEVENTY : CodePoint = CodePoint::from(4984u32);
    pub const ETHIOPIC_NUMBER_EIGHTY : CodePoint = CodePoint::from(4985u32);
    pub const ETHIOPIC_NUMBER_NINETY : CodePoint = CodePoint::from(4986u32);
    pub const ETHIOPIC_NUMBER_HUNDRED : CodePoint = CodePoint::from(4987u32);
    pub const ETHIOPIC_NUMBER_TEN_THOUSAND : CodePoint = CodePoint::from(4988u32);
    pub const ETHIOPIC_SYLLABLE_SEBATBEIT_MWA : CodePoint = CodePoint::from(4992u32);
    pub const ETHIOPIC_SYLLABLE_MWI : CodePoint = CodePoint::from(4993u32);
    pub const ETHIOPIC_SYLLABLE_MWEE : CodePoint = CodePoint::from(4994u32);
    pub const ETHIOPIC_SYLLABLE_MWE : CodePoint = CodePoint::from(4995u32);
    pub const ETHIOPIC_SYLLABLE_SEBATBEIT_BWA : CodePoint = CodePoint::from(4996u32);
    pub const ETHIOPIC_SYLLABLE_BWI : CodePoint = CodePoint::from(4997u32);
    pub const ETHIOPIC_SYLLABLE_BWEE : CodePoint = CodePoint::from(4998u32);
    pub const ETHIOPIC_SYLLABLE_BWE : CodePoint = CodePoint::from(4999u32);
    pub const ETHIOPIC_SYLLABLE_SEBATBEIT_FWA : CodePoint = CodePoint::from(5000u32);
    pub const ETHIOPIC_SYLLABLE_FWI : CodePoint = CodePoint::from(5001u32);
    pub const ETHIOPIC_SYLLABLE_FWEE : CodePoint = CodePoint::from(5002u32);
    pub const ETHIOPIC_SYLLABLE_FWE : CodePoint = CodePoint::from(5003u32);
    pub const ETHIOPIC_SYLLABLE_SEBATBEIT_PWA : CodePoint = CodePoint::from(5004u32);
    pub const ETHIOPIC_SYLLABLE_PWI : CodePoint = CodePoint::from(5005u32);
    pub const ETHIOPIC_SYLLABLE_PWEE : CodePoint = CodePoint::from(5006u32);
    pub const ETHIOPIC_SYLLABLE_PWE : CodePoint = CodePoint::from(5007u32);
    pub const ETHIOPIC_TONAL_MARK_YIZET : CodePoint = CodePoint::from(5008u32);
    pub const ETHIOPIC_TONAL_MARK_DERET : CodePoint = CodePoint::from(5009u32);
    pub const ETHIOPIC_TONAL_MARK_RIKRIK : CodePoint = CodePoint::from(5010u32);
    pub const ETHIOPIC_TONAL_MARK_SHORT_RIKRIK : CodePoint = CodePoint::from(5011u32);
    pub const ETHIOPIC_TONAL_MARK_DIFAT : CodePoint = CodePoint::from(5012u32);
    pub const ETHIOPIC_TONAL_MARK_KENAT : CodePoint = CodePoint::from(5013u32);
    pub const ETHIOPIC_TONAL_MARK_CHIRET : CodePoint = CodePoint::from(5014u32);
    pub const ETHIOPIC_TONAL_MARK_HIDET : CodePoint = CodePoint::from(5015u32);
    pub const ETHIOPIC_TONAL_MARK_DERET_HIDET : CodePoint = CodePoint::from(5016u32);
    pub const ETHIOPIC_TONAL_MARK_KURT : CodePoint = CodePoint::from(5017u32);
    pub const CHEROKEE_LETTER_A : CodePoint = CodePoint::from(5024u32);
    pub const CHEROKEE_LETTER_E : CodePoint = CodePoint::from(5025u32);
    pub const CHEROKEE_LETTER_I : CodePoint = CodePoint::from(5026u32);
    pub const CHEROKEE_LETTER_O : CodePoint = CodePoint::from(5027u32);
    pub const CHEROKEE_LETTER_U : CodePoint = CodePoint::from(5028u32);
    pub const CHEROKEE_LETTER_V : CodePoint = CodePoint::from(5029u32);
    pub const CHEROKEE_LETTER_GA : CodePoint = CodePoint::from(5030u32);
    pub const CHEROKEE_LETTER_KA : CodePoint = CodePoint::from(5031u32);
    pub const CHEROKEE_LETTER_GE : CodePoint = CodePoint::from(5032u32);
    pub const CHEROKEE_LETTER_GI : CodePoint = CodePoint::from(5033u32);
    pub const CHEROKEE_LETTER_GO : CodePoint = CodePoint::from(5034u32);
    pub const CHEROKEE_LETTER_GU : CodePoint = CodePoint::from(5035u32);
    pub const CHEROKEE_LETTER_GV : CodePoint = CodePoint::from(5036u32);
    pub const CHEROKEE_LETTER_HA : CodePoint = CodePoint::from(5037u32);
    pub const CHEROKEE_LETTER_HE : CodePoint = CodePoint::from(5038u32);
    pub const CHEROKEE_LETTER_HI : CodePoint = CodePoint::from(5039u32);
    pub const CHEROKEE_LETTER_HO : CodePoint = CodePoint::from(5040u32);
    pub const CHEROKEE_LETTER_HU : CodePoint = CodePoint::from(5041u32);
    pub const CHEROKEE_LETTER_HV : CodePoint = CodePoint::from(5042u32);
    pub const CHEROKEE_LETTER_LA : CodePoint = CodePoint::from(5043u32);
    pub const CHEROKEE_LETTER_LE : CodePoint = CodePoint::from(5044u32);
    pub const CHEROKEE_LETTER_LI : CodePoint = CodePoint::from(5045u32);
    pub const CHEROKEE_LETTER_LO : CodePoint = CodePoint::from(5046u32);
    pub const CHEROKEE_LETTER_LU : CodePoint = CodePoint::from(5047u32);
    pub const CHEROKEE_LETTER_LV : CodePoint = CodePoint::from(5048u32);
    pub const CHEROKEE_LETTER_MA : CodePoint = CodePoint::from(5049u32);
    pub const CHEROKEE_LETTER_ME : CodePoint = CodePoint::from(5050u32);
    pub const CHEROKEE_LETTER_MI : CodePoint = CodePoint::from(5051u32);
    pub const CHEROKEE_LETTER_MO : CodePoint = CodePoint::from(5052u32);
    pub const CHEROKEE_LETTER_MU : CodePoint = CodePoint::from(5053u32);
    pub const CHEROKEE_LETTER_NA : CodePoint = CodePoint::from(5054u32);
    pub const CHEROKEE_LETTER_HNA : CodePoint = CodePoint::from(5055u32);
    pub const CHEROKEE_LETTER_NAH : CodePoint = CodePoint::from(5056u32);
    pub const CHEROKEE_LETTER_NE : CodePoint = CodePoint::from(5057u32);
    pub const CHEROKEE_LETTER_NI : CodePoint = CodePoint::from(5058u32);
    pub const CHEROKEE_LETTER_NO : CodePoint = CodePoint::from(5059u32);
    pub const CHEROKEE_LETTER_NU : CodePoint = CodePoint::from(5060u32);
    pub const CHEROKEE_LETTER_NV : CodePoint = CodePoint::from(5061u32);
    pub const CHEROKEE_LETTER_QUA : CodePoint = CodePoint::from(5062u32);
    pub const CHEROKEE_LETTER_QUE : CodePoint = CodePoint::from(5063u32);
    pub const CHEROKEE_LETTER_QUI : CodePoint = CodePoint::from(5064u32);
    pub const CHEROKEE_LETTER_QUO : CodePoint = CodePoint::from(5065u32);
    pub const CHEROKEE_LETTER_QUU : CodePoint = CodePoint::from(5066u32);
    pub const CHEROKEE_LETTER_QUV : CodePoint = CodePoint::from(5067u32);
    pub const CHEROKEE_LETTER_SA : CodePoint = CodePoint::from(5068u32);
    pub const CHEROKEE_LETTER_S : CodePoint = CodePoint::from(5069u32);
    pub const CHEROKEE_LETTER_SE : CodePoint = CodePoint::from(5070u32);
    pub const CHEROKEE_LETTER_SI : CodePoint = CodePoint::from(5071u32);
    pub const CHEROKEE_LETTER_SO : CodePoint = CodePoint::from(5072u32);
    pub const CHEROKEE_LETTER_SU : CodePoint = CodePoint::from(5073u32);
    pub const CHEROKEE_LETTER_SV : CodePoint = CodePoint::from(5074u32);
    pub const CHEROKEE_LETTER_DA : CodePoint = CodePoint::from(5075u32);
    pub const CHEROKEE_LETTER_TA : CodePoint = CodePoint::from(5076u32);
    pub const CHEROKEE_LETTER_DE : CodePoint = CodePoint::from(5077u32);
    pub const CHEROKEE_LETTER_TE : CodePoint = CodePoint::from(5078u32);
    pub const CHEROKEE_LETTER_DI : CodePoint = CodePoint::from(5079u32);
    pub const CHEROKEE_LETTER_TI : CodePoint = CodePoint::from(5080u32);
    pub const CHEROKEE_LETTER_DO : CodePoint = CodePoint::from(5081u32);
    pub const CHEROKEE_LETTER_DU : CodePoint = CodePoint::from(5082u32);
    pub const CHEROKEE_LETTER_DV : CodePoint = CodePoint::from(5083u32);
    pub const CHEROKEE_LETTER_DLA : CodePoint = CodePoint::from(5084u32);
    pub const CHEROKEE_LETTER_TLA : CodePoint = CodePoint::from(5085u32);
    pub const CHEROKEE_LETTER_TLE : CodePoint = CodePoint::from(5086u32);
    pub const CHEROKEE_LETTER_TLI : CodePoint = CodePoint::from(5087u32);
    pub const CHEROKEE_LETTER_TLO : CodePoint = CodePoint::from(5088u32);
    pub const CHEROKEE_LETTER_TLU : CodePoint = CodePoint::from(5089u32);
    pub const CHEROKEE_LETTER_TLV : CodePoint = CodePoint::from(5090u32);
    pub const CHEROKEE_LETTER_TSA : CodePoint = CodePoint::from(5091u32);
    pub const CHEROKEE_LETTER_TSE : CodePoint = CodePoint::from(5092u32);
    pub const CHEROKEE_LETTER_TSI : CodePoint = CodePoint::from(5093u32);
    pub const CHEROKEE_LETTER_TSO : CodePoint = CodePoint::from(5094u32);
    pub const CHEROKEE_LETTER_TSU : CodePoint = CodePoint::from(5095u32);
    pub const CHEROKEE_LETTER_TSV : CodePoint = CodePoint::from(5096u32);
    pub const CHEROKEE_LETTER_WA : CodePoint = CodePoint::from(5097u32);
    pub const CHEROKEE_LETTER_WE : CodePoint = CodePoint::from(5098u32);
    pub const CHEROKEE_LETTER_WI : CodePoint = CodePoint::from(5099u32);
    pub const CHEROKEE_LETTER_WO : CodePoint = CodePoint::from(5100u32);
    pub const CHEROKEE_LETTER_WU : CodePoint = CodePoint::from(5101u32);
    pub const CHEROKEE_LETTER_WV : CodePoint = CodePoint::from(5102u32);
    pub const CHEROKEE_LETTER_YA : CodePoint = CodePoint::from(5103u32);
    pub const CHEROKEE_LETTER_YE : CodePoint = CodePoint::from(5104u32);
    pub const CHEROKEE_LETTER_YI : CodePoint = CodePoint::from(5105u32);
    pub const CHEROKEE_LETTER_YO : CodePoint = CodePoint::from(5106u32);
    pub const CHEROKEE_LETTER_YU : CodePoint = CodePoint::from(5107u32);
    pub const CHEROKEE_LETTER_YV : CodePoint = CodePoint::from(5108u32);
    pub const CHEROKEE_LETTER_MV : CodePoint = CodePoint::from(5109u32);
    pub const CHEROKEE_SMALL_LETTER_YE : CodePoint = CodePoint::from(5112u32);
    pub const CHEROKEE_SMALL_LETTER_YI : CodePoint = CodePoint::from(5113u32);
    pub const CHEROKEE_SMALL_LETTER_YO : CodePoint = CodePoint::from(5114u32);
    pub const CHEROKEE_SMALL_LETTER_YU : CodePoint = CodePoint::from(5115u32);
    pub const CHEROKEE_SMALL_LETTER_YV : CodePoint = CodePoint::from(5116u32);
    pub const CHEROKEE_SMALL_LETTER_MV : CodePoint = CodePoint::from(5117u32);
    pub const CANADIAN_SYLLABICS_HYPHEN : CodePoint = CodePoint::from(5120u32);
    pub const CANADIAN_SYLLABICS_E : CodePoint = CodePoint::from(5121u32);
    pub const CANADIAN_SYLLABICS_AAI : CodePoint = CodePoint::from(5122u32);
    pub const CANADIAN_SYLLABICS_I : CodePoint = CodePoint::from(5123u32);
    pub const CANADIAN_SYLLABICS_II : CodePoint = CodePoint::from(5124u32);
    pub const CANADIAN_SYLLABICS_O : CodePoint = CodePoint::from(5125u32);
    pub const CANADIAN_SYLLABICS_OO : CodePoint = CodePoint::from(5126u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_OO : CodePoint = CodePoint::from(5127u32);
    pub const CANADIAN_SYLLABICS_CARRIER_EE : CodePoint = CodePoint::from(5128u32);
    pub const CANADIAN_SYLLABICS_CARRIER_I : CodePoint = CodePoint::from(5129u32);
    pub const CANADIAN_SYLLABICS_A : CodePoint = CodePoint::from(5130u32);
    pub const CANADIAN_SYLLABICS_AA : CodePoint = CodePoint::from(5131u32);
    pub const CANADIAN_SYLLABICS_WE : CodePoint = CodePoint::from(5132u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WE : CodePoint = CodePoint::from(5133u32);
    pub const CANADIAN_SYLLABICS_WI : CodePoint = CodePoint::from(5134u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WI : CodePoint = CodePoint::from(5135u32);
    pub const CANADIAN_SYLLABICS_WII : CodePoint = CodePoint::from(5136u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WII : CodePoint = CodePoint::from(5137u32);
    pub const CANADIAN_SYLLABICS_WO : CodePoint = CodePoint::from(5138u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WO : CodePoint = CodePoint::from(5139u32);
    pub const CANADIAN_SYLLABICS_WOO : CodePoint = CodePoint::from(5140u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WOO : CodePoint = CodePoint::from(5141u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_WOO : CodePoint = CodePoint::from(5142u32);
    pub const CANADIAN_SYLLABICS_WA : CodePoint = CodePoint::from(5143u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WA : CodePoint = CodePoint::from(5144u32);
    pub const CANADIAN_SYLLABICS_WAA : CodePoint = CodePoint::from(5145u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_WAA : CodePoint = CodePoint::from(5146u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_WAA : CodePoint = CodePoint::from(5147u32);
    pub const CANADIAN_SYLLABICS_AI : CodePoint = CodePoint::from(5148u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_W : CodePoint = CodePoint::from(5149u32);
    pub const CANADIAN_SYLLABICS_GLOTTAL_STOP : CodePoint = CodePoint::from(5150u32);
    pub const CANADIAN_SYLLABICS_FINAL_ACUTE : CodePoint = CodePoint::from(5151u32);
    pub const CANADIAN_SYLLABICS_FINAL_GRAVE : CodePoint = CodePoint::from(5152u32);
    pub const CANADIAN_SYLLABICS_FINAL_BOTTOM_HALF_RING : CodePoint = CodePoint::from(5153u32);
    pub const CANADIAN_SYLLABICS_FINAL_TOP_HALF_RING : CodePoint = CodePoint::from(5154u32);
    pub const CANADIAN_SYLLABICS_FINAL_RIGHT_HALF_RING : CodePoint = CodePoint::from(5155u32);
    pub const CANADIAN_SYLLABICS_FINAL_RING : CodePoint = CodePoint::from(5156u32);
    pub const CANADIAN_SYLLABICS_FINAL_DOUBLE_ACUTE : CodePoint = CodePoint::from(5157u32);
    pub const CANADIAN_SYLLABICS_FINAL_DOUBLE_SHORT_VERTICAL_STROKES : CodePoint = CodePoint::from(5158u32);
    pub const CANADIAN_SYLLABICS_FINAL_MIDDLE_DOT : CodePoint = CodePoint::from(5159u32);
    pub const CANADIAN_SYLLABICS_FINAL_SHORT_HORIZONTAL_STROKE : CodePoint = CodePoint::from(5160u32);
    pub const CANADIAN_SYLLABICS_FINAL_PLUS : CodePoint = CodePoint::from(5161u32);
    pub const CANADIAN_SYLLABICS_FINAL_DOWN_TACK : CodePoint = CodePoint::from(5162u32);
    pub const CANADIAN_SYLLABICS_EN : CodePoint = CodePoint::from(5163u32);
    pub const CANADIAN_SYLLABICS_IN : CodePoint = CodePoint::from(5164u32);
    pub const CANADIAN_SYLLABICS_ON : CodePoint = CodePoint::from(5165u32);
    pub const CANADIAN_SYLLABICS_AN : CodePoint = CodePoint::from(5166u32);
    pub const CANADIAN_SYLLABICS_PE : CodePoint = CodePoint::from(5167u32);
    pub const CANADIAN_SYLLABICS_PAAI : CodePoint = CodePoint::from(5168u32);
    pub const CANADIAN_SYLLABICS_PI : CodePoint = CodePoint::from(5169u32);
    pub const CANADIAN_SYLLABICS_PII : CodePoint = CodePoint::from(5170u32);
    pub const CANADIAN_SYLLABICS_PO : CodePoint = CodePoint::from(5171u32);
    pub const CANADIAN_SYLLABICS_POO : CodePoint = CodePoint::from(5172u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_POO : CodePoint = CodePoint::from(5173u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HEE : CodePoint = CodePoint::from(5174u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HI : CodePoint = CodePoint::from(5175u32);
    pub const CANADIAN_SYLLABICS_PA : CodePoint = CodePoint::from(5176u32);
    pub const CANADIAN_SYLLABICS_PAA : CodePoint = CodePoint::from(5177u32);
    pub const CANADIAN_SYLLABICS_PWE : CodePoint = CodePoint::from(5178u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWE : CodePoint = CodePoint::from(5179u32);
    pub const CANADIAN_SYLLABICS_PWI : CodePoint = CodePoint::from(5180u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWI : CodePoint = CodePoint::from(5181u32);
    pub const CANADIAN_SYLLABICS_PWII : CodePoint = CodePoint::from(5182u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWII : CodePoint = CodePoint::from(5183u32);
    pub const CANADIAN_SYLLABICS_PWO : CodePoint = CodePoint::from(5184u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWO : CodePoint = CodePoint::from(5185u32);
    pub const CANADIAN_SYLLABICS_PWOO : CodePoint = CodePoint::from(5186u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWOO : CodePoint = CodePoint::from(5187u32);
    pub const CANADIAN_SYLLABICS_PWA : CodePoint = CodePoint::from(5188u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWA : CodePoint = CodePoint::from(5189u32);
    pub const CANADIAN_SYLLABICS_PWAA : CodePoint = CodePoint::from(5190u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_PWAA : CodePoint = CodePoint::from(5191u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_PWAA : CodePoint = CodePoint::from(5192u32);
    pub const CANADIAN_SYLLABICS_P : CodePoint = CodePoint::from(5193u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_P : CodePoint = CodePoint::from(5194u32);
    pub const CANADIAN_SYLLABICS_CARRIER_H : CodePoint = CodePoint::from(5195u32);
    pub const CANADIAN_SYLLABICS_TE : CodePoint = CodePoint::from(5196u32);
    pub const CANADIAN_SYLLABICS_TAAI : CodePoint = CodePoint::from(5197u32);
    pub const CANADIAN_SYLLABICS_TI : CodePoint = CodePoint::from(5198u32);
    pub const CANADIAN_SYLLABICS_TII : CodePoint = CodePoint::from(5199u32);
    pub const CANADIAN_SYLLABICS_TO : CodePoint = CodePoint::from(5200u32);
    pub const CANADIAN_SYLLABICS_TOO : CodePoint = CodePoint::from(5201u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_TOO : CodePoint = CodePoint::from(5202u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DEE : CodePoint = CodePoint::from(5203u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DI : CodePoint = CodePoint::from(5204u32);
    pub const CANADIAN_SYLLABICS_TA : CodePoint = CodePoint::from(5205u32);
    pub const CANADIAN_SYLLABICS_TAA : CodePoint = CodePoint::from(5206u32);
    pub const CANADIAN_SYLLABICS_TWE : CodePoint = CodePoint::from(5207u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWE : CodePoint = CodePoint::from(5208u32);
    pub const CANADIAN_SYLLABICS_TWI : CodePoint = CodePoint::from(5209u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWI : CodePoint = CodePoint::from(5210u32);
    pub const CANADIAN_SYLLABICS_TWII : CodePoint = CodePoint::from(5211u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWII : CodePoint = CodePoint::from(5212u32);
    pub const CANADIAN_SYLLABICS_TWO : CodePoint = CodePoint::from(5213u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWO : CodePoint = CodePoint::from(5214u32);
    pub const CANADIAN_SYLLABICS_TWOO : CodePoint = CodePoint::from(5215u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWOO : CodePoint = CodePoint::from(5216u32);
    pub const CANADIAN_SYLLABICS_TWA : CodePoint = CodePoint::from(5217u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWA : CodePoint = CodePoint::from(5218u32);
    pub const CANADIAN_SYLLABICS_TWAA : CodePoint = CodePoint::from(5219u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_TWAA : CodePoint = CodePoint::from(5220u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_TWAA : CodePoint = CodePoint::from(5221u32);
    pub const CANADIAN_SYLLABICS_T : CodePoint = CodePoint::from(5222u32);
    pub const CANADIAN_SYLLABICS_TTE : CodePoint = CodePoint::from(5223u32);
    pub const CANADIAN_SYLLABICS_TTI : CodePoint = CodePoint::from(5224u32);
    pub const CANADIAN_SYLLABICS_TTO : CodePoint = CodePoint::from(5225u32);
    pub const CANADIAN_SYLLABICS_TTA : CodePoint = CodePoint::from(5226u32);
    pub const CANADIAN_SYLLABICS_KE : CodePoint = CodePoint::from(5227u32);
    pub const CANADIAN_SYLLABICS_KAAI : CodePoint = CodePoint::from(5228u32);
    pub const CANADIAN_SYLLABICS_KI : CodePoint = CodePoint::from(5229u32);
    pub const CANADIAN_SYLLABICS_KII : CodePoint = CodePoint::from(5230u32);
    pub const CANADIAN_SYLLABICS_KO : CodePoint = CodePoint::from(5231u32);
    pub const CANADIAN_SYLLABICS_KOO : CodePoint = CodePoint::from(5232u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_KOO : CodePoint = CodePoint::from(5233u32);
    pub const CANADIAN_SYLLABICS_KA : CodePoint = CodePoint::from(5234u32);
    pub const CANADIAN_SYLLABICS_KAA : CodePoint = CodePoint::from(5235u32);
    pub const CANADIAN_SYLLABICS_KWE : CodePoint = CodePoint::from(5236u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWE : CodePoint = CodePoint::from(5237u32);
    pub const CANADIAN_SYLLABICS_KWI : CodePoint = CodePoint::from(5238u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWI : CodePoint = CodePoint::from(5239u32);
    pub const CANADIAN_SYLLABICS_KWII : CodePoint = CodePoint::from(5240u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWII : CodePoint = CodePoint::from(5241u32);
    pub const CANADIAN_SYLLABICS_KWO : CodePoint = CodePoint::from(5242u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWO : CodePoint = CodePoint::from(5243u32);
    pub const CANADIAN_SYLLABICS_KWOO : CodePoint = CodePoint::from(5244u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWOO : CodePoint = CodePoint::from(5245u32);
    pub const CANADIAN_SYLLABICS_KWA : CodePoint = CodePoint::from(5246u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWA : CodePoint = CodePoint::from(5247u32);
    pub const CANADIAN_SYLLABICS_KWAA : CodePoint = CodePoint::from(5248u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_KWAA : CodePoint = CodePoint::from(5249u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_KWAA : CodePoint = CodePoint::from(5250u32);
    pub const CANADIAN_SYLLABICS_K : CodePoint = CodePoint::from(5251u32);
    pub const CANADIAN_SYLLABICS_KW : CodePoint = CodePoint::from(5252u32);
    pub const CANADIAN_SYLLABICS_SOUTH_SLAVEY_KEH : CodePoint = CodePoint::from(5253u32);
    pub const CANADIAN_SYLLABICS_SOUTH_SLAVEY_KIH : CodePoint = CodePoint::from(5254u32);
    pub const CANADIAN_SYLLABICS_SOUTH_SLAVEY_KOH : CodePoint = CodePoint::from(5255u32);
    pub const CANADIAN_SYLLABICS_SOUTH_SLAVEY_KAH : CodePoint = CodePoint::from(5256u32);
    pub const CANADIAN_SYLLABICS_CE : CodePoint = CodePoint::from(5257u32);
    pub const CANADIAN_SYLLABICS_CAAI : CodePoint = CodePoint::from(5258u32);
    pub const CANADIAN_SYLLABICS_CI : CodePoint = CodePoint::from(5259u32);
    pub const CANADIAN_SYLLABICS_CII : CodePoint = CodePoint::from(5260u32);
    pub const CANADIAN_SYLLABICS_CO : CodePoint = CodePoint::from(5261u32);
    pub const CANADIAN_SYLLABICS_COO : CodePoint = CodePoint::from(5262u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_COO : CodePoint = CodePoint::from(5263u32);
    pub const CANADIAN_SYLLABICS_CA : CodePoint = CodePoint::from(5264u32);
    pub const CANADIAN_SYLLABICS_CAA : CodePoint = CodePoint::from(5265u32);
    pub const CANADIAN_SYLLABICS_CWE : CodePoint = CodePoint::from(5266u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWE : CodePoint = CodePoint::from(5267u32);
    pub const CANADIAN_SYLLABICS_CWI : CodePoint = CodePoint::from(5268u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWI : CodePoint = CodePoint::from(5269u32);
    pub const CANADIAN_SYLLABICS_CWII : CodePoint = CodePoint::from(5270u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWII : CodePoint = CodePoint::from(5271u32);
    pub const CANADIAN_SYLLABICS_CWO : CodePoint = CodePoint::from(5272u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWO : CodePoint = CodePoint::from(5273u32);
    pub const CANADIAN_SYLLABICS_CWOO : CodePoint = CodePoint::from(5274u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWOO : CodePoint = CodePoint::from(5275u32);
    pub const CANADIAN_SYLLABICS_CWA : CodePoint = CodePoint::from(5276u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWA : CodePoint = CodePoint::from(5277u32);
    pub const CANADIAN_SYLLABICS_CWAA : CodePoint = CodePoint::from(5278u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_CWAA : CodePoint = CodePoint::from(5279u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_CWAA : CodePoint = CodePoint::from(5280u32);
    pub const CANADIAN_SYLLABICS_C : CodePoint = CodePoint::from(5281u32);
    pub const CANADIAN_SYLLABICS_SAYISI_TH : CodePoint = CodePoint::from(5282u32);
    pub const CANADIAN_SYLLABICS_ME : CodePoint = CodePoint::from(5283u32);
    pub const CANADIAN_SYLLABICS_MAAI : CodePoint = CodePoint::from(5284u32);
    pub const CANADIAN_SYLLABICS_MI : CodePoint = CodePoint::from(5285u32);
    pub const CANADIAN_SYLLABICS_MII : CodePoint = CodePoint::from(5286u32);
    pub const CANADIAN_SYLLABICS_MO : CodePoint = CodePoint::from(5287u32);
    pub const CANADIAN_SYLLABICS_MOO : CodePoint = CodePoint::from(5288u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_MOO : CodePoint = CodePoint::from(5289u32);
    pub const CANADIAN_SYLLABICS_MA : CodePoint = CodePoint::from(5290u32);
    pub const CANADIAN_SYLLABICS_MAA : CodePoint = CodePoint::from(5291u32);
    pub const CANADIAN_SYLLABICS_MWE : CodePoint = CodePoint::from(5292u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWE : CodePoint = CodePoint::from(5293u32);
    pub const CANADIAN_SYLLABICS_MWI : CodePoint = CodePoint::from(5294u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWI : CodePoint = CodePoint::from(5295u32);
    pub const CANADIAN_SYLLABICS_MWII : CodePoint = CodePoint::from(5296u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWII : CodePoint = CodePoint::from(5297u32);
    pub const CANADIAN_SYLLABICS_MWO : CodePoint = CodePoint::from(5298u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWO : CodePoint = CodePoint::from(5299u32);
    pub const CANADIAN_SYLLABICS_MWOO : CodePoint = CodePoint::from(5300u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWOO : CodePoint = CodePoint::from(5301u32);
    pub const CANADIAN_SYLLABICS_MWA : CodePoint = CodePoint::from(5302u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWA : CodePoint = CodePoint::from(5303u32);
    pub const CANADIAN_SYLLABICS_MWAA : CodePoint = CodePoint::from(5304u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_MWAA : CodePoint = CodePoint::from(5305u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_MWAA : CodePoint = CodePoint::from(5306u32);
    pub const CANADIAN_SYLLABICS_M : CodePoint = CodePoint::from(5307u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_M : CodePoint = CodePoint::from(5308u32);
    pub const CANADIAN_SYLLABICS_MH : CodePoint = CodePoint::from(5309u32);
    pub const CANADIAN_SYLLABICS_ATHAPASCAN_M : CodePoint = CodePoint::from(5310u32);
    pub const CANADIAN_SYLLABICS_SAYISI_M : CodePoint = CodePoint::from(5311u32);
    pub const CANADIAN_SYLLABICS_NE : CodePoint = CodePoint::from(5312u32);
    pub const CANADIAN_SYLLABICS_NAAI : CodePoint = CodePoint::from(5313u32);
    pub const CANADIAN_SYLLABICS_NI : CodePoint = CodePoint::from(5314u32);
    pub const CANADIAN_SYLLABICS_NII : CodePoint = CodePoint::from(5315u32);
    pub const CANADIAN_SYLLABICS_NO : CodePoint = CodePoint::from(5316u32);
    pub const CANADIAN_SYLLABICS_NOO : CodePoint = CodePoint::from(5317u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_NOO : CodePoint = CodePoint::from(5318u32);
    pub const CANADIAN_SYLLABICS_NA : CodePoint = CodePoint::from(5319u32);
    pub const CANADIAN_SYLLABICS_NAA : CodePoint = CodePoint::from(5320u32);
    pub const CANADIAN_SYLLABICS_NWE : CodePoint = CodePoint::from(5321u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_NWE : CodePoint = CodePoint::from(5322u32);
    pub const CANADIAN_SYLLABICS_NWA : CodePoint = CodePoint::from(5323u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_NWA : CodePoint = CodePoint::from(5324u32);
    pub const CANADIAN_SYLLABICS_NWAA : CodePoint = CodePoint::from(5325u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_NWAA : CodePoint = CodePoint::from(5326u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_NWAA : CodePoint = CodePoint::from(5327u32);
    pub const CANADIAN_SYLLABICS_N : CodePoint = CodePoint::from(5328u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NG : CodePoint = CodePoint::from(5329u32);
    pub const CANADIAN_SYLLABICS_NH : CodePoint = CodePoint::from(5330u32);
    pub const CANADIAN_SYLLABICS_LE : CodePoint = CodePoint::from(5331u32);
    pub const CANADIAN_SYLLABICS_LAAI : CodePoint = CodePoint::from(5332u32);
    pub const CANADIAN_SYLLABICS_LI : CodePoint = CodePoint::from(5333u32);
    pub const CANADIAN_SYLLABICS_LII : CodePoint = CodePoint::from(5334u32);
    pub const CANADIAN_SYLLABICS_LO : CodePoint = CodePoint::from(5335u32);
    pub const CANADIAN_SYLLABICS_LOO : CodePoint = CodePoint::from(5336u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_LOO : CodePoint = CodePoint::from(5337u32);
    pub const CANADIAN_SYLLABICS_LA : CodePoint = CodePoint::from(5338u32);
    pub const CANADIAN_SYLLABICS_LAA : CodePoint = CodePoint::from(5339u32);
    pub const CANADIAN_SYLLABICS_LWE : CodePoint = CodePoint::from(5340u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWE : CodePoint = CodePoint::from(5341u32);
    pub const CANADIAN_SYLLABICS_LWI : CodePoint = CodePoint::from(5342u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWI : CodePoint = CodePoint::from(5343u32);
    pub const CANADIAN_SYLLABICS_LWII : CodePoint = CodePoint::from(5344u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWII : CodePoint = CodePoint::from(5345u32);
    pub const CANADIAN_SYLLABICS_LWO : CodePoint = CodePoint::from(5346u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWO : CodePoint = CodePoint::from(5347u32);
    pub const CANADIAN_SYLLABICS_LWOO : CodePoint = CodePoint::from(5348u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWOO : CodePoint = CodePoint::from(5349u32);
    pub const CANADIAN_SYLLABICS_LWA : CodePoint = CodePoint::from(5350u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWA : CodePoint = CodePoint::from(5351u32);
    pub const CANADIAN_SYLLABICS_LWAA : CodePoint = CodePoint::from(5352u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LWAA : CodePoint = CodePoint::from(5353u32);
    pub const CANADIAN_SYLLABICS_L : CodePoint = CodePoint::from(5354u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_L : CodePoint = CodePoint::from(5355u32);
    pub const CANADIAN_SYLLABICS_MEDIAL_L : CodePoint = CodePoint::from(5356u32);
    pub const CANADIAN_SYLLABICS_SE : CodePoint = CodePoint::from(5357u32);
    pub const CANADIAN_SYLLABICS_SAAI : CodePoint = CodePoint::from(5358u32);
    pub const CANADIAN_SYLLABICS_SI : CodePoint = CodePoint::from(5359u32);
    pub const CANADIAN_SYLLABICS_SII : CodePoint = CodePoint::from(5360u32);
    pub const CANADIAN_SYLLABICS_SO : CodePoint = CodePoint::from(5361u32);
    pub const CANADIAN_SYLLABICS_SOO : CodePoint = CodePoint::from(5362u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_SOO : CodePoint = CodePoint::from(5363u32);
    pub const CANADIAN_SYLLABICS_SA : CodePoint = CodePoint::from(5364u32);
    pub const CANADIAN_SYLLABICS_SAA : CodePoint = CodePoint::from(5365u32);
    pub const CANADIAN_SYLLABICS_SWE : CodePoint = CodePoint::from(5366u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWE : CodePoint = CodePoint::from(5367u32);
    pub const CANADIAN_SYLLABICS_SWI : CodePoint = CodePoint::from(5368u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWI : CodePoint = CodePoint::from(5369u32);
    pub const CANADIAN_SYLLABICS_SWII : CodePoint = CodePoint::from(5370u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWII : CodePoint = CodePoint::from(5371u32);
    pub const CANADIAN_SYLLABICS_SWO : CodePoint = CodePoint::from(5372u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWO : CodePoint = CodePoint::from(5373u32);
    pub const CANADIAN_SYLLABICS_SWOO : CodePoint = CodePoint::from(5374u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWOO : CodePoint = CodePoint::from(5375u32);
    pub const CANADIAN_SYLLABICS_SWA : CodePoint = CodePoint::from(5376u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWA : CodePoint = CodePoint::from(5377u32);
    pub const CANADIAN_SYLLABICS_SWAA : CodePoint = CodePoint::from(5378u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SWAA : CodePoint = CodePoint::from(5379u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_SWAA : CodePoint = CodePoint::from(5380u32);
    pub const CANADIAN_SYLLABICS_S : CodePoint = CodePoint::from(5381u32);
    pub const CANADIAN_SYLLABICS_ATHAPASCAN_S : CodePoint = CodePoint::from(5382u32);
    pub const CANADIAN_SYLLABICS_SW : CodePoint = CodePoint::from(5383u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_S : CodePoint = CodePoint::from(5384u32);
    pub const CANADIAN_SYLLABICS_MOOSE_CREE_SK : CodePoint = CodePoint::from(5385u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_SKW : CodePoint = CodePoint::from(5386u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_S_W : CodePoint = CodePoint::from(5387u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_SPWA : CodePoint = CodePoint::from(5388u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_STWA : CodePoint = CodePoint::from(5389u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_SKWA : CodePoint = CodePoint::from(5390u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_SCWA : CodePoint = CodePoint::from(5391u32);
    pub const CANADIAN_SYLLABICS_SHE : CodePoint = CodePoint::from(5392u32);
    pub const CANADIAN_SYLLABICS_SHI : CodePoint = CodePoint::from(5393u32);
    pub const CANADIAN_SYLLABICS_SHII : CodePoint = CodePoint::from(5394u32);
    pub const CANADIAN_SYLLABICS_SHO : CodePoint = CodePoint::from(5395u32);
    pub const CANADIAN_SYLLABICS_SHOO : CodePoint = CodePoint::from(5396u32);
    pub const CANADIAN_SYLLABICS_SHA : CodePoint = CodePoint::from(5397u32);
    pub const CANADIAN_SYLLABICS_SHAA : CodePoint = CodePoint::from(5398u32);
    pub const CANADIAN_SYLLABICS_SHWE : CodePoint = CodePoint::from(5399u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWE : CodePoint = CodePoint::from(5400u32);
    pub const CANADIAN_SYLLABICS_SHWI : CodePoint = CodePoint::from(5401u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWI : CodePoint = CodePoint::from(5402u32);
    pub const CANADIAN_SYLLABICS_SHWII : CodePoint = CodePoint::from(5403u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWII : CodePoint = CodePoint::from(5404u32);
    pub const CANADIAN_SYLLABICS_SHWO : CodePoint = CodePoint::from(5405u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWO : CodePoint = CodePoint::from(5406u32);
    pub const CANADIAN_SYLLABICS_SHWOO : CodePoint = CodePoint::from(5407u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWOO : CodePoint = CodePoint::from(5408u32);
    pub const CANADIAN_SYLLABICS_SHWA : CodePoint = CodePoint::from(5409u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWA : CodePoint = CodePoint::from(5410u32);
    pub const CANADIAN_SYLLABICS_SHWAA : CodePoint = CodePoint::from(5411u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_SHWAA : CodePoint = CodePoint::from(5412u32);
    pub const CANADIAN_SYLLABICS_SH : CodePoint = CodePoint::from(5413u32);
    pub const CANADIAN_SYLLABICS_YE : CodePoint = CodePoint::from(5414u32);
    pub const CANADIAN_SYLLABICS_YAAI : CodePoint = CodePoint::from(5415u32);
    pub const CANADIAN_SYLLABICS_YI : CodePoint = CodePoint::from(5416u32);
    pub const CANADIAN_SYLLABICS_YII : CodePoint = CodePoint::from(5417u32);
    pub const CANADIAN_SYLLABICS_YO : CodePoint = CodePoint::from(5418u32);
    pub const CANADIAN_SYLLABICS_YOO : CodePoint = CodePoint::from(5419u32);
    pub const CANADIAN_SYLLABICS_Y_CREE_YOO : CodePoint = CodePoint::from(5420u32);
    pub const CANADIAN_SYLLABICS_YA : CodePoint = CodePoint::from(5421u32);
    pub const CANADIAN_SYLLABICS_YAA : CodePoint = CodePoint::from(5422u32);
    pub const CANADIAN_SYLLABICS_YWE : CodePoint = CodePoint::from(5423u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWE : CodePoint = CodePoint::from(5424u32);
    pub const CANADIAN_SYLLABICS_YWI : CodePoint = CodePoint::from(5425u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWI : CodePoint = CodePoint::from(5426u32);
    pub const CANADIAN_SYLLABICS_YWII : CodePoint = CodePoint::from(5427u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWII : CodePoint = CodePoint::from(5428u32);
    pub const CANADIAN_SYLLABICS_YWO : CodePoint = CodePoint::from(5429u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWO : CodePoint = CodePoint::from(5430u32);
    pub const CANADIAN_SYLLABICS_YWOO : CodePoint = CodePoint::from(5431u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWOO : CodePoint = CodePoint::from(5432u32);
    pub const CANADIAN_SYLLABICS_YWA : CodePoint = CodePoint::from(5433u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWA : CodePoint = CodePoint::from(5434u32);
    pub const CANADIAN_SYLLABICS_YWAA : CodePoint = CodePoint::from(5435u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_YWAA : CodePoint = CodePoint::from(5436u32);
    pub const CANADIAN_SYLLABICS_NASKAPI_YWAA : CodePoint = CodePoint::from(5437u32);
    pub const CANADIAN_SYLLABICS_Y : CodePoint = CodePoint::from(5438u32);
    pub const CANADIAN_SYLLABICS_BIBLE_CREE_Y : CodePoint = CodePoint::from(5439u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_Y : CodePoint = CodePoint::from(5440u32);
    pub const CANADIAN_SYLLABICS_SAYISI_YI : CodePoint = CodePoint::from(5441u32);
    pub const CANADIAN_SYLLABICS_RE : CodePoint = CodePoint::from(5442u32);
    pub const CANADIAN_SYLLABICS_R_CREE_RE : CodePoint = CodePoint::from(5443u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LE : CodePoint = CodePoint::from(5444u32);
    pub const CANADIAN_SYLLABICS_RAAI : CodePoint = CodePoint::from(5445u32);
    pub const CANADIAN_SYLLABICS_RI : CodePoint = CodePoint::from(5446u32);
    pub const CANADIAN_SYLLABICS_RII : CodePoint = CodePoint::from(5447u32);
    pub const CANADIAN_SYLLABICS_RO : CodePoint = CodePoint::from(5448u32);
    pub const CANADIAN_SYLLABICS_ROO : CodePoint = CodePoint::from(5449u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LO : CodePoint = CodePoint::from(5450u32);
    pub const CANADIAN_SYLLABICS_RA : CodePoint = CodePoint::from(5451u32);
    pub const CANADIAN_SYLLABICS_RAA : CodePoint = CodePoint::from(5452u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LA : CodePoint = CodePoint::from(5453u32);
    pub const CANADIAN_SYLLABICS_RWAA : CodePoint = CodePoint::from(5454u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_RWAA : CodePoint = CodePoint::from(5455u32);
    pub const CANADIAN_SYLLABICS_R : CodePoint = CodePoint::from(5456u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_R : CodePoint = CodePoint::from(5457u32);
    pub const CANADIAN_SYLLABICS_MEDIAL_R : CodePoint = CodePoint::from(5458u32);
    pub const CANADIAN_SYLLABICS_FE : CodePoint = CodePoint::from(5459u32);
    pub const CANADIAN_SYLLABICS_FAAI : CodePoint = CodePoint::from(5460u32);
    pub const CANADIAN_SYLLABICS_FI : CodePoint = CodePoint::from(5461u32);
    pub const CANADIAN_SYLLABICS_FII : CodePoint = CodePoint::from(5462u32);
    pub const CANADIAN_SYLLABICS_FO : CodePoint = CodePoint::from(5463u32);
    pub const CANADIAN_SYLLABICS_FOO : CodePoint = CodePoint::from(5464u32);
    pub const CANADIAN_SYLLABICS_FA : CodePoint = CodePoint::from(5465u32);
    pub const CANADIAN_SYLLABICS_FAA : CodePoint = CodePoint::from(5466u32);
    pub const CANADIAN_SYLLABICS_FWAA : CodePoint = CodePoint::from(5467u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_FWAA : CodePoint = CodePoint::from(5468u32);
    pub const CANADIAN_SYLLABICS_F : CodePoint = CodePoint::from(5469u32);
    pub const CANADIAN_SYLLABICS_THE : CodePoint = CodePoint::from(5470u32);
    pub const CANADIAN_SYLLABICS_N_CREE_THE : CodePoint = CodePoint::from(5471u32);
    pub const CANADIAN_SYLLABICS_THI : CodePoint = CodePoint::from(5472u32);
    pub const CANADIAN_SYLLABICS_N_CREE_THI : CodePoint = CodePoint::from(5473u32);
    pub const CANADIAN_SYLLABICS_THII : CodePoint = CodePoint::from(5474u32);
    pub const CANADIAN_SYLLABICS_N_CREE_THII : CodePoint = CodePoint::from(5475u32);
    pub const CANADIAN_SYLLABICS_THO : CodePoint = CodePoint::from(5476u32);
    pub const CANADIAN_SYLLABICS_THOO : CodePoint = CodePoint::from(5477u32);
    pub const CANADIAN_SYLLABICS_THA : CodePoint = CodePoint::from(5478u32);
    pub const CANADIAN_SYLLABICS_THAA : CodePoint = CodePoint::from(5479u32);
    pub const CANADIAN_SYLLABICS_THWAA : CodePoint = CodePoint::from(5480u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_THWAA : CodePoint = CodePoint::from(5481u32);
    pub const CANADIAN_SYLLABICS_TH : CodePoint = CodePoint::from(5482u32);
    pub const CANADIAN_SYLLABICS_TTHE : CodePoint = CodePoint::from(5483u32);
    pub const CANADIAN_SYLLABICS_TTHI : CodePoint = CodePoint::from(5484u32);
    pub const CANADIAN_SYLLABICS_TTHO : CodePoint = CodePoint::from(5485u32);
    pub const CANADIAN_SYLLABICS_TTHA : CodePoint = CodePoint::from(5486u32);
    pub const CANADIAN_SYLLABICS_TTH : CodePoint = CodePoint::from(5487u32);
    pub const CANADIAN_SYLLABICS_TYE : CodePoint = CodePoint::from(5488u32);
    pub const CANADIAN_SYLLABICS_TYI : CodePoint = CodePoint::from(5489u32);
    pub const CANADIAN_SYLLABICS_TYO : CodePoint = CodePoint::from(5490u32);
    pub const CANADIAN_SYLLABICS_TYA : CodePoint = CodePoint::from(5491u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HE : CodePoint = CodePoint::from(5492u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HI : CodePoint = CodePoint::from(5493u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HII : CodePoint = CodePoint::from(5494u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HO : CodePoint = CodePoint::from(5495u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HOO : CodePoint = CodePoint::from(5496u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HA : CodePoint = CodePoint::from(5497u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_HAA : CodePoint = CodePoint::from(5498u32);
    pub const CANADIAN_SYLLABICS_NUNAVIK_H : CodePoint = CodePoint::from(5499u32);
    pub const CANADIAN_SYLLABICS_NUNAVUT_H : CodePoint = CodePoint::from(5500u32);
    pub const CANADIAN_SYLLABICS_HK : CodePoint = CodePoint::from(5501u32);
    pub const CANADIAN_SYLLABICS_QAAI : CodePoint = CodePoint::from(5502u32);
    pub const CANADIAN_SYLLABICS_QI : CodePoint = CodePoint::from(5503u32);
    pub const CANADIAN_SYLLABICS_QII : CodePoint = CodePoint::from(5504u32);
    pub const CANADIAN_SYLLABICS_QO : CodePoint = CodePoint::from(5505u32);
    pub const CANADIAN_SYLLABICS_QOO : CodePoint = CodePoint::from(5506u32);
    pub const CANADIAN_SYLLABICS_QA : CodePoint = CodePoint::from(5507u32);
    pub const CANADIAN_SYLLABICS_QAA : CodePoint = CodePoint::from(5508u32);
    pub const CANADIAN_SYLLABICS_Q : CodePoint = CodePoint::from(5509u32);
    pub const CANADIAN_SYLLABICS_TLHE : CodePoint = CodePoint::from(5510u32);
    pub const CANADIAN_SYLLABICS_TLHI : CodePoint = CodePoint::from(5511u32);
    pub const CANADIAN_SYLLABICS_TLHO : CodePoint = CodePoint::from(5512u32);
    pub const CANADIAN_SYLLABICS_TLHA : CodePoint = CodePoint::from(5513u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_RE : CodePoint = CodePoint::from(5514u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_RI : CodePoint = CodePoint::from(5515u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_RO : CodePoint = CodePoint::from(5516u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_RA : CodePoint = CodePoint::from(5517u32);
    pub const CANADIAN_SYLLABICS_NGAAI : CodePoint = CodePoint::from(5518u32);
    pub const CANADIAN_SYLLABICS_NGI : CodePoint = CodePoint::from(5519u32);
    pub const CANADIAN_SYLLABICS_NGII : CodePoint = CodePoint::from(5520u32);
    pub const CANADIAN_SYLLABICS_NGO : CodePoint = CodePoint::from(5521u32);
    pub const CANADIAN_SYLLABICS_NGOO : CodePoint = CodePoint::from(5522u32);
    pub const CANADIAN_SYLLABICS_NGA : CodePoint = CodePoint::from(5523u32);
    pub const CANADIAN_SYLLABICS_NGAA : CodePoint = CodePoint::from(5524u32);
    pub const CANADIAN_SYLLABICS_NG : CodePoint = CodePoint::from(5525u32);
    pub const CANADIAN_SYLLABICS_NNG : CodePoint = CodePoint::from(5526u32);
    pub const CANADIAN_SYLLABICS_SAYISI_SHE : CodePoint = CodePoint::from(5527u32);
    pub const CANADIAN_SYLLABICS_SAYISI_SHI : CodePoint = CodePoint::from(5528u32);
    pub const CANADIAN_SYLLABICS_SAYISI_SHO : CodePoint = CodePoint::from(5529u32);
    pub const CANADIAN_SYLLABICS_SAYISI_SHA : CodePoint = CodePoint::from(5530u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THE : CodePoint = CodePoint::from(5531u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THI : CodePoint = CodePoint::from(5532u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THO : CodePoint = CodePoint::from(5533u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THA : CodePoint = CodePoint::from(5534u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_TH : CodePoint = CodePoint::from(5535u32);
    pub const CANADIAN_SYLLABICS_LHI : CodePoint = CodePoint::from(5536u32);
    pub const CANADIAN_SYLLABICS_LHII : CodePoint = CodePoint::from(5537u32);
    pub const CANADIAN_SYLLABICS_LHO : CodePoint = CodePoint::from(5538u32);
    pub const CANADIAN_SYLLABICS_LHOO : CodePoint = CodePoint::from(5539u32);
    pub const CANADIAN_SYLLABICS_LHA : CodePoint = CodePoint::from(5540u32);
    pub const CANADIAN_SYLLABICS_LHAA : CodePoint = CodePoint::from(5541u32);
    pub const CANADIAN_SYLLABICS_LH : CodePoint = CodePoint::from(5542u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THE : CodePoint = CodePoint::from(5543u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THI : CodePoint = CodePoint::from(5544u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THII : CodePoint = CodePoint::from(5545u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THO : CodePoint = CodePoint::from(5546u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THOO : CodePoint = CodePoint::from(5547u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THA : CodePoint = CodePoint::from(5548u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_THAA : CodePoint = CodePoint::from(5549u32);
    pub const CANADIAN_SYLLABICS_TH_CREE_TH : CodePoint = CodePoint::from(5550u32);
    pub const CANADIAN_SYLLABICS_AIVILIK_B : CodePoint = CodePoint::from(5551u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_E : CodePoint = CodePoint::from(5552u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_I : CodePoint = CodePoint::from(5553u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_O : CodePoint = CodePoint::from(5554u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_A : CodePoint = CodePoint::from(5555u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_WE : CodePoint = CodePoint::from(5556u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_WI : CodePoint = CodePoint::from(5557u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_WO : CodePoint = CodePoint::from(5558u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_WA : CodePoint = CodePoint::from(5559u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_NE : CodePoint = CodePoint::from(5560u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_NI : CodePoint = CodePoint::from(5561u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_NO : CodePoint = CodePoint::from(5562u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_NA : CodePoint = CodePoint::from(5563u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_KE : CodePoint = CodePoint::from(5564u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_KI : CodePoint = CodePoint::from(5565u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_KO : CodePoint = CodePoint::from(5566u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_KA : CodePoint = CodePoint::from(5567u32);
    pub const CANADIAN_SYLLABICS_SAYISI_HE : CodePoint = CodePoint::from(5568u32);
    pub const CANADIAN_SYLLABICS_SAYISI_HI : CodePoint = CodePoint::from(5569u32);
    pub const CANADIAN_SYLLABICS_SAYISI_HO : CodePoint = CodePoint::from(5570u32);
    pub const CANADIAN_SYLLABICS_SAYISI_HA : CodePoint = CodePoint::from(5571u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GHU : CodePoint = CodePoint::from(5572u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GHO : CodePoint = CodePoint::from(5573u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GHE : CodePoint = CodePoint::from(5574u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GHEE : CodePoint = CodePoint::from(5575u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GHI : CodePoint = CodePoint::from(5576u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GHA : CodePoint = CodePoint::from(5577u32);
    pub const CANADIAN_SYLLABICS_CARRIER_RU : CodePoint = CodePoint::from(5578u32);
    pub const CANADIAN_SYLLABICS_CARRIER_RO : CodePoint = CodePoint::from(5579u32);
    pub const CANADIAN_SYLLABICS_CARRIER_RE : CodePoint = CodePoint::from(5580u32);
    pub const CANADIAN_SYLLABICS_CARRIER_REE : CodePoint = CodePoint::from(5581u32);
    pub const CANADIAN_SYLLABICS_CARRIER_RI : CodePoint = CodePoint::from(5582u32);
    pub const CANADIAN_SYLLABICS_CARRIER_RA : CodePoint = CodePoint::from(5583u32);
    pub const CANADIAN_SYLLABICS_CARRIER_WU : CodePoint = CodePoint::from(5584u32);
    pub const CANADIAN_SYLLABICS_CARRIER_WO : CodePoint = CodePoint::from(5585u32);
    pub const CANADIAN_SYLLABICS_CARRIER_WE : CodePoint = CodePoint::from(5586u32);
    pub const CANADIAN_SYLLABICS_CARRIER_WEE : CodePoint = CodePoint::from(5587u32);
    pub const CANADIAN_SYLLABICS_CARRIER_WI : CodePoint = CodePoint::from(5588u32);
    pub const CANADIAN_SYLLABICS_CARRIER_WA : CodePoint = CodePoint::from(5589u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HWU : CodePoint = CodePoint::from(5590u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HWO : CodePoint = CodePoint::from(5591u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HWE : CodePoint = CodePoint::from(5592u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HWEE : CodePoint = CodePoint::from(5593u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HWI : CodePoint = CodePoint::from(5594u32);
    pub const CANADIAN_SYLLABICS_CARRIER_HWA : CodePoint = CodePoint::from(5595u32);
    pub const CANADIAN_SYLLABICS_CARRIER_THU : CodePoint = CodePoint::from(5596u32);
    pub const CANADIAN_SYLLABICS_CARRIER_THO : CodePoint = CodePoint::from(5597u32);
    pub const CANADIAN_SYLLABICS_CARRIER_THE : CodePoint = CodePoint::from(5598u32);
    pub const CANADIAN_SYLLABICS_CARRIER_THEE : CodePoint = CodePoint::from(5599u32);
    pub const CANADIAN_SYLLABICS_CARRIER_THI : CodePoint = CodePoint::from(5600u32);
    pub const CANADIAN_SYLLABICS_CARRIER_THA : CodePoint = CodePoint::from(5601u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTU : CodePoint = CodePoint::from(5602u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTO : CodePoint = CodePoint::from(5603u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTE : CodePoint = CodePoint::from(5604u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTEE : CodePoint = CodePoint::from(5605u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTI : CodePoint = CodePoint::from(5606u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTA : CodePoint = CodePoint::from(5607u32);
    pub const CANADIAN_SYLLABICS_CARRIER_PU : CodePoint = CodePoint::from(5608u32);
    pub const CANADIAN_SYLLABICS_CARRIER_PO : CodePoint = CodePoint::from(5609u32);
    pub const CANADIAN_SYLLABICS_CARRIER_PE : CodePoint = CodePoint::from(5610u32);
    pub const CANADIAN_SYLLABICS_CARRIER_PEE : CodePoint = CodePoint::from(5611u32);
    pub const CANADIAN_SYLLABICS_CARRIER_PI : CodePoint = CodePoint::from(5612u32);
    pub const CANADIAN_SYLLABICS_CARRIER_PA : CodePoint = CodePoint::from(5613u32);
    pub const CANADIAN_SYLLABICS_CARRIER_P : CodePoint = CodePoint::from(5614u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GU : CodePoint = CodePoint::from(5615u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GO : CodePoint = CodePoint::from(5616u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GE : CodePoint = CodePoint::from(5617u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GEE : CodePoint = CodePoint::from(5618u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GI : CodePoint = CodePoint::from(5619u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GA : CodePoint = CodePoint::from(5620u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KHU : CodePoint = CodePoint::from(5621u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KHO : CodePoint = CodePoint::from(5622u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KHE : CodePoint = CodePoint::from(5623u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KHEE : CodePoint = CodePoint::from(5624u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KHI : CodePoint = CodePoint::from(5625u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KHA : CodePoint = CodePoint::from(5626u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KKU : CodePoint = CodePoint::from(5627u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KKO : CodePoint = CodePoint::from(5628u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KKE : CodePoint = CodePoint::from(5629u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KKEE : CodePoint = CodePoint::from(5630u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KKI : CodePoint = CodePoint::from(5631u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KKA : CodePoint = CodePoint::from(5632u32);
    pub const CANADIAN_SYLLABICS_CARRIER_KK : CodePoint = CodePoint::from(5633u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NU : CodePoint = CodePoint::from(5634u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NO : CodePoint = CodePoint::from(5635u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NE : CodePoint = CodePoint::from(5636u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NEE : CodePoint = CodePoint::from(5637u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NI : CodePoint = CodePoint::from(5638u32);
    pub const CANADIAN_SYLLABICS_CARRIER_NA : CodePoint = CodePoint::from(5639u32);
    pub const CANADIAN_SYLLABICS_CARRIER_MU : CodePoint = CodePoint::from(5640u32);
    pub const CANADIAN_SYLLABICS_CARRIER_MO : CodePoint = CodePoint::from(5641u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ME : CodePoint = CodePoint::from(5642u32);
    pub const CANADIAN_SYLLABICS_CARRIER_MEE : CodePoint = CodePoint::from(5643u32);
    pub const CANADIAN_SYLLABICS_CARRIER_MI : CodePoint = CodePoint::from(5644u32);
    pub const CANADIAN_SYLLABICS_CARRIER_MA : CodePoint = CodePoint::from(5645u32);
    pub const CANADIAN_SYLLABICS_CARRIER_YU : CodePoint = CodePoint::from(5646u32);
    pub const CANADIAN_SYLLABICS_CARRIER_YO : CodePoint = CodePoint::from(5647u32);
    pub const CANADIAN_SYLLABICS_CARRIER_YE : CodePoint = CodePoint::from(5648u32);
    pub const CANADIAN_SYLLABICS_CARRIER_YEE : CodePoint = CodePoint::from(5649u32);
    pub const CANADIAN_SYLLABICS_CARRIER_YI : CodePoint = CodePoint::from(5650u32);
    pub const CANADIAN_SYLLABICS_CARRIER_YA : CodePoint = CodePoint::from(5651u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JU : CodePoint = CodePoint::from(5652u32);
    pub const CANADIAN_SYLLABICS_SAYISI_JU : CodePoint = CodePoint::from(5653u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JO : CodePoint = CodePoint::from(5654u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JE : CodePoint = CodePoint::from(5655u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JEE : CodePoint = CodePoint::from(5656u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JI : CodePoint = CodePoint::from(5657u32);
    pub const CANADIAN_SYLLABICS_SAYISI_JI : CodePoint = CodePoint::from(5658u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JA : CodePoint = CodePoint::from(5659u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JJU : CodePoint = CodePoint::from(5660u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JJO : CodePoint = CodePoint::from(5661u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JJE : CodePoint = CodePoint::from(5662u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JJEE : CodePoint = CodePoint::from(5663u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JJI : CodePoint = CodePoint::from(5664u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JJA : CodePoint = CodePoint::from(5665u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LU : CodePoint = CodePoint::from(5666u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LO : CodePoint = CodePoint::from(5667u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LE : CodePoint = CodePoint::from(5668u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LEE : CodePoint = CodePoint::from(5669u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LI : CodePoint = CodePoint::from(5670u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LA : CodePoint = CodePoint::from(5671u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DLU : CodePoint = CodePoint::from(5672u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DLO : CodePoint = CodePoint::from(5673u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DLE : CodePoint = CodePoint::from(5674u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DLEE : CodePoint = CodePoint::from(5675u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DLI : CodePoint = CodePoint::from(5676u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DLA : CodePoint = CodePoint::from(5677u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LHU : CodePoint = CodePoint::from(5678u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LHO : CodePoint = CodePoint::from(5679u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LHE : CodePoint = CodePoint::from(5680u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LHEE : CodePoint = CodePoint::from(5681u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LHI : CodePoint = CodePoint::from(5682u32);
    pub const CANADIAN_SYLLABICS_CARRIER_LHA : CodePoint = CodePoint::from(5683u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLHU : CodePoint = CodePoint::from(5684u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLHO : CodePoint = CodePoint::from(5685u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLHE : CodePoint = CodePoint::from(5686u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLHEE : CodePoint = CodePoint::from(5687u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLHI : CodePoint = CodePoint::from(5688u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLHA : CodePoint = CodePoint::from(5689u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLU : CodePoint = CodePoint::from(5690u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLO : CodePoint = CodePoint::from(5691u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLE : CodePoint = CodePoint::from(5692u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLEE : CodePoint = CodePoint::from(5693u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLI : CodePoint = CodePoint::from(5694u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TLA : CodePoint = CodePoint::from(5695u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ZU : CodePoint = CodePoint::from(5696u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ZO : CodePoint = CodePoint::from(5697u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ZE : CodePoint = CodePoint::from(5698u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ZEE : CodePoint = CodePoint::from(5699u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ZI : CodePoint = CodePoint::from(5700u32);
    pub const CANADIAN_SYLLABICS_CARRIER_ZA : CodePoint = CodePoint::from(5701u32);
    pub const CANADIAN_SYLLABICS_CARRIER_Z : CodePoint = CodePoint::from(5702u32);
    pub const CANADIAN_SYLLABICS_CARRIER_INITIAL_Z : CodePoint = CodePoint::from(5703u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DZU : CodePoint = CodePoint::from(5704u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DZO : CodePoint = CodePoint::from(5705u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DZE : CodePoint = CodePoint::from(5706u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DZEE : CodePoint = CodePoint::from(5707u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DZI : CodePoint = CodePoint::from(5708u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DZA : CodePoint = CodePoint::from(5709u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SU : CodePoint = CodePoint::from(5710u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SO : CodePoint = CodePoint::from(5711u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SE : CodePoint = CodePoint::from(5712u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SEE : CodePoint = CodePoint::from(5713u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SI : CodePoint = CodePoint::from(5714u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SA : CodePoint = CodePoint::from(5715u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SHU : CodePoint = CodePoint::from(5716u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SHO : CodePoint = CodePoint::from(5717u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SHE : CodePoint = CodePoint::from(5718u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SHEE : CodePoint = CodePoint::from(5719u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SHI : CodePoint = CodePoint::from(5720u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SHA : CodePoint = CodePoint::from(5721u32);
    pub const CANADIAN_SYLLABICS_CARRIER_SH : CodePoint = CodePoint::from(5722u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TSU : CodePoint = CodePoint::from(5723u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TSO : CodePoint = CodePoint::from(5724u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TSE : CodePoint = CodePoint::from(5725u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TSEE : CodePoint = CodePoint::from(5726u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TSI : CodePoint = CodePoint::from(5727u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TSA : CodePoint = CodePoint::from(5728u32);
    pub const CANADIAN_SYLLABICS_CARRIER_CHU : CodePoint = CodePoint::from(5729u32);
    pub const CANADIAN_SYLLABICS_CARRIER_CHO : CodePoint = CodePoint::from(5730u32);
    pub const CANADIAN_SYLLABICS_CARRIER_CHE : CodePoint = CodePoint::from(5731u32);
    pub const CANADIAN_SYLLABICS_CARRIER_CHEE : CodePoint = CodePoint::from(5732u32);
    pub const CANADIAN_SYLLABICS_CARRIER_CHI : CodePoint = CodePoint::from(5733u32);
    pub const CANADIAN_SYLLABICS_CARRIER_CHA : CodePoint = CodePoint::from(5734u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTSU : CodePoint = CodePoint::from(5735u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTSO : CodePoint = CodePoint::from(5736u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTSE : CodePoint = CodePoint::from(5737u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTSEE : CodePoint = CodePoint::from(5738u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTSI : CodePoint = CodePoint::from(5739u32);
    pub const CANADIAN_SYLLABICS_CARRIER_TTSA : CodePoint = CodePoint::from(5740u32);
    pub const CANADIAN_SYLLABICS_CHI_SIGN : CodePoint = CodePoint::from(5741u32);
    pub const CANADIAN_SYLLABICS_FULL_STOP : CodePoint = CodePoint::from(5742u32);
    pub const CANADIAN_SYLLABICS_QAI : CodePoint = CodePoint::from(5743u32);
    pub const CANADIAN_SYLLABICS_NGAI : CodePoint = CodePoint::from(5744u32);
    pub const CANADIAN_SYLLABICS_NNGI : CodePoint = CodePoint::from(5745u32);
    pub const CANADIAN_SYLLABICS_NNGII : CodePoint = CodePoint::from(5746u32);
    pub const CANADIAN_SYLLABICS_NNGO : CodePoint = CodePoint::from(5747u32);
    pub const CANADIAN_SYLLABICS_NNGOO : CodePoint = CodePoint::from(5748u32);
    pub const CANADIAN_SYLLABICS_NNGA : CodePoint = CodePoint::from(5749u32);
    pub const CANADIAN_SYLLABICS_NNGAA : CodePoint = CodePoint::from(5750u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWEE : CodePoint = CodePoint::from(5751u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWI : CodePoint = CodePoint::from(5752u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWII : CodePoint = CodePoint::from(5753u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWO : CodePoint = CodePoint::from(5754u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWOO : CodePoint = CodePoint::from(5755u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWA : CodePoint = CodePoint::from(5756u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_THWAA : CodePoint = CodePoint::from(5757u32);
    pub const CANADIAN_SYLLABICS_WOODS_CREE_FINAL_TH : CodePoint = CodePoint::from(5758u32);
    pub const CANADIAN_SYLLABICS_BLACKFOOT_W : CodePoint = CodePoint::from(5759u32);
    pub const OGHAM_SPACE_MARK : CodePoint = CodePoint::from(5760u32);
    pub const OGHAM_LETTER_BEITH : CodePoint = CodePoint::from(5761u32);
    pub const OGHAM_LETTER_LUIS : CodePoint = CodePoint::from(5762u32);
    pub const OGHAM_LETTER_FEARN : CodePoint = CodePoint::from(5763u32);
    pub const OGHAM_LETTER_SAIL : CodePoint = CodePoint::from(5764u32);
    pub const OGHAM_LETTER_NION : CodePoint = CodePoint::from(5765u32);
    pub const OGHAM_LETTER_UATH : CodePoint = CodePoint::from(5766u32);
    pub const OGHAM_LETTER_DAIR : CodePoint = CodePoint::from(5767u32);
    pub const OGHAM_LETTER_TINNE : CodePoint = CodePoint::from(5768u32);
    pub const OGHAM_LETTER_COLL : CodePoint = CodePoint::from(5769u32);
    pub const OGHAM_LETTER_CEIRT : CodePoint = CodePoint::from(5770u32);
    pub const OGHAM_LETTER_MUIN : CodePoint = CodePoint::from(5771u32);
    pub const OGHAM_LETTER_GORT : CodePoint = CodePoint::from(5772u32);
    pub const OGHAM_LETTER_NGEADAL : CodePoint = CodePoint::from(5773u32);
    pub const OGHAM_LETTER_STRAIF : CodePoint = CodePoint::from(5774u32);
    pub const OGHAM_LETTER_RUIS : CodePoint = CodePoint::from(5775u32);
    pub const OGHAM_LETTER_AILM : CodePoint = CodePoint::from(5776u32);
    pub const OGHAM_LETTER_ONN : CodePoint = CodePoint::from(5777u32);
    pub const OGHAM_LETTER_UR : CodePoint = CodePoint::from(5778u32);
    pub const OGHAM_LETTER_EADHADH : CodePoint = CodePoint::from(5779u32);
    pub const OGHAM_LETTER_IODHADH : CodePoint = CodePoint::from(5780u32);
    pub const OGHAM_LETTER_EABHADH : CodePoint = CodePoint::from(5781u32);
    pub const OGHAM_LETTER_OR : CodePoint = CodePoint::from(5782u32);
    pub const OGHAM_LETTER_UILLEANN : CodePoint = CodePoint::from(5783u32);
    pub const OGHAM_LETTER_IFIN : CodePoint = CodePoint::from(5784u32);
    pub const OGHAM_LETTER_EAMHANCHOLL : CodePoint = CodePoint::from(5785u32);
    pub const OGHAM_LETTER_PEITH : CodePoint = CodePoint::from(5786u32);
    pub const OGHAM_FEATHER_MARK : CodePoint = CodePoint::from(5787u32);
    pub const OGHAM_REVERSED_FEATHER_MARK : CodePoint = CodePoint::from(5788u32);
    pub const RUNIC_LETTER_FEHU_FEOH_FE_F : CodePoint = CodePoint::from(5792u32);
    pub const RUNIC_LETTER_V : CodePoint = CodePoint::from(5793u32);
    pub const RUNIC_LETTER_URUZ_UR_U : CodePoint = CodePoint::from(5794u32);
    pub const RUNIC_LETTER_YR : CodePoint = CodePoint::from(5795u32);
    pub const RUNIC_LETTER_Y : CodePoint = CodePoint::from(5796u32);
    pub const RUNIC_LETTER_W : CodePoint = CodePoint::from(5797u32);
    pub const RUNIC_LETTER_THURISAZ_THURS_THORN : CodePoint = CodePoint::from(5798u32);
    pub const RUNIC_LETTER_ETH : CodePoint = CodePoint::from(5799u32);
    pub const RUNIC_LETTER_ANSUZ_A : CodePoint = CodePoint::from(5800u32);
    pub const RUNIC_LETTER_OS_O : CodePoint = CodePoint::from(5801u32);
    pub const RUNIC_LETTER_AC_A : CodePoint = CodePoint::from(5802u32);
    pub const RUNIC_LETTER_AESC : CodePoint = CodePoint::from(5803u32);
    pub const RUNIC_LETTER_LONG_BRANCH_OSS_O : CodePoint = CodePoint::from(5804u32);
    pub const RUNIC_LETTER_SHORT_TWIG_OSS_O : CodePoint = CodePoint::from(5805u32);
    pub const RUNIC_LETTER_O : CodePoint = CodePoint::from(5806u32);
    pub const RUNIC_LETTER_OE : CodePoint = CodePoint::from(5807u32);
    pub const RUNIC_LETTER_ON : CodePoint = CodePoint::from(5808u32);
    pub const RUNIC_LETTER_RAIDO_RAD_REID_R : CodePoint = CodePoint::from(5809u32);
    pub const RUNIC_LETTER_KAUNA : CodePoint = CodePoint::from(5810u32);
    pub const RUNIC_LETTER_CEN : CodePoint = CodePoint::from(5811u32);
    pub const RUNIC_LETTER_KAUN_K : CodePoint = CodePoint::from(5812u32);
    pub const RUNIC_LETTER_G : CodePoint = CodePoint::from(5813u32);
    pub const RUNIC_LETTER_ENG : CodePoint = CodePoint::from(5814u32);
    pub const RUNIC_LETTER_GEBO_GYFU_G : CodePoint = CodePoint::from(5815u32);
    pub const RUNIC_LETTER_GAR : CodePoint = CodePoint::from(5816u32);
    pub const RUNIC_LETTER_WUNJO_WYNN_W : CodePoint = CodePoint::from(5817u32);
    pub const RUNIC_LETTER_HAGLAZ_H : CodePoint = CodePoint::from(5818u32);
    pub const RUNIC_LETTER_HAEGL_H : CodePoint = CodePoint::from(5819u32);
    pub const RUNIC_LETTER_LONG_BRANCH_HAGALL_H : CodePoint = CodePoint::from(5820u32);
    pub const RUNIC_LETTER_SHORT_TWIG_HAGALL_H : CodePoint = CodePoint::from(5821u32);
    pub const RUNIC_LETTER_NAUDIZ_NYD_NAUD_N : CodePoint = CodePoint::from(5822u32);
    pub const RUNIC_LETTER_SHORT_TWIG_NAUD_N : CodePoint = CodePoint::from(5823u32);
    pub const RUNIC_LETTER_DOTTED_N : CodePoint = CodePoint::from(5824u32);
    pub const RUNIC_LETTER_ISAZ_IS_ISS_I : CodePoint = CodePoint::from(5825u32);
    pub const RUNIC_LETTER_E : CodePoint = CodePoint::from(5826u32);
    pub const RUNIC_LETTER_JERAN_J : CodePoint = CodePoint::from(5827u32);
    pub const RUNIC_LETTER_GER : CodePoint = CodePoint::from(5828u32);
    pub const RUNIC_LETTER_LONG_BRANCH_AR_AE : CodePoint = CodePoint::from(5829u32);
    pub const RUNIC_LETTER_SHORT_TWIG_AR_A : CodePoint = CodePoint::from(5830u32);
    pub const RUNIC_LETTER_IWAZ_EOH : CodePoint = CodePoint::from(5831u32);
    pub const RUNIC_LETTER_PERTHO_PEORTH_P : CodePoint = CodePoint::from(5832u32);
    pub const RUNIC_LETTER_ALGIZ_EOLHX : CodePoint = CodePoint::from(5833u32);
    pub const RUNIC_LETTER_SOWILO_S : CodePoint = CodePoint::from(5834u32);
    pub const RUNIC_LETTER_SIGEL_LONG_BRANCH_SOL_S : CodePoint = CodePoint::from(5835u32);
    pub const RUNIC_LETTER_SHORT_TWIG_SOL_S : CodePoint = CodePoint::from(5836u32);
    pub const RUNIC_LETTER_C : CodePoint = CodePoint::from(5837u32);
    pub const RUNIC_LETTER_Z : CodePoint = CodePoint::from(5838u32);
    pub const RUNIC_LETTER_TIWAZ_TIR_TYR_T : CodePoint = CodePoint::from(5839u32);
    pub const RUNIC_LETTER_SHORT_TWIG_TYR_T : CodePoint = CodePoint::from(5840u32);
    pub const RUNIC_LETTER_D : CodePoint = CodePoint::from(5841u32);
    pub const RUNIC_LETTER_BERKANAN_BEORC_BJARKAN_B : CodePoint = CodePoint::from(5842u32);
    pub const RUNIC_LETTER_SHORT_TWIG_BJARKAN_B : CodePoint = CodePoint::from(5843u32);
    pub const RUNIC_LETTER_DOTTED_P : CodePoint = CodePoint::from(5844u32);
    pub const RUNIC_LETTER_OPEN_P : CodePoint = CodePoint::from(5845u32);
    pub const RUNIC_LETTER_EHWAZ_EH_E : CodePoint = CodePoint::from(5846u32);
    pub const RUNIC_LETTER_MANNAZ_MAN_M : CodePoint = CodePoint::from(5847u32);
    pub const RUNIC_LETTER_LONG_BRANCH_MADR_M : CodePoint = CodePoint::from(5848u32);
    pub const RUNIC_LETTER_SHORT_TWIG_MADR_M : CodePoint = CodePoint::from(5849u32);
    pub const RUNIC_LETTER_LAUKAZ_LAGU_LOGR_L : CodePoint = CodePoint::from(5850u32);
    pub const RUNIC_LETTER_DOTTED_L : CodePoint = CodePoint::from(5851u32);
    pub const RUNIC_LETTER_INGWAZ : CodePoint = CodePoint::from(5852u32);
    pub const RUNIC_LETTER_ING : CodePoint = CodePoint::from(5853u32);
    pub const RUNIC_LETTER_DAGAZ_DAEG_D : CodePoint = CodePoint::from(5854u32);
    pub const RUNIC_LETTER_OTHALAN_ETHEL_O : CodePoint = CodePoint::from(5855u32);
    pub const RUNIC_LETTER_EAR : CodePoint = CodePoint::from(5856u32);
    pub const RUNIC_LETTER_IOR : CodePoint = CodePoint::from(5857u32);
    pub const RUNIC_LETTER_CWEORTH : CodePoint = CodePoint::from(5858u32);
    pub const RUNIC_LETTER_CALC : CodePoint = CodePoint::from(5859u32);
    pub const RUNIC_LETTER_CEALC : CodePoint = CodePoint::from(5860u32);
    pub const RUNIC_LETTER_STAN : CodePoint = CodePoint::from(5861u32);
    pub const RUNIC_LETTER_LONG_BRANCH_YR : CodePoint = CodePoint::from(5862u32);
    pub const RUNIC_LETTER_SHORT_TWIG_YR : CodePoint = CodePoint::from(5863u32);
    pub const RUNIC_LETTER_ICELANDIC_YR : CodePoint = CodePoint::from(5864u32);
    pub const RUNIC_LETTER_Q : CodePoint = CodePoint::from(5865u32);
    pub const RUNIC_LETTER_X : CodePoint = CodePoint::from(5866u32);
    pub const RUNIC_SINGLE_PUNCTUATION : CodePoint = CodePoint::from(5867u32);
    pub const RUNIC_MULTIPLE_PUNCTUATION : CodePoint = CodePoint::from(5868u32);
    pub const RUNIC_CROSS_PUNCTUATION : CodePoint = CodePoint::from(5869u32);
    pub const RUNIC_ARLAUG_SYMBOL : CodePoint = CodePoint::from(5870u32);
    pub const RUNIC_TVIMADUR_SYMBOL : CodePoint = CodePoint::from(5871u32);
    pub const RUNIC_BELGTHOR_SYMBOL : CodePoint = CodePoint::from(5872u32);
    pub const RUNIC_LETTER_K : CodePoint = CodePoint::from(5873u32);
    pub const RUNIC_LETTER_SH : CodePoint = CodePoint::from(5874u32);
    pub const RUNIC_LETTER_OO : CodePoint = CodePoint::from(5875u32);
    pub const RUNIC_LETTER_FRANKS_CASKET_OS : CodePoint = CodePoint::from(5876u32);
    pub const RUNIC_LETTER_FRANKS_CASKET_IS : CodePoint = CodePoint::from(5877u32);
    pub const RUNIC_LETTER_FRANKS_CASKET_EH : CodePoint = CodePoint::from(5878u32);
    pub const RUNIC_LETTER_FRANKS_CASKET_AC : CodePoint = CodePoint::from(5879u32);
    pub const RUNIC_LETTER_FRANKS_CASKET_AESC : CodePoint = CodePoint::from(5880u32);
    pub const TAGALOG_LETTER_A : CodePoint = CodePoint::from(5888u32);
    pub const TAGALOG_LETTER_I : CodePoint = CodePoint::from(5889u32);
    pub const TAGALOG_LETTER_U : CodePoint = CodePoint::from(5890u32);
    pub const TAGALOG_LETTER_KA : CodePoint = CodePoint::from(5891u32);
    pub const TAGALOG_LETTER_GA : CodePoint = CodePoint::from(5892u32);
    pub const TAGALOG_LETTER_NGA : CodePoint = CodePoint::from(5893u32);
    pub const TAGALOG_LETTER_TA : CodePoint = CodePoint::from(5894u32);
    pub const TAGALOG_LETTER_DA : CodePoint = CodePoint::from(5895u32);
    pub const TAGALOG_LETTER_NA : CodePoint = CodePoint::from(5896u32);
    pub const TAGALOG_LETTER_PA : CodePoint = CodePoint::from(5897u32);
    pub const TAGALOG_LETTER_BA : CodePoint = CodePoint::from(5898u32);
    pub const TAGALOG_LETTER_MA : CodePoint = CodePoint::from(5899u32);
    pub const TAGALOG_LETTER_YA : CodePoint = CodePoint::from(5900u32);
    pub const TAGALOG_LETTER_LA : CodePoint = CodePoint::from(5902u32);
    pub const TAGALOG_LETTER_WA : CodePoint = CodePoint::from(5903u32);
    pub const TAGALOG_LETTER_SA : CodePoint = CodePoint::from(5904u32);
    pub const TAGALOG_LETTER_HA : CodePoint = CodePoint::from(5905u32);
    pub const TAGALOG_VOWEL_SIGN_I : CodePoint = CodePoint::from(5906u32);
    pub const TAGALOG_VOWEL_SIGN_U : CodePoint = CodePoint::from(5907u32);
    pub const TAGALOG_SIGN_VIRAMA : CodePoint = CodePoint::from(5908u32);
    pub const HANUNOO_LETTER_A : CodePoint = CodePoint::from(5920u32);
    pub const HANUNOO_LETTER_I : CodePoint = CodePoint::from(5921u32);
    pub const HANUNOO_LETTER_U : CodePoint = CodePoint::from(5922u32);
    pub const HANUNOO_LETTER_KA : CodePoint = CodePoint::from(5923u32);
    pub const HANUNOO_LETTER_GA : CodePoint = CodePoint::from(5924u32);
    pub const HANUNOO_LETTER_NGA : CodePoint = CodePoint::from(5925u32);
    pub const HANUNOO_LETTER_TA : CodePoint = CodePoint::from(5926u32);
    pub const HANUNOO_LETTER_DA : CodePoint = CodePoint::from(5927u32);
    pub const HANUNOO_LETTER_NA : CodePoint = CodePoint::from(5928u32);
    pub const HANUNOO_LETTER_PA : CodePoint = CodePoint::from(5929u32);
    pub const HANUNOO_LETTER_BA : CodePoint = CodePoint::from(5930u32);
    pub const HANUNOO_LETTER_MA : CodePoint = CodePoint::from(5931u32);
    pub const HANUNOO_LETTER_YA : CodePoint = CodePoint::from(5932u32);
    pub const HANUNOO_LETTER_RA : CodePoint = CodePoint::from(5933u32);
    pub const HANUNOO_LETTER_LA : CodePoint = CodePoint::from(5934u32);
    pub const HANUNOO_LETTER_WA : CodePoint = CodePoint::from(5935u32);
    pub const HANUNOO_LETTER_SA : CodePoint = CodePoint::from(5936u32);
    pub const HANUNOO_LETTER_HA : CodePoint = CodePoint::from(5937u32);
    pub const HANUNOO_VOWEL_SIGN_I : CodePoint = CodePoint::from(5938u32);
    pub const HANUNOO_VOWEL_SIGN_U : CodePoint = CodePoint::from(5939u32);
    pub const HANUNOO_SIGN_PAMUDPOD : CodePoint = CodePoint::from(5940u32);
    pub const PHILIPPINE_SINGLE_PUNCTUATION : CodePoint = CodePoint::from(5941u32);
    pub const PHILIPPINE_DOUBLE_PUNCTUATION : CodePoint = CodePoint::from(5942u32);
    pub const BUHID_LETTER_A : CodePoint = CodePoint::from(5952u32);
    pub const BUHID_LETTER_I : CodePoint = CodePoint::from(5953u32);
    pub const BUHID_LETTER_U : CodePoint = CodePoint::from(5954u32);
    pub const BUHID_LETTER_KA : CodePoint = CodePoint::from(5955u32);
    pub const BUHID_LETTER_GA : CodePoint = CodePoint::from(5956u32);
    pub const BUHID_LETTER_NGA : CodePoint = CodePoint::from(5957u32);
    pub const BUHID_LETTER_TA : CodePoint = CodePoint::from(5958u32);
    pub const BUHID_LETTER_DA : CodePoint = CodePoint::from(5959u32);
    pub const BUHID_LETTER_NA : CodePoint = CodePoint::from(5960u32);
    pub const BUHID_LETTER_PA : CodePoint = CodePoint::from(5961u32);
    pub const BUHID_LETTER_BA : CodePoint = CodePoint::from(5962u32);
    pub const BUHID_LETTER_MA : CodePoint = CodePoint::from(5963u32);
    pub const BUHID_LETTER_YA : CodePoint = CodePoint::from(5964u32);
    pub const BUHID_LETTER_RA : CodePoint = CodePoint::from(5965u32);
    pub const BUHID_LETTER_LA : CodePoint = CodePoint::from(5966u32);
    pub const BUHID_LETTER_WA : CodePoint = CodePoint::from(5967u32);
    pub const BUHID_LETTER_SA : CodePoint = CodePoint::from(5968u32);
    pub const BUHID_LETTER_HA : CodePoint = CodePoint::from(5969u32);
    pub const BUHID_VOWEL_SIGN_I : CodePoint = CodePoint::from(5970u32);
    pub const BUHID_VOWEL_SIGN_U : CodePoint = CodePoint::from(5971u32);
    pub const TAGBANWA_LETTER_A : CodePoint = CodePoint::from(5984u32);
    pub const TAGBANWA_LETTER_I : CodePoint = CodePoint::from(5985u32);
    pub const TAGBANWA_LETTER_U : CodePoint = CodePoint::from(5986u32);
    pub const TAGBANWA_LETTER_KA : CodePoint = CodePoint::from(5987u32);
    pub const TAGBANWA_LETTER_GA : CodePoint = CodePoint::from(5988u32);
    pub const TAGBANWA_LETTER_NGA : CodePoint = CodePoint::from(5989u32);
    pub const TAGBANWA_LETTER_TA : CodePoint = CodePoint::from(5990u32);
    pub const TAGBANWA_LETTER_DA : CodePoint = CodePoint::from(5991u32);
    pub const TAGBANWA_LETTER_NA : CodePoint = CodePoint::from(5992u32);
    pub const TAGBANWA_LETTER_PA : CodePoint = CodePoint::from(5993u32);
    pub const TAGBANWA_LETTER_BA : CodePoint = CodePoint::from(5994u32);
    pub const TAGBANWA_LETTER_MA : CodePoint = CodePoint::from(5995u32);
    pub const TAGBANWA_LETTER_YA : CodePoint = CodePoint::from(5996u32);
    pub const TAGBANWA_LETTER_LA : CodePoint = CodePoint::from(5998u32);
    pub const TAGBANWA_LETTER_WA : CodePoint = CodePoint::from(5999u32);
    pub const TAGBANWA_LETTER_SA : CodePoint = CodePoint::from(6000u32);
    pub const TAGBANWA_VOWEL_SIGN_I : CodePoint = CodePoint::from(6002u32);
    pub const TAGBANWA_VOWEL_SIGN_U : CodePoint = CodePoint::from(6003u32);
    pub const KHMER_LETTER_KA : CodePoint = CodePoint::from(6016u32);
    pub const KHMER_LETTER_KHA : CodePoint = CodePoint::from(6017u32);
    pub const KHMER_LETTER_KO : CodePoint = CodePoint::from(6018u32);
    pub const KHMER_LETTER_KHO : CodePoint = CodePoint::from(6019u32);
    pub const KHMER_LETTER_NGO : CodePoint = CodePoint::from(6020u32);
    pub const KHMER_LETTER_CA : CodePoint = CodePoint::from(6021u32);
    pub const KHMER_LETTER_CHA : CodePoint = CodePoint::from(6022u32);
    pub const KHMER_LETTER_CO : CodePoint = CodePoint::from(6023u32);
    pub const KHMER_LETTER_CHO : CodePoint = CodePoint::from(6024u32);
    pub const KHMER_LETTER_NYO : CodePoint = CodePoint::from(6025u32);
    pub const KHMER_LETTER_DA : CodePoint = CodePoint::from(6026u32);
    pub const KHMER_LETTER_TTHA : CodePoint = CodePoint::from(6027u32);
    pub const KHMER_LETTER_DO : CodePoint = CodePoint::from(6028u32);
    pub const KHMER_LETTER_TTHO : CodePoint = CodePoint::from(6029u32);
    pub const KHMER_LETTER_NNO : CodePoint = CodePoint::from(6030u32);
    pub const KHMER_LETTER_TA : CodePoint = CodePoint::from(6031u32);
    pub const KHMER_LETTER_THA : CodePoint = CodePoint::from(6032u32);
    pub const KHMER_LETTER_TO : CodePoint = CodePoint::from(6033u32);
    pub const KHMER_LETTER_THO : CodePoint = CodePoint::from(6034u32);
    pub const KHMER_LETTER_NO : CodePoint = CodePoint::from(6035u32);
    pub const KHMER_LETTER_BA : CodePoint = CodePoint::from(6036u32);
    pub const KHMER_LETTER_PHA : CodePoint = CodePoint::from(6037u32);
    pub const KHMER_LETTER_PO : CodePoint = CodePoint::from(6038u32);
    pub const KHMER_LETTER_PHO : CodePoint = CodePoint::from(6039u32);
    pub const KHMER_LETTER_MO : CodePoint = CodePoint::from(6040u32);
    pub const KHMER_LETTER_YO : CodePoint = CodePoint::from(6041u32);
    pub const KHMER_LETTER_RO : CodePoint = CodePoint::from(6042u32);
    pub const KHMER_LETTER_LO : CodePoint = CodePoint::from(6043u32);
    pub const KHMER_LETTER_VO : CodePoint = CodePoint::from(6044u32);
    pub const KHMER_LETTER_SHA : CodePoint = CodePoint::from(6045u32);
    pub const KHMER_LETTER_SSO : CodePoint = CodePoint::from(6046u32);
    pub const KHMER_LETTER_SA : CodePoint = CodePoint::from(6047u32);
    pub const KHMER_LETTER_HA : CodePoint = CodePoint::from(6048u32);
    pub const KHMER_LETTER_LA : CodePoint = CodePoint::from(6049u32);
    pub const KHMER_LETTER_QA : CodePoint = CodePoint::from(6050u32);
    pub const KHMER_INDEPENDENT_VOWEL_QAQ : CodePoint = CodePoint::from(6051u32);
    pub const KHMER_INDEPENDENT_VOWEL_QAA : CodePoint = CodePoint::from(6052u32);
    pub const KHMER_INDEPENDENT_VOWEL_QI : CodePoint = CodePoint::from(6053u32);
    pub const KHMER_INDEPENDENT_VOWEL_QII : CodePoint = CodePoint::from(6054u32);
    pub const KHMER_INDEPENDENT_VOWEL_QU : CodePoint = CodePoint::from(6055u32);
    pub const KHMER_INDEPENDENT_VOWEL_QUK : CodePoint = CodePoint::from(6056u32);
    pub const KHMER_INDEPENDENT_VOWEL_QUU : CodePoint = CodePoint::from(6057u32);
    pub const KHMER_INDEPENDENT_VOWEL_QUUV : CodePoint = CodePoint::from(6058u32);
    pub const KHMER_INDEPENDENT_VOWEL_RY : CodePoint = CodePoint::from(6059u32);
    pub const KHMER_INDEPENDENT_VOWEL_RYY : CodePoint = CodePoint::from(6060u32);
    pub const KHMER_INDEPENDENT_VOWEL_LY : CodePoint = CodePoint::from(6061u32);
    pub const KHMER_INDEPENDENT_VOWEL_LYY : CodePoint = CodePoint::from(6062u32);
    pub const KHMER_INDEPENDENT_VOWEL_QE : CodePoint = CodePoint::from(6063u32);
    pub const KHMER_INDEPENDENT_VOWEL_QAI : CodePoint = CodePoint::from(6064u32);
    pub const KHMER_INDEPENDENT_VOWEL_QOO_TYPE_ONE : CodePoint = CodePoint::from(6065u32);
    pub const KHMER_INDEPENDENT_VOWEL_QOO_TYPE_TWO : CodePoint = CodePoint::from(6066u32);
    pub const KHMER_INDEPENDENT_VOWEL_QAU : CodePoint = CodePoint::from(6067u32);
    pub const KHMER_VOWEL_INHERENT_AQ : CodePoint = CodePoint::from(6068u32);
    pub const KHMER_VOWEL_INHERENT_AA : CodePoint = CodePoint::from(6069u32);
    pub const KHMER_VOWEL_SIGN_AA : CodePoint = CodePoint::from(6070u32);
    pub const KHMER_VOWEL_SIGN_I : CodePoint = CodePoint::from(6071u32);
    pub const KHMER_VOWEL_SIGN_II : CodePoint = CodePoint::from(6072u32);
    pub const KHMER_VOWEL_SIGN_Y : CodePoint = CodePoint::from(6073u32);
    pub const KHMER_VOWEL_SIGN_YY : CodePoint = CodePoint::from(6074u32);
    pub const KHMER_VOWEL_SIGN_U : CodePoint = CodePoint::from(6075u32);
    pub const KHMER_VOWEL_SIGN_UU : CodePoint = CodePoint::from(6076u32);
    pub const KHMER_VOWEL_SIGN_UA : CodePoint = CodePoint::from(6077u32);
    pub const KHMER_VOWEL_SIGN_OE : CodePoint = CodePoint::from(6078u32);
    pub const KHMER_VOWEL_SIGN_YA : CodePoint = CodePoint::from(6079u32);
    pub const KHMER_VOWEL_SIGN_IE : CodePoint = CodePoint::from(6080u32);
    pub const KHMER_VOWEL_SIGN_E : CodePoint = CodePoint::from(6081u32);
    pub const KHMER_VOWEL_SIGN_AE : CodePoint = CodePoint::from(6082u32);
    pub const KHMER_VOWEL_SIGN_AI : CodePoint = CodePoint::from(6083u32);
    pub const KHMER_VOWEL_SIGN_OO : CodePoint = CodePoint::from(6084u32);
    pub const KHMER_VOWEL_SIGN_AU : CodePoint = CodePoint::from(6085u32);
    pub const KHMER_SIGN_NIKAHIT : CodePoint = CodePoint::from(6086u32);
    pub const KHMER_SIGN_REAHMUK : CodePoint = CodePoint::from(6087u32);
    pub const KHMER_SIGN_YUUKALEAPINTU : CodePoint = CodePoint::from(6088u32);
    pub const KHMER_SIGN_MUUSIKATOAN : CodePoint = CodePoint::from(6089u32);
    pub const KHMER_SIGN_TRIISAP : CodePoint = CodePoint::from(6090u32);
    pub const KHMER_SIGN_BANTOC : CodePoint = CodePoint::from(6091u32);
    pub const KHMER_SIGN_ROBAT : CodePoint = CodePoint::from(6092u32);
    pub const KHMER_SIGN_TOANDAKHIAT : CodePoint = CodePoint::from(6093u32);
    pub const KHMER_SIGN_KAKABAT : CodePoint = CodePoint::from(6094u32);
    pub const KHMER_SIGN_AHSDA : CodePoint = CodePoint::from(6095u32);
    pub const KHMER_SIGN_SAMYOK_SANNYA : CodePoint = CodePoint::from(6096u32);
    pub const KHMER_SIGN_VIRIAM : CodePoint = CodePoint::from(6097u32);
    pub const KHMER_SIGN_COENG : CodePoint = CodePoint::from(6098u32);
    pub const KHMER_SIGN_BATHAMASAT : CodePoint = CodePoint::from(6099u32);
    pub const KHMER_SIGN_KHAN : CodePoint = CodePoint::from(6100u32);
    pub const KHMER_SIGN_BARIYOOSAN : CodePoint = CodePoint::from(6101u32);
    pub const KHMER_SIGN_CAMNUC_PII_KUUH : CodePoint = CodePoint::from(6102u32);
    pub const KHMER_SIGN_LEK_TOO : CodePoint = CodePoint::from(6103u32);
    pub const KHMER_SIGN_BEYYAL : CodePoint = CodePoint::from(6104u32);
    pub const KHMER_SIGN_PHNAEK_MUAN : CodePoint = CodePoint::from(6105u32);
    pub const KHMER_SIGN_KOOMUUT : CodePoint = CodePoint::from(6106u32);
    pub const KHMER_CURRENCY_SYMBOL_RIEL : CodePoint = CodePoint::from(6107u32);
    pub const KHMER_SIGN_AVAKRAHASANYA : CodePoint = CodePoint::from(6108u32);
    pub const KHMER_SIGN_ATTHACAN : CodePoint = CodePoint::from(6109u32);
    pub const KHMER_DIGIT_ZERO : CodePoint = CodePoint::from(6112u32);
    pub const KHMER_DIGIT_ONE : CodePoint = CodePoint::from(6113u32);
    pub const KHMER_DIGIT_TWO : CodePoint = CodePoint::from(6114u32);
    pub const KHMER_DIGIT_THREE : CodePoint = CodePoint::from(6115u32);
    pub const KHMER_DIGIT_FOUR : CodePoint = CodePoint::from(6116u32);
    pub const KHMER_DIGIT_FIVE : CodePoint = CodePoint::from(6117u32);
    pub const KHMER_DIGIT_SIX : CodePoint = CodePoint::from(6118u32);
    pub const KHMER_DIGIT_SEVEN : CodePoint = CodePoint::from(6119u32);
    pub const KHMER_DIGIT_EIGHT : CodePoint = CodePoint::from(6120u32);
    pub const KHMER_DIGIT_NINE : CodePoint = CodePoint::from(6121u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_SON : CodePoint = CodePoint::from(6128u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_MUOY : CodePoint = CodePoint::from(6129u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_PII : CodePoint = CodePoint::from(6130u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_BEI : CodePoint = CodePoint::from(6131u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_BUON : CodePoint = CodePoint::from(6132u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_PRAM : CodePoint = CodePoint::from(6133u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_PRAM_MUOY : CodePoint = CodePoint::from(6134u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_PRAM_PII : CodePoint = CodePoint::from(6135u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_PRAM_BEI : CodePoint = CodePoint::from(6136u32);
    pub const KHMER_SYMBOL_LEK_ATTAK_PRAM_BUON : CodePoint = CodePoint::from(6137u32);
    pub const MONGOLIAN_BIRGA : CodePoint = CodePoint::from(6144u32);
    pub const MONGOLIAN_ELLIPSIS : CodePoint = CodePoint::from(6145u32);
    pub const MONGOLIAN_COMMA : CodePoint = CodePoint::from(6146u32);
    pub const MONGOLIAN_FULL_STOP : CodePoint = CodePoint::from(6147u32);
    pub const MONGOLIAN_COLON : CodePoint = CodePoint::from(6148u32);
    pub const MONGOLIAN_FOUR_DOTS : CodePoint = CodePoint::from(6149u32);
    pub const MONGOLIAN_TODO_SOFT_HYPHEN : CodePoint = CodePoint::from(6150u32);
    pub const MONGOLIAN_SIBE_SYLLABLE_BOUNDARY_MARKER : CodePoint = CodePoint::from(6151u32);
    pub const MONGOLIAN_MANCHU_COMMA : CodePoint = CodePoint::from(6152u32);
    pub const MONGOLIAN_MANCHU_FULL_STOP : CodePoint = CodePoint::from(6153u32);
    pub const MONGOLIAN_NIRUGU : CodePoint = CodePoint::from(6154u32);
    pub const MONGOLIAN_FREE_VARIATION_SELECTOR_ONE : CodePoint = CodePoint::from(6155u32);
    pub const MONGOLIAN_FREE_VARIATION_SELECTOR_TWO : CodePoint = CodePoint::from(6156u32);
    pub const MONGOLIAN_FREE_VARIATION_SELECTOR_THREE : CodePoint = CodePoint::from(6157u32);
    pub const MONGOLIAN_VOWEL_SEPARATOR : CodePoint = CodePoint::from(6158u32);
    pub const MONGOLIAN_DIGIT_ZERO : CodePoint = CodePoint::from(6160u32);
    pub const MONGOLIAN_DIGIT_ONE : CodePoint = CodePoint::from(6161u32);
    pub const MONGOLIAN_DIGIT_TWO : CodePoint = CodePoint::from(6162u32);
    pub const MONGOLIAN_DIGIT_THREE : CodePoint = CodePoint::from(6163u32);
    pub const MONGOLIAN_DIGIT_FOUR : CodePoint = CodePoint::from(6164u32);
    pub const MONGOLIAN_DIGIT_FIVE : CodePoint = CodePoint::from(6165u32);
    pub const MONGOLIAN_DIGIT_SIX : CodePoint = CodePoint::from(6166u32);
    pub const MONGOLIAN_DIGIT_SEVEN : CodePoint = CodePoint::from(6167u32);
    pub const MONGOLIAN_DIGIT_EIGHT : CodePoint = CodePoint::from(6168u32);
    pub const MONGOLIAN_DIGIT_NINE : CodePoint = CodePoint::from(6169u32);
    pub const MONGOLIAN_LETTER_A : CodePoint = CodePoint::from(6176u32);
    pub const MONGOLIAN_LETTER_E : CodePoint = CodePoint::from(6177u32);
    pub const MONGOLIAN_LETTER_I : CodePoint = CodePoint::from(6178u32);
    pub const MONGOLIAN_LETTER_O : CodePoint = CodePoint::from(6179u32);
    pub const MONGOLIAN_LETTER_U : CodePoint = CodePoint::from(6180u32);
    pub const MONGOLIAN_LETTER_OE : CodePoint = CodePoint::from(6181u32);
    pub const MONGOLIAN_LETTER_UE : CodePoint = CodePoint::from(6182u32);
    pub const MONGOLIAN_LETTER_EE : CodePoint = CodePoint::from(6183u32);
    pub const MONGOLIAN_LETTER_NA : CodePoint = CodePoint::from(6184u32);
    pub const MONGOLIAN_LETTER_ANG : CodePoint = CodePoint::from(6185u32);
    pub const MONGOLIAN_LETTER_BA : CodePoint = CodePoint::from(6186u32);
    pub const MONGOLIAN_LETTER_PA : CodePoint = CodePoint::from(6187u32);
    pub const MONGOLIAN_LETTER_QA : CodePoint = CodePoint::from(6188u32);
    pub const MONGOLIAN_LETTER_GA : CodePoint = CodePoint::from(6189u32);
    pub const MONGOLIAN_LETTER_MA : CodePoint = CodePoint::from(6190u32);
    pub const MONGOLIAN_LETTER_LA : CodePoint = CodePoint::from(6191u32);
    pub const MONGOLIAN_LETTER_SA : CodePoint = CodePoint::from(6192u32);
    pub const MONGOLIAN_LETTER_SHA : CodePoint = CodePoint::from(6193u32);
    pub const MONGOLIAN_LETTER_TA : CodePoint = CodePoint::from(6194u32);
    pub const MONGOLIAN_LETTER_DA : CodePoint = CodePoint::from(6195u32);
    pub const MONGOLIAN_LETTER_CHA : CodePoint = CodePoint::from(6196u32);
    pub const MONGOLIAN_LETTER_JA : CodePoint = CodePoint::from(6197u32);
    pub const MONGOLIAN_LETTER_YA : CodePoint = CodePoint::from(6198u32);
    pub const MONGOLIAN_LETTER_RA : CodePoint = CodePoint::from(6199u32);
    pub const MONGOLIAN_LETTER_WA : CodePoint = CodePoint::from(6200u32);
    pub const MONGOLIAN_LETTER_FA : CodePoint = CodePoint::from(6201u32);
    pub const MONGOLIAN_LETTER_KA : CodePoint = CodePoint::from(6202u32);
    pub const MONGOLIAN_LETTER_KHA : CodePoint = CodePoint::from(6203u32);
    pub const MONGOLIAN_LETTER_TSA : CodePoint = CodePoint::from(6204u32);
    pub const MONGOLIAN_LETTER_ZA : CodePoint = CodePoint::from(6205u32);
    pub const MONGOLIAN_LETTER_HAA : CodePoint = CodePoint::from(6206u32);
    pub const MONGOLIAN_LETTER_ZRA : CodePoint = CodePoint::from(6207u32);
    pub const MONGOLIAN_LETTER_LHA : CodePoint = CodePoint::from(6208u32);
    pub const MONGOLIAN_LETTER_ZHI : CodePoint = CodePoint::from(6209u32);
    pub const MONGOLIAN_LETTER_CHI : CodePoint = CodePoint::from(6210u32);
    pub const MONGOLIAN_LETTER_TODO_LONG_VOWEL_SIGN : CodePoint = CodePoint::from(6211u32);
    pub const MONGOLIAN_LETTER_TODO_E : CodePoint = CodePoint::from(6212u32);
    pub const MONGOLIAN_LETTER_TODO_I : CodePoint = CodePoint::from(6213u32);
    pub const MONGOLIAN_LETTER_TODO_O : CodePoint = CodePoint::from(6214u32);
    pub const MONGOLIAN_LETTER_TODO_U : CodePoint = CodePoint::from(6215u32);
    pub const MONGOLIAN_LETTER_TODO_OE : CodePoint = CodePoint::from(6216u32);
    pub const MONGOLIAN_LETTER_TODO_UE : CodePoint = CodePoint::from(6217u32);
    pub const MONGOLIAN_LETTER_TODO_ANG : CodePoint = CodePoint::from(6218u32);
    pub const MONGOLIAN_LETTER_TODO_BA : CodePoint = CodePoint::from(6219u32);
    pub const MONGOLIAN_LETTER_TODO_PA : CodePoint = CodePoint::from(6220u32);
    pub const MONGOLIAN_LETTER_TODO_QA : CodePoint = CodePoint::from(6221u32);
    pub const MONGOLIAN_LETTER_TODO_GA : CodePoint = CodePoint::from(6222u32);
    pub const MONGOLIAN_LETTER_TODO_MA : CodePoint = CodePoint::from(6223u32);
    pub const MONGOLIAN_LETTER_TODO_TA : CodePoint = CodePoint::from(6224u32);
    pub const MONGOLIAN_LETTER_TODO_DA : CodePoint = CodePoint::from(6225u32);
    pub const MONGOLIAN_LETTER_TODO_CHA : CodePoint = CodePoint::from(6226u32);
    pub const MONGOLIAN_LETTER_TODO_JA : CodePoint = CodePoint::from(6227u32);
    pub const MONGOLIAN_LETTER_TODO_TSA : CodePoint = CodePoint::from(6228u32);
    pub const MONGOLIAN_LETTER_TODO_YA : CodePoint = CodePoint::from(6229u32);
    pub const MONGOLIAN_LETTER_TODO_WA : CodePoint = CodePoint::from(6230u32);
    pub const MONGOLIAN_LETTER_TODO_KA : CodePoint = CodePoint::from(6231u32);
    pub const MONGOLIAN_LETTER_TODO_GAA : CodePoint = CodePoint::from(6232u32);
    pub const MONGOLIAN_LETTER_TODO_HAA : CodePoint = CodePoint::from(6233u32);
    pub const MONGOLIAN_LETTER_TODO_JIA : CodePoint = CodePoint::from(6234u32);
    pub const MONGOLIAN_LETTER_TODO_NIA : CodePoint = CodePoint::from(6235u32);
    pub const MONGOLIAN_LETTER_TODO_DZA : CodePoint = CodePoint::from(6236u32);
    pub const MONGOLIAN_LETTER_SIBE_E : CodePoint = CodePoint::from(6237u32);
    pub const MONGOLIAN_LETTER_SIBE_I : CodePoint = CodePoint::from(6238u32);
    pub const MONGOLIAN_LETTER_SIBE_IY : CodePoint = CodePoint::from(6239u32);
    pub const MONGOLIAN_LETTER_SIBE_UE : CodePoint = CodePoint::from(6240u32);
    pub const MONGOLIAN_LETTER_SIBE_U : CodePoint = CodePoint::from(6241u32);
    pub const MONGOLIAN_LETTER_SIBE_ANG : CodePoint = CodePoint::from(6242u32);
    pub const MONGOLIAN_LETTER_SIBE_KA : CodePoint = CodePoint::from(6243u32);
    pub const MONGOLIAN_LETTER_SIBE_GA : CodePoint = CodePoint::from(6244u32);
    pub const MONGOLIAN_LETTER_SIBE_HA : CodePoint = CodePoint::from(6245u32);
    pub const MONGOLIAN_LETTER_SIBE_PA : CodePoint = CodePoint::from(6246u32);
    pub const MONGOLIAN_LETTER_SIBE_SHA : CodePoint = CodePoint::from(6247u32);
    pub const MONGOLIAN_LETTER_SIBE_TA : CodePoint = CodePoint::from(6248u32);
    pub const MONGOLIAN_LETTER_SIBE_DA : CodePoint = CodePoint::from(6249u32);
    pub const MONGOLIAN_LETTER_SIBE_JA : CodePoint = CodePoint::from(6250u32);
    pub const MONGOLIAN_LETTER_SIBE_FA : CodePoint = CodePoint::from(6251u32);
    pub const MONGOLIAN_LETTER_SIBE_GAA : CodePoint = CodePoint::from(6252u32);
    pub const MONGOLIAN_LETTER_SIBE_HAA : CodePoint = CodePoint::from(6253u32);
    pub const MONGOLIAN_LETTER_SIBE_TSA : CodePoint = CodePoint::from(6254u32);
    pub const MONGOLIAN_LETTER_SIBE_ZA : CodePoint = CodePoint::from(6255u32);
    pub const MONGOLIAN_LETTER_SIBE_RAA : CodePoint = CodePoint::from(6256u32);
    pub const MONGOLIAN_LETTER_SIBE_CHA : CodePoint = CodePoint::from(6257u32);
    pub const MONGOLIAN_LETTER_SIBE_ZHA : CodePoint = CodePoint::from(6258u32);
    pub const MONGOLIAN_LETTER_MANCHU_I : CodePoint = CodePoint::from(6259u32);
    pub const MONGOLIAN_LETTER_MANCHU_KA : CodePoint = CodePoint::from(6260u32);
    pub const MONGOLIAN_LETTER_MANCHU_RA : CodePoint = CodePoint::from(6261u32);
    pub const MONGOLIAN_LETTER_MANCHU_FA : CodePoint = CodePoint::from(6262u32);
    pub const MONGOLIAN_LETTER_MANCHU_ZHA : CodePoint = CodePoint::from(6263u32);
    pub const MONGOLIAN_LETTER_CHA_WITH_TWO_DOTS : CodePoint = CodePoint::from(6264u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_ANUSVARA_ONE : CodePoint = CodePoint::from(6272u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_VISARGA_ONE : CodePoint = CodePoint::from(6273u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_DAMARU : CodePoint = CodePoint::from(6274u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_UBADAMA : CodePoint = CodePoint::from(6275u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_INVERTED_UBADAMA : CodePoint = CodePoint::from(6276u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_BALUDA : CodePoint = CodePoint::from(6277u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_THREE_BALUDA : CodePoint = CodePoint::from(6278u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_A : CodePoint = CodePoint::from(6279u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_I : CodePoint = CodePoint::from(6280u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_KA : CodePoint = CodePoint::from(6281u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_NGA : CodePoint = CodePoint::from(6282u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_CA : CodePoint = CodePoint::from(6283u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_TTA : CodePoint = CodePoint::from(6284u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_TTHA : CodePoint = CodePoint::from(6285u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_DDA : CodePoint = CodePoint::from(6286u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_NNA : CodePoint = CodePoint::from(6287u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_TA : CodePoint = CodePoint::from(6288u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_DA : CodePoint = CodePoint::from(6289u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_PA : CodePoint = CodePoint::from(6290u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_PHA : CodePoint = CodePoint::from(6291u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_SSA : CodePoint = CodePoint::from(6292u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_ZHA : CodePoint = CodePoint::from(6293u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_ZA : CodePoint = CodePoint::from(6294u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_AH : CodePoint = CodePoint::from(6295u32);
    pub const MONGOLIAN_LETTER_TODO_ALI_GALI_TA : CodePoint = CodePoint::from(6296u32);
    pub const MONGOLIAN_LETTER_TODO_ALI_GALI_ZHA : CodePoint = CodePoint::from(6297u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_GHA : CodePoint = CodePoint::from(6298u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_NGA : CodePoint = CodePoint::from(6299u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_CA : CodePoint = CodePoint::from(6300u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_JHA : CodePoint = CodePoint::from(6301u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_TTA : CodePoint = CodePoint::from(6302u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_DDHA : CodePoint = CodePoint::from(6303u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_TA : CodePoint = CodePoint::from(6304u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_DHA : CodePoint = CodePoint::from(6305u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_SSA : CodePoint = CodePoint::from(6306u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_CYA : CodePoint = CodePoint::from(6307u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZHA : CodePoint = CodePoint::from(6308u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZA : CodePoint = CodePoint::from(6309u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_HALF_U : CodePoint = CodePoint::from(6310u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_HALF_YA : CodePoint = CodePoint::from(6311u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_BHA : CodePoint = CodePoint::from(6312u32);
    pub const MONGOLIAN_LETTER_ALI_GALI_DAGALGA : CodePoint = CodePoint::from(6313u32);
    pub const MONGOLIAN_LETTER_MANCHU_ALI_GALI_LHA : CodePoint = CodePoint::from(6314u32);
    pub const CANADIAN_SYLLABICS_OY : CodePoint = CodePoint::from(6320u32);
    pub const CANADIAN_SYLLABICS_AY : CodePoint = CodePoint::from(6321u32);
    pub const CANADIAN_SYLLABICS_AAY : CodePoint = CodePoint::from(6322u32);
    pub const CANADIAN_SYLLABICS_WAY : CodePoint = CodePoint::from(6323u32);
    pub const CANADIAN_SYLLABICS_POY : CodePoint = CodePoint::from(6324u32);
    pub const CANADIAN_SYLLABICS_PAY : CodePoint = CodePoint::from(6325u32);
    pub const CANADIAN_SYLLABICS_PWOY : CodePoint = CodePoint::from(6326u32);
    pub const CANADIAN_SYLLABICS_TAY : CodePoint = CodePoint::from(6327u32);
    pub const CANADIAN_SYLLABICS_KAY : CodePoint = CodePoint::from(6328u32);
    pub const CANADIAN_SYLLABICS_KWAY : CodePoint = CodePoint::from(6329u32);
    pub const CANADIAN_SYLLABICS_MAY : CodePoint = CodePoint::from(6330u32);
    pub const CANADIAN_SYLLABICS_NOY : CodePoint = CodePoint::from(6331u32);
    pub const CANADIAN_SYLLABICS_NAY : CodePoint = CodePoint::from(6332u32);
    pub const CANADIAN_SYLLABICS_LAY : CodePoint = CodePoint::from(6333u32);
    pub const CANADIAN_SYLLABICS_SOY : CodePoint = CodePoint::from(6334u32);
    pub const CANADIAN_SYLLABICS_SAY : CodePoint = CodePoint::from(6335u32);
    pub const CANADIAN_SYLLABICS_SHOY : CodePoint = CodePoint::from(6336u32);
    pub const CANADIAN_SYLLABICS_SHAY : CodePoint = CodePoint::from(6337u32);
    pub const CANADIAN_SYLLABICS_SHWOY : CodePoint = CodePoint::from(6338u32);
    pub const CANADIAN_SYLLABICS_YOY : CodePoint = CodePoint::from(6339u32);
    pub const CANADIAN_SYLLABICS_YAY : CodePoint = CodePoint::from(6340u32);
    pub const CANADIAN_SYLLABICS_RAY : CodePoint = CodePoint::from(6341u32);
    pub const CANADIAN_SYLLABICS_NWI : CodePoint = CodePoint::from(6342u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_NWI : CodePoint = CodePoint::from(6343u32);
    pub const CANADIAN_SYLLABICS_NWII : CodePoint = CodePoint::from(6344u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_NWII : CodePoint = CodePoint::from(6345u32);
    pub const CANADIAN_SYLLABICS_NWO : CodePoint = CodePoint::from(6346u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_NWO : CodePoint = CodePoint::from(6347u32);
    pub const CANADIAN_SYLLABICS_NWOO : CodePoint = CodePoint::from(6348u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_NWOO : CodePoint = CodePoint::from(6349u32);
    pub const CANADIAN_SYLLABICS_RWEE : CodePoint = CodePoint::from(6350u32);
    pub const CANADIAN_SYLLABICS_RWI : CodePoint = CodePoint::from(6351u32);
    pub const CANADIAN_SYLLABICS_RWII : CodePoint = CodePoint::from(6352u32);
    pub const CANADIAN_SYLLABICS_RWO : CodePoint = CodePoint::from(6353u32);
    pub const CANADIAN_SYLLABICS_RWOO : CodePoint = CodePoint::from(6354u32);
    pub const CANADIAN_SYLLABICS_RWA : CodePoint = CodePoint::from(6355u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_P : CodePoint = CodePoint::from(6356u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_T : CodePoint = CodePoint::from(6357u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_K : CodePoint = CodePoint::from(6358u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_C : CodePoint = CodePoint::from(6359u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_M : CodePoint = CodePoint::from(6360u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_N : CodePoint = CodePoint::from(6361u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_S : CodePoint = CodePoint::from(6362u32);
    pub const CANADIAN_SYLLABICS_OJIBWAY_SH : CodePoint = CodePoint::from(6363u32);
    pub const CANADIAN_SYLLABICS_EASTERN_W : CodePoint = CodePoint::from(6364u32);
    pub const CANADIAN_SYLLABICS_WESTERN_W : CodePoint = CodePoint::from(6365u32);
    pub const CANADIAN_SYLLABICS_FINAL_SMALL_RING : CodePoint = CodePoint::from(6366u32);
    pub const CANADIAN_SYLLABICS_FINAL_RAISED_DOT : CodePoint = CodePoint::from(6367u32);
    pub const CANADIAN_SYLLABICS_R_CREE_RWE : CodePoint = CodePoint::from(6368u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LOO : CodePoint = CodePoint::from(6369u32);
    pub const CANADIAN_SYLLABICS_WEST_CREE_LAA : CodePoint = CodePoint::from(6370u32);
    pub const CANADIAN_SYLLABICS_THWE : CodePoint = CodePoint::from(6371u32);
    pub const CANADIAN_SYLLABICS_THWA : CodePoint = CodePoint::from(6372u32);
    pub const CANADIAN_SYLLABICS_TTHWE : CodePoint = CodePoint::from(6373u32);
    pub const CANADIAN_SYLLABICS_TTHOO : CodePoint = CodePoint::from(6374u32);
    pub const CANADIAN_SYLLABICS_TTHAA : CodePoint = CodePoint::from(6375u32);
    pub const CANADIAN_SYLLABICS_TLHWE : CodePoint = CodePoint::from(6376u32);
    pub const CANADIAN_SYLLABICS_TLHOO : CodePoint = CodePoint::from(6377u32);
    pub const CANADIAN_SYLLABICS_SAYISI_SHWE : CodePoint = CodePoint::from(6378u32);
    pub const CANADIAN_SYLLABICS_SAYISI_SHOO : CodePoint = CodePoint::from(6379u32);
    pub const CANADIAN_SYLLABICS_SAYISI_HOO : CodePoint = CodePoint::from(6380u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GWU : CodePoint = CodePoint::from(6381u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DENE_GEE : CodePoint = CodePoint::from(6382u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GAA : CodePoint = CodePoint::from(6383u32);
    pub const CANADIAN_SYLLABICS_CARRIER_GWA : CodePoint = CodePoint::from(6384u32);
    pub const CANADIAN_SYLLABICS_SAYISI_JUU : CodePoint = CodePoint::from(6385u32);
    pub const CANADIAN_SYLLABICS_CARRIER_JWA : CodePoint = CodePoint::from(6386u32);
    pub const CANADIAN_SYLLABICS_BEAVER_DENE_L : CodePoint = CodePoint::from(6387u32);
    pub const CANADIAN_SYLLABICS_BEAVER_DENE_R : CodePoint = CodePoint::from(6388u32);
    pub const CANADIAN_SYLLABICS_CARRIER_DENTAL_S : CodePoint = CodePoint::from(6389u32);
    pub const LIMBU_VOWEL_CARRIER_LETTER : CodePoint = CodePoint::from(6400u32);
    pub const LIMBU_LETTER_KA : CodePoint = CodePoint::from(6401u32);
    pub const LIMBU_LETTER_KHA : CodePoint = CodePoint::from(6402u32);
    pub const LIMBU_LETTER_GA : CodePoint = CodePoint::from(6403u32);
    pub const LIMBU_LETTER_GHA : CodePoint = CodePoint::from(6404u32);
    pub const LIMBU_LETTER_NGA : CodePoint = CodePoint::from(6405u32);
    pub const LIMBU_LETTER_CA : CodePoint = CodePoint::from(6406u32);
    pub const LIMBU_LETTER_CHA : CodePoint = CodePoint::from(6407u32);
    pub const LIMBU_LETTER_JA : CodePoint = CodePoint::from(6408u32);
    pub const LIMBU_LETTER_JHA : CodePoint = CodePoint::from(6409u32);
    pub const LIMBU_LETTER_YAN : CodePoint = CodePoint::from(6410u32);
    pub const LIMBU_LETTER_TA : CodePoint = CodePoint::from(6411u32);
    pub const LIMBU_LETTER_THA : CodePoint = CodePoint::from(6412u32);
    pub const LIMBU_LETTER_DA : CodePoint = CodePoint::from(6413u32);
    pub const LIMBU_LETTER_DHA : CodePoint = CodePoint::from(6414u32);
    pub const LIMBU_LETTER_NA : CodePoint = CodePoint::from(6415u32);
    pub const LIMBU_LETTER_PA : CodePoint = CodePoint::from(6416u32);
    pub const LIMBU_LETTER_PHA : CodePoint = CodePoint::from(6417u32);
    pub const LIMBU_LETTER_BA : CodePoint = CodePoint::from(6418u32);
    pub const LIMBU_LETTER_BHA : CodePoint = CodePoint::from(6419u32);
    pub const LIMBU_LETTER_MA : CodePoint = CodePoint::from(6420u32);
    pub const LIMBU_LETTER_YA : CodePoint = CodePoint::from(6421u32);
    pub const LIMBU_LETTER_RA : CodePoint = CodePoint::from(6422u32);
    pub const LIMBU_LETTER_LA : CodePoint = CodePoint::from(6423u32);
    pub const LIMBU_LETTER_WA : CodePoint = CodePoint::from(6424u32);
    pub const LIMBU_LETTER_SHA : CodePoint = CodePoint::from(6425u32);
    pub const LIMBU_LETTER_SSA : CodePoint = CodePoint::from(6426u32);
    pub const LIMBU_LETTER_SA : CodePoint = CodePoint::from(6427u32);
    pub const LIMBU_LETTER_HA : CodePoint = CodePoint::from(6428u32);
    pub const LIMBU_LETTER_GYAN : CodePoint = CodePoint::from(6429u32);
    pub const LIMBU_LETTER_TRA : CodePoint = CodePoint::from(6430u32);
    pub const LIMBU_VOWEL_SIGN_A : CodePoint = CodePoint::from(6432u32);
    pub const LIMBU_VOWEL_SIGN_I : CodePoint = CodePoint::from(6433u32);
    pub const LIMBU_VOWEL_SIGN_U : CodePoint = CodePoint::from(6434u32);
    pub const LIMBU_VOWEL_SIGN_EE : CodePoint = CodePoint::from(6435u32);
    pub const LIMBU_VOWEL_SIGN_AI : CodePoint = CodePoint::from(6436u32);
    pub const LIMBU_VOWEL_SIGN_OO : CodePoint = CodePoint::from(6437u32);
    pub const LIMBU_VOWEL_SIGN_AU : CodePoint = CodePoint::from(6438u32);
    pub const LIMBU_VOWEL_SIGN_E : CodePoint = CodePoint::from(6439u32);
    pub const LIMBU_VOWEL_SIGN_O : CodePoint = CodePoint::from(6440u32);
    pub const LIMBU_SUBJOINED_LETTER_YA : CodePoint = CodePoint::from(6441u32);
    pub const LIMBU_SUBJOINED_LETTER_RA : CodePoint = CodePoint::from(6442u32);
    pub const LIMBU_SUBJOINED_LETTER_WA : CodePoint = CodePoint::from(6443u32);
    pub const LIMBU_SMALL_LETTER_KA : CodePoint = CodePoint::from(6448u32);
    pub const LIMBU_SMALL_LETTER_NGA : CodePoint = CodePoint::from(6449u32);
    pub const LIMBU_SMALL_LETTER_ANUSVARA : CodePoint = CodePoint::from(6450u32);
    pub const LIMBU_SMALL_LETTER_TA : CodePoint = CodePoint::from(6451u32);
    pub const LIMBU_SMALL_LETTER_NA : CodePoint = CodePoint::from(6452u32);
    pub const LIMBU_SMALL_LETTER_PA : CodePoint = CodePoint::from(6453u32);
    pub const LIMBU_SMALL_LETTER_MA : CodePoint = CodePoint::from(6454u32);
    pub const LIMBU_SMALL_LETTER_RA : CodePoint = CodePoint::from(6455u32);
    pub const LIMBU_SMALL_LETTER_LA : CodePoint = CodePoint::from(6456u32);
    pub const LIMBU_SIGN_MUKPHRENG : CodePoint = CodePoint::from(6457u32);
    pub const LIMBU_SIGN_KEMPHRENG : CodePoint = CodePoint::from(6458u32);
    pub const LIMBU_SIGN_SA_I : CodePoint = CodePoint::from(6459u32);
    pub const LIMBU_SIGN_LOO : CodePoint = CodePoint::from(6464u32);
    pub const LIMBU_EXCLAMATION_MARK : CodePoint = CodePoint::from(6468u32);
    pub const LIMBU_QUESTION_MARK : CodePoint = CodePoint::from(6469u32);
    pub const LIMBU_DIGIT_ZERO : CodePoint = CodePoint::from(6470u32);
    pub const LIMBU_DIGIT_ONE : CodePoint = CodePoint::from(6471u32);
    pub const LIMBU_DIGIT_TWO : CodePoint = CodePoint::from(6472u32);
    pub const LIMBU_DIGIT_THREE : CodePoint = CodePoint::from(6473u32);
    pub const LIMBU_DIGIT_FOUR : CodePoint = CodePoint::from(6474u32);
    pub const LIMBU_DIGIT_FIVE : CodePoint = CodePoint::from(6475u32);
    pub const LIMBU_DIGIT_SIX : CodePoint = CodePoint::from(6476u32);
    pub const LIMBU_DIGIT_SEVEN : CodePoint = CodePoint::from(6477u32);
    pub const LIMBU_DIGIT_EIGHT : CodePoint = CodePoint::from(6478u32);
    pub const LIMBU_DIGIT_NINE : CodePoint = CodePoint::from(6479u32);
    pub const TAI_LE_LETTER_KA : CodePoint = CodePoint::from(6480u32);
    pub const TAI_LE_LETTER_XA : CodePoint = CodePoint::from(6481u32);
    pub const TAI_LE_LETTER_NGA : CodePoint = CodePoint::from(6482u32);
    pub const TAI_LE_LETTER_TSA : CodePoint = CodePoint::from(6483u32);
    pub const TAI_LE_LETTER_SA : CodePoint = CodePoint::from(6484u32);
    pub const TAI_LE_LETTER_YA : CodePoint = CodePoint::from(6485u32);
    pub const TAI_LE_LETTER_TA : CodePoint = CodePoint::from(6486u32);
    pub const TAI_LE_LETTER_THA : CodePoint = CodePoint::from(6487u32);
    pub const TAI_LE_LETTER_LA : CodePoint = CodePoint::from(6488u32);
    pub const TAI_LE_LETTER_PA : CodePoint = CodePoint::from(6489u32);
    pub const TAI_LE_LETTER_PHA : CodePoint = CodePoint::from(6490u32);
    pub const TAI_LE_LETTER_MA : CodePoint = CodePoint::from(6491u32);
    pub const TAI_LE_LETTER_FA : CodePoint = CodePoint::from(6492u32);
    pub const TAI_LE_LETTER_VA : CodePoint = CodePoint::from(6493u32);
    pub const TAI_LE_LETTER_HA : CodePoint = CodePoint::from(6494u32);
    pub const TAI_LE_LETTER_QA : CodePoint = CodePoint::from(6495u32);
    pub const TAI_LE_LETTER_KHA : CodePoint = CodePoint::from(6496u32);
    pub const TAI_LE_LETTER_TSHA : CodePoint = CodePoint::from(6497u32);
    pub const TAI_LE_LETTER_NA : CodePoint = CodePoint::from(6498u32);
    pub const TAI_LE_LETTER_A : CodePoint = CodePoint::from(6499u32);
    pub const TAI_LE_LETTER_I : CodePoint = CodePoint::from(6500u32);
    pub const TAI_LE_LETTER_EE : CodePoint = CodePoint::from(6501u32);
    pub const TAI_LE_LETTER_EH : CodePoint = CodePoint::from(6502u32);
    pub const TAI_LE_LETTER_U : CodePoint = CodePoint::from(6503u32);
    pub const TAI_LE_LETTER_OO : CodePoint = CodePoint::from(6504u32);
    pub const TAI_LE_LETTER_O : CodePoint = CodePoint::from(6505u32);
    pub const TAI_LE_LETTER_UE : CodePoint = CodePoint::from(6506u32);
    pub const TAI_LE_LETTER_E : CodePoint = CodePoint::from(6507u32);
    pub const TAI_LE_LETTER_AUE : CodePoint = CodePoint::from(6508u32);
    pub const TAI_LE_LETTER_AI : CodePoint = CodePoint::from(6509u32);
    pub const TAI_LE_LETTER_TONE_2 : CodePoint = CodePoint::from(6512u32);
    pub const TAI_LE_LETTER_TONE_3 : CodePoint = CodePoint::from(6513u32);
    pub const TAI_LE_LETTER_TONE_4 : CodePoint = CodePoint::from(6514u32);
    pub const TAI_LE_LETTER_TONE_5 : CodePoint = CodePoint::from(6515u32);
    pub const TAI_LE_LETTER_TONE_6 : CodePoint = CodePoint::from(6516u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_QA : CodePoint = CodePoint::from(6528u32);
    pub const NEW_TAI_LUE_LETTER_LOW_QA : CodePoint = CodePoint::from(6529u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_KA : CodePoint = CodePoint::from(6530u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_XA : CodePoint = CodePoint::from(6531u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_NGA : CodePoint = CodePoint::from(6532u32);
    pub const NEW_TAI_LUE_LETTER_LOW_KA : CodePoint = CodePoint::from(6533u32);
    pub const NEW_TAI_LUE_LETTER_LOW_XA : CodePoint = CodePoint::from(6534u32);
    pub const NEW_TAI_LUE_LETTER_LOW_NGA : CodePoint = CodePoint::from(6535u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_TSA : CodePoint = CodePoint::from(6536u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_SA : CodePoint = CodePoint::from(6537u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_YA : CodePoint = CodePoint::from(6538u32);
    pub const NEW_TAI_LUE_LETTER_LOW_TSA : CodePoint = CodePoint::from(6539u32);
    pub const NEW_TAI_LUE_LETTER_LOW_SA : CodePoint = CodePoint::from(6540u32);
    pub const NEW_TAI_LUE_LETTER_LOW_YA : CodePoint = CodePoint::from(6541u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_TA : CodePoint = CodePoint::from(6542u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_THA : CodePoint = CodePoint::from(6543u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_NA : CodePoint = CodePoint::from(6544u32);
    pub const NEW_TAI_LUE_LETTER_LOW_TA : CodePoint = CodePoint::from(6545u32);
    pub const NEW_TAI_LUE_LETTER_LOW_THA : CodePoint = CodePoint::from(6546u32);
    pub const NEW_TAI_LUE_LETTER_LOW_NA : CodePoint = CodePoint::from(6547u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_PA : CodePoint = CodePoint::from(6548u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_PHA : CodePoint = CodePoint::from(6549u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_MA : CodePoint = CodePoint::from(6550u32);
    pub const NEW_TAI_LUE_LETTER_LOW_PA : CodePoint = CodePoint::from(6551u32);
    pub const NEW_TAI_LUE_LETTER_LOW_PHA : CodePoint = CodePoint::from(6552u32);
    pub const NEW_TAI_LUE_LETTER_LOW_MA : CodePoint = CodePoint::from(6553u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_FA : CodePoint = CodePoint::from(6554u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_VA : CodePoint = CodePoint::from(6555u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_LA : CodePoint = CodePoint::from(6556u32);
    pub const NEW_TAI_LUE_LETTER_LOW_FA : CodePoint = CodePoint::from(6557u32);
    pub const NEW_TAI_LUE_LETTER_LOW_VA : CodePoint = CodePoint::from(6558u32);
    pub const NEW_TAI_LUE_LETTER_LOW_LA : CodePoint = CodePoint::from(6559u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_HA : CodePoint = CodePoint::from(6560u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_DA : CodePoint = CodePoint::from(6561u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_BA : CodePoint = CodePoint::from(6562u32);
    pub const NEW_TAI_LUE_LETTER_LOW_HA : CodePoint = CodePoint::from(6563u32);
    pub const NEW_TAI_LUE_LETTER_LOW_DA : CodePoint = CodePoint::from(6564u32);
    pub const NEW_TAI_LUE_LETTER_LOW_BA : CodePoint = CodePoint::from(6565u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_KVA : CodePoint = CodePoint::from(6566u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_XVA : CodePoint = CodePoint::from(6567u32);
    pub const NEW_TAI_LUE_LETTER_LOW_KVA : CodePoint = CodePoint::from(6568u32);
    pub const NEW_TAI_LUE_LETTER_LOW_XVA : CodePoint = CodePoint::from(6569u32);
    pub const NEW_TAI_LUE_LETTER_HIGH_SUA : CodePoint = CodePoint::from(6570u32);
    pub const NEW_TAI_LUE_LETTER_LOW_SUA : CodePoint = CodePoint::from(6571u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_VOWEL_SHORTENER : CodePoint = CodePoint::from(6576u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_AA : CodePoint = CodePoint::from(6577u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_II : CodePoint = CodePoint::from(6578u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_U : CodePoint = CodePoint::from(6579u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_UU : CodePoint = CodePoint::from(6580u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_E : CodePoint = CodePoint::from(6581u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_AE : CodePoint = CodePoint::from(6582u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_O : CodePoint = CodePoint::from(6583u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_OA : CodePoint = CodePoint::from(6584u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_UE : CodePoint = CodePoint::from(6585u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_AY : CodePoint = CodePoint::from(6586u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_AAY : CodePoint = CodePoint::from(6587u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_UY : CodePoint = CodePoint::from(6588u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_OY : CodePoint = CodePoint::from(6589u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_OAY : CodePoint = CodePoint::from(6590u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_UEY : CodePoint = CodePoint::from(6591u32);
    pub const NEW_TAI_LUE_VOWEL_SIGN_IY : CodePoint = CodePoint::from(6592u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_V : CodePoint = CodePoint::from(6593u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_NG : CodePoint = CodePoint::from(6594u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_N : CodePoint = CodePoint::from(6595u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_M : CodePoint = CodePoint::from(6596u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_K : CodePoint = CodePoint::from(6597u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_D : CodePoint = CodePoint::from(6598u32);
    pub const NEW_TAI_LUE_LETTER_FINAL_B : CodePoint = CodePoint::from(6599u32);
    pub const NEW_TAI_LUE_TONE_MARK_1 : CodePoint = CodePoint::from(6600u32);
    pub const NEW_TAI_LUE_TONE_MARK_2 : CodePoint = CodePoint::from(6601u32);
    pub const NEW_TAI_LUE_DIGIT_ZERO : CodePoint = CodePoint::from(6608u32);
    pub const NEW_TAI_LUE_DIGIT_ONE : CodePoint = CodePoint::from(6609u32);
    pub const NEW_TAI_LUE_DIGIT_TWO : CodePoint = CodePoint::from(6610u32);
    pub const NEW_TAI_LUE_DIGIT_THREE : CodePoint = CodePoint::from(6611u32);
    pub const NEW_TAI_LUE_DIGIT_FOUR : CodePoint = CodePoint::from(6612u32);
    pub const NEW_TAI_LUE_DIGIT_FIVE : CodePoint = CodePoint::from(6613u32);
    pub const NEW_TAI_LUE_DIGIT_SIX : CodePoint = CodePoint::from(6614u32);
    pub const NEW_TAI_LUE_DIGIT_SEVEN : CodePoint = CodePoint::from(6615u32);
    pub const NEW_TAI_LUE_DIGIT_EIGHT : CodePoint = CodePoint::from(6616u32);
    pub const NEW_TAI_LUE_DIGIT_NINE : CodePoint = CodePoint::from(6617u32);
    pub const NEW_TAI_LUE_THAM_DIGIT_ONE : CodePoint = CodePoint::from(6618u32);
    pub const NEW_TAI_LUE_SIGN_LAE : CodePoint = CodePoint::from(6622u32);
    pub const NEW_TAI_LUE_SIGN_LAEV : CodePoint = CodePoint::from(6623u32);
    pub const KHMER_SYMBOL_PATHAMASAT : CodePoint = CodePoint::from(6624u32);
    pub const KHMER_SYMBOL_MUOY_KOET : CodePoint = CodePoint::from(6625u32);
    pub const KHMER_SYMBOL_PII_KOET : CodePoint = CodePoint::from(6626u32);
    pub const KHMER_SYMBOL_BEI_KOET : CodePoint = CodePoint::from(6627u32);
    pub const KHMER_SYMBOL_BUON_KOET : CodePoint = CodePoint::from(6628u32);
    pub const KHMER_SYMBOL_PRAM_KOET : CodePoint = CodePoint::from(6629u32);
    pub const KHMER_SYMBOL_PRAM_MUOY_KOET : CodePoint = CodePoint::from(6630u32);
    pub const KHMER_SYMBOL_PRAM_PII_KOET : CodePoint = CodePoint::from(6631u32);
    pub const KHMER_SYMBOL_PRAM_BEI_KOET : CodePoint = CodePoint::from(6632u32);
    pub const KHMER_SYMBOL_PRAM_BUON_KOET : CodePoint = CodePoint::from(6633u32);
    pub const KHMER_SYMBOL_DAP_KOET : CodePoint = CodePoint::from(6634u32);
    pub const KHMER_SYMBOL_DAP_MUOY_KOET : CodePoint = CodePoint::from(6635u32);
    pub const KHMER_SYMBOL_DAP_PII_KOET : CodePoint = CodePoint::from(6636u32);
    pub const KHMER_SYMBOL_DAP_BEI_KOET : CodePoint = CodePoint::from(6637u32);
    pub const KHMER_SYMBOL_DAP_BUON_KOET : CodePoint = CodePoint::from(6638u32);
    pub const KHMER_SYMBOL_DAP_PRAM_KOET : CodePoint = CodePoint::from(6639u32);
    pub const KHMER_SYMBOL_TUTEYASAT : CodePoint = CodePoint::from(6640u32);
    pub const KHMER_SYMBOL_MUOY_ROC : CodePoint = CodePoint::from(6641u32);
    pub const KHMER_SYMBOL_PII_ROC : CodePoint = CodePoint::from(6642u32);
    pub const KHMER_SYMBOL_BEI_ROC : CodePoint = CodePoint::from(6643u32);
    pub const KHMER_SYMBOL_BUON_ROC : CodePoint = CodePoint::from(6644u32);
    pub const KHMER_SYMBOL_PRAM_ROC : CodePoint = CodePoint::from(6645u32);
    pub const KHMER_SYMBOL_PRAM_MUOY_ROC : CodePoint = CodePoint::from(6646u32);
    pub const KHMER_SYMBOL_PRAM_PII_ROC : CodePoint = CodePoint::from(6647u32);
    pub const KHMER_SYMBOL_PRAM_BEI_ROC : CodePoint = CodePoint::from(6648u32);
    pub const KHMER_SYMBOL_PRAM_BUON_ROC : CodePoint = CodePoint::from(6649u32);
    pub const KHMER_SYMBOL_DAP_ROC : CodePoint = CodePoint::from(6650u32);
    pub const KHMER_SYMBOL_DAP_MUOY_ROC : CodePoint = CodePoint::from(6651u32);
    pub const KHMER_SYMBOL_DAP_PII_ROC : CodePoint = CodePoint::from(6652u32);
    pub const KHMER_SYMBOL_DAP_BEI_ROC : CodePoint = CodePoint::from(6653u32);
    pub const KHMER_SYMBOL_DAP_BUON_ROC : CodePoint = CodePoint::from(6654u32);
    pub const KHMER_SYMBOL_DAP_PRAM_ROC : CodePoint = CodePoint::from(6655u32);
    pub const BUGINESE_LETTER_KA : CodePoint = CodePoint::from(6656u32);
    pub const BUGINESE_LETTER_GA : CodePoint = CodePoint::from(6657u32);
    pub const BUGINESE_LETTER_NGA : CodePoint = CodePoint::from(6658u32);
    pub const BUGINESE_LETTER_NGKA : CodePoint = CodePoint::from(6659u32);
    pub const BUGINESE_LETTER_PA : CodePoint = CodePoint::from(6660u32);
    pub const BUGINESE_LETTER_BA : CodePoint = CodePoint::from(6661u32);
    pub const BUGINESE_LETTER_MA : CodePoint = CodePoint::from(6662u32);
    pub const BUGINESE_LETTER_MPA : CodePoint = CodePoint::from(6663u32);
    pub const BUGINESE_LETTER_TA : CodePoint = CodePoint::from(6664u32);
    pub const BUGINESE_LETTER_DA : CodePoint = CodePoint::from(6665u32);
    pub const BUGINESE_LETTER_NA : CodePoint = CodePoint::from(6666u32);
    pub const BUGINESE_LETTER_NRA : CodePoint = CodePoint::from(6667u32);
    pub const BUGINESE_LETTER_CA : CodePoint = CodePoint::from(6668u32);
    pub const BUGINESE_LETTER_JA : CodePoint = CodePoint::from(6669u32);
    pub const BUGINESE_LETTER_NYA : CodePoint = CodePoint::from(6670u32);
    pub const BUGINESE_LETTER_NYCA : CodePoint = CodePoint::from(6671u32);
    pub const BUGINESE_LETTER_YA : CodePoint = CodePoint::from(6672u32);
    pub const BUGINESE_LETTER_RA : CodePoint = CodePoint::from(6673u32);
    pub const BUGINESE_LETTER_LA : CodePoint = CodePoint::from(6674u32);
    pub const BUGINESE_LETTER_VA : CodePoint = CodePoint::from(6675u32);
    pub const BUGINESE_LETTER_SA : CodePoint = CodePoint::from(6676u32);
    pub const BUGINESE_LETTER_A : CodePoint = CodePoint::from(6677u32);
    pub const BUGINESE_LETTER_HA : CodePoint = CodePoint::from(6678u32);
    pub const BUGINESE_VOWEL_SIGN_I : CodePoint = CodePoint::from(6679u32);
    pub const BUGINESE_VOWEL_SIGN_U : CodePoint = CodePoint::from(6680u32);
    pub const BUGINESE_VOWEL_SIGN_E : CodePoint = CodePoint::from(6681u32);
    pub const BUGINESE_VOWEL_SIGN_O : CodePoint = CodePoint::from(6682u32);
    pub const BUGINESE_VOWEL_SIGN_AE : CodePoint = CodePoint::from(6683u32);
    pub const BUGINESE_PALLAWA : CodePoint = CodePoint::from(6686u32);
    pub const BUGINESE_END_OF_SECTION : CodePoint = CodePoint::from(6687u32);
    pub const TAI_THAM_LETTER_HIGH_KA : CodePoint = CodePoint::from(6688u32);
    pub const TAI_THAM_LETTER_HIGH_KHA : CodePoint = CodePoint::from(6689u32);
    pub const TAI_THAM_LETTER_HIGH_KXA : CodePoint = CodePoint::from(6690u32);
    pub const TAI_THAM_LETTER_LOW_KA : CodePoint = CodePoint::from(6691u32);
    pub const TAI_THAM_LETTER_LOW_KXA : CodePoint = CodePoint::from(6692u32);
    pub const TAI_THAM_LETTER_LOW_KHA : CodePoint = CodePoint::from(6693u32);
    pub const TAI_THAM_LETTER_NGA : CodePoint = CodePoint::from(6694u32);
    pub const TAI_THAM_LETTER_HIGH_CA : CodePoint = CodePoint::from(6695u32);
    pub const TAI_THAM_LETTER_HIGH_CHA : CodePoint = CodePoint::from(6696u32);
    pub const TAI_THAM_LETTER_LOW_CA : CodePoint = CodePoint::from(6697u32);
    pub const TAI_THAM_LETTER_LOW_SA : CodePoint = CodePoint::from(6698u32);
    pub const TAI_THAM_LETTER_LOW_CHA : CodePoint = CodePoint::from(6699u32);
    pub const TAI_THAM_LETTER_NYA : CodePoint = CodePoint::from(6700u32);
    pub const TAI_THAM_LETTER_RATA : CodePoint = CodePoint::from(6701u32);
    pub const TAI_THAM_LETTER_HIGH_RATHA : CodePoint = CodePoint::from(6702u32);
    pub const TAI_THAM_LETTER_DA : CodePoint = CodePoint::from(6703u32);
    pub const TAI_THAM_LETTER_LOW_RATHA : CodePoint = CodePoint::from(6704u32);
    pub const TAI_THAM_LETTER_RANA : CodePoint = CodePoint::from(6705u32);
    pub const TAI_THAM_LETTER_HIGH_TA : CodePoint = CodePoint::from(6706u32);
    pub const TAI_THAM_LETTER_HIGH_THA : CodePoint = CodePoint::from(6707u32);
    pub const TAI_THAM_LETTER_LOW_TA : CodePoint = CodePoint::from(6708u32);
    pub const TAI_THAM_LETTER_LOW_THA : CodePoint = CodePoint::from(6709u32);
    pub const TAI_THAM_LETTER_NA : CodePoint = CodePoint::from(6710u32);
    pub const TAI_THAM_LETTER_BA : CodePoint = CodePoint::from(6711u32);
    pub const TAI_THAM_LETTER_HIGH_PA : CodePoint = CodePoint::from(6712u32);
    pub const TAI_THAM_LETTER_HIGH_PHA : CodePoint = CodePoint::from(6713u32);
    pub const TAI_THAM_LETTER_HIGH_FA : CodePoint = CodePoint::from(6714u32);
    pub const TAI_THAM_LETTER_LOW_PA : CodePoint = CodePoint::from(6715u32);
    pub const TAI_THAM_LETTER_LOW_FA : CodePoint = CodePoint::from(6716u32);
    pub const TAI_THAM_LETTER_LOW_PHA : CodePoint = CodePoint::from(6717u32);
    pub const TAI_THAM_LETTER_MA : CodePoint = CodePoint::from(6718u32);
    pub const TAI_THAM_LETTER_LOW_YA : CodePoint = CodePoint::from(6719u32);
    pub const TAI_THAM_LETTER_HIGH_YA : CodePoint = CodePoint::from(6720u32);
    pub const TAI_THAM_LETTER_RA : CodePoint = CodePoint::from(6721u32);
    pub const TAI_THAM_LETTER_RUE : CodePoint = CodePoint::from(6722u32);
    pub const TAI_THAM_LETTER_LA : CodePoint = CodePoint::from(6723u32);
    pub const TAI_THAM_LETTER_LUE : CodePoint = CodePoint::from(6724u32);
    pub const TAI_THAM_LETTER_WA : CodePoint = CodePoint::from(6725u32);
    pub const TAI_THAM_LETTER_HIGH_SHA : CodePoint = CodePoint::from(6726u32);
    pub const TAI_THAM_LETTER_HIGH_SSA : CodePoint = CodePoint::from(6727u32);
    pub const TAI_THAM_LETTER_HIGH_SA : CodePoint = CodePoint::from(6728u32);
    pub const TAI_THAM_LETTER_HIGH_HA : CodePoint = CodePoint::from(6729u32);
    pub const TAI_THAM_LETTER_LLA : CodePoint = CodePoint::from(6730u32);
    pub const TAI_THAM_LETTER_A : CodePoint = CodePoint::from(6731u32);
    pub const TAI_THAM_LETTER_LOW_HA : CodePoint = CodePoint::from(6732u32);
    pub const TAI_THAM_LETTER_I : CodePoint = CodePoint::from(6733u32);
    pub const TAI_THAM_LETTER_II : CodePoint = CodePoint::from(6734u32);
    pub const TAI_THAM_LETTER_U : CodePoint = CodePoint::from(6735u32);
    pub const TAI_THAM_LETTER_UU : CodePoint = CodePoint::from(6736u32);
    pub const TAI_THAM_LETTER_EE : CodePoint = CodePoint::from(6737u32);
    pub const TAI_THAM_LETTER_OO : CodePoint = CodePoint::from(6738u32);
    pub const TAI_THAM_LETTER_LAE : CodePoint = CodePoint::from(6739u32);
    pub const TAI_THAM_LETTER_GREAT_SA : CodePoint = CodePoint::from(6740u32);
    pub const TAI_THAM_CONSONANT_SIGN_MEDIAL_RA : CodePoint = CodePoint::from(6741u32);
    pub const TAI_THAM_CONSONANT_SIGN_MEDIAL_LA : CodePoint = CodePoint::from(6742u32);
    pub const TAI_THAM_CONSONANT_SIGN_LA_TANG_LAI : CodePoint = CodePoint::from(6743u32);
    pub const TAI_THAM_SIGN_MAI_KANG_LAI : CodePoint = CodePoint::from(6744u32);
    pub const TAI_THAM_CONSONANT_SIGN_FINAL_NGA : CodePoint = CodePoint::from(6745u32);
    pub const TAI_THAM_CONSONANT_SIGN_LOW_PA : CodePoint = CodePoint::from(6746u32);
    pub const TAI_THAM_CONSONANT_SIGN_HIGH_RATHA_OR_LOW_PA : CodePoint = CodePoint::from(6747u32);
    pub const TAI_THAM_CONSONANT_SIGN_MA : CodePoint = CodePoint::from(6748u32);
    pub const TAI_THAM_CONSONANT_SIGN_BA : CodePoint = CodePoint::from(6749u32);
    pub const TAI_THAM_CONSONANT_SIGN_SA : CodePoint = CodePoint::from(6750u32);
    pub const TAI_THAM_SIGN_SAKOT : CodePoint = CodePoint::from(6752u32);
    pub const TAI_THAM_VOWEL_SIGN_A : CodePoint = CodePoint::from(6753u32);
    pub const TAI_THAM_VOWEL_SIGN_MAI_SAT : CodePoint = CodePoint::from(6754u32);
    pub const TAI_THAM_VOWEL_SIGN_AA : CodePoint = CodePoint::from(6755u32);
    pub const TAI_THAM_VOWEL_SIGN_TALL_AA : CodePoint = CodePoint::from(6756u32);
    pub const TAI_THAM_VOWEL_SIGN_I : CodePoint = CodePoint::from(6757u32);
    pub const TAI_THAM_VOWEL_SIGN_II : CodePoint = CodePoint::from(6758u32);
    pub const TAI_THAM_VOWEL_SIGN_UE : CodePoint = CodePoint::from(6759u32);
    pub const TAI_THAM_VOWEL_SIGN_UUE : CodePoint = CodePoint::from(6760u32);
    pub const TAI_THAM_VOWEL_SIGN_U : CodePoint = CodePoint::from(6761u32);
    pub const TAI_THAM_VOWEL_SIGN_UU : CodePoint = CodePoint::from(6762u32);
    pub const TAI_THAM_VOWEL_SIGN_O : CodePoint = CodePoint::from(6763u32);
    pub const TAI_THAM_VOWEL_SIGN_OA_BELOW : CodePoint = CodePoint::from(6764u32);
    pub const TAI_THAM_VOWEL_SIGN_OY : CodePoint = CodePoint::from(6765u32);
    pub const TAI_THAM_VOWEL_SIGN_E : CodePoint = CodePoint::from(6766u32);
    pub const TAI_THAM_VOWEL_SIGN_AE : CodePoint = CodePoint::from(6767u32);
    pub const TAI_THAM_VOWEL_SIGN_OO : CodePoint = CodePoint::from(6768u32);
    pub const TAI_THAM_VOWEL_SIGN_AI : CodePoint = CodePoint::from(6769u32);
    pub const TAI_THAM_VOWEL_SIGN_THAM_AI : CodePoint = CodePoint::from(6770u32);
    pub const TAI_THAM_VOWEL_SIGN_OA_ABOVE : CodePoint = CodePoint::from(6771u32);
    pub const TAI_THAM_SIGN_MAI_KANG : CodePoint = CodePoint::from(6772u32);
    pub const TAI_THAM_SIGN_TONE_1 : CodePoint = CodePoint::from(6773u32);
    pub const TAI_THAM_SIGN_TONE_2 : CodePoint = CodePoint::from(6774u32);
    pub const TAI_THAM_SIGN_KHUEN_TONE_3 : CodePoint = CodePoint::from(6775u32);
    pub const TAI_THAM_SIGN_KHUEN_TONE_4 : CodePoint = CodePoint::from(6776u32);
    pub const TAI_THAM_SIGN_KHUEN_TONE_5 : CodePoint = CodePoint::from(6777u32);
    pub const TAI_THAM_SIGN_RA_HAAM : CodePoint = CodePoint::from(6778u32);
    pub const TAI_THAM_SIGN_MAI_SAM : CodePoint = CodePoint::from(6779u32);
    pub const TAI_THAM_SIGN_KHUEN_LUE_KARAN : CodePoint = CodePoint::from(6780u32);
    pub const TAI_THAM_COMBINING_CRYPTOGRAMMIC_DOT : CodePoint = CodePoint::from(6783u32);
    pub const TAI_THAM_HORA_DIGIT_ZERO : CodePoint = CodePoint::from(6784u32);
    pub const TAI_THAM_HORA_DIGIT_ONE : CodePoint = CodePoint::from(6785u32);
    pub const TAI_THAM_HORA_DIGIT_TWO : CodePoint = CodePoint::from(6786u32);
    pub const TAI_THAM_HORA_DIGIT_THREE : CodePoint = CodePoint::from(6787u32);
    pub const TAI_THAM_HORA_DIGIT_FOUR : CodePoint = CodePoint::from(6788u32);
    pub const TAI_THAM_HORA_DIGIT_FIVE : CodePoint = CodePoint::from(6789u32);
    pub const TAI_THAM_HORA_DIGIT_SIX : CodePoint = CodePoint::from(6790u32);
    pub const TAI_THAM_HORA_DIGIT_SEVEN : CodePoint = CodePoint::from(6791u32);
    pub const TAI_THAM_HORA_DIGIT_EIGHT : CodePoint = CodePoint::from(6792u32);
    pub const TAI_THAM_HORA_DIGIT_NINE : CodePoint = CodePoint::from(6793u32);
    pub const TAI_THAM_THAM_DIGIT_ZERO : CodePoint = CodePoint::from(6800u32);
    pub const TAI_THAM_THAM_DIGIT_ONE : CodePoint = CodePoint::from(6801u32);
    pub const TAI_THAM_THAM_DIGIT_TWO : CodePoint = CodePoint::from(6802u32);
    pub const TAI_THAM_THAM_DIGIT_THREE : CodePoint = CodePoint::from(6803u32);
    pub const TAI_THAM_THAM_DIGIT_FOUR : CodePoint = CodePoint::from(6804u32);
    pub const TAI_THAM_THAM_DIGIT_FIVE : CodePoint = CodePoint::from(6805u32);
    pub const TAI_THAM_THAM_DIGIT_SIX : CodePoint = CodePoint::from(6806u32);
    pub const TAI_THAM_THAM_DIGIT_SEVEN : CodePoint = CodePoint::from(6807u32);
    pub const TAI_THAM_THAM_DIGIT_EIGHT : CodePoint = CodePoint::from(6808u32);
    pub const TAI_THAM_THAM_DIGIT_NINE : CodePoint = CodePoint::from(6809u32);
    pub const TAI_THAM_SIGN_WIANG : CodePoint = CodePoint::from(6816u32);
    pub const TAI_THAM_SIGN_WIANGWAAK : CodePoint = CodePoint::from(6817u32);
    pub const TAI_THAM_SIGN_SAWAN : CodePoint = CodePoint::from(6818u32);
    pub const TAI_THAM_SIGN_KEOW : CodePoint = CodePoint::from(6819u32);
    pub const TAI_THAM_SIGN_HOY : CodePoint = CodePoint::from(6820u32);
    pub const TAI_THAM_SIGN_DOKMAI : CodePoint = CodePoint::from(6821u32);
    pub const TAI_THAM_SIGN_REVERSED_ROTATED_RANA : CodePoint = CodePoint::from(6822u32);
    pub const TAI_THAM_SIGN_MAI_YAMOK : CodePoint = CodePoint::from(6823u32);
    pub const TAI_THAM_SIGN_KAAN : CodePoint = CodePoint::from(6824u32);
    pub const TAI_THAM_SIGN_KAANKUU : CodePoint = CodePoint::from(6825u32);
    pub const TAI_THAM_SIGN_SATKAAN : CodePoint = CodePoint::from(6826u32);
    pub const TAI_THAM_SIGN_SATKAANKUU : CodePoint = CodePoint::from(6827u32);
    pub const TAI_THAM_SIGN_HANG : CodePoint = CodePoint::from(6828u32);
    pub const TAI_THAM_SIGN_CAANG : CodePoint = CodePoint::from(6829u32);
    pub const COMBINING_DOUBLED_CIRCUMFLEX_ACCENT : CodePoint = CodePoint::from(6832u32);
    pub const COMBINING_DIAERESIS_RING : CodePoint = CodePoint::from(6833u32);
    pub const COMBINING_INFINITY : CodePoint = CodePoint::from(6834u32);
    pub const COMBINING_DOWNWARDS_ARROW : CodePoint = CodePoint::from(6835u32);
    pub const COMBINING_TRIPLE_DOT : CodePoint = CodePoint::from(6836u32);
    pub const COMBINING_X_X_BELOW : CodePoint = CodePoint::from(6837u32);
    pub const COMBINING_WIGGLY_LINE_BELOW : CodePoint = CodePoint::from(6838u32);
    pub const COMBINING_OPEN_MARK_BELOW : CodePoint = CodePoint::from(6839u32);
    pub const COMBINING_DOUBLE_OPEN_MARK_BELOW : CodePoint = CodePoint::from(6840u32);
    pub const COMBINING_LIGHT_CENTRALIZATION_STROKE_BELOW : CodePoint = CodePoint::from(6841u32);
    pub const COMBINING_STRONG_CENTRALIZATION_STROKE_BELOW : CodePoint = CodePoint::from(6842u32);
    pub const COMBINING_PARENTHESES_ABOVE : CodePoint = CodePoint::from(6843u32);
    pub const COMBINING_DOUBLE_PARENTHESES_ABOVE : CodePoint = CodePoint::from(6844u32);
    pub const COMBINING_PARENTHESES_BELOW : CodePoint = CodePoint::from(6845u32);
    pub const COMBINING_PARENTHESES_OVERLAY : CodePoint = CodePoint::from(6846u32);
    pub const BALINESE_SIGN_ULU_RICEM : CodePoint = CodePoint::from(6912u32);
    pub const BALINESE_SIGN_ULU_CANDRA : CodePoint = CodePoint::from(6913u32);
    pub const BALINESE_SIGN_CECEK : CodePoint = CodePoint::from(6914u32);
    pub const BALINESE_SIGN_SURANG : CodePoint = CodePoint::from(6915u32);
    pub const BALINESE_SIGN_BISAH : CodePoint = CodePoint::from(6916u32);
    pub const BALINESE_LETTER_AKARA : CodePoint = CodePoint::from(6917u32);
    pub const BALINESE_LETTER_AKARA_TEDUNG : CodePoint = CodePoint::from(6918u32);
    pub const BALINESE_LETTER_IKARA : CodePoint = CodePoint::from(6919u32);
    pub const BALINESE_LETTER_IKARA_TEDUNG : CodePoint = CodePoint::from(6920u32);
    pub const BALINESE_LETTER_UKARA : CodePoint = CodePoint::from(6921u32);
    pub const BALINESE_LETTER_UKARA_TEDUNG : CodePoint = CodePoint::from(6922u32);
    pub const BALINESE_LETTER_RA_REPA : CodePoint = CodePoint::from(6923u32);
    pub const BALINESE_LETTER_RA_REPA_TEDUNG : CodePoint = CodePoint::from(6924u32);
    pub const BALINESE_LETTER_LA_LENGA : CodePoint = CodePoint::from(6925u32);
    pub const BALINESE_LETTER_LA_LENGA_TEDUNG : CodePoint = CodePoint::from(6926u32);
    pub const BALINESE_LETTER_EKARA : CodePoint = CodePoint::from(6927u32);
    pub const BALINESE_LETTER_AIKARA : CodePoint = CodePoint::from(6928u32);
    pub const BALINESE_LETTER_OKARA : CodePoint = CodePoint::from(6929u32);
    pub const BALINESE_LETTER_OKARA_TEDUNG : CodePoint = CodePoint::from(6930u32);
    pub const BALINESE_LETTER_KA : CodePoint = CodePoint::from(6931u32);
    pub const BALINESE_LETTER_KA_MAHAPRANA : CodePoint = CodePoint::from(6932u32);
    pub const BALINESE_LETTER_GA : CodePoint = CodePoint::from(6933u32);
    pub const BALINESE_LETTER_GA_GORA : CodePoint = CodePoint::from(6934u32);
    pub const BALINESE_LETTER_NGA : CodePoint = CodePoint::from(6935u32);
    pub const BALINESE_LETTER_CA : CodePoint = CodePoint::from(6936u32);
    pub const BALINESE_LETTER_CA_LACA : CodePoint = CodePoint::from(6937u32);
    pub const BALINESE_LETTER_JA : CodePoint = CodePoint::from(6938u32);
    pub const BALINESE_LETTER_JA_JERA : CodePoint = CodePoint::from(6939u32);
    pub const BALINESE_LETTER_NYA : CodePoint = CodePoint::from(6940u32);
    pub const BALINESE_LETTER_TA_LATIK : CodePoint = CodePoint::from(6941u32);
    pub const BALINESE_LETTER_TA_MURDA_MAHAPRANA : CodePoint = CodePoint::from(6942u32);
    pub const BALINESE_LETTER_DA_MURDA_ALPAPRANA : CodePoint = CodePoint::from(6943u32);
    pub const BALINESE_LETTER_DA_MURDA_MAHAPRANA : CodePoint = CodePoint::from(6944u32);
    pub const BALINESE_LETTER_NA_RAMBAT : CodePoint = CodePoint::from(6945u32);
    pub const BALINESE_LETTER_TA : CodePoint = CodePoint::from(6946u32);
    pub const BALINESE_LETTER_TA_TAWA : CodePoint = CodePoint::from(6947u32);
    pub const BALINESE_LETTER_DA : CodePoint = CodePoint::from(6948u32);
    pub const BALINESE_LETTER_DA_MADU : CodePoint = CodePoint::from(6949u32);
    pub const BALINESE_LETTER_NA : CodePoint = CodePoint::from(6950u32);
    pub const BALINESE_LETTER_PA : CodePoint = CodePoint::from(6951u32);
    pub const BALINESE_LETTER_PA_KAPAL : CodePoint = CodePoint::from(6952u32);
    pub const BALINESE_LETTER_BA : CodePoint = CodePoint::from(6953u32);
    pub const BALINESE_LETTER_BA_KEMBANG : CodePoint = CodePoint::from(6954u32);
    pub const BALINESE_LETTER_MA : CodePoint = CodePoint::from(6955u32);
    pub const BALINESE_LETTER_YA : CodePoint = CodePoint::from(6956u32);
    pub const BALINESE_LETTER_RA : CodePoint = CodePoint::from(6957u32);
    pub const BALINESE_LETTER_LA : CodePoint = CodePoint::from(6958u32);
    pub const BALINESE_LETTER_WA : CodePoint = CodePoint::from(6959u32);
    pub const BALINESE_LETTER_SA_SAGA : CodePoint = CodePoint::from(6960u32);
    pub const BALINESE_LETTER_SA_SAPA : CodePoint = CodePoint::from(6961u32);
    pub const BALINESE_LETTER_SA : CodePoint = CodePoint::from(6962u32);
    pub const BALINESE_LETTER_HA : CodePoint = CodePoint::from(6963u32);
    pub const BALINESE_SIGN_REREKAN : CodePoint = CodePoint::from(6964u32);
    pub const BALINESE_VOWEL_SIGN_TEDUNG : CodePoint = CodePoint::from(6965u32);
    pub const BALINESE_VOWEL_SIGN_ULU : CodePoint = CodePoint::from(6966u32);
    pub const BALINESE_VOWEL_SIGN_ULU_SARI : CodePoint = CodePoint::from(6967u32);
    pub const BALINESE_VOWEL_SIGN_SUKU : CodePoint = CodePoint::from(6968u32);
    pub const BALINESE_VOWEL_SIGN_SUKU_ILUT : CodePoint = CodePoint::from(6969u32);
    pub const BALINESE_VOWEL_SIGN_RA_REPA : CodePoint = CodePoint::from(6970u32);
    pub const BALINESE_VOWEL_SIGN_RA_REPA_TEDUNG : CodePoint = CodePoint::from(6971u32);
    pub const BALINESE_VOWEL_SIGN_LA_LENGA : CodePoint = CodePoint::from(6972u32);
    pub const BALINESE_VOWEL_SIGN_LA_LENGA_TEDUNG : CodePoint = CodePoint::from(6973u32);
    pub const BALINESE_VOWEL_SIGN_TALING : CodePoint = CodePoint::from(6974u32);
    pub const BALINESE_VOWEL_SIGN_TALING_REPA : CodePoint = CodePoint::from(6975u32);
    pub const BALINESE_VOWEL_SIGN_TALING_TEDUNG : CodePoint = CodePoint::from(6976u32);
    pub const BALINESE_VOWEL_SIGN_TALING_REPA_TEDUNG : CodePoint = CodePoint::from(6977u32);
    pub const BALINESE_VOWEL_SIGN_PEPET : CodePoint = CodePoint::from(6978u32);
    pub const BALINESE_VOWEL_SIGN_PEPET_TEDUNG : CodePoint = CodePoint::from(6979u32);
    pub const BALINESE_ADEG_ADEG : CodePoint = CodePoint::from(6980u32);
    pub const BALINESE_LETTER_KAF_SASAK : CodePoint = CodePoint::from(6981u32);
    pub const BALINESE_LETTER_KHOT_SASAK : CodePoint = CodePoint::from(6982u32);
    pub const BALINESE_LETTER_TZIR_SASAK : CodePoint = CodePoint::from(6983u32);
    pub const BALINESE_LETTER_EF_SASAK : CodePoint = CodePoint::from(6984u32);
    pub const BALINESE_LETTER_VE_SASAK : CodePoint = CodePoint::from(6985u32);
    pub const BALINESE_LETTER_ZAL_SASAK : CodePoint = CodePoint::from(6986u32);
    pub const BALINESE_LETTER_ASYURA_SASAK : CodePoint = CodePoint::from(6987u32);
    pub const BALINESE_DIGIT_ZERO : CodePoint = CodePoint::from(6992u32);
    pub const BALINESE_DIGIT_ONE : CodePoint = CodePoint::from(6993u32);
    pub const BALINESE_DIGIT_TWO : CodePoint = CodePoint::from(6994u32);
    pub const BALINESE_DIGIT_THREE : CodePoint = CodePoint::from(6995u32);
    pub const BALINESE_DIGIT_FOUR : CodePoint = CodePoint::from(6996u32);
    pub const BALINESE_DIGIT_FIVE : CodePoint = CodePoint::from(6997u32);
    pub const BALINESE_DIGIT_SIX : CodePoint = CodePoint::from(6998u32);
    pub const BALINESE_DIGIT_SEVEN : CodePoint = CodePoint::from(6999u32);
    pub const BALINESE_DIGIT_EIGHT : CodePoint = CodePoint::from(7000u32);
    pub const BALINESE_DIGIT_NINE : CodePoint = CodePoint::from(7001u32);
    pub const BALINESE_PANTI : CodePoint = CodePoint::from(7002u32);
    pub const BALINESE_PAMADA : CodePoint = CodePoint::from(7003u32);
    pub const BALINESE_WINDU : CodePoint = CodePoint::from(7004u32);
    pub const BALINESE_CARIK_PAMUNGKAH : CodePoint = CodePoint::from(7005u32);
    pub const BALINESE_CARIK_SIKI : CodePoint = CodePoint::from(7006u32);
    pub const BALINESE_CARIK_PAREREN : CodePoint = CodePoint::from(7007u32);
    pub const BALINESE_PAMENENG : CodePoint = CodePoint::from(7008u32);
    pub const BALINESE_MUSICAL_SYMBOL_DONG : CodePoint = CodePoint::from(7009u32);
    pub const BALINESE_MUSICAL_SYMBOL_DENG : CodePoint = CodePoint::from(7010u32);
    pub const BALINESE_MUSICAL_SYMBOL_DUNG : CodePoint = CodePoint::from(7011u32);
    pub const BALINESE_MUSICAL_SYMBOL_DANG : CodePoint = CodePoint::from(7012u32);
    pub const BALINESE_MUSICAL_SYMBOL_DANG_SURANG : CodePoint = CodePoint::from(7013u32);
    pub const BALINESE_MUSICAL_SYMBOL_DING : CodePoint = CodePoint::from(7014u32);
    pub const BALINESE_MUSICAL_SYMBOL_DAENG : CodePoint = CodePoint::from(7015u32);
    pub const BALINESE_MUSICAL_SYMBOL_DEUNG : CodePoint = CodePoint::from(7016u32);
    pub const BALINESE_MUSICAL_SYMBOL_DAING : CodePoint = CodePoint::from(7017u32);
    pub const BALINESE_MUSICAL_SYMBOL_DANG_GEDE : CodePoint = CodePoint::from(7018u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_TEGEH : CodePoint = CodePoint::from(7019u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_ENDEP : CodePoint = CodePoint::from(7020u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPUL : CodePoint = CodePoint::from(7021u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPLI : CodePoint = CodePoint::from(7022u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_JEGOGAN : CodePoint = CodePoint::from(7023u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPUL_WITH_JEGOGAN : CodePoint = CodePoint::from(7024u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPLI_WITH_JEGOGAN : CodePoint = CodePoint::from(7025u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_BENDE : CodePoint = CodePoint::from(7026u32);
    pub const BALINESE_MUSICAL_SYMBOL_COMBINING_GONG : CodePoint = CodePoint::from(7027u32);
    pub const BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_OPEN_DUG : CodePoint = CodePoint::from(7028u32);
    pub const BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_OPEN_DAG : CodePoint = CodePoint::from(7029u32);
    pub const BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_CLOSED_TUK : CodePoint = CodePoint::from(7030u32);
    pub const BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_CLOSED_TAK : CodePoint = CodePoint::from(7031u32);
    pub const BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PANG : CodePoint = CodePoint::from(7032u32);
    pub const BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PUNG : CodePoint = CodePoint::from(7033u32);
    pub const BALINESE_MUSICAL_SYMBOL_LEFT_HAND_CLOSED_PLAK : CodePoint = CodePoint::from(7034u32);
    pub const BALINESE_MUSICAL_SYMBOL_LEFT_HAND_CLOSED_PLUK : CodePoint = CodePoint::from(7035u32);
    pub const BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PING : CodePoint = CodePoint::from(7036u32);
    pub const SUNDANESE_SIGN_PANYECEK : CodePoint = CodePoint::from(7040u32);
    pub const SUNDANESE_SIGN_PANGLAYAR : CodePoint = CodePoint::from(7041u32);
    pub const SUNDANESE_SIGN_PANGWISAD : CodePoint = CodePoint::from(7042u32);
    pub const SUNDANESE_LETTER_A : CodePoint = CodePoint::from(7043u32);
    pub const SUNDANESE_LETTER_I : CodePoint = CodePoint::from(7044u32);
    pub const SUNDANESE_LETTER_U : CodePoint = CodePoint::from(7045u32);
    pub const SUNDANESE_LETTER_AE : CodePoint = CodePoint::from(7046u32);
    pub const SUNDANESE_LETTER_O : CodePoint = CodePoint::from(7047u32);
    pub const SUNDANESE_LETTER_E : CodePoint = CodePoint::from(7048u32);
    pub const SUNDANESE_LETTER_EU : CodePoint = CodePoint::from(7049u32);
    pub const SUNDANESE_LETTER_KA : CodePoint = CodePoint::from(7050u32);
    pub const SUNDANESE_LETTER_QA : CodePoint = CodePoint::from(7051u32);
    pub const SUNDANESE_LETTER_GA : CodePoint = CodePoint::from(7052u32);
    pub const SUNDANESE_LETTER_NGA : CodePoint = CodePoint::from(7053u32);
    pub const SUNDANESE_LETTER_CA : CodePoint = CodePoint::from(7054u32);
    pub const SUNDANESE_LETTER_JA : CodePoint = CodePoint::from(7055u32);
    pub const SUNDANESE_LETTER_ZA : CodePoint = CodePoint::from(7056u32);
    pub const SUNDANESE_LETTER_NYA : CodePoint = CodePoint::from(7057u32);
    pub const SUNDANESE_LETTER_TA : CodePoint = CodePoint::from(7058u32);
    pub const SUNDANESE_LETTER_DA : CodePoint = CodePoint::from(7059u32);
    pub const SUNDANESE_LETTER_NA : CodePoint = CodePoint::from(7060u32);
    pub const SUNDANESE_LETTER_PA : CodePoint = CodePoint::from(7061u32);
    pub const SUNDANESE_LETTER_FA : CodePoint = CodePoint::from(7062u32);
    pub const SUNDANESE_LETTER_VA : CodePoint = CodePoint::from(7063u32);
    pub const SUNDANESE_LETTER_BA : CodePoint = CodePoint::from(7064u32);
    pub const SUNDANESE_LETTER_MA : CodePoint = CodePoint::from(7065u32);
    pub const SUNDANESE_LETTER_YA : CodePoint = CodePoint::from(7066u32);
    pub const SUNDANESE_LETTER_RA : CodePoint = CodePoint::from(7067u32);
    pub const SUNDANESE_LETTER_LA : CodePoint = CodePoint::from(7068u32);
    pub const SUNDANESE_LETTER_WA : CodePoint = CodePoint::from(7069u32);
    pub const SUNDANESE_LETTER_SA : CodePoint = CodePoint::from(7070u32);
    pub const SUNDANESE_LETTER_XA : CodePoint = CodePoint::from(7071u32);
    pub const SUNDANESE_LETTER_HA : CodePoint = CodePoint::from(7072u32);
    pub const SUNDANESE_CONSONANT_SIGN_PAMINGKAL : CodePoint = CodePoint::from(7073u32);
    pub const SUNDANESE_CONSONANT_SIGN_PANYAKRA : CodePoint = CodePoint::from(7074u32);
    pub const SUNDANESE_CONSONANT_SIGN_PANYIKU : CodePoint = CodePoint::from(7075u32);
    pub const SUNDANESE_VOWEL_SIGN_PANGHULU : CodePoint = CodePoint::from(7076u32);
    pub const SUNDANESE_VOWEL_SIGN_PANYUKU : CodePoint = CodePoint::from(7077u32);
    pub const SUNDANESE_VOWEL_SIGN_PANAELAENG : CodePoint = CodePoint::from(7078u32);
    pub const SUNDANESE_VOWEL_SIGN_PANOLONG : CodePoint = CodePoint::from(7079u32);
    pub const SUNDANESE_VOWEL_SIGN_PAMEPET : CodePoint = CodePoint::from(7080u32);
    pub const SUNDANESE_VOWEL_SIGN_PANEULEUNG : CodePoint = CodePoint::from(7081u32);
    pub const SUNDANESE_SIGN_PAMAAEH : CodePoint = CodePoint::from(7082u32);
    pub const SUNDANESE_SIGN_VIRAMA : CodePoint = CodePoint::from(7083u32);
    pub const SUNDANESE_CONSONANT_SIGN_PASANGAN_MA : CodePoint = CodePoint::from(7084u32);
    pub const SUNDANESE_CONSONANT_SIGN_PASANGAN_WA : CodePoint = CodePoint::from(7085u32);
    pub const SUNDANESE_LETTER_KHA : CodePoint = CodePoint::from(7086u32);
    pub const SUNDANESE_LETTER_SYA : CodePoint = CodePoint::from(7087u32);
    pub const SUNDANESE_DIGIT_ZERO : CodePoint = CodePoint::from(7088u32);
    pub const SUNDANESE_DIGIT_ONE : CodePoint = CodePoint::from(7089u32);
    pub const SUNDANESE_DIGIT_TWO : CodePoint = CodePoint::from(7090u32);
    pub const SUNDANESE_DIGIT_THREE : CodePoint = CodePoint::from(7091u32);
    pub const SUNDANESE_DIGIT_FOUR : CodePoint = CodePoint::from(7092u32);
    pub const SUNDANESE_DIGIT_FIVE : CodePoint = CodePoint::from(7093u32);
    pub const SUNDANESE_DIGIT_SIX : CodePoint = CodePoint::from(7094u32);
    pub const SUNDANESE_DIGIT_SEVEN : CodePoint = CodePoint::from(7095u32);
    pub const SUNDANESE_DIGIT_EIGHT : CodePoint = CodePoint::from(7096u32);
    pub const SUNDANESE_DIGIT_NINE : CodePoint = CodePoint::from(7097u32);
    pub const SUNDANESE_AVAGRAHA : CodePoint = CodePoint::from(7098u32);
    pub const SUNDANESE_LETTER_REU : CodePoint = CodePoint::from(7099u32);
    pub const SUNDANESE_LETTER_LEU : CodePoint = CodePoint::from(7100u32);
    pub const SUNDANESE_LETTER_BHA : CodePoint = CodePoint::from(7101u32);
    pub const SUNDANESE_LETTER_FINAL_K : CodePoint = CodePoint::from(7102u32);
    pub const SUNDANESE_LETTER_FINAL_M : CodePoint = CodePoint::from(7103u32);
    pub const BATAK_LETTER_A : CodePoint = CodePoint::from(7104u32);
    pub const BATAK_LETTER_SIMALUNGUN_A : CodePoint = CodePoint::from(7105u32);
    pub const BATAK_LETTER_HA : CodePoint = CodePoint::from(7106u32);
    pub const BATAK_LETTER_SIMALUNGUN_HA : CodePoint = CodePoint::from(7107u32);
    pub const BATAK_LETTER_MANDAILING_HA : CodePoint = CodePoint::from(7108u32);
    pub const BATAK_LETTER_BA : CodePoint = CodePoint::from(7109u32);
    pub const BATAK_LETTER_KARO_BA : CodePoint = CodePoint::from(7110u32);
    pub const BATAK_LETTER_PA : CodePoint = CodePoint::from(7111u32);
    pub const BATAK_LETTER_SIMALUNGUN_PA : CodePoint = CodePoint::from(7112u32);
    pub const BATAK_LETTER_NA : CodePoint = CodePoint::from(7113u32);
    pub const BATAK_LETTER_MANDAILING_NA : CodePoint = CodePoint::from(7114u32);
    pub const BATAK_LETTER_WA : CodePoint = CodePoint::from(7115u32);
    pub const BATAK_LETTER_SIMALUNGUN_WA : CodePoint = CodePoint::from(7116u32);
    pub const BATAK_LETTER_PAKPAK_WA : CodePoint = CodePoint::from(7117u32);
    pub const BATAK_LETTER_GA : CodePoint = CodePoint::from(7118u32);
    pub const BATAK_LETTER_SIMALUNGUN_GA : CodePoint = CodePoint::from(7119u32);
    pub const BATAK_LETTER_JA : CodePoint = CodePoint::from(7120u32);
    pub const BATAK_LETTER_DA : CodePoint = CodePoint::from(7121u32);
    pub const BATAK_LETTER_RA : CodePoint = CodePoint::from(7122u32);
    pub const BATAK_LETTER_SIMALUNGUN_RA : CodePoint = CodePoint::from(7123u32);
    pub const BATAK_LETTER_MA : CodePoint = CodePoint::from(7124u32);
    pub const BATAK_LETTER_SIMALUNGUN_MA : CodePoint = CodePoint::from(7125u32);
    pub const BATAK_LETTER_SOUTHERN_TA : CodePoint = CodePoint::from(7126u32);
    pub const BATAK_LETTER_NORTHERN_TA : CodePoint = CodePoint::from(7127u32);
    pub const BATAK_LETTER_SA : CodePoint = CodePoint::from(7128u32);
    pub const BATAK_LETTER_SIMALUNGUN_SA : CodePoint = CodePoint::from(7129u32);
    pub const BATAK_LETTER_MANDAILING_SA : CodePoint = CodePoint::from(7130u32);
    pub const BATAK_LETTER_YA : CodePoint = CodePoint::from(7131u32);
    pub const BATAK_LETTER_SIMALUNGUN_YA : CodePoint = CodePoint::from(7132u32);
    pub const BATAK_LETTER_NGA : CodePoint = CodePoint::from(7133u32);
    pub const BATAK_LETTER_LA : CodePoint = CodePoint::from(7134u32);
    pub const BATAK_LETTER_SIMALUNGUN_LA : CodePoint = CodePoint::from(7135u32);
    pub const BATAK_LETTER_NYA : CodePoint = CodePoint::from(7136u32);
    pub const BATAK_LETTER_CA : CodePoint = CodePoint::from(7137u32);
    pub const BATAK_LETTER_NDA : CodePoint = CodePoint::from(7138u32);
    pub const BATAK_LETTER_MBA : CodePoint = CodePoint::from(7139u32);
    pub const BATAK_LETTER_I : CodePoint = CodePoint::from(7140u32);
    pub const BATAK_LETTER_U : CodePoint = CodePoint::from(7141u32);
    pub const BATAK_SIGN_TOMPI : CodePoint = CodePoint::from(7142u32);
    pub const BATAK_VOWEL_SIGN_E : CodePoint = CodePoint::from(7143u32);
    pub const BATAK_VOWEL_SIGN_PAKPAK_E : CodePoint = CodePoint::from(7144u32);
    pub const BATAK_VOWEL_SIGN_EE : CodePoint = CodePoint::from(7145u32);
    pub const BATAK_VOWEL_SIGN_I : CodePoint = CodePoint::from(7146u32);
    pub const BATAK_VOWEL_SIGN_KARO_I : CodePoint = CodePoint::from(7147u32);
    pub const BATAK_VOWEL_SIGN_O : CodePoint = CodePoint::from(7148u32);
    pub const BATAK_VOWEL_SIGN_KARO_O : CodePoint = CodePoint::from(7149u32);
    pub const BATAK_VOWEL_SIGN_U : CodePoint = CodePoint::from(7150u32);
    pub const BATAK_VOWEL_SIGN_U_FOR_SIMALUNGUN_SA : CodePoint = CodePoint::from(7151u32);
    pub const BATAK_CONSONANT_SIGN_NG : CodePoint = CodePoint::from(7152u32);
    pub const BATAK_CONSONANT_SIGN_H : CodePoint = CodePoint::from(7153u32);
    pub const BATAK_PANGOLAT : CodePoint = CodePoint::from(7154u32);
    pub const BATAK_PANONGONAN : CodePoint = CodePoint::from(7155u32);
    pub const BATAK_SYMBOL_BINDU_NA_METEK : CodePoint = CodePoint::from(7164u32);
    pub const BATAK_SYMBOL_BINDU_PINARBORAS : CodePoint = CodePoint::from(7165u32);
    pub const BATAK_SYMBOL_BINDU_JUDUL : CodePoint = CodePoint::from(7166u32);
    pub const BATAK_SYMBOL_BINDU_PANGOLAT : CodePoint = CodePoint::from(7167u32);
    pub const LEPCHA_LETTER_KA : CodePoint = CodePoint::from(7168u32);
    pub const LEPCHA_LETTER_KLA : CodePoint = CodePoint::from(7169u32);
    pub const LEPCHA_LETTER_KHA : CodePoint = CodePoint::from(7170u32);
    pub const LEPCHA_LETTER_GA : CodePoint = CodePoint::from(7171u32);
    pub const LEPCHA_LETTER_GLA : CodePoint = CodePoint::from(7172u32);
    pub const LEPCHA_LETTER_NGA : CodePoint = CodePoint::from(7173u32);
    pub const LEPCHA_LETTER_CA : CodePoint = CodePoint::from(7174u32);
    pub const LEPCHA_LETTER_CHA : CodePoint = CodePoint::from(7175u32);
    pub const LEPCHA_LETTER_JA : CodePoint = CodePoint::from(7176u32);
    pub const LEPCHA_LETTER_NYA : CodePoint = CodePoint::from(7177u32);
    pub const LEPCHA_LETTER_TA : CodePoint = CodePoint::from(7178u32);
    pub const LEPCHA_LETTER_THA : CodePoint = CodePoint::from(7179u32);
    pub const LEPCHA_LETTER_DA : CodePoint = CodePoint::from(7180u32);
    pub const LEPCHA_LETTER_NA : CodePoint = CodePoint::from(7181u32);
    pub const LEPCHA_LETTER_PA : CodePoint = CodePoint::from(7182u32);
    pub const LEPCHA_LETTER_PLA : CodePoint = CodePoint::from(7183u32);
    pub const LEPCHA_LETTER_PHA : CodePoint = CodePoint::from(7184u32);
    pub const LEPCHA_LETTER_FA : CodePoint = CodePoint::from(7185u32);
    pub const LEPCHA_LETTER_FLA : CodePoint = CodePoint::from(7186u32);
    pub const LEPCHA_LETTER_BA : CodePoint = CodePoint::from(7187u32);
    pub const LEPCHA_LETTER_BLA : CodePoint = CodePoint::from(7188u32);
    pub const LEPCHA_LETTER_MA : CodePoint = CodePoint::from(7189u32);
    pub const LEPCHA_LETTER_MLA : CodePoint = CodePoint::from(7190u32);
    pub const LEPCHA_LETTER_TSA : CodePoint = CodePoint::from(7191u32);
    pub const LEPCHA_LETTER_TSHA : CodePoint = CodePoint::from(7192u32);
    pub const LEPCHA_LETTER_DZA : CodePoint = CodePoint::from(7193u32);
    pub const LEPCHA_LETTER_YA : CodePoint = CodePoint::from(7194u32);
    pub const LEPCHA_LETTER_RA : CodePoint = CodePoint::from(7195u32);
    pub const LEPCHA_LETTER_LA : CodePoint = CodePoint::from(7196u32);
    pub const LEPCHA_LETTER_HA : CodePoint = CodePoint::from(7197u32);
    pub const LEPCHA_LETTER_HLA : CodePoint = CodePoint::from(7198u32);
    pub const LEPCHA_LETTER_VA : CodePoint = CodePoint::from(7199u32);
    pub const LEPCHA_LETTER_SA : CodePoint = CodePoint::from(7200u32);
    pub const LEPCHA_LETTER_SHA : CodePoint = CodePoint::from(7201u32);
    pub const LEPCHA_LETTER_WA : CodePoint = CodePoint::from(7202u32);
    pub const LEPCHA_LETTER_A : CodePoint = CodePoint::from(7203u32);
    pub const LEPCHA_SUBJOINED_LETTER_YA : CodePoint = CodePoint::from(7204u32);
    pub const LEPCHA_SUBJOINED_LETTER_RA : CodePoint = CodePoint::from(7205u32);
    pub const LEPCHA_VOWEL_SIGN_AA : CodePoint = CodePoint::from(7206u32);
    pub const LEPCHA_VOWEL_SIGN_I : CodePoint = CodePoint::from(7207u32);
    pub const LEPCHA_VOWEL_SIGN_O : CodePoint = CodePoint::from(7208u32);
    pub const LEPCHA_VOWEL_SIGN_OO : CodePoint = CodePoint::from(7209u32);
    pub const LEPCHA_VOWEL_SIGN_U : CodePoint = CodePoint::from(7210u32);
    pub const LEPCHA_VOWEL_SIGN_UU : CodePoint = CodePoint::from(7211u32);
    pub const LEPCHA_VOWEL_SIGN_E : CodePoint = CodePoint::from(7212u32);
    pub const LEPCHA_CONSONANT_SIGN_K : CodePoint = CodePoint::from(7213u32);
    pub const LEPCHA_CONSONANT_SIGN_M : CodePoint = CodePoint::from(7214u32);
    pub const LEPCHA_CONSONANT_SIGN_L : CodePoint = CodePoint::from(7215u32);
    pub const LEPCHA_CONSONANT_SIGN_N : CodePoint = CodePoint::from(7216u32);
    pub const LEPCHA_CONSONANT_SIGN_P : CodePoint = CodePoint::from(7217u32);
    pub const LEPCHA_CONSONANT_SIGN_R : CodePoint = CodePoint::from(7218u32);
    pub const LEPCHA_CONSONANT_SIGN_T : CodePoint = CodePoint::from(7219u32);
    pub const LEPCHA_CONSONANT_SIGN_NYIN_DO : CodePoint = CodePoint::from(7220u32);
    pub const LEPCHA_CONSONANT_SIGN_KANG : CodePoint = CodePoint::from(7221u32);
    pub const LEPCHA_SIGN_RAN : CodePoint = CodePoint::from(7222u32);
    pub const LEPCHA_SIGN_NUKTA : CodePoint = CodePoint::from(7223u32);
    pub const LEPCHA_PUNCTUATION_TA_ROL : CodePoint = CodePoint::from(7227u32);
    pub const LEPCHA_PUNCTUATION_NYET_THYOOM_TA_ROL : CodePoint = CodePoint::from(7228u32);
    pub const LEPCHA_PUNCTUATION_CER_WA : CodePoint = CodePoint::from(7229u32);
    pub const LEPCHA_PUNCTUATION_TSHOOK_CER_WA : CodePoint = CodePoint::from(7230u32);
    pub const LEPCHA_PUNCTUATION_TSHOOK : CodePoint = CodePoint::from(7231u32);
    pub const LEPCHA_DIGIT_ZERO : CodePoint = CodePoint::from(7232u32);
    pub const LEPCHA_DIGIT_ONE : CodePoint = CodePoint::from(7233u32);
    pub const LEPCHA_DIGIT_TWO : CodePoint = CodePoint::from(7234u32);
    pub const LEPCHA_DIGIT_THREE : CodePoint = CodePoint::from(7235u32);
    pub const LEPCHA_DIGIT_FOUR : CodePoint = CodePoint::from(7236u32);
    pub const LEPCHA_DIGIT_FIVE : CodePoint = CodePoint::from(7237u32);
    pub const LEPCHA_DIGIT_SIX : CodePoint = CodePoint::from(7238u32);
    pub const LEPCHA_DIGIT_SEVEN : CodePoint = CodePoint::from(7239u32);
    pub const LEPCHA_DIGIT_EIGHT : CodePoint = CodePoint::from(7240u32);
    pub const LEPCHA_DIGIT_NINE : CodePoint = CodePoint::from(7241u32);
    pub const LEPCHA_LETTER_TTA : CodePoint = CodePoint::from(7245u32);
    pub const LEPCHA_LETTER_TTHA : CodePoint = CodePoint::from(7246u32);
    pub const LEPCHA_LETTER_DDA : CodePoint = CodePoint::from(7247u32);
    pub const OL_CHIKI_DIGIT_ZERO : CodePoint = CodePoint::from(7248u32);
    pub const OL_CHIKI_DIGIT_ONE : CodePoint = CodePoint::from(7249u32);
    pub const OL_CHIKI_DIGIT_TWO : CodePoint = CodePoint::from(7250u32);
    pub const OL_CHIKI_DIGIT_THREE : CodePoint = CodePoint::from(7251u32);
    pub const OL_CHIKI_DIGIT_FOUR : CodePoint = CodePoint::from(7252u32);
    pub const OL_CHIKI_DIGIT_FIVE : CodePoint = CodePoint::from(7253u32);
    pub const OL_CHIKI_DIGIT_SIX : CodePoint = CodePoint::from(7254u32);
    pub const OL_CHIKI_DIGIT_SEVEN : CodePoint = CodePoint::from(7255u32);
    pub const OL_CHIKI_DIGIT_EIGHT : CodePoint = CodePoint::from(7256u32);
    pub const OL_CHIKI_DIGIT_NINE : CodePoint = CodePoint::from(7257u32);
    pub const OL_CHIKI_LETTER_LA : CodePoint = CodePoint::from(7258u32);
    pub const OL_CHIKI_LETTER_AT : CodePoint = CodePoint::from(7259u32);
    pub const OL_CHIKI_LETTER_AG : CodePoint = CodePoint::from(7260u32);
    pub const OL_CHIKI_LETTER_ANG : CodePoint = CodePoint::from(7261u32);
    pub const OL_CHIKI_LETTER_AL : CodePoint = CodePoint::from(7262u32);
    pub const OL_CHIKI_LETTER_LAA : CodePoint = CodePoint::from(7263u32);
    pub const OL_CHIKI_LETTER_AAK : CodePoint = CodePoint::from(7264u32);
    pub const OL_CHIKI_LETTER_AAJ : CodePoint = CodePoint::from(7265u32);
    pub const OL_CHIKI_LETTER_AAM : CodePoint = CodePoint::from(7266u32);
    pub const OL_CHIKI_LETTER_AAW : CodePoint = CodePoint::from(7267u32);
    pub const OL_CHIKI_LETTER_LI : CodePoint = CodePoint::from(7268u32);
    pub const OL_CHIKI_LETTER_IS : CodePoint = CodePoint::from(7269u32);
    pub const OL_CHIKI_LETTER_IH : CodePoint = CodePoint::from(7270u32);
    pub const OL_CHIKI_LETTER_INY : CodePoint = CodePoint::from(7271u32);
    pub const OL_CHIKI_LETTER_IR : CodePoint = CodePoint::from(7272u32);
    pub const OL_CHIKI_LETTER_LU : CodePoint = CodePoint::from(7273u32);
    pub const OL_CHIKI_LETTER_UC : CodePoint = CodePoint::from(7274u32);
    pub const OL_CHIKI_LETTER_UD : CodePoint = CodePoint::from(7275u32);
    pub const OL_CHIKI_LETTER_UNN : CodePoint = CodePoint::from(7276u32);
    pub const OL_CHIKI_LETTER_UY : CodePoint = CodePoint::from(7277u32);
    pub const OL_CHIKI_LETTER_LE : CodePoint = CodePoint::from(7278u32);
    pub const OL_CHIKI_LETTER_EP : CodePoint = CodePoint::from(7279u32);
    pub const OL_CHIKI_LETTER_EDD : CodePoint = CodePoint::from(7280u32);
    pub const OL_CHIKI_LETTER_EN : CodePoint = CodePoint::from(7281u32);
    pub const OL_CHIKI_LETTER_ERR : CodePoint = CodePoint::from(7282u32);
    pub const OL_CHIKI_LETTER_LO : CodePoint = CodePoint::from(7283u32);
    pub const OL_CHIKI_LETTER_OTT : CodePoint = CodePoint::from(7284u32);
    pub const OL_CHIKI_LETTER_OB : CodePoint = CodePoint::from(7285u32);
    pub const OL_CHIKI_LETTER_OV : CodePoint = CodePoint::from(7286u32);
    pub const OL_CHIKI_LETTER_OH : CodePoint = CodePoint::from(7287u32);
    pub const OL_CHIKI_MU_TTUDDAG : CodePoint = CodePoint::from(7288u32);
    pub const OL_CHIKI_GAAHLAA_TTUDDAAG : CodePoint = CodePoint::from(7289u32);
    pub const OL_CHIKI_MU_GAAHLAA_TTUDDAAG : CodePoint = CodePoint::from(7290u32);
    pub const OL_CHIKI_RELAA : CodePoint = CodePoint::from(7291u32);
    pub const OL_CHIKI_PHAARKAA : CodePoint = CodePoint::from(7292u32);
    pub const OL_CHIKI_AHAD : CodePoint = CodePoint::from(7293u32);
    pub const OL_CHIKI_PUNCTUATION_MUCAAD : CodePoint = CodePoint::from(7294u32);
    pub const OL_CHIKI_PUNCTUATION_DOUBLE_MUCAAD : CodePoint = CodePoint::from(7295u32);
    pub const CYRILLIC_SMALL_LETTER_ROUNDED_VE : CodePoint = CodePoint::from(7296u32);
    pub const CYRILLIC_SMALL_LETTER_LONG_LEGGED_DE : CodePoint = CodePoint::from(7297u32);
    pub const CYRILLIC_SMALL_LETTER_NARROW_O : CodePoint = CodePoint::from(7298u32);
    pub const CYRILLIC_SMALL_LETTER_WIDE_ES : CodePoint = CodePoint::from(7299u32);
    pub const CYRILLIC_SMALL_LETTER_TALL_TE : CodePoint = CodePoint::from(7300u32);
    pub const CYRILLIC_SMALL_LETTER_THREE_LEGGED_TE : CodePoint = CodePoint::from(7301u32);
    pub const CYRILLIC_SMALL_LETTER_TALL_HARD_SIGN : CodePoint = CodePoint::from(7302u32);
    pub const CYRILLIC_SMALL_LETTER_TALL_YAT : CodePoint = CodePoint::from(7303u32);
    pub const CYRILLIC_SMALL_LETTER_UNBLENDED_UK : CodePoint = CodePoint::from(7304u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_AN : CodePoint = CodePoint::from(7312u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_BAN : CodePoint = CodePoint::from(7313u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_GAN : CodePoint = CodePoint::from(7314u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_DON : CodePoint = CodePoint::from(7315u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_EN : CodePoint = CodePoint::from(7316u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_VIN : CodePoint = CodePoint::from(7317u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_ZEN : CodePoint = CodePoint::from(7318u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_TAN : CodePoint = CodePoint::from(7319u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_IN : CodePoint = CodePoint::from(7320u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_KAN : CodePoint = CodePoint::from(7321u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_LAS : CodePoint = CodePoint::from(7322u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_MAN : CodePoint = CodePoint::from(7323u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_NAR : CodePoint = CodePoint::from(7324u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_ON : CodePoint = CodePoint::from(7325u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_PAR : CodePoint = CodePoint::from(7326u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_ZHAR : CodePoint = CodePoint::from(7327u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_RAE : CodePoint = CodePoint::from(7328u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_SAN : CodePoint = CodePoint::from(7329u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_TAR : CodePoint = CodePoint::from(7330u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_UN : CodePoint = CodePoint::from(7331u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_PHAR : CodePoint = CodePoint::from(7332u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_KHAR : CodePoint = CodePoint::from(7333u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_GHAN : CodePoint = CodePoint::from(7334u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_QAR : CodePoint = CodePoint::from(7335u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_SHIN : CodePoint = CodePoint::from(7336u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_CHIN : CodePoint = CodePoint::from(7337u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_CAN : CodePoint = CodePoint::from(7338u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_JIL : CodePoint = CodePoint::from(7339u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_CIL : CodePoint = CodePoint::from(7340u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_CHAR : CodePoint = CodePoint::from(7341u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_XAN : CodePoint = CodePoint::from(7342u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_JHAN : CodePoint = CodePoint::from(7343u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_HAE : CodePoint = CodePoint::from(7344u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_HE : CodePoint = CodePoint::from(7345u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_HIE : CodePoint = CodePoint::from(7346u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_WE : CodePoint = CodePoint::from(7347u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_HAR : CodePoint = CodePoint::from(7348u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_HOE : CodePoint = CodePoint::from(7349u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_FI : CodePoint = CodePoint::from(7350u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_YN : CodePoint = CodePoint::from(7351u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_ELIFI : CodePoint = CodePoint::from(7352u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_TURNED_GAN : CodePoint = CodePoint::from(7353u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_AIN : CodePoint = CodePoint::from(7354u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_AEN : CodePoint = CodePoint::from(7357u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_HARD_SIGN : CodePoint = CodePoint::from(7358u32);
    pub const GEORGIAN_MTAVRULI_CAPITAL_LETTER_LABIAL_SIGN : CodePoint = CodePoint::from(7359u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_SURYA : CodePoint = CodePoint::from(7360u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_PANGLONG : CodePoint = CodePoint::from(7361u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_PURNAMA : CodePoint = CodePoint::from(7362u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_CAKRA : CodePoint = CodePoint::from(7363u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_LEU_SATANGA : CodePoint = CodePoint::from(7364u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_KA_SATANGA : CodePoint = CodePoint::from(7365u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_DA_SATANGA : CodePoint = CodePoint::from(7366u32);
    pub const SUNDANESE_PUNCTUATION_BINDU_BA_SATANGA : CodePoint = CodePoint::from(7367u32);
    pub const VEDIC_TONE_KARSHANA : CodePoint = CodePoint::from(7376u32);
    pub const VEDIC_TONE_SHARA : CodePoint = CodePoint::from(7377u32);
    pub const VEDIC_TONE_PRENKHA : CodePoint = CodePoint::from(7378u32);
    pub const VEDIC_SIGN_NIHSHVASA : CodePoint = CodePoint::from(7379u32);
    pub const VEDIC_SIGN_YAJURVEDIC_MIDLINE_SVARITA : CodePoint = CodePoint::from(7380u32);
    pub const VEDIC_TONE_YAJURVEDIC_AGGRAVATED_INDEPENDENT_SVARITA : CodePoint = CodePoint::from(7381u32);
    pub const VEDIC_TONE_YAJURVEDIC_INDEPENDENT_SVARITA : CodePoint = CodePoint::from(7382u32);
    pub const VEDIC_TONE_YAJURVEDIC_KATHAKA_INDEPENDENT_SVARITA : CodePoint = CodePoint::from(7383u32);
    pub const VEDIC_TONE_CANDRA_BELOW : CodePoint = CodePoint::from(7384u32);
    pub const VEDIC_TONE_YAJURVEDIC_KATHAKA_INDEPENDENT_SVARITA_SCHROEDER : CodePoint = CodePoint::from(7385u32);
    pub const VEDIC_TONE_DOUBLE_SVARITA : CodePoint = CodePoint::from(7386u32);
    pub const VEDIC_TONE_TRIPLE_SVARITA : CodePoint = CodePoint::from(7387u32);
    pub const VEDIC_TONE_KATHAKA_ANUDATTA : CodePoint = CodePoint::from(7388u32);
    pub const VEDIC_TONE_DOT_BELOW : CodePoint = CodePoint::from(7389u32);
    pub const VEDIC_TONE_TWO_DOTS_BELOW : CodePoint = CodePoint::from(7390u32);
    pub const VEDIC_TONE_THREE_DOTS_BELOW : CodePoint = CodePoint::from(7391u32);
    pub const VEDIC_TONE_RIGVEDIC_KASHMIRI_INDEPENDENT_SVARITA : CodePoint = CodePoint::from(7392u32);
    pub const VEDIC_TONE_ATHARVAVEDIC_INDEPENDENT_SVARITA : CodePoint = CodePoint::from(7393u32);
    pub const VEDIC_SIGN_VISARGA_SVARITA : CodePoint = CodePoint::from(7394u32);
    pub const VEDIC_SIGN_VISARGA_UDATTA : CodePoint = CodePoint::from(7395u32);
    pub const VEDIC_SIGN_REVERSED_VISARGA_UDATTA : CodePoint = CodePoint::from(7396u32);
    pub const VEDIC_SIGN_VISARGA_ANUDATTA : CodePoint = CodePoint::from(7397u32);
    pub const VEDIC_SIGN_REVERSED_VISARGA_ANUDATTA : CodePoint = CodePoint::from(7398u32);
    pub const VEDIC_SIGN_VISARGA_UDATTA_WITH_TAIL : CodePoint = CodePoint::from(7399u32);
    pub const VEDIC_SIGN_VISARGA_ANUDATTA_WITH_TAIL : CodePoint = CodePoint::from(7400u32);
    pub const VEDIC_SIGN_ANUSVARA_ANTARGOMUKHA : CodePoint = CodePoint::from(7401u32);
    pub const VEDIC_SIGN_ANUSVARA_BAHIRGOMUKHA : CodePoint = CodePoint::from(7402u32);
    pub const VEDIC_SIGN_ANUSVARA_VAMAGOMUKHA : CodePoint = CodePoint::from(7403u32);
    pub const VEDIC_SIGN_ANUSVARA_VAMAGOMUKHA_WITH_TAIL : CodePoint = CodePoint::from(7404u32);
    pub const VEDIC_SIGN_TIRYAK : CodePoint = CodePoint::from(7405u32);
    pub const VEDIC_SIGN_HEXIFORM_LONG_ANUSVARA : CodePoint = CodePoint::from(7406u32);
    pub const VEDIC_SIGN_LONG_ANUSVARA : CodePoint = CodePoint::from(7407u32);
    pub const VEDIC_SIGN_RTHANG_LONG_ANUSVARA : CodePoint = CodePoint::from(7408u32);
    pub const VEDIC_SIGN_ANUSVARA_UBHAYATO_MUKHA : CodePoint = CodePoint::from(7409u32);
    pub const VEDIC_SIGN_ARDHAVISARGA : CodePoint = CodePoint::from(7410u32);
    pub const VEDIC_SIGN_ROTATED_ARDHAVISARGA : CodePoint = CodePoint::from(7411u32);
    pub const VEDIC_TONE_CANDRA_ABOVE : CodePoint = CodePoint::from(7412u32);
    pub const VEDIC_SIGN_JIHVAMULIYA : CodePoint = CodePoint::from(7413u32);
    pub const VEDIC_SIGN_UPADHMANIYA : CodePoint = CodePoint::from(7414u32);
    pub const VEDIC_SIGN_ATIKRAMA : CodePoint = CodePoint::from(7415u32);
    pub const VEDIC_TONE_RING_ABOVE : CodePoint = CodePoint::from(7416u32);
    pub const VEDIC_TONE_DOUBLE_RING_ABOVE : CodePoint = CodePoint::from(7417u32);
    pub const VEDIC_SIGN_DOUBLE_ANUSVARA_ANTARGOMUKHA : CodePoint = CodePoint::from(7418u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_A : CodePoint = CodePoint::from(7424u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_AE : CodePoint = CodePoint::from(7425u32);
    pub const LATIN_SMALL_LETTER_TURNED_AE : CodePoint = CodePoint::from(7426u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_BARRED_B : CodePoint = CodePoint::from(7427u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_C : CodePoint = CodePoint::from(7428u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_D : CodePoint = CodePoint::from(7429u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_ETH : CodePoint = CodePoint::from(7430u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_E : CodePoint = CodePoint::from(7431u32);
    pub const LATIN_SMALL_LETTER_TURNED_OPEN_E : CodePoint = CodePoint::from(7432u32);
    pub const LATIN_SMALL_LETTER_TURNED_I : CodePoint = CodePoint::from(7433u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_J : CodePoint = CodePoint::from(7434u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_K : CodePoint = CodePoint::from(7435u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_L_WITH_STROKE : CodePoint = CodePoint::from(7436u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_M : CodePoint = CodePoint::from(7437u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_REVERSED_N : CodePoint = CodePoint::from(7438u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_O : CodePoint = CodePoint::from(7439u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_OPEN_O : CodePoint = CodePoint::from(7440u32);
    pub const LATIN_SMALL_LETTER_SIDEWAYS_O : CodePoint = CodePoint::from(7441u32);
    pub const LATIN_SMALL_LETTER_SIDEWAYS_OPEN_O : CodePoint = CodePoint::from(7442u32);
    pub const LATIN_SMALL_LETTER_SIDEWAYS_O_WITH_STROKE : CodePoint = CodePoint::from(7443u32);
    pub const LATIN_SMALL_LETTER_TURNED_OE : CodePoint = CodePoint::from(7444u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_OU : CodePoint = CodePoint::from(7445u32);
    pub const LATIN_SMALL_LETTER_TOP_HALF_O : CodePoint = CodePoint::from(7446u32);
    pub const LATIN_SMALL_LETTER_BOTTOM_HALF_O : CodePoint = CodePoint::from(7447u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_P : CodePoint = CodePoint::from(7448u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_REVERSED_R : CodePoint = CodePoint::from(7449u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_TURNED_R : CodePoint = CodePoint::from(7450u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_T : CodePoint = CodePoint::from(7451u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_U : CodePoint = CodePoint::from(7452u32);
    pub const LATIN_SMALL_LETTER_SIDEWAYS_U : CodePoint = CodePoint::from(7453u32);
    pub const LATIN_SMALL_LETTER_SIDEWAYS_DIAERESIZED_U : CodePoint = CodePoint::from(7454u32);
    pub const LATIN_SMALL_LETTER_SIDEWAYS_TURNED_M : CodePoint = CodePoint::from(7455u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_V : CodePoint = CodePoint::from(7456u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_W : CodePoint = CodePoint::from(7457u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_Z : CodePoint = CodePoint::from(7458u32);
    pub const LATIN_LETTER_SMALL_CAPITAL_EZH : CodePoint = CodePoint::from(7459u32);
    pub const LATIN_LETTER_VOICED_LARYNGEAL_SPIRANT : CodePoint = CodePoint::from(7460u32);
    pub const LATIN_LETTER_AIN : CodePoint = CodePoint::from(7461u32);
    pub const GREEK_LETTER_SMALL_CAPITAL_GAMMA : CodePoint = CodePoint::from(7462u32);
    pub const GREEK_LETTER_SMALL_CAPITAL_LAMDA : CodePoint = CodePoint::from(7463u32);
    pub const GREEK_LETTER_SMALL_CAPITAL_PI : CodePoint = CodePoint::from(7464u32);
    pub const GREEK_LETTER_SMALL_CAPITAL_RHO : CodePoint = CodePoint::from(7465u32);
    pub const GREEK_LETTER_SMALL_CAPITAL_PSI : CodePoint = CodePoint::from(7466u32);
    pub const CYRILLIC_LETTER_SMALL_CAPITAL_EL : CodePoint = CodePoint::from(7467u32);
    pub const MODIFIER_LETTER_CAPITAL_A : CodePoint = CodePoint::from(7468u32);
    pub const MODIFIER_LETTER_CAPITAL_AE : CodePoint = CodePoint::from(7469u32);
    pub const MODIFIER_LETTER_CAPITAL_B : CodePoint = CodePoint::from(7470u32);
    pub const MODIFIER_LETTER_CAPITAL_BARRED_B : CodePoint = CodePoint::from(7471u32);
    pub const MODIFIER_LETTER_CAPITAL_D : CodePoint = CodePoint::from(7472u32);
    pub const MODIFIER_LETTER_CAPITAL_E : CodePoint = CodePoint::from(7473u32);
    pub const MODIFIER_LETTER_CAPITAL_REVERSED_E : CodePoint = CodePoint::from(7474u32);
    pub const MODIFIER_LETTER_CAPITAL_G : CodePoint = CodePoint::from(7475u32);
    pub const MODIFIER_LETTER_CAPITAL_H : CodePoint = CodePoint::from(7476u32);
    pub const MODIFIER_LETTER_CAPITAL_I : CodePoint = CodePoint::from(7477u32);
    pub const MODIFIER_LETTER_CAPITAL_J : CodePoint = CodePoint::from(7478u32);
    pub const MODIFIER_LETTER_CAPITAL_K : CodePoint = CodePoint::from(7479u32);
    pub const MODIFIER_LETTER_CAPITAL_L : CodePoint = CodePoint::from(7480u32);
    pub const MODIFIER_LETTER_CAPITAL_M : CodePoint = CodePoint::from(7481u32);
    pub const MODIFIER_LETTER_CAPITAL_N : CodePoint = CodePoint::from(7482u32);
    pub const MODIFIER_LETTER_CAPITAL_REVERSED_N : CodePoint = CodePoint::from(7483u32);
    pub const MODIFIER_LETTER_CAPITAL_O : CodePoint = CodePoint::from(7484u32);
    pub const MODIFIER_LETTER_CAPITAL_OU : CodePoint = CodePoint::from(7485u32);
    pub const MODIFIER_LETTER_CAPITAL_P : CodePoint = CodePoint::from(7486u32);
    pub const MODIFIER_LETTER_CAPITAL_R : CodePoint = CodePoint::from(7487u32);
    pub const MODIFIER_LETTER_CAPITAL_T : CodePoint = CodePoint::from(7488u32);
    pub const MODIFIER_LETTER_CAPITAL_U : CodePoint = CodePoint::from(7489u32);
    pub const MODIFIER_LETTER_CAPITAL_W : CodePoint = CodePoint::from(7490u32);
    pub const MODIFIER_LETTER_SMALL_A : CodePoint = CodePoint::from(7491u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_A : CodePoint = CodePoint::from(7492u32);
    pub const MODIFIER_LETTER_SMALL_ALPHA : CodePoint = CodePoint::from(7493u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_AE : CodePoint = CodePoint::from(7494u32);
    pub const MODIFIER_LETTER_SMALL_B : CodePoint = CodePoint::from(7495u32);
    pub const MODIFIER_LETTER_SMALL_D : CodePoint = CodePoint::from(7496u32);
    pub const MODIFIER_LETTER_SMALL_E : CodePoint = CodePoint::from(7497u32);
    pub const MODIFIER_LETTER_SMALL_SCHWA : CodePoint = CodePoint::from(7498u32);
    pub const MODIFIER_LETTER_SMALL_OPEN_E : CodePoint = CodePoint::from(7499u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_OPEN_E : CodePoint = CodePoint::from(7500u32);
    pub const MODIFIER_LETTER_SMALL_G : CodePoint = CodePoint::from(7501u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_I : CodePoint = CodePoint::from(7502u32);
    pub const MODIFIER_LETTER_SMALL_K : CodePoint = CodePoint::from(7503u32);
    pub const MODIFIER_LETTER_SMALL_M : CodePoint = CodePoint::from(7504u32);
    pub const MODIFIER_LETTER_SMALL_ENG : CodePoint = CodePoint::from(7505u32);
    pub const MODIFIER_LETTER_SMALL_O : CodePoint = CodePoint::from(7506u32);
    pub const MODIFIER_LETTER_SMALL_OPEN_O : CodePoint = CodePoint::from(7507u32);
    pub const MODIFIER_LETTER_SMALL_TOP_HALF_O : CodePoint = CodePoint::from(7508u32);
    pub const MODIFIER_LETTER_SMALL_BOTTOM_HALF_O : CodePoint = CodePoint::from(7509u32);
    pub const MODIFIER_LETTER_SMALL_P : CodePoint = CodePoint::from(7510u32);
    pub const MODIFIER_LETTER_SMALL_T : CodePoint = CodePoint::from(7511u32);
    pub const MODIFIER_LETTER_SMALL_U : CodePoint = CodePoint::from(7512u32);
    pub const MODIFIER_LETTER_SMALL_SIDEWAYS_U : CodePoint = CodePoint::from(7513u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_M : CodePoint = CodePoint::from(7514u32);
    pub const MODIFIER_LETTER_SMALL_V : CodePoint = CodePoint::from(7515u32);
    pub const MODIFIER_LETTER_SMALL_AIN : CodePoint = CodePoint::from(7516u32);
    pub const MODIFIER_LETTER_SMALL_BETA : CodePoint = CodePoint::from(7517u32);
    pub const MODIFIER_LETTER_SMALL_GREEK_GAMMA : CodePoint = CodePoint::from(7518u32);
    pub const MODIFIER_LETTER_SMALL_DELTA : CodePoint = CodePoint::from(7519u32);
    pub const MODIFIER_LETTER_SMALL_GREEK_PHI : CodePoint = CodePoint::from(7520u32);
    pub const MODIFIER_LETTER_SMALL_CHI : CodePoint = CodePoint::from(7521u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_I : CodePoint = CodePoint::from(7522u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_R : CodePoint = CodePoint::from(7523u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_U : CodePoint = CodePoint::from(7524u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_V : CodePoint = CodePoint::from(7525u32);
    pub const GREEK_SUBSCRIPT_SMALL_LETTER_BETA : CodePoint = CodePoint::from(7526u32);
    pub const GREEK_SUBSCRIPT_SMALL_LETTER_GAMMA : CodePoint = CodePoint::from(7527u32);
    pub const GREEK_SUBSCRIPT_SMALL_LETTER_RHO : CodePoint = CodePoint::from(7528u32);
    pub const GREEK_SUBSCRIPT_SMALL_LETTER_PHI : CodePoint = CodePoint::from(7529u32);
    pub const GREEK_SUBSCRIPT_SMALL_LETTER_CHI : CodePoint = CodePoint::from(7530u32);
    pub const LATIN_SMALL_LETTER_UE : CodePoint = CodePoint::from(7531u32);
    pub const LATIN_SMALL_LETTER_B_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7532u32);
    pub const LATIN_SMALL_LETTER_D_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7533u32);
    pub const LATIN_SMALL_LETTER_F_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7534u32);
    pub const LATIN_SMALL_LETTER_M_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7535u32);
    pub const LATIN_SMALL_LETTER_N_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7536u32);
    pub const LATIN_SMALL_LETTER_P_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7537u32);
    pub const LATIN_SMALL_LETTER_R_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7538u32);
    pub const LATIN_SMALL_LETTER_R_WITH_FISHHOOK_AND_MIDDLE_TILDE : CodePoint = CodePoint::from(7539u32);
    pub const LATIN_SMALL_LETTER_S_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7540u32);
    pub const LATIN_SMALL_LETTER_T_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7541u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_MIDDLE_TILDE : CodePoint = CodePoint::from(7542u32);
    pub const LATIN_SMALL_LETTER_TURNED_G : CodePoint = CodePoint::from(7543u32);
    pub const MODIFIER_LETTER_CYRILLIC_EN : CodePoint = CodePoint::from(7544u32);
    pub const LATIN_SMALL_LETTER_INSULAR_G : CodePoint = CodePoint::from(7545u32);
    pub const LATIN_SMALL_LETTER_TH_WITH_STRIKETHROUGH : CodePoint = CodePoint::from(7546u32);
    pub const LATIN_SMALL_CAPITAL_LETTER_I_WITH_STROKE : CodePoint = CodePoint::from(7547u32);
    pub const LATIN_SMALL_LETTER_IOTA_WITH_STROKE : CodePoint = CodePoint::from(7548u32);
    pub const LATIN_SMALL_LETTER_P_WITH_STROKE : CodePoint = CodePoint::from(7549u32);
    pub const LATIN_SMALL_CAPITAL_LETTER_U_WITH_STROKE : CodePoint = CodePoint::from(7550u32);
    pub const LATIN_SMALL_LETTER_UPSILON_WITH_STROKE : CodePoint = CodePoint::from(7551u32);
    pub const LATIN_SMALL_LETTER_B_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7552u32);
    pub const LATIN_SMALL_LETTER_D_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7553u32);
    pub const LATIN_SMALL_LETTER_F_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7554u32);
    pub const LATIN_SMALL_LETTER_G_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7555u32);
    pub const LATIN_SMALL_LETTER_K_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7556u32);
    pub const LATIN_SMALL_LETTER_L_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7557u32);
    pub const LATIN_SMALL_LETTER_M_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7558u32);
    pub const LATIN_SMALL_LETTER_N_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7559u32);
    pub const LATIN_SMALL_LETTER_P_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7560u32);
    pub const LATIN_SMALL_LETTER_R_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7561u32);
    pub const LATIN_SMALL_LETTER_S_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7562u32);
    pub const LATIN_SMALL_LETTER_ESH_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7563u32);
    pub const LATIN_SMALL_LETTER_V_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7564u32);
    pub const LATIN_SMALL_LETTER_X_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7565u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7566u32);
    pub const LATIN_SMALL_LETTER_A_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7567u32);
    pub const LATIN_SMALL_LETTER_ALPHA_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7568u32);
    pub const LATIN_SMALL_LETTER_D_WITH_HOOK_AND_TAIL : CodePoint = CodePoint::from(7569u32);
    pub const LATIN_SMALL_LETTER_E_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7570u32);
    pub const LATIN_SMALL_LETTER_OPEN_E_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7571u32);
    pub const LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7572u32);
    pub const LATIN_SMALL_LETTER_SCHWA_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7573u32);
    pub const LATIN_SMALL_LETTER_I_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7574u32);
    pub const LATIN_SMALL_LETTER_OPEN_O_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7575u32);
    pub const LATIN_SMALL_LETTER_ESH_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7576u32);
    pub const LATIN_SMALL_LETTER_U_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7577u32);
    pub const LATIN_SMALL_LETTER_EZH_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7578u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_ALPHA : CodePoint = CodePoint::from(7579u32);
    pub const MODIFIER_LETTER_SMALL_C : CodePoint = CodePoint::from(7580u32);
    pub const MODIFIER_LETTER_SMALL_C_WITH_CURL : CodePoint = CodePoint::from(7581u32);
    pub const MODIFIER_LETTER_SMALL_ETH : CodePoint = CodePoint::from(7582u32);
    pub const MODIFIER_LETTER_SMALL_REVERSED_OPEN_E : CodePoint = CodePoint::from(7583u32);
    pub const MODIFIER_LETTER_SMALL_F : CodePoint = CodePoint::from(7584u32);
    pub const MODIFIER_LETTER_SMALL_DOTLESS_J_WITH_STROKE : CodePoint = CodePoint::from(7585u32);
    pub const MODIFIER_LETTER_SMALL_SCRIPT_G : CodePoint = CodePoint::from(7586u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_H : CodePoint = CodePoint::from(7587u32);
    pub const MODIFIER_LETTER_SMALL_I_WITH_STROKE : CodePoint = CodePoint::from(7588u32);
    pub const MODIFIER_LETTER_SMALL_IOTA : CodePoint = CodePoint::from(7589u32);
    pub const MODIFIER_LETTER_SMALL_CAPITAL_I : CodePoint = CodePoint::from(7590u32);
    pub const MODIFIER_LETTER_SMALL_CAPITAL_I_WITH_STROKE : CodePoint = CodePoint::from(7591u32);
    pub const MODIFIER_LETTER_SMALL_J_WITH_CROSSED_TAIL : CodePoint = CodePoint::from(7592u32);
    pub const MODIFIER_LETTER_SMALL_L_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7593u32);
    pub const MODIFIER_LETTER_SMALL_L_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7594u32);
    pub const MODIFIER_LETTER_SMALL_CAPITAL_L : CodePoint = CodePoint::from(7595u32);
    pub const MODIFIER_LETTER_SMALL_M_WITH_HOOK : CodePoint = CodePoint::from(7596u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_M_WITH_LONG_LEG : CodePoint = CodePoint::from(7597u32);
    pub const MODIFIER_LETTER_SMALL_N_WITH_LEFT_HOOK : CodePoint = CodePoint::from(7598u32);
    pub const MODIFIER_LETTER_SMALL_N_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7599u32);
    pub const MODIFIER_LETTER_SMALL_CAPITAL_N : CodePoint = CodePoint::from(7600u32);
    pub const MODIFIER_LETTER_SMALL_BARRED_O : CodePoint = CodePoint::from(7601u32);
    pub const MODIFIER_LETTER_SMALL_PHI : CodePoint = CodePoint::from(7602u32);
    pub const MODIFIER_LETTER_SMALL_S_WITH_HOOK : CodePoint = CodePoint::from(7603u32);
    pub const MODIFIER_LETTER_SMALL_ESH : CodePoint = CodePoint::from(7604u32);
    pub const MODIFIER_LETTER_SMALL_T_WITH_PALATAL_HOOK : CodePoint = CodePoint::from(7605u32);
    pub const MODIFIER_LETTER_SMALL_U_BAR : CodePoint = CodePoint::from(7606u32);
    pub const MODIFIER_LETTER_SMALL_UPSILON : CodePoint = CodePoint::from(7607u32);
    pub const MODIFIER_LETTER_SMALL_CAPITAL_U : CodePoint = CodePoint::from(7608u32);
    pub const MODIFIER_LETTER_SMALL_V_WITH_HOOK : CodePoint = CodePoint::from(7609u32);
    pub const MODIFIER_LETTER_SMALL_TURNED_V : CodePoint = CodePoint::from(7610u32);
    pub const MODIFIER_LETTER_SMALL_Z : CodePoint = CodePoint::from(7611u32);
    pub const MODIFIER_LETTER_SMALL_Z_WITH_RETROFLEX_HOOK : CodePoint = CodePoint::from(7612u32);
    pub const MODIFIER_LETTER_SMALL_Z_WITH_CURL : CodePoint = CodePoint::from(7613u32);
    pub const MODIFIER_LETTER_SMALL_EZH : CodePoint = CodePoint::from(7614u32);
    pub const MODIFIER_LETTER_SMALL_THETA : CodePoint = CodePoint::from(7615u32);
    pub const COMBINING_DOTTED_GRAVE_ACCENT : CodePoint = CodePoint::from(7616u32);
    pub const COMBINING_DOTTED_ACUTE_ACCENT : CodePoint = CodePoint::from(7617u32);
    pub const COMBINING_SNAKE_BELOW : CodePoint = CodePoint::from(7618u32);
    pub const COMBINING_SUSPENSION_MARK : CodePoint = CodePoint::from(7619u32);
    pub const COMBINING_MACRON_ACUTE : CodePoint = CodePoint::from(7620u32);
    pub const COMBINING_GRAVE_MACRON : CodePoint = CodePoint::from(7621u32);
    pub const COMBINING_MACRON_GRAVE : CodePoint = CodePoint::from(7622u32);
    pub const COMBINING_ACUTE_MACRON : CodePoint = CodePoint::from(7623u32);
    pub const COMBINING_GRAVE_ACUTE_GRAVE : CodePoint = CodePoint::from(7624u32);
    pub const COMBINING_ACUTE_GRAVE_ACUTE : CodePoint = CodePoint::from(7625u32);
    pub const COMBINING_LATIN_SMALL_LETTER_R_BELOW : CodePoint = CodePoint::from(7626u32);
    pub const COMBINING_BREVE_MACRON : CodePoint = CodePoint::from(7627u32);
    pub const COMBINING_MACRON_BREVE : CodePoint = CodePoint::from(7628u32);
    pub const COMBINING_DOUBLE_CIRCUMFLEX_ABOVE : CodePoint = CodePoint::from(7629u32);
    pub const COMBINING_OGONEK_ABOVE : CodePoint = CodePoint::from(7630u32);
    pub const COMBINING_ZIGZAG_BELOW : CodePoint = CodePoint::from(7631u32);
    pub const COMBINING_IS_BELOW : CodePoint = CodePoint::from(7632u32);
    pub const COMBINING_UR_ABOVE : CodePoint = CodePoint::from(7633u32);
    pub const COMBINING_US_ABOVE : CodePoint = CodePoint::from(7634u32);
    pub const COMBINING_LATIN_SMALL_LETTER_FLATTENED_OPEN_A_ABOVE : CodePoint = CodePoint::from(7635u32);
    pub const COMBINING_LATIN_SMALL_LETTER_AE : CodePoint = CodePoint::from(7636u32);
    pub const COMBINING_LATIN_SMALL_LETTER_AO : CodePoint = CodePoint::from(7637u32);
    pub const COMBINING_LATIN_SMALL_LETTER_AV : CodePoint = CodePoint::from(7638u32);
    pub const COMBINING_LATIN_SMALL_LETTER_C_CEDILLA : CodePoint = CodePoint::from(7639u32);
    pub const COMBINING_LATIN_SMALL_LETTER_INSULAR_D : CodePoint = CodePoint::from(7640u32);
    pub const COMBINING_LATIN_SMALL_LETTER_ETH : CodePoint = CodePoint::from(7641u32);
    pub const COMBINING_LATIN_SMALL_LETTER_G : CodePoint = CodePoint::from(7642u32);
    pub const COMBINING_LATIN_LETTER_SMALL_CAPITAL_G : CodePoint = CodePoint::from(7643u32);
    pub const COMBINING_LATIN_SMALL_LETTER_K : CodePoint = CodePoint::from(7644u32);
    pub const COMBINING_LATIN_SMALL_LETTER_L : CodePoint = CodePoint::from(7645u32);
    pub const COMBINING_LATIN_LETTER_SMALL_CAPITAL_L : CodePoint = CodePoint::from(7646u32);
    pub const COMBINING_LATIN_LETTER_SMALL_CAPITAL_M : CodePoint = CodePoint::from(7647u32);
    pub const COMBINING_LATIN_SMALL_LETTER_N : CodePoint = CodePoint::from(7648u32);
    pub const COMBINING_LATIN_LETTER_SMALL_CAPITAL_N : CodePoint = CodePoint::from(7649u32);
    pub const COMBINING_LATIN_LETTER_SMALL_CAPITAL_R : CodePoint = CodePoint::from(7650u32);
    pub const COMBINING_LATIN_SMALL_LETTER_R_ROTUNDA : CodePoint = CodePoint::from(7651u32);
    pub const COMBINING_LATIN_SMALL_LETTER_S : CodePoint = CodePoint::from(7652u32);
    pub const COMBINING_LATIN_SMALL_LETTER_LONG_S : CodePoint = CodePoint::from(7653u32);
    pub const COMBINING_LATIN_SMALL_LETTER_Z : CodePoint = CodePoint::from(7654u32);
    pub const COMBINING_LATIN_SMALL_LETTER_ALPHA : CodePoint = CodePoint::from(7655u32);
    pub const COMBINING_LATIN_SMALL_LETTER_B : CodePoint = CodePoint::from(7656u32);
    pub const COMBINING_LATIN_SMALL_LETTER_BETA : CodePoint = CodePoint::from(7657u32);
    pub const COMBINING_LATIN_SMALL_LETTER_SCHWA : CodePoint = CodePoint::from(7658u32);
    pub const COMBINING_LATIN_SMALL_LETTER_F : CodePoint = CodePoint::from(7659u32);
    pub const COMBINING_LATIN_SMALL_LETTER_L_WITH_DOUBLE_MIDDLE_TILDE : CodePoint = CodePoint::from(7660u32);
    pub const COMBINING_LATIN_SMALL_LETTER_O_WITH_LIGHT_CENTRALIZATION_STROKE : CodePoint = CodePoint::from(7661u32);
    pub const COMBINING_LATIN_SMALL_LETTER_P : CodePoint = CodePoint::from(7662u32);
    pub const COMBINING_LATIN_SMALL_LETTER_ESH : CodePoint = CodePoint::from(7663u32);
    pub const COMBINING_LATIN_SMALL_LETTER_U_WITH_LIGHT_CENTRALIZATION_STROKE : CodePoint = CodePoint::from(7664u32);
    pub const COMBINING_LATIN_SMALL_LETTER_W : CodePoint = CodePoint::from(7665u32);
    pub const COMBINING_LATIN_SMALL_LETTER_A_WITH_DIAERESIS : CodePoint = CodePoint::from(7666u32);
    pub const COMBINING_LATIN_SMALL_LETTER_O_WITH_DIAERESIS : CodePoint = CodePoint::from(7667u32);
    pub const COMBINING_LATIN_SMALL_LETTER_U_WITH_DIAERESIS : CodePoint = CodePoint::from(7668u32);
    pub const COMBINING_UP_TACK_ABOVE : CodePoint = CodePoint::from(7669u32);
    pub const COMBINING_KAVYKA_ABOVE_RIGHT : CodePoint = CodePoint::from(7670u32);
    pub const COMBINING_KAVYKA_ABOVE_LEFT : CodePoint = CodePoint::from(7671u32);
    pub const COMBINING_DOT_ABOVE_LEFT : CodePoint = CodePoint::from(7672u32);
    pub const COMBINING_WIDE_INVERTED_BRIDGE_BELOW : CodePoint = CodePoint::from(7673u32);
    pub const COMBINING_DELETION_MARK : CodePoint = CodePoint::from(7675u32);
    pub const COMBINING_DOUBLE_INVERTED_BREVE_BELOW : CodePoint = CodePoint::from(7676u32);
    pub const COMBINING_ALMOST_EQUAL_TO_BELOW : CodePoint = CodePoint::from(7677u32);
    pub const COMBINING_LEFT_ARROWHEAD_ABOVE : CodePoint = CodePoint::from(7678u32);
    pub const COMBINING_RIGHT_ARROWHEAD_AND_DOWN_ARROWHEAD_BELOW : CodePoint = CodePoint::from(7679u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_RING_BELOW : CodePoint = CodePoint::from(7680u32);
    pub const LATIN_SMALL_LETTER_A_WITH_RING_BELOW : CodePoint = CodePoint::from(7681u32);
    pub const LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7682u32);
    pub const LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7683u32);
    pub const LATIN_CAPITAL_LETTER_B_WITH_DOT_BELOW : CodePoint = CodePoint::from(7684u32);
    pub const LATIN_SMALL_LETTER_B_WITH_DOT_BELOW : CodePoint = CodePoint::from(7685u32);
    pub const LATIN_CAPITAL_LETTER_B_WITH_LINE_BELOW : CodePoint = CodePoint::from(7686u32);
    pub const LATIN_SMALL_LETTER_B_WITH_LINE_BELOW : CodePoint = CodePoint::from(7687u32);
    pub const LATIN_CAPITAL_LETTER_C_WITH_CEDILLA_AND_ACUTE : CodePoint = CodePoint::from(7688u32);
    pub const LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE : CodePoint = CodePoint::from(7689u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7690u32);
    pub const LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7691u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_DOT_BELOW : CodePoint = CodePoint::from(7692u32);
    pub const LATIN_SMALL_LETTER_D_WITH_DOT_BELOW : CodePoint = CodePoint::from(7693u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_LINE_BELOW : CodePoint = CodePoint::from(7694u32);
    pub const LATIN_SMALL_LETTER_D_WITH_LINE_BELOW : CodePoint = CodePoint::from(7695u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_CEDILLA : CodePoint = CodePoint::from(7696u32);
    pub const LATIN_SMALL_LETTER_D_WITH_CEDILLA : CodePoint = CodePoint::from(7697u32);
    pub const LATIN_CAPITAL_LETTER_D_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7698u32);
    pub const LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7699u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_GRAVE : CodePoint = CodePoint::from(7700u32);
    pub const LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE : CodePoint = CodePoint::from(7701u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_ACUTE : CodePoint = CodePoint::from(7702u32);
    pub const LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE : CodePoint = CodePoint::from(7703u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7704u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7705u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_TILDE_BELOW : CodePoint = CodePoint::from(7706u32);
    pub const LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW : CodePoint = CodePoint::from(7707u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CEDILLA_AND_BREVE : CodePoint = CodePoint::from(7708u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE : CodePoint = CodePoint::from(7709u32);
    pub const LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7710u32);
    pub const LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7711u32);
    pub const LATIN_CAPITAL_LETTER_G_WITH_MACRON : CodePoint = CodePoint::from(7712u32);
    pub const LATIN_SMALL_LETTER_G_WITH_MACRON : CodePoint = CodePoint::from(7713u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7714u32);
    pub const LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7715u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_DOT_BELOW : CodePoint = CodePoint::from(7716u32);
    pub const LATIN_SMALL_LETTER_H_WITH_DOT_BELOW : CodePoint = CodePoint::from(7717u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_DIAERESIS : CodePoint = CodePoint::from(7718u32);
    pub const LATIN_SMALL_LETTER_H_WITH_DIAERESIS : CodePoint = CodePoint::from(7719u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_CEDILLA : CodePoint = CodePoint::from(7720u32);
    pub const LATIN_SMALL_LETTER_H_WITH_CEDILLA : CodePoint = CodePoint::from(7721u32);
    pub const LATIN_CAPITAL_LETTER_H_WITH_BREVE_BELOW : CodePoint = CodePoint::from(7722u32);
    pub const LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW : CodePoint = CodePoint::from(7723u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_TILDE_BELOW : CodePoint = CodePoint::from(7724u32);
    pub const LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW : CodePoint = CodePoint::from(7725u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS_AND_ACUTE : CodePoint = CodePoint::from(7726u32);
    pub const LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE : CodePoint = CodePoint::from(7727u32);
    pub const LATIN_CAPITAL_LETTER_K_WITH_ACUTE : CodePoint = CodePoint::from(7728u32);
    pub const LATIN_SMALL_LETTER_K_WITH_ACUTE : CodePoint = CodePoint::from(7729u32);
    pub const LATIN_CAPITAL_LETTER_K_WITH_DOT_BELOW : CodePoint = CodePoint::from(7730u32);
    pub const LATIN_SMALL_LETTER_K_WITH_DOT_BELOW : CodePoint = CodePoint::from(7731u32);
    pub const LATIN_CAPITAL_LETTER_K_WITH_LINE_BELOW : CodePoint = CodePoint::from(7732u32);
    pub const LATIN_SMALL_LETTER_K_WITH_LINE_BELOW : CodePoint = CodePoint::from(7733u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW : CodePoint = CodePoint::from(7734u32);
    pub const LATIN_SMALL_LETTER_L_WITH_DOT_BELOW : CodePoint = CodePoint::from(7735u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW_AND_MACRON : CodePoint = CodePoint::from(7736u32);
    pub const LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON : CodePoint = CodePoint::from(7737u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_LINE_BELOW : CodePoint = CodePoint::from(7738u32);
    pub const LATIN_SMALL_LETTER_L_WITH_LINE_BELOW : CodePoint = CodePoint::from(7739u32);
    pub const LATIN_CAPITAL_LETTER_L_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7740u32);
    pub const LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7741u32);
    pub const LATIN_CAPITAL_LETTER_M_WITH_ACUTE : CodePoint = CodePoint::from(7742u32);
    pub const LATIN_SMALL_LETTER_M_WITH_ACUTE : CodePoint = CodePoint::from(7743u32);
    pub const LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7744u32);
    pub const LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7745u32);
    pub const LATIN_CAPITAL_LETTER_M_WITH_DOT_BELOW : CodePoint = CodePoint::from(7746u32);
    pub const LATIN_SMALL_LETTER_M_WITH_DOT_BELOW : CodePoint = CodePoint::from(7747u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7748u32);
    pub const LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7749u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_DOT_BELOW : CodePoint = CodePoint::from(7750u32);
    pub const LATIN_SMALL_LETTER_N_WITH_DOT_BELOW : CodePoint = CodePoint::from(7751u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_LINE_BELOW : CodePoint = CodePoint::from(7752u32);
    pub const LATIN_SMALL_LETTER_N_WITH_LINE_BELOW : CodePoint = CodePoint::from(7753u32);
    pub const LATIN_CAPITAL_LETTER_N_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7754u32);
    pub const LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7755u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_ACUTE : CodePoint = CodePoint::from(7756u32);
    pub const LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE : CodePoint = CodePoint::from(7757u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_DIAERESIS : CodePoint = CodePoint::from(7758u32);
    pub const LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS : CodePoint = CodePoint::from(7759u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_GRAVE : CodePoint = CodePoint::from(7760u32);
    pub const LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE : CodePoint = CodePoint::from(7761u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_ACUTE : CodePoint = CodePoint::from(7762u32);
    pub const LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE : CodePoint = CodePoint::from(7763u32);
    pub const LATIN_CAPITAL_LETTER_P_WITH_ACUTE : CodePoint = CodePoint::from(7764u32);
    pub const LATIN_SMALL_LETTER_P_WITH_ACUTE : CodePoint = CodePoint::from(7765u32);
    pub const LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7766u32);
    pub const LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7767u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7768u32);
    pub const LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7769u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW : CodePoint = CodePoint::from(7770u32);
    pub const LATIN_SMALL_LETTER_R_WITH_DOT_BELOW : CodePoint = CodePoint::from(7771u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW_AND_MACRON : CodePoint = CodePoint::from(7772u32);
    pub const LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON : CodePoint = CodePoint::from(7773u32);
    pub const LATIN_CAPITAL_LETTER_R_WITH_LINE_BELOW : CodePoint = CodePoint::from(7774u32);
    pub const LATIN_SMALL_LETTER_R_WITH_LINE_BELOW : CodePoint = CodePoint::from(7775u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7776u32);
    pub const LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7777u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW : CodePoint = CodePoint::from(7778u32);
    pub const LATIN_SMALL_LETTER_S_WITH_DOT_BELOW : CodePoint = CodePoint::from(7779u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE : CodePoint = CodePoint::from(7780u32);
    pub const LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE : CodePoint = CodePoint::from(7781u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_CARON_AND_DOT_ABOVE : CodePoint = CodePoint::from(7782u32);
    pub const LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE : CodePoint = CodePoint::from(7783u32);
    pub const LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE : CodePoint = CodePoint::from(7784u32);
    pub const LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE : CodePoint = CodePoint::from(7785u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7786u32);
    pub const LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7787u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_DOT_BELOW : CodePoint = CodePoint::from(7788u32);
    pub const LATIN_SMALL_LETTER_T_WITH_DOT_BELOW : CodePoint = CodePoint::from(7789u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_LINE_BELOW : CodePoint = CodePoint::from(7790u32);
    pub const LATIN_SMALL_LETTER_T_WITH_LINE_BELOW : CodePoint = CodePoint::from(7791u32);
    pub const LATIN_CAPITAL_LETTER_T_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7792u32);
    pub const LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7793u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_BELOW : CodePoint = CodePoint::from(7794u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW : CodePoint = CodePoint::from(7795u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_TILDE_BELOW : CodePoint = CodePoint::from(7796u32);
    pub const LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW : CodePoint = CodePoint::from(7797u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7798u32);
    pub const LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW : CodePoint = CodePoint::from(7799u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_TILDE_AND_ACUTE : CodePoint = CodePoint::from(7800u32);
    pub const LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE : CodePoint = CodePoint::from(7801u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_MACRON_AND_DIAERESIS : CodePoint = CodePoint::from(7802u32);
    pub const LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS : CodePoint = CodePoint::from(7803u32);
    pub const LATIN_CAPITAL_LETTER_V_WITH_TILDE : CodePoint = CodePoint::from(7804u32);
    pub const LATIN_SMALL_LETTER_V_WITH_TILDE : CodePoint = CodePoint::from(7805u32);
    pub const LATIN_CAPITAL_LETTER_V_WITH_DOT_BELOW : CodePoint = CodePoint::from(7806u32);
    pub const LATIN_SMALL_LETTER_V_WITH_DOT_BELOW : CodePoint = CodePoint::from(7807u32);
    pub const LATIN_CAPITAL_LETTER_W_WITH_GRAVE : CodePoint = CodePoint::from(7808u32);
    pub const LATIN_SMALL_LETTER_W_WITH_GRAVE : CodePoint = CodePoint::from(7809u32);
    pub const LATIN_CAPITAL_LETTER_W_WITH_ACUTE : CodePoint = CodePoint::from(7810u32);
    pub const LATIN_SMALL_LETTER_W_WITH_ACUTE : CodePoint = CodePoint::from(7811u32);
    pub const LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS : CodePoint = CodePoint::from(7812u32);
    pub const LATIN_SMALL_LETTER_W_WITH_DIAERESIS : CodePoint = CodePoint::from(7813u32);
    pub const LATIN_CAPITAL_LETTER_W_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7814u32);
    pub const LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7815u32);
    pub const LATIN_CAPITAL_LETTER_W_WITH_DOT_BELOW : CodePoint = CodePoint::from(7816u32);
    pub const LATIN_SMALL_LETTER_W_WITH_DOT_BELOW : CodePoint = CodePoint::from(7817u32);
    pub const LATIN_CAPITAL_LETTER_X_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7818u32);
    pub const LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7819u32);
    pub const LATIN_CAPITAL_LETTER_X_WITH_DIAERESIS : CodePoint = CodePoint::from(7820u32);
    pub const LATIN_SMALL_LETTER_X_WITH_DIAERESIS : CodePoint = CodePoint::from(7821u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7822u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7823u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(7824u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX : CodePoint = CodePoint::from(7825u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_DOT_BELOW : CodePoint = CodePoint::from(7826u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW : CodePoint = CodePoint::from(7827u32);
    pub const LATIN_CAPITAL_LETTER_Z_WITH_LINE_BELOW : CodePoint = CodePoint::from(7828u32);
    pub const LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW : CodePoint = CodePoint::from(7829u32);
    pub const LATIN_SMALL_LETTER_H_WITH_LINE_BELOW : CodePoint = CodePoint::from(7830u32);
    pub const LATIN_SMALL_LETTER_T_WITH_DIAERESIS : CodePoint = CodePoint::from(7831u32);
    pub const LATIN_SMALL_LETTER_W_WITH_RING_ABOVE : CodePoint = CodePoint::from(7832u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE : CodePoint = CodePoint::from(7833u32);
    pub const LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING : CodePoint = CodePoint::from(7834u32);
    pub const LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE : CodePoint = CodePoint::from(7835u32);
    pub const LATIN_SMALL_LETTER_LONG_S_WITH_DIAGONAL_STROKE : CodePoint = CodePoint::from(7836u32);
    pub const LATIN_SMALL_LETTER_LONG_S_WITH_HIGH_STROKE : CodePoint = CodePoint::from(7837u32);
    pub const LATIN_CAPITAL_LETTER_SHARP_S : CodePoint = CodePoint::from(7838u32);
    pub const LATIN_SMALL_LETTER_DELTA : CodePoint = CodePoint::from(7839u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_DOT_BELOW : CodePoint = CodePoint::from(7840u32);
    pub const LATIN_SMALL_LETTER_A_WITH_DOT_BELOW : CodePoint = CodePoint::from(7841u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7842u32);
    pub const LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7843u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE : CodePoint = CodePoint::from(7844u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE : CodePoint = CodePoint::from(7845u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE : CodePoint = CodePoint::from(7846u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE : CodePoint = CodePoint::from(7847u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7848u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7849u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE : CodePoint = CodePoint::from(7850u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE : CodePoint = CodePoint::from(7851u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW : CodePoint = CodePoint::from(7852u32);
    pub const LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW : CodePoint = CodePoint::from(7853u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_ACUTE : CodePoint = CodePoint::from(7854u32);
    pub const LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE : CodePoint = CodePoint::from(7855u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_GRAVE : CodePoint = CodePoint::from(7856u32);
    pub const LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE : CodePoint = CodePoint::from(7857u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7858u32);
    pub const LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7859u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_TILDE : CodePoint = CodePoint::from(7860u32);
    pub const LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE : CodePoint = CodePoint::from(7861u32);
    pub const LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_DOT_BELOW : CodePoint = CodePoint::from(7862u32);
    pub const LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW : CodePoint = CodePoint::from(7863u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_DOT_BELOW : CodePoint = CodePoint::from(7864u32);
    pub const LATIN_SMALL_LETTER_E_WITH_DOT_BELOW : CodePoint = CodePoint::from(7865u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7866u32);
    pub const LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7867u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_TILDE : CodePoint = CodePoint::from(7868u32);
    pub const LATIN_SMALL_LETTER_E_WITH_TILDE : CodePoint = CodePoint::from(7869u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE : CodePoint = CodePoint::from(7870u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE : CodePoint = CodePoint::from(7871u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE : CodePoint = CodePoint::from(7872u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE : CodePoint = CodePoint::from(7873u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7874u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7875u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE : CodePoint = CodePoint::from(7876u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE : CodePoint = CodePoint::from(7877u32);
    pub const LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW : CodePoint = CodePoint::from(7878u32);
    pub const LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW : CodePoint = CodePoint::from(7879u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7880u32);
    pub const LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7881u32);
    pub const LATIN_CAPITAL_LETTER_I_WITH_DOT_BELOW : CodePoint = CodePoint::from(7882u32);
    pub const LATIN_SMALL_LETTER_I_WITH_DOT_BELOW : CodePoint = CodePoint::from(7883u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_DOT_BELOW : CodePoint = CodePoint::from(7884u32);
    pub const LATIN_SMALL_LETTER_O_WITH_DOT_BELOW : CodePoint = CodePoint::from(7885u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7886u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7887u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE : CodePoint = CodePoint::from(7888u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE : CodePoint = CodePoint::from(7889u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE : CodePoint = CodePoint::from(7890u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE : CodePoint = CodePoint::from(7891u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7892u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7893u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE : CodePoint = CodePoint::from(7894u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE : CodePoint = CodePoint::from(7895u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW : CodePoint = CodePoint::from(7896u32);
    pub const LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW : CodePoint = CodePoint::from(7897u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_ACUTE : CodePoint = CodePoint::from(7898u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE : CodePoint = CodePoint::from(7899u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_GRAVE : CodePoint = CodePoint::from(7900u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE : CodePoint = CodePoint::from(7901u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7902u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7903u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_TILDE : CodePoint = CodePoint::from(7904u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE : CodePoint = CodePoint::from(7905u32);
    pub const LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_DOT_BELOW : CodePoint = CodePoint::from(7906u32);
    pub const LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW : CodePoint = CodePoint::from(7907u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_DOT_BELOW : CodePoint = CodePoint::from(7908u32);
    pub const LATIN_SMALL_LETTER_U_WITH_DOT_BELOW : CodePoint = CodePoint::from(7909u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7910u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7911u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_ACUTE : CodePoint = CodePoint::from(7912u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE : CodePoint = CodePoint::from(7913u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_GRAVE : CodePoint = CodePoint::from(7914u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE : CodePoint = CodePoint::from(7915u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7916u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE : CodePoint = CodePoint::from(7917u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_TILDE : CodePoint = CodePoint::from(7918u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE : CodePoint = CodePoint::from(7919u32);
    pub const LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_DOT_BELOW : CodePoint = CodePoint::from(7920u32);
    pub const LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW : CodePoint = CodePoint::from(7921u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_GRAVE : CodePoint = CodePoint::from(7922u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_GRAVE : CodePoint = CodePoint::from(7923u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_DOT_BELOW : CodePoint = CodePoint::from(7924u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW : CodePoint = CodePoint::from(7925u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7926u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE : CodePoint = CodePoint::from(7927u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_TILDE : CodePoint = CodePoint::from(7928u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_TILDE : CodePoint = CodePoint::from(7929u32);
    pub const LATIN_CAPITAL_LETTER_MIDDLE_WELSH_LL : CodePoint = CodePoint::from(7930u32);
    pub const LATIN_SMALL_LETTER_MIDDLE_WELSH_LL : CodePoint = CodePoint::from(7931u32);
    pub const LATIN_CAPITAL_LETTER_MIDDLE_WELSH_V : CodePoint = CodePoint::from(7932u32);
    pub const LATIN_SMALL_LETTER_MIDDLE_WELSH_V : CodePoint = CodePoint::from(7933u32);
    pub const LATIN_CAPITAL_LETTER_Y_WITH_LOOP : CodePoint = CodePoint::from(7934u32);
    pub const LATIN_SMALL_LETTER_Y_WITH_LOOP : CodePoint = CodePoint::from(7935u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI : CodePoint = CodePoint::from(7936u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA : CodePoint = CodePoint::from(7937u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7938u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7939u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7940u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7941u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(7942u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(7943u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI : CodePoint = CodePoint::from(7944u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA : CodePoint = CodePoint::from(7945u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7946u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7947u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7948u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7949u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(7950u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(7951u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_PSILI : CodePoint = CodePoint::from(7952u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_DASIA : CodePoint = CodePoint::from(7953u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7954u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7955u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7956u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7957u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI : CodePoint = CodePoint::from(7960u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA : CodePoint = CodePoint::from(7961u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7962u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7963u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7964u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7965u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI : CodePoint = CodePoint::from(7968u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA : CodePoint = CodePoint::from(7969u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7970u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7971u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7972u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7973u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(7974u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(7975u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI : CodePoint = CodePoint::from(7976u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA : CodePoint = CodePoint::from(7977u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7978u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7979u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7980u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7981u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(7982u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(7983u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_PSILI : CodePoint = CodePoint::from(7984u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DASIA : CodePoint = CodePoint::from(7985u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7986u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7987u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7988u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7989u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(7990u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(7991u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI : CodePoint = CodePoint::from(7992u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA : CodePoint = CodePoint::from(7993u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(7994u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(7995u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(7996u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(7997u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(7998u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(7999u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_PSILI : CodePoint = CodePoint::from(8000u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_DASIA : CodePoint = CodePoint::from(8001u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(8002u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(8003u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(8004u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(8005u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI : CodePoint = CodePoint::from(8008u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA : CodePoint = CodePoint::from(8009u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(8010u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(8011u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(8012u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(8013u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_PSILI : CodePoint = CodePoint::from(8016u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DASIA : CodePoint = CodePoint::from(8017u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(8018u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(8019u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(8020u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(8021u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(8022u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(8023u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA : CodePoint = CodePoint::from(8025u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(8027u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(8029u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(8031u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI : CodePoint = CodePoint::from(8032u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA : CodePoint = CodePoint::from(8033u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(8034u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(8035u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(8036u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(8037u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(8038u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(8039u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI : CodePoint = CodePoint::from(8040u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA : CodePoint = CodePoint::from(8041u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA : CodePoint = CodePoint::from(8042u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA : CodePoint = CodePoint::from(8043u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA : CodePoint = CodePoint::from(8044u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA : CodePoint = CodePoint::from(8045u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(8046u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(8047u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_VARIA : CodePoint = CodePoint::from(8048u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_OXIA : CodePoint = CodePoint::from(8049u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_VARIA : CodePoint = CodePoint::from(8050u32);
    pub const GREEK_SMALL_LETTER_EPSILON_WITH_OXIA : CodePoint = CodePoint::from(8051u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_VARIA : CodePoint = CodePoint::from(8052u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_OXIA : CodePoint = CodePoint::from(8053u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_VARIA : CodePoint = CodePoint::from(8054u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_OXIA : CodePoint = CodePoint::from(8055u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_VARIA : CodePoint = CodePoint::from(8056u32);
    pub const GREEK_SMALL_LETTER_OMICRON_WITH_OXIA : CodePoint = CodePoint::from(8057u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_VARIA : CodePoint = CodePoint::from(8058u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_OXIA : CodePoint = CodePoint::from(8059u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_VARIA : CodePoint = CodePoint::from(8060u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_OXIA : CodePoint = CodePoint::from(8061u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8064u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8065u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8066u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8067u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8068u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8069u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8070u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8071u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8072u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8073u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8074u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8075u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8076u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8077u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8078u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8079u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8080u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8081u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8082u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8083u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8084u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8085u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8086u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8087u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8088u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8089u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8090u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8091u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8092u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8093u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8094u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8095u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8096u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8097u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8098u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8099u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8100u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8101u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8102u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8103u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8104u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8105u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8106u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8107u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8108u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8109u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8110u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI : CodePoint = CodePoint::from(8111u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_VRACHY : CodePoint = CodePoint::from(8112u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_MACRON : CodePoint = CodePoint::from(8113u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8114u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_YPOGEGRAMMENI : CodePoint = CodePoint::from(8115u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8116u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI : CodePoint = CodePoint::from(8118u32);
    pub const GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8119u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_VRACHY : CodePoint = CodePoint::from(8120u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_MACRON : CodePoint = CodePoint::from(8121u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA : CodePoint = CodePoint::from(8122u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA : CodePoint = CodePoint::from(8123u32);
    pub const GREEK_CAPITAL_LETTER_ALPHA_WITH_PROSGEGRAMMENI : CodePoint = CodePoint::from(8124u32);
    pub const GREEK_KORONIS : CodePoint = CodePoint::from(8125u32);
    pub const GREEK_PROSGEGRAMMENI : CodePoint = CodePoint::from(8126u32);
    pub const GREEK_PSILI : CodePoint = CodePoint::from(8127u32);
    pub const GREEK_PERISPOMENI : CodePoint = CodePoint::from(8128u32);
    pub const GREEK_DIALYTIKA_AND_PERISPOMENI : CodePoint = CodePoint::from(8129u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8130u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_YPOGEGRAMMENI : CodePoint = CodePoint::from(8131u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8132u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI : CodePoint = CodePoint::from(8134u32);
    pub const GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8135u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_VARIA : CodePoint = CodePoint::from(8136u32);
    pub const GREEK_CAPITAL_LETTER_EPSILON_WITH_OXIA : CodePoint = CodePoint::from(8137u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_VARIA : CodePoint = CodePoint::from(8138u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_OXIA : CodePoint = CodePoint::from(8139u32);
    pub const GREEK_CAPITAL_LETTER_ETA_WITH_PROSGEGRAMMENI : CodePoint = CodePoint::from(8140u32);
    pub const GREEK_PSILI_AND_VARIA : CodePoint = CodePoint::from(8141u32);
    pub const GREEK_PSILI_AND_OXIA : CodePoint = CodePoint::from(8142u32);
    pub const GREEK_PSILI_AND_PERISPOMENI : CodePoint = CodePoint::from(8143u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_VRACHY : CodePoint = CodePoint::from(8144u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_MACRON : CodePoint = CodePoint::from(8145u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_VARIA : CodePoint = CodePoint::from(8146u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_OXIA : CodePoint = CodePoint::from(8147u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_PERISPOMENI : CodePoint = CodePoint::from(8150u32);
    pub const GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_PERISPOMENI : CodePoint = CodePoint::from(8151u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_VRACHY : CodePoint = CodePoint::from(8152u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_MACRON : CodePoint = CodePoint::from(8153u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_VARIA : CodePoint = CodePoint::from(8154u32);
    pub const GREEK_CAPITAL_LETTER_IOTA_WITH_OXIA : CodePoint = CodePoint::from(8155u32);
    pub const GREEK_DASIA_AND_VARIA : CodePoint = CodePoint::from(8157u32);
    pub const GREEK_DASIA_AND_OXIA : CodePoint = CodePoint::from(8158u32);
    pub const GREEK_DASIA_AND_PERISPOMENI : CodePoint = CodePoint::from(8159u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_VRACHY : CodePoint = CodePoint::from(8160u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_MACRON : CodePoint = CodePoint::from(8161u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_VARIA : CodePoint = CodePoint::from(8162u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_OXIA : CodePoint = CodePoint::from(8163u32);
    pub const GREEK_SMALL_LETTER_RHO_WITH_PSILI : CodePoint = CodePoint::from(8164u32);
    pub const GREEK_SMALL_LETTER_RHO_WITH_DASIA : CodePoint = CodePoint::from(8165u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_PERISPOMENI : CodePoint = CodePoint::from(8166u32);
    pub const GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_PERISPOMENI : CodePoint = CodePoint::from(8167u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_VRACHY : CodePoint = CodePoint::from(8168u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_MACRON : CodePoint = CodePoint::from(8169u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_VARIA : CodePoint = CodePoint::from(8170u32);
    pub const GREEK_CAPITAL_LETTER_UPSILON_WITH_OXIA : CodePoint = CodePoint::from(8171u32);
    pub const GREEK_CAPITAL_LETTER_RHO_WITH_DASIA : CodePoint = CodePoint::from(8172u32);
    pub const GREEK_DIALYTIKA_AND_VARIA : CodePoint = CodePoint::from(8173u32);
    pub const GREEK_DIALYTIKA_AND_OXIA : CodePoint = CodePoint::from(8174u32);
    pub const GREEK_VARIA : CodePoint = CodePoint::from(8175u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_VARIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8178u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_YPOGEGRAMMENI : CodePoint = CodePoint::from(8179u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_OXIA_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8180u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI : CodePoint = CodePoint::from(8182u32);
    pub const GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI : CodePoint = CodePoint::from(8183u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_VARIA : CodePoint = CodePoint::from(8184u32);
    pub const GREEK_CAPITAL_LETTER_OMICRON_WITH_OXIA : CodePoint = CodePoint::from(8185u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA : CodePoint = CodePoint::from(8186u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA : CodePoint = CodePoint::from(8187u32);
    pub const GREEK_CAPITAL_LETTER_OMEGA_WITH_PROSGEGRAMMENI : CodePoint = CodePoint::from(8188u32);
    pub const GREEK_OXIA : CodePoint = CodePoint::from(8189u32);
    pub const GREEK_DASIA : CodePoint = CodePoint::from(8190u32);
    pub const EN_QUAD : CodePoint = CodePoint::from(8192u32);
    pub const EM_QUAD : CodePoint = CodePoint::from(8193u32);
    pub const EN_SPACE : CodePoint = CodePoint::from(8194u32);
    pub const EM_SPACE : CodePoint = CodePoint::from(8195u32);
    pub const THREE_PER_EM_SPACE : CodePoint = CodePoint::from(8196u32);
    pub const FOUR_PER_EM_SPACE : CodePoint = CodePoint::from(8197u32);
    pub const SIX_PER_EM_SPACE : CodePoint = CodePoint::from(8198u32);
    pub const FIGURE_SPACE : CodePoint = CodePoint::from(8199u32);
    pub const PUNCTUATION_SPACE : CodePoint = CodePoint::from(8200u32);
    pub const THIN_SPACE : CodePoint = CodePoint::from(8201u32);
    pub const HAIR_SPACE : CodePoint = CodePoint::from(8202u32);
    pub const ZERO_WIDTH_SPACE : CodePoint = CodePoint::from(8203u32);
    pub const ZERO_WIDTH_NON_JOINER : CodePoint = CodePoint::from(8204u32);
    pub const ZERO_WIDTH_JOINER : CodePoint = CodePoint::from(8205u32);
    pub const LEFT_TO_RIGHT_MARK : CodePoint = CodePoint::from(8206u32);
    pub const RIGHT_TO_LEFT_MARK : CodePoint = CodePoint::from(8207u32);
    pub const HYPHEN : CodePoint = CodePoint::from(8208u32);
    pub const NON_BREAKING_HYPHEN : CodePoint = CodePoint::from(8209u32);
    pub const FIGURE_DASH : CodePoint = CodePoint::from(8210u32);
    pub const EN_DASH : CodePoint = CodePoint::from(8211u32);
    pub const EM_DASH : CodePoint = CodePoint::from(8212u32);
    pub const HORIZONTAL_BAR : CodePoint = CodePoint::from(8213u32);
    pub const DOUBLE_VERTICAL_LINE : CodePoint = CodePoint::from(8214u32);
    pub const DOUBLE_LOW_LINE : CodePoint = CodePoint::from(8215u32);
    pub const LEFT_SINGLE_QUOTATION_MARK : CodePoint = CodePoint::from(8216u32);
    pub const RIGHT_SINGLE_QUOTATION_MARK : CodePoint = CodePoint::from(8217u32);
    pub const SINGLE_LOW_9_QUOTATION_MARK : CodePoint = CodePoint::from(8218u32);
    pub const SINGLE_HIGH_REVERSED_9_QUOTATION_MARK : CodePoint = CodePoint::from(8219u32);
    pub const LEFT_DOUBLE_QUOTATION_MARK : CodePoint = CodePoint::from(8220u32);
    pub const RIGHT_DOUBLE_QUOTATION_MARK : CodePoint = CodePoint::from(8221u32);
    pub const DOUBLE_LOW_9_QUOTATION_MARK : CodePoint = CodePoint::from(8222u32);
    pub const DOUBLE_HIGH_REVERSED_9_QUOTATION_MARK : CodePoint = CodePoint::from(8223u32);
    pub const DAGGER : CodePoint = CodePoint::from(8224u32);
    pub const DOUBLE_DAGGER : CodePoint = CodePoint::from(8225u32);
    pub const BULLET : CodePoint = CodePoint::from(8226u32);
    pub const TRIANGULAR_BULLET : CodePoint = CodePoint::from(8227u32);
    pub const ONE_DOT_LEADER : CodePoint = CodePoint::from(8228u32);
    pub const TWO_DOT_LEADER : CodePoint = CodePoint::from(8229u32);
    pub const HORIZONTAL_ELLIPSIS : CodePoint = CodePoint::from(8230u32);
    pub const HYPHENATION_POINT : CodePoint = CodePoint::from(8231u32);
    pub const LINE_SEPARATOR : CodePoint = CodePoint::from(8232u32);
    pub const PARAGRAPH_SEPARATOR : CodePoint = CodePoint::from(8233u32);
    pub const LEFT_TO_RIGHT_EMBEDDING : CodePoint = CodePoint::from(8234u32);
    pub const RIGHT_TO_LEFT_EMBEDDING : CodePoint = CodePoint::from(8235u32);
    pub const POP_DIRECTIONAL_FORMATTING : CodePoint = CodePoint::from(8236u32);
    pub const LEFT_TO_RIGHT_OVERRIDE : CodePoint = CodePoint::from(8237u32);
    pub const RIGHT_TO_LEFT_OVERRIDE : CodePoint = CodePoint::from(8238u32);
    pub const NARROW_NO_BREAK_SPACE : CodePoint = CodePoint::from(8239u32);
    pub const PER_MILLE_SIGN : CodePoint = CodePoint::from(8240u32);
    pub const PER_TEN_THOUSAND_SIGN : CodePoint = CodePoint::from(8241u32);
    pub const PRIME : CodePoint = CodePoint::from(8242u32);
    pub const DOUBLE_PRIME : CodePoint = CodePoint::from(8243u32);
    pub const TRIPLE_PRIME : CodePoint = CodePoint::from(8244u32);
    pub const REVERSED_PRIME : CodePoint = CodePoint::from(8245u32);
    pub const REVERSED_DOUBLE_PRIME : CodePoint = CodePoint::from(8246u32);
    pub const REVERSED_TRIPLE_PRIME : CodePoint = CodePoint::from(8247u32);
    pub const CARET : CodePoint = CodePoint::from(8248u32);
    pub const SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK : CodePoint = CodePoint::from(8249u32);
    pub const SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK : CodePoint = CodePoint::from(8250u32);
    pub const REFERENCE_MARK : CodePoint = CodePoint::from(8251u32);
    pub const DOUBLE_EXCLAMATION_MARK : CodePoint = CodePoint::from(8252u32);
    pub const INTERROBANG : CodePoint = CodePoint::from(8253u32);
    pub const OVERLINE : CodePoint = CodePoint::from(8254u32);
    pub const UNDERTIE : CodePoint = CodePoint::from(8255u32);
    pub const CHARACTER_TIE : CodePoint = CodePoint::from(8256u32);
    pub const CARET_INSERTION_POINT : CodePoint = CodePoint::from(8257u32);
    pub const ASTERISM : CodePoint = CodePoint::from(8258u32);
    pub const HYPHEN_BULLET : CodePoint = CodePoint::from(8259u32);
    pub const FRACTION_SLASH : CodePoint = CodePoint::from(8260u32);
    pub const LEFT_SQUARE_BRACKET_WITH_QUILL : CodePoint = CodePoint::from(8261u32);
    pub const RIGHT_SQUARE_BRACKET_WITH_QUILL : CodePoint = CodePoint::from(8262u32);
    pub const DOUBLE_QUESTION_MARK : CodePoint = CodePoint::from(8263u32);
    pub const QUESTION_EXCLAMATION_MARK : CodePoint = CodePoint::from(8264u32);
    pub const EXCLAMATION_QUESTION_MARK : CodePoint = CodePoint::from(8265u32);
    pub const TIRONIAN_SIGN_ET : CodePoint = CodePoint::from(8266u32);
    pub const REVERSED_PILCROW_SIGN : CodePoint = CodePoint::from(8267u32);
    pub const BLACK_LEFTWARDS_BULLET : CodePoint = CodePoint::from(8268u32);
    pub const BLACK_RIGHTWARDS_BULLET : CodePoint = CodePoint::from(8269u32);
    pub const LOW_ASTERISK : CodePoint = CodePoint::from(8270u32);
    pub const REVERSED_SEMICOLON : CodePoint = CodePoint::from(8271u32);
    pub const CLOSE_UP : CodePoint = CodePoint::from(8272u32);
    pub const TWO_ASTERISKS_ALIGNED_VERTICALLY : CodePoint = CodePoint::from(8273u32);
    pub const COMMERCIAL_MINUS_SIGN : CodePoint = CodePoint::from(8274u32);
    pub const SWUNG_DASH : CodePoint = CodePoint::from(8275u32);
    pub const INVERTED_UNDERTIE : CodePoint = CodePoint::from(8276u32);
    pub const FLOWER_PUNCTUATION_MARK : CodePoint = CodePoint::from(8277u32);
    pub const THREE_DOT_PUNCTUATION : CodePoint = CodePoint::from(8278u32);
    pub const QUADRUPLE_PRIME : CodePoint = CodePoint::from(8279u32);
    pub const FOUR_DOT_PUNCTUATION : CodePoint = CodePoint::from(8280u32);
    pub const FIVE_DOT_PUNCTUATION : CodePoint = CodePoint::from(8281u32);
    pub const TWO_DOT_PUNCTUATION : CodePoint = CodePoint::from(8282u32);
    pub const FOUR_DOT_MARK : CodePoint = CodePoint::from(8283u32);
    pub const DOTTED_CROSS : CodePoint = CodePoint::from(8284u32);
    pub const TRICOLON : CodePoint = CodePoint::from(8285u32);
    pub const VERTICAL_FOUR_DOTS : CodePoint = CodePoint::from(8286u32);
    pub const MEDIUM_MATHEMATICAL_SPACE : CodePoint = CodePoint::from(8287u32);
    pub const WORD_JOINER : CodePoint = CodePoint::from(8288u32);
    pub const FUNCTION_APPLICATION : CodePoint = CodePoint::from(8289u32);
    pub const INVISIBLE_TIMES : CodePoint = CodePoint::from(8290u32);
    pub const INVISIBLE_SEPARATOR : CodePoint = CodePoint::from(8291u32);
    pub const INVISIBLE_PLUS : CodePoint = CodePoint::from(8292u32);
    pub const LEFT_TO_RIGHT_ISOLATE : CodePoint = CodePoint::from(8294u32);
    pub const RIGHT_TO_LEFT_ISOLATE : CodePoint = CodePoint::from(8295u32);
    pub const FIRST_STRONG_ISOLATE : CodePoint = CodePoint::from(8296u32);
    pub const POP_DIRECTIONAL_ISOLATE : CodePoint = CodePoint::from(8297u32);
    pub const INHIBIT_SYMMETRIC_SWAPPING : CodePoint = CodePoint::from(8298u32);
    pub const ACTIVATE_SYMMETRIC_SWAPPING : CodePoint = CodePoint::from(8299u32);
    pub const INHIBIT_ARABIC_FORM_SHAPING : CodePoint = CodePoint::from(8300u32);
    pub const ACTIVATE_ARABIC_FORM_SHAPING : CodePoint = CodePoint::from(8301u32);
    pub const NATIONAL_DIGIT_SHAPES : CodePoint = CodePoint::from(8302u32);
    pub const NOMINAL_DIGIT_SHAPES : CodePoint = CodePoint::from(8303u32);
    pub const SUPERSCRIPT_ZERO : CodePoint = CodePoint::from(8304u32);
    pub const SUPERSCRIPT_LATIN_SMALL_LETTER_I : CodePoint = CodePoint::from(8305u32);
    pub const SUPERSCRIPT_FOUR : CodePoint = CodePoint::from(8308u32);
    pub const SUPERSCRIPT_FIVE : CodePoint = CodePoint::from(8309u32);
    pub const SUPERSCRIPT_SIX : CodePoint = CodePoint::from(8310u32);
    pub const SUPERSCRIPT_SEVEN : CodePoint = CodePoint::from(8311u32);
    pub const SUPERSCRIPT_EIGHT : CodePoint = CodePoint::from(8312u32);
    pub const SUPERSCRIPT_NINE : CodePoint = CodePoint::from(8313u32);
    pub const SUPERSCRIPT_PLUS_SIGN : CodePoint = CodePoint::from(8314u32);
    pub const SUPERSCRIPT_MINUS : CodePoint = CodePoint::from(8315u32);
    pub const SUPERSCRIPT_EQUALS_SIGN : CodePoint = CodePoint::from(8316u32);
    pub const SUPERSCRIPT_LEFT_PARENTHESIS : CodePoint = CodePoint::from(8317u32);
    pub const SUPERSCRIPT_RIGHT_PARENTHESIS : CodePoint = CodePoint::from(8318u32);
    pub const SUPERSCRIPT_LATIN_SMALL_LETTER_N : CodePoint = CodePoint::from(8319u32);
    pub const SUBSCRIPT_ZERO : CodePoint = CodePoint::from(8320u32);
    pub const SUBSCRIPT_ONE : CodePoint = CodePoint::from(8321u32);
    pub const SUBSCRIPT_TWO : CodePoint = CodePoint::from(8322u32);
    pub const SUBSCRIPT_THREE : CodePoint = CodePoint::from(8323u32);
    pub const SUBSCRIPT_FOUR : CodePoint = CodePoint::from(8324u32);
    pub const SUBSCRIPT_FIVE : CodePoint = CodePoint::from(8325u32);
    pub const SUBSCRIPT_SIX : CodePoint = CodePoint::from(8326u32);
    pub const SUBSCRIPT_SEVEN : CodePoint = CodePoint::from(8327u32);
    pub const SUBSCRIPT_EIGHT : CodePoint = CodePoint::from(8328u32);
    pub const SUBSCRIPT_NINE : CodePoint = CodePoint::from(8329u32);
    pub const SUBSCRIPT_PLUS_SIGN : CodePoint = CodePoint::from(8330u32);
    pub const SUBSCRIPT_MINUS : CodePoint = CodePoint::from(8331u32);
    pub const SUBSCRIPT_EQUALS_SIGN : CodePoint = CodePoint::from(8332u32);
    pub const SUBSCRIPT_LEFT_PARENTHESIS : CodePoint = CodePoint::from(8333u32);
    pub const SUBSCRIPT_RIGHT_PARENTHESIS : CodePoint = CodePoint::from(8334u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_A : CodePoint = CodePoint::from(8336u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_E : CodePoint = CodePoint::from(8337u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_O : CodePoint = CodePoint::from(8338u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_X : CodePoint = CodePoint::from(8339u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_SCHWA : CodePoint = CodePoint::from(8340u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_H : CodePoint = CodePoint::from(8341u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_K : CodePoint = CodePoint::from(8342u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_L : CodePoint = CodePoint::from(8343u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_M : CodePoint = CodePoint::from(8344u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_N : CodePoint = CodePoint::from(8345u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_P : CodePoint = CodePoint::from(8346u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_S : CodePoint = CodePoint::from(8347u32);
    pub const LATIN_SUBSCRIPT_SMALL_LETTER_T : CodePoint = CodePoint::from(8348u32);
    pub const EURO_CURRENCY_SIGN : CodePoint = CodePoint::from(8352u32);
    pub const COLON_SIGN : CodePoint = CodePoint::from(8353u32);
    pub const CRUZEIRO_SIGN : CodePoint = CodePoint::from(8354u32);
    pub const FRENCH_FRANC_SIGN : CodePoint = CodePoint::from(8355u32);
    pub const LIRA_SIGN : CodePoint = CodePoint::from(8356u32);
    pub const MILL_SIGN : CodePoint = CodePoint::from(8357u32);
    pub const NAIRA_SIGN : CodePoint = CodePoint::from(8358u32);
    pub const PESETA_SIGN : CodePoint = CodePoint::from(8359u32);
    pub const RUPEE_SIGN : CodePoint = CodePoint::from(8360u32);
    pub const WON_SIGN : CodePoint = CodePoint::from(8361u32);
    pub const NEW_SHEQEL_SIGN : CodePoint = CodePoint::from(8362u32);
    pub const DONG_SIGN : CodePoint = CodePoint::from(8363u32);
    pub const EURO_SIGN : CodePoint = CodePoint::from(8364u32);
    pub const KIP_SIGN : CodePoint = CodePoint::from(8365u32);
    pub const TUGRIK_SIGN : CodePoint = CodePoint::from(8366u32);
    pub const DRACHMA_SIGN : CodePoint = CodePoint::from(8367u32);
    pub const GERMAN_PENNY_SIGN : CodePoint = CodePoint::from(8368u32);
    pub const PESO_SIGN : CodePoint = CodePoint::from(8369u32);
    pub const GUARANI_SIGN : CodePoint = CodePoint::from(8370u32);
    pub const AUSTRAL_SIGN : CodePoint = CodePoint::from(8371u32);
    pub const HRYVNIA_SIGN : CodePoint = CodePoint::from(8372u32);
    pub const CEDI_SIGN : CodePoint = CodePoint::from(8373u32);
    pub const LIVRE_TOURNOIS_SIGN : CodePoint = CodePoint::from(8374u32);
    pub const SPESMILO_SIGN : CodePoint = CodePoint::from(8375u32);
    pub const TENGE_SIGN : CodePoint = CodePoint::from(8376u32);
    pub const INDIAN_RUPEE_SIGN : CodePoint = CodePoint::from(8377u32);
    pub const TURKISH_LIRA_SIGN : CodePoint = CodePoint::from(8378u32);
    pub const NORDIC_MARK_SIGN : CodePoint = CodePoint::from(8379u32);
    pub const MANAT_SIGN : CodePoint = CodePoint::from(8380u32);
    pub const RUBLE_SIGN : CodePoint = CodePoint::from(8381u32);
    pub const LARI_SIGN : CodePoint = CodePoint::from(8382u32);
    pub const BITCOIN_SIGN : CodePoint = CodePoint::from(8383u32);
    pub const COMBINING_LEFT_HARPOON_ABOVE : CodePoint = CodePoint::from(8400u32);
    pub const COMBINING_RIGHT_HARPOON_ABOVE : CodePoint = CodePoint::from(8401u32);
    pub const COMBINING_LONG_VERTICAL_LINE_OVERLAY : CodePoint = CodePoint::from(8402u32);
    pub const COMBINING_SHORT_VERTICAL_LINE_OVERLAY : CodePoint = CodePoint::from(8403u32);
    pub const COMBINING_ANTICLOCKWISE_ARROW_ABOVE : CodePoint = CodePoint::from(8404u32);
    pub const COMBINING_CLOCKWISE_ARROW_ABOVE : CodePoint = CodePoint::from(8405u32);
    pub const COMBINING_LEFT_ARROW_ABOVE : CodePoint = CodePoint::from(8406u32);
    pub const COMBINING_RIGHT_ARROW_ABOVE : CodePoint = CodePoint::from(8407u32);
    pub const COMBINING_RING_OVERLAY : CodePoint = CodePoint::from(8408u32);
    pub const COMBINING_CLOCKWISE_RING_OVERLAY : CodePoint = CodePoint::from(8409u32);
    pub const COMBINING_ANTICLOCKWISE_RING_OVERLAY : CodePoint = CodePoint::from(8410u32);
    pub const COMBINING_THREE_DOTS_ABOVE : CodePoint = CodePoint::from(8411u32);
    pub const COMBINING_FOUR_DOTS_ABOVE : CodePoint = CodePoint::from(8412u32);
    pub const COMBINING_ENCLOSING_CIRCLE : CodePoint = CodePoint::from(8413u32);
    pub const COMBINING_ENCLOSING_SQUARE : CodePoint = CodePoint::from(8414u32);
    pub const COMBINING_ENCLOSING_DIAMOND : CodePoint = CodePoint::from(8415u32);
    pub const COMBINING_ENCLOSING_CIRCLE_BACKSLASH : CodePoint = CodePoint::from(8416u32);
    pub const COMBINING_LEFT_RIGHT_ARROW_ABOVE : CodePoint = CodePoint::from(8417u32);
    pub const COMBINING_ENCLOSING_SCREEN : CodePoint = CodePoint::from(8418u32);
    pub const COMBINING_ENCLOSING_KEYCAP : CodePoint = CodePoint::from(8419u32);
    pub const COMBINING_ENCLOSING_UPWARD_POINTING_TRIANGLE : CodePoint = CodePoint::from(8420u32);
    pub const COMBINING_REVERSE_SOLIDUS_OVERLAY : CodePoint = CodePoint::from(8421u32);
    pub const COMBINING_DOUBLE_VERTICAL_STROKE_OVERLAY : CodePoint = CodePoint::from(8422u32);
    pub const COMBINING_ANNUITY_SYMBOL : CodePoint = CodePoint::from(8423u32);
    pub const COMBINING_TRIPLE_UNDERDOT : CodePoint = CodePoint::from(8424u32);
    pub const COMBINING_WIDE_BRIDGE_ABOVE : CodePoint = CodePoint::from(8425u32);
    pub const COMBINING_LEFTWARDS_ARROW_OVERLAY : CodePoint = CodePoint::from(8426u32);
    pub const COMBINING_LONG_DOUBLE_SOLIDUS_OVERLAY : CodePoint = CodePoint::from(8427u32);
    pub const COMBINING_RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS : CodePoint = CodePoint::from(8428u32);
    pub const COMBINING_LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS : CodePoint = CodePoint::from(8429u32);
    pub const COMBINING_LEFT_ARROW_BELOW : CodePoint = CodePoint::from(8430u32);
    pub const COMBINING_RIGHT_ARROW_BELOW : CodePoint = CodePoint::from(8431u32);
    pub const COMBINING_ASTERISK_ABOVE : CodePoint = CodePoint::from(8432u32);
    pub const ACCOUNT_OF : CodePoint = CodePoint::from(8448u32);
    pub const ADDRESSED_TO_THE_SUBJECT : CodePoint = CodePoint::from(8449u32);
    pub const DOUBLE_STRUCK_CAPITAL_C : CodePoint = CodePoint::from(8450u32);
    pub const DEGREE_CELSIUS : CodePoint = CodePoint::from(8451u32);
    pub const CENTRE_LINE_SYMBOL : CodePoint = CodePoint::from(8452u32);
    pub const CARE_OF : CodePoint = CodePoint::from(8453u32);
    pub const CADA_UNA : CodePoint = CodePoint::from(8454u32);
    pub const EULER_CONSTANT : CodePoint = CodePoint::from(8455u32);
    pub const SCRUPLE : CodePoint = CodePoint::from(8456u32);
    pub const DEGREE_FAHRENHEIT : CodePoint = CodePoint::from(8457u32);
    pub const SCRIPT_SMALL_G : CodePoint = CodePoint::from(8458u32);
    pub const SCRIPT_CAPITAL_H : CodePoint = CodePoint::from(8459u32);
    pub const BLACK_LETTER_CAPITAL_H : CodePoint = CodePoint::from(8460u32);
    pub const DOUBLE_STRUCK_CAPITAL_H : CodePoint = CodePoint::from(8461u32);
    pub const PLANCK_CONSTANT : CodePoint = CodePoint::from(8462u32);
    pub const PLANCK_CONSTANT_OVER_TWO_PI : CodePoint = CodePoint::from(8463u32);
    pub const SCRIPT_CAPITAL_I : CodePoint = CodePoint::from(8464u32);
    pub const BLACK_LETTER_CAPITAL_I : CodePoint = CodePoint::from(8465u32);
    pub const SCRIPT_CAPITAL_L : CodePoint = CodePoint::from(8466u32);
    pub const SCRIPT_SMALL_L : CodePoint = CodePoint::from(8467u32);
    pub const L_B_BAR_SYMBOL : CodePoint = CodePoint::from(8468u32);
    pub const DOUBLE_STRUCK_CAPITAL_N : CodePoint = CodePoint::from(8469u32);
    pub const NUMERO_SIGN : CodePoint = CodePoint::from(8470u32);
    pub const SOUND_RECORDING_COPYRIGHT : CodePoint = CodePoint::from(8471u32);
    pub const SCRIPT_CAPITAL_P : CodePoint = CodePoint::from(8472u32);
    pub const DOUBLE_STRUCK_CAPITAL_P : CodePoint = CodePoint::from(8473u32);
    pub const DOUBLE_STRUCK_CAPITAL_Q : CodePoint = CodePoint::from(8474u32);
    pub const SCRIPT_CAPITAL_R : CodePoint = CodePoint::from(8475u32);
    pub const BLACK_LETTER_CAPITAL_R : CodePoint = CodePoint::from(8476u32);
    pub const DOUBLE_STRUCK_CAPITAL_R : CodePoint = CodePoint::from(8477u32);
    pub const PRESCRIPTION_TAKE : CodePoint = CodePoint::from(8478u32);
    pub const RESPONSE : CodePoint = CodePoint::from(8479u32);
    pub const SERVICE_MARK : CodePoint = CodePoint::from(8480u32);
    pub const TELEPHONE_SIGN : CodePoint = CodePoint::from(8481u32);
    pub const TRADE_MARK_SIGN : CodePoint = CodePoint::from(8482u32);
    pub const VERSICLE : CodePoint = CodePoint::from(8483u32);
    pub const DOUBLE_STRUCK_CAPITAL_Z : CodePoint = CodePoint::from(8484u32);
    pub const OUNCE_SIGN : CodePoint = CodePoint::from(8485u32);
    pub const OHM_SIGN : CodePoint = CodePoint::from(8486u32);
    pub const INVERTED_OHM_SIGN : CodePoint = CodePoint::from(8487u32);
    pub const BLACK_LETTER_CAPITAL_Z : CodePoint = CodePoint::from(8488u32);
    pub const TURNED_GREEK_SMALL_LETTER_IOTA : CodePoint = CodePoint::from(8489u32);
    pub const KELVIN_SIGN : CodePoint = CodePoint::from(8490u32);
    pub const ANGSTROM_SIGN : CodePoint = CodePoint::from(8491u32);
    pub const SCRIPT_CAPITAL_B : CodePoint = CodePoint::from(8492u32);
    pub const BLACK_LETTER_CAPITAL_C : CodePoint = CodePoint::from(8493u32);
    pub const ESTIMATED_SYMBOL : CodePoint = CodePoint::from(8494u32);
    pub const SCRIPT_SMALL_E : CodePoint = CodePoint::from(8495u32);
    pub const SCRIPT_CAPITAL_E : CodePoint = CodePoint::from(8496u32);
    pub const SCRIPT_CAPITAL_F : CodePoint = CodePoint::from(8497u32);
    pub const TURNED_CAPITAL_F : CodePoint = CodePoint::from(8498u32);
    pub const SCRIPT_CAPITAL_M : CodePoint = CodePoint::from(8499u32);
    pub const SCRIPT_SMALL_O : CodePoint = CodePoint::from(8500u32);
    pub const ALEF_SYMBOL : CodePoint = CodePoint::from(8501u32);
    pub const BET_SYMBOL : CodePoint = CodePoint::from(8502u32);
    pub const GIMEL_SYMBOL : CodePoint = CodePoint::from(8503u32);
    pub const DALET_SYMBOL : CodePoint = CodePoint::from(8504u32);
    pub const INFORMATION_SOURCE : CodePoint = CodePoint::from(8505u32);
    pub const ROTATED_CAPITAL_Q : CodePoint = CodePoint::from(8506u32);
    pub const FACSIMILE_SIGN : CodePoint = CodePoint::from(8507u32);
    pub const DOUBLE_STRUCK_SMALL_PI : CodePoint = CodePoint::from(8508u32);
    pub const DOUBLE_STRUCK_SMALL_GAMMA : CodePoint = CodePoint::from(8509u32);
    pub const DOUBLE_STRUCK_CAPITAL_GAMMA : CodePoint = CodePoint::from(8510u32);
    pub const DOUBLE_STRUCK_CAPITAL_PI : CodePoint = CodePoint::from(8511u32);
    pub const DOUBLE_STRUCK_N_ARY_SUMMATION : CodePoint = CodePoint::from(8512u32);
    pub const TURNED_SANS_SERIF_CAPITAL_G : CodePoint = CodePoint::from(8513u32);
    pub const TURNED_SANS_SERIF_CAPITAL_L : CodePoint = CodePoint::from(8514u32);
    pub const REVERSED_SANS_SERIF_CAPITAL_L : CodePoint = CodePoint::from(8515u32);
    pub const TURNED_SANS_SERIF_CAPITAL_Y : CodePoint = CodePoint::from(8516u32);
    pub const DOUBLE_STRUCK_ITALIC_CAPITAL_D : CodePoint = CodePoint::from(8517u32);
    pub const DOUBLE_STRUCK_ITALIC_SMALL_D : CodePoint = CodePoint::from(8518u32);
    pub const DOUBLE_STRUCK_ITALIC_SMALL_E : CodePoint = CodePoint::from(8519u32);
    pub const DOUBLE_STRUCK_ITALIC_SMALL_I : CodePoint = CodePoint::from(8520u32);
    pub const DOUBLE_STRUCK_ITALIC_SMALL_J : CodePoint = CodePoint::from(8521u32);
    pub const PROPERTY_LINE : CodePoint = CodePoint::from(8522u32);
    pub const TURNED_AMPERSAND : CodePoint = CodePoint::from(8523u32);
    pub const PER_SIGN : CodePoint = CodePoint::from(8524u32);
    pub const AKTIESELSKAB : CodePoint = CodePoint::from(8525u32);
    pub const TURNED_SMALL_F : CodePoint = CodePoint::from(8526u32);
    pub const SYMBOL_FOR_SAMARITAN_SOURCE : CodePoint = CodePoint::from(8527u32);
    pub const VULGAR_FRACTION_ONE_SEVENTH : CodePoint = CodePoint::from(8528u32);
    pub const VULGAR_FRACTION_ONE_NINTH : CodePoint = CodePoint::from(8529u32);
    pub const VULGAR_FRACTION_ONE_TENTH : CodePoint = CodePoint::from(8530u32);
    pub const VULGAR_FRACTION_ONE_THIRD : CodePoint = CodePoint::from(8531u32);
    pub const VULGAR_FRACTION_TWO_THIRDS : CodePoint = CodePoint::from(8532u32);
    pub const VULGAR_FRACTION_ONE_FIFTH : CodePoint = CodePoint::from(8533u32);
    pub const VULGAR_FRACTION_TWO_FIFTHS : CodePoint = CodePoint::from(8534u32);
    pub const VULGAR_FRACTION_THREE_FIFTHS : CodePoint = CodePoint::from(8535u32);
    pub const VULGAR_FRACTION_FOUR_FIFTHS : CodePoint = CodePoint::from(8536u32);
    pub const VULGAR_FRACTION_ONE_SIXTH : CodePoint = CodePoint::from(8537u32);
    pub const VULGAR_FRACTION_FIVE_SIXTHS : CodePoint = CodePoint::from(8538u32);
    pub const VULGAR_FRACTION_ONE_EIGHTH : CodePoint = CodePoint::from(8539u32);
    pub const VULGAR_FRACTION_THREE_EIGHTHS : CodePoint = CodePoint::from(8540u32);
    pub const VULGAR_FRACTION_FIVE_EIGHTHS : CodePoint = CodePoint::from(8541u32);
    pub const VULGAR_FRACTION_SEVEN_EIGHTHS : CodePoint = CodePoint::from(8542u32);
    pub const FRACTION_NUMERATOR_ONE : CodePoint = CodePoint::from(8543u32);
    pub const ROMAN_NUMERAL_ONE : CodePoint = CodePoint::from(8544u32);
    pub const ROMAN_NUMERAL_TWO : CodePoint = CodePoint::from(8545u32);
    pub const ROMAN_NUMERAL_THREE : CodePoint = CodePoint::from(8546u32);
    pub const ROMAN_NUMERAL_FOUR : CodePoint = CodePoint::from(8547u32);
    pub const ROMAN_NUMERAL_FIVE : CodePoint = CodePoint::from(8548u32);
    pub const ROMAN_NUMERAL_SIX : CodePoint = CodePoint::from(8549u32);
    pub const ROMAN_NUMERAL_SEVEN : CodePoint = CodePoint::from(8550u32);
    pub const ROMAN_NUMERAL_EIGHT : CodePoint = CodePoint::from(8551u32);
    pub const ROMAN_NUMERAL_NINE : CodePoint = CodePoint::from(8552u32);
    pub const ROMAN_NUMERAL_TEN : CodePoint = CodePoint::from(8553u32);
    pub const ROMAN_NUMERAL_ELEVEN : CodePoint = CodePoint::from(8554u32);
    pub const ROMAN_NUMERAL_TWELVE : CodePoint = CodePoint::from(8555u32);
    pub const ROMAN_NUMERAL_FIFTY : CodePoint = CodePoint::from(8556u32);
    pub const ROMAN_NUMERAL_ONE_HUNDRED : CodePoint = CodePoint::from(8557u32);
    pub const ROMAN_NUMERAL_FIVE_HUNDRED : CodePoint = CodePoint::from(8558u32);
    pub const ROMAN_NUMERAL_ONE_THOUSAND : CodePoint = CodePoint::from(8559u32);
    pub const SMALL_ROMAN_NUMERAL_ONE : CodePoint = CodePoint::from(8560u32);
    pub const SMALL_ROMAN_NUMERAL_TWO : CodePoint = CodePoint::from(8561u32);
    pub const SMALL_ROMAN_NUMERAL_THREE : CodePoint = CodePoint::from(8562u32);
    pub const SMALL_ROMAN_NUMERAL_FOUR : CodePoint = CodePoint::from(8563u32);
    pub const SMALL_ROMAN_NUMERAL_FIVE : CodePoint = CodePoint::from(8564u32);
    pub const SMALL_ROMAN_NUMERAL_SIX : CodePoint = CodePoint::from(8565u32);
    pub const SMALL_ROMAN_NUMERAL_SEVEN : CodePoint = CodePoint::from(8566u32);
    pub const SMALL_ROMAN_NUMERAL_EIGHT : CodePoint = CodePoint::from(8567u32);
    pub const SMALL_ROMAN_NUMERAL_NINE : CodePoint = CodePoint::from(8568u32);
    pub const SMALL_ROMAN_NUMERAL_TEN : CodePoint = CodePoint::from(8569u32);
    pub const SMALL_ROMAN_NUMERAL_ELEVEN : CodePoint = CodePoint::from(8570u32);
    pub const SMALL_ROMAN_NUMERAL_TWELVE : CodePoint = CodePoint::from(8571u32);
    pub const SMALL_ROMAN_NUMERAL_FIFTY : CodePoint = CodePoint::from(8572u32);
    pub const SMALL_ROMAN_NUMERAL_ONE_HUNDRED : CodePoint = CodePoint::from(8573u32);
    pub const SMALL_ROMAN_NUMERAL_FIVE_HUNDRED : CodePoint = CodePoint::from(8574u32);
    pub const SMALL_ROMAN_NUMERAL_ONE_THOUSAND : CodePoint = CodePoint::from(8575u32);
    pub const ROMAN_NUMERAL_ONE_THOUSAND_C_D : CodePoint = CodePoint::from(8576u32);
    pub const ROMAN_NUMERAL_FIVE_THOUSAND : CodePoint = CodePoint::from(8577u32);
    pub const ROMAN_NUMERAL_TEN_THOUSAND : CodePoint = CodePoint::from(8578u32);
    pub const ROMAN_NUMERAL_REVERSED_ONE_HUNDRED : CodePoint = CodePoint::from(8579u32);
    pub const LATIN_SMALL_LETTER_REVERSED_C : CodePoint = CodePoint::from(8580u32);
    pub const ROMAN_NUMERAL_SIX_LATE_FORM : CodePoint = CodePoint::from(8581u32);
    pub const ROMAN_NUMERAL_FIFTY_EARLY_FORM : CodePoint = CodePoint::from(8582u32);
    pub const ROMAN_NUMERAL_FIFTY_THOUSAND : CodePoint = CodePoint::from(8583u32);
    pub const ROMAN_NUMERAL_ONE_HUNDRED_THOUSAND : CodePoint = CodePoint::from(8584u32);
    pub const VULGAR_FRACTION_ZERO_THIRDS : CodePoint = CodePoint::from(8585u32);
    pub const TURNED_DIGIT_TWO : CodePoint = CodePoint::from(8586u32);
    pub const TURNED_DIGIT_THREE : CodePoint = CodePoint::from(8587u32);
    pub const LEFTWARDS_ARROW : CodePoint = CodePoint::from(8592u32);
    pub const UPWARDS_ARROW : CodePoint = CodePoint::from(8593u32);
    pub const RIGHTWARDS_ARROW : CodePoint = CodePoint::from(8594u32);
    pub const DOWNWARDS_ARROW : CodePoint = CodePoint::from(8595u32);
    pub const LEFT_RIGHT_ARROW : CodePoint = CodePoint::from(8596u32);
    pub const UP_DOWN_ARROW : CodePoint = CodePoint::from(8597u32);
    pub const NORTH_WEST_ARROW : CodePoint = CodePoint::from(8598u32);
    pub const NORTH_EAST_ARROW : CodePoint = CodePoint::from(8599u32);
    pub const SOUTH_EAST_ARROW : CodePoint = CodePoint::from(8600u32);
    pub const SOUTH_WEST_ARROW : CodePoint = CodePoint::from(8601u32);
    pub const LEFTWARDS_ARROW_WITH_STROKE : CodePoint = CodePoint::from(8602u32);
    pub const RIGHTWARDS_ARROW_WITH_STROKE : CodePoint = CodePoint::from(8603u32);
    pub const LEFTWARDS_WAVE_ARROW : CodePoint = CodePoint::from(8604u32);
    pub const RIGHTWARDS_WAVE_ARROW : CodePoint = CodePoint::from(8605u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW : CodePoint = CodePoint::from(8606u32);
    pub const UPWARDS_TWO_HEADED_ARROW : CodePoint = CodePoint::from(8607u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW : CodePoint = CodePoint::from(8608u32);
    pub const DOWNWARDS_TWO_HEADED_ARROW : CodePoint = CodePoint::from(8609u32);
    pub const LEFTWARDS_ARROW_WITH_TAIL : CodePoint = CodePoint::from(8610u32);
    pub const RIGHTWARDS_ARROW_WITH_TAIL : CodePoint = CodePoint::from(8611u32);
    pub const LEFTWARDS_ARROW_FROM_BAR : CodePoint = CodePoint::from(8612u32);
    pub const UPWARDS_ARROW_FROM_BAR : CodePoint = CodePoint::from(8613u32);
    pub const RIGHTWARDS_ARROW_FROM_BAR : CodePoint = CodePoint::from(8614u32);
    pub const DOWNWARDS_ARROW_FROM_BAR : CodePoint = CodePoint::from(8615u32);
    pub const UP_DOWN_ARROW_WITH_BASE : CodePoint = CodePoint::from(8616u32);
    pub const LEFTWARDS_ARROW_WITH_HOOK : CodePoint = CodePoint::from(8617u32);
    pub const RIGHTWARDS_ARROW_WITH_HOOK : CodePoint = CodePoint::from(8618u32);
    pub const LEFTWARDS_ARROW_WITH_LOOP : CodePoint = CodePoint::from(8619u32);
    pub const RIGHTWARDS_ARROW_WITH_LOOP : CodePoint = CodePoint::from(8620u32);
    pub const LEFT_RIGHT_WAVE_ARROW : CodePoint = CodePoint::from(8621u32);
    pub const LEFT_RIGHT_ARROW_WITH_STROKE : CodePoint = CodePoint::from(8622u32);
    pub const DOWNWARDS_ZIGZAG_ARROW : CodePoint = CodePoint::from(8623u32);
    pub const UPWARDS_ARROW_WITH_TIP_LEFTWARDS : CodePoint = CodePoint::from(8624u32);
    pub const UPWARDS_ARROW_WITH_TIP_RIGHTWARDS : CodePoint = CodePoint::from(8625u32);
    pub const DOWNWARDS_ARROW_WITH_TIP_LEFTWARDS : CodePoint = CodePoint::from(8626u32);
    pub const DOWNWARDS_ARROW_WITH_TIP_RIGHTWARDS : CodePoint = CodePoint::from(8627u32);
    pub const RIGHTWARDS_ARROW_WITH_CORNER_DOWNWARDS : CodePoint = CodePoint::from(8628u32);
    pub const DOWNWARDS_ARROW_WITH_CORNER_LEFTWARDS : CodePoint = CodePoint::from(8629u32);
    pub const ANTICLOCKWISE_TOP_SEMICIRCLE_ARROW : CodePoint = CodePoint::from(8630u32);
    pub const CLOCKWISE_TOP_SEMICIRCLE_ARROW : CodePoint = CodePoint::from(8631u32);
    pub const NORTH_WEST_ARROW_TO_LONG_BAR : CodePoint = CodePoint::from(8632u32);
    pub const LEFTWARDS_ARROW_TO_BAR_OVER_RIGHTWARDS_ARROW_TO_BAR : CodePoint = CodePoint::from(8633u32);
    pub const ANTICLOCKWISE_OPEN_CIRCLE_ARROW : CodePoint = CodePoint::from(8634u32);
    pub const CLOCKWISE_OPEN_CIRCLE_ARROW : CodePoint = CodePoint::from(8635u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_UPWARDS : CodePoint = CodePoint::from(8636u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS : CodePoint = CodePoint::from(8637u32);
    pub const UPWARDS_HARPOON_WITH_BARB_RIGHTWARDS : CodePoint = CodePoint::from(8638u32);
    pub const UPWARDS_HARPOON_WITH_BARB_LEFTWARDS : CodePoint = CodePoint::from(8639u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_UPWARDS : CodePoint = CodePoint::from(8640u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS : CodePoint = CodePoint::from(8641u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_RIGHTWARDS : CodePoint = CodePoint::from(8642u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_LEFTWARDS : CodePoint = CodePoint::from(8643u32);
    pub const RIGHTWARDS_ARROW_OVER_LEFTWARDS_ARROW : CodePoint = CodePoint::from(8644u32);
    pub const UPWARDS_ARROW_LEFTWARDS_OF_DOWNWARDS_ARROW : CodePoint = CodePoint::from(8645u32);
    pub const LEFTWARDS_ARROW_OVER_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(8646u32);
    pub const LEFTWARDS_PAIRED_ARROWS : CodePoint = CodePoint::from(8647u32);
    pub const UPWARDS_PAIRED_ARROWS : CodePoint = CodePoint::from(8648u32);
    pub const RIGHTWARDS_PAIRED_ARROWS : CodePoint = CodePoint::from(8649u32);
    pub const DOWNWARDS_PAIRED_ARROWS : CodePoint = CodePoint::from(8650u32);
    pub const LEFTWARDS_HARPOON_OVER_RIGHTWARDS_HARPOON : CodePoint = CodePoint::from(8651u32);
    pub const RIGHTWARDS_HARPOON_OVER_LEFTWARDS_HARPOON : CodePoint = CodePoint::from(8652u32);
    pub const LEFTWARDS_DOUBLE_ARROW_WITH_STROKE : CodePoint = CodePoint::from(8653u32);
    pub const LEFT_RIGHT_DOUBLE_ARROW_WITH_STROKE : CodePoint = CodePoint::from(8654u32);
    pub const RIGHTWARDS_DOUBLE_ARROW_WITH_STROKE : CodePoint = CodePoint::from(8655u32);
    pub const LEFTWARDS_DOUBLE_ARROW : CodePoint = CodePoint::from(8656u32);
    pub const UPWARDS_DOUBLE_ARROW : CodePoint = CodePoint::from(8657u32);
    pub const RIGHTWARDS_DOUBLE_ARROW : CodePoint = CodePoint::from(8658u32);
    pub const DOWNWARDS_DOUBLE_ARROW : CodePoint = CodePoint::from(8659u32);
    pub const LEFT_RIGHT_DOUBLE_ARROW : CodePoint = CodePoint::from(8660u32);
    pub const UP_DOWN_DOUBLE_ARROW : CodePoint = CodePoint::from(8661u32);
    pub const NORTH_WEST_DOUBLE_ARROW : CodePoint = CodePoint::from(8662u32);
    pub const NORTH_EAST_DOUBLE_ARROW : CodePoint = CodePoint::from(8663u32);
    pub const SOUTH_EAST_DOUBLE_ARROW : CodePoint = CodePoint::from(8664u32);
    pub const SOUTH_WEST_DOUBLE_ARROW : CodePoint = CodePoint::from(8665u32);
    pub const LEFTWARDS_TRIPLE_ARROW : CodePoint = CodePoint::from(8666u32);
    pub const RIGHTWARDS_TRIPLE_ARROW : CodePoint = CodePoint::from(8667u32);
    pub const LEFTWARDS_SQUIGGLE_ARROW : CodePoint = CodePoint::from(8668u32);
    pub const RIGHTWARDS_SQUIGGLE_ARROW : CodePoint = CodePoint::from(8669u32);
    pub const UPWARDS_ARROW_WITH_DOUBLE_STROKE : CodePoint = CodePoint::from(8670u32);
    pub const DOWNWARDS_ARROW_WITH_DOUBLE_STROKE : CodePoint = CodePoint::from(8671u32);
    pub const LEFTWARDS_DASHED_ARROW : CodePoint = CodePoint::from(8672u32);
    pub const UPWARDS_DASHED_ARROW : CodePoint = CodePoint::from(8673u32);
    pub const RIGHTWARDS_DASHED_ARROW : CodePoint = CodePoint::from(8674u32);
    pub const DOWNWARDS_DASHED_ARROW : CodePoint = CodePoint::from(8675u32);
    pub const LEFTWARDS_ARROW_TO_BAR : CodePoint = CodePoint::from(8676u32);
    pub const RIGHTWARDS_ARROW_TO_BAR : CodePoint = CodePoint::from(8677u32);
    pub const LEFTWARDS_WHITE_ARROW : CodePoint = CodePoint::from(8678u32);
    pub const UPWARDS_WHITE_ARROW : CodePoint = CodePoint::from(8679u32);
    pub const RIGHTWARDS_WHITE_ARROW : CodePoint = CodePoint::from(8680u32);
    pub const DOWNWARDS_WHITE_ARROW : CodePoint = CodePoint::from(8681u32);
    pub const UPWARDS_WHITE_ARROW_FROM_BAR : CodePoint = CodePoint::from(8682u32);
    pub const UPWARDS_WHITE_ARROW_ON_PEDESTAL : CodePoint = CodePoint::from(8683u32);
    pub const UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_HORIZONTAL_BAR : CodePoint = CodePoint::from(8684u32);
    pub const UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_VERTICAL_BAR : CodePoint = CodePoint::from(8685u32);
    pub const UPWARDS_WHITE_DOUBLE_ARROW : CodePoint = CodePoint::from(8686u32);
    pub const UPWARDS_WHITE_DOUBLE_ARROW_ON_PEDESTAL : CodePoint = CodePoint::from(8687u32);
    pub const RIGHTWARDS_WHITE_ARROW_FROM_WALL : CodePoint = CodePoint::from(8688u32);
    pub const NORTH_WEST_ARROW_TO_CORNER : CodePoint = CodePoint::from(8689u32);
    pub const SOUTH_EAST_ARROW_TO_CORNER : CodePoint = CodePoint::from(8690u32);
    pub const UP_DOWN_WHITE_ARROW : CodePoint = CodePoint::from(8691u32);
    pub const RIGHT_ARROW_WITH_SMALL_CIRCLE : CodePoint = CodePoint::from(8692u32);
    pub const DOWNWARDS_ARROW_LEFTWARDS_OF_UPWARDS_ARROW : CodePoint = CodePoint::from(8693u32);
    pub const THREE_RIGHTWARDS_ARROWS : CodePoint = CodePoint::from(8694u32);
    pub const LEFTWARDS_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(8695u32);
    pub const RIGHTWARDS_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(8696u32);
    pub const LEFT_RIGHT_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(8697u32);
    pub const LEFTWARDS_ARROW_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(8698u32);
    pub const RIGHTWARDS_ARROW_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(8699u32);
    pub const LEFT_RIGHT_ARROW_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(8700u32);
    pub const LEFTWARDS_OPEN_HEADED_ARROW : CodePoint = CodePoint::from(8701u32);
    pub const RIGHTWARDS_OPEN_HEADED_ARROW : CodePoint = CodePoint::from(8702u32);
    pub const LEFT_RIGHT_OPEN_HEADED_ARROW : CodePoint = CodePoint::from(8703u32);
    pub const FOR_ALL : CodePoint = CodePoint::from(8704u32);
    pub const COMPLEMENT : CodePoint = CodePoint::from(8705u32);
    pub const PARTIAL_DIFFERENTIAL : CodePoint = CodePoint::from(8706u32);
    pub const THERE_EXISTS : CodePoint = CodePoint::from(8707u32);
    pub const THERE_DOES_NOT_EXIST : CodePoint = CodePoint::from(8708u32);
    pub const EMPTY_SET : CodePoint = CodePoint::from(8709u32);
    pub const INCREMENT : CodePoint = CodePoint::from(8710u32);
    pub const NABLA : CodePoint = CodePoint::from(8711u32);
    pub const ELEMENT_OF : CodePoint = CodePoint::from(8712u32);
    pub const NOT_AN_ELEMENT_OF : CodePoint = CodePoint::from(8713u32);
    pub const SMALL_ELEMENT_OF : CodePoint = CodePoint::from(8714u32);
    pub const CONTAINS_AS_MEMBER : CodePoint = CodePoint::from(8715u32);
    pub const DOES_NOT_CONTAIN_AS_MEMBER : CodePoint = CodePoint::from(8716u32);
    pub const SMALL_CONTAINS_AS_MEMBER : CodePoint = CodePoint::from(8717u32);
    pub const END_OF_PROOF : CodePoint = CodePoint::from(8718u32);
    pub const N_ARY_PRODUCT : CodePoint = CodePoint::from(8719u32);
    pub const N_ARY_COPRODUCT : CodePoint = CodePoint::from(8720u32);
    pub const N_ARY_SUMMATION : CodePoint = CodePoint::from(8721u32);
    pub const MINUS_SIGN : CodePoint = CodePoint::from(8722u32);
    pub const MINUS_OR_PLUS_SIGN : CodePoint = CodePoint::from(8723u32);
    pub const DOT_PLUS : CodePoint = CodePoint::from(8724u32);
    pub const DIVISION_SLASH : CodePoint = CodePoint::from(8725u32);
    pub const SET_MINUS : CodePoint = CodePoint::from(8726u32);
    pub const ASTERISK_OPERATOR : CodePoint = CodePoint::from(8727u32);
    pub const RING_OPERATOR : CodePoint = CodePoint::from(8728u32);
    pub const BULLET_OPERATOR : CodePoint = CodePoint::from(8729u32);
    pub const SQUARE_ROOT : CodePoint = CodePoint::from(8730u32);
    pub const CUBE_ROOT : CodePoint = CodePoint::from(8731u32);
    pub const FOURTH_ROOT : CodePoint = CodePoint::from(8732u32);
    pub const PROPORTIONAL_TO : CodePoint = CodePoint::from(8733u32);
    pub const INFINITY : CodePoint = CodePoint::from(8734u32);
    pub const RIGHT_ANGLE : CodePoint = CodePoint::from(8735u32);
    pub const ANGLE : CodePoint = CodePoint::from(8736u32);
    pub const MEASURED_ANGLE : CodePoint = CodePoint::from(8737u32);
    pub const SPHERICAL_ANGLE : CodePoint = CodePoint::from(8738u32);
    pub const DIVIDES : CodePoint = CodePoint::from(8739u32);
    pub const DOES_NOT_DIVIDE : CodePoint = CodePoint::from(8740u32);
    pub const PARALLEL_TO : CodePoint = CodePoint::from(8741u32);
    pub const NOT_PARALLEL_TO : CodePoint = CodePoint::from(8742u32);
    pub const LOGICAL_AND : CodePoint = CodePoint::from(8743u32);
    pub const LOGICAL_OR : CodePoint = CodePoint::from(8744u32);
    pub const INTERSECTION : CodePoint = CodePoint::from(8745u32);
    pub const UNION : CodePoint = CodePoint::from(8746u32);
    pub const INTEGRAL : CodePoint = CodePoint::from(8747u32);
    pub const DOUBLE_INTEGRAL : CodePoint = CodePoint::from(8748u32);
    pub const TRIPLE_INTEGRAL : CodePoint = CodePoint::from(8749u32);
    pub const CONTOUR_INTEGRAL : CodePoint = CodePoint::from(8750u32);
    pub const SURFACE_INTEGRAL : CodePoint = CodePoint::from(8751u32);
    pub const VOLUME_INTEGRAL : CodePoint = CodePoint::from(8752u32);
    pub const CLOCKWISE_INTEGRAL : CodePoint = CodePoint::from(8753u32);
    pub const CLOCKWISE_CONTOUR_INTEGRAL : CodePoint = CodePoint::from(8754u32);
    pub const ANTICLOCKWISE_CONTOUR_INTEGRAL : CodePoint = CodePoint::from(8755u32);
    pub const THEREFORE : CodePoint = CodePoint::from(8756u32);
    pub const BECAUSE : CodePoint = CodePoint::from(8757u32);
    pub const RATIO : CodePoint = CodePoint::from(8758u32);
    pub const PROPORTION : CodePoint = CodePoint::from(8759u32);
    pub const DOT_MINUS : CodePoint = CodePoint::from(8760u32);
    pub const EXCESS : CodePoint = CodePoint::from(8761u32);
    pub const GEOMETRIC_PROPORTION : CodePoint = CodePoint::from(8762u32);
    pub const HOMOTHETIC : CodePoint = CodePoint::from(8763u32);
    pub const TILDE_OPERATOR : CodePoint = CodePoint::from(8764u32);
    pub const REVERSED_TILDE : CodePoint = CodePoint::from(8765u32);
    pub const INVERTED_LAZY_S : CodePoint = CodePoint::from(8766u32);
    pub const SINE_WAVE : CodePoint = CodePoint::from(8767u32);
    pub const WREATH_PRODUCT : CodePoint = CodePoint::from(8768u32);
    pub const NOT_TILDE : CodePoint = CodePoint::from(8769u32);
    pub const MINUS_TILDE : CodePoint = CodePoint::from(8770u32);
    pub const ASYMPTOTICALLY_EQUAL_TO : CodePoint = CodePoint::from(8771u32);
    pub const NOT_ASYMPTOTICALLY_EQUAL_TO : CodePoint = CodePoint::from(8772u32);
    pub const APPROXIMATELY_EQUAL_TO : CodePoint = CodePoint::from(8773u32);
    pub const APPROXIMATELY_BUT_NOT_ACTUALLY_EQUAL_TO : CodePoint = CodePoint::from(8774u32);
    pub const NEITHER_APPROXIMATELY_NOR_ACTUALLY_EQUAL_TO : CodePoint = CodePoint::from(8775u32);
    pub const ALMOST_EQUAL_TO : CodePoint = CodePoint::from(8776u32);
    pub const NOT_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(8777u32);
    pub const ALMOST_EQUAL_OR_EQUAL_TO : CodePoint = CodePoint::from(8778u32);
    pub const TRIPLE_TILDE : CodePoint = CodePoint::from(8779u32);
    pub const ALL_EQUAL_TO : CodePoint = CodePoint::from(8780u32);
    pub const EQUIVALENT_TO : CodePoint = CodePoint::from(8781u32);
    pub const GEOMETRICALLY_EQUIVALENT_TO : CodePoint = CodePoint::from(8782u32);
    pub const DIFFERENCE_BETWEEN : CodePoint = CodePoint::from(8783u32);
    pub const APPROACHES_THE_LIMIT : CodePoint = CodePoint::from(8784u32);
    pub const GEOMETRICALLY_EQUAL_TO : CodePoint = CodePoint::from(8785u32);
    pub const APPROXIMATELY_EQUAL_TO_OR_THE_IMAGE_OF : CodePoint = CodePoint::from(8786u32);
    pub const IMAGE_OF_OR_APPROXIMATELY_EQUAL_TO : CodePoint = CodePoint::from(8787u32);
    pub const COLON_EQUALS : CodePoint = CodePoint::from(8788u32);
    pub const EQUALS_COLON : CodePoint = CodePoint::from(8789u32);
    pub const RING_IN_EQUAL_TO : CodePoint = CodePoint::from(8790u32);
    pub const RING_EQUAL_TO : CodePoint = CodePoint::from(8791u32);
    pub const CORRESPONDS_TO : CodePoint = CodePoint::from(8792u32);
    pub const ESTIMATES : CodePoint = CodePoint::from(8793u32);
    pub const EQUIANGULAR_TO : CodePoint = CodePoint::from(8794u32);
    pub const STAR_EQUALS : CodePoint = CodePoint::from(8795u32);
    pub const DELTA_EQUAL_TO : CodePoint = CodePoint::from(8796u32);
    pub const EQUAL_TO_BY_DEFINITION : CodePoint = CodePoint::from(8797u32);
    pub const MEASURED_BY : CodePoint = CodePoint::from(8798u32);
    pub const QUESTIONED_EQUAL_TO : CodePoint = CodePoint::from(8799u32);
    pub const NOT_EQUAL_TO : CodePoint = CodePoint::from(8800u32);
    pub const IDENTICAL_TO : CodePoint = CodePoint::from(8801u32);
    pub const NOT_IDENTICAL_TO : CodePoint = CodePoint::from(8802u32);
    pub const STRICTLY_EQUIVALENT_TO : CodePoint = CodePoint::from(8803u32);
    pub const LESS_THAN_OR_EQUAL_TO : CodePoint = CodePoint::from(8804u32);
    pub const GREATER_THAN_OR_EQUAL_TO : CodePoint = CodePoint::from(8805u32);
    pub const LESS_THAN_OVER_EQUAL_TO : CodePoint = CodePoint::from(8806u32);
    pub const GREATER_THAN_OVER_EQUAL_TO : CodePoint = CodePoint::from(8807u32);
    pub const LESS_THAN_BUT_NOT_EQUAL_TO : CodePoint = CodePoint::from(8808u32);
    pub const GREATER_THAN_BUT_NOT_EQUAL_TO : CodePoint = CodePoint::from(8809u32);
    pub const MUCH_LESS_THAN : CodePoint = CodePoint::from(8810u32);
    pub const MUCH_GREATER_THAN : CodePoint = CodePoint::from(8811u32);
    pub const BETWEEN : CodePoint = CodePoint::from(8812u32);
    pub const NOT_EQUIVALENT_TO : CodePoint = CodePoint::from(8813u32);
    pub const NOT_LESS_THAN : CodePoint = CodePoint::from(8814u32);
    pub const NOT_GREATER_THAN : CodePoint = CodePoint::from(8815u32);
    pub const NEITHER_LESS_THAN_NOR_EQUAL_TO : CodePoint = CodePoint::from(8816u32);
    pub const NEITHER_GREATER_THAN_NOR_EQUAL_TO : CodePoint = CodePoint::from(8817u32);
    pub const LESS_THAN_OR_EQUIVALENT_TO : CodePoint = CodePoint::from(8818u32);
    pub const GREATER_THAN_OR_EQUIVALENT_TO : CodePoint = CodePoint::from(8819u32);
    pub const NEITHER_LESS_THAN_NOR_EQUIVALENT_TO : CodePoint = CodePoint::from(8820u32);
    pub const NEITHER_GREATER_THAN_NOR_EQUIVALENT_TO : CodePoint = CodePoint::from(8821u32);
    pub const LESS_THAN_OR_GREATER_THAN : CodePoint = CodePoint::from(8822u32);
    pub const GREATER_THAN_OR_LESS_THAN : CodePoint = CodePoint::from(8823u32);
    pub const NEITHER_LESS_THAN_NOR_GREATER_THAN : CodePoint = CodePoint::from(8824u32);
    pub const NEITHER_GREATER_THAN_NOR_LESS_THAN : CodePoint = CodePoint::from(8825u32);
    pub const PRECEDES : CodePoint = CodePoint::from(8826u32);
    pub const SUCCEEDS : CodePoint = CodePoint::from(8827u32);
    pub const PRECEDES_OR_EQUAL_TO : CodePoint = CodePoint::from(8828u32);
    pub const SUCCEEDS_OR_EQUAL_TO : CodePoint = CodePoint::from(8829u32);
    pub const PRECEDES_OR_EQUIVALENT_TO : CodePoint = CodePoint::from(8830u32);
    pub const SUCCEEDS_OR_EQUIVALENT_TO : CodePoint = CodePoint::from(8831u32);
    pub const DOES_NOT_PRECEDE : CodePoint = CodePoint::from(8832u32);
    pub const DOES_NOT_SUCCEED : CodePoint = CodePoint::from(8833u32);
    pub const SUBSET_OF : CodePoint = CodePoint::from(8834u32);
    pub const SUPERSET_OF : CodePoint = CodePoint::from(8835u32);
    pub const NOT_A_SUBSET_OF : CodePoint = CodePoint::from(8836u32);
    pub const NOT_A_SUPERSET_OF : CodePoint = CodePoint::from(8837u32);
    pub const SUBSET_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8838u32);
    pub const SUPERSET_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8839u32);
    pub const NEITHER_A_SUBSET_OF_NOR_EQUAL_TO : CodePoint = CodePoint::from(8840u32);
    pub const NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO : CodePoint = CodePoint::from(8841u32);
    pub const SUBSET_OF_WITH_NOT_EQUAL_TO : CodePoint = CodePoint::from(8842u32);
    pub const SUPERSET_OF_WITH_NOT_EQUAL_TO : CodePoint = CodePoint::from(8843u32);
    pub const MULTISET : CodePoint = CodePoint::from(8844u32);
    pub const MULTISET_MULTIPLICATION : CodePoint = CodePoint::from(8845u32);
    pub const MULTISET_UNION : CodePoint = CodePoint::from(8846u32);
    pub const SQUARE_IMAGE_OF : CodePoint = CodePoint::from(8847u32);
    pub const SQUARE_ORIGINAL_OF : CodePoint = CodePoint::from(8848u32);
    pub const SQUARE_IMAGE_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8849u32);
    pub const SQUARE_ORIGINAL_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8850u32);
    pub const SQUARE_CAP : CodePoint = CodePoint::from(8851u32);
    pub const SQUARE_CUP : CodePoint = CodePoint::from(8852u32);
    pub const CIRCLED_PLUS : CodePoint = CodePoint::from(8853u32);
    pub const CIRCLED_MINUS : CodePoint = CodePoint::from(8854u32);
    pub const CIRCLED_TIMES : CodePoint = CodePoint::from(8855u32);
    pub const CIRCLED_DIVISION_SLASH : CodePoint = CodePoint::from(8856u32);
    pub const CIRCLED_DOT_OPERATOR : CodePoint = CodePoint::from(8857u32);
    pub const CIRCLED_RING_OPERATOR : CodePoint = CodePoint::from(8858u32);
    pub const CIRCLED_ASTERISK_OPERATOR : CodePoint = CodePoint::from(8859u32);
    pub const CIRCLED_EQUALS : CodePoint = CodePoint::from(8860u32);
    pub const CIRCLED_DASH : CodePoint = CodePoint::from(8861u32);
    pub const SQUARED_PLUS : CodePoint = CodePoint::from(8862u32);
    pub const SQUARED_MINUS : CodePoint = CodePoint::from(8863u32);
    pub const SQUARED_TIMES : CodePoint = CodePoint::from(8864u32);
    pub const SQUARED_DOT_OPERATOR : CodePoint = CodePoint::from(8865u32);
    pub const RIGHT_TACK : CodePoint = CodePoint::from(8866u32);
    pub const LEFT_TACK : CodePoint = CodePoint::from(8867u32);
    pub const DOWN_TACK : CodePoint = CodePoint::from(8868u32);
    pub const UP_TACK : CodePoint = CodePoint::from(8869u32);
    pub const ASSERTION : CodePoint = CodePoint::from(8870u32);
    pub const MODELS : CodePoint = CodePoint::from(8871u32);
    pub const TRUE : CodePoint = CodePoint::from(8872u32);
    pub const FORCES : CodePoint = CodePoint::from(8873u32);
    pub const TRIPLE_VERTICAL_BAR_RIGHT_TURNSTILE : CodePoint = CodePoint::from(8874u32);
    pub const DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE : CodePoint = CodePoint::from(8875u32);
    pub const DOES_NOT_PROVE : CodePoint = CodePoint::from(8876u32);
    pub const NOT_TRUE : CodePoint = CodePoint::from(8877u32);
    pub const DOES_NOT_FORCE : CodePoint = CodePoint::from(8878u32);
    pub const NEGATED_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE : CodePoint = CodePoint::from(8879u32);
    pub const PRECEDES_UNDER_RELATION : CodePoint = CodePoint::from(8880u32);
    pub const SUCCEEDS_UNDER_RELATION : CodePoint = CodePoint::from(8881u32);
    pub const NORMAL_SUBGROUP_OF : CodePoint = CodePoint::from(8882u32);
    pub const CONTAINS_AS_NORMAL_SUBGROUP : CodePoint = CodePoint::from(8883u32);
    pub const NORMAL_SUBGROUP_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8884u32);
    pub const CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO : CodePoint = CodePoint::from(8885u32);
    pub const ORIGINAL_OF : CodePoint = CodePoint::from(8886u32);
    pub const IMAGE_OF : CodePoint = CodePoint::from(8887u32);
    pub const MULTIMAP : CodePoint = CodePoint::from(8888u32);
    pub const HERMITIAN_CONJUGATE_MATRIX : CodePoint = CodePoint::from(8889u32);
    pub const INTERCALATE : CodePoint = CodePoint::from(8890u32);
    pub const XOR : CodePoint = CodePoint::from(8891u32);
    pub const NAND : CodePoint = CodePoint::from(8892u32);
    pub const NOR : CodePoint = CodePoint::from(8893u32);
    pub const RIGHT_ANGLE_WITH_ARC : CodePoint = CodePoint::from(8894u32);
    pub const RIGHT_TRIANGLE : CodePoint = CodePoint::from(8895u32);
    pub const N_ARY_LOGICAL_AND : CodePoint = CodePoint::from(8896u32);
    pub const N_ARY_LOGICAL_OR : CodePoint = CodePoint::from(8897u32);
    pub const N_ARY_INTERSECTION : CodePoint = CodePoint::from(8898u32);
    pub const N_ARY_UNION : CodePoint = CodePoint::from(8899u32);
    pub const DIAMOND_OPERATOR : CodePoint = CodePoint::from(8900u32);
    pub const DOT_OPERATOR : CodePoint = CodePoint::from(8901u32);
    pub const STAR_OPERATOR : CodePoint = CodePoint::from(8902u32);
    pub const DIVISION_TIMES : CodePoint = CodePoint::from(8903u32);
    pub const BOWTIE : CodePoint = CodePoint::from(8904u32);
    pub const LEFT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT : CodePoint = CodePoint::from(8905u32);
    pub const RIGHT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT : CodePoint = CodePoint::from(8906u32);
    pub const LEFT_SEMIDIRECT_PRODUCT : CodePoint = CodePoint::from(8907u32);
    pub const RIGHT_SEMIDIRECT_PRODUCT : CodePoint = CodePoint::from(8908u32);
    pub const REVERSED_TILDE_EQUALS : CodePoint = CodePoint::from(8909u32);
    pub const CURLY_LOGICAL_OR : CodePoint = CodePoint::from(8910u32);
    pub const CURLY_LOGICAL_AND : CodePoint = CodePoint::from(8911u32);
    pub const DOUBLE_SUBSET : CodePoint = CodePoint::from(8912u32);
    pub const DOUBLE_SUPERSET : CodePoint = CodePoint::from(8913u32);
    pub const DOUBLE_INTERSECTION : CodePoint = CodePoint::from(8914u32);
    pub const DOUBLE_UNION : CodePoint = CodePoint::from(8915u32);
    pub const PITCHFORK : CodePoint = CodePoint::from(8916u32);
    pub const EQUAL_AND_PARALLEL_TO : CodePoint = CodePoint::from(8917u32);
    pub const LESS_THAN_WITH_DOT : CodePoint = CodePoint::from(8918u32);
    pub const GREATER_THAN_WITH_DOT : CodePoint = CodePoint::from(8919u32);
    pub const VERY_MUCH_LESS_THAN : CodePoint = CodePoint::from(8920u32);
    pub const VERY_MUCH_GREATER_THAN : CodePoint = CodePoint::from(8921u32);
    pub const LESS_THAN_EQUAL_TO_OR_GREATER_THAN : CodePoint = CodePoint::from(8922u32);
    pub const GREATER_THAN_EQUAL_TO_OR_LESS_THAN : CodePoint = CodePoint::from(8923u32);
    pub const EQUAL_TO_OR_LESS_THAN : CodePoint = CodePoint::from(8924u32);
    pub const EQUAL_TO_OR_GREATER_THAN : CodePoint = CodePoint::from(8925u32);
    pub const EQUAL_TO_OR_PRECEDES : CodePoint = CodePoint::from(8926u32);
    pub const EQUAL_TO_OR_SUCCEEDS : CodePoint = CodePoint::from(8927u32);
    pub const DOES_NOT_PRECEDE_OR_EQUAL : CodePoint = CodePoint::from(8928u32);
    pub const DOES_NOT_SUCCEED_OR_EQUAL : CodePoint = CodePoint::from(8929u32);
    pub const NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8930u32);
    pub const NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8931u32);
    pub const SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO : CodePoint = CodePoint::from(8932u32);
    pub const SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO : CodePoint = CodePoint::from(8933u32);
    pub const LESS_THAN_BUT_NOT_EQUIVALENT_TO : CodePoint = CodePoint::from(8934u32);
    pub const GREATER_THAN_BUT_NOT_EQUIVALENT_TO : CodePoint = CodePoint::from(8935u32);
    pub const PRECEDES_BUT_NOT_EQUIVALENT_TO : CodePoint = CodePoint::from(8936u32);
    pub const SUCCEEDS_BUT_NOT_EQUIVALENT_TO : CodePoint = CodePoint::from(8937u32);
    pub const NOT_NORMAL_SUBGROUP_OF : CodePoint = CodePoint::from(8938u32);
    pub const DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP : CodePoint = CodePoint::from(8939u32);
    pub const NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO : CodePoint = CodePoint::from(8940u32);
    pub const DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL : CodePoint = CodePoint::from(8941u32);
    pub const VERTICAL_ELLIPSIS : CodePoint = CodePoint::from(8942u32);
    pub const MIDLINE_HORIZONTAL_ELLIPSIS : CodePoint = CodePoint::from(8943u32);
    pub const UP_RIGHT_DIAGONAL_ELLIPSIS : CodePoint = CodePoint::from(8944u32);
    pub const DOWN_RIGHT_DIAGONAL_ELLIPSIS : CodePoint = CodePoint::from(8945u32);
    pub const ELEMENT_OF_WITH_LONG_HORIZONTAL_STROKE : CodePoint = CodePoint::from(8946u32);
    pub const ELEMENT_OF_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE : CodePoint = CodePoint::from(8947u32);
    pub const SMALL_ELEMENT_OF_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE : CodePoint = CodePoint::from(8948u32);
    pub const ELEMENT_OF_WITH_DOT_ABOVE : CodePoint = CodePoint::from(8949u32);
    pub const ELEMENT_OF_WITH_OVERBAR : CodePoint = CodePoint::from(8950u32);
    pub const SMALL_ELEMENT_OF_WITH_OVERBAR : CodePoint = CodePoint::from(8951u32);
    pub const ELEMENT_OF_WITH_UNDERBAR : CodePoint = CodePoint::from(8952u32);
    pub const ELEMENT_OF_WITH_TWO_HORIZONTAL_STROKES : CodePoint = CodePoint::from(8953u32);
    pub const CONTAINS_WITH_LONG_HORIZONTAL_STROKE : CodePoint = CodePoint::from(8954u32);
    pub const CONTAINS_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE : CodePoint = CodePoint::from(8955u32);
    pub const SMALL_CONTAINS_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE : CodePoint = CodePoint::from(8956u32);
    pub const CONTAINS_WITH_OVERBAR : CodePoint = CodePoint::from(8957u32);
    pub const SMALL_CONTAINS_WITH_OVERBAR : CodePoint = CodePoint::from(8958u32);
    pub const Z_NOTATION_BAG_MEMBERSHIP : CodePoint = CodePoint::from(8959u32);
    pub const DIAMETER_SIGN : CodePoint = CodePoint::from(8960u32);
    pub const ELECTRIC_ARROW : CodePoint = CodePoint::from(8961u32);
    pub const HOUSE : CodePoint = CodePoint::from(8962u32);
    pub const UP_ARROWHEAD : CodePoint = CodePoint::from(8963u32);
    pub const DOWN_ARROWHEAD : CodePoint = CodePoint::from(8964u32);
    pub const PROJECTIVE : CodePoint = CodePoint::from(8965u32);
    pub const PERSPECTIVE : CodePoint = CodePoint::from(8966u32);
    pub const WAVY_LINE : CodePoint = CodePoint::from(8967u32);
    pub const LEFT_CEILING : CodePoint = CodePoint::from(8968u32);
    pub const RIGHT_CEILING : CodePoint = CodePoint::from(8969u32);
    pub const LEFT_FLOOR : CodePoint = CodePoint::from(8970u32);
    pub const RIGHT_FLOOR : CodePoint = CodePoint::from(8971u32);
    pub const BOTTOM_RIGHT_CROP : CodePoint = CodePoint::from(8972u32);
    pub const BOTTOM_LEFT_CROP : CodePoint = CodePoint::from(8973u32);
    pub const TOP_RIGHT_CROP : CodePoint = CodePoint::from(8974u32);
    pub const TOP_LEFT_CROP : CodePoint = CodePoint::from(8975u32);
    pub const REVERSED_NOT_SIGN : CodePoint = CodePoint::from(8976u32);
    pub const SQUARE_LOZENGE : CodePoint = CodePoint::from(8977u32);
    pub const ARC : CodePoint = CodePoint::from(8978u32);
    pub const SEGMENT : CodePoint = CodePoint::from(8979u32);
    pub const SECTOR : CodePoint = CodePoint::from(8980u32);
    pub const TELEPHONE_RECORDER : CodePoint = CodePoint::from(8981u32);
    pub const POSITION_INDICATOR : CodePoint = CodePoint::from(8982u32);
    pub const VIEWDATA_SQUARE : CodePoint = CodePoint::from(8983u32);
    pub const PLACE_OF_INTEREST_SIGN : CodePoint = CodePoint::from(8984u32);
    pub const TURNED_NOT_SIGN : CodePoint = CodePoint::from(8985u32);
    pub const WATCH : CodePoint = CodePoint::from(8986u32);
    pub const HOURGLASS : CodePoint = CodePoint::from(8987u32);
    pub const TOP_LEFT_CORNER : CodePoint = CodePoint::from(8988u32);
    pub const TOP_RIGHT_CORNER : CodePoint = CodePoint::from(8989u32);
    pub const BOTTOM_LEFT_CORNER : CodePoint = CodePoint::from(8990u32);
    pub const BOTTOM_RIGHT_CORNER : CodePoint = CodePoint::from(8991u32);
    pub const TOP_HALF_INTEGRAL : CodePoint = CodePoint::from(8992u32);
    pub const BOTTOM_HALF_INTEGRAL : CodePoint = CodePoint::from(8993u32);
    pub const FROWN : CodePoint = CodePoint::from(8994u32);
    pub const SMILE : CodePoint = CodePoint::from(8995u32);
    pub const UP_ARROWHEAD_BETWEEN_TWO_HORIZONTAL_BARS : CodePoint = CodePoint::from(8996u32);
    pub const OPTION_KEY : CodePoint = CodePoint::from(8997u32);
    pub const ERASE_TO_THE_RIGHT : CodePoint = CodePoint::from(8998u32);
    pub const X_IN_A_RECTANGLE_BOX : CodePoint = CodePoint::from(8999u32);
    pub const KEYBOARD : CodePoint = CodePoint::from(9000u32);
    pub const LEFT_POINTING_ANGLE_BRACKET : CodePoint = CodePoint::from(9001u32);
    pub const RIGHT_POINTING_ANGLE_BRACKET : CodePoint = CodePoint::from(9002u32);
    pub const ERASE_TO_THE_LEFT : CodePoint = CodePoint::from(9003u32);
    pub const BENZENE_RING : CodePoint = CodePoint::from(9004u32);
    pub const CYLINDRICITY : CodePoint = CodePoint::from(9005u32);
    pub const ALL_AROUND_PROFILE : CodePoint = CodePoint::from(9006u32);
    pub const SYMMETRY : CodePoint = CodePoint::from(9007u32);
    pub const TOTAL_RUNOUT : CodePoint = CodePoint::from(9008u32);
    pub const DIMENSION_ORIGIN : CodePoint = CodePoint::from(9009u32);
    pub const CONICAL_TAPER : CodePoint = CodePoint::from(9010u32);
    pub const SLOPE : CodePoint = CodePoint::from(9011u32);
    pub const COUNTERBORE : CodePoint = CodePoint::from(9012u32);
    pub const COUNTERSINK : CodePoint = CodePoint::from(9013u32);
    pub const APL_FUNCTIONAL_SYMBOL_I_BEAM : CodePoint = CodePoint::from(9014u32);
    pub const APL_FUNCTIONAL_SYMBOL_SQUISH_QUAD : CodePoint = CodePoint::from(9015u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_EQUAL : CodePoint = CodePoint::from(9016u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_DIVIDE : CodePoint = CodePoint::from(9017u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_DIAMOND : CodePoint = CodePoint::from(9018u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_JOT : CodePoint = CodePoint::from(9019u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_CIRCLE : CodePoint = CodePoint::from(9020u32);
    pub const APL_FUNCTIONAL_SYMBOL_CIRCLE_STILE : CodePoint = CodePoint::from(9021u32);
    pub const APL_FUNCTIONAL_SYMBOL_CIRCLE_JOT : CodePoint = CodePoint::from(9022u32);
    pub const APL_FUNCTIONAL_SYMBOL_SLASH_BAR : CodePoint = CodePoint::from(9023u32);
    pub const APL_FUNCTIONAL_SYMBOL_BACKSLASH_BAR : CodePoint = CodePoint::from(9024u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_SLASH : CodePoint = CodePoint::from(9025u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_BACKSLASH : CodePoint = CodePoint::from(9026u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_LESS_THAN : CodePoint = CodePoint::from(9027u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_GREATER_THAN : CodePoint = CodePoint::from(9028u32);
    pub const APL_FUNCTIONAL_SYMBOL_LEFTWARDS_VANE : CodePoint = CodePoint::from(9029u32);
    pub const APL_FUNCTIONAL_SYMBOL_RIGHTWARDS_VANE : CodePoint = CodePoint::from(9030u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_LEFTWARDS_ARROW : CodePoint = CodePoint::from(9031u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(9032u32);
    pub const APL_FUNCTIONAL_SYMBOL_CIRCLE_BACKSLASH : CodePoint = CodePoint::from(9033u32);
    pub const APL_FUNCTIONAL_SYMBOL_DOWN_TACK_UNDERBAR : CodePoint = CodePoint::from(9034u32);
    pub const APL_FUNCTIONAL_SYMBOL_DELTA_STILE : CodePoint = CodePoint::from(9035u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_DOWN_CARET : CodePoint = CodePoint::from(9036u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_DELTA : CodePoint = CodePoint::from(9037u32);
    pub const APL_FUNCTIONAL_SYMBOL_DOWN_TACK_JOT : CodePoint = CodePoint::from(9038u32);
    pub const APL_FUNCTIONAL_SYMBOL_UPWARDS_VANE : CodePoint = CodePoint::from(9039u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_UPWARDS_ARROW : CodePoint = CodePoint::from(9040u32);
    pub const APL_FUNCTIONAL_SYMBOL_UP_TACK_OVERBAR : CodePoint = CodePoint::from(9041u32);
    pub const APL_FUNCTIONAL_SYMBOL_DEL_STILE : CodePoint = CodePoint::from(9042u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_UP_CARET : CodePoint = CodePoint::from(9043u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_DEL : CodePoint = CodePoint::from(9044u32);
    pub const APL_FUNCTIONAL_SYMBOL_UP_TACK_JOT : CodePoint = CodePoint::from(9045u32);
    pub const APL_FUNCTIONAL_SYMBOL_DOWNWARDS_VANE : CodePoint = CodePoint::from(9046u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_DOWNWARDS_ARROW : CodePoint = CodePoint::from(9047u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUOTE_UNDERBAR : CodePoint = CodePoint::from(9048u32);
    pub const APL_FUNCTIONAL_SYMBOL_DELTA_UNDERBAR : CodePoint = CodePoint::from(9049u32);
    pub const APL_FUNCTIONAL_SYMBOL_DIAMOND_UNDERBAR : CodePoint = CodePoint::from(9050u32);
    pub const APL_FUNCTIONAL_SYMBOL_JOT_UNDERBAR : CodePoint = CodePoint::from(9051u32);
    pub const APL_FUNCTIONAL_SYMBOL_CIRCLE_UNDERBAR : CodePoint = CodePoint::from(9052u32);
    pub const APL_FUNCTIONAL_SYMBOL_UP_SHOE_JOT : CodePoint = CodePoint::from(9053u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUOTE_QUAD : CodePoint = CodePoint::from(9054u32);
    pub const APL_FUNCTIONAL_SYMBOL_CIRCLE_STAR : CodePoint = CodePoint::from(9055u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_COLON : CodePoint = CodePoint::from(9056u32);
    pub const APL_FUNCTIONAL_SYMBOL_UP_TACK_DIAERESIS : CodePoint = CodePoint::from(9057u32);
    pub const APL_FUNCTIONAL_SYMBOL_DEL_DIAERESIS : CodePoint = CodePoint::from(9058u32);
    pub const APL_FUNCTIONAL_SYMBOL_STAR_DIAERESIS : CodePoint = CodePoint::from(9059u32);
    pub const APL_FUNCTIONAL_SYMBOL_JOT_DIAERESIS : CodePoint = CodePoint::from(9060u32);
    pub const APL_FUNCTIONAL_SYMBOL_CIRCLE_DIAERESIS : CodePoint = CodePoint::from(9061u32);
    pub const APL_FUNCTIONAL_SYMBOL_DOWN_SHOE_STILE : CodePoint = CodePoint::from(9062u32);
    pub const APL_FUNCTIONAL_SYMBOL_LEFT_SHOE_STILE : CodePoint = CodePoint::from(9063u32);
    pub const APL_FUNCTIONAL_SYMBOL_TILDE_DIAERESIS : CodePoint = CodePoint::from(9064u32);
    pub const APL_FUNCTIONAL_SYMBOL_GREATER_THAN_DIAERESIS : CodePoint = CodePoint::from(9065u32);
    pub const APL_FUNCTIONAL_SYMBOL_COMMA_BAR : CodePoint = CodePoint::from(9066u32);
    pub const APL_FUNCTIONAL_SYMBOL_DEL_TILDE : CodePoint = CodePoint::from(9067u32);
    pub const APL_FUNCTIONAL_SYMBOL_ZILDE : CodePoint = CodePoint::from(9068u32);
    pub const APL_FUNCTIONAL_SYMBOL_STILE_TILDE : CodePoint = CodePoint::from(9069u32);
    pub const APL_FUNCTIONAL_SYMBOL_SEMICOLON_UNDERBAR : CodePoint = CodePoint::from(9070u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_NOT_EQUAL : CodePoint = CodePoint::from(9071u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD_QUESTION : CodePoint = CodePoint::from(9072u32);
    pub const APL_FUNCTIONAL_SYMBOL_DOWN_CARET_TILDE : CodePoint = CodePoint::from(9073u32);
    pub const APL_FUNCTIONAL_SYMBOL_UP_CARET_TILDE : CodePoint = CodePoint::from(9074u32);
    pub const APL_FUNCTIONAL_SYMBOL_IOTA : CodePoint = CodePoint::from(9075u32);
    pub const APL_FUNCTIONAL_SYMBOL_RHO : CodePoint = CodePoint::from(9076u32);
    pub const APL_FUNCTIONAL_SYMBOL_OMEGA : CodePoint = CodePoint::from(9077u32);
    pub const APL_FUNCTIONAL_SYMBOL_ALPHA_UNDERBAR : CodePoint = CodePoint::from(9078u32);
    pub const APL_FUNCTIONAL_SYMBOL_EPSILON_UNDERBAR : CodePoint = CodePoint::from(9079u32);
    pub const APL_FUNCTIONAL_SYMBOL_IOTA_UNDERBAR : CodePoint = CodePoint::from(9080u32);
    pub const APL_FUNCTIONAL_SYMBOL_OMEGA_UNDERBAR : CodePoint = CodePoint::from(9081u32);
    pub const APL_FUNCTIONAL_SYMBOL_ALPHA : CodePoint = CodePoint::from(9082u32);
    pub const NOT_CHECK_MARK : CodePoint = CodePoint::from(9083u32);
    pub const RIGHT_ANGLE_WITH_DOWNWARDS_ZIGZAG_ARROW : CodePoint = CodePoint::from(9084u32);
    pub const SHOULDERED_OPEN_BOX : CodePoint = CodePoint::from(9085u32);
    pub const BELL_SYMBOL : CodePoint = CodePoint::from(9086u32);
    pub const VERTICAL_LINE_WITH_MIDDLE_DOT : CodePoint = CodePoint::from(9087u32);
    pub const INSERTION_SYMBOL : CodePoint = CodePoint::from(9088u32);
    pub const CONTINUOUS_UNDERLINE_SYMBOL : CodePoint = CodePoint::from(9089u32);
    pub const DISCONTINUOUS_UNDERLINE_SYMBOL : CodePoint = CodePoint::from(9090u32);
    pub const EMPHASIS_SYMBOL : CodePoint = CodePoint::from(9091u32);
    pub const COMPOSITION_SYMBOL : CodePoint = CodePoint::from(9092u32);
    pub const WHITE_SQUARE_WITH_CENTRE_VERTICAL_LINE : CodePoint = CodePoint::from(9093u32);
    pub const ENTER_SYMBOL : CodePoint = CodePoint::from(9094u32);
    pub const ALTERNATIVE_KEY_SYMBOL : CodePoint = CodePoint::from(9095u32);
    pub const HELM_SYMBOL : CodePoint = CodePoint::from(9096u32);
    pub const CIRCLED_HORIZONTAL_BAR_WITH_NOTCH : CodePoint = CodePoint::from(9097u32);
    pub const CIRCLED_TRIANGLE_DOWN : CodePoint = CodePoint::from(9098u32);
    pub const BROKEN_CIRCLE_WITH_NORTHWEST_ARROW : CodePoint = CodePoint::from(9099u32);
    pub const UNDO_SYMBOL : CodePoint = CodePoint::from(9100u32);
    pub const MONOSTABLE_SYMBOL : CodePoint = CodePoint::from(9101u32);
    pub const HYSTERESIS_SYMBOL : CodePoint = CodePoint::from(9102u32);
    pub const OPEN_CIRCUIT_OUTPUT_H_TYPE_SYMBOL : CodePoint = CodePoint::from(9103u32);
    pub const OPEN_CIRCUIT_OUTPUT_L_TYPE_SYMBOL : CodePoint = CodePoint::from(9104u32);
    pub const PASSIVE_PULL_DOWN_OUTPUT_SYMBOL : CodePoint = CodePoint::from(9105u32);
    pub const PASSIVE_PULL_UP_OUTPUT_SYMBOL : CodePoint = CodePoint::from(9106u32);
    pub const DIRECT_CURRENT_SYMBOL_FORM_TWO : CodePoint = CodePoint::from(9107u32);
    pub const SOFTWARE_FUNCTION_SYMBOL : CodePoint = CodePoint::from(9108u32);
    pub const APL_FUNCTIONAL_SYMBOL_QUAD : CodePoint = CodePoint::from(9109u32);
    pub const DECIMAL_SEPARATOR_KEY_SYMBOL : CodePoint = CodePoint::from(9110u32);
    pub const PREVIOUS_PAGE : CodePoint = CodePoint::from(9111u32);
    pub const NEXT_PAGE : CodePoint = CodePoint::from(9112u32);
    pub const PRINT_SCREEN_SYMBOL : CodePoint = CodePoint::from(9113u32);
    pub const CLEAR_SCREEN_SYMBOL : CodePoint = CodePoint::from(9114u32);
    pub const LEFT_PARENTHESIS_UPPER_HOOK : CodePoint = CodePoint::from(9115u32);
    pub const LEFT_PARENTHESIS_EXTENSION : CodePoint = CodePoint::from(9116u32);
    pub const LEFT_PARENTHESIS_LOWER_HOOK : CodePoint = CodePoint::from(9117u32);
    pub const RIGHT_PARENTHESIS_UPPER_HOOK : CodePoint = CodePoint::from(9118u32);
    pub const RIGHT_PARENTHESIS_EXTENSION : CodePoint = CodePoint::from(9119u32);
    pub const RIGHT_PARENTHESIS_LOWER_HOOK : CodePoint = CodePoint::from(9120u32);
    pub const LEFT_SQUARE_BRACKET_UPPER_CORNER : CodePoint = CodePoint::from(9121u32);
    pub const LEFT_SQUARE_BRACKET_EXTENSION : CodePoint = CodePoint::from(9122u32);
    pub const LEFT_SQUARE_BRACKET_LOWER_CORNER : CodePoint = CodePoint::from(9123u32);
    pub const RIGHT_SQUARE_BRACKET_UPPER_CORNER : CodePoint = CodePoint::from(9124u32);
    pub const RIGHT_SQUARE_BRACKET_EXTENSION : CodePoint = CodePoint::from(9125u32);
    pub const RIGHT_SQUARE_BRACKET_LOWER_CORNER : CodePoint = CodePoint::from(9126u32);
    pub const LEFT_CURLY_BRACKET_UPPER_HOOK : CodePoint = CodePoint::from(9127u32);
    pub const LEFT_CURLY_BRACKET_MIDDLE_PIECE : CodePoint = CodePoint::from(9128u32);
    pub const LEFT_CURLY_BRACKET_LOWER_HOOK : CodePoint = CodePoint::from(9129u32);
    pub const CURLY_BRACKET_EXTENSION : CodePoint = CodePoint::from(9130u32);
    pub const RIGHT_CURLY_BRACKET_UPPER_HOOK : CodePoint = CodePoint::from(9131u32);
    pub const RIGHT_CURLY_BRACKET_MIDDLE_PIECE : CodePoint = CodePoint::from(9132u32);
    pub const RIGHT_CURLY_BRACKET_LOWER_HOOK : CodePoint = CodePoint::from(9133u32);
    pub const INTEGRAL_EXTENSION : CodePoint = CodePoint::from(9134u32);
    pub const HORIZONTAL_LINE_EXTENSION : CodePoint = CodePoint::from(9135u32);
    pub const UPPER_LEFT_OR_LOWER_RIGHT_CURLY_BRACKET_SECTION : CodePoint = CodePoint::from(9136u32);
    pub const UPPER_RIGHT_OR_LOWER_LEFT_CURLY_BRACKET_SECTION : CodePoint = CodePoint::from(9137u32);
    pub const SUMMATION_TOP : CodePoint = CodePoint::from(9138u32);
    pub const SUMMATION_BOTTOM : CodePoint = CodePoint::from(9139u32);
    pub const TOP_SQUARE_BRACKET : CodePoint = CodePoint::from(9140u32);
    pub const BOTTOM_SQUARE_BRACKET : CodePoint = CodePoint::from(9141u32);
    pub const BOTTOM_SQUARE_BRACKET_OVER_TOP_SQUARE_BRACKET : CodePoint = CodePoint::from(9142u32);
    pub const RADICAL_SYMBOL_BOTTOM : CodePoint = CodePoint::from(9143u32);
    pub const LEFT_VERTICAL_BOX_LINE : CodePoint = CodePoint::from(9144u32);
    pub const RIGHT_VERTICAL_BOX_LINE : CodePoint = CodePoint::from(9145u32);
    pub const HORIZONTAL_SCAN_LINE_1 : CodePoint = CodePoint::from(9146u32);
    pub const HORIZONTAL_SCAN_LINE_3 : CodePoint = CodePoint::from(9147u32);
    pub const HORIZONTAL_SCAN_LINE_7 : CodePoint = CodePoint::from(9148u32);
    pub const HORIZONTAL_SCAN_LINE_9 : CodePoint = CodePoint::from(9149u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_TOP_RIGHT : CodePoint = CodePoint::from(9150u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_BOTTOM_RIGHT : CodePoint = CodePoint::from(9151u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_WITH_CIRCLE : CodePoint = CodePoint::from(9152u32);
    pub const DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_CIRCLE : CodePoint = CodePoint::from(9153u32);
    pub const DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_CIRCLE : CodePoint = CodePoint::from(9154u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_WITH_TRIANGLE : CodePoint = CodePoint::from(9155u32);
    pub const DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_TRIANGLE : CodePoint = CodePoint::from(9156u32);
    pub const DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_TRIANGLE : CodePoint = CodePoint::from(9157u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_WAVE : CodePoint = CodePoint::from(9158u32);
    pub const DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_WAVE : CodePoint = CodePoint::from(9159u32);
    pub const DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_WAVE : CodePoint = CodePoint::from(9160u32);
    pub const DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL : CodePoint = CodePoint::from(9161u32);
    pub const DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL : CodePoint = CodePoint::from(9162u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_TOP_LEFT : CodePoint = CodePoint::from(9163u32);
    pub const DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_BOTTOM_LEFT : CodePoint = CodePoint::from(9164u32);
    pub const SQUARE_FOOT : CodePoint = CodePoint::from(9165u32);
    pub const RETURN_SYMBOL : CodePoint = CodePoint::from(9166u32);
    pub const EJECT_SYMBOL : CodePoint = CodePoint::from(9167u32);
    pub const VERTICAL_LINE_EXTENSION : CodePoint = CodePoint::from(9168u32);
    pub const METRICAL_BREVE : CodePoint = CodePoint::from(9169u32);
    pub const METRICAL_LONG_OVER_SHORT : CodePoint = CodePoint::from(9170u32);
    pub const METRICAL_SHORT_OVER_LONG : CodePoint = CodePoint::from(9171u32);
    pub const METRICAL_LONG_OVER_TWO_SHORTS : CodePoint = CodePoint::from(9172u32);
    pub const METRICAL_TWO_SHORTS_OVER_LONG : CodePoint = CodePoint::from(9173u32);
    pub const METRICAL_TWO_SHORTS_JOINED : CodePoint = CodePoint::from(9174u32);
    pub const METRICAL_TRISEME : CodePoint = CodePoint::from(9175u32);
    pub const METRICAL_TETRASEME : CodePoint = CodePoint::from(9176u32);
    pub const METRICAL_PENTASEME : CodePoint = CodePoint::from(9177u32);
    pub const EARTH_GROUND : CodePoint = CodePoint::from(9178u32);
    pub const FUSE : CodePoint = CodePoint::from(9179u32);
    pub const TOP_PARENTHESIS : CodePoint = CodePoint::from(9180u32);
    pub const BOTTOM_PARENTHESIS : CodePoint = CodePoint::from(9181u32);
    pub const TOP_CURLY_BRACKET : CodePoint = CodePoint::from(9182u32);
    pub const BOTTOM_CURLY_BRACKET : CodePoint = CodePoint::from(9183u32);
    pub const TOP_TORTOISE_SHELL_BRACKET : CodePoint = CodePoint::from(9184u32);
    pub const BOTTOM_TORTOISE_SHELL_BRACKET : CodePoint = CodePoint::from(9185u32);
    pub const WHITE_TRAPEZIUM : CodePoint = CodePoint::from(9186u32);
    pub const BENZENE_RING_WITH_CIRCLE : CodePoint = CodePoint::from(9187u32);
    pub const STRAIGHTNESS : CodePoint = CodePoint::from(9188u32);
    pub const FLATNESS : CodePoint = CodePoint::from(9189u32);
    pub const AC_CURRENT : CodePoint = CodePoint::from(9190u32);
    pub const ELECTRICAL_INTERSECTION : CodePoint = CodePoint::from(9191u32);
    pub const DECIMAL_EXPONENT_SYMBOL : CodePoint = CodePoint::from(9192u32);
    pub const BLACK_RIGHT_POINTING_DOUBLE_TRIANGLE : CodePoint = CodePoint::from(9193u32);
    pub const BLACK_LEFT_POINTING_DOUBLE_TRIANGLE : CodePoint = CodePoint::from(9194u32);
    pub const BLACK_UP_POINTING_DOUBLE_TRIANGLE : CodePoint = CodePoint::from(9195u32);
    pub const BLACK_DOWN_POINTING_DOUBLE_TRIANGLE : CodePoint = CodePoint::from(9196u32);
    pub const BLACK_RIGHT_POINTING_DOUBLE_TRIANGLE_WITH_VERTICAL_BAR : CodePoint = CodePoint::from(9197u32);
    pub const BLACK_LEFT_POINTING_DOUBLE_TRIANGLE_WITH_VERTICAL_BAR : CodePoint = CodePoint::from(9198u32);
    pub const BLACK_RIGHT_POINTING_TRIANGLE_WITH_DOUBLE_VERTICAL_BAR : CodePoint = CodePoint::from(9199u32);
    pub const ALARM_CLOCK : CodePoint = CodePoint::from(9200u32);
    pub const STOPWATCH : CodePoint = CodePoint::from(9201u32);
    pub const TIMER_CLOCK : CodePoint = CodePoint::from(9202u32);
    pub const HOURGLASS_WITH_FLOWING_SAND : CodePoint = CodePoint::from(9203u32);
    pub const BLACK_MEDIUM_LEFT_POINTING_TRIANGLE : CodePoint = CodePoint::from(9204u32);
    pub const BLACK_MEDIUM_RIGHT_POINTING_TRIANGLE : CodePoint = CodePoint::from(9205u32);
    pub const BLACK_MEDIUM_UP_POINTING_TRIANGLE : CodePoint = CodePoint::from(9206u32);
    pub const BLACK_MEDIUM_DOWN_POINTING_TRIANGLE : CodePoint = CodePoint::from(9207u32);
    pub const DOUBLE_VERTICAL_BAR : CodePoint = CodePoint::from(9208u32);
    pub const BLACK_SQUARE_FOR_STOP : CodePoint = CodePoint::from(9209u32);
    pub const BLACK_CIRCLE_FOR_RECORD : CodePoint = CodePoint::from(9210u32);
    pub const POWER_SYMBOL : CodePoint = CodePoint::from(9211u32);
    pub const POWER_ON_OFF_SYMBOL : CodePoint = CodePoint::from(9212u32);
    pub const POWER_ON_SYMBOL : CodePoint = CodePoint::from(9213u32);
    pub const POWER_SLEEP_SYMBOL : CodePoint = CodePoint::from(9214u32);
    pub const OBSERVER_EYE_SYMBOL : CodePoint = CodePoint::from(9215u32);
    pub const SYMBOL_FOR_NULL : CodePoint = CodePoint::from(9216u32);
    pub const SYMBOL_FOR_START_OF_HEADING : CodePoint = CodePoint::from(9217u32);
    pub const SYMBOL_FOR_START_OF_TEXT : CodePoint = CodePoint::from(9218u32);
    pub const SYMBOL_FOR_END_OF_TEXT : CodePoint = CodePoint::from(9219u32);
    pub const SYMBOL_FOR_END_OF_TRANSMISSION : CodePoint = CodePoint::from(9220u32);
    pub const SYMBOL_FOR_ENQUIRY : CodePoint = CodePoint::from(9221u32);
    pub const SYMBOL_FOR_ACKNOWLEDGE : CodePoint = CodePoint::from(9222u32);
    pub const SYMBOL_FOR_BELL : CodePoint = CodePoint::from(9223u32);
    pub const SYMBOL_FOR_BACKSPACE : CodePoint = CodePoint::from(9224u32);
    pub const SYMBOL_FOR_HORIZONTAL_TABULATION : CodePoint = CodePoint::from(9225u32);
    pub const SYMBOL_FOR_LINE_FEED : CodePoint = CodePoint::from(9226u32);
    pub const SYMBOL_FOR_VERTICAL_TABULATION : CodePoint = CodePoint::from(9227u32);
    pub const SYMBOL_FOR_FORM_FEED : CodePoint = CodePoint::from(9228u32);
    pub const SYMBOL_FOR_CARRIAGE_RETURN : CodePoint = CodePoint::from(9229u32);
    pub const SYMBOL_FOR_SHIFT_OUT : CodePoint = CodePoint::from(9230u32);
    pub const SYMBOL_FOR_SHIFT_IN : CodePoint = CodePoint::from(9231u32);
    pub const SYMBOL_FOR_DATA_LINK_ESCAPE : CodePoint = CodePoint::from(9232u32);
    pub const SYMBOL_FOR_DEVICE_CONTROL_ONE : CodePoint = CodePoint::from(9233u32);
    pub const SYMBOL_FOR_DEVICE_CONTROL_TWO : CodePoint = CodePoint::from(9234u32);
    pub const SYMBOL_FOR_DEVICE_CONTROL_THREE : CodePoint = CodePoint::from(9235u32);
    pub const SYMBOL_FOR_DEVICE_CONTROL_FOUR : CodePoint = CodePoint::from(9236u32);
    pub const SYMBOL_FOR_NEGATIVE_ACKNOWLEDGE : CodePoint = CodePoint::from(9237u32);
    pub const SYMBOL_FOR_SYNCHRONOUS_IDLE : CodePoint = CodePoint::from(9238u32);
    pub const SYMBOL_FOR_END_OF_TRANSMISSION_BLOCK : CodePoint = CodePoint::from(9239u32);
    pub const SYMBOL_FOR_CANCEL : CodePoint = CodePoint::from(9240u32);
    pub const SYMBOL_FOR_END_OF_MEDIUM : CodePoint = CodePoint::from(9241u32);
    pub const SYMBOL_FOR_SUBSTITUTE : CodePoint = CodePoint::from(9242u32);
    pub const SYMBOL_FOR_ESCAPE : CodePoint = CodePoint::from(9243u32);
    pub const SYMBOL_FOR_FILE_SEPARATOR : CodePoint = CodePoint::from(9244u32);
    pub const SYMBOL_FOR_GROUP_SEPARATOR : CodePoint = CodePoint::from(9245u32);
    pub const SYMBOL_FOR_RECORD_SEPARATOR : CodePoint = CodePoint::from(9246u32);
    pub const SYMBOL_FOR_UNIT_SEPARATOR : CodePoint = CodePoint::from(9247u32);
    pub const SYMBOL_FOR_SPACE : CodePoint = CodePoint::from(9248u32);
    pub const SYMBOL_FOR_DELETE : CodePoint = CodePoint::from(9249u32);
    pub const BLANK_SYMBOL : CodePoint = CodePoint::from(9250u32);
    pub const OPEN_BOX : CodePoint = CodePoint::from(9251u32);
    pub const SYMBOL_FOR_NEWLINE : CodePoint = CodePoint::from(9252u32);
    pub const SYMBOL_FOR_DELETE_FORM_TWO : CodePoint = CodePoint::from(9253u32);
    pub const SYMBOL_FOR_SUBSTITUTE_FORM_TWO : CodePoint = CodePoint::from(9254u32);
    pub const OCR_HOOK : CodePoint = CodePoint::from(9280u32);
    pub const OCR_CHAIR : CodePoint = CodePoint::from(9281u32);
    pub const OCR_FORK : CodePoint = CodePoint::from(9282u32);
    pub const OCR_INVERTED_FORK : CodePoint = CodePoint::from(9283u32);
    pub const OCR_BELT_BUCKLE : CodePoint = CodePoint::from(9284u32);
    pub const OCR_BOW_TIE : CodePoint = CodePoint::from(9285u32);
    pub const OCR_BRANCH_BANK_IDENTIFICATION : CodePoint = CodePoint::from(9286u32);
    pub const OCR_AMOUNT_OF_CHECK : CodePoint = CodePoint::from(9287u32);
    pub const OCR_DASH : CodePoint = CodePoint::from(9288u32);
    pub const OCR_CUSTOMER_ACCOUNT_NUMBER : CodePoint = CodePoint::from(9289u32);
    pub const OCR_DOUBLE_BACKSLASH : CodePoint = CodePoint::from(9290u32);
    pub const CIRCLED_DIGIT_ONE : CodePoint = CodePoint::from(9312u32);
    pub const CIRCLED_DIGIT_TWO : CodePoint = CodePoint::from(9313u32);
    pub const CIRCLED_DIGIT_THREE : CodePoint = CodePoint::from(9314u32);
    pub const CIRCLED_DIGIT_FOUR : CodePoint = CodePoint::from(9315u32);
    pub const CIRCLED_DIGIT_FIVE : CodePoint = CodePoint::from(9316u32);
    pub const CIRCLED_DIGIT_SIX : CodePoint = CodePoint::from(9317u32);
    pub const CIRCLED_DIGIT_SEVEN : CodePoint = CodePoint::from(9318u32);
    pub const CIRCLED_DIGIT_EIGHT : CodePoint = CodePoint::from(9319u32);
    pub const CIRCLED_DIGIT_NINE : CodePoint = CodePoint::from(9320u32);
    pub const CIRCLED_NUMBER_TEN : CodePoint = CodePoint::from(9321u32);
    pub const CIRCLED_NUMBER_ELEVEN : CodePoint = CodePoint::from(9322u32);
    pub const CIRCLED_NUMBER_TWELVE : CodePoint = CodePoint::from(9323u32);
    pub const CIRCLED_NUMBER_THIRTEEN : CodePoint = CodePoint::from(9324u32);
    pub const CIRCLED_NUMBER_FOURTEEN : CodePoint = CodePoint::from(9325u32);
    pub const CIRCLED_NUMBER_FIFTEEN : CodePoint = CodePoint::from(9326u32);
    pub const CIRCLED_NUMBER_SIXTEEN : CodePoint = CodePoint::from(9327u32);
    pub const CIRCLED_NUMBER_SEVENTEEN : CodePoint = CodePoint::from(9328u32);
    pub const CIRCLED_NUMBER_EIGHTEEN : CodePoint = CodePoint::from(9329u32);
    pub const CIRCLED_NUMBER_NINETEEN : CodePoint = CodePoint::from(9330u32);
    pub const CIRCLED_NUMBER_TWENTY : CodePoint = CodePoint::from(9331u32);
    pub const PARENTHESIZED_DIGIT_ONE : CodePoint = CodePoint::from(9332u32);
    pub const PARENTHESIZED_DIGIT_TWO : CodePoint = CodePoint::from(9333u32);
    pub const PARENTHESIZED_DIGIT_THREE : CodePoint = CodePoint::from(9334u32);
    pub const PARENTHESIZED_DIGIT_FOUR : CodePoint = CodePoint::from(9335u32);
    pub const PARENTHESIZED_DIGIT_FIVE : CodePoint = CodePoint::from(9336u32);
    pub const PARENTHESIZED_DIGIT_SIX : CodePoint = CodePoint::from(9337u32);
    pub const PARENTHESIZED_DIGIT_SEVEN : CodePoint = CodePoint::from(9338u32);
    pub const PARENTHESIZED_DIGIT_EIGHT : CodePoint = CodePoint::from(9339u32);
    pub const PARENTHESIZED_DIGIT_NINE : CodePoint = CodePoint::from(9340u32);
    pub const PARENTHESIZED_NUMBER_TEN : CodePoint = CodePoint::from(9341u32);
    pub const PARENTHESIZED_NUMBER_ELEVEN : CodePoint = CodePoint::from(9342u32);
    pub const PARENTHESIZED_NUMBER_TWELVE : CodePoint = CodePoint::from(9343u32);
    pub const PARENTHESIZED_NUMBER_THIRTEEN : CodePoint = CodePoint::from(9344u32);
    pub const PARENTHESIZED_NUMBER_FOURTEEN : CodePoint = CodePoint::from(9345u32);
    pub const PARENTHESIZED_NUMBER_FIFTEEN : CodePoint = CodePoint::from(9346u32);
    pub const PARENTHESIZED_NUMBER_SIXTEEN : CodePoint = CodePoint::from(9347u32);
    pub const PARENTHESIZED_NUMBER_SEVENTEEN : CodePoint = CodePoint::from(9348u32);
    pub const PARENTHESIZED_NUMBER_EIGHTEEN : CodePoint = CodePoint::from(9349u32);
    pub const PARENTHESIZED_NUMBER_NINETEEN : CodePoint = CodePoint::from(9350u32);
    pub const PARENTHESIZED_NUMBER_TWENTY : CodePoint = CodePoint::from(9351u32);
    pub const DIGIT_ONE_FULL_STOP : CodePoint = CodePoint::from(9352u32);
    pub const DIGIT_TWO_FULL_STOP : CodePoint = CodePoint::from(9353u32);
    pub const DIGIT_THREE_FULL_STOP : CodePoint = CodePoint::from(9354u32);
    pub const DIGIT_FOUR_FULL_STOP : CodePoint = CodePoint::from(9355u32);
    pub const DIGIT_FIVE_FULL_STOP : CodePoint = CodePoint::from(9356u32);
    pub const DIGIT_SIX_FULL_STOP : CodePoint = CodePoint::from(9357u32);
    pub const DIGIT_SEVEN_FULL_STOP : CodePoint = CodePoint::from(9358u32);
    pub const DIGIT_EIGHT_FULL_STOP : CodePoint = CodePoint::from(9359u32);
    pub const DIGIT_NINE_FULL_STOP : CodePoint = CodePoint::from(9360u32);
    pub const NUMBER_TEN_FULL_STOP : CodePoint = CodePoint::from(9361u32);
    pub const NUMBER_ELEVEN_FULL_STOP : CodePoint = CodePoint::from(9362u32);
    pub const NUMBER_TWELVE_FULL_STOP : CodePoint = CodePoint::from(9363u32);
    pub const NUMBER_THIRTEEN_FULL_STOP : CodePoint = CodePoint::from(9364u32);
    pub const NUMBER_FOURTEEN_FULL_STOP : CodePoint = CodePoint::from(9365u32);
    pub const NUMBER_FIFTEEN_FULL_STOP : CodePoint = CodePoint::from(9366u32);
    pub const NUMBER_SIXTEEN_FULL_STOP : CodePoint = CodePoint::from(9367u32);
    pub const NUMBER_SEVENTEEN_FULL_STOP : CodePoint = CodePoint::from(9368u32);
    pub const NUMBER_EIGHTEEN_FULL_STOP : CodePoint = CodePoint::from(9369u32);
    pub const NUMBER_NINETEEN_FULL_STOP : CodePoint = CodePoint::from(9370u32);
    pub const NUMBER_TWENTY_FULL_STOP : CodePoint = CodePoint::from(9371u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_A : CodePoint = CodePoint::from(9372u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_B : CodePoint = CodePoint::from(9373u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_C : CodePoint = CodePoint::from(9374u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_D : CodePoint = CodePoint::from(9375u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_E : CodePoint = CodePoint::from(9376u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_F : CodePoint = CodePoint::from(9377u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_G : CodePoint = CodePoint::from(9378u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_H : CodePoint = CodePoint::from(9379u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_I : CodePoint = CodePoint::from(9380u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_J : CodePoint = CodePoint::from(9381u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_K : CodePoint = CodePoint::from(9382u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_L : CodePoint = CodePoint::from(9383u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_M : CodePoint = CodePoint::from(9384u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_N : CodePoint = CodePoint::from(9385u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_O : CodePoint = CodePoint::from(9386u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_P : CodePoint = CodePoint::from(9387u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_Q : CodePoint = CodePoint::from(9388u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_R : CodePoint = CodePoint::from(9389u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_S : CodePoint = CodePoint::from(9390u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_T : CodePoint = CodePoint::from(9391u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_U : CodePoint = CodePoint::from(9392u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_V : CodePoint = CodePoint::from(9393u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_W : CodePoint = CodePoint::from(9394u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_X : CodePoint = CodePoint::from(9395u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_Y : CodePoint = CodePoint::from(9396u32);
    pub const PARENTHESIZED_LATIN_SMALL_LETTER_Z : CodePoint = CodePoint::from(9397u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_A : CodePoint = CodePoint::from(9398u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_B : CodePoint = CodePoint::from(9399u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_C : CodePoint = CodePoint::from(9400u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_D : CodePoint = CodePoint::from(9401u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_E : CodePoint = CodePoint::from(9402u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_F : CodePoint = CodePoint::from(9403u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_G : CodePoint = CodePoint::from(9404u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_H : CodePoint = CodePoint::from(9405u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_I : CodePoint = CodePoint::from(9406u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_J : CodePoint = CodePoint::from(9407u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_K : CodePoint = CodePoint::from(9408u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_L : CodePoint = CodePoint::from(9409u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_M : CodePoint = CodePoint::from(9410u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_N : CodePoint = CodePoint::from(9411u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_O : CodePoint = CodePoint::from(9412u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_P : CodePoint = CodePoint::from(9413u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_Q : CodePoint = CodePoint::from(9414u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_R : CodePoint = CodePoint::from(9415u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_S : CodePoint = CodePoint::from(9416u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_T : CodePoint = CodePoint::from(9417u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_U : CodePoint = CodePoint::from(9418u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_V : CodePoint = CodePoint::from(9419u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_W : CodePoint = CodePoint::from(9420u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_X : CodePoint = CodePoint::from(9421u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_Y : CodePoint = CodePoint::from(9422u32);
    pub const CIRCLED_LATIN_CAPITAL_LETTER_Z : CodePoint = CodePoint::from(9423u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_A : CodePoint = CodePoint::from(9424u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_B : CodePoint = CodePoint::from(9425u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_C : CodePoint = CodePoint::from(9426u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_D : CodePoint = CodePoint::from(9427u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_E : CodePoint = CodePoint::from(9428u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_F : CodePoint = CodePoint::from(9429u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_G : CodePoint = CodePoint::from(9430u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_H : CodePoint = CodePoint::from(9431u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_I : CodePoint = CodePoint::from(9432u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_J : CodePoint = CodePoint::from(9433u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_K : CodePoint = CodePoint::from(9434u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_L : CodePoint = CodePoint::from(9435u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_M : CodePoint = CodePoint::from(9436u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_N : CodePoint = CodePoint::from(9437u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_O : CodePoint = CodePoint::from(9438u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_P : CodePoint = CodePoint::from(9439u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_Q : CodePoint = CodePoint::from(9440u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_R : CodePoint = CodePoint::from(9441u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_S : CodePoint = CodePoint::from(9442u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_T : CodePoint = CodePoint::from(9443u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_U : CodePoint = CodePoint::from(9444u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_V : CodePoint = CodePoint::from(9445u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_W : CodePoint = CodePoint::from(9446u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_X : CodePoint = CodePoint::from(9447u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_Y : CodePoint = CodePoint::from(9448u32);
    pub const CIRCLED_LATIN_SMALL_LETTER_Z : CodePoint = CodePoint::from(9449u32);
    pub const CIRCLED_DIGIT_ZERO : CodePoint = CodePoint::from(9450u32);
    pub const NEGATIVE_CIRCLED_NUMBER_ELEVEN : CodePoint = CodePoint::from(9451u32);
    pub const NEGATIVE_CIRCLED_NUMBER_TWELVE : CodePoint = CodePoint::from(9452u32);
    pub const NEGATIVE_CIRCLED_NUMBER_THIRTEEN : CodePoint = CodePoint::from(9453u32);
    pub const NEGATIVE_CIRCLED_NUMBER_FOURTEEN : CodePoint = CodePoint::from(9454u32);
    pub const NEGATIVE_CIRCLED_NUMBER_FIFTEEN : CodePoint = CodePoint::from(9455u32);
    pub const NEGATIVE_CIRCLED_NUMBER_SIXTEEN : CodePoint = CodePoint::from(9456u32);
    pub const NEGATIVE_CIRCLED_NUMBER_SEVENTEEN : CodePoint = CodePoint::from(9457u32);
    pub const NEGATIVE_CIRCLED_NUMBER_EIGHTEEN : CodePoint = CodePoint::from(9458u32);
    pub const NEGATIVE_CIRCLED_NUMBER_NINETEEN : CodePoint = CodePoint::from(9459u32);
    pub const NEGATIVE_CIRCLED_NUMBER_TWENTY : CodePoint = CodePoint::from(9460u32);
    pub const DOUBLE_CIRCLED_DIGIT_ONE : CodePoint = CodePoint::from(9461u32);
    pub const DOUBLE_CIRCLED_DIGIT_TWO : CodePoint = CodePoint::from(9462u32);
    pub const DOUBLE_CIRCLED_DIGIT_THREE : CodePoint = CodePoint::from(9463u32);
    pub const DOUBLE_CIRCLED_DIGIT_FOUR : CodePoint = CodePoint::from(9464u32);
    pub const DOUBLE_CIRCLED_DIGIT_FIVE : CodePoint = CodePoint::from(9465u32);
    pub const DOUBLE_CIRCLED_DIGIT_SIX : CodePoint = CodePoint::from(9466u32);
    pub const DOUBLE_CIRCLED_DIGIT_SEVEN : CodePoint = CodePoint::from(9467u32);
    pub const DOUBLE_CIRCLED_DIGIT_EIGHT : CodePoint = CodePoint::from(9468u32);
    pub const DOUBLE_CIRCLED_DIGIT_NINE : CodePoint = CodePoint::from(9469u32);
    pub const DOUBLE_CIRCLED_NUMBER_TEN : CodePoint = CodePoint::from(9470u32);
    pub const NEGATIVE_CIRCLED_DIGIT_ZERO : CodePoint = CodePoint::from(9471u32);
    pub const BOX_DRAWINGS_LIGHT_HORIZONTAL : CodePoint = CodePoint::from(9472u32);
    pub const BOX_DRAWINGS_HEAVY_HORIZONTAL : CodePoint = CodePoint::from(9473u32);
    pub const BOX_DRAWINGS_LIGHT_VERTICAL : CodePoint = CodePoint::from(9474u32);
    pub const BOX_DRAWINGS_HEAVY_VERTICAL : CodePoint = CodePoint::from(9475u32);
    pub const BOX_DRAWINGS_LIGHT_TRIPLE_DASH_HORIZONTAL : CodePoint = CodePoint::from(9476u32);
    pub const BOX_DRAWINGS_HEAVY_TRIPLE_DASH_HORIZONTAL : CodePoint = CodePoint::from(9477u32);
    pub const BOX_DRAWINGS_LIGHT_TRIPLE_DASH_VERTICAL : CodePoint = CodePoint::from(9478u32);
    pub const BOX_DRAWINGS_HEAVY_TRIPLE_DASH_VERTICAL : CodePoint = CodePoint::from(9479u32);
    pub const BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_HORIZONTAL : CodePoint = CodePoint::from(9480u32);
    pub const BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_HORIZONTAL : CodePoint = CodePoint::from(9481u32);
    pub const BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_VERTICAL : CodePoint = CodePoint::from(9482u32);
    pub const BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_VERTICAL : CodePoint = CodePoint::from(9483u32);
    pub const BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT : CodePoint = CodePoint::from(9484u32);
    pub const BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_HEAVY : CodePoint = CodePoint::from(9485u32);
    pub const BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_LIGHT : CodePoint = CodePoint::from(9486u32);
    pub const BOX_DRAWINGS_HEAVY_DOWN_AND_RIGHT : CodePoint = CodePoint::from(9487u32);
    pub const BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT : CodePoint = CodePoint::from(9488u32);
    pub const BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_HEAVY : CodePoint = CodePoint::from(9489u32);
    pub const BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_LIGHT : CodePoint = CodePoint::from(9490u32);
    pub const BOX_DRAWINGS_HEAVY_DOWN_AND_LEFT : CodePoint = CodePoint::from(9491u32);
    pub const BOX_DRAWINGS_LIGHT_UP_AND_RIGHT : CodePoint = CodePoint::from(9492u32);
    pub const BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_HEAVY : CodePoint = CodePoint::from(9493u32);
    pub const BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_LIGHT : CodePoint = CodePoint::from(9494u32);
    pub const BOX_DRAWINGS_HEAVY_UP_AND_RIGHT : CodePoint = CodePoint::from(9495u32);
    pub const BOX_DRAWINGS_LIGHT_UP_AND_LEFT : CodePoint = CodePoint::from(9496u32);
    pub const BOX_DRAWINGS_UP_LIGHT_AND_LEFT_HEAVY : CodePoint = CodePoint::from(9497u32);
    pub const BOX_DRAWINGS_UP_HEAVY_AND_LEFT_LIGHT : CodePoint = CodePoint::from(9498u32);
    pub const BOX_DRAWINGS_HEAVY_UP_AND_LEFT : CodePoint = CodePoint::from(9499u32);
    pub const BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT : CodePoint = CodePoint::from(9500u32);
    pub const BOX_DRAWINGS_VERTICAL_LIGHT_AND_RIGHT_HEAVY : CodePoint = CodePoint::from(9501u32);
    pub const BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_DOWN_LIGHT : CodePoint = CodePoint::from(9502u32);
    pub const BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_UP_LIGHT : CodePoint = CodePoint::from(9503u32);
    pub const BOX_DRAWINGS_VERTICAL_HEAVY_AND_RIGHT_LIGHT : CodePoint = CodePoint::from(9504u32);
    pub const BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_UP_HEAVY : CodePoint = CodePoint::from(9505u32);
    pub const BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_DOWN_HEAVY : CodePoint = CodePoint::from(9506u32);
    pub const BOX_DRAWINGS_HEAVY_VERTICAL_AND_RIGHT : CodePoint = CodePoint::from(9507u32);
    pub const BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT : CodePoint = CodePoint::from(9508u32);
    pub const BOX_DRAWINGS_VERTICAL_LIGHT_AND_LEFT_HEAVY : CodePoint = CodePoint::from(9509u32);
    pub const BOX_DRAWINGS_UP_HEAVY_AND_LEFT_DOWN_LIGHT : CodePoint = CodePoint::from(9510u32);
    pub const BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_UP_LIGHT : CodePoint = CodePoint::from(9511u32);
    pub const BOX_DRAWINGS_VERTICAL_HEAVY_AND_LEFT_LIGHT : CodePoint = CodePoint::from(9512u32);
    pub const BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_UP_HEAVY : CodePoint = CodePoint::from(9513u32);
    pub const BOX_DRAWINGS_UP_LIGHT_AND_LEFT_DOWN_HEAVY : CodePoint = CodePoint::from(9514u32);
    pub const BOX_DRAWINGS_HEAVY_VERTICAL_AND_LEFT : CodePoint = CodePoint::from(9515u32);
    pub const BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL : CodePoint = CodePoint::from(9516u32);
    pub const BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT : CodePoint = CodePoint::from(9517u32);
    pub const BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT : CodePoint = CodePoint::from(9518u32);
    pub const BOX_DRAWINGS_DOWN_LIGHT_AND_HORIZONTAL_HEAVY : CodePoint = CodePoint::from(9519u32);
    pub const BOX_DRAWINGS_DOWN_HEAVY_AND_HORIZONTAL_LIGHT : CodePoint = CodePoint::from(9520u32);
    pub const BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY : CodePoint = CodePoint::from(9521u32);
    pub const BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY : CodePoint = CodePoint::from(9522u32);
    pub const BOX_DRAWINGS_HEAVY_DOWN_AND_HORIZONTAL : CodePoint = CodePoint::from(9523u32);
    pub const BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL : CodePoint = CodePoint::from(9524u32);
    pub const BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_UP_LIGHT : CodePoint = CodePoint::from(9525u32);
    pub const BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_UP_LIGHT : CodePoint = CodePoint::from(9526u32);
    pub const BOX_DRAWINGS_UP_LIGHT_AND_HORIZONTAL_HEAVY : CodePoint = CodePoint::from(9527u32);
    pub const BOX_DRAWINGS_UP_HEAVY_AND_HORIZONTAL_LIGHT : CodePoint = CodePoint::from(9528u32);
    pub const BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_UP_HEAVY : CodePoint = CodePoint::from(9529u32);
    pub const BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_UP_HEAVY : CodePoint = CodePoint::from(9530u32);
    pub const BOX_DRAWINGS_HEAVY_UP_AND_HORIZONTAL : CodePoint = CodePoint::from(9531u32);
    pub const BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL : CodePoint = CodePoint::from(9532u32);
    pub const BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT : CodePoint = CodePoint::from(9533u32);
    pub const BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT : CodePoint = CodePoint::from(9534u32);
    pub const BOX_DRAWINGS_VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY : CodePoint = CodePoint::from(9535u32);
    pub const BOX_DRAWINGS_UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT : CodePoint = CodePoint::from(9536u32);
    pub const BOX_DRAWINGS_DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT : CodePoint = CodePoint::from(9537u32);
    pub const BOX_DRAWINGS_VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT : CodePoint = CodePoint::from(9538u32);
    pub const BOX_DRAWINGS_LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT : CodePoint = CodePoint::from(9539u32);
    pub const BOX_DRAWINGS_RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT : CodePoint = CodePoint::from(9540u32);
    pub const BOX_DRAWINGS_LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT : CodePoint = CodePoint::from(9541u32);
    pub const BOX_DRAWINGS_RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT : CodePoint = CodePoint::from(9542u32);
    pub const BOX_DRAWINGS_DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY : CodePoint = CodePoint::from(9543u32);
    pub const BOX_DRAWINGS_UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY : CodePoint = CodePoint::from(9544u32);
    pub const BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY : CodePoint = CodePoint::from(9545u32);
    pub const BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY : CodePoint = CodePoint::from(9546u32);
    pub const BOX_DRAWINGS_HEAVY_VERTICAL_AND_HORIZONTAL : CodePoint = CodePoint::from(9547u32);
    pub const BOX_DRAWINGS_LIGHT_DOUBLE_DASH_HORIZONTAL : CodePoint = CodePoint::from(9548u32);
    pub const BOX_DRAWINGS_HEAVY_DOUBLE_DASH_HORIZONTAL : CodePoint = CodePoint::from(9549u32);
    pub const BOX_DRAWINGS_LIGHT_DOUBLE_DASH_VERTICAL : CodePoint = CodePoint::from(9550u32);
    pub const BOX_DRAWINGS_HEAVY_DOUBLE_DASH_VERTICAL : CodePoint = CodePoint::from(9551u32);
    pub const BOX_DRAWINGS_DOUBLE_HORIZONTAL : CodePoint = CodePoint::from(9552u32);
    pub const BOX_DRAWINGS_DOUBLE_VERTICAL : CodePoint = CodePoint::from(9553u32);
    pub const BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE : CodePoint = CodePoint::from(9554u32);
    pub const BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE : CodePoint = CodePoint::from(9555u32);
    pub const BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT : CodePoint = CodePoint::from(9556u32);
    pub const BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE : CodePoint = CodePoint::from(9557u32);
    pub const BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE : CodePoint = CodePoint::from(9558u32);
    pub const BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT : CodePoint = CodePoint::from(9559u32);
    pub const BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE : CodePoint = CodePoint::from(9560u32);
    pub const BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE : CodePoint = CodePoint::from(9561u32);
    pub const BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT : CodePoint = CodePoint::from(9562u32);
    pub const BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE : CodePoint = CodePoint::from(9563u32);
    pub const BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE : CodePoint = CodePoint::from(9564u32);
    pub const BOX_DRAWINGS_DOUBLE_UP_AND_LEFT : CodePoint = CodePoint::from(9565u32);
    pub const BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE : CodePoint = CodePoint::from(9566u32);
    pub const BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE : CodePoint = CodePoint::from(9567u32);
    pub const BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT : CodePoint = CodePoint::from(9568u32);
    pub const BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE : CodePoint = CodePoint::from(9569u32);
    pub const BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE : CodePoint = CodePoint::from(9570u32);
    pub const BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT : CodePoint = CodePoint::from(9571u32);
    pub const BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE : CodePoint = CodePoint::from(9572u32);
    pub const BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE : CodePoint = CodePoint::from(9573u32);
    pub const BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL : CodePoint = CodePoint::from(9574u32);
    pub const BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE : CodePoint = CodePoint::from(9575u32);
    pub const BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE : CodePoint = CodePoint::from(9576u32);
    pub const BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL : CodePoint = CodePoint::from(9577u32);
    pub const BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE : CodePoint = CodePoint::from(9578u32);
    pub const BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE : CodePoint = CodePoint::from(9579u32);
    pub const BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL : CodePoint = CodePoint::from(9580u32);
    pub const BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_RIGHT : CodePoint = CodePoint::from(9581u32);
    pub const BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_LEFT : CodePoint = CodePoint::from(9582u32);
    pub const BOX_DRAWINGS_LIGHT_ARC_UP_AND_LEFT : CodePoint = CodePoint::from(9583u32);
    pub const BOX_DRAWINGS_LIGHT_ARC_UP_AND_RIGHT : CodePoint = CodePoint::from(9584u32);
    pub const BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT : CodePoint = CodePoint::from(9585u32);
    pub const BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT : CodePoint = CodePoint::from(9586u32);
    pub const BOX_DRAWINGS_LIGHT_DIAGONAL_CROSS : CodePoint = CodePoint::from(9587u32);
    pub const BOX_DRAWINGS_LIGHT_LEFT : CodePoint = CodePoint::from(9588u32);
    pub const BOX_DRAWINGS_LIGHT_UP : CodePoint = CodePoint::from(9589u32);
    pub const BOX_DRAWINGS_LIGHT_RIGHT : CodePoint = CodePoint::from(9590u32);
    pub const BOX_DRAWINGS_LIGHT_DOWN : CodePoint = CodePoint::from(9591u32);
    pub const BOX_DRAWINGS_HEAVY_LEFT : CodePoint = CodePoint::from(9592u32);
    pub const BOX_DRAWINGS_HEAVY_UP : CodePoint = CodePoint::from(9593u32);
    pub const BOX_DRAWINGS_HEAVY_RIGHT : CodePoint = CodePoint::from(9594u32);
    pub const BOX_DRAWINGS_HEAVY_DOWN : CodePoint = CodePoint::from(9595u32);
    pub const BOX_DRAWINGS_LIGHT_LEFT_AND_HEAVY_RIGHT : CodePoint = CodePoint::from(9596u32);
    pub const BOX_DRAWINGS_LIGHT_UP_AND_HEAVY_DOWN : CodePoint = CodePoint::from(9597u32);
    pub const BOX_DRAWINGS_HEAVY_LEFT_AND_LIGHT_RIGHT : CodePoint = CodePoint::from(9598u32);
    pub const BOX_DRAWINGS_HEAVY_UP_AND_LIGHT_DOWN : CodePoint = CodePoint::from(9599u32);
    pub const UPPER_HALF_BLOCK : CodePoint = CodePoint::from(9600u32);
    pub const LOWER_ONE_EIGHTH_BLOCK : CodePoint = CodePoint::from(9601u32);
    pub const LOWER_ONE_QUARTER_BLOCK : CodePoint = CodePoint::from(9602u32);
    pub const LOWER_THREE_EIGHTHS_BLOCK : CodePoint = CodePoint::from(9603u32);
    pub const LOWER_HALF_BLOCK : CodePoint = CodePoint::from(9604u32);
    pub const LOWER_FIVE_EIGHTHS_BLOCK : CodePoint = CodePoint::from(9605u32);
    pub const LOWER_THREE_QUARTERS_BLOCK : CodePoint = CodePoint::from(9606u32);
    pub const LOWER_SEVEN_EIGHTHS_BLOCK : CodePoint = CodePoint::from(9607u32);
    pub const FULL_BLOCK : CodePoint = CodePoint::from(9608u32);
    pub const LEFT_SEVEN_EIGHTHS_BLOCK : CodePoint = CodePoint::from(9609u32);
    pub const LEFT_THREE_QUARTERS_BLOCK : CodePoint = CodePoint::from(9610u32);
    pub const LEFT_FIVE_EIGHTHS_BLOCK : CodePoint = CodePoint::from(9611u32);
    pub const LEFT_HALF_BLOCK : CodePoint = CodePoint::from(9612u32);
    pub const LEFT_THREE_EIGHTHS_BLOCK : CodePoint = CodePoint::from(9613u32);
    pub const LEFT_ONE_QUARTER_BLOCK : CodePoint = CodePoint::from(9614u32);
    pub const LEFT_ONE_EIGHTH_BLOCK : CodePoint = CodePoint::from(9615u32);
    pub const RIGHT_HALF_BLOCK : CodePoint = CodePoint::from(9616u32);
    pub const LIGHT_SHADE : CodePoint = CodePoint::from(9617u32);
    pub const MEDIUM_SHADE : CodePoint = CodePoint::from(9618u32);
    pub const DARK_SHADE : CodePoint = CodePoint::from(9619u32);
    pub const UPPER_ONE_EIGHTH_BLOCK : CodePoint = CodePoint::from(9620u32);
    pub const RIGHT_ONE_EIGHTH_BLOCK : CodePoint = CodePoint::from(9621u32);
    pub const QUADRANT_LOWER_LEFT : CodePoint = CodePoint::from(9622u32);
    pub const QUADRANT_LOWER_RIGHT : CodePoint = CodePoint::from(9623u32);
    pub const QUADRANT_UPPER_LEFT : CodePoint = CodePoint::from(9624u32);
    pub const QUADRANT_UPPER_LEFT_AND_LOWER_LEFT_AND_LOWER_RIGHT : CodePoint = CodePoint::from(9625u32);
    pub const QUADRANT_UPPER_LEFT_AND_LOWER_RIGHT : CodePoint = CodePoint::from(9626u32);
    pub const QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_LEFT : CodePoint = CodePoint::from(9627u32);
    pub const QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_RIGHT : CodePoint = CodePoint::from(9628u32);
    pub const QUADRANT_UPPER_RIGHT : CodePoint = CodePoint::from(9629u32);
    pub const QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT : CodePoint = CodePoint::from(9630u32);
    pub const QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT_AND_LOWER_RIGHT : CodePoint = CodePoint::from(9631u32);
    pub const BLACK_SQUARE : CodePoint = CodePoint::from(9632u32);
    pub const WHITE_SQUARE : CodePoint = CodePoint::from(9633u32);
    pub const WHITE_SQUARE_WITH_ROUNDED_CORNERS : CodePoint = CodePoint::from(9634u32);
    pub const WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE : CodePoint = CodePoint::from(9635u32);
    pub const SQUARE_WITH_HORIZONTAL_FILL : CodePoint = CodePoint::from(9636u32);
    pub const SQUARE_WITH_VERTICAL_FILL : CodePoint = CodePoint::from(9637u32);
    pub const SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL : CodePoint = CodePoint::from(9638u32);
    pub const SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL : CodePoint = CodePoint::from(9639u32);
    pub const SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL : CodePoint = CodePoint::from(9640u32);
    pub const SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL : CodePoint = CodePoint::from(9641u32);
    pub const BLACK_SMALL_SQUARE : CodePoint = CodePoint::from(9642u32);
    pub const WHITE_SMALL_SQUARE : CodePoint = CodePoint::from(9643u32);
    pub const BLACK_RECTANGLE : CodePoint = CodePoint::from(9644u32);
    pub const WHITE_RECTANGLE : CodePoint = CodePoint::from(9645u32);
    pub const BLACK_VERTICAL_RECTANGLE : CodePoint = CodePoint::from(9646u32);
    pub const WHITE_VERTICAL_RECTANGLE : CodePoint = CodePoint::from(9647u32);
    pub const BLACK_PARALLELOGRAM : CodePoint = CodePoint::from(9648u32);
    pub const WHITE_PARALLELOGRAM : CodePoint = CodePoint::from(9649u32);
    pub const BLACK_UP_POINTING_TRIANGLE : CodePoint = CodePoint::from(9650u32);
    pub const WHITE_UP_POINTING_TRIANGLE : CodePoint = CodePoint::from(9651u32);
    pub const BLACK_UP_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9652u32);
    pub const WHITE_UP_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9653u32);
    pub const BLACK_RIGHT_POINTING_TRIANGLE : CodePoint = CodePoint::from(9654u32);
    pub const WHITE_RIGHT_POINTING_TRIANGLE : CodePoint = CodePoint::from(9655u32);
    pub const BLACK_RIGHT_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9656u32);
    pub const WHITE_RIGHT_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9657u32);
    pub const BLACK_RIGHT_POINTING_POINTER : CodePoint = CodePoint::from(9658u32);
    pub const WHITE_RIGHT_POINTING_POINTER : CodePoint = CodePoint::from(9659u32);
    pub const BLACK_DOWN_POINTING_TRIANGLE : CodePoint = CodePoint::from(9660u32);
    pub const WHITE_DOWN_POINTING_TRIANGLE : CodePoint = CodePoint::from(9661u32);
    pub const BLACK_DOWN_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9662u32);
    pub const WHITE_DOWN_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9663u32);
    pub const BLACK_LEFT_POINTING_TRIANGLE : CodePoint = CodePoint::from(9664u32);
    pub const WHITE_LEFT_POINTING_TRIANGLE : CodePoint = CodePoint::from(9665u32);
    pub const BLACK_LEFT_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9666u32);
    pub const WHITE_LEFT_POINTING_SMALL_TRIANGLE : CodePoint = CodePoint::from(9667u32);
    pub const BLACK_LEFT_POINTING_POINTER : CodePoint = CodePoint::from(9668u32);
    pub const WHITE_LEFT_POINTING_POINTER : CodePoint = CodePoint::from(9669u32);
    pub const BLACK_DIAMOND : CodePoint = CodePoint::from(9670u32);
    pub const WHITE_DIAMOND : CodePoint = CodePoint::from(9671u32);
    pub const WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND : CodePoint = CodePoint::from(9672u32);
    pub const FISHEYE : CodePoint = CodePoint::from(9673u32);
    pub const LOZENGE : CodePoint = CodePoint::from(9674u32);
    pub const WHITE_CIRCLE : CodePoint = CodePoint::from(9675u32);
    pub const DOTTED_CIRCLE : CodePoint = CodePoint::from(9676u32);
    pub const CIRCLE_WITH_VERTICAL_FILL : CodePoint = CodePoint::from(9677u32);
    pub const BULLSEYE : CodePoint = CodePoint::from(9678u32);
    pub const BLACK_CIRCLE : CodePoint = CodePoint::from(9679u32);
    pub const CIRCLE_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(9680u32);
    pub const CIRCLE_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(9681u32);
    pub const CIRCLE_WITH_LOWER_HALF_BLACK : CodePoint = CodePoint::from(9682u32);
    pub const CIRCLE_WITH_UPPER_HALF_BLACK : CodePoint = CodePoint::from(9683u32);
    pub const CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK : CodePoint = CodePoint::from(9684u32);
    pub const CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK : CodePoint = CodePoint::from(9685u32);
    pub const LEFT_HALF_BLACK_CIRCLE : CodePoint = CodePoint::from(9686u32);
    pub const RIGHT_HALF_BLACK_CIRCLE : CodePoint = CodePoint::from(9687u32);
    pub const INVERSE_BULLET : CodePoint = CodePoint::from(9688u32);
    pub const INVERSE_WHITE_CIRCLE : CodePoint = CodePoint::from(9689u32);
    pub const UPPER_HALF_INVERSE_WHITE_CIRCLE : CodePoint = CodePoint::from(9690u32);
    pub const LOWER_HALF_INVERSE_WHITE_CIRCLE : CodePoint = CodePoint::from(9691u32);
    pub const UPPER_LEFT_QUADRANT_CIRCULAR_ARC : CodePoint = CodePoint::from(9692u32);
    pub const UPPER_RIGHT_QUADRANT_CIRCULAR_ARC : CodePoint = CodePoint::from(9693u32);
    pub const LOWER_RIGHT_QUADRANT_CIRCULAR_ARC : CodePoint = CodePoint::from(9694u32);
    pub const LOWER_LEFT_QUADRANT_CIRCULAR_ARC : CodePoint = CodePoint::from(9695u32);
    pub const UPPER_HALF_CIRCLE : CodePoint = CodePoint::from(9696u32);
    pub const LOWER_HALF_CIRCLE : CodePoint = CodePoint::from(9697u32);
    pub const BLACK_LOWER_RIGHT_TRIANGLE : CodePoint = CodePoint::from(9698u32);
    pub const BLACK_LOWER_LEFT_TRIANGLE : CodePoint = CodePoint::from(9699u32);
    pub const BLACK_UPPER_LEFT_TRIANGLE : CodePoint = CodePoint::from(9700u32);
    pub const BLACK_UPPER_RIGHT_TRIANGLE : CodePoint = CodePoint::from(9701u32);
    pub const WHITE_BULLET : CodePoint = CodePoint::from(9702u32);
    pub const SQUARE_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(9703u32);
    pub const SQUARE_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(9704u32);
    pub const SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK : CodePoint = CodePoint::from(9705u32);
    pub const SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK : CodePoint = CodePoint::from(9706u32);
    pub const WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE : CodePoint = CodePoint::from(9707u32);
    pub const WHITE_UP_POINTING_TRIANGLE_WITH_DOT : CodePoint = CodePoint::from(9708u32);
    pub const UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(9709u32);
    pub const UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(9710u32);
    pub const LARGE_CIRCLE : CodePoint = CodePoint::from(9711u32);
    pub const WHITE_SQUARE_WITH_UPPER_LEFT_QUADRANT : CodePoint = CodePoint::from(9712u32);
    pub const WHITE_SQUARE_WITH_LOWER_LEFT_QUADRANT : CodePoint = CodePoint::from(9713u32);
    pub const WHITE_SQUARE_WITH_LOWER_RIGHT_QUADRANT : CodePoint = CodePoint::from(9714u32);
    pub const WHITE_SQUARE_WITH_UPPER_RIGHT_QUADRANT : CodePoint = CodePoint::from(9715u32);
    pub const WHITE_CIRCLE_WITH_UPPER_LEFT_QUADRANT : CodePoint = CodePoint::from(9716u32);
    pub const WHITE_CIRCLE_WITH_LOWER_LEFT_QUADRANT : CodePoint = CodePoint::from(9717u32);
    pub const WHITE_CIRCLE_WITH_LOWER_RIGHT_QUADRANT : CodePoint = CodePoint::from(9718u32);
    pub const WHITE_CIRCLE_WITH_UPPER_RIGHT_QUADRANT : CodePoint = CodePoint::from(9719u32);
    pub const UPPER_LEFT_TRIANGLE : CodePoint = CodePoint::from(9720u32);
    pub const UPPER_RIGHT_TRIANGLE : CodePoint = CodePoint::from(9721u32);
    pub const LOWER_LEFT_TRIANGLE : CodePoint = CodePoint::from(9722u32);
    pub const WHITE_MEDIUM_SQUARE : CodePoint = CodePoint::from(9723u32);
    pub const BLACK_MEDIUM_SQUARE : CodePoint = CodePoint::from(9724u32);
    pub const WHITE_MEDIUM_SMALL_SQUARE : CodePoint = CodePoint::from(9725u32);
    pub const BLACK_MEDIUM_SMALL_SQUARE : CodePoint = CodePoint::from(9726u32);
    pub const LOWER_RIGHT_TRIANGLE : CodePoint = CodePoint::from(9727u32);
    pub const BLACK_SUN_WITH_RAYS : CodePoint = CodePoint::from(9728u32);
    pub const CLOUD : CodePoint = CodePoint::from(9729u32);
    pub const UMBRELLA : CodePoint = CodePoint::from(9730u32);
    pub const SNOWMAN : CodePoint = CodePoint::from(9731u32);
    pub const COMET : CodePoint = CodePoint::from(9732u32);
    pub const BLACK_STAR : CodePoint = CodePoint::from(9733u32);
    pub const WHITE_STAR : CodePoint = CodePoint::from(9734u32);
    pub const LIGHTNING : CodePoint = CodePoint::from(9735u32);
    pub const THUNDERSTORM : CodePoint = CodePoint::from(9736u32);
    pub const SUN : CodePoint = CodePoint::from(9737u32);
    pub const ASCENDING_NODE : CodePoint = CodePoint::from(9738u32);
    pub const DESCENDING_NODE : CodePoint = CodePoint::from(9739u32);
    pub const CONJUNCTION : CodePoint = CodePoint::from(9740u32);
    pub const OPPOSITION : CodePoint = CodePoint::from(9741u32);
    pub const BLACK_TELEPHONE : CodePoint = CodePoint::from(9742u32);
    pub const WHITE_TELEPHONE : CodePoint = CodePoint::from(9743u32);
    pub const BALLOT_BOX : CodePoint = CodePoint::from(9744u32);
    pub const BALLOT_BOX_WITH_CHECK : CodePoint = CodePoint::from(9745u32);
    pub const BALLOT_BOX_WITH_X : CodePoint = CodePoint::from(9746u32);
    pub const SALTIRE : CodePoint = CodePoint::from(9747u32);
    pub const UMBRELLA_WITH_RAIN_DROPS : CodePoint = CodePoint::from(9748u32);
    pub const HOT_BEVERAGE : CodePoint = CodePoint::from(9749u32);
    pub const WHITE_SHOGI_PIECE : CodePoint = CodePoint::from(9750u32);
    pub const BLACK_SHOGI_PIECE : CodePoint = CodePoint::from(9751u32);
    pub const SHAMROCK : CodePoint = CodePoint::from(9752u32);
    pub const REVERSED_ROTATED_FLORAL_HEART_BULLET : CodePoint = CodePoint::from(9753u32);
    pub const BLACK_LEFT_POINTING_INDEX : CodePoint = CodePoint::from(9754u32);
    pub const BLACK_RIGHT_POINTING_INDEX : CodePoint = CodePoint::from(9755u32);
    pub const WHITE_LEFT_POINTING_INDEX : CodePoint = CodePoint::from(9756u32);
    pub const WHITE_UP_POINTING_INDEX : CodePoint = CodePoint::from(9757u32);
    pub const WHITE_RIGHT_POINTING_INDEX : CodePoint = CodePoint::from(9758u32);
    pub const WHITE_DOWN_POINTING_INDEX : CodePoint = CodePoint::from(9759u32);
    pub const SKULL_AND_CROSSBONES : CodePoint = CodePoint::from(9760u32);
    pub const CAUTION_SIGN : CodePoint = CodePoint::from(9761u32);
    pub const RADIOACTIVE_SIGN : CodePoint = CodePoint::from(9762u32);
    pub const BIOHAZARD_SIGN : CodePoint = CodePoint::from(9763u32);
    pub const CADUCEUS : CodePoint = CodePoint::from(9764u32);
    pub const ANKH : CodePoint = CodePoint::from(9765u32);
    pub const ORTHODOX_CROSS : CodePoint = CodePoint::from(9766u32);
    pub const CHI_RHO : CodePoint = CodePoint::from(9767u32);
    pub const CROSS_OF_LORRAINE : CodePoint = CodePoint::from(9768u32);
    pub const CROSS_OF_JERUSALEM : CodePoint = CodePoint::from(9769u32);
    pub const STAR_AND_CRESCENT : CodePoint = CodePoint::from(9770u32);
    pub const FARSI_SYMBOL : CodePoint = CodePoint::from(9771u32);
    pub const ADI_SHAKTI : CodePoint = CodePoint::from(9772u32);
    pub const HAMMER_AND_SICKLE : CodePoint = CodePoint::from(9773u32);
    pub const PEACE_SYMBOL : CodePoint = CodePoint::from(9774u32);
    pub const YIN_YANG : CodePoint = CodePoint::from(9775u32);
    pub const TRIGRAM_FOR_HEAVEN : CodePoint = CodePoint::from(9776u32);
    pub const TRIGRAM_FOR_LAKE : CodePoint = CodePoint::from(9777u32);
    pub const TRIGRAM_FOR_FIRE : CodePoint = CodePoint::from(9778u32);
    pub const TRIGRAM_FOR_THUNDER : CodePoint = CodePoint::from(9779u32);
    pub const TRIGRAM_FOR_WIND : CodePoint = CodePoint::from(9780u32);
    pub const TRIGRAM_FOR_WATER : CodePoint = CodePoint::from(9781u32);
    pub const TRIGRAM_FOR_MOUNTAIN : CodePoint = CodePoint::from(9782u32);
    pub const TRIGRAM_FOR_EARTH : CodePoint = CodePoint::from(9783u32);
    pub const WHEEL_OF_DHARMA : CodePoint = CodePoint::from(9784u32);
    pub const WHITE_FROWNING_FACE : CodePoint = CodePoint::from(9785u32);
    pub const WHITE_SMILING_FACE : CodePoint = CodePoint::from(9786u32);
    pub const BLACK_SMILING_FACE : CodePoint = CodePoint::from(9787u32);
    pub const WHITE_SUN_WITH_RAYS : CodePoint = CodePoint::from(9788u32);
    pub const FIRST_QUARTER_MOON : CodePoint = CodePoint::from(9789u32);
    pub const LAST_QUARTER_MOON : CodePoint = CodePoint::from(9790u32);
    pub const MERCURY : CodePoint = CodePoint::from(9791u32);
    pub const FEMALE_SIGN : CodePoint = CodePoint::from(9792u32);
    pub const EARTH : CodePoint = CodePoint::from(9793u32);
    pub const MALE_SIGN : CodePoint = CodePoint::from(9794u32);
    pub const JUPITER : CodePoint = CodePoint::from(9795u32);
    pub const SATURN : CodePoint = CodePoint::from(9796u32);
    pub const URANUS : CodePoint = CodePoint::from(9797u32);
    pub const NEPTUNE : CodePoint = CodePoint::from(9798u32);
    pub const PLUTO : CodePoint = CodePoint::from(9799u32);
    pub const ARIES : CodePoint = CodePoint::from(9800u32);
    pub const TAURUS : CodePoint = CodePoint::from(9801u32);
    pub const GEMINI : CodePoint = CodePoint::from(9802u32);
    pub const CANCER : CodePoint = CodePoint::from(9803u32);
    pub const LEO : CodePoint = CodePoint::from(9804u32);
    pub const VIRGO : CodePoint = CodePoint::from(9805u32);
    pub const LIBRA : CodePoint = CodePoint::from(9806u32);
    pub const SCORPIUS : CodePoint = CodePoint::from(9807u32);
    pub const SAGITTARIUS : CodePoint = CodePoint::from(9808u32);
    pub const CAPRICORN : CodePoint = CodePoint::from(9809u32);
    pub const AQUARIUS : CodePoint = CodePoint::from(9810u32);
    pub const PISCES : CodePoint = CodePoint::from(9811u32);
    pub const WHITE_CHESS_KING : CodePoint = CodePoint::from(9812u32);
    pub const WHITE_CHESS_QUEEN : CodePoint = CodePoint::from(9813u32);
    pub const WHITE_CHESS_ROOK : CodePoint = CodePoint::from(9814u32);
    pub const WHITE_CHESS_BISHOP : CodePoint = CodePoint::from(9815u32);
    pub const WHITE_CHESS_KNIGHT : CodePoint = CodePoint::from(9816u32);
    pub const WHITE_CHESS_PAWN : CodePoint = CodePoint::from(9817u32);
    pub const BLACK_CHESS_KING : CodePoint = CodePoint::from(9818u32);
    pub const BLACK_CHESS_QUEEN : CodePoint = CodePoint::from(9819u32);
    pub const BLACK_CHESS_ROOK : CodePoint = CodePoint::from(9820u32);
    pub const BLACK_CHESS_BISHOP : CodePoint = CodePoint::from(9821u32);
    pub const BLACK_CHESS_KNIGHT : CodePoint = CodePoint::from(9822u32);
    pub const BLACK_CHESS_PAWN : CodePoint = CodePoint::from(9823u32);
    pub const BLACK_SPADE_SUIT : CodePoint = CodePoint::from(9824u32);
    pub const WHITE_HEART_SUIT : CodePoint = CodePoint::from(9825u32);
    pub const WHITE_DIAMOND_SUIT : CodePoint = CodePoint::from(9826u32);
    pub const BLACK_CLUB_SUIT : CodePoint = CodePoint::from(9827u32);
    pub const WHITE_SPADE_SUIT : CodePoint = CodePoint::from(9828u32);
    pub const BLACK_HEART_SUIT : CodePoint = CodePoint::from(9829u32);
    pub const BLACK_DIAMOND_SUIT : CodePoint = CodePoint::from(9830u32);
    pub const WHITE_CLUB_SUIT : CodePoint = CodePoint::from(9831u32);
    pub const HOT_SPRINGS : CodePoint = CodePoint::from(9832u32);
    pub const QUARTER_NOTE : CodePoint = CodePoint::from(9833u32);
    pub const EIGHTH_NOTE : CodePoint = CodePoint::from(9834u32);
    pub const BEAMED_EIGHTH_NOTES : CodePoint = CodePoint::from(9835u32);
    pub const BEAMED_SIXTEENTH_NOTES : CodePoint = CodePoint::from(9836u32);
    pub const MUSIC_FLAT_SIGN : CodePoint = CodePoint::from(9837u32);
    pub const MUSIC_NATURAL_SIGN : CodePoint = CodePoint::from(9838u32);
    pub const MUSIC_SHARP_SIGN : CodePoint = CodePoint::from(9839u32);
    pub const WEST_SYRIAC_CROSS : CodePoint = CodePoint::from(9840u32);
    pub const EAST_SYRIAC_CROSS : CodePoint = CodePoint::from(9841u32);
    pub const UNIVERSAL_RECYCLING_SYMBOL : CodePoint = CodePoint::from(9842u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_1_PLASTICS : CodePoint = CodePoint::from(9843u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_2_PLASTICS : CodePoint = CodePoint::from(9844u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_3_PLASTICS : CodePoint = CodePoint::from(9845u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_4_PLASTICS : CodePoint = CodePoint::from(9846u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_5_PLASTICS : CodePoint = CodePoint::from(9847u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_6_PLASTICS : CodePoint = CodePoint::from(9848u32);
    pub const RECYCLING_SYMBOL_FOR_TYPE_7_PLASTICS : CodePoint = CodePoint::from(9849u32);
    pub const RECYCLING_SYMBOL_FOR_GENERIC_MATERIALS : CodePoint = CodePoint::from(9850u32);
    pub const BLACK_UNIVERSAL_RECYCLING_SYMBOL : CodePoint = CodePoint::from(9851u32);
    pub const RECYCLED_PAPER_SYMBOL : CodePoint = CodePoint::from(9852u32);
    pub const PARTIALLY_RECYCLED_PAPER_SYMBOL : CodePoint = CodePoint::from(9853u32);
    pub const PERMANENT_PAPER_SIGN : CodePoint = CodePoint::from(9854u32);
    pub const WHEELCHAIR_SYMBOL : CodePoint = CodePoint::from(9855u32);
    pub const DIE_FACE_1 : CodePoint = CodePoint::from(9856u32);
    pub const DIE_FACE_2 : CodePoint = CodePoint::from(9857u32);
    pub const DIE_FACE_3 : CodePoint = CodePoint::from(9858u32);
    pub const DIE_FACE_4 : CodePoint = CodePoint::from(9859u32);
    pub const DIE_FACE_5 : CodePoint = CodePoint::from(9860u32);
    pub const DIE_FACE_6 : CodePoint = CodePoint::from(9861u32);
    pub const WHITE_CIRCLE_WITH_DOT_RIGHT : CodePoint = CodePoint::from(9862u32);
    pub const WHITE_CIRCLE_WITH_TWO_DOTS : CodePoint = CodePoint::from(9863u32);
    pub const BLACK_CIRCLE_WITH_WHITE_DOT_RIGHT : CodePoint = CodePoint::from(9864u32);
    pub const BLACK_CIRCLE_WITH_TWO_WHITE_DOTS : CodePoint = CodePoint::from(9865u32);
    pub const MONOGRAM_FOR_YANG : CodePoint = CodePoint::from(9866u32);
    pub const MONOGRAM_FOR_YIN : CodePoint = CodePoint::from(9867u32);
    pub const DIGRAM_FOR_GREATER_YANG : CodePoint = CodePoint::from(9868u32);
    pub const DIGRAM_FOR_LESSER_YIN : CodePoint = CodePoint::from(9869u32);
    pub const DIGRAM_FOR_LESSER_YANG : CodePoint = CodePoint::from(9870u32);
    pub const DIGRAM_FOR_GREATER_YIN : CodePoint = CodePoint::from(9871u32);
    pub const WHITE_FLAG : CodePoint = CodePoint::from(9872u32);
    pub const BLACK_FLAG : CodePoint = CodePoint::from(9873u32);
    pub const HAMMER_AND_PICK : CodePoint = CodePoint::from(9874u32);
    pub const ANCHOR : CodePoint = CodePoint::from(9875u32);
    pub const CROSSED_SWORDS : CodePoint = CodePoint::from(9876u32);
    pub const STAFF_OF_AESCULAPIUS : CodePoint = CodePoint::from(9877u32);
    pub const SCALES : CodePoint = CodePoint::from(9878u32);
    pub const ALEMBIC : CodePoint = CodePoint::from(9879u32);
    pub const FLOWER : CodePoint = CodePoint::from(9880u32);
    pub const GEAR : CodePoint = CodePoint::from(9881u32);
    pub const STAFF_OF_HERMES : CodePoint = CodePoint::from(9882u32);
    pub const ATOM_SYMBOL : CodePoint = CodePoint::from(9883u32);
    pub const FLEUR_DE_LIS : CodePoint = CodePoint::from(9884u32);
    pub const OUTLINED_WHITE_STAR : CodePoint = CodePoint::from(9885u32);
    pub const THREE_LINES_CONVERGING_RIGHT : CodePoint = CodePoint::from(9886u32);
    pub const THREE_LINES_CONVERGING_LEFT : CodePoint = CodePoint::from(9887u32);
    pub const WARNING_SIGN : CodePoint = CodePoint::from(9888u32);
    pub const HIGH_VOLTAGE_SIGN : CodePoint = CodePoint::from(9889u32);
    pub const DOUBLED_FEMALE_SIGN : CodePoint = CodePoint::from(9890u32);
    pub const DOUBLED_MALE_SIGN : CodePoint = CodePoint::from(9891u32);
    pub const INTERLOCKED_FEMALE_AND_MALE_SIGN : CodePoint = CodePoint::from(9892u32);
    pub const MALE_AND_FEMALE_SIGN : CodePoint = CodePoint::from(9893u32);
    pub const MALE_WITH_STROKE_SIGN : CodePoint = CodePoint::from(9894u32);
    pub const MALE_WITH_STROKE_AND_MALE_AND_FEMALE_SIGN : CodePoint = CodePoint::from(9895u32);
    pub const VERTICAL_MALE_WITH_STROKE_SIGN : CodePoint = CodePoint::from(9896u32);
    pub const HORIZONTAL_MALE_WITH_STROKE_SIGN : CodePoint = CodePoint::from(9897u32);
    pub const MEDIUM_WHITE_CIRCLE : CodePoint = CodePoint::from(9898u32);
    pub const MEDIUM_BLACK_CIRCLE : CodePoint = CodePoint::from(9899u32);
    pub const MEDIUM_SMALL_WHITE_CIRCLE : CodePoint = CodePoint::from(9900u32);
    pub const MARRIAGE_SYMBOL : CodePoint = CodePoint::from(9901u32);
    pub const DIVORCE_SYMBOL : CodePoint = CodePoint::from(9902u32);
    pub const UNMARRIED_PARTNERSHIP_SYMBOL : CodePoint = CodePoint::from(9903u32);
    pub const COFFIN : CodePoint = CodePoint::from(9904u32);
    pub const FUNERAL_URN : CodePoint = CodePoint::from(9905u32);
    pub const NEUTER : CodePoint = CodePoint::from(9906u32);
    pub const CERES : CodePoint = CodePoint::from(9907u32);
    pub const PALLAS : CodePoint = CodePoint::from(9908u32);
    pub const JUNO : CodePoint = CodePoint::from(9909u32);
    pub const VESTA : CodePoint = CodePoint::from(9910u32);
    pub const CHIRON : CodePoint = CodePoint::from(9911u32);
    pub const BLACK_MOON_LILITH : CodePoint = CodePoint::from(9912u32);
    pub const SEXTILE : CodePoint = CodePoint::from(9913u32);
    pub const SEMISEXTILE : CodePoint = CodePoint::from(9914u32);
    pub const QUINCUNX : CodePoint = CodePoint::from(9915u32);
    pub const SESQUIQUADRATE : CodePoint = CodePoint::from(9916u32);
    pub const SOCCER_BALL : CodePoint = CodePoint::from(9917u32);
    pub const BASEBALL : CodePoint = CodePoint::from(9918u32);
    pub const SQUARED_KEY : CodePoint = CodePoint::from(9919u32);
    pub const WHITE_DRAUGHTS_MAN : CodePoint = CodePoint::from(9920u32);
    pub const WHITE_DRAUGHTS_KING : CodePoint = CodePoint::from(9921u32);
    pub const BLACK_DRAUGHTS_MAN : CodePoint = CodePoint::from(9922u32);
    pub const BLACK_DRAUGHTS_KING : CodePoint = CodePoint::from(9923u32);
    pub const SNOWMAN_WITHOUT_SNOW : CodePoint = CodePoint::from(9924u32);
    pub const SUN_BEHIND_CLOUD : CodePoint = CodePoint::from(9925u32);
    pub const RAIN : CodePoint = CodePoint::from(9926u32);
    pub const BLACK_SNOWMAN : CodePoint = CodePoint::from(9927u32);
    pub const THUNDER_CLOUD_AND_RAIN : CodePoint = CodePoint::from(9928u32);
    pub const TURNED_WHITE_SHOGI_PIECE : CodePoint = CodePoint::from(9929u32);
    pub const TURNED_BLACK_SHOGI_PIECE : CodePoint = CodePoint::from(9930u32);
    pub const WHITE_DIAMOND_IN_SQUARE : CodePoint = CodePoint::from(9931u32);
    pub const CROSSING_LANES : CodePoint = CodePoint::from(9932u32);
    pub const DISABLED_CAR : CodePoint = CodePoint::from(9933u32);
    pub const OPHIUCHUS : CodePoint = CodePoint::from(9934u32);
    pub const PICK : CodePoint = CodePoint::from(9935u32);
    pub const CAR_SLIDING : CodePoint = CodePoint::from(9936u32);
    pub const HELMET_WITH_WHITE_CROSS : CodePoint = CodePoint::from(9937u32);
    pub const CIRCLED_CROSSING_LANES : CodePoint = CodePoint::from(9938u32);
    pub const CHAINS : CodePoint = CodePoint::from(9939u32);
    pub const NO_ENTRY : CodePoint = CodePoint::from(9940u32);
    pub const ALTERNATE_ONE_WAY_LEFT_WAY_TRAFFIC : CodePoint = CodePoint::from(9941u32);
    pub const BLACK_TWO_WAY_LEFT_WAY_TRAFFIC : CodePoint = CodePoint::from(9942u32);
    pub const WHITE_TWO_WAY_LEFT_WAY_TRAFFIC : CodePoint = CodePoint::from(9943u32);
    pub const BLACK_LEFT_LANE_MERGE : CodePoint = CodePoint::from(9944u32);
    pub const WHITE_LEFT_LANE_MERGE : CodePoint = CodePoint::from(9945u32);
    pub const DRIVE_SLOW_SIGN : CodePoint = CodePoint::from(9946u32);
    pub const HEAVY_WHITE_DOWN_POINTING_TRIANGLE : CodePoint = CodePoint::from(9947u32);
    pub const LEFT_CLOSED_ENTRY : CodePoint = CodePoint::from(9948u32);
    pub const SQUARED_SALTIRE : CodePoint = CodePoint::from(9949u32);
    pub const FALLING_DIAGONAL_IN_WHITE_CIRCLE_IN_BLACK_SQUARE : CodePoint = CodePoint::from(9950u32);
    pub const BLACK_TRUCK : CodePoint = CodePoint::from(9951u32);
    pub const RESTRICTED_LEFT_ENTRY_1 : CodePoint = CodePoint::from(9952u32);
    pub const RESTRICTED_LEFT_ENTRY_2 : CodePoint = CodePoint::from(9953u32);
    pub const ASTRONOMICAL_SYMBOL_FOR_URANUS : CodePoint = CodePoint::from(9954u32);
    pub const HEAVY_CIRCLE_WITH_STROKE_AND_TWO_DOTS_ABOVE : CodePoint = CodePoint::from(9955u32);
    pub const PENTAGRAM : CodePoint = CodePoint::from(9956u32);
    pub const RIGHT_HANDED_INTERLACED_PENTAGRAM : CodePoint = CodePoint::from(9957u32);
    pub const LEFT_HANDED_INTERLACED_PENTAGRAM : CodePoint = CodePoint::from(9958u32);
    pub const INVERTED_PENTAGRAM : CodePoint = CodePoint::from(9959u32);
    pub const BLACK_CROSS_ON_SHIELD : CodePoint = CodePoint::from(9960u32);
    pub const SHINTO_SHRINE : CodePoint = CodePoint::from(9961u32);
    pub const CHURCH : CodePoint = CodePoint::from(9962u32);
    pub const CASTLE : CodePoint = CodePoint::from(9963u32);
    pub const HISTORIC_SITE : CodePoint = CodePoint::from(9964u32);
    pub const GEAR_WITHOUT_HUB : CodePoint = CodePoint::from(9965u32);
    pub const GEAR_WITH_HANDLES : CodePoint = CodePoint::from(9966u32);
    pub const MAP_SYMBOL_FOR_LIGHTHOUSE : CodePoint = CodePoint::from(9967u32);
    pub const MOUNTAIN : CodePoint = CodePoint::from(9968u32);
    pub const UMBRELLA_ON_GROUND : CodePoint = CodePoint::from(9969u32);
    pub const FOUNTAIN : CodePoint = CodePoint::from(9970u32);
    pub const FLAG_IN_HOLE : CodePoint = CodePoint::from(9971u32);
    pub const FERRY : CodePoint = CodePoint::from(9972u32);
    pub const SAILBOAT : CodePoint = CodePoint::from(9973u32);
    pub const SQUARE_FOUR_CORNERS : CodePoint = CodePoint::from(9974u32);
    pub const SKIER : CodePoint = CodePoint::from(9975u32);
    pub const ICE_SKATE : CodePoint = CodePoint::from(9976u32);
    pub const PERSON_WITH_BALL : CodePoint = CodePoint::from(9977u32);
    pub const TENT : CodePoint = CodePoint::from(9978u32);
    pub const JAPANESE_BANK_SYMBOL : CodePoint = CodePoint::from(9979u32);
    pub const HEADSTONE_GRAVEYARD_SYMBOL : CodePoint = CodePoint::from(9980u32);
    pub const FUEL_PUMP : CodePoint = CodePoint::from(9981u32);
    pub const CUP_ON_BLACK_SQUARE : CodePoint = CodePoint::from(9982u32);
    pub const WHITE_FLAG_WITH_HORIZONTAL_MIDDLE_BLACK_STRIPE : CodePoint = CodePoint::from(9983u32);
    pub const BLACK_SAFETY_SCISSORS : CodePoint = CodePoint::from(9984u32);
    pub const UPPER_BLADE_SCISSORS : CodePoint = CodePoint::from(9985u32);
    pub const BLACK_SCISSORS : CodePoint = CodePoint::from(9986u32);
    pub const LOWER_BLADE_SCISSORS : CodePoint = CodePoint::from(9987u32);
    pub const WHITE_SCISSORS : CodePoint = CodePoint::from(9988u32);
    pub const WHITE_HEAVY_CHECK_MARK : CodePoint = CodePoint::from(9989u32);
    pub const TELEPHONE_LOCATION_SIGN : CodePoint = CodePoint::from(9990u32);
    pub const TAPE_DRIVE : CodePoint = CodePoint::from(9991u32);
    pub const AIRPLANE : CodePoint = CodePoint::from(9992u32);
    pub const ENVELOPE : CodePoint = CodePoint::from(9993u32);
    pub const RAISED_FIST : CodePoint = CodePoint::from(9994u32);
    pub const RAISED_HAND : CodePoint = CodePoint::from(9995u32);
    pub const VICTORY_HAND : CodePoint = CodePoint::from(9996u32);
    pub const WRITING_HAND : CodePoint = CodePoint::from(9997u32);
    pub const LOWER_RIGHT_PENCIL : CodePoint = CodePoint::from(9998u32);
    pub const PENCIL : CodePoint = CodePoint::from(9999u32);
    pub const UPPER_RIGHT_PENCIL : CodePoint = CodePoint::from(10000u32);
    pub const WHITE_NIB : CodePoint = CodePoint::from(10001u32);
    pub const BLACK_NIB : CodePoint = CodePoint::from(10002u32);
    pub const CHECK_MARK : CodePoint = CodePoint::from(10003u32);
    pub const HEAVY_CHECK_MARK : CodePoint = CodePoint::from(10004u32);
    pub const MULTIPLICATION_X : CodePoint = CodePoint::from(10005u32);
    pub const HEAVY_MULTIPLICATION_X : CodePoint = CodePoint::from(10006u32);
    pub const BALLOT_X : CodePoint = CodePoint::from(10007u32);
    pub const HEAVY_BALLOT_X : CodePoint = CodePoint::from(10008u32);
    pub const OUTLINED_GREEK_CROSS : CodePoint = CodePoint::from(10009u32);
    pub const HEAVY_GREEK_CROSS : CodePoint = CodePoint::from(10010u32);
    pub const OPEN_CENTRE_CROSS : CodePoint = CodePoint::from(10011u32);
    pub const HEAVY_OPEN_CENTRE_CROSS : CodePoint = CodePoint::from(10012u32);
    pub const LATIN_CROSS : CodePoint = CodePoint::from(10013u32);
    pub const SHADOWED_WHITE_LATIN_CROSS : CodePoint = CodePoint::from(10014u32);
    pub const OUTLINED_LATIN_CROSS : CodePoint = CodePoint::from(10015u32);
    pub const MALTESE_CROSS : CodePoint = CodePoint::from(10016u32);
    pub const STAR_OF_DAVID : CodePoint = CodePoint::from(10017u32);
    pub const FOUR_TEARDROP_SPOKED_ASTERISK : CodePoint = CodePoint::from(10018u32);
    pub const FOUR_BALLOON_SPOKED_ASTERISK : CodePoint = CodePoint::from(10019u32);
    pub const HEAVY_FOUR_BALLOON_SPOKED_ASTERISK : CodePoint = CodePoint::from(10020u32);
    pub const FOUR_CLUB_SPOKED_ASTERISK : CodePoint = CodePoint::from(10021u32);
    pub const BLACK_FOUR_POINTED_STAR : CodePoint = CodePoint::from(10022u32);
    pub const WHITE_FOUR_POINTED_STAR : CodePoint = CodePoint::from(10023u32);
    pub const SPARKLES : CodePoint = CodePoint::from(10024u32);
    pub const STRESS_OUTLINED_WHITE_STAR : CodePoint = CodePoint::from(10025u32);
    pub const CIRCLED_WHITE_STAR : CodePoint = CodePoint::from(10026u32);
    pub const OPEN_CENTRE_BLACK_STAR : CodePoint = CodePoint::from(10027u32);
    pub const BLACK_CENTRE_WHITE_STAR : CodePoint = CodePoint::from(10028u32);
    pub const OUTLINED_BLACK_STAR : CodePoint = CodePoint::from(10029u32);
    pub const HEAVY_OUTLINED_BLACK_STAR : CodePoint = CodePoint::from(10030u32);
    pub const PINWHEEL_STAR : CodePoint = CodePoint::from(10031u32);
    pub const SHADOWED_WHITE_STAR : CodePoint = CodePoint::from(10032u32);
    pub const HEAVY_ASTERISK : CodePoint = CodePoint::from(10033u32);
    pub const OPEN_CENTRE_ASTERISK : CodePoint = CodePoint::from(10034u32);
    pub const EIGHT_SPOKED_ASTERISK : CodePoint = CodePoint::from(10035u32);
    pub const EIGHT_POINTED_BLACK_STAR : CodePoint = CodePoint::from(10036u32);
    pub const EIGHT_POINTED_PINWHEEL_STAR : CodePoint = CodePoint::from(10037u32);
    pub const SIX_POINTED_BLACK_STAR : CodePoint = CodePoint::from(10038u32);
    pub const EIGHT_POINTED_RECTILINEAR_BLACK_STAR : CodePoint = CodePoint::from(10039u32);
    pub const HEAVY_EIGHT_POINTED_RECTILINEAR_BLACK_STAR : CodePoint = CodePoint::from(10040u32);
    pub const TWELVE_POINTED_BLACK_STAR : CodePoint = CodePoint::from(10041u32);
    pub const SIXTEEN_POINTED_ASTERISK : CodePoint = CodePoint::from(10042u32);
    pub const TEARDROP_SPOKED_ASTERISK : CodePoint = CodePoint::from(10043u32);
    pub const OPEN_CENTRE_TEARDROP_SPOKED_ASTERISK : CodePoint = CodePoint::from(10044u32);
    pub const HEAVY_TEARDROP_SPOKED_ASTERISK : CodePoint = CodePoint::from(10045u32);
    pub const SIX_PETALLED_BLACK_AND_WHITE_FLORETTE : CodePoint = CodePoint::from(10046u32);
    pub const BLACK_FLORETTE : CodePoint = CodePoint::from(10047u32);
    pub const WHITE_FLORETTE : CodePoint = CodePoint::from(10048u32);
    pub const EIGHT_PETALLED_OUTLINED_BLACK_FLORETTE : CodePoint = CodePoint::from(10049u32);
    pub const CIRCLED_OPEN_CENTRE_EIGHT_POINTED_STAR : CodePoint = CodePoint::from(10050u32);
    pub const HEAVY_TEARDROP_SPOKED_PINWHEEL_ASTERISK : CodePoint = CodePoint::from(10051u32);
    pub const SNOWFLAKE : CodePoint = CodePoint::from(10052u32);
    pub const TIGHT_TRIFOLIATE_SNOWFLAKE : CodePoint = CodePoint::from(10053u32);
    pub const HEAVY_CHEVRON_SNOWFLAKE : CodePoint = CodePoint::from(10054u32);
    pub const SPARKLE : CodePoint = CodePoint::from(10055u32);
    pub const HEAVY_SPARKLE : CodePoint = CodePoint::from(10056u32);
    pub const BALLOON_SPOKED_ASTERISK : CodePoint = CodePoint::from(10057u32);
    pub const EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK : CodePoint = CodePoint::from(10058u32);
    pub const HEAVY_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK : CodePoint = CodePoint::from(10059u32);
    pub const CROSS_MARK : CodePoint = CodePoint::from(10060u32);
    pub const SHADOWED_WHITE_CIRCLE : CodePoint = CodePoint::from(10061u32);
    pub const NEGATIVE_SQUARED_CROSS_MARK : CodePoint = CodePoint::from(10062u32);
    pub const LOWER_RIGHT_DROP_SHADOWED_WHITE_SQUARE : CodePoint = CodePoint::from(10063u32);
    pub const UPPER_RIGHT_DROP_SHADOWED_WHITE_SQUARE : CodePoint = CodePoint::from(10064u32);
    pub const LOWER_RIGHT_SHADOWED_WHITE_SQUARE : CodePoint = CodePoint::from(10065u32);
    pub const UPPER_RIGHT_SHADOWED_WHITE_SQUARE : CodePoint = CodePoint::from(10066u32);
    pub const BLACK_QUESTION_MARK_ORNAMENT : CodePoint = CodePoint::from(10067u32);
    pub const WHITE_QUESTION_MARK_ORNAMENT : CodePoint = CodePoint::from(10068u32);
    pub const WHITE_EXCLAMATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10069u32);
    pub const BLACK_DIAMOND_MINUS_WHITE_X : CodePoint = CodePoint::from(10070u32);
    pub const HEAVY_EXCLAMATION_MARK_SYMBOL : CodePoint = CodePoint::from(10071u32);
    pub const LIGHT_VERTICAL_BAR : CodePoint = CodePoint::from(10072u32);
    pub const MEDIUM_VERTICAL_BAR : CodePoint = CodePoint::from(10073u32);
    pub const HEAVY_VERTICAL_BAR : CodePoint = CodePoint::from(10074u32);
    pub const HEAVY_SINGLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10075u32);
    pub const HEAVY_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10076u32);
    pub const HEAVY_DOUBLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10077u32);
    pub const HEAVY_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10078u32);
    pub const HEAVY_LOW_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10079u32);
    pub const HEAVY_LOW_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10080u32);
    pub const CURVED_STEM_PARAGRAPH_SIGN_ORNAMENT : CodePoint = CodePoint::from(10081u32);
    pub const HEAVY_EXCLAMATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10082u32);
    pub const HEAVY_HEART_EXCLAMATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10083u32);
    pub const HEAVY_BLACK_HEART : CodePoint = CodePoint::from(10084u32);
    pub const ROTATED_HEAVY_BLACK_HEART_BULLET : CodePoint = CodePoint::from(10085u32);
    pub const FLORAL_HEART : CodePoint = CodePoint::from(10086u32);
    pub const ROTATED_FLORAL_HEART_BULLET : CodePoint = CodePoint::from(10087u32);
    pub const MEDIUM_LEFT_PARENTHESIS_ORNAMENT : CodePoint = CodePoint::from(10088u32);
    pub const MEDIUM_RIGHT_PARENTHESIS_ORNAMENT : CodePoint = CodePoint::from(10089u32);
    pub const MEDIUM_FLATTENED_LEFT_PARENTHESIS_ORNAMENT : CodePoint = CodePoint::from(10090u32);
    pub const MEDIUM_FLATTENED_RIGHT_PARENTHESIS_ORNAMENT : CodePoint = CodePoint::from(10091u32);
    pub const MEDIUM_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10092u32);
    pub const MEDIUM_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10093u32);
    pub const HEAVY_LEFT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10094u32);
    pub const HEAVY_RIGHT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT : CodePoint = CodePoint::from(10095u32);
    pub const HEAVY_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10096u32);
    pub const HEAVY_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10097u32);
    pub const LIGHT_LEFT_TORTOISE_SHELL_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10098u32);
    pub const LIGHT_RIGHT_TORTOISE_SHELL_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10099u32);
    pub const MEDIUM_LEFT_CURLY_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10100u32);
    pub const MEDIUM_RIGHT_CURLY_BRACKET_ORNAMENT : CodePoint = CodePoint::from(10101u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_ONE : CodePoint = CodePoint::from(10102u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_TWO : CodePoint = CodePoint::from(10103u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_THREE : CodePoint = CodePoint::from(10104u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_FOUR : CodePoint = CodePoint::from(10105u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_FIVE : CodePoint = CodePoint::from(10106u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_SIX : CodePoint = CodePoint::from(10107u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_SEVEN : CodePoint = CodePoint::from(10108u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_EIGHT : CodePoint = CodePoint::from(10109u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_DIGIT_NINE : CodePoint = CodePoint::from(10110u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_NUMBER_TEN : CodePoint = CodePoint::from(10111u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_ONE : CodePoint = CodePoint::from(10112u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_TWO : CodePoint = CodePoint::from(10113u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_THREE : CodePoint = CodePoint::from(10114u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FOUR : CodePoint = CodePoint::from(10115u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FIVE : CodePoint = CodePoint::from(10116u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SIX : CodePoint = CodePoint::from(10117u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SEVEN : CodePoint = CodePoint::from(10118u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_EIGHT : CodePoint = CodePoint::from(10119u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_DIGIT_NINE : CodePoint = CodePoint::from(10120u32);
    pub const DINGBAT_CIRCLED_SANS_SERIF_NUMBER_TEN : CodePoint = CodePoint::from(10121u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_ONE : CodePoint = CodePoint::from(10122u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_TWO : CodePoint = CodePoint::from(10123u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_THREE : CodePoint = CodePoint::from(10124u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FOUR : CodePoint = CodePoint::from(10125u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FIVE : CodePoint = CodePoint::from(10126u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SIX : CodePoint = CodePoint::from(10127u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SEVEN : CodePoint = CodePoint::from(10128u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_EIGHT : CodePoint = CodePoint::from(10129u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_NINE : CodePoint = CodePoint::from(10130u32);
    pub const DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_NUMBER_TEN : CodePoint = CodePoint::from(10131u32);
    pub const HEAVY_WIDE_HEADED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10132u32);
    pub const HEAVY_PLUS_SIGN : CodePoint = CodePoint::from(10133u32);
    pub const HEAVY_MINUS_SIGN : CodePoint = CodePoint::from(10134u32);
    pub const HEAVY_DIVISION_SIGN : CodePoint = CodePoint::from(10135u32);
    pub const HEAVY_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10136u32);
    pub const HEAVY_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10137u32);
    pub const HEAVY_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10138u32);
    pub const DRAFTING_POINT_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10139u32);
    pub const HEAVY_ROUND_TIPPED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10140u32);
    pub const TRIANGLE_HEADED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10141u32);
    pub const HEAVY_TRIANGLE_HEADED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10142u32);
    pub const DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10143u32);
    pub const HEAVY_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10144u32);
    pub const BLACK_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10145u32);
    pub const THREE_D_TOP_LIGHTED_RIGHTWARDS_ARROWHEAD : CodePoint = CodePoint::from(10146u32);
    pub const THREE_D_BOTTOM_LIGHTED_RIGHTWARDS_ARROWHEAD : CodePoint = CodePoint::from(10147u32);
    pub const BLACK_RIGHTWARDS_ARROWHEAD : CodePoint = CodePoint::from(10148u32);
    pub const HEAVY_BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10149u32);
    pub const HEAVY_BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10150u32);
    pub const SQUAT_BLACK_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10151u32);
    pub const HEAVY_CONCAVE_POINTED_BLACK_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10152u32);
    pub const RIGHT_SHADED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10153u32);
    pub const LEFT_SHADED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10154u32);
    pub const BACK_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10155u32);
    pub const FRONT_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10156u32);
    pub const HEAVY_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10157u32);
    pub const HEAVY_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10158u32);
    pub const NOTCHED_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10159u32);
    pub const CURLY_LOOP : CodePoint = CodePoint::from(10160u32);
    pub const NOTCHED_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10161u32);
    pub const CIRCLED_HEAVY_WHITE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10162u32);
    pub const WHITE_FEATHERED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10163u32);
    pub const BLACK_FEATHERED_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10164u32);
    pub const BLACK_FEATHERED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10165u32);
    pub const BLACK_FEATHERED_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10166u32);
    pub const HEAVY_BLACK_FEATHERED_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10167u32);
    pub const HEAVY_BLACK_FEATHERED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10168u32);
    pub const HEAVY_BLACK_FEATHERED_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10169u32);
    pub const TEARDROP_BARBED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10170u32);
    pub const HEAVY_TEARDROP_SHANKED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10171u32);
    pub const WEDGE_TAILED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10172u32);
    pub const HEAVY_WEDGE_TAILED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10173u32);
    pub const OPEN_OUTLINED_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10174u32);
    pub const DOUBLE_CURLY_LOOP : CodePoint = CodePoint::from(10175u32);
    pub const THREE_DIMENSIONAL_ANGLE : CodePoint = CodePoint::from(10176u32);
    pub const WHITE_TRIANGLE_CONTAINING_SMALL_WHITE_TRIANGLE : CodePoint = CodePoint::from(10177u32);
    pub const PERPENDICULAR : CodePoint = CodePoint::from(10178u32);
    pub const OPEN_SUBSET : CodePoint = CodePoint::from(10179u32);
    pub const OPEN_SUPERSET : CodePoint = CodePoint::from(10180u32);
    pub const LEFT_S_SHAPED_BAG_DELIMITER : CodePoint = CodePoint::from(10181u32);
    pub const RIGHT_S_SHAPED_BAG_DELIMITER : CodePoint = CodePoint::from(10182u32);
    pub const OR_WITH_DOT_INSIDE : CodePoint = CodePoint::from(10183u32);
    pub const REVERSE_SOLIDUS_PRECEDING_SUBSET : CodePoint = CodePoint::from(10184u32);
    pub const SUPERSET_PRECEDING_SOLIDUS : CodePoint = CodePoint::from(10185u32);
    pub const VERTICAL_BAR_WITH_HORIZONTAL_STROKE : CodePoint = CodePoint::from(10186u32);
    pub const MATHEMATICAL_RISING_DIAGONAL : CodePoint = CodePoint::from(10187u32);
    pub const LONG_DIVISION : CodePoint = CodePoint::from(10188u32);
    pub const MATHEMATICAL_FALLING_DIAGONAL : CodePoint = CodePoint::from(10189u32);
    pub const SQUARED_LOGICAL_AND : CodePoint = CodePoint::from(10190u32);
    pub const SQUARED_LOGICAL_OR : CodePoint = CodePoint::from(10191u32);
    pub const WHITE_DIAMOND_WITH_CENTRED_DOT : CodePoint = CodePoint::from(10192u32);
    pub const AND_WITH_DOT : CodePoint = CodePoint::from(10193u32);
    pub const ELEMENT_OF_OPENING_UPWARDS : CodePoint = CodePoint::from(10194u32);
    pub const LOWER_RIGHT_CORNER_WITH_DOT : CodePoint = CodePoint::from(10195u32);
    pub const UPPER_LEFT_CORNER_WITH_DOT : CodePoint = CodePoint::from(10196u32);
    pub const LEFT_OUTER_JOIN : CodePoint = CodePoint::from(10197u32);
    pub const RIGHT_OUTER_JOIN : CodePoint = CodePoint::from(10198u32);
    pub const FULL_OUTER_JOIN : CodePoint = CodePoint::from(10199u32);
    pub const LARGE_UP_TACK : CodePoint = CodePoint::from(10200u32);
    pub const LARGE_DOWN_TACK : CodePoint = CodePoint::from(10201u32);
    pub const LEFT_AND_RIGHT_DOUBLE_TURNSTILE : CodePoint = CodePoint::from(10202u32);
    pub const LEFT_AND_RIGHT_TACK : CodePoint = CodePoint::from(10203u32);
    pub const LEFT_MULTIMAP : CodePoint = CodePoint::from(10204u32);
    pub const LONG_RIGHT_TACK : CodePoint = CodePoint::from(10205u32);
    pub const LONG_LEFT_TACK : CodePoint = CodePoint::from(10206u32);
    pub const UP_TACK_WITH_CIRCLE_ABOVE : CodePoint = CodePoint::from(10207u32);
    pub const LOZENGE_DIVIDED_BY_HORIZONTAL_RULE : CodePoint = CodePoint::from(10208u32);
    pub const WHITE_CONCAVE_SIDED_DIAMOND : CodePoint = CodePoint::from(10209u32);
    pub const WHITE_CONCAVE_SIDED_DIAMOND_WITH_LEFTWARDS_TICK : CodePoint = CodePoint::from(10210u32);
    pub const WHITE_CONCAVE_SIDED_DIAMOND_WITH_RIGHTWARDS_TICK : CodePoint = CodePoint::from(10211u32);
    pub const WHITE_SQUARE_WITH_LEFTWARDS_TICK : CodePoint = CodePoint::from(10212u32);
    pub const WHITE_SQUARE_WITH_RIGHTWARDS_TICK : CodePoint = CodePoint::from(10213u32);
    pub const MATHEMATICAL_LEFT_WHITE_SQUARE_BRACKET : CodePoint = CodePoint::from(10214u32);
    pub const MATHEMATICAL_RIGHT_WHITE_SQUARE_BRACKET : CodePoint = CodePoint::from(10215u32);
    pub const MATHEMATICAL_LEFT_ANGLE_BRACKET : CodePoint = CodePoint::from(10216u32);
    pub const MATHEMATICAL_RIGHT_ANGLE_BRACKET : CodePoint = CodePoint::from(10217u32);
    pub const MATHEMATICAL_LEFT_DOUBLE_ANGLE_BRACKET : CodePoint = CodePoint::from(10218u32);
    pub const MATHEMATICAL_RIGHT_DOUBLE_ANGLE_BRACKET : CodePoint = CodePoint::from(10219u32);
    pub const MATHEMATICAL_LEFT_WHITE_TORTOISE_SHELL_BRACKET : CodePoint = CodePoint::from(10220u32);
    pub const MATHEMATICAL_RIGHT_WHITE_TORTOISE_SHELL_BRACKET : CodePoint = CodePoint::from(10221u32);
    pub const MATHEMATICAL_LEFT_FLATTENED_PARENTHESIS : CodePoint = CodePoint::from(10222u32);
    pub const MATHEMATICAL_RIGHT_FLATTENED_PARENTHESIS : CodePoint = CodePoint::from(10223u32);
    pub const UPWARDS_QUADRUPLE_ARROW : CodePoint = CodePoint::from(10224u32);
    pub const DOWNWARDS_QUADRUPLE_ARROW : CodePoint = CodePoint::from(10225u32);
    pub const ANTICLOCKWISE_GAPPED_CIRCLE_ARROW : CodePoint = CodePoint::from(10226u32);
    pub const CLOCKWISE_GAPPED_CIRCLE_ARROW : CodePoint = CodePoint::from(10227u32);
    pub const RIGHT_ARROW_WITH_CIRCLED_PLUS : CodePoint = CodePoint::from(10228u32);
    pub const LONG_LEFTWARDS_ARROW : CodePoint = CodePoint::from(10229u32);
    pub const LONG_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10230u32);
    pub const LONG_LEFT_RIGHT_ARROW : CodePoint = CodePoint::from(10231u32);
    pub const LONG_LEFTWARDS_DOUBLE_ARROW : CodePoint = CodePoint::from(10232u32);
    pub const LONG_RIGHTWARDS_DOUBLE_ARROW : CodePoint = CodePoint::from(10233u32);
    pub const LONG_LEFT_RIGHT_DOUBLE_ARROW : CodePoint = CodePoint::from(10234u32);
    pub const LONG_LEFTWARDS_ARROW_FROM_BAR : CodePoint = CodePoint::from(10235u32);
    pub const LONG_RIGHTWARDS_ARROW_FROM_BAR : CodePoint = CodePoint::from(10236u32);
    pub const LONG_LEFTWARDS_DOUBLE_ARROW_FROM_BAR : CodePoint = CodePoint::from(10237u32);
    pub const LONG_RIGHTWARDS_DOUBLE_ARROW_FROM_BAR : CodePoint = CodePoint::from(10238u32);
    pub const LONG_RIGHTWARDS_SQUIGGLE_ARROW : CodePoint = CodePoint::from(10239u32);
    pub const BRAILLE_PATTERN_BLANK : CodePoint = CodePoint::from(10240u32);
    pub const BRAILLE_PATTERN_DOTS_1 : CodePoint = CodePoint::from(10241u32);
    pub const BRAILLE_PATTERN_DOTS_2 : CodePoint = CodePoint::from(10242u32);
    pub const BRAILLE_PATTERN_DOTS_12 : CodePoint = CodePoint::from(10243u32);
    pub const BRAILLE_PATTERN_DOTS_3 : CodePoint = CodePoint::from(10244u32);
    pub const BRAILLE_PATTERN_DOTS_13 : CodePoint = CodePoint::from(10245u32);
    pub const BRAILLE_PATTERN_DOTS_23 : CodePoint = CodePoint::from(10246u32);
    pub const BRAILLE_PATTERN_DOTS_123 : CodePoint = CodePoint::from(10247u32);
    pub const BRAILLE_PATTERN_DOTS_4 : CodePoint = CodePoint::from(10248u32);
    pub const BRAILLE_PATTERN_DOTS_14 : CodePoint = CodePoint::from(10249u32);
    pub const BRAILLE_PATTERN_DOTS_24 : CodePoint = CodePoint::from(10250u32);
    pub const BRAILLE_PATTERN_DOTS_124 : CodePoint = CodePoint::from(10251u32);
    pub const BRAILLE_PATTERN_DOTS_34 : CodePoint = CodePoint::from(10252u32);
    pub const BRAILLE_PATTERN_DOTS_134 : CodePoint = CodePoint::from(10253u32);
    pub const BRAILLE_PATTERN_DOTS_234 : CodePoint = CodePoint::from(10254u32);
    pub const BRAILLE_PATTERN_DOTS_1234 : CodePoint = CodePoint::from(10255u32);
    pub const BRAILLE_PATTERN_DOTS_5 : CodePoint = CodePoint::from(10256u32);
    pub const BRAILLE_PATTERN_DOTS_15 : CodePoint = CodePoint::from(10257u32);
    pub const BRAILLE_PATTERN_DOTS_25 : CodePoint = CodePoint::from(10258u32);
    pub const BRAILLE_PATTERN_DOTS_125 : CodePoint = CodePoint::from(10259u32);
    pub const BRAILLE_PATTERN_DOTS_35 : CodePoint = CodePoint::from(10260u32);
    pub const BRAILLE_PATTERN_DOTS_135 : CodePoint = CodePoint::from(10261u32);
    pub const BRAILLE_PATTERN_DOTS_235 : CodePoint = CodePoint::from(10262u32);
    pub const BRAILLE_PATTERN_DOTS_1235 : CodePoint = CodePoint::from(10263u32);
    pub const BRAILLE_PATTERN_DOTS_45 : CodePoint = CodePoint::from(10264u32);
    pub const BRAILLE_PATTERN_DOTS_145 : CodePoint = CodePoint::from(10265u32);
    pub const BRAILLE_PATTERN_DOTS_245 : CodePoint = CodePoint::from(10266u32);
    pub const BRAILLE_PATTERN_DOTS_1245 : CodePoint = CodePoint::from(10267u32);
    pub const BRAILLE_PATTERN_DOTS_345 : CodePoint = CodePoint::from(10268u32);
    pub const BRAILLE_PATTERN_DOTS_1345 : CodePoint = CodePoint::from(10269u32);
    pub const BRAILLE_PATTERN_DOTS_2345 : CodePoint = CodePoint::from(10270u32);
    pub const BRAILLE_PATTERN_DOTS_12345 : CodePoint = CodePoint::from(10271u32);
    pub const BRAILLE_PATTERN_DOTS_6 : CodePoint = CodePoint::from(10272u32);
    pub const BRAILLE_PATTERN_DOTS_16 : CodePoint = CodePoint::from(10273u32);
    pub const BRAILLE_PATTERN_DOTS_26 : CodePoint = CodePoint::from(10274u32);
    pub const BRAILLE_PATTERN_DOTS_126 : CodePoint = CodePoint::from(10275u32);
    pub const BRAILLE_PATTERN_DOTS_36 : CodePoint = CodePoint::from(10276u32);
    pub const BRAILLE_PATTERN_DOTS_136 : CodePoint = CodePoint::from(10277u32);
    pub const BRAILLE_PATTERN_DOTS_236 : CodePoint = CodePoint::from(10278u32);
    pub const BRAILLE_PATTERN_DOTS_1236 : CodePoint = CodePoint::from(10279u32);
    pub const BRAILLE_PATTERN_DOTS_46 : CodePoint = CodePoint::from(10280u32);
    pub const BRAILLE_PATTERN_DOTS_146 : CodePoint = CodePoint::from(10281u32);
    pub const BRAILLE_PATTERN_DOTS_246 : CodePoint = CodePoint::from(10282u32);
    pub const BRAILLE_PATTERN_DOTS_1246 : CodePoint = CodePoint::from(10283u32);
    pub const BRAILLE_PATTERN_DOTS_346 : CodePoint = CodePoint::from(10284u32);
    pub const BRAILLE_PATTERN_DOTS_1346 : CodePoint = CodePoint::from(10285u32);
    pub const BRAILLE_PATTERN_DOTS_2346 : CodePoint = CodePoint::from(10286u32);
    pub const BRAILLE_PATTERN_DOTS_12346 : CodePoint = CodePoint::from(10287u32);
    pub const BRAILLE_PATTERN_DOTS_56 : CodePoint = CodePoint::from(10288u32);
    pub const BRAILLE_PATTERN_DOTS_156 : CodePoint = CodePoint::from(10289u32);
    pub const BRAILLE_PATTERN_DOTS_256 : CodePoint = CodePoint::from(10290u32);
    pub const BRAILLE_PATTERN_DOTS_1256 : CodePoint = CodePoint::from(10291u32);
    pub const BRAILLE_PATTERN_DOTS_356 : CodePoint = CodePoint::from(10292u32);
    pub const BRAILLE_PATTERN_DOTS_1356 : CodePoint = CodePoint::from(10293u32);
    pub const BRAILLE_PATTERN_DOTS_2356 : CodePoint = CodePoint::from(10294u32);
    pub const BRAILLE_PATTERN_DOTS_12356 : CodePoint = CodePoint::from(10295u32);
    pub const BRAILLE_PATTERN_DOTS_456 : CodePoint = CodePoint::from(10296u32);
    pub const BRAILLE_PATTERN_DOTS_1456 : CodePoint = CodePoint::from(10297u32);
    pub const BRAILLE_PATTERN_DOTS_2456 : CodePoint = CodePoint::from(10298u32);
    pub const BRAILLE_PATTERN_DOTS_12456 : CodePoint = CodePoint::from(10299u32);
    pub const BRAILLE_PATTERN_DOTS_3456 : CodePoint = CodePoint::from(10300u32);
    pub const BRAILLE_PATTERN_DOTS_13456 : CodePoint = CodePoint::from(10301u32);
    pub const BRAILLE_PATTERN_DOTS_23456 : CodePoint = CodePoint::from(10302u32);
    pub const BRAILLE_PATTERN_DOTS_123456 : CodePoint = CodePoint::from(10303u32);
    pub const BRAILLE_PATTERN_DOTS_7 : CodePoint = CodePoint::from(10304u32);
    pub const BRAILLE_PATTERN_DOTS_17 : CodePoint = CodePoint::from(10305u32);
    pub const BRAILLE_PATTERN_DOTS_27 : CodePoint = CodePoint::from(10306u32);
    pub const BRAILLE_PATTERN_DOTS_127 : CodePoint = CodePoint::from(10307u32);
    pub const BRAILLE_PATTERN_DOTS_37 : CodePoint = CodePoint::from(10308u32);
    pub const BRAILLE_PATTERN_DOTS_137 : CodePoint = CodePoint::from(10309u32);
    pub const BRAILLE_PATTERN_DOTS_237 : CodePoint = CodePoint::from(10310u32);
    pub const BRAILLE_PATTERN_DOTS_1237 : CodePoint = CodePoint::from(10311u32);
    pub const BRAILLE_PATTERN_DOTS_47 : CodePoint = CodePoint::from(10312u32);
    pub const BRAILLE_PATTERN_DOTS_147 : CodePoint = CodePoint::from(10313u32);
    pub const BRAILLE_PATTERN_DOTS_247 : CodePoint = CodePoint::from(10314u32);
    pub const BRAILLE_PATTERN_DOTS_1247 : CodePoint = CodePoint::from(10315u32);
    pub const BRAILLE_PATTERN_DOTS_347 : CodePoint = CodePoint::from(10316u32);
    pub const BRAILLE_PATTERN_DOTS_1347 : CodePoint = CodePoint::from(10317u32);
    pub const BRAILLE_PATTERN_DOTS_2347 : CodePoint = CodePoint::from(10318u32);
    pub const BRAILLE_PATTERN_DOTS_12347 : CodePoint = CodePoint::from(10319u32);
    pub const BRAILLE_PATTERN_DOTS_57 : CodePoint = CodePoint::from(10320u32);
    pub const BRAILLE_PATTERN_DOTS_157 : CodePoint = CodePoint::from(10321u32);
    pub const BRAILLE_PATTERN_DOTS_257 : CodePoint = CodePoint::from(10322u32);
    pub const BRAILLE_PATTERN_DOTS_1257 : CodePoint = CodePoint::from(10323u32);
    pub const BRAILLE_PATTERN_DOTS_357 : CodePoint = CodePoint::from(10324u32);
    pub const BRAILLE_PATTERN_DOTS_1357 : CodePoint = CodePoint::from(10325u32);
    pub const BRAILLE_PATTERN_DOTS_2357 : CodePoint = CodePoint::from(10326u32);
    pub const BRAILLE_PATTERN_DOTS_12357 : CodePoint = CodePoint::from(10327u32);
    pub const BRAILLE_PATTERN_DOTS_457 : CodePoint = CodePoint::from(10328u32);
    pub const BRAILLE_PATTERN_DOTS_1457 : CodePoint = CodePoint::from(10329u32);
    pub const BRAILLE_PATTERN_DOTS_2457 : CodePoint = CodePoint::from(10330u32);
    pub const BRAILLE_PATTERN_DOTS_12457 : CodePoint = CodePoint::from(10331u32);
    pub const BRAILLE_PATTERN_DOTS_3457 : CodePoint = CodePoint::from(10332u32);
    pub const BRAILLE_PATTERN_DOTS_13457 : CodePoint = CodePoint::from(10333u32);
    pub const BRAILLE_PATTERN_DOTS_23457 : CodePoint = CodePoint::from(10334u32);
    pub const BRAILLE_PATTERN_DOTS_123457 : CodePoint = CodePoint::from(10335u32);
    pub const BRAILLE_PATTERN_DOTS_67 : CodePoint = CodePoint::from(10336u32);
    pub const BRAILLE_PATTERN_DOTS_167 : CodePoint = CodePoint::from(10337u32);
    pub const BRAILLE_PATTERN_DOTS_267 : CodePoint = CodePoint::from(10338u32);
    pub const BRAILLE_PATTERN_DOTS_1267 : CodePoint = CodePoint::from(10339u32);
    pub const BRAILLE_PATTERN_DOTS_367 : CodePoint = CodePoint::from(10340u32);
    pub const BRAILLE_PATTERN_DOTS_1367 : CodePoint = CodePoint::from(10341u32);
    pub const BRAILLE_PATTERN_DOTS_2367 : CodePoint = CodePoint::from(10342u32);
    pub const BRAILLE_PATTERN_DOTS_12367 : CodePoint = CodePoint::from(10343u32);
    pub const BRAILLE_PATTERN_DOTS_467 : CodePoint = CodePoint::from(10344u32);
    pub const BRAILLE_PATTERN_DOTS_1467 : CodePoint = CodePoint::from(10345u32);
    pub const BRAILLE_PATTERN_DOTS_2467 : CodePoint = CodePoint::from(10346u32);
    pub const BRAILLE_PATTERN_DOTS_12467 : CodePoint = CodePoint::from(10347u32);
    pub const BRAILLE_PATTERN_DOTS_3467 : CodePoint = CodePoint::from(10348u32);
    pub const BRAILLE_PATTERN_DOTS_13467 : CodePoint = CodePoint::from(10349u32);
    pub const BRAILLE_PATTERN_DOTS_23467 : CodePoint = CodePoint::from(10350u32);
    pub const BRAILLE_PATTERN_DOTS_123467 : CodePoint = CodePoint::from(10351u32);
    pub const BRAILLE_PATTERN_DOTS_567 : CodePoint = CodePoint::from(10352u32);
    pub const BRAILLE_PATTERN_DOTS_1567 : CodePoint = CodePoint::from(10353u32);
    pub const BRAILLE_PATTERN_DOTS_2567 : CodePoint = CodePoint::from(10354u32);
    pub const BRAILLE_PATTERN_DOTS_12567 : CodePoint = CodePoint::from(10355u32);
    pub const BRAILLE_PATTERN_DOTS_3567 : CodePoint = CodePoint::from(10356u32);
    pub const BRAILLE_PATTERN_DOTS_13567 : CodePoint = CodePoint::from(10357u32);
    pub const BRAILLE_PATTERN_DOTS_23567 : CodePoint = CodePoint::from(10358u32);
    pub const BRAILLE_PATTERN_DOTS_123567 : CodePoint = CodePoint::from(10359u32);
    pub const BRAILLE_PATTERN_DOTS_4567 : CodePoint = CodePoint::from(10360u32);
    pub const BRAILLE_PATTERN_DOTS_14567 : CodePoint = CodePoint::from(10361u32);
    pub const BRAILLE_PATTERN_DOTS_24567 : CodePoint = CodePoint::from(10362u32);
    pub const BRAILLE_PATTERN_DOTS_124567 : CodePoint = CodePoint::from(10363u32);
    pub const BRAILLE_PATTERN_DOTS_34567 : CodePoint = CodePoint::from(10364u32);
    pub const BRAILLE_PATTERN_DOTS_134567 : CodePoint = CodePoint::from(10365u32);
    pub const BRAILLE_PATTERN_DOTS_234567 : CodePoint = CodePoint::from(10366u32);
    pub const BRAILLE_PATTERN_DOTS_1234567 : CodePoint = CodePoint::from(10367u32);
    pub const BRAILLE_PATTERN_DOTS_8 : CodePoint = CodePoint::from(10368u32);
    pub const BRAILLE_PATTERN_DOTS_18 : CodePoint = CodePoint::from(10369u32);
    pub const BRAILLE_PATTERN_DOTS_28 : CodePoint = CodePoint::from(10370u32);
    pub const BRAILLE_PATTERN_DOTS_128 : CodePoint = CodePoint::from(10371u32);
    pub const BRAILLE_PATTERN_DOTS_38 : CodePoint = CodePoint::from(10372u32);
    pub const BRAILLE_PATTERN_DOTS_138 : CodePoint = CodePoint::from(10373u32);
    pub const BRAILLE_PATTERN_DOTS_238 : CodePoint = CodePoint::from(10374u32);
    pub const BRAILLE_PATTERN_DOTS_1238 : CodePoint = CodePoint::from(10375u32);
    pub const BRAILLE_PATTERN_DOTS_48 : CodePoint = CodePoint::from(10376u32);
    pub const BRAILLE_PATTERN_DOTS_148 : CodePoint = CodePoint::from(10377u32);
    pub const BRAILLE_PATTERN_DOTS_248 : CodePoint = CodePoint::from(10378u32);
    pub const BRAILLE_PATTERN_DOTS_1248 : CodePoint = CodePoint::from(10379u32);
    pub const BRAILLE_PATTERN_DOTS_348 : CodePoint = CodePoint::from(10380u32);
    pub const BRAILLE_PATTERN_DOTS_1348 : CodePoint = CodePoint::from(10381u32);
    pub const BRAILLE_PATTERN_DOTS_2348 : CodePoint = CodePoint::from(10382u32);
    pub const BRAILLE_PATTERN_DOTS_12348 : CodePoint = CodePoint::from(10383u32);
    pub const BRAILLE_PATTERN_DOTS_58 : CodePoint = CodePoint::from(10384u32);
    pub const BRAILLE_PATTERN_DOTS_158 : CodePoint = CodePoint::from(10385u32);
    pub const BRAILLE_PATTERN_DOTS_258 : CodePoint = CodePoint::from(10386u32);
    pub const BRAILLE_PATTERN_DOTS_1258 : CodePoint = CodePoint::from(10387u32);
    pub const BRAILLE_PATTERN_DOTS_358 : CodePoint = CodePoint::from(10388u32);
    pub const BRAILLE_PATTERN_DOTS_1358 : CodePoint = CodePoint::from(10389u32);
    pub const BRAILLE_PATTERN_DOTS_2358 : CodePoint = CodePoint::from(10390u32);
    pub const BRAILLE_PATTERN_DOTS_12358 : CodePoint = CodePoint::from(10391u32);
    pub const BRAILLE_PATTERN_DOTS_458 : CodePoint = CodePoint::from(10392u32);
    pub const BRAILLE_PATTERN_DOTS_1458 : CodePoint = CodePoint::from(10393u32);
    pub const BRAILLE_PATTERN_DOTS_2458 : CodePoint = CodePoint::from(10394u32);
    pub const BRAILLE_PATTERN_DOTS_12458 : CodePoint = CodePoint::from(10395u32);
    pub const BRAILLE_PATTERN_DOTS_3458 : CodePoint = CodePoint::from(10396u32);
    pub const BRAILLE_PATTERN_DOTS_13458 : CodePoint = CodePoint::from(10397u32);
    pub const BRAILLE_PATTERN_DOTS_23458 : CodePoint = CodePoint::from(10398u32);
    pub const BRAILLE_PATTERN_DOTS_123458 : CodePoint = CodePoint::from(10399u32);
    pub const BRAILLE_PATTERN_DOTS_68 : CodePoint = CodePoint::from(10400u32);
    pub const BRAILLE_PATTERN_DOTS_168 : CodePoint = CodePoint::from(10401u32);
    pub const BRAILLE_PATTERN_DOTS_268 : CodePoint = CodePoint::from(10402u32);
    pub const BRAILLE_PATTERN_DOTS_1268 : CodePoint = CodePoint::from(10403u32);
    pub const BRAILLE_PATTERN_DOTS_368 : CodePoint = CodePoint::from(10404u32);
    pub const BRAILLE_PATTERN_DOTS_1368 : CodePoint = CodePoint::from(10405u32);
    pub const BRAILLE_PATTERN_DOTS_2368 : CodePoint = CodePoint::from(10406u32);
    pub const BRAILLE_PATTERN_DOTS_12368 : CodePoint = CodePoint::from(10407u32);
    pub const BRAILLE_PATTERN_DOTS_468 : CodePoint = CodePoint::from(10408u32);
    pub const BRAILLE_PATTERN_DOTS_1468 : CodePoint = CodePoint::from(10409u32);
    pub const BRAILLE_PATTERN_DOTS_2468 : CodePoint = CodePoint::from(10410u32);
    pub const BRAILLE_PATTERN_DOTS_12468 : CodePoint = CodePoint::from(10411u32);
    pub const BRAILLE_PATTERN_DOTS_3468 : CodePoint = CodePoint::from(10412u32);
    pub const BRAILLE_PATTERN_DOTS_13468 : CodePoint = CodePoint::from(10413u32);
    pub const BRAILLE_PATTERN_DOTS_23468 : CodePoint = CodePoint::from(10414u32);
    pub const BRAILLE_PATTERN_DOTS_123468 : CodePoint = CodePoint::from(10415u32);
    pub const BRAILLE_PATTERN_DOTS_568 : CodePoint = CodePoint::from(10416u32);
    pub const BRAILLE_PATTERN_DOTS_1568 : CodePoint = CodePoint::from(10417u32);
    pub const BRAILLE_PATTERN_DOTS_2568 : CodePoint = CodePoint::from(10418u32);
    pub const BRAILLE_PATTERN_DOTS_12568 : CodePoint = CodePoint::from(10419u32);
    pub const BRAILLE_PATTERN_DOTS_3568 : CodePoint = CodePoint::from(10420u32);
    pub const BRAILLE_PATTERN_DOTS_13568 : CodePoint = CodePoint::from(10421u32);
    pub const BRAILLE_PATTERN_DOTS_23568 : CodePoint = CodePoint::from(10422u32);
    pub const BRAILLE_PATTERN_DOTS_123568 : CodePoint = CodePoint::from(10423u32);
    pub const BRAILLE_PATTERN_DOTS_4568 : CodePoint = CodePoint::from(10424u32);
    pub const BRAILLE_PATTERN_DOTS_14568 : CodePoint = CodePoint::from(10425u32);
    pub const BRAILLE_PATTERN_DOTS_24568 : CodePoint = CodePoint::from(10426u32);
    pub const BRAILLE_PATTERN_DOTS_124568 : CodePoint = CodePoint::from(10427u32);
    pub const BRAILLE_PATTERN_DOTS_34568 : CodePoint = CodePoint::from(10428u32);
    pub const BRAILLE_PATTERN_DOTS_134568 : CodePoint = CodePoint::from(10429u32);
    pub const BRAILLE_PATTERN_DOTS_234568 : CodePoint = CodePoint::from(10430u32);
    pub const BRAILLE_PATTERN_DOTS_1234568 : CodePoint = CodePoint::from(10431u32);
    pub const BRAILLE_PATTERN_DOTS_78 : CodePoint = CodePoint::from(10432u32);
    pub const BRAILLE_PATTERN_DOTS_178 : CodePoint = CodePoint::from(10433u32);
    pub const BRAILLE_PATTERN_DOTS_278 : CodePoint = CodePoint::from(10434u32);
    pub const BRAILLE_PATTERN_DOTS_1278 : CodePoint = CodePoint::from(10435u32);
    pub const BRAILLE_PATTERN_DOTS_378 : CodePoint = CodePoint::from(10436u32);
    pub const BRAILLE_PATTERN_DOTS_1378 : CodePoint = CodePoint::from(10437u32);
    pub const BRAILLE_PATTERN_DOTS_2378 : CodePoint = CodePoint::from(10438u32);
    pub const BRAILLE_PATTERN_DOTS_12378 : CodePoint = CodePoint::from(10439u32);
    pub const BRAILLE_PATTERN_DOTS_478 : CodePoint = CodePoint::from(10440u32);
    pub const BRAILLE_PATTERN_DOTS_1478 : CodePoint = CodePoint::from(10441u32);
    pub const BRAILLE_PATTERN_DOTS_2478 : CodePoint = CodePoint::from(10442u32);
    pub const BRAILLE_PATTERN_DOTS_12478 : CodePoint = CodePoint::from(10443u32);
    pub const BRAILLE_PATTERN_DOTS_3478 : CodePoint = CodePoint::from(10444u32);
    pub const BRAILLE_PATTERN_DOTS_13478 : CodePoint = CodePoint::from(10445u32);
    pub const BRAILLE_PATTERN_DOTS_23478 : CodePoint = CodePoint::from(10446u32);
    pub const BRAILLE_PATTERN_DOTS_123478 : CodePoint = CodePoint::from(10447u32);
    pub const BRAILLE_PATTERN_DOTS_578 : CodePoint = CodePoint::from(10448u32);
    pub const BRAILLE_PATTERN_DOTS_1578 : CodePoint = CodePoint::from(10449u32);
    pub const BRAILLE_PATTERN_DOTS_2578 : CodePoint = CodePoint::from(10450u32);
    pub const BRAILLE_PATTERN_DOTS_12578 : CodePoint = CodePoint::from(10451u32);
    pub const BRAILLE_PATTERN_DOTS_3578 : CodePoint = CodePoint::from(10452u32);
    pub const BRAILLE_PATTERN_DOTS_13578 : CodePoint = CodePoint::from(10453u32);
    pub const BRAILLE_PATTERN_DOTS_23578 : CodePoint = CodePoint::from(10454u32);
    pub const BRAILLE_PATTERN_DOTS_123578 : CodePoint = CodePoint::from(10455u32);
    pub const BRAILLE_PATTERN_DOTS_4578 : CodePoint = CodePoint::from(10456u32);
    pub const BRAILLE_PATTERN_DOTS_14578 : CodePoint = CodePoint::from(10457u32);
    pub const BRAILLE_PATTERN_DOTS_24578 : CodePoint = CodePoint::from(10458u32);
    pub const BRAILLE_PATTERN_DOTS_124578 : CodePoint = CodePoint::from(10459u32);
    pub const BRAILLE_PATTERN_DOTS_34578 : CodePoint = CodePoint::from(10460u32);
    pub const BRAILLE_PATTERN_DOTS_134578 : CodePoint = CodePoint::from(10461u32);
    pub const BRAILLE_PATTERN_DOTS_234578 : CodePoint = CodePoint::from(10462u32);
    pub const BRAILLE_PATTERN_DOTS_1234578 : CodePoint = CodePoint::from(10463u32);
    pub const BRAILLE_PATTERN_DOTS_678 : CodePoint = CodePoint::from(10464u32);
    pub const BRAILLE_PATTERN_DOTS_1678 : CodePoint = CodePoint::from(10465u32);
    pub const BRAILLE_PATTERN_DOTS_2678 : CodePoint = CodePoint::from(10466u32);
    pub const BRAILLE_PATTERN_DOTS_12678 : CodePoint = CodePoint::from(10467u32);
    pub const BRAILLE_PATTERN_DOTS_3678 : CodePoint = CodePoint::from(10468u32);
    pub const BRAILLE_PATTERN_DOTS_13678 : CodePoint = CodePoint::from(10469u32);
    pub const BRAILLE_PATTERN_DOTS_23678 : CodePoint = CodePoint::from(10470u32);
    pub const BRAILLE_PATTERN_DOTS_123678 : CodePoint = CodePoint::from(10471u32);
    pub const BRAILLE_PATTERN_DOTS_4678 : CodePoint = CodePoint::from(10472u32);
    pub const BRAILLE_PATTERN_DOTS_14678 : CodePoint = CodePoint::from(10473u32);
    pub const BRAILLE_PATTERN_DOTS_24678 : CodePoint = CodePoint::from(10474u32);
    pub const BRAILLE_PATTERN_DOTS_124678 : CodePoint = CodePoint::from(10475u32);
    pub const BRAILLE_PATTERN_DOTS_34678 : CodePoint = CodePoint::from(10476u32);
    pub const BRAILLE_PATTERN_DOTS_134678 : CodePoint = CodePoint::from(10477u32);
    pub const BRAILLE_PATTERN_DOTS_234678 : CodePoint = CodePoint::from(10478u32);
    pub const BRAILLE_PATTERN_DOTS_1234678 : CodePoint = CodePoint::from(10479u32);
    pub const BRAILLE_PATTERN_DOTS_5678 : CodePoint = CodePoint::from(10480u32);
    pub const BRAILLE_PATTERN_DOTS_15678 : CodePoint = CodePoint::from(10481u32);
    pub const BRAILLE_PATTERN_DOTS_25678 : CodePoint = CodePoint::from(10482u32);
    pub const BRAILLE_PATTERN_DOTS_125678 : CodePoint = CodePoint::from(10483u32);
    pub const BRAILLE_PATTERN_DOTS_35678 : CodePoint = CodePoint::from(10484u32);
    pub const BRAILLE_PATTERN_DOTS_135678 : CodePoint = CodePoint::from(10485u32);
    pub const BRAILLE_PATTERN_DOTS_235678 : CodePoint = CodePoint::from(10486u32);
    pub const BRAILLE_PATTERN_DOTS_1235678 : CodePoint = CodePoint::from(10487u32);
    pub const BRAILLE_PATTERN_DOTS_45678 : CodePoint = CodePoint::from(10488u32);
    pub const BRAILLE_PATTERN_DOTS_145678 : CodePoint = CodePoint::from(10489u32);
    pub const BRAILLE_PATTERN_DOTS_245678 : CodePoint = CodePoint::from(10490u32);
    pub const BRAILLE_PATTERN_DOTS_1245678 : CodePoint = CodePoint::from(10491u32);
    pub const BRAILLE_PATTERN_DOTS_345678 : CodePoint = CodePoint::from(10492u32);
    pub const BRAILLE_PATTERN_DOTS_1345678 : CodePoint = CodePoint::from(10493u32);
    pub const BRAILLE_PATTERN_DOTS_2345678 : CodePoint = CodePoint::from(10494u32);
    pub const BRAILLE_PATTERN_DOTS_12345678 : CodePoint = CodePoint::from(10495u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(10496u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(10497u32);
    pub const LEFTWARDS_DOUBLE_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(10498u32);
    pub const RIGHTWARDS_DOUBLE_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(10499u32);
    pub const LEFT_RIGHT_DOUBLE_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(10500u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW_FROM_BAR : CodePoint = CodePoint::from(10501u32);
    pub const LEFTWARDS_DOUBLE_ARROW_FROM_BAR : CodePoint = CodePoint::from(10502u32);
    pub const RIGHTWARDS_DOUBLE_ARROW_FROM_BAR : CodePoint = CodePoint::from(10503u32);
    pub const DOWNWARDS_ARROW_WITH_HORIZONTAL_STROKE : CodePoint = CodePoint::from(10504u32);
    pub const UPWARDS_ARROW_WITH_HORIZONTAL_STROKE : CodePoint = CodePoint::from(10505u32);
    pub const UPWARDS_TRIPLE_ARROW : CodePoint = CodePoint::from(10506u32);
    pub const DOWNWARDS_TRIPLE_ARROW : CodePoint = CodePoint::from(10507u32);
    pub const LEFTWARDS_DOUBLE_DASH_ARROW : CodePoint = CodePoint::from(10508u32);
    pub const RIGHTWARDS_DOUBLE_DASH_ARROW : CodePoint = CodePoint::from(10509u32);
    pub const LEFTWARDS_TRIPLE_DASH_ARROW : CodePoint = CodePoint::from(10510u32);
    pub const RIGHTWARDS_TRIPLE_DASH_ARROW : CodePoint = CodePoint::from(10511u32);
    pub const RIGHTWARDS_TWO_HEADED_TRIPLE_DASH_ARROW : CodePoint = CodePoint::from(10512u32);
    pub const RIGHTWARDS_ARROW_WITH_DOTTED_STEM : CodePoint = CodePoint::from(10513u32);
    pub const UPWARDS_ARROW_TO_BAR : CodePoint = CodePoint::from(10514u32);
    pub const DOWNWARDS_ARROW_TO_BAR : CodePoint = CodePoint::from(10515u32);
    pub const RIGHTWARDS_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(10516u32);
    pub const RIGHTWARDS_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(10517u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL : CodePoint = CodePoint::from(10518u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(10519u32);
    pub const RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(10520u32);
    pub const LEFTWARDS_ARROW_TAIL : CodePoint = CodePoint::from(10521u32);
    pub const RIGHTWARDS_ARROW_TAIL : CodePoint = CodePoint::from(10522u32);
    pub const LEFTWARDS_DOUBLE_ARROW_TAIL : CodePoint = CodePoint::from(10523u32);
    pub const RIGHTWARDS_DOUBLE_ARROW_TAIL : CodePoint = CodePoint::from(10524u32);
    pub const LEFTWARDS_ARROW_TO_BLACK_DIAMOND : CodePoint = CodePoint::from(10525u32);
    pub const RIGHTWARDS_ARROW_TO_BLACK_DIAMOND : CodePoint = CodePoint::from(10526u32);
    pub const LEFTWARDS_ARROW_FROM_BAR_TO_BLACK_DIAMOND : CodePoint = CodePoint::from(10527u32);
    pub const RIGHTWARDS_ARROW_FROM_BAR_TO_BLACK_DIAMOND : CodePoint = CodePoint::from(10528u32);
    pub const NORTH_WEST_AND_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10529u32);
    pub const NORTH_EAST_AND_SOUTH_WEST_ARROW : CodePoint = CodePoint::from(10530u32);
    pub const NORTH_WEST_ARROW_WITH_HOOK : CodePoint = CodePoint::from(10531u32);
    pub const NORTH_EAST_ARROW_WITH_HOOK : CodePoint = CodePoint::from(10532u32);
    pub const SOUTH_EAST_ARROW_WITH_HOOK : CodePoint = CodePoint::from(10533u32);
    pub const SOUTH_WEST_ARROW_WITH_HOOK : CodePoint = CodePoint::from(10534u32);
    pub const NORTH_WEST_ARROW_AND_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10535u32);
    pub const NORTH_EAST_ARROW_AND_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10536u32);
    pub const SOUTH_EAST_ARROW_AND_SOUTH_WEST_ARROW : CodePoint = CodePoint::from(10537u32);
    pub const SOUTH_WEST_ARROW_AND_NORTH_WEST_ARROW : CodePoint = CodePoint::from(10538u32);
    pub const RISING_DIAGONAL_CROSSING_FALLING_DIAGONAL : CodePoint = CodePoint::from(10539u32);
    pub const FALLING_DIAGONAL_CROSSING_RISING_DIAGONAL : CodePoint = CodePoint::from(10540u32);
    pub const SOUTH_EAST_ARROW_CROSSING_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10541u32);
    pub const NORTH_EAST_ARROW_CROSSING_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10542u32);
    pub const FALLING_DIAGONAL_CROSSING_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10543u32);
    pub const RISING_DIAGONAL_CROSSING_SOUTH_EAST_ARROW : CodePoint = CodePoint::from(10544u32);
    pub const NORTH_EAST_ARROW_CROSSING_NORTH_WEST_ARROW : CodePoint = CodePoint::from(10545u32);
    pub const NORTH_WEST_ARROW_CROSSING_NORTH_EAST_ARROW : CodePoint = CodePoint::from(10546u32);
    pub const WAVE_ARROW_POINTING_DIRECTLY_RIGHT : CodePoint = CodePoint::from(10547u32);
    pub const ARROW_POINTING_RIGHTWARDS_THEN_CURVING_UPWARDS : CodePoint = CodePoint::from(10548u32);
    pub const ARROW_POINTING_RIGHTWARDS_THEN_CURVING_DOWNWARDS : CodePoint = CodePoint::from(10549u32);
    pub const ARROW_POINTING_DOWNWARDS_THEN_CURVING_LEFTWARDS : CodePoint = CodePoint::from(10550u32);
    pub const ARROW_POINTING_DOWNWARDS_THEN_CURVING_RIGHTWARDS : CodePoint = CodePoint::from(10551u32);
    pub const RIGHT_SIDE_ARC_CLOCKWISE_ARROW : CodePoint = CodePoint::from(10552u32);
    pub const LEFT_SIDE_ARC_ANTICLOCKWISE_ARROW : CodePoint = CodePoint::from(10553u32);
    pub const TOP_ARC_ANTICLOCKWISE_ARROW : CodePoint = CodePoint::from(10554u32);
    pub const BOTTOM_ARC_ANTICLOCKWISE_ARROW : CodePoint = CodePoint::from(10555u32);
    pub const TOP_ARC_CLOCKWISE_ARROW_WITH_MINUS : CodePoint = CodePoint::from(10556u32);
    pub const TOP_ARC_ANTICLOCKWISE_ARROW_WITH_PLUS : CodePoint = CodePoint::from(10557u32);
    pub const LOWER_RIGHT_SEMICIRCULAR_CLOCKWISE_ARROW : CodePoint = CodePoint::from(10558u32);
    pub const LOWER_LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW : CodePoint = CodePoint::from(10559u32);
    pub const ANTICLOCKWISE_CLOSED_CIRCLE_ARROW : CodePoint = CodePoint::from(10560u32);
    pub const CLOCKWISE_CLOSED_CIRCLE_ARROW : CodePoint = CodePoint::from(10561u32);
    pub const RIGHTWARDS_ARROW_ABOVE_SHORT_LEFTWARDS_ARROW : CodePoint = CodePoint::from(10562u32);
    pub const LEFTWARDS_ARROW_ABOVE_SHORT_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10563u32);
    pub const SHORT_RIGHTWARDS_ARROW_ABOVE_LEFTWARDS_ARROW : CodePoint = CodePoint::from(10564u32);
    pub const RIGHTWARDS_ARROW_WITH_PLUS_BELOW : CodePoint = CodePoint::from(10565u32);
    pub const LEFTWARDS_ARROW_WITH_PLUS_BELOW : CodePoint = CodePoint::from(10566u32);
    pub const RIGHTWARDS_ARROW_THROUGH_X : CodePoint = CodePoint::from(10567u32);
    pub const LEFT_RIGHT_ARROW_THROUGH_SMALL_CIRCLE : CodePoint = CodePoint::from(10568u32);
    pub const UPWARDS_TWO_HEADED_ARROW_FROM_SMALL_CIRCLE : CodePoint = CodePoint::from(10569u32);
    pub const LEFT_BARB_UP_RIGHT_BARB_DOWN_HARPOON : CodePoint = CodePoint::from(10570u32);
    pub const LEFT_BARB_DOWN_RIGHT_BARB_UP_HARPOON : CodePoint = CodePoint::from(10571u32);
    pub const UP_BARB_RIGHT_DOWN_BARB_LEFT_HARPOON : CodePoint = CodePoint::from(10572u32);
    pub const UP_BARB_LEFT_DOWN_BARB_RIGHT_HARPOON : CodePoint = CodePoint::from(10573u32);
    pub const LEFT_BARB_UP_RIGHT_BARB_UP_HARPOON : CodePoint = CodePoint::from(10574u32);
    pub const UP_BARB_RIGHT_DOWN_BARB_RIGHT_HARPOON : CodePoint = CodePoint::from(10575u32);
    pub const LEFT_BARB_DOWN_RIGHT_BARB_DOWN_HARPOON : CodePoint = CodePoint::from(10576u32);
    pub const UP_BARB_LEFT_DOWN_BARB_LEFT_HARPOON : CodePoint = CodePoint::from(10577u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_UP_TO_BAR : CodePoint = CodePoint::from(10578u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_UP_TO_BAR : CodePoint = CodePoint::from(10579u32);
    pub const UPWARDS_HARPOON_WITH_BARB_RIGHT_TO_BAR : CodePoint = CodePoint::from(10580u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_RIGHT_TO_BAR : CodePoint = CodePoint::from(10581u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_DOWN_TO_BAR : CodePoint = CodePoint::from(10582u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_DOWN_TO_BAR : CodePoint = CodePoint::from(10583u32);
    pub const UPWARDS_HARPOON_WITH_BARB_LEFT_TO_BAR : CodePoint = CodePoint::from(10584u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_LEFT_TO_BAR : CodePoint = CodePoint::from(10585u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_UP_FROM_BAR : CodePoint = CodePoint::from(10586u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_UP_FROM_BAR : CodePoint = CodePoint::from(10587u32);
    pub const UPWARDS_HARPOON_WITH_BARB_RIGHT_FROM_BAR : CodePoint = CodePoint::from(10588u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_RIGHT_FROM_BAR : CodePoint = CodePoint::from(10589u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_DOWN_FROM_BAR : CodePoint = CodePoint::from(10590u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_DOWN_FROM_BAR : CodePoint = CodePoint::from(10591u32);
    pub const UPWARDS_HARPOON_WITH_BARB_LEFT_FROM_BAR : CodePoint = CodePoint::from(10592u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_LEFT_FROM_BAR : CodePoint = CodePoint::from(10593u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_DOWN : CodePoint = CodePoint::from(10594u32);
    pub const UPWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_UPWARDS_HARPOON_WITH_BARB_RIGHT : CodePoint = CodePoint::from(10595u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_DOWN : CodePoint = CodePoint::from(10596u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_DOWNWARDS_HARPOON_WITH_BARB_RIGHT : CodePoint = CodePoint::from(10597u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_UP : CodePoint = CodePoint::from(10598u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_DOWN_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_DOWN : CodePoint = CodePoint::from(10599u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_UP : CodePoint = CodePoint::from(10600u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_DOWN_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_DOWN : CodePoint = CodePoint::from(10601u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LONG_DASH : CodePoint = CodePoint::from(10602u32);
    pub const LEFTWARDS_HARPOON_WITH_BARB_DOWN_BELOW_LONG_DASH : CodePoint = CodePoint::from(10603u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LONG_DASH : CodePoint = CodePoint::from(10604u32);
    pub const RIGHTWARDS_HARPOON_WITH_BARB_DOWN_BELOW_LONG_DASH : CodePoint = CodePoint::from(10605u32);
    pub const UPWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_DOWNWARDS_HARPOON_WITH_BARB_RIGHT : CodePoint = CodePoint::from(10606u32);
    pub const DOWNWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_UPWARDS_HARPOON_WITH_BARB_RIGHT : CodePoint = CodePoint::from(10607u32);
    pub const RIGHT_DOUBLE_ARROW_WITH_ROUNDED_HEAD : CodePoint = CodePoint::from(10608u32);
    pub const EQUALS_SIGN_ABOVE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10609u32);
    pub const TILDE_OPERATOR_ABOVE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10610u32);
    pub const LEFTWARDS_ARROW_ABOVE_TILDE_OPERATOR : CodePoint = CodePoint::from(10611u32);
    pub const RIGHTWARDS_ARROW_ABOVE_TILDE_OPERATOR : CodePoint = CodePoint::from(10612u32);
    pub const RIGHTWARDS_ARROW_ABOVE_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10613u32);
    pub const LESS_THAN_ABOVE_LEFTWARDS_ARROW : CodePoint = CodePoint::from(10614u32);
    pub const LEFTWARDS_ARROW_THROUGH_LESS_THAN : CodePoint = CodePoint::from(10615u32);
    pub const GREATER_THAN_ABOVE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10616u32);
    pub const SUBSET_ABOVE_RIGHTWARDS_ARROW : CodePoint = CodePoint::from(10617u32);
    pub const LEFTWARDS_ARROW_THROUGH_SUBSET : CodePoint = CodePoint::from(10618u32);
    pub const SUPERSET_ABOVE_LEFTWARDS_ARROW : CodePoint = CodePoint::from(10619u32);
    pub const LEFT_FISH_TAIL : CodePoint = CodePoint::from(10620u32);
    pub const RIGHT_FISH_TAIL : CodePoint = CodePoint::from(10621u32);
    pub const UP_FISH_TAIL : CodePoint = CodePoint::from(10622u32);
    pub const DOWN_FISH_TAIL : CodePoint = CodePoint::from(10623u32);
    pub const TRIPLE_VERTICAL_BAR_DELIMITER : CodePoint = CodePoint::from(10624u32);
    pub const Z_NOTATION_SPOT : CodePoint = CodePoint::from(10625u32);
    pub const Z_NOTATION_TYPE_COLON : CodePoint = CodePoint::from(10626u32);
    pub const LEFT_WHITE_CURLY_BRACKET : CodePoint = CodePoint::from(10627u32);
    pub const RIGHT_WHITE_CURLY_BRACKET : CodePoint = CodePoint::from(10628u32);
    pub const LEFT_WHITE_PARENTHESIS : CodePoint = CodePoint::from(10629u32);
    pub const RIGHT_WHITE_PARENTHESIS : CodePoint = CodePoint::from(10630u32);
    pub const Z_NOTATION_LEFT_IMAGE_BRACKET : CodePoint = CodePoint::from(10631u32);
    pub const Z_NOTATION_RIGHT_IMAGE_BRACKET : CodePoint = CodePoint::from(10632u32);
    pub const Z_NOTATION_LEFT_BINDING_BRACKET : CodePoint = CodePoint::from(10633u32);
    pub const Z_NOTATION_RIGHT_BINDING_BRACKET : CodePoint = CodePoint::from(10634u32);
    pub const LEFT_SQUARE_BRACKET_WITH_UNDERBAR : CodePoint = CodePoint::from(10635u32);
    pub const RIGHT_SQUARE_BRACKET_WITH_UNDERBAR : CodePoint = CodePoint::from(10636u32);
    pub const LEFT_SQUARE_BRACKET_WITH_TICK_IN_TOP_CORNER : CodePoint = CodePoint::from(10637u32);
    pub const RIGHT_SQUARE_BRACKET_WITH_TICK_IN_BOTTOM_CORNER : CodePoint = CodePoint::from(10638u32);
    pub const LEFT_SQUARE_BRACKET_WITH_TICK_IN_BOTTOM_CORNER : CodePoint = CodePoint::from(10639u32);
    pub const RIGHT_SQUARE_BRACKET_WITH_TICK_IN_TOP_CORNER : CodePoint = CodePoint::from(10640u32);
    pub const LEFT_ANGLE_BRACKET_WITH_DOT : CodePoint = CodePoint::from(10641u32);
    pub const RIGHT_ANGLE_BRACKET_WITH_DOT : CodePoint = CodePoint::from(10642u32);
    pub const LEFT_ARC_LESS_THAN_BRACKET : CodePoint = CodePoint::from(10643u32);
    pub const RIGHT_ARC_GREATER_THAN_BRACKET : CodePoint = CodePoint::from(10644u32);
    pub const DOUBLE_LEFT_ARC_GREATER_THAN_BRACKET : CodePoint = CodePoint::from(10645u32);
    pub const DOUBLE_RIGHT_ARC_LESS_THAN_BRACKET : CodePoint = CodePoint::from(10646u32);
    pub const LEFT_BLACK_TORTOISE_SHELL_BRACKET : CodePoint = CodePoint::from(10647u32);
    pub const RIGHT_BLACK_TORTOISE_SHELL_BRACKET : CodePoint = CodePoint::from(10648u32);
    pub const DOTTED_FENCE : CodePoint = CodePoint::from(10649u32);
    pub const VERTICAL_ZIGZAG_LINE : CodePoint = CodePoint::from(10650u32);
    pub const MEASURED_ANGLE_OPENING_LEFT : CodePoint = CodePoint::from(10651u32);
    pub const RIGHT_ANGLE_VARIANT_WITH_SQUARE : CodePoint = CodePoint::from(10652u32);
    pub const MEASURED_RIGHT_ANGLE_WITH_DOT : CodePoint = CodePoint::from(10653u32);
    pub const ANGLE_WITH_S_INSIDE : CodePoint = CodePoint::from(10654u32);
    pub const ACUTE_ANGLE : CodePoint = CodePoint::from(10655u32);
    pub const SPHERICAL_ANGLE_OPENING_LEFT : CodePoint = CodePoint::from(10656u32);
    pub const SPHERICAL_ANGLE_OPENING_UP : CodePoint = CodePoint::from(10657u32);
    pub const TURNED_ANGLE : CodePoint = CodePoint::from(10658u32);
    pub const REVERSED_ANGLE : CodePoint = CodePoint::from(10659u32);
    pub const ANGLE_WITH_UNDERBAR : CodePoint = CodePoint::from(10660u32);
    pub const REVERSED_ANGLE_WITH_UNDERBAR : CodePoint = CodePoint::from(10661u32);
    pub const OBLIQUE_ANGLE_OPENING_UP : CodePoint = CodePoint::from(10662u32);
    pub const OBLIQUE_ANGLE_OPENING_DOWN : CodePoint = CodePoint::from(10663u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_UP_AND_RIGHT : CodePoint = CodePoint::from(10664u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_UP_AND_LEFT : CodePoint = CodePoint::from(10665u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_DOWN_AND_RIGHT : CodePoint = CodePoint::from(10666u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_DOWN_AND_LEFT : CodePoint = CodePoint::from(10667u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_RIGHT_AND_UP : CodePoint = CodePoint::from(10668u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_LEFT_AND_UP : CodePoint = CodePoint::from(10669u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_RIGHT_AND_DOWN : CodePoint = CodePoint::from(10670u32);
    pub const MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_LEFT_AND_DOWN : CodePoint = CodePoint::from(10671u32);
    pub const REVERSED_EMPTY_SET : CodePoint = CodePoint::from(10672u32);
    pub const EMPTY_SET_WITH_OVERBAR : CodePoint = CodePoint::from(10673u32);
    pub const EMPTY_SET_WITH_SMALL_CIRCLE_ABOVE : CodePoint = CodePoint::from(10674u32);
    pub const EMPTY_SET_WITH_RIGHT_ARROW_ABOVE : CodePoint = CodePoint::from(10675u32);
    pub const EMPTY_SET_WITH_LEFT_ARROW_ABOVE : CodePoint = CodePoint::from(10676u32);
    pub const CIRCLE_WITH_HORIZONTAL_BAR : CodePoint = CodePoint::from(10677u32);
    pub const CIRCLED_VERTICAL_BAR : CodePoint = CodePoint::from(10678u32);
    pub const CIRCLED_PARALLEL : CodePoint = CodePoint::from(10679u32);
    pub const CIRCLED_REVERSE_SOLIDUS : CodePoint = CodePoint::from(10680u32);
    pub const CIRCLED_PERPENDICULAR : CodePoint = CodePoint::from(10681u32);
    pub const CIRCLE_DIVIDED_BY_HORIZONTAL_BAR_AND_TOP_HALF_DIVIDED_BY_VERTICAL_BAR : CodePoint = CodePoint::from(10682u32);
    pub const CIRCLE_WITH_SUPERIMPOSED_X : CodePoint = CodePoint::from(10683u32);
    pub const CIRCLED_ANTICLOCKWISE_ROTATED_DIVISION_SIGN : CodePoint = CodePoint::from(10684u32);
    pub const UP_ARROW_THROUGH_CIRCLE : CodePoint = CodePoint::from(10685u32);
    pub const CIRCLED_WHITE_BULLET : CodePoint = CodePoint::from(10686u32);
    pub const CIRCLED_BULLET : CodePoint = CodePoint::from(10687u32);
    pub const CIRCLED_LESS_THAN : CodePoint = CodePoint::from(10688u32);
    pub const CIRCLED_GREATER_THAN : CodePoint = CodePoint::from(10689u32);
    pub const CIRCLE_WITH_SMALL_CIRCLE_TO_THE_RIGHT : CodePoint = CodePoint::from(10690u32);
    pub const CIRCLE_WITH_TWO_HORIZONTAL_STROKES_TO_THE_RIGHT : CodePoint = CodePoint::from(10691u32);
    pub const SQUARED_RISING_DIAGONAL_SLASH : CodePoint = CodePoint::from(10692u32);
    pub const SQUARED_FALLING_DIAGONAL_SLASH : CodePoint = CodePoint::from(10693u32);
    pub const SQUARED_ASTERISK : CodePoint = CodePoint::from(10694u32);
    pub const SQUARED_SMALL_CIRCLE : CodePoint = CodePoint::from(10695u32);
    pub const SQUARED_SQUARE : CodePoint = CodePoint::from(10696u32);
    pub const TWO_JOINED_SQUARES : CodePoint = CodePoint::from(10697u32);
    pub const TRIANGLE_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10698u32);
    pub const TRIANGLE_WITH_UNDERBAR : CodePoint = CodePoint::from(10699u32);
    pub const S_IN_TRIANGLE : CodePoint = CodePoint::from(10700u32);
    pub const TRIANGLE_WITH_SERIFS_AT_BOTTOM : CodePoint = CodePoint::from(10701u32);
    pub const RIGHT_TRIANGLE_ABOVE_LEFT_TRIANGLE : CodePoint = CodePoint::from(10702u32);
    pub const LEFT_TRIANGLE_BESIDE_VERTICAL_BAR : CodePoint = CodePoint::from(10703u32);
    pub const VERTICAL_BAR_BESIDE_RIGHT_TRIANGLE : CodePoint = CodePoint::from(10704u32);
    pub const BOWTIE_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(10705u32);
    pub const BOWTIE_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(10706u32);
    pub const BLACK_BOWTIE : CodePoint = CodePoint::from(10707u32);
    pub const TIMES_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(10708u32);
    pub const TIMES_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(10709u32);
    pub const WHITE_HOURGLASS : CodePoint = CodePoint::from(10710u32);
    pub const BLACK_HOURGLASS : CodePoint = CodePoint::from(10711u32);
    pub const LEFT_WIGGLY_FENCE : CodePoint = CodePoint::from(10712u32);
    pub const RIGHT_WIGGLY_FENCE : CodePoint = CodePoint::from(10713u32);
    pub const LEFT_DOUBLE_WIGGLY_FENCE : CodePoint = CodePoint::from(10714u32);
    pub const RIGHT_DOUBLE_WIGGLY_FENCE : CodePoint = CodePoint::from(10715u32);
    pub const INCOMPLETE_INFINITY : CodePoint = CodePoint::from(10716u32);
    pub const TIE_OVER_INFINITY : CodePoint = CodePoint::from(10717u32);
    pub const INFINITY_NEGATED_WITH_VERTICAL_BAR : CodePoint = CodePoint::from(10718u32);
    pub const DOUBLE_ENDED_MULTIMAP : CodePoint = CodePoint::from(10719u32);
    pub const SQUARE_WITH_CONTOURED_OUTLINE : CodePoint = CodePoint::from(10720u32);
    pub const INCREASES_AS : CodePoint = CodePoint::from(10721u32);
    pub const SHUFFLE_PRODUCT : CodePoint = CodePoint::from(10722u32);
    pub const EQUALS_SIGN_AND_SLANTED_PARALLEL : CodePoint = CodePoint::from(10723u32);
    pub const EQUALS_SIGN_AND_SLANTED_PARALLEL_WITH_TILDE_ABOVE : CodePoint = CodePoint::from(10724u32);
    pub const IDENTICAL_TO_AND_SLANTED_PARALLEL : CodePoint = CodePoint::from(10725u32);
    pub const GLEICH_STARK : CodePoint = CodePoint::from(10726u32);
    pub const THERMODYNAMIC : CodePoint = CodePoint::from(10727u32);
    pub const DOWN_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(10728u32);
    pub const DOWN_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(10729u32);
    pub const BLACK_DIAMOND_WITH_DOWN_ARROW : CodePoint = CodePoint::from(10730u32);
    pub const BLACK_LOZENGE : CodePoint = CodePoint::from(10731u32);
    pub const WHITE_CIRCLE_WITH_DOWN_ARROW : CodePoint = CodePoint::from(10732u32);
    pub const BLACK_CIRCLE_WITH_DOWN_ARROW : CodePoint = CodePoint::from(10733u32);
    pub const ERROR_BARRED_WHITE_SQUARE : CodePoint = CodePoint::from(10734u32);
    pub const ERROR_BARRED_BLACK_SQUARE : CodePoint = CodePoint::from(10735u32);
    pub const ERROR_BARRED_WHITE_DIAMOND : CodePoint = CodePoint::from(10736u32);
    pub const ERROR_BARRED_BLACK_DIAMOND : CodePoint = CodePoint::from(10737u32);
    pub const ERROR_BARRED_WHITE_CIRCLE : CodePoint = CodePoint::from(10738u32);
    pub const ERROR_BARRED_BLACK_CIRCLE : CodePoint = CodePoint::from(10739u32);
    pub const RULE_DELAYED : CodePoint = CodePoint::from(10740u32);
    pub const REVERSE_SOLIDUS_OPERATOR : CodePoint = CodePoint::from(10741u32);
    pub const SOLIDUS_WITH_OVERBAR : CodePoint = CodePoint::from(10742u32);
    pub const REVERSE_SOLIDUS_WITH_HORIZONTAL_STROKE : CodePoint = CodePoint::from(10743u32);
    pub const BIG_SOLIDUS : CodePoint = CodePoint::from(10744u32);
    pub const BIG_REVERSE_SOLIDUS : CodePoint = CodePoint::from(10745u32);
    pub const DOUBLE_PLUS : CodePoint = CodePoint::from(10746u32);
    pub const TRIPLE_PLUS : CodePoint = CodePoint::from(10747u32);
    pub const LEFT_POINTING_CURVED_ANGLE_BRACKET : CodePoint = CodePoint::from(10748u32);
    pub const RIGHT_POINTING_CURVED_ANGLE_BRACKET : CodePoint = CodePoint::from(10749u32);
    pub const TINY : CodePoint = CodePoint::from(10750u32);
    pub const MINY : CodePoint = CodePoint::from(10751u32);
    pub const N_ARY_CIRCLED_DOT_OPERATOR : CodePoint = CodePoint::from(10752u32);
    pub const N_ARY_CIRCLED_PLUS_OPERATOR : CodePoint = CodePoint::from(10753u32);
    pub const N_ARY_CIRCLED_TIMES_OPERATOR : CodePoint = CodePoint::from(10754u32);
    pub const N_ARY_UNION_OPERATOR_WITH_DOT : CodePoint = CodePoint::from(10755u32);
    pub const N_ARY_UNION_OPERATOR_WITH_PLUS : CodePoint = CodePoint::from(10756u32);
    pub const N_ARY_SQUARE_INTERSECTION_OPERATOR : CodePoint = CodePoint::from(10757u32);
    pub const N_ARY_SQUARE_UNION_OPERATOR : CodePoint = CodePoint::from(10758u32);
    pub const TWO_LOGICAL_AND_OPERATOR : CodePoint = CodePoint::from(10759u32);
    pub const TWO_LOGICAL_OR_OPERATOR : CodePoint = CodePoint::from(10760u32);
    pub const N_ARY_TIMES_OPERATOR : CodePoint = CodePoint::from(10761u32);
    pub const MODULO_TWO_SUM : CodePoint = CodePoint::from(10762u32);
    pub const SUMMATION_WITH_INTEGRAL : CodePoint = CodePoint::from(10763u32);
    pub const QUADRUPLE_INTEGRAL_OPERATOR : CodePoint = CodePoint::from(10764u32);
    pub const FINITE_PART_INTEGRAL : CodePoint = CodePoint::from(10765u32);
    pub const INTEGRAL_WITH_DOUBLE_STROKE : CodePoint = CodePoint::from(10766u32);
    pub const INTEGRAL_AVERAGE_WITH_SLASH : CodePoint = CodePoint::from(10767u32);
    pub const CIRCULATION_FUNCTION : CodePoint = CodePoint::from(10768u32);
    pub const ANTICLOCKWISE_INTEGRATION : CodePoint = CodePoint::from(10769u32);
    pub const LINE_INTEGRATION_WITH_RECTANGULAR_PATH_AROUND_POLE : CodePoint = CodePoint::from(10770u32);
    pub const LINE_INTEGRATION_WITH_SEMICIRCULAR_PATH_AROUND_POLE : CodePoint = CodePoint::from(10771u32);
    pub const LINE_INTEGRATION_NOT_INCLUDING_THE_POLE : CodePoint = CodePoint::from(10772u32);
    pub const INTEGRAL_AROUND_A_POINT_OPERATOR : CodePoint = CodePoint::from(10773u32);
    pub const QUATERNION_INTEGRAL_OPERATOR : CodePoint = CodePoint::from(10774u32);
    pub const INTEGRAL_WITH_LEFTWARDS_ARROW_WITH_HOOK : CodePoint = CodePoint::from(10775u32);
    pub const INTEGRAL_WITH_TIMES_SIGN : CodePoint = CodePoint::from(10776u32);
    pub const INTEGRAL_WITH_INTERSECTION : CodePoint = CodePoint::from(10777u32);
    pub const INTEGRAL_WITH_UNION : CodePoint = CodePoint::from(10778u32);
    pub const INTEGRAL_WITH_OVERBAR : CodePoint = CodePoint::from(10779u32);
    pub const INTEGRAL_WITH_UNDERBAR : CodePoint = CodePoint::from(10780u32);
    pub const JOIN : CodePoint = CodePoint::from(10781u32);
    pub const LARGE_LEFT_TRIANGLE_OPERATOR : CodePoint = CodePoint::from(10782u32);
    pub const Z_NOTATION_SCHEMA_COMPOSITION : CodePoint = CodePoint::from(10783u32);
    pub const Z_NOTATION_SCHEMA_PIPING : CodePoint = CodePoint::from(10784u32);
    pub const Z_NOTATION_SCHEMA_PROJECTION : CodePoint = CodePoint::from(10785u32);
    pub const PLUS_SIGN_WITH_SMALL_CIRCLE_ABOVE : CodePoint = CodePoint::from(10786u32);
    pub const PLUS_SIGN_WITH_CIRCUMFLEX_ACCENT_ABOVE : CodePoint = CodePoint::from(10787u32);
    pub const PLUS_SIGN_WITH_TILDE_ABOVE : CodePoint = CodePoint::from(10788u32);
    pub const PLUS_SIGN_WITH_DOT_BELOW : CodePoint = CodePoint::from(10789u32);
    pub const PLUS_SIGN_WITH_TILDE_BELOW : CodePoint = CodePoint::from(10790u32);
    pub const PLUS_SIGN_WITH_SUBSCRIPT_TWO : CodePoint = CodePoint::from(10791u32);
    pub const PLUS_SIGN_WITH_BLACK_TRIANGLE : CodePoint = CodePoint::from(10792u32);
    pub const MINUS_SIGN_WITH_COMMA_ABOVE : CodePoint = CodePoint::from(10793u32);
    pub const MINUS_SIGN_WITH_DOT_BELOW : CodePoint = CodePoint::from(10794u32);
    pub const MINUS_SIGN_WITH_FALLING_DOTS : CodePoint = CodePoint::from(10795u32);
    pub const MINUS_SIGN_WITH_RISING_DOTS : CodePoint = CodePoint::from(10796u32);
    pub const PLUS_SIGN_IN_LEFT_HALF_CIRCLE : CodePoint = CodePoint::from(10797u32);
    pub const PLUS_SIGN_IN_RIGHT_HALF_CIRCLE : CodePoint = CodePoint::from(10798u32);
    pub const VECTOR_OR_CROSS_PRODUCT : CodePoint = CodePoint::from(10799u32);
    pub const MULTIPLICATION_SIGN_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10800u32);
    pub const MULTIPLICATION_SIGN_WITH_UNDERBAR : CodePoint = CodePoint::from(10801u32);
    pub const SEMIDIRECT_PRODUCT_WITH_BOTTOM_CLOSED : CodePoint = CodePoint::from(10802u32);
    pub const SMASH_PRODUCT : CodePoint = CodePoint::from(10803u32);
    pub const MULTIPLICATION_SIGN_IN_LEFT_HALF_CIRCLE : CodePoint = CodePoint::from(10804u32);
    pub const MULTIPLICATION_SIGN_IN_RIGHT_HALF_CIRCLE : CodePoint = CodePoint::from(10805u32);
    pub const CIRCLED_MULTIPLICATION_SIGN_WITH_CIRCUMFLEX_ACCENT : CodePoint = CodePoint::from(10806u32);
    pub const MULTIPLICATION_SIGN_IN_DOUBLE_CIRCLE : CodePoint = CodePoint::from(10807u32);
    pub const CIRCLED_DIVISION_SIGN : CodePoint = CodePoint::from(10808u32);
    pub const PLUS_SIGN_IN_TRIANGLE : CodePoint = CodePoint::from(10809u32);
    pub const MINUS_SIGN_IN_TRIANGLE : CodePoint = CodePoint::from(10810u32);
    pub const MULTIPLICATION_SIGN_IN_TRIANGLE : CodePoint = CodePoint::from(10811u32);
    pub const INTERIOR_PRODUCT : CodePoint = CodePoint::from(10812u32);
    pub const RIGHTHAND_INTERIOR_PRODUCT : CodePoint = CodePoint::from(10813u32);
    pub const Z_NOTATION_RELATIONAL_COMPOSITION : CodePoint = CodePoint::from(10814u32);
    pub const AMALGAMATION_OR_COPRODUCT : CodePoint = CodePoint::from(10815u32);
    pub const INTERSECTION_WITH_DOT : CodePoint = CodePoint::from(10816u32);
    pub const UNION_WITH_MINUS_SIGN : CodePoint = CodePoint::from(10817u32);
    pub const UNION_WITH_OVERBAR : CodePoint = CodePoint::from(10818u32);
    pub const INTERSECTION_WITH_OVERBAR : CodePoint = CodePoint::from(10819u32);
    pub const INTERSECTION_WITH_LOGICAL_AND : CodePoint = CodePoint::from(10820u32);
    pub const UNION_WITH_LOGICAL_OR : CodePoint = CodePoint::from(10821u32);
    pub const UNION_ABOVE_INTERSECTION : CodePoint = CodePoint::from(10822u32);
    pub const INTERSECTION_ABOVE_UNION : CodePoint = CodePoint::from(10823u32);
    pub const UNION_ABOVE_BAR_ABOVE_INTERSECTION : CodePoint = CodePoint::from(10824u32);
    pub const INTERSECTION_ABOVE_BAR_ABOVE_UNION : CodePoint = CodePoint::from(10825u32);
    pub const UNION_BESIDE_AND_JOINED_WITH_UNION : CodePoint = CodePoint::from(10826u32);
    pub const INTERSECTION_BESIDE_AND_JOINED_WITH_INTERSECTION : CodePoint = CodePoint::from(10827u32);
    pub const CLOSED_UNION_WITH_SERIFS : CodePoint = CodePoint::from(10828u32);
    pub const CLOSED_INTERSECTION_WITH_SERIFS : CodePoint = CodePoint::from(10829u32);
    pub const DOUBLE_SQUARE_INTERSECTION : CodePoint = CodePoint::from(10830u32);
    pub const DOUBLE_SQUARE_UNION : CodePoint = CodePoint::from(10831u32);
    pub const CLOSED_UNION_WITH_SERIFS_AND_SMASH_PRODUCT : CodePoint = CodePoint::from(10832u32);
    pub const LOGICAL_AND_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10833u32);
    pub const LOGICAL_OR_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10834u32);
    pub const DOUBLE_LOGICAL_AND : CodePoint = CodePoint::from(10835u32);
    pub const DOUBLE_LOGICAL_OR : CodePoint = CodePoint::from(10836u32);
    pub const TWO_INTERSECTING_LOGICAL_AND : CodePoint = CodePoint::from(10837u32);
    pub const TWO_INTERSECTING_LOGICAL_OR : CodePoint = CodePoint::from(10838u32);
    pub const SLOPING_LARGE_OR : CodePoint = CodePoint::from(10839u32);
    pub const SLOPING_LARGE_AND : CodePoint = CodePoint::from(10840u32);
    pub const LOGICAL_OR_OVERLAPPING_LOGICAL_AND : CodePoint = CodePoint::from(10841u32);
    pub const LOGICAL_AND_WITH_MIDDLE_STEM : CodePoint = CodePoint::from(10842u32);
    pub const LOGICAL_OR_WITH_MIDDLE_STEM : CodePoint = CodePoint::from(10843u32);
    pub const LOGICAL_AND_WITH_HORIZONTAL_DASH : CodePoint = CodePoint::from(10844u32);
    pub const LOGICAL_OR_WITH_HORIZONTAL_DASH : CodePoint = CodePoint::from(10845u32);
    pub const LOGICAL_AND_WITH_DOUBLE_OVERBAR : CodePoint = CodePoint::from(10846u32);
    pub const LOGICAL_AND_WITH_UNDERBAR : CodePoint = CodePoint::from(10847u32);
    pub const LOGICAL_AND_WITH_DOUBLE_UNDERBAR : CodePoint = CodePoint::from(10848u32);
    pub const SMALL_VEE_WITH_UNDERBAR : CodePoint = CodePoint::from(10849u32);
    pub const LOGICAL_OR_WITH_DOUBLE_OVERBAR : CodePoint = CodePoint::from(10850u32);
    pub const LOGICAL_OR_WITH_DOUBLE_UNDERBAR : CodePoint = CodePoint::from(10851u32);
    pub const Z_NOTATION_DOMAIN_ANTIRESTRICTION : CodePoint = CodePoint::from(10852u32);
    pub const Z_NOTATION_RANGE_ANTIRESTRICTION : CodePoint = CodePoint::from(10853u32);
    pub const EQUALS_SIGN_WITH_DOT_BELOW : CodePoint = CodePoint::from(10854u32);
    pub const IDENTICAL_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10855u32);
    pub const TRIPLE_HORIZONTAL_BAR_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(10856u32);
    pub const TRIPLE_HORIZONTAL_BAR_WITH_TRIPLE_VERTICAL_STROKE : CodePoint = CodePoint::from(10857u32);
    pub const TILDE_OPERATOR_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10858u32);
    pub const TILDE_OPERATOR_WITH_RISING_DOTS : CodePoint = CodePoint::from(10859u32);
    pub const SIMILAR_MINUS_SIMILAR : CodePoint = CodePoint::from(10860u32);
    pub const CONGRUENT_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10861u32);
    pub const EQUALS_WITH_ASTERISK : CodePoint = CodePoint::from(10862u32);
    pub const ALMOST_EQUAL_TO_WITH_CIRCUMFLEX_ACCENT : CodePoint = CodePoint::from(10863u32);
    pub const APPROXIMATELY_EQUAL_OR_EQUAL_TO : CodePoint = CodePoint::from(10864u32);
    pub const EQUALS_SIGN_ABOVE_PLUS_SIGN : CodePoint = CodePoint::from(10865u32);
    pub const PLUS_SIGN_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10866u32);
    pub const EQUALS_SIGN_ABOVE_TILDE_OPERATOR : CodePoint = CodePoint::from(10867u32);
    pub const DOUBLE_COLON_EQUAL : CodePoint = CodePoint::from(10868u32);
    pub const TWO_CONSECUTIVE_EQUALS_SIGNS : CodePoint = CodePoint::from(10869u32);
    pub const THREE_CONSECUTIVE_EQUALS_SIGNS : CodePoint = CodePoint::from(10870u32);
    pub const EQUALS_SIGN_WITH_TWO_DOTS_ABOVE_AND_TWO_DOTS_BELOW : CodePoint = CodePoint::from(10871u32);
    pub const EQUIVALENT_WITH_FOUR_DOTS_ABOVE : CodePoint = CodePoint::from(10872u32);
    pub const LESS_THAN_WITH_CIRCLE_INSIDE : CodePoint = CodePoint::from(10873u32);
    pub const GREATER_THAN_WITH_CIRCLE_INSIDE : CodePoint = CodePoint::from(10874u32);
    pub const LESS_THAN_WITH_QUESTION_MARK_ABOVE : CodePoint = CodePoint::from(10875u32);
    pub const GREATER_THAN_WITH_QUESTION_MARK_ABOVE : CodePoint = CodePoint::from(10876u32);
    pub const LESS_THAN_OR_SLANTED_EQUAL_TO : CodePoint = CodePoint::from(10877u32);
    pub const GREATER_THAN_OR_SLANTED_EQUAL_TO : CodePoint = CodePoint::from(10878u32);
    pub const LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_INSIDE : CodePoint = CodePoint::from(10879u32);
    pub const GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_INSIDE : CodePoint = CodePoint::from(10880u32);
    pub const LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10881u32);
    pub const GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10882u32);
    pub const LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE_RIGHT : CodePoint = CodePoint::from(10883u32);
    pub const GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE_LEFT : CodePoint = CodePoint::from(10884u32);
    pub const LESS_THAN_OR_APPROXIMATE : CodePoint = CodePoint::from(10885u32);
    pub const GREATER_THAN_OR_APPROXIMATE : CodePoint = CodePoint::from(10886u32);
    pub const LESS_THAN_AND_SINGLE_LINE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10887u32);
    pub const GREATER_THAN_AND_SINGLE_LINE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10888u32);
    pub const LESS_THAN_AND_NOT_APPROXIMATE : CodePoint = CodePoint::from(10889u32);
    pub const GREATER_THAN_AND_NOT_APPROXIMATE : CodePoint = CodePoint::from(10890u32);
    pub const LESS_THAN_ABOVE_DOUBLE_LINE_EQUAL_ABOVE_GREATER_THAN : CodePoint = CodePoint::from(10891u32);
    pub const GREATER_THAN_ABOVE_DOUBLE_LINE_EQUAL_ABOVE_LESS_THAN : CodePoint = CodePoint::from(10892u32);
    pub const LESS_THAN_ABOVE_SIMILAR_OR_EQUAL : CodePoint = CodePoint::from(10893u32);
    pub const GREATER_THAN_ABOVE_SIMILAR_OR_EQUAL : CodePoint = CodePoint::from(10894u32);
    pub const LESS_THAN_ABOVE_SIMILAR_ABOVE_GREATER_THAN : CodePoint = CodePoint::from(10895u32);
    pub const GREATER_THAN_ABOVE_SIMILAR_ABOVE_LESS_THAN : CodePoint = CodePoint::from(10896u32);
    pub const LESS_THAN_ABOVE_GREATER_THAN_ABOVE_DOUBLE_LINE_EQUAL : CodePoint = CodePoint::from(10897u32);
    pub const GREATER_THAN_ABOVE_LESS_THAN_ABOVE_DOUBLE_LINE_EQUAL : CodePoint = CodePoint::from(10898u32);
    pub const LESS_THAN_ABOVE_SLANTED_EQUAL_ABOVE_GREATER_THAN_ABOVE_SLANTED_EQUAL : CodePoint = CodePoint::from(10899u32);
    pub const GREATER_THAN_ABOVE_SLANTED_EQUAL_ABOVE_LESS_THAN_ABOVE_SLANTED_EQUAL : CodePoint = CodePoint::from(10900u32);
    pub const SLANTED_EQUAL_TO_OR_LESS_THAN : CodePoint = CodePoint::from(10901u32);
    pub const SLANTED_EQUAL_TO_OR_GREATER_THAN : CodePoint = CodePoint::from(10902u32);
    pub const SLANTED_EQUAL_TO_OR_LESS_THAN_WITH_DOT_INSIDE : CodePoint = CodePoint::from(10903u32);
    pub const SLANTED_EQUAL_TO_OR_GREATER_THAN_WITH_DOT_INSIDE : CodePoint = CodePoint::from(10904u32);
    pub const DOUBLE_LINE_EQUAL_TO_OR_LESS_THAN : CodePoint = CodePoint::from(10905u32);
    pub const DOUBLE_LINE_EQUAL_TO_OR_GREATER_THAN : CodePoint = CodePoint::from(10906u32);
    pub const DOUBLE_LINE_SLANTED_EQUAL_TO_OR_LESS_THAN : CodePoint = CodePoint::from(10907u32);
    pub const DOUBLE_LINE_SLANTED_EQUAL_TO_OR_GREATER_THAN : CodePoint = CodePoint::from(10908u32);
    pub const SIMILAR_OR_LESS_THAN : CodePoint = CodePoint::from(10909u32);
    pub const SIMILAR_OR_GREATER_THAN : CodePoint = CodePoint::from(10910u32);
    pub const SIMILAR_ABOVE_LESS_THAN_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10911u32);
    pub const SIMILAR_ABOVE_GREATER_THAN_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10912u32);
    pub const DOUBLE_NESTED_LESS_THAN : CodePoint = CodePoint::from(10913u32);
    pub const DOUBLE_NESTED_GREATER_THAN : CodePoint = CodePoint::from(10914u32);
    pub const DOUBLE_NESTED_LESS_THAN_WITH_UNDERBAR : CodePoint = CodePoint::from(10915u32);
    pub const GREATER_THAN_OVERLAPPING_LESS_THAN : CodePoint = CodePoint::from(10916u32);
    pub const GREATER_THAN_BESIDE_LESS_THAN : CodePoint = CodePoint::from(10917u32);
    pub const LESS_THAN_CLOSED_BY_CURVE : CodePoint = CodePoint::from(10918u32);
    pub const GREATER_THAN_CLOSED_BY_CURVE : CodePoint = CodePoint::from(10919u32);
    pub const LESS_THAN_CLOSED_BY_CURVE_ABOVE_SLANTED_EQUAL : CodePoint = CodePoint::from(10920u32);
    pub const GREATER_THAN_CLOSED_BY_CURVE_ABOVE_SLANTED_EQUAL : CodePoint = CodePoint::from(10921u32);
    pub const SMALLER_THAN : CodePoint = CodePoint::from(10922u32);
    pub const LARGER_THAN : CodePoint = CodePoint::from(10923u32);
    pub const SMALLER_THAN_OR_EQUAL_TO : CodePoint = CodePoint::from(10924u32);
    pub const LARGER_THAN_OR_EQUAL_TO : CodePoint = CodePoint::from(10925u32);
    pub const EQUALS_SIGN_WITH_BUMPY_ABOVE : CodePoint = CodePoint::from(10926u32);
    pub const PRECEDES_ABOVE_SINGLE_LINE_EQUALS_SIGN : CodePoint = CodePoint::from(10927u32);
    pub const SUCCEEDS_ABOVE_SINGLE_LINE_EQUALS_SIGN : CodePoint = CodePoint::from(10928u32);
    pub const PRECEDES_ABOVE_SINGLE_LINE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10929u32);
    pub const SUCCEEDS_ABOVE_SINGLE_LINE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10930u32);
    pub const PRECEDES_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10931u32);
    pub const SUCCEEDS_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10932u32);
    pub const PRECEDES_ABOVE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10933u32);
    pub const SUCCEEDS_ABOVE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10934u32);
    pub const PRECEDES_ABOVE_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10935u32);
    pub const SUCCEEDS_ABOVE_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10936u32);
    pub const PRECEDES_ABOVE_NOT_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10937u32);
    pub const SUCCEEDS_ABOVE_NOT_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10938u32);
    pub const DOUBLE_PRECEDES : CodePoint = CodePoint::from(10939u32);
    pub const DOUBLE_SUCCEEDS : CodePoint = CodePoint::from(10940u32);
    pub const SUBSET_WITH_DOT : CodePoint = CodePoint::from(10941u32);
    pub const SUPERSET_WITH_DOT : CodePoint = CodePoint::from(10942u32);
    pub const SUBSET_WITH_PLUS_SIGN_BELOW : CodePoint = CodePoint::from(10943u32);
    pub const SUPERSET_WITH_PLUS_SIGN_BELOW : CodePoint = CodePoint::from(10944u32);
    pub const SUBSET_WITH_MULTIPLICATION_SIGN_BELOW : CodePoint = CodePoint::from(10945u32);
    pub const SUPERSET_WITH_MULTIPLICATION_SIGN_BELOW : CodePoint = CodePoint::from(10946u32);
    pub const SUBSET_OF_OR_EQUAL_TO_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10947u32);
    pub const SUPERSET_OF_OR_EQUAL_TO_WITH_DOT_ABOVE : CodePoint = CodePoint::from(10948u32);
    pub const SUBSET_OF_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10949u32);
    pub const SUPERSET_OF_ABOVE_EQUALS_SIGN : CodePoint = CodePoint::from(10950u32);
    pub const SUBSET_OF_ABOVE_TILDE_OPERATOR : CodePoint = CodePoint::from(10951u32);
    pub const SUPERSET_OF_ABOVE_TILDE_OPERATOR : CodePoint = CodePoint::from(10952u32);
    pub const SUBSET_OF_ABOVE_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10953u32);
    pub const SUPERSET_OF_ABOVE_ALMOST_EQUAL_TO : CodePoint = CodePoint::from(10954u32);
    pub const SUBSET_OF_ABOVE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10955u32);
    pub const SUPERSET_OF_ABOVE_NOT_EQUAL_TO : CodePoint = CodePoint::from(10956u32);
    pub const SQUARE_LEFT_OPEN_BOX_OPERATOR : CodePoint = CodePoint::from(10957u32);
    pub const SQUARE_RIGHT_OPEN_BOX_OPERATOR : CodePoint = CodePoint::from(10958u32);
    pub const CLOSED_SUBSET : CodePoint = CodePoint::from(10959u32);
    pub const CLOSED_SUPERSET : CodePoint = CodePoint::from(10960u32);
    pub const CLOSED_SUBSET_OR_EQUAL_TO : CodePoint = CodePoint::from(10961u32);
    pub const CLOSED_SUPERSET_OR_EQUAL_TO : CodePoint = CodePoint::from(10962u32);
    pub const SUBSET_ABOVE_SUPERSET : CodePoint = CodePoint::from(10963u32);
    pub const SUPERSET_ABOVE_SUBSET : CodePoint = CodePoint::from(10964u32);
    pub const SUBSET_ABOVE_SUBSET : CodePoint = CodePoint::from(10965u32);
    pub const SUPERSET_ABOVE_SUPERSET : CodePoint = CodePoint::from(10966u32);
    pub const SUPERSET_BESIDE_SUBSET : CodePoint = CodePoint::from(10967u32);
    pub const SUPERSET_BESIDE_AND_JOINED_BY_DASH_WITH_SUBSET : CodePoint = CodePoint::from(10968u32);
    pub const ELEMENT_OF_OPENING_DOWNWARDS : CodePoint = CodePoint::from(10969u32);
    pub const PITCHFORK_WITH_TEE_TOP : CodePoint = CodePoint::from(10970u32);
    pub const TRANSVERSAL_INTERSECTION : CodePoint = CodePoint::from(10971u32);
    pub const FORKING : CodePoint = CodePoint::from(10972u32);
    pub const NONFORKING : CodePoint = CodePoint::from(10973u32);
    pub const SHORT_LEFT_TACK : CodePoint = CodePoint::from(10974u32);
    pub const SHORT_DOWN_TACK : CodePoint = CodePoint::from(10975u32);
    pub const SHORT_UP_TACK : CodePoint = CodePoint::from(10976u32);
    pub const PERPENDICULAR_WITH_S : CodePoint = CodePoint::from(10977u32);
    pub const VERTICAL_BAR_TRIPLE_RIGHT_TURNSTILE : CodePoint = CodePoint::from(10978u32);
    pub const DOUBLE_VERTICAL_BAR_LEFT_TURNSTILE : CodePoint = CodePoint::from(10979u32);
    pub const VERTICAL_BAR_DOUBLE_LEFT_TURNSTILE : CodePoint = CodePoint::from(10980u32);
    pub const DOUBLE_VERTICAL_BAR_DOUBLE_LEFT_TURNSTILE : CodePoint = CodePoint::from(10981u32);
    pub const LONG_DASH_FROM_LEFT_MEMBER_OF_DOUBLE_VERTICAL : CodePoint = CodePoint::from(10982u32);
    pub const SHORT_DOWN_TACK_WITH_OVERBAR : CodePoint = CodePoint::from(10983u32);
    pub const SHORT_UP_TACK_WITH_UNDERBAR : CodePoint = CodePoint::from(10984u32);
    pub const SHORT_UP_TACK_ABOVE_SHORT_DOWN_TACK : CodePoint = CodePoint::from(10985u32);
    pub const DOUBLE_DOWN_TACK : CodePoint = CodePoint::from(10986u32);
    pub const DOUBLE_UP_TACK : CodePoint = CodePoint::from(10987u32);
    pub const DOUBLE_STROKE_NOT_SIGN : CodePoint = CodePoint::from(10988u32);
    pub const REVERSED_DOUBLE_STROKE_NOT_SIGN : CodePoint = CodePoint::from(10989u32);
    pub const DOES_NOT_DIVIDE_WITH_REVERSED_NEGATION_SLASH : CodePoint = CodePoint::from(10990u32);
    pub const VERTICAL_LINE_WITH_CIRCLE_ABOVE : CodePoint = CodePoint::from(10991u32);
    pub const VERTICAL_LINE_WITH_CIRCLE_BELOW : CodePoint = CodePoint::from(10992u32);
    pub const DOWN_TACK_WITH_CIRCLE_BELOW : CodePoint = CodePoint::from(10993u32);
    pub const PARALLEL_WITH_HORIZONTAL_STROKE : CodePoint = CodePoint::from(10994u32);
    pub const PARALLEL_WITH_TILDE_OPERATOR : CodePoint = CodePoint::from(10995u32);
    pub const TRIPLE_VERTICAL_BAR_BINARY_RELATION : CodePoint = CodePoint::from(10996u32);
    pub const TRIPLE_VERTICAL_BAR_WITH_HORIZONTAL_STROKE : CodePoint = CodePoint::from(10997u32);
    pub const TRIPLE_COLON_OPERATOR : CodePoint = CodePoint::from(10998u32);
    pub const TRIPLE_NESTED_LESS_THAN : CodePoint = CodePoint::from(10999u32);
    pub const TRIPLE_NESTED_GREATER_THAN : CodePoint = CodePoint::from(11000u32);
    pub const DOUBLE_LINE_SLANTED_LESS_THAN_OR_EQUAL_TO : CodePoint = CodePoint::from(11001u32);
    pub const DOUBLE_LINE_SLANTED_GREATER_THAN_OR_EQUAL_TO : CodePoint = CodePoint::from(11002u32);
    pub const TRIPLE_SOLIDUS_BINARY_RELATION : CodePoint = CodePoint::from(11003u32);
    pub const LARGE_TRIPLE_VERTICAL_BAR_OPERATOR : CodePoint = CodePoint::from(11004u32);
    pub const DOUBLE_SOLIDUS_OPERATOR : CodePoint = CodePoint::from(11005u32);
    pub const WHITE_VERTICAL_BAR : CodePoint = CodePoint::from(11006u32);
    pub const N_ARY_WHITE_VERTICAL_BAR : CodePoint = CodePoint::from(11007u32);
    pub const NORTH_EAST_WHITE_ARROW : CodePoint = CodePoint::from(11008u32);
    pub const NORTH_WEST_WHITE_ARROW : CodePoint = CodePoint::from(11009u32);
    pub const SOUTH_EAST_WHITE_ARROW : CodePoint = CodePoint::from(11010u32);
    pub const SOUTH_WEST_WHITE_ARROW : CodePoint = CodePoint::from(11011u32);
    pub const LEFT_RIGHT_WHITE_ARROW : CodePoint = CodePoint::from(11012u32);
    pub const LEFTWARDS_BLACK_ARROW : CodePoint = CodePoint::from(11013u32);
    pub const UPWARDS_BLACK_ARROW : CodePoint = CodePoint::from(11014u32);
    pub const DOWNWARDS_BLACK_ARROW : CodePoint = CodePoint::from(11015u32);
    pub const NORTH_EAST_BLACK_ARROW : CodePoint = CodePoint::from(11016u32);
    pub const NORTH_WEST_BLACK_ARROW : CodePoint = CodePoint::from(11017u32);
    pub const SOUTH_EAST_BLACK_ARROW : CodePoint = CodePoint::from(11018u32);
    pub const SOUTH_WEST_BLACK_ARROW : CodePoint = CodePoint::from(11019u32);
    pub const LEFT_RIGHT_BLACK_ARROW : CodePoint = CodePoint::from(11020u32);
    pub const UP_DOWN_BLACK_ARROW : CodePoint = CodePoint::from(11021u32);
    pub const RIGHTWARDS_ARROW_WITH_TIP_DOWNWARDS : CodePoint = CodePoint::from(11022u32);
    pub const RIGHTWARDS_ARROW_WITH_TIP_UPWARDS : CodePoint = CodePoint::from(11023u32);
    pub const LEFTWARDS_ARROW_WITH_TIP_DOWNWARDS : CodePoint = CodePoint::from(11024u32);
    pub const LEFTWARDS_ARROW_WITH_TIP_UPWARDS : CodePoint = CodePoint::from(11025u32);
    pub const SQUARE_WITH_TOP_HALF_BLACK : CodePoint = CodePoint::from(11026u32);
    pub const SQUARE_WITH_BOTTOM_HALF_BLACK : CodePoint = CodePoint::from(11027u32);
    pub const SQUARE_WITH_UPPER_RIGHT_DIAGONAL_HALF_BLACK : CodePoint = CodePoint::from(11028u32);
    pub const SQUARE_WITH_LOWER_LEFT_DIAGONAL_HALF_BLACK : CodePoint = CodePoint::from(11029u32);
    pub const DIAMOND_WITH_LEFT_HALF_BLACK : CodePoint = CodePoint::from(11030u32);
    pub const DIAMOND_WITH_RIGHT_HALF_BLACK : CodePoint = CodePoint::from(11031u32);
    pub const DIAMOND_WITH_TOP_HALF_BLACK : CodePoint = CodePoint::from(11032u32);
    pub const DIAMOND_WITH_BOTTOM_HALF_BLACK : CodePoint = CodePoint::from(11033u32);
    pub const DOTTED_SQUARE : CodePoint = CodePoint::from(11034u32);
    pub const BLACK_LARGE_SQUARE : CodePoint = CodePoint::from(11035u32);
    pub const WHITE_LARGE_SQUARE : CodePoint = CodePoint::from(11036u32);
    pub const BLACK_VERY_SMALL_SQUARE : CodePoint = CodePoint::from(11037u32);
    pub const WHITE_VERY_SMALL_SQUARE : CodePoint = CodePoint::from(11038u32);
    pub const BLACK_PENTAGON : CodePoint = CodePoint::from(11039u32);
    pub const WHITE_PENTAGON : CodePoint = CodePoint::from(11040u32);
    pub const WHITE_HEXAGON : CodePoint = CodePoint::from(11041u32);
    pub const BLACK_HEXAGON : CodePoint = CodePoint::from(11042u32);
    pub const HORIZONTAL_BLACK_HEXAGON : CodePoint = CodePoint::from(11043u32);
    pub const BLACK_LARGE_CIRCLE : CodePoint = CodePoint::from(11044u32);
    pub const BLACK_MEDIUM_DIAMOND : CodePoint = CodePoint::from(11045u32);
    pub const WHITE_MEDIUM_DIAMOND : CodePoint = CodePoint::from(11046u32);
    pub const BLACK_MEDIUM_LOZENGE : CodePoint = CodePoint::from(11047u32);
    pub const WHITE_MEDIUM_LOZENGE : CodePoint = CodePoint::from(11048u32);
    pub const BLACK_SMALL_DIAMOND : CodePoint = CodePoint::from(11049u32);
    pub const BLACK_SMALL_LOZENGE : CodePoint = CodePoint::from(11050u32);
    pub const WHITE_SMALL_LOZENGE : CodePoint = CodePoint::from(11051u32);
    pub const BLACK_HORIZONTAL_ELLIPSE : CodePoint = CodePoint::from(11052u32);
    pub const WHITE_HORIZONTAL_ELLIPSE : CodePoint = CodePoint::from(11053u32);
    pub const BLACK_VERTICAL_ELLIPSE : CodePoint = CodePoint::from(11054u32);
    pub const WHITE_VERTICAL_ELLIPSE : CodePoint = CodePoint::from(11055u32);
    pub const LEFT_ARROW_WITH_SMALL_CIRCLE : CodePoint = CodePoint::from(11056u32);
    pub const THREE_LEFTWARDS_ARROWS : CodePoint = CodePoint::from(11057u32);
    pub const LEFT_ARROW_WITH_CIRCLED_PLUS : CodePoint = CodePoint::from(11058u32);
    pub const LONG_LEFTWARDS_SQUIGGLE_ARROW : CodePoint = CodePoint::from(11059u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(11060u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(11061u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW_FROM_BAR : CodePoint = CodePoint::from(11062u32);
    pub const LEFTWARDS_TWO_HEADED_TRIPLE_DASH_ARROW : CodePoint = CodePoint::from(11063u32);
    pub const LEFTWARDS_ARROW_WITH_DOTTED_STEM : CodePoint = CodePoint::from(11064u32);
    pub const LEFTWARDS_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(11065u32);
    pub const LEFTWARDS_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(11066u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL : CodePoint = CodePoint::from(11067u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE : CodePoint = CodePoint::from(11068u32);
    pub const LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE : CodePoint = CodePoint::from(11069u32);
    pub const LEFTWARDS_ARROW_THROUGH_X : CodePoint = CodePoint::from(11070u32);
    pub const WAVE_ARROW_POINTING_DIRECTLY_LEFT : CodePoint = CodePoint::from(11071u32);
    pub const EQUALS_SIGN_ABOVE_LEFTWARDS_ARROW : CodePoint = CodePoint::from(11072u32);
    pub const REVERSE_TILDE_OPERATOR_ABOVE_LEFTWARDS_ARROW : CodePoint = CodePoint::from(11073u32);
}
