/* $Id: error.c,v 1.6 2002/03/02 19:37:36 sverrehu Exp $ */
/*------------------------------------------------------------------------
 |  FILE            error.c
 |  MODULE OF       shhmsg - library for displaying messages.
 |
 |  DESCRIPTION     Function for displaying a simple error message.
 |
 |  WRITTEN BY      Sverre H. Huseby <shh@thathost.com>
 +----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdarg.h>

#include "internal.h"
#include "shhmsg.h"

/*-----------------------------------------------------------------------+
|  PUBLIC FUNCTIONS                                                      |
+-----------------------------------------------------------------------*/

/*------------------------------------------------------------------------
 |
 |  NAME          msgError
 |
 |  FUNCTION      Show given message on the _msgErrorStream.
 |
 |  SYNOPSIS      #include "shhmsg.h"
 |                void msgError(const char *format, ...);
 |
 |  INPUT         format, ...
 |                        Arguments used as with printf().
 |
 |  DESCRIPTION   Prints the name of this program followed by ": " and the
 |                given message on the _msgErrorStream.
 */
void
msgError(const char *format, ...)
{
    va_list ap;

    fflush(stdout);
    fprintf(GET_ERROR_STREAM, "%s: ", msgGetName());
    va_start(ap, format);
    vfprintf(GET_ERROR_STREAM, format, ap);
    va_end(ap);
}
