//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_BDSQR_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_BDSQR_HPP

#include <boost/assert.hpp>
#include <boost/numeric/bindings/begin.hpp>
#include <boost/numeric/bindings/detail/array.hpp>
#include <boost/numeric/bindings/is_column_major.hpp>
#include <boost/numeric/bindings/is_complex.hpp>
#include <boost/numeric/bindings/is_mutable.hpp>
#include <boost/numeric/bindings/is_real.hpp>
#include <boost/numeric/bindings/lapack/workspace.hpp>
#include <boost/numeric/bindings/remove_imaginary.hpp>
#include <boost/numeric/bindings/size.hpp>
#include <boost/numeric/bindings/stride.hpp>
#include <boost/numeric/bindings/uplo_tag.hpp>
#include <boost/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>
#include <boost/utility/enable_if.hpp>

//
// The LAPACK-backend for bdsqr is the netlib-compatible backend.
//
#include <boost/numeric/bindings/lapack/detail/lapack.h>
#include <boost/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost {
namespace numeric {
namespace bindings {
namespace lapack {

//
// The detail namespace contains value-type-overloaded functions that
// dispatch to the appropriate back-end LAPACK-routine.
//
namespace detail {

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * float value-type.
//
inline std::ptrdiff_t bdsqr( const char uplo, const fortran_int_t n,
        const fortran_int_t ncvt, const fortran_int_t nru,
        const fortran_int_t ncc, float* d, float* e, float* vt,
        const fortran_int_t ldvt, float* u, const fortran_int_t ldu, float* c,
        const fortran_int_t ldc, float* work ) {
    fortran_int_t info(0);
    LAPACK_SBDSQR( &uplo, &n, &ncvt, &nru, &ncc, d, e, vt, &ldvt, u, &ldu, c,
            &ldc, work, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * double value-type.
//
inline std::ptrdiff_t bdsqr( const char uplo, const fortran_int_t n,
        const fortran_int_t ncvt, const fortran_int_t nru,
        const fortran_int_t ncc, double* d, double* e, double* vt,
        const fortran_int_t ldvt, double* u, const fortran_int_t ldu,
        double* c, const fortran_int_t ldc, double* work ) {
    fortran_int_t info(0);
    LAPACK_DBDSQR( &uplo, &n, &ncvt, &nru, &ncc, d, e, vt, &ldvt, u, &ldu, c,
            &ldc, work, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<float> value-type.
//
inline std::ptrdiff_t bdsqr( const char uplo, const fortran_int_t n,
        const fortran_int_t ncvt, const fortran_int_t nru,
        const fortran_int_t ncc, float* d, float* e, std::complex<float>* vt,
        const fortran_int_t ldvt, std::complex<float>* u,
        const fortran_int_t ldu, std::complex<float>* c,
        const fortran_int_t ldc, float* rwork ) {
    fortran_int_t info(0);
    LAPACK_CBDSQR( &uplo, &n, &ncvt, &nru, &ncc, d, e, vt, &ldvt, u, &ldu, c,
            &ldc, rwork, &info );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<double> value-type.
//
inline std::ptrdiff_t bdsqr( const char uplo, const fortran_int_t n,
        const fortran_int_t ncvt, const fortran_int_t nru,
        const fortran_int_t ncc, double* d, double* e,
        std::complex<double>* vt, const fortran_int_t ldvt,
        std::complex<double>* u, const fortran_int_t ldu,
        std::complex<double>* c, const fortran_int_t ldc, double* rwork ) {
    fortran_int_t info(0);
    LAPACK_ZBDSQR( &uplo, &n, &ncvt, &nru, &ncc, d, e, vt, &ldvt, u, &ldu, c,
            &ldc, rwork, &info );
    return info;
}

} // namespace detail

//
// Value-type based template class. Use this class if you need a type
// for dispatching to bdsqr.
//
template< typename Value, typename Enable = void >
struct bdsqr_impl {};

//
// This implementation is enabled if Value is a real type.
//
template< typename Value >
struct bdsqr_impl< Value, typename boost::enable_if< is_real< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename VectorD, typename VectorE, typename MatrixVT,
            typename MatrixU, typename MatrixC, typename WORK >
    static std::ptrdiff_t invoke( const char uplo, const fortran_int_t n,
            VectorD& d, VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c,
            detail::workspace1< WORK > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixVT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixU >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixC >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< VectorD >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorE >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< VectorD >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixVT >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< VectorD >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixU >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< VectorD >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixC >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorD >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorE >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixVT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixU >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixC >::value) );
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_work( n, bindings::size_column(vt),
                bindings::size_row(u), bindings::size_column(c) ));
        BOOST_ASSERT( bindings::size_column(c) >= 0 );
        BOOST_ASSERT( bindings::size_column(vt) >= 0 );
        BOOST_ASSERT( bindings::size_minor(c) == 1 ||
                bindings::stride_minor(c) == 1 );
        BOOST_ASSERT( bindings::size_minor(u) == 1 ||
                bindings::stride_minor(u) == 1 );
        BOOST_ASSERT( bindings::size_minor(vt) == 1 ||
                bindings::stride_minor(vt) == 1 );
        BOOST_ASSERT( bindings::size_row(u) >= 0 );
        BOOST_ASSERT( bindings::stride_major(u) >= std::max< std::ptrdiff_t >(1,
                bindings::size_row(u)) );
        BOOST_ASSERT( n >= 0 );
        return detail::bdsqr( uplo, n, bindings::size_column(vt),
                bindings::size_row(u), bindings::size_column(c),
                bindings::begin_value(d), bindings::begin_value(e),
                bindings::begin_value(vt), bindings::stride_major(vt),
                bindings::begin_value(u), bindings::stride_major(u),
                bindings::begin_value(c), bindings::stride_major(c),
                bindings::begin_value(work.select(real_type())) );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename VectorD, typename VectorE, typename MatrixVT,
            typename MatrixU, typename MatrixC >
    static std::ptrdiff_t invoke( const char uplo, const fortran_int_t n,
            VectorD& d, VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c,
            minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< real_type > tmp_work( min_size_work( n,
                bindings::size_column(vt), bindings::size_row(u),
                bindings::size_column(c) ) );
        return invoke( uplo, n, d, e, vt, u, c, workspace( tmp_work ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename VectorD, typename VectorE, typename MatrixVT,
            typename MatrixU, typename MatrixC >
    static std::ptrdiff_t invoke( const char uplo, const fortran_int_t n,
            VectorD& d, VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c,
            optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        return invoke( uplo, n, d, e, vt, u, c, minimal_workspace() );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array work.
    //
    static std::ptrdiff_t min_size_work( const std::ptrdiff_t n,
            const std::ptrdiff_t ncvt, const std::ptrdiff_t nru,
            const std::ptrdiff_t ncc ) {
        if ( ncvt == 0 && nru == 0 && ncc == 0 )
            return 2*n;
        else
            return std::max< std::ptrdiff_t >(1, 4*n);
    }
};

//
// This implementation is enabled if Value is a complex type.
//
template< typename Value >
struct bdsqr_impl< Value, typename boost::enable_if< is_complex< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename VectorD, typename VectorE, typename MatrixVT,
            typename MatrixU, typename MatrixC, typename RWORK >
    static std::ptrdiff_t invoke( const char uplo, const fortran_int_t n,
            VectorD& d, VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c,
            detail::workspace1< RWORK > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixVT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixU >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_column_major< MatrixC >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< VectorD >::type >::type,
                typename remove_const< typename bindings::value_type<
                VectorE >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixVT >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixU >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (boost::is_same< typename remove_const<
                typename bindings::value_type< MatrixVT >::type >::type,
                typename remove_const< typename bindings::value_type<
                MatrixC >::type >::type >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorD >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorE >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixVT >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixU >::value) );
        BOOST_STATIC_ASSERT( (bindings::is_mutable< MatrixC >::value) );
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_rwork( n, bindings::size_column(vt),
                bindings::size_row(u), bindings::size_column(c) ));
        BOOST_ASSERT( bindings::size_column(c) >= 0 );
        BOOST_ASSERT( bindings::size_column(vt) >= 0 );
        BOOST_ASSERT( bindings::size_minor(c) == 1 ||
                bindings::stride_minor(c) == 1 );
        BOOST_ASSERT( bindings::size_minor(u) == 1 ||
                bindings::stride_minor(u) == 1 );
        BOOST_ASSERT( bindings::size_minor(vt) == 1 ||
                bindings::stride_minor(vt) == 1 );
        BOOST_ASSERT( bindings::size_row(u) >= 0 );
        BOOST_ASSERT( bindings::stride_major(u) >= std::max< std::ptrdiff_t >(1,
                bindings::size_row(u)) );
        BOOST_ASSERT( n >= 0 );
        return detail::bdsqr( uplo, n, bindings::size_column(vt),
                bindings::size_row(u), bindings::size_column(c),
                bindings::begin_value(d), bindings::begin_value(e),
                bindings::begin_value(vt), bindings::stride_major(vt),
                bindings::begin_value(u), bindings::stride_major(u),
                bindings::begin_value(c), bindings::stride_major(c),
                bindings::begin_value(work.select(real_type())) );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename VectorD, typename VectorE, typename MatrixVT,
            typename MatrixU, typename MatrixC >
    static std::ptrdiff_t invoke( const char uplo, const fortran_int_t n,
            VectorD& d, VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c,
            minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< real_type > tmp_rwork( min_size_rwork( n,
                bindings::size_column(vt), bindings::size_row(u),
                bindings::size_column(c) ) );
        return invoke( uplo, n, d, e, vt, u, c, workspace( tmp_rwork ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename VectorD, typename VectorE, typename MatrixVT,
            typename MatrixU, typename MatrixC >
    static std::ptrdiff_t invoke( const char uplo, const fortran_int_t n,
            VectorD& d, VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c,
            optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        return invoke( uplo, n, d, e, vt, u, c, minimal_workspace() );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array rwork.
    //
    static std::ptrdiff_t min_size_rwork( const std::ptrdiff_t n,
            const std::ptrdiff_t ncvt, const std::ptrdiff_t nru,
            const std::ptrdiff_t ncc ) {
        if ( ncvt == 0 && nru == 0 && ncc == 0 )
            return 2*n;
        else
            return std::max< std::ptrdiff_t >(1, 4*n-4);
    }
};


//
// Functions for direct use. These functions are overloaded for temporaries,
// so that wrapped types can still be passed and used for write-access. In
// addition, if applicable, they are overloaded for user-defined workspaces.
// Calls to these functions are passed to the bdsqr_impl classes. In the 
// documentation, most overloads are collapsed to avoid a large number of
// prototypes which are very similar.
//

//
// Overloaded function for bdsqr. Its overload differs for
// * User-defined workspace
//
template< typename VectorD, typename VectorE, typename MatrixVT,
        typename MatrixU, typename MatrixC, typename Workspace >
inline typename boost::enable_if< detail::is_workspace< Workspace >,
        std::ptrdiff_t >::type
bdsqr( const char uplo, const fortran_int_t n, VectorD& d,
        VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c, Workspace work ) {
    return bdsqr_impl< typename bindings::value_type<
            MatrixVT >::type >::invoke( uplo, n, d, e, vt, u, c, work );
}

//
// Overloaded function for bdsqr. Its overload differs for
// * Default workspace-type (optimal)
//
template< typename VectorD, typename VectorE, typename MatrixVT,
        typename MatrixU, typename MatrixC >
inline typename boost::disable_if< detail::is_workspace< MatrixC >,
        std::ptrdiff_t >::type
bdsqr( const char uplo, const fortran_int_t n, VectorD& d,
        VectorE& e, MatrixVT& vt, MatrixU& u, MatrixC& c ) {
    return bdsqr_impl< typename bindings::value_type<
            MatrixVT >::type >::invoke( uplo, n, d, e, vt, u, c,
            optimal_workspace() );
}

} // namespace lapack
} // namespace bindings
} // namespace numeric
} // namespace boost

#endif
