// -*- Mode: Go; indent-tabs-mode: t -*-

/*
 * Copyright (C) 2016 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package spdx

// From https://spdx.org/licenses/
// data files: https://github.com/spdx/license-list-data
// Version: 3.11 2020-11-25
//
// jq < json/licenses.json '.licenses | .[] | select(.isOsiApproved == true) | .licenseId' | sort | sed -e 's/$/,/'
var osi = []string{
	"0BSD",
	"AAL",
	"AFL-1.1",
	"AFL-1.2",
	"AFL-2.0",
	"AFL-2.1",
	"AFL-3.0",
	"AGPL-3.0",
	"AGPL-3.0-only",
	"AGPL-3.0-or-later",
	"Apache-1.1",
	"Apache-2.0",
	"APL-1.0",
	"APSL-1.0",
	"APSL-1.1",
	"APSL-1.2",
	"APSL-2.0",
	"Artistic-1.0",
	"Artistic-1.0-cl8",
	"Artistic-1.0-Perl",
	"Artistic-2.0",
	"BSD-1-Clause",
	"BSD-2-Clause",
	"BSD-2-Clause-Patent",
	"BSD-3-Clause",
	"BSD-3-Clause-LBNL",
	"BSL-1.0",
	"CAL-1.0",
	"CAL-1.0-Combined-Work-Exception",
	"CATOSL-1.1",
	"CDDL-1.0",
	"CECILL-2.1",
	"CNRI-Python",
	"CPAL-1.0",
	"CPL-1.0",
	"CUA-OPL-1.0",
	"ECL-1.0",
	"ECL-2.0",
	"EFL-1.0",
	"EFL-2.0",
	"Entessa",
	"EPL-1.0",
	"EPL-2.0",
	"EUDatagrid",
	"EUPL-1.1",
	"EUPL-1.2",
	"Fair",
	"Frameworx-1.0",
	"GPL-2.0",
	"GPL-2.0+",
	"GPL-2.0-only",
	"GPL-2.0-or-later",
	"GPL-3.0",
	"GPL-3.0+",
	"GPL-3.0-only",
	"GPL-3.0-or-later",
	"GPL-3.0-with-GCC-exception",
	"HPND",
	"Intel",
	"IPA",
	"IPL-1.0",
	"ISC",
	"LGPL-2.0",
	"LGPL-2.0+",
	"LGPL-2.0-only",
	"LGPL-2.0-or-later",
	"LGPL-2.1",
	"LGPL-2.1+",
	"LGPL-2.1-only",
	"LGPL-2.1-or-later",
	"LGPL-3.0",
	"LGPL-3.0+",
	"LGPL-3.0-only",
	"LGPL-3.0-or-later",
	"LiLiQ-P-1.1",
	"LiLiQ-R-1.1",
	"LiLiQ-Rplus-1.1",
	"LPL-1.0",
	"LPL-1.02",
	"LPPL-1.3c",
	"MirOS",
	"MIT",
	"MIT-0",
	"Motosoto",
	"MPL-1.0",
	"MPL-1.1",
	"MPL-2.0",
	"MPL-2.0-no-copyleft-exception",
	"MS-PL",
	"MS-RL",
	"MulanPSL-2.0",
	"Multics",
	"NASA-1.3",
	"Naumen",
	"NCSA",
	"NGPL",
	"Nokia",
	"NPOSL-3.0",
	"NTP",
	"OCLC-2.0",
	"OFL-1.1",
	"OFL-1.1-no-RFN",
	"OFL-1.1-RFN",
	"OGTSL",
	"OLDAP-2.8",
	"OSET-PL-2.1",
	"OSL-1.0",
	"OSL-2.0",
	"OSL-2.1",
	"OSL-3.0",
	"PHP-3.0",
	"PHP-3.01",
	"PostgreSQL",
	"Python-2.0",
	"QPL-1.0",
	"RPL-1.1",
	"RPL-1.5",
	"RPSL-1.0",
	"RSCPL",
	"SimPL-2.0",
	"SISSL",
	"Sleepycat",
	"SPL-1.0",
	"UCL-1.0",
	"Unicode-DFS-2016",
	"Unlicense",
	"UPL-1.0",
	"VSL-1.0",
	"W3C",
	"Watcom-1.0",
	"Xnet",
	"Zlib",
	"ZPL-2.0",
}

// using SPDX license data:
// jq < json/licenses.json '.licenses | .[] | .licenseId' | sort | sed -e 's/$/,/'
var allLicenses = []string{
	"0BSD",
	"AAL",
	"Abstyles",
	"Adobe-2006",
	"Adobe-Glyph",
	"ADSL",
	"AFL-1.1",
	"AFL-1.2",
	"AFL-2.0",
	"AFL-2.1",
	"AFL-3.0",
	"Afmparse",
	"AGPL-1.0",
	"AGPL-1.0-only",
	"AGPL-1.0-or-later",
	"AGPL-3.0",
	"AGPL-3.0-only",
	"AGPL-3.0-or-later",
	"Aladdin",
	"AMDPLPA",
	"AML",
	"AMPAS",
	"ANTLR-PD",
	"ANTLR-PD-fallback",
	"Apache-1.0",
	"Apache-1.1",
	"Apache-2.0",
	"APAFML",
	"APL-1.0",
	"APSL-1.0",
	"APSL-1.1",
	"APSL-1.2",
	"APSL-2.0",
	"Artistic-1.0",
	"Artistic-1.0-cl8",
	"Artistic-1.0-Perl",
	"Artistic-2.0",
	"Bahyph",
	"Barr",
	"Beerware",
	"BitTorrent-1.0",
	"BitTorrent-1.1",
	"blessing",
	"BlueOak-1.0.0",
	"Borceux",
	"BSD-1-Clause",
	"BSD-2-Clause",
	"BSD-2-Clause-FreeBSD",
	"BSD-2-Clause-NetBSD",
	"BSD-2-Clause-Patent",
	"BSD-2-Clause-Views",
	"BSD-3-Clause",
	"BSD-3-Clause-Attribution",
	"BSD-3-Clause-Clear",
	"BSD-3-Clause-LBNL",
	"BSD-3-Clause-No-Nuclear-License",
	"BSD-3-Clause-No-Nuclear-License-2014",
	"BSD-3-Clause-No-Nuclear-Warranty",
	"BSD-3-Clause-Open-MPI",
	"BSD-4-Clause",
	"BSD-4-Clause-UC",
	"BSD-Protection",
	"BSD-Source-Code",
	"BSL-1.0",
	"BUSL-1.1",
	"bzip2-1.0.5",
	"bzip2-1.0.6",
	"CAL-1.0",
	"CAL-1.0-Combined-Work-Exception",
	"Caldera",
	"CATOSL-1.1",
	"CC0-1.0",
	"CC-BY-1.0",
	"CC-BY-2.0",
	"CC-BY-2.5",
	"CC-BY-3.0",
	"CC-BY-3.0-AT",
	"CC-BY-3.0-US",
	"CC-BY-4.0",
	"CC-BY-NC-1.0",
	"CC-BY-NC-2.0",
	"CC-BY-NC-2.5",
	"CC-BY-NC-3.0",
	"CC-BY-NC-4.0",
	"CC-BY-NC-ND-1.0",
	"CC-BY-NC-ND-2.0",
	"CC-BY-NC-ND-2.5",
	"CC-BY-NC-ND-3.0",
	"CC-BY-NC-ND-3.0-IGO",
	"CC-BY-NC-ND-4.0",
	"CC-BY-NC-SA-1.0",
	"CC-BY-NC-SA-2.0",
	"CC-BY-NC-SA-2.5",
	"CC-BY-NC-SA-3.0",
	"CC-BY-NC-SA-4.0",
	"CC-BY-ND-1.0",
	"CC-BY-ND-2.0",
	"CC-BY-ND-2.5",
	"CC-BY-ND-3.0",
	"CC-BY-ND-4.0",
	"CC-BY-SA-1.0",
	"CC-BY-SA-2.0",
	"CC-BY-SA-2.0-UK",
	"CC-BY-SA-2.5",
	"CC-BY-SA-3.0",
	"CC-BY-SA-3.0-AT",
	"CC-BY-SA-4.0",
	"CC-PDDC",
	"CDDL-1.0",
	"CDDL-1.1",
	"CDLA-Permissive-1.0",
	"CDLA-Sharing-1.0",
	"CECILL-1.0",
	"CECILL-1.1",
	"CECILL-2.0",
	"CECILL-2.1",
	"CECILL-B",
	"CECILL-C",
	"CERN-OHL-1.1",
	"CERN-OHL-1.2",
	"CERN-OHL-P-2.0",
	"CERN-OHL-S-2.0",
	"CERN-OHL-W-2.0",
	"ClArtistic",
	"CNRI-Jython",
	"CNRI-Python",
	"CNRI-Python-GPL-Compatible",
	"Condor-1.1",
	"copyleft-next-0.3.0",
	"copyleft-next-0.3.1",
	"CPAL-1.0",
	"CPL-1.0",
	"CPOL-1.02",
	"Crossword",
	"CrystalStacker",
	"CUA-OPL-1.0",
	"Cube",
	"curl",
	"D-FSL-1.0",
	"diffmark",
	"DOC",
	"Dotseqn",
	"DSDP",
	"dvipdfm",
	"ECL-1.0",
	"ECL-2.0",
	"eCos-2.0",
	"EFL-1.0",
	"EFL-2.0",
	"eGenix",
	"Entessa",
	"EPICS",
	"EPL-1.0",
	"EPL-2.0",
	"ErlPL-1.1",
	"etalab-2.0",
	"EUDatagrid",
	"EUPL-1.0",
	"EUPL-1.1",
	"EUPL-1.2",
	"Eurosym",
	"Fair",
	"Frameworx-1.0",
	"FreeImage",
	"FSFAP",
	"FSFUL",
	"FSFULLR",
	"FTL",
	"GFDL-1.1",
	"GFDL-1.1-invariants-only",
	"GFDL-1.1-invariants-or-later",
	"GFDL-1.1-no-invariants-only",
	"GFDL-1.1-no-invariants-or-later",
	"GFDL-1.1-only",
	"GFDL-1.1-or-later",
	"GFDL-1.2",
	"GFDL-1.2-invariants-only",
	"GFDL-1.2-invariants-or-later",
	"GFDL-1.2-no-invariants-only",
	"GFDL-1.2-no-invariants-or-later",
	"GFDL-1.2-only",
	"GFDL-1.2-or-later",
	"GFDL-1.3",
	"GFDL-1.3-invariants-only",
	"GFDL-1.3-invariants-or-later",
	"GFDL-1.3-no-invariants-only",
	"GFDL-1.3-no-invariants-or-later",
	"GFDL-1.3-only",
	"GFDL-1.3-or-later",
	"Giftware",
	"GL2PS",
	"Glide",
	"Glulxe",
	"GLWTPL",
	"gnuplot",
	"GPL-1.0",
	"GPL-1.0+",
	"GPL-1.0-only",
	"GPL-1.0-or-later",
	"GPL-2.0",
	"GPL-2.0+",
	"GPL-2.0-only",
	"GPL-2.0-or-later",
	"GPL-2.0-with-autoconf-exception",
	"GPL-2.0-with-bison-exception",
	"GPL-2.0-with-classpath-exception",
	"GPL-2.0-with-font-exception",
	"GPL-2.0-with-GCC-exception",
	"GPL-3.0",
	"GPL-3.0+",
	"GPL-3.0-only",
	"GPL-3.0-or-later",
	"GPL-3.0-with-autoconf-exception",
	"GPL-3.0-with-GCC-exception",
	"gSOAP-1.3b",
	"HaskellReport",
	"Hippocratic-2.1",
	"HPND",
	"HPND-sell-variant",
	"HTMLTIDY",
	"IBM-pibs",
	"ICU",
	"IJG",
	"ImageMagick",
	"iMatix",
	"Imlib2",
	"Info-ZIP",
	"Intel",
	"Intel-ACPI",
	"Interbase-1.0",
	"IPA",
	"IPL-1.0",
	"ISC",
	"JasPer-2.0",
	"JPNIC",
	"JSON",
	"LAL-1.2",
	"LAL-1.3",
	"Latex2e",
	"Leptonica",
	"LGPL-2.0",
	"LGPL-2.0+",
	"LGPL-2.0-only",
	"LGPL-2.0-or-later",
	"LGPL-2.1",
	"LGPL-2.1+",
	"LGPL-2.1-only",
	"LGPL-2.1-or-later",
	"LGPL-3.0",
	"LGPL-3.0+",
	"LGPL-3.0-only",
	"LGPL-3.0-or-later",
	"LGPLLR",
	"Libpng",
	"libpng-2.0",
	"libselinux-1.0",
	"libtiff",
	"LiLiQ-P-1.1",
	"LiLiQ-R-1.1",
	"LiLiQ-Rplus-1.1",
	"Linux-OpenIB",
	"LPL-1.0",
	"LPL-1.02",
	"LPPL-1.0",
	"LPPL-1.1",
	"LPPL-1.2",
	"LPPL-1.3a",
	"LPPL-1.3c",
	"MakeIndex",
	"MirOS",
	"MIT",
	"MIT-0",
	"MIT-advertising",
	"MIT-CMU",
	"MIT-enna",
	"MIT-feh",
	"MITNFA",
	"MIT-open-group",
	"Motosoto",
	"mpich2",
	"MPL-1.0",
	"MPL-1.1",
	"MPL-2.0",
	"MPL-2.0-no-copyleft-exception",
	"MS-PL",
	"MS-RL",
	"MTLL",
	"MulanPSL-1.0",
	"MulanPSL-2.0",
	"Multics",
	"Mup",
	"NASA-1.3",
	"Naumen",
	"NBPL-1.0",
	"NCGL-UK-2.0",
	"NCSA",
	"NetCDF",
	"Net-SNMP",
	"Newsletr",
	"NGPL",
	"NIST-PD",
	"NIST-PD-fallback",
	"NLOD-1.0",
	"NLPL",
	"Nokia",
	"NOSL",
	"Noweb",
	"NPL-1.0",
	"NPL-1.1",
	"NPOSL-3.0",
	"NRL",
	"NTP",
	"NTP-0",
	"Nunit",
	"OCCT-PL",
	"OCLC-2.0",
	"ODbL-1.0",
	"ODC-By-1.0",
	"OFL-1.0",
	"OFL-1.0-no-RFN",
	"OFL-1.0-RFN",
	"OFL-1.1",
	"OFL-1.1-no-RFN",
	"OFL-1.1-RFN",
	"OGC-1.0",
	"OGL-Canada-2.0",
	"OGL-UK-1.0",
	"OGL-UK-2.0",
	"OGL-UK-3.0",
	"OGTSL",
	"OLDAP-1.1",
	"OLDAP-1.2",
	"OLDAP-1.3",
	"OLDAP-1.4",
	"OLDAP-2.0",
	"OLDAP-2.0.1",
	"OLDAP-2.1",
	"OLDAP-2.2",
	"OLDAP-2.2.1",
	"OLDAP-2.2.2",
	"OLDAP-2.3",
	"OLDAP-2.4",
	"OLDAP-2.5",
	"OLDAP-2.6",
	"OLDAP-2.7",
	"OLDAP-2.8",
	"OML",
	"OpenSSL",
	"OPL-1.0",
	"OSET-PL-2.1",
	"OSL-1.0",
	"OSL-1.1",
	"OSL-2.0",
	"OSL-2.1",
	"OSL-3.0",
	"O-UDA-1.0",
	"Parity-6.0.0",
	"Parity-7.0.0",
	"PDDL-1.0",
	"PHP-3.0",
	"PHP-3.01",
	"Plexus",
	"PolyForm-Noncommercial-1.0.0",
	"PolyForm-Small-Business-1.0.0",
	"PostgreSQL",
	"PSF-2.0",
	"psfrag",
	"psutils",
	"Python-2.0",
	"Qhull",
	"QPL-1.0",
	"Rdisc",
	"RHeCos-1.1",
	"RPL-1.1",
	"RPL-1.5",
	"RPSL-1.0",
	"RSA-MD",
	"RSCPL",
	"Ruby",
	"Saxpath",
	"SAX-PD",
	"SCEA",
	"Sendmail",
	"Sendmail-8.23",
	"SGI-B-1.0",
	"SGI-B-1.1",
	"SGI-B-2.0",
	"SHL-0.5",
	"SHL-0.51",
	"SimPL-2.0",
	"SISSL",
	"SISSL-1.2",
	"Sleepycat",
	"SMLNJ",
	"SMPPL",
	"SNIA",
	"Spencer-86",
	"Spencer-94",
	"Spencer-99",
	"SPL-1.0",
	"SSH-OpenSSH",
	"SSH-short",
	"SSPL-1.0",
	"StandardML-NJ",
	"SugarCRM-1.1.3",
	"SWL",
	"TAPR-OHL-1.0",
	"TCL",
	"TCP-wrappers",
	"TMate",
	"TORQUE-1.1",
	"TOSL",
	"TU-Berlin-1.0",
	"TU-Berlin-2.0",
	"UCL-1.0",
	"Unicode-DFS-2015",
	"Unicode-DFS-2016",
	"Unicode-TOU",
	"Unlicense",
	"UPL-1.0",
	"Vim",
	"VOSTROM",
	"VSL-1.0",
	"W3C",
	"W3C-19980720",
	"W3C-20150513",
	"Watcom-1.0",
	"Wsuipa",
	"WTFPL",
	"wxWindows",
	"X11",
	"Xerox",
	"XFree86-1.1",
	"xinetd",
	"Xnet",
	"xpp",
	"XSkat",
	"YPL-1.0",
	"YPL-1.1",
	"Zed",
	"Zend-2.0",
	"Zimbra-1.3",
	"Zimbra-1.4",
	"Zlib",
	"zlib-acknowledgement",
	"ZPL-1.1",
	"ZPL-2.0",
	"ZPL-2.1",

	// FIXME: non SPDX licenses that the snapstore uses
	"Proprietary",
}

// from https://www.google.com/url?q=https://docs.google.com/a/s.sfusd.edu/document/d/1wE_zvLU4c291ACi9wIJmQoE4ltKRW4rzM1TYiIvEVOs/edit?pli%3D1%23heading%3Dh.ruv3yl8g6czd&sa=D&ust=1473291615601000&usg=AFQjCNFyLcPLdEarX1TOesGWxg9Afb57mA
var licenseExceptions = []string{
	"Autoconf-exception-2.0",
	"Autoconf-exception-3.0",
	"Bison-exception-2.2",
	"Classpath-exception-2.0",
	"eCos-exception-2.0",
	"Font-exception-2.0",
	"GCC-exception-2.0",
	"GCC-exception-3.1",
	"WxWindows-exception-3.1",
}
