CREATE CLUSTERED COLUMNSTORE INDEX cci ON dbo.Orders
WITH (MAXDOP = 2);

CREATE CLUSTERED COLUMNSTORE INDEX cci_comp ON dbo.Compression
WITH ( COMPRESSION_DELAY = 10 MINUTES );

CREATE CLUSTERED COLUMNSTORE INDEX cci_data ON dbo.DataColumns
WITH ( DATA_COMPRESSION = COLUMNSTORE_ARCHIVE );

CREATE CLUSTERED COLUMNSTORE INDEX cci_online ON dbo.OnlineTable
WITH ( ONLINE = ON );


CREATE NONCLUSTERED COLUMNSTORE INDEX ncci ON dbo.Orders (StockItemID, Quantity, UnitPrice, TaxRate)
WITH ( ONLINE = ON );


CREATE COLUMNSTORE INDEX ncci2 ON dbo.Orders2 (StockItemID, Quantity, UnitPrice, TaxRate)
WITH ( ONLINE = ON );

CREATE NONCLUSTERED COLUMNSTORE INDEX FIBillOfMaterialsWithEndDate
    ON dbo.Materials (ComponentID, StartDate)
    WHERE EndDate IS NOT NULL;
