use core:debug;
use core:lang;
use core:asm;
use lang:bs;

class VarRef extends AsmOperand {
	LocalVar? var;

	init(SrcPos pos, lang:bs:Block block, Str name) {
		init();

		Named? v = block.scope.find(SimpleName(name));
		if (v as LocalVar) {
			var = v;
		} else {
			throw SyntaxError(pos, "Unknown variable: " # name # ". Note: Only local variables are supported.");
		}
	}

	Operand v(Labels l) {
		if (var) {
			Operand(var.var.v);
		} else {
			Operand();
		}
	}
}
