
/**
 * Visitor interface to traverse a document.
 *
 * The element is replaced by whatever is returned by each function. This allows modifying the
 * structure as well.
 *
 * Children are traversed before parents. This means that each transform function will "see" changes
 * made to children.
 */
class Visitor {
	// Called for all elements.
	Element visit(Element element) { element; }

	// Called for all `ElementSeq` objects. Usually it is enough to consider only `Element`s.
	ElementSeq visit(ElementSeq seq) { seq; }

	// Called for all `TextSpan` objects in the hierarcy.
	TextSpan visit(TextSpan span) { span; }

	// Called for all `FormattedText` objects in the hierarcy. Usually it is enough to consider only `TextSpan`s.
	FormattedText visit(FormattedText text) { text; }
}
