use test;

value ToSFull {
	Int v;

	init(Int v) {
		init { v = v; }
	}

	void toS(StrBuf to) {
		to << "strbuf:" << v;
	}

	Str toS() {
		"str:" # v;
	}
}

value ToSLimited {
	Int v;

	init(Int v) {
		init { v = v; }
	}

	Str toS() {
		"str:" # v;
	}
}

test ToSImpl {
	ToSFull full(1);
	ToSLimited limited(2);

	check full.toS() == "str:1";
	check (StrBuf() << full).toS == "strbuf:1";
	check ("!" # full) == "!strbuf:1";
	check "!${full}" == "!strbuf:1";
	check ToSFull:[full].toS == "[strbuf:1]";

	check limited.toS() == "str:2";
	check (StrBuf() << limited).toS == "str:2";
	check ("!" # limited) == "!str:2";
	check "!${limited}" == "!str:2";
	check ToSLimited:[limited].toS == "[str:2]";
}
