use test;
use parser;
use core:io;

binaryParser : parser(recursive descent, binary) {
	start = Start;

	Array<Buffer> Start();
	Start => Array<Buffer>() : "[^\n]*" -> push - ("\n" - "[^\n]*" -> push)*;
}

test BinaryParser {
	Buffer b = "ab\ncd\ne".toUtf8();

	var result = binaryParser(b);
	check result.value;
	if (v = result.value) {
		check v.count == 3.nat;
	} else {
		print("Error at ${result.end}, ${result.error}");
	}

	result = binaryParser(b, 2);
	check result.value;
	if (v = result.value) {
		check v.count == 3.nat;
		check v[0].filled == 0.nat;
	} else {
		print("Error at ${result.end}, ${result.error}");
	}
}

pseudoParser : parser(recursive descent, binary) {
	use parser.special;
	start = Start;

	Buffer Start();
	Start => x : Number n - Bytes(n) x;

	Nat Number();
	Number => toNat(x) : "[0-9]" x;
}

pseudoStr : parser(recursive descent) {
	use parser.special;
	start = Start;

	Str Start();
	Start => x : Number n - Chars(n) x;

	Nat Number();
	Number => toNat(x) : "[0-9]" x;
}

Nat toNat(Buffer b) {
	b.fromUtf8.toNat;
}

test PseudoRules {
	Buffer b = "3abcde".toUtf8();
	var r = pseudoParser(b);
	check r.value;
	check r.end == 4;
	if (x = r.value) {
		check x.count == 3;
		check x.fromUtf8 == "abc";
	}

	var z = pseudoStr("3abcde");
	check z.value;
	if (x = z.value) {
		check x == "abc";
	}
}

value BinData {
	init(Nat a, Int b) {
		init { a = a; b = b; }
	}

	Nat a;
	Int b;
}

binNumParser : parser(recursive descent, binary) {
	use parser.special;
	start = Start;

	BinData Start();
	Start => BinData(a, b) : Nat16LE a - Int16BE b;
}

test BinNumRules {
	Buffer b = buffer(4);
	b.push(0x01);
	b.push(0x80);
	b.push(0xFF);
	b.push(0xFF);

	var r = binNumParser(b);
	check r.value;
	if (x = r.value) {
		check x.a == 0x8001_n;
		check x.b == -1;
	}
}
