#pragma once
#include "ControlFlow.h"

namespace storm {
	STORM_PKG(core.lang);

	// Compute the differences between two ControlFlowItem trees.
	Array<ControlFlowItem> *STORM_FN diff(Array<ControlFlowItem> *oldFlow, Array<ControlFlowItem> *newFlow);

	// Helper to pretty-print a diff between two flow items. Assumes the shapes of the two are the same.
	Str *STORM_FN formatDiff(Array<ControlFlowItem> *oldFlow, Array<ControlFlowItem> *newFlow);

}
