#pragma once
#include "Options.h"
#include "Image.h"

namespace graphics {

	/**
	 * BMP options.
	 */
	class BMPOptions : public FormatOptions {
		STORM_CLASS;
	public:
		// Create, default options.
		STORM_CTOR BMPOptions();

		// Encoding mode.
		// Note: The current implementation does not support palette4. Palette8 is just a static palette.
		enum Mode {
			// Unknown. Some format that we can not encode.
			unknown,
			// Black and white, 1bpp
			mono1,
			// Palette, 4bpp
			palette4,
			// Palette, 8bpp
			palette8,
			// Color, 16bpp, 5:5:5:1
			color16alpha,
			// Color, 16bpp, 5:6:5
			color16,
			// Color, 24bpp
			color24,
			// Color, 24bpp + 8bpp alpha
			color24alpha,
		};

		// Encoding mode.
		Mode mode;

		// Create, custom options.
		STORM_CTOR BMPOptions(Mode mode);

		// Load an image, set options.
		virtual Image *STORM_FN load(IStream *from);
		using FormatOptions::load;

		// Save an image according to options.
		virtual void STORM_FN save(Image *image, OStream *to);
		using FormatOptions::save;

		// Output.
		virtual void STORM_FN toS(StrBuf *to) const;
	};


	// Create an ImageFormat. For internal use.
	ImageFormat *bmpFormat(Engine &e);

}
