use lang;
use core:lang;

/**
 * Stores a set of values that correspond to the global variables in a program.
 *
 * This is so that we can properly restore them when the program is restarted.
 *
 * Note: This approach will not work for actors, since they are inherently by-reference objects and
 * their contents may thus still be mutated.
 */
class SavedGlobals on Compiler {
	private Str->Variant data;

	init() {
		init {}
	}

	private init(GlobalVar[] globals) {
		init {}

		CloneEnv env;
		for (x in globals) {
			var ptr = unsafe:RawPtr:fromGlobal(x);
			Variant v = ptr.asVariant(); // Shallow copy of ptr
			v.deepCopy(env);
			data.put(x.name, v);
		}
	}

	SavedGlobals save(GlobalVar[] globals) : static {
		SavedGlobals(globals);
	}

	void restore(GlobalVar[] globals) {
		CloneEnv env;
		for (x in globals) {
			unless (v = data.at(x.name)) // Note: copies the variant.
				continue;
			v.deepCopy(env);

			var ptr = unsafe:RawPtr:fromGlobal(x);
			ptr.copyVariant(v);
		}
	}
}
