#include "wrap/thread.h"
#include "wrap/sync.h"

struct parameters_to_start {
	const char *start;
};

struct semaphore sema;

void process_start(struct parameters_to_start *test) {
	for (const char *at = test->start; *at; at++) {
		putchar(*at);
	}
	putchar('\n');

	sema_up(&sema);
}

void start_process(const char *name) {
	struct parameters_to_start params;
	params.start = name;
	sema_init(&sema, 0);

	tid_t tid = thread_new(process_start, &params);

	sema_down(&sema);
}

int main() {
	start_process("test");
	return 0;
}
